// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__11027 = s;
var map__11027__$1 = cljs.core.__destructure_map(map__11027);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11027__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11027__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__11029 = info;
var map__11030 = G__11029;
var map__11030__$1 = cljs.core.__destructure_map(map__11030);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11030__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__11029__$1 = G__11029;
while(true){
var d__$2 = d__$1;
var map__11032 = G__11029__$1;
var map__11032__$1 = cljs.core.__destructure_map(map__11032);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11032__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__11033 = (d__$2 + (1));
var G__11034 = shadow__$1;
d__$1 = G__11033;
G__11029__$1 = G__11034;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__11035){
var map__11036 = p__11035;
var map__11036__$1 = cljs.core.__destructure_map(map__11036);
var name_var = map__11036__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11036__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11036__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__11037 = info;
var map__11037__$1 = cljs.core.__destructure_map(map__11037);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11037__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11037__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__11038 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__11038) : cljs.compiler.munge.call(null,G__11038));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__11040 = arguments.length;
switch (G__11040) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__11041 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11639,11639,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__11041.cljs$core$IFn$_invoke$arity$1 ? fexpr__11041.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__11041.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__11043 = cp;
switch (G__11043) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__11045_11049 = cljs.core.seq(s);
var chunk__11046_11050 = null;
var count__11047_11051 = (0);
var i__11048_11052 = (0);
while(true){
if((i__11048_11052 < count__11047_11051)){
var c_11053 = chunk__11046_11050.cljs$core$IIndexed$_nth$arity$2(null,i__11048_11052);
sb.append(cljs.compiler.escape_char(c_11053));


var G__11054 = seq__11045_11049;
var G__11055 = chunk__11046_11050;
var G__11056 = count__11047_11051;
var G__11057 = (i__11048_11052 + (1));
seq__11045_11049 = G__11054;
chunk__11046_11050 = G__11055;
count__11047_11051 = G__11056;
i__11048_11052 = G__11057;
continue;
} else {
var temp__5753__auto___11058 = cljs.core.seq(seq__11045_11049);
if(temp__5753__auto___11058){
var seq__11045_11059__$1 = temp__5753__auto___11058;
if(cljs.core.chunked_seq_QMARK_(seq__11045_11059__$1)){
var c__4638__auto___11060 = cljs.core.chunk_first(seq__11045_11059__$1);
var G__11061 = cljs.core.chunk_rest(seq__11045_11059__$1);
var G__11062 = c__4638__auto___11060;
var G__11063 = cljs.core.count(c__4638__auto___11060);
var G__11064 = (0);
seq__11045_11049 = G__11061;
chunk__11046_11050 = G__11062;
count__11047_11051 = G__11063;
i__11048_11052 = G__11064;
continue;
} else {
var c_11065 = cljs.core.first(seq__11045_11059__$1);
sb.append(cljs.compiler.escape_char(c_11065));


var G__11066 = cljs.core.next(seq__11045_11059__$1);
var G__11067 = null;
var G__11068 = (0);
var G__11069 = (0);
seq__11045_11049 = G__11066;
chunk__11046_11050 = G__11067;
count__11047_11051 = G__11068;
i__11048_11052 = G__11069;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__11070 = cljs.core.get_global_hierarchy;
return (fexpr__11070.cljs$core$IFn$_invoke$arity$0 ? fexpr__11070.cljs$core$IFn$_invoke$arity$0() : fexpr__11070.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__11071_11076 = ast;
var map__11071_11077__$1 = cljs.core.__destructure_map(map__11071_11076);
var env_11078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11071_11077__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_11078))){
var map__11072_11079 = env_11078;
var map__11072_11080__$1 = cljs.core.__destructure_map(map__11072_11079);
var line_11081 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11072_11080__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_11082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11072_11080__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__11073 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__11075 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__11074 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__11074.cljs$core$IFn$_invoke$arity$1 ? fexpr__11074.cljs$core$IFn$_invoke$arity$1(G__11075) : fexpr__11074.call(null,G__11075));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__11073,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__11073;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_11081 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_11082)?(column_11082 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__11091 = arguments.length;
switch (G__11091) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___11098 = arguments.length;
var i__4819__auto___11099 = (0);
while(true){
if((i__4819__auto___11099 < len__4818__auto___11098)){
args_arr__4839__auto__.push((arguments[i__4819__auto___11099]));

var G__11100 = (i__4819__auto___11099 + (1));
i__4819__auto___11099 = G__11100;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_11101 = (function (){var G__11092 = a;
if((!(typeof a === 'string'))){
return G__11092.toString();
} else {
return G__11092;
}
})();
var temp__5757__auto___11102 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___11102 == null)){
} else {
var sm_data_11103 = temp__5757__auto___11102;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_11103,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__11083_SHARP_){
return (p1__11083_SHARP_ + s_11101.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_11101], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11093 = cljs.core.seq(xs);
var chunk__11094 = null;
var count__11095 = (0);
var i__11096 = (0);
while(true){
if((i__11096 < count__11095)){
var x = chunk__11094.cljs$core$IIndexed$_nth$arity$2(null,i__11096);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11104 = seq__11093;
var G__11105 = chunk__11094;
var G__11106 = count__11095;
var G__11107 = (i__11096 + (1));
seq__11093 = G__11104;
chunk__11094 = G__11105;
count__11095 = G__11106;
i__11096 = G__11107;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11093);
if(temp__5753__auto__){
var seq__11093__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11093__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__11093__$1);
var G__11108 = cljs.core.chunk_rest(seq__11093__$1);
var G__11109 = c__4638__auto__;
var G__11110 = cljs.core.count(c__4638__auto__);
var G__11111 = (0);
seq__11093 = G__11108;
chunk__11094 = G__11109;
count__11095 = G__11110;
i__11096 = G__11111;
continue;
} else {
var x = cljs.core.first(seq__11093__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11112 = cljs.core.next(seq__11093__$1);
var G__11113 = null;
var G__11114 = (0);
var G__11115 = (0);
seq__11093 = G__11112;
chunk__11094 = G__11113;
count__11095 = G__11114;
i__11096 = G__11115;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq11085){
var G__11086 = cljs.core.first(seq11085);
var seq11085__$1 = cljs.core.next(seq11085);
var G__11087 = cljs.core.first(seq11085__$1);
var seq11085__$2 = cljs.core.next(seq11085__$1);
var G__11088 = cljs.core.first(seq11085__$2);
var seq11085__$3 = cljs.core.next(seq11085__$2);
var G__11089 = cljs.core.first(seq11085__$3);
var seq11085__$4 = cljs.core.next(seq11085__$3);
var G__11090 = cljs.core.first(seq11085__$4);
var seq11085__$5 = cljs.core.next(seq11085__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11086,G__11087,G__11088,G__11089,G__11090,seq11085__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__11116){
var map__11117 = p__11116;
var map__11117__$1 = cljs.core.__destructure_map(map__11117);
var m = map__11117__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11117__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__11125 = arguments.length;
switch (G__11125) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___11131 = arguments.length;
var i__4819__auto___11132 = (0);
while(true){
if((i__4819__auto___11132 < len__4818__auto___11131)){
args_arr__4839__auto__.push((arguments[i__4819__auto___11132]));

var G__11133 = (i__4819__auto___11132 + (1));
i__4819__auto___11132 = G__11133;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11126_11134 = cljs.core.seq(xs);
var chunk__11127_11135 = null;
var count__11128_11136 = (0);
var i__11129_11137 = (0);
while(true){
if((i__11129_11137 < count__11128_11136)){
var x_11138 = chunk__11127_11135.cljs$core$IIndexed$_nth$arity$2(null,i__11129_11137);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11138);


var G__11139 = seq__11126_11134;
var G__11140 = chunk__11127_11135;
var G__11141 = count__11128_11136;
var G__11142 = (i__11129_11137 + (1));
seq__11126_11134 = G__11139;
chunk__11127_11135 = G__11140;
count__11128_11136 = G__11141;
i__11129_11137 = G__11142;
continue;
} else {
var temp__5753__auto___11143 = cljs.core.seq(seq__11126_11134);
if(temp__5753__auto___11143){
var seq__11126_11144__$1 = temp__5753__auto___11143;
if(cljs.core.chunked_seq_QMARK_(seq__11126_11144__$1)){
var c__4638__auto___11145 = cljs.core.chunk_first(seq__11126_11144__$1);
var G__11146 = cljs.core.chunk_rest(seq__11126_11144__$1);
var G__11147 = c__4638__auto___11145;
var G__11148 = cljs.core.count(c__4638__auto___11145);
var G__11149 = (0);
seq__11126_11134 = G__11146;
chunk__11127_11135 = G__11147;
count__11128_11136 = G__11148;
i__11129_11137 = G__11149;
continue;
} else {
var x_11150 = cljs.core.first(seq__11126_11144__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11150);


var G__11151 = cljs.core.next(seq__11126_11144__$1);
var G__11152 = null;
var G__11153 = (0);
var G__11154 = (0);
seq__11126_11134 = G__11151;
chunk__11127_11135 = G__11152;
count__11128_11136 = G__11153;
i__11129_11137 = G__11154;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq11119){
var G__11120 = cljs.core.first(seq11119);
var seq11119__$1 = cljs.core.next(seq11119);
var G__11121 = cljs.core.first(seq11119__$1);
var seq11119__$2 = cljs.core.next(seq11119__$1);
var G__11122 = cljs.core.first(seq11119__$2);
var seq11119__$3 = cljs.core.next(seq11119__$2);
var G__11123 = cljs.core.first(seq11119__$3);
var seq11119__$4 = cljs.core.next(seq11119__$3);
var G__11124 = cljs.core.first(seq11119__$4);
var seq11119__$5 = cljs.core.next(seq11119__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11120,G__11121,G__11122,G__11123,G__11124,seq11119__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__11155_11159 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__11156_11160 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__11157_11161 = true;
var _STAR_print_fn_STAR__temp_val__11158_11162 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__11157_11161);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__11158_11162);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__11156_11160);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__11155_11159);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__11163 = cljs.core.get_global_hierarchy;
return (fexpr__11163.cljs$core$IFn$_invoke$arity$0 ? fexpr__11163.cljs$core$IFn$_invoke$arity$0() : fexpr__11163.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__11164 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11164,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11164,(1),null);
var G__11167 = ns;
var G__11168 = name;
var G__11169 = (function (){
var G__11170 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__11170) : cljs.compiler.emit_constant.call(null,G__11170));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__11167,G__11168,G__11169) : cljs.compiler.emit_record_value.call(null,G__11167,G__11168,G__11169));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__11171 = cljs.core.keys(x);
var G__11172 = cljs.core.vals(x);
var G__11173 = cljs.compiler.emit_constants_comma_sep;
var G__11174 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__11171,G__11172,G__11173,G__11174) : cljs.compiler.emit_map.call(null,G__11171,G__11172,G__11173,G__11174));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__11175 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__11176 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__11175,G__11176) : cljs.compiler.emit_with_meta.call(null,G__11175,G__11176));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__11177 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11177,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11177,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11177,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__11180 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11180) : x.call(null,G__11180));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__11181 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11181) : x.call(null,G__11181));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__11183 = items;
var G__11184 = (function (p1__11182_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__11182_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__11183,G__11184) : cljs.compiler.emit_js_object.call(null,G__11183,G__11184));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__11186){
var map__11187 = p__11186;
var map__11187__$1 = cljs.core.__destructure_map(map__11187);
var ast = map__11187__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__11188 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11188__$1 = cljs.core.__destructure_map(map__11188);
var cenv = map__11188__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11188__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4212__auto__ = js_module_name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11189 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4210__auto__ = (function (){var G__11190 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__11190) : cljs.compiler.es5_GT__EQ_.call(null,G__11190));
})();
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4210__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__11189,cljs.analyzer.es5_allowed);
} else {
return G__11189;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4212__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__11191 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__11191,reserved);
} else {
return G__11191;
}
})();
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__11192_11193 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__11192_11194__$1 = (((G__11192_11193 instanceof cljs.core.Keyword))?G__11192_11193.fqn:null);
switch (G__11192_11194__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4210__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__11196){
var map__11197 = p__11196;
var map__11197__$1 = cljs.core.__destructure_map(map__11197);
var arg = map__11197__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11197__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11197__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11197__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11197__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11198 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__11198__$1 = cljs.core.__destructure_map(map__11198);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11198__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__11199){
var map__11200 = p__11199;
var map__11200__$1 = cljs.core.__destructure_map(map__11200);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11200__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11200__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11200__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__11201_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__11201_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__11202 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11202) : comma_sep.call(null,G__11202));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__11203 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11203) : comma_sep.call(null,G__11203));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__11204){
var map__11205 = p__11204;
var map__11205__$1 = cljs.core.__destructure_map(map__11205);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11205__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11205__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11205__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__11206){
var map__11207 = p__11206;
var map__11207__$1 = cljs.core.__destructure_map(map__11207);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11207__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11207__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__11208_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__11208_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__11209 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11209) : comma_sep.call(null,G__11209));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__11210){
var map__11211 = p__11210;
var map__11211__$1 = cljs.core.__destructure_map(map__11211);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11211__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11211__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___11234 = cljs.core.seq(items);
if(temp__5753__auto___11234){
var items_11235__$1 = temp__5753__auto___11234;
var vec__11212_11236 = items_11235__$1;
var seq__11213_11237 = cljs.core.seq(vec__11212_11236);
var first__11214_11238 = cljs.core.first(seq__11213_11237);
var seq__11213_11239__$1 = cljs.core.next(seq__11213_11237);
var vec__11215_11240 = first__11214_11238;
var k_11241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11215_11240,(0),null);
var v_11242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11215_11240,(1),null);
var r_11243 = seq__11213_11239__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_11241),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11242) : emit_js_object_val.call(null,v_11242)));

var seq__11218_11244 = cljs.core.seq(r_11243);
var chunk__11219_11245 = null;
var count__11220_11246 = (0);
var i__11221_11247 = (0);
while(true){
if((i__11221_11247 < count__11220_11246)){
var vec__11228_11248 = chunk__11219_11245.cljs$core$IIndexed$_nth$arity$2(null,i__11221_11247);
var k_11249__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11228_11248,(0),null);
var v_11250__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11228_11248,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11249__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11250__$1) : emit_js_object_val.call(null,v_11250__$1)));


var G__11251 = seq__11218_11244;
var G__11252 = chunk__11219_11245;
var G__11253 = count__11220_11246;
var G__11254 = (i__11221_11247 + (1));
seq__11218_11244 = G__11251;
chunk__11219_11245 = G__11252;
count__11220_11246 = G__11253;
i__11221_11247 = G__11254;
continue;
} else {
var temp__5753__auto___11255__$1 = cljs.core.seq(seq__11218_11244);
if(temp__5753__auto___11255__$1){
var seq__11218_11256__$1 = temp__5753__auto___11255__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11218_11256__$1)){
var c__4638__auto___11257 = cljs.core.chunk_first(seq__11218_11256__$1);
var G__11258 = cljs.core.chunk_rest(seq__11218_11256__$1);
var G__11259 = c__4638__auto___11257;
var G__11260 = cljs.core.count(c__4638__auto___11257);
var G__11261 = (0);
seq__11218_11244 = G__11258;
chunk__11219_11245 = G__11259;
count__11220_11246 = G__11260;
i__11221_11247 = G__11261;
continue;
} else {
var vec__11231_11262 = cljs.core.first(seq__11218_11256__$1);
var k_11263__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11231_11262,(0),null);
var v_11264__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11231_11262,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11263__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11264__$1) : emit_js_object_val.call(null,v_11264__$1)));


var G__11265 = cljs.core.next(seq__11218_11256__$1);
var G__11266 = null;
var G__11267 = (0);
var G__11268 = (0);
seq__11218_11244 = G__11265;
chunk__11219_11245 = G__11266;
count__11220_11246 = G__11267;
i__11221_11247 = G__11268;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__11269){
var map__11270 = p__11269;
var map__11270__$1 = cljs.core.__destructure_map(map__11270);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11270__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11270__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11270__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__11271){
var map__11272 = p__11271;
var map__11272__$1 = cljs.core.__destructure_map(map__11272);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11272__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11272__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__11273){
var map__11274 = p__11273;
var map__11274__$1 = cljs.core.__destructure_map(map__11274);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11274__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__11275){
var map__11276 = p__11275;
var map__11276__$1 = cljs.core.__destructure_map(map__11276);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11276__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11276__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__11277 = cljs.analyzer.unwrap_quote(expr);
var map__11277__$1 = cljs.core.__destructure_map(map__11277);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11277__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11277__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11277__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4210__auto__){
var and__4210__auto____$1 = form;
if(cljs.core.truth_(and__4210__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__11278 = cljs.analyzer.unwrap_quote(expr);
var map__11278__$1 = cljs.core.__destructure_map(map__11278);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11278__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11278__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11278__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4212__auto__ = (function (){var fexpr__11279 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__11279.cljs$core$IFn$_invoke$arity$1 ? fexpr__11279.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11279.call(null,tag));
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__11280){
var map__11281 = p__11280;
var map__11281__$1 = cljs.core.__destructure_map(map__11281);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11281__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11281__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11281__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11281__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11281__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4212__auto__ = unchecked;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__11282){
var map__11283 = p__11282;
var map__11283__$1 = cljs.core.__destructure_map(map__11283);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11283__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11283__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11283__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11283__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__11284_11312 = cljs.core.seq(nodes);
var chunk__11285_11313 = null;
var count__11286_11314 = (0);
var i__11287_11315 = (0);
while(true){
if((i__11287_11315 < count__11286_11314)){
var map__11300_11316 = chunk__11285_11313.cljs$core$IIndexed$_nth$arity$2(null,i__11287_11315);
var map__11300_11317__$1 = cljs.core.__destructure_map(map__11300_11316);
var ts_11318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11300_11317__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__11301_11319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11300_11317__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__11301_11320__$1 = cljs.core.__destructure_map(map__11301_11319);
var then_11321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11301_11320__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__11302_11322 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_11318));
var chunk__11303_11323 = null;
var count__11304_11324 = (0);
var i__11305_11325 = (0);
while(true){
if((i__11305_11325 < count__11304_11324)){
var test_11326 = chunk__11303_11323.cljs$core$IIndexed$_nth$arity$2(null,i__11305_11325);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11326,":");


var G__11327 = seq__11302_11322;
var G__11328 = chunk__11303_11323;
var G__11329 = count__11304_11324;
var G__11330 = (i__11305_11325 + (1));
seq__11302_11322 = G__11327;
chunk__11303_11323 = G__11328;
count__11304_11324 = G__11329;
i__11305_11325 = G__11330;
continue;
} else {
var temp__5753__auto___11331 = cljs.core.seq(seq__11302_11322);
if(temp__5753__auto___11331){
var seq__11302_11332__$1 = temp__5753__auto___11331;
if(cljs.core.chunked_seq_QMARK_(seq__11302_11332__$1)){
var c__4638__auto___11333 = cljs.core.chunk_first(seq__11302_11332__$1);
var G__11334 = cljs.core.chunk_rest(seq__11302_11332__$1);
var G__11335 = c__4638__auto___11333;
var G__11336 = cljs.core.count(c__4638__auto___11333);
var G__11337 = (0);
seq__11302_11322 = G__11334;
chunk__11303_11323 = G__11335;
count__11304_11324 = G__11336;
i__11305_11325 = G__11337;
continue;
} else {
var test_11338 = cljs.core.first(seq__11302_11332__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11338,":");


var G__11339 = cljs.core.next(seq__11302_11332__$1);
var G__11340 = null;
var G__11341 = (0);
var G__11342 = (0);
seq__11302_11322 = G__11339;
chunk__11303_11323 = G__11340;
count__11304_11324 = G__11341;
i__11305_11325 = G__11342;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11321);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11321);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11343 = seq__11284_11312;
var G__11344 = chunk__11285_11313;
var G__11345 = count__11286_11314;
var G__11346 = (i__11287_11315 + (1));
seq__11284_11312 = G__11343;
chunk__11285_11313 = G__11344;
count__11286_11314 = G__11345;
i__11287_11315 = G__11346;
continue;
} else {
var temp__5753__auto___11347 = cljs.core.seq(seq__11284_11312);
if(temp__5753__auto___11347){
var seq__11284_11348__$1 = temp__5753__auto___11347;
if(cljs.core.chunked_seq_QMARK_(seq__11284_11348__$1)){
var c__4638__auto___11349 = cljs.core.chunk_first(seq__11284_11348__$1);
var G__11350 = cljs.core.chunk_rest(seq__11284_11348__$1);
var G__11351 = c__4638__auto___11349;
var G__11352 = cljs.core.count(c__4638__auto___11349);
var G__11353 = (0);
seq__11284_11312 = G__11350;
chunk__11285_11313 = G__11351;
count__11286_11314 = G__11352;
i__11287_11315 = G__11353;
continue;
} else {
var map__11306_11354 = cljs.core.first(seq__11284_11348__$1);
var map__11306_11355__$1 = cljs.core.__destructure_map(map__11306_11354);
var ts_11356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11306_11355__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__11307_11357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11306_11355__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__11307_11358__$1 = cljs.core.__destructure_map(map__11307_11357);
var then_11359 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11307_11358__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__11308_11360 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_11356));
var chunk__11309_11361 = null;
var count__11310_11362 = (0);
var i__11311_11363 = (0);
while(true){
if((i__11311_11363 < count__11310_11362)){
var test_11364 = chunk__11309_11361.cljs$core$IIndexed$_nth$arity$2(null,i__11311_11363);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11364,":");


var G__11365 = seq__11308_11360;
var G__11366 = chunk__11309_11361;
var G__11367 = count__11310_11362;
var G__11368 = (i__11311_11363 + (1));
seq__11308_11360 = G__11365;
chunk__11309_11361 = G__11366;
count__11310_11362 = G__11367;
i__11311_11363 = G__11368;
continue;
} else {
var temp__5753__auto___11369__$1 = cljs.core.seq(seq__11308_11360);
if(temp__5753__auto___11369__$1){
var seq__11308_11370__$1 = temp__5753__auto___11369__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11308_11370__$1)){
var c__4638__auto___11371 = cljs.core.chunk_first(seq__11308_11370__$1);
var G__11372 = cljs.core.chunk_rest(seq__11308_11370__$1);
var G__11373 = c__4638__auto___11371;
var G__11374 = cljs.core.count(c__4638__auto___11371);
var G__11375 = (0);
seq__11308_11360 = G__11372;
chunk__11309_11361 = G__11373;
count__11310_11362 = G__11374;
i__11311_11363 = G__11375;
continue;
} else {
var test_11376 = cljs.core.first(seq__11308_11370__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11376,":");


var G__11377 = cljs.core.next(seq__11308_11370__$1);
var G__11378 = null;
var G__11379 = (0);
var G__11380 = (0);
seq__11308_11360 = G__11377;
chunk__11309_11361 = G__11378;
count__11310_11362 = G__11379;
i__11311_11363 = G__11380;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11359);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11359);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11381 = cljs.core.next(seq__11284_11348__$1);
var G__11382 = null;
var G__11383 = (0);
var G__11384 = (0);
seq__11284_11312 = G__11381;
chunk__11285_11313 = G__11382;
count__11286_11314 = G__11383;
i__11287_11315 = G__11384;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__11385){
var map__11386 = p__11385;
var map__11386__$1 = cljs.core.__destructure_map(map__11386);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11386__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11386__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11390 = env;
var G__11391 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11390,G__11391) : cljs.compiler.resolve_type.call(null,G__11390,G__11391));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__11392 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11392,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11392,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__11387_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__11387_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__11387_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__11395 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__11395,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__11395;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11398 = env;
var G__11399 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11398,G__11399) : cljs.compiler.resolve_type.call(null,G__11398,G__11399));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11400_SHARP_){
return cljs.compiler.resolve_type(env,p1__11400_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__11401 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11402 = cljs.core.seq(vec__11401);
var first__11403 = cljs.core.first(seq__11402);
var seq__11402__$1 = cljs.core.next(seq__11402);
var p = first__11403;
var first__11403__$1 = cljs.core.first(seq__11402__$1);
var seq__11402__$2 = cljs.core.next(seq__11402__$1);
var ts = first__11403__$1;
var first__11403__$2 = cljs.core.first(seq__11402__$2);
var seq__11402__$3 = cljs.core.next(seq__11402__$2);
var n = first__11403__$2;
var xs = seq__11402__$3;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__11404 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11405 = cljs.core.seq(vec__11404);
var first__11406 = cljs.core.first(seq__11405);
var seq__11405__$1 = cljs.core.next(seq__11405);
var p = first__11406;
var first__11406__$1 = cljs.core.first(seq__11405__$1);
var seq__11405__$2 = cljs.core.next(seq__11405__$1);
var ts = first__11406__$1;
var xs = seq__11405__$2;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__11408 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__11407 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__11407.cljs$core$IFn$_invoke$arity$1 ? fexpr__11407.cljs$core$IFn$_invoke$arity$1(G__11408) : fexpr__11407.call(null,G__11408));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__11411 = arguments.length;
switch (G__11411) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__11419 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11409_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__11409_SHARP_);
} else {
return p1__11409_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__11420 = cljs.core.seq(vec__11419);
var first__11421 = cljs.core.first(seq__11420);
var seq__11420__$1 = cljs.core.next(seq__11420);
var x = first__11421;
var ys = seq__11420__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__11422 = cljs.core.seq(ys);
var chunk__11423 = null;
var count__11424 = (0);
var i__11425 = (0);
while(true){
if((i__11425 < count__11424)){
var next_line = chunk__11423.cljs$core$IIndexed$_nth$arity$2(null,i__11425);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11431 = seq__11422;
var G__11432 = chunk__11423;
var G__11433 = count__11424;
var G__11434 = (i__11425 + (1));
seq__11422 = G__11431;
chunk__11423 = G__11432;
count__11424 = G__11433;
i__11425 = G__11434;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11422);
if(temp__5753__auto__){
var seq__11422__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11422__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__11422__$1);
var G__11435 = cljs.core.chunk_rest(seq__11422__$1);
var G__11436 = c__4638__auto__;
var G__11437 = cljs.core.count(c__4638__auto__);
var G__11438 = (0);
seq__11422 = G__11435;
chunk__11423 = G__11436;
count__11424 = G__11437;
i__11425 = G__11438;
continue;
} else {
var next_line = cljs.core.first(seq__11422__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11439 = cljs.core.next(seq__11422__$1);
var G__11440 = null;
var G__11441 = (0);
var G__11442 = (0);
seq__11422 = G__11439;
chunk__11423 = G__11440;
count__11424 = G__11441;
i__11425 = G__11442;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__11426_11443 = cljs.core.seq(docs__$2);
var chunk__11427_11444 = null;
var count__11428_11445 = (0);
var i__11429_11446 = (0);
while(true){
if((i__11429_11446 < count__11428_11445)){
var e_11447 = chunk__11427_11444.cljs$core$IIndexed$_nth$arity$2(null,i__11429_11446);
if(cljs.core.truth_(e_11447)){
print_comment_lines(e_11447);
} else {
}


var G__11448 = seq__11426_11443;
var G__11449 = chunk__11427_11444;
var G__11450 = count__11428_11445;
var G__11451 = (i__11429_11446 + (1));
seq__11426_11443 = G__11448;
chunk__11427_11444 = G__11449;
count__11428_11445 = G__11450;
i__11429_11446 = G__11451;
continue;
} else {
var temp__5753__auto___11452 = cljs.core.seq(seq__11426_11443);
if(temp__5753__auto___11452){
var seq__11426_11453__$1 = temp__5753__auto___11452;
if(cljs.core.chunked_seq_QMARK_(seq__11426_11453__$1)){
var c__4638__auto___11454 = cljs.core.chunk_first(seq__11426_11453__$1);
var G__11455 = cljs.core.chunk_rest(seq__11426_11453__$1);
var G__11456 = c__4638__auto___11454;
var G__11457 = cljs.core.count(c__4638__auto___11454);
var G__11458 = (0);
seq__11426_11443 = G__11455;
chunk__11427_11444 = G__11456;
count__11428_11445 = G__11457;
i__11429_11446 = G__11458;
continue;
} else {
var e_11459 = cljs.core.first(seq__11426_11453__$1);
if(cljs.core.truth_(e_11459)){
print_comment_lines(e_11459);
} else {
}


var G__11460 = cljs.core.next(seq__11426_11453__$1);
var G__11461 = null;
var G__11462 = (0);
var G__11463 = (0);
seq__11426_11443 = G__11460;
chunk__11427_11444 = G__11461;
count__11428_11445 = G__11462;
i__11429_11446 = G__11463;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4210__auto__ = cljs.core.some((function (p1__11465_SHARP_){
return goog.string.startsWith(p1__11465_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = opts;
if(cljs.core.truth_(and__4210__auto____$1)){
var and__4210__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4210__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4210__auto____$2;
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__11466){
var map__11467 = p__11466;
var map__11467__$1 = cljs.core.__destructure_map(map__11467);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11467__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4212__auto__ = init;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return test;
} else {
return and__4210__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__11468){
var map__11469 = p__11468;
var map__11469__$1 = cljs.core.__destructure_map(map__11469);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11469__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11469__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11469__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__11470_11494 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__11471_11495 = null;
var count__11472_11496 = (0);
var i__11473_11497 = (0);
while(true){
if((i__11473_11497 < count__11472_11496)){
var vec__11480_11498 = chunk__11471_11495.cljs$core$IIndexed$_nth$arity$2(null,i__11473_11497);
var i_11499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11480_11498,(0),null);
var param_11500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11480_11498,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11500);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11501 = seq__11470_11494;
var G__11502 = chunk__11471_11495;
var G__11503 = count__11472_11496;
var G__11504 = (i__11473_11497 + (1));
seq__11470_11494 = G__11501;
chunk__11471_11495 = G__11502;
count__11472_11496 = G__11503;
i__11473_11497 = G__11504;
continue;
} else {
var temp__5753__auto___11505 = cljs.core.seq(seq__11470_11494);
if(temp__5753__auto___11505){
var seq__11470_11506__$1 = temp__5753__auto___11505;
if(cljs.core.chunked_seq_QMARK_(seq__11470_11506__$1)){
var c__4638__auto___11507 = cljs.core.chunk_first(seq__11470_11506__$1);
var G__11508 = cljs.core.chunk_rest(seq__11470_11506__$1);
var G__11509 = c__4638__auto___11507;
var G__11510 = cljs.core.count(c__4638__auto___11507);
var G__11511 = (0);
seq__11470_11494 = G__11508;
chunk__11471_11495 = G__11509;
count__11472_11496 = G__11510;
i__11473_11497 = G__11511;
continue;
} else {
var vec__11483_11512 = cljs.core.first(seq__11470_11506__$1);
var i_11513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11483_11512,(0),null);
var param_11514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11483_11512,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11514);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11515 = cljs.core.next(seq__11470_11506__$1);
var G__11516 = null;
var G__11517 = (0);
var G__11518 = (0);
seq__11470_11494 = G__11515;
chunk__11471_11495 = G__11516;
count__11472_11496 = G__11517;
i__11473_11497 = G__11518;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11486_11519 = cljs.core.seq(params);
var chunk__11487_11520 = null;
var count__11488_11521 = (0);
var i__11489_11522 = (0);
while(true){
if((i__11489_11522 < count__11488_11521)){
var param_11523 = chunk__11487_11520.cljs$core$IIndexed$_nth$arity$2(null,i__11489_11522);
cljs.compiler.emit(param_11523);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11523,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11524 = seq__11486_11519;
var G__11525 = chunk__11487_11520;
var G__11526 = count__11488_11521;
var G__11527 = (i__11489_11522 + (1));
seq__11486_11519 = G__11524;
chunk__11487_11520 = G__11525;
count__11488_11521 = G__11526;
i__11489_11522 = G__11527;
continue;
} else {
var temp__5753__auto___11528 = cljs.core.seq(seq__11486_11519);
if(temp__5753__auto___11528){
var seq__11486_11529__$1 = temp__5753__auto___11528;
if(cljs.core.chunked_seq_QMARK_(seq__11486_11529__$1)){
var c__4638__auto___11530 = cljs.core.chunk_first(seq__11486_11529__$1);
var G__11531 = cljs.core.chunk_rest(seq__11486_11529__$1);
var G__11532 = c__4638__auto___11530;
var G__11533 = cljs.core.count(c__4638__auto___11530);
var G__11534 = (0);
seq__11486_11519 = G__11531;
chunk__11487_11520 = G__11532;
count__11488_11521 = G__11533;
i__11489_11522 = G__11534;
continue;
} else {
var param_11535 = cljs.core.first(seq__11486_11529__$1);
cljs.compiler.emit(param_11535);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11535,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11536 = cljs.core.next(seq__11486_11529__$1);
var G__11537 = null;
var G__11538 = (0);
var G__11539 = (0);
seq__11486_11519 = G__11536;
chunk__11487_11520 = G__11537;
count__11488_11521 = G__11538;
i__11489_11522 = G__11539;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11490_11540 = cljs.core.seq(params);
var chunk__11491_11541 = null;
var count__11492_11542 = (0);
var i__11493_11543 = (0);
while(true){
if((i__11493_11543 < count__11492_11542)){
var param_11544 = chunk__11491_11541.cljs$core$IIndexed$_nth$arity$2(null,i__11493_11543);
cljs.compiler.emit(param_11544);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11544,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11545 = seq__11490_11540;
var G__11546 = chunk__11491_11541;
var G__11547 = count__11492_11542;
var G__11548 = (i__11493_11543 + (1));
seq__11490_11540 = G__11545;
chunk__11491_11541 = G__11546;
count__11492_11542 = G__11547;
i__11493_11543 = G__11548;
continue;
} else {
var temp__5753__auto___11549 = cljs.core.seq(seq__11490_11540);
if(temp__5753__auto___11549){
var seq__11490_11550__$1 = temp__5753__auto___11549;
if(cljs.core.chunked_seq_QMARK_(seq__11490_11550__$1)){
var c__4638__auto___11551 = cljs.core.chunk_first(seq__11490_11550__$1);
var G__11552 = cljs.core.chunk_rest(seq__11490_11550__$1);
var G__11553 = c__4638__auto___11551;
var G__11554 = cljs.core.count(c__4638__auto___11551);
var G__11555 = (0);
seq__11490_11540 = G__11552;
chunk__11491_11541 = G__11553;
count__11492_11542 = G__11554;
i__11493_11543 = G__11555;
continue;
} else {
var param_11556 = cljs.core.first(seq__11490_11550__$1);
cljs.compiler.emit(param_11556);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11556,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11557 = cljs.core.next(seq__11490_11550__$1);
var G__11558 = null;
var G__11559 = (0);
var G__11560 = (0);
seq__11490_11540 = G__11557;
chunk__11491_11541 = G__11558;
count__11492_11542 = G__11559;
i__11493_11543 = G__11560;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__11561 = cljs.core.seq(params);
var chunk__11562 = null;
var count__11563 = (0);
var i__11564 = (0);
while(true){
if((i__11564 < count__11563)){
var param = chunk__11562.cljs$core$IIndexed$_nth$arity$2(null,i__11564);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11565 = seq__11561;
var G__11566 = chunk__11562;
var G__11567 = count__11563;
var G__11568 = (i__11564 + (1));
seq__11561 = G__11565;
chunk__11562 = G__11566;
count__11563 = G__11567;
i__11564 = G__11568;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11561);
if(temp__5753__auto__){
var seq__11561__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11561__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__11561__$1);
var G__11569 = cljs.core.chunk_rest(seq__11561__$1);
var G__11570 = c__4638__auto__;
var G__11571 = cljs.core.count(c__4638__auto__);
var G__11572 = (0);
seq__11561 = G__11569;
chunk__11562 = G__11570;
count__11563 = G__11571;
i__11564 = G__11572;
continue;
} else {
var param = cljs.core.first(seq__11561__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11573 = cljs.core.next(seq__11561__$1);
var G__11574 = null;
var G__11575 = (0);
var G__11576 = (0);
seq__11561 = G__11573;
chunk__11562 = G__11574;
count__11563 = G__11575;
i__11564 = G__11576;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__11577){
var map__11578 = p__11577;
var map__11578__$1 = cljs.core.__destructure_map(map__11578);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11578__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__11579){
var map__11580 = p__11579;
var map__11580__$1 = cljs.core.__destructure_map(map__11580);
var f = map__11580__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11580__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_11589__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11590 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11589__$1);
var delegate_name_11591 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11590),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_11591," = function (");

var seq__11581_11592 = cljs.core.seq(params);
var chunk__11582_11593 = null;
var count__11583_11594 = (0);
var i__11584_11595 = (0);
while(true){
if((i__11584_11595 < count__11583_11594)){
var param_11596 = chunk__11582_11593.cljs$core$IIndexed$_nth$arity$2(null,i__11584_11595);
cljs.compiler.emit(param_11596);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11596,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11597 = seq__11581_11592;
var G__11598 = chunk__11582_11593;
var G__11599 = count__11583_11594;
var G__11600 = (i__11584_11595 + (1));
seq__11581_11592 = G__11597;
chunk__11582_11593 = G__11598;
count__11583_11594 = G__11599;
i__11584_11595 = G__11600;
continue;
} else {
var temp__5753__auto___11601 = cljs.core.seq(seq__11581_11592);
if(temp__5753__auto___11601){
var seq__11581_11602__$1 = temp__5753__auto___11601;
if(cljs.core.chunked_seq_QMARK_(seq__11581_11602__$1)){
var c__4638__auto___11603 = cljs.core.chunk_first(seq__11581_11602__$1);
var G__11604 = cljs.core.chunk_rest(seq__11581_11602__$1);
var G__11605 = c__4638__auto___11603;
var G__11606 = cljs.core.count(c__4638__auto___11603);
var G__11607 = (0);
seq__11581_11592 = G__11604;
chunk__11582_11593 = G__11605;
count__11583_11594 = G__11606;
i__11584_11595 = G__11607;
continue;
} else {
var param_11608 = cljs.core.first(seq__11581_11602__$1);
cljs.compiler.emit(param_11608);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11608,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11609 = cljs.core.next(seq__11581_11602__$1);
var G__11610 = null;
var G__11611 = (0);
var G__11612 = (0);
seq__11581_11592 = G__11609;
chunk__11582_11593 = G__11610;
count__11583_11594 = G__11611;
i__11584_11595 = G__11612;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_11590," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_11613 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_11613,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_11591,".call(this,");

var seq__11585_11614 = cljs.core.seq(params);
var chunk__11586_11615 = null;
var count__11587_11616 = (0);
var i__11588_11617 = (0);
while(true){
if((i__11588_11617 < count__11587_11616)){
var param_11618 = chunk__11586_11615.cljs$core$IIndexed$_nth$arity$2(null,i__11588_11617);
cljs.compiler.emit(param_11618);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11618,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11619 = seq__11585_11614;
var G__11620 = chunk__11586_11615;
var G__11621 = count__11587_11616;
var G__11622 = (i__11588_11617 + (1));
seq__11585_11614 = G__11619;
chunk__11586_11615 = G__11620;
count__11587_11616 = G__11621;
i__11588_11617 = G__11622;
continue;
} else {
var temp__5753__auto___11623 = cljs.core.seq(seq__11585_11614);
if(temp__5753__auto___11623){
var seq__11585_11624__$1 = temp__5753__auto___11623;
if(cljs.core.chunked_seq_QMARK_(seq__11585_11624__$1)){
var c__4638__auto___11625 = cljs.core.chunk_first(seq__11585_11624__$1);
var G__11626 = cljs.core.chunk_rest(seq__11585_11624__$1);
var G__11627 = c__4638__auto___11625;
var G__11628 = cljs.core.count(c__4638__auto___11625);
var G__11629 = (0);
seq__11585_11614 = G__11626;
chunk__11586_11615 = G__11627;
count__11587_11616 = G__11628;
i__11588_11617 = G__11629;
continue;
} else {
var param_11630 = cljs.core.first(seq__11585_11624__$1);
cljs.compiler.emit(param_11630);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11630,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11631 = cljs.core.next(seq__11585_11624__$1);
var G__11632 = null;
var G__11633 = (0);
var G__11634 = (0);
seq__11585_11614 = G__11631;
chunk__11586_11615 = G__11632;
count__11587_11616 = G__11633;
i__11588_11617 = G__11634;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11590,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_11590,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_11589__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11590,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_11591,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11590,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__11638){
var map__11639 = p__11638;
var map__11639__$1 = cljs.core.__destructure_map(map__11639);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11639__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11635_SHARP_){
var and__4210__auto__ = p1__11635_SHARP_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__11635_SHARP_));
} else {
return and__4210__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4212__auto__ = in_loop;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_11691__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11692 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11691__$1);
var maxparams_11693 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_11694 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11692),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_11695 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__11636_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__11636_SHARP_)));
}),cljs.core.seq(mmap_11694));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_11692," = null;");

var seq__11640_11696 = cljs.core.seq(ms_11695);
var chunk__11641_11697 = null;
var count__11642_11698 = (0);
var i__11643_11699 = (0);
while(true){
if((i__11643_11699 < count__11642_11698)){
var vec__11650_11700 = chunk__11641_11697.cljs$core$IIndexed$_nth$arity$2(null,i__11643_11699);
var n_11701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11650_11700,(0),null);
var meth_11702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11650_11700,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11701," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11702))){
cljs.compiler.emit_variadic_fn_method(meth_11702);
} else {
cljs.compiler.emit_fn_method(meth_11702);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11703 = seq__11640_11696;
var G__11704 = chunk__11641_11697;
var G__11705 = count__11642_11698;
var G__11706 = (i__11643_11699 + (1));
seq__11640_11696 = G__11703;
chunk__11641_11697 = G__11704;
count__11642_11698 = G__11705;
i__11643_11699 = G__11706;
continue;
} else {
var temp__5753__auto___11707 = cljs.core.seq(seq__11640_11696);
if(temp__5753__auto___11707){
var seq__11640_11708__$1 = temp__5753__auto___11707;
if(cljs.core.chunked_seq_QMARK_(seq__11640_11708__$1)){
var c__4638__auto___11709 = cljs.core.chunk_first(seq__11640_11708__$1);
var G__11710 = cljs.core.chunk_rest(seq__11640_11708__$1);
var G__11711 = c__4638__auto___11709;
var G__11712 = cljs.core.count(c__4638__auto___11709);
var G__11713 = (0);
seq__11640_11696 = G__11710;
chunk__11641_11697 = G__11711;
count__11642_11698 = G__11712;
i__11643_11699 = G__11713;
continue;
} else {
var vec__11653_11714 = cljs.core.first(seq__11640_11708__$1);
var n_11715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11653_11714,(0),null);
var meth_11716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11653_11714,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11715," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11716))){
cljs.compiler.emit_variadic_fn_method(meth_11716);
} else {
cljs.compiler.emit_fn_method(meth_11716);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11717 = cljs.core.next(seq__11640_11708__$1);
var G__11718 = null;
var G__11719 = (0);
var G__11720 = (0);
seq__11640_11696 = G__11717;
chunk__11641_11697 = G__11718;
count__11642_11698 = G__11719;
i__11643_11699 = G__11720;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11692," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_11693),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_11693)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_11693));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__11656_11721 = cljs.core.seq(ms_11695);
var chunk__11657_11722 = null;
var count__11658_11723 = (0);
var i__11659_11724 = (0);
while(true){
if((i__11659_11724 < count__11658_11723)){
var vec__11666_11725 = chunk__11657_11722.cljs$core$IIndexed$_nth$arity$2(null,i__11659_11724);
var n_11726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11666_11725,(0),null);
var meth_11727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11666_11725,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11727))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11728 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11728," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11729 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11728," = new cljs.core.IndexedSeq(",a_11729,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11726,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11693)),(((cljs.core.count(maxparams_11693) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11728,");"], 0));
} else {
var pcnt_11730 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11727));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11730,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11726,".call(this",(((pcnt_11730 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11730,maxparams_11693)),null,(1),null)),(2),null))),");");
}


var G__11731 = seq__11656_11721;
var G__11732 = chunk__11657_11722;
var G__11733 = count__11658_11723;
var G__11734 = (i__11659_11724 + (1));
seq__11656_11721 = G__11731;
chunk__11657_11722 = G__11732;
count__11658_11723 = G__11733;
i__11659_11724 = G__11734;
continue;
} else {
var temp__5753__auto___11735 = cljs.core.seq(seq__11656_11721);
if(temp__5753__auto___11735){
var seq__11656_11736__$1 = temp__5753__auto___11735;
if(cljs.core.chunked_seq_QMARK_(seq__11656_11736__$1)){
var c__4638__auto___11737 = cljs.core.chunk_first(seq__11656_11736__$1);
var G__11738 = cljs.core.chunk_rest(seq__11656_11736__$1);
var G__11739 = c__4638__auto___11737;
var G__11740 = cljs.core.count(c__4638__auto___11737);
var G__11741 = (0);
seq__11656_11721 = G__11738;
chunk__11657_11722 = G__11739;
count__11658_11723 = G__11740;
i__11659_11724 = G__11741;
continue;
} else {
var vec__11669_11742 = cljs.core.first(seq__11656_11736__$1);
var n_11743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11669_11742,(0),null);
var meth_11744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11669_11742,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11744))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11745 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11745," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11746 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11745," = new cljs.core.IndexedSeq(",a_11746,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11743,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11693)),(((cljs.core.count(maxparams_11693) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11745,");"], 0));
} else {
var pcnt_11747 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11744));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11747,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11743,".call(this",(((pcnt_11747 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11747,maxparams_11693)),null,(1),null)),(2),null))),");");
}


var G__11748 = cljs.core.next(seq__11656_11736__$1);
var G__11749 = null;
var G__11750 = (0);
var G__11751 = (0);
seq__11656_11721 = G__11748;
chunk__11657_11722 = G__11749;
count__11658_11723 = G__11750;
i__11659_11724 = G__11751;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_11752 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_11695)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_11752,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11692,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11692,".cljs$lang$applyTo = ",cljs.core.some((function (p1__11637_SHARP_){
var vec__11672 = p1__11637_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11672,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11672,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_11695),".cljs$lang$applyTo;");
} else {
}

var seq__11675_11753 = cljs.core.seq(ms_11695);
var chunk__11676_11754 = null;
var count__11677_11755 = (0);
var i__11678_11756 = (0);
while(true){
if((i__11678_11756 < count__11677_11755)){
var vec__11685_11757 = chunk__11676_11754.cljs$core$IIndexed$_nth$arity$2(null,i__11678_11756);
var n_11758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11685_11757,(0),null);
var meth_11759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11685_11757,(1),null);
var c_11760 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11759));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11759))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11692,".cljs$core$IFn$_invoke$arity$variadic = ",n_11758,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11692,".cljs$core$IFn$_invoke$arity$",c_11760," = ",n_11758,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__11761 = seq__11675_11753;
var G__11762 = chunk__11676_11754;
var G__11763 = count__11677_11755;
var G__11764 = (i__11678_11756 + (1));
seq__11675_11753 = G__11761;
chunk__11676_11754 = G__11762;
count__11677_11755 = G__11763;
i__11678_11756 = G__11764;
continue;
} else {
var temp__5753__auto___11765 = cljs.core.seq(seq__11675_11753);
if(temp__5753__auto___11765){
var seq__11675_11766__$1 = temp__5753__auto___11765;
if(cljs.core.chunked_seq_QMARK_(seq__11675_11766__$1)){
var c__4638__auto___11767 = cljs.core.chunk_first(seq__11675_11766__$1);
var G__11768 = cljs.core.chunk_rest(seq__11675_11766__$1);
var G__11769 = c__4638__auto___11767;
var G__11770 = cljs.core.count(c__4638__auto___11767);
var G__11771 = (0);
seq__11675_11753 = G__11768;
chunk__11676_11754 = G__11769;
count__11677_11755 = G__11770;
i__11678_11756 = G__11771;
continue;
} else {
var vec__11688_11772 = cljs.core.first(seq__11675_11766__$1);
var n_11773 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11688_11772,(0),null);
var meth_11774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11688_11772,(1),null);
var c_11775 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11774));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11774))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11692,".cljs$core$IFn$_invoke$arity$variadic = ",n_11773,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11692,".cljs$core$IFn$_invoke$arity$",c_11775," = ",n_11773,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__11776 = cljs.core.next(seq__11675_11766__$1);
var G__11777 = null;
var G__11778 = (0);
var G__11779 = (0);
seq__11675_11753 = G__11776;
chunk__11676_11754 = G__11777;
count__11677_11755 = G__11778;
i__11678_11756 = G__11779;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11692,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__11780){
var map__11781 = p__11780;
var map__11781__$1 = cljs.core.__destructure_map(map__11781);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11781__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11781__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11781__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__11782_11786 = cljs.core.seq(statements);
var chunk__11783_11787 = null;
var count__11784_11788 = (0);
var i__11785_11789 = (0);
while(true){
if((i__11785_11789 < count__11784_11788)){
var s_11790 = chunk__11783_11787.cljs$core$IIndexed$_nth$arity$2(null,i__11785_11789);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_11790);


var G__11791 = seq__11782_11786;
var G__11792 = chunk__11783_11787;
var G__11793 = count__11784_11788;
var G__11794 = (i__11785_11789 + (1));
seq__11782_11786 = G__11791;
chunk__11783_11787 = G__11792;
count__11784_11788 = G__11793;
i__11785_11789 = G__11794;
continue;
} else {
var temp__5753__auto___11795 = cljs.core.seq(seq__11782_11786);
if(temp__5753__auto___11795){
var seq__11782_11796__$1 = temp__5753__auto___11795;
if(cljs.core.chunked_seq_QMARK_(seq__11782_11796__$1)){
var c__4638__auto___11797 = cljs.core.chunk_first(seq__11782_11796__$1);
var G__11798 = cljs.core.chunk_rest(seq__11782_11796__$1);
var G__11799 = c__4638__auto___11797;
var G__11800 = cljs.core.count(c__4638__auto___11797);
var G__11801 = (0);
seq__11782_11786 = G__11798;
chunk__11783_11787 = G__11799;
count__11784_11788 = G__11800;
i__11785_11789 = G__11801;
continue;
} else {
var s_11802 = cljs.core.first(seq__11782_11796__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_11802);


var G__11803 = cljs.core.next(seq__11782_11796__$1);
var G__11804 = null;
var G__11805 = (0);
var G__11806 = (0);
seq__11782_11786 = G__11803;
chunk__11783_11787 = G__11804;
count__11784_11788 = G__11805;
i__11785_11789 = G__11806;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__11807){
var map__11808 = p__11807;
var map__11808__$1 = cljs.core.__destructure_map(map__11808);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11808__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11808__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11808__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11808__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11808__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__11809,is_loop){
var map__11810 = p__11809;
var map__11810__$1 = cljs.core.__destructure_map(map__11810);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11810__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11810__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11810__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__11811_11821 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__11812_11822 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__11812_11822);

try{var seq__11813_11823 = cljs.core.seq(bindings);
var chunk__11814_11824 = null;
var count__11815_11825 = (0);
var i__11816_11826 = (0);
while(true){
if((i__11816_11826 < count__11815_11825)){
var map__11819_11827 = chunk__11814_11824.cljs$core$IIndexed$_nth$arity$2(null,i__11816_11826);
var map__11819_11828__$1 = cljs.core.__destructure_map(map__11819_11827);
var binding_11829 = map__11819_11828__$1;
var init_11830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11819_11828__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_11829);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_11830,";");


var G__11831 = seq__11813_11823;
var G__11832 = chunk__11814_11824;
var G__11833 = count__11815_11825;
var G__11834 = (i__11816_11826 + (1));
seq__11813_11823 = G__11831;
chunk__11814_11824 = G__11832;
count__11815_11825 = G__11833;
i__11816_11826 = G__11834;
continue;
} else {
var temp__5753__auto___11835 = cljs.core.seq(seq__11813_11823);
if(temp__5753__auto___11835){
var seq__11813_11836__$1 = temp__5753__auto___11835;
if(cljs.core.chunked_seq_QMARK_(seq__11813_11836__$1)){
var c__4638__auto___11837 = cljs.core.chunk_first(seq__11813_11836__$1);
var G__11838 = cljs.core.chunk_rest(seq__11813_11836__$1);
var G__11839 = c__4638__auto___11837;
var G__11840 = cljs.core.count(c__4638__auto___11837);
var G__11841 = (0);
seq__11813_11823 = G__11838;
chunk__11814_11824 = G__11839;
count__11815_11825 = G__11840;
i__11816_11826 = G__11841;
continue;
} else {
var map__11820_11842 = cljs.core.first(seq__11813_11836__$1);
var map__11820_11843__$1 = cljs.core.__destructure_map(map__11820_11842);
var binding_11844 = map__11820_11843__$1;
var init_11845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11820_11843__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_11844);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_11845,";");


var G__11846 = cljs.core.next(seq__11813_11836__$1);
var G__11847 = null;
var G__11848 = (0);
var G__11849 = (0);
seq__11813_11823 = G__11846;
chunk__11814_11824 = G__11847;
count__11815_11825 = G__11848;
i__11816_11826 = G__11849;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__11811_11821);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__11850){
var map__11851 = p__11850;
var map__11851__$1 = cljs.core.__destructure_map(map__11851);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11851__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11851__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11851__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4695__auto___11852 = cljs.core.count(exprs);
var i_11853 = (0);
while(true){
if((i_11853 < n__4695__auto___11852)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_11853) : temps.call(null,i_11853))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_11853) : exprs.call(null,i_11853)),";");

var G__11854 = (i_11853 + (1));
i_11853 = G__11854;
continue;
} else {
}
break;
}

var n__4695__auto___11855 = cljs.core.count(exprs);
var i_11856 = (0);
while(true){
if((i_11856 < n__4695__auto___11855)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_11856) : params.call(null,i_11856)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_11856) : temps.call(null,i_11856)),";");

var G__11857 = (i_11856 + (1));
i_11856 = G__11857;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__11858){
var map__11859 = p__11858;
var map__11859__$1 = cljs.core.__destructure_map(map__11859);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11859__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11859__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11859__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__11860_11868 = cljs.core.seq(bindings);
var chunk__11861_11869 = null;
var count__11862_11870 = (0);
var i__11863_11871 = (0);
while(true){
if((i__11863_11871 < count__11862_11870)){
var map__11866_11872 = chunk__11861_11869.cljs$core$IIndexed$_nth$arity$2(null,i__11863_11871);
var map__11866_11873__$1 = cljs.core.__destructure_map(map__11866_11872);
var binding_11874 = map__11866_11873__$1;
var init_11875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11866_11873__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_11874)," = ",init_11875,";");


var G__11876 = seq__11860_11868;
var G__11877 = chunk__11861_11869;
var G__11878 = count__11862_11870;
var G__11879 = (i__11863_11871 + (1));
seq__11860_11868 = G__11876;
chunk__11861_11869 = G__11877;
count__11862_11870 = G__11878;
i__11863_11871 = G__11879;
continue;
} else {
var temp__5753__auto___11880 = cljs.core.seq(seq__11860_11868);
if(temp__5753__auto___11880){
var seq__11860_11881__$1 = temp__5753__auto___11880;
if(cljs.core.chunked_seq_QMARK_(seq__11860_11881__$1)){
var c__4638__auto___11882 = cljs.core.chunk_first(seq__11860_11881__$1);
var G__11883 = cljs.core.chunk_rest(seq__11860_11881__$1);
var G__11884 = c__4638__auto___11882;
var G__11885 = cljs.core.count(c__4638__auto___11882);
var G__11886 = (0);
seq__11860_11868 = G__11883;
chunk__11861_11869 = G__11884;
count__11862_11870 = G__11885;
i__11863_11871 = G__11886;
continue;
} else {
var map__11867_11887 = cljs.core.first(seq__11860_11881__$1);
var map__11867_11888__$1 = cljs.core.__destructure_map(map__11867_11887);
var binding_11889 = map__11867_11888__$1;
var init_11890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11867_11888__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_11889)," = ",init_11890,";");


var G__11891 = cljs.core.next(seq__11860_11881__$1);
var G__11892 = null;
var G__11893 = (0);
var G__11894 = (0);
seq__11860_11868 = G__11891;
chunk__11861_11869 = G__11892;
count__11862_11870 = G__11893;
i__11863_11871 = G__11894;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__11897){
var map__11898 = p__11897;
var map__11898__$1 = cljs.core.__destructure_map(map__11898);
var expr = map__11898__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11898__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11898__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11898__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4210__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4210__auto__ = protocol;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = tag;
if(cljs.core.truth_(and__4210__auto____$1)){
var or__4212__auto__ = (function (){var and__4210__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto____$2)){
var and__4210__auto____$3 = protocol;
if(cljs.core.truth_(and__4210__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4210__auto____$3;
}
} else {
return and__4210__auto____$2;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto____$2 = (function (){var or__4212__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4210__auto____$2)){
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
var and__4210__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4210__auto____$3){
var and__4210__auto____$4 = cljs.core.not((function (){var fexpr__11902 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__11902.cljs$core$IFn$_invoke$arity$1 ? fexpr__11902.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11902.call(null,tag));
})());
if(and__4210__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4210__auto____$4;
}
} else {
return and__4210__auto____$3;
}
}
} else {
return and__4210__auto____$2;
}
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__11903 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__11903.cljs$core$IFn$_invoke$arity$1 ? fexpr__11903.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__11903.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__11899 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (arity > mfa);
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__11895_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11895_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__11896_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11896_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11899,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11899,(1),null);
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_11906 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_11906,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_11907 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_11907,args)),(((mfa_11907 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_11907,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var G__11905 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__11904 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__11904.cljs$core$IFn$_invoke$arity$1 ? fexpr__11904.cljs$core$IFn$_invoke$arity$1(G__11905) : fexpr__11904.call(null,G__11905));
} else {
return and__4210__auto__;
}
})())){
var fprop_11908 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11908," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11908,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11908," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11908,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__11909){
var map__11910 = p__11909;
var map__11910__$1 = cljs.core.__destructure_map(map__11910);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11910__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11910__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11910__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__11911){
var map__11912 = p__11911;
var map__11912__$1 = cljs.core.__destructure_map(map__11912);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11912__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11912__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11912__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11913_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11913_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__11914 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11914,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11914,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__11917 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11917__$1 = cljs.core.__destructure_map(map__11917);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11917__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11917__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__11918 = options;
var map__11918__$1 = cljs.core.__destructure_map(map__11918);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11918__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11918__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11918__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__11919 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__11922 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__11922__$1 = cljs.core.__destructure_map(map__11922);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11922__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11922__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11919,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11919,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__11923_11951 = cljs.core.seq(libs_to_load);
var chunk__11924_11952 = null;
var count__11925_11953 = (0);
var i__11926_11954 = (0);
while(true){
if((i__11926_11954 < count__11925_11953)){
var lib_11955 = chunk__11924_11952.cljs$core$IIndexed$_nth$arity$2(null,i__11926_11954);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11955)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11955),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11955),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11955),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11955),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11955,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11955),"');");
}

}
}
}


var G__11956 = seq__11923_11951;
var G__11957 = chunk__11924_11952;
var G__11958 = count__11925_11953;
var G__11959 = (i__11926_11954 + (1));
seq__11923_11951 = G__11956;
chunk__11924_11952 = G__11957;
count__11925_11953 = G__11958;
i__11926_11954 = G__11959;
continue;
} else {
var temp__5753__auto___11960 = cljs.core.seq(seq__11923_11951);
if(temp__5753__auto___11960){
var seq__11923_11961__$1 = temp__5753__auto___11960;
if(cljs.core.chunked_seq_QMARK_(seq__11923_11961__$1)){
var c__4638__auto___11962 = cljs.core.chunk_first(seq__11923_11961__$1);
var G__11963 = cljs.core.chunk_rest(seq__11923_11961__$1);
var G__11964 = c__4638__auto___11962;
var G__11965 = cljs.core.count(c__4638__auto___11962);
var G__11966 = (0);
seq__11923_11951 = G__11963;
chunk__11924_11952 = G__11964;
count__11925_11953 = G__11965;
i__11926_11954 = G__11966;
continue;
} else {
var lib_11967 = cljs.core.first(seq__11923_11961__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11967)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11967),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11967),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11967),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11967),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11967,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11967),"');");
}

}
}
}


var G__11968 = cljs.core.next(seq__11923_11961__$1);
var G__11969 = null;
var G__11970 = (0);
var G__11971 = (0);
seq__11923_11951 = G__11968;
chunk__11924_11952 = G__11969;
count__11925_11953 = G__11970;
i__11926_11954 = G__11971;
continue;
}
} else {
}
}
break;
}

var seq__11927_11972 = cljs.core.seq(node_libs);
var chunk__11928_11973 = null;
var count__11929_11974 = (0);
var i__11930_11975 = (0);
while(true){
if((i__11930_11975 < count__11929_11974)){
var lib_11976 = chunk__11928_11973.cljs$core$IIndexed$_nth$arity$2(null,i__11930_11975);
var vec__11937_11977 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11976);
var lib_SINGLEQUOTE__11978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11937_11977,(0),null);
var sublib_11979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11937_11977,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11976)," = require('",lib_SINGLEQUOTE__11978,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11979),";"], 0));


var G__11980 = seq__11927_11972;
var G__11981 = chunk__11928_11973;
var G__11982 = count__11929_11974;
var G__11983 = (i__11930_11975 + (1));
seq__11927_11972 = G__11980;
chunk__11928_11973 = G__11981;
count__11929_11974 = G__11982;
i__11930_11975 = G__11983;
continue;
} else {
var temp__5753__auto___11984 = cljs.core.seq(seq__11927_11972);
if(temp__5753__auto___11984){
var seq__11927_11985__$1 = temp__5753__auto___11984;
if(cljs.core.chunked_seq_QMARK_(seq__11927_11985__$1)){
var c__4638__auto___11986 = cljs.core.chunk_first(seq__11927_11985__$1);
var G__11987 = cljs.core.chunk_rest(seq__11927_11985__$1);
var G__11988 = c__4638__auto___11986;
var G__11989 = cljs.core.count(c__4638__auto___11986);
var G__11990 = (0);
seq__11927_11972 = G__11987;
chunk__11928_11973 = G__11988;
count__11929_11974 = G__11989;
i__11930_11975 = G__11990;
continue;
} else {
var lib_11991 = cljs.core.first(seq__11927_11985__$1);
var vec__11940_11992 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11991);
var lib_SINGLEQUOTE__11993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11940_11992,(0),null);
var sublib_11994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11940_11992,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11991)," = require('",lib_SINGLEQUOTE__11993,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11994),";"], 0));


var G__11995 = cljs.core.next(seq__11927_11985__$1);
var G__11996 = null;
var G__11997 = (0);
var G__11998 = (0);
seq__11927_11972 = G__11995;
chunk__11928_11973 = G__11996;
count__11929_11974 = G__11997;
i__11930_11975 = G__11998;
continue;
}
} else {
}
}
break;
}

var seq__11943_11999 = cljs.core.seq(global_exports_libs);
var chunk__11944_12000 = null;
var count__11945_12001 = (0);
var i__11946_12002 = (0);
while(true){
if((i__11946_12002 < count__11945_12001)){
var lib_12003 = chunk__11944_12000.cljs$core$IIndexed$_nth$arity$2(null,i__11946_12002);
var map__11949_12004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12003))));
var map__11949_12005__$1 = cljs.core.__destructure_map(map__11949_12004);
var global_exports_12006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11949_12005__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_12006,lib_12003);


var G__12007 = seq__11943_11999;
var G__12008 = chunk__11944_12000;
var G__12009 = count__11945_12001;
var G__12010 = (i__11946_12002 + (1));
seq__11943_11999 = G__12007;
chunk__11944_12000 = G__12008;
count__11945_12001 = G__12009;
i__11946_12002 = G__12010;
continue;
} else {
var temp__5753__auto___12011 = cljs.core.seq(seq__11943_11999);
if(temp__5753__auto___12011){
var seq__11943_12012__$1 = temp__5753__auto___12011;
if(cljs.core.chunked_seq_QMARK_(seq__11943_12012__$1)){
var c__4638__auto___12013 = cljs.core.chunk_first(seq__11943_12012__$1);
var G__12014 = cljs.core.chunk_rest(seq__11943_12012__$1);
var G__12015 = c__4638__auto___12013;
var G__12016 = cljs.core.count(c__4638__auto___12013);
var G__12017 = (0);
seq__11943_11999 = G__12014;
chunk__11944_12000 = G__12015;
count__11945_12001 = G__12016;
i__11946_12002 = G__12017;
continue;
} else {
var lib_12018 = cljs.core.first(seq__11943_12012__$1);
var map__11950_12019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12018))));
var map__11950_12020__$1 = cljs.core.__destructure_map(map__11950_12019);
var global_exports_12021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11950_12020__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_12021,lib_12018);


var G__12022 = cljs.core.next(seq__11943_12012__$1);
var G__12023 = null;
var G__12024 = (0);
var G__12025 = (0);
seq__11943_11999 = G__12022;
chunk__11944_12000 = G__12023;
count__11945_12001 = G__12024;
i__11946_12002 = G__12025;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__12026){
var map__12027 = p__12026;
var map__12027__$1 = cljs.core.__destructure_map(map__12027);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12027__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__12028){
var map__12029 = p__12028;
var map__12029__$1 = cljs.core.__destructure_map(map__12029);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12029__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__12030){
var map__12031 = p__12030;
var map__12031__$1 = cljs.core.__destructure_map(map__12031);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12031__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12031__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12031__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12031__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12031__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12032_12056 = cljs.core.seq(protocols);
var chunk__12033_12057 = null;
var count__12034_12058 = (0);
var i__12035_12059 = (0);
while(true){
if((i__12035_12059 < count__12034_12058)){
var protocol_12060 = chunk__12033_12057.cljs$core$IIndexed$_nth$arity$2(null,i__12035_12059);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12060)),"}");


var G__12061 = seq__12032_12056;
var G__12062 = chunk__12033_12057;
var G__12063 = count__12034_12058;
var G__12064 = (i__12035_12059 + (1));
seq__12032_12056 = G__12061;
chunk__12033_12057 = G__12062;
count__12034_12058 = G__12063;
i__12035_12059 = G__12064;
continue;
} else {
var temp__5753__auto___12065 = cljs.core.seq(seq__12032_12056);
if(temp__5753__auto___12065){
var seq__12032_12066__$1 = temp__5753__auto___12065;
if(cljs.core.chunked_seq_QMARK_(seq__12032_12066__$1)){
var c__4638__auto___12067 = cljs.core.chunk_first(seq__12032_12066__$1);
var G__12068 = cljs.core.chunk_rest(seq__12032_12066__$1);
var G__12069 = c__4638__auto___12067;
var G__12070 = cljs.core.count(c__4638__auto___12067);
var G__12071 = (0);
seq__12032_12056 = G__12068;
chunk__12033_12057 = G__12069;
count__12034_12058 = G__12070;
i__12035_12059 = G__12071;
continue;
} else {
var protocol_12072 = cljs.core.first(seq__12032_12066__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12072)),"}");


var G__12073 = cljs.core.next(seq__12032_12066__$1);
var G__12074 = null;
var G__12075 = (0);
var G__12076 = (0);
seq__12032_12056 = G__12073;
chunk__12033_12057 = G__12074;
count__12034_12058 = G__12075;
i__12035_12059 = G__12076;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12036_12077 = cljs.core.seq(fields__$1);
var chunk__12037_12078 = null;
var count__12038_12079 = (0);
var i__12039_12080 = (0);
while(true){
if((i__12039_12080 < count__12038_12079)){
var fld_12081 = chunk__12037_12078.cljs$core$IIndexed$_nth$arity$2(null,i__12039_12080);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12081," = ",fld_12081,";");


var G__12082 = seq__12036_12077;
var G__12083 = chunk__12037_12078;
var G__12084 = count__12038_12079;
var G__12085 = (i__12039_12080 + (1));
seq__12036_12077 = G__12082;
chunk__12037_12078 = G__12083;
count__12038_12079 = G__12084;
i__12039_12080 = G__12085;
continue;
} else {
var temp__5753__auto___12086 = cljs.core.seq(seq__12036_12077);
if(temp__5753__auto___12086){
var seq__12036_12087__$1 = temp__5753__auto___12086;
if(cljs.core.chunked_seq_QMARK_(seq__12036_12087__$1)){
var c__4638__auto___12088 = cljs.core.chunk_first(seq__12036_12087__$1);
var G__12089 = cljs.core.chunk_rest(seq__12036_12087__$1);
var G__12090 = c__4638__auto___12088;
var G__12091 = cljs.core.count(c__4638__auto___12088);
var G__12092 = (0);
seq__12036_12077 = G__12089;
chunk__12037_12078 = G__12090;
count__12038_12079 = G__12091;
i__12039_12080 = G__12092;
continue;
} else {
var fld_12093 = cljs.core.first(seq__12036_12087__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12093," = ",fld_12093,";");


var G__12094 = cljs.core.next(seq__12036_12087__$1);
var G__12095 = null;
var G__12096 = (0);
var G__12097 = (0);
seq__12036_12077 = G__12094;
chunk__12037_12078 = G__12095;
count__12038_12079 = G__12096;
i__12039_12080 = G__12097;
continue;
}
} else {
}
}
break;
}

var seq__12040_12098 = cljs.core.seq(pmasks);
var chunk__12041_12099 = null;
var count__12042_12100 = (0);
var i__12043_12101 = (0);
while(true){
if((i__12043_12101 < count__12042_12100)){
var vec__12050_12102 = chunk__12041_12099.cljs$core$IIndexed$_nth$arity$2(null,i__12043_12101);
var pno_12103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_12102,(0),null);
var pmask_12104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12050_12102,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12103,"$ = ",pmask_12104,";");


var G__12105 = seq__12040_12098;
var G__12106 = chunk__12041_12099;
var G__12107 = count__12042_12100;
var G__12108 = (i__12043_12101 + (1));
seq__12040_12098 = G__12105;
chunk__12041_12099 = G__12106;
count__12042_12100 = G__12107;
i__12043_12101 = G__12108;
continue;
} else {
var temp__5753__auto___12109 = cljs.core.seq(seq__12040_12098);
if(temp__5753__auto___12109){
var seq__12040_12110__$1 = temp__5753__auto___12109;
if(cljs.core.chunked_seq_QMARK_(seq__12040_12110__$1)){
var c__4638__auto___12111 = cljs.core.chunk_first(seq__12040_12110__$1);
var G__12112 = cljs.core.chunk_rest(seq__12040_12110__$1);
var G__12113 = c__4638__auto___12111;
var G__12114 = cljs.core.count(c__4638__auto___12111);
var G__12115 = (0);
seq__12040_12098 = G__12112;
chunk__12041_12099 = G__12113;
count__12042_12100 = G__12114;
i__12043_12101 = G__12115;
continue;
} else {
var vec__12053_12116 = cljs.core.first(seq__12040_12110__$1);
var pno_12117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12053_12116,(0),null);
var pmask_12118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12053_12116,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12117,"$ = ",pmask_12118,";");


var G__12119 = cljs.core.next(seq__12040_12110__$1);
var G__12120 = null;
var G__12121 = (0);
var G__12122 = (0);
seq__12040_12098 = G__12119;
chunk__12041_12099 = G__12120;
count__12042_12100 = G__12121;
i__12043_12101 = G__12122;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__12123){
var map__12124 = p__12123;
var map__12124__$1 = cljs.core.__destructure_map(map__12124);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12124__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12124__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12124__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12124__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12124__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12125_12149 = cljs.core.seq(protocols);
var chunk__12126_12150 = null;
var count__12127_12151 = (0);
var i__12128_12152 = (0);
while(true){
if((i__12128_12152 < count__12127_12151)){
var protocol_12153 = chunk__12126_12150.cljs$core$IIndexed$_nth$arity$2(null,i__12128_12152);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12153)),"}");


var G__12154 = seq__12125_12149;
var G__12155 = chunk__12126_12150;
var G__12156 = count__12127_12151;
var G__12157 = (i__12128_12152 + (1));
seq__12125_12149 = G__12154;
chunk__12126_12150 = G__12155;
count__12127_12151 = G__12156;
i__12128_12152 = G__12157;
continue;
} else {
var temp__5753__auto___12158 = cljs.core.seq(seq__12125_12149);
if(temp__5753__auto___12158){
var seq__12125_12159__$1 = temp__5753__auto___12158;
if(cljs.core.chunked_seq_QMARK_(seq__12125_12159__$1)){
var c__4638__auto___12160 = cljs.core.chunk_first(seq__12125_12159__$1);
var G__12161 = cljs.core.chunk_rest(seq__12125_12159__$1);
var G__12162 = c__4638__auto___12160;
var G__12163 = cljs.core.count(c__4638__auto___12160);
var G__12164 = (0);
seq__12125_12149 = G__12161;
chunk__12126_12150 = G__12162;
count__12127_12151 = G__12163;
i__12128_12152 = G__12164;
continue;
} else {
var protocol_12165 = cljs.core.first(seq__12125_12159__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12165)),"}");


var G__12166 = cljs.core.next(seq__12125_12159__$1);
var G__12167 = null;
var G__12168 = (0);
var G__12169 = (0);
seq__12125_12149 = G__12166;
chunk__12126_12150 = G__12167;
count__12127_12151 = G__12168;
i__12128_12152 = G__12169;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12129_12170 = cljs.core.seq(fields__$1);
var chunk__12130_12171 = null;
var count__12131_12172 = (0);
var i__12132_12173 = (0);
while(true){
if((i__12132_12173 < count__12131_12172)){
var fld_12174 = chunk__12130_12171.cljs$core$IIndexed$_nth$arity$2(null,i__12132_12173);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12174," = ",fld_12174,";");


var G__12175 = seq__12129_12170;
var G__12176 = chunk__12130_12171;
var G__12177 = count__12131_12172;
var G__12178 = (i__12132_12173 + (1));
seq__12129_12170 = G__12175;
chunk__12130_12171 = G__12176;
count__12131_12172 = G__12177;
i__12132_12173 = G__12178;
continue;
} else {
var temp__5753__auto___12179 = cljs.core.seq(seq__12129_12170);
if(temp__5753__auto___12179){
var seq__12129_12180__$1 = temp__5753__auto___12179;
if(cljs.core.chunked_seq_QMARK_(seq__12129_12180__$1)){
var c__4638__auto___12181 = cljs.core.chunk_first(seq__12129_12180__$1);
var G__12182 = cljs.core.chunk_rest(seq__12129_12180__$1);
var G__12183 = c__4638__auto___12181;
var G__12184 = cljs.core.count(c__4638__auto___12181);
var G__12185 = (0);
seq__12129_12170 = G__12182;
chunk__12130_12171 = G__12183;
count__12131_12172 = G__12184;
i__12132_12173 = G__12185;
continue;
} else {
var fld_12186 = cljs.core.first(seq__12129_12180__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12186," = ",fld_12186,";");


var G__12187 = cljs.core.next(seq__12129_12180__$1);
var G__12188 = null;
var G__12189 = (0);
var G__12190 = (0);
seq__12129_12170 = G__12187;
chunk__12130_12171 = G__12188;
count__12131_12172 = G__12189;
i__12132_12173 = G__12190;
continue;
}
} else {
}
}
break;
}

var seq__12133_12191 = cljs.core.seq(pmasks);
var chunk__12134_12192 = null;
var count__12135_12193 = (0);
var i__12136_12194 = (0);
while(true){
if((i__12136_12194 < count__12135_12193)){
var vec__12143_12195 = chunk__12134_12192.cljs$core$IIndexed$_nth$arity$2(null,i__12136_12194);
var pno_12196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12143_12195,(0),null);
var pmask_12197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12143_12195,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12196,"$ = ",pmask_12197,";");


var G__12198 = seq__12133_12191;
var G__12199 = chunk__12134_12192;
var G__12200 = count__12135_12193;
var G__12201 = (i__12136_12194 + (1));
seq__12133_12191 = G__12198;
chunk__12134_12192 = G__12199;
count__12135_12193 = G__12200;
i__12136_12194 = G__12201;
continue;
} else {
var temp__5753__auto___12202 = cljs.core.seq(seq__12133_12191);
if(temp__5753__auto___12202){
var seq__12133_12203__$1 = temp__5753__auto___12202;
if(cljs.core.chunked_seq_QMARK_(seq__12133_12203__$1)){
var c__4638__auto___12204 = cljs.core.chunk_first(seq__12133_12203__$1);
var G__12205 = cljs.core.chunk_rest(seq__12133_12203__$1);
var G__12206 = c__4638__auto___12204;
var G__12207 = cljs.core.count(c__4638__auto___12204);
var G__12208 = (0);
seq__12133_12191 = G__12205;
chunk__12134_12192 = G__12206;
count__12135_12193 = G__12207;
i__12136_12194 = G__12208;
continue;
} else {
var vec__12146_12209 = cljs.core.first(seq__12133_12203__$1);
var pno_12210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12146_12209,(0),null);
var pmask_12211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12146_12209,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12210,"$ = ",pmask_12211,";");


var G__12212 = cljs.core.next(seq__12133_12203__$1);
var G__12213 = null;
var G__12214 = (0);
var G__12215 = (0);
seq__12133_12191 = G__12212;
chunk__12134_12192 = G__12213;
count__12135_12193 = G__12214;
i__12136_12194 = G__12215;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__12216){
var map__12217 = p__12216;
var map__12217__$1 = cljs.core.__destructure_map(map__12217);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12217__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12217__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12217__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12217__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12217__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__12218){
var map__12219 = p__12218;
var map__12219__$1 = cljs.core.__destructure_map(map__12219);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12219__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12219__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12219__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12219__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12219__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4210__auto__ = code;
if(cljs.core.truth_(and__4210__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4210__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__12224 = cljs.core.seq(table);
var chunk__12225 = null;
var count__12226 = (0);
var i__12227 = (0);
while(true){
if((i__12227 < count__12226)){
var vec__12234 = chunk__12225.cljs$core$IIndexed$_nth$arity$2(null,i__12227);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12234,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12234,(1),null);
var ns_12240 = cljs.core.namespace(sym);
var name_12241 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12242 = seq__12224;
var G__12243 = chunk__12225;
var G__12244 = count__12226;
var G__12245 = (i__12227 + (1));
seq__12224 = G__12242;
chunk__12225 = G__12243;
count__12226 = G__12244;
i__12227 = G__12245;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12224);
if(temp__5753__auto__){
var seq__12224__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12224__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__12224__$1);
var G__12246 = cljs.core.chunk_rest(seq__12224__$1);
var G__12247 = c__4638__auto__;
var G__12248 = cljs.core.count(c__4638__auto__);
var G__12249 = (0);
seq__12224 = G__12246;
chunk__12225 = G__12247;
count__12226 = G__12248;
i__12227 = G__12249;
continue;
} else {
var vec__12237 = cljs.core.first(seq__12224__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12237,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12237,(1),null);
var ns_12250 = cljs.core.namespace(sym);
var name_12251 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12252 = cljs.core.next(seq__12224__$1);
var G__12253 = null;
var G__12254 = (0);
var G__12255 = (0);
seq__12224 = G__12252;
chunk__12225 = G__12253;
count__12226 = G__12254;
i__12227 = G__12255;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12257 = arguments.length;
switch (G__12257) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_12262 = cljs.core.first(ks);
var vec__12258_12263 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_12262);
var top_12264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12258_12263,(0),null);
var prefix_SINGLEQUOTE__12265 = vec__12258_12263;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_12262)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__12265) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_12264)) || (cljs.core.contains_QMARK_(known_externs,top_12264)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12265)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_12264);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12265)),";");
}
} else {
}

var m_12266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_12262);
if(cljs.core.empty_QMARK_(m_12266)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__12265,m_12266,top_level,known_externs);
}

var G__12267 = cljs.core.next(ks);
ks = G__12267;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

