// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__8741){
var vec__8742 = p__8741;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8742,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8742,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__8745 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__8748 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8748,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8748,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8748,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8748,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8748,(4),null);
var vec__8751 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8751,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8751,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8751,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8751,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8751,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4212__auto__ = source;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4212__auto__ = line;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4212__auto__ = col;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__8754 = segmap;
var map__8754__$1 = cljs.core.__destructure_map(map__8754);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__8756 = arguments.length;
switch (G__8756) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8760 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8764 = cljs.core.next(segs__$1);
var G__8765 = nrelseg;
var G__8766 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8764;
relseg__$1 = G__8765;
result__$1 = G__8766;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8760,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8760,(1),null);
var G__8767 = (gline + (1));
var G__8768 = cljs.core.next(lines__$1);
var G__8769 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8770 = result__$1;
gline = G__8767;
lines__$1 = G__8768;
relseg = G__8769;
result = G__8770;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__8772 = segmap;
var map__8772__$1 = cljs.core.__destructure_map(map__8772);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8772__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8772__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8772__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8772__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8772__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__8771_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__8771_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__8774 = arguments.length;
switch (G__8774) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8778 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8782 = cljs.core.next(segs__$1);
var G__8783 = nrelseg;
var G__8784 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8782;
relseg__$1 = G__8783;
result__$1 = G__8784;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8778,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8778,(1),null);
var G__8785 = (gline + (1));
var G__8786 = cljs.core.next(lines__$1);
var G__8787 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8788 = result__$1;
gline = G__8785;
lines__$1 = G__8786;
relseg = G__8787;
result = G__8788;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8789){
var vec__8790 = p__8789;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8790,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8790,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8790,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8790,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8790,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__8793){
var vec__8794 = p__8793;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8794,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8794,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8794,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8794,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8794,(4),null);
var seg = vec__8794;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8797){
var vec__8798 = p__8797;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8798,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8798,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8798,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8798,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8798,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__8804 = cljs.core.seq(infos);
var chunk__8805 = null;
var count__8806 = (0);
var i__8807 = (0);
while(true){
if((i__8807 < count__8806)){
var info = chunk__8805.cljs$core$IIndexed$_nth$arity$2(null,i__8807);
var segv_9158 = info__GT_segv(info,source_idx,line,col);
var gline_9159 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_9160 = cljs.core.count(cljs.core.deref(lines));
if((gline_9159 > (lc_9160 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8804,chunk__8805,count__8806,i__8807,segv_9158,gline_9159,lc_9160,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9159 - (lc_9160 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9158], null));
});})(seq__8804,chunk__8805,count__8806,i__8807,segv_9158,gline_9159,lc_9160,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8804,chunk__8805,count__8806,i__8807,segv_9158,gline_9159,lc_9160,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9159], null),cljs.core.conj,segv_9158);
});})(seq__8804,chunk__8805,count__8806,i__8807,segv_9158,gline_9159,lc_9160,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9161 = seq__8804;
var G__9162 = chunk__8805;
var G__9163 = count__8806;
var G__9164 = (i__8807 + (1));
seq__8804 = G__9161;
chunk__8805 = G__9162;
count__8806 = G__9163;
i__8807 = G__9164;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__8804);
if(temp__5753__auto__){
var seq__8804__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8804__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__8804__$1);
var G__9165 = cljs.core.chunk_rest(seq__8804__$1);
var G__9166 = c__4638__auto__;
var G__9167 = cljs.core.count(c__4638__auto__);
var G__9168 = (0);
seq__8804 = G__9165;
chunk__8805 = G__9166;
count__8806 = G__9167;
i__8807 = G__9168;
continue;
} else {
var info = cljs.core.first(seq__8804__$1);
var segv_9169 = info__GT_segv(info,source_idx,line,col);
var gline_9170 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_9171 = cljs.core.count(cljs.core.deref(lines));
if((gline_9170 > (lc_9171 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8804,chunk__8805,count__8806,i__8807,segv_9169,gline_9170,lc_9171,info,seq__8804__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9170 - (lc_9171 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9169], null));
});})(seq__8804,chunk__8805,count__8806,i__8807,segv_9169,gline_9170,lc_9171,info,seq__8804__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8804,chunk__8805,count__8806,i__8807,segv_9169,gline_9170,lc_9171,info,seq__8804__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9170], null),cljs.core.conj,segv_9169);
});})(seq__8804,chunk__8805,count__8806,i__8807,segv_9169,gline_9170,lc_9171,info,seq__8804__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9172 = cljs.core.next(seq__8804__$1);
var G__9173 = null;
var G__9174 = (0);
var G__9175 = (0);
seq__8804 = G__9172;
chunk__8805 = G__9173;
count__8806 = G__9174;
i__8807 = G__9175;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__8808_9176 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__8809_9177 = null;
var count__8810_9178 = (0);
var i__8811_9179 = (0);
while(true){
if((i__8811_9179 < count__8810_9178)){
var vec__8984_9180 = chunk__8809_9177.cljs$core$IIndexed$_nth$arity$2(null,i__8811_9179);
var source_idx_9181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8984_9180,(0),null);
var vec__8987_9182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8984_9180,(1),null);
var __9183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8987_9182,(0),null);
var lines_9184__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8987_9182,(1),null);
var seq__8990_9185 = cljs.core.seq(lines_9184__$1);
var chunk__8991_9186 = null;
var count__8992_9187 = (0);
var i__8993_9188 = (0);
while(true){
if((i__8993_9188 < count__8992_9187)){
var vec__9032_9189 = chunk__8991_9186.cljs$core$IIndexed$_nth$arity$2(null,i__8993_9188);
var line_9190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9032_9189,(0),null);
var cols_9191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9032_9189,(1),null);
var seq__9035_9192 = cljs.core.seq(cols_9191);
var chunk__9036_9193 = null;
var count__9037_9194 = (0);
var i__9038_9195 = (0);
while(true){
if((i__9038_9195 < count__9037_9194)){
var vec__9045_9196 = chunk__9036_9193.cljs$core$IIndexed$_nth$arity$2(null,i__9038_9195);
var col_9197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9045_9196,(0),null);
var infos_9198 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9045_9196,(1),null);
encode_cols(infos_9198,source_idx_9181,line_9190,col_9197);


var G__9199 = seq__9035_9192;
var G__9200 = chunk__9036_9193;
var G__9201 = count__9037_9194;
var G__9202 = (i__9038_9195 + (1));
seq__9035_9192 = G__9199;
chunk__9036_9193 = G__9200;
count__9037_9194 = G__9201;
i__9038_9195 = G__9202;
continue;
} else {
var temp__5753__auto___9203 = cljs.core.seq(seq__9035_9192);
if(temp__5753__auto___9203){
var seq__9035_9204__$1 = temp__5753__auto___9203;
if(cljs.core.chunked_seq_QMARK_(seq__9035_9204__$1)){
var c__4638__auto___9205 = cljs.core.chunk_first(seq__9035_9204__$1);
var G__9206 = cljs.core.chunk_rest(seq__9035_9204__$1);
var G__9207 = c__4638__auto___9205;
var G__9208 = cljs.core.count(c__4638__auto___9205);
var G__9209 = (0);
seq__9035_9192 = G__9206;
chunk__9036_9193 = G__9207;
count__9037_9194 = G__9208;
i__9038_9195 = G__9209;
continue;
} else {
var vec__9048_9210 = cljs.core.first(seq__9035_9204__$1);
var col_9211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9048_9210,(0),null);
var infos_9212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9048_9210,(1),null);
encode_cols(infos_9212,source_idx_9181,line_9190,col_9211);


var G__9213 = cljs.core.next(seq__9035_9204__$1);
var G__9214 = null;
var G__9215 = (0);
var G__9216 = (0);
seq__9035_9192 = G__9213;
chunk__9036_9193 = G__9214;
count__9037_9194 = G__9215;
i__9038_9195 = G__9216;
continue;
}
} else {
}
}
break;
}


var G__9217 = seq__8990_9185;
var G__9218 = chunk__8991_9186;
var G__9219 = count__8992_9187;
var G__9220 = (i__8993_9188 + (1));
seq__8990_9185 = G__9217;
chunk__8991_9186 = G__9218;
count__8992_9187 = G__9219;
i__8993_9188 = G__9220;
continue;
} else {
var temp__5753__auto___9221 = cljs.core.seq(seq__8990_9185);
if(temp__5753__auto___9221){
var seq__8990_9222__$1 = temp__5753__auto___9221;
if(cljs.core.chunked_seq_QMARK_(seq__8990_9222__$1)){
var c__4638__auto___9223 = cljs.core.chunk_first(seq__8990_9222__$1);
var G__9224 = cljs.core.chunk_rest(seq__8990_9222__$1);
var G__9225 = c__4638__auto___9223;
var G__9226 = cljs.core.count(c__4638__auto___9223);
var G__9227 = (0);
seq__8990_9185 = G__9224;
chunk__8991_9186 = G__9225;
count__8992_9187 = G__9226;
i__8993_9188 = G__9227;
continue;
} else {
var vec__9051_9228 = cljs.core.first(seq__8990_9222__$1);
var line_9229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9051_9228,(0),null);
var cols_9230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9051_9228,(1),null);
var seq__9054_9231 = cljs.core.seq(cols_9230);
var chunk__9055_9232 = null;
var count__9056_9233 = (0);
var i__9057_9234 = (0);
while(true){
if((i__9057_9234 < count__9056_9233)){
var vec__9064_9235 = chunk__9055_9232.cljs$core$IIndexed$_nth$arity$2(null,i__9057_9234);
var col_9236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9064_9235,(0),null);
var infos_9237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9064_9235,(1),null);
encode_cols(infos_9237,source_idx_9181,line_9229,col_9236);


var G__9238 = seq__9054_9231;
var G__9239 = chunk__9055_9232;
var G__9240 = count__9056_9233;
var G__9241 = (i__9057_9234 + (1));
seq__9054_9231 = G__9238;
chunk__9055_9232 = G__9239;
count__9056_9233 = G__9240;
i__9057_9234 = G__9241;
continue;
} else {
var temp__5753__auto___9242__$1 = cljs.core.seq(seq__9054_9231);
if(temp__5753__auto___9242__$1){
var seq__9054_9243__$1 = temp__5753__auto___9242__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9054_9243__$1)){
var c__4638__auto___9244 = cljs.core.chunk_first(seq__9054_9243__$1);
var G__9245 = cljs.core.chunk_rest(seq__9054_9243__$1);
var G__9246 = c__4638__auto___9244;
var G__9247 = cljs.core.count(c__4638__auto___9244);
var G__9248 = (0);
seq__9054_9231 = G__9245;
chunk__9055_9232 = G__9246;
count__9056_9233 = G__9247;
i__9057_9234 = G__9248;
continue;
} else {
var vec__9067_9249 = cljs.core.first(seq__9054_9243__$1);
var col_9250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9067_9249,(0),null);
var infos_9251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9067_9249,(1),null);
encode_cols(infos_9251,source_idx_9181,line_9229,col_9250);


var G__9252 = cljs.core.next(seq__9054_9243__$1);
var G__9253 = null;
var G__9254 = (0);
var G__9255 = (0);
seq__9054_9231 = G__9252;
chunk__9055_9232 = G__9253;
count__9056_9233 = G__9254;
i__9057_9234 = G__9255;
continue;
}
} else {
}
}
break;
}


var G__9256 = cljs.core.next(seq__8990_9222__$1);
var G__9257 = null;
var G__9258 = (0);
var G__9259 = (0);
seq__8990_9185 = G__9256;
chunk__8991_9186 = G__9257;
count__8992_9187 = G__9258;
i__8993_9188 = G__9259;
continue;
}
} else {
}
}
break;
}


var G__9260 = seq__8808_9176;
var G__9261 = chunk__8809_9177;
var G__9262 = count__8810_9178;
var G__9263 = (i__8811_9179 + (1));
seq__8808_9176 = G__9260;
chunk__8809_9177 = G__9261;
count__8810_9178 = G__9262;
i__8811_9179 = G__9263;
continue;
} else {
var temp__5753__auto___9264 = cljs.core.seq(seq__8808_9176);
if(temp__5753__auto___9264){
var seq__8808_9265__$1 = temp__5753__auto___9264;
if(cljs.core.chunked_seq_QMARK_(seq__8808_9265__$1)){
var c__4638__auto___9266 = cljs.core.chunk_first(seq__8808_9265__$1);
var G__9267 = cljs.core.chunk_rest(seq__8808_9265__$1);
var G__9268 = c__4638__auto___9266;
var G__9269 = cljs.core.count(c__4638__auto___9266);
var G__9270 = (0);
seq__8808_9176 = G__9267;
chunk__8809_9177 = G__9268;
count__8810_9178 = G__9269;
i__8811_9179 = G__9270;
continue;
} else {
var vec__9070_9271 = cljs.core.first(seq__8808_9265__$1);
var source_idx_9272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9070_9271,(0),null);
var vec__9073_9273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9070_9271,(1),null);
var __9274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9073_9273,(0),null);
var lines_9275__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9073_9273,(1),null);
var seq__9076_9276 = cljs.core.seq(lines_9275__$1);
var chunk__9077_9277 = null;
var count__9078_9278 = (0);
var i__9079_9279 = (0);
while(true){
if((i__9079_9279 < count__9078_9278)){
var vec__9118_9280 = chunk__9077_9277.cljs$core$IIndexed$_nth$arity$2(null,i__9079_9279);
var line_9281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9118_9280,(0),null);
var cols_9282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9118_9280,(1),null);
var seq__9121_9283 = cljs.core.seq(cols_9282);
var chunk__9122_9284 = null;
var count__9123_9285 = (0);
var i__9124_9286 = (0);
while(true){
if((i__9124_9286 < count__9123_9285)){
var vec__9131_9287 = chunk__9122_9284.cljs$core$IIndexed$_nth$arity$2(null,i__9124_9286);
var col_9288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9131_9287,(0),null);
var infos_9289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9131_9287,(1),null);
encode_cols(infos_9289,source_idx_9272,line_9281,col_9288);


var G__9290 = seq__9121_9283;
var G__9291 = chunk__9122_9284;
var G__9292 = count__9123_9285;
var G__9293 = (i__9124_9286 + (1));
seq__9121_9283 = G__9290;
chunk__9122_9284 = G__9291;
count__9123_9285 = G__9292;
i__9124_9286 = G__9293;
continue;
} else {
var temp__5753__auto___9294__$1 = cljs.core.seq(seq__9121_9283);
if(temp__5753__auto___9294__$1){
var seq__9121_9295__$1 = temp__5753__auto___9294__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9121_9295__$1)){
var c__4638__auto___9296 = cljs.core.chunk_first(seq__9121_9295__$1);
var G__9297 = cljs.core.chunk_rest(seq__9121_9295__$1);
var G__9298 = c__4638__auto___9296;
var G__9299 = cljs.core.count(c__4638__auto___9296);
var G__9300 = (0);
seq__9121_9283 = G__9297;
chunk__9122_9284 = G__9298;
count__9123_9285 = G__9299;
i__9124_9286 = G__9300;
continue;
} else {
var vec__9134_9301 = cljs.core.first(seq__9121_9295__$1);
var col_9302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9134_9301,(0),null);
var infos_9303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9134_9301,(1),null);
encode_cols(infos_9303,source_idx_9272,line_9281,col_9302);


var G__9304 = cljs.core.next(seq__9121_9295__$1);
var G__9305 = null;
var G__9306 = (0);
var G__9307 = (0);
seq__9121_9283 = G__9304;
chunk__9122_9284 = G__9305;
count__9123_9285 = G__9306;
i__9124_9286 = G__9307;
continue;
}
} else {
}
}
break;
}


var G__9308 = seq__9076_9276;
var G__9309 = chunk__9077_9277;
var G__9310 = count__9078_9278;
var G__9311 = (i__9079_9279 + (1));
seq__9076_9276 = G__9308;
chunk__9077_9277 = G__9309;
count__9078_9278 = G__9310;
i__9079_9279 = G__9311;
continue;
} else {
var temp__5753__auto___9312__$1 = cljs.core.seq(seq__9076_9276);
if(temp__5753__auto___9312__$1){
var seq__9076_9313__$1 = temp__5753__auto___9312__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9076_9313__$1)){
var c__4638__auto___9314 = cljs.core.chunk_first(seq__9076_9313__$1);
var G__9315 = cljs.core.chunk_rest(seq__9076_9313__$1);
var G__9316 = c__4638__auto___9314;
var G__9317 = cljs.core.count(c__4638__auto___9314);
var G__9318 = (0);
seq__9076_9276 = G__9315;
chunk__9077_9277 = G__9316;
count__9078_9278 = G__9317;
i__9079_9279 = G__9318;
continue;
} else {
var vec__9137_9319 = cljs.core.first(seq__9076_9313__$1);
var line_9320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9137_9319,(0),null);
var cols_9321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9137_9319,(1),null);
var seq__9140_9322 = cljs.core.seq(cols_9321);
var chunk__9141_9323 = null;
var count__9142_9324 = (0);
var i__9143_9325 = (0);
while(true){
if((i__9143_9325 < count__9142_9324)){
var vec__9150_9326 = chunk__9141_9323.cljs$core$IIndexed$_nth$arity$2(null,i__9143_9325);
var col_9327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9150_9326,(0),null);
var infos_9328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9150_9326,(1),null);
encode_cols(infos_9328,source_idx_9272,line_9320,col_9327);


var G__9329 = seq__9140_9322;
var G__9330 = chunk__9141_9323;
var G__9331 = count__9142_9324;
var G__9332 = (i__9143_9325 + (1));
seq__9140_9322 = G__9329;
chunk__9141_9323 = G__9330;
count__9142_9324 = G__9331;
i__9143_9325 = G__9332;
continue;
} else {
var temp__5753__auto___9333__$2 = cljs.core.seq(seq__9140_9322);
if(temp__5753__auto___9333__$2){
var seq__9140_9334__$1 = temp__5753__auto___9333__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9140_9334__$1)){
var c__4638__auto___9335 = cljs.core.chunk_first(seq__9140_9334__$1);
var G__9336 = cljs.core.chunk_rest(seq__9140_9334__$1);
var G__9337 = c__4638__auto___9335;
var G__9338 = cljs.core.count(c__4638__auto___9335);
var G__9339 = (0);
seq__9140_9322 = G__9336;
chunk__9141_9323 = G__9337;
count__9142_9324 = G__9338;
i__9143_9325 = G__9339;
continue;
} else {
var vec__9153_9340 = cljs.core.first(seq__9140_9334__$1);
var col_9341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9153_9340,(0),null);
var infos_9342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9153_9340,(1),null);
encode_cols(infos_9342,source_idx_9272,line_9320,col_9341);


var G__9343 = cljs.core.next(seq__9140_9334__$1);
var G__9344 = null;
var G__9345 = (0);
var G__9346 = (0);
seq__9140_9322 = G__9343;
chunk__9141_9323 = G__9344;
count__9142_9324 = G__9345;
i__9143_9325 = G__9346;
continue;
}
} else {
}
}
break;
}


var G__9347 = cljs.core.next(seq__9076_9313__$1);
var G__9348 = null;
var G__9349 = (0);
var G__9350 = (0);
seq__9076_9276 = G__9347;
chunk__9077_9277 = G__9348;
count__9078_9278 = G__9349;
i__9079_9279 = G__9350;
continue;
}
} else {
}
}
break;
}


var G__9351 = cljs.core.next(seq__8808_9265__$1);
var G__9352 = null;
var G__9353 = (0);
var G__9354 = (0);
seq__8808_9176 = G__9351;
chunk__8809_9177 = G__9352;
count__8810_9178 = G__9353;
i__8811_9179 = G__9354;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__9156 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__8801_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__8801_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__8802_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__8802_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__8803_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__8803_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__9157 = G__9156;
goog.object.set(G__9157,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__9157;
} else {
return G__9156;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__9355 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9355,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9355,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__9358 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9358,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9358,(1),null);
var G__9363 = cljs.core.next(col_map_seq);
var G__9364 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__9358,col,infos,vec__9355,line,col_map){
return (function (v,p__9361){
var map__9362 = p__9361;
var map__9362__$1 = cljs.core.__destructure_map(map__9362);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9362__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9362__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__9358,col,infos,vec__9355,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__9363;
new_cols = G__9364;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__9365 = cljs.core.next(line_map_seq);
var G__9366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__9365;
new_lines = G__9366;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__9367_9575 = cljs.core.seq(reverse_map);
var chunk__9368_9576 = null;
var count__9369_9577 = (0);
var i__9370_9578 = (0);
while(true){
if((i__9370_9578 < count__9369_9577)){
var vec__9473_9579 = chunk__9368_9576.cljs$core$IIndexed$_nth$arity$2(null,i__9370_9578);
var line_9580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9473_9579,(0),null);
var columns_9581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9473_9579,(1),null);
var seq__9476_9582 = cljs.core.seq(columns_9581);
var chunk__9477_9583 = null;
var count__9478_9584 = (0);
var i__9479_9585 = (0);
while(true){
if((i__9479_9585 < count__9478_9584)){
var vec__9502_9586 = chunk__9477_9583.cljs$core$IIndexed$_nth$arity$2(null,i__9479_9585);
var column_9587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9502_9586,(0),null);
var column_info_9588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9502_9586,(1),null);
var seq__9505_9589 = cljs.core.seq(column_info_9588);
var chunk__9506_9590 = null;
var count__9507_9591 = (0);
var i__9508_9592 = (0);
while(true){
if((i__9508_9592 < count__9507_9591)){
var map__9511_9593 = chunk__9506_9590.cljs$core$IIndexed$_nth$arity$2(null,i__9508_9592);
var map__9511_9594__$1 = cljs.core.__destructure_map(map__9511_9593);
var gline_9595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9511_9594__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9511_9594__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9511_9594__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9595], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9505_9589,chunk__9506_9590,count__9507_9591,i__9508_9592,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9511_9593,map__9511_9594__$1,gline_9595,gcol_9596,name_9597,vec__9502_9586,column_9587,column_info_9588,vec__9473_9579,line_9580,columns_9581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9596], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9580,new cljs.core.Keyword(null,"col","col",-1959363084),column_9587,new cljs.core.Keyword(null,"name","name",1843675177),name_9597], null));
});})(seq__9505_9589,chunk__9506_9590,count__9507_9591,i__9508_9592,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9511_9593,map__9511_9594__$1,gline_9595,gcol_9596,name_9597,vec__9502_9586,column_9587,column_info_9588,vec__9473_9579,line_9580,columns_9581,inverted))
,cljs.core.sorted_map()));


var G__9598 = seq__9505_9589;
var G__9599 = chunk__9506_9590;
var G__9600 = count__9507_9591;
var G__9601 = (i__9508_9592 + (1));
seq__9505_9589 = G__9598;
chunk__9506_9590 = G__9599;
count__9507_9591 = G__9600;
i__9508_9592 = G__9601;
continue;
} else {
var temp__5753__auto___9602 = cljs.core.seq(seq__9505_9589);
if(temp__5753__auto___9602){
var seq__9505_9603__$1 = temp__5753__auto___9602;
if(cljs.core.chunked_seq_QMARK_(seq__9505_9603__$1)){
var c__4638__auto___9604 = cljs.core.chunk_first(seq__9505_9603__$1);
var G__9605 = cljs.core.chunk_rest(seq__9505_9603__$1);
var G__9606 = c__4638__auto___9604;
var G__9607 = cljs.core.count(c__4638__auto___9604);
var G__9608 = (0);
seq__9505_9589 = G__9605;
chunk__9506_9590 = G__9606;
count__9507_9591 = G__9607;
i__9508_9592 = G__9608;
continue;
} else {
var map__9512_9609 = cljs.core.first(seq__9505_9603__$1);
var map__9512_9610__$1 = cljs.core.__destructure_map(map__9512_9609);
var gline_9611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9512_9610__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9512_9610__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9512_9610__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9611], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9505_9589,chunk__9506_9590,count__9507_9591,i__9508_9592,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9512_9609,map__9512_9610__$1,gline_9611,gcol_9612,name_9613,seq__9505_9603__$1,temp__5753__auto___9602,vec__9502_9586,column_9587,column_info_9588,vec__9473_9579,line_9580,columns_9581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9612], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9580,new cljs.core.Keyword(null,"col","col",-1959363084),column_9587,new cljs.core.Keyword(null,"name","name",1843675177),name_9613], null));
});})(seq__9505_9589,chunk__9506_9590,count__9507_9591,i__9508_9592,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9512_9609,map__9512_9610__$1,gline_9611,gcol_9612,name_9613,seq__9505_9603__$1,temp__5753__auto___9602,vec__9502_9586,column_9587,column_info_9588,vec__9473_9579,line_9580,columns_9581,inverted))
,cljs.core.sorted_map()));


var G__9614 = cljs.core.next(seq__9505_9603__$1);
var G__9615 = null;
var G__9616 = (0);
var G__9617 = (0);
seq__9505_9589 = G__9614;
chunk__9506_9590 = G__9615;
count__9507_9591 = G__9616;
i__9508_9592 = G__9617;
continue;
}
} else {
}
}
break;
}


var G__9618 = seq__9476_9582;
var G__9619 = chunk__9477_9583;
var G__9620 = count__9478_9584;
var G__9621 = (i__9479_9585 + (1));
seq__9476_9582 = G__9618;
chunk__9477_9583 = G__9619;
count__9478_9584 = G__9620;
i__9479_9585 = G__9621;
continue;
} else {
var temp__5753__auto___9622 = cljs.core.seq(seq__9476_9582);
if(temp__5753__auto___9622){
var seq__9476_9623__$1 = temp__5753__auto___9622;
if(cljs.core.chunked_seq_QMARK_(seq__9476_9623__$1)){
var c__4638__auto___9624 = cljs.core.chunk_first(seq__9476_9623__$1);
var G__9625 = cljs.core.chunk_rest(seq__9476_9623__$1);
var G__9626 = c__4638__auto___9624;
var G__9627 = cljs.core.count(c__4638__auto___9624);
var G__9628 = (0);
seq__9476_9582 = G__9625;
chunk__9477_9583 = G__9626;
count__9478_9584 = G__9627;
i__9479_9585 = G__9628;
continue;
} else {
var vec__9513_9629 = cljs.core.first(seq__9476_9623__$1);
var column_9630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9513_9629,(0),null);
var column_info_9631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9513_9629,(1),null);
var seq__9516_9632 = cljs.core.seq(column_info_9631);
var chunk__9517_9633 = null;
var count__9518_9634 = (0);
var i__9519_9635 = (0);
while(true){
if((i__9519_9635 < count__9518_9634)){
var map__9522_9636 = chunk__9517_9633.cljs$core$IIndexed$_nth$arity$2(null,i__9519_9635);
var map__9522_9637__$1 = cljs.core.__destructure_map(map__9522_9636);
var gline_9638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9522_9637__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9522_9637__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9522_9637__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9638], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9516_9632,chunk__9517_9633,count__9518_9634,i__9519_9635,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9522_9636,map__9522_9637__$1,gline_9638,gcol_9639,name_9640,vec__9513_9629,column_9630,column_info_9631,seq__9476_9623__$1,temp__5753__auto___9622,vec__9473_9579,line_9580,columns_9581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9639], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9580,new cljs.core.Keyword(null,"col","col",-1959363084),column_9630,new cljs.core.Keyword(null,"name","name",1843675177),name_9640], null));
});})(seq__9516_9632,chunk__9517_9633,count__9518_9634,i__9519_9635,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9522_9636,map__9522_9637__$1,gline_9638,gcol_9639,name_9640,vec__9513_9629,column_9630,column_info_9631,seq__9476_9623__$1,temp__5753__auto___9622,vec__9473_9579,line_9580,columns_9581,inverted))
,cljs.core.sorted_map()));


var G__9641 = seq__9516_9632;
var G__9642 = chunk__9517_9633;
var G__9643 = count__9518_9634;
var G__9644 = (i__9519_9635 + (1));
seq__9516_9632 = G__9641;
chunk__9517_9633 = G__9642;
count__9518_9634 = G__9643;
i__9519_9635 = G__9644;
continue;
} else {
var temp__5753__auto___9645__$1 = cljs.core.seq(seq__9516_9632);
if(temp__5753__auto___9645__$1){
var seq__9516_9646__$1 = temp__5753__auto___9645__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9516_9646__$1)){
var c__4638__auto___9647 = cljs.core.chunk_first(seq__9516_9646__$1);
var G__9648 = cljs.core.chunk_rest(seq__9516_9646__$1);
var G__9649 = c__4638__auto___9647;
var G__9650 = cljs.core.count(c__4638__auto___9647);
var G__9651 = (0);
seq__9516_9632 = G__9648;
chunk__9517_9633 = G__9649;
count__9518_9634 = G__9650;
i__9519_9635 = G__9651;
continue;
} else {
var map__9523_9652 = cljs.core.first(seq__9516_9646__$1);
var map__9523_9653__$1 = cljs.core.__destructure_map(map__9523_9652);
var gline_9654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9523_9653__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9523_9653__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9523_9653__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9654], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9516_9632,chunk__9517_9633,count__9518_9634,i__9519_9635,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9523_9652,map__9523_9653__$1,gline_9654,gcol_9655,name_9656,seq__9516_9646__$1,temp__5753__auto___9645__$1,vec__9513_9629,column_9630,column_info_9631,seq__9476_9623__$1,temp__5753__auto___9622,vec__9473_9579,line_9580,columns_9581,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9655], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9580,new cljs.core.Keyword(null,"col","col",-1959363084),column_9630,new cljs.core.Keyword(null,"name","name",1843675177),name_9656], null));
});})(seq__9516_9632,chunk__9517_9633,count__9518_9634,i__9519_9635,seq__9476_9582,chunk__9477_9583,count__9478_9584,i__9479_9585,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9523_9652,map__9523_9653__$1,gline_9654,gcol_9655,name_9656,seq__9516_9646__$1,temp__5753__auto___9645__$1,vec__9513_9629,column_9630,column_info_9631,seq__9476_9623__$1,temp__5753__auto___9622,vec__9473_9579,line_9580,columns_9581,inverted))
,cljs.core.sorted_map()));


var G__9657 = cljs.core.next(seq__9516_9646__$1);
var G__9658 = null;
var G__9659 = (0);
var G__9660 = (0);
seq__9516_9632 = G__9657;
chunk__9517_9633 = G__9658;
count__9518_9634 = G__9659;
i__9519_9635 = G__9660;
continue;
}
} else {
}
}
break;
}


var G__9661 = cljs.core.next(seq__9476_9623__$1);
var G__9662 = null;
var G__9663 = (0);
var G__9664 = (0);
seq__9476_9582 = G__9661;
chunk__9477_9583 = G__9662;
count__9478_9584 = G__9663;
i__9479_9585 = G__9664;
continue;
}
} else {
}
}
break;
}


var G__9665 = seq__9367_9575;
var G__9666 = chunk__9368_9576;
var G__9667 = count__9369_9577;
var G__9668 = (i__9370_9578 + (1));
seq__9367_9575 = G__9665;
chunk__9368_9576 = G__9666;
count__9369_9577 = G__9667;
i__9370_9578 = G__9668;
continue;
} else {
var temp__5753__auto___9669 = cljs.core.seq(seq__9367_9575);
if(temp__5753__auto___9669){
var seq__9367_9670__$1 = temp__5753__auto___9669;
if(cljs.core.chunked_seq_QMARK_(seq__9367_9670__$1)){
var c__4638__auto___9671 = cljs.core.chunk_first(seq__9367_9670__$1);
var G__9672 = cljs.core.chunk_rest(seq__9367_9670__$1);
var G__9673 = c__4638__auto___9671;
var G__9674 = cljs.core.count(c__4638__auto___9671);
var G__9675 = (0);
seq__9367_9575 = G__9672;
chunk__9368_9576 = G__9673;
count__9369_9577 = G__9674;
i__9370_9578 = G__9675;
continue;
} else {
var vec__9524_9676 = cljs.core.first(seq__9367_9670__$1);
var line_9677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9524_9676,(0),null);
var columns_9678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9524_9676,(1),null);
var seq__9527_9679 = cljs.core.seq(columns_9678);
var chunk__9528_9680 = null;
var count__9529_9681 = (0);
var i__9530_9682 = (0);
while(true){
if((i__9530_9682 < count__9529_9681)){
var vec__9553_9683 = chunk__9528_9680.cljs$core$IIndexed$_nth$arity$2(null,i__9530_9682);
var column_9684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9553_9683,(0),null);
var column_info_9685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9553_9683,(1),null);
var seq__9556_9686 = cljs.core.seq(column_info_9685);
var chunk__9557_9687 = null;
var count__9558_9688 = (0);
var i__9559_9689 = (0);
while(true){
if((i__9559_9689 < count__9558_9688)){
var map__9562_9690 = chunk__9557_9687.cljs$core$IIndexed$_nth$arity$2(null,i__9559_9689);
var map__9562_9691__$1 = cljs.core.__destructure_map(map__9562_9690);
var gline_9692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9562_9691__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9562_9691__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9562_9691__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9692], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9556_9686,chunk__9557_9687,count__9558_9688,i__9559_9689,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9562_9690,map__9562_9691__$1,gline_9692,gcol_9693,name_9694,vec__9553_9683,column_9684,column_info_9685,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9693], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9677,new cljs.core.Keyword(null,"col","col",-1959363084),column_9684,new cljs.core.Keyword(null,"name","name",1843675177),name_9694], null));
});})(seq__9556_9686,chunk__9557_9687,count__9558_9688,i__9559_9689,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9562_9690,map__9562_9691__$1,gline_9692,gcol_9693,name_9694,vec__9553_9683,column_9684,column_info_9685,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted))
,cljs.core.sorted_map()));


var G__9695 = seq__9556_9686;
var G__9696 = chunk__9557_9687;
var G__9697 = count__9558_9688;
var G__9698 = (i__9559_9689 + (1));
seq__9556_9686 = G__9695;
chunk__9557_9687 = G__9696;
count__9558_9688 = G__9697;
i__9559_9689 = G__9698;
continue;
} else {
var temp__5753__auto___9699__$1 = cljs.core.seq(seq__9556_9686);
if(temp__5753__auto___9699__$1){
var seq__9556_9700__$1 = temp__5753__auto___9699__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9556_9700__$1)){
var c__4638__auto___9701 = cljs.core.chunk_first(seq__9556_9700__$1);
var G__9702 = cljs.core.chunk_rest(seq__9556_9700__$1);
var G__9703 = c__4638__auto___9701;
var G__9704 = cljs.core.count(c__4638__auto___9701);
var G__9705 = (0);
seq__9556_9686 = G__9702;
chunk__9557_9687 = G__9703;
count__9558_9688 = G__9704;
i__9559_9689 = G__9705;
continue;
} else {
var map__9563_9706 = cljs.core.first(seq__9556_9700__$1);
var map__9563_9707__$1 = cljs.core.__destructure_map(map__9563_9706);
var gline_9708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9563_9707__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9563_9707__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9563_9707__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9708], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9556_9686,chunk__9557_9687,count__9558_9688,i__9559_9689,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9563_9706,map__9563_9707__$1,gline_9708,gcol_9709,name_9710,seq__9556_9700__$1,temp__5753__auto___9699__$1,vec__9553_9683,column_9684,column_info_9685,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9709], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9677,new cljs.core.Keyword(null,"col","col",-1959363084),column_9684,new cljs.core.Keyword(null,"name","name",1843675177),name_9710], null));
});})(seq__9556_9686,chunk__9557_9687,count__9558_9688,i__9559_9689,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9563_9706,map__9563_9707__$1,gline_9708,gcol_9709,name_9710,seq__9556_9700__$1,temp__5753__auto___9699__$1,vec__9553_9683,column_9684,column_info_9685,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted))
,cljs.core.sorted_map()));


var G__9711 = cljs.core.next(seq__9556_9700__$1);
var G__9712 = null;
var G__9713 = (0);
var G__9714 = (0);
seq__9556_9686 = G__9711;
chunk__9557_9687 = G__9712;
count__9558_9688 = G__9713;
i__9559_9689 = G__9714;
continue;
}
} else {
}
}
break;
}


var G__9715 = seq__9527_9679;
var G__9716 = chunk__9528_9680;
var G__9717 = count__9529_9681;
var G__9718 = (i__9530_9682 + (1));
seq__9527_9679 = G__9715;
chunk__9528_9680 = G__9716;
count__9529_9681 = G__9717;
i__9530_9682 = G__9718;
continue;
} else {
var temp__5753__auto___9719__$1 = cljs.core.seq(seq__9527_9679);
if(temp__5753__auto___9719__$1){
var seq__9527_9720__$1 = temp__5753__auto___9719__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9527_9720__$1)){
var c__4638__auto___9721 = cljs.core.chunk_first(seq__9527_9720__$1);
var G__9722 = cljs.core.chunk_rest(seq__9527_9720__$1);
var G__9723 = c__4638__auto___9721;
var G__9724 = cljs.core.count(c__4638__auto___9721);
var G__9725 = (0);
seq__9527_9679 = G__9722;
chunk__9528_9680 = G__9723;
count__9529_9681 = G__9724;
i__9530_9682 = G__9725;
continue;
} else {
var vec__9564_9726 = cljs.core.first(seq__9527_9720__$1);
var column_9727 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9564_9726,(0),null);
var column_info_9728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9564_9726,(1),null);
var seq__9567_9729 = cljs.core.seq(column_info_9728);
var chunk__9568_9730 = null;
var count__9569_9731 = (0);
var i__9570_9732 = (0);
while(true){
if((i__9570_9732 < count__9569_9731)){
var map__9573_9733 = chunk__9568_9730.cljs$core$IIndexed$_nth$arity$2(null,i__9570_9732);
var map__9573_9734__$1 = cljs.core.__destructure_map(map__9573_9733);
var gline_9735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9573_9734__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9573_9734__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9573_9734__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9735], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9567_9729,chunk__9568_9730,count__9569_9731,i__9570_9732,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9573_9733,map__9573_9734__$1,gline_9735,gcol_9736,name_9737,vec__9564_9726,column_9727,column_info_9728,seq__9527_9720__$1,temp__5753__auto___9719__$1,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9736], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9677,new cljs.core.Keyword(null,"col","col",-1959363084),column_9727,new cljs.core.Keyword(null,"name","name",1843675177),name_9737], null));
});})(seq__9567_9729,chunk__9568_9730,count__9569_9731,i__9570_9732,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9573_9733,map__9573_9734__$1,gline_9735,gcol_9736,name_9737,vec__9564_9726,column_9727,column_info_9728,seq__9527_9720__$1,temp__5753__auto___9719__$1,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted))
,cljs.core.sorted_map()));


var G__9738 = seq__9567_9729;
var G__9739 = chunk__9568_9730;
var G__9740 = count__9569_9731;
var G__9741 = (i__9570_9732 + (1));
seq__9567_9729 = G__9738;
chunk__9568_9730 = G__9739;
count__9569_9731 = G__9740;
i__9570_9732 = G__9741;
continue;
} else {
var temp__5753__auto___9742__$2 = cljs.core.seq(seq__9567_9729);
if(temp__5753__auto___9742__$2){
var seq__9567_9743__$1 = temp__5753__auto___9742__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9567_9743__$1)){
var c__4638__auto___9744 = cljs.core.chunk_first(seq__9567_9743__$1);
var G__9745 = cljs.core.chunk_rest(seq__9567_9743__$1);
var G__9746 = c__4638__auto___9744;
var G__9747 = cljs.core.count(c__4638__auto___9744);
var G__9748 = (0);
seq__9567_9729 = G__9745;
chunk__9568_9730 = G__9746;
count__9569_9731 = G__9747;
i__9570_9732 = G__9748;
continue;
} else {
var map__9574_9749 = cljs.core.first(seq__9567_9743__$1);
var map__9574_9750__$1 = cljs.core.__destructure_map(map__9574_9749);
var gline_9751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9574_9750__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9574_9750__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9574_9750__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9751], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9567_9729,chunk__9568_9730,count__9569_9731,i__9570_9732,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9574_9749,map__9574_9750__$1,gline_9751,gcol_9752,name_9753,seq__9567_9743__$1,temp__5753__auto___9742__$2,vec__9564_9726,column_9727,column_info_9728,seq__9527_9720__$1,temp__5753__auto___9719__$1,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9752], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9677,new cljs.core.Keyword(null,"col","col",-1959363084),column_9727,new cljs.core.Keyword(null,"name","name",1843675177),name_9753], null));
});})(seq__9567_9729,chunk__9568_9730,count__9569_9731,i__9570_9732,seq__9527_9679,chunk__9528_9680,count__9529_9681,i__9530_9682,seq__9367_9575,chunk__9368_9576,count__9369_9577,i__9370_9578,map__9574_9749,map__9574_9750__$1,gline_9751,gcol_9752,name_9753,seq__9567_9743__$1,temp__5753__auto___9742__$2,vec__9564_9726,column_9727,column_info_9728,seq__9527_9720__$1,temp__5753__auto___9719__$1,vec__9524_9676,line_9677,columns_9678,seq__9367_9670__$1,temp__5753__auto___9669,inverted))
,cljs.core.sorted_map()));


var G__9754 = cljs.core.next(seq__9567_9743__$1);
var G__9755 = null;
var G__9756 = (0);
var G__9757 = (0);
seq__9567_9729 = G__9754;
chunk__9568_9730 = G__9755;
count__9569_9731 = G__9756;
i__9570_9732 = G__9757;
continue;
}
} else {
}
}
break;
}


var G__9758 = cljs.core.next(seq__9527_9720__$1);
var G__9759 = null;
var G__9760 = (0);
var G__9761 = (0);
seq__9527_9679 = G__9758;
chunk__9528_9680 = G__9759;
count__9529_9681 = G__9760;
i__9530_9682 = G__9761;
continue;
}
} else {
}
}
break;
}


var G__9762 = cljs.core.next(seq__9367_9670__$1);
var G__9763 = null;
var G__9764 = (0);
var G__9765 = (0);
seq__9367_9575 = G__9762;
chunk__9368_9576 = G__9763;
count__9369_9577 = G__9764;
i__9370_9578 = G__9765;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
