// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4824__auto__ = [];
var len__4818__auto___4074 = arguments.length;
var i__4819__auto___4075 = (0);
while(true){
if((i__4819__auto___4075 < len__4818__auto___4074)){
args__4824__auto__.push((arguments[i__4819__auto___4075]));

var G__4076 = (i__4819__auto___4075 + (1));
i__4819__auto___4075 = G__4076;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__4068){
var vec__4069 = p__4068;
var map__4072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4069,(0),null);
var map__4072__$1 = cljs.core.__destructure_map(map__4072);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4072__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4072__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__4073 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__4073__$1 = (((G__4073 instanceof cljs.core.Keyword))?G__4073.fqn:null);
switch (G__4073__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__4073__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq4065){
var G__4066 = cljs.core.first(seq4065);
var seq4065__$1 = cljs.core.next(seq4065);
var G__4067 = cljs.core.first(seq4065__$1);
var seq4065__$2 = cljs.core.next(seq4065__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4066,G__4067,seq4065__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4824__auto__ = [];
var len__4818__auto___4089 = arguments.length;
var i__4819__auto___4090 = (0);
while(true){
if((i__4819__auto___4090 < len__4818__auto___4089)){
args__4824__auto__.push((arguments[i__4819__auto___4090]));

var G__4091 = (i__4819__auto___4090 + (1));
i__4819__auto___4090 = G__4091;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__4082){
var vec__4083 = p__4082;
var map__4086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4083,(0),null);
var map__4086__$1 = cljs.core.__destructure_map(map__4086);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4086__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4086__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__4086__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__4087 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__4087__$1 = (((G__4087 instanceof cljs.core.Keyword))?G__4087.fqn:null);
switch (G__4087__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__4087__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__4088 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__4088__$1 = (((G__4088 instanceof cljs.core.Keyword))?G__4088.fqn:null);
switch (G__4088__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__4088__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq4079){
var G__4080 = cljs.core.first(seq4079);
var seq4079__$1 = cljs.core.next(seq4079);
var G__4081 = cljs.core.first(seq4079__$1);
var seq4079__$2 = cljs.core.next(seq4079__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4080,G__4081,seq4079__$2);
}));

