// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__87260 = arguments.length;
switch (G__87260) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___87299 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87281){
var state_val_87282 = (state_87281[(1)]);
if((state_val_87282 === (1))){
var state_87281__$1 = state_87281;
var statearr_87283_87300 = state_87281__$1;
(statearr_87283_87300[(2)] = null);

(statearr_87283_87300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87282 === (2))){
var _ = (function (){var statearr_87284 = state_87281;
(statearr_87284[(4)] = cljs.core.cons((5),(state_87281[(4)])));

return statearr_87284;
})();
var inst_87267 = fluree.db.session.db(conn,ledger,null);
var state_87281__$1 = state_87281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87281__$1,(7),inst_87267);
} else {
if((state_val_87282 === (3))){
var inst_87277 = (state_87281[(2)]);
var inst_87278 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_87277);
var inst_87279 = cljs.core.async.close_BANG_(pc);
var state_87281__$1 = (function (){var statearr_87286 = state_87281;
(statearr_87286[(7)] = inst_87278);

return statearr_87286;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_87281__$1,inst_87279);
} else {
if((state_val_87282 === (4))){
var inst_87261 = (state_87281[(2)]);
var state_87281__$1 = state_87281;
var statearr_87287_87301 = state_87281__$1;
(statearr_87287_87301[(2)] = inst_87261);

(statearr_87287_87301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87282 === (5))){
var _ = (function (){var statearr_87288 = state_87281;
(statearr_87288[(4)] = cljs.core.rest((state_87281[(4)])));

return statearr_87288;
})();
var state_87281__$1 = state_87281;
var ex87285 = (state_87281__$1[(2)]);
var statearr_87289_87302 = state_87281__$1;
(statearr_87289_87302[(5)] = ex87285);


var statearr_87290_87303 = state_87281__$1;
(statearr_87290_87303[(1)] = (4));

(statearr_87290_87303[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87282 === (6))){
var inst_87273 = (state_87281[(2)]);
var inst_87274 = fluree.db.util.async.throw_err(inst_87273);
var _ = (function (){var statearr_87291 = state_87281;
(statearr_87291[(4)] = cljs.core.rest((state_87281[(4)])));

return statearr_87291;
})();
var state_87281__$1 = state_87281;
var statearr_87292_87304 = state_87281__$1;
(statearr_87292_87304[(2)] = inst_87274);

(statearr_87292_87304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87282 === (7))){
var inst_87269 = (state_87281[(2)]);
var inst_87270 = fluree.db.util.async.throw_err(inst_87269);
var inst_87271 = fluree.db.time_travel.as_of_block(inst_87270,block);
var state_87281__$1 = state_87281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87281__$1,(6),inst_87271);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__17178__auto__ = null;
var fluree$db$api$ledger$state_machine__17178__auto____0 = (function (){
var statearr_87293 = [null,null,null,null,null,null,null,null];
(statearr_87293[(0)] = fluree$db$api$ledger$state_machine__17178__auto__);

(statearr_87293[(1)] = (1));

return statearr_87293;
});
var fluree$db$api$ledger$state_machine__17178__auto____1 = (function (state_87281){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87281);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87294){var ex__17181__auto__ = e87294;
var statearr_87295_87305 = state_87281;
(statearr_87295_87305[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87281[(4)]))){
var statearr_87296_87306 = state_87281;
(statearr_87296_87306[(1)] = cljs.core.first((state_87281[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87307 = state_87281;
state_87281 = G__87307;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__17178__auto__ = function(state_87281){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__17178__auto____1.call(this,state_87281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__17178__auto____0;
fluree$db$api$ledger$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__17178__auto____1;
return fluree$db$api$ledger$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87297 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87297[(6)] = c__17304__auto___87299);

return statearr_87297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87348){
var state_val_87349 = (state_87348[(1)]);
if((state_val_87349 === (7))){
var inst_87317 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_87348__$1 = state_87348;
if(inst_87317){
var statearr_87350_87381 = state_87348__$1;
(statearr_87350_87381[(1)] = (9));

} else {
var statearr_87351_87382 = state_87348__$1;
(statearr_87351_87382[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (1))){
var state_87348__$1 = state_87348;
var statearr_87352_87383 = state_87348__$1;
(statearr_87352_87383[(2)] = null);

(statearr_87352_87383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (4))){
var inst_87308 = (state_87348[(2)]);
var state_87348__$1 = state_87348;
var statearr_87353_87384 = state_87348__$1;
(statearr_87353_87384[(2)] = inst_87308);

(statearr_87353_87384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (15))){
var inst_87325 = (state_87348[(7)]);
var inst_87324 = (state_87348[(2)]);
var inst_87325__$1 = fluree.db.util.async.throw_err(inst_87324);
var state_87348__$1 = (function (){var statearr_87354 = state_87348;
(statearr_87354[(7)] = inst_87325__$1);

return statearr_87354;
})();
if(cljs.core.truth_(inst_87325__$1)){
var statearr_87355_87385 = state_87348__$1;
(statearr_87355_87385[(1)] = (16));

} else {
var statearr_87356_87386 = state_87348__$1;
(statearr_87356_87386[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (13))){
var state_87348__$1 = state_87348;
var statearr_87357_87387 = state_87348__$1;
(statearr_87357_87387[(2)] = null);

(statearr_87357_87387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (6))){
var state_87348__$1 = state_87348;
var statearr_87358_87388 = state_87348__$1;
(statearr_87358_87388[(2)] = db);

(statearr_87358_87388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (17))){
var inst_87329 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_87330 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_87331 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_87332 = cljs.core.PersistentHashMap.fromArrays(inst_87330,inst_87331);
var inst_87333 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_87329,inst_87332);
var inst_87334 = (function(){throw inst_87333})();
var state_87348__$1 = state_87348;
var statearr_87359_87389 = state_87348__$1;
(statearr_87359_87389[(2)] = inst_87334);

(statearr_87359_87389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (3))){
var inst_87346 = (state_87348[(2)]);
var state_87348__$1 = state_87348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87348__$1,inst_87346);
} else {
if((state_val_87349 === (12))){
var inst_87322 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_87348__$1 = state_87348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87348__$1,(15),inst_87322);
} else {
if((state_val_87349 === (2))){
var _ = (function (){var statearr_87360 = state_87348;
(statearr_87360[(4)] = cljs.core.cons((5),(state_87348[(4)])));

return statearr_87360;
})();
var inst_87314 = cljs.core.not(auth);
var state_87348__$1 = state_87348;
if(inst_87314){
var statearr_87361_87390 = state_87348__$1;
(statearr_87361_87390[(1)] = (6));

} else {
var statearr_87362_87391 = state_87348__$1;
(statearr_87362_87391[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (11))){
var inst_87341 = (state_87348[(2)]);
var state_87348__$1 = state_87348;
var statearr_87364_87392 = state_87348__$1;
(statearr_87364_87392[(2)] = inst_87341);

(statearr_87364_87392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (9))){
var inst_87319 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_87348__$1 = state_87348;
var statearr_87365_87393 = state_87348__$1;
(statearr_87365_87393[(2)] = inst_87319);

(statearr_87365_87393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (5))){
var _ = (function (){var statearr_87366 = state_87348;
(statearr_87366[(4)] = cljs.core.rest((state_87348[(4)])));

return statearr_87366;
})();
var state_87348__$1 = state_87348;
var ex87363 = (state_87348__$1[(2)]);
var statearr_87367_87394 = state_87348__$1;
(statearr_87367_87394[(5)] = ex87363);


if((ex87363 instanceof Error)){
var statearr_87368_87395 = state_87348__$1;
(statearr_87368_87395[(1)] = (4));

(statearr_87368_87395[(5)] = null);

} else {
throw ex87363;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (14))){
var inst_87339 = (state_87348[(2)]);
var state_87348__$1 = state_87348;
var statearr_87369_87396 = state_87348__$1;
(statearr_87369_87396[(2)] = inst_87339);

(statearr_87369_87396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (16))){
var inst_87325 = (state_87348[(7)]);
var inst_87327 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_87325);
var state_87348__$1 = state_87348;
var statearr_87370_87397 = state_87348__$1;
(statearr_87370_87397[(2)] = inst_87327);

(statearr_87370_87397[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (10))){
var state_87348__$1 = state_87348;
var statearr_87371_87398 = state_87348__$1;
(statearr_87371_87398[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (18))){
var inst_87336 = (state_87348[(2)]);
var state_87348__$1 = state_87348;
var statearr_87373_87399 = state_87348__$1;
(statearr_87373_87399[(2)] = inst_87336);

(statearr_87373_87399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87349 === (8))){
var inst_87343 = (state_87348[(2)]);
var _ = (function (){var statearr_87374 = state_87348;
(statearr_87374[(4)] = cljs.core.rest((state_87348[(4)])));

return statearr_87374;
})();
var state_87348__$1 = state_87348;
var statearr_87375_87400 = state_87348__$1;
(statearr_87375_87400[(2)] = inst_87343);

(statearr_87375_87400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____0 = (function (){
var statearr_87376 = [null,null,null,null,null,null,null,null];
(statearr_87376[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__);

(statearr_87376[(1)] = (1));

return statearr_87376;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____1 = (function (state_87348){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87348);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87377){var ex__17181__auto__ = e87377;
var statearr_87378_87401 = state_87348;
(statearr_87378_87401[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87348[(4)]))){
var statearr_87379_87402 = state_87348;
(statearr_87379_87402[(1)] = cljs.core.first((state_87348[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87403 = state_87348;
state_87348 = G__87403;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__ = function(state_87348){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____1.call(this,state_87348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87380 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87380[(6)] = c__17304__auto__);

return statearr_87380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87467){
var state_val_87468 = (state_87467[(1)]);
if((state_val_87468 === (7))){
var inst_87413 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_87467__$1 = state_87467;
if(inst_87413){
var statearr_87469_87518 = state_87467__$1;
(statearr_87469_87518[(1)] = (9));

} else {
var statearr_87470_87519 = state_87467__$1;
(statearr_87470_87519[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (20))){
var inst_87437 = (state_87467[(7)]);
var state_87467__$1 = state_87467;
if(cljs.core.truth_(inst_87437)){
var statearr_87471_87520 = state_87467__$1;
(statearr_87471_87520[(1)] = (22));

} else {
var statearr_87472_87521 = state_87467__$1;
(statearr_87472_87521[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (27))){
var state_87467__$1 = state_87467;
var statearr_87473_87522 = state_87467__$1;
(statearr_87473_87522[(2)] = null);

(statearr_87473_87522[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (1))){
var state_87467__$1 = state_87467;
var statearr_87474_87523 = state_87467__$1;
(statearr_87474_87523[(2)] = null);

(statearr_87474_87523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (24))){
var inst_87451 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87475_87524 = state_87467__$1;
(statearr_87475_87524[(2)] = inst_87451);

(statearr_87475_87524[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (4))){
var inst_87404 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87476_87525 = state_87467__$1;
(statearr_87476_87525[(2)] = inst_87404);

(statearr_87476_87525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (15))){
var inst_87420 = (state_87467[(8)]);
var inst_87419 = (state_87467[(2)]);
var inst_87420__$1 = fluree.db.util.async.throw_err(inst_87419);
var state_87467__$1 = (function (){var statearr_87477 = state_87467;
(statearr_87477[(8)] = inst_87420__$1);

return statearr_87477;
})();
if(cljs.core.truth_(inst_87420__$1)){
var statearr_87478_87526 = state_87467__$1;
(statearr_87478_87526[(1)] = (16));

} else {
var statearr_87479_87527 = state_87467__$1;
(statearr_87479_87527[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (21))){
var inst_87453 = (state_87467[(9)]);
var inst_87453__$1 = (state_87467[(2)]);
var state_87467__$1 = (function (){var statearr_87480 = state_87467;
(statearr_87480[(9)] = inst_87453__$1);

return statearr_87480;
})();
if(cljs.core.truth_(inst_87453__$1)){
var statearr_87481_87528 = state_87467__$1;
(statearr_87481_87528[(1)] = (29));

} else {
var statearr_87482_87529 = state_87467__$1;
(statearr_87482_87529[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (31))){
var inst_87437 = (state_87467[(7)]);
var inst_87453 = (state_87467[(9)]);
var inst_87461 = (state_87467[(2)]);
var inst_87462 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_87437,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_87453,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_87461], 0));
var _ = (function (){var statearr_87483 = state_87467;
(statearr_87483[(4)] = cljs.core.rest((state_87467[(4)])));

return statearr_87483;
})();
var state_87467__$1 = state_87467;
var statearr_87484_87530 = state_87467__$1;
(statearr_87484_87530[(2)] = inst_87462);

(statearr_87484_87530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (32))){
var inst_87457 = (state_87467[(2)]);
var inst_87458 = fluree.db.util.async.throw_err(inst_87457);
var state_87467__$1 = state_87467;
var statearr_87485_87531 = state_87467__$1;
(statearr_87485_87531[(2)] = inst_87458);

(statearr_87485_87531[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (13))){
var state_87467__$1 = state_87467;
var statearr_87486_87532 = state_87467__$1;
(statearr_87486_87532[(2)] = null);

(statearr_87486_87532[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (22))){
var inst_87437 = (state_87467[(7)]);
var inst_87441 = fluree.db.auth.roles(db,inst_87437);
var state_87467__$1 = state_87467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87467__$1,(25),inst_87441);
} else {
if((state_val_87468 === (29))){
var inst_87453 = (state_87467[(9)]);
var inst_87455 = fluree.db.permissions.permission_map(db,inst_87453,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_87467__$1 = state_87467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87467__$1,(32),inst_87455);
} else {
if((state_val_87468 === (6))){
var state_87467__$1 = state_87467;
var statearr_87487_87533 = state_87467__$1;
(statearr_87487_87533[(2)] = null);

(statearr_87487_87533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (28))){
var inst_87449 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87488_87534 = state_87467__$1;
(statearr_87488_87534[(2)] = inst_87449);

(statearr_87488_87534[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (25))){
var inst_87443 = (state_87467[(2)]);
var inst_87444 = fluree.db.util.async.throw_err(inst_87443);
var state_87467__$1 = state_87467;
var statearr_87489_87535 = state_87467__$1;
(statearr_87489_87535[(2)] = inst_87444);

(statearr_87489_87535[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (17))){
var inst_87423 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_87424 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_87425 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_87426 = cljs.core.PersistentHashMap.fromArrays(inst_87424,inst_87425);
var inst_87427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_87423,inst_87426);
var inst_87428 = (function(){throw inst_87427})();
var state_87467__$1 = state_87467;
var statearr_87490_87536 = state_87467__$1;
(statearr_87490_87536[(2)] = inst_87428);

(statearr_87490_87536[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (3))){
var inst_87465 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87467__$1,inst_87465);
} else {
if((state_val_87468 === (12))){
var inst_87417 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_87467__$1 = state_87467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87467__$1,(15),inst_87417);
} else {
if((state_val_87468 === (2))){
var _ = (function (){var statearr_87491 = state_87467;
(statearr_87491[(4)] = cljs.core.cons((5),(state_87467[(4)])));

return statearr_87491;
})();
var inst_87410 = (auth == null);
var state_87467__$1 = state_87467;
if(cljs.core.truth_(inst_87410)){
var statearr_87492_87537 = state_87467__$1;
(statearr_87492_87537[(1)] = (6));

} else {
var statearr_87493_87538 = state_87467__$1;
(statearr_87493_87538[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (23))){
var state_87467__$1 = state_87467;
var statearr_87494_87539 = state_87467__$1;
(statearr_87494_87539[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (19))){
var state_87467__$1 = state_87467;
var statearr_87496_87540 = state_87467__$1;
(statearr_87496_87540[(2)] = roles);

(statearr_87496_87540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (11))){
var inst_87435 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87498_87541 = state_87467__$1;
(statearr_87498_87541[(2)] = inst_87435);

(statearr_87498_87541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (9))){
var state_87467__$1 = state_87467;
var statearr_87499_87542 = state_87467__$1;
(statearr_87499_87542[(2)] = (0));

(statearr_87499_87542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (5))){
var _ = (function (){var statearr_87500 = state_87467;
(statearr_87500[(4)] = cljs.core.rest((state_87467[(4)])));

return statearr_87500;
})();
var state_87467__$1 = state_87467;
var ex87497 = (state_87467__$1[(2)]);
var statearr_87501_87543 = state_87467__$1;
(statearr_87501_87543[(5)] = ex87497);


if((ex87497 instanceof Error)){
var statearr_87502_87544 = state_87467__$1;
(statearr_87502_87544[(1)] = (4));

(statearr_87502_87544[(5)] = null);

} else {
throw ex87497;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (14))){
var inst_87433 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87503_87545 = state_87467__$1;
(statearr_87503_87545[(2)] = inst_87433);

(statearr_87503_87545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (26))){
var state_87467__$1 = state_87467;
var statearr_87504_87546 = state_87467__$1;
(statearr_87504_87546[(2)] = null);

(statearr_87504_87546[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (16))){
var inst_87420 = (state_87467[(8)]);
var state_87467__$1 = state_87467;
var statearr_87505_87547 = state_87467__$1;
(statearr_87505_87547[(2)] = inst_87420);

(statearr_87505_87547[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (30))){
var state_87467__$1 = state_87467;
var statearr_87506_87548 = state_87467__$1;
(statearr_87506_87548[(2)] = null);

(statearr_87506_87548[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (10))){
var state_87467__$1 = state_87467;
if(cljs.core.truth_(auth)){
var statearr_87507_87549 = state_87467__$1;
(statearr_87507_87549[(1)] = (12));

} else {
var statearr_87508_87550 = state_87467__$1;
(statearr_87508_87550[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (18))){
var inst_87430 = (state_87467[(2)]);
var state_87467__$1 = state_87467;
var statearr_87509_87551 = state_87467__$1;
(statearr_87509_87551[(2)] = inst_87430);

(statearr_87509_87551[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87468 === (8))){
var inst_87437 = (state_87467[(2)]);
var state_87467__$1 = (function (){var statearr_87510 = state_87467;
(statearr_87510[(7)] = inst_87437);

return statearr_87510;
})();
if(cljs.core.truth_(roles)){
var statearr_87511_87552 = state_87467__$1;
(statearr_87511_87552[(1)] = (19));

} else {
var statearr_87512_87553 = state_87467__$1;
(statearr_87512_87553[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____0 = (function (){
var statearr_87513 = [null,null,null,null,null,null,null,null,null,null];
(statearr_87513[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__);

(statearr_87513[(1)] = (1));

return statearr_87513;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____1 = (function (state_87467){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87467);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87514){var ex__17181__auto__ = e87514;
var statearr_87515_87554 = state_87467;
(statearr_87515_87554[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87467[(4)]))){
var statearr_87516_87555 = state_87467;
(statearr_87516_87555[(1)] = cljs.core.first((state_87467[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87556 = state_87467;
state_87467 = G__87556;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__ = function(state_87467){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____1.call(this,state_87467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87517 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87517[(6)] = c__17304__auto__);

return statearr_87517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__87557 = db;
var map__87557__$1 = cljs.core.__destructure_map(map__87557);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87557__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87557__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87557__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87564){
var state_val_87565 = (state_87564[(1)]);
if((state_val_87565 === (1))){
var inst_87558 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_87559 = fluree.db.session.db(conn,inst_87558,null);
var state_87564__$1 = state_87564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87564__$1,(2),inst_87559);
} else {
if((state_val_87565 === (2))){
var inst_87561 = (state_87564[(2)]);
var inst_87562 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_87561);
var state_87564__$1 = state_87564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87564__$1,inst_87562);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0 = (function (){
var statearr_87566 = [null,null,null,null,null,null,null];
(statearr_87566[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__);

(statearr_87566[(1)] = (1));

return statearr_87566;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1 = (function (state_87564){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87564);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87567){var ex__17181__auto__ = e87567;
var statearr_87568_87595 = state_87564;
(statearr_87568_87595[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87564[(4)]))){
var statearr_87569_87596 = state_87564;
(statearr_87569_87596[(1)] = cljs.core.first((state_87564[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87597 = state_87564;
state_87564 = G__87597;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__ = function(state_87564){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1.call(this,state_87564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87570 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87570[(6)] = c__17304__auto__);

return statearr_87570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87583){
var state_val_87584 = (state_87583[(1)]);
if((state_val_87584 === (1))){
var inst_87571 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_87572 = fluree.db.session.db(conn,inst_87571,null);
var state_87583__$1 = state_87583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87583__$1,(2),inst_87572);
} else {
if((state_val_87584 === (2))){
var inst_87574 = (state_87583[(7)]);
var inst_87574__$1 = (state_87583[(2)]);
var inst_87575 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_87574__$1);
var inst_87576 = newer_block_QMARK_(inst_87575);
var state_87583__$1 = (function (){var statearr_87585 = state_87583;
(statearr_87585[(7)] = inst_87574__$1);

return statearr_87585;
})();
if(inst_87576){
var statearr_87586_87598 = state_87583__$1;
(statearr_87586_87598[(1)] = (3));

} else {
var statearr_87587_87599 = state_87583__$1;
(statearr_87587_87599[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87584 === (3))){
var inst_87574 = (state_87583[(7)]);
var inst_87578 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_87574);
var state_87583__$1 = state_87583;
var statearr_87588_87600 = state_87583__$1;
(statearr_87588_87600[(2)] = inst_87578);

(statearr_87588_87600[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87584 === (4))){
var state_87583__$1 = state_87583;
var statearr_87589_87601 = state_87583__$1;
(statearr_87589_87601[(2)] = null);

(statearr_87589_87601[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87584 === (5))){
var inst_87581 = (state_87583[(2)]);
var state_87583__$1 = state_87583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87583__$1,inst_87581);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0 = (function (){
var statearr_87590 = [null,null,null,null,null,null,null,null];
(statearr_87590[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__);

(statearr_87590[(1)] = (1));

return statearr_87590;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1 = (function (state_87583){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87583);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87591){var ex__17181__auto__ = e87591;
var statearr_87592_87602 = state_87583;
(statearr_87592_87602[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87583[(4)]))){
var statearr_87593_87603 = state_87583;
(statearr_87593_87603[(1)] = cljs.core.first((state_87583[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87604 = state_87583;
state_87583 = G__87604;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__ = function(state_87583){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1.call(this,state_87583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87594 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87594[(6)] = c__17304__auto__);

return statearr_87594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__87605 = db;
var map__87605__$1 = cljs.core.__destructure_map(map__87605);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87605__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87605__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87605__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4298__auto__ = syncTimeout;
var y__4299__auto__ = (120000);
return ((x__4298__auto__ < y__4299__auto__) ? x__4298__auto__ : y__4299__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__17304__auto___87681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87655){
var state_val_87656 = (state_87655[(1)]);
if((state_val_87656 === (7))){
var inst_87621 = (state_87655[(7)]);
var inst_87632 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87621,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_87655__$1 = state_87655;
if(inst_87632){
var statearr_87657_87682 = state_87655__$1;
(statearr_87657_87682[(1)] = (9));

} else {
var statearr_87658_87683 = state_87655__$1;
(statearr_87658_87683[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (1))){
var inst_87606 = (state_87655[(8)]);
var inst_87614 = (state_87655[(9)]);
var inst_87606__$1 = cljs.core.async.timeout(timeout);
var inst_87614__$1 = res_port;
var inst_87615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87616 = [inst_87606__$1,inst_87614__$1];
var inst_87617 = (new cljs.core.PersistentVector(null,2,(5),inst_87615,inst_87616,null));
var state_87655__$1 = (function (){var statearr_87659 = state_87655;
(statearr_87659[(8)] = inst_87606__$1);

(statearr_87659[(9)] = inst_87614__$1);

return statearr_87659;
})();
return cljs.core.async.ioc_alts_BANG_(state_87655__$1,(2),inst_87617);
} else {
if((state_val_87656 === (4))){
var inst_87621 = (state_87655[(7)]);
var inst_87614 = (state_87655[(9)]);
var inst_87625 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87621,inst_87614);
var state_87655__$1 = state_87655;
if(inst_87625){
var statearr_87660_87684 = state_87655__$1;
(statearr_87660_87684[(1)] = (6));

} else {
var statearr_87661_87685 = state_87655__$1;
(statearr_87661_87685[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (13))){
var inst_87640 = (state_87655[(10)]);
var inst_87651 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_87640);
var state_87655__$1 = state_87655;
var statearr_87662_87686 = state_87655__$1;
(statearr_87662_87686[(2)] = inst_87651);

(statearr_87662_87686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (6))){
var inst_87619 = (state_87655[(11)]);
var inst_87630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87619,(0),null);
var state_87655__$1 = state_87655;
var statearr_87663_87687 = state_87655__$1;
(statearr_87663_87687[(2)] = inst_87630);

(statearr_87663_87687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (3))){
var state_87655__$1 = state_87655;
var statearr_87664_87688 = state_87655__$1;
(statearr_87664_87688[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_87664_87688[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (12))){
var inst_87644 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_87645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_87646 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_87647 = cljs.core.PersistentHashMap.fromArrays(inst_87645,inst_87646);
var inst_87648 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_87644,inst_87647);
var inst_87649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_87648);
var state_87655__$1 = state_87655;
var statearr_87665_87689 = state_87655__$1;
(statearr_87665_87689[(2)] = inst_87649);

(statearr_87665_87689[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (2))){
var inst_87619 = (state_87655[(11)]);
var inst_87621 = (state_87655[(7)]);
var inst_87606 = (state_87655[(8)]);
var inst_87619__$1 = (state_87655[(2)]);
var inst_87620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87619__$1,(0),null);
var inst_87621__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87619__$1,(1),null);
var inst_87622 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87621__$1,inst_87606);
var state_87655__$1 = (function (){var statearr_87666 = state_87655;
(statearr_87666[(12)] = inst_87620);

(statearr_87666[(11)] = inst_87619__$1);

(statearr_87666[(7)] = inst_87621__$1);

return statearr_87666;
})();
if(inst_87622){
var statearr_87667_87690 = state_87655__$1;
(statearr_87667_87690[(1)] = (3));

} else {
var statearr_87668_87691 = state_87655__$1;
(statearr_87668_87691[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (11))){
var inst_87636 = (state_87655[(2)]);
var state_87655__$1 = state_87655;
var statearr_87669_87692 = state_87655__$1;
(statearr_87669_87692[(2)] = inst_87636);

(statearr_87669_87692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (9))){
var inst_87620 = (state_87655[(12)]);
var state_87655__$1 = state_87655;
var statearr_87670_87693 = state_87655__$1;
(statearr_87670_87693[(2)] = inst_87620);

(statearr_87670_87693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (5))){
var inst_87640 = (state_87655[(10)]);
var inst_87640__$1 = (state_87655[(2)]);
var inst_87641 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_87642 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_87640__$1);
var state_87655__$1 = (function (){var statearr_87671 = state_87655;
(statearr_87671[(10)] = inst_87640__$1);

(statearr_87671[(13)] = inst_87641);

return statearr_87671;
})();
if(inst_87642){
var statearr_87672_87694 = state_87655__$1;
(statearr_87672_87694[(1)] = (12));

} else {
var statearr_87673_87695 = state_87655__$1;
(statearr_87673_87695[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (14))){
var inst_87653 = (state_87655[(2)]);
var state_87655__$1 = state_87655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87655__$1,inst_87653);
} else {
if((state_val_87656 === (10))){
var state_87655__$1 = state_87655;
var statearr_87674_87696 = state_87655__$1;
(statearr_87674_87696[(2)] = null);

(statearr_87674_87696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87656 === (8))){
var inst_87638 = (state_87655[(2)]);
var state_87655__$1 = state_87655;
var statearr_87675_87697 = state_87655__$1;
(statearr_87675_87697[(2)] = inst_87638);

(statearr_87675_87697[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____0 = (function (){
var statearr_87676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87676[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__);

(statearr_87676[(1)] = (1));

return statearr_87676;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____1 = (function (state_87655){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87655);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87677){var ex__17181__auto__ = e87677;
var statearr_87678_87698 = state_87655;
(statearr_87678_87698[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87655[(4)]))){
var statearr_87679_87699 = state_87655;
(statearr_87679_87699[(1)] = cljs.core.first((state_87655[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87700 = state_87655;
state_87655 = G__87700;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__ = function(state_87655){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____1.call(this,state_87655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87680 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87680[(6)] = c__17304__auto___87681);

return statearr_87680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__87702 = arguments.length;
switch (G__87702) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__87703){
var map__87704 = p__87703;
var map__87704__$1 = cljs.core.__destructure_map(map__87704);
var opts = map__87704__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87704__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87704__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87704__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87704__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87704__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__17304__auto___87793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87755){
var state_val_87756 = (state_87755[(1)]);
if((state_val_87756 === (7))){
var inst_87717 = (state_87755[(7)]);
var inst_87719 = fluree.db.api.ledger.syncTo_db(inst_87717,syncTo,syncTimeout);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87755__$1,(10),inst_87719);
} else {
if((state_val_87756 === (20))){
var inst_87741 = (state_87755[(8)]);
var state_87755__$1 = state_87755;
var statearr_87757_87794 = state_87755__$1;
(statearr_87757_87794[(2)] = inst_87741);

(statearr_87757_87794[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (1))){
var state_87755__$1 = state_87755;
var statearr_87758_87795 = state_87755__$1;
(statearr_87758_87795[(2)] = null);

(statearr_87758_87795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (4))){
var inst_87705 = (state_87755[(2)]);
var inst_87706 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_87705);
var inst_87707 = cljs.core.async.close_BANG_(pc);
var state_87755__$1 = (function (){var statearr_87759 = state_87755;
(statearr_87759[(9)] = inst_87706);

return statearr_87759;
})();
var statearr_87760_87796 = state_87755__$1;
(statearr_87760_87796[(2)] = inst_87707);

(statearr_87760_87796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (15))){
var inst_87733 = (state_87755[(10)]);
var inst_87735 = fluree.db.api.ledger.add_db_permissions(inst_87733,auth,roles);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87755__$1,(18),inst_87735);
} else {
if((state_val_87756 === (21))){
var inst_87749 = (state_87755[(2)]);
var inst_87750 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_87749);
var _ = (function (){var statearr_87761 = state_87755;
(statearr_87761[(4)] = cljs.core.rest((state_87755[(4)])));

return statearr_87761;
})();
var state_87755__$1 = state_87755;
var statearr_87762_87797 = state_87755__$1;
(statearr_87762_87797[(2)] = inst_87750);

(statearr_87762_87797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (13))){
var inst_87733 = (state_87755[(2)]);
var state_87755__$1 = (function (){var statearr_87763 = state_87755;
(statearr_87763[(10)] = inst_87733);

return statearr_87763;
})();
if(cljs.core.truth_(roles)){
var statearr_87764_87798 = state_87755__$1;
(statearr_87764_87798[(1)] = (15));

} else {
var statearr_87765_87799 = state_87755__$1;
(statearr_87765_87799[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (22))){
var inst_87745 = (state_87755[(2)]);
var inst_87746 = fluree.db.util.async.throw_err(inst_87745);
var state_87755__$1 = state_87755;
var statearr_87766_87800 = state_87755__$1;
(statearr_87766_87800[(2)] = inst_87746);

(statearr_87766_87800[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (6))){
var inst_87716 = (state_87755[(2)]);
var inst_87717 = fluree.db.util.async.throw_err(inst_87716);
var state_87755__$1 = (function (){var statearr_87767 = state_87755;
(statearr_87767[(7)] = inst_87717);

return statearr_87767;
})();
if(cljs.core.truth_(syncTo)){
var statearr_87768_87801 = state_87755__$1;
(statearr_87768_87801[(1)] = (7));

} else {
var statearr_87769_87802 = state_87755__$1;
(statearr_87769_87802[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (17))){
var inst_87741 = (state_87755[(2)]);
var state_87755__$1 = (function (){var statearr_87770 = state_87755;
(statearr_87770[(8)] = inst_87741);

return statearr_87770;
})();
if(cljs.core.truth_(auth)){
var statearr_87771_87803 = state_87755__$1;
(statearr_87771_87803[(1)] = (19));

} else {
var statearr_87772_87804 = state_87755__$1;
(statearr_87772_87804[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (3))){
var inst_87753 = (state_87755[(2)]);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87755__$1,inst_87753);
} else {
if((state_val_87756 === (12))){
var inst_87725 = (state_87755[(11)]);
var state_87755__$1 = state_87755;
var statearr_87773_87805 = state_87755__$1;
(statearr_87773_87805[(2)] = inst_87725);

(statearr_87773_87805[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (2))){
var _ = (function (){var statearr_87774 = state_87755;
(statearr_87774[(4)] = cljs.core.cons((5),(state_87755[(4)])));

return statearr_87774;
})();
var inst_87714 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87755__$1,(6),inst_87714);
} else {
if((state_val_87756 === (19))){
var inst_87741 = (state_87755[(8)]);
var inst_87743 = fluree.db.api.ledger.add_db_permissions(inst_87741,auth,roles);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87755__$1,(22),inst_87743);
} else {
if((state_val_87756 === (11))){
var inst_87725 = (state_87755[(11)]);
var inst_87727 = fluree.db.time_travel.as_of_block(inst_87725,block);
var state_87755__$1 = state_87755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87755__$1,(14),inst_87727);
} else {
if((state_val_87756 === (9))){
var inst_87725 = (state_87755[(2)]);
var state_87755__$1 = (function (){var statearr_87776 = state_87755;
(statearr_87776[(11)] = inst_87725);

return statearr_87776;
})();
if(cljs.core.truth_(block)){
var statearr_87777_87806 = state_87755__$1;
(statearr_87777_87806[(1)] = (11));

} else {
var statearr_87778_87807 = state_87755__$1;
(statearr_87778_87807[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (5))){
var _ = (function (){var statearr_87779 = state_87755;
(statearr_87779[(4)] = cljs.core.rest((state_87755[(4)])));

return statearr_87779;
})();
var state_87755__$1 = state_87755;
var ex87775 = (state_87755__$1[(2)]);
var statearr_87780_87808 = state_87755__$1;
(statearr_87780_87808[(5)] = ex87775);


var statearr_87781_87809 = state_87755__$1;
(statearr_87781_87809[(1)] = (4));

(statearr_87781_87809[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (14))){
var inst_87729 = (state_87755[(2)]);
var inst_87730 = fluree.db.util.async.throw_err(inst_87729);
var state_87755__$1 = state_87755;
var statearr_87782_87810 = state_87755__$1;
(statearr_87782_87810[(2)] = inst_87730);

(statearr_87782_87810[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (16))){
var inst_87733 = (state_87755[(10)]);
var state_87755__$1 = state_87755;
var statearr_87783_87811 = state_87755__$1;
(statearr_87783_87811[(2)] = inst_87733);

(statearr_87783_87811[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (10))){
var inst_87721 = (state_87755[(2)]);
var inst_87722 = fluree.db.util.async.throw_err(inst_87721);
var state_87755__$1 = state_87755;
var statearr_87784_87812 = state_87755__$1;
(statearr_87784_87812[(2)] = inst_87722);

(statearr_87784_87812[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (18))){
var inst_87737 = (state_87755[(2)]);
var inst_87738 = fluree.db.util.async.throw_err(inst_87737);
var state_87755__$1 = state_87755;
var statearr_87785_87813 = state_87755__$1;
(statearr_87785_87813[(2)] = inst_87738);

(statearr_87785_87813[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87756 === (8))){
var inst_87717 = (state_87755[(7)]);
var state_87755__$1 = state_87755;
var statearr_87786_87814 = state_87755__$1;
(statearr_87786_87814[(2)] = inst_87717);

(statearr_87786_87814[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__17178__auto__ = null;
var fluree$db$api$ledger$state_machine__17178__auto____0 = (function (){
var statearr_87787 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87787[(0)] = fluree$db$api$ledger$state_machine__17178__auto__);

(statearr_87787[(1)] = (1));

return statearr_87787;
});
var fluree$db$api$ledger$state_machine__17178__auto____1 = (function (state_87755){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87755);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87788){var ex__17181__auto__ = e87788;
var statearr_87789_87815 = state_87755;
(statearr_87789_87815[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87755[(4)]))){
var statearr_87790_87816 = state_87755;
(statearr_87790_87816[(1)] = cljs.core.first((state_87755[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87817 = state_87755;
state_87755 = G__87817;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__17178__auto__ = function(state_87755){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__17178__auto____1.call(this,state_87755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__17178__auto____0;
fluree$db$api$ledger$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__17178__auto____1;
return fluree$db$api$ledger$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87791 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87791[(6)] = c__17304__auto___87793);

return statearr_87791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

