// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__31649 = cljs.core.get_global_hierarchy;
return (fexpr__31649.cljs$core$IFn$_invoke$arity$0 ? fexpr__31649.cljs$core$IFn$_invoke$arity$0() : fexpr__31649.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["set websocket id:",ws_id], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["process event:",event_type,event_data], 0));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__31650 = cljs.core.seq(callbacks);
var chunk__31651 = null;
var count__31652 = (0);
var i__31653 = (0);
while(true){
if((i__31653 < count__31652)){
var vec__31662 = chunk__31651.cljs$core$IIndexed$_nth$arity$2(null,i__31653);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31662,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31662,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e31665){var e_31670 = e31665;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_31670,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__31671 = seq__31650;
var G__31672 = chunk__31651;
var G__31673 = count__31652;
var G__31674 = (i__31653 + (1));
seq__31650 = G__31671;
chunk__31651 = G__31672;
count__31652 = G__31673;
i__31653 = G__31674;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__31650);
if(temp__5753__auto__){
var seq__31650__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31650__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__31650__$1);
var G__31675 = cljs.core.chunk_rest(seq__31650__$1);
var G__31676 = c__4638__auto__;
var G__31677 = cljs.core.count(c__4638__auto__);
var G__31678 = (0);
seq__31650 = G__31675;
chunk__31651 = G__31676;
count__31652 = G__31677;
i__31653 = G__31678;
continue;
} else {
var vec__31666 = cljs.core.first(seq__31650__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31666,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31666,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e31669){var e_31679 = e31669;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_31679,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__31680 = cljs.core.next(seq__31650__$1);
var G__31681 = null;
var G__31682 = (0);
var G__31683 = (0);
seq__31650 = G__31680;
chunk__31651 = G__31681;
count__31652 = G__31682;
i__31653 = G__31683;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__31686 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31686,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31686,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31686,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31686,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__31689 = conn;
var map__31689__$1 = cljs.core.__destructure_map(map__31689);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31689__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__31690 = event_type__$1;
var G__31690__$1 = (((G__31690 instanceof cljs.core.Keyword))?G__31690.fqn:null);
switch (G__31690__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Found response channel for subject",subject], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__31684_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__31684_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__31691 = error_data;
var map__31691__$1 = cljs.core.__destructure_map(map__31691);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31691__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e31685){var e = e31685;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
