// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__80658_80827 = cljs.core.seq(servers);
var chunk__80659_80828 = null;
var count__80660_80829 = (0);
var i__80661_80830 = (0);
while(true){
if((i__80661_80830 < count__80660_80829)){
var server_80831 = chunk__80659_80828.cljs$core$IIndexed$_nth$arity$2(null,i__80661_80830);
var healthcheck_uri_80832 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_80831),"/fdb/health"].join('');
var resp_chan_80833 = fluree.db.util.xhttp.post_json(healthcheck_uri_80832,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__17304__auto___80834 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831){
return (function (state_80722){
var state_val_80723 = (state_80722[(1)]);
if((state_val_80723 === (1))){
var state_80722__$1 = state_80722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80722__$1,(2),resp_chan_80833);
} else {
if((state_val_80723 === (2))){
var inst_80711 = (state_80722[(7)]);
var inst_80711__$1 = (state_80722[(2)]);
var inst_80712 = fluree.db.util.core.exception_QMARK_(inst_80711__$1);
var state_80722__$1 = (function (){var statearr_80724 = state_80722;
(statearr_80724[(7)] = inst_80711__$1);

return statearr_80724;
})();
if(inst_80712){
var statearr_80725_80835 = state_80722__$1;
(statearr_80725_80835[(1)] = (3));

} else {
var statearr_80726_80836 = state_80722__$1;
(statearr_80726_80836[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80723 === (3))){
var inst_80711 = (state_80722[(7)]);
var inst_80714 = cljs.core.ex_message(inst_80711);
var inst_80715 = cljs.core.ex_data(inst_80711);
var inst_80716 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_80714,inst_80715], 0));
var state_80722__$1 = state_80722;
var statearr_80727_80837 = state_80722__$1;
(statearr_80727_80837[(2)] = inst_80716);

(statearr_80727_80837[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80723 === (4))){
var inst_80718 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_80831);
var state_80722__$1 = state_80722;
var statearr_80728_80838 = state_80722__$1;
(statearr_80728_80838[(2)] = inst_80718);

(statearr_80728_80838[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80723 === (5))){
var inst_80720 = (state_80722[(2)]);
var state_80722__$1 = state_80722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80722__$1,inst_80720);
} else {
return null;
}
}
}
}
}
});})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831))
;
return ((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,switch__17177__auto__,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0 = (function (){
var statearr_80729 = [null,null,null,null,null,null,null,null];
(statearr_80729[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__);

(statearr_80729[(1)] = (1));

return statearr_80729;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1 = (function (state_80722){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_80722);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e80730){var ex__17181__auto__ = e80730;
var statearr_80731_80839 = state_80722;
(statearr_80731_80839[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_80722[(4)]))){
var statearr_80732_80840 = state_80722;
(statearr_80732_80840[(1)] = cljs.core.first((state_80722[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80841 = state_80722;
state_80722 = G__80841;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = function(state_80722){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1.call(this,state_80722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__;
})()
;})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,switch__17177__auto__,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831))
})();
var state__17306__auto__ = (function (){var statearr_80733 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_80733[(6)] = c__17304__auto___80834);

return statearr_80733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80834,healthcheck_uri_80832,resp_chan_80833,server_80831))
);



var G__80842 = seq__80658_80827;
var G__80843 = chunk__80659_80828;
var G__80844 = count__80660_80829;
var G__80845 = (i__80661_80830 + (1));
seq__80658_80827 = G__80842;
chunk__80659_80828 = G__80843;
count__80660_80829 = G__80844;
i__80661_80830 = G__80845;
continue;
} else {
var temp__5753__auto___80846 = cljs.core.seq(seq__80658_80827);
if(temp__5753__auto___80846){
var seq__80658_80847__$1 = temp__5753__auto___80846;
if(cljs.core.chunked_seq_QMARK_(seq__80658_80847__$1)){
var c__4638__auto___80848 = cljs.core.chunk_first(seq__80658_80847__$1);
var G__80849 = cljs.core.chunk_rest(seq__80658_80847__$1);
var G__80850 = c__4638__auto___80848;
var G__80851 = cljs.core.count(c__4638__auto___80848);
var G__80852 = (0);
seq__80658_80827 = G__80849;
chunk__80659_80828 = G__80850;
count__80660_80829 = G__80851;
i__80661_80830 = G__80852;
continue;
} else {
var server_80853 = cljs.core.first(seq__80658_80847__$1);
var healthcheck_uri_80854 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_80853),"/fdb/health"].join('');
var resp_chan_80855 = fluree.db.util.xhttp.post_json(healthcheck_uri_80854,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__17304__auto___80856 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846){
return (function (state_80746){
var state_val_80747 = (state_80746[(1)]);
if((state_val_80747 === (1))){
var state_80746__$1 = state_80746;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80746__$1,(2),resp_chan_80855);
} else {
if((state_val_80747 === (2))){
var inst_80735 = (state_80746[(7)]);
var inst_80735__$1 = (state_80746[(2)]);
var inst_80736 = fluree.db.util.core.exception_QMARK_(inst_80735__$1);
var state_80746__$1 = (function (){var statearr_80748 = state_80746;
(statearr_80748[(7)] = inst_80735__$1);

return statearr_80748;
})();
if(inst_80736){
var statearr_80749_80857 = state_80746__$1;
(statearr_80749_80857[(1)] = (3));

} else {
var statearr_80750_80858 = state_80746__$1;
(statearr_80750_80858[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80747 === (3))){
var inst_80735 = (state_80746[(7)]);
var inst_80738 = cljs.core.ex_message(inst_80735);
var inst_80739 = cljs.core.ex_data(inst_80735);
var inst_80740 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_80738,inst_80739], 0));
var state_80746__$1 = state_80746;
var statearr_80751_80859 = state_80746__$1;
(statearr_80751_80859[(2)] = inst_80740);

(statearr_80751_80859[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80747 === (4))){
var inst_80742 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_80853);
var state_80746__$1 = state_80746;
var statearr_80752_80860 = state_80746__$1;
(statearr_80752_80860[(2)] = inst_80742);

(statearr_80752_80860[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80747 === (5))){
var inst_80744 = (state_80746[(2)]);
var state_80746__$1 = state_80746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80746__$1,inst_80744);
} else {
return null;
}
}
}
}
}
});})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846))
;
return ((function (seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,switch__17177__auto__,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0 = (function (){
var statearr_80753 = [null,null,null,null,null,null,null,null];
(statearr_80753[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__);

(statearr_80753[(1)] = (1));

return statearr_80753;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1 = (function (state_80746){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_80746);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e80754){var ex__17181__auto__ = e80754;
var statearr_80755_80861 = state_80746;
(statearr_80755_80861[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_80746[(4)]))){
var statearr_80756_80862 = state_80746;
(statearr_80756_80862[(1)] = cljs.core.first((state_80746[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80863 = state_80746;
state_80746 = G__80863;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = function(state_80746){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1.call(this,state_80746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__;
})()
;})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,switch__17177__auto__,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846))
})();
var state__17306__auto__ = (function (){var statearr_80757 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_80757[(6)] = c__17304__auto___80856);

return statearr_80757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(seq__80658_80827,chunk__80659_80828,count__80660_80829,i__80661_80830,c__17304__auto___80856,healthcheck_uri_80854,resp_chan_80855,server_80853,seq__80658_80847__$1,temp__5753__auto___80846))
);



var G__80864 = cljs.core.next(seq__80658_80847__$1);
var G__80865 = null;
var G__80866 = (0);
var G__80867 = (0);
seq__80658_80827 = G__80864;
chunk__80659_80828 = G__80865;
count__80660_80829 = G__80866;
i__80661_80830 = G__80867;
continue;
}
} else {
}
}
break;
}

var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_80801){
var state_val_80802 = (state_80801[(1)]);
if((state_val_80802 === (7))){
var inst_80773 = (state_80801[(7)]);
var inst_80780 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80773,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_80801__$1 = state_80801;
if(inst_80780){
var statearr_80803_80868 = state_80801__$1;
(statearr_80803_80868[(1)] = (9));

} else {
var statearr_80804_80869 = state_80801__$1;
(statearr_80804_80869[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (1))){
var inst_80765 = (state_80801[(8)]);
var inst_80766 = (state_80801[(9)]);
var inst_80765__$1 = promise_chan;
var inst_80766__$1 = cljs.core.async.timeout((60000));
var inst_80767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80768 = [inst_80765__$1,inst_80766__$1];
var inst_80769 = (new cljs.core.PersistentVector(null,2,(5),inst_80767,inst_80768,null));
var state_80801__$1 = (function (){var statearr_80805 = state_80801;
(statearr_80805[(8)] = inst_80765__$1);

(statearr_80805[(9)] = inst_80766__$1);

return statearr_80805;
})();
return cljs.core.async.ioc_alts_BANG_(state_80801__$1,(2),inst_80769);
} else {
if((state_val_80802 === (4))){
var inst_80766 = (state_80801[(9)]);
var inst_80773 = (state_80801[(7)]);
var inst_80777 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80773,inst_80766);
var state_80801__$1 = state_80801;
if(inst_80777){
var statearr_80806_80870 = state_80801__$1;
(statearr_80806_80870[(1)] = (6));

} else {
var statearr_80807_80871 = state_80801__$1;
(statearr_80807_80871[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (13))){
var state_80801__$1 = state_80801;
var statearr_80808_80872 = state_80801__$1;
(statearr_80808_80872[(2)] = null);

(statearr_80808_80872[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (6))){
var state_80801__$1 = state_80801;
var statearr_80809_80873 = state_80801__$1;
(statearr_80809_80873[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_80809_80873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (3))){
var state_80801__$1 = state_80801;
var statearr_80810_80874 = state_80801__$1;
(statearr_80810_80874[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_80810_80874[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (12))){
var inst_80791 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_80792 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80793 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_80794 = cljs.core.PersistentHashMap.fromArrays(inst_80792,inst_80793);
var inst_80795 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_80794);
var inst_80796 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_80795);
var state_80801__$1 = (function (){var statearr_80811 = state_80801;
(statearr_80811[(10)] = inst_80791);

return statearr_80811;
})();
var statearr_80812_80875 = state_80801__$1;
(statearr_80812_80875[(2)] = inst_80796);

(statearr_80812_80875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (2))){
var inst_80765 = (state_80801[(8)]);
var inst_80773 = (state_80801[(7)]);
var inst_80771 = (state_80801[(2)]);
var inst_80772 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80771,(0),null);
var inst_80773__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80771,(1),null);
var inst_80774 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80773__$1,inst_80765);
var state_80801__$1 = (function (){var statearr_80813 = state_80801;
(statearr_80813[(11)] = inst_80772);

(statearr_80813[(7)] = inst_80773__$1);

return statearr_80813;
})();
if(inst_80774){
var statearr_80814_80876 = state_80801__$1;
(statearr_80814_80876[(1)] = (3));

} else {
var statearr_80815_80877 = state_80801__$1;
(statearr_80815_80877[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (11))){
var inst_80784 = (state_80801[(2)]);
var state_80801__$1 = state_80801;
var statearr_80816_80878 = state_80801__$1;
(statearr_80816_80878[(2)] = inst_80784);

(statearr_80816_80878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (9))){
var inst_80772 = (state_80801[(11)]);
var state_80801__$1 = state_80801;
var statearr_80817_80879 = state_80801__$1;
(statearr_80817_80879[(2)] = inst_80772);

(statearr_80817_80879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (5))){
var inst_80788 = (state_80801[(2)]);
var inst_80789 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_80788);
var state_80801__$1 = state_80801;
if(inst_80789){
var statearr_80818_80880 = state_80801__$1;
(statearr_80818_80880[(1)] = (12));

} else {
var statearr_80819_80881 = state_80801__$1;
(statearr_80819_80881[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (14))){
var inst_80799 = (state_80801[(2)]);
var state_80801__$1 = state_80801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80801__$1,inst_80799);
} else {
if((state_val_80802 === (10))){
var state_80801__$1 = state_80801;
var statearr_80820_80882 = state_80801__$1;
(statearr_80820_80882[(2)] = null);

(statearr_80820_80882[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80802 === (8))){
var inst_80786 = (state_80801[(2)]);
var state_80801__$1 = state_80801;
var statearr_80821_80883 = state_80801__$1;
(statearr_80821_80883[(2)] = inst_80786);

(statearr_80821_80883[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0 = (function (){
var statearr_80822 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80822[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__);

(statearr_80822[(1)] = (1));

return statearr_80822;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1 = (function (state_80801){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_80801);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e80823){var ex__17181__auto__ = e80823;
var statearr_80824_80884 = state_80801;
(statearr_80824_80884[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_80801[(4)]))){
var statearr_80825_80885 = state_80801;
(statearr_80825_80885[(1)] = cljs.core.first((state_80801[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80886 = state_80801;
state_80801 = G__80886;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__ = function(state_80801){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1.call(this,state_80801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_80826 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_80826[(6)] = c__17304__auto__);

return statearr_80826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_80930){
var state_val_80931 = (state_80930[(1)]);
if((state_val_80931 === (7))){
var state_80930__$1 = state_80930;
var statearr_80932_80958 = state_80930__$1;
(statearr_80932_80958[(2)] = null);

(statearr_80932_80958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (1))){
var state_80930__$1 = state_80930;
var statearr_80933_80959 = state_80930__$1;
(statearr_80933_80959[(2)] = null);

(statearr_80933_80959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (4))){
var inst_80887 = (state_80930[(2)]);
var state_80930__$1 = state_80930;
var statearr_80934_80960 = state_80930__$1;
(statearr_80934_80960[(2)] = inst_80887);

(statearr_80934_80960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (6))){
var inst_80909 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_80930__$1 = state_80930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80930__$1,(9),inst_80909);
} else {
if((state_val_80931 === (3))){
var inst_80928 = (state_80930[(2)]);
var state_80930__$1 = state_80930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80930__$1,inst_80928);
} else {
if((state_val_80931 === (12))){
var inst_80922 = (state_80930[(2)]);
var state_80930__$1 = state_80930;
var statearr_80935_80961 = state_80930__$1;
(statearr_80935_80961[(2)] = inst_80922);

(statearr_80935_80961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (2))){
var inst_80898 = (state_80930[(7)]);
var inst_80903 = (state_80930[(8)]);
var inst_80893 = (state_80930[(9)]);
var _ = (function (){var statearr_80936 = state_80930;
(statearr_80936[(4)] = cljs.core.cons((5),(state_80930[(4)])));

return statearr_80936;
})();
var inst_80893__$1 = fluree.db.util.core.random_uuid();
var inst_80894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80895 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_80896 = (new cljs.core.PersistentVector(null,2,(5),inst_80894,inst_80895,null));
var inst_80897 = (function (){var lock_id = inst_80893__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_80898__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_80896,inst_80897);
var inst_80899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80900 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_80901 = (new cljs.core.PersistentVector(null,3,(5),inst_80899,inst_80900,null));
var inst_80902 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_80898__$1,inst_80901);
var inst_80903__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80893__$1,inst_80902);
var inst_80904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80905 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_80906 = (new cljs.core.PersistentVector(null,3,(5),inst_80904,inst_80905,null));
var inst_80907 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_80898__$1,inst_80906);
var state_80930__$1 = (function (){var statearr_80937 = state_80930;
(statearr_80937[(7)] = inst_80898__$1);

(statearr_80937[(8)] = inst_80903__$1);

(statearr_80937[(10)] = inst_80907);

(statearr_80937[(9)] = inst_80893__$1);

return statearr_80937;
})();
if(inst_80903__$1){
var statearr_80938_80962 = state_80930__$1;
(statearr_80938_80962[(1)] = (6));

} else {
var statearr_80939_80963 = state_80930__$1;
(statearr_80939_80963[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (11))){
var inst_80913 = (state_80930[(11)]);
var inst_80914 = (state_80930[(12)]);
var inst_80907 = (state_80930[(10)]);
var inst_80920 = fluree.db.util.xhttp.try_socket(inst_80913,sub_chan,pub_chan,inst_80907,(60000),inst_80914);
var state_80930__$1 = state_80930;
var statearr_80941_80964 = state_80930__$1;
(statearr_80941_80964[(2)] = inst_80920);

(statearr_80941_80964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (9))){
var inst_80913 = (state_80930[(11)]);
var inst_80898 = (state_80930[(7)]);
var inst_80903 = (state_80930[(8)]);
var inst_80907 = (state_80930[(10)]);
var inst_80911 = (state_80930[(13)]);
var inst_80893 = (state_80930[(9)]);
var inst_80911__$1 = (state_80930[(2)]);
var inst_80912 = clojure.string.replace(inst_80911__$1,"http","ws");
var inst_80913__$1 = [inst_80912,"/fdb/ws"].join('');
var inst_80914 = (function (){var lock_id = inst_80893;
var state = inst_80898;
var have_lock_QMARK_ = inst_80903;
var resp_chan = inst_80907;
var healthy_server = inst_80911__$1;
var ws_url = inst_80913__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_80915 = fluree.db.util.core.exception_QMARK_(inst_80911__$1);
var state_80930__$1 = (function (){var statearr_80942 = state_80930;
(statearr_80942[(11)] = inst_80913__$1);

(statearr_80942[(12)] = inst_80914);

(statearr_80942[(13)] = inst_80911__$1);

return statearr_80942;
})();
if(inst_80915){
var statearr_80943_80965 = state_80930__$1;
(statearr_80943_80965[(1)] = (10));

} else {
var statearr_80944_80966 = state_80930__$1;
(statearr_80944_80966[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (5))){
var _ = (function (){var statearr_80945 = state_80930;
(statearr_80945[(4)] = cljs.core.rest((state_80930[(4)])));

return statearr_80945;
})();
var state_80930__$1 = state_80930;
var ex80940 = (state_80930__$1[(2)]);
var statearr_80946_80967 = state_80930__$1;
(statearr_80946_80967[(5)] = ex80940);


if((ex80940 instanceof Error)){
var statearr_80947_80968 = state_80930__$1;
(statearr_80947_80968[(1)] = (4));

(statearr_80947_80968[(5)] = null);

} else {
throw ex80940;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (10))){
var inst_80907 = (state_80930[(10)]);
var inst_80911 = (state_80930[(13)]);
var inst_80917 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_80918 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_80907,inst_80911);
var state_80930__$1 = (function (){var statearr_80948 = state_80930;
(statearr_80948[(14)] = inst_80917);

return statearr_80948;
})();
var statearr_80949_80969 = state_80930__$1;
(statearr_80949_80969[(2)] = inst_80918);

(statearr_80949_80969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80931 === (8))){
var inst_80907 = (state_80930[(10)]);
var inst_80925 = (state_80930[(2)]);
var _ = (function (){var statearr_80950 = state_80930;
(statearr_80950[(4)] = cljs.core.rest((state_80930[(4)])));

return statearr_80950;
})();
var state_80930__$1 = (function (){var statearr_80951 = state_80930;
(statearr_80951[(15)] = inst_80925);

return statearr_80951;
})();
var statearr_80952_80970 = state_80930__$1;
(statearr_80952_80970[(2)] = inst_80907);

(statearr_80952_80970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__17178__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__17178__auto____0 = (function (){
var statearr_80953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80953[(0)] = fluree$db$connection$establish_socket_$_state_machine__17178__auto__);

(statearr_80953[(1)] = (1));

return statearr_80953;
});
var fluree$db$connection$establish_socket_$_state_machine__17178__auto____1 = (function (state_80930){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_80930);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e80954){var ex__17181__auto__ = e80954;
var statearr_80955_80971 = state_80930;
(statearr_80955_80971[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_80930[(4)]))){
var statearr_80956_80972 = state_80930;
(statearr_80956_80972[(1)] = cljs.core.first((state_80930[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80973 = state_80930;
state_80930 = G__80973;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__17178__auto__ = function(state_80930){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__17178__auto____1.call(this,state_80930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__17178__auto____0;
fluree$db$connection$establish_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__17178__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_80957 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_80957[(6)] = c__17304__auto__);

return statearr_80957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k80975,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__80979 = k80975;
var G__80979__$1 = (((G__80979 instanceof cljs.core.Keyword))?G__80979.fqn:null);
switch (G__80979__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k80975,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__80980){
var vec__80981 = p__80980;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80981,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80981,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__80974){
var self__ = this;
var G__80974__$1 = this;
return (new cljs.core.RecordIter((0),G__80974__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__80984 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__80984(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this80976,other80977){
var self__ = this;
var this80976__$1 = this;
return (((!((other80977 == null)))) && ((((this80976__$1.constructor === other80977.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.id,other80977.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.servers,other80977.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.state,other80977.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.req_chan,other80977.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.sub_chan,other80977.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.pub_chan,other80977.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.group,other80977.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.storage_read,other80977.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.storage_write,other80977.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.object_cache,other80977.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.parallelism,other80977.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.serializer,other80977.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.default_network,other80977.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.transactor_QMARK_,other80977.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.publish,other80977.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.transact_handler,other80977.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.tx_private_key,other80977.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.tx_key_id,other80977.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.meta,other80977.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.add_listener,other80977.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.remove_listener,other80977.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.close,other80977.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this80976__$1.__extmap,other80977.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k80975){
var self__ = this;
var this__4468__auto____$1 = this;
var G__80985 = k80975;
var G__80985__$1 = (((G__80985 instanceof cljs.core.Keyword))?G__80985.fqn:null);
switch (G__80985__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k80975);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__80974){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__80986 = cljs.core.keyword_identical_QMARK_;
var expr__80987 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__80989 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__80990 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80989,G__80990) : pred__80986.call(null,G__80989,G__80990));
})())){
return (new fluree.db.connection.Connection(G__80974,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__80991 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__80992 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80991,G__80992) : pred__80986.call(null,G__80991,G__80992));
})())){
return (new fluree.db.connection.Connection(self__.id,G__80974,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__80993 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__80994 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80993,G__80994) : pred__80986.call(null,G__80993,G__80994));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__80974,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__80995 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__80996 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80995,G__80996) : pred__80986.call(null,G__80995,G__80996));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__80974,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__80997 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__80998 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80997,G__80998) : pred__80986.call(null,G__80997,G__80998));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__80974,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__80999 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__81000 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__80999,G__81000) : pred__80986.call(null,G__80999,G__81000));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__80974,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81001 = new cljs.core.Keyword(null,"group","group",582596132);
var G__81002 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81001,G__81002) : pred__80986.call(null,G__81001,G__81002));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__80974,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81003 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__81004 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81003,G__81004) : pred__80986.call(null,G__81003,G__81004));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__80974,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81005 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__81006 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81005,G__81006) : pred__80986.call(null,G__81005,G__81006));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__80974,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81007 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__81008 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81007,G__81008) : pred__80986.call(null,G__81007,G__81008));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__80974,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81009 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__81010 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81009,G__81010) : pred__80986.call(null,G__81009,G__81010));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__80974,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81011 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__81012 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81011,G__81012) : pred__80986.call(null,G__81011,G__81012));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__80974,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81013 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__81014 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81013,G__81014) : pred__80986.call(null,G__81013,G__81014));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__80974,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81015 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__81016 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81015,G__81016) : pred__80986.call(null,G__81015,G__81016));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__80974,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81017 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__81018 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81017,G__81018) : pred__80986.call(null,G__81017,G__81018));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__80974,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81019 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__81020 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81019,G__81020) : pred__80986.call(null,G__81019,G__81020));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__80974,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81021 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__81022 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81021,G__81022) : pred__80986.call(null,G__81021,G__81022));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__80974,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81023 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__81024 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81023,G__81024) : pred__80986.call(null,G__81023,G__81024));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__80974,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81025 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__81026 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81025,G__81026) : pred__80986.call(null,G__81025,G__81026));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__80974,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81027 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__81028 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81027,G__81028) : pred__80986.call(null,G__81027,G__81028));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__80974,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81029 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__81030 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81029,G__81030) : pred__80986.call(null,G__81029,G__81030));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__80974,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__81031 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__81032 = expr__80987;
return (pred__80986.cljs$core$IFn$_invoke$arity$2 ? pred__80986.cljs$core$IFn$_invoke$arity$2(G__81031,G__81032) : pred__80986.call(null,G__81031,G__81032));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__80974,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__80974),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__80974){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__80974,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__80978){
var extmap__4501__auto__ = (function (){var G__81033 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__80978,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__80978)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__81033);
} else {
return G__81033;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__80978),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__80978),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__81039 = servers_STAR_;
var vec__81040 = G__81039;
var seq__81041 = cljs.core.seq(vec__81040);
var first__81042 = cljs.core.first(seq__81041);
var seq__81041__$1 = cljs.core.next(seq__81041);
var server = first__81042;
var r = seq__81041__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__81039__$1 = G__81039;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__81046 = G__81039__$1;
var seq__81047 = cljs.core.seq(vec__81046);
var first__81048 = cljs.core.first(seq__81047);
var seq__81047__$1 = cljs.core.next(seq__81047);
var server__$1 = first__81048;
var r__$1 = seq__81047__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__81049 = r__$1;
var G__81050 = is_https_QMARK_;
var G__81051 = result_STAR_;
G__81039__$1 = G__81049;
https_QMARK___$1 = G__81050;
result__$1 = G__81051;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__81052 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__81052 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__81052);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81081){
var state_val_81082 = (state_81081[(1)]);
if((state_val_81082 === (7))){
var inst_81067 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81068 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81069 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81070 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81071 = fluree.db.connection.establish_socket(inst_81067,inst_81068,inst_81069,inst_81070);
var state_81081__$1 = state_81081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81081__$1,(9),inst_81071);
} else {
if((state_val_81082 === (1))){
var state_81081__$1 = state_81081;
var statearr_81083_81102 = state_81081__$1;
(statearr_81083_81102[(2)] = null);

(statearr_81083_81102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (4))){
var inst_81053 = (state_81081[(2)]);
var state_81081__$1 = state_81081;
var statearr_81084_81103 = state_81081__$1;
(statearr_81084_81103[(2)] = inst_81053);

(statearr_81084_81103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (6))){
var inst_81064 = (state_81081[(7)]);
var state_81081__$1 = state_81081;
var statearr_81085_81104 = state_81081__$1;
(statearr_81085_81104[(2)] = inst_81064);

(statearr_81085_81104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (3))){
var inst_81079 = (state_81081[(2)]);
var state_81081__$1 = state_81081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81081__$1,inst_81079);
} else {
if((state_val_81082 === (2))){
var inst_81064 = (state_81081[(7)]);
var _ = (function (){var statearr_81087 = state_81081;
(statearr_81087[(4)] = cljs.core.cons((5),(state_81081[(4)])));

return statearr_81087;
})();
var inst_81059 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_81060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81061 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81062 = [inst_81061,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_81063 = (new cljs.core.PersistentVector(null,3,(5),inst_81060,inst_81062,null));
var inst_81064__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_81059,inst_81063);
var state_81081__$1 = (function (){var statearr_81088 = state_81081;
(statearr_81088[(7)] = inst_81064__$1);

return statearr_81088;
})();
if(cljs.core.truth_(inst_81064__$1)){
var statearr_81089_81105 = state_81081__$1;
(statearr_81089_81105[(1)] = (6));

} else {
var statearr_81090_81106 = state_81081__$1;
(statearr_81090_81106[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (9))){
var inst_81073 = (state_81081[(2)]);
var inst_81074 = fluree.db.util.async.throw_err(inst_81073);
var state_81081__$1 = state_81081;
var statearr_81091_81107 = state_81081__$1;
(statearr_81091_81107[(2)] = inst_81074);

(statearr_81091_81107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (5))){
var _ = (function (){var statearr_81092 = state_81081;
(statearr_81092[(4)] = cljs.core.rest((state_81081[(4)])));

return statearr_81092;
})();
var state_81081__$1 = state_81081;
var ex81086 = (state_81081__$1[(2)]);
var statearr_81093_81108 = state_81081__$1;
(statearr_81093_81108[(5)] = ex81086);


if((ex81086 instanceof Error)){
var statearr_81094_81109 = state_81081__$1;
(statearr_81094_81109[(1)] = (4));

(statearr_81094_81109[(5)] = null);

} else {
throw ex81086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81082 === (8))){
var inst_81076 = (state_81081[(2)]);
var _ = (function (){var statearr_81095 = state_81081;
(statearr_81095[(4)] = cljs.core.rest((state_81081[(4)])));

return statearr_81095;
})();
var state_81081__$1 = state_81081;
var statearr_81096_81110 = state_81081__$1;
(statearr_81096_81110[(2)] = inst_81076);

(statearr_81096_81110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__17178__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__17178__auto____0 = (function (){
var statearr_81097 = [null,null,null,null,null,null,null,null];
(statearr_81097[(0)] = fluree$db$connection$get_socket_$_state_machine__17178__auto__);

(statearr_81097[(1)] = (1));

return statearr_81097;
});
var fluree$db$connection$get_socket_$_state_machine__17178__auto____1 = (function (state_81081){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81081);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81098){var ex__17181__auto__ = e81098;
var statearr_81099_81111 = state_81081;
(statearr_81099_81111[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81081[(4)]))){
var statearr_81100_81112 = state_81081;
(statearr_81100_81112[(1)] = cljs.core.first((state_81081[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81113 = state_81081;
state_81081 = G__81113;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__17178__auto__ = function(state_81081){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__17178__auto____1.call(this,state_81081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__17178__auto____0;
fluree$db$connection$get_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__17178__auto____1;
return fluree$db$connection$get_socket_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81101 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81101[(6)] = c__17304__auto__);

return statearr_81101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e81114){var e = e81114;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81241){
var state_val_81242 = (state_81241[(1)]);
if((state_val_81242 === (7))){
var inst_81237 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
var statearr_81244_81314 = state_81241__$1;
(statearr_81244_81314[(2)] = inst_81237);

(statearr_81244_81314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (20))){
var _ = (function (){var statearr_81245 = state_81241;
(statearr_81245[(4)] = cljs.core.rest((state_81241[(4)])));

return statearr_81245;
})();
var state_81241__$1 = state_81241;
var ex81243 = (state_81241__$1[(2)]);
var statearr_81246_81315 = state_81241__$1;
(statearr_81246_81315[(5)] = ex81243);


var statearr_81247_81316 = state_81241__$1;
(statearr_81247_81316[(1)] = (10));

(statearr_81247_81316[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (27))){
var inst_81229 = (state_81241[(2)]);
var _ = (function (){var statearr_81248 = state_81241;
(statearr_81248[(4)] = cljs.core.rest((state_81241[(4)])));

return statearr_81248;
})();
var state_81241__$1 = state_81241;
var statearr_81249_81317 = state_81241__$1;
(statearr_81249_81317[(2)] = inst_81229);

(statearr_81249_81317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (1))){
var inst_81116 = (0);
var state_81241__$1 = (function (){var statearr_81250 = state_81241;
(statearr_81250[(7)] = inst_81116);

return statearr_81250;
})();
var statearr_81251_81318 = state_81241__$1;
(statearr_81251_81318[(2)] = null);

(statearr_81251_81318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (24))){
var inst_81207 = (state_81241[(8)]);
var inst_81207__$1 = (state_81241[(2)]);
var inst_81208 = inst_81207__$1 === true;
var state_81241__$1 = (function (){var statearr_81252 = state_81241;
(statearr_81252[(8)] = inst_81207__$1);

return statearr_81252;
})();
if(cljs.core.truth_(inst_81208)){
var statearr_81253_81319 = state_81241__$1;
(statearr_81253_81319[(1)] = (25));

} else {
var statearr_81254_81320 = state_81241__$1;
(statearr_81254_81320[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (4))){
var inst_81119 = (state_81241[(9)]);
var inst_81119__$1 = (state_81241[(2)]);
var state_81241__$1 = (function (){var statearr_81255 = state_81241;
(statearr_81255[(9)] = inst_81119__$1);

return statearr_81255;
})();
if(cljs.core.truth_(inst_81119__$1)){
var statearr_81256_81321 = state_81241__$1;
(statearr_81256_81321[(1)] = (5));

} else {
var statearr_81257_81322 = state_81241__$1;
(statearr_81257_81322[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (15))){
var inst_81132 = (state_81241[(10)]);
var state_81241__$1 = state_81241;
var statearr_81258_81323 = state_81241__$1;
(statearr_81258_81323[(2)] = inst_81132);

(statearr_81258_81323[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (21))){
var inst_81159 = (state_81241[(11)]);
var inst_81156 = (state_81241[(12)]);
var inst_81160 = (state_81241[(13)]);
var inst_81164 = (state_81241[(14)]);
var inst_81116 = (state_81241[(7)]);
var inst_81158 = (state_81241[(15)]);
var inst_81157 = (state_81241[(16)]);
var inst_81119 = (state_81241[(9)]);
var inst_81155 = (state_81241[(17)]);
var inst_81163 = (state_81241[(18)]);
var inst_81166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81167 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_81163];
var inst_81168 = (new cljs.core.PersistentVector(null,2,(5),inst_81166,inst_81167,null));
var inst_81169 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_81168,inst_81158);
var inst_81196 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_81197 = (function (){var resp_chan = inst_81158;
var timeout = inst_81164;
var i = inst_81116;
var data = inst_81157;
var _ = inst_81155;
var req_id = inst_81163;
var operation = inst_81156;
var vec__81151 = inst_81119;
var msg = inst_81119;
var c__17304__auto____$1 = inst_81196;
var map__81154 = inst_81160;
var opts = inst_81159;
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81194){
var state_val_81195 = (state_81194[(1)]);
if((state_val_81195 === (1))){
var inst_81173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81174 = cljs.core.async.timeout(timeout);
var inst_81175 = [resp_chan,inst_81174];
var inst_81176 = (new cljs.core.PersistentVector(null,2,(5),inst_81173,inst_81175,null));
var state_81194__$1 = state_81194;
return cljs.core.async.ioc_alts_BANG_(state_81194__$1,(2),inst_81176);
} else {
if((state_val_81195 === (2))){
var inst_81179 = (state_81194[(7)]);
var inst_81178 = (state_81194[(2)]);
var inst_81179__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81178,(0),null);
var inst_81180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81178,(1),null);
var inst_81181 = (function (){var vec__81170 = inst_81178;
var resp = inst_81179__$1;
var c = inst_81180;
return (function (p1__81115_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__81115_SHARP_,req_id);
});
})();
var inst_81182 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_81181);
var inst_81183 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_81180,resp_chan);
var state_81194__$1 = (function (){var statearr_81259 = state_81194;
(statearr_81259[(8)] = inst_81182);

(statearr_81259[(7)] = inst_81179__$1);

return statearr_81259;
})();
if(inst_81183){
var statearr_81260_81324 = state_81194__$1;
(statearr_81260_81324[(1)] = (3));

} else {
var statearr_81261_81325 = state_81194__$1;
(statearr_81261_81325[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81195 === (3))){
var inst_81179 = (state_81194[(7)]);
var state_81194__$1 = state_81194;
var statearr_81262_81326 = state_81194__$1;
(statearr_81262_81326[(2)] = inst_81179);

(statearr_81262_81326[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81195 === (4))){
var inst_81186 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_81187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81188 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_81189 = cljs.core.PersistentHashMap.fromArrays(inst_81187,inst_81188);
var inst_81190 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_81186,inst_81189);
var state_81194__$1 = state_81194;
var statearr_81263_81327 = state_81194__$1;
(statearr_81263_81327[(2)] = inst_81190);

(statearr_81263_81327[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81195 === (5))){
var inst_81192 = (state_81194[(2)]);
var state_81194__$1 = state_81194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81194__$1,inst_81192);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__17178__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__17178__auto____0 = (function (){
var statearr_81264 = [null,null,null,null,null,null,null,null,null];
(statearr_81264[(0)] = fluree$db$connection$msg_producer_$_state_machine__17178__auto__);

(statearr_81264[(1)] = (1));

return statearr_81264;
});
var fluree$db$connection$msg_producer_$_state_machine__17178__auto____1 = (function (state_81194){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81194);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81265){var ex__17181__auto__ = e81265;
var statearr_81266_81328 = state_81194;
(statearr_81266_81328[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81194[(4)]))){
var statearr_81267_81329 = state_81194;
(statearr_81267_81329[(1)] = cljs.core.first((state_81194[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81330 = state_81194;
state_81194 = G__81330;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__17178__auto__ = function(state_81194){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__17178__auto____1.call(this,state_81194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__17178__auto____0;
fluree$db$connection$msg_producer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__17178__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81268 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81268[(6)] = c__17304__auto____$1);

return statearr_81268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});
})();
var inst_81198 = cljs.core.async.impl.dispatch.run(inst_81197);
var state_81241__$1 = (function (){var statearr_81269 = state_81241;
(statearr_81269[(19)] = inst_81198);

(statearr_81269[(20)] = inst_81169);

return statearr_81269;
})();
var statearr_81270_81331 = state_81241__$1;
(statearr_81270_81331[(2)] = inst_81196);

(statearr_81270_81331[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (31))){
var inst_81217 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_81241__$1 = state_81241;
var statearr_81271_81332 = state_81241__$1;
(statearr_81271_81332[(2)] = inst_81217);

(statearr_81271_81332[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (32))){
var state_81241__$1 = state_81241;
var statearr_81272_81333 = state_81241__$1;
(statearr_81272_81333[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (33))){
var inst_81225 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
var statearr_81274_81334 = state_81241__$1;
(statearr_81274_81334[(2)] = inst_81225);

(statearr_81274_81334[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (13))){
var inst_81132 = (state_81241[(10)]);
var inst_81129 = (state_81241[(2)]);
var inst_81130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81129,(0),null);
var inst_81131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81129,(1),null);
var inst_81132__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81129,(2),null);
var state_81241__$1 = (function (){var statearr_81275 = state_81241;
(statearr_81275[(21)] = inst_81131);

(statearr_81275[(10)] = inst_81132__$1);

(statearr_81275[(22)] = inst_81130);

return statearr_81275;
})();
if(cljs.core.truth_(inst_81132__$1)){
var statearr_81276_81335 = state_81241__$1;
(statearr_81276_81335[(1)] = (14));

} else {
var statearr_81277_81336 = state_81241__$1;
(statearr_81277_81336[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (22))){
var state_81241__$1 = state_81241;
var statearr_81278_81337 = state_81241__$1;
(statearr_81278_81337[(2)] = null);

(statearr_81278_81337[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (36))){
var inst_81223 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
var statearr_81279_81338 = state_81241__$1;
(statearr_81279_81338[(2)] = inst_81223);

(statearr_81279_81338[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (29))){
var inst_81207 = (state_81241[(8)]);
var inst_81215 = (inst_81207 == null);
var state_81241__$1 = state_81241;
if(cljs.core.truth_(inst_81215)){
var statearr_81280_81339 = state_81241__$1;
(statearr_81280_81339[(1)] = (31));

} else {
var statearr_81281_81340 = state_81241__$1;
(statearr_81281_81340[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (6))){
var state_81241__$1 = state_81241;
var statearr_81282_81341 = state_81241__$1;
(statearr_81282_81341[(2)] = null);

(statearr_81282_81341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (28))){
var inst_81207 = (state_81241[(8)]);
var inst_81213 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81207,"Error processing message in producer."], 0));
var state_81241__$1 = state_81241;
var statearr_81283_81342 = state_81241__$1;
(statearr_81283_81342[(2)] = inst_81213);

(statearr_81283_81342[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (25))){
var state_81241__$1 = state_81241;
var statearr_81284_81343 = state_81241__$1;
(statearr_81284_81343[(2)] = null);

(statearr_81284_81343[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (34))){
var inst_81207 = (state_81241[(8)]);
var inst_81220 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_81207], 0));
var state_81241__$1 = state_81241;
var statearr_81285_81344 = state_81241__$1;
(statearr_81285_81344[(2)] = inst_81220);

(statearr_81285_81344[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (17))){
var inst_81121 = (state_81241[(23)]);
var inst_81132 = (state_81241[(10)]);
var inst_81139 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81132,inst_81121);
var state_81241__$1 = state_81241;
var statearr_81286_81345 = state_81241__$1;
(statearr_81286_81345[(2)] = inst_81139);

(statearr_81286_81345[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (3))){
var inst_81239 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81241__$1,inst_81239);
} else {
if((state_val_81242 === (12))){
var state_81241__$1 = state_81241;
var statearr_81287_81346 = state_81241__$1;
(statearr_81287_81346[(2)] = null);

(statearr_81287_81346[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (2))){
var state_81241__$1 = state_81241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81241__$1,(4),req_chan);
} else {
if((state_val_81242 === (23))){
var inst_81156 = (state_81241[(12)]);
var inst_81157 = (state_81241[(16)]);
var inst_81163 = (state_81241[(18)]);
var inst_81201 = (state_81241[(2)]);
var inst_81202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81203 = [inst_81156,inst_81163,inst_81157];
var inst_81204 = (new cljs.core.PersistentVector(null,3,(5),inst_81202,inst_81203,null));
var inst_81205 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_81204) : publish_fn.call(null,conn,inst_81204));
var state_81241__$1 = (function (){var statearr_81288 = state_81241;
(statearr_81288[(24)] = inst_81201);

return statearr_81288;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81241__$1,(24),inst_81205);
} else {
if((state_val_81242 === (35))){
var state_81241__$1 = state_81241;
var statearr_81289_81347 = state_81241__$1;
(statearr_81289_81347[(2)] = null);

(statearr_81289_81347[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (19))){
var inst_81145 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
var statearr_81290_81348 = state_81241__$1;
(statearr_81290_81348[(2)] = inst_81145);

(statearr_81290_81348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (11))){
var inst_81119 = (state_81241[(9)]);
var state_81241__$1 = state_81241;
var statearr_81291_81349 = state_81241__$1;
(statearr_81291_81349[(2)] = inst_81119);

(statearr_81291_81349[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (9))){
var inst_81116 = (state_81241[(7)]);
var inst_81232 = (state_81241[(2)]);
var inst_81233 = (inst_81116 + (1));
var inst_81116__$1 = inst_81233;
var state_81241__$1 = (function (){var statearr_81292 = state_81241;
(statearr_81292[(7)] = inst_81116__$1);

(statearr_81292[(25)] = inst_81232);

return statearr_81292;
})();
var statearr_81293_81350 = state_81241__$1;
(statearr_81293_81350[(2)] = null);

(statearr_81293_81350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (5))){
var state_81241__$1 = state_81241;
var statearr_81294_81351 = state_81241__$1;
(statearr_81294_81351[(2)] = null);

(statearr_81294_81351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (14))){
var inst_81132 = (state_81241[(10)]);
var inst_81134 = fluree.db.util.async.channel_QMARK_(inst_81132);
var state_81241__$1 = state_81241;
var statearr_81295_81352 = state_81241__$1;
(statearr_81295_81352[(2)] = inst_81134);

(statearr_81295_81352[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (26))){
var inst_81207 = (state_81241[(8)]);
var inst_81211 = fluree.db.util.core.exception_QMARK_(inst_81207);
var state_81241__$1 = state_81241;
if(inst_81211){
var statearr_81296_81353 = state_81241__$1;
(statearr_81296_81353[(1)] = (28));

} else {
var statearr_81297_81354 = state_81241__$1;
(statearr_81297_81354[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (16))){
var inst_81137 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
if(cljs.core.truth_(inst_81137)){
var statearr_81298_81355 = state_81241__$1;
(statearr_81298_81355[(1)] = (17));

} else {
var statearr_81299_81356 = state_81241__$1;
(statearr_81299_81356[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (30))){
var inst_81227 = (state_81241[(2)]);
var state_81241__$1 = state_81241;
var statearr_81300_81357 = state_81241__$1;
(statearr_81300_81357[(2)] = inst_81227);

(statearr_81300_81357[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (10))){
var inst_81119 = (state_81241[(9)]);
var inst_81121 = (state_81241[(2)]);
var inst_81125 = cljs.core.sequential_QMARK_(inst_81119);
var state_81241__$1 = (function (){var statearr_81301 = state_81241;
(statearr_81301[(23)] = inst_81121);

return statearr_81301;
})();
if(inst_81125){
var statearr_81302_81358 = state_81241__$1;
(statearr_81302_81358[(1)] = (11));

} else {
var statearr_81303_81359 = state_81241__$1;
(statearr_81303_81359[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (18))){
var inst_81121 = (state_81241[(23)]);
var inst_81119 = (state_81241[(9)]);
var inst_81141 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81119], 0));
var inst_81142 = ["Error processing ledger request, no valid return channel: ",inst_81141].join('');
var inst_81143 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81121,inst_81142], 0));
var state_81241__$1 = state_81241;
var statearr_81304_81360 = state_81241__$1;
(statearr_81304_81360[(2)] = inst_81143);

(statearr_81304_81360[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81242 === (8))){
var inst_81159 = (state_81241[(11)]);
var inst_81160 = (state_81241[(13)]);
var inst_81158 = (state_81241[(15)]);
var inst_81119 = (state_81241[(9)]);
var _ = (function (){var statearr_81305 = state_81241;
(statearr_81305[(4)] = cljs.core.cons((20),(state_81241[(4)])));

return statearr_81305;
})();
var inst_81155 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_81119], 0));
var inst_81156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81119,(0),null);
var inst_81157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81119,(1),null);
var inst_81158__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81119,(2),null);
var inst_81159__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81119,(3),null);
var inst_81160__$1 = cljs.core.__destructure_map(inst_81159__$1);
var inst_81161 = fluree.db.util.core.random_uuid();
var inst_81162 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81161);
var inst_81163 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_81160__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_81162);
var inst_81164 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_81160__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_81241__$1 = (function (){var statearr_81306 = state_81241;
(statearr_81306[(11)] = inst_81159__$1);

(statearr_81306[(12)] = inst_81156);

(statearr_81306[(13)] = inst_81160__$1);

(statearr_81306[(14)] = inst_81164);

(statearr_81306[(15)] = inst_81158__$1);

(statearr_81306[(16)] = inst_81157);

(statearr_81306[(17)] = inst_81155);

(statearr_81306[(18)] = inst_81163);

return statearr_81306;
})();
if(cljs.core.truth_(inst_81158__$1)){
var statearr_81307_81361 = state_81241__$1;
(statearr_81307_81361[(1)] = (21));

} else {
var statearr_81308_81362 = state_81241__$1;
(statearr_81308_81362[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__17178__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__17178__auto____0 = (function (){
var statearr_81309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81309[(0)] = fluree$db$connection$msg_producer_$_state_machine__17178__auto__);

(statearr_81309[(1)] = (1));

return statearr_81309;
});
var fluree$db$connection$msg_producer_$_state_machine__17178__auto____1 = (function (state_81241){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81241);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81310){var ex__17181__auto__ = e81310;
var statearr_81311_81363 = state_81241;
(statearr_81311_81363[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81241[(4)]))){
var statearr_81312_81364 = state_81241;
(statearr_81312_81364[(1)] = cljs.core.first((state_81241[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81365 = state_81241;
state_81241 = G__81365;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__17178__auto__ = function(state_81241){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__17178__auto____1.call(this,state_81241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__17178__auto____0;
fluree$db$connection$msg_producer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__17178__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81313 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81313[(6)] = c__17304__auto__);

return statearr_81313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__81366 = conn;
var map__81366__$1 = cljs.core.__destructure_map(map__81366);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81366__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81451){
var state_val_81452 = (state_81451[(1)]);
if((state_val_81452 === (7))){
var inst_81447 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81453_81504 = state_81451__$1;
(statearr_81453_81504[(2)] = inst_81447);

(statearr_81453_81504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (20))){
var inst_81385 = (state_81451[(7)]);
var inst_81399 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_81400 = [inst_81385];
var inst_81401 = cljs.core.PersistentHashMap.fromArrays(inst_81399,inst_81400);
var inst_81402 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_81401], 0));
var state_81451__$1 = state_81451;
var statearr_81454_81505 = state_81451__$1;
(statearr_81454_81505[(2)] = inst_81402);

(statearr_81454_81505[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (27))){
var state_81451__$1 = state_81451;
var statearr_81455_81506 = state_81451__$1;
(statearr_81455_81506[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (1))){
var inst_81367 = (0);
var state_81451__$1 = (function (){var statearr_81457 = state_81451;
(statearr_81457[(8)] = inst_81367);

return statearr_81457;
})();
var statearr_81458_81507 = state_81451__$1;
(statearr_81458_81507[(2)] = null);

(statearr_81458_81507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (24))){
var inst_81378 = (state_81451[(9)]);
var inst_81427 = fluree.db.util.core.exception_QMARK_(inst_81378);
var state_81451__$1 = state_81451;
if(inst_81427){
var statearr_81459_81508 = state_81451__$1;
(statearr_81459_81508[(1)] = (26));

} else {
var statearr_81460_81509 = state_81451__$1;
(statearr_81460_81509[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (4))){
var inst_81372 = (state_81451[(10)]);
var inst_81377 = (state_81451[(2)]);
var inst_81378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81377,(0),null);
var inst_81379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81377,(1),null);
var inst_81380 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_81379,inst_81372);
var state_81451__$1 = (function (){var statearr_81461 = state_81451;
(statearr_81461[(9)] = inst_81378);

return statearr_81461;
})();
if(inst_81380){
var statearr_81462_81510 = state_81451__$1;
(statearr_81462_81510[(1)] = (5));

} else {
var statearr_81463_81511 = state_81451__$1;
(statearr_81463_81511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (15))){
var inst_81385 = (state_81451[(7)]);
var inst_81394 = typeof inst_81385 === 'string';
var state_81451__$1 = state_81451;
if(cljs.core.truth_(inst_81394)){
var statearr_81464_81512 = state_81451__$1;
(statearr_81464_81512[(1)] = (17));

} else {
var statearr_81465_81513 = state_81451__$1;
(statearr_81465_81513[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (21))){
var state_81451__$1 = state_81451;
var statearr_81466_81514 = state_81451__$1;
(statearr_81466_81514[(2)] = null);

(statearr_81466_81514[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (31))){
var inst_81441 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81467_81515 = state_81451__$1;
(statearr_81467_81515[(2)] = inst_81441);

(statearr_81467_81515[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (13))){
var inst_81411 = (state_81451[(2)]);
var inst_81412 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81413 = fluree.db.connection.close_websocket(inst_81412);
var inst_81414 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81415 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_81414);
var state_81451__$1 = (function (){var statearr_81468 = state_81451;
(statearr_81468[(11)] = inst_81413);

(statearr_81468[(12)] = inst_81411);

return statearr_81468;
})();
var statearr_81469_81516 = state_81451__$1;
(statearr_81469_81516[(2)] = inst_81415);

(statearr_81469_81516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (22))){
var inst_81405 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81470_81517 = state_81451__$1;
(statearr_81470_81517[(2)] = inst_81405);

(statearr_81470_81517[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (29))){
var inst_81378 = (state_81451[(9)]);
var inst_81433 = fluree.db.util.json.parse(inst_81378);
var inst_81434 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81433], 0));
var inst_81435 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_81434], 0));
var inst_81436 = fluree.db.util.json.parse(inst_81378);
var inst_81437 = fluree.db.conn_events.process_events(conn,inst_81436);
var inst_81367 = (0);
var state_81451__$1 = (function (){var statearr_81471 = state_81451;
(statearr_81471[(13)] = inst_81435);

(statearr_81471[(14)] = inst_81437);

(statearr_81471[(8)] = inst_81367);

return statearr_81471;
})();
var statearr_81472_81518 = state_81451__$1;
(statearr_81472_81518[(2)] = null);

(statearr_81472_81518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (6))){
var inst_81378 = (state_81451[(9)]);
var inst_81423 = (inst_81378 == null);
var state_81451__$1 = state_81451;
if(cljs.core.truth_(inst_81423)){
var statearr_81473_81519 = state_81451__$1;
(statearr_81473_81519[(1)] = (23));

} else {
var statearr_81474_81520 = state_81451__$1;
(statearr_81474_81520[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (28))){
var inst_81443 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81475_81521 = state_81451__$1;
(statearr_81475_81521[(2)] = inst_81443);

(statearr_81475_81521[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (25))){
var inst_81445 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81476_81522 = state_81451__$1;
(statearr_81476_81522[(2)] = inst_81445);

(statearr_81476_81522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (17))){
var inst_81385 = (state_81451[(7)]);
var inst_81396 = cljs.core.eval(inst_81385);
var state_81451__$1 = state_81451;
var statearr_81477_81523 = state_81451__$1;
(statearr_81477_81523[(2)] = inst_81396);

(statearr_81477_81523[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (3))){
var inst_81449 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81451__$1,inst_81449);
} else {
if((state_val_81452 === (12))){
var inst_81385 = (state_81451[(7)]);
var inst_81390 = cljs.core.fn_QMARK_(inst_81385);
var state_81451__$1 = state_81451;
if(inst_81390){
var statearr_81478_81524 = state_81451__$1;
(statearr_81478_81524[(1)] = (14));

} else {
var statearr_81479_81525 = state_81451__$1;
(statearr_81479_81525[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (2))){
var inst_81372 = (state_81451[(10)]);
var inst_81372__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_81373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81374 = [sub_chan,inst_81372__$1];
var inst_81375 = (new cljs.core.PersistentVector(null,2,(5),inst_81373,inst_81374,null));
var state_81451__$1 = (function (){var statearr_81480 = state_81451;
(statearr_81480[(10)] = inst_81372__$1);

return statearr_81480;
})();
return cljs.core.async.ioc_alts_BANG_(state_81451__$1,(4),inst_81375);
} else {
if((state_val_81452 === (23))){
var inst_81425 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_81451__$1 = state_81451;
var statearr_81481_81526 = state_81451__$1;
(statearr_81481_81526[(2)] = inst_81425);

(statearr_81481_81526[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (19))){
var inst_81407 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81482_81527 = state_81451__$1;
(statearr_81482_81527[(2)] = inst_81407);

(statearr_81482_81527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (11))){
var inst_81388 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_81451__$1 = state_81451;
var statearr_81483_81528 = state_81451__$1;
(statearr_81483_81528[(2)] = inst_81388);

(statearr_81483_81528[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (9))){
var inst_81367 = (state_81451[(8)]);
var inst_81417 = fluree.db.connection.ping_transactor(conn);
var inst_81418 = (inst_81367 + (1));
var inst_81367__$1 = inst_81418;
var state_81451__$1 = (function (){var statearr_81484 = state_81451;
(statearr_81484[(15)] = inst_81417);

(statearr_81484[(8)] = inst_81367__$1);

return statearr_81484;
})();
var statearr_81485_81529 = state_81451__$1;
(statearr_81485_81529[(2)] = null);

(statearr_81485_81529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (5))){
var inst_81367 = (state_81451[(8)]);
var inst_81382 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_81367);
var state_81451__$1 = state_81451;
if(inst_81382){
var statearr_81486_81530 = state_81451__$1;
(statearr_81486_81530[(1)] = (8));

} else {
var statearr_81487_81531 = state_81451__$1;
(statearr_81487_81531[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (14))){
var inst_81385 = (state_81451[(7)]);
var inst_81392 = (inst_81385.cljs$core$IFn$_invoke$arity$0 ? inst_81385.cljs$core$IFn$_invoke$arity$0() : inst_81385.call(null));
var state_81451__$1 = state_81451;
var statearr_81488_81532 = state_81451__$1;
(statearr_81488_81532[(2)] = inst_81392);

(statearr_81488_81532[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (26))){
var inst_81378 = (state_81451[(9)]);
var inst_81429 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81378], 0));
var inst_81367 = (0);
var state_81451__$1 = (function (){var statearr_81489 = state_81451;
(statearr_81489[(16)] = inst_81429);

(statearr_81489[(8)] = inst_81367);

return statearr_81489;
})();
var statearr_81490_81533 = state_81451__$1;
(statearr_81490_81533[(2)] = null);

(statearr_81490_81533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (16))){
var inst_81409 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81491_81534 = state_81451__$1;
(statearr_81491_81534[(2)] = inst_81409);

(statearr_81491_81534[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (30))){
var state_81451__$1 = state_81451;
var statearr_81492_81535 = state_81451__$1;
(statearr_81492_81535[(2)] = null);

(statearr_81492_81535[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (10))){
var inst_81421 = (state_81451[(2)]);
var state_81451__$1 = state_81451;
var statearr_81493_81536 = state_81451__$1;
(statearr_81493_81536[(2)] = inst_81421);

(statearr_81493_81536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (18))){
var state_81451__$1 = state_81451;
var statearr_81494_81537 = state_81451__$1;
(statearr_81494_81537[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81452 === (8))){
var inst_81385 = (state_81451[(7)]);
var inst_81384 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_81385__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81386 = (inst_81385__$1 == null);
var state_81451__$1 = (function (){var statearr_81496 = state_81451;
(statearr_81496[(17)] = inst_81384);

(statearr_81496[(7)] = inst_81385__$1);

return statearr_81496;
})();
if(cljs.core.truth_(inst_81386)){
var statearr_81497_81538 = state_81451__$1;
(statearr_81497_81538[(1)] = (11));

} else {
var statearr_81498_81539 = state_81451__$1;
(statearr_81498_81539[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__17178__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__17178__auto____0 = (function (){
var statearr_81499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81499[(0)] = fluree$db$connection$msg_consumer_$_state_machine__17178__auto__);

(statearr_81499[(1)] = (1));

return statearr_81499;
});
var fluree$db$connection$msg_consumer_$_state_machine__17178__auto____1 = (function (state_81451){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81451);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81500){var ex__17181__auto__ = e81500;
var statearr_81501_81540 = state_81451;
(statearr_81501_81540[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81451[(4)]))){
var statearr_81502_81541 = state_81451;
(statearr_81502_81541[(1)] = cljs.core.first((state_81451[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81542 = state_81451;
state_81451 = G__81542;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__17178__auto__ = function(state_81451){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__17178__auto____1.call(this,state_81451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__17178__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__17178__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81503 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81503[(6)] = c__17304__auto__);

return statearr_81503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__81544 = arguments.length;
switch (G__81544) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__81545 = opts;
var map__81545__$1 = cljs.core.__destructure_map(map__81545);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81545__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81545__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81597){
var state_val_81598 = (state_81597[(1)]);
if((state_val_81598 === (7))){
var inst_81555 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_81556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81557 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_81558 = (new cljs.core.PersistentVector(null,2,(5),inst_81556,inst_81557,null));
var inst_81559 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_81555,inst_81558);
var state_81597__$1 = state_81597;
var statearr_81599_81630 = state_81597__$1;
(statearr_81599_81630[(2)] = inst_81559);

(statearr_81599_81630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (1))){
var state_81597__$1 = state_81597;
var statearr_81600_81631 = state_81597__$1;
(statearr_81600_81631[(2)] = null);

(statearr_81600_81631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (4))){
var inst_81546 = (state_81597[(2)]);
var state_81597__$1 = state_81597;
var statearr_81601_81632 = state_81597__$1;
(statearr_81601_81632[(2)] = inst_81546);

(statearr_81601_81632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (15))){
var inst_81566 = (state_81597[(7)]);
var inst_81585 = (state_81597[(2)]);
var inst_81586 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_81587 = [(5000),inst_81585,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_81588 = cljs.core.PersistentHashMap.fromArrays(inst_81586,inst_81587);
var inst_81589 = fluree.db.util.xhttp.get(inst_81566,inst_81588);
var state_81597__$1 = state_81597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81597__$1,(16),inst_81589);
} else {
if((state_val_81598 === (13))){
var inst_81576 = (state_81597[(8)]);
var inst_81566 = (state_81597[(7)]);
var inst_81578 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_81579 = [inst_81576];
var inst_81580 = cljs.core.PersistentHashMap.fromArrays(inst_81578,inst_81579);
var inst_81581 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_81566,inst_81580,private$);
var inst_81582 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_81581);
var state_81597__$1 = state_81597;
var statearr_81602_81633 = state_81597__$1;
(statearr_81602_81633[(2)] = inst_81582);

(statearr_81602_81633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (6))){
var inst_81552 = (state_81597[(9)]);
var state_81597__$1 = state_81597;
var statearr_81603_81634 = state_81597__$1;
(statearr_81603_81634[(2)] = inst_81552);

(statearr_81603_81634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (3))){
var inst_81595 = (state_81597[(2)]);
var state_81597__$1 = state_81597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81597__$1,inst_81595);
} else {
if((state_val_81598 === (12))){
var inst_81576 = (state_81597[(2)]);
var state_81597__$1 = (function (){var statearr_81604 = state_81597;
(statearr_81604[(8)] = inst_81576);

return statearr_81604;
})();
if(cljs.core.truth_(private$)){
var statearr_81605_81635 = state_81597__$1;
(statearr_81605_81635[(1)] = (13));

} else {
var statearr_81606_81636 = state_81597__$1;
(statearr_81606_81636[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (2))){
var inst_81552 = (state_81597[(9)]);
var _ = (function (){var statearr_81607 = state_81597;
(statearr_81607[(4)] = cljs.core.cons((5),(state_81597[(4)])));

return statearr_81607;
})();
var inst_81552__$1 = jwt;
var state_81597__$1 = (function (){var statearr_81608 = state_81597;
(statearr_81608[(9)] = inst_81552__$1);

return statearr_81608;
})();
if(cljs.core.truth_(inst_81552__$1)){
var statearr_81609_81637 = state_81597__$1;
(statearr_81609_81637[(1)] = (6));

} else {
var statearr_81610_81638 = state_81597__$1;
(statearr_81610_81638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (11))){
var inst_81570 = (state_81597[(10)]);
var state_81597__$1 = state_81597;
var statearr_81612_81639 = state_81597__$1;
(statearr_81612_81639[(2)] = inst_81570);

(statearr_81612_81639[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (9))){
var inst_81562 = (state_81597[(11)]);
var inst_81561 = (state_81597[(12)]);
var inst_81565 = (state_81597[(2)]);
var inst_81566 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81565),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81562)].join('');
var inst_81568 = ["Accept"];
var inst_81569 = ["application/json"];
var inst_81570 = cljs.core.PersistentHashMap.fromArrays(inst_81568,inst_81569);
var state_81597__$1 = (function (){var statearr_81613 = state_81597;
(statearr_81613[(10)] = inst_81570);

(statearr_81613[(7)] = inst_81566);

return statearr_81613;
})();
if(cljs.core.truth_(inst_81561)){
var statearr_81614_81640 = state_81597__$1;
(statearr_81614_81640[(1)] = (10));

} else {
var statearr_81615_81641 = state_81597__$1;
(statearr_81615_81641[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (5))){
var _ = (function (){var statearr_81616 = state_81597;
(statearr_81616[(4)] = cljs.core.rest((state_81597[(4)])));

return statearr_81616;
})();
var state_81597__$1 = state_81597;
var ex81611 = (state_81597__$1[(2)]);
var statearr_81617_81642 = state_81597__$1;
(statearr_81617_81642[(5)] = ex81611);


if((ex81611 instanceof Error)){
var statearr_81618_81643 = state_81597__$1;
(statearr_81618_81643[(1)] = (4));

(statearr_81618_81643[(5)] = null);

} else {
throw ex81611;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (14))){
var inst_81576 = (state_81597[(8)]);
var state_81597__$1 = state_81597;
var statearr_81619_81644 = state_81597__$1;
(statearr_81619_81644[(2)] = inst_81576);

(statearr_81619_81644[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (16))){
var inst_81591 = (state_81597[(2)]);
var inst_81592 = fluree.db.util.async.throw_err(inst_81591);
var _ = (function (){var statearr_81620 = state_81597;
(statearr_81620[(4)] = cljs.core.rest((state_81597[(4)])));

return statearr_81620;
})();
var state_81597__$1 = state_81597;
var statearr_81621_81645 = state_81597__$1;
(statearr_81621_81645[(2)] = inst_81592);

(statearr_81621_81645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (10))){
var inst_81561 = (state_81597[(12)]);
var inst_81570 = (state_81597[(10)]);
var inst_81572 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81561)].join('');
var inst_81573 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_81570,"Authorization",inst_81572);
var state_81597__$1 = state_81597;
var statearr_81622_81646 = state_81597__$1;
(statearr_81622_81646[(2)] = inst_81573);

(statearr_81622_81646[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81598 === (8))){
var inst_81561 = (state_81597[(2)]);
var inst_81562 = clojure.string.replace(k,"_","/");
var inst_81563 = fluree.db.connection.get_server(conn_id,servers);
var state_81597__$1 = (function (){var statearr_81623 = state_81597;
(statearr_81623[(11)] = inst_81562);

(statearr_81623[(12)] = inst_81561);

return statearr_81623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81597__$1,(9),inst_81563);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__17178__auto__ = null;
var fluree$db$connection$state_machine__17178__auto____0 = (function (){
var statearr_81624 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81624[(0)] = fluree$db$connection$state_machine__17178__auto__);

(statearr_81624[(1)] = (1));

return statearr_81624;
});
var fluree$db$connection$state_machine__17178__auto____1 = (function (state_81597){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81597);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81625){var ex__17181__auto__ = e81625;
var statearr_81626_81647 = state_81597;
(statearr_81626_81647[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81597[(4)]))){
var statearr_81627_81648 = state_81597;
(statearr_81627_81648[(1)] = cljs.core.first((state_81597[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81649 = state_81597;
state_81597 = G__81649;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$state_machine__17178__auto__ = function(state_81597){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__17178__auto____1.call(this,state_81597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__17178__auto____0;
fluree$db$connection$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__17178__auto____1;
return fluree$db$connection$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81628 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81628[(6)] = c__17304__auto__);

return statearr_81628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__81650_SHARP_){
if(cljs.core.truth_(p1__81650_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__81651_SHARP_){
var or__4212__auto__ = p1__81651_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e81652){var e = e81652;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__81653 = opts;
var map__81653__$1 = cljs.core.__destructure_map(map__81653);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__81653__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__81653__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__81654_81655 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__81654_81655.cljs$core$IFn$_invoke$arity$0 ? fexpr__81654_81655.cljs$core$IFn$_invoke$arity$0() : fexpr__81654_81655.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81696 = arguments.length;
var i__4819__auto___81697 = (0);
while(true){
if((i__4819__auto___81697 < len__4818__auto___81696)){
args__4824__auto__.push((arguments[i__4819__auto___81697]));

var G__81698 = (i__4819__auto___81697 + (1));
i__4819__auto___81697 = G__81698;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__81658){
var vec__81659 = p__81658;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81659,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__17304__auto___81699 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81679){
var state_val_81680 = (state_81679[(1)]);
if((state_val_81680 === (1))){
var inst_81662 = fluree.db.connection.get_socket(conn);
var state_81679__$1 = state_81679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81679__$1,(2),inst_81662);
} else {
if((state_val_81680 === (2))){
var inst_81665 = (state_81679[(7)]);
var inst_81664 = (state_81679[(8)]);
var inst_81664__$1 = (state_81679[(2)]);
var inst_81665__$1 = (inst_81664__$1 == null);
var state_81679__$1 = (function (){var statearr_81681 = state_81679;
(statearr_81681[(7)] = inst_81665__$1);

(statearr_81681[(8)] = inst_81664__$1);

return statearr_81681;
})();
if(cljs.core.truth_(inst_81665__$1)){
var statearr_81682_81700 = state_81679__$1;
(statearr_81682_81700[(1)] = (3));

} else {
var statearr_81683_81701 = state_81679__$1;
(statearr_81683_81701[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (3))){
var inst_81665 = (state_81679[(7)]);
var state_81679__$1 = state_81679;
var statearr_81684_81702 = state_81679__$1;
(statearr_81684_81702[(2)] = inst_81665);

(statearr_81684_81702[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (4))){
var inst_81664 = (state_81679[(8)]);
var inst_81668 = fluree.db.util.core.exception_QMARK_(inst_81664);
var state_81679__$1 = state_81679;
var statearr_81685_81703 = state_81679__$1;
(statearr_81685_81703[(2)] = inst_81668);

(statearr_81685_81703[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (5))){
var inst_81670 = (state_81679[(2)]);
var state_81679__$1 = state_81679;
if(cljs.core.truth_(inst_81670)){
var statearr_81686_81704 = state_81679__$1;
(statearr_81686_81704[(1)] = (6));

} else {
var statearr_81687_81705 = state_81679__$1;
(statearr_81687_81705[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (6))){
var inst_81664 = (state_81679[(8)]);
var inst_81672 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81664,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_81673 = cljs.core.async.close_BANG_(conn);
var state_81679__$1 = (function (){var statearr_81688 = state_81679;
(statearr_81688[(9)] = inst_81672);

return statearr_81688;
})();
var statearr_81689_81706 = state_81679__$1;
(statearr_81689_81706[(2)] = inst_81673);

(statearr_81689_81706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (7))){
var inst_81675 = fluree.db.connection.msg_consumer(conn);
var state_81679__$1 = state_81679;
var statearr_81690_81707 = state_81679__$1;
(statearr_81690_81707[(2)] = inst_81675);

(statearr_81690_81707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81680 === (8))){
var inst_81677 = (state_81679[(2)]);
var state_81679__$1 = state_81679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81679__$1,inst_81677);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__17178__auto__ = null;
var fluree$db$connection$state_machine__17178__auto____0 = (function (){
var statearr_81691 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81691[(0)] = fluree$db$connection$state_machine__17178__auto__);

(statearr_81691[(1)] = (1));

return statearr_81691;
});
var fluree$db$connection$state_machine__17178__auto____1 = (function (state_81679){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81679);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81692){var ex__17181__auto__ = e81692;
var statearr_81693_81708 = state_81679;
(statearr_81693_81708[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81679[(4)]))){
var statearr_81694_81709 = state_81679;
(statearr_81694_81709[(1)] = cljs.core.first((state_81679[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81710 = state_81679;
state_81679 = G__81710;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection$state_machine__17178__auto__ = function(state_81679){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__17178__auto____1.call(this,state_81679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__17178__auto____0;
fluree$db$connection$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__17178__auto____1;
return fluree$db$connection$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81695 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81695[(6)] = c__17304__auto___81699);

return statearr_81695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq81656){
var G__81657 = cljs.core.first(seq81656);
var seq81656__$1 = cljs.core.next(seq81656);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81657,seq81656__$1);
}));

