// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__37417 = arguments.length;
switch (G__37417) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__37420 = arguments.length;
switch (G__37420) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___37473 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37451){
var state_val_37452 = (state_37451[(1)]);
if((state_val_37452 === (1))){
var state_37451__$1 = state_37451;
var statearr_37453_37474 = state_37451__$1;
(statearr_37453_37474[(2)] = null);

(statearr_37453_37474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (2))){
var _ = (function (){var statearr_37454 = state_37451;
(statearr_37454[(4)] = cljs.core.cons((5),(state_37451[(4)])));

return statearr_37454;
})();
var inst_37428 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_37451__$1 = state_37451;
if(cljs.core.truth_(inst_37428)){
var statearr_37455_37475 = state_37451__$1;
(statearr_37455_37475[(1)] = (6));

} else {
var statearr_37456_37476 = state_37451__$1;
(statearr_37456_37476[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (3))){
var inst_37449 = (state_37451[(2)]);
var state_37451__$1 = state_37451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37451__$1,inst_37449);
} else {
if((state_val_37452 === (4))){
var inst_37421 = (state_37451[(2)]);
var inst_37422 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_37421);
var state_37451__$1 = state_37451;
var statearr_37458_37477 = state_37451__$1;
(statearr_37458_37477[(2)] = inst_37422);

(statearr_37458_37477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (5))){
var _ = (function (){var statearr_37459 = state_37451;
(statearr_37459[(4)] = cljs.core.rest((state_37451[(4)])));

return statearr_37459;
})();
var state_37451__$1 = state_37451;
var ex37457 = (state_37451__$1[(2)]);
var statearr_37460_37478 = state_37451__$1;
(statearr_37460_37478[(5)] = ex37457);


var statearr_37461_37479 = state_37451__$1;
(statearr_37461_37479[(1)] = (4));

(statearr_37461_37479[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (6))){
var inst_37430 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37431 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_37432 = cljs.core.PersistentHashMap.fromArrays(inst_37430,inst_37431);
var inst_37433 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_37432);
var inst_37434 = (function(){throw inst_37433})();
var state_37451__$1 = state_37451;
var statearr_37462_37480 = state_37451__$1;
(statearr_37462_37480[(2)] = inst_37434);

(statearr_37462_37480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (7))){
var inst_37436 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_37437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37438 = [operation,data,pc,opts];
var inst_37439 = (new cljs.core.PersistentVector(null,4,(5),inst_37437,inst_37438,null));
var inst_37440 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37436,inst_37439);
var inst_37441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37442 = [operation,data,pc,opts];
var inst_37443 = (new cljs.core.PersistentVector(null,4,(5),inst_37441,inst_37442,null));
var inst_37444 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_37443], 0));
var state_37451__$1 = (function (){var statearr_37463 = state_37451;
(statearr_37463[(7)] = inst_37440);

return statearr_37463;
})();
var statearr_37464_37481 = state_37451__$1;
(statearr_37464_37481[(2)] = inst_37444);

(statearr_37464_37481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37452 === (8))){
var inst_37446 = (state_37451[(2)]);
var _ = (function (){var statearr_37465 = state_37451;
(statearr_37465[(4)] = cljs.core.rest((state_37451[(4)])));

return statearr_37465;
})();
var state_37451__$1 = state_37451;
var statearr_37466_37482 = state_37451__$1;
(statearr_37466_37482[(2)] = inst_37446);

(statearr_37466_37482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__17178__auto__ = null;
var fluree$db$operations$state_machine__17178__auto____0 = (function (){
var statearr_37467 = [null,null,null,null,null,null,null,null];
(statearr_37467[(0)] = fluree$db$operations$state_machine__17178__auto__);

(statearr_37467[(1)] = (1));

return statearr_37467;
});
var fluree$db$operations$state_machine__17178__auto____1 = (function (state_37451){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37451);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37468){var ex__17181__auto__ = e37468;
var statearr_37469_37483 = state_37451;
(statearr_37469_37483[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37451[(4)]))){
var statearr_37470_37484 = state_37451;
(statearr_37470_37484[(1)] = cljs.core.first((state_37451[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37485 = state_37451;
state_37451 = G__37485;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$operations$state_machine__17178__auto__ = function(state_37451){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__17178__auto____1.call(this,state_37451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__17178__auto____0;
fluree$db$operations$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__17178__auto____1;
return fluree$db$operations$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37471 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37471[(6)] = c__17304__auto___37473);

return statearr_37471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__37487 = arguments.length;
switch (G__37487) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__37488){
var map__37489 = p__37488;
var map__37489__$1 = cljs.core.__destructure_map(map__37489);
var opts = map__37489__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37489__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__37490 = session;
var map__37490__$1 = cljs.core.__destructure_map(map__37490);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37490__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37490__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37490__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___37517 = arguments.length;
var i__4819__auto___37518 = (0);
while(true){
if((i__4819__auto___37518 < len__4818__auto___37517)){
args__4824__auto__.push((arguments[i__4819__auto___37518]));

var G__37519 = (i__4819__auto___37518 + (1));
i__4819__auto___37518 = G__37519;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__37494){
var vec__37495 = p__37494;
var map__37498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37495,(0),null);
var map__37498__$1 = cljs.core.__destructure_map(map__37498);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37498__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37498__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__37495;
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37510){
var state_val_37511 = (state_37510[(1)]);
if((state_val_37511 === (1))){
var inst_37500 = session;
var inst_37501 = cljs.core.__destructure_map(inst_37500);
var inst_37502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37501,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_37503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37501,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_37504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37501,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_37505 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_37506 = [inst_37502,inst_37503,toBlock,toTime];
var inst_37507 = cljs.core.PersistentHashMap.fromArrays(inst_37505,inst_37506);
var inst_37508 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_37504,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_37507);
var state_37510__$1 = state_37510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37510__$1,inst_37508);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__17178__auto__ = null;
var fluree$db$operations$state_machine__17178__auto____0 = (function (){
var statearr_37512 = [null,null,null,null,null,null,null];
(statearr_37512[(0)] = fluree$db$operations$state_machine__17178__auto__);

(statearr_37512[(1)] = (1));

return statearr_37512;
});
var fluree$db$operations$state_machine__17178__auto____1 = (function (state_37510){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37510);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37513){var ex__17181__auto__ = e37513;
var statearr_37514_37520 = state_37510;
(statearr_37514_37520[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37510[(4)]))){
var statearr_37515_37521 = state_37510;
(statearr_37515_37521[(1)] = cljs.core.first((state_37510[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37522 = state_37510;
state_37510 = G__37522;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$operations$state_machine__17178__auto__ = function(state_37510){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__17178__auto____1.call(this,state_37510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__17178__auto____0;
fluree$db$operations$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__17178__auto____1;
return fluree$db$operations$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37516 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37516[(6)] = c__17304__auto__);

return statearr_37516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq37492){
var G__37493 = cljs.core.first(seq37492);
var seq37492__$1 = cljs.core.next(seq37492);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37493,seq37492__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__37523 = session;
var map__37523__$1 = cljs.core.__destructure_map(map__37523);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37523__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37523__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37523__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__37525 = arguments.length;
switch (G__37525) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__37526 = opts;
var map__37526__$1 = cljs.core.__destructure_map(map__37526);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37526__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37526__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
