// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e38797){var e = e38797;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__38798_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__38798_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__38798_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__38798_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__38798_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38799_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38799_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38800_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38800_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__38805 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38801_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38801_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__38808 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38808,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38808,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38802_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38802_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38803_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38803_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__38804_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__38804_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38811_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__38811_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__38812 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__38812) : intersecting_vars.call(null,G__38812));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__38815,optional_QMARK_,fuel,max_fuel){
var map__38816 = p__38815;
var map__38816__$1 = cljs.core.__destructure_map(map__38816);
var res = map__38816__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38816__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38882){
var state_val_38883 = (state_38882[(1)]);
if((state_val_38883 === (7))){
var inst_38871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38872 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_38873 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38872,clause);
var inst_38874 = [null,inst_38873];
var inst_38875 = (new cljs.core.PersistentVector(null,2,(5),inst_38871,inst_38874,null));
var state_38882__$1 = state_38882;
var statearr_38884_38912 = state_38882__$1;
(statearr_38884_38912[(2)] = inst_38875);

(statearr_38884_38912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (1))){
var state_38882__$1 = state_38882;
var statearr_38885_38913 = state_38882__$1;
(statearr_38885_38913[(2)] = null);

(statearr_38885_38913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (4))){
var inst_38817 = (state_38882[(2)]);
var state_38882__$1 = state_38882;
var statearr_38886_38914 = state_38882__$1;
(statearr_38886_38914[(2)] = inst_38817);

(statearr_38886_38914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (15))){
var inst_38860 = (state_38882[(2)]);
var inst_38861 = fluree.db.util.async.throw_err(inst_38860);
var inst_38862 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_38861);
var inst_38863 = cljs.core.count(inst_38862);
var inst_38864 = fluree.db.query.analytical.add_fuel(inst_38863,fuel,max_fuel);
var inst_38865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38866 = [inst_38861,r];
var inst_38867 = (new cljs.core.PersistentVector(null,2,(5),inst_38865,inst_38866,null));
var state_38882__$1 = (function (){var statearr_38887 = state_38882;
(statearr_38887[(7)] = inst_38864);

return statearr_38887;
})();
var statearr_38888_38915 = state_38882__$1;
(statearr_38888_38915[(2)] = inst_38867);

(statearr_38888_38915[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (13))){
var inst_38826 = (state_38882[(8)]);
var inst_38839 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_38840 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_38839);
var inst_38841 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_38826);
var inst_38842 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_38841);
var inst_38843 = cljs.core.set(inst_38842);
var inst_38844 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_38840);
var inst_38845 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_38844);
var inst_38846 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38843,inst_38845);
var inst_38847 = (function (){var all_wd = inst_38826;
var optional = inst_38840;
var all_wd_vars = inst_38843;
var all_vars = inst_38846;
return (function (p1__38813_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__38813_SHARP_) : all_vars.call(null,p1__38813_SHARP_));
});
})();
var inst_38848 = cljs.core.keys(vars);
var inst_38849 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38847,inst_38848);
var inst_38850 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_38849);
var inst_38851 = cljs.core.set(inst_38850);
var inst_38852 = (function (){var all_wd = inst_38826;
var optional = inst_38840;
var all_wd_vars = inst_38843;
var all_vars = inst_38846;
var intersecting_vars = inst_38851;
return (function (p1__38814_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__38814_SHARP_);
});
})();
var inst_38853 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38852,inst_38826);
var inst_38854 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_38853);
var inst_38855 = fluree.db.query.analytical.select_from_tuples(inst_38854,res);
var inst_38856 = fluree.db.query.analytical.replace_vars_wikidata(inst_38826,inst_38851,vars);
var inst_38857 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_38851,inst_38846);
var inst_38858 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_38856,inst_38854,inst_38855,inst_38857,inst_38840);
var state_38882__$1 = state_38882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38882__$1,(15),inst_38858);
} else {
if((state_val_38883 === (6))){
var inst_38827 = (state_38882[(9)]);
var inst_38825 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_38826 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_38825);
var inst_38827__$1 = optional_QMARK_;
var state_38882__$1 = (function (){var statearr_38889 = state_38882;
(statearr_38889[(8)] = inst_38826);

(statearr_38889[(9)] = inst_38827__$1);

return statearr_38889;
})();
if(cljs.core.truth_(inst_38827__$1)){
var statearr_38890_38916 = state_38882__$1;
(statearr_38890_38916[(1)] = (9));

} else {
var statearr_38891_38917 = state_38882__$1;
(statearr_38891_38917[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (3))){
var inst_38880 = (state_38882[(2)]);
var state_38882__$1 = state_38882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38882__$1,inst_38880);
} else {
if((state_val_38883 === (12))){
var inst_38835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38836 = [null,r];
var inst_38837 = (new cljs.core.PersistentVector(null,2,(5),inst_38835,inst_38836,null));
var state_38882__$1 = state_38882;
var statearr_38892_38918 = state_38882__$1;
(statearr_38892_38918[(2)] = inst_38837);

(statearr_38892_38918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (2))){
var _ = (function (){var statearr_38893 = state_38882;
(statearr_38893[(4)] = cljs.core.cons((5),(state_38882[(4)])));

return statearr_38893;
})();
var inst_38823 = (r == null);
var state_38882__$1 = state_38882;
if(cljs.core.truth_(inst_38823)){
var statearr_38894_38919 = state_38882__$1;
(statearr_38894_38919[(1)] = (6));

} else {
var statearr_38895_38920 = state_38882__$1;
(statearr_38895_38920[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (11))){
var inst_38833 = (state_38882[(2)]);
var state_38882__$1 = state_38882;
if(cljs.core.truth_(inst_38833)){
var statearr_38897_38921 = state_38882__$1;
(statearr_38897_38921[(1)] = (12));

} else {
var statearr_38898_38922 = state_38882__$1;
(statearr_38898_38922[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (9))){
var inst_38826 = (state_38882[(8)]);
var inst_38829 = cljs.core.empty_QMARK_(inst_38826);
var inst_38830 = (!(inst_38829));
var state_38882__$1 = state_38882;
var statearr_38899_38923 = state_38882__$1;
(statearr_38899_38923[(2)] = inst_38830);

(statearr_38899_38923[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (5))){
var _ = (function (){var statearr_38900 = state_38882;
(statearr_38900[(4)] = cljs.core.rest((state_38882[(4)])));

return statearr_38900;
})();
var state_38882__$1 = state_38882;
var ex38896 = (state_38882__$1[(2)]);
var statearr_38901_38924 = state_38882__$1;
(statearr_38901_38924[(5)] = ex38896);


if((ex38896 instanceof Error)){
var statearr_38902_38925 = state_38882__$1;
(statearr_38902_38925[(1)] = (4));

(statearr_38902_38925[(5)] = null);

} else {
throw ex38896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (14))){
var inst_38869 = (state_38882[(2)]);
var state_38882__$1 = state_38882;
var statearr_38903_38926 = state_38882__$1;
(statearr_38903_38926[(2)] = inst_38869);

(statearr_38903_38926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (10))){
var inst_38827 = (state_38882[(9)]);
var state_38882__$1 = state_38882;
var statearr_38904_38927 = state_38882__$1;
(statearr_38904_38927[(2)] = inst_38827);

(statearr_38904_38927[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38883 === (8))){
var inst_38877 = (state_38882[(2)]);
var _ = (function (){var statearr_38905 = state_38882;
(statearr_38905[(4)] = cljs.core.rest((state_38882[(4)])));

return statearr_38905;
})();
var state_38882__$1 = state_38882;
var statearr_38906_38928 = state_38882__$1;
(statearr_38906_38928[(2)] = inst_38877);

(statearr_38906_38928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____0 = (function (){
var statearr_38907 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38907[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__);

(statearr_38907[(1)] = (1));

return statearr_38907;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____1 = (function (state_38882){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38882);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38908){var ex__17181__auto__ = e38908;
var statearr_38909_38929 = state_38882;
(statearr_38909_38929[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38882[(4)]))){
var statearr_38910_38930 = state_38882;
(statearr_38910_38930[(1)] = cljs.core.first((state_38882[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38931 = state_38882;
state_38882 = G__38931;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__ = function(state_38882){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____1.call(this,state_38882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38911 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38911[(6)] = c__17304__auto__);

return statearr_38911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__38933 = arguments.length;
switch (G__38933) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_39027){
var state_val_39028 = (state_39027[(1)]);
if((state_val_39028 === (7))){
var inst_38940 = (state_39027[(7)]);
var inst_38950 = clojure.string.starts_with_QMARK_(inst_38940,"$fdb");
var state_39027__$1 = state_39027;
if(inst_38950){
var statearr_39029_39078 = state_39027__$1;
(statearr_39029_39078[(1)] = (9));

} else {
var statearr_39030_39079 = state_39027__$1;
(statearr_39030_39079[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (20))){
var state_39027__$1 = state_39027;
var statearr_39031_39080 = state_39027__$1;
(statearr_39031_39080[(2)] = null);

(statearr_39031_39080[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (27))){
var inst_38990 = (state_39027[(8)]);
var state_39027__$1 = state_39027;
var statearr_39032_39081 = state_39027__$1;
(statearr_39032_39081[(2)] = inst_38990);

(statearr_39032_39081[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (1))){
var state_39027__$1 = state_39027;
var statearr_39033_39082 = state_39027__$1;
(statearr_39033_39082[(2)] = null);

(statearr_39033_39082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (24))){
var inst_39013 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
var statearr_39034_39083 = state_39027__$1;
(statearr_39034_39083[(2)] = inst_39013);

(statearr_39034_39083[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (4))){
var inst_38934 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
var statearr_39035_39084 = state_39027__$1;
(statearr_39035_39084[(2)] = inst_38934);

(statearr_39035_39084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (15))){
var inst_38957 = (state_39027[(9)]);
var inst_38963 = (state_39027[(2)]);
var inst_38964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38965 = cljs.core.PersistentVector.EMPTY;
var inst_38966 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_38967 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38965,inst_38966);
var inst_38968 = [inst_38957,inst_38967];
var inst_38969 = (new cljs.core.PersistentVector(null,2,(5),inst_38964,inst_38968,null));
var state_39027__$1 = (function (){var statearr_39036 = state_39027;
(statearr_39036[(10)] = inst_38963);

return statearr_39036;
})();
var statearr_39037_39085 = state_39027__$1;
(statearr_39037_39085[(2)] = inst_38969);

(statearr_39037_39085[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (21))){
var inst_39016 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
var statearr_39038_39086 = state_39027__$1;
(statearr_39038_39086[(2)] = inst_39016);

(statearr_39038_39086[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (13))){
var inst_38957 = (state_39027[(9)]);
var inst_38960 = (function(){throw inst_38957})();
var state_39027__$1 = state_39027;
var statearr_39039_39087 = state_39027__$1;
(statearr_39039_39087[(2)] = inst_38960);

(statearr_39039_39087[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (22))){
var inst_38981 = (state_39027[(11)]);
var inst_38979 = (state_39027[(12)]);
var inst_38983 = fluree.db.query.analytical.parse_block_from_source(inst_38979);
var inst_38984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38985 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_38981];
var inst_38986 = (new cljs.core.PersistentVector(null,2,(5),inst_38984,inst_38985,null));
var inst_38987 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_38986);
var state_39027__$1 = (function (){var statearr_39040 = state_39027;
(statearr_39040[(13)] = inst_38983);

return statearr_39040;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39027__$1,(25),inst_38987);
} else {
if((state_val_39028 === (29))){
var inst_38994 = (state_39027[(2)]);
var inst_38995 = fluree.db.util.async.throw_err(inst_38994);
var state_39027__$1 = state_39027;
var statearr_39041_39088 = state_39027__$1;
(statearr_39041_39088[(2)] = inst_38995);

(statearr_39041_39088[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (6))){
var inst_38943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38944 = cljs.core.PersistentVector.EMPTY;
var inst_38945 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_38946 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38944,inst_38945);
var inst_38947 = [db,inst_38946];
var inst_38948 = (new cljs.core.PersistentVector(null,2,(5),inst_38943,inst_38947,null));
var state_39027__$1 = state_39027;
var statearr_39042_39089 = state_39027__$1;
(statearr_39042_39089[(2)] = inst_38948);

(statearr_39042_39089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (28))){
var inst_38998 = (state_39027[(2)]);
var inst_38999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39000 = cljs.core.PersistentVector.EMPTY;
var inst_39001 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_39002 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39000,inst_39001);
var inst_39003 = [inst_38998,inst_39002];
var inst_39004 = (new cljs.core.PersistentVector(null,2,(5),inst_38999,inst_39003,null));
var state_39027__$1 = state_39027;
var statearr_39043_39090 = state_39027__$1;
(statearr_39043_39090[(2)] = inst_39004);

(statearr_39043_39090[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (25))){
var inst_38983 = (state_39027[(13)]);
var inst_38989 = (state_39027[(2)]);
var inst_38990 = fluree.db.util.async.throw_err(inst_38989);
var state_39027__$1 = (function (){var statearr_39044 = state_39027;
(statearr_39044[(8)] = inst_38990);

return statearr_39044;
})();
if(cljs.core.truth_(inst_38983)){
var statearr_39045_39091 = state_39027__$1;
(statearr_39045_39091[(1)] = (26));

} else {
var statearr_39046_39092 = state_39027__$1;
(statearr_39046_39092[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (17))){
var state_39027__$1 = state_39027;
var statearr_39047_39093 = state_39027__$1;
(statearr_39047_39093[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (3))){
var inst_39025 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39027__$1,inst_39025);
} else {
if((state_val_39028 === (12))){
var inst_38957 = (state_39027[(9)]);
var inst_38956 = (state_39027[(2)]);
var inst_38957__$1 = fluree.db.util.async.throw_err(inst_38956);
var inst_38958 = fluree.db.util.core.exception_QMARK_(inst_38957__$1);
var state_39027__$1 = (function (){var statearr_39049 = state_39027;
(statearr_39049[(9)] = inst_38957__$1);

return statearr_39049;
})();
if(inst_38958){
var statearr_39050_39094 = state_39027__$1;
(statearr_39050_39094[(1)] = (13));

} else {
var statearr_39051_39095 = state_39027__$1;
(statearr_39051_39095[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (2))){
var inst_38940 = (state_39027[(7)]);
var _ = (function (){var statearr_39052 = state_39027;
(statearr_39052[(4)] = cljs.core.cons((5),(state_39027[(4)])));

return statearr_39052;
})();
var inst_38940__$1 = cljs.core.first(clause);
var inst_38941 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_38940__$1);
var state_39027__$1 = (function (){var statearr_39053 = state_39027;
(statearr_39053[(7)] = inst_38940__$1);

return statearr_39053;
})();
if(inst_38941){
var statearr_39054_39096 = state_39027__$1;
(statearr_39054_39096[(1)] = (6));

} else {
var statearr_39055_39097 = state_39027__$1;
(statearr_39055_39097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (23))){
var inst_38940 = (state_39027[(7)]);
var inst_39006 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38940)," is not supported in Fluree"].join('');
var inst_39007 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39008 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_39009 = cljs.core.PersistentHashMap.fromArrays(inst_39007,inst_39008);
var inst_39010 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39006,inst_39009);
var inst_39011 = (function(){throw inst_39010})();
var state_39027__$1 = state_39027;
var statearr_39056_39098 = state_39027__$1;
(statearr_39056_39098[(2)] = inst_39011);

(statearr_39056_39098[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (19))){
var inst_38940 = (state_39027[(7)]);
var inst_38981 = (state_39027[(11)]);
var inst_38978 = fluree.db.query.analytical.isolate_source_name(inst_38940);
var inst_38979 = fluree.db.query.analytical.isolate_source_block(inst_38940);
var inst_38980 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_38978);
var inst_38981__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_38980);
var state_39027__$1 = (function (){var statearr_39057 = state_39027;
(statearr_39057[(11)] = inst_38981__$1);

(statearr_39057[(12)] = inst_38979);

return statearr_39057;
})();
if(cljs.core.truth_(inst_38981__$1)){
var statearr_39058_39099 = state_39027__$1;
(statearr_39058_39099[(1)] = (22));

} else {
var statearr_39059_39100 = state_39027__$1;
(statearr_39059_39100[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (11))){
var inst_39020 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
var statearr_39061_39101 = state_39027__$1;
(statearr_39061_39101[(2)] = inst_39020);

(statearr_39061_39101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (9))){
var inst_38940 = (state_39027[(7)]);
var inst_38952 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_38940,(4));
var inst_38953 = fluree.db.query.analytical.parse_block_from_source(inst_38952);
var inst_38954 = fluree.db.time_travel.as_of_block(db,inst_38953);
var state_39027__$1 = state_39027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39027__$1,(12),inst_38954);
} else {
if((state_val_39028 === (5))){
var _ = (function (){var statearr_39062 = state_39027;
(statearr_39062[(4)] = cljs.core.rest((state_39027[(4)])));

return statearr_39062;
})();
var state_39027__$1 = state_39027;
var ex39060 = (state_39027__$1[(2)]);
var statearr_39063_39102 = state_39027__$1;
(statearr_39063_39102[(5)] = ex39060);


if((ex39060 instanceof Error)){
var statearr_39064_39103 = state_39027__$1;
(statearr_39064_39103[(1)] = (4));

(statearr_39064_39103[(5)] = null);

} else {
throw ex39060;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (14))){
var state_39027__$1 = state_39027;
var statearr_39065_39104 = state_39027__$1;
(statearr_39065_39104[(2)] = null);

(statearr_39065_39104[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (26))){
var inst_38983 = (state_39027[(13)]);
var inst_38990 = (state_39027[(8)]);
var inst_38992 = fluree.db.time_travel.as_of_block(inst_38990,inst_38983);
var state_39027__$1 = state_39027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39027__$1,(29),inst_38992);
} else {
if((state_val_39028 === (16))){
var inst_38973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38974 = ["$wd",clause];
var inst_38975 = (new cljs.core.PersistentVector(null,2,(5),inst_38973,inst_38974,null));
var state_39027__$1 = state_39027;
var statearr_39066_39105 = state_39027__$1;
(statearr_39066_39105[(2)] = inst_38975);

(statearr_39066_39105[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (10))){
var inst_38940 = (state_39027[(7)]);
var inst_38971 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_38940);
var state_39027__$1 = state_39027;
if(inst_38971){
var statearr_39067_39106 = state_39027__$1;
(statearr_39067_39106[(1)] = (16));

} else {
var statearr_39068_39107 = state_39027__$1;
(statearr_39068_39107[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (18))){
var inst_39018 = (state_39027[(2)]);
var state_39027__$1 = state_39027;
var statearr_39069_39108 = state_39027__$1;
(statearr_39069_39108[(2)] = inst_39018);

(statearr_39069_39108[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39028 === (8))){
var inst_39022 = (state_39027[(2)]);
var _ = (function (){var statearr_39070 = state_39027;
(statearr_39070[(4)] = cljs.core.rest((state_39027[(4)])));

return statearr_39070;
})();
var state_39027__$1 = state_39027;
var statearr_39071_39109 = state_39027__$1;
(statearr_39071_39109[(2)] = inst_39022);

(statearr_39071_39109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__17178__auto__ = null;
var fluree$db$query$analytical$state_machine__17178__auto____0 = (function (){
var statearr_39072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39072[(0)] = fluree$db$query$analytical$state_machine__17178__auto__);

(statearr_39072[(1)] = (1));

return statearr_39072;
});
var fluree$db$query$analytical$state_machine__17178__auto____1 = (function (state_39027){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_39027);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e39073){var ex__17181__auto__ = e39073;
var statearr_39074_39110 = state_39027;
(statearr_39074_39110[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_39027[(4)]))){
var statearr_39075_39111 = state_39027;
(statearr_39075_39111[(1)] = cljs.core.first((state_39027[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39112 = state_39027;
state_39027 = G__39112;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__17178__auto__ = function(state_39027){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__17178__auto____1.call(this,state_39027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__17178__auto____0;
fluree$db$query$analytical$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__17178__auto____1;
return fluree$db$query$analytical$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_39076 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_39076[(6)] = c__17304__auto__);

return statearr_39076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__39113){
var vec__39114 = p__39113;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39114,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39114,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39117_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__39117_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__39121 = subjects;
var vec__39122 = G__39121;
var seq__39123 = cljs.core.seq(vec__39122);
var first__39124 = cljs.core.first(seq__39123);
var seq__39123__$1 = cljs.core.next(seq__39123);
var subject = first__39124;
var r = seq__39123__$1;
var acc = expanded_map;
var G__39121__$1 = G__39121;
var acc__$1 = acc;
while(true){
var vec__39128 = G__39121__$1;
var seq__39129 = cljs.core.seq(vec__39128);
var first__39130 = cljs.core.first(seq__39129);
var seq__39129__$1 = cljs.core.next(seq__39129);
var subject__$1 = first__39130;
var r__$1 = seq__39129__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__39131 = r__$1;
var G__39132 = acc__$2;
G__39121__$1 = G__39131;
acc__$1 = G__39132;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__39121__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__39121__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__39121__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__39121__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__39121__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__39121__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__39128,seq__39129,first__39130,seq__39129__$1,subject__$1,r__$1,acc__$2,G__39121,vec__39122,seq__39123,first__39124,seq__39123__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__39133 = r__$1;
var G__39134 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__39121__$1 = G__39133;
acc__$1 = G__39134;
continue;
} else {
var G__39135 = subjects;
var G__39136 = acc_STAR_;
G__39121__$1 = G__39135;
acc__$1 = G__39136;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39137_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__39137_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_39228){
var state_val_39229 = (state_39228[(1)]);
if((state_val_39229 === (7))){
var state_39228__$1 = state_39228;
var statearr_39230_39276 = state_39228__$1;
(statearr_39230_39276[(2)] = (100));

(statearr_39230_39276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (20))){
var inst_39177 = (state_39228[(7)]);
var state_39228__$1 = state_39228;
var statearr_39231_39277 = state_39228__$1;
(statearr_39231_39277[(2)] = inst_39177);

(statearr_39231_39277[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (1))){
var state_39228__$1 = state_39228;
var statearr_39232_39278 = state_39228__$1;
(statearr_39232_39278[(2)] = null);

(statearr_39232_39278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (24))){
var inst_39215 = (state_39228[(8)]);
var inst_39216 = (state_39228[(9)]);
var inst_39149 = (state_39228[(10)]);
var inst_39214 = (state_39228[(11)]);
var inst_39219 = (function (){var max_depth = inst_39149;
var recur_map__$1 = inst_39215;
var subjects = inst_39214;
var tuples = inst_39216;
return (function (p1__39138_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__39138_SHARP_)],null));
});
})();
var inst_39220 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39219,inst_39216);
var inst_39221 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_39220);
var state_39228__$1 = state_39228;
var statearr_39233_39279 = state_39228__$1;
(statearr_39233_39279[(2)] = inst_39221);

(statearr_39233_39279[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (4))){
var inst_39139 = (state_39228[(2)]);
var state_39228__$1 = state_39228;
var statearr_39234_39280 = state_39228__$1;
(statearr_39234_39280[(2)] = inst_39139);

(statearr_39234_39280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (15))){
var inst_39162 = (state_39228[(12)]);
var inst_39173 = cljs.core.PersistentVector.EMPTY;
var inst_39174 = cljs.core.seq(inst_39162);
var inst_39175 = cljs.core.first(inst_39174);
var inst_39176 = cljs.core.next(inst_39174);
var inst_39177 = inst_39173;
var inst_39178 = inst_39162;
var state_39228__$1 = (function (){var statearr_39235 = state_39228;
(statearr_39235[(13)] = inst_39175);

(statearr_39235[(14)] = inst_39176);

(statearr_39235[(7)] = inst_39177);

(statearr_39235[(15)] = inst_39178);

return statearr_39235;
})();
var statearr_39236_39281 = state_39228__$1;
(statearr_39236_39281[(2)] = null);

(statearr_39236_39281[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (21))){
var inst_39198 = (state_39228[(2)]);
var state_39228__$1 = state_39228;
var statearr_39237_39282 = state_39228__$1;
(statearr_39237_39282[(2)] = inst_39198);

(statearr_39237_39282[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (13))){
var inst_39211 = (state_39228[(2)]);
var state_39228__$1 = state_39228;
var statearr_39238_39283 = state_39228__$1;
(statearr_39238_39283[(2)] = inst_39211);

(statearr_39238_39283[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (22))){
var inst_39185 = (state_39228[(16)]);
var inst_39177 = (state_39228[(7)]);
var inst_39192 = (state_39228[(2)]);
var inst_39193 = fluree.db.util.async.throw_err(inst_39192);
var inst_39194 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39177,inst_39193);
var inst_39177__$1 = inst_39194;
var inst_39178 = inst_39185;
var state_39228__$1 = (function (){var statearr_39239 = state_39228;
(statearr_39239[(7)] = inst_39177__$1);

(statearr_39239[(15)] = inst_39178);

return statearr_39239;
})();
var statearr_39240_39284 = state_39228__$1;
(statearr_39240_39284[(2)] = null);

(statearr_39240_39284[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (6))){
var inst_39145 = (state_39228[(17)]);
var state_39228__$1 = state_39228;
var statearr_39241_39285 = state_39228__$1;
(statearr_39241_39285[(2)] = inst_39145);

(statearr_39241_39285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (25))){
var inst_39223 = (state_39228[(2)]);
var _ = (function (){var statearr_39242 = state_39228;
(statearr_39242[(4)] = cljs.core.rest((state_39228[(4)])));

return statearr_39242;
})();
var state_39228__$1 = state_39228;
var statearr_39243_39286 = state_39228__$1;
(statearr_39243_39286[(2)] = inst_39223);

(statearr_39243_39286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (17))){
var inst_39178 = (state_39228[(15)]);
var inst_39184 = (state_39228[(18)]);
var inst_39183 = cljs.core.seq(inst_39178);
var inst_39184__$1 = cljs.core.first(inst_39183);
var inst_39185 = cljs.core.next(inst_39183);
var state_39228__$1 = (function (){var statearr_39244 = state_39228;
(statearr_39244[(16)] = inst_39185);

(statearr_39244[(18)] = inst_39184__$1);

return statearr_39244;
})();
if(cljs.core.truth_(inst_39184__$1)){
var statearr_39245_39287 = state_39228__$1;
(statearr_39245_39287[(1)] = (19));

} else {
var statearr_39246_39288 = state_39228__$1;
(statearr_39246_39288[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (3))){
var inst_39226 = (state_39228[(2)]);
var state_39228__$1 = state_39228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39228__$1,inst_39226);
} else {
if((state_val_39229 === (12))){
var inst_39151 = (state_39228[(19)]);
var inst_39162 = (state_39228[(12)]);
var inst_39157 = cljs.core.vals(inst_39151);
var inst_39158 = cljs.core.flatten(inst_39157);
var inst_39159 = cljs.core.set(inst_39158);
var inst_39160 = cljs.core.keys(inst_39151);
var inst_39161 = cljs.core.set(inst_39160);
var inst_39162__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_39159,inst_39161);
var inst_39163 = cljs.core.empty_QMARK_(inst_39162__$1);
var state_39228__$1 = (function (){var statearr_39247 = state_39228;
(statearr_39247[(12)] = inst_39162__$1);

return statearr_39247;
})();
if(inst_39163){
var statearr_39248_39289 = state_39228__$1;
(statearr_39248_39289[(1)] = (14));

} else {
var statearr_39249_39290 = state_39228__$1;
(statearr_39249_39290[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (2))){
var inst_39145 = (state_39228[(17)]);
var _ = (function (){var statearr_39250 = state_39228;
(statearr_39250[(4)] = cljs.core.cons((5),(state_39228[(4)])));

return statearr_39250;
})();
var inst_39145__$1 = depth;
var state_39228__$1 = (function (){var statearr_39251 = state_39228;
(statearr_39251[(17)] = inst_39145__$1);

return statearr_39251;
})();
if(cljs.core.truth_(inst_39145__$1)){
var statearr_39252_39291 = state_39228__$1;
(statearr_39252_39291[(1)] = (6));

} else {
var statearr_39253_39292 = state_39228__$1;
(statearr_39253_39292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (23))){
var inst_39216 = (state_39228[(9)]);
var state_39228__$1 = state_39228;
var statearr_39254_39293 = state_39228__$1;
(statearr_39254_39293[(2)] = inst_39216);

(statearr_39254_39293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (19))){
var inst_39184 = (state_39228[(18)]);
var inst_39187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39188 = [inst_39184,predicate];
var inst_39189 = (new cljs.core.PersistentVector(null,2,(5),inst_39187,inst_39188,null));
var inst_39190 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_39189);
var state_39228__$1 = state_39228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39228__$1,(22),inst_39190);
} else {
if((state_val_39229 === (11))){
var inst_39151 = (state_39228[(19)]);
var state_39228__$1 = state_39228;
var statearr_39256_39294 = state_39228__$1;
(statearr_39256_39294[(2)] = inst_39151);

(statearr_39256_39294[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (9))){
var inst_39152 = (state_39228[(20)]);
var inst_39149 = (state_39228[(10)]);
var inst_39154 = (inst_39152 >= inst_39149);
var state_39228__$1 = state_39228;
if(cljs.core.truth_(inst_39154)){
var statearr_39257_39295 = state_39228__$1;
(statearr_39257_39295[(1)] = (11));

} else {
var statearr_39258_39296 = state_39228__$1;
(statearr_39258_39296[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (5))){
var _ = (function (){var statearr_39259 = state_39228;
(statearr_39259[(4)] = cljs.core.rest((state_39228[(4)])));

return statearr_39259;
})();
var state_39228__$1 = state_39228;
var ex39255 = (state_39228__$1[(2)]);
var statearr_39260_39297 = state_39228__$1;
(statearr_39260_39297[(5)] = ex39255);


if((ex39255 instanceof Error)){
var statearr_39261_39298 = state_39228__$1;
(statearr_39261_39298[(1)] = (4));

(statearr_39261_39298[(5)] = null);

} else {
throw ex39255;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (14))){
var inst_39151 = (state_39228[(19)]);
var state_39228__$1 = state_39228;
var statearr_39262_39299 = state_39228__$1;
(statearr_39262_39299[(2)] = inst_39151);

(statearr_39262_39299[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (16))){
var inst_39209 = (state_39228[(2)]);
var state_39228__$1 = state_39228;
var statearr_39263_39300 = state_39228__$1;
(statearr_39263_39300[(2)] = inst_39209);

(statearr_39263_39300[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (10))){
var inst_39215 = (state_39228[(8)]);
var inst_39214 = (state_39228[(11)]);
var inst_39213 = (state_39228[(2)]);
var inst_39214__$1 = cljs.core.keys(inst_39213);
var inst_39215__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_39214__$1,inst_39213);
var inst_39216 = fluree.db.query.analytical.recur_map__GT_tuples(inst_39214__$1,inst_39215__$1);
var state_39228__$1 = (function (){var statearr_39264 = state_39228;
(statearr_39264[(8)] = inst_39215__$1);

(statearr_39264[(9)] = inst_39216);

(statearr_39264[(11)] = inst_39214__$1);

return statearr_39264;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_39265_39301 = state_39228__$1;
(statearr_39265_39301[(1)] = (23));

} else {
var statearr_39266_39302 = state_39228__$1;
(statearr_39266_39302[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (18))){
var inst_39152 = (state_39228[(20)]);
var inst_39151 = (state_39228[(19)]);
var inst_39200 = (state_39228[(2)]);
var inst_39201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39202 = [(0),(2)];
var inst_39203 = (new cljs.core.PersistentVector(null,2,(5),inst_39201,inst_39202,null));
var inst_39204 = fluree.db.query.analytical.get_ns_arrays(inst_39203,inst_39200);
var inst_39205 = fluree.db.query.analytical.tuples__GT_map(inst_39151,inst_39204);
var inst_39206 = (inst_39152 + (1));
var inst_39151__$1 = inst_39205;
var inst_39152__$1 = inst_39206;
var state_39228__$1 = (function (){var statearr_39267 = state_39228;
(statearr_39267[(20)] = inst_39152__$1);

(statearr_39267[(19)] = inst_39151__$1);

return statearr_39267;
})();
var statearr_39268_39303 = state_39228__$1;
(statearr_39268_39303[(2)] = null);

(statearr_39268_39303[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39229 === (8))){
var inst_39149 = (state_39228[(2)]);
var inst_39150 = recur_map;
var inst_39151 = inst_39150;
var inst_39152 = (1);
var state_39228__$1 = (function (){var statearr_39269 = state_39228;
(statearr_39269[(20)] = inst_39152);

(statearr_39269[(19)] = inst_39151);

(statearr_39269[(10)] = inst_39149);

return statearr_39269;
})();
var statearr_39270_39304 = state_39228__$1;
(statearr_39270_39304[(2)] = null);

(statearr_39270_39304[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____0 = (function (){
var statearr_39271 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39271[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__);

(statearr_39271[(1)] = (1));

return statearr_39271;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____1 = (function (state_39228){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_39228);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e39272){var ex__17181__auto__ = e39272;
var statearr_39273_39305 = state_39228;
(statearr_39273_39305[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_39228[(4)]))){
var statearr_39274_39306 = state_39228;
(statearr_39274_39306[(1)] = cljs.core.first((state_39228[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39307 = state_39228;
state_39228 = G__39307;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__ = function(state_39228){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____1.call(this,state_39228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_39275 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_39275[(6)] = c__17304__auto__);

return statearr_39275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__39308,clause,fuel,max_fuel){
var map__39309 = p__39308;
var map__39309__$1 = cljs.core.__destructure_map(map__39309);
var res = map__39309__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39309__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39309__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39309__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_39420){
var state_val_39421 = (state_39420[(1)]);
if((state_val_39421 === (7))){
var inst_39326 = (state_39420[(7)]);
var state_39420__$1 = state_39420;
var statearr_39422_39475 = state_39420__$1;
(statearr_39422_39475[(2)] = inst_39326);

(statearr_39422_39475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (20))){
var inst_39354 = (state_39420[(8)]);
var inst_39385 = typeof inst_39354 === 'number';
var state_39420__$1 = state_39420;
if(cljs.core.truth_(inst_39385)){
var statearr_39423_39476 = state_39420__$1;
(statearr_39423_39476[(1)] = (22));

} else {
var statearr_39424_39477 = state_39420__$1;
(statearr_39424_39477[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (27))){
var inst_39400 = (state_39420[(2)]);
var state_39420__$1 = state_39420;
var statearr_39425_39478 = state_39420__$1;
(statearr_39425_39478[(2)] = inst_39400);

(statearr_39425_39478[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (1))){
var state_39420__$1 = state_39420;
var statearr_39426_39479 = state_39420__$1;
(statearr_39426_39479[(2)] = null);

(statearr_39426_39479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (24))){
var inst_39402 = (state_39420[(2)]);
var state_39420__$1 = state_39420;
var statearr_39427_39480 = state_39420__$1;
(statearr_39427_39480[(2)] = inst_39402);

(statearr_39427_39480[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (4))){
var inst_39310 = (state_39420[(2)]);
var state_39420__$1 = state_39420;
var statearr_39428_39481 = state_39420__$1;
(statearr_39428_39481[(2)] = inst_39310);

(statearr_39428_39481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (15))){
var inst_39368 = (state_39420[(2)]);
var inst_39369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_39370 = fluree.db.query.analytical.variable_QMARK_(inst_39369);
var state_39420__$1 = (function (){var statearr_39429 = state_39420;
(statearr_39429[(9)] = inst_39368);

return statearr_39429;
})();
if(cljs.core.truth_(inst_39370)){
var statearr_39430_39482 = state_39420__$1;
(statearr_39430_39482[(1)] = (16));

} else {
var statearr_39431_39483 = state_39420__$1;
(statearr_39431_39483[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (21))){
var inst_39357 = (state_39420[(10)]);
var inst_39327 = (state_39420[(11)]);
var inst_39356 = (state_39420[(12)]);
var inst_39404 = (state_39420[(2)]);
var inst_39405 = fluree.db.query.analytical.tuples__GT_recur(db,inst_39357,inst_39404,inst_39327,inst_39356);
var state_39420__$1 = state_39420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39420__$1,(28),inst_39405);
} else {
if((state_val_39421 === (13))){
var inst_39336 = (state_39420[(13)]);
var inst_39360 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39336)].join('');
var inst_39361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39362 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_39363 = cljs.core.PersistentHashMap.fromArrays(inst_39361,inst_39362);
var inst_39364 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39360,inst_39363);
var inst_39365 = (function(){throw inst_39364})();
var state_39420__$1 = state_39420;
var statearr_39432_39484 = state_39420__$1;
(statearr_39432_39484[(2)] = inst_39365);

(statearr_39432_39484[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (22))){
var inst_39352 = (state_39420[(14)]);
var inst_39354 = (state_39420[(8)]);
var inst_39387 = cljs.core.PersistentHashMap.EMPTY;
var inst_39388 = cljs.core.flatten(inst_39352);
var inst_39389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39387,inst_39354,inst_39388);
var state_39420__$1 = state_39420;
var statearr_39433_39485 = state_39420__$1;
(statearr_39433_39485[(2)] = inst_39389);

(statearr_39433_39485[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (6))){
var inst_39338 = (state_39420[(15)]);
var state_39420__$1 = state_39420;
var statearr_39434_39486 = state_39420__$1;
(statearr_39434_39486[(2)] = inst_39338);

(statearr_39434_39486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (28))){
var inst_39407 = (state_39420[(2)]);
var inst_39408 = fluree.db.util.async.throw_err(inst_39407);
var state_39420__$1 = state_39420;
var statearr_39435_39487 = state_39420__$1;
(statearr_39435_39487[(2)] = inst_39408);

(statearr_39435_39487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (25))){
var inst_39352 = (state_39420[(14)]);
var inst_39348 = (state_39420[(16)]);
var inst_39393 = cljs.core.PersistentHashMap.EMPTY;
var inst_39394 = cljs.core.first(inst_39348);
var inst_39395 = cljs.core.first(inst_39394);
var inst_39396 = cljs.core.flatten(inst_39352);
var inst_39397 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39393,inst_39395,inst_39396);
var state_39420__$1 = state_39420;
var statearr_39436_39488 = state_39420__$1;
(statearr_39436_39488[(2)] = inst_39397);

(statearr_39436_39488[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (17))){
var inst_39336 = (state_39420[(13)]);
var inst_39373 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39336)].join('');
var inst_39374 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39375 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_39376 = cljs.core.PersistentHashMap.fromArrays(inst_39374,inst_39375);
var inst_39377 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39373,inst_39376);
var inst_39378 = (function(){throw inst_39377})();
var state_39420__$1 = state_39420;
var statearr_39437_39489 = state_39420__$1;
(statearr_39437_39489[(2)] = inst_39378);

(statearr_39437_39489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (3))){
var inst_39418 = (state_39420[(2)]);
var state_39420__$1 = state_39420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39420__$1,inst_39418);
} else {
if((state_val_39421 === (12))){
var inst_39323 = (state_39420[(17)]);
var inst_39411 = (state_39420[(2)]);
var inst_39412 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_39413 = cljs.core.keys(inst_39323);
var inst_39414 = [inst_39413,vars,inst_39411];
var inst_39415 = cljs.core.PersistentHashMap.fromArrays(inst_39412,inst_39414);
var _ = (function (){var statearr_39438 = state_39420;
(statearr_39438[(4)] = cljs.core.rest((state_39420[(4)])));

return statearr_39438;
})();
var state_39420__$1 = state_39420;
var statearr_39439_39490 = state_39420__$1;
(statearr_39439_39490[(2)] = inst_39415);

(statearr_39439_39490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (2))){
var inst_39327 = (state_39420[(11)]);
var inst_39326 = (state_39420[(7)]);
var inst_39323 = (state_39420[(17)]);
var inst_39338 = (state_39420[(15)]);
var _ = (function (){var statearr_39440 = state_39420;
(statearr_39440[(4)] = cljs.core.cons((5),(state_39420[(4)])));

return statearr_39440;
})();
var inst_39320 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_39321 = cljs.core.__destructure_map(inst_39320);
var inst_39322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39321,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_39323__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39321,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_39324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39321,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_39325 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_39326__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_39324);
var inst_39327__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_39324);
var inst_39329 = (function (){var map__39316 = inst_39321;
var search = inst_39322;
var rel = inst_39323__$1;
var opts = inst_39324;
var common_keys = inst_39325;
var object_fn = inst_39326__$1;
var recur_depth = inst_39327__$1;
return (function (p__39328,common_key){
var vec__39441 = p__39328;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39441,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39441,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__39444 = cljs.core._EQ_;
var expr__39445 = idx_of;
if(cljs.core.truth_((pred__39444.cljs$core$IFn$_invoke$arity$2 ? pred__39444.cljs$core$IFn$_invoke$arity$2((0),expr__39445) : pred__39444.call(null,(0),expr__39445)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__39444.cljs$core$IFn$_invoke$arity$2 ? pred__39444.cljs$core$IFn$_invoke$arity$2((1),expr__39445) : pred__39444.call(null,(1),expr__39445)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__39444.cljs$core$IFn$_invoke$arity$2 ? pred__39444.cljs$core$IFn$_invoke$arity$2((2),expr__39445) : pred__39444.call(null,(2),expr__39445)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__39445)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_39330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39331 = cljs.core.PersistentHashMap.EMPTY;
var inst_39332 = [inst_39331,inst_39322];
var inst_39333 = (new cljs.core.PersistentVector(null,2,(5),inst_39330,inst_39332,null));
var inst_39334 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39329,inst_39333,inst_39325);
var inst_39335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39334,(0),null);
var inst_39336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39334,(1),null);
var inst_39337 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_39338__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_39335);
var state_39420__$1 = (function (){var statearr_39447 = state_39420;
(statearr_39447[(11)] = inst_39327__$1);

(statearr_39447[(7)] = inst_39326__$1);

(statearr_39447[(17)] = inst_39323__$1);

(statearr_39447[(15)] = inst_39338__$1);

(statearr_39447[(13)] = inst_39336);

(statearr_39447[(18)] = inst_39337);

return statearr_39447;
})();
if(cljs.core.truth_(inst_39338__$1)){
var statearr_39448_39491 = state_39420__$1;
(statearr_39448_39491[(1)] = (6));

} else {
var statearr_39449_39492 = state_39420__$1;
(statearr_39449_39492[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (23))){
var inst_39354 = (state_39420[(8)]);
var inst_39391 = cljs.core.coll_QMARK_(inst_39354);
var state_39420__$1 = state_39420;
if(inst_39391){
var statearr_39450_39493 = state_39420__$1;
(statearr_39450_39493[(1)] = (25));

} else {
var statearr_39451_39494 = state_39420__$1;
(statearr_39451_39494[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (19))){
var inst_39352 = (state_39420[(14)]);
var inst_39382 = cljs.core.PersistentHashMap.EMPTY;
var inst_39383 = fluree.db.query.analytical.tuples__GT_map(inst_39382,inst_39352);
var state_39420__$1 = state_39420;
var statearr_39452_39495 = state_39420__$1;
(statearr_39452_39495[(2)] = inst_39383);

(statearr_39452_39495[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (11))){
var inst_39352 = (state_39420[(14)]);
var state_39420__$1 = state_39420;
var statearr_39454_39496 = state_39420__$1;
(statearr_39454_39496[(2)] = inst_39352);

(statearr_39454_39496[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (9))){
var inst_39327 = (state_39420[(11)]);
var inst_39323 = (state_39420[(17)]);
var inst_39348 = (state_39420[(16)]);
var inst_39347 = (state_39420[(2)]);
var inst_39348__$1 = fluree.db.util.async.throw_err(inst_39347);
var inst_39349 = cljs.core.count(inst_39348__$1);
var inst_39350 = fluree.db.query.analytical.add_fuel(inst_39349,fuel,max_fuel);
var inst_39351 = cljs.core.vals(inst_39323);
var inst_39352 = fluree.db.query.analytical.get_ns_arrays(inst_39351,inst_39348__$1);
var state_39420__$1 = (function (){var statearr_39455 = state_39420;
(statearr_39455[(14)] = inst_39352);

(statearr_39455[(16)] = inst_39348__$1);

(statearr_39455[(19)] = inst_39350);

return statearr_39455;
})();
if(cljs.core.truth_(inst_39327)){
var statearr_39456_39497 = state_39420__$1;
(statearr_39456_39497[(1)] = (10));

} else {
var statearr_39457_39498 = state_39420__$1;
(statearr_39457_39498[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (5))){
var _ = (function (){var statearr_39458 = state_39420;
(statearr_39458[(4)] = cljs.core.rest((state_39420[(4)])));

return statearr_39458;
})();
var state_39420__$1 = state_39420;
var ex39453 = (state_39420__$1[(2)]);
var statearr_39459_39499 = state_39420__$1;
(statearr_39459_39499[(5)] = ex39453);


if((ex39453 instanceof Error)){
var statearr_39460_39500 = state_39420__$1;
(statearr_39460_39500[(1)] = (4));

(statearr_39460_39500[(5)] = null);

} else {
throw ex39453;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (14))){
var state_39420__$1 = state_39420;
var statearr_39461_39501 = state_39420__$1;
(statearr_39461_39501[(2)] = null);

(statearr_39461_39501[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (26))){
var state_39420__$1 = state_39420;
var statearr_39462_39502 = state_39420__$1;
(statearr_39462_39502[(2)] = null);

(statearr_39462_39502[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (16))){
var state_39420__$1 = state_39420;
var statearr_39463_39503 = state_39420__$1;
(statearr_39463_39503[(2)] = null);

(statearr_39463_39503[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (10))){
var inst_39357 = (state_39420[(10)]);
var inst_39336 = (state_39420[(13)]);
var inst_39354 = cljs.core.first(inst_39336);
var inst_39355 = cljs.core.first(clause);
var inst_39356 = fluree.db.query.analytical.variable_QMARK_(inst_39355);
var inst_39357__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_39336,(1));
var inst_39358 = fluree.db.query.analytical.variable_QMARK_(inst_39357__$1);
var state_39420__$1 = (function (){var statearr_39464 = state_39420;
(statearr_39464[(10)] = inst_39357__$1);

(statearr_39464[(12)] = inst_39356);

(statearr_39464[(8)] = inst_39354);

return statearr_39464;
})();
if(cljs.core.truth_(inst_39358)){
var statearr_39465_39504 = state_39420__$1;
(statearr_39465_39504[(1)] = (13));

} else {
var statearr_39466_39505 = state_39420__$1;
(statearr_39466_39505[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (18))){
var inst_39356 = (state_39420[(12)]);
var inst_39380 = (state_39420[(2)]);
var state_39420__$1 = (function (){var statearr_39467 = state_39420;
(statearr_39467[(20)] = inst_39380);

return statearr_39467;
})();
if(cljs.core.truth_(inst_39356)){
var statearr_39468_39506 = state_39420__$1;
(statearr_39468_39506[(1)] = (19));

} else {
var statearr_39469_39507 = state_39420__$1;
(statearr_39469_39507[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39421 === (8))){
var inst_39336 = (state_39420[(13)]);
var inst_39337 = (state_39420[(18)]);
var inst_39342 = (state_39420[(2)]);
var inst_39343 = [inst_39342];
var inst_39344 = cljs.core.PersistentHashMap.fromArrays(inst_39337,inst_39343);
var inst_39345 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_39336,inst_39344);
var state_39420__$1 = state_39420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39420__$1,(9),inst_39345);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____0 = (function (){
var statearr_39470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39470[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__);

(statearr_39470[(1)] = (1));

return statearr_39470;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____1 = (function (state_39420){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_39420);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e39471){var ex__17181__auto__ = e39471;
var statearr_39472_39508 = state_39420;
(statearr_39472_39508[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_39420[(4)]))){
var statearr_39473_39509 = state_39420;
(statearr_39473_39509[(1)] = cljs.core.first((state_39420[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39510 = state_39420;
state_39420 = G__39510;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__ = function(state_39420){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____1.call(this,state_39420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_39474 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_39474[(6)] = c__17304__auto__);

return statearr_39474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__39511,res,clause){
var map__39512 = p__39511;
var map__39512__$1 = cljs.core.__destructure_map(map__39512);
var db = map__39512__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39512__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39512__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39512__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_39621){
var state_val_39622 = (state_39621[(1)]);
if((state_val_39622 === (7))){
var inst_39521 = (state_39621[(7)]);
var state_39621__$1 = state_39621;
var statearr_39623_39664 = state_39621__$1;
(statearr_39623_39664[(2)] = inst_39521);

(statearr_39623_39664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (20))){
var state_39621__$1 = state_39621;
var statearr_39624_39665 = state_39621__$1;
(statearr_39624_39665[(2)] = null);

(statearr_39624_39665[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (1))){
var state_39621__$1 = state_39621;
var statearr_39625_39666 = state_39621__$1;
(statearr_39625_39666[(2)] = null);

(statearr_39625_39666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (24))){
var inst_39523 = (state_39621[(8)]);
var inst_39594 = (state_39621[(2)]);
var inst_39595 = fluree.db.flake.sid__GT_cid(inst_39594);
var inst_39596 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_39595);
var inst_39597 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_39598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39599 = [inst_39523];
var inst_39600 = (new cljs.core.PersistentVector(null,1,(5),inst_39598,inst_39599,null));
var inst_39601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39603 = [inst_39596];
var inst_39604 = (new cljs.core.PersistentVector(null,1,(5),inst_39602,inst_39603,null));
var inst_39605 = [inst_39604];
var inst_39606 = (new cljs.core.PersistentVector(null,1,(5),inst_39601,inst_39605,null));
var inst_39607 = cljs.core.PersistentHashMap.EMPTY;
var inst_39608 = [inst_39600,inst_39606,inst_39607];
var inst_39609 = cljs.core.PersistentHashMap.fromArrays(inst_39597,inst_39608);
var state_39621__$1 = state_39621;
var statearr_39626_39667 = state_39621__$1;
(statearr_39626_39667[(2)] = inst_39609);

(statearr_39626_39667[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (4))){
var inst_39514 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
var statearr_39627_39668 = state_39621__$1;
(statearr_39627_39668[(2)] = inst_39514);

(statearr_39627_39668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (15))){
var inst_39523 = (state_39621[(8)]);
var inst_39521 = (state_39621[(7)]);
var inst_39542 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_39543 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_39544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39545 = [inst_39521];
var inst_39546 = (new cljs.core.PersistentVector(null,1,(5),inst_39544,inst_39545,null));
var inst_39547 = (function (){var subject_var = inst_39521;
var object_var = inst_39523;
var min_sid = inst_39542;
var max_sid = (0);
return (function (p1__39513_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__39513_SHARP_);
});
})();
var inst_39548 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_39542,(0));
var inst_39549 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39547,inst_39548);
var inst_39550 = cljs.core.PersistentHashMap.EMPTY;
var inst_39551 = [inst_39546,inst_39549,inst_39550];
var inst_39552 = cljs.core.PersistentHashMap.fromArrays(inst_39543,inst_39551);
var state_39621__$1 = state_39621;
var statearr_39628_39669 = state_39621__$1;
(statearr_39628_39669[(2)] = inst_39552);

(statearr_39628_39669[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (21))){
var inst_39612 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
var statearr_39629_39670 = state_39621__$1;
(statearr_39629_39670[(2)] = inst_39612);

(statearr_39629_39670[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (13))){
var inst_39523 = (state_39621[(8)]);
var state_39621__$1 = state_39621;
if(cljs.core.truth_(inst_39523)){
var statearr_39630_39671 = state_39621__$1;
(statearr_39630_39671[(1)] = (19));

} else {
var statearr_39631_39672 = state_39621__$1;
(statearr_39631_39672[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (22))){
var inst_39585 = (state_39621[(9)]);
var state_39621__$1 = state_39621;
var statearr_39632_39673 = state_39621__$1;
(statearr_39632_39673[(2)] = inst_39585);

(statearr_39632_39673[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (6))){
var inst_39523 = (state_39621[(8)]);
var state_39621__$1 = state_39621;
var statearr_39633_39674 = state_39621__$1;
(statearr_39633_39674[(2)] = inst_39523);

(statearr_39633_39674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (25))){
var inst_39591 = (state_39621[(2)]);
var inst_39592 = fluree.db.util.async.throw_err(inst_39591);
var state_39621__$1 = state_39621;
var statearr_39634_39675 = state_39621__$1;
(statearr_39634_39675[(2)] = inst_39592);

(statearr_39634_39675[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (17))){
var inst_39582 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
var statearr_39635_39676 = state_39621__$1;
(statearr_39635_39676[(2)] = inst_39582);

(statearr_39635_39676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (3))){
var inst_39619 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39621__$1,inst_39619);
} else {
if((state_val_39622 === (12))){
var inst_39536 = ["_tx",null,"_block",null];
var inst_39537 = (new cljs.core.PersistentArrayMap(null,2,inst_39536,null));
var inst_39538 = (new cljs.core.PersistentHashSet(null,inst_39537,null));
var inst_39539 = cljs.core.last(clause);
var inst_39540 = (inst_39538.cljs$core$IFn$_invoke$arity$1 ? inst_39538.cljs$core$IFn$_invoke$arity$1(inst_39539) : inst_39538.call(null,inst_39539));
var state_39621__$1 = state_39621;
if(cljs.core.truth_(inst_39540)){
var statearr_39636_39677 = state_39621__$1;
(statearr_39636_39677[(1)] = (15));

} else {
var statearr_39637_39678 = state_39621__$1;
(statearr_39637_39678[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (2))){
var inst_39521 = (state_39621[(7)]);
var _ = (function (){var statearr_39638 = state_39621;
(statearr_39638[(4)] = cljs.core.cons((5),(state_39621[(4)])));

return statearr_39638;
})();
var inst_39520 = cljs.core.first(clause);
var inst_39521__$1 = fluree.db.query.analytical.variable_QMARK_(inst_39520);
var inst_39522 = cljs.core.last(clause);
var inst_39523 = fluree.db.query.analytical.variable_QMARK_(inst_39522);
var state_39621__$1 = (function (){var statearr_39639 = state_39621;
(statearr_39639[(8)] = inst_39523);

(statearr_39639[(7)] = inst_39521__$1);

return statearr_39639;
})();
if(cljs.core.truth_(inst_39521__$1)){
var statearr_39640_39679 = state_39621__$1;
(statearr_39640_39679[(1)] = (6));

} else {
var statearr_39641_39680 = state_39621__$1;
(statearr_39641_39680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (23))){
var inst_39585 = (state_39621[(9)]);
var inst_39589 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39585);
var state_39621__$1 = state_39621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39621__$1,(25),inst_39589);
} else {
if((state_val_39622 === (19))){
var inst_39585 = (state_39621[(9)]);
var inst_39585__$1 = cljs.core.first(clause);
var inst_39586 = typeof inst_39585__$1 === 'number';
var state_39621__$1 = (function (){var statearr_39642 = state_39621;
(statearr_39642[(9)] = inst_39585__$1);

return statearr_39642;
})();
if(cljs.core.truth_(inst_39586)){
var statearr_39643_39681 = state_39621__$1;
(statearr_39643_39681[(1)] = (22));

} else {
var statearr_39644_39682 = state_39621__$1;
(statearr_39644_39682[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (11))){
var inst_39616 = (state_39621[(2)]);
var _ = (function (){var statearr_39646 = state_39621;
(statearr_39646[(4)] = cljs.core.rest((state_39621[(4)])));

return statearr_39646;
})();
var state_39621__$1 = state_39621;
var statearr_39647_39683 = state_39621__$1;
(statearr_39647_39683[(2)] = inst_39616);

(statearr_39647_39683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (9))){
var inst_39529 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39530 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_39531 = cljs.core.PersistentHashMap.fromArrays(inst_39529,inst_39530);
var inst_39532 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_39531);
var inst_39533 = (function(){throw inst_39532})();
var state_39621__$1 = state_39621;
var statearr_39648_39684 = state_39621__$1;
(statearr_39648_39684[(2)] = inst_39533);

(statearr_39648_39684[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (5))){
var _ = (function (){var statearr_39649 = state_39621;
(statearr_39649[(4)] = cljs.core.rest((state_39621[(4)])));

return statearr_39649;
})();
var state_39621__$1 = state_39621;
var ex39645 = (state_39621__$1[(2)]);
var statearr_39650_39685 = state_39621__$1;
(statearr_39650_39685[(5)] = ex39645);


if((ex39645 instanceof Error)){
var statearr_39651_39686 = state_39621__$1;
(statearr_39651_39686[(1)] = (4));

(statearr_39651_39686[(5)] = null);

} else {
throw ex39645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (14))){
var inst_39614 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
var statearr_39652_39687 = state_39621__$1;
(statearr_39652_39687[(2)] = inst_39614);

(statearr_39652_39687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (16))){
var inst_39555 = (state_39621[(10)]);
var inst_39557 = (state_39621[(11)]);
var inst_39558 = (state_39621[(12)]);
var inst_39554 = cljs.core.last(clause);
var inst_39555__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_39554);
var inst_39556 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_39557__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39556,inst_39555__$1);
var inst_39558__$1 = fluree.db.flake.min_subject_id(inst_39555__$1);
var inst_39559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39560 = [inst_39557__$1];
var inst_39561 = (new cljs.core.PersistentVector(null,1,(5),inst_39559,inst_39560,null));
var inst_39562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39563 = [inst_39558__$1];
var inst_39564 = (new cljs.core.PersistentVector(null,1,(5),inst_39562,inst_39563,null));
var inst_39565 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_39561,cljs.core._LT__EQ_,inst_39564);
var state_39621__$1 = (function (){var statearr_39653 = state_39621;
(statearr_39653[(10)] = inst_39555__$1);

(statearr_39653[(11)] = inst_39557__$1);

(statearr_39653[(12)] = inst_39558__$1);

return statearr_39653;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39621__$1,(18),inst_39565);
} else {
if((state_val_39622 === (10))){
var inst_39521 = (state_39621[(7)]);
var state_39621__$1 = state_39621;
if(cljs.core.truth_(inst_39521)){
var statearr_39654_39688 = state_39621__$1;
(statearr_39654_39688[(1)] = (12));

} else {
var statearr_39655_39689 = state_39621__$1;
(statearr_39655_39689[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (18))){
var inst_39523 = (state_39621[(8)]);
var inst_39555 = (state_39621[(10)]);
var inst_39521 = (state_39621[(7)]);
var inst_39557 = (state_39621[(11)]);
var inst_39558 = (state_39621[(12)]);
var inst_39567 = (state_39621[(2)]);
var inst_39568 = fluree.db.util.async.throw_err(inst_39567);
var inst_39569 = (function (){var subject_var = inst_39521;
var object_var = inst_39523;
var partition = inst_39555;
var max_sid = inst_39557;
var min_sid = inst_39558;
var flakes = inst_39568;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_39570 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_39569);
var inst_39571 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_39572 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39570,inst_39571);
var inst_39573 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_39574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39575 = [inst_39521];
var inst_39576 = (new cljs.core.PersistentVector(null,1,(5),inst_39574,inst_39575,null));
var inst_39577 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39572,inst_39568);
var inst_39578 = cljs.core.PersistentHashMap.EMPTY;
var inst_39579 = [inst_39576,inst_39577,inst_39578];
var inst_39580 = cljs.core.PersistentHashMap.fromArrays(inst_39573,inst_39579);
var state_39621__$1 = state_39621;
var statearr_39656_39690 = state_39621__$1;
(statearr_39656_39690[(2)] = inst_39580);

(statearr_39656_39690[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39622 === (8))){
var inst_39527 = (state_39621[(2)]);
var state_39621__$1 = state_39621;
if(cljs.core.truth_(inst_39527)){
var statearr_39657_39691 = state_39621__$1;
(statearr_39657_39691[(1)] = (9));

} else {
var statearr_39658_39692 = state_39621__$1;
(statearr_39658_39692[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____0 = (function (){
var statearr_39659 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39659[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__);

(statearr_39659[(1)] = (1));

return statearr_39659;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____1 = (function (state_39621){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_39621);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e39660){var ex__17181__auto__ = e39660;
var statearr_39661_39693 = state_39621;
(statearr_39661_39693[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_39621[(4)]))){
var statearr_39662_39694 = state_39621;
(statearr_39662_39694[(1)] = cljs.core.first((state_39621[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39695 = state_39621;
state_39621 = G__39695;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__ = function(state_39621){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____1.call(this,state_39621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_39663 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_39663[(6)] = c__17304__auto__);

return statearr_39663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__39702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__39702 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__39702;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__39703(s__39704){
return (new cljs.core.LazySeq(null,(function (){
var s__39704__$1 = s__39704;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__39704__$1);
if(temp__5753__auto__){
var s__39704__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39704__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__39704__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__39706 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__39705 = (0);
while(true){
if((i__39705 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__39705);
var delta = (x - mean);
cljs.core.chunk_append(b__39706,(delta * delta));

var G__39708 = (i__39705 + (1));
i__39705 = G__39708;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39706),fluree$db$query$analytical$variance_$_iter__39703(cljs.core.chunk_rest(s__39704__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39706),null);
}
} else {
var x = cljs.core.first(s__39704__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__39703(cljs.core.rest(s__39704__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__39707 = variance(coll);
return Math.sqrt(G__39707);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__39709 = null;
var G__39709__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__39709__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__39709 = function(n,coll){
switch(arguments.length){
case 1:
return G__39709__1.call(this,n);
case 2:
return G__39709__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39709.cljs$core$IFn$_invoke$arity$1 = G__39709__1;
G__39709.cljs$core$IFn$_invoke$arity$2 = G__39709__2;
return G__39709;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__39710 = null;
var G__39710__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__39710__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__39710 = function(n,coll){
switch(arguments.length){
case 1:
return G__39710__1.call(this,n);
case 2:
return G__39710__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39710.cljs$core$IFn$_invoke$arity$1 = G__39710__1;
G__39710.cljs$core$IFn$_invoke$arity$2 = G__39710__2;
return G__39710;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__39711 = null;
var G__39711__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__39711__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__39711 = function(n,coll){
switch(arguments.length){
case 1:
return G__39711__1.call(this,n);
case 2:
return G__39711__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39711.cljs$core$IFn$_invoke$arity$1 = G__39711__1;
G__39711.cljs$core$IFn$_invoke$arity$2 = G__39711__2;
return G__39711;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__39712 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39712,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39712,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39712,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__39715 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__39718 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__39718) : agg_fn.call(null,G__39718));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39715,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39715,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__39719 = agg;
var map__39719__$1 = cljs.core.__destructure_map(map__39719);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39719__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39719__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39719__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__39721 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721,(1),null);
var map__39724 = res__$1;
var map__39724__$1 = cljs.core.__destructure_map(map__39724);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39724__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39724__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39720_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__39720_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39725_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__39725_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39726_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__39726_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__39727_SHARP_,p2__39728_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39727_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__39728_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39729_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__39729_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__39732,row,b_tuple){
var vec__39733 = p__39732;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39733,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39733,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39730_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__39730_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39731_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__39731_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39736_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__39736_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39737_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__39737_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__39742 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__39744 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__39743 = (function (p1__39738_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__39738_SHARP_);
});
return fexpr__39743(G__39744);
})()),cljs.core.set(b_idxs));
var fexpr__39741 = (function (p1__39739_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__39739_SHARP_);
});
return fexpr__39741(G__39742);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39740_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__39740_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39745_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__39745_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39746_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__39746_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__39751 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__39753 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__39752 = (function (p1__39747_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__39747_SHARP_);
});
return fexpr__39752(G__39753);
})()),cljs.core.set(b_idxs));
var fexpr__39750 = (function (p1__39748_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__39748_SHARP_);
});
return fexpr__39750(G__39751);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39749_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__39749_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__39755 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39755,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39755,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__39754_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__39754_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__39760 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39760,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39760,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39758_SHARP_){
return fluree.db.util.core.index_of(headers,p1__39758_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__39759_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__39759_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__39763,filters,optional_QMARK_){
var map__39764 = p__39763;
var map__39764__$1 = cljs.core.__destructure_map(map__39764);
var tuple_map = map__39764__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39764__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39764__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39764__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__39765 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39765,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39765,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__39768 = res;
var map__39768__$1 = cljs.core.__destructure_map(map__39768);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39768__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39768__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_39824){
var state_val_39825 = (state_39824[(1)]);
if((state_val_39825 === (7))){
var inst_39798 = (state_39824[(7)]);
var inst_39796 = (state_39824[(2)]);
var inst_39797 = fluree.db.util.async.throw_err(inst_39796);
var inst_39798__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39797,(0),null);
var inst_39799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39797,(1),null);
var inst_39800 = (inst_39798__$1 == null);
var state_39824__$1 = (function (){var statearr_39826 = state_39824;
(statearr_39826[(7)] = inst_39798__$1);

(statearr_39826[(8)] = inst_39799);

return statearr_39826;
})();
if(cljs.core.truth_(inst_39800)){
var statearr_39827_39856 = state_39824__$1;
(statearr_39827_39856[(1)] = (8));

} else {
var statearr_39828_39857 = state_39824__$1;
(statearr_39828_39857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (1))){
var inst_39776 = optional_clauses;
var inst_39777 = cljs.core.seq(inst_39776);
var inst_39778 = cljs.core.first(inst_39777);
var inst_39779 = cljs.core.next(inst_39777);
var inst_39780 = where_tuples;
var inst_39781 = inst_39776;
var inst_39782 = inst_39780;
var state_39824__$1 = (function (){var statearr_39829 = state_39824;
(statearr_39829[(9)] = inst_39781);

(statearr_39829[(10)] = inst_39778);

(statearr_39829[(11)] = inst_39779);

(statearr_39829[(12)] = inst_39782);

return statearr_39829;
})();
var statearr_39830_39858 = state_39824__$1;
(statearr_39830_39858[(2)] = null);

(statearr_39830_39858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (4))){
var inst_39788 = (state_39824[(13)]);
var inst_39789 = (state_39824[(14)]);
var inst_39782 = (state_39824[(12)]);
var inst_39794 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_39782,inst_39788,inst_39789,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_39782,inst_39788,inst_39789,true,fuel,max_fuel,opts));
var state_39824__$1 = state_39824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39824__$1,(7),inst_39794);
} else {
if((state_val_39825 === (15))){
var state_39824__$1 = state_39824;
var statearr_39831_39859 = state_39824__$1;
(statearr_39831_39859[(2)] = null);

(statearr_39831_39859[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (13))){
var inst_39815 = (state_39824[(2)]);
var state_39824__$1 = state_39824;
var statearr_39832_39860 = state_39824__$1;
(statearr_39832_39860[(2)] = inst_39815);

(statearr_39832_39860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (6))){
var inst_39820 = (state_39824[(2)]);
var state_39824__$1 = state_39824;
var statearr_39833_39861 = state_39824__$1;
(statearr_39833_39861[(2)] = inst_39820);

(statearr_39833_39861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (3))){
var inst_39822 = (state_39824[(2)]);
var state_39824__$1 = state_39824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39824__$1,inst_39822);
} else {
if((state_val_39825 === (12))){
var state_39824__$1 = state_39824;
var statearr_39834_39862 = state_39824__$1;
(statearr_39834_39862[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (2))){
var inst_39781 = (state_39824[(9)]);
var inst_39788 = (state_39824[(13)]);
var inst_39787 = cljs.core.seq(inst_39781);
var inst_39788__$1 = cljs.core.first(inst_39787);
var inst_39789 = cljs.core.next(inst_39787);
var state_39824__$1 = (function (){var statearr_39836 = state_39824;
(statearr_39836[(13)] = inst_39788__$1);

(statearr_39836[(14)] = inst_39789);

return statearr_39836;
})();
if(cljs.core.truth_(inst_39788__$1)){
var statearr_39837_39863 = state_39824__$1;
(statearr_39837_39863[(1)] = (4));

} else {
var statearr_39838_39864 = state_39824__$1;
(statearr_39838_39864[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (11))){
var inst_39798 = (state_39824[(7)]);
var inst_39799 = (state_39824[(8)]);
var inst_39781 = inst_39799;
var inst_39782 = inst_39798;
var state_39824__$1 = (function (){var statearr_39839 = state_39824;
(statearr_39839[(9)] = inst_39781);

(statearr_39839[(12)] = inst_39782);

return statearr_39839;
})();
var statearr_39840_39865 = state_39824__$1;
(statearr_39840_39865[(2)] = null);

(statearr_39840_39865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (9))){
var inst_39788 = (state_39824[(13)]);
var inst_39804 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_39788);
var state_39824__$1 = state_39824;
if(cljs.core.truth_(inst_39804)){
var statearr_39841_39866 = state_39824__$1;
(statearr_39841_39866[(1)] = (11));

} else {
var statearr_39842_39867 = state_39824__$1;
(statearr_39842_39867[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (5))){
var inst_39782 = (state_39824[(12)]);
var state_39824__$1 = state_39824;
var statearr_39843_39868 = state_39824__$1;
(statearr_39843_39868[(2)] = inst_39782);

(statearr_39843_39868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (14))){
var inst_39798 = (state_39824[(7)]);
var inst_39799 = (state_39824[(8)]);
var inst_39782 = (state_39824[(12)]);
var inst_39809 = fluree.db.query.analytical.left_outer_join(inst_39782,inst_39798);
var inst_39781 = inst_39799;
var inst_39782__$1 = inst_39809;
var state_39824__$1 = (function (){var statearr_39844 = state_39824;
(statearr_39844[(9)] = inst_39781);

(statearr_39844[(12)] = inst_39782__$1);

return statearr_39844;
})();
var statearr_39845_39869 = state_39824__$1;
(statearr_39845_39869[(2)] = null);

(statearr_39845_39869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (16))){
var inst_39813 = (state_39824[(2)]);
var state_39824__$1 = state_39824;
var statearr_39847_39870 = state_39824__$1;
(statearr_39847_39870[(2)] = inst_39813);

(statearr_39847_39870[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (10))){
var inst_39817 = (state_39824[(2)]);
var state_39824__$1 = state_39824;
var statearr_39848_39871 = state_39824__$1;
(statearr_39848_39871[(2)] = inst_39817);

(statearr_39848_39871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39825 === (8))){
var inst_39799 = (state_39824[(8)]);
var inst_39782 = (state_39824[(12)]);
var tmp39846 = inst_39782;
var inst_39781 = inst_39799;
var inst_39782__$1 = tmp39846;
var state_39824__$1 = (function (){var statearr_39849 = state_39824;
(statearr_39849[(9)] = inst_39781);

(statearr_39849[(12)] = inst_39782__$1);

return statearr_39849;
})();
var statearr_39850_39872 = state_39824__$1;
(statearr_39850_39872[(2)] = null);

(statearr_39850_39872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____0 = (function (){
var statearr_39851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39851[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__);

(statearr_39851[(1)] = (1));

return statearr_39851;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____1 = (function (state_39824){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_39824);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e39852){var ex__17181__auto__ = e39852;
var statearr_39853_39873 = state_39824;
(statearr_39853_39873[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_39824[(4)]))){
var statearr_39854_39874 = state_39824;
(statearr_39854_39874[(1)] = cljs.core.first((state_39824[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39875 = state_39824;
state_39824 = G__39875;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__ = function(state_39824){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____1.call(this,state_39824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_39855 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_39855[(6)] = c__17304__auto__);

return statearr_39855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__39877){
var vec__39878 = p__39877;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39878,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39878,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39876_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__39876_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__39882,p__39883,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__39884 = p__39882;
var map__39884__$1 = cljs.core.__destructure_map(map__39884);
var q_map = map__39884__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39884__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__39885 = p__39883;
var map__39885__$1 = cljs.core.__destructure_map(map__39885);
var res = map__39885__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39885__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_40122){
var state_val_40123 = (state_40122[(1)]);
if((state_val_40123 === (65))){
var inst_40072 = (state_40122[(7)]);
var inst_40071 = (state_40122[(8)]);
var inst_40083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40084 = fluree.db.query.analytical.full_text__GT_tuples(inst_40071,res,inst_40072);
var inst_40085 = [inst_40084,r];
var inst_40086 = (new cljs.core.PersistentVector(null,2,(5),inst_40083,inst_40085,null));
var state_40122__$1 = state_40122;
var statearr_40124_40237 = state_40122__$1;
(statearr_40124_40237[(2)] = inst_40086);

(statearr_40124_40237[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (70))){
var inst_40098 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40125_40238 = state_40122__$1;
(statearr_40125_40238[(2)] = inst_40098);

(statearr_40125_40238[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (62))){
var inst_40072 = (state_40122[(7)]);
var inst_40080 = cljs.core.second(inst_40072);
var inst_40081 = clojure.string.starts_with_QMARK_(inst_40080,"fullText:");
var state_40122__$1 = state_40122;
if(inst_40081){
var statearr_40126_40239 = state_40122__$1;
(statearr_40126_40239[(1)] = (65));

} else {
var statearr_40127_40240 = state_40122__$1;
(statearr_40127_40240[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (7))){
var inst_39991 = (state_40122[(9)]);
var inst_39990 = cljs.core.count(clause);
var inst_39991__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_39990);
var state_40122__$1 = (function (){var statearr_40128 = state_40122;
(statearr_40128[(9)] = inst_39991__$1);

return statearr_40128;
})();
if(inst_39991__$1){
var statearr_40129_40241 = state_40122__$1;
(statearr_40129_40241[(1)] = (31));

} else {
var statearr_40130_40242 = state_40122__$1;
(statearr_40130_40242[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (59))){
var inst_40105 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40131_40243 = state_40122__$1;
(statearr_40131_40243[(2)] = inst_40105);

(statearr_40131_40243[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (20))){
var inst_39954 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40132_40244 = state_40122__$1;
(statearr_40132_40244[(2)] = inst_39954);

(statearr_40132_40244[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (58))){
var state_40122__$1 = state_40122;
var statearr_40133_40245 = state_40122__$1;
(statearr_40133_40245[(2)] = null);

(statearr_40133_40245[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (60))){
var inst_40071 = (state_40122[(8)]);
var inst_40069 = (state_40122[(2)]);
var inst_40070 = fluree.db.util.async.throw_err(inst_40069);
var inst_40071__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40070,(0),null);
var inst_40072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40070,(1),null);
var inst_40073 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_40071__$1);
var state_40122__$1 = (function (){var statearr_40134 = state_40122;
(statearr_40134[(7)] = inst_40072);

(statearr_40134[(8)] = inst_40071__$1);

return statearr_40134;
})();
if(inst_40073){
var statearr_40135_40246 = state_40122__$1;
(statearr_40135_40246[(1)] = (61));

} else {
var statearr_40136_40247 = state_40122__$1;
(statearr_40136_40247[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (27))){
var inst_39984 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40137_40248 = state_40122__$1;
(statearr_40137_40248[(2)] = inst_39984);

(statearr_40137_40248[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (1))){
var state_40122__$1 = state_40122;
var statearr_40138_40249 = state_40122__$1;
(statearr_40138_40249[(2)] = null);

(statearr_40138_40249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (69))){
var state_40122__$1 = state_40122;
var statearr_40139_40250 = state_40122__$1;
(statearr_40139_40250[(2)] = null);

(statearr_40139_40250[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (24))){
var inst_39948 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40140_40251 = state_40122__$1;
(statearr_40140_40251[(2)] = inst_39948);

(statearr_40140_40251[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (55))){
var inst_40054 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_40055 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40056 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_40057 = cljs.core.PersistentHashMap.fromArrays(inst_40055,inst_40056);
var inst_40058 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40054,inst_40057);
var inst_40059 = (function(){throw inst_40058})();
var state_40122__$1 = state_40122;
var statearr_40141_40252 = state_40122__$1;
(statearr_40141_40252[(2)] = inst_40059);

(statearr_40141_40252[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (39))){
var inst_40011 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
if(cljs.core.truth_(inst_40011)){
var statearr_40142_40253 = state_40122__$1;
(statearr_40142_40253[(1)] = (40));

} else {
var statearr_40143_40254 = state_40122__$1;
(statearr_40143_40254[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (46))){
var inst_40111 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40144_40255 = state_40122__$1;
(statearr_40144_40255[(2)] = inst_40111);

(statearr_40144_40255[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (4))){
var inst_39886 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40145_40256 = state_40122__$1;
(statearr_40145_40256[(2)] = inst_39886);

(statearr_40145_40256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (54))){
var inst_40047 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_40048 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40049 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_40050 = cljs.core.PersistentHashMap.fromArrays(inst_40048,inst_40049);
var inst_40051 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40047,inst_40050);
var inst_40052 = (function(){throw inst_40051})();
var state_40122__$1 = state_40122;
var statearr_40146_40257 = state_40122__$1;
(statearr_40146_40257[(2)] = inst_40052);

(statearr_40146_40257[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (15))){
var inst_39986 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40147_40258 = state_40122__$1;
(statearr_40147_40258[(2)] = inst_39986);

(statearr_40147_40258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (48))){
var inst_40035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40036 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_40037 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_40036);
var inst_40038 = [inst_40037,r];
var inst_40039 = (new cljs.core.PersistentVector(null,2,(5),inst_40035,inst_40038,null));
var state_40122__$1 = state_40122;
var statearr_40148_40259 = state_40122__$1;
(statearr_40148_40259[(2)] = inst_40039);

(statearr_40148_40259[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (50))){
var inst_40109 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40149_40260 = state_40122__$1;
(statearr_40149_40260[(2)] = inst_40109);

(statearr_40149_40260[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (21))){
var inst_39924 = (state_40122[(10)]);
var inst_39920 = (state_40122[(11)]);
var inst_39922 = (state_40122[(12)]);
var inst_39931 = (state_40122[(13)]);
var inst_39923 = (state_40122[(14)]);
var inst_39925 = (state_40122[(15)]);
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39932 = (state_40122[(18)]);
var inst_39936 = (state_40122[(2)]);
var inst_39937 = fluree.db.util.async.throw_err(inst_39936);
var inst_39938 = (function (){var new_res = inst_39937;
var vec__39927 = inst_39924;
var first__39919 = inst_39922;
var rest = inst_39932;
var first__39929 = inst_39931;
var tuples = inst_39925;
var pred__39896 = inst_39899;
var seq__39918 = inst_39923;
var G__39916 = inst_39924;
var seq__39928 = inst_39932;
var expr__39897 = inst_39895;
var segment_type = inst_39895;
var clause_group = inst_39931;
var vec__39917 = inst_39920;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_39939 = cljs.core.keys(vars);
var inst_39940 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39938,inst_39937,inst_39939);
var inst_39941 = fluree.db.query.analytical.res_absorb_vars(inst_39940);
var state_40122__$1 = (function (){var statearr_40150 = state_40122;
(statearr_40150[(19)] = inst_39941);

return statearr_40150;
})();
if(cljs.core.truth_(inst_39925)){
var statearr_40151_40261 = state_40122__$1;
(statearr_40151_40261[(1)] = (22));

} else {
var statearr_40152_40262 = state_40122__$1;
(statearr_40152_40262[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (31))){
var inst_39993 = cljs.core.second(clause);
var inst_39994 = clojure.string.starts_with_QMARK_(inst_39993,"fullText:");
var state_40122__$1 = state_40122;
var statearr_40153_40263 = state_40122__$1;
(statearr_40153_40263[(2)] = inst_39994);

(statearr_40153_40263[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (32))){
var inst_39991 = (state_40122[(9)]);
var state_40122__$1 = state_40122;
var statearr_40154_40264 = state_40122__$1;
(statearr_40154_40264[(2)] = inst_39991);

(statearr_40154_40264[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (40))){
var inst_40013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40014 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_40122__$1 = (function (){var statearr_40155 = state_40122;
(statearr_40155[(20)] = inst_40013);

return statearr_40155;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(43),inst_40014);
} else {
if((state_val_40123 === (56))){
var inst_40061 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40156_40265 = state_40122__$1;
(statearr_40156_40265[(2)] = inst_40061);

(statearr_40156_40265[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (33))){
var inst_39997 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
if(cljs.core.truth_(inst_39997)){
var statearr_40157_40266 = state_40122__$1;
(statearr_40157_40266[(1)] = (34));

} else {
var statearr_40158_40267 = state_40122__$1;
(statearr_40158_40267[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (13))){
var inst_39920 = (state_40122[(11)]);
var inst_39920__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_39921 = cljs.core.seq(inst_39920__$1);
var inst_39922 = cljs.core.first(inst_39921);
var inst_39923 = cljs.core.next(inst_39921);
var inst_39924 = inst_39920__$1;
var inst_39925 = null;
var state_40122__$1 = (function (){var statearr_40159 = state_40122;
(statearr_40159[(10)] = inst_39924);

(statearr_40159[(11)] = inst_39920__$1);

(statearr_40159[(12)] = inst_39922);

(statearr_40159[(14)] = inst_39923);

(statearr_40159[(15)] = inst_39925);

return statearr_40159;
})();
var statearr_40160_40268 = state_40122__$1;
(statearr_40160_40268[(2)] = null);

(statearr_40160_40268[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (22))){
var inst_39941 = (state_40122[(19)]);
var inst_39925 = (state_40122[(15)]);
var inst_39932 = (state_40122[(18)]);
var inst_39943 = fluree.db.query.union.results(inst_39925,inst_39941);
var inst_39924 = inst_39932;
var inst_39925__$1 = inst_39943;
var state_40122__$1 = (function (){var statearr_40161 = state_40122;
(statearr_40161[(10)] = inst_39924);

(statearr_40161[(15)] = inst_39925__$1);

return statearr_40161;
})();
var statearr_40162_40269 = state_40122__$1;
(statearr_40162_40269[(2)] = null);

(statearr_40162_40269[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (36))){
var inst_40115 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40163_40270 = state_40122__$1;
(statearr_40163_40270[(2)] = inst_40115);

(statearr_40163_40270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (41))){
var inst_40021 = cljs.core.count(clause);
var inst_40022 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_40021);
var state_40122__$1 = state_40122;
if(inst_40022){
var statearr_40164_40271 = state_40122__$1;
(statearr_40164_40271[(1)] = (44));

} else {
var statearr_40165_40272 = state_40122__$1;
(statearr_40165_40272[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (43))){
var inst_40013 = (state_40122[(20)]);
var inst_40016 = (state_40122[(2)]);
var inst_40017 = fluree.db.util.async.throw_err(inst_40016);
var inst_40018 = [inst_40017,r];
var inst_40019 = (new cljs.core.PersistentVector(null,2,(5),inst_40013,inst_40018,null));
var state_40122__$1 = state_40122;
var statearr_40166_40273 = state_40122__$1;
(statearr_40166_40273[(2)] = inst_40019);

(statearr_40166_40273[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (61))){
var inst_40072 = (state_40122[(7)]);
var inst_40075 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_40072,r,res,optional_QMARK_,fuel,max_fuel);
var state_40122__$1 = state_40122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(64),inst_40075);
} else {
if((state_val_40123 === (29))){
var inst_39895 = (state_40122[(17)]);
var inst_39978 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39895)].join('');
var inst_39979 = (new Error(inst_39978));
var inst_39980 = (function(){throw inst_39979})();
var state_40122__$1 = state_40122;
var statearr_40167_40274 = state_40122__$1;
(statearr_40167_40274[(2)] = inst_39980);

(statearr_40167_40274[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (44))){
var inst_40024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40025 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_40122__$1 = (function (){var statearr_40168 = state_40122;
(statearr_40168[(21)] = inst_40024);

return statearr_40168;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(47),inst_40025);
} else {
if((state_val_40123 === (6))){
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39894 = cljs.core.keys(clause);
var inst_39895__$1 = cljs.core.first(inst_39894);
var inst_39899__$1 = cljs.core._EQ_;
var inst_39900 = (function (){var G__40169 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__40170 = inst_39895__$1;
return (inst_39899__$1.cljs$core$IFn$_invoke$arity$2 ? inst_39899__$1.cljs$core$IFn$_invoke$arity$2(G__40169,G__40170) : inst_39899__$1.call(null,G__40169,G__40170));
})();
var state_40122__$1 = (function (){var statearr_40171 = state_40122;
(statearr_40171[(16)] = inst_39899__$1);

(statearr_40171[(17)] = inst_39895__$1);

return statearr_40171;
})();
if(cljs.core.truth_(inst_39900)){
var statearr_40172_40275 = state_40122__$1;
(statearr_40172_40275[(1)] = (9));

} else {
var statearr_40173_40276 = state_40122__$1;
(statearr_40173_40276[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (28))){
var inst_39972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39973 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_39974 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_39973,optional_QMARK_);
var inst_39975 = [inst_39974,r];
var inst_39976 = (new cljs.core.PersistentVector(null,2,(5),inst_39972,inst_39975,null));
var state_40122__$1 = state_40122;
var statearr_40174_40277 = state_40122__$1;
(statearr_40174_40277[(2)] = inst_39976);

(statearr_40174_40277[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (64))){
var inst_40077 = (state_40122[(2)]);
var inst_40078 = fluree.db.util.async.throw_err(inst_40077);
var state_40122__$1 = state_40122;
var statearr_40175_40278 = state_40122__$1;
(statearr_40175_40278[(2)] = inst_40078);

(statearr_40175_40278[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (51))){
var inst_40044 = cljs.core.first(clause);
var inst_40045 = cljs.core.sequential_QMARK_(inst_40044);
var state_40122__$1 = state_40122;
if(inst_40045){
var statearr_40176_40279 = state_40122__$1;
(statearr_40176_40279[(1)] = (54));

} else {
var statearr_40177_40280 = state_40122__$1;
(statearr_40177_40280[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (25))){
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39960 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_39961 = (function (){var segment_type = inst_39895;
var pred__39896 = inst_39899;
var expr__39897 = inst_39895;
var bindings = inst_39960;
return (function (p1__39881_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__39881_SHARP_);
});
})();
var inst_39962 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39961,inst_39960);
var inst_39963 = cljs.core.PersistentHashMap.EMPTY;
var inst_39964 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39963,inst_39962);
var inst_39965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39966 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_39964);
var inst_39967 = [inst_39966,r];
var inst_39968 = (new cljs.core.PersistentVector(null,2,(5),inst_39965,inst_39967,null));
var state_40122__$1 = state_40122;
var statearr_40178_40281 = state_40122__$1;
(statearr_40178_40281[(2)] = inst_39968);

(statearr_40178_40281[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (34))){
var inst_39999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40000 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_40001 = [inst_40000,r];
var inst_40002 = (new cljs.core.PersistentVector(null,2,(5),inst_39999,inst_40001,null));
var state_40122__$1 = state_40122;
var statearr_40179_40282 = state_40122__$1;
(statearr_40179_40282[(2)] = inst_40002);

(statearr_40179_40282[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (17))){
var inst_39956 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40180_40283 = state_40122__$1;
(statearr_40180_40283[(2)] = inst_39956);

(statearr_40180_40283[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (3))){
var inst_40120 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40122__$1,inst_40120);
} else {
if((state_val_40123 === (12))){
var inst_39902 = (state_40122[(22)]);
var inst_39906 = (state_40122[(2)]);
var inst_39907 = fluree.db.util.async.throw_err(inst_39906);
var inst_39908 = [inst_39907,r];
var inst_39909 = (new cljs.core.PersistentVector(null,2,(5),inst_39902,inst_39908,null));
var state_40122__$1 = state_40122;
var statearr_40181_40284 = state_40122__$1;
(statearr_40181_40284[(2)] = inst_39909);

(statearr_40181_40284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (2))){
var _ = (function (){var statearr_40182 = state_40122;
(statearr_40182[(4)] = cljs.core.cons((5),(state_40122[(4)])));

return statearr_40182;
})();
var inst_39892 = cljs.core.map_QMARK_(clause);
var state_40122__$1 = state_40122;
if(inst_39892){
var statearr_40183_40285 = state_40122__$1;
(statearr_40183_40285[(1)] = (6));

} else {
var statearr_40184_40286 = state_40122__$1;
(statearr_40184_40286[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (66))){
var state_40122__$1 = state_40122;
var statearr_40185_40287 = state_40122__$1;
(statearr_40185_40287[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (23))){
var inst_39941 = (state_40122[(19)]);
var inst_39932 = (state_40122[(18)]);
var inst_39924 = inst_39932;
var inst_39925 = inst_39941;
var state_40122__$1 = (function (){var statearr_40187 = state_40122;
(statearr_40187[(10)] = inst_39924);

(statearr_40187[(15)] = inst_39925);

return statearr_40187;
})();
var statearr_40188_40288 = state_40122__$1;
(statearr_40188_40288[(2)] = null);

(statearr_40188_40288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (47))){
var inst_40024 = (state_40122[(21)]);
var inst_40027 = (state_40122[(2)]);
var inst_40028 = fluree.db.util.async.throw_err(inst_40027);
var inst_40029 = [inst_40028,r];
var inst_40030 = (new cljs.core.PersistentVector(null,2,(5),inst_40024,inst_40029,null));
var state_40122__$1 = state_40122;
var statearr_40189_40289 = state_40122__$1;
(statearr_40189_40289[(2)] = inst_40030);

(statearr_40189_40289[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (35))){
var inst_40005 = (state_40122[(23)]);
var inst_40004 = cljs.core.count(clause);
var inst_40005__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_40004);
var state_40122__$1 = (function (){var statearr_40190 = state_40122;
(statearr_40190[(23)] = inst_40005__$1);

return statearr_40190;
})();
if(inst_40005__$1){
var statearr_40191_40290 = state_40122__$1;
(statearr_40191_40290[(1)] = (37));

} else {
var statearr_40192_40291 = state_40122__$1;
(statearr_40192_40291[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (19))){
var inst_39925 = (state_40122[(15)]);
var inst_39950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39951 = [inst_39925,r];
var inst_39952 = (new cljs.core.PersistentVector(null,2,(5),inst_39950,inst_39951,null));
var state_40122__$1 = state_40122;
var statearr_40193_40292 = state_40122__$1;
(statearr_40193_40292[(2)] = inst_39952);

(statearr_40193_40292[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (57))){
var inst_40067 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_40122__$1 = state_40122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(60),inst_40067);
} else {
if((state_val_40123 === (68))){
var inst_40072 = (state_40122[(7)]);
var inst_40071 = (state_40122[(8)]);
var inst_40089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40090 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_40071,res,inst_40072,fuel,max_fuel);
var state_40122__$1 = (function (){var statearr_40194 = state_40122;
(statearr_40194[(24)] = inst_40089);

return statearr_40194;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(71),inst_40090);
} else {
if((state_val_40123 === (11))){
var inst_39988 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40196_40293 = state_40122__$1;
(statearr_40196_40293[(2)] = inst_39988);

(statearr_40196_40293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (9))){
var inst_39902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39903 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_39904 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_39903,res,fuel,max_fuel,opts);
var state_40122__$1 = (function (){var statearr_40197 = state_40122;
(statearr_40197[(22)] = inst_39902);

return statearr_40197;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(12),inst_39904);
} else {
if((state_val_40123 === (5))){
var _ = (function (){var statearr_40198 = state_40122;
(statearr_40198[(4)] = cljs.core.rest((state_40122[(4)])));

return statearr_40198;
})();
var state_40122__$1 = state_40122;
var ex40195 = (state_40122__$1[(2)]);
var statearr_40199_40294 = state_40122__$1;
(statearr_40199_40294[(5)] = ex40195);


if((ex40195 instanceof Error)){
var statearr_40200_40295 = state_40122__$1;
(statearr_40200_40295[(1)] = (4));

(statearr_40200_40295[(5)] = null);

} else {
throw ex40195;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (14))){
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39958 = (function (){var G__40201 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__40202 = inst_39895;
return (inst_39899.cljs$core$IFn$_invoke$arity$2 ? inst_39899.cljs$core$IFn$_invoke$arity$2(G__40201,G__40202) : inst_39899.call(null,G__40201,G__40202));
})();
var state_40122__$1 = state_40122;
if(cljs.core.truth_(inst_39958)){
var statearr_40203_40296 = state_40122__$1;
(statearr_40203_40296[(1)] = (25));

} else {
var statearr_40204_40297 = state_40122__$1;
(statearr_40204_40297[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (45))){
var inst_40032 = cljs.core.count(clause);
var inst_40033 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_40032);
var state_40122__$1 = state_40122;
if(inst_40033){
var statearr_40205_40298 = state_40122__$1;
(statearr_40205_40298[(1)] = (48));

} else {
var statearr_40206_40299 = state_40122__$1;
(statearr_40206_40299[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (53))){
var inst_40107 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40207_40300 = state_40122__$1;
(statearr_40207_40300[(2)] = inst_40107);

(statearr_40207_40300[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (26))){
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39970 = (function (){var G__40208 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__40209 = inst_39895;
return (inst_39899.cljs$core$IFn$_invoke$arity$2 ? inst_39899.cljs$core$IFn$_invoke$arity$2(G__40208,G__40209) : inst_39899.call(null,G__40208,G__40209));
})();
var state_40122__$1 = state_40122;
if(cljs.core.truth_(inst_39970)){
var statearr_40210_40301 = state_40122__$1;
(statearr_40210_40301[(1)] = (28));

} else {
var statearr_40211_40302 = state_40122__$1;
(statearr_40211_40302[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (16))){
var inst_39924 = (state_40122[(10)]);
var inst_39931 = (state_40122[(13)]);
var inst_39930 = cljs.core.seq(inst_39924);
var inst_39931__$1 = cljs.core.first(inst_39930);
var inst_39932 = cljs.core.next(inst_39930);
var state_40122__$1 = (function (){var statearr_40212 = state_40122;
(statearr_40212[(13)] = inst_39931__$1);

(statearr_40212[(18)] = inst_39932);

return statearr_40212;
})();
if(cljs.core.truth_(inst_39931__$1)){
var statearr_40213_40303 = state_40122__$1;
(statearr_40213_40303[(1)] = (18));

} else {
var statearr_40214_40304 = state_40122__$1;
(statearr_40214_40304[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (38))){
var inst_40005 = (state_40122[(23)]);
var state_40122__$1 = state_40122;
var statearr_40215_40305 = state_40122__$1;
(statearr_40215_40305[(2)] = inst_40005);

(statearr_40215_40305[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (30))){
var inst_39982 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40216_40306 = state_40122__$1;
(statearr_40216_40306[(2)] = inst_39982);

(statearr_40216_40306[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (10))){
var inst_39899 = (state_40122[(16)]);
var inst_39895 = (state_40122[(17)]);
var inst_39911 = (function (){var G__40217 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__40218 = inst_39895;
return (inst_39899.cljs$core$IFn$_invoke$arity$2 ? inst_39899.cljs$core$IFn$_invoke$arity$2(G__40217,G__40218) : inst_39899.call(null,G__40217,G__40218));
})();
var state_40122__$1 = state_40122;
if(cljs.core.truth_(inst_39911)){
var statearr_40219_40307 = state_40122__$1;
(statearr_40219_40307[(1)] = (13));

} else {
var statearr_40220_40308 = state_40122__$1;
(statearr_40220_40308[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (18))){
var inst_39931 = (state_40122[(13)]);
var inst_39934 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_39931,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_39931,q_map,vars,fuel,max_fuel,opts));
var state_40122__$1 = state_40122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40122__$1,(21),inst_39934);
} else {
if((state_val_40123 === (52))){
var state_40122__$1 = state_40122;
var statearr_40221_40309 = state_40122__$1;
(statearr_40221_40309[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (67))){
var inst_40100 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40223_40310 = state_40122__$1;
(statearr_40223_40310[(2)] = inst_40100);

(statearr_40223_40310[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (71))){
var inst_40089 = (state_40122[(24)]);
var inst_40092 = (state_40122[(2)]);
var inst_40093 = fluree.db.util.async.throw_err(inst_40092);
var inst_40094 = [inst_40093,r];
var inst_40095 = (new cljs.core.PersistentVector(null,2,(5),inst_40089,inst_40094,null));
var state_40122__$1 = state_40122;
var statearr_40224_40311 = state_40122__$1;
(statearr_40224_40311[(2)] = inst_40095);

(statearr_40224_40311[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (42))){
var inst_40113 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40225_40312 = state_40122__$1;
(statearr_40225_40312[(2)] = inst_40113);

(statearr_40225_40312[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (37))){
var inst_40007 = cljs.core.second(clause);
var inst_40008 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40007,"rdf:type");
var state_40122__$1 = state_40122;
var statearr_40226_40313 = state_40122__$1;
(statearr_40226_40313[(2)] = inst_40008);

(statearr_40226_40313[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (63))){
var inst_40102 = (state_40122[(2)]);
var state_40122__$1 = state_40122;
var statearr_40227_40314 = state_40122__$1;
(statearr_40227_40314[(2)] = inst_40102);

(statearr_40227_40314[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (8))){
var inst_40117 = (state_40122[(2)]);
var _ = (function (){var statearr_40228 = state_40122;
(statearr_40228[(4)] = cljs.core.rest((state_40122[(4)])));

return statearr_40228;
})();
var state_40122__$1 = state_40122;
var statearr_40229_40315 = state_40122__$1;
(statearr_40229_40315[(2)] = inst_40117);

(statearr_40229_40315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40123 === (49))){
var inst_40041 = cljs.core.count(clause);
var inst_40042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_40041);
var state_40122__$1 = state_40122;
if(inst_40042){
var statearr_40230_40316 = state_40122__$1;
(statearr_40230_40316[(1)] = (51));

} else {
var statearr_40231_40317 = state_40122__$1;
(statearr_40231_40317[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____0 = (function (){
var statearr_40232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40232[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__);

(statearr_40232[(1)] = (1));

return statearr_40232;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____1 = (function (state_40122){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_40122);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e40233){var ex__17181__auto__ = e40233;
var statearr_40234_40318 = state_40122;
(statearr_40234_40318[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_40122[(4)]))){
var statearr_40235_40319 = state_40122;
(statearr_40235_40319[(1)] = cljs.core.first((state_40122[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40320 = state_40122;
state_40122 = G__40320;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__ = function(state_40122){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____1.call(this,state_40122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_40236 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_40236[(6)] = c__17304__auto__);

return statearr_40236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__40322 = arguments.length;
switch (G__40322) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_40402){
var state_val_40403 = (state_40402[(1)]);
if((state_val_40403 === (7))){
var inst_40397 = (state_40402[(2)]);
var _ = (function (){var statearr_40404 = state_40402;
(statearr_40404[(4)] = cljs.core.rest((state_40402[(4)])));

return statearr_40404;
})();
var state_40402__$1 = state_40402;
var statearr_40405_40453 = state_40402__$1;
(statearr_40405_40453[(2)] = inst_40397);

(statearr_40405_40453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (20))){
var inst_40362 = (state_40402[(7)]);
var inst_40374 = (state_40402[(2)]);
var inst_40344 = inst_40362;
var inst_40345 = inst_40374;
var state_40402__$1 = (function (){var statearr_40406 = state_40402;
(statearr_40406[(8)] = inst_40344);

(statearr_40406[(9)] = inst_40345);

return statearr_40406;
})();
var statearr_40407_40454 = state_40402__$1;
(statearr_40407_40454[(2)] = null);

(statearr_40407_40454[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (1))){
var state_40402__$1 = state_40402;
var statearr_40408_40455 = state_40402__$1;
(statearr_40408_40455[(2)] = null);

(statearr_40408_40455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (24))){
var inst_40361 = (state_40402[(10)]);
var inst_40362 = (state_40402[(7)]);
var inst_40345 = (state_40402[(9)]);
var inst_40382 = fluree.db.query.analytical.inner_join(inst_40345,inst_40361);
var inst_40344 = inst_40362;
var inst_40345__$1 = inst_40382;
var state_40402__$1 = (function (){var statearr_40409 = state_40402;
(statearr_40409[(8)] = inst_40344);

(statearr_40409[(9)] = inst_40345__$1);

return statearr_40409;
})();
var statearr_40410_40456 = state_40402__$1;
(statearr_40410_40456[(2)] = null);

(statearr_40410_40456[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (4))){
var inst_40323 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40412_40457 = state_40402__$1;
(statearr_40412_40457[(2)] = inst_40323);

(statearr_40412_40457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (15))){
var inst_40361 = (state_40402[(10)]);
var state_40402__$1 = state_40402;
if(cljs.core.truth_(inst_40361)){
var statearr_40413_40458 = state_40402__$1;
(statearr_40413_40458[(1)] = (18));

} else {
var statearr_40414_40459 = state_40402__$1;
(statearr_40414_40459[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (21))){
var inst_40362 = (state_40402[(7)]);
var inst_40345 = (state_40402[(9)]);
var tmp40411 = inst_40345;
var inst_40344 = inst_40362;
var inst_40345__$1 = tmp40411;
var state_40402__$1 = (function (){var statearr_40415 = state_40402;
(statearr_40415[(8)] = inst_40344);

(statearr_40415[(9)] = inst_40345__$1);

return statearr_40415;
})();
var statearr_40416_40460 = state_40402__$1;
(statearr_40416_40460[(2)] = null);

(statearr_40416_40460[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (13))){
var inst_40345 = (state_40402[(9)]);
var inst_40368 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_40345,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_40369 = cljs.core.empty_QMARK_(inst_40368);
var state_40402__$1 = state_40402;
if(inst_40369){
var statearr_40417_40461 = state_40402__$1;
(statearr_40417_40461[(1)] = (15));

} else {
var statearr_40418_40462 = state_40402__$1;
(statearr_40418_40462[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (22))){
var state_40402__$1 = state_40402;
var statearr_40419_40463 = state_40402__$1;
(statearr_40419_40463[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (6))){
var inst_40351 = (state_40402[(11)]);
var inst_40344 = (state_40402[(8)]);
var inst_40350 = cljs.core.seq(inst_40344);
var inst_40351__$1 = cljs.core.first(inst_40350);
var inst_40352 = cljs.core.next(inst_40350);
var state_40402__$1 = (function (){var statearr_40421 = state_40402;
(statearr_40421[(12)] = inst_40352);

(statearr_40421[(11)] = inst_40351__$1);

return statearr_40421;
})();
if(cljs.core.truth_(inst_40351__$1)){
var statearr_40422_40464 = state_40402__$1;
(statearr_40422_40464[(1)] = (8));

} else {
var statearr_40423_40465 = state_40402__$1;
(statearr_40423_40465[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (25))){
var state_40402__$1 = state_40402;
var statearr_40424_40466 = state_40402__$1;
(statearr_40424_40466[(2)] = null);

(statearr_40424_40466[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (17))){
var inst_40390 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40425_40467 = state_40402__$1;
(statearr_40425_40467[(2)] = inst_40390);

(statearr_40425_40467[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (3))){
var inst_40400 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40402__$1,inst_40400);
} else {
if((state_val_40403 === (12))){
var inst_40361 = (state_40402[(10)]);
var inst_40362 = (state_40402[(7)]);
var inst_40344 = inst_40362;
var inst_40345 = inst_40361;
var state_40402__$1 = (function (){var statearr_40426 = state_40402;
(statearr_40426[(8)] = inst_40344);

(statearr_40426[(9)] = inst_40345);

return statearr_40426;
})();
var statearr_40427_40468 = state_40402__$1;
(statearr_40427_40468[(2)] = null);

(statearr_40427_40468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (2))){
var _ = (function (){var statearr_40428 = state_40402;
(statearr_40428[(4)] = cljs.core.cons((5),(state_40402[(4)])));

return statearr_40428;
})();
var inst_40336 = where;
var inst_40337 = cljs.core.seq(inst_40336);
var inst_40338 = cljs.core.first(inst_40337);
var inst_40339 = cljs.core.next(inst_40337);
var inst_40340 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_40341 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_40342 = [inst_40341];
var inst_40343 = cljs.core.PersistentHashMap.fromArrays(inst_40340,inst_40342);
var inst_40344 = inst_40336;
var inst_40345 = inst_40343;
var state_40402__$1 = (function (){var statearr_40429 = state_40402;
(statearr_40429[(13)] = inst_40338);

(statearr_40429[(8)] = inst_40344);

(statearr_40429[(14)] = inst_40339);

(statearr_40429[(9)] = inst_40345);

return statearr_40429;
})();
var statearr_40430_40469 = state_40402__$1;
(statearr_40430_40469[(2)] = null);

(statearr_40430_40469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (23))){
var inst_40388 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40431_40470 = state_40402__$1;
(statearr_40431_40470[(2)] = inst_40388);

(statearr_40431_40470[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (19))){
var inst_40345 = (state_40402[(9)]);
var state_40402__$1 = state_40402;
var statearr_40432_40471 = state_40402__$1;
(statearr_40432_40471[(2)] = inst_40345);

(statearr_40432_40471[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (11))){
var inst_40351 = (state_40402[(11)]);
var inst_40359 = (state_40402[(2)]);
var inst_40360 = fluree.db.util.async.throw_err(inst_40359);
var inst_40361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40360,(0),null);
var inst_40362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40360,(1),null);
var inst_40363 = cljs.core.count(inst_40351);
var inst_40364 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_40363);
var state_40402__$1 = (function (){var statearr_40434 = state_40402;
(statearr_40434[(10)] = inst_40361);

(statearr_40434[(7)] = inst_40362);

return statearr_40434;
})();
if(inst_40364){
var statearr_40435_40472 = state_40402__$1;
(statearr_40435_40472[(1)] = (12));

} else {
var statearr_40436_40473 = state_40402__$1;
(statearr_40436_40473[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (9))){
var inst_40345 = (state_40402[(9)]);
var state_40402__$1 = state_40402;
var statearr_40437_40474 = state_40402__$1;
(statearr_40437_40474[(2)] = inst_40345);

(statearr_40437_40474[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (5))){
var _ = (function (){var statearr_40438 = state_40402;
(statearr_40438[(4)] = cljs.core.rest((state_40402[(4)])));

return statearr_40438;
})();
var state_40402__$1 = state_40402;
var ex40433 = (state_40402__$1[(2)]);
var statearr_40439_40475 = state_40402__$1;
(statearr_40439_40475[(5)] = ex40433);


if((ex40433 instanceof Error)){
var statearr_40440_40476 = state_40402__$1;
(statearr_40440_40476[(1)] = (4));

(statearr_40440_40476[(5)] = null);

} else {
throw ex40433;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (14))){
var inst_40392 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40441_40477 = state_40402__$1;
(statearr_40441_40477[(2)] = inst_40392);

(statearr_40441_40477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (26))){
var inst_40386 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40442_40478 = state_40402__$1;
(statearr_40442_40478[(2)] = inst_40386);

(statearr_40442_40478[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (16))){
var inst_40361 = (state_40402[(10)]);
var inst_40377 = (inst_40361 == null);
var state_40402__$1 = state_40402;
if(cljs.core.truth_(inst_40377)){
var statearr_40443_40479 = state_40402__$1;
(statearr_40443_40479[(1)] = (21));

} else {
var statearr_40444_40480 = state_40402__$1;
(statearr_40444_40480[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (10))){
var inst_40395 = (state_40402[(2)]);
var state_40402__$1 = state_40402;
var statearr_40445_40481 = state_40402__$1;
(statearr_40445_40481[(2)] = inst_40395);

(statearr_40445_40481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (18))){
var inst_40361 = (state_40402[(10)]);
var state_40402__$1 = state_40402;
var statearr_40446_40482 = state_40402__$1;
(statearr_40446_40482[(2)] = inst_40361);

(statearr_40446_40482[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40403 === (8))){
var inst_40352 = (state_40402[(12)]);
var inst_40351 = (state_40402[(11)]);
var inst_40345 = (state_40402[(9)]);
var inst_40357 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_40345,inst_40351,inst_40352,false,fuel,max_fuel,opts);
var state_40402__$1 = state_40402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40402__$1,(11),inst_40357);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__17178__auto__ = null;
var fluree$db$query$analytical$state_machine__17178__auto____0 = (function (){
var statearr_40447 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40447[(0)] = fluree$db$query$analytical$state_machine__17178__auto__);

(statearr_40447[(1)] = (1));

return statearr_40447;
});
var fluree$db$query$analytical$state_machine__17178__auto____1 = (function (state_40402){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_40402);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e40448){var ex__17181__auto__ = e40448;
var statearr_40449_40483 = state_40402;
(statearr_40449_40483[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_40402[(4)]))){
var statearr_40450_40484 = state_40402;
(statearr_40450_40484[(1)] = cljs.core.first((state_40402[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40485 = state_40402;
state_40402 = G__40485;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__17178__auto__ = function(state_40402){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__17178__auto____1.call(this,state_40402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__17178__auto____0;
fluree$db$query$analytical$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__17178__auto____1;
return fluree$db$query$analytical$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_40451 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_40451[(6)] = c__17304__auto__);

return statearr_40451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_40520){
var state_val_40521 = (state_40520[(1)]);
if((state_val_40521 === (7))){
var inst_40502 = (state_40520[(7)]);
var inst_40497 = (state_40520[(8)]);
var inst_40504 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_40497,inst_40502,fuel,max_fuel,opts);
var state_40520__$1 = state_40520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40520__$1,(10),inst_40504);
} else {
if((state_val_40521 === (1))){
var state_40520__$1 = state_40520;
var statearr_40522_40547 = state_40520__$1;
(statearr_40522_40547[(2)] = null);

(statearr_40522_40547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (4))){
var inst_40486 = (state_40520[(2)]);
var state_40520__$1 = state_40520;
var statearr_40523_40548 = state_40520__$1;
(statearr_40523_40548[(2)] = inst_40486);

(statearr_40523_40548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (13))){
var inst_40515 = (state_40520[(2)]);
var _ = (function (){var statearr_40524 = state_40520;
(statearr_40524[(4)] = cljs.core.rest((state_40520[(4)])));

return statearr_40524;
})();
var state_40520__$1 = state_40520;
var statearr_40525_40549 = state_40520__$1;
(statearr_40525_40549[(2)] = inst_40515);

(statearr_40525_40549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (6))){
var inst_40497 = (state_40520[(8)]);
var inst_40501 = (state_40520[(2)]);
var inst_40502 = fluree.db.util.async.throw_err(inst_40501);
var state_40520__$1 = (function (){var statearr_40526 = state_40520;
(statearr_40526[(7)] = inst_40502);

return statearr_40526;
})();
if(cljs.core.truth_(inst_40497)){
var statearr_40527_40550 = state_40520__$1;
(statearr_40527_40550[(1)] = (7));

} else {
var statearr_40528_40551 = state_40520__$1;
(statearr_40528_40551[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (3))){
var inst_40518 = (state_40520[(2)]);
var state_40520__$1 = state_40520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40520__$1,inst_40518);
} else {
if((state_val_40521 === (12))){
var inst_40510 = (state_40520[(9)]);
var state_40520__$1 = state_40520;
var statearr_40529_40552 = state_40520__$1;
(statearr_40529_40552[(2)] = inst_40510);

(statearr_40529_40552[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (2))){
var _ = (function (){var statearr_40530 = state_40520;
(statearr_40530[(4)] = cljs.core.cons((5),(state_40520[(4)])));

return statearr_40530;
})();
var inst_40493 = q_map;
var inst_40494 = cljs.core.__destructure_map(inst_40493);
var inst_40495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40494,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_40496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40494,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_40497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40494,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_40498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40494,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_40499 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_40496,q_map,inst_40495,fuel,max_fuel,opts);
var state_40520__$1 = (function (){var statearr_40531 = state_40520;
(statearr_40531[(10)] = inst_40498);

(statearr_40531[(8)] = inst_40497);

return statearr_40531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40520__$1,(6),inst_40499);
} else {
if((state_val_40521 === (11))){
var inst_40510 = (state_40520[(9)]);
var inst_40498 = (state_40520[(10)]);
var inst_40512 = fluree.db.query.analytical.tuples__GT_filtered(inst_40510,inst_40498,null);
var state_40520__$1 = state_40520;
var statearr_40533_40553 = state_40520__$1;
(statearr_40533_40553[(2)] = inst_40512);

(statearr_40533_40553[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (9))){
var inst_40498 = (state_40520[(10)]);
var inst_40510 = (state_40520[(2)]);
var state_40520__$1 = (function (){var statearr_40534 = state_40520;
(statearr_40534[(9)] = inst_40510);

return statearr_40534;
})();
if(cljs.core.truth_(inst_40498)){
var statearr_40535_40554 = state_40520__$1;
(statearr_40535_40554[(1)] = (11));

} else {
var statearr_40536_40555 = state_40520__$1;
(statearr_40536_40555[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (5))){
var _ = (function (){var statearr_40537 = state_40520;
(statearr_40537[(4)] = cljs.core.rest((state_40520[(4)])));

return statearr_40537;
})();
var state_40520__$1 = state_40520;
var ex40532 = (state_40520__$1[(2)]);
var statearr_40538_40556 = state_40520__$1;
(statearr_40538_40556[(5)] = ex40532);


if((ex40532 instanceof Error)){
var statearr_40539_40557 = state_40520__$1;
(statearr_40539_40557[(1)] = (4));

(statearr_40539_40557[(5)] = null);

} else {
throw ex40532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (10))){
var inst_40506 = (state_40520[(2)]);
var inst_40507 = fluree.db.util.async.throw_err(inst_40506);
var state_40520__$1 = state_40520;
var statearr_40540_40558 = state_40520__$1;
(statearr_40540_40558[(2)] = inst_40507);

(statearr_40540_40558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40521 === (8))){
var inst_40502 = (state_40520[(7)]);
var state_40520__$1 = state_40520;
var statearr_40541_40559 = state_40520__$1;
(statearr_40541_40559[(2)] = inst_40502);

(statearr_40541_40559[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__17178__auto____0 = (function (){
var statearr_40542 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40542[(0)] = fluree$db$query$analytical$q_$_state_machine__17178__auto__);

(statearr_40542[(1)] = (1));

return statearr_40542;
});
var fluree$db$query$analytical$q_$_state_machine__17178__auto____1 = (function (state_40520){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_40520);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e40543){var ex__17181__auto__ = e40543;
var statearr_40544_40560 = state_40520;
(statearr_40544_40560[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_40520[(4)]))){
var statearr_40545_40561 = state_40520;
(statearr_40545_40561[(1)] = cljs.core.first((state_40520[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40562 = state_40520;
state_40520 = G__40562;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__17178__auto__ = function(state_40520){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__17178__auto____1.call(this,state_40520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__17178__auto____0;
fluree$db$query$analytical$q_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__17178__auto____1;
return fluree$db$query$analytical$q_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_40546 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_40546[(6)] = c__17304__auto__);

return statearr_40546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
