// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_34446){
var state_val_34447 = (state_34446[(1)]);
if((state_val_34447 === (1))){
var state_34446__$1 = state_34446;
var statearr_34448_34462 = state_34446__$1;
(statearr_34448_34462[(2)] = null);

(statearr_34448_34462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34447 === (2))){
var _ = (function (){var statearr_34449 = state_34446;
(statearr_34449[(4)] = cljs.core.cons((5),(state_34446[(4)])));

return statearr_34449;
})();
var inst_34437 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_34446__$1 = state_34446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34446__$1,(6),inst_34437);
} else {
if((state_val_34447 === (3))){
var inst_34444 = (state_34446[(2)]);
var state_34446__$1 = state_34446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34446__$1,inst_34444);
} else {
if((state_val_34447 === (4))){
var inst_34431 = (state_34446[(2)]);
var state_34446__$1 = state_34446;
var statearr_34451_34463 = state_34446__$1;
(statearr_34451_34463[(2)] = inst_34431);

(statearr_34451_34463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34447 === (5))){
var _ = (function (){var statearr_34452 = state_34446;
(statearr_34452[(4)] = cljs.core.rest((state_34446[(4)])));

return statearr_34452;
})();
var state_34446__$1 = state_34446;
var ex34450 = (state_34446__$1[(2)]);
var statearr_34453_34464 = state_34446__$1;
(statearr_34453_34464[(5)] = ex34450);


if((ex34450 instanceof Error)){
var statearr_34454_34465 = state_34446__$1;
(statearr_34454_34465[(1)] = (4));

(statearr_34454_34465[(5)] = null);

} else {
throw ex34450;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34447 === (6))){
var inst_34439 = (state_34446[(2)]);
var inst_34440 = fluree.db.util.async.throw_err(inst_34439);
var inst_34441 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34440);
var _ = (function (){var statearr_34455 = state_34446;
(statearr_34455[(4)] = cljs.core.rest((state_34446[(4)])));

return statearr_34455;
})();
var state_34446__$1 = state_34446;
var statearr_34456_34466 = state_34446__$1;
(statearr_34456_34466[(2)] = inst_34441);

(statearr_34456_34466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____0 = (function (){
var statearr_34457 = [null,null,null,null,null,null,null];
(statearr_34457[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__);

(statearr_34457[(1)] = (1));

return statearr_34457;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____1 = (function (state_34446){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_34446);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e34458){var ex__17181__auto__ = e34458;
var statearr_34459_34467 = state_34446;
(statearr_34459_34467[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_34446[(4)]))){
var statearr_34460_34468 = state_34446;
(statearr_34460_34468[(1)] = cljs.core.first((state_34446[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34469 = state_34446;
state_34446 = G__34469;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__ = function(state_34446){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____1.call(this,state_34446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_34461 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_34461[(6)] = c__17304__auto__);

return statearr_34461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_34501){
var state_val_34502 = (state_34501[(1)]);
if((state_val_34502 === (7))){
var inst_34485 = (state_34501[(7)]);
var inst_34487 = cljs.core.empty_QMARK_(inst_34485);
var inst_34488 = (!(inst_34487));
var state_34501__$1 = state_34501;
var statearr_34503_34527 = state_34501__$1;
(statearr_34503_34527[(2)] = inst_34488);

(statearr_34503_34527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (1))){
var state_34501__$1 = state_34501;
var statearr_34504_34528 = state_34501__$1;
(statearr_34504_34528[(2)] = null);

(statearr_34504_34528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (4))){
var inst_34471 = (state_34501[(2)]);
var state_34501__$1 = state_34501;
var statearr_34505_34529 = state_34501__$1;
(statearr_34505_34529[(2)] = inst_34471);

(statearr_34505_34529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (6))){
var inst_34485 = (state_34501[(7)]);
var inst_34477 = (state_34501[(8)]);
var inst_34483 = (state_34501[(2)]);
var inst_34484 = fluree.db.util.async.throw_err(inst_34483);
var inst_34485__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34477,inst_34484);
var state_34501__$1 = (function (){var statearr_34506 = state_34501;
(statearr_34506[(7)] = inst_34485__$1);

return statearr_34506;
})();
if(cljs.core.truth_(inst_34485__$1)){
var statearr_34507_34530 = state_34501__$1;
(statearr_34507_34530[(1)] = (7));

} else {
var statearr_34508_34531 = state_34501__$1;
(statearr_34508_34531[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (3))){
var inst_34499 = (state_34501[(2)]);
var state_34501__$1 = state_34501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34501__$1,inst_34499);
} else {
if((state_val_34502 === (12))){
var inst_34496 = (state_34501[(2)]);
var _ = (function (){var statearr_34509 = state_34501;
(statearr_34509[(4)] = cljs.core.rest((state_34501[(4)])));

return statearr_34509;
})();
var state_34501__$1 = state_34501;
var statearr_34510_34532 = state_34501__$1;
(statearr_34510_34532[(2)] = inst_34496);

(statearr_34510_34532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (2))){
var _ = (function (){var statearr_34511 = state_34501;
(statearr_34511[(4)] = cljs.core.cons((5),(state_34501[(4)])));

return statearr_34511;
})();
var inst_34477 = (function (){return (function (p1__34470_SHARP_){
return p1__34470_SHARP_.o;
});
})();
var inst_34478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34479 = [pred_id];
var inst_34480 = (new cljs.core.PersistentVector(null,1,(5),inst_34478,inst_34479,null));
var inst_34481 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_34480);
var state_34501__$1 = (function (){var statearr_34512 = state_34501;
(statearr_34512[(8)] = inst_34477);

return statearr_34512;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34501__$1,(6),inst_34481);
} else {
if((state_val_34502 === (11))){
var state_34501__$1 = state_34501;
var statearr_34514_34533 = state_34501__$1;
(statearr_34514_34533[(2)] = true);

(statearr_34514_34533[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (9))){
var inst_34491 = (state_34501[(2)]);
var state_34501__$1 = state_34501;
if(cljs.core.truth_(inst_34491)){
var statearr_34515_34534 = state_34501__$1;
(statearr_34515_34534[(1)] = (10));

} else {
var statearr_34516_34535 = state_34501__$1;
(statearr_34516_34535[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (5))){
var _ = (function (){var statearr_34517 = state_34501;
(statearr_34517[(4)] = cljs.core.rest((state_34501[(4)])));

return statearr_34517;
})();
var state_34501__$1 = state_34501;
var ex34513 = (state_34501__$1[(2)]);
var statearr_34518_34536 = state_34501__$1;
(statearr_34518_34536[(5)] = ex34513);


if((ex34513 instanceof Error)){
var statearr_34519_34537 = state_34501__$1;
(statearr_34519_34537[(1)] = (4));

(statearr_34519_34537[(5)] = null);

} else {
throw ex34513;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (10))){
var inst_34485 = (state_34501[(7)]);
var inst_34493 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_34485);
var state_34501__$1 = state_34501;
var statearr_34520_34538 = state_34501__$1;
(statearr_34520_34538[(2)] = inst_34493);

(statearr_34520_34538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34502 === (8))){
var inst_34485 = (state_34501[(7)]);
var state_34501__$1 = state_34501;
var statearr_34521_34539 = state_34501__$1;
(statearr_34521_34539[(2)] = inst_34485);

(statearr_34521_34539[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_34522 = [null,null,null,null,null,null,null,null,null];
(statearr_34522[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__);

(statearr_34522[(1)] = (1));

return statearr_34522;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____1 = (function (state_34501){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_34501);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e34523){var ex__17181__auto__ = e34523;
var statearr_34524_34540 = state_34501;
(statearr_34524_34540[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_34501[(4)]))){
var statearr_34525_34541 = state_34501;
(statearr_34525_34541[(1)] = cljs.core.first((state_34501[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34542 = state_34501;
state_34501 = G__34542;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__ = function(state_34501){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____1.call(this,state_34501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_34526 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_34526[(6)] = c__17304__auto__);

return statearr_34526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_34623){
var state_val_34624 = (state_34623[(1)]);
if((state_val_34624 === (7))){
var state_34623__$1 = state_34623;
var statearr_34625_34663 = state_34623__$1;
(statearr_34625_34663[(2)] = flakes);

(statearr_34625_34663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (20))){
var inst_34580 = (state_34623[(7)]);
var inst_34613 = (state_34623[(2)]);
var inst_34572 = inst_34580;
var inst_34573 = inst_34613;
var state_34623__$1 = (function (){var statearr_34626 = state_34623;
(statearr_34626[(8)] = inst_34572);

(statearr_34626[(9)] = inst_34573);

return statearr_34626;
})();
var statearr_34627_34664 = state_34623__$1;
(statearr_34627_34664[(2)] = null);

(statearr_34627_34664[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (1))){
var state_34623__$1 = state_34623;
var statearr_34628_34665 = state_34623__$1;
(statearr_34628_34665[(2)] = null);

(statearr_34628_34665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (4))){
var inst_34545 = (state_34623[(2)]);
var state_34623__$1 = state_34623;
var statearr_34629_34666 = state_34623__$1;
(statearr_34629_34666[(2)] = inst_34545);

(statearr_34629_34666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (15))){
var inst_34579 = (state_34623[(10)]);
var inst_34597 = inst_34579.o;
var state_34623__$1 = state_34623;
var statearr_34630_34667 = state_34623__$1;
(statearr_34630_34667[(2)] = inst_34597);

(statearr_34630_34667[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (13))){
var inst_34616 = (state_34623[(2)]);
var state_34623__$1 = state_34623;
var statearr_34631_34668 = state_34623__$1;
(statearr_34631_34668[(2)] = inst_34616);

(statearr_34631_34668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (6))){
var inst_34552 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_34623__$1 = state_34623;
var statearr_34632_34669 = state_34623__$1;
(statearr_34632_34669[(2)] = inst_34552);

(statearr_34632_34669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (17))){
var inst_34594 = (state_34623[(2)]);
var inst_34595 = fluree.db.util.async.throw_err(inst_34594);
var state_34623__$1 = state_34623;
var statearr_34633_34670 = state_34623__$1;
(statearr_34633_34670[(2)] = inst_34595);

(statearr_34633_34670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (3))){
var inst_34621 = (state_34623[(2)]);
var state_34623__$1 = state_34623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34623__$1,inst_34621);
} else {
if((state_val_34624 === (12))){
var inst_34579 = (state_34623[(10)]);
var inst_34586 = (state_34623[(11)]);
var inst_34584 = inst_34579.p;
var inst_34585 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_34584);
var inst_34586__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_34585);
var inst_34587 = inst_34579.op;
var inst_34588 = inst_34587 === false;
var inst_34589 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_34586__$1);
var state_34623__$1 = (function (){var statearr_34634 = state_34623;
(statearr_34634[(12)] = inst_34588);

(statearr_34634[(11)] = inst_34586__$1);

return statearr_34634;
})();
if(inst_34589){
var statearr_34635_34671 = state_34623__$1;
(statearr_34635_34671[(1)] = (14));

} else {
var statearr_34636_34672 = state_34623__$1;
(statearr_34636_34672[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (2))){
var _ = (function (){var statearr_34637 = state_34623;
(statearr_34637[(4)] = cljs.core.cons((5),(state_34623[(4)])));

return statearr_34637;
})();
var state_34623__$1 = state_34623;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_34638_34673 = state_34623__$1;
(statearr_34638_34673[(1)] = (6));

} else {
var statearr_34639_34674 = state_34623__$1;
(statearr_34639_34674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (19))){
var inst_34579 = (state_34623[(10)]);
var inst_34599 = (state_34623[(13)]);
var inst_34586 = (state_34623[(11)]);
var inst_34573 = (state_34623[(9)]);
var inst_34607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34608 = inst_34579.s;
var inst_34609 = [inst_34608,inst_34586,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_34610 = (new cljs.core.PersistentVector(null,3,(5),inst_34607,inst_34609,null));
var inst_34611 = cljs.core.assoc_in(inst_34573,inst_34610,inst_34599);
var state_34623__$1 = state_34623;
var statearr_34640_34675 = state_34623__$1;
(statearr_34640_34675[(2)] = inst_34611);

(statearr_34640_34675[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (11))){
var inst_34573 = (state_34623[(9)]);
var state_34623__$1 = state_34623;
var statearr_34642_34676 = state_34623__$1;
(statearr_34642_34676[(2)] = inst_34573);

(statearr_34642_34676[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (9))){
var inst_34579 = (state_34623[(10)]);
var inst_34572 = (state_34623[(8)]);
var inst_34578 = cljs.core.seq(inst_34572);
var inst_34579__$1 = cljs.core.first(inst_34578);
var inst_34580 = cljs.core.next(inst_34578);
var inst_34581 = cljs.core.not(inst_34579__$1);
var state_34623__$1 = (function (){var statearr_34643 = state_34623;
(statearr_34643[(10)] = inst_34579__$1);

(statearr_34643[(7)] = inst_34580);

return statearr_34643;
})();
if(inst_34581){
var statearr_34644_34677 = state_34623__$1;
(statearr_34644_34677[(1)] = (11));

} else {
var statearr_34645_34678 = state_34623__$1;
(statearr_34645_34678[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (5))){
var _ = (function (){var statearr_34646 = state_34623;
(statearr_34646[(4)] = cljs.core.rest((state_34623[(4)])));

return statearr_34646;
})();
var state_34623__$1 = state_34623;
var ex34641 = (state_34623__$1[(2)]);
var statearr_34647_34679 = state_34623__$1;
(statearr_34647_34679[(5)] = ex34641);


if((ex34641 instanceof Error)){
var statearr_34648_34680 = state_34623__$1;
(statearr_34648_34680[(1)] = (4));

(statearr_34648_34680[(5)] = null);

} else {
throw ex34641;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (14))){
var inst_34579 = (state_34623[(10)]);
var inst_34591 = inst_34579.o;
var inst_34592 = fluree.db.query.schema.convert_type_to_kw(inst_34591,db);
var state_34623__$1 = state_34623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34623__$1,(17),inst_34592);
} else {
if((state_val_34624 === (16))){
var inst_34588 = (state_34623[(12)]);
var inst_34599 = (state_34623[(2)]);
var state_34623__$1 = (function (){var statearr_34649 = state_34623;
(statearr_34649[(13)] = inst_34599);

return statearr_34649;
})();
if(cljs.core.truth_(inst_34588)){
var statearr_34650_34681 = state_34623__$1;
(statearr_34650_34681[(1)] = (18));

} else {
var statearr_34651_34682 = state_34623__$1;
(statearr_34651_34682[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (10))){
var inst_34618 = (state_34623[(2)]);
var _ = (function (){var statearr_34652 = state_34623;
(statearr_34652[(4)] = cljs.core.rest((state_34623[(4)])));

return statearr_34652;
})();
var state_34623__$1 = state_34623;
var statearr_34653_34683 = state_34623__$1;
(statearr_34653_34683[(2)] = inst_34618);

(statearr_34653_34683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (18))){
var inst_34579 = (state_34623[(10)]);
var inst_34599 = (state_34623[(13)]);
var inst_34586 = (state_34623[(11)]);
var inst_34573 = (state_34623[(9)]);
var inst_34601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34602 = inst_34579.s;
var inst_34603 = [inst_34602,inst_34586,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_34604 = (new cljs.core.PersistentVector(null,3,(5),inst_34601,inst_34603,null));
var inst_34605 = cljs.core.assoc_in(inst_34573,inst_34604,inst_34599);
var state_34623__$1 = state_34623;
var statearr_34654_34684 = state_34623__$1;
(statearr_34654_34684[(2)] = inst_34605);

(statearr_34654_34684[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34624 === (8))){
var inst_34555 = (state_34623[(2)]);
var inst_34556 = cljs.core.PersistentHashSet.EMPTY;
var inst_34557 = cljs.core.vals(tempids);
var inst_34558 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34556,inst_34557);
var inst_34559 = (function (){var pred_flakes = inst_34555;
var is_new_QMARK_ = inst_34558;
return (function (p1__34544_SHARP_,p2__34543_SHARP_){
var f = p2__34543_SHARP_;
return cljs.core.assoc_in(p1__34544_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__34655 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34655) : is_new_QMARK_.call(null,G__34655));
})()));
});
})();
var inst_34560 = cljs.core.PersistentHashMap.EMPTY;
var inst_34561 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34559,inst_34560,inst_34555);
var inst_34569 = cljs.core.seq(inst_34555);
var inst_34570 = cljs.core.first(inst_34569);
var inst_34571 = cljs.core.next(inst_34569);
var inst_34572 = inst_34555;
var inst_34573 = inst_34561;
var state_34623__$1 = (function (){var statearr_34656 = state_34623;
(statearr_34656[(14)] = inst_34571);

(statearr_34656[(15)] = inst_34570);

(statearr_34656[(8)] = inst_34572);

(statearr_34656[(9)] = inst_34573);

return statearr_34656;
})();
var statearr_34657_34685 = state_34623__$1;
(statearr_34657_34685[(2)] = null);

(statearr_34657_34685[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____0 = (function (){
var statearr_34658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34658[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__);

(statearr_34658[(1)] = (1));

return statearr_34658;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____1 = (function (state_34623){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_34623);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e34659){var ex__17181__auto__ = e34659;
var statearr_34660_34686 = state_34623;
(statearr_34660_34686[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_34623[(4)]))){
var statearr_34661_34687 = state_34623;
(statearr_34661_34687[(1)] = cljs.core.first((state_34623[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34688 = state_34623;
state_34623 = G__34688;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__ = function(state_34623){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____1.call(this,state_34623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_34662 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_34662[(6)] = c__17304__auto__);

return statearr_34662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__34690 = arguments.length;
switch (G__34690) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__34693 = arguments.length;
switch (G__34693) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35005){
var state_val_35006 = (state_35005[(1)]);
if((state_val_35006 === (121))){
var inst_34960 = (state_35005[(7)]);
var state_35005__$1 = state_35005;
var statearr_35007_35200 = state_35005__$1;
(statearr_35007_35200[(2)] = inst_34960);

(statearr_35007_35200[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (65))){
var inst_34859 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34859)){
var statearr_35008_35201 = state_35005__$1;
(statearr_35008_35201[(1)] = (66));

} else {
var statearr_35009_35202 = state_35005__$1;
(statearr_35009_35202[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (70))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34869 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_34870 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_34869,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,3,inst_34869,null));
var inst_34871 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34870,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34870,null));
var inst_34872 = (inst_34871.cljs$core$IFn$_invoke$arity$1 ? inst_34871.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34871.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34872)){
var statearr_35010_35203 = state_35005__$1;
(statearr_35010_35203[(1)] = (72));

} else {
var statearr_35011_35204 = state_35005__$1;
(statearr_35011_35204[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (62))){
var inst_34849 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35012_35205 = state_35005__$1;
(statearr_35012_35205[(2)] = inst_34849);

(statearr_35012_35205[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (74))){
var inst_34955 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35013_35206 = state_35005__$1;
(statearr_35013_35206[(2)] = inst_34955);

(statearr_35013_35206[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (110))){
var inst_34982 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34982)){
var statearr_35014_35207 = state_35005__$1;
(statearr_35014_35207[(1)] = (117));

} else {
var statearr_35015_35208 = state_35005__$1;
(statearr_35015_35208[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (7))){
var inst_35000 = (state_35005[(2)]);
var _ = (function (){var statearr_35016 = state_35005;
(statearr_35016[(4)] = cljs.core.rest((state_35005[(4)])));

return statearr_35016;
})();
var state_35005__$1 = state_35005;
var statearr_35017_35209 = state_35005__$1;
(statearr_35017_35209[(2)] = inst_35000);

(statearr_35017_35209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (59))){
var inst_34853 = (state_35005[(10)]);
var inst_34733 = (state_35005[(11)]);
var inst_34852 = (state_35005[(2)]);
var inst_34853__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35018 = state_35005;
(statearr_35018[(12)] = inst_34852);

(statearr_35018[(10)] = inst_34853__$1);

return statearr_35018;
})();
if(cljs.core.truth_(inst_34853__$1)){
var statearr_35019_35210 = state_35005__$1;
(statearr_35019_35210[(1)] = (63));

} else {
var statearr_35020_35211 = state_35005__$1;
(statearr_35020_35211[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (86))){
var inst_34895 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35021_35212 = state_35005__$1;
(statearr_35021_35212[(2)] = inst_34895);

(statearr_35021_35212[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (20))){
var inst_34733 = (state_35005[(11)]);
var inst_34759 = (state_35005[(13)]);
var inst_34759__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35022 = state_35005;
(statearr_35022[(13)] = inst_34759__$1);

return statearr_35022;
})();
if(cljs.core.truth_(inst_34759__$1)){
var statearr_35023_35213 = state_35005__$1;
(statearr_35023_35213[(1)] = (23));

} else {
var statearr_35024_35214 = state_35005__$1;
(statearr_35024_35214[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (72))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34874 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35025_35215 = state_35005__$1;
(statearr_35025_35215[(2)] = inst_34874);

(statearr_35025_35215[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (58))){
var inst_34814 = (state_35005[(14)]);
var state_35005__$1 = state_35005;
var statearr_35026_35216 = state_35005__$1;
(statearr_35026_35216[(2)] = inst_34814);

(statearr_35026_35216[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (60))){
var inst_34721 = (state_35005[(15)]);
var inst_34732 = (state_35005[(16)]);
var inst_34840 = fluree.db.dbproto._p_prop(inst_34721,new cljs.core.Keyword(null,"name","name",1843675177),inst_34732);
var inst_34841 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34840)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_34842 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34843 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_34844 = cljs.core.PersistentHashMap.fromArrays(inst_34842,inst_34843);
var inst_34845 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34841,inst_34844);
var inst_34846 = (function(){throw inst_34845})();
var state_35005__$1 = state_35005;
var statearr_35027_35217 = state_35005__$1;
(statearr_35027_35217[(2)] = inst_34846);

(statearr_35027_35217[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (27))){
var inst_34762 = (state_35005[(17)]);
var state_35005__$1 = state_35005;
var statearr_35028_35218 = state_35005__$1;
(statearr_35028_35218[(2)] = inst_34762);

(statearr_35028_35218[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (1))){
var state_35005__$1 = state_35005;
var statearr_35029_35219 = state_35005__$1;
(statearr_35029_35219[(2)] = null);

(statearr_35029_35219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (69))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35030_35220 = state_35005__$1;
(statearr_35030_35220[(2)] = inst_34852);

(statearr_35030_35220[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (101))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34933 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35031_35221 = state_35005__$1;
(statearr_35031_35221[(2)] = inst_34933);

(statearr_35031_35221[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (24))){
var inst_34759 = (state_35005[(13)]);
var state_35005__$1 = state_35005;
var statearr_35032_35222 = state_35005__$1;
(statearr_35032_35222[(2)] = inst_34759);

(statearr_35032_35222[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (102))){
var inst_34935 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35033_35223 = state_35005__$1;
(statearr_35033_35223[(2)] = inst_34935);

(statearr_35033_35223[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (55))){
var inst_34831 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35034_35224 = state_35005__$1;
(statearr_35034_35224[(2)] = inst_34831);

(statearr_35034_35224[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (85))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34893 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35035_35225 = state_35005__$1;
(statearr_35035_35225[(2)] = inst_34893);

(statearr_35035_35225[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (39))){
var inst_34796 = (state_35005[(18)]);
var state_35005__$1 = state_35005;
var statearr_35036_35226 = state_35005__$1;
(statearr_35036_35226[(2)] = inst_34796);

(statearr_35036_35226[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (88))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35037_35227 = state_35005__$1;
(statearr_35037_35227[(2)] = inst_34852);

(statearr_35037_35227[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (46))){
var inst_34733 = (state_35005[(11)]);
var inst_34815 = (state_35005[(19)]);
var inst_34814 = (state_35005[(2)]);
var inst_34815__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35038 = state_35005;
(statearr_35038[(14)] = inst_34814);

(statearr_35038[(19)] = inst_34815__$1);

return statearr_35038;
})();
if(cljs.core.truth_(inst_34815__$1)){
var statearr_35039_35228 = state_35005__$1;
(statearr_35039_35228[(1)] = (47));

} else {
var statearr_35040_35229 = state_35005__$1;
(statearr_35040_35229[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (4))){
var inst_34694 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35041_35230 = state_35005__$1;
(statearr_35041_35230[(2)] = inst_34694);

(statearr_35041_35230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (77))){
var inst_34953 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35042_35231 = state_35005__$1;
(statearr_35042_35231[(2)] = inst_34953);

(statearr_35042_35231[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (106))){
var inst_34945 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35043_35232 = state_35005__$1;
(statearr_35043_35232[(2)] = inst_34945);

(statearr_35043_35232[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (119))){
var inst_34731 = (state_35005[(20)]);
var inst_34995 = (state_35005[(2)]);
var inst_34720 = inst_34731;
var inst_34721 = inst_34995;
var state_35005__$1 = (function (){var statearr_35044 = state_35005;
(statearr_35044[(15)] = inst_34721);

(statearr_35044[(21)] = inst_34720);

return statearr_35044;
})();
var statearr_35045_35233 = state_35005__$1;
(statearr_35045_35233[(2)] = null);

(statearr_35045_35233[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (95))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34917 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_34918 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_34917,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,5,inst_34917,null));
var inst_34919 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34918,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34918,null));
var inst_34920 = (inst_34919.cljs$core$IFn$_invoke$arity$1 ? inst_34919.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34919.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34920)){
var statearr_35046_35234 = state_35005__$1;
(statearr_35046_35234[(1)] = (96));

} else {
var statearr_35047_35235 = state_35005__$1;
(statearr_35047_35235[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (54))){
var inst_34822 = (state_35005[(22)]);
var state_35005__$1 = state_35005;
var statearr_35048_35236 = state_35005__$1;
(statearr_35048_35236[(2)] = inst_34822);

(statearr_35048_35236[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (92))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35049_35237 = state_35005__$1;
(statearr_35049_35237[(2)] = inst_34852);

(statearr_35049_35237[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (104))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35050_35238 = state_35005__$1;
(statearr_35050_35238[(2)] = inst_34852);

(statearr_35050_35238[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (15))){
var inst_34741 = (state_35005[(23)]);
var state_35005__$1 = state_35005;
var statearr_35051_35239 = state_35005__$1;
(statearr_35051_35239[(2)] = inst_34741);

(statearr_35051_35239[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (48))){
var inst_34815 = (state_35005[(19)]);
var state_35005__$1 = state_35005;
var statearr_35052_35240 = state_35005__$1;
(statearr_35052_35240[(2)] = inst_34815);

(statearr_35052_35240[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (50))){
var inst_34822 = (state_35005[(22)]);
var inst_34733 = (state_35005[(11)]);
var inst_34820 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34821 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34820);
var inst_34822__$1 = inst_34821 === true;
var state_35005__$1 = (function (){var statearr_35053 = state_35005;
(statearr_35053[(22)] = inst_34822__$1);

return statearr_35053;
})();
if(cljs.core.truth_(inst_34822__$1)){
var statearr_35054_35241 = state_35005__$1;
(statearr_35054_35241[(1)] = (53));

} else {
var statearr_35055_35242 = state_35005__$1;
(statearr_35055_35242[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (116))){
var inst_34976 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35056_35243 = state_35005__$1;
(statearr_35056_35243[(2)] = inst_34976);

(statearr_35056_35243[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (75))){
var inst_34865 = (state_35005[(8)]);
var state_35005__$1 = state_35005;
var G__35057_35244 = inst_34865;
var G__35057_35245__$1 = (((G__35057_35244 instanceof cljs.core.Keyword))?G__35057_35244.fqn:null);
switch (G__35057_35245__$1) {
case "long":
var statearr_35058_35247 = state_35005__$1;
(statearr_35058_35247[(1)] = (79));


break;
case "bigint":
var statearr_35059_35248 = state_35005__$1;
(statearr_35059_35248[(1)] = (83));


break;
case "double":
var statearr_35060_35249 = state_35005__$1;
(statearr_35060_35249[(1)] = (87));


break;
case "float":
var statearr_35061_35250 = state_35005__$1;
(statearr_35061_35250[(1)] = (91));


break;
case "bigdec":
var statearr_35062_35251 = state_35005__$1;
(statearr_35062_35251[(1)] = (95));


break;
case "string":
var statearr_35063_35252 = state_35005__$1;
(statearr_35063_35252[(1)] = (99));


break;
case "instant":
var statearr_35064_35253 = state_35005__$1;
(statearr_35064_35253[(1)] = (103));


break;
default:
var statearr_35065_35254 = state_35005__$1;
(statearr_35065_35254[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (99))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34927 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_34928 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_34927,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,5,inst_34927,null));
var inst_34929 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34928,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34928,null));
var inst_34930 = (inst_34929.cljs$core$IFn$_invoke$arity$1 ? inst_34929.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34929.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34930)){
var statearr_35066_35255 = state_35005__$1;
(statearr_35066_35255[(1)] = (100));

} else {
var statearr_35067_35256 = state_35005__$1;
(statearr_35067_35256[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (21))){
var inst_34757 = (state_35005[(24)]);
var state_35005__$1 = state_35005;
var statearr_35068_35257 = state_35005__$1;
(statearr_35068_35257[(2)] = inst_34757);

(statearr_35068_35257[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (31))){
var inst_34773 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35069_35258 = state_35005__$1;
(statearr_35069_35258[(2)] = inst_34773);

(statearr_35069_35258[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (113))){
var inst_34979 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35070_35259 = state_35005__$1;
(statearr_35070_35259[(2)] = inst_34979);

(statearr_35070_35259[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (32))){
var state_35005__$1 = state_35005;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35071_35260 = state_35005__$1;
(statearr_35071_35260[(1)] = (35));

} else {
var statearr_35072_35261 = state_35005__$1;
(statearr_35072_35261[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (40))){
var inst_34809 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34809)){
var statearr_35073_35262 = state_35005__$1;
(statearr_35073_35262[(1)] = (44));

} else {
var statearr_35074_35263 = state_35005__$1;
(statearr_35074_35263[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (91))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34907 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_34908 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_34907,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,3,inst_34907,null));
var inst_34909 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34908,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34908,null));
var inst_34910 = (inst_34909.cljs$core$IFn$_invoke$arity$1 ? inst_34909.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34909.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34910)){
var statearr_35075_35264 = state_35005__$1;
(statearr_35075_35264[(1)] = (92));

} else {
var statearr_35076_35265 = state_35005__$1;
(statearr_35076_35265[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (117))){
var state_35005__$1 = state_35005;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35077_35266 = state_35005__$1;
(statearr_35077_35266[(1)] = (120));

} else {
var statearr_35078_35267 = state_35005__$1;
(statearr_35078_35267[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (108))){
var inst_34964 = (state_35005[(25)]);
var inst_34733 = (state_35005[(11)]);
var inst_34964__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35079 = state_35005;
(statearr_35079[(25)] = inst_34964__$1);

return statearr_35079;
})();
if(cljs.core.truth_(inst_34964__$1)){
var statearr_35080_35268 = state_35005__$1;
(statearr_35080_35268[(1)] = (111));

} else {
var statearr_35081_35269 = state_35005__$1;
(statearr_35081_35269[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (56))){
var inst_34826 = (state_35005[(2)]);
var inst_34827 = fluree.db.util.async.throw_err(inst_34826);
var inst_34828 = cljs.core.not(inst_34827);
var state_35005__$1 = state_35005;
var statearr_35082_35270 = state_35005__$1;
(statearr_35082_35270[(2)] = inst_34828);

(statearr_35082_35270[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (33))){
var inst_34756 = (state_35005[(26)]);
var state_35005__$1 = state_35005;
var statearr_35083_35271 = state_35005__$1;
(statearr_35083_35271[(2)] = inst_34756);

(statearr_35083_35271[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (13))){
var inst_34751 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34751)){
var statearr_35084_35272 = state_35005__$1;
(statearr_35084_35272[(1)] = (17));

} else {
var statearr_35085_35273 = state_35005__$1;
(statearr_35085_35273[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (22))){
var inst_34782 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34782)){
var statearr_35086_35274 = state_35005__$1;
(statearr_35086_35274[(1)] = (32));

} else {
var statearr_35087_35275 = state_35005__$1;
(statearr_35087_35275[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (90))){
var inst_34905 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35088_35276 = state_35005__$1;
(statearr_35088_35276[(2)] = inst_34905);

(statearr_35088_35276[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (109))){
var inst_34962 = (state_35005[(27)]);
var state_35005__$1 = state_35005;
var statearr_35089_35277 = state_35005__$1;
(statearr_35089_35277[(2)] = inst_34962);

(statearr_35089_35277[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (36))){
var inst_34756 = (state_35005[(26)]);
var state_35005__$1 = state_35005;
var statearr_35090_35278 = state_35005__$1;
(statearr_35090_35278[(2)] = inst_34756);

(statearr_35090_35278[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (41))){
var inst_34733 = (state_35005[(11)]);
var inst_34801 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34802 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34801);
var inst_34803 = inst_34802 === true;
var state_35005__$1 = state_35005;
var statearr_35091_35279 = state_35005__$1;
(statearr_35091_35279[(2)] = inst_34803);

(statearr_35091_35279[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (118))){
var inst_34960 = (state_35005[(7)]);
var state_35005__$1 = state_35005;
var statearr_35092_35280 = state_35005__$1;
(statearr_35092_35280[(2)] = inst_34960);

(statearr_35092_35280[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (89))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34903 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35093_35281 = state_35005__$1;
(statearr_35093_35281[(2)] = inst_34903);

(statearr_35093_35281[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (100))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35094_35282 = state_35005__$1;
(statearr_35094_35282[(2)] = inst_34852);

(statearr_35094_35282[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (122))){
var inst_34992 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35095_35283 = state_35005__$1;
(statearr_35095_35283[(2)] = inst_34992);

(statearr_35095_35283[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (43))){
var inst_34806 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35096_35284 = state_35005__$1;
(statearr_35096_35284[(2)] = inst_34806);

(statearr_35096_35284[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (61))){
var inst_34814 = (state_35005[(14)]);
var state_35005__$1 = state_35005;
var statearr_35097_35285 = state_35005__$1;
(statearr_35097_35285[(2)] = inst_34814);

(statearr_35097_35285[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (29))){
var inst_34733 = (state_35005[(11)]);
var inst_34768 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34769 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34768);
var inst_34770 = inst_34769 === true;
var state_35005__$1 = state_35005;
var statearr_35098_35286 = state_35005__$1;
(statearr_35098_35286[(2)] = inst_34770);

(statearr_35098_35286[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (44))){
var inst_34795 = (state_35005[(28)]);
var inst_34811 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_34795,"a component","a non-component",throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35099_35287 = state_35005__$1;
(statearr_35099_35287[(2)] = inst_34811);

(statearr_35099_35287[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (93))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34913 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35100_35288 = state_35005__$1;
(statearr_35100_35288[(2)] = inst_34913);

(statearr_35100_35288[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (6))){
var inst_34732 = (state_35005[(16)]);
var inst_34720 = (state_35005[(21)]);
var inst_34729 = cljs.core.seq(inst_34720);
var inst_34730 = cljs.core.first(inst_34729);
var inst_34731 = cljs.core.next(inst_34729);
var inst_34732__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34730,(0),null);
var inst_34733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34730,(1),null);
var inst_34734 = cljs.core.not(inst_34732__$1);
var state_35005__$1 = (function (){var statearr_35101 = state_35005;
(statearr_35101[(20)] = inst_34731);

(statearr_35101[(16)] = inst_34732__$1);

(statearr_35101[(11)] = inst_34733);

return statearr_35101;
})();
if(inst_34734){
var statearr_35102_35289 = state_35005__$1;
(statearr_35102_35289[(1)] = (8));

} else {
var statearr_35103_35290 = state_35005__$1;
(statearr_35103_35290[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (111))){
var inst_34968 = (state_35005[(29)]);
var inst_34733 = (state_35005[(11)]);
var inst_34966 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34967 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34966);
var inst_34968__$1 = inst_34967 === true;
var state_35005__$1 = (function (){var statearr_35104 = state_35005;
(statearr_35104[(29)] = inst_34968__$1);

return statearr_35104;
})();
if(cljs.core.truth_(inst_34968__$1)){
var statearr_35105_35291 = state_35005__$1;
(statearr_35105_35291[(1)] = (114));

} else {
var statearr_35106_35292 = state_35005__$1;
(statearr_35106_35292[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (28))){
var inst_34776 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35107_35293 = state_35005__$1;
(statearr_35107_35293[(2)] = inst_34776);

(statearr_35107_35293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (64))){
var inst_34853 = (state_35005[(10)]);
var state_35005__$1 = state_35005;
var statearr_35108_35294 = state_35005__$1;
(statearr_35108_35294[(2)] = inst_34853);

(statearr_35108_35294[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (103))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34937 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_34938 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_34937,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,2,inst_34937,null));
var inst_34939 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34938,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34938,null));
var inst_34940 = (inst_34939.cljs$core$IFn$_invoke$arity$1 ? inst_34939.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34939.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34940)){
var statearr_35109_35295 = state_35005__$1;
(statearr_35109_35295[(1)] = (104));

} else {
var statearr_35110_35296 = state_35005__$1;
(statearr_35110_35296[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (51))){
var inst_34818 = (state_35005[(30)]);
var state_35005__$1 = state_35005;
var statearr_35111_35297 = state_35005__$1;
(statearr_35111_35297[(2)] = inst_34818);

(statearr_35111_35297[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (25))){
var inst_34779 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35112_35298 = state_35005__$1;
(statearr_35112_35298[(2)] = inst_34779);

(statearr_35112_35298[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (34))){
var inst_34796 = (state_35005[(18)]);
var inst_34733 = (state_35005[(11)]);
var inst_34795 = (state_35005[(2)]);
var inst_34796__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35113 = state_35005;
(statearr_35113[(18)] = inst_34796__$1);

(statearr_35113[(28)] = inst_34795);

return statearr_35113;
})();
if(cljs.core.truth_(inst_34796__$1)){
var statearr_35114_35299 = state_35005__$1;
(statearr_35114_35299[(1)] = (38));

} else {
var statearr_35115_35300 = state_35005__$1;
(statearr_35115_35300[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (17))){
var inst_34721 = (state_35005[(15)]);
var inst_34753 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_34721,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35116_35301 = state_35005__$1;
(statearr_35116_35301[(2)] = inst_34753);

(statearr_35116_35301[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (3))){
var inst_35003 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35005__$1,inst_35003);
} else {
if((state_val_35006 === (12))){
var inst_34737 = (state_35005[(31)]);
var state_35005__$1 = state_35005;
var statearr_35117_35302 = state_35005__$1;
(statearr_35117_35302[(2)] = inst_34737);

(statearr_35117_35302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (2))){
var _ = (function (){var statearr_35118 = state_35005;
(statearr_35118[(4)] = cljs.core.cons((5),(state_35005[(4)])));

return statearr_35118;
})();
var inst_34713 = pred_changes;
var inst_34714 = cljs.core.seq(inst_34713);
var inst_34715 = cljs.core.first(inst_34714);
var inst_34716 = cljs.core.next(inst_34714);
var inst_34717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34715,(0),null);
var inst_34718 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34715,(1),null);
var inst_34719 = db;
var inst_34720 = inst_34713;
var inst_34721 = inst_34719;
var state_35005__$1 = (function (){var statearr_35119 = state_35005;
(statearr_35119[(15)] = inst_34721);

(statearr_35119[(32)] = inst_34718);

(statearr_35119[(33)] = inst_34716);

(statearr_35119[(34)] = inst_34717);

(statearr_35119[(21)] = inst_34720);

return statearr_35119;
})();
var statearr_35120_35303 = state_35005__$1;
(statearr_35120_35303[(2)] = null);

(statearr_35120_35303[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (66))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34733 = (state_35005[(11)]);
var inst_34862 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34863 = cljs.core.__destructure_map(inst_34862);
var inst_34864__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34863,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_34865__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34863,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_34866 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34865__$1,inst_34864__$1);
var state_35005__$1 = (function (){var statearr_35121 = state_35005;
(statearr_35121[(8)] = inst_34865__$1);

(statearr_35121[(9)] = inst_34864__$1);

return statearr_35121;
})();
if(inst_34866){
var statearr_35122_35304 = state_35005__$1;
(statearr_35122_35304[(1)] = (69));

} else {
var statearr_35123_35305 = state_35005__$1;
(statearr_35123_35305[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (107))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34947 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35124_35306 = state_35005__$1;
(statearr_35124_35306[(2)] = inst_34947);

(statearr_35124_35306[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (23))){
var inst_34733 = (state_35005[(11)]);
var inst_34762 = (state_35005[(17)]);
var inst_34761 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34762__$1 = inst_34761 === true;
var state_35005__$1 = (function (){var statearr_35125 = state_35005;
(statearr_35125[(17)] = inst_34762__$1);

return statearr_35125;
})();
if(cljs.core.truth_(inst_34762__$1)){
var statearr_35126_35307 = state_35005__$1;
(statearr_35126_35307[(1)] = (26));

} else {
var statearr_35127_35308 = state_35005__$1;
(statearr_35127_35308[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (47))){
var inst_34818 = (state_35005[(30)]);
var inst_34733 = (state_35005[(11)]);
var inst_34817 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34818__$1 = cljs.core.not(inst_34817);
var state_35005__$1 = (function (){var statearr_35128 = state_35005;
(statearr_35128[(30)] = inst_34818__$1);

return statearr_35128;
})();
if(inst_34818__$1){
var statearr_35129_35309 = state_35005__$1;
(statearr_35129_35309[(1)] = (50));

} else {
var statearr_35130_35310 = state_35005__$1;
(statearr_35130_35310[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (35))){
var inst_34785 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34786 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_34787 = cljs.core.PersistentHashMap.fromArrays(inst_34785,inst_34786);
var inst_34788 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_34787);
var inst_34789 = (function(){throw inst_34788})();
var state_35005__$1 = state_35005;
var statearr_35131_35311 = state_35005__$1;
(statearr_35131_35311[(2)] = inst_34789);

(statearr_35131_35311[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (82))){
var inst_34885 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35132_35312 = state_35005__$1;
(statearr_35132_35312[(2)] = inst_34885);

(statearr_35132_35312[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (76))){
var state_35005__$1 = state_35005;
var statearr_35133_35313 = state_35005__$1;
(statearr_35133_35313[(2)] = null);

(statearr_35133_35313[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (97))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34923 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35134_35314 = state_35005__$1;
(statearr_35134_35314[(2)] = inst_34923);

(statearr_35134_35314[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (19))){
var inst_34757 = (state_35005[(24)]);
var inst_34733 = (state_35005[(11)]);
var inst_34756 = (state_35005[(2)]);
var inst_34757__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35135 = state_35005;
(statearr_35135[(24)] = inst_34757__$1);

(statearr_35135[(26)] = inst_34756);

return statearr_35135;
})();
if(cljs.core.truth_(inst_34757__$1)){
var statearr_35136_35315 = state_35005__$1;
(statearr_35136_35315[(1)] = (20));

} else {
var statearr_35137_35316 = state_35005__$1;
(statearr_35137_35316[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (57))){
var state_35005__$1 = state_35005;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35138_35317 = state_35005__$1;
(statearr_35138_35317[(1)] = (60));

} else {
var statearr_35139_35318 = state_35005__$1;
(statearr_35139_35318[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (68))){
var inst_34962 = (state_35005[(27)]);
var inst_34733 = (state_35005[(11)]);
var inst_34960 = (state_35005[(2)]);
var inst_34961 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34962__$1 = inst_34961 === true;
var state_35005__$1 = (function (){var statearr_35140 = state_35005;
(statearr_35140[(27)] = inst_34962__$1);

(statearr_35140[(7)] = inst_34960);

return statearr_35140;
})();
if(cljs.core.truth_(inst_34962__$1)){
var statearr_35141_35319 = state_35005__$1;
(statearr_35141_35319[(1)] = (108));

} else {
var statearr_35142_35320 = state_35005__$1;
(statearr_35142_35320[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (11))){
var inst_34741 = (state_35005[(23)]);
var inst_34733 = (state_35005[(11)]);
var inst_34739 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34740 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34739);
var inst_34741__$1 = inst_34740 === false;
var state_35005__$1 = (function (){var statearr_35143 = state_35005;
(statearr_35143[(23)] = inst_34741__$1);

return statearr_35143;
})();
if(cljs.core.truth_(inst_34741__$1)){
var statearr_35144_35321 = state_35005__$1;
(statearr_35144_35321[(1)] = (14));

} else {
var statearr_35145_35322 = state_35005__$1;
(statearr_35145_35322[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (115))){
var inst_34968 = (state_35005[(29)]);
var state_35005__$1 = state_35005;
var statearr_35147_35323 = state_35005__$1;
(statearr_35147_35323[(2)] = inst_34968);

(statearr_35147_35323[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (9))){
var inst_34737 = (state_35005[(31)]);
var inst_34733 = (state_35005[(11)]);
var inst_34737__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_34733);
var state_35005__$1 = (function (){var statearr_35148 = state_35005;
(statearr_35148[(31)] = inst_34737__$1);

return statearr_35148;
})();
if(cljs.core.truth_(inst_34737__$1)){
var statearr_35149_35324 = state_35005__$1;
(statearr_35149_35324[(1)] = (11));

} else {
var statearr_35150_35325 = state_35005__$1;
(statearr_35150_35325[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (5))){
var _ = (function (){var statearr_35151 = state_35005;
(statearr_35151[(4)] = cljs.core.rest((state_35005[(4)])));

return statearr_35151;
})();
var state_35005__$1 = state_35005;
var ex35146 = (state_35005__$1[(2)]);
var statearr_35152_35326 = state_35005__$1;
(statearr_35152_35326[(5)] = ex35146);


if((ex35146 instanceof Error)){
var statearr_35153_35327 = state_35005__$1;
(statearr_35153_35327[(1)] = (4));

(statearr_35153_35327[(5)] = null);

} else {
throw ex35146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (112))){
var inst_34964 = (state_35005[(25)]);
var state_35005__$1 = state_35005;
var statearr_35154_35328 = state_35005__$1;
(statearr_35154_35328[(2)] = inst_34964);

(statearr_35154_35328[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (83))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34887 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_34888 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_34887,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,3,inst_34887,null));
var inst_34889 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34888,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34888,null));
var inst_34890 = (inst_34889.cljs$core$IFn$_invoke$arity$1 ? inst_34889.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34889.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34890)){
var statearr_35155_35329 = state_35005__$1;
(statearr_35155_35329[(1)] = (84));

} else {
var statearr_35156_35330 = state_35005__$1;
(statearr_35156_35330[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (14))){
var inst_34733 = (state_35005[(11)]);
var inst_34743 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34744 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_34743);
var inst_34745 = inst_34744 === true;
var state_35005__$1 = state_35005;
var statearr_35157_35331 = state_35005__$1;
(statearr_35157_35331[(2)] = inst_34745);

(statearr_35157_35331[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (45))){
var inst_34795 = (state_35005[(28)]);
var state_35005__$1 = state_35005;
var statearr_35158_35332 = state_35005__$1;
(statearr_35158_35332[(2)] = inst_34795);

(statearr_35158_35332[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (53))){
var inst_34721 = (state_35005[(15)]);
var inst_34732 = (state_35005[(16)]);
var inst_34824 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_34721,inst_34732);
var state_35005__$1 = state_35005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35005__$1,(56),inst_34824);
} else {
if((state_val_35006 === (78))){
var inst_34950 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35159_35333 = state_35005__$1;
(statearr_35159_35333[(2)] = inst_34950);

(statearr_35159_35333[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (26))){
var inst_34766 = (state_35005[(35)]);
var inst_34733 = (state_35005[(11)]);
var inst_34764 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34765 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34764);
var inst_34766__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_34765);
var state_35005__$1 = (function (){var statearr_35160 = state_35005;
(statearr_35160[(35)] = inst_34766__$1);

return statearr_35160;
})();
if(inst_34766__$1){
var statearr_35161_35334 = state_35005__$1;
(statearr_35161_35334[(1)] = (29));

} else {
var statearr_35162_35335 = state_35005__$1;
(statearr_35162_35335[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (16))){
var inst_34748 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35163_35336 = state_35005__$1;
(statearr_35163_35336[(2)] = inst_34748);

(statearr_35163_35336[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (81))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34883 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35164_35337 = state_35005__$1;
(statearr_35164_35337[(2)] = inst_34883);

(statearr_35164_35337[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (120))){
var inst_34985 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34986 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_34987 = cljs.core.PersistentHashMap.fromArrays(inst_34985,inst_34986);
var inst_34988 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_34987);
var inst_34989 = (function(){throw inst_34988})();
var state_35005__$1 = state_35005;
var statearr_35165_35338 = state_35005__$1;
(statearr_35165_35338[(2)] = inst_34989);

(statearr_35165_35338[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (79))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34877 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_34878 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_34877,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,2,inst_34877,null));
var inst_34879 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34878,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34878,null));
var inst_34880 = (inst_34879.cljs$core$IFn$_invoke$arity$1 ? inst_34879.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34879.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34880)){
var statearr_35166_35339 = state_35005__$1;
(statearr_35166_35339[(1)] = (80));

} else {
var statearr_35167_35340 = state_35005__$1;
(statearr_35167_35340[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (38))){
var inst_34733 = (state_35005[(11)]);
var inst_34799 = (state_35005[(36)]);
var inst_34798 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34799__$1 = cljs.core.not(inst_34798);
var state_35005__$1 = (function (){var statearr_35168 = state_35005;
(statearr_35168[(36)] = inst_34799__$1);

return statearr_35168;
})();
if(inst_34799__$1){
var statearr_35169_35341 = state_35005__$1;
(statearr_35169_35341[(1)] = (41));

} else {
var statearr_35170_35342 = state_35005__$1;
(statearr_35170_35342[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (98))){
var inst_34925 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35171_35343 = state_35005__$1;
(statearr_35171_35343[(2)] = inst_34925);

(statearr_35171_35343[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (87))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34897 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_34898 = (inst_34865.cljs$core$IFn$_invoke$arity$5 ? inst_34865.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_34897,null) : inst_34865.call(null,cljs.core.PersistentArrayMap,null,3,inst_34897,null));
var inst_34899 = (inst_34865.cljs$core$IFn$_invoke$arity$4 ? inst_34865.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_34898,null) : inst_34865.call(null,cljs.core.PersistentHashSet,null,inst_34898,null));
var inst_34900 = (inst_34899.cljs$core$IFn$_invoke$arity$1 ? inst_34899.cljs$core$IFn$_invoke$arity$1(inst_34864) : inst_34899.call(null,inst_34864));
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34900)){
var statearr_35172_35344 = state_35005__$1;
(statearr_35172_35344[(1)] = (88));

} else {
var statearr_35173_35345 = state_35005__$1;
(statearr_35173_35345[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (30))){
var inst_34766 = (state_35005[(35)]);
var state_35005__$1 = state_35005;
var statearr_35174_35346 = state_35005__$1;
(statearr_35174_35346[(2)] = inst_34766);

(statearr_35174_35346[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (73))){
var state_35005__$1 = state_35005;
var statearr_35175_35347 = state_35005__$1;
(statearr_35175_35347[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (96))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35177_35348 = state_35005__$1;
(statearr_35177_35348[(2)] = inst_34852);

(statearr_35177_35348[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (10))){
var inst_34998 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35178_35349 = state_35005__$1;
(statearr_35178_35349[(2)] = inst_34998);

(statearr_35178_35349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (18))){
var inst_34721 = (state_35005[(15)]);
var state_35005__$1 = state_35005;
var statearr_35179_35350 = state_35005__$1;
(statearr_35179_35350[(2)] = inst_34721);

(statearr_35179_35350[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (105))){
var inst_34865 = (state_35005[(8)]);
var inst_34864 = (state_35005[(9)]);
var inst_34943 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_34864,inst_34865,throw_QMARK_);
var state_35005__$1 = state_35005;
var statearr_35180_35351 = state_35005__$1;
(statearr_35180_35351[(2)] = inst_34943);

(statearr_35180_35351[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (52))){
var inst_34834 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35181_35352 = state_35005__$1;
(statearr_35181_35352[(2)] = inst_34834);

(statearr_35181_35352[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (114))){
var inst_34733 = (state_35005[(11)]);
var inst_34970 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34971 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_34970);
var inst_34972 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_34971);
var inst_34973 = (!(inst_34972));
var state_35005__$1 = state_35005;
var statearr_35182_35353 = state_35005__$1;
(statearr_35182_35353[(2)] = inst_34973);

(statearr_35182_35353[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (67))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35183_35354 = state_35005__$1;
(statearr_35183_35354[(2)] = inst_34852);

(statearr_35183_35354[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (71))){
var inst_34957 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35184_35355 = state_35005__$1;
(statearr_35184_35355[(2)] = inst_34957);

(statearr_35184_35355[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (42))){
var inst_34799 = (state_35005[(36)]);
var state_35005__$1 = state_35005;
var statearr_35185_35356 = state_35005__$1;
(statearr_35185_35356[(2)] = inst_34799);

(statearr_35185_35356[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (80))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35186_35357 = state_35005__$1;
(statearr_35186_35357[(2)] = inst_34852);

(statearr_35186_35357[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (37))){
var inst_34792 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35187_35358 = state_35005__$1;
(statearr_35187_35358[(2)] = inst_34792);

(statearr_35187_35358[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (63))){
var inst_34733 = (state_35005[(11)]);
var inst_34855 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_34733);
var inst_34856 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_34855);
var state_35005__$1 = state_35005;
var statearr_35188_35359 = state_35005__$1;
(statearr_35188_35359[(2)] = inst_34856);

(statearr_35188_35359[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (94))){
var inst_34915 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
var statearr_35189_35360 = state_35005__$1;
(statearr_35189_35360[(2)] = inst_34915);

(statearr_35189_35360[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (8))){
var inst_34721 = (state_35005[(15)]);
var state_35005__$1 = state_35005;
var statearr_35190_35361 = state_35005__$1;
(statearr_35190_35361[(2)] = inst_34721);

(statearr_35190_35361[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (49))){
var inst_34837 = (state_35005[(2)]);
var state_35005__$1 = state_35005;
if(cljs.core.truth_(inst_34837)){
var statearr_35191_35362 = state_35005__$1;
(statearr_35191_35362[(1)] = (57));

} else {
var statearr_35192_35363 = state_35005__$1;
(statearr_35192_35363[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35006 === (84))){
var inst_34852 = (state_35005[(12)]);
var state_35005__$1 = state_35005;
var statearr_35193_35364 = state_35005__$1;
(statearr_35193_35364[(2)] = inst_34852);

(statearr_35193_35364[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__17178__auto__ = null;
var fluree$db$query$schema$state_machine__17178__auto____0 = (function (){
var statearr_35194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35194[(0)] = fluree$db$query$schema$state_machine__17178__auto__);

(statearr_35194[(1)] = (1));

return statearr_35194;
});
var fluree$db$query$schema$state_machine__17178__auto____1 = (function (state_35005){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35005);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35195){var ex__17181__auto__ = e35195;
var statearr_35196_35365 = state_35005;
(statearr_35196_35365[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35005[(4)]))){
var statearr_35197_35366 = state_35005;
(statearr_35197_35366[(1)] = cljs.core.first((state_35005[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35367 = state_35005;
state_35005 = G__35367;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__17178__auto__ = function(state_35005){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__17178__auto____1.call(this,state_35005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__17178__auto____0;
fluree$db$query$schema$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__17178__auto____1;
return fluree$db$query$schema$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35198 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35198[(6)] = c__17304__auto__);

return statearr_35198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__35369 = arguments.length;
switch (G__35369) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35393){
var state_val_35394 = (state_35393[(1)]);
if((state_val_35394 === (7))){
var state_35393__$1 = state_35393;
var statearr_35395_35415 = state_35393__$1;
(statearr_35395_35415[(2)] = db);

(statearr_35395_35415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (1))){
var state_35393__$1 = state_35393;
var statearr_35396_35416 = state_35393__$1;
(statearr_35396_35416[(2)] = null);

(statearr_35396_35416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (4))){
var inst_35370 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
var statearr_35397_35417 = state_35393__$1;
(statearr_35397_35417[(2)] = inst_35370);

(statearr_35397_35417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (6))){
var inst_35379 = (state_35393[(7)]);
var inst_35378 = (state_35393[(2)]);
var inst_35379__$1 = fluree.db.util.async.throw_err(inst_35378);
var inst_35380 = cljs.core.empty_QMARK_(inst_35379__$1);
var state_35393__$1 = (function (){var statearr_35398 = state_35393;
(statearr_35398[(7)] = inst_35379__$1);

return statearr_35398;
})();
if(inst_35380){
var statearr_35399_35418 = state_35393__$1;
(statearr_35399_35418[(1)] = (7));

} else {
var statearr_35400_35419 = state_35393__$1;
(statearr_35400_35419[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (3))){
var inst_35391 = (state_35393[(2)]);
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35393__$1,inst_35391);
} else {
if((state_val_35394 === (2))){
var _ = (function (){var statearr_35402 = state_35393;
(statearr_35402[(4)] = cljs.core.cons((5),(state_35393[(4)])));

return statearr_35402;
})();
var inst_35376 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35393__$1,(6),inst_35376);
} else {
if((state_val_35394 === (9))){
var inst_35388 = (state_35393[(2)]);
var _ = (function (){var statearr_35403 = state_35393;
(statearr_35403[(4)] = cljs.core.rest((state_35393[(4)])));

return statearr_35403;
})();
var state_35393__$1 = state_35393;
var statearr_35404_35420 = state_35393__$1;
(statearr_35404_35420[(2)] = inst_35388);

(statearr_35404_35420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (5))){
var _ = (function (){var statearr_35405 = state_35393;
(statearr_35405[(4)] = cljs.core.rest((state_35393[(4)])));

return statearr_35405;
})();
var state_35393__$1 = state_35393;
var ex35401 = (state_35393__$1[(2)]);
var statearr_35406_35421 = state_35393__$1;
(statearr_35406_35421[(5)] = ex35401);


if((ex35401 instanceof Error)){
var statearr_35407_35422 = state_35393__$1;
(statearr_35407_35422[(1)] = (4));

(statearr_35407_35422[(5)] = null);

} else {
throw ex35401;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (10))){
var inst_35385 = (state_35393[(2)]);
var inst_35386 = fluree.db.util.async.throw_err(inst_35385);
var state_35393__$1 = state_35393;
var statearr_35408_35423 = state_35393__$1;
(statearr_35408_35423[(2)] = inst_35386);

(statearr_35408_35423[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35394 === (8))){
var inst_35379 = (state_35393[(7)]);
var inst_35383 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_35379,db,true);
var state_35393__$1 = state_35393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35393__$1,(10),inst_35383);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__17178__auto__ = null;
var fluree$db$query$schema$state_machine__17178__auto____0 = (function (){
var statearr_35409 = [null,null,null,null,null,null,null,null];
(statearr_35409[(0)] = fluree$db$query$schema$state_machine__17178__auto__);

(statearr_35409[(1)] = (1));

return statearr_35409;
});
var fluree$db$query$schema$state_machine__17178__auto____1 = (function (state_35393){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35393);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35410){var ex__17181__auto__ = e35410;
var statearr_35411_35424 = state_35393;
(statearr_35411_35424[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35393[(4)]))){
var statearr_35412_35425 = state_35393;
(statearr_35412_35425[(1)] = cljs.core.first((state_35393[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35426 = state_35393;
state_35393 = G__35426;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__17178__auto__ = function(state_35393){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__17178__auto____1.call(this,state_35393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__17178__auto____0;
fluree$db$query$schema$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__17178__auto____1;
return fluree$db$query$schema$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35413 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35413[(6)] = c__17304__auto__);

return statearr_35413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__35428 = arguments.length;
switch (G__35428) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__35430 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35430,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35430,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35430,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__35433_SHARP_,p2__35434_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35433_SHARP_,p2__35434_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__35435_SHARP_){
var f = p1__35435_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35501){
var state_val_35502 = (state_35501[(1)]);
if((state_val_35502 === (1))){
var state_35501__$1 = state_35501;
var statearr_35503_35521 = state_35501__$1;
(statearr_35503_35521[(2)] = null);

(statearr_35503_35521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35502 === (2))){
var _ = (function (){var statearr_35504 = state_35501;
(statearr_35504[(4)] = cljs.core.cons((5),(state_35501[(4)])));

return statearr_35504;
})();
var inst_35453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35454 = fluree.db.flake.max_subject_id((1));
var inst_35455 = [inst_35454];
var inst_35456 = (new cljs.core.PersistentVector(null,1,(5),inst_35453,inst_35455,null));
var inst_35457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35458 = [(0)];
var inst_35459 = (new cljs.core.PersistentVector(null,1,(5),inst_35457,inst_35458,null));
var inst_35460 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_35456,cljs.core._LT__EQ_,inst_35459);
var state_35501__$1 = state_35501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35501__$1,(6),inst_35460);
} else {
if((state_val_35502 === (3))){
var inst_35499 = (state_35501[(2)]);
var state_35501__$1 = state_35501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35501__$1,inst_35499);
} else {
if((state_val_35502 === (4))){
var inst_35441 = (state_35501[(2)]);
var state_35501__$1 = state_35501;
var statearr_35506_35522 = state_35501__$1;
(statearr_35506_35522[(2)] = inst_35441);

(statearr_35506_35522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35502 === (5))){
var _ = (function (){var statearr_35507 = state_35501;
(statearr_35507[(4)] = cljs.core.rest((state_35501[(4)])));

return statearr_35507;
})();
var state_35501__$1 = state_35501;
var ex35505 = (state_35501__$1[(2)]);
var statearr_35508_35523 = state_35501__$1;
(statearr_35508_35523[(5)] = ex35505);


if((ex35505 instanceof Error)){
var statearr_35509_35524 = state_35501__$1;
(statearr_35509_35524[(1)] = (4));

(statearr_35509_35524[(5)] = null);

} else {
throw ex35505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35502 === (6))){
var inst_35462 = (state_35501[(2)]);
var inst_35463 = fluree.db.util.async.throw_err(inst_35462);
var inst_35464 = (function (){var schema_flakes = inst_35463;
return (function (p1__35436_SHARP_){
return (p1__35436_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_35465 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35464,inst_35463);
var inst_35466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35465,(0),null);
var inst_35467 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35465,(1),null);
var inst_35468 = (function (){var schema_flakes = inst_35463;
var vec__35447 = inst_35465;
var collection_flakes = inst_35466;
var predicate_flakes = inst_35467;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35439_SHARP_,p2__35438_SHARP_){
var f = p2__35438_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35439_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_35469 = [(-1),"_tx"];
var inst_35470 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_35471 = ["_tx",(-1),(-1),(-1),null,null];
var inst_35472 = cljs.core.PersistentHashMap.fromArrays(inst_35470,inst_35471);
var inst_35473 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_35474 = ["_tx",(-1),(-1),(-1),null,null];
var inst_35475 = cljs.core.PersistentHashMap.fromArrays(inst_35473,inst_35474);
var inst_35476 = [inst_35472,inst_35475];
var inst_35477 = cljs.core.PersistentHashMap.fromArrays(inst_35469,inst_35476);
var inst_35478 = (function (){var schema_flakes = inst_35463;
var vec__35447 = inst_35465;
var collection_flakes = inst_35466;
var predicate_flakes = inst_35467;
return (function (p1__35437_SHARP_){
return p1__35437_SHARP_.s;
});
})();
var inst_35479 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35478,inst_35466);
var inst_35480 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35468,inst_35477,inst_35479);
var inst_35482 = (function (){var schema_flakes = inst_35463;
var vec__35447 = inst_35465;
var collection_flakes = inst_35466;
var predicate_flakes = inst_35467;
var coll = inst_35480;
return (function (p__35481,pred_flakes){
var vec__35510 = p__35481;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35510,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35510,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__35513 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__35513.cljs$core$IFn$_invoke$arity$1 ? fexpr__35513.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__35513.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_35483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35484 = cljs.core.PersistentHashMap.EMPTY;
var inst_35485 = cljs.core.PersistentHashSet.EMPTY;
var inst_35486 = [inst_35484,inst_35485];
var inst_35487 = (new cljs.core.PersistentVector(null,2,(5),inst_35483,inst_35486,null));
var inst_35488 = (function (){var schema_flakes = inst_35463;
var vec__35447 = inst_35465;
var collection_flakes = inst_35466;
var predicate_flakes = inst_35467;
var coll = inst_35480;
return (function (p1__35440_SHARP_){
return p1__35440_SHARP_.s;
});
})();
var inst_35489 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35488,inst_35467);
var inst_35490 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35482,inst_35487,inst_35489);
var inst_35491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35490,(0),null);
var inst_35492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35490,(1),null);
var inst_35493 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_35494 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_35495 = [inst_35494,inst_35480,inst_35491,inst_35492];
var inst_35496 = cljs.core.PersistentHashMap.fromArrays(inst_35493,inst_35495);
var _ = (function (){var statearr_35514 = state_35501;
(statearr_35514[(4)] = cljs.core.rest((state_35501[(4)])));

return statearr_35514;
})();
var state_35501__$1 = state_35501;
var statearr_35515_35525 = state_35501__$1;
(statearr_35515_35525[(2)] = inst_35496);

(statearr_35515_35525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__17178__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__17178__auto____0 = (function (){
var statearr_35516 = [null,null,null,null,null,null,null];
(statearr_35516[(0)] = fluree$db$query$schema$schema_map_$_state_machine__17178__auto__);

(statearr_35516[(1)] = (1));

return statearr_35516;
});
var fluree$db$query$schema$schema_map_$_state_machine__17178__auto____1 = (function (state_35501){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35501);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35517){var ex__17181__auto__ = e35517;
var statearr_35518_35526 = state_35501;
(statearr_35518_35526[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35501[(4)]))){
var statearr_35519_35527 = state_35501;
(statearr_35519_35527[(1)] = cljs.core.first((state_35501[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35528 = state_35501;
state_35501 = G__35528;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__17178__auto__ = function(state_35501){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__17178__auto____1.call(this,state_35501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__17178__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__17178__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35520 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35520[(6)] = c__17304__auto__);

return statearr_35520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35570){
var state_val_35571 = (state_35570[(1)]);
if((state_val_35571 === (7))){
var inst_35553 = (state_35570[(2)]);
var inst_35554 = fluree.db.query.schema.flake__GT_pred_map(inst_35553);
var inst_35555 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_35556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(114));
var inst_35557 = cljs.core.boolean$(inst_35556);
var inst_35558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(110));
var inst_35559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(117));
var inst_35560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_35559);
var inst_35561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(111));
var inst_35562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(115));
var inst_35563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35554,(112));
var inst_35564 = [inst_35557,inst_35558,inst_35560,inst_35561,inst_35562,inst_35563];
var inst_35565 = cljs.core.PersistentHashMap.fromArrays(inst_35555,inst_35564);
var _ = (function (){var statearr_35572 = state_35570;
(statearr_35572[(4)] = cljs.core.rest((state_35570[(4)])));

return statearr_35572;
})();
var state_35570__$1 = state_35570;
var statearr_35573_35596 = state_35570__$1;
(statearr_35573_35596[(2)] = inst_35565);

(statearr_35573_35596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (1))){
var state_35570__$1 = state_35570;
var statearr_35574_35597 = state_35570__$1;
(statearr_35574_35597[(2)] = null);

(statearr_35574_35597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (4))){
var inst_35529 = (state_35570[(2)]);
var state_35570__$1 = state_35570;
var statearr_35575_35598 = state_35570__$1;
(statearr_35575_35598[(2)] = inst_35529);

(statearr_35575_35598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (6))){
var _ = (function (){var statearr_35576 = state_35570;
(statearr_35576[(4)] = cljs.core.cons((9),(state_35570[(4)])));

return statearr_35576;
})();
var inst_35541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35543 = ["_setting/id","root"];
var inst_35544 = (new cljs.core.PersistentVector(null,2,(5),inst_35542,inst_35543,null));
var inst_35545 = [inst_35544];
var inst_35546 = (new cljs.core.PersistentVector(null,1,(5),inst_35541,inst_35545,null));
var inst_35547 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_35546);
var state_35570__$1 = state_35570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35570__$1,(10),inst_35547);
} else {
if((state_val_35571 === (3))){
var inst_35568 = (state_35570[(2)]);
var state_35570__$1 = state_35570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35570__$1,inst_35568);
} else {
if((state_val_35571 === (2))){
var _ = (function (){var statearr_35579 = state_35570;
(statearr_35579[(4)] = cljs.core.cons((5),(state_35570[(4)])));

return statearr_35579;
})();
var state_35570__$1 = state_35570;
var statearr_35580_35599 = state_35570__$1;
(statearr_35580_35599[(2)] = null);

(statearr_35580_35599[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (9))){
var _ = (function (){var statearr_35581 = state_35570;
(statearr_35581[(4)] = cljs.core.rest((state_35570[(4)])));

return statearr_35581;
})();
var state_35570__$1 = state_35570;
var ex35577 = (state_35570__$1[(2)]);
var statearr_35582_35600 = state_35570__$1;
(statearr_35582_35600[(5)] = ex35577);


var statearr_35583_35601 = state_35570__$1;
(statearr_35583_35601[(1)] = (8));

(statearr_35583_35601[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (5))){
var _ = (function (){var statearr_35584 = state_35570;
(statearr_35584[(4)] = cljs.core.rest((state_35570[(4)])));

return statearr_35584;
})();
var state_35570__$1 = state_35570;
var ex35578 = (state_35570__$1[(2)]);
var statearr_35585_35602 = state_35570__$1;
(statearr_35585_35602[(5)] = ex35578);


if((ex35578 instanceof Error)){
var statearr_35586_35603 = state_35570__$1;
(statearr_35586_35603[(1)] = (4));

(statearr_35586_35603[(5)] = null);

} else {
throw ex35578;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (10))){
var inst_35549 = (state_35570[(2)]);
var inst_35550 = fluree.db.util.async.throw_err(inst_35549);
var _ = (function (){var statearr_35587 = state_35570;
(statearr_35587[(4)] = cljs.core.rest((state_35570[(4)])));

return statearr_35587;
})();
var state_35570__$1 = state_35570;
var statearr_35588_35604 = state_35570__$1;
(statearr_35588_35604[(2)] = inst_35550);

(statearr_35588_35604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35571 === (8))){
var inst_35535 = (state_35570[(2)]);
var state_35570__$1 = (function (){var statearr_35589 = state_35570;
(statearr_35589[(7)] = inst_35535);

return statearr_35589;
})();
var statearr_35590_35605 = state_35570__$1;
(statearr_35590_35605[(2)] = null);

(statearr_35590_35605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__17178__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__17178__auto____0 = (function (){
var statearr_35591 = [null,null,null,null,null,null,null,null];
(statearr_35591[(0)] = fluree$db$query$schema$setting_map_$_state_machine__17178__auto__);

(statearr_35591[(1)] = (1));

return statearr_35591;
});
var fluree$db$query$schema$setting_map_$_state_machine__17178__auto____1 = (function (state_35570){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35570);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35592){var ex__17181__auto__ = e35592;
var statearr_35593_35606 = state_35570;
(statearr_35593_35606[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35570[(4)]))){
var statearr_35594_35607 = state_35570;
(statearr_35594_35607[(1)] = cljs.core.first((state_35570[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35608 = state_35570;
state_35570 = G__35608;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__17178__auto__ = function(state_35570){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__17178__auto____1.call(this,state_35570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__17178__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__17178__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35595 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35595[(6)] = c__17304__auto__);

return statearr_35595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
