// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k46943,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__46947 = k46943;
var G__46947__$1 = (((G__46947 instanceof cljs.core.Keyword))?G__46947.fqn:null);
switch (G__46947__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46943,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__46948){
var vec__46949 = p__46948;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46949,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46949,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46942){
var self__ = this;
var G__46942__$1 = this;
return (new cljs.core.RecordIter((0),G__46942__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__46952 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__46952(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46944,other46945){
var self__ = this;
var this46944__$1 = this;
return (((!((other46945 == null)))) && ((((this46944__$1.constructor === other46945.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.conn,other46945.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.network,other46945.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.dbid,other46945.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.db_name,other46945.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.update_chan,other46945.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.transact_chan,other46945.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.state,other46945.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.schema_cache,other46945.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.blank_db,other46945.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.close,other46945.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.id,other46945.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46944__$1.__extmap,other46945.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k46943){
var self__ = this;
var this__4468__auto____$1 = this;
var G__46953 = k46943;
var G__46953__$1 = (((G__46953 instanceof cljs.core.Keyword))?G__46953.fqn:null);
switch (G__46953__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k46943);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__46942){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__46954 = cljs.core.keyword_identical_QMARK_;
var expr__46955 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__46957 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__46958 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46957,G__46958) : pred__46954.call(null,G__46957,G__46958));
})())){
return (new fluree.db.session.DbSession(G__46942,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46959 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__46960 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46959,G__46960) : pred__46954.call(null,G__46959,G__46960));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__46942,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46961 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__46962 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46961,G__46962) : pred__46954.call(null,G__46961,G__46962));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__46942,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46963 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__46964 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46963,G__46964) : pred__46954.call(null,G__46963,G__46964));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__46942,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46965 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__46966 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46965,G__46966) : pred__46954.call(null,G__46965,G__46966));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__46942,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46967 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__46968 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46967,G__46968) : pred__46954.call(null,G__46967,G__46968));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__46942,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46969 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__46970 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46969,G__46970) : pred__46954.call(null,G__46969,G__46970));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__46942,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46971 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__46972 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46971,G__46972) : pred__46954.call(null,G__46971,G__46972));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__46942,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46973 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__46974 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46973,G__46974) : pred__46954.call(null,G__46973,G__46974));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__46942,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46975 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__46976 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46975,G__46976) : pred__46954.call(null,G__46975,G__46976));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__46942,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46977 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__46978 = expr__46955;
return (pred__46954.cljs$core$IFn$_invoke$arity$2 ? pred__46954.cljs$core$IFn$_invoke$arity$2(G__46977,G__46978) : pred__46954.call(null,G__46977,G__46978));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__46942,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__46942),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__46942){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__46942,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__46946){
var extmap__4501__auto__ = (function (){var G__46979 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46946,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__46946)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46979);
} else {
return G__46979;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__46946),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__46946),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__46982 = session;
var map__46982__$1 = cljs.core.__destructure_map(map__46982);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46982__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46982__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___47133 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47085){
var state_val_47086 = (state_47085[(1)]);
if((state_val_47086 === (7))){
var inst_47003 = (state_47085[(7)]);
var inst_47008 = cljs.core.empty_QMARK_(inst_47003);
var state_47085__$1 = state_47085;
if(inst_47008){
var statearr_47087_47134 = state_47085__$1;
(statearr_47087_47134[(1)] = (10));

} else {
var statearr_47088_47135 = state_47085__$1;
(statearr_47088_47135[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (20))){
var inst_47034 = (state_47085[(8)]);
var inst_46994 = (state_47085[(9)]);
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var inst_47039 = fluree.db.storage.core.read_block(inst_46994,inst_46995,inst_46996,inst_47034);
var state_47085__$1 = state_47085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(22),inst_47039);
} else {
if((state_val_47086 === (27))){
var inst_47072 = (state_47085[(12)]);
var inst_47074 = (state_47085[(2)]);
var inst_47075 = fluree.db.util.async.throw_err(inst_47074);
var state_47085__$1 = (function (){var statearr_47089 = state_47085;
(statearr_47089[(13)] = inst_47075);

return statearr_47089;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(28),inst_47072);
} else {
if((state_val_47086 === (1))){
var state_47085__$1 = state_47085;
var statearr_47090_47136 = state_47085__$1;
(statearr_47090_47136[(2)] = null);

(statearr_47090_47136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (24))){
var inst_47034 = (state_47085[(8)]);
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var inst_47056 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47034)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46995),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46996),"."].join('');
var inst_47057 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47058 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_47059 = cljs.core.PersistentHashMap.fromArrays(inst_47057,inst_47058);
var inst_47060 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47056,inst_47059);
var inst_47061 = (function(){throw inst_47060})();
var state_47085__$1 = state_47085;
var statearr_47091_47137 = state_47085__$1;
(statearr_47091_47137[(2)] = inst_47061);

(statearr_47091_47137[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (4))){
var inst_46983 = (state_47085[(2)]);
var inst_46984 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_46983);
var state_47085__$1 = state_47085;
var statearr_47092_47138 = state_47085__$1;
(statearr_47092_47138[(2)] = inst_46984);

(statearr_47092_47138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (15))){
var state_47085__$1 = state_47085;
var statearr_47093_47139 = state_47085__$1;
(statearr_47093_47139[(2)] = null);

(statearr_47093_47139[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (21))){
var inst_47065 = (state_47085[(2)]);
var state_47085__$1 = state_47085;
var statearr_47094_47140 = state_47085__$1;
(statearr_47094_47140[(2)] = inst_47065);

(statearr_47094_47140[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (13))){
var inst_47028 = (state_47085[(14)]);
var inst_47003 = (state_47085[(7)]);
var inst_47027 = (state_47085[(2)]);
var inst_47028__$1 = fluree.db.util.async.throw_err(inst_47027);
var inst_47029 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_47003);
var state_47085__$1 = (function (){var statearr_47095 = state_47085;
(statearr_47095[(14)] = inst_47028__$1);

(statearr_47095[(15)] = inst_47029);

return statearr_47095;
})();
if(cljs.core.truth_(inst_47028__$1)){
var statearr_47096_47141 = state_47085__$1;
(statearr_47096_47141[(1)] = (14));

} else {
var statearr_47097_47142 = state_47085__$1;
(statearr_47097_47142[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (22))){
var inst_47042 = (state_47085[(16)]);
var inst_47041 = (state_47085[(2)]);
var inst_47042__$1 = fluree.db.util.async.throw_err(inst_47041);
var state_47085__$1 = (function (){var statearr_47098 = state_47085;
(statearr_47098[(16)] = inst_47042__$1);

return statearr_47098;
})();
if(cljs.core.truth_(inst_47042__$1)){
var statearr_47099_47143 = state_47085__$1;
(statearr_47099_47143[(1)] = (23));

} else {
var statearr_47100_47144 = state_47085__$1;
(statearr_47100_47144[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (6))){
var inst_47003 = (state_47085[(7)]);
var inst_47002 = (state_47085[(2)]);
var inst_47003__$1 = fluree.db.util.async.throw_err(inst_47002);
var inst_47004 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_47003__$1);
var inst_47005 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_47004);
var inst_47006 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_47005);
var state_47085__$1 = (function (){var statearr_47101 = state_47085;
(statearr_47101[(7)] = inst_47003__$1);

return statearr_47101;
})();
if(inst_47006){
var statearr_47102_47145 = state_47085__$1;
(statearr_47102_47145[(1)] = (7));

} else {
var statearr_47103_47146 = state_47085__$1;
(statearr_47103_47146[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (28))){
var inst_47070 = (state_47085[(17)]);
var inst_47075 = (state_47085[(13)]);
var inst_47077 = (state_47085[(2)]);
var inst_47078 = fluree.db.util.async.throw_err(inst_47077);
var inst_47079 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_47070,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_47075,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_47078], 0));
var inst_47080 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_47079);
var _ = (function (){var statearr_47104 = state_47085;
(statearr_47104[(4)] = cljs.core.rest((state_47085[(4)])));

return statearr_47104;
})();
var state_47085__$1 = state_47085;
var statearr_47105_47147 = state_47085__$1;
(statearr_47105_47147[(2)] = inst_47080);

(statearr_47105_47147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (25))){
var inst_47063 = (state_47085[(2)]);
var state_47085__$1 = state_47085;
var statearr_47106_47148 = state_47085__$1;
(statearr_47106_47148[(2)] = inst_47063);

(statearr_47106_47148[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (17))){
var inst_47034 = (state_47085[(8)]);
var inst_47029 = (state_47085[(15)]);
var inst_47036 = (inst_47034 > inst_47029);
var state_47085__$1 = state_47085;
if(cljs.core.truth_(inst_47036)){
var statearr_47107_47149 = state_47085__$1;
(statearr_47107_47149[(1)] = (19));

} else {
var statearr_47108_47150 = state_47085__$1;
(statearr_47108_47150[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (3))){
var inst_47083 = (state_47085[(2)]);
var state_47085__$1 = state_47085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47085__$1,inst_47083);
} else {
if((state_val_47086 === (12))){
var inst_47015 = (state_47085[(2)]);
var inst_47016 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47017 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_47018 = cljs.core.PersistentHashMap.fromArrays(inst_47016,inst_47017);
var inst_47019 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47015,inst_47018);
var inst_47020 = (function(){throw inst_47019})();
var state_47085__$1 = state_47085;
var statearr_47109_47151 = state_47085__$1;
(statearr_47109_47151[(2)] = inst_47020);

(statearr_47109_47151[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (2))){
var inst_46994 = (state_47085[(9)]);
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var _ = (function (){var statearr_47110 = state_47085;
(statearr_47110[(4)] = cljs.core.cons((5),(state_47085[(4)])));

return statearr_47110;
})();
var inst_46991 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_46992 = session;
var inst_46993 = cljs.core.__destructure_map(inst_46992);
var inst_46994__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46993,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_46995__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46993,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_46996__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46993,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_46997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46998 = [inst_46995__$1,inst_46996__$1];
var inst_46999 = (new cljs.core.PersistentVector(null,2,(5),inst_46997,inst_46998,null));
var inst_47000 = fluree.db.operations.ledger_info_async(inst_46994__$1,inst_46999);
var state_47085__$1 = (function (){var statearr_47111 = state_47085;
(statearr_47111[(18)] = inst_46991);

(statearr_47111[(9)] = inst_46994__$1);

(statearr_47111[(10)] = inst_46996__$1);

(statearr_47111[(11)] = inst_46995__$1);

return statearr_47111;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(6),inst_47000);
} else {
if((state_val_47086 === (23))){
var inst_47033 = (state_47085[(19)]);
var inst_47042 = (state_47085[(16)]);
var inst_47045 = cljs.core.__destructure_map(inst_47042);
var inst_47046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47045,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_47047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47045,new cljs.core.Keyword(null,"block","block",664686210));
var inst_47048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47045,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_47049 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_47033,inst_47047,inst_47046);
var state_47085__$1 = (function (){var statearr_47112 = state_47085;
(statearr_47112[(20)] = inst_47048);

return statearr_47112;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(26),inst_47049);
} else {
if((state_val_47086 === (19))){
var inst_47033 = (state_47085[(19)]);
var state_47085__$1 = state_47085;
var statearr_47113_47152 = state_47085__$1;
(statearr_47113_47152[(2)] = inst_47033);

(statearr_47113_47152[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (11))){
var inst_47003 = (state_47085[(7)]);
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var inst_47012 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_47003);
var inst_47013 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46995),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46996)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47012),"."].join('');
var state_47085__$1 = state_47085;
var statearr_47115_47153 = state_47085__$1;
(statearr_47115_47153[(2)] = inst_47013);

(statearr_47115_47153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (9))){
var inst_46991 = (state_47085[(18)]);
var inst_46994 = (state_47085[(9)]);
var inst_47003 = (state_47085[(7)]);
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var inst_47023 = (state_47085[(2)]);
var inst_47024 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_47003);
var inst_47025 = fluree.db.storage.core.reify_db(inst_46994,inst_46995,inst_46996,inst_46991,inst_47024);
var state_47085__$1 = (function (){var statearr_47116 = state_47085;
(statearr_47116[(21)] = inst_47023);

return statearr_47116;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(13),inst_47025);
} else {
if((state_val_47086 === (5))){
var _ = (function (){var statearr_47117 = state_47085;
(statearr_47117[(4)] = cljs.core.rest((state_47085[(4)])));

return statearr_47117;
})();
var state_47085__$1 = state_47085;
var ex47114 = (state_47085__$1[(2)]);
var statearr_47118_47154 = state_47085__$1;
(statearr_47118_47154[(5)] = ex47114);


var statearr_47119_47155 = state_47085__$1;
(statearr_47119_47155[(1)] = (4));

(statearr_47119_47155[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (14))){
var inst_47028 = (state_47085[(14)]);
var inst_47031 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_47028);
var inst_47032 = (inst_47031 + (1));
var inst_47033 = inst_47028;
var inst_47034 = inst_47032;
var state_47085__$1 = (function (){var statearr_47120 = state_47085;
(statearr_47120[(19)] = inst_47033);

(statearr_47120[(8)] = inst_47034);

return statearr_47120;
})();
var statearr_47121_47156 = state_47085__$1;
(statearr_47121_47156[(2)] = null);

(statearr_47121_47156[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (26))){
var inst_47034 = (state_47085[(8)]);
var inst_47051 = (state_47085[(2)]);
var inst_47052 = fluree.db.util.async.throw_err(inst_47051);
var inst_47053 = (inst_47034 + (1));
var inst_47033 = inst_47052;
var inst_47034__$1 = inst_47053;
var state_47085__$1 = (function (){var statearr_47122 = state_47085;
(statearr_47122[(19)] = inst_47033);

(statearr_47122[(8)] = inst_47034__$1);

return statearr_47122;
})();
var statearr_47123_47157 = state_47085__$1;
(statearr_47123_47157[(2)] = null);

(statearr_47123_47157[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (16))){
var inst_47070 = (state_47085[(17)]);
var inst_47070__$1 = (state_47085[(2)]);
var inst_47071 = fluree.db.query.schema.schema_map(inst_47070__$1);
var inst_47072 = fluree.db.query.schema.setting_map(inst_47070__$1);
var state_47085__$1 = (function (){var statearr_47124 = state_47085;
(statearr_47124[(17)] = inst_47070__$1);

(statearr_47124[(12)] = inst_47072);

return statearr_47124;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47085__$1,(27),inst_47071);
} else {
if((state_val_47086 === (10))){
var inst_46996 = (state_47085[(10)]);
var inst_46995 = (state_47085[(11)]);
var inst_47010 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46995),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46996)," is not found on this ledger group."].join('');
var state_47085__$1 = state_47085;
var statearr_47125_47158 = state_47085__$1;
(statearr_47125_47158[(2)] = inst_47010);

(statearr_47125_47158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (18))){
var inst_47067 = (state_47085[(2)]);
var state_47085__$1 = state_47085;
var statearr_47126_47159 = state_47085__$1;
(statearr_47126_47159[(2)] = inst_47067);

(statearr_47126_47159[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47086 === (8))){
var state_47085__$1 = state_47085;
var statearr_47127_47160 = state_47085__$1;
(statearr_47127_47160[(2)] = null);

(statearr_47127_47160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____0 = (function (){
var statearr_47128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47128[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__);

(statearr_47128[(1)] = (1));

return statearr_47128;
});
var fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____1 = (function (state_47085){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47085);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47129){var ex__17181__auto__ = e47129;
var statearr_47130_47161 = state_47085;
(statearr_47130_47161[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47085[(4)]))){
var statearr_47131_47162 = state_47085;
(statearr_47131_47162[(1)] = cljs.core.first((state_47085[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47163 = state_47085;
state_47085 = G__47163;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__ = function(state_47085){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____1.call(this,state_47085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__17178__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47132 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47132[(6)] = c__17304__auto___47133);

return statearr_47132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__47164 = cljs.core.get_global_hierarchy;
return (fexpr__47164.cljs$core$IFn$_invoke$arity$0 ? fexpr__47164.cljs$core$IFn$_invoke$arity$0() : fexpr__47164.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47166){
var state_val_47167 = (state_47166[(1)]);
if((state_val_47167 === (1))){
var state_47166__$1 = state_47166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47166__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__17178__auto__ = null;
var fluree$db$session$state_machine__17178__auto____0 = (function (){
var statearr_47168 = [null,null,null,null,null,null,null];
(statearr_47168[(0)] = fluree$db$session$state_machine__17178__auto__);

(statearr_47168[(1)] = (1));

return statearr_47168;
});
var fluree$db$session$state_machine__17178__auto____1 = (function (state_47166){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47166);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47169){var ex__17181__auto__ = e47169;
var statearr_47170_47173 = state_47166;
(statearr_47170_47173[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47166[(4)]))){
var statearr_47171_47174 = state_47166;
(statearr_47171_47174[(1)] = cljs.core.first((state_47166[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47175 = state_47166;
state_47166 = G__47175;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$state_machine__17178__auto__ = function(state_47166){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__17178__auto____1.call(this,state_47166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__17178__auto____0;
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__17178__auto____1;
return fluree$db$session$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47172 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47172[(6)] = c__17304__auto__);

return statearr_47172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__47177){
var map__47178 = p__47177;
var map__47178__$1 = cljs.core.__destructure_map(map__47178);
var data = map__47178__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47178__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47178__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47178__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47237){
var state_val_47238 = (state_47237[(1)]);
if((state_val_47238 === (7))){
var inst_47189 = (state_47237[(7)]);
var inst_47192 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_47193 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_47194 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47192),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47193),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47189),". No-op."].join('');
var inst_47195 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47194], 0));
var state_47237__$1 = state_47237;
var statearr_47239_47277 = state_47237__$1;
(statearr_47239_47277[(2)] = inst_47195);

(statearr_47239_47277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (1))){
var state_47237__$1 = state_47237;
var statearr_47240_47278 = state_47237__$1;
(statearr_47240_47278[(2)] = null);

(statearr_47240_47278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (4))){
var inst_47179 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
var statearr_47241_47279 = state_47237__$1;
(statearr_47241_47279[(2)] = inst_47179);

(statearr_47241_47279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (15))){
var inst_47218 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
var statearr_47242_47280 = state_47237__$1;
(statearr_47242_47280[(2)] = inst_47218);

(statearr_47242_47280[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (13))){
var inst_47209 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_47210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47211 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_47212 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_47213 = [inst_47211,inst_47212];
var inst_47214 = (new cljs.core.PersistentVector(null,2,(5),inst_47210,inst_47213,null));
var inst_47215 = (function (){var G__47243 = inst_47209;
var G__47244 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__47245 = inst_47214;
var G__47246 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__47243,G__47244,G__47245,G__47246) : fluree.db.conn_events.process_event.call(null,G__47243,G__47244,G__47245,G__47246));
})();
var state_47237__$1 = state_47237;
var statearr_47247_47281 = state_47237__$1;
(statearr_47247_47281[(2)] = inst_47215);

(statearr_47247_47281[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (6))){
var inst_47188 = (state_47237[(8)]);
var inst_47189 = (state_47237[(7)]);
var inst_47187 = (state_47237[(2)]);
var inst_47188__$1 = fluree.db.util.async.throw_err(inst_47187);
var inst_47189__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_47188__$1);
var inst_47190 = (block <= inst_47189__$1);
var state_47237__$1 = (function (){var statearr_47248 = state_47237;
(statearr_47248[(8)] = inst_47188__$1);

(statearr_47248[(7)] = inst_47189__$1);

return statearr_47248;
})();
if(cljs.core.truth_(inst_47190)){
var statearr_47249_47282 = state_47237__$1;
(statearr_47249_47282[(1)] = (7));

} else {
var statearr_47250_47283 = state_47237__$1;
(statearr_47250_47283[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (17))){
var state_47237__$1 = state_47237;
var statearr_47251_47284 = state_47237__$1;
(statearr_47251_47284[(2)] = null);

(statearr_47251_47284[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (3))){
var inst_47235 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47237__$1,inst_47235);
} else {
if((state_val_47238 === (12))){
var inst_47230 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
var statearr_47252_47285 = state_47237__$1;
(statearr_47252_47285[(2)] = inst_47230);

(statearr_47252_47285[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (2))){
var inst_47185 = (state_47237[(9)]);
var _ = (function (){var statearr_47253 = state_47237;
(statearr_47253[(4)] = cljs.core.cons((5),(state_47237[(4)])));

return statearr_47253;
})();
var inst_47185__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_47237__$1 = (function (){var statearr_47254 = state_47237;
(statearr_47254[(9)] = inst_47185__$1);

return statearr_47254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47237__$1,(6),inst_47185__$1);
} else {
if((state_val_47238 === (11))){
var state_47237__$1 = state_47237;
var statearr_47256_47286 = state_47237__$1;
(statearr_47256_47286[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (9))){
var inst_47232 = (state_47237[(2)]);
var _ = (function (){var statearr_47258 = state_47237;
(statearr_47258[(4)] = cljs.core.rest((state_47237[(4)])));

return statearr_47258;
})();
var state_47237__$1 = state_47237;
var statearr_47259_47287 = state_47237__$1;
(statearr_47259_47287[(2)] = inst_47232);

(statearr_47259_47287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (5))){
var _ = (function (){var statearr_47260 = state_47237;
(statearr_47260[(4)] = cljs.core.rest((state_47237[(4)])));

return statearr_47260;
})();
var state_47237__$1 = state_47237;
var ex47255 = (state_47237__$1[(2)]);
var statearr_47261_47288 = state_47237__$1;
(statearr_47261_47288[(5)] = ex47255);


if((ex47255 instanceof Error)){
var statearr_47262_47289 = state_47237__$1;
(statearr_47262_47289[(1)] = (4));

(statearr_47262_47289[(5)] = null);

} else {
throw ex47255;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (14))){
var state_47237__$1 = state_47237;
var statearr_47263_47290 = state_47237__$1;
(statearr_47263_47290[(2)] = null);

(statearr_47263_47290[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (16))){
var inst_47189 = (state_47237[(7)]);
var inst_47221 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_47222 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_47223 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47221),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47222),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47189),". Forcing a db reload."].join('');
var inst_47224 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47223], 0));
var inst_47225 = fluree.db.session.reload_db_BANG_(session);
var state_47237__$1 = (function (){var statearr_47264 = state_47237;
(statearr_47264[(10)] = inst_47224);

return statearr_47264;
})();
var statearr_47265_47291 = state_47237__$1;
(statearr_47265_47291[(2)] = inst_47225);

(statearr_47265_47291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (10))){
var inst_47185 = (state_47237[(9)]);
var inst_47188 = (state_47237[(8)]);
var inst_47189 = (state_47237[(7)]);
var inst_47200 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_47201 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_47202 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47200),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47201),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_47203 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47202], 0));
var inst_47204 = (function (){var current_db_ch = inst_47185;
var current_db = inst_47188;
var current_block = inst_47189;
return (function (p1__47176_SHARP_){
if((p1__47176_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__47176_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__47176_SHARP_);
}
});
})();
var inst_47205 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_47204,flakes);
var inst_47206 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_47188,block,inst_47205);
var inst_47207 = fluree.db.session.cas_db_BANG_(session,inst_47185,inst_47206);
var state_47237__$1 = (function (){var statearr_47266 = state_47237;
(statearr_47266[(11)] = inst_47203);

return statearr_47266;
})();
if(inst_47207){
var statearr_47267_47292 = state_47237__$1;
(statearr_47267_47292[(1)] = (13));

} else {
var statearr_47268_47293 = state_47237__$1;
(statearr_47268_47293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (18))){
var inst_47228 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
var statearr_47269_47294 = state_47237__$1;
(statearr_47269_47294[(2)] = inst_47228);

(statearr_47269_47294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47238 === (8))){
var inst_47189 = (state_47237[(7)]);
var inst_47197 = ((1) + inst_47189);
var inst_47198 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_47197);
var state_47237__$1 = state_47237;
if(inst_47198){
var statearr_47270_47295 = state_47237__$1;
(statearr_47270_47295[(1)] = (10));

} else {
var statearr_47271_47296 = state_47237__$1;
(statearr_47271_47296[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__17178__auto__ = null;
var fluree$db$session$state_machine__17178__auto____0 = (function (){
var statearr_47272 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47272[(0)] = fluree$db$session$state_machine__17178__auto__);

(statearr_47272[(1)] = (1));

return statearr_47272;
});
var fluree$db$session$state_machine__17178__auto____1 = (function (state_47237){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47237);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47273){var ex__17181__auto__ = e47273;
var statearr_47274_47297 = state_47237;
(statearr_47274_47297[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47237[(4)]))){
var statearr_47275_47298 = state_47237;
(statearr_47275_47298[(1)] = cljs.core.first((state_47237[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47299 = state_47237;
state_47237 = G__47299;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$state_machine__17178__auto__ = function(state_47237){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__17178__auto____1.call(this,state_47237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__17178__auto____0;
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__17178__auto____1;
return fluree$db$session$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47276 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47276[(6)] = c__17304__auto__);

return statearr_47276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47306){
var state_val_47307 = (state_47306[(1)]);
if((state_val_47307 === (1))){
var inst_47300 = fluree.db.session.clear_db_BANG_(session);
var inst_47301 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_47302 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_47303 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47301),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47302)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_47304 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47303], 0));
var state_47306__$1 = (function (){var statearr_47308 = state_47306;
(statearr_47308[(7)] = inst_47304);

(statearr_47308[(8)] = inst_47300);

return statearr_47308;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47306__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__17178__auto__ = null;
var fluree$db$session$state_machine__17178__auto____0 = (function (){
var statearr_47309 = [null,null,null,null,null,null,null,null,null];
(statearr_47309[(0)] = fluree$db$session$state_machine__17178__auto__);

(statearr_47309[(1)] = (1));

return statearr_47309;
});
var fluree$db$session$state_machine__17178__auto____1 = (function (state_47306){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47306);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47310){var ex__17181__auto__ = e47310;
var statearr_47311_47314 = state_47306;
(statearr_47311_47314[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47306[(4)]))){
var statearr_47312_47315 = state_47306;
(statearr_47312_47315[(1)] = cljs.core.first((state_47306[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47316 = state_47306;
state_47306 = G__47316;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$state_machine__17178__auto__ = function(state_47306){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__17178__auto____1.call(this,state_47306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__17178__auto____0;
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__17178__auto____1;
return fluree$db$session$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47313 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47313[(6)] = c__17304__auto__);

return statearr_47313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__47318 = arguments.length;
switch (G__47318) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__47319 = session;
var map__47319__$1 = cljs.core.__destructure_map(map__47319);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47319__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__47320_47323 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__47320_47323.cljs$core$IFn$_invoke$arity$3 ? fexpr__47320_47323.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__47320_47323.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__47321_47324 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__47321_47324.cljs$core$IFn$_invoke$arity$0 ? fexpr__47321_47324.cljs$core$IFn$_invoke$arity$0() : fexpr__47321_47324.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47377){
var state_val_47378 = (state_47377[(1)]);
if((state_val_47378 === (7))){
var inst_47373 = (state_47377[(2)]);
var state_47377__$1 = state_47377;
var statearr_47379_47410 = state_47377__$1;
(statearr_47379_47410[(2)] = inst_47373);

(statearr_47379_47410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (1))){
var state_47377__$1 = state_47377;
var statearr_47380_47411 = state_47377__$1;
(statearr_47380_47411[(2)] = null);

(statearr_47380_47411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (4))){
var inst_47328 = (state_47377[(7)]);
var inst_47327 = (state_47377[(2)]);
var inst_47328__$1 = fluree.db.util.async.throw_err(inst_47327);
var inst_47329 = fluree.db.session.from_cache(network,ledger_id);
var inst_47330 = (inst_47328__$1 == null);
var state_47377__$1 = (function (){var statearr_47381 = state_47377;
(statearr_47381[(7)] = inst_47328__$1);

(statearr_47381[(8)] = inst_47329);

return statearr_47381;
})();
if(cljs.core.truth_(inst_47330)){
var statearr_47382_47412 = state_47377__$1;
(statearr_47382_47412[(1)] = (5));

} else {
var statearr_47383_47413 = state_47377__$1;
(statearr_47383_47413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (15))){
var inst_47365 = (state_47377[(2)]);
var state_47377__$1 = (function (){var statearr_47384 = state_47377;
(statearr_47384[(9)] = inst_47365);

return statearr_47384;
})();
var statearr_47385_47414 = state_47377__$1;
(statearr_47385_47414[(2)] = null);

(statearr_47385_47414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (13))){
var inst_47369 = (state_47377[(2)]);
var state_47377__$1 = state_47377;
var statearr_47387_47415 = state_47377__$1;
(statearr_47387_47415[(2)] = inst_47369);

(statearr_47387_47415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (6))){
var inst_47329 = (state_47377[(8)]);
var inst_47335 = (inst_47329 == null);
var state_47377__$1 = state_47377;
if(cljs.core.truth_(inst_47335)){
var statearr_47388_47416 = state_47377__$1;
(statearr_47388_47416[(1)] = (8));

} else {
var statearr_47389_47417 = state_47377__$1;
(statearr_47389_47417[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (17))){
var _ = (function (){var statearr_47390 = state_47377;
(statearr_47390[(4)] = cljs.core.rest((state_47377[(4)])));

return statearr_47390;
})();
var state_47377__$1 = state_47377;
var ex47386 = (state_47377__$1[(2)]);
var statearr_47391_47418 = state_47377__$1;
(statearr_47391_47418[(5)] = ex47386);


var statearr_47392_47419 = state_47377__$1;
(statearr_47392_47419[(1)] = (16));

(statearr_47392_47419[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (3))){
var inst_47375 = (state_47377[(2)]);
var state_47377__$1 = state_47377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47377__$1,inst_47375);
} else {
if((state_val_47378 === (12))){
var state_47377__$1 = state_47377;
var statearr_47393_47420 = state_47377__$1;
(statearr_47393_47420[(2)] = null);

(statearr_47393_47420[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (2))){
var state_47377__$1 = state_47377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47377__$1,(4),update_chan);
} else {
if((state_val_47378 === (11))){
var state_47377__$1 = state_47377;
var statearr_47394_47421 = state_47377__$1;
(statearr_47394_47421[(2)] = null);

(statearr_47394_47421[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (9))){
var state_47377__$1 = state_47377;
var statearr_47395_47422 = state_47377__$1;
(statearr_47395_47422[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (5))){
var inst_47332 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_47333 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47332], 0));
var state_47377__$1 = state_47377;
var statearr_47397_47423 = state_47377__$1;
(statearr_47397_47423[(2)] = inst_47333);

(statearr_47397_47423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (14))){
var inst_47328 = (state_47377[(7)]);
var inst_47329 = (state_47377[(8)]);
var _ = (function (){var statearr_47398 = state_47377;
(statearr_47398[(4)] = cljs.core.cons((17),(state_47377[(4)])));

return statearr_47398;
})();
var inst_47353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47328,(0),null);
var inst_47354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47328,(1),null);
var inst_47355 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_47356 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47328], 0));
var inst_47357 = fluree.db.util.core.trunc(inst_47356,(200));
var inst_47358 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47355,inst_47357], 0));
var inst_47359 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_47329,inst_47353,inst_47354) : fluree.db.session.process_ledger_update.call(null,inst_47329,inst_47353,inst_47354));
var state_47377__$1 = (function (){var statearr_47399 = state_47377;
(statearr_47399[(10)] = inst_47358);

return statearr_47399;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47377__$1,(18),inst_47359);
} else {
if((state_val_47378 === (16))){
var inst_47328 = (state_47377[(7)]);
var inst_47343 = (state_47377[(2)]);
var inst_47344 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47343,"Exception processing ledger updates for message: ",inst_47328], 0));
var state_47377__$1 = state_47377;
var statearr_47400_47424 = state_47377__$1;
(statearr_47400_47424[(2)] = inst_47344);

(statearr_47400_47424[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (10))){
var inst_47371 = (state_47377[(2)]);
var state_47377__$1 = state_47377;
var statearr_47401_47425 = state_47377__$1;
(statearr_47401_47425[(2)] = inst_47371);

(statearr_47401_47425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (18))){
var inst_47361 = (state_47377[(2)]);
var inst_47362 = fluree.db.util.async.throw_err(inst_47361);
var _ = (function (){var statearr_47402 = state_47377;
(statearr_47402[(4)] = cljs.core.rest((state_47377[(4)])));

return statearr_47402;
})();
var state_47377__$1 = state_47377;
var statearr_47403_47426 = state_47377__$1;
(statearr_47403_47426[(2)] = inst_47362);

(statearr_47403_47426[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47378 === (8))){
var inst_47328 = (state_47377[(7)]);
var inst_47337 = cljs.core.first(inst_47328);
var inst_47338 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47337], 0));
var inst_47339 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_47338].join('');
var inst_47340 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47339], 0));
var state_47377__$1 = state_47377;
var statearr_47404_47427 = state_47377__$1;
(statearr_47404_47427[(2)] = inst_47340);

(statearr_47404_47427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____0 = (function (){
var statearr_47405 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47405[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__);

(statearr_47405[(1)] = (1));

return statearr_47405;
});
var fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____1 = (function (state_47377){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47377);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47406){var ex__17181__auto__ = e47406;
var statearr_47407_47428 = state_47377;
(statearr_47407_47428[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47377[(4)]))){
var statearr_47408_47429 = state_47377;
(statearr_47408_47429[(1)] = cljs.core.first((state_47377[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47430 = state_47377;
state_47377 = G__47430;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__ = function(state_47377){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____1.call(this,state_47377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__17178__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47409 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47409[(6)] = c__17304__auto__);

return statearr_47409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__47431){
var map__47432 = p__47431;
var map__47432__$1 = cljs.core.__destructure_map(map__47432);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47432__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__47436 = block_result;
var map__47436__$1 = cljs.core.__destructure_map(map__47436);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47436__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47436__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47436__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47436__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47436__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__47437 = tx_result;
var map__47437__$1 = cljs.core.__destructure_map(map__47437);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47437__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47437__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__47433_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__47433_SHARP_.t);
}):(function (p1__47434_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__47434_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__47435_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__47435_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__47435_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__47438 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47438,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47438,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47438,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47438,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__47442 = arguments.length;
switch (G__47442) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__47443){
var map__47444 = p__47443;
var map__47444__$1 = cljs.core.__destructure_map(map__47444);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47444__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47444__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47444__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47444__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__47445 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47445,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47445,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47445,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__47449_47569 = network;
var G__47450_47570 = ledger_id;
var G__47451_47571 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__47452_47572 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__47453 = cljs.core.seq(tids);
var chunk__47454 = null;
var count__47455 = (0);
var i__47456 = (0);
while(true){
if((i__47456 < count__47455)){
var tid = chunk__47454.cljs$core$IIndexed$_nth$arity$2(null,i__47456);
var temp__5753__auto___47574__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___47574__$1)){
var keyed_callbacks_47575 = temp__5753__auto___47574__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_47576 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__47497_47577 = cljs.core.seq(keyed_callbacks_47575);
var chunk__47498_47578 = null;
var count__47499_47579 = (0);
var i__47500_47580 = (0);
while(true){
if((i__47500_47580 < count__47499_47579)){
var vec__47509_47581 = chunk__47498_47578.cljs$core$IIndexed$_nth$arity$2(null,i__47500_47580);
var k_47582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47509_47581,(0),null);
var f_47583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47509_47581,(1),null);
try{(f_47583.cljs$core$IFn$_invoke$arity$1 ? f_47583.cljs$core$IFn$_invoke$arity$1(tx_response_47576) : f_47583.call(null,tx_response_47576));
}catch (e47512){var e_47584 = e47512;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_47584,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__47585 = seq__47497_47577;
var G__47586 = chunk__47498_47578;
var G__47587 = count__47499_47579;
var G__47588 = (i__47500_47580 + (1));
seq__47497_47577 = G__47585;
chunk__47498_47578 = G__47586;
count__47499_47579 = G__47587;
i__47500_47580 = G__47588;
continue;
} else {
var temp__5753__auto___47589__$2 = cljs.core.seq(seq__47497_47577);
if(temp__5753__auto___47589__$2){
var seq__47497_47590__$1 = temp__5753__auto___47589__$2;
if(cljs.core.chunked_seq_QMARK_(seq__47497_47590__$1)){
var c__4638__auto___47591 = cljs.core.chunk_first(seq__47497_47590__$1);
var G__47592 = cljs.core.chunk_rest(seq__47497_47590__$1);
var G__47593 = c__4638__auto___47591;
var G__47594 = cljs.core.count(c__4638__auto___47591);
var G__47595 = (0);
seq__47497_47577 = G__47592;
chunk__47498_47578 = G__47593;
count__47499_47579 = G__47594;
i__47500_47580 = G__47595;
continue;
} else {
var vec__47513_47596 = cljs.core.first(seq__47497_47590__$1);
var k_47597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47513_47596,(0),null);
var f_47598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47513_47596,(1),null);
try{(f_47598.cljs$core$IFn$_invoke$arity$1 ? f_47598.cljs$core$IFn$_invoke$arity$1(tx_response_47576) : f_47598.call(null,tx_response_47576));
}catch (e47516){var e_47599 = e47516;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_47599,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__47600 = cljs.core.next(seq__47497_47590__$1);
var G__47601 = null;
var G__47602 = (0);
var G__47603 = (0);
seq__47497_47577 = G__47600;
chunk__47498_47578 = G__47601;
count__47499_47579 = G__47602;
i__47500_47580 = G__47603;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__47604 = seq__47453;
var G__47605 = chunk__47454;
var G__47606 = count__47455;
var G__47607 = (i__47456 + (1));
seq__47453 = G__47604;
chunk__47454 = G__47605;
count__47455 = G__47606;
i__47456 = G__47607;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__47453);
if(temp__5753__auto____$1){
var seq__47453__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__47453__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__47453__$1);
var G__47608 = cljs.core.chunk_rest(seq__47453__$1);
var G__47609 = c__4638__auto__;
var G__47610 = cljs.core.count(c__4638__auto__);
var G__47611 = (0);
seq__47453 = G__47608;
chunk__47454 = G__47609;
count__47455 = G__47610;
i__47456 = G__47611;
continue;
} else {
var tid = cljs.core.first(seq__47453__$1);
var temp__5753__auto___47612__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___47612__$2)){
var keyed_callbacks_47613 = temp__5753__auto___47612__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_47614 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__47517_47615 = cljs.core.seq(keyed_callbacks_47613);
var chunk__47518_47616 = null;
var count__47519_47617 = (0);
var i__47520_47618 = (0);
while(true){
if((i__47520_47618 < count__47519_47617)){
var vec__47529_47619 = chunk__47518_47616.cljs$core$IIndexed$_nth$arity$2(null,i__47520_47618);
var k_47620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47529_47619,(0),null);
var f_47621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47529_47619,(1),null);
try{(f_47621.cljs$core$IFn$_invoke$arity$1 ? f_47621.cljs$core$IFn$_invoke$arity$1(tx_response_47614) : f_47621.call(null,tx_response_47614));
}catch (e47532){var e_47622 = e47532;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_47622,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__47623 = seq__47517_47615;
var G__47624 = chunk__47518_47616;
var G__47625 = count__47519_47617;
var G__47626 = (i__47520_47618 + (1));
seq__47517_47615 = G__47623;
chunk__47518_47616 = G__47624;
count__47519_47617 = G__47625;
i__47520_47618 = G__47626;
continue;
} else {
var temp__5753__auto___47627__$3 = cljs.core.seq(seq__47517_47615);
if(temp__5753__auto___47627__$3){
var seq__47517_47628__$1 = temp__5753__auto___47627__$3;
if(cljs.core.chunked_seq_QMARK_(seq__47517_47628__$1)){
var c__4638__auto___47629 = cljs.core.chunk_first(seq__47517_47628__$1);
var G__47630 = cljs.core.chunk_rest(seq__47517_47628__$1);
var G__47631 = c__4638__auto___47629;
var G__47632 = cljs.core.count(c__4638__auto___47629);
var G__47633 = (0);
seq__47517_47615 = G__47630;
chunk__47518_47616 = G__47631;
count__47519_47617 = G__47632;
i__47520_47618 = G__47633;
continue;
} else {
var vec__47533_47634 = cljs.core.first(seq__47517_47628__$1);
var k_47635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47533_47634,(0),null);
var f_47636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47533_47634,(1),null);
try{(f_47636.cljs$core$IFn$_invoke$arity$1 ? f_47636.cljs$core$IFn$_invoke$arity$1(tx_response_47614) : f_47636.call(null,tx_response_47614));
}catch (e47536){var e_47637 = e47536;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_47637,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__47638 = cljs.core.next(seq__47517_47628__$1);
var G__47639 = null;
var G__47640 = (0);
var G__47641 = (0);
seq__47517_47615 = G__47638;
chunk__47518_47616 = G__47639;
count__47519_47617 = G__47640;
i__47520_47618 = G__47641;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__47642 = cljs.core.next(seq__47453__$1);
var G__47643 = null;
var G__47644 = (0);
var G__47645 = (0);
seq__47453 = G__47642;
chunk__47454 = G__47643;
count__47455 = G__47644;
i__47456 = G__47645;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__47448_47573 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__47448_47573.cljs$core$IFn$_invoke$arity$4 ? fexpr__47448_47573.cljs$core$IFn$_invoke$arity$4(G__47449_47569,G__47450_47570,G__47451_47571,G__47452_47572) : fexpr__47448_47573.call(null,G__47449_47569,G__47450_47570,G__47451_47571,G__47452_47572));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_47646 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__17304__auto___47647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47553){
var state_val_47554 = (state_47553[(1)]);
if((state_val_47554 === (1))){
var state_47553__$1 = state_47553;
var statearr_47555_47648 = state_47553__$1;
(statearr_47555_47648[(2)] = null);

(statearr_47555_47648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (2))){
var inst_47538 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_47553__$1 = state_47553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47553__$1,(4),inst_47538);
} else {
if((state_val_47554 === (3))){
var inst_47551 = (state_47553[(2)]);
var state_47553__$1 = state_47553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47553__$1,inst_47551);
} else {
if((state_val_47554 === (4))){
var inst_47540 = (state_47553[(7)]);
var inst_47540__$1 = (state_47553[(2)]);
var inst_47541 = (inst_47540__$1 == null);
var state_47553__$1 = (function (){var statearr_47556 = state_47553;
(statearr_47556[(7)] = inst_47540__$1);

return statearr_47556;
})();
if(cljs.core.truth_(inst_47541)){
var statearr_47557_47649 = state_47553__$1;
(statearr_47557_47649[(1)] = (5));

} else {
var statearr_47558_47650 = state_47553__$1;
(statearr_47558_47650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (5))){
var inst_47543 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_47544 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47543], 0));
var state_47553__$1 = state_47553;
var statearr_47559_47651 = state_47553__$1;
(statearr_47559_47651[(2)] = inst_47544);

(statearr_47559_47651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (6))){
var inst_47540 = (state_47553[(7)]);
var inst_47546 = (transact_handler_47646.cljs$core$IFn$_invoke$arity$2 ? transact_handler_47646.cljs$core$IFn$_invoke$arity$2(conn,inst_47540) : transact_handler_47646.call(null,conn,inst_47540));
var state_47553__$1 = (function (){var statearr_47560 = state_47553;
(statearr_47560[(8)] = inst_47546);

return statearr_47560;
})();
var statearr_47561_47652 = state_47553__$1;
(statearr_47561_47652[(2)] = null);

(statearr_47561_47652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47554 === (7))){
var inst_47549 = (state_47553[(2)]);
var state_47553__$1 = state_47553;
var statearr_47562_47653 = state_47553__$1;
(statearr_47562_47653[(2)] = inst_47549);

(statearr_47562_47653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__17178__auto__ = null;
var fluree$db$session$state_machine__17178__auto____0 = (function (){
var statearr_47563 = [null,null,null,null,null,null,null,null,null];
(statearr_47563[(0)] = fluree$db$session$state_machine__17178__auto__);

(statearr_47563[(1)] = (1));

return statearr_47563;
});
var fluree$db$session$state_machine__17178__auto____1 = (function (state_47553){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47553);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47564){var ex__17181__auto__ = e47564;
var statearr_47565_47654 = state_47553;
(statearr_47565_47654[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47553[(4)]))){
var statearr_47566_47655 = state_47553;
(statearr_47566_47655[(1)] = cljs.core.first((state_47553[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47656 = state_47553;
state_47553 = G__47656;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$session$state_machine__17178__auto__ = function(state_47553){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__17178__auto____1.call(this,state_47553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__17178__auto____0;
fluree$db$session$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__17178__auto____1;
return fluree$db$session$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47567 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47567[(6)] = c__17304__auto___47647);

return statearr_47567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__47658){
var map__47659 = p__47658;
var map__47659__$1 = cljs.core.__destructure_map(map__47659);
var session = map__47659__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47659__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__47657_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__47657_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__47657_SHARP_) + (1))], 0));
}));

var or__4212__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__47662 = arguments.length;
switch (G__47662) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__47663 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__47660_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__47660_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__47663);
} else {
return G__47663;
}
})();
var seq__47664 = cljs.core.seq(sessions);
var chunk__47665 = null;
var count__47666 = (0);
var i__47667 = (0);
while(true){
if((i__47667 < count__47666)){
var session = chunk__47665.cljs$core$IIndexed$_nth$arity$2(null,i__47667);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__47669 = seq__47664;
var G__47670 = chunk__47665;
var G__47671 = count__47666;
var G__47672 = (i__47667 + (1));
seq__47664 = G__47669;
chunk__47665 = G__47670;
count__47666 = G__47671;
i__47667 = G__47672;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__47664);
if(temp__5753__auto__){
var seq__47664__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47664__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__47664__$1);
var G__47673 = cljs.core.chunk_rest(seq__47664__$1);
var G__47674 = c__4638__auto__;
var G__47675 = cljs.core.count(c__4638__auto__);
var G__47676 = (0);
seq__47664 = G__47673;
chunk__47665 = G__47674;
count__47666 = G__47675;
i__47667 = G__47676;
continue;
} else {
var session = cljs.core.first(seq__47664__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__47677 = cljs.core.next(seq__47664__$1);
var G__47678 = null;
var G__47679 = (0);
var G__47680 = (0);
seq__47664 = G__47677;
chunk__47665 = G__47678;
count__47666 = G__47679;
i__47667 = G__47680;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
