// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_29639){
var state_val_29640 = (state_29639[(1)]);
if((state_val_29640 === (7))){
var inst_29634 = (state_29639[(2)]);
var _ = (function (){var statearr_29641 = state_29639;
(statearr_29641[(4)] = cljs.core.rest((state_29639[(4)])));

return statearr_29641;
})();
var state_29639__$1 = state_29639;
var statearr_29642_29664 = state_29639__$1;
(statearr_29642_29664[(2)] = inst_29634);

(statearr_29642_29664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (1))){
var state_29639__$1 = state_29639;
var statearr_29643_29665 = state_29639__$1;
(statearr_29643_29665[(2)] = null);

(statearr_29643_29665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (4))){
var inst_29596 = (state_29639[(2)]);
var state_29639__$1 = state_29639;
var statearr_29644_29666 = state_29639__$1;
(statearr_29644_29666[(2)] = inst_29596);

(statearr_29644_29666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (6))){
var inst_29614 = (state_29639[(7)]);
var inst_29621 = (state_29639[(8)]);
var inst_29620 = cljs.core.seq(inst_29614);
var inst_29621__$1 = cljs.core.first(inst_29620);
var inst_29622 = cljs.core.next(inst_29620);
var inst_29623 = cljs.core.not(inst_29621__$1);
var state_29639__$1 = (function (){var statearr_29645 = state_29639;
(statearr_29645[(9)] = inst_29622);

(statearr_29645[(8)] = inst_29621__$1);

return statearr_29645;
})();
if(inst_29623){
var statearr_29646_29667 = state_29639__$1;
(statearr_29646_29667[(1)] = (8));

} else {
var statearr_29647_29668 = state_29639__$1;
(statearr_29647_29668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (3))){
var inst_29637 = (state_29639[(2)]);
var state_29639__$1 = state_29639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29639__$1,inst_29637);
} else {
if((state_val_29640 === (2))){
var _ = (function (){var statearr_29648 = state_29639;
(statearr_29648[(4)] = cljs.core.cons((5),(state_29639[(4)])));

return statearr_29648;
})();
var inst_29609 = chs;
var inst_29610 = cljs.core.seq(inst_29609);
var inst_29611 = cljs.core.first(inst_29610);
var inst_29612 = cljs.core.next(inst_29610);
var inst_29613 = coll;
var inst_29614 = inst_29609;
var inst_29615 = inst_29613;
var state_29639__$1 = (function (){var statearr_29649 = state_29639;
(statearr_29649[(10)] = inst_29615);

(statearr_29649[(7)] = inst_29614);

(statearr_29649[(11)] = inst_29612);

(statearr_29649[(12)] = inst_29611);

return statearr_29649;
})();
var statearr_29650_29669 = state_29639__$1;
(statearr_29650_29669[(2)] = null);

(statearr_29650_29669[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (11))){
var inst_29615 = (state_29639[(10)]);
var inst_29622 = (state_29639[(9)]);
var inst_29627 = (state_29639[(2)]);
var inst_29628 = fluree.db.util.async.throw_err(inst_29627);
var inst_29629 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29615,inst_29628);
var inst_29614 = inst_29622;
var inst_29615__$1 = inst_29629;
var state_29639__$1 = (function (){var statearr_29652 = state_29639;
(statearr_29652[(10)] = inst_29615__$1);

(statearr_29652[(7)] = inst_29614);

return statearr_29652;
})();
var statearr_29653_29670 = state_29639__$1;
(statearr_29653_29670[(2)] = null);

(statearr_29653_29670[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (9))){
var inst_29621 = (state_29639[(8)]);
var state_29639__$1 = state_29639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29639__$1,(11),inst_29621);
} else {
if((state_val_29640 === (5))){
var _ = (function (){var statearr_29654 = state_29639;
(statearr_29654[(4)] = cljs.core.rest((state_29639[(4)])));

return statearr_29654;
})();
var state_29639__$1 = state_29639;
var ex29651 = (state_29639__$1[(2)]);
var statearr_29655_29671 = state_29639__$1;
(statearr_29655_29671[(5)] = ex29651);


var statearr_29656_29672 = state_29639__$1;
(statearr_29656_29672[(1)] = (4));

(statearr_29656_29672[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (10))){
var inst_29632 = (state_29639[(2)]);
var state_29639__$1 = state_29639;
var statearr_29657_29673 = state_29639__$1;
(statearr_29657_29673[(2)] = inst_29632);

(statearr_29657_29673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (8))){
var inst_29615 = (state_29639[(10)]);
var state_29639__$1 = state_29639;
var statearr_29658_29674 = state_29639__$1;
(statearr_29658_29674[(2)] = inst_29615);

(statearr_29658_29674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_29659 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29659[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__);

(statearr_29659[(1)] = (1));

return statearr_29659;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____1 = (function (state_29639){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_29639);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e29660){var ex__17181__auto__ = e29660;
var statearr_29661_29675 = state_29639;
(statearr_29661_29675[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_29639[(4)]))){
var statearr_29662_29676 = state_29639;
(statearr_29662_29676[(1)] = cljs.core.first((state_29639[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29677 = state_29639;
state_29639 = G__29677;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__ = function(state_29639){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____1.call(this,state_29639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_29663 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_29663[(6)] = c__17304__auto__);

return statearr_29663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_29703){
var state_val_29704 = (state_29703[(1)]);
if((state_val_29704 === (7))){
var inst_29698 = (state_29703[(2)]);
var _ = (function (){var statearr_29705 = state_29703;
(statearr_29705[(4)] = cljs.core.rest((state_29703[(4)])));

return statearr_29705;
})();
var state_29703__$1 = state_29703;
var statearr_29706_29728 = state_29703__$1;
(statearr_29706_29728[(2)] = inst_29698);

(statearr_29706_29728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (1))){
var state_29703__$1 = state_29703;
var statearr_29707_29729 = state_29703__$1;
(statearr_29707_29729[(2)] = null);

(statearr_29707_29729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (4))){
var inst_29678 = (state_29703[(2)]);
var state_29703__$1 = state_29703;
var statearr_29708_29730 = state_29703__$1;
(statearr_29708_29730[(2)] = inst_29678);

(statearr_29708_29730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (6))){
var state_29703__$1 = state_29703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29703__$1,(8),chan);
} else {
if((state_val_29704 === (3))){
var inst_29701 = (state_29703[(2)]);
var state_29703__$1 = state_29703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29703__$1,inst_29701);
} else {
if((state_val_29704 === (2))){
var _ = (function (){var statearr_29709 = state_29703;
(statearr_29709[(4)] = cljs.core.cons((5),(state_29703[(4)])));

return statearr_29709;
})();
var inst_29684 = coll;
var inst_29685 = inst_29684;
var state_29703__$1 = (function (){var statearr_29710 = state_29703;
(statearr_29710[(7)] = inst_29685);

return statearr_29710;
})();
var statearr_29711_29731 = state_29703__$1;
(statearr_29711_29731[(2)] = null);

(statearr_29711_29731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (11))){
var inst_29696 = (state_29703[(2)]);
var state_29703__$1 = state_29703;
var statearr_29713_29732 = state_29703__$1;
(statearr_29713_29732[(2)] = inst_29696);

(statearr_29713_29732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (9))){
var inst_29685 = (state_29703[(7)]);
var state_29703__$1 = state_29703;
var statearr_29714_29733 = state_29703__$1;
(statearr_29714_29733[(2)] = inst_29685);

(statearr_29714_29733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (5))){
var _ = (function (){var statearr_29715 = state_29703;
(statearr_29715[(4)] = cljs.core.rest((state_29703[(4)])));

return statearr_29715;
})();
var state_29703__$1 = state_29703;
var ex29712 = (state_29703__$1[(2)]);
var statearr_29716_29734 = state_29703__$1;
(statearr_29716_29734[(5)] = ex29712);


var statearr_29717_29735 = state_29703__$1;
(statearr_29717_29735[(1)] = (4));

(statearr_29717_29735[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (10))){
var inst_29685 = (state_29703[(7)]);
var inst_29689 = (state_29703[(8)]);
var inst_29693 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29685,inst_29689);
var inst_29685__$1 = inst_29693;
var state_29703__$1 = (function (){var statearr_29718 = state_29703;
(statearr_29718[(7)] = inst_29685__$1);

return statearr_29718;
})();
var statearr_29719_29736 = state_29703__$1;
(statearr_29719_29736[(2)] = null);

(statearr_29719_29736[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29704 === (8))){
var inst_29689 = (state_29703[(8)]);
var inst_29688 = (state_29703[(2)]);
var inst_29689__$1 = fluree.db.util.async.throw_err(inst_29688);
var inst_29690 = (inst_29689__$1 == null);
var state_29703__$1 = (function (){var statearr_29720 = state_29703;
(statearr_29720[(8)] = inst_29689__$1);

return statearr_29720;
})();
if(cljs.core.truth_(inst_29690)){
var statearr_29721_29737 = state_29703__$1;
(statearr_29721_29737[(1)] = (9));

} else {
var statearr_29722_29738 = state_29703__$1;
(statearr_29722_29738[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_29723 = [null,null,null,null,null,null,null,null,null];
(statearr_29723[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__);

(statearr_29723[(1)] = (1));

return statearr_29723;
});
var fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____1 = (function (state_29703){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_29703);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e29724){var ex__17181__auto__ = e29724;
var statearr_29725_29739 = state_29703;
(statearr_29725_29739[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_29703[(4)]))){
var statearr_29726_29740 = state_29703;
(statearr_29726_29740[(1)] = cljs.core.first((state_29703[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29741 = state_29703;
state_29703 = G__29741;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__ = function(state_29703){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____1.call(this,state_29703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__17178__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_29727 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_29727[(6)] = c__17304__auto__);

return statearr_29727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
