// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__87820 = opts_SINGLEQUOTE_;
var map__87820__$1 = cljs.core.__destructure_map(map__87820);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87820__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__87822 = arguments.length;
switch (G__87822) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__87825 = arguments.length;
switch (G__87825) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__87828 = arguments.length;
switch (G__87828) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__87831 = arguments.length;
switch (G__87831) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__87834 = arguments.length;
switch (G__87834) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__87837 = arguments.length;
switch (G__87837) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4824__auto__ = [];
var len__4818__auto___87846 = arguments.length;
var i__4819__auto___87847 = (0);
while(true){
if((i__4819__auto___87847 < len__4818__auto___87846)){
args__4824__auto__.push((arguments[i__4819__auto___87847]));

var G__87848 = (i__4819__auto___87847 + (1));
i__4819__auto___87847 = G__87848;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__87842){
var vec__87843 = p__87842;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87843,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq87839){
var G__87840 = cljs.core.first(seq87839);
var seq87839__$1 = cljs.core.next(seq87839);
var G__87841 = cljs.core.first(seq87839__$1);
var seq87839__$2 = cljs.core.next(seq87839__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__87840,G__87841,seq87839__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87867){
var state_val_87868 = (state_87867[(1)]);
if((state_val_87868 === (1))){
var state_87867__$1 = state_87867;
var statearr_87869_87884 = state_87867__$1;
(statearr_87869_87884[(2)] = null);

(statearr_87869_87884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87868 === (2))){
var _ = (function (){var statearr_87870 = state_87867;
(statearr_87870[(4)] = cljs.core.cons((5),(state_87867[(4)])));

return statearr_87870;
})();
var state_87867__$1 = state_87867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87867__$1,(6),db);
} else {
if((state_val_87868 === (3))){
var inst_87865 = (state_87867[(2)]);
var state_87867__$1 = state_87867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87867__$1,inst_87865);
} else {
if((state_val_87868 === (4))){
var inst_87849 = (state_87867[(2)]);
var inst_87850 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_87849], 0));
var inst_87851 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_87849) : reject.call(null,inst_87849));
var state_87867__$1 = (function (){var statearr_87872 = state_87867;
(statearr_87872[(7)] = inst_87850);

return statearr_87872;
})();
var statearr_87873_87885 = state_87867__$1;
(statearr_87873_87885[(2)] = inst_87851);

(statearr_87873_87885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87868 === (5))){
var _ = (function (){var statearr_87874 = state_87867;
(statearr_87874[(4)] = cljs.core.rest((state_87867[(4)])));

return statearr_87874;
})();
var state_87867__$1 = state_87867;
var ex87871 = (state_87867__$1[(2)]);
var statearr_87875_87886 = state_87867__$1;
(statearr_87875_87886[(5)] = ex87871);


var statearr_87876_87887 = state_87867__$1;
(statearr_87876_87887[(1)] = (4));

(statearr_87876_87887[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87868 === (6))){
var inst_87858 = (state_87867[(2)]);
var inst_87859 = fluree.db.util.async.throw_err(inst_87858);
var inst_87860 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_87859);
var inst_87861 = cljs.core.clj__GT_js(inst_87860);
var inst_87862 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_87861) : resolve.call(null,inst_87861));
var _ = (function (){var statearr_87877 = state_87867;
(statearr_87877[(4)] = cljs.core.rest((state_87867[(4)])));

return statearr_87877;
})();
var state_87867__$1 = state_87867;
var statearr_87878_87888 = state_87867__$1;
(statearr_87878_87888[(2)] = inst_87862);

(statearr_87878_87888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__17178__auto__ = null;
var flureedb$db_schema_$_state_machine__17178__auto____0 = (function (){
var statearr_87879 = [null,null,null,null,null,null,null,null];
(statearr_87879[(0)] = flureedb$db_schema_$_state_machine__17178__auto__);

(statearr_87879[(1)] = (1));

return statearr_87879;
});
var flureedb$db_schema_$_state_machine__17178__auto____1 = (function (state_87867){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87867);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e87880){var ex__17181__auto__ = e87880;
var statearr_87881_87889 = state_87867;
(statearr_87881_87889[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87867[(4)]))){
var statearr_87882_87890 = state_87867;
(statearr_87882_87890[(1)] = cljs.core.first((state_87867[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87891 = state_87867;
state_87867 = G__87891;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__17178__auto__ = function(state_87867){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__17178__auto____1.call(this,state_87867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__17178__auto____0;
flureedb$db_schema_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__17178__auto____1;
return flureedb$db_schema_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_87883 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_87883[(6)] = c__17304__auto__);

return statearr_87883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__87893 = arguments.length;
switch (G__87893) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_87963){
var state_val_87964 = (state_87963[(1)]);
if((state_val_87964 === (7))){
var inst_87906 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_87963__$1 = state_87963;
var statearr_87965_88010 = state_87963__$1;
(statearr_87965_88010[(2)] = inst_87906);

(statearr_87965_88010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (20))){
var inst_87914 = (state_87963[(7)]);
var inst_87938 = (state_87963[(2)]);
var state_87963__$1 = (function (){var statearr_87966 = state_87963;
(statearr_87966[(8)] = inst_87938);

return statearr_87966;
})();
if(cljs.core.truth_(inst_87914)){
var statearr_87967_88011 = state_87963__$1;
(statearr_87967_88011[(1)] = (21));

} else {
var statearr_87968_88012 = state_87963__$1;
(statearr_87968_88012[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (1))){
var state_87963__$1 = state_87963;
var statearr_87969_88013 = state_87963__$1;
(statearr_87969_88013[(2)] = null);

(statearr_87969_88013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (24))){
var inst_87945 = (state_87963[(2)]);
var inst_87946 = fluree.db.util.async.throw_err(inst_87945);
var state_87963__$1 = state_87963;
var statearr_87970_88014 = state_87963__$1;
(statearr_87970_88014[(2)] = inst_87946);

(statearr_87970_88014[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (4))){
var inst_87894 = (state_87963[(2)]);
var inst_87895 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_87894], 0));
var inst_87896 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_87894) : reject.call(null,inst_87894));
var state_87963__$1 = (function (){var statearr_87971 = state_87963;
(statearr_87971[(9)] = inst_87895);

return statearr_87971;
})();
var statearr_87972_88015 = state_87963__$1;
(statearr_87972_88015[(2)] = inst_87896);

(statearr_87972_88015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (15))){
var inst_87927 = (state_87963[(10)]);
var inst_87929 = fluree.db.util.core.without_nils(inst_87927);
var inst_87930 = fluree.db.util.json.stringify(inst_87929);
var state_87963__$1 = state_87963;
var statearr_87973_88016 = state_87963__$1;
(statearr_87973_88016[(2)] = inst_87930);

(statearr_87973_88016[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (21))){
var inst_87933 = (state_87963[(11)]);
var inst_87938 = (state_87963[(8)]);
var inst_87940 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_87941 = [inst_87933,inst_87938];
var inst_87942 = cljs.core.PersistentHashMap.fromArrays(inst_87940,inst_87941);
var inst_87943 = fluree.db.operations.command_async(conn,inst_87942);
var state_87963__$1 = state_87963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87963__$1,(24),inst_87943);
} else {
if((state_val_87964 === (13))){
var inst_87915 = (state_87963[(12)]);
var inst_87922 = (inst_87915 + (30000));
var state_87963__$1 = state_87963;
var statearr_87974_88017 = state_87963__$1;
(statearr_87974_88017[(2)] = inst_87922);

(statearr_87974_88017[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (22))){
var inst_87927 = (state_87963[(10)]);
var inst_87948 = fluree.db.operations.unsigned_command_async(conn,inst_87927);
var state_87963__$1 = state_87963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87963__$1,(25),inst_87948);
} else {
if((state_val_87964 === (6))){
var state_87963__$1 = state_87963;
var statearr_87975_88018 = state_87963__$1;
(statearr_87975_88018[(2)] = null);

(statearr_87975_88018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (25))){
var inst_87950 = (state_87963[(2)]);
var inst_87951 = fluree.db.util.async.throw_err(inst_87950);
var state_87963__$1 = state_87963;
var statearr_87976_88019 = state_87963__$1;
(statearr_87976_88019[(2)] = inst_87951);

(statearr_87976_88019[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (17))){
var inst_87914 = (state_87963[(7)]);
var inst_87933 = (state_87963[(2)]);
var state_87963__$1 = (function (){var statearr_87977 = state_87963;
(statearr_87977[(11)] = inst_87933);

return statearr_87977;
})();
if(cljs.core.truth_(inst_87914)){
var statearr_87978_88020 = state_87963__$1;
(statearr_87978_88020[(1)] = (18));

} else {
var statearr_87979_88021 = state_87963__$1;
(statearr_87979_88021[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (3))){
var inst_87961 = (state_87963[(2)]);
var state_87963__$1 = state_87963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87963__$1,inst_87961);
} else {
if((state_val_87964 === (12))){
var inst_87912 = (state_87963[(13)]);
var state_87963__$1 = state_87963;
var statearr_87980_88022 = state_87963__$1;
(statearr_87980_88022[(2)] = inst_87912);

(statearr_87980_88022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (2))){
var _ = (function (){var statearr_87981 = state_87963;
(statearr_87981[(4)] = cljs.core.cons((5),(state_87963[(4)])));

return statearr_87981;
})();
var inst_87903 = (opts == null);
var state_87963__$1 = state_87963;
if(cljs.core.truth_(inst_87903)){
var statearr_87982_88023 = state_87963__$1;
(statearr_87982_88023[(1)] = (6));

} else {
var statearr_87983_88024 = state_87963__$1;
(statearr_87983_88024[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (23))){
var inst_87953 = (state_87963[(2)]);
var inst_87954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_87955 = [(200),inst_87953];
var inst_87956 = cljs.core.PersistentHashMap.fromArrays(inst_87954,inst_87955);
var inst_87957 = cljs.core.clj__GT_js(inst_87956);
var inst_87958 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_87957) : resolve.call(null,inst_87957));
var _ = (function (){var statearr_87984 = state_87963;
(statearr_87984[(4)] = cljs.core.rest((state_87963[(4)])));

return statearr_87984;
})();
var state_87963__$1 = state_87963;
var statearr_87985_88025 = state_87963__$1;
(statearr_87985_88025[(2)] = inst_87958);

(statearr_87985_88025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (19))){
var state_87963__$1 = state_87963;
var statearr_87986_88026 = state_87963__$1;
(statearr_87986_88026[(2)] = null);

(statearr_87986_88026[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (11))){
var inst_87912 = (state_87963[(13)]);
var inst_87919 = (state_87963[(2)]);
var state_87963__$1 = (function (){var statearr_87988 = state_87963;
(statearr_87988[(14)] = inst_87919);

return statearr_87988;
})();
if(cljs.core.truth_(inst_87912)){
var statearr_87989_88027 = state_87963__$1;
(statearr_87989_88027[(1)] = (12));

} else {
var statearr_87990_88028 = state_87963__$1;
(statearr_87990_88028[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (9))){
var inst_87911 = (state_87963[(15)]);
var state_87963__$1 = state_87963;
var statearr_87991_88029 = state_87963__$1;
(statearr_87991_88029[(2)] = inst_87911);

(statearr_87991_88029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (5))){
var _ = (function (){var statearr_87992 = state_87963;
(statearr_87992[(4)] = cljs.core.rest((state_87963[(4)])));

return statearr_87992;
})();
var state_87963__$1 = state_87963;
var ex87987 = (state_87963__$1[(2)]);
var statearr_87993_88030 = state_87963__$1;
(statearr_87993_88030[(5)] = ex87987);


var statearr_87994_88031 = state_87963__$1;
(statearr_87994_88031[(1)] = (4));

(statearr_87994_88031[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (14))){
var inst_87919 = (state_87963[(14)]);
var inst_87914 = (state_87963[(7)]);
var inst_87924 = (state_87963[(2)]);
var inst_87925 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_87926 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_87919,inst_87924];
var inst_87927 = cljs.core.PersistentHashMap.fromArrays(inst_87925,inst_87926);
var state_87963__$1 = (function (){var statearr_87995 = state_87963;
(statearr_87995[(10)] = inst_87927);

return statearr_87995;
})();
if(cljs.core.truth_(inst_87914)){
var statearr_87996_88032 = state_87963__$1;
(statearr_87996_88032[(1)] = (15));

} else {
var statearr_87997_88033 = state_87963__$1;
(statearr_87997_88033[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (16))){
var state_87963__$1 = state_87963;
var statearr_87998_88034 = state_87963__$1;
(statearr_87998_88034[(2)] = null);

(statearr_87998_88034[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (10))){
var inst_87915 = (state_87963[(12)]);
var state_87963__$1 = state_87963;
var statearr_87999_88035 = state_87963__$1;
(statearr_87999_88035[(2)] = inst_87915);

(statearr_87999_88035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (18))){
var inst_87933 = (state_87963[(11)]);
var inst_87914 = (state_87963[(7)]);
var inst_87935 = fluree.crypto.sign_message(inst_87933,inst_87914);
var state_87963__$1 = state_87963;
var statearr_88000_88036 = state_87963__$1;
(statearr_88000_88036[(2)] = inst_87935);

(statearr_88000_88036[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87964 === (8))){
var inst_87911 = (state_87963[(15)]);
var inst_87908 = (state_87963[(2)]);
var inst_87909 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_87908);
var inst_87910 = cljs.core.__destructure_map(inst_87908);
var inst_87911__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_87910,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_87912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_87910,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_87913 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_87910,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_87914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_87910,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_87915 = fluree.db.util.core.current_time_millis();
var state_87963__$1 = (function (){var statearr_88001 = state_87963;
(statearr_88001[(12)] = inst_87915);

(statearr_88001[(16)] = inst_87913);

(statearr_88001[(13)] = inst_87912);

(statearr_88001[(17)] = inst_87909);

(statearr_88001[(7)] = inst_87914);

(statearr_88001[(15)] = inst_87911__$1);

return statearr_88001;
})();
if(cljs.core.truth_(inst_87911__$1)){
var statearr_88002_88037 = state_87963__$1;
(statearr_88002_88037[(1)] = (9));

} else {
var statearr_88003_88038 = state_87963__$1;
(statearr_88003_88038[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88004 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88004[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88004[(1)] = (1));

return statearr_88004;
});
var flureedb$state_machine__17178__auto____1 = (function (state_87963){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_87963);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88005){var ex__17181__auto__ = e88005;
var statearr_88006_88039 = state_87963;
(statearr_88006_88039[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_87963[(4)]))){
var statearr_88007_88040 = state_87963;
(statearr_88007_88040[(1)] = cljs.core.first((state_87963[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88041 = state_87963;
state_87963 = G__88041;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_87963){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_87963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88008 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88008[(6)] = c__17304__auto__);

return statearr_88008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88060){
var state_val_88061 = (state_88060[(1)]);
if((state_val_88061 === (1))){
var state_88060__$1 = state_88060;
var statearr_88062_88077 = state_88060__$1;
(statearr_88062_88077[(2)] = null);

(statearr_88062_88077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88061 === (2))){
var _ = (function (){var statearr_88063 = state_88060;
(statearr_88063[(4)] = cljs.core.cons((5),(state_88060[(4)])));

return statearr_88063;
})();
var inst_88050 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_88060__$1 = state_88060;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88060__$1,(6),inst_88050);
} else {
if((state_val_88061 === (3))){
var inst_88058 = (state_88060[(2)]);
var state_88060__$1 = state_88060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88060__$1,inst_88058);
} else {
if((state_val_88061 === (4))){
var inst_88042 = (state_88060[(2)]);
var inst_88043 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88042], 0));
var inst_88044 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88042) : reject.call(null,inst_88042));
var state_88060__$1 = (function (){var statearr_88065 = state_88060;
(statearr_88065[(7)] = inst_88043);

return statearr_88065;
})();
var statearr_88066_88078 = state_88060__$1;
(statearr_88066_88078[(2)] = inst_88044);

(statearr_88066_88078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88061 === (5))){
var _ = (function (){var statearr_88067 = state_88060;
(statearr_88067[(4)] = cljs.core.rest((state_88060[(4)])));

return statearr_88067;
})();
var state_88060__$1 = state_88060;
var ex88064 = (state_88060__$1[(2)]);
var statearr_88068_88079 = state_88060__$1;
(statearr_88068_88079[(5)] = ex88064);


var statearr_88069_88080 = state_88060__$1;
(statearr_88069_88080[(1)] = (4));

(statearr_88069_88080[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88061 === (6))){
var inst_88052 = (state_88060[(2)]);
var inst_88053 = fluree.db.util.async.throw_err(inst_88052);
var inst_88054 = cljs.core.clj__GT_js(inst_88053);
var inst_88055 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88054) : resolve.call(null,inst_88054));
var _ = (function (){var statearr_88070 = state_88060;
(statearr_88070[(4)] = cljs.core.rest((state_88060[(4)])));

return statearr_88070;
})();
var state_88060__$1 = state_88060;
var statearr_88071_88081 = state_88060__$1;
(statearr_88071_88081[(2)] = inst_88055);

(statearr_88071_88081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__17178__auto__ = null;
var flureedb$ledger_stats_$_state_machine__17178__auto____0 = (function (){
var statearr_88072 = [null,null,null,null,null,null,null,null];
(statearr_88072[(0)] = flureedb$ledger_stats_$_state_machine__17178__auto__);

(statearr_88072[(1)] = (1));

return statearr_88072;
});
var flureedb$ledger_stats_$_state_machine__17178__auto____1 = (function (state_88060){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88060);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88073){var ex__17181__auto__ = e88073;
var statearr_88074_88082 = state_88060;
(statearr_88074_88082[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88060[(4)]))){
var statearr_88075_88083 = state_88060;
(statearr_88075_88083[(1)] = cljs.core.first((state_88060[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88084 = state_88060;
state_88060 = G__88084;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__17178__auto__ = function(state_88060){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__17178__auto____1.call(this,state_88060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__17178__auto____0;
flureedb$ledger_stats_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__17178__auto____1;
return flureedb$ledger_stats_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88076 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88076[(6)] = c__17304__auto__);

return statearr_88076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__88086 = arguments.length;
switch (G__88086) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88210){
var state_val_88211 = (state_88210[(1)]);
if((state_val_88211 === (7))){
var inst_88109 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88210__$1 = state_88210;
var statearr_88212_88282 = state_88210__$1;
(statearr_88212_88282[(2)] = inst_88109);

(statearr_88212_88282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (20))){
var inst_88116 = (state_88210[(7)]);
var inst_88155 = (state_88210[(2)]);
var inst_88156 = fluree.db.util.core.current_time_millis();
var state_88210__$1 = (function (){var statearr_88213 = state_88210;
(statearr_88213[(8)] = inst_88156);

(statearr_88213[(9)] = inst_88155);

return statearr_88213;
})();
if(cljs.core.truth_(inst_88116)){
var statearr_88214_88283 = state_88210__$1;
(statearr_88214_88283[(1)] = (21));

} else {
var statearr_88215_88284 = state_88210__$1;
(statearr_88215_88284[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (27))){
var inst_88169 = (state_88210[(10)]);
var inst_88124 = (state_88210[(11)]);
var inst_88171 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_88169,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_88124);
var state_88210__$1 = state_88210;
var statearr_88216_88285 = state_88210__$1;
(statearr_88216_88285[(2)] = inst_88171);

(statearr_88216_88285[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (1))){
var state_88210__$1 = state_88210;
var statearr_88217_88286 = state_88210__$1;
(statearr_88217_88286[(2)] = null);

(statearr_88217_88286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (24))){
var inst_88122 = (state_88210[(12)]);
var state_88210__$1 = state_88210;
var statearr_88218_88287 = state_88210__$1;
(statearr_88218_88287[(2)] = inst_88122);

(statearr_88218_88287[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (39))){
var inst_88192 = (state_88210[(2)]);
var inst_88193 = fluree.db.util.async.throw_err(inst_88192);
var state_88210__$1 = state_88210;
var statearr_88219_88288 = state_88210__$1;
(statearr_88219_88288[(2)] = inst_88193);

(statearr_88219_88288[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (4))){
var inst_88087 = (state_88210[(2)]);
var inst_88088 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88087], 0));
var inst_88089 = cljs.core.ex_data(inst_88087);
var inst_88090 = cljs.core.ex_message(inst_88087);
var inst_88091 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_88089,new cljs.core.Keyword(null,"message","message",-406056002),inst_88090);
var inst_88092 = cljs.core.clj__GT_js(inst_88091);
var inst_88093 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88092) : reject.call(null,inst_88092));
var state_88210__$1 = (function (){var statearr_88220 = state_88210;
(statearr_88220[(13)] = inst_88088);

return statearr_88220;
})();
var statearr_88221_88289 = state_88210__$1;
(statearr_88221_88289[(2)] = inst_88093);

(statearr_88221_88289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (15))){
var inst_88145 = (state_88210[(14)]);
var inst_88147 = fluree.db.graphdb.validate_ledger_name(inst_88145,"alias");
var state_88210__$1 = state_88210;
var statearr_88222_88290 = state_88210__$1;
(statearr_88222_88290[(2)] = inst_88147);

(statearr_88222_88290[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (21))){
var inst_88116 = (state_88210[(7)]);
var state_88210__$1 = state_88210;
var statearr_88223_88291 = state_88210__$1;
(statearr_88223_88291[(2)] = inst_88116);

(statearr_88223_88291[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (31))){
var state_88210__$1 = state_88210;
var statearr_88224_88292 = state_88210__$1;
(statearr_88224_88292[(2)] = null);

(statearr_88224_88292[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (32))){
var inst_88118 = (state_88210[(15)]);
var inst_88180 = (state_88210[(2)]);
var state_88210__$1 = (function (){var statearr_88225 = state_88210;
(statearr_88225[(16)] = inst_88180);

return statearr_88225;
})();
if(cljs.core.truth_(inst_88118)){
var statearr_88226_88293 = state_88210__$1;
(statearr_88226_88293[(1)] = (33));

} else {
var statearr_88227_88294 = state_88210__$1;
(statearr_88227_88294[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (40))){
var inst_88197 = (state_88210[(2)]);
var inst_88198 = fluree.db.util.async.throw_err(inst_88197);
var state_88210__$1 = state_88210;
var statearr_88228_88295 = state_88210__$1;
(statearr_88228_88295[(2)] = inst_88198);

(statearr_88228_88295[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (33))){
var inst_88118 = (state_88210[(15)]);
var inst_88180 = (state_88210[(16)]);
var inst_88182 = fluree.crypto.sign_message(inst_88180,inst_88118);
var state_88210__$1 = state_88210;
var statearr_88229_88296 = state_88210__$1;
(statearr_88229_88296[(2)] = inst_88182);

(statearr_88229_88296[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (13))){
var state_88210__$1 = state_88210;
var statearr_88230_88297 = state_88210__$1;
(statearr_88230_88297[(2)] = null);

(statearr_88230_88297[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (22))){
var inst_88156 = (state_88210[(8)]);
var state_88210__$1 = state_88210;
var statearr_88231_88298 = state_88210__$1;
(statearr_88231_88298[(2)] = inst_88156);

(statearr_88231_88298[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (36))){
var inst_88185 = (state_88210[(17)]);
var inst_88180 = (state_88210[(16)]);
var inst_88187 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_88188 = [inst_88180,inst_88185];
var inst_88189 = cljs.core.PersistentHashMap.fromArrays(inst_88187,inst_88188);
var inst_88190 = fluree.db.operations.command_async(conn,inst_88189);
var state_88210__$1 = state_88210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88210__$1,(39),inst_88190);
} else {
if((state_val_88211 === (29))){
var inst_88118 = (state_88210[(15)]);
var inst_88174 = (state_88210[(2)]);
var state_88210__$1 = (function (){var statearr_88232 = state_88210;
(statearr_88232[(18)] = inst_88174);

return statearr_88232;
})();
if(cljs.core.truth_(inst_88118)){
var statearr_88233_88299 = state_88210__$1;
(statearr_88233_88299[(1)] = (30));

} else {
var statearr_88234_88300 = state_88210__$1;
(statearr_88234_88300[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (6))){
var state_88210__$1 = state_88210;
var statearr_88235_88301 = state_88210__$1;
(statearr_88235_88301[(2)] = null);

(statearr_88235_88301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (28))){
var inst_88169 = (state_88210[(10)]);
var state_88210__$1 = state_88210;
var statearr_88236_88302 = state_88210__$1;
(statearr_88236_88302[(2)] = inst_88169);

(statearr_88236_88302[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (25))){
var inst_88156 = (state_88210[(8)]);
var inst_88163 = (inst_88156 + (30000));
var state_88210__$1 = state_88210;
var statearr_88237_88303 = state_88210__$1;
(statearr_88237_88303[(2)] = inst_88163);

(statearr_88237_88303[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (34))){
var state_88210__$1 = state_88210;
var statearr_88238_88304 = state_88210__$1;
(statearr_88238_88304[(2)] = null);

(statearr_88238_88304[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (17))){
var inst_88126 = (state_88210[(19)]);
var inst_88150 = (state_88210[(2)]);
var state_88210__$1 = (function (){var statearr_88239 = state_88210;
(statearr_88239[(20)] = inst_88150);

return statearr_88239;
})();
if(cljs.core.truth_(inst_88126)){
var statearr_88240_88305 = state_88210__$1;
(statearr_88240_88305[(1)] = (18));

} else {
var statearr_88241_88306 = state_88210__$1;
(statearr_88241_88306[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (3))){
var inst_88208 = (state_88210[(2)]);
var state_88210__$1 = state_88210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88210__$1,inst_88208);
} else {
if((state_val_88211 === (12))){
var inst_88140 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_88210__$1 = state_88210;
var statearr_88242_88307 = state_88210__$1;
(statearr_88242_88307[(2)] = inst_88140);

(statearr_88242_88307[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (2))){
var _ = (function (){var statearr_88243 = state_88210;
(statearr_88243[(4)] = cljs.core.cons((5),(state_88210[(4)])));

return statearr_88243;
})();
var inst_88106 = (opts == null);
var state_88210__$1 = state_88210;
if(cljs.core.truth_(inst_88106)){
var statearr_88244_88308 = state_88210__$1;
(statearr_88244_88308[(1)] = (6));

} else {
var statearr_88245_88309 = state_88210__$1;
(statearr_88245_88309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (23))){
var inst_88122 = (state_88210[(12)]);
var inst_88160 = (state_88210[(2)]);
var state_88210__$1 = (function (){var statearr_88246 = state_88210;
(statearr_88246[(21)] = inst_88160);

return statearr_88246;
})();
if(cljs.core.truth_(inst_88122)){
var statearr_88247_88310 = state_88210__$1;
(statearr_88247_88310[(1)] = (24));

} else {
var statearr_88248_88311 = state_88210__$1;
(statearr_88248_88311[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (35))){
var inst_88118 = (state_88210[(15)]);
var inst_88185 = (state_88210[(2)]);
var state_88210__$1 = (function (){var statearr_88249 = state_88210;
(statearr_88249[(17)] = inst_88185);

return statearr_88249;
})();
if(cljs.core.truth_(inst_88118)){
var statearr_88250_88312 = state_88210__$1;
(statearr_88250_88312[(1)] = (36));

} else {
var statearr_88251_88313 = state_88210__$1;
(statearr_88251_88313[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (19))){
var state_88210__$1 = state_88210;
var statearr_88252_88314 = state_88210__$1;
(statearr_88252_88314[(2)] = null);

(statearr_88252_88314[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (11))){
var inst_88129 = (state_88210[(22)]);
var inst_88136 = (state_88210[(23)]);
var inst_88126 = (state_88210[(19)]);
var inst_88136__$1 = (state_88210[(2)]);
var inst_88137 = fluree.db.graphdb.validate_ledger_name(inst_88136__$1,"ledger");
var inst_88138 = fluree.db.graphdb.validate_ledger_name(inst_88129,"network");
var state_88210__$1 = (function (){var statearr_88254 = state_88210;
(statearr_88254[(23)] = inst_88136__$1);

(statearr_88254[(24)] = inst_88137);

(statearr_88254[(25)] = inst_88138);

return statearr_88254;
})();
if(cljs.core.truth_(inst_88126)){
var statearr_88255_88315 = state_88210__$1;
(statearr_88255_88315[(1)] = (12));

} else {
var statearr_88256_88316 = state_88210__$1;
(statearr_88256_88316[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (9))){
var inst_88130 = (state_88210[(26)]);
var inst_88133 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_88130,(1));
var state_88210__$1 = state_88210;
var statearr_88257_88317 = state_88210__$1;
(statearr_88257_88317[(2)] = inst_88133);

(statearr_88257_88317[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (5))){
var _ = (function (){var statearr_88258 = state_88210;
(statearr_88258[(4)] = cljs.core.rest((state_88210[(4)])));

return statearr_88258;
})();
var state_88210__$1 = state_88210;
var ex88253 = (state_88210__$1[(2)]);
var statearr_88259_88318 = state_88210__$1;
(statearr_88259_88318[(5)] = ex88253);


var statearr_88260_88319 = state_88210__$1;
(statearr_88260_88319[(1)] = (4));

(statearr_88260_88319[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (14))){
var inst_88126 = (state_88210[(19)]);
var inst_88143 = (state_88210[(2)]);
var inst_88144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88143,(0),null);
var inst_88145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88143,(1),null);
var state_88210__$1 = (function (){var statearr_88261 = state_88210;
(statearr_88261[(27)] = inst_88144);

(statearr_88261[(14)] = inst_88145);

return statearr_88261;
})();
if(cljs.core.truth_(inst_88126)){
var statearr_88262_88320 = state_88210__$1;
(statearr_88262_88320[(1)] = (15));

} else {
var statearr_88263_88321 = state_88210__$1;
(statearr_88263_88321[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (26))){
var inst_88125 = (state_88210[(28)]);
var inst_88129 = (state_88210[(22)]);
var inst_88119 = (state_88210[(29)]);
var inst_88136 = (state_88210[(23)]);
var inst_88127 = (state_88210[(30)]);
var inst_88120 = (state_88210[(31)]);
var inst_88117 = (state_88210[(32)]);
var inst_88155 = (state_88210[(9)]);
var inst_88124 = (state_88210[(11)]);
var inst_88121 = (state_88210[(33)]);
var inst_88115 = (state_88210[(34)]);
var inst_88160 = (state_88210[(21)]);
var inst_88123 = (state_88210[(35)]);
var inst_88165 = (state_88210[(2)]);
var inst_88166 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_88167 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88129),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88136)].join('');
var inst_88168 = [inst_88120,inst_88121,inst_88167,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_88165,inst_88123,inst_88155,inst_88127,inst_88125,inst_88115,inst_88160,inst_88117,inst_88119];
var inst_88169 = cljs.core.PersistentHashMap.fromArrays(inst_88166,inst_88168);
var state_88210__$1 = (function (){var statearr_88264 = state_88210;
(statearr_88264[(10)] = inst_88169);

return statearr_88264;
})();
if(cljs.core.truth_(inst_88124)){
var statearr_88265_88322 = state_88210__$1;
(statearr_88265_88322[(1)] = (27));

} else {
var statearr_88266_88323 = state_88210__$1;
(statearr_88266_88323[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (16))){
var state_88210__$1 = state_88210;
var statearr_88267_88324 = state_88210__$1;
(statearr_88267_88324[(2)] = null);

(statearr_88267_88324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (38))){
var inst_88200 = (state_88210[(2)]);
var inst_88201 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_88202 = [(200),inst_88200];
var inst_88203 = cljs.core.PersistentHashMap.fromArrays(inst_88201,inst_88202);
var inst_88204 = cljs.core.clj__GT_js(inst_88203);
var inst_88205 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88204) : resolve.call(null,inst_88204));
var _ = (function (){var statearr_88268 = state_88210;
(statearr_88268[(4)] = cljs.core.rest((state_88210[(4)])));

return statearr_88268;
})();
var state_88210__$1 = state_88210;
var statearr_88269_88325 = state_88210__$1;
(statearr_88269_88325[(2)] = inst_88205);

(statearr_88269_88325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (30))){
var inst_88174 = (state_88210[(18)]);
var inst_88176 = fluree.db.util.core.without_nils(inst_88174);
var inst_88177 = fluree.db.util.json.stringify(inst_88176);
var state_88210__$1 = state_88210;
var statearr_88270_88326 = state_88210__$1;
(statearr_88270_88326[(2)] = inst_88177);

(statearr_88270_88326[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (10))){
var inst_88130 = (state_88210[(26)]);
var state_88210__$1 = state_88210;
var statearr_88271_88327 = state_88210__$1;
(statearr_88271_88327[(2)] = inst_88130);

(statearr_88271_88327[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (18))){
var inst_88144 = (state_88210[(27)]);
var inst_88145 = (state_88210[(14)]);
var inst_88152 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88144),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_88145)].join('');
var state_88210__$1 = state_88210;
var statearr_88272_88328 = state_88210__$1;
(statearr_88272_88328[(2)] = inst_88152);

(statearr_88272_88328[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88211 === (37))){
var inst_88174 = (state_88210[(18)]);
var inst_88195 = fluree.db.operations.unsigned_command_async(conn,inst_88174);
var state_88210__$1 = state_88210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88210__$1,(40),inst_88195);
} else {
if((state_val_88211 === (8))){
var inst_88130 = (state_88210[(26)]);
var inst_88111 = (state_88210[(2)]);
var inst_88112 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_88111);
var inst_88113 = cljs.core.__destructure_map(inst_88111);
var inst_88114 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_88113,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_88115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_88116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_88117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_88118 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_88119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_88120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_88121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_88122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_88123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_88124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_88125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_88126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_88127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88113,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_88128 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_88129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88128,(0),null);
var inst_88130__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88128,(1),null);
var inst_88131 = clojure.string.starts_with_QMARK_(inst_88130__$1,"$");
var state_88210__$1 = (function (){var statearr_88273 = state_88210;
(statearr_88273[(36)] = inst_88112);

(statearr_88273[(28)] = inst_88125);

(statearr_88273[(7)] = inst_88116);

(statearr_88273[(12)] = inst_88122);

(statearr_88273[(22)] = inst_88129);

(statearr_88273[(29)] = inst_88119);

(statearr_88273[(37)] = inst_88114);

(statearr_88273[(30)] = inst_88127);

(statearr_88273[(26)] = inst_88130__$1);

(statearr_88273[(19)] = inst_88126);

(statearr_88273[(31)] = inst_88120);

(statearr_88273[(32)] = inst_88117);

(statearr_88273[(15)] = inst_88118);

(statearr_88273[(11)] = inst_88124);

(statearr_88273[(33)] = inst_88121);

(statearr_88273[(34)] = inst_88115);

(statearr_88273[(35)] = inst_88123);

return statearr_88273;
})();
if(inst_88131){
var statearr_88274_88329 = state_88210__$1;
(statearr_88274_88329[(1)] = (9));

} else {
var statearr_88275_88330 = state_88210__$1;
(statearr_88275_88330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88276[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88276[(1)] = (1));

return statearr_88276;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88210){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88210);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88277){var ex__17181__auto__ = e88277;
var statearr_88278_88331 = state_88210;
(statearr_88278_88331[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88210[(4)]))){
var statearr_88279_88332 = state_88210;
(statearr_88279_88332[(1)] = cljs.core.first((state_88210[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88333 = state_88210;
state_88210 = G__88333;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88210){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88280 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88280[(6)] = c__17304__auto__);

return statearr_88280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88353){
var state_val_88354 = (state_88353[(1)]);
if((state_val_88354 === (1))){
var state_88353__$1 = state_88353;
var statearr_88355_88371 = state_88353__$1;
(statearr_88355_88371[(2)] = null);

(statearr_88355_88371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88354 === (2))){
var _ = (function (){var statearr_88356 = state_88353;
(statearr_88356[(4)] = cljs.core.cons((5),(state_88353[(4)])));

return statearr_88356;
})();
var inst_88343 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_88344 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_88353__$1 = (function (){var statearr_88357 = state_88353;
(statearr_88357[(7)] = inst_88343);

return statearr_88357;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88353__$1,(6),inst_88344);
} else {
if((state_val_88354 === (3))){
var inst_88351 = (state_88353[(2)]);
var state_88353__$1 = state_88353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88353__$1,inst_88351);
} else {
if((state_val_88354 === (4))){
var inst_88334 = (state_88353[(2)]);
var inst_88335 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88334], 0));
var inst_88336 = cljs.core.clj__GT_js(inst_88334);
var inst_88337 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88336) : reject.call(null,inst_88336));
var state_88353__$1 = (function (){var statearr_88359 = state_88353;
(statearr_88359[(8)] = inst_88335);

return statearr_88359;
})();
var statearr_88360_88372 = state_88353__$1;
(statearr_88360_88372[(2)] = inst_88337);

(statearr_88360_88372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88354 === (5))){
var _ = (function (){var statearr_88361 = state_88353;
(statearr_88361[(4)] = cljs.core.rest((state_88353[(4)])));

return statearr_88361;
})();
var state_88353__$1 = state_88353;
var ex88358 = (state_88353__$1[(2)]);
var statearr_88362_88373 = state_88353__$1;
(statearr_88362_88373[(5)] = ex88358);


var statearr_88363_88374 = state_88353__$1;
(statearr_88363_88374[(1)] = (4));

(statearr_88363_88374[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88354 === (6))){
var inst_88346 = (state_88353[(2)]);
var inst_88347 = cljs.core.clj__GT_js(inst_88346);
var inst_88348 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88347) : resolve.call(null,inst_88347));
var _ = (function (){var statearr_88364 = state_88353;
(statearr_88364[(4)] = cljs.core.rest((state_88353[(4)])));

return statearr_88364;
})();
var state_88353__$1 = state_88353;
var statearr_88365_88375 = state_88353__$1;
(statearr_88365_88375[(2)] = inst_88348);

(statearr_88365_88375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__17178__auto__ = null;
var flureedb$monitor_tx_$_state_machine__17178__auto____0 = (function (){
var statearr_88366 = [null,null,null,null,null,null,null,null,null];
(statearr_88366[(0)] = flureedb$monitor_tx_$_state_machine__17178__auto__);

(statearr_88366[(1)] = (1));

return statearr_88366;
});
var flureedb$monitor_tx_$_state_machine__17178__auto____1 = (function (state_88353){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88353);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88367){var ex__17181__auto__ = e88367;
var statearr_88368_88376 = state_88353;
(statearr_88368_88376[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88353[(4)]))){
var statearr_88369_88377 = state_88353;
(statearr_88369_88377[(1)] = cljs.core.first((state_88353[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88378 = state_88353;
state_88353 = G__88378;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__17178__auto__ = function(state_88353){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__17178__auto____1.call(this,state_88353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__17178__auto____0;
flureedb$monitor_tx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__17178__auto____1;
return flureedb$monitor_tx_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88370 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88370[(6)] = c__17304__auto__);

return statearr_88370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__88380 = arguments.length;
switch (G__88380) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88406){
var state_val_88407 = (state_88406[(1)]);
if((state_val_88407 === (7))){
var inst_88392 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88406__$1 = state_88406;
var statearr_88408_88429 = state_88406__$1;
(statearr_88408_88429[(2)] = inst_88392);

(statearr_88408_88429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (1))){
var state_88406__$1 = state_88406;
var statearr_88409_88430 = state_88406__$1;
(statearr_88409_88430[(2)] = null);

(statearr_88409_88430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (4))){
var inst_88381 = (state_88406[(2)]);
var inst_88382 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88381], 0));
var inst_88383 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88381) : reject.call(null,inst_88381));
var state_88406__$1 = (function (){var statearr_88410 = state_88406;
(statearr_88410[(7)] = inst_88382);

return statearr_88410;
})();
var statearr_88411_88431 = state_88406__$1;
(statearr_88411_88431[(2)] = inst_88383);

(statearr_88411_88431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (6))){
var state_88406__$1 = state_88406;
var statearr_88412_88432 = state_88406__$1;
(statearr_88412_88432[(2)] = null);

(statearr_88412_88432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (3))){
var inst_88404 = (state_88406[(2)]);
var state_88406__$1 = state_88406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88406__$1,inst_88404);
} else {
if((state_val_88407 === (2))){
var _ = (function (){var statearr_88414 = state_88406;
(statearr_88414[(4)] = cljs.core.cons((5),(state_88406[(4)])));

return statearr_88414;
})();
var inst_88389 = (opts == null);
var state_88406__$1 = state_88406;
if(cljs.core.truth_(inst_88389)){
var statearr_88415_88433 = state_88406__$1;
(statearr_88415_88433[(1)] = (6));

} else {
var statearr_88416_88434 = state_88406__$1;
(statearr_88416_88434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (9))){
var inst_88399 = (state_88406[(2)]);
var inst_88400 = cljs.core.clj__GT_js(inst_88399);
var inst_88401 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88400) : resolve.call(null,inst_88400));
var _ = (function (){var statearr_88417 = state_88406;
(statearr_88417[(4)] = cljs.core.rest((state_88406[(4)])));

return statearr_88417;
})();
var state_88406__$1 = state_88406;
var statearr_88418_88435 = state_88406__$1;
(statearr_88418_88435[(2)] = inst_88401);

(statearr_88418_88435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (5))){
var _ = (function (){var statearr_88419 = state_88406;
(statearr_88419[(4)] = cljs.core.rest((state_88406[(4)])));

return statearr_88419;
})();
var state_88406__$1 = state_88406;
var ex88413 = (state_88406__$1[(2)]);
var statearr_88420_88436 = state_88406__$1;
(statearr_88420_88436[(5)] = ex88413);


var statearr_88421_88437 = state_88406__$1;
(statearr_88421_88437[(1)] = (4));

(statearr_88421_88437[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88407 === (8))){
var inst_88394 = (state_88406[(2)]);
var inst_88395 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_88394);
var inst_88396 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88397 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_88396,inst_88394);
var state_88406__$1 = (function (){var statearr_88422 = state_88406;
(statearr_88422[(8)] = inst_88395);

return statearr_88422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88406__$1,(9),inst_88397);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88423 = [null,null,null,null,null,null,null,null,null];
(statearr_88423[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88423[(1)] = (1));

return statearr_88423;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88406){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88406);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88424){var ex__17181__auto__ = e88424;
var statearr_88425_88438 = state_88406;
(statearr_88425_88438[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88406[(4)]))){
var statearr_88426_88439 = state_88406;
(statearr_88426_88439[(1)] = cljs.core.first((state_88406[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88440 = state_88406;
state_88406 = G__88440;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88406){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88427 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88427[(6)] = c__17304__auto__);

return statearr_88427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__88442 = arguments.length;
switch (G__88442) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88471){
var state_val_88472 = (state_88471[(1)]);
if((state_val_88472 === (7))){
var inst_88454 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88471__$1 = state_88471;
var statearr_88473_88494 = state_88471__$1;
(statearr_88473_88494[(2)] = inst_88454);

(statearr_88473_88494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (1))){
var state_88471__$1 = state_88471;
var statearr_88474_88495 = state_88471__$1;
(statearr_88474_88495[(2)] = null);

(statearr_88474_88495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (4))){
var inst_88443 = (state_88471[(2)]);
var inst_88444 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88443], 0));
var inst_88445 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88443) : reject.call(null,inst_88443));
var state_88471__$1 = (function (){var statearr_88475 = state_88471;
(statearr_88475[(7)] = inst_88444);

return statearr_88475;
})();
var statearr_88476_88496 = state_88471__$1;
(statearr_88476_88496[(2)] = inst_88445);

(statearr_88476_88496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (6))){
var state_88471__$1 = state_88471;
var statearr_88477_88497 = state_88471__$1;
(statearr_88477_88497[(2)] = null);

(statearr_88477_88497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (3))){
var inst_88469 = (state_88471[(2)]);
var state_88471__$1 = state_88471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88471__$1,inst_88469);
} else {
if((state_val_88472 === (2))){
var _ = (function (){var statearr_88479 = state_88471;
(statearr_88479[(4)] = cljs.core.cons((5),(state_88471[(4)])));

return statearr_88479;
})();
var inst_88451 = (opts == null);
var state_88471__$1 = state_88471;
if(cljs.core.truth_(inst_88451)){
var statearr_88480_88498 = state_88471__$1;
(statearr_88480_88498[(1)] = (6));

} else {
var statearr_88481_88499 = state_88471__$1;
(statearr_88481_88499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (9))){
var inst_88456 = (state_88471[(8)]);
var inst_88459 = (state_88471[(2)]);
var inst_88460 = fluree.db.util.async.throw_err(inst_88459);
var inst_88461 = fluree.db.query.block.block_range(inst_88460,start,end,inst_88456);
var state_88471__$1 = state_88471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88471__$1,(10),inst_88461);
} else {
if((state_val_88472 === (5))){
var _ = (function (){var statearr_88482 = state_88471;
(statearr_88482[(4)] = cljs.core.rest((state_88471[(4)])));

return statearr_88482;
})();
var state_88471__$1 = state_88471;
var ex88478 = (state_88471__$1[(2)]);
var statearr_88483_88500 = state_88471__$1;
(statearr_88483_88500[(5)] = ex88478);


var statearr_88484_88501 = state_88471__$1;
(statearr_88484_88501[(1)] = (4));

(statearr_88484_88501[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (10))){
var inst_88463 = (state_88471[(2)]);
var inst_88464 = fluree.db.util.async.throw_err(inst_88463);
var inst_88465 = cljs.core.clj__GT_js(inst_88464);
var inst_88466 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88465) : resolve.call(null,inst_88465));
var _ = (function (){var statearr_88485 = state_88471;
(statearr_88485[(4)] = cljs.core.rest((state_88471[(4)])));

return statearr_88485;
})();
var state_88471__$1 = state_88471;
var statearr_88486_88502 = state_88471__$1;
(statearr_88486_88502[(2)] = inst_88466);

(statearr_88486_88502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88472 === (8))){
var inst_88456 = (state_88471[(8)]);
var inst_88456__$1 = (state_88471[(2)]);
var inst_88457 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88456__$1], 0));
var state_88471__$1 = (function (){var statearr_88487 = state_88471;
(statearr_88487[(8)] = inst_88456__$1);

return statearr_88487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88471__$1,(9),inst_88457);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88488 = [null,null,null,null,null,null,null,null,null];
(statearr_88488[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88488[(1)] = (1));

return statearr_88488;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88471){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88471);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88489){var ex__17181__auto__ = e88489;
var statearr_88490_88503 = state_88471;
(statearr_88490_88503[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88471[(4)]))){
var statearr_88491_88504 = state_88471;
(statearr_88491_88504[(1)] = cljs.core.first((state_88471[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88505 = state_88471;
state_88471 = G__88505;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88471){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88492 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88492[(6)] = c__17304__auto__);

return statearr_88492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__88507 = arguments.length;
switch (G__88507) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88542){
var state_val_88543 = (state_88542[(1)]);
if((state_val_88543 === (7))){
var inst_88520 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88542__$1 = state_88542;
var statearr_88544_88565 = state_88542__$1;
(statearr_88544_88565[(2)] = inst_88520);

(statearr_88544_88565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (1))){
var state_88542__$1 = state_88542;
var statearr_88545_88566 = state_88542__$1;
(statearr_88545_88566[(2)] = null);

(statearr_88545_88566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (4))){
var inst_88508 = (state_88542[(2)]);
var inst_88509 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88508], 0));
var inst_88510 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88508) : reject.call(null,inst_88508));
var state_88542__$1 = (function (){var statearr_88546 = state_88542;
(statearr_88546[(7)] = inst_88509);

return statearr_88546;
})();
var statearr_88547_88567 = state_88542__$1;
(statearr_88547_88567[(2)] = inst_88510);

(statearr_88547_88567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (6))){
var state_88542__$1 = state_88542;
var statearr_88548_88568 = state_88542__$1;
(statearr_88548_88568[(2)] = null);

(statearr_88548_88568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (3))){
var inst_88540 = (state_88542[(2)]);
var state_88542__$1 = state_88542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88542__$1,inst_88540);
} else {
if((state_val_88543 === (2))){
var _ = (function (){var statearr_88550 = state_88542;
(statearr_88550[(4)] = cljs.core.cons((5),(state_88542[(4)])));

return statearr_88550;
})();
var inst_88517 = (opts == null);
var state_88542__$1 = state_88542;
if(cljs.core.truth_(inst_88517)){
var statearr_88551_88569 = state_88542__$1;
(statearr_88551_88569[(1)] = (6));

} else {
var statearr_88552_88570 = state_88542__$1;
(statearr_88552_88570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (9))){
var inst_88525 = (state_88542[(8)]);
var inst_88522 = (state_88542[(9)]);
var inst_88526 = (state_88542[(10)]);
var inst_88529 = (state_88542[(2)]);
var inst_88530 = fluree.db.util.async.throw_err(inst_88529);
var inst_88531 = fluree.db.query.block.block_range(inst_88530,inst_88525,inst_88526,inst_88522);
var state_88542__$1 = state_88542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88542__$1,(10),inst_88531);
} else {
if((state_val_88543 === (5))){
var _ = (function (){var statearr_88553 = state_88542;
(statearr_88553[(4)] = cljs.core.rest((state_88542[(4)])));

return statearr_88553;
})();
var state_88542__$1 = state_88542;
var ex88549 = (state_88542__$1[(2)]);
var statearr_88554_88571 = state_88542__$1;
(statearr_88554_88571[(5)] = ex88549);


var statearr_88555_88572 = state_88542__$1;
(statearr_88555_88572[(1)] = (4));

(statearr_88555_88572[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (10))){
var inst_88533 = (state_88542[(2)]);
var inst_88534 = fluree.db.util.async.throw_err(inst_88533);
var inst_88535 = fluree.db.query.range.block_with_tx_data(inst_88534);
var inst_88536 = cljs.core.clj__GT_js(inst_88535);
var inst_88537 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88536) : resolve.call(null,inst_88536));
var _ = (function (){var statearr_88556 = state_88542;
(statearr_88556[(4)] = cljs.core.rest((state_88542[(4)])));

return statearr_88556;
})();
var state_88542__$1 = state_88542;
var statearr_88557_88573 = state_88542__$1;
(statearr_88557_88573[(2)] = inst_88537);

(statearr_88557_88573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88543 === (8))){
var inst_88522 = (state_88542[(9)]);
var inst_88522__$1 = (state_88542[(2)]);
var inst_88523 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88524 = cljs.core.__destructure_map(inst_88523);
var inst_88525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88524,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_88526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_88524,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_88527 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88522__$1], 0));
var state_88542__$1 = (function (){var statearr_88558 = state_88542;
(statearr_88558[(8)] = inst_88525);

(statearr_88558[(9)] = inst_88522__$1);

(statearr_88558[(10)] = inst_88526);

return statearr_88558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88542__$1,(9),inst_88527);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88559 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_88559[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88559[(1)] = (1));

return statearr_88559;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88542){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88542);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88560){var ex__17181__auto__ = e88560;
var statearr_88561_88574 = state_88542;
(statearr_88561_88574[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88542[(4)]))){
var statearr_88562_88575 = state_88542;
(statearr_88562_88575[(1)] = cljs.core.first((state_88542[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88576 = state_88542;
state_88542 = G__88576;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88542){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88563 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88563[(6)] = c__17304__auto__);

return statearr_88563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__88578 = arguments.length;
switch (G__88578) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88645){
var state_val_88646 = (state_88645[(1)]);
if((state_val_88646 === (7))){
var inst_88591 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88645__$1 = state_88645;
var statearr_88647_88688 = state_88645__$1;
(statearr_88647_88688[(2)] = inst_88591);

(statearr_88647_88688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (20))){
var inst_88587 = (state_88645[(7)]);
var inst_88593 = (state_88645[(8)]);
var inst_88629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_88630 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_88631 = (new cljs.core.PersistentVector(null,1,(5),inst_88629,inst_88630,null));
var inst_88632 = cljs.core.assoc_in(inst_88593,inst_88631,new cljs.core.Keyword(null,"block","block",664686210));
var inst_88633 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_88587,inst_88632);
var state_88645__$1 = state_88645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88645__$1,(23),inst_88633);
} else {
if((state_val_88646 === (1))){
var state_88645__$1 = state_88645;
var statearr_88648_88689 = state_88645__$1;
(statearr_88648_88689[(2)] = null);

(statearr_88648_88689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (4))){
var inst_88579 = (state_88645[(2)]);
var inst_88580 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88579], 0));
var inst_88581 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88579) : reject.call(null,inst_88579));
var state_88645__$1 = (function (){var statearr_88649 = state_88645;
(statearr_88649[(9)] = inst_88580);

return statearr_88649;
})();
var statearr_88650_88690 = state_88645__$1;
(statearr_88650_88690[(2)] = inst_88581);

(statearr_88650_88690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (15))){
var inst_88617 = (state_88645[(2)]);
var inst_88618 = fluree.db.util.async.throw_err(inst_88617);
var state_88645__$1 = state_88645;
var statearr_88651_88691 = state_88645__$1;
(statearr_88651_88691[(2)] = inst_88618);

(statearr_88651_88691[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (21))){
var inst_88638 = (state_88645[(2)]);
var inst_88639 = cljs.core.clj__GT_js(inst_88638);
var inst_88640 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88639) : resolve.call(null,inst_88639));
var _ = (function (){var statearr_88652 = state_88645;
(statearr_88652[(4)] = cljs.core.rest((state_88645[(4)])));

return statearr_88652;
})();
var state_88645__$1 = state_88645;
var statearr_88653_88692 = state_88645__$1;
(statearr_88653_88692[(2)] = inst_88640);

(statearr_88653_88692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (13))){
var state_88645__$1 = state_88645;
var statearr_88654_88693 = state_88645__$1;
(statearr_88654_88693[(2)] = null);

(statearr_88654_88693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (22))){
var inst_88626 = (state_88645[(2)]);
var inst_88627 = fluree.db.util.async.throw_err(inst_88626);
var state_88645__$1 = state_88645;
var statearr_88655_88694 = state_88645__$1;
(statearr_88655_88694[(2)] = inst_88627);

(statearr_88655_88694[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (6))){
var state_88645__$1 = state_88645;
var statearr_88656_88695 = state_88645__$1;
(statearr_88656_88695[(2)] = null);

(statearr_88656_88695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (17))){
var state_88645__$1 = state_88645;
var statearr_88657_88696 = state_88645__$1;
(statearr_88657_88696[(2)] = null);

(statearr_88657_88696[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (3))){
var inst_88643 = (state_88645[(2)]);
var state_88645__$1 = state_88645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88645__$1,inst_88643);
} else {
if((state_val_88646 === (12))){
var inst_88601 = (state_88645[(10)]);
var inst_88605 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_88645__$1 = (function (){var statearr_88658 = state_88645;
(statearr_88658[(11)] = inst_88605);

return statearr_88658;
})();
if(cljs.core.truth_(inst_88601)){
var statearr_88659_88697 = state_88645__$1;
(statearr_88659_88697[(1)] = (16));

} else {
var statearr_88660_88698 = state_88645__$1;
(statearr_88660_88698[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (2))){
var _ = (function (){var statearr_88661 = state_88645;
(statearr_88661[(4)] = cljs.core.cons((5),(state_88645[(4)])));

return statearr_88661;
})();
var inst_88587 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88588 = (opts == null);
var state_88645__$1 = (function (){var statearr_88662 = state_88645;
(statearr_88662[(7)] = inst_88587);

return statearr_88662;
})();
if(cljs.core.truth_(inst_88588)){
var statearr_88663_88699 = state_88645__$1;
(statearr_88663_88699[(1)] = (6));

} else {
var statearr_88664_88700 = state_88645__$1;
(statearr_88664_88700[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (23))){
var inst_88635 = (state_88645[(2)]);
var inst_88636 = fluree.db.util.async.throw_err(inst_88635);
var state_88645__$1 = state_88645;
var statearr_88665_88701 = state_88645__$1;
(statearr_88665_88701[(2)] = inst_88636);

(statearr_88665_88701[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (19))){
var inst_88587 = (state_88645[(7)]);
var inst_88593 = (state_88645[(8)]);
var inst_88621 = (state_88645[(12)]);
var inst_88624 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_88621,inst_88587,inst_88593);
var state_88645__$1 = state_88645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88645__$1,(22),inst_88624);
} else {
if((state_val_88646 === (11))){
var inst_88593 = (state_88645[(8)]);
var inst_88595 = (state_88645[(13)]);
var inst_88601 = (state_88645[(2)]);
var inst_88602 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_88593);
var inst_88603 = (inst_88595 == null);
var state_88645__$1 = (function (){var statearr_88667 = state_88645;
(statearr_88667[(10)] = inst_88601);

(statearr_88667[(14)] = inst_88602);

return statearr_88667;
})();
if(cljs.core.truth_(inst_88603)){
var statearr_88668_88702 = state_88645__$1;
(statearr_88668_88702[(1)] = (12));

} else {
var statearr_88669_88703 = state_88645__$1;
(statearr_88669_88703[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (9))){
var inst_88596 = (state_88645[(15)]);
var state_88645__$1 = state_88645;
var statearr_88670_88704 = state_88645__$1;
(statearr_88670_88704[(2)] = inst_88596);

(statearr_88670_88704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (5))){
var _ = (function (){var statearr_88671 = state_88645;
(statearr_88671[(4)] = cljs.core.rest((state_88645[(4)])));

return statearr_88671;
})();
var state_88645__$1 = state_88645;
var ex88666 = (state_88645__$1[(2)]);
var statearr_88672_88705 = state_88645__$1;
(statearr_88672_88705[(5)] = ex88666);


var statearr_88673_88706 = state_88645__$1;
(statearr_88673_88706[(1)] = (4));

(statearr_88673_88706[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (14))){
var inst_88595 = (state_88645[(13)]);
var inst_88621 = (state_88645[(2)]);
var inst_88622 = (inst_88595 == null);
var state_88645__$1 = (function (){var statearr_88674 = state_88645;
(statearr_88674[(12)] = inst_88621);

return statearr_88674;
})();
if(cljs.core.truth_(inst_88622)){
var statearr_88675_88707 = state_88645__$1;
(statearr_88675_88707[(1)] = (19));

} else {
var statearr_88676_88708 = state_88645__$1;
(statearr_88676_88708[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (16))){
var inst_88601 = (state_88645[(10)]);
var inst_88607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_88608 = ["_auth/id",inst_88601];
var inst_88609 = (new cljs.core.PersistentVector(null,2,(5),inst_88607,inst_88608,null));
var state_88645__$1 = state_88645;
var statearr_88677_88709 = state_88645__$1;
(statearr_88677_88709[(2)] = inst_88609);

(statearr_88677_88709[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (10))){
var inst_88593 = (state_88645[(8)]);
var inst_88599 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_88593);
var state_88645__$1 = state_88645;
var statearr_88678_88710 = state_88645__$1;
(statearr_88678_88710[(2)] = inst_88599);

(statearr_88678_88710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88646 === (18))){
var inst_88602 = (state_88645[(14)]);
var inst_88605 = (state_88645[(11)]);
var inst_88612 = (state_88645[(2)]);
var inst_88613 = [inst_88612,inst_88602];
var inst_88614 = cljs.core.PersistentHashMap.fromArrays(inst_88605,inst_88613);
var inst_88615 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88614], 0));
var state_88645__$1 = state_88645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88645__$1,(15),inst_88615);
} else {
if((state_val_88646 === (8))){
var inst_88593 = (state_88645[(8)]);
var inst_88596 = (state_88645[(15)]);
var inst_88593__$1 = (state_88645[(2)]);
var inst_88594 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_88593__$1);
var inst_88595 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_88593__$1);
var inst_88596__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_88593__$1);
var state_88645__$1 = (function (){var statearr_88679 = state_88645;
(statearr_88679[(8)] = inst_88593__$1);

(statearr_88679[(15)] = inst_88596__$1);

(statearr_88679[(16)] = inst_88594);

(statearr_88679[(13)] = inst_88595);

return statearr_88679;
})();
if(cljs.core.truth_(inst_88596__$1)){
var statearr_88680_88711 = state_88645__$1;
(statearr_88680_88711[(1)] = (9));

} else {
var statearr_88681_88712 = state_88645__$1;
(statearr_88681_88712[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88682[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88682[(1)] = (1));

return statearr_88682;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88645){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88645);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88683){var ex__17181__auto__ = e88683;
var statearr_88684_88713 = state_88645;
(statearr_88684_88713[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88645[(4)]))){
var statearr_88685_88714 = state_88645;
(statearr_88685_88714[(1)] = cljs.core.first((state_88645[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88715 = state_88645;
state_88645 = G__88715;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88645){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88686 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88686[(6)] = c__17304__auto__);

return statearr_88686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88735){
var state_val_88736 = (state_88735[(1)]);
if((state_val_88736 === (1))){
var state_88735__$1 = state_88735;
var statearr_88737_88752 = state_88735__$1;
(statearr_88737_88752[(2)] = null);

(statearr_88737_88752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88736 === (2))){
var _ = (function (){var statearr_88738 = state_88735;
(statearr_88738[(4)] = cljs.core.cons((5),(state_88735[(4)])));

return statearr_88738;
})();
var inst_88724 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88725 = fluree.db.api.query.history_query_async(sources,inst_88724);
var state_88735__$1 = state_88735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88735__$1,(6),inst_88725);
} else {
if((state_val_88736 === (3))){
var inst_88733 = (state_88735[(2)]);
var state_88735__$1 = state_88735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88735__$1,inst_88733);
} else {
if((state_val_88736 === (4))){
var inst_88716 = (state_88735[(2)]);
var inst_88717 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88716], 0));
var inst_88718 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88716) : reject.call(null,inst_88716));
var state_88735__$1 = (function (){var statearr_88740 = state_88735;
(statearr_88740[(7)] = inst_88717);

return statearr_88740;
})();
var statearr_88741_88753 = state_88735__$1;
(statearr_88741_88753[(2)] = inst_88718);

(statearr_88741_88753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88736 === (5))){
var _ = (function (){var statearr_88742 = state_88735;
(statearr_88742[(4)] = cljs.core.rest((state_88735[(4)])));

return statearr_88742;
})();
var state_88735__$1 = state_88735;
var ex88739 = (state_88735__$1[(2)]);
var statearr_88743_88754 = state_88735__$1;
(statearr_88743_88754[(5)] = ex88739);


var statearr_88744_88755 = state_88735__$1;
(statearr_88744_88755[(1)] = (4));

(statearr_88744_88755[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88736 === (6))){
var inst_88727 = (state_88735[(2)]);
var inst_88728 = fluree.db.util.async.throw_err(inst_88727);
var inst_88729 = cljs.core.clj__GT_js(inst_88728);
var inst_88730 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88729) : resolve.call(null,inst_88729));
var _ = (function (){var statearr_88745 = state_88735;
(statearr_88745[(4)] = cljs.core.rest((state_88735[(4)])));

return statearr_88745;
})();
var state_88735__$1 = state_88735;
var statearr_88746_88756 = state_88735__$1;
(statearr_88746_88756[(2)] = inst_88730);

(statearr_88746_88756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__17178__auto__ = null;
var flureedb$history_query_$_state_machine__17178__auto____0 = (function (){
var statearr_88747 = [null,null,null,null,null,null,null,null];
(statearr_88747[(0)] = flureedb$history_query_$_state_machine__17178__auto__);

(statearr_88747[(1)] = (1));

return statearr_88747;
});
var flureedb$history_query_$_state_machine__17178__auto____1 = (function (state_88735){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88735);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88748){var ex__17181__auto__ = e88748;
var statearr_88749_88757 = state_88735;
(statearr_88749_88757[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88735[(4)]))){
var statearr_88750_88758 = state_88735;
(statearr_88750_88758[(1)] = cljs.core.first((state_88735[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88759 = state_88735;
state_88735 = G__88759;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__17178__auto__ = function(state_88735){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__17178__auto____1.call(this,state_88735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__17178__auto____0;
flureedb$history_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__17178__auto____1;
return flureedb$history_query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88751 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88751[(6)] = c__17304__auto__);

return statearr_88751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88779){
var state_val_88780 = (state_88779[(1)]);
if((state_val_88780 === (1))){
var state_88779__$1 = state_88779;
var statearr_88781_88796 = state_88779__$1;
(statearr_88781_88796[(2)] = null);

(statearr_88781_88796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88780 === (2))){
var _ = (function (){var statearr_88782 = state_88779;
(statearr_88782[(4)] = cljs.core.cons((5),(state_88779[(4)])));

return statearr_88782;
})();
var inst_88768 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88769 = fluree.db.api.query.multi_query_async(sources,inst_88768);
var state_88779__$1 = state_88779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88779__$1,(6),inst_88769);
} else {
if((state_val_88780 === (3))){
var inst_88777 = (state_88779[(2)]);
var state_88779__$1 = state_88779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88779__$1,inst_88777);
} else {
if((state_val_88780 === (4))){
var inst_88760 = (state_88779[(2)]);
var inst_88761 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88760], 0));
var inst_88762 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88760) : reject.call(null,inst_88760));
var state_88779__$1 = (function (){var statearr_88784 = state_88779;
(statearr_88784[(7)] = inst_88761);

return statearr_88784;
})();
var statearr_88785_88797 = state_88779__$1;
(statearr_88785_88797[(2)] = inst_88762);

(statearr_88785_88797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88780 === (5))){
var _ = (function (){var statearr_88786 = state_88779;
(statearr_88786[(4)] = cljs.core.rest((state_88779[(4)])));

return statearr_88786;
})();
var state_88779__$1 = state_88779;
var ex88783 = (state_88779__$1[(2)]);
var statearr_88787_88798 = state_88779__$1;
(statearr_88787_88798[(5)] = ex88783);


var statearr_88788_88799 = state_88779__$1;
(statearr_88788_88799[(1)] = (4));

(statearr_88788_88799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88780 === (6))){
var inst_88771 = (state_88779[(2)]);
var inst_88772 = fluree.db.util.async.throw_err(inst_88771);
var inst_88773 = cljs.core.clj__GT_js(inst_88772);
var inst_88774 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88773) : resolve.call(null,inst_88773));
var _ = (function (){var statearr_88789 = state_88779;
(statearr_88789[(4)] = cljs.core.rest((state_88779[(4)])));

return statearr_88789;
})();
var state_88779__$1 = state_88779;
var statearr_88790_88800 = state_88779__$1;
(statearr_88790_88800[(2)] = inst_88774);

(statearr_88790_88800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__17178__auto__ = null;
var flureedb$multi_query_$_state_machine__17178__auto____0 = (function (){
var statearr_88791 = [null,null,null,null,null,null,null,null];
(statearr_88791[(0)] = flureedb$multi_query_$_state_machine__17178__auto__);

(statearr_88791[(1)] = (1));

return statearr_88791;
});
var flureedb$multi_query_$_state_machine__17178__auto____1 = (function (state_88779){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88779);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88792){var ex__17181__auto__ = e88792;
var statearr_88793_88801 = state_88779;
(statearr_88793_88801[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88779[(4)]))){
var statearr_88794_88802 = state_88779;
(statearr_88794_88802[(1)] = cljs.core.first((state_88779[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88803 = state_88779;
state_88779 = G__88803;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__17178__auto__ = function(state_88779){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__17178__auto____1.call(this,state_88779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__17178__auto____0;
flureedb$multi_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__17178__auto____1;
return flureedb$multi_query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88795 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88795[(6)] = c__17304__auto__);

return statearr_88795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88823){
var state_val_88824 = (state_88823[(1)]);
if((state_val_88824 === (1))){
var state_88823__$1 = state_88823;
var statearr_88825_88840 = state_88823__$1;
(statearr_88825_88840[(2)] = null);

(statearr_88825_88840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88824 === (2))){
var _ = (function (){var statearr_88826 = state_88823;
(statearr_88826[(4)] = cljs.core.cons((5),(state_88823[(4)])));

return statearr_88826;
})();
var inst_88813 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88814 = fluree.db.api.query.query_async(sources,inst_88813);
var state_88823__$1 = state_88823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88823__$1,(6),inst_88814);
} else {
if((state_val_88824 === (3))){
var inst_88821 = (state_88823[(2)]);
var state_88823__$1 = state_88823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88823__$1,inst_88821);
} else {
if((state_val_88824 === (4))){
var inst_88804 = (state_88823[(2)]);
var inst_88805 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88804], 0));
var inst_88806 = cljs.core.clj__GT_js(inst_88804);
var inst_88807 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88806) : reject.call(null,inst_88806));
var state_88823__$1 = (function (){var statearr_88828 = state_88823;
(statearr_88828[(7)] = inst_88805);

return statearr_88828;
})();
var statearr_88829_88841 = state_88823__$1;
(statearr_88829_88841[(2)] = inst_88807);

(statearr_88829_88841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88824 === (5))){
var _ = (function (){var statearr_88830 = state_88823;
(statearr_88830[(4)] = cljs.core.rest((state_88823[(4)])));

return statearr_88830;
})();
var state_88823__$1 = state_88823;
var ex88827 = (state_88823__$1[(2)]);
var statearr_88831_88842 = state_88823__$1;
(statearr_88831_88842[(5)] = ex88827);


var statearr_88832_88843 = state_88823__$1;
(statearr_88832_88843[(1)] = (4));

(statearr_88832_88843[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88824 === (6))){
var inst_88816 = (state_88823[(2)]);
var inst_88817 = cljs.core.clj__GT_js(inst_88816);
var inst_88818 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88817) : resolve.call(null,inst_88817));
var _ = (function (){var statearr_88833 = state_88823;
(statearr_88833[(4)] = cljs.core.rest((state_88823[(4)])));

return statearr_88833;
})();
var state_88823__$1 = state_88823;
var statearr_88834_88844 = state_88823__$1;
(statearr_88834_88844[(2)] = inst_88818);

(statearr_88834_88844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__17178__auto__ = null;
var flureedb$query_$_state_machine__17178__auto____0 = (function (){
var statearr_88835 = [null,null,null,null,null,null,null,null];
(statearr_88835[(0)] = flureedb$query_$_state_machine__17178__auto__);

(statearr_88835[(1)] = (1));

return statearr_88835;
});
var flureedb$query_$_state_machine__17178__auto____1 = (function (state_88823){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88823);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88836){var ex__17181__auto__ = e88836;
var statearr_88837_88845 = state_88823;
(statearr_88837_88845[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88823[(4)]))){
var statearr_88838_88846 = state_88823;
(statearr_88838_88846[(1)] = cljs.core.first((state_88823[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88847 = state_88823;
state_88823 = G__88847;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$query_$_state_machine__17178__auto__ = function(state_88823){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__17178__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__17178__auto____1.call(this,state_88823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__17178__auto____0;
flureedb$query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__17178__auto____1;
return flureedb$query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88839 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88839[(6)] = c__17304__auto__);

return statearr_88839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__88849 = arguments.length;
switch (G__88849) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_88876){
var state_val_88877 = (state_88876[(1)]);
if((state_val_88877 === (7))){
var inst_88863 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_88876__$1 = state_88876;
var statearr_88878_88899 = state_88876__$1;
(statearr_88878_88899[(2)] = inst_88863);

(statearr_88878_88899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (1))){
var state_88876__$1 = state_88876;
var statearr_88879_88900 = state_88876__$1;
(statearr_88879_88900[(2)] = null);

(statearr_88879_88900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (4))){
var inst_88850 = (state_88876[(2)]);
var inst_88851 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_88850], 0));
var inst_88852 = cljs.core.clj__GT_js(inst_88850);
var inst_88853 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_88852) : reject.call(null,inst_88852));
var state_88876__$1 = (function (){var statearr_88880 = state_88876;
(statearr_88880[(7)] = inst_88851);

return statearr_88880;
})();
var statearr_88881_88901 = state_88876__$1;
(statearr_88881_88901[(2)] = inst_88853);

(statearr_88881_88901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (6))){
var state_88876__$1 = state_88876;
var statearr_88882_88902 = state_88876__$1;
(statearr_88882_88902[(2)] = null);

(statearr_88882_88902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (3))){
var inst_88874 = (state_88876[(2)]);
var state_88876__$1 = state_88876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88876__$1,inst_88874);
} else {
if((state_val_88877 === (2))){
var _ = (function (){var statearr_88884 = state_88876;
(statearr_88884[(4)] = cljs.core.cons((5),(state_88876[(4)])));

return statearr_88884;
})();
var inst_88859 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_88860 = (opts == null);
var state_88876__$1 = (function (){var statearr_88885 = state_88876;
(statearr_88885[(8)] = inst_88859);

return statearr_88885;
})();
if(cljs.core.truth_(inst_88860)){
var statearr_88886_88903 = state_88876__$1;
(statearr_88886_88903[(1)] = (6));

} else {
var statearr_88887_88904 = state_88876__$1;
(statearr_88887_88904[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (9))){
var inst_88868 = (state_88876[(2)]);
var inst_88869 = fluree.db.util.async.throw_err(inst_88868);
var inst_88870 = cljs.core.clj__GT_js(inst_88869);
var inst_88871 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_88870) : resolve.call(null,inst_88870));
var _ = (function (){var statearr_88888 = state_88876;
(statearr_88888[(4)] = cljs.core.rest((state_88876[(4)])));

return statearr_88888;
})();
var state_88876__$1 = state_88876;
var statearr_88889_88905 = state_88876__$1;
(statearr_88889_88905[(2)] = inst_88871);

(statearr_88889_88905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (5))){
var _ = (function (){var statearr_88890 = state_88876;
(statearr_88890[(4)] = cljs.core.rest((state_88876[(4)])));

return statearr_88890;
})();
var state_88876__$1 = state_88876;
var ex88883 = (state_88876__$1[(2)]);
var statearr_88891_88906 = state_88876__$1;
(statearr_88891_88906[(5)] = ex88883);


var statearr_88892_88907 = state_88876__$1;
(statearr_88892_88907[(1)] = (4));

(statearr_88892_88907[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88877 === (8))){
var inst_88859 = (state_88876[(8)]);
var inst_88865 = (state_88876[(2)]);
var inst_88866 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_88859,inst_88865);
var state_88876__$1 = state_88876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88876__$1,(9),inst_88866);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__17178__auto__ = null;
var flureedb$state_machine__17178__auto____0 = (function (){
var statearr_88893 = [null,null,null,null,null,null,null,null,null];
(statearr_88893[(0)] = flureedb$state_machine__17178__auto__);

(statearr_88893[(1)] = (1));

return statearr_88893;
});
var flureedb$state_machine__17178__auto____1 = (function (state_88876){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_88876);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e88894){var ex__17181__auto__ = e88894;
var statearr_88895_88908 = state_88876;
(statearr_88895_88908[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_88876[(4)]))){
var statearr_88896_88909 = state_88876;
(statearr_88896_88909[(1)] = cljs.core.first((state_88876[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88910 = state_88876;
state_88876 = G__88910;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
flureedb$state_machine__17178__auto__ = function(state_88876){
switch(arguments.length){
case 0:
return flureedb$state_machine__17178__auto____0.call(this);
case 1:
return flureedb$state_machine__17178__auto____1.call(this,state_88876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__17178__auto____0;
flureedb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__17178__auto____1;
return flureedb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_88897 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_88897[(6)] = c__17304__auto__);

return statearr_88897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
