// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__8246){
var vec__8247 = p__8246;
var i = cljs.core.nth.call(null,vec__8247,(0),null);
var v = cljs.core.nth.call(null,vec__8247,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__8250 = seg;
var gcol = cljs.core.nth.call(null,vec__8250,(0),null);
var source = cljs.core.nth.call(null,vec__8250,(1),null);
var line = cljs.core.nth.call(null,vec__8250,(2),null);
var col = cljs.core.nth.call(null,vec__8250,(3),null);
var name = cljs.core.nth.call(null,vec__8250,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__8253 = seg;
var gcol = cljs.core.nth.call(null,vec__8253,(0),null);
var source = cljs.core.nth.call(null,vec__8253,(1),null);
var line = cljs.core.nth.call(null,vec__8253,(2),null);
var col = cljs.core.nth.call(null,vec__8253,(3),null);
var name = cljs.core.nth.call(null,vec__8253,(4),null);
var vec__8256 = relseg;
var rgcol = cljs.core.nth.call(null,vec__8256,(0),null);
var rsource = cljs.core.nth.call(null,vec__8256,(1),null);
var rline = cljs.core.nth.call(null,vec__8256,(2),null);
var rcol = cljs.core.nth.call(null,vec__8256,(3),null);
var rname = cljs.core.nth.call(null,vec__8256,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4212__auto__ = source;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4212__auto__ = line;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4212__auto__ = col;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__8259 = segmap;
var map__8259__$1 = cljs.core.__destructure_map.call(null,map__8259);
var gcol = cljs.core.get.call(null,map__8259__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__8259__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__8259__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__8259__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__8259__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__8261 = arguments.length;
switch (G__8261) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__8265 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__8269 = cljs.core.next.call(null,segs__$1);
var G__8270 = nrelseg;
var G__8271 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__8269;
relseg__$1 = G__8270;
result__$1 = G__8271;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__8265,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__8265,(1),null);
var G__8272 = (gline + (1));
var G__8273 = cljs.core.next.call(null,lines__$1);
var G__8274 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__8275 = result__$1;
gline = G__8272;
lines__$1 = G__8273;
relseg = G__8274;
result = G__8275;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__8277 = segmap;
var map__8277__$1 = cljs.core.__destructure_map.call(null,map__8277);
var gcol = cljs.core.get.call(null,map__8277__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__8277__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__8277__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__8277__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__8277__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__8276_SHARP_){
return cljs.core.conj.call(null,p1__8276_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__8279 = arguments.length;
switch (G__8279) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__8283 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__8287 = cljs.core.next.call(null,segs__$1);
var G__8288 = nrelseg;
var G__8289 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__8287;
relseg__$1 = G__8288;
result__$1 = G__8289;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__8283,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__8283,(1),null);
var G__8290 = (gline + (1));
var G__8291 = cljs.core.next.call(null,lines__$1);
var G__8292 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__8293 = result__$1;
gline = G__8290;
lines__$1 = G__8291;
relseg = G__8292;
result = G__8293;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__8294){
var vec__8295 = p__8294;
var _ = cljs.core.nth.call(null,vec__8295,(0),null);
var source = cljs.core.nth.call(null,vec__8295,(1),null);
var line = cljs.core.nth.call(null,vec__8295,(2),null);
var col = cljs.core.nth.call(null,vec__8295,(3),null);
var name = cljs.core.nth.call(null,vec__8295,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__8298){
var vec__8299 = p__8298;
var gcol = cljs.core.nth.call(null,vec__8299,(0),null);
var sidx = cljs.core.nth.call(null,vec__8299,(1),null);
var line = cljs.core.nth.call(null,vec__8299,(2),null);
var col = cljs.core.nth.call(null,vec__8299,(3),null);
var name = cljs.core.nth.call(null,vec__8299,(4),null);
var seg = vec__8299;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__8302){
var vec__8303 = p__8302;
var _ = cljs.core.nth.call(null,vec__8303,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__8303,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__8303,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__8303,(3),null);
var lname = cljs.core.nth.call(null,vec__8303,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__8309 = cljs.core.seq.call(null,infos);
var chunk__8310 = null;
var count__8311 = (0);
var i__8312 = (0);
while(true){
if((i__8312 < count__8311)){
var info = cljs.core._nth.call(null,chunk__8310,i__8312);
var segv_8663 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_8664 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_8665 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_8664 > (lc_8665 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__8309,chunk__8310,count__8311,i__8312,segv_8663,gline_8664,lc_8665,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_8664 - (lc_8665 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8663], null));
});})(seq__8309,chunk__8310,count__8311,i__8312,segv_8663,gline_8664,lc_8665,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__8309,chunk__8310,count__8311,i__8312,segv_8663,gline_8664,lc_8665,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8664], null),cljs.core.conj,segv_8663);
});})(seq__8309,chunk__8310,count__8311,i__8312,segv_8663,gline_8664,lc_8665,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8666 = seq__8309;
var G__8667 = chunk__8310;
var G__8668 = count__8311;
var G__8669 = (i__8312 + (1));
seq__8309 = G__8666;
chunk__8310 = G__8667;
count__8311 = G__8668;
i__8312 = G__8669;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__8309);
if(temp__5753__auto__){
var seq__8309__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8309__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__8309__$1);
var G__8670 = cljs.core.chunk_rest.call(null,seq__8309__$1);
var G__8671 = c__4638__auto__;
var G__8672 = cljs.core.count.call(null,c__4638__auto__);
var G__8673 = (0);
seq__8309 = G__8670;
chunk__8310 = G__8671;
count__8311 = G__8672;
i__8312 = G__8673;
continue;
} else {
var info = cljs.core.first.call(null,seq__8309__$1);
var segv_8674 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_8675 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_8676 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_8675 > (lc_8676 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__8309,chunk__8310,count__8311,i__8312,segv_8674,gline_8675,lc_8676,info,seq__8309__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_8675 - (lc_8676 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8674], null));
});})(seq__8309,chunk__8310,count__8311,i__8312,segv_8674,gline_8675,lc_8676,info,seq__8309__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__8309,chunk__8310,count__8311,i__8312,segv_8674,gline_8675,lc_8676,info,seq__8309__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8675], null),cljs.core.conj,segv_8674);
});})(seq__8309,chunk__8310,count__8311,i__8312,segv_8674,gline_8675,lc_8676,info,seq__8309__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8677 = cljs.core.next.call(null,seq__8309__$1);
var G__8678 = null;
var G__8679 = (0);
var G__8680 = (0);
seq__8309 = G__8677;
chunk__8310 = G__8678;
count__8311 = G__8679;
i__8312 = G__8680;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__8313_8681 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__8314_8682 = null;
var count__8315_8683 = (0);
var i__8316_8684 = (0);
while(true){
if((i__8316_8684 < count__8315_8683)){
var vec__8489_8685 = cljs.core._nth.call(null,chunk__8314_8682,i__8316_8684);
var source_idx_8686 = cljs.core.nth.call(null,vec__8489_8685,(0),null);
var vec__8492_8687 = cljs.core.nth.call(null,vec__8489_8685,(1),null);
var __8688 = cljs.core.nth.call(null,vec__8492_8687,(0),null);
var lines_8689__$1 = cljs.core.nth.call(null,vec__8492_8687,(1),null);
var seq__8495_8690 = cljs.core.seq.call(null,lines_8689__$1);
var chunk__8496_8691 = null;
var count__8497_8692 = (0);
var i__8498_8693 = (0);
while(true){
if((i__8498_8693 < count__8497_8692)){
var vec__8537_8694 = cljs.core._nth.call(null,chunk__8496_8691,i__8498_8693);
var line_8695 = cljs.core.nth.call(null,vec__8537_8694,(0),null);
var cols_8696 = cljs.core.nth.call(null,vec__8537_8694,(1),null);
var seq__8540_8697 = cljs.core.seq.call(null,cols_8696);
var chunk__8541_8698 = null;
var count__8542_8699 = (0);
var i__8543_8700 = (0);
while(true){
if((i__8543_8700 < count__8542_8699)){
var vec__8550_8701 = cljs.core._nth.call(null,chunk__8541_8698,i__8543_8700);
var col_8702 = cljs.core.nth.call(null,vec__8550_8701,(0),null);
var infos_8703 = cljs.core.nth.call(null,vec__8550_8701,(1),null);
encode_cols.call(null,infos_8703,source_idx_8686,line_8695,col_8702);


var G__8704 = seq__8540_8697;
var G__8705 = chunk__8541_8698;
var G__8706 = count__8542_8699;
var G__8707 = (i__8543_8700 + (1));
seq__8540_8697 = G__8704;
chunk__8541_8698 = G__8705;
count__8542_8699 = G__8706;
i__8543_8700 = G__8707;
continue;
} else {
var temp__5753__auto___8708 = cljs.core.seq.call(null,seq__8540_8697);
if(temp__5753__auto___8708){
var seq__8540_8709__$1 = temp__5753__auto___8708;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8540_8709__$1)){
var c__4638__auto___8710 = cljs.core.chunk_first.call(null,seq__8540_8709__$1);
var G__8711 = cljs.core.chunk_rest.call(null,seq__8540_8709__$1);
var G__8712 = c__4638__auto___8710;
var G__8713 = cljs.core.count.call(null,c__4638__auto___8710);
var G__8714 = (0);
seq__8540_8697 = G__8711;
chunk__8541_8698 = G__8712;
count__8542_8699 = G__8713;
i__8543_8700 = G__8714;
continue;
} else {
var vec__8553_8715 = cljs.core.first.call(null,seq__8540_8709__$1);
var col_8716 = cljs.core.nth.call(null,vec__8553_8715,(0),null);
var infos_8717 = cljs.core.nth.call(null,vec__8553_8715,(1),null);
encode_cols.call(null,infos_8717,source_idx_8686,line_8695,col_8716);


var G__8718 = cljs.core.next.call(null,seq__8540_8709__$1);
var G__8719 = null;
var G__8720 = (0);
var G__8721 = (0);
seq__8540_8697 = G__8718;
chunk__8541_8698 = G__8719;
count__8542_8699 = G__8720;
i__8543_8700 = G__8721;
continue;
}
} else {
}
}
break;
}


var G__8722 = seq__8495_8690;
var G__8723 = chunk__8496_8691;
var G__8724 = count__8497_8692;
var G__8725 = (i__8498_8693 + (1));
seq__8495_8690 = G__8722;
chunk__8496_8691 = G__8723;
count__8497_8692 = G__8724;
i__8498_8693 = G__8725;
continue;
} else {
var temp__5753__auto___8726 = cljs.core.seq.call(null,seq__8495_8690);
if(temp__5753__auto___8726){
var seq__8495_8727__$1 = temp__5753__auto___8726;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8495_8727__$1)){
var c__4638__auto___8728 = cljs.core.chunk_first.call(null,seq__8495_8727__$1);
var G__8729 = cljs.core.chunk_rest.call(null,seq__8495_8727__$1);
var G__8730 = c__4638__auto___8728;
var G__8731 = cljs.core.count.call(null,c__4638__auto___8728);
var G__8732 = (0);
seq__8495_8690 = G__8729;
chunk__8496_8691 = G__8730;
count__8497_8692 = G__8731;
i__8498_8693 = G__8732;
continue;
} else {
var vec__8556_8733 = cljs.core.first.call(null,seq__8495_8727__$1);
var line_8734 = cljs.core.nth.call(null,vec__8556_8733,(0),null);
var cols_8735 = cljs.core.nth.call(null,vec__8556_8733,(1),null);
var seq__8559_8736 = cljs.core.seq.call(null,cols_8735);
var chunk__8560_8737 = null;
var count__8561_8738 = (0);
var i__8562_8739 = (0);
while(true){
if((i__8562_8739 < count__8561_8738)){
var vec__8569_8740 = cljs.core._nth.call(null,chunk__8560_8737,i__8562_8739);
var col_8741 = cljs.core.nth.call(null,vec__8569_8740,(0),null);
var infos_8742 = cljs.core.nth.call(null,vec__8569_8740,(1),null);
encode_cols.call(null,infos_8742,source_idx_8686,line_8734,col_8741);


var G__8743 = seq__8559_8736;
var G__8744 = chunk__8560_8737;
var G__8745 = count__8561_8738;
var G__8746 = (i__8562_8739 + (1));
seq__8559_8736 = G__8743;
chunk__8560_8737 = G__8744;
count__8561_8738 = G__8745;
i__8562_8739 = G__8746;
continue;
} else {
var temp__5753__auto___8747__$1 = cljs.core.seq.call(null,seq__8559_8736);
if(temp__5753__auto___8747__$1){
var seq__8559_8748__$1 = temp__5753__auto___8747__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8559_8748__$1)){
var c__4638__auto___8749 = cljs.core.chunk_first.call(null,seq__8559_8748__$1);
var G__8750 = cljs.core.chunk_rest.call(null,seq__8559_8748__$1);
var G__8751 = c__4638__auto___8749;
var G__8752 = cljs.core.count.call(null,c__4638__auto___8749);
var G__8753 = (0);
seq__8559_8736 = G__8750;
chunk__8560_8737 = G__8751;
count__8561_8738 = G__8752;
i__8562_8739 = G__8753;
continue;
} else {
var vec__8572_8754 = cljs.core.first.call(null,seq__8559_8748__$1);
var col_8755 = cljs.core.nth.call(null,vec__8572_8754,(0),null);
var infos_8756 = cljs.core.nth.call(null,vec__8572_8754,(1),null);
encode_cols.call(null,infos_8756,source_idx_8686,line_8734,col_8755);


var G__8757 = cljs.core.next.call(null,seq__8559_8748__$1);
var G__8758 = null;
var G__8759 = (0);
var G__8760 = (0);
seq__8559_8736 = G__8757;
chunk__8560_8737 = G__8758;
count__8561_8738 = G__8759;
i__8562_8739 = G__8760;
continue;
}
} else {
}
}
break;
}


var G__8761 = cljs.core.next.call(null,seq__8495_8727__$1);
var G__8762 = null;
var G__8763 = (0);
var G__8764 = (0);
seq__8495_8690 = G__8761;
chunk__8496_8691 = G__8762;
count__8497_8692 = G__8763;
i__8498_8693 = G__8764;
continue;
}
} else {
}
}
break;
}


var G__8765 = seq__8313_8681;
var G__8766 = chunk__8314_8682;
var G__8767 = count__8315_8683;
var G__8768 = (i__8316_8684 + (1));
seq__8313_8681 = G__8765;
chunk__8314_8682 = G__8766;
count__8315_8683 = G__8767;
i__8316_8684 = G__8768;
continue;
} else {
var temp__5753__auto___8769 = cljs.core.seq.call(null,seq__8313_8681);
if(temp__5753__auto___8769){
var seq__8313_8770__$1 = temp__5753__auto___8769;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8313_8770__$1)){
var c__4638__auto___8771 = cljs.core.chunk_first.call(null,seq__8313_8770__$1);
var G__8772 = cljs.core.chunk_rest.call(null,seq__8313_8770__$1);
var G__8773 = c__4638__auto___8771;
var G__8774 = cljs.core.count.call(null,c__4638__auto___8771);
var G__8775 = (0);
seq__8313_8681 = G__8772;
chunk__8314_8682 = G__8773;
count__8315_8683 = G__8774;
i__8316_8684 = G__8775;
continue;
} else {
var vec__8575_8776 = cljs.core.first.call(null,seq__8313_8770__$1);
var source_idx_8777 = cljs.core.nth.call(null,vec__8575_8776,(0),null);
var vec__8578_8778 = cljs.core.nth.call(null,vec__8575_8776,(1),null);
var __8779 = cljs.core.nth.call(null,vec__8578_8778,(0),null);
var lines_8780__$1 = cljs.core.nth.call(null,vec__8578_8778,(1),null);
var seq__8581_8781 = cljs.core.seq.call(null,lines_8780__$1);
var chunk__8582_8782 = null;
var count__8583_8783 = (0);
var i__8584_8784 = (0);
while(true){
if((i__8584_8784 < count__8583_8783)){
var vec__8623_8785 = cljs.core._nth.call(null,chunk__8582_8782,i__8584_8784);
var line_8786 = cljs.core.nth.call(null,vec__8623_8785,(0),null);
var cols_8787 = cljs.core.nth.call(null,vec__8623_8785,(1),null);
var seq__8626_8788 = cljs.core.seq.call(null,cols_8787);
var chunk__8627_8789 = null;
var count__8628_8790 = (0);
var i__8629_8791 = (0);
while(true){
if((i__8629_8791 < count__8628_8790)){
var vec__8636_8792 = cljs.core._nth.call(null,chunk__8627_8789,i__8629_8791);
var col_8793 = cljs.core.nth.call(null,vec__8636_8792,(0),null);
var infos_8794 = cljs.core.nth.call(null,vec__8636_8792,(1),null);
encode_cols.call(null,infos_8794,source_idx_8777,line_8786,col_8793);


var G__8795 = seq__8626_8788;
var G__8796 = chunk__8627_8789;
var G__8797 = count__8628_8790;
var G__8798 = (i__8629_8791 + (1));
seq__8626_8788 = G__8795;
chunk__8627_8789 = G__8796;
count__8628_8790 = G__8797;
i__8629_8791 = G__8798;
continue;
} else {
var temp__5753__auto___8799__$1 = cljs.core.seq.call(null,seq__8626_8788);
if(temp__5753__auto___8799__$1){
var seq__8626_8800__$1 = temp__5753__auto___8799__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8626_8800__$1)){
var c__4638__auto___8801 = cljs.core.chunk_first.call(null,seq__8626_8800__$1);
var G__8802 = cljs.core.chunk_rest.call(null,seq__8626_8800__$1);
var G__8803 = c__4638__auto___8801;
var G__8804 = cljs.core.count.call(null,c__4638__auto___8801);
var G__8805 = (0);
seq__8626_8788 = G__8802;
chunk__8627_8789 = G__8803;
count__8628_8790 = G__8804;
i__8629_8791 = G__8805;
continue;
} else {
var vec__8639_8806 = cljs.core.first.call(null,seq__8626_8800__$1);
var col_8807 = cljs.core.nth.call(null,vec__8639_8806,(0),null);
var infos_8808 = cljs.core.nth.call(null,vec__8639_8806,(1),null);
encode_cols.call(null,infos_8808,source_idx_8777,line_8786,col_8807);


var G__8809 = cljs.core.next.call(null,seq__8626_8800__$1);
var G__8810 = null;
var G__8811 = (0);
var G__8812 = (0);
seq__8626_8788 = G__8809;
chunk__8627_8789 = G__8810;
count__8628_8790 = G__8811;
i__8629_8791 = G__8812;
continue;
}
} else {
}
}
break;
}


var G__8813 = seq__8581_8781;
var G__8814 = chunk__8582_8782;
var G__8815 = count__8583_8783;
var G__8816 = (i__8584_8784 + (1));
seq__8581_8781 = G__8813;
chunk__8582_8782 = G__8814;
count__8583_8783 = G__8815;
i__8584_8784 = G__8816;
continue;
} else {
var temp__5753__auto___8817__$1 = cljs.core.seq.call(null,seq__8581_8781);
if(temp__5753__auto___8817__$1){
var seq__8581_8818__$1 = temp__5753__auto___8817__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8581_8818__$1)){
var c__4638__auto___8819 = cljs.core.chunk_first.call(null,seq__8581_8818__$1);
var G__8820 = cljs.core.chunk_rest.call(null,seq__8581_8818__$1);
var G__8821 = c__4638__auto___8819;
var G__8822 = cljs.core.count.call(null,c__4638__auto___8819);
var G__8823 = (0);
seq__8581_8781 = G__8820;
chunk__8582_8782 = G__8821;
count__8583_8783 = G__8822;
i__8584_8784 = G__8823;
continue;
} else {
var vec__8642_8824 = cljs.core.first.call(null,seq__8581_8818__$1);
var line_8825 = cljs.core.nth.call(null,vec__8642_8824,(0),null);
var cols_8826 = cljs.core.nth.call(null,vec__8642_8824,(1),null);
var seq__8645_8827 = cljs.core.seq.call(null,cols_8826);
var chunk__8646_8828 = null;
var count__8647_8829 = (0);
var i__8648_8830 = (0);
while(true){
if((i__8648_8830 < count__8647_8829)){
var vec__8655_8831 = cljs.core._nth.call(null,chunk__8646_8828,i__8648_8830);
var col_8832 = cljs.core.nth.call(null,vec__8655_8831,(0),null);
var infos_8833 = cljs.core.nth.call(null,vec__8655_8831,(1),null);
encode_cols.call(null,infos_8833,source_idx_8777,line_8825,col_8832);


var G__8834 = seq__8645_8827;
var G__8835 = chunk__8646_8828;
var G__8836 = count__8647_8829;
var G__8837 = (i__8648_8830 + (1));
seq__8645_8827 = G__8834;
chunk__8646_8828 = G__8835;
count__8647_8829 = G__8836;
i__8648_8830 = G__8837;
continue;
} else {
var temp__5753__auto___8838__$2 = cljs.core.seq.call(null,seq__8645_8827);
if(temp__5753__auto___8838__$2){
var seq__8645_8839__$1 = temp__5753__auto___8838__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8645_8839__$1)){
var c__4638__auto___8840 = cljs.core.chunk_first.call(null,seq__8645_8839__$1);
var G__8841 = cljs.core.chunk_rest.call(null,seq__8645_8839__$1);
var G__8842 = c__4638__auto___8840;
var G__8843 = cljs.core.count.call(null,c__4638__auto___8840);
var G__8844 = (0);
seq__8645_8827 = G__8841;
chunk__8646_8828 = G__8842;
count__8647_8829 = G__8843;
i__8648_8830 = G__8844;
continue;
} else {
var vec__8658_8845 = cljs.core.first.call(null,seq__8645_8839__$1);
var col_8846 = cljs.core.nth.call(null,vec__8658_8845,(0),null);
var infos_8847 = cljs.core.nth.call(null,vec__8658_8845,(1),null);
encode_cols.call(null,infos_8847,source_idx_8777,line_8825,col_8846);


var G__8848 = cljs.core.next.call(null,seq__8645_8839__$1);
var G__8849 = null;
var G__8850 = (0);
var G__8851 = (0);
seq__8645_8827 = G__8848;
chunk__8646_8828 = G__8849;
count__8647_8829 = G__8850;
i__8648_8830 = G__8851;
continue;
}
} else {
}
}
break;
}


var G__8852 = cljs.core.next.call(null,seq__8581_8818__$1);
var G__8853 = null;
var G__8854 = (0);
var G__8855 = (0);
seq__8581_8781 = G__8852;
chunk__8582_8782 = G__8853;
count__8583_8783 = G__8854;
i__8584_8784 = G__8855;
continue;
}
} else {
}
}
break;
}


var G__8856 = cljs.core.next.call(null,seq__8313_8770__$1);
var G__8857 = null;
var G__8858 = (0);
var G__8859 = (0);
seq__8313_8681 = G__8856;
chunk__8314_8682 = G__8857;
count__8315_8683 = G__8858;
i__8316_8684 = G__8859;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__8661 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__8306_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__8306_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__8307_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__8307_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__8308_SHARP_){
return clojure.string.join.call(null,",",p1__8308_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__8662 = G__8661;
goog.object.set(G__8662,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__8662;
} else {
return G__8661;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__8860 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__8860,(0),null);
var col_map = cljs.core.nth.call(null,vec__8860,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__8863 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__8863,(0),null);
var infos = cljs.core.nth.call(null,vec__8863,(1),null);
var G__8868 = cljs.core.next.call(null,col_map_seq);
var G__8869 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__8863,col,infos,vec__8860,line,col_map){
return (function (v,p__8866){
var map__8867 = p__8866;
var map__8867__$1 = cljs.core.__destructure_map.call(null,map__8867);
var gline = cljs.core.get.call(null,map__8867__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__8867__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__8863,col,infos,vec__8860,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__8868;
new_cols = G__8869;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__8870 = cljs.core.next.call(null,line_map_seq);
var G__8871 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__8870;
new_lines = G__8871;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__8872_9080 = cljs.core.seq.call(null,reverse_map);
var chunk__8873_9081 = null;
var count__8874_9082 = (0);
var i__8875_9083 = (0);
while(true){
if((i__8875_9083 < count__8874_9082)){
var vec__8978_9084 = cljs.core._nth.call(null,chunk__8873_9081,i__8875_9083);
var line_9085 = cljs.core.nth.call(null,vec__8978_9084,(0),null);
var columns_9086 = cljs.core.nth.call(null,vec__8978_9084,(1),null);
var seq__8981_9087 = cljs.core.seq.call(null,columns_9086);
var chunk__8982_9088 = null;
var count__8983_9089 = (0);
var i__8984_9090 = (0);
while(true){
if((i__8984_9090 < count__8983_9089)){
var vec__9007_9091 = cljs.core._nth.call(null,chunk__8982_9088,i__8984_9090);
var column_9092 = cljs.core.nth.call(null,vec__9007_9091,(0),null);
var column_info_9093 = cljs.core.nth.call(null,vec__9007_9091,(1),null);
var seq__9010_9094 = cljs.core.seq.call(null,column_info_9093);
var chunk__9011_9095 = null;
var count__9012_9096 = (0);
var i__9013_9097 = (0);
while(true){
if((i__9013_9097 < count__9012_9096)){
var map__9016_9098 = cljs.core._nth.call(null,chunk__9011_9095,i__9013_9097);
var map__9016_9099__$1 = cljs.core.__destructure_map.call(null,map__9016_9098);
var gline_9100 = cljs.core.get.call(null,map__9016_9099__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9101 = cljs.core.get.call(null,map__9016_9099__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9102 = cljs.core.get.call(null,map__9016_9099__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9100], null),cljs.core.fnil.call(null,((function (seq__9010_9094,chunk__9011_9095,count__9012_9096,i__9013_9097,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9016_9098,map__9016_9099__$1,gline_9100,gcol_9101,name_9102,vec__9007_9091,column_9092,column_info_9093,vec__8978_9084,line_9085,columns_9086,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9101], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9085,new cljs.core.Keyword(null,"col","col",-1959363084),column_9092,new cljs.core.Keyword(null,"name","name",1843675177),name_9102], null));
});})(seq__9010_9094,chunk__9011_9095,count__9012_9096,i__9013_9097,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9016_9098,map__9016_9099__$1,gline_9100,gcol_9101,name_9102,vec__9007_9091,column_9092,column_info_9093,vec__8978_9084,line_9085,columns_9086,inverted))
,cljs.core.sorted_map.call(null)));


var G__9103 = seq__9010_9094;
var G__9104 = chunk__9011_9095;
var G__9105 = count__9012_9096;
var G__9106 = (i__9013_9097 + (1));
seq__9010_9094 = G__9103;
chunk__9011_9095 = G__9104;
count__9012_9096 = G__9105;
i__9013_9097 = G__9106;
continue;
} else {
var temp__5753__auto___9107 = cljs.core.seq.call(null,seq__9010_9094);
if(temp__5753__auto___9107){
var seq__9010_9108__$1 = temp__5753__auto___9107;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9010_9108__$1)){
var c__4638__auto___9109 = cljs.core.chunk_first.call(null,seq__9010_9108__$1);
var G__9110 = cljs.core.chunk_rest.call(null,seq__9010_9108__$1);
var G__9111 = c__4638__auto___9109;
var G__9112 = cljs.core.count.call(null,c__4638__auto___9109);
var G__9113 = (0);
seq__9010_9094 = G__9110;
chunk__9011_9095 = G__9111;
count__9012_9096 = G__9112;
i__9013_9097 = G__9113;
continue;
} else {
var map__9017_9114 = cljs.core.first.call(null,seq__9010_9108__$1);
var map__9017_9115__$1 = cljs.core.__destructure_map.call(null,map__9017_9114);
var gline_9116 = cljs.core.get.call(null,map__9017_9115__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9117 = cljs.core.get.call(null,map__9017_9115__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9118 = cljs.core.get.call(null,map__9017_9115__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9116], null),cljs.core.fnil.call(null,((function (seq__9010_9094,chunk__9011_9095,count__9012_9096,i__9013_9097,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9017_9114,map__9017_9115__$1,gline_9116,gcol_9117,name_9118,seq__9010_9108__$1,temp__5753__auto___9107,vec__9007_9091,column_9092,column_info_9093,vec__8978_9084,line_9085,columns_9086,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9117], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9085,new cljs.core.Keyword(null,"col","col",-1959363084),column_9092,new cljs.core.Keyword(null,"name","name",1843675177),name_9118], null));
});})(seq__9010_9094,chunk__9011_9095,count__9012_9096,i__9013_9097,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9017_9114,map__9017_9115__$1,gline_9116,gcol_9117,name_9118,seq__9010_9108__$1,temp__5753__auto___9107,vec__9007_9091,column_9092,column_info_9093,vec__8978_9084,line_9085,columns_9086,inverted))
,cljs.core.sorted_map.call(null)));


var G__9119 = cljs.core.next.call(null,seq__9010_9108__$1);
var G__9120 = null;
var G__9121 = (0);
var G__9122 = (0);
seq__9010_9094 = G__9119;
chunk__9011_9095 = G__9120;
count__9012_9096 = G__9121;
i__9013_9097 = G__9122;
continue;
}
} else {
}
}
break;
}


var G__9123 = seq__8981_9087;
var G__9124 = chunk__8982_9088;
var G__9125 = count__8983_9089;
var G__9126 = (i__8984_9090 + (1));
seq__8981_9087 = G__9123;
chunk__8982_9088 = G__9124;
count__8983_9089 = G__9125;
i__8984_9090 = G__9126;
continue;
} else {
var temp__5753__auto___9127 = cljs.core.seq.call(null,seq__8981_9087);
if(temp__5753__auto___9127){
var seq__8981_9128__$1 = temp__5753__auto___9127;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8981_9128__$1)){
var c__4638__auto___9129 = cljs.core.chunk_first.call(null,seq__8981_9128__$1);
var G__9130 = cljs.core.chunk_rest.call(null,seq__8981_9128__$1);
var G__9131 = c__4638__auto___9129;
var G__9132 = cljs.core.count.call(null,c__4638__auto___9129);
var G__9133 = (0);
seq__8981_9087 = G__9130;
chunk__8982_9088 = G__9131;
count__8983_9089 = G__9132;
i__8984_9090 = G__9133;
continue;
} else {
var vec__9018_9134 = cljs.core.first.call(null,seq__8981_9128__$1);
var column_9135 = cljs.core.nth.call(null,vec__9018_9134,(0),null);
var column_info_9136 = cljs.core.nth.call(null,vec__9018_9134,(1),null);
var seq__9021_9137 = cljs.core.seq.call(null,column_info_9136);
var chunk__9022_9138 = null;
var count__9023_9139 = (0);
var i__9024_9140 = (0);
while(true){
if((i__9024_9140 < count__9023_9139)){
var map__9027_9141 = cljs.core._nth.call(null,chunk__9022_9138,i__9024_9140);
var map__9027_9142__$1 = cljs.core.__destructure_map.call(null,map__9027_9141);
var gline_9143 = cljs.core.get.call(null,map__9027_9142__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9144 = cljs.core.get.call(null,map__9027_9142__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9145 = cljs.core.get.call(null,map__9027_9142__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9143], null),cljs.core.fnil.call(null,((function (seq__9021_9137,chunk__9022_9138,count__9023_9139,i__9024_9140,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9027_9141,map__9027_9142__$1,gline_9143,gcol_9144,name_9145,vec__9018_9134,column_9135,column_info_9136,seq__8981_9128__$1,temp__5753__auto___9127,vec__8978_9084,line_9085,columns_9086,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9144], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9085,new cljs.core.Keyword(null,"col","col",-1959363084),column_9135,new cljs.core.Keyword(null,"name","name",1843675177),name_9145], null));
});})(seq__9021_9137,chunk__9022_9138,count__9023_9139,i__9024_9140,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9027_9141,map__9027_9142__$1,gline_9143,gcol_9144,name_9145,vec__9018_9134,column_9135,column_info_9136,seq__8981_9128__$1,temp__5753__auto___9127,vec__8978_9084,line_9085,columns_9086,inverted))
,cljs.core.sorted_map.call(null)));


var G__9146 = seq__9021_9137;
var G__9147 = chunk__9022_9138;
var G__9148 = count__9023_9139;
var G__9149 = (i__9024_9140 + (1));
seq__9021_9137 = G__9146;
chunk__9022_9138 = G__9147;
count__9023_9139 = G__9148;
i__9024_9140 = G__9149;
continue;
} else {
var temp__5753__auto___9150__$1 = cljs.core.seq.call(null,seq__9021_9137);
if(temp__5753__auto___9150__$1){
var seq__9021_9151__$1 = temp__5753__auto___9150__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9021_9151__$1)){
var c__4638__auto___9152 = cljs.core.chunk_first.call(null,seq__9021_9151__$1);
var G__9153 = cljs.core.chunk_rest.call(null,seq__9021_9151__$1);
var G__9154 = c__4638__auto___9152;
var G__9155 = cljs.core.count.call(null,c__4638__auto___9152);
var G__9156 = (0);
seq__9021_9137 = G__9153;
chunk__9022_9138 = G__9154;
count__9023_9139 = G__9155;
i__9024_9140 = G__9156;
continue;
} else {
var map__9028_9157 = cljs.core.first.call(null,seq__9021_9151__$1);
var map__9028_9158__$1 = cljs.core.__destructure_map.call(null,map__9028_9157);
var gline_9159 = cljs.core.get.call(null,map__9028_9158__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9160 = cljs.core.get.call(null,map__9028_9158__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9161 = cljs.core.get.call(null,map__9028_9158__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9159], null),cljs.core.fnil.call(null,((function (seq__9021_9137,chunk__9022_9138,count__9023_9139,i__9024_9140,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9028_9157,map__9028_9158__$1,gline_9159,gcol_9160,name_9161,seq__9021_9151__$1,temp__5753__auto___9150__$1,vec__9018_9134,column_9135,column_info_9136,seq__8981_9128__$1,temp__5753__auto___9127,vec__8978_9084,line_9085,columns_9086,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9160], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9085,new cljs.core.Keyword(null,"col","col",-1959363084),column_9135,new cljs.core.Keyword(null,"name","name",1843675177),name_9161], null));
});})(seq__9021_9137,chunk__9022_9138,count__9023_9139,i__9024_9140,seq__8981_9087,chunk__8982_9088,count__8983_9089,i__8984_9090,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9028_9157,map__9028_9158__$1,gline_9159,gcol_9160,name_9161,seq__9021_9151__$1,temp__5753__auto___9150__$1,vec__9018_9134,column_9135,column_info_9136,seq__8981_9128__$1,temp__5753__auto___9127,vec__8978_9084,line_9085,columns_9086,inverted))
,cljs.core.sorted_map.call(null)));


var G__9162 = cljs.core.next.call(null,seq__9021_9151__$1);
var G__9163 = null;
var G__9164 = (0);
var G__9165 = (0);
seq__9021_9137 = G__9162;
chunk__9022_9138 = G__9163;
count__9023_9139 = G__9164;
i__9024_9140 = G__9165;
continue;
}
} else {
}
}
break;
}


var G__9166 = cljs.core.next.call(null,seq__8981_9128__$1);
var G__9167 = null;
var G__9168 = (0);
var G__9169 = (0);
seq__8981_9087 = G__9166;
chunk__8982_9088 = G__9167;
count__8983_9089 = G__9168;
i__8984_9090 = G__9169;
continue;
}
} else {
}
}
break;
}


var G__9170 = seq__8872_9080;
var G__9171 = chunk__8873_9081;
var G__9172 = count__8874_9082;
var G__9173 = (i__8875_9083 + (1));
seq__8872_9080 = G__9170;
chunk__8873_9081 = G__9171;
count__8874_9082 = G__9172;
i__8875_9083 = G__9173;
continue;
} else {
var temp__5753__auto___9174 = cljs.core.seq.call(null,seq__8872_9080);
if(temp__5753__auto___9174){
var seq__8872_9175__$1 = temp__5753__auto___9174;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__8872_9175__$1)){
var c__4638__auto___9176 = cljs.core.chunk_first.call(null,seq__8872_9175__$1);
var G__9177 = cljs.core.chunk_rest.call(null,seq__8872_9175__$1);
var G__9178 = c__4638__auto___9176;
var G__9179 = cljs.core.count.call(null,c__4638__auto___9176);
var G__9180 = (0);
seq__8872_9080 = G__9177;
chunk__8873_9081 = G__9178;
count__8874_9082 = G__9179;
i__8875_9083 = G__9180;
continue;
} else {
var vec__9029_9181 = cljs.core.first.call(null,seq__8872_9175__$1);
var line_9182 = cljs.core.nth.call(null,vec__9029_9181,(0),null);
var columns_9183 = cljs.core.nth.call(null,vec__9029_9181,(1),null);
var seq__9032_9184 = cljs.core.seq.call(null,columns_9183);
var chunk__9033_9185 = null;
var count__9034_9186 = (0);
var i__9035_9187 = (0);
while(true){
if((i__9035_9187 < count__9034_9186)){
var vec__9058_9188 = cljs.core._nth.call(null,chunk__9033_9185,i__9035_9187);
var column_9189 = cljs.core.nth.call(null,vec__9058_9188,(0),null);
var column_info_9190 = cljs.core.nth.call(null,vec__9058_9188,(1),null);
var seq__9061_9191 = cljs.core.seq.call(null,column_info_9190);
var chunk__9062_9192 = null;
var count__9063_9193 = (0);
var i__9064_9194 = (0);
while(true){
if((i__9064_9194 < count__9063_9193)){
var map__9067_9195 = cljs.core._nth.call(null,chunk__9062_9192,i__9064_9194);
var map__9067_9196__$1 = cljs.core.__destructure_map.call(null,map__9067_9195);
var gline_9197 = cljs.core.get.call(null,map__9067_9196__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9198 = cljs.core.get.call(null,map__9067_9196__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9199 = cljs.core.get.call(null,map__9067_9196__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9197], null),cljs.core.fnil.call(null,((function (seq__9061_9191,chunk__9062_9192,count__9063_9193,i__9064_9194,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9067_9195,map__9067_9196__$1,gline_9197,gcol_9198,name_9199,vec__9058_9188,column_9189,column_info_9190,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9198], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9182,new cljs.core.Keyword(null,"col","col",-1959363084),column_9189,new cljs.core.Keyword(null,"name","name",1843675177),name_9199], null));
});})(seq__9061_9191,chunk__9062_9192,count__9063_9193,i__9064_9194,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9067_9195,map__9067_9196__$1,gline_9197,gcol_9198,name_9199,vec__9058_9188,column_9189,column_info_9190,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted))
,cljs.core.sorted_map.call(null)));


var G__9200 = seq__9061_9191;
var G__9201 = chunk__9062_9192;
var G__9202 = count__9063_9193;
var G__9203 = (i__9064_9194 + (1));
seq__9061_9191 = G__9200;
chunk__9062_9192 = G__9201;
count__9063_9193 = G__9202;
i__9064_9194 = G__9203;
continue;
} else {
var temp__5753__auto___9204__$1 = cljs.core.seq.call(null,seq__9061_9191);
if(temp__5753__auto___9204__$1){
var seq__9061_9205__$1 = temp__5753__auto___9204__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9061_9205__$1)){
var c__4638__auto___9206 = cljs.core.chunk_first.call(null,seq__9061_9205__$1);
var G__9207 = cljs.core.chunk_rest.call(null,seq__9061_9205__$1);
var G__9208 = c__4638__auto___9206;
var G__9209 = cljs.core.count.call(null,c__4638__auto___9206);
var G__9210 = (0);
seq__9061_9191 = G__9207;
chunk__9062_9192 = G__9208;
count__9063_9193 = G__9209;
i__9064_9194 = G__9210;
continue;
} else {
var map__9068_9211 = cljs.core.first.call(null,seq__9061_9205__$1);
var map__9068_9212__$1 = cljs.core.__destructure_map.call(null,map__9068_9211);
var gline_9213 = cljs.core.get.call(null,map__9068_9212__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9214 = cljs.core.get.call(null,map__9068_9212__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9215 = cljs.core.get.call(null,map__9068_9212__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9213], null),cljs.core.fnil.call(null,((function (seq__9061_9191,chunk__9062_9192,count__9063_9193,i__9064_9194,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9068_9211,map__9068_9212__$1,gline_9213,gcol_9214,name_9215,seq__9061_9205__$1,temp__5753__auto___9204__$1,vec__9058_9188,column_9189,column_info_9190,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9214], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9182,new cljs.core.Keyword(null,"col","col",-1959363084),column_9189,new cljs.core.Keyword(null,"name","name",1843675177),name_9215], null));
});})(seq__9061_9191,chunk__9062_9192,count__9063_9193,i__9064_9194,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9068_9211,map__9068_9212__$1,gline_9213,gcol_9214,name_9215,seq__9061_9205__$1,temp__5753__auto___9204__$1,vec__9058_9188,column_9189,column_info_9190,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted))
,cljs.core.sorted_map.call(null)));


var G__9216 = cljs.core.next.call(null,seq__9061_9205__$1);
var G__9217 = null;
var G__9218 = (0);
var G__9219 = (0);
seq__9061_9191 = G__9216;
chunk__9062_9192 = G__9217;
count__9063_9193 = G__9218;
i__9064_9194 = G__9219;
continue;
}
} else {
}
}
break;
}


var G__9220 = seq__9032_9184;
var G__9221 = chunk__9033_9185;
var G__9222 = count__9034_9186;
var G__9223 = (i__9035_9187 + (1));
seq__9032_9184 = G__9220;
chunk__9033_9185 = G__9221;
count__9034_9186 = G__9222;
i__9035_9187 = G__9223;
continue;
} else {
var temp__5753__auto___9224__$1 = cljs.core.seq.call(null,seq__9032_9184);
if(temp__5753__auto___9224__$1){
var seq__9032_9225__$1 = temp__5753__auto___9224__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9032_9225__$1)){
var c__4638__auto___9226 = cljs.core.chunk_first.call(null,seq__9032_9225__$1);
var G__9227 = cljs.core.chunk_rest.call(null,seq__9032_9225__$1);
var G__9228 = c__4638__auto___9226;
var G__9229 = cljs.core.count.call(null,c__4638__auto___9226);
var G__9230 = (0);
seq__9032_9184 = G__9227;
chunk__9033_9185 = G__9228;
count__9034_9186 = G__9229;
i__9035_9187 = G__9230;
continue;
} else {
var vec__9069_9231 = cljs.core.first.call(null,seq__9032_9225__$1);
var column_9232 = cljs.core.nth.call(null,vec__9069_9231,(0),null);
var column_info_9233 = cljs.core.nth.call(null,vec__9069_9231,(1),null);
var seq__9072_9234 = cljs.core.seq.call(null,column_info_9233);
var chunk__9073_9235 = null;
var count__9074_9236 = (0);
var i__9075_9237 = (0);
while(true){
if((i__9075_9237 < count__9074_9236)){
var map__9078_9238 = cljs.core._nth.call(null,chunk__9073_9235,i__9075_9237);
var map__9078_9239__$1 = cljs.core.__destructure_map.call(null,map__9078_9238);
var gline_9240 = cljs.core.get.call(null,map__9078_9239__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9241 = cljs.core.get.call(null,map__9078_9239__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9242 = cljs.core.get.call(null,map__9078_9239__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9240], null),cljs.core.fnil.call(null,((function (seq__9072_9234,chunk__9073_9235,count__9074_9236,i__9075_9237,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9078_9238,map__9078_9239__$1,gline_9240,gcol_9241,name_9242,vec__9069_9231,column_9232,column_info_9233,seq__9032_9225__$1,temp__5753__auto___9224__$1,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9241], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9182,new cljs.core.Keyword(null,"col","col",-1959363084),column_9232,new cljs.core.Keyword(null,"name","name",1843675177),name_9242], null));
});})(seq__9072_9234,chunk__9073_9235,count__9074_9236,i__9075_9237,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9078_9238,map__9078_9239__$1,gline_9240,gcol_9241,name_9242,vec__9069_9231,column_9232,column_info_9233,seq__9032_9225__$1,temp__5753__auto___9224__$1,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted))
,cljs.core.sorted_map.call(null)));


var G__9243 = seq__9072_9234;
var G__9244 = chunk__9073_9235;
var G__9245 = count__9074_9236;
var G__9246 = (i__9075_9237 + (1));
seq__9072_9234 = G__9243;
chunk__9073_9235 = G__9244;
count__9074_9236 = G__9245;
i__9075_9237 = G__9246;
continue;
} else {
var temp__5753__auto___9247__$2 = cljs.core.seq.call(null,seq__9072_9234);
if(temp__5753__auto___9247__$2){
var seq__9072_9248__$1 = temp__5753__auto___9247__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9072_9248__$1)){
var c__4638__auto___9249 = cljs.core.chunk_first.call(null,seq__9072_9248__$1);
var G__9250 = cljs.core.chunk_rest.call(null,seq__9072_9248__$1);
var G__9251 = c__4638__auto___9249;
var G__9252 = cljs.core.count.call(null,c__4638__auto___9249);
var G__9253 = (0);
seq__9072_9234 = G__9250;
chunk__9073_9235 = G__9251;
count__9074_9236 = G__9252;
i__9075_9237 = G__9253;
continue;
} else {
var map__9079_9254 = cljs.core.first.call(null,seq__9072_9248__$1);
var map__9079_9255__$1 = cljs.core.__destructure_map.call(null,map__9079_9254);
var gline_9256 = cljs.core.get.call(null,map__9079_9255__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_9257 = cljs.core.get.call(null,map__9079_9255__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_9258 = cljs.core.get.call(null,map__9079_9255__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9256], null),cljs.core.fnil.call(null,((function (seq__9072_9234,chunk__9073_9235,count__9074_9236,i__9075_9237,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9079_9254,map__9079_9255__$1,gline_9256,gcol_9257,name_9258,seq__9072_9248__$1,temp__5753__auto___9247__$2,vec__9069_9231,column_9232,column_info_9233,seq__9032_9225__$1,temp__5753__auto___9224__$1,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9257], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_9182,new cljs.core.Keyword(null,"col","col",-1959363084),column_9232,new cljs.core.Keyword(null,"name","name",1843675177),name_9258], null));
});})(seq__9072_9234,chunk__9073_9235,count__9074_9236,i__9075_9237,seq__9032_9184,chunk__9033_9185,count__9034_9186,i__9035_9187,seq__8872_9080,chunk__8873_9081,count__8874_9082,i__8875_9083,map__9079_9254,map__9079_9255__$1,gline_9256,gcol_9257,name_9258,seq__9072_9248__$1,temp__5753__auto___9247__$2,vec__9069_9231,column_9232,column_info_9233,seq__9032_9225__$1,temp__5753__auto___9224__$1,vec__9029_9181,line_9182,columns_9183,seq__8872_9175__$1,temp__5753__auto___9174,inverted))
,cljs.core.sorted_map.call(null)));


var G__9259 = cljs.core.next.call(null,seq__9072_9248__$1);
var G__9260 = null;
var G__9261 = (0);
var G__9262 = (0);
seq__9072_9234 = G__9259;
chunk__9073_9235 = G__9260;
count__9074_9236 = G__9261;
i__9075_9237 = G__9262;
continue;
}
} else {
}
}
break;
}


var G__9263 = cljs.core.next.call(null,seq__9032_9225__$1);
var G__9264 = null;
var G__9265 = (0);
var G__9266 = (0);
seq__9032_9184 = G__9263;
chunk__9033_9185 = G__9264;
count__9034_9186 = G__9265;
i__9035_9187 = G__9266;
continue;
}
} else {
}
}
break;
}


var G__9267 = cljs.core.next.call(null,seq__8872_9175__$1);
var G__9268 = null;
var G__9269 = (0);
var G__9270 = (0);
seq__8872_9080 = G__9267;
chunk__8873_9081 = G__9268;
count__8874_9082 = G__9269;
i__8875_9083 = G__9270;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
