// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4824__auto__ = [];
var len__4818__auto___80746 = arguments.length;
var i__4819__auto___80747 = (0);
while(true){
if((i__4819__auto___80747 < len__4818__auto___80746)){
args__4824__auto__.push((arguments[i__4819__auto___80747]));

var G__80748 = (i__4819__auto___80747 + (1));
i__4819__auto___80747 = G__80748;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__80678){
var vec__80679 = p__80678;
var opts = cljs.core.nth.call(null,vec__80679,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__16345__auto___80749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80723){
var state_val_80724 = (state_80723[(1)]);
if((state_val_80724 === (7))){
var inst_80700 = (state_80723[(7)]);
var inst_80709 = (state_80723[(8)]);
var inst_80711 = fluree.db.time_travel.as_of_block.call(null,inst_80709,inst_80700);
var state_80723__$1 = state_80723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80723__$1,(10),inst_80711);
} else {
if((state_val_80724 === (1))){
var state_80723__$1 = state_80723;
var statearr_80725_80750 = state_80723__$1;
(statearr_80725_80750[(2)] = null);

(statearr_80725_80750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (4))){
var inst_80682 = (state_80723[(2)]);
var inst_80683 = fluree.db.util.log.error.call(null,inst_80682);
var inst_80684 = cljs.core.async.put_BANG_.call(null,pc,inst_80682);
var inst_80685 = cljs.core.async.close_BANG_.call(null,pc);
var state_80723__$1 = (function (){var statearr_80726 = state_80723;
(statearr_80726[(9)] = inst_80683);

(statearr_80726[(10)] = inst_80684);

return statearr_80726;
})();
var statearr_80727_80751 = state_80723__$1;
(statearr_80727_80751[(2)] = inst_80685);

(statearr_80727_80751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (6))){
var inst_80700 = (state_80723[(7)]);
var inst_80703 = (state_80723[(11)]);
var inst_80704 = (state_80723[(12)]);
var inst_80707 = (state_80723[(2)]);
var inst_80708 = fluree.db.util.async.throw_err.call(null,inst_80707);
var inst_80709 = cljs.core.assoc.call(null,inst_80708,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_80703,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_80704);
var state_80723__$1 = (function (){var statearr_80728 = state_80723;
(statearr_80728[(8)] = inst_80709);

return statearr_80728;
})();
if(cljs.core.truth_(inst_80700)){
var statearr_80729_80752 = state_80723__$1;
(statearr_80729_80752[(1)] = (7));

} else {
var statearr_80730_80753 = state_80723__$1;
(statearr_80730_80753[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (3))){
var inst_80721 = (state_80723[(2)]);
var state_80723__$1 = state_80723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80723__$1,inst_80721);
} else {
if((state_val_80724 === (2))){
var _ = (function (){var statearr_80732 = state_80723;
(statearr_80732[(4)] = cljs.core.cons.call(null,(5),(state_80723[(4)])));

return statearr_80732;
})();
var inst_80695 = opts;
var inst_80696 = cljs.core.__destructure_map.call(null,inst_80695);
var inst_80697 = cljs.core.get.call(null,inst_80696,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_80698 = cljs.core.get.call(null,inst_80696,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_80699 = cljs.core.get.call(null,inst_80696,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_80700 = cljs.core.get.call(null,inst_80696,new cljs.core.Keyword(null,"block","block",664686210));
var inst_80701 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_80702 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_80703 = cljs.core.nth.call(null,inst_80702,(0),null);
var inst_80704 = cljs.core.nth.call(null,inst_80702,(1),null);
var inst_80705 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_80723__$1 = (function (){var statearr_80733 = state_80723;
(statearr_80733[(7)] = inst_80700);

(statearr_80733[(13)] = inst_80697);

(statearr_80733[(11)] = inst_80703);

(statearr_80733[(14)] = inst_80699);

(statearr_80733[(12)] = inst_80704);

(statearr_80733[(15)] = inst_80698);

(statearr_80733[(16)] = inst_80701);

return statearr_80733;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80723__$1,(6),inst_80705);
} else {
if((state_val_80724 === (9))){
var inst_80717 = (state_80723[(2)]);
var inst_80718 = cljs.core.async.put_BANG_.call(null,pc,inst_80717);
var _ = (function (){var statearr_80734 = state_80723;
(statearr_80734[(4)] = cljs.core.rest.call(null,(state_80723[(4)])));

return statearr_80734;
})();
var state_80723__$1 = state_80723;
var statearr_80735_80754 = state_80723__$1;
(statearr_80735_80754[(2)] = inst_80718);

(statearr_80735_80754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (5))){
var _ = (function (){var statearr_80736 = state_80723;
(statearr_80736[(4)] = cljs.core.rest.call(null,(state_80723[(4)])));

return statearr_80736;
})();
var state_80723__$1 = state_80723;
var ex80731 = (state_80723__$1[(2)]);
var statearr_80737_80755 = state_80723__$1;
(statearr_80737_80755[(5)] = ex80731);


var statearr_80738_80756 = state_80723__$1;
(statearr_80738_80756[(1)] = (4));

(statearr_80738_80756[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (10))){
var inst_80713 = (state_80723[(2)]);
var inst_80714 = fluree.db.util.async.throw_err.call(null,inst_80713);
var state_80723__$1 = state_80723;
var statearr_80739_80757 = state_80723__$1;
(statearr_80739_80757[(2)] = inst_80714);

(statearr_80739_80757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80724 === (8))){
var inst_80709 = (state_80723[(8)]);
var state_80723__$1 = state_80723;
var statearr_80740_80758 = state_80723__$1;
(statearr_80740_80758[(2)] = inst_80709);

(statearr_80740_80758[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_80741 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80741[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_80741[(1)] = (1));

return statearr_80741;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_80723){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80742){var ex__16224__auto__ = e80742;
var statearr_80743_80759 = state_80723;
(statearr_80743_80759[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80723[(4)]))){
var statearr_80744_80760 = state_80723;
(statearr_80744_80760[(1)] = cljs.core.first.call(null,(state_80723[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80761 = state_80723;
state_80723 = G__80761;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_80723){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_80723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80745 = f__16346__auto__.call(null);
(statearr_80745[(6)] = c__16345__auto___80749);

return statearr_80745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq80675){
var G__80676 = cljs.core.first.call(null,seq80675);
var seq80675__$1 = cljs.core.next.call(null,seq80675);
var G__80677 = cljs.core.first.call(null,seq80675__$1);
var seq80675__$2 = cljs.core.next.call(null,seq80675__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80676,G__80677,seq80675__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4210__auto__){
var and__4210__auto____$1 = open_api;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4210__auto__){
return open_api;
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4210__auto__){
return auth;
} else {
return and__4210__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__80763 = arguments.length;
switch (G__80763) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80889){
var state_val_80890 = (state_80889[(1)]);
if((state_val_80890 === (7))){
var inst_80789 = (state_80889[(7)]);
var inst_80779 = (state_80889[(8)]);
var inst_80791 = fluree.db.time_travel.as_of_block.call(null,inst_80789,inst_80779);
var state_80889__$1 = state_80889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80889__$1,(10),inst_80791);
} else {
if((state_val_80890 === (20))){
var inst_80783 = (state_80889[(9)]);
var state_80889__$1 = state_80889;
var statearr_80891_80971 = state_80889__$1;
(statearr_80891_80971[(2)] = inst_80783);

(statearr_80891_80971[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (27))){
var inst_80777 = (state_80889[(10)]);
var state_80889__$1 = state_80889;
var statearr_80892_80972 = state_80889__$1;
(statearr_80892_80972[(2)] = inst_80777);

(statearr_80892_80972[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (1))){
var state_80889__$1 = state_80889;
var statearr_80893_80973 = state_80889__$1;
(statearr_80893_80973[(2)] = null);

(statearr_80893_80973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (24))){
var inst_80786 = (state_80889[(11)]);
var state_80889__$1 = state_80889;
if(cljs.core.truth_(inst_80786)){
var statearr_80894_80974 = state_80889__$1;
(statearr_80894_80974[(1)] = (26));

} else {
var statearr_80895_80975 = state_80889__$1;
(statearr_80895_80975[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (39))){
var inst_80851 = (state_80889[(12)]);
var inst_80854 = cljs.core.ex_data.call(null,inst_80851);
var inst_80855 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80856 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_80854);
var inst_80857 = cljs.core.ex_message.call(null,inst_80851);
var inst_80858 = [inst_80856,inst_80857,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_80859 = cljs.core.PersistentHashMap.fromArrays(inst_80855,inst_80858);
var state_80889__$1 = state_80889;
var statearr_80896_80976 = state_80889__$1;
(statearr_80896_80976[(2)] = inst_80859);

(statearr_80896_80976[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (46))){
var inst_80851 = (state_80889[(12)]);
var state_80889__$1 = state_80889;
var statearr_80897_80977 = state_80889__$1;
(statearr_80897_80977[(2)] = inst_80851);

(statearr_80897_80977[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (4))){
var inst_80764 = (state_80889[(2)]);
var inst_80765 = fluree.db.util.log.error.call(null,inst_80764);
var inst_80766 = cljs.core.ex_data.call(null,inst_80764);
var inst_80767 = cljs.core.ex_message.call(null,inst_80764);
var inst_80768 = cljs.core.assoc.call(null,inst_80766,new cljs.core.Keyword(null,"message","message",-406056002),inst_80767);
var state_80889__$1 = (function (){var statearr_80898 = state_80889;
(statearr_80898[(13)] = inst_80765);

return statearr_80898;
})();
var statearr_80899_80978 = state_80889__$1;
(statearr_80899_80978[(2)] = inst_80768);

(statearr_80899_80978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (15))){
var state_80889__$1 = state_80889;
var statearr_80900_80979 = state_80889__$1;
(statearr_80900_80979[(2)] = (1000000));

(statearr_80900_80979[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (48))){
var inst_80851 = (state_80889[(12)]);
var state_80889__$1 = state_80889;
var statearr_80901_80980 = state_80889__$1;
(statearr_80901_80980[(2)] = inst_80851);

(statearr_80901_80980[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (50))){
var inst_80878 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80902_80981 = state_80889__$1;
(statearr_80902_80981[(2)] = inst_80878);

(statearr_80902_80981[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (21))){
var inst_80782 = (state_80889[(14)]);
var state_80889__$1 = state_80889;
if(cljs.core.truth_(inst_80782)){
var statearr_80903_80982 = state_80889__$1;
(statearr_80903_80982[(1)] = (23));

} else {
var statearr_80904_80983 = state_80889__$1;
(statearr_80904_80983[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (31))){
var inst_80840 = (state_80889[(2)]);
var inst_80841 = cljs.core.not.call(null,inst_80840);
var state_80889__$1 = state_80889;
if(inst_80841){
var statearr_80905_80984 = state_80889__$1;
(statearr_80905_80984[(1)] = (35));

} else {
var statearr_80906_80985 = state_80889__$1;
(statearr_80906_80985[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (32))){
var inst_80784 = (state_80889[(15)]);
var state_80889__$1 = state_80889;
var statearr_80907_80986 = state_80889__$1;
(statearr_80907_80986[(2)] = inst_80784);

(statearr_80907_80986[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (40))){
var inst_80814 = (state_80889[(16)]);
var state_80889__$1 = state_80889;
if(cljs.core.truth_(inst_80814)){
var statearr_80908_80987 = state_80889__$1;
(statearr_80908_80987[(1)] = (42));

} else {
var statearr_80909_80988 = state_80889__$1;
(statearr_80909_80988[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (33))){
var inst_80780 = (state_80889[(17)]);
var state_80889__$1 = state_80889;
var statearr_80910_80989 = state_80889__$1;
(statearr_80910_80989[(2)] = inst_80780);

(statearr_80910_80989[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (13))){
var inst_80785 = (state_80889[(18)]);
var inst_80809 = (state_80889[(19)]);
var inst_80807 = (state_80889[(2)]);
var inst_80808 = cljs.core.volatile_BANG_.call(null,(0));
var inst_80809__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_80785);
var state_80889__$1 = (function (){var statearr_80911 = state_80889;
(statearr_80911[(20)] = inst_80808);

(statearr_80911[(19)] = inst_80809__$1);

(statearr_80911[(21)] = inst_80807);

return statearr_80911;
})();
if(cljs.core.truth_(inst_80809__$1)){
var statearr_80912_80990 = state_80889__$1;
(statearr_80912_80990[(1)] = (14));

} else {
var statearr_80913_80991 = state_80889__$1;
(statearr_80913_80991[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (22))){
var inst_80830 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80914_80992 = state_80889__$1;
(statearr_80914_80992[(2)] = inst_80830);

(statearr_80914_80992[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (36))){
var inst_80816 = (state_80889[(22)]);
var inst_80797 = (state_80889[(23)]);
var inst_80847 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_80816);
var inst_80848 = fluree.db.query.fql.query.call(null,inst_80797,inst_80847);
var state_80889__$1 = state_80889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80889__$1,(38),inst_80848);
} else {
if((state_val_80890 === (41))){
var inst_80882 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80915_80993 = state_80889__$1;
(statearr_80915_80993[(2)] = inst_80882);

(statearr_80915_80993[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (43))){
var state_80889__$1 = state_80889;
var statearr_80916_80994 = state_80889__$1;
(statearr_80916_80994[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (29))){
var inst_80784 = (state_80889[(15)]);
var state_80889__$1 = state_80889;
if(cljs.core.truth_(inst_80784)){
var statearr_80918_80995 = state_80889__$1;
(statearr_80918_80995[(1)] = (32));

} else {
var statearr_80919_80996 = state_80889__$1;
(statearr_80919_80996[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (44))){
var inst_80880 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80920_80997 = state_80889__$1;
(statearr_80920_80997[(2)] = inst_80880);

(statearr_80920_80997[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (6))){
var inst_80779 = (state_80889[(8)]);
var inst_80788 = (state_80889[(2)]);
var inst_80789 = fluree.db.util.async.throw_err.call(null,inst_80788);
var state_80889__$1 = (function (){var statearr_80921 = state_80889;
(statearr_80921[(7)] = inst_80789);

return statearr_80921;
})();
if(cljs.core.truth_(inst_80779)){
var statearr_80922_80998 = state_80889__$1;
(statearr_80922_80998[(1)] = (7));

} else {
var statearr_80923_80999 = state_80889__$1;
(statearr_80923_80999[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (28))){
var inst_80826 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80924_81000 = state_80889__$1;
(statearr_80924_81000[(2)] = inst_80826);

(statearr_80924_81000[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (25))){
var inst_80828 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80925_81001 = state_80889__$1;
(statearr_80925_81001[(2)] = inst_80828);

(statearr_80925_81001[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (34))){
var inst_80837 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
var statearr_80926_81002 = state_80889__$1;
(statearr_80926_81002[(2)] = inst_80837);

(statearr_80926_81002[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (17))){
var inst_80778 = (state_80889[(24)]);
var state_80889__$1 = state_80889;
var statearr_80927_81003 = state_80889__$1;
(statearr_80927_81003[(2)] = inst_80778);

(statearr_80927_81003[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (3))){
var inst_80887 = (state_80889[(2)]);
var state_80889__$1 = state_80889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80889__$1,inst_80887);
} else {
if((state_val_80890 === (12))){
var inst_80805 = cljs.core.PersistentHashMap.EMPTY;
var state_80889__$1 = state_80889;
var statearr_80928_81004 = state_80889__$1;
(statearr_80928_81004[(2)] = inst_80805);

(statearr_80928_81004[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (2))){
var _ = (function (){var statearr_80929 = state_80889;
(statearr_80929[(4)] = cljs.core.cons.call(null,(5),(state_80889[(4)])));

return statearr_80929;
})();
var inst_80775 = query_map;
var inst_80776 = cljs.core.__destructure_map.call(null,inst_80775);
var inst_80777 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_80778 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_80779 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"block","block",664686210));
var inst_80780 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_80781 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_80782 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_80783 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_80784 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_80785 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_80786 = cljs.core.get.call(null,inst_80776,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_80889__$1 = (function (){var statearr_80930 = state_80889;
(statearr_80930[(9)] = inst_80783);

(statearr_80930[(25)] = inst_80781);

(statearr_80930[(11)] = inst_80786);

(statearr_80930[(14)] = inst_80782);

(statearr_80930[(17)] = inst_80780);

(statearr_80930[(15)] = inst_80784);

(statearr_80930[(18)] = inst_80785);

(statearr_80930[(8)] = inst_80779);

(statearr_80930[(10)] = inst_80777);

(statearr_80930[(24)] = inst_80778);

return statearr_80930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80889__$1,(6),sources);
} else {
if((state_val_80890 === (23))){
var inst_80782 = (state_80889[(14)]);
var state_80889__$1 = state_80889;
var statearr_80931_81005 = state_80889__$1;
(statearr_80931_81005[(2)] = inst_80782);

(statearr_80931_81005[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (47))){
var inst_80808 = (state_80889[(20)]);
var inst_80862 = (state_80889[(26)]);
var inst_80815 = (state_80889[(27)]);
var inst_80797 = (state_80889[(23)]);
var inst_80868 = (state_80889[(2)]);
var inst_80869 = cljs.core.deref.call(null,inst_80808);
var inst_80870 = fluree.db.util.core.response_time_formatted.call(null,inst_80815);
var inst_80871 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_80797);
var inst_80872 = [(200),inst_80868,inst_80869,inst_80870,inst_80871];
var inst_80873 = cljs.core.PersistentHashMap.fromArrays(inst_80862,inst_80872);
var state_80889__$1 = state_80889;
var statearr_80932_81006 = state_80889__$1;
(statearr_80932_81006[(2)] = inst_80873);

(statearr_80932_81006[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (35))){
var inst_80843 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80844 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_80845 = cljs.core.PersistentHashMap.fromArrays(inst_80843,inst_80844);
var state_80889__$1 = state_80889;
var statearr_80933_81007 = state_80889__$1;
(statearr_80933_81007[(2)] = inst_80845);

(statearr_80933_81007[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (19))){
var inst_80832 = (state_80889[(28)]);
var inst_80832__$1 = (state_80889[(2)]);
var state_80889__$1 = (function (){var statearr_80934 = state_80889;
(statearr_80934[(28)] = inst_80832__$1);

return statearr_80934;
})();
if(cljs.core.truth_(inst_80832__$1)){
var statearr_80935_81008 = state_80889__$1;
(statearr_80935_81008[(1)] = (29));

} else {
var statearr_80936_81009 = state_80889__$1;
(statearr_80936_81009[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (11))){
var inst_80781 = (state_80889[(25)]);
var inst_80798 = (state_80889[(29)]);
var inst_80797 = (state_80889[(23)]);
var inst_80800 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_80797);
var inst_80801 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_80798);
var inst_80802 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_80797);
var inst_80803 = fluree.db.api_js.get_sources.call(null,inst_80798,inst_80800,inst_80801,inst_80802,inst_80781,db_fn);
var state_80889__$1 = state_80889;
var statearr_80938_81010 = state_80889__$1;
(statearr_80938_81010[(2)] = inst_80803);

(statearr_80938_81010[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (9))){
var inst_80781 = (state_80889[(25)]);
var inst_80797 = (state_80889[(23)]);
var inst_80797__$1 = (state_80889[(2)]);
var inst_80798 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_80797__$1);
var state_80889__$1 = (function (){var statearr_80939 = state_80889;
(statearr_80939[(29)] = inst_80798);

(statearr_80939[(23)] = inst_80797__$1);

return statearr_80939;
})();
if(cljs.core.truth_(inst_80781)){
var statearr_80940_81011 = state_80889__$1;
(statearr_80940_81011[(1)] = (11));

} else {
var statearr_80941_81012 = state_80889__$1;
(statearr_80941_81012[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (5))){
var _ = (function (){var statearr_80942 = state_80889;
(statearr_80942[(4)] = cljs.core.rest.call(null,(state_80889[(4)])));

return statearr_80942;
})();
var state_80889__$1 = state_80889;
var ex80937 = (state_80889__$1[(2)]);
var statearr_80943_81013 = state_80889__$1;
(statearr_80943_81013[(5)] = ex80937);


var statearr_80944_81014 = state_80889__$1;
(statearr_80944_81014[(1)] = (4));

(statearr_80944_81014[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (14))){
var inst_80809 = (state_80889[(19)]);
var state_80889__$1 = state_80889;
var statearr_80945_81015 = state_80889__$1;
(statearr_80945_81015[(2)] = inst_80809);

(statearr_80945_81015[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (45))){
var inst_80851 = (state_80889[(12)]);
var inst_80865 = cljs.core.doall.call(null,inst_80851);
var state_80889__$1 = state_80889;
var statearr_80946_81016 = state_80889__$1;
(statearr_80946_81016[(2)] = inst_80865);

(statearr_80946_81016[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (26))){
var inst_80786 = (state_80889[(11)]);
var state_80889__$1 = state_80889;
var statearr_80947_81017 = state_80889__$1;
(statearr_80947_81017[(2)] = inst_80786);

(statearr_80947_81017[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (16))){
var inst_80808 = (state_80889[(20)]);
var inst_80785 = (state_80889[(18)]);
var inst_80807 = (state_80889[(21)]);
var inst_80778 = (state_80889[(24)]);
var inst_80813 = (state_80889[(2)]);
var inst_80814 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_80785);
var inst_80815 = fluree.db.util.core.current_time_millis.call(null);
var inst_80816 = cljs.core.assoc.call(null,inst_80785,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_80807,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_80813,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_80808);
var state_80889__$1 = (function (){var statearr_80948 = state_80889;
(statearr_80948[(16)] = inst_80814);

(statearr_80948[(22)] = inst_80816);

(statearr_80948[(27)] = inst_80815);

return statearr_80948;
})();
if(cljs.core.truth_(inst_80778)){
var statearr_80949_81018 = state_80889__$1;
(statearr_80949_81018[(1)] = (17));

} else {
var statearr_80950_81019 = state_80889__$1;
(statearr_80950_81019[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (38))){
var inst_80851 = (state_80889[(12)]);
var inst_80850 = (state_80889[(2)]);
var inst_80851__$1 = fluree.db.util.async.throw_err.call(null,inst_80850);
var inst_80852 = (inst_80851__$1 instanceof cljs.core.ExceptionInfo);
var state_80889__$1 = (function (){var statearr_80951 = state_80889;
(statearr_80951[(12)] = inst_80851__$1);

return statearr_80951;
})();
if(cljs.core.truth_(inst_80852)){
var statearr_80952_81020 = state_80889__$1;
(statearr_80952_81020[(1)] = (39));

} else {
var statearr_80953_81021 = state_80889__$1;
(statearr_80953_81021[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (30))){
var inst_80832 = (state_80889[(28)]);
var state_80889__$1 = state_80889;
var statearr_80954_81022 = state_80889__$1;
(statearr_80954_81022[(2)] = inst_80832);

(statearr_80954_81022[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (10))){
var inst_80793 = (state_80889[(2)]);
var inst_80794 = fluree.db.util.async.throw_err.call(null,inst_80793);
var state_80889__$1 = state_80889;
var statearr_80955_81023 = state_80889__$1;
(statearr_80955_81023[(2)] = inst_80794);

(statearr_80955_81023[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (18))){
var inst_80783 = (state_80889[(9)]);
var state_80889__$1 = state_80889;
if(cljs.core.truth_(inst_80783)){
var statearr_80956_81024 = state_80889__$1;
(statearr_80956_81024[(1)] = (20));

} else {
var statearr_80957_81025 = state_80889__$1;
(statearr_80957_81025[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (42))){
var inst_80851 = (state_80889[(12)]);
var inst_80862 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_80863 = cljs.core.sequential_QMARK_.call(null,inst_80851);
var state_80889__$1 = (function (){var statearr_80958 = state_80889;
(statearr_80958[(26)] = inst_80862);

return statearr_80958;
})();
if(inst_80863){
var statearr_80959_81026 = state_80889__$1;
(statearr_80959_81026[(1)] = (45));

} else {
var statearr_80960_81027 = state_80889__$1;
(statearr_80960_81027[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (37))){
var inst_80884 = (state_80889[(2)]);
var _ = (function (){var statearr_80961 = state_80889;
(statearr_80961[(4)] = cljs.core.rest.call(null,(state_80889[(4)])));

return statearr_80961;
})();
var state_80889__$1 = state_80889;
var statearr_80962_81028 = state_80889__$1;
(statearr_80962_81028[(2)] = inst_80884);

(statearr_80962_81028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (8))){
var inst_80789 = (state_80889[(7)]);
var state_80889__$1 = state_80889;
var statearr_80963_81029 = state_80889__$1;
(statearr_80963_81029[(2)] = inst_80789);

(statearr_80963_81029[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80890 === (49))){
var state_80889__$1 = state_80889;
var statearr_80964_81030 = state_80889__$1;
(statearr_80964_81030[(2)] = null);

(statearr_80964_81030[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_80965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80965[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_80965[(1)] = (1));

return statearr_80965;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_80889){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80966){var ex__16224__auto__ = e80966;
var statearr_80967_81031 = state_80889;
(statearr_80967_81031[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80889[(4)]))){
var statearr_80968_81032 = state_80889;
(statearr_80968_81032[(1)] = cljs.core.first.call(null,(state_80889[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81033 = state_80889;
state_80889 = G__81033;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_80889){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_80889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80969 = f__16346__auto__.call(null);
(statearr_80969[(6)] = c__16345__auto__);

return statearr_80969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__81034_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__81034_SHARP_);
}));

var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81056){
var state_val_81057 = (state_81056[(1)]);
if((state_val_81057 === (1))){
var inst_81038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81039 = [resp_chan,timeout_chan];
var inst_81040 = (new cljs.core.PersistentVector(null,2,(5),inst_81038,inst_81039,null));
var state_81056__$1 = state_81056;
return cljs.core.async.ioc_alts_BANG_.call(null,state_81056__$1,(2),inst_81040);
} else {
if((state_val_81057 === (2))){
var inst_81042 = (state_81056[(2)]);
var inst_81043 = cljs.core.nth.call(null,inst_81042,(0),null);
var inst_81044 = cljs.core.nth.call(null,inst_81042,(1),null);
var inst_81045 = cljs.core._EQ_.call(null,timeout_chan,inst_81044);
var state_81056__$1 = (function (){var statearr_81058 = state_81056;
(statearr_81058[(7)] = inst_81043);

return statearr_81058;
})();
if(inst_81045){
var statearr_81059_81069 = state_81056__$1;
(statearr_81059_81069[(1)] = (3));

} else {
var statearr_81060_81070 = state_81056__$1;
(statearr_81060_81070[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81057 === (3))){
var inst_81047 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_81048 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_81049 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_81050 = [tid,(408),inst_81049];
var inst_81051 = cljs.core.PersistentHashMap.fromArrays(inst_81048,inst_81050);
var state_81056__$1 = (function (){var statearr_81061 = state_81056;
(statearr_81061[(8)] = inst_81047);

return statearr_81061;
})();
var statearr_81062_81071 = state_81056__$1;
(statearr_81062_81071[(2)] = inst_81051);

(statearr_81062_81071[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81057 === (4))){
var inst_81043 = (state_81056[(7)]);
var state_81056__$1 = state_81056;
var statearr_81063_81072 = state_81056__$1;
(statearr_81063_81072[(2)] = inst_81043);

(statearr_81063_81072[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81057 === (5))){
var inst_81054 = (state_81056[(2)]);
var state_81056__$1 = state_81056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81056__$1,inst_81054);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____0 = (function (){
var statearr_81064 = [null,null,null,null,null,null,null,null,null];
(statearr_81064[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__);

(statearr_81064[(1)] = (1));

return statearr_81064;
});
var fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____1 = (function (state_81056){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81065){var ex__16224__auto__ = e81065;
var statearr_81066_81073 = state_81056;
(statearr_81066_81073[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81056[(4)]))){
var statearr_81067_81074 = state_81056;
(statearr_81067_81074[(1)] = cljs.core.first.call(null,(state_81056[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81075 = state_81056;
state_81056 = G__81075;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__ = function(state_81056){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____1.call(this,state_81056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__16221__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81068 = f__16346__auto__.call(null);
(statearr_81068[(6)] = c__16345__auto__);

return statearr_81068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__81077 = arguments.length;
switch (G__81077) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__81078 = opts;
var map__81078__$1 = cljs.core.__destructure_map.call(null,map__81078);
var auth = cljs.core.get.call(null,map__81078__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__81078__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__81078__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__81078__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__81079 = (cljs.core.truth_((function (){var and__4210__auto__ = auth;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4210__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__81079,(0),null);
var authority = cljs.core.nth.call(null,vec__81079,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4212__auto__ = nonce;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4212__auto__ = expire;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e81082){var e = e81082;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__81085 = arguments.length;
switch (G__81085) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81151){
var state_val_81152 = (state_81151[(1)]);
if((state_val_81152 === (7))){
var inst_81107 = (state_81151[(7)]);
var inst_81106 = (state_81151[(8)]);
var inst_81104 = (state_81151[(9)]);
var inst_81105 = (state_81151[(10)]);
var inst_81102 = (state_81151[(11)]);
var inst_81120 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_81121 = [ledger,txn,inst_81102,inst_81104,inst_81105,inst_81106,inst_81107];
var inst_81122 = cljs.core.PersistentHashMap.fromArrays(inst_81120,inst_81121);
var inst_81123 = fluree.db.util.core.without_nils.call(null,inst_81122);
var inst_81124 = fluree.db.operations.transact_async.call(null,conn,inst_81123);
var state_81151__$1 = state_81151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81151__$1,(13),inst_81124);
} else {
if((state_val_81152 === (20))){
var inst_81142 = (state_81151[(2)]);
var state_81151__$1 = state_81151;
var statearr_81153_81189 = state_81151__$1;
(statearr_81153_81189[(2)] = inst_81142);

(statearr_81153_81189[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (1))){
var state_81151__$1 = state_81151;
var statearr_81154_81190 = state_81151__$1;
(statearr_81154_81190[(2)] = null);

(statearr_81154_81190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (4))){
var inst_81086 = (state_81151[(2)]);
var inst_81087 = fluree.db.util.log.error.call(null,inst_81086);
var inst_81088 = cljs.core.ex_data.call(null,inst_81086);
var inst_81089 = cljs.core.ex_message.call(null,inst_81086);
var inst_81090 = cljs.core.assoc.call(null,inst_81088,new cljs.core.Keyword(null,"message","message",-406056002),inst_81089);
var state_81151__$1 = (function (){var statearr_81155 = state_81151;
(statearr_81155[(12)] = inst_81087);

return statearr_81155;
})();
var statearr_81156_81191 = state_81151__$1;
(statearr_81156_81191[(2)] = inst_81090);

(statearr_81156_81191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (15))){
var inst_81101 = (state_81151[(13)]);
var inst_81126 = (state_81151[(14)]);
var inst_81129 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_81126,inst_81101);
var state_81151__$1 = state_81151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81151__$1,(17),inst_81129);
} else {
if((state_val_81152 === (13))){
var inst_81100 = (state_81151[(15)]);
var inst_81126 = (state_81151[(2)]);
var state_81151__$1 = (function (){var statearr_81157 = state_81151;
(statearr_81157[(14)] = inst_81126);

return statearr_81157;
})();
if(cljs.core.truth_(inst_81100)){
var statearr_81158_81192 = state_81151__$1;
(statearr_81158_81192[(1)] = (14));

} else {
var statearr_81159_81193 = state_81151__$1;
(statearr_81159_81193[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (6))){
var inst_81100 = (state_81151[(15)]);
var inst_81099 = (state_81151[(16)]);
var inst_81109 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_81099,opts);
var inst_81110 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_81109);
var inst_81111 = fluree.db.operations.command_async.call(null,conn,inst_81109);
var state_81151__$1 = (function (){var statearr_81160 = state_81151;
(statearr_81160[(17)] = inst_81111);

(statearr_81160[(18)] = inst_81110);

return statearr_81160;
})();
if(cljs.core.truth_(inst_81100)){
var statearr_81161_81194 = state_81151__$1;
(statearr_81161_81194[(1)] = (9));

} else {
var statearr_81162_81195 = state_81151__$1;
(statearr_81162_81195[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (17))){
var inst_81131 = (state_81151[(19)]);
var inst_81131__$1 = (state_81151[(2)]);
var inst_81132 = (inst_81131__$1 instanceof cljs.core.ExceptionInfo);
var state_81151__$1 = (function (){var statearr_81163 = state_81151;
(statearr_81163[(19)] = inst_81131__$1);

return statearr_81163;
})();
if(cljs.core.truth_(inst_81132)){
var statearr_81164_81196 = state_81151__$1;
(statearr_81164_81196[(1)] = (18));

} else {
var statearr_81165_81197 = state_81151__$1;
(statearr_81165_81197[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (3))){
var inst_81149 = (state_81151[(2)]);
var state_81151__$1 = state_81151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81151__$1,inst_81149);
} else {
if((state_val_81152 === (12))){
var inst_81116 = (state_81151[(2)]);
var state_81151__$1 = state_81151;
var statearr_81166_81198 = state_81151__$1;
(statearr_81166_81198[(2)] = inst_81116);

(statearr_81166_81198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (2))){
var inst_81099 = (state_81151[(16)]);
var _ = (function (){var statearr_81167 = state_81151;
(statearr_81167[(4)] = cljs.core.cons.call(null,(5),(state_81151[(4)])));

return statearr_81167;
})();
var inst_81097 = opts;
var inst_81098 = cljs.core.__destructure_map.call(null,inst_81097);
var inst_81099__$1 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_81100 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_81101 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_81102 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_81103 = fluree.db.util.core.current_time_millis.call(null);
var inst_81104 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_81103);
var inst_81105 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_81106 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_81107 = cljs.core.get.call(null,inst_81098,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_81151__$1 = (function (){var statearr_81168 = state_81151;
(statearr_81168[(7)] = inst_81107);

(statearr_81168[(8)] = inst_81106);

(statearr_81168[(9)] = inst_81104);

(statearr_81168[(15)] = inst_81100);

(statearr_81168[(13)] = inst_81101);

(statearr_81168[(16)] = inst_81099__$1);

(statearr_81168[(10)] = inst_81105);

(statearr_81168[(11)] = inst_81102);

return statearr_81168;
})();
if(cljs.core.truth_(inst_81099__$1)){
var statearr_81169_81199 = state_81151__$1;
(statearr_81169_81199[(1)] = (6));

} else {
var statearr_81170_81200 = state_81151__$1;
(statearr_81170_81200[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (19))){
var inst_81131 = (state_81151[(19)]);
var state_81151__$1 = state_81151;
var statearr_81171_81201 = state_81151__$1;
(statearr_81171_81201[(2)] = inst_81131);

(statearr_81171_81201[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (11))){
var inst_81118 = (state_81151[(2)]);
var state_81151__$1 = state_81151;
var statearr_81173_81202 = state_81151__$1;
(statearr_81173_81202[(2)] = inst_81118);

(statearr_81173_81202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (9))){
var inst_81111 = (state_81151[(17)]);
var state_81151__$1 = state_81151;
var statearr_81174_81203 = state_81151__$1;
(statearr_81174_81203[(2)] = inst_81111);

(statearr_81174_81203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (5))){
var _ = (function (){var statearr_81175 = state_81151;
(statearr_81175[(4)] = cljs.core.rest.call(null,(state_81151[(4)])));

return statearr_81175;
})();
var state_81151__$1 = state_81151;
var ex81172 = (state_81151__$1[(2)]);
var statearr_81176_81204 = state_81151__$1;
(statearr_81176_81204[(5)] = ex81172);


var statearr_81177_81205 = state_81151__$1;
(statearr_81177_81205[(1)] = (4));

(statearr_81177_81205[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (14))){
var inst_81126 = (state_81151[(14)]);
var state_81151__$1 = state_81151;
var statearr_81178_81206 = state_81151__$1;
(statearr_81178_81206[(2)] = inst_81126);

(statearr_81178_81206[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (16))){
var inst_81144 = (state_81151[(2)]);
var state_81151__$1 = state_81151;
var statearr_81179_81207 = state_81151__$1;
(statearr_81179_81207[(2)] = inst_81144);

(statearr_81179_81207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (10))){
var inst_81101 = (state_81151[(13)]);
var inst_81110 = (state_81151[(18)]);
var inst_81114 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_81110,inst_81101);
var state_81151__$1 = state_81151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81151__$1,(12),inst_81114);
} else {
if((state_val_81152 === (18))){
var inst_81131 = (state_81151[(19)]);
var inst_81134 = cljs.core.ex_data.call(null,inst_81131);
var inst_81135 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81136 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_81134);
var inst_81137 = cljs.core.ex_message.call(null,inst_81131);
var inst_81138 = [inst_81136,inst_81137,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_81139 = cljs.core.PersistentHashMap.fromArrays(inst_81135,inst_81138);
var state_81151__$1 = state_81151;
var statearr_81180_81208 = state_81151__$1;
(statearr_81180_81208[(2)] = inst_81139);

(statearr_81180_81208[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81152 === (8))){
var inst_81146 = (state_81151[(2)]);
var _ = (function (){var statearr_81181 = state_81151;
(statearr_81181[(4)] = cljs.core.rest.call(null,(state_81151[(4)])));

return statearr_81181;
})();
var state_81151__$1 = state_81151;
var statearr_81182_81209 = state_81151__$1;
(statearr_81182_81209[(2)] = inst_81146);

(statearr_81182_81209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_81183 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81183[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_81183[(1)] = (1));

return statearr_81183;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_81151){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81184){var ex__16224__auto__ = e81184;
var statearr_81185_81210 = state_81151;
(statearr_81185_81210[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81151[(4)]))){
var statearr_81186_81211 = state_81151;
(statearr_81186_81211[(1)] = cljs.core.first.call(null,(state_81151[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81212 = state_81151;
state_81151 = G__81212;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_81151){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_81151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81187 = f__16346__auto__.call(null);
(statearr_81187[(6)] = c__16345__auto__);

return statearr_81187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81214 = arguments.length;
var i__4819__auto___81215 = (0);
while(true){
if((i__4819__auto___81215 < len__4818__auto___81214)){
args__4824__auto__.push((arguments[i__4819__auto___81215]));

var G__81216 = (i__4819__auto___81215 + (1));
i__4819__auto___81215 = G__81216;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq81213){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq81213));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81247){
var state_val_81248 = (state_81247[(1)]);
if((state_val_81248 === (1))){
var inst_81217 = cljs.core.first.call(null,flakes);
var inst_81218 = cljs.core.rest.call(null,flakes);
var inst_81219 = cljs.core.PersistentVector.EMPTY;
var inst_81220 = inst_81217;
var inst_81221 = inst_81218;
var inst_81222 = inst_81219;
var state_81247__$1 = (function (){var statearr_81249 = state_81247;
(statearr_81249[(7)] = inst_81222);

(statearr_81249[(8)] = inst_81221);

(statearr_81249[(9)] = inst_81220);

return statearr_81249;
})();
var statearr_81250_81263 = state_81247__$1;
(statearr_81250_81263[(2)] = null);

(statearr_81250_81263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81248 === (2))){
var inst_81220 = (state_81247[(9)]);
var inst_81224 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_81225 = cljs.core.PersistentHashMap.EMPTY;
var inst_81226 = [true,inst_81225];
var inst_81227 = cljs.core.PersistentHashMap.fromArrays(inst_81224,inst_81226);
var inst_81228 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_81227,inst_81220);
var state_81247__$1 = state_81247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81247__$1,(4),inst_81228);
} else {
if((state_val_81248 === (3))){
var inst_81245 = (state_81247[(2)]);
var state_81247__$1 = state_81247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81247__$1,inst_81245);
} else {
if((state_val_81248 === (4))){
var inst_81222 = (state_81247[(7)]);
var inst_81221 = (state_81247[(8)]);
var inst_81230 = (state_81247[(2)]);
var inst_81231 = fluree.db.util.async.throw_err.call(null,inst_81230);
var inst_81232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81233 = [inst_81231];
var inst_81234 = (new cljs.core.PersistentVector(null,1,(5),inst_81232,inst_81233,null));
var inst_81235 = cljs.core.concat.call(null,inst_81222,inst_81234);
var inst_81236 = cljs.core.first.call(null,inst_81221);
var state_81247__$1 = (function (){var statearr_81251 = state_81247;
(statearr_81251[(10)] = inst_81235);

return statearr_81251;
})();
if(cljs.core.truth_(inst_81236)){
var statearr_81252_81264 = state_81247__$1;
(statearr_81252_81264[(1)] = (5));

} else {
var statearr_81253_81265 = state_81247__$1;
(statearr_81253_81265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81248 === (5))){
var inst_81221 = (state_81247[(8)]);
var inst_81235 = (state_81247[(10)]);
var inst_81238 = cljs.core.first.call(null,inst_81221);
var inst_81239 = cljs.core.rest.call(null,inst_81221);
var inst_81220 = inst_81238;
var inst_81221__$1 = inst_81239;
var inst_81222 = inst_81235;
var state_81247__$1 = (function (){var statearr_81254 = state_81247;
(statearr_81254[(7)] = inst_81222);

(statearr_81254[(8)] = inst_81221__$1);

(statearr_81254[(9)] = inst_81220);

return statearr_81254;
})();
var statearr_81255_81266 = state_81247__$1;
(statearr_81255_81266[(2)] = null);

(statearr_81255_81266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81248 === (6))){
var inst_81235 = (state_81247[(10)]);
var state_81247__$1 = state_81247;
var statearr_81256_81267 = state_81247__$1;
(statearr_81256_81267[(2)] = inst_81235);

(statearr_81256_81267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81248 === (7))){
var inst_81243 = (state_81247[(2)]);
var state_81247__$1 = state_81247;
var statearr_81257_81268 = state_81247__$1;
(statearr_81257_81268[(2)] = inst_81243);

(statearr_81257_81268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____0 = (function (){
var statearr_81258 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81258[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__);

(statearr_81258[(1)] = (1));

return statearr_81258;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____1 = (function (state_81247){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81259){var ex__16224__auto__ = e81259;
var statearr_81260_81269 = state_81247;
(statearr_81260_81269[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81247[(4)]))){
var statearr_81261_81270 = state_81247;
(statearr_81261_81270[(1)] = cljs.core.first.call(null,(state_81247[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81271 = state_81247;
state_81247 = G__81271;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__ = function(state_81247){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____1.call(this,state_81247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81262 = f__16346__auto__.call(null);
(statearr_81262[(6)] = c__16345__auto__);

return statearr_81262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81339){
var state_val_81340 = (state_81339[(1)]);
if((state_val_81340 === (7))){
var inst_81299 = (state_81339[(2)]);
var inst_81300 = fluree.db.util.async.throw_err.call(null,inst_81299);
var state_81339__$1 = state_81339;
var statearr_81341_81367 = state_81339__$1;
(statearr_81341_81367[(2)] = inst_81300);

(statearr_81341_81367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (1))){
var inst_81276 = cljs.core.volatile_BANG_.call(null,(0));
var inst_81277 = cljs.core.PersistentHashMap.EMPTY;
var inst_81278 = cljs.core.volatile_BANG_.call(null,inst_81277);
var inst_81279 = cljs.core.first.call(null,resp);
var inst_81280 = cljs.core.rest.call(null,resp);
var inst_81281 = cljs.core.PersistentVector.EMPTY;
var inst_81282 = inst_81276;
var inst_81283 = inst_81278;
var inst_81284 = inst_81279;
var inst_81285 = inst_81280;
var inst_81286 = inst_81281;
var state_81339__$1 = (function (){var statearr_81342 = state_81339;
(statearr_81342[(7)] = inst_81285);

(statearr_81342[(8)] = inst_81283);

(statearr_81342[(9)] = inst_81286);

(statearr_81342[(10)] = inst_81282);

(statearr_81342[(11)] = inst_81284);

return statearr_81342;
})();
var statearr_81343_81368 = state_81339__$1;
(statearr_81343_81368[(2)] = null);

(statearr_81343_81368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (4))){
var inst_81285 = (state_81339[(7)]);
var inst_81283 = (state_81339[(8)]);
var inst_81290 = (state_81339[(12)]);
var inst_81286 = (state_81339[(9)]);
var inst_81288 = (state_81339[(13)]);
var inst_81282 = (state_81339[(10)]);
var inst_81284 = (state_81339[(11)]);
var inst_81294 = (function (){var fuel = inst_81282;
var cache = inst_81283;
var curr_block = inst_81284;
var rest_blocks = inst_81285;
var acc = inst_81286;
var flakes = inst_81288;
var asserted = inst_81290;
return (function (p1__81273_SHARP_){
return p1__81273_SHARP_.s;
});
})();
var inst_81295 = cljs.core.group_by.call(null,inst_81294,inst_81290);
var inst_81296 = cljs.core.vals.call(null,inst_81295);
var inst_81297 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_81283,inst_81282,inst_81296);
var state_81339__$1 = state_81339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81339__$1,(7),inst_81297);
} else {
if((state_val_81340 === (13))){
var inst_81327 = (state_81339[(14)]);
var state_81339__$1 = state_81339;
var statearr_81344_81369 = state_81339__$1;
(statearr_81344_81369[(2)] = inst_81327);

(statearr_81344_81369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (6))){
var inst_81305 = (state_81339[(15)]);
var inst_81303 = (state_81339[(16)]);
var inst_81285 = (state_81339[(7)]);
var inst_81283 = (state_81339[(8)]);
var inst_81290 = (state_81339[(12)]);
var inst_81286 = (state_81339[(9)]);
var inst_81288 = (state_81339[(13)]);
var inst_81282 = (state_81339[(10)]);
var inst_81284 = (state_81339[(11)]);
var inst_81303__$1 = (state_81339[(2)]);
var inst_81304 = (function (){var fuel = inst_81282;
var cache = inst_81283;
var curr_block = inst_81284;
var rest_blocks = inst_81285;
var acc = inst_81286;
var flakes = inst_81288;
var asserted = inst_81290;
var asserted_SINGLEQUOTE_ = inst_81303__$1;
return (function (p1__81274_SHARP_){
return p1__81274_SHARP_.op === false;
});
})();
var inst_81305__$1 = cljs.core.filter.call(null,inst_81304,inst_81288);
var inst_81306 = cljs.core.empty_QMARK_.call(null,inst_81305__$1);
var inst_81307 = (!(inst_81306));
var state_81339__$1 = (function (){var statearr_81347 = state_81339;
(statearr_81347[(15)] = inst_81305__$1);

(statearr_81347[(16)] = inst_81303__$1);

return statearr_81347;
})();
if(inst_81307){
var statearr_81348_81370 = state_81339__$1;
(statearr_81348_81370[(1)] = (8));

} else {
var statearr_81349_81371 = state_81339__$1;
(statearr_81349_81371[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (3))){
var inst_81337 = (state_81339[(2)]);
var state_81339__$1 = state_81339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81339__$1,inst_81337);
} else {
if((state_val_81340 === (12))){
var inst_81285 = (state_81339[(7)]);
var inst_81283 = (state_81339[(8)]);
var inst_81327 = (state_81339[(14)]);
var inst_81282 = (state_81339[(10)]);
var inst_81330 = cljs.core.first.call(null,inst_81285);
var inst_81331 = cljs.core.rest.call(null,inst_81285);
var tmp81345 = inst_81283;
var tmp81346 = inst_81282;
var inst_81282__$1 = tmp81346;
var inst_81283__$1 = tmp81345;
var inst_81284 = inst_81330;
var inst_81285__$1 = inst_81331;
var inst_81286 = inst_81327;
var state_81339__$1 = (function (){var statearr_81350 = state_81339;
(statearr_81350[(7)] = inst_81285__$1);

(statearr_81350[(8)] = inst_81283__$1);

(statearr_81350[(9)] = inst_81286);

(statearr_81350[(10)] = inst_81282__$1);

(statearr_81350[(11)] = inst_81284);

return statearr_81350;
})();
var statearr_81351_81372 = state_81339__$1;
(statearr_81351_81372[(2)] = null);

(statearr_81351_81372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (2))){
var inst_81285 = (state_81339[(7)]);
var inst_81283 = (state_81339[(8)]);
var inst_81290 = (state_81339[(12)]);
var inst_81286 = (state_81339[(9)]);
var inst_81288 = (state_81339[(13)]);
var inst_81282 = (state_81339[(10)]);
var inst_81284 = (state_81339[(11)]);
var inst_81288__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_81284);
var inst_81289 = (function (){var fuel = inst_81282;
var cache = inst_81283;
var curr_block = inst_81284;
var rest_blocks = inst_81285;
var acc = inst_81286;
var flakes = inst_81288__$1;
return (function (p1__81272_SHARP_){
return p1__81272_SHARP_.op;
});
})();
var inst_81290__$1 = cljs.core.filter.call(null,inst_81289,inst_81288__$1);
var inst_81291 = cljs.core.empty_QMARK_.call(null,inst_81290__$1);
var inst_81292 = (!(inst_81291));
var state_81339__$1 = (function (){var statearr_81352 = state_81339;
(statearr_81352[(12)] = inst_81290__$1);

(statearr_81352[(13)] = inst_81288__$1);

return statearr_81352;
})();
if(inst_81292){
var statearr_81353_81373 = state_81339__$1;
(statearr_81353_81373[(1)] = (4));

} else {
var statearr_81354_81374 = state_81339__$1;
(statearr_81354_81374[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (11))){
var inst_81315 = (state_81339[(2)]);
var inst_81316 = fluree.db.util.async.throw_err.call(null,inst_81315);
var state_81339__$1 = state_81339;
var statearr_81355_81375 = state_81339__$1;
(statearr_81355_81375[(2)] = inst_81316);

(statearr_81355_81375[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (9))){
var state_81339__$1 = state_81339;
var statearr_81356_81376 = state_81339__$1;
(statearr_81356_81376[(2)] = null);

(statearr_81356_81376[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (5))){
var state_81339__$1 = state_81339;
var statearr_81357_81377 = state_81339__$1;
(statearr_81357_81377[(2)] = null);

(statearr_81357_81377[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (14))){
var inst_81335 = (state_81339[(2)]);
var state_81339__$1 = state_81339;
var statearr_81358_81378 = state_81339__$1;
(statearr_81358_81378[(2)] = inst_81335);

(statearr_81358_81378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (10))){
var inst_81303 = (state_81339[(16)]);
var inst_81285 = (state_81339[(7)]);
var inst_81286 = (state_81339[(9)]);
var inst_81284 = (state_81339[(11)]);
var inst_81319 = (state_81339[(2)]);
var inst_81320 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_81321 = [inst_81303,inst_81319];
var inst_81322 = cljs.core.PersistentHashMap.fromArrays(inst_81320,inst_81321);
var inst_81323 = cljs.core.assoc.call(null,inst_81284,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_81322);
var inst_81324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81325 = [inst_81323];
var inst_81326 = (new cljs.core.PersistentVector(null,1,(5),inst_81324,inst_81325,null));
var inst_81327 = cljs.core.concat.call(null,inst_81286,inst_81326);
var inst_81328 = cljs.core.first.call(null,inst_81285);
var state_81339__$1 = (function (){var statearr_81359 = state_81339;
(statearr_81359[(14)] = inst_81327);

return statearr_81359;
})();
if(cljs.core.truth_(inst_81328)){
var statearr_81360_81379 = state_81339__$1;
(statearr_81360_81379[(1)] = (12));

} else {
var statearr_81361_81380 = state_81339__$1;
(statearr_81361_81380[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81340 === (8))){
var inst_81305 = (state_81339[(15)]);
var inst_81303 = (state_81339[(16)]);
var inst_81285 = (state_81339[(7)]);
var inst_81283 = (state_81339[(8)]);
var inst_81290 = (state_81339[(12)]);
var inst_81286 = (state_81339[(9)]);
var inst_81288 = (state_81339[(13)]);
var inst_81282 = (state_81339[(10)]);
var inst_81284 = (state_81339[(11)]);
var inst_81309 = (function (){var flakes = inst_81288;
var rest_blocks = inst_81285;
var curr_block = inst_81284;
var asserted_SINGLEQUOTE_ = inst_81303;
var acc = inst_81286;
var fuel = inst_81282;
var cache = inst_81283;
var retracted = inst_81305;
var asserted = inst_81290;
return (function (p1__81275_SHARP_){
return p1__81275_SHARP_.s;
});
})();
var inst_81310 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_81305);
var inst_81311 = cljs.core.group_by.call(null,inst_81309,inst_81310);
var inst_81312 = cljs.core.vals.call(null,inst_81311);
var inst_81313 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_81283,inst_81282,inst_81312);
var state_81339__$1 = state_81339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81339__$1,(11),inst_81313);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____0 = (function (){
var statearr_81362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81362[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__);

(statearr_81362[(1)] = (1));

return statearr_81362;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____1 = (function (state_81339){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81363){var ex__16224__auto__ = e81363;
var statearr_81364_81381 = state_81339;
(statearr_81364_81381[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81339[(4)]))){
var statearr_81365_81382 = state_81339;
(statearr_81365_81382[(1)] = cljs.core.first.call(null,(state_81339[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81383 = state_81339;
state_81339 = G__81383;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__ = function(state_81339){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____1.call(this,state_81339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81366 = f__16346__auto__.call(null);
(statearr_81366[(6)] = c__16345__auto__);

return statearr_81366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81483){
var state_val_81484 = (state_81483[(1)]);
if((state_val_81484 === (7))){
var inst_81455 = (state_81483[(7)]);
var inst_81448 = (state_81483[(8)]);
var inst_81454 = cljs.core.seq.call(null,inst_81448);
var inst_81455__$1 = cljs.core.first.call(null,inst_81454);
var inst_81456 = cljs.core.next.call(null,inst_81454);
var state_81483__$1 = (function (){var statearr_81485 = state_81483;
(statearr_81485[(7)] = inst_81455__$1);

(statearr_81485[(9)] = inst_81456);

return statearr_81485;
})();
if(cljs.core.truth_(inst_81455__$1)){
var statearr_81486_81523 = state_81483__$1;
(statearr_81486_81523[(1)] = (9));

} else {
var statearr_81487_81524 = state_81483__$1;
(statearr_81487_81524[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (1))){
var state_81483__$1 = state_81483;
var statearr_81488_81525 = state_81483__$1;
(statearr_81488_81525[(2)] = null);

(statearr_81488_81525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (4))){
var inst_81385 = (state_81483[(2)]);
var state_81483__$1 = state_81483;
var statearr_81489_81526 = state_81483__$1;
(statearr_81489_81526[(2)] = inst_81385);

(statearr_81489_81526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (6))){
var inst_81434 = (state_81483[(2)]);
var inst_81435 = fluree.db.util.async.throw_err.call(null,inst_81434);
var inst_81443 = resp;
var inst_81444 = cljs.core.seq.call(null,inst_81443);
var inst_81445 = cljs.core.first.call(null,inst_81444);
var inst_81446 = cljs.core.next.call(null,inst_81444);
var inst_81447 = cljs.core.PersistentHashMap.EMPTY;
var inst_81448 = inst_81443;
var inst_81449 = inst_81447;
var state_81483__$1 = (function (){var statearr_81490 = state_81483;
(statearr_81490[(10)] = inst_81445);

(statearr_81490[(11)] = inst_81435);

(statearr_81490[(12)] = inst_81446);

(statearr_81490[(13)] = inst_81449);

(statearr_81490[(8)] = inst_81448);

return statearr_81490;
})();
var statearr_81491_81527 = state_81483__$1;
(statearr_81491_81527[(2)] = null);

(statearr_81491_81527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (3))){
var inst_81481 = (state_81483[(2)]);
var state_81483__$1 = state_81483;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81483__$1,inst_81481);
} else {
if((state_val_81484 === (2))){
var _ = (function (){var statearr_81492 = state_81483;
(statearr_81492[(4)] = cljs.core.cons.call(null,(5),(state_81483[(4)])));

return statearr_81492;
})();
var inst_81391 = (function (){return (function (p1__81384_SHARP_){
return p1__81384_SHARP_.t;
});
})();
var inst_81392 = cljs.core.map.call(null,inst_81391,resp);
var inst_81393 = cljs.core.set.call(null,inst_81392);
var inst_81430 = cljs.core.async.chan.call(null,(1));
var inst_81431 = (function (){var ts = inst_81393;
var c__16345__auto____$1 = inst_81430;
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81428){
var state_val_81429 = (state_81428[(1)]);
if((state_val_81429 === (1))){
var inst_81401 = ts;
var inst_81402 = cljs.core.seq.call(null,inst_81401);
var inst_81403 = cljs.core.first.call(null,inst_81402);
var inst_81404 = cljs.core.next.call(null,inst_81402);
var inst_81405 = cljs.core.PersistentHashMap.EMPTY;
var inst_81406 = inst_81401;
var inst_81407 = inst_81405;
var state_81428__$1 = (function (){var statearr_81493 = state_81428;
(statearr_81493[(7)] = inst_81403);

(statearr_81493[(8)] = inst_81404);

(statearr_81493[(9)] = inst_81407);

(statearr_81493[(10)] = inst_81406);

return statearr_81493;
})();
var statearr_81494_81528 = state_81428__$1;
(statearr_81494_81528[(2)] = null);

(statearr_81494_81528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81429 === (2))){
var inst_81413 = (state_81428[(11)]);
var inst_81406 = (state_81428[(10)]);
var inst_81412 = cljs.core.seq.call(null,inst_81406);
var inst_81413__$1 = cljs.core.first.call(null,inst_81412);
var inst_81414 = cljs.core.next.call(null,inst_81412);
var state_81428__$1 = (function (){var statearr_81495 = state_81428;
(statearr_81495[(11)] = inst_81413__$1);

(statearr_81495[(12)] = inst_81414);

return statearr_81495;
})();
if(cljs.core.truth_(inst_81413__$1)){
var statearr_81496_81529 = state_81428__$1;
(statearr_81496_81529[(1)] = (4));

} else {
var statearr_81497_81530 = state_81428__$1;
(statearr_81497_81530[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81429 === (3))){
var inst_81426 = (state_81428[(2)]);
var state_81428__$1 = state_81428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81428__$1,inst_81426);
} else {
if((state_val_81429 === (4))){
var inst_81413 = (state_81428[(11)]);
var inst_81416 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_81413);
var state_81428__$1 = state_81428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81428__$1,(7),inst_81416);
} else {
if((state_val_81429 === (5))){
var inst_81407 = (state_81428[(9)]);
var state_81428__$1 = state_81428;
var statearr_81498_81531 = state_81428__$1;
(statearr_81498_81531[(2)] = inst_81407);

(statearr_81498_81531[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81429 === (6))){
var inst_81424 = (state_81428[(2)]);
var state_81428__$1 = state_81428;
var statearr_81499_81532 = state_81428__$1;
(statearr_81499_81532[(2)] = inst_81424);

(statearr_81499_81532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81429 === (7))){
var inst_81413 = (state_81428[(11)]);
var inst_81414 = (state_81428[(12)]);
var inst_81407 = (state_81428[(9)]);
var inst_81418 = (state_81428[(2)]);
var inst_81419 = fluree.db.util.async.throw_err.call(null,inst_81418);
var inst_81420 = cljs.core.assoc.call(null,inst_81407,inst_81413,inst_81419);
var inst_81406 = inst_81414;
var inst_81407__$1 = inst_81420;
var state_81428__$1 = (function (){var statearr_81500 = state_81428;
(statearr_81500[(9)] = inst_81407__$1);

(statearr_81500[(10)] = inst_81406);

return statearr_81500;
})();
var statearr_81501_81533 = state_81428__$1;
(statearr_81501_81533[(2)] = null);

(statearr_81501_81533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0 = (function (){
var statearr_81502 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81502[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__);

(statearr_81502[(1)] = (1));

return statearr_81502;
});
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1 = (function (state_81428){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81503){var ex__16224__auto__ = e81503;
var statearr_81504_81534 = state_81428;
(statearr_81504_81534[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81428[(4)]))){
var statearr_81505_81535 = state_81428;
(statearr_81505_81535[(1)] = cljs.core.first.call(null,(state_81428[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81536 = state_81428;
state_81428 = G__81536;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__ = function(state_81428){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1.call(this,state_81428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81506 = f__16346__auto__.call(null);
(statearr_81506[(6)] = c__16345__auto____$1);

return statearr_81506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});
})();
var inst_81432 = cljs.core.async.impl.dispatch.run.call(null,inst_81431);
var state_81483__$1 = (function (){var statearr_81507 = state_81483;
(statearr_81507[(14)] = inst_81432);

return statearr_81507;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81483__$1,(6),inst_81430);
} else {
if((state_val_81484 === (11))){
var inst_81475 = (state_81483[(2)]);
var state_81483__$1 = state_81483;
var statearr_81509_81537 = state_81483__$1;
(statearr_81509_81537[(2)] = inst_81475);

(statearr_81509_81537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (9))){
var inst_81455 = (state_81483[(7)]);
var inst_81435 = (state_81483[(11)]);
var inst_81456 = (state_81483[(9)]);
var inst_81449 = (state_81483[(13)]);
var inst_81458 = inst_81455.t;
var inst_81459 = cljs.core.get.call(null,inst_81435,inst_81458);
var inst_81460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81461 = [inst_81459,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_81462 = (new cljs.core.PersistentVector(null,2,(5),inst_81460,inst_81461,null));
var inst_81463 = cljs.core.assoc_in.call(null,inst_81449,inst_81462,inst_81459);
var inst_81464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81465 = [inst_81459,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_81466 = (new cljs.core.PersistentVector(null,2,(5),inst_81464,inst_81465,null));
var inst_81467 = cljs.core.update_in.call(null,inst_81463,inst_81466,cljs.core.conj,inst_81455);
var inst_81468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81469 = [inst_81459,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_81470 = (new cljs.core.PersistentVector(null,2,(5),inst_81468,inst_81469,null));
var inst_81471 = cljs.core.update_in.call(null,inst_81467,inst_81470,fluree.db.api_js.min_safe,inst_81458);
var inst_81448 = inst_81456;
var inst_81449__$1 = inst_81471;
var state_81483__$1 = (function (){var statearr_81510 = state_81483;
(statearr_81510[(13)] = inst_81449__$1);

(statearr_81510[(8)] = inst_81448);

return statearr_81510;
})();
var statearr_81511_81538 = state_81483__$1;
(statearr_81511_81538[(2)] = null);

(statearr_81511_81538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (5))){
var _ = (function (){var statearr_81512 = state_81483;
(statearr_81512[(4)] = cljs.core.rest.call(null,(state_81483[(4)])));

return statearr_81512;
})();
var state_81483__$1 = state_81483;
var ex81508 = (state_81483__$1[(2)]);
var statearr_81513_81539 = state_81483__$1;
(statearr_81513_81539[(5)] = ex81508);


if((ex81508 instanceof Error)){
var statearr_81514_81540 = state_81483__$1;
(statearr_81514_81540[(1)] = (4));

(statearr_81514_81540[(5)] = null);

} else {
throw ex81508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (10))){
var inst_81449 = (state_81483[(13)]);
var state_81483__$1 = state_81483;
var statearr_81515_81541 = state_81483__$1;
(statearr_81515_81541[(2)] = inst_81449);

(statearr_81515_81541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81484 === (8))){
var inst_81477 = (state_81483[(2)]);
var inst_81478 = cljs.core.vals.call(null,inst_81477);
var _ = (function (){var statearr_81516 = state_81483;
(statearr_81516[(4)] = cljs.core.rest.call(null,(state_81483[(4)])));

return statearr_81516;
})();
var state_81483__$1 = state_81483;
var statearr_81517_81542 = state_81483__$1;
(statearr_81517_81542[(2)] = inst_81478);

(statearr_81517_81542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0 = (function (){
var statearr_81518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81518[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__);

(statearr_81518[(1)] = (1));

return statearr_81518;
});
var fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1 = (function (state_81483){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81483);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81519){var ex__16224__auto__ = e81519;
var statearr_81520_81543 = state_81483;
(statearr_81520_81543[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81483[(4)]))){
var statearr_81521_81544 = state_81483;
(statearr_81521_81544[(1)] = cljs.core.first.call(null,(state_81483[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81545 = state_81483;
state_81483 = G__81545;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__ = function(state_81483){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1.call(this,state_81483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__16221__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81522 = f__16346__auto__.call(null);
(statearr_81522[(6)] = c__16345__auto__);

return statearr_81522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81690){
var state_val_81691 = (state_81690[(1)]);
if((state_val_81691 === (7))){
var inst_81570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81571 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_81572 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_81573 = [inst_81571,inst_81572];
var inst_81574 = (new cljs.core.PersistentVector(null,2,(5),inst_81570,inst_81573,null));
var state_81690__$1 = state_81690;
var statearr_81692_81763 = state_81690__$1;
(statearr_81692_81763[(2)] = inst_81574);

(statearr_81692_81763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (20))){
var inst_81600 = (state_81690[(7)]);
var state_81690__$1 = state_81690;
var statearr_81693_81764 = state_81690__$1;
(statearr_81693_81764[(2)] = inst_81600);

(statearr_81693_81764[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (27))){
var state_81690__$1 = state_81690;
var statearr_81694_81765 = state_81690__$1;
(statearr_81694_81765[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (1))){
var state_81690__$1 = state_81690;
var statearr_81696_81766 = state_81690__$1;
(statearr_81696_81766[(2)] = null);

(statearr_81696_81766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (24))){
var inst_81599 = (state_81690[(8)]);
var state_81690__$1 = state_81690;
if(cljs.core.truth_(inst_81599)){
var statearr_81697_81767 = state_81690__$1;
(statearr_81697_81767[(1)] = (26));

} else {
var statearr_81698_81768 = state_81690__$1;
(statearr_81698_81768[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (39))){
var inst_81645 = (state_81690[(9)]);
var inst_81646 = (state_81690[(10)]);
var inst_81671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81672 = [inst_81645,inst_81646];
var inst_81673 = (new cljs.core.PersistentVector(null,2,(5),inst_81671,inst_81672,null));
var state_81690__$1 = state_81690;
var statearr_81699_81769 = state_81690__$1;
(statearr_81699_81769[(2)] = inst_81673);

(statearr_81699_81769[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (4))){
var inst_81546 = (state_81690[(2)]);
var inst_81547 = fluree.db.util.log.error.call(null,inst_81546);
var inst_81548 = cljs.core.ex_data.call(null,inst_81546);
var inst_81549 = cljs.core.ex_message.call(null,inst_81546);
var inst_81550 = cljs.core.assoc.call(null,inst_81548,new cljs.core.Keyword(null,"message","message",-406056002),inst_81549);
var state_81690__$1 = (function (){var statearr_81700 = state_81690;
(statearr_81700[(11)] = inst_81547);

return statearr_81700;
})();
var statearr_81701_81770 = state_81690__$1;
(statearr_81701_81770[(2)] = inst_81550);

(statearr_81701_81770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (15))){
var inst_81584 = (state_81690[(12)]);
var inst_81579 = (state_81690[(13)]);
var inst_81593 = (state_81690[(2)]);
var inst_81594 = [inst_81584,inst_81593];
var inst_81595 = (new cljs.core.PersistentVector(null,2,(5),inst_81579,inst_81594,null));
var state_81690__$1 = state_81690;
var statearr_81702_81771 = state_81690__$1;
(statearr_81702_81771[(2)] = inst_81595);

(statearr_81702_81771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (21))){
var inst_81599 = (state_81690[(8)]);
var state_81690__$1 = state_81690;
var statearr_81703_81772 = state_81690__$1;
(statearr_81703_81772[(2)] = inst_81599);

(statearr_81703_81772[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (31))){
var inst_81640 = (state_81690[(2)]);
var state_81690__$1 = state_81690;
var statearr_81704_81773 = state_81690__$1;
(statearr_81704_81773[(2)] = inst_81640);

(statearr_81704_81773[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (32))){
var inst_81646 = (state_81690[(10)]);
var inst_81649 = cljs.core.pos_int_QMARK_.call(null,inst_81646);
var state_81690__$1 = state_81690;
var statearr_81705_81774 = state_81690__$1;
(statearr_81705_81774[(2)] = inst_81649);

(statearr_81705_81774[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (40))){
var inst_81601 = (state_81690[(14)]);
var inst_81677 = (state_81690[(15)]);
var inst_81675 = (state_81690[(2)]);
var inst_81676 = cljs.core.nth.call(null,inst_81675,(0),null);
var inst_81677__$1 = cljs.core.nth.call(null,inst_81675,(1),null);
var inst_81678 = (inst_81677__$1 > inst_81601);
var state_81690__$1 = (function (){var statearr_81706 = state_81690;
(statearr_81706[(16)] = inst_81676);

(statearr_81706[(15)] = inst_81677__$1);

return statearr_81706;
})();
if(cljs.core.truth_(inst_81678)){
var statearr_81707_81775 = state_81690__$1;
(statearr_81707_81775[(1)] = (41));

} else {
var statearr_81708_81776 = state_81690__$1;
(statearr_81708_81776[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (33))){
var inst_81647 = (state_81690[(17)]);
var state_81690__$1 = state_81690;
var statearr_81709_81777 = state_81690__$1;
(statearr_81709_81777[(2)] = inst_81647);

(statearr_81709_81777[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (13))){
var inst_81585 = (state_81690[(18)]);
var inst_81587 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_81585);
var state_81690__$1 = state_81690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81690__$1,(16),inst_81587);
} else {
if((state_val_81691 === (22))){
var inst_81618 = (state_81690[(2)]);
var state_81690__$1 = state_81690;
if(cljs.core.truth_(inst_81618)){
var statearr_81710_81778 = state_81690__$1;
(statearr_81710_81778[(1)] = (23));

} else {
var statearr_81711_81779 = state_81690__$1;
(statearr_81711_81779[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (36))){
var state_81690__$1 = state_81690;
var statearr_81712_81780 = state_81690__$1;
(statearr_81712_81780[(2)] = null);

(statearr_81712_81780[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (41))){
var inst_81601 = (state_81690[(14)]);
var state_81690__$1 = state_81690;
var statearr_81713_81781 = state_81690__$1;
(statearr_81713_81781[(2)] = inst_81601);

(statearr_81713_81781[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (43))){
var inst_81676 = (state_81690[(16)]);
var inst_81682 = (state_81690[(2)]);
var inst_81683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81684 = [inst_81676,inst_81682];
var inst_81685 = (new cljs.core.PersistentVector(null,2,(5),inst_81683,inst_81684,null));
var _ = (function (){var statearr_81714 = state_81690;
(statearr_81714[(4)] = cljs.core.rest.call(null,(state_81690[(4)])));

return statearr_81714;
})();
var state_81690__$1 = state_81690;
var statearr_81715_81782 = state_81690__$1;
(statearr_81715_81782[(2)] = inst_81685);

(statearr_81715_81782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (29))){
var inst_81576 = (state_81690[(19)]);
var inst_81631 = cljs.core.pr_str.call(null,inst_81576);
var inst_81632 = ["Invalid block range provided: ",inst_81631].join('');
var inst_81633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81634 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_81635 = cljs.core.PersistentHashMap.fromArrays(inst_81633,inst_81634);
var inst_81636 = cljs.core.ex_info.call(null,inst_81632,inst_81635);
var inst_81637 = (function(){throw inst_81636})();
var state_81690__$1 = state_81690;
var statearr_81716_81783 = state_81690__$1;
(statearr_81716_81783[(2)] = inst_81637);

(statearr_81716_81783[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (6))){
var inst_81568 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_81690__$1 = state_81690;
var statearr_81717_81784 = state_81690__$1;
(statearr_81717_81784[(2)] = inst_81568);

(statearr_81717_81784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (28))){
var inst_81642 = (state_81690[(2)]);
var state_81690__$1 = state_81690;
var statearr_81718_81785 = state_81690__$1;
(statearr_81718_81785[(2)] = inst_81642);

(statearr_81718_81785[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (25))){
var inst_81645 = (state_81690[(9)]);
var inst_81647 = (state_81690[(17)]);
var inst_81644 = (state_81690[(2)]);
var inst_81645__$1 = cljs.core.nth.call(null,inst_81644,(0),null);
var inst_81646 = cljs.core.nth.call(null,inst_81644,(1),null);
var inst_81647__$1 = cljs.core.pos_int_QMARK_.call(null,inst_81645__$1);
var state_81690__$1 = (function (){var statearr_81719 = state_81690;
(statearr_81719[(9)] = inst_81645__$1);

(statearr_81719[(10)] = inst_81646);

(statearr_81719[(17)] = inst_81647__$1);

return statearr_81719;
})();
if(inst_81647__$1){
var statearr_81720_81786 = state_81690__$1;
(statearr_81720_81786[(1)] = (32));

} else {
var statearr_81721_81787 = state_81690__$1;
(statearr_81721_81787[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (34))){
var inst_81652 = (state_81690[(2)]);
var inst_81653 = cljs.core.not.call(null,inst_81652);
var state_81690__$1 = state_81690;
if(inst_81653){
var statearr_81722_81788 = state_81690__$1;
(statearr_81722_81788[(1)] = (35));

} else {
var statearr_81723_81789 = state_81690__$1;
(statearr_81723_81789[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (17))){
var inst_81599 = (state_81690[(8)]);
var inst_81601 = (state_81690[(14)]);
var inst_81604 = cljs.core.pr_str.call(null,inst_81599);
var inst_81605 = cljs.core.pr_str.call(null,inst_81601);
var inst_81606 = ["Start block is out of range for this ledger. Start block provided: ",inst_81604,". Database block: ",inst_81605].join('');
var inst_81607 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81608 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_81609 = cljs.core.PersistentHashMap.fromArrays(inst_81607,inst_81608);
var inst_81610 = cljs.core.ex_info.call(null,inst_81606,inst_81609);
var inst_81611 = (function(){throw inst_81610})();
var state_81690__$1 = state_81690;
var statearr_81724_81790 = state_81690__$1;
(statearr_81724_81790[(2)] = inst_81611);

(statearr_81724_81790[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (3))){
var inst_81688 = (state_81690[(2)]);
var state_81690__$1 = state_81690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81690__$1,inst_81688);
} else {
if((state_val_81691 === (12))){
var inst_81585 = (state_81690[(18)]);
var inst_81576 = (state_81690[(19)]);
var inst_81583 = (state_81690[(2)]);
var inst_81584 = fluree.db.util.async.throw_err.call(null,inst_81583);
var inst_81585__$1 = cljs.core.second.call(null,inst_81576);
var state_81690__$1 = (function (){var statearr_81725 = state_81690;
(statearr_81725[(12)] = inst_81584);

(statearr_81725[(18)] = inst_81585__$1);

return statearr_81725;
})();
if(cljs.core.truth_(inst_81585__$1)){
var statearr_81726_81791 = state_81690__$1;
(statearr_81726_81791[(1)] = (13));

} else {
var statearr_81727_81792 = state_81690__$1;
(statearr_81727_81792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (2))){
var _ = (function (){var statearr_81728 = state_81690;
(statearr_81728[(4)] = cljs.core.cons.call(null,(5),(state_81690[(4)])));

return statearr_81728;
})();
var inst_81565 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_81566 = cljs.core.sequential_QMARK_.call(null,inst_81565);
var state_81690__$1 = state_81690;
if(inst_81566){
var statearr_81729_81793 = state_81690__$1;
(statearr_81729_81793[(1)] = (6));

} else {
var statearr_81730_81794 = state_81690__$1;
(statearr_81730_81794[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (23))){
var inst_81599 = (state_81690[(8)]);
var inst_81600 = (state_81690[(7)]);
var inst_81620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81621 = [inst_81599,inst_81600];
var inst_81622 = (new cljs.core.PersistentVector(null,2,(5),inst_81620,inst_81621,null));
var state_81690__$1 = state_81690;
var statearr_81731_81795 = state_81690__$1;
(statearr_81731_81795[(2)] = inst_81622);

(statearr_81731_81795[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (35))){
var inst_81576 = (state_81690[(19)]);
var inst_81655 = cljs.core.pr_str.call(null,inst_81576);
var inst_81656 = ["Invalid block range provided: ",inst_81655].join('');
var inst_81657 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81658 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_81659 = cljs.core.PersistentHashMap.fromArrays(inst_81657,inst_81658);
var inst_81660 = cljs.core.ex_info.call(null,inst_81656,inst_81659);
var inst_81661 = (function(){throw inst_81660})();
var state_81690__$1 = state_81690;
var statearr_81732_81796 = state_81690__$1;
(statearr_81732_81796[(2)] = inst_81661);

(statearr_81732_81796[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (19))){
var inst_81599 = (state_81690[(8)]);
var inst_81614 = (state_81690[(2)]);
var state_81690__$1 = (function (){var statearr_81733 = state_81690;
(statearr_81733[(20)] = inst_81614);

return statearr_81733;
})();
if(cljs.core.truth_(inst_81599)){
var statearr_81734_81797 = state_81690__$1;
(statearr_81734_81797[(1)] = (20));

} else {
var statearr_81735_81798 = state_81690__$1;
(statearr_81735_81798[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (11))){
var inst_81599 = (state_81690[(8)]);
var inst_81601 = (state_81690[(14)]);
var inst_81598 = (state_81690[(2)]);
var inst_81599__$1 = cljs.core.nth.call(null,inst_81598,(0),null);
var inst_81600 = cljs.core.nth.call(null,inst_81598,(1),null);
var inst_81601__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_81602 = (inst_81599__$1 > inst_81601__$1);
var state_81690__$1 = (function (){var statearr_81737 = state_81690;
(statearr_81737[(8)] = inst_81599__$1);

(statearr_81737[(14)] = inst_81601__$1);

(statearr_81737[(7)] = inst_81600);

return statearr_81737;
})();
if(cljs.core.truth_(inst_81602)){
var statearr_81738_81799 = state_81690__$1;
(statearr_81738_81799[(1)] = (17));

} else {
var statearr_81739_81800 = state_81690__$1;
(statearr_81739_81800[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (9))){
var inst_81576 = (state_81690[(19)]);
var inst_81579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81580 = cljs.core.first.call(null,inst_81576);
var inst_81581 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_81580);
var state_81690__$1 = (function (){var statearr_81740 = state_81690;
(statearr_81740[(13)] = inst_81579);

return statearr_81740;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81690__$1,(12),inst_81581);
} else {
if((state_val_81691 === (5))){
var _ = (function (){var statearr_81741 = state_81690;
(statearr_81741[(4)] = cljs.core.rest.call(null,(state_81690[(4)])));

return statearr_81741;
})();
var state_81690__$1 = state_81690;
var ex81736 = (state_81690__$1[(2)]);
var statearr_81742_81801 = state_81690__$1;
(statearr_81742_81801[(5)] = ex81736);


var statearr_81743_81802 = state_81690__$1;
(statearr_81743_81802[(1)] = (4));

(statearr_81743_81802[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (14))){
var state_81690__$1 = state_81690;
var statearr_81744_81803 = state_81690__$1;
(statearr_81744_81803[(2)] = null);

(statearr_81744_81803[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (26))){
var inst_81599 = (state_81690[(8)]);
var inst_81625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81626 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_81627 = [inst_81599,inst_81626];
var inst_81628 = (new cljs.core.PersistentVector(null,2,(5),inst_81625,inst_81627,null));
var state_81690__$1 = state_81690;
var statearr_81745_81804 = state_81690__$1;
(statearr_81745_81804[(2)] = inst_81628);

(statearr_81745_81804[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (16))){
var inst_81589 = (state_81690[(2)]);
var inst_81590 = fluree.db.util.async.throw_err.call(null,inst_81589);
var state_81690__$1 = state_81690;
var statearr_81746_81805 = state_81690__$1;
(statearr_81746_81805[(2)] = inst_81590);

(statearr_81746_81805[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (38))){
var inst_81645 = (state_81690[(9)]);
var inst_81646 = (state_81690[(10)]);
var inst_81667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81668 = [inst_81646,inst_81645];
var inst_81669 = (new cljs.core.PersistentVector(null,2,(5),inst_81667,inst_81668,null));
var state_81690__$1 = state_81690;
var statearr_81747_81806 = state_81690__$1;
(statearr_81747_81806[(2)] = inst_81669);

(statearr_81747_81806[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (30))){
var state_81690__$1 = state_81690;
var statearr_81748_81807 = state_81690__$1;
(statearr_81748_81807[(2)] = null);

(statearr_81748_81807[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (10))){
var inst_81576 = (state_81690[(19)]);
var state_81690__$1 = state_81690;
var statearr_81749_81808 = state_81690__$1;
(statearr_81749_81808[(2)] = inst_81576);

(statearr_81749_81808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (18))){
var state_81690__$1 = state_81690;
var statearr_81750_81809 = state_81690__$1;
(statearr_81750_81809[(2)] = null);

(statearr_81750_81809[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (42))){
var inst_81677 = (state_81690[(15)]);
var state_81690__$1 = state_81690;
var statearr_81751_81810 = state_81690__$1;
(statearr_81751_81810[(2)] = inst_81677);

(statearr_81751_81810[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (37))){
var inst_81645 = (state_81690[(9)]);
var inst_81646 = (state_81690[(10)]);
var inst_81664 = (state_81690[(2)]);
var inst_81665 = (inst_81646 < inst_81645);
var state_81690__$1 = (function (){var statearr_81752 = state_81690;
(statearr_81752[(21)] = inst_81664);

return statearr_81752;
})();
if(cljs.core.truth_(inst_81665)){
var statearr_81753_81811 = state_81690__$1;
(statearr_81753_81811[(1)] = (38));

} else {
var statearr_81754_81812 = state_81690__$1;
(statearr_81754_81812[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81691 === (8))){
var inst_81576 = (state_81690[(19)]);
var inst_81576__$1 = (state_81690[(2)]);
var inst_81577 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_81576__$1);
var state_81690__$1 = (function (){var statearr_81755 = state_81690;
(statearr_81755[(19)] = inst_81576__$1);

return statearr_81755;
})();
if(cljs.core.truth_(inst_81577)){
var statearr_81756_81813 = state_81690__$1;
(statearr_81756_81813[(1)] = (9));

} else {
var statearr_81757_81814 = state_81690__$1;
(statearr_81757_81814[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____0 = (function (){
var statearr_81758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81758[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__);

(statearr_81758[(1)] = (1));

return statearr_81758;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____1 = (function (state_81690){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81759){var ex__16224__auto__ = e81759;
var statearr_81760_81815 = state_81690;
(statearr_81760_81815[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81690[(4)]))){
var statearr_81761_81816 = state_81690;
(statearr_81761_81816[(1)] = cljs.core.first.call(null,(state_81690[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81817 = state_81690;
state_81690 = G__81817;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__ = function(state_81690){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____1.call(this,state_81690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81762 = f__16346__auto__.call(null);
(statearr_81762[(6)] = c__16345__auto__);

return statearr_81762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__81819 = arguments.length;
switch (G__81819) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_81910){
var state_val_81911 = (state_81910[(1)]);
if((state_val_81911 === (7))){
var inst_81842 = (state_81910[(7)]);
var inst_81845 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_81842);
var state_81910__$1 = state_81910;
var statearr_81912_81963 = state_81910__$1;
(statearr_81912_81963[(2)] = inst_81845);

(statearr_81912_81963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (20))){
var inst_81881 = (state_81910[(8)]);
var inst_81884 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_81881);
var state_81910__$1 = state_81910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81910__$1,(23),inst_81884);
} else {
if((state_val_81911 === (27))){
var inst_81890 = (state_81910[(9)]);
var inst_81896 = cljs.core.doall.call(null,inst_81890);
var state_81910__$1 = state_81910;
var statearr_81913_81964 = state_81910__$1;
(statearr_81913_81964[(2)] = inst_81896);

(statearr_81913_81964[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (1))){
var state_81910__$1 = state_81910;
var statearr_81914_81965 = state_81910__$1;
(statearr_81914_81965[(2)] = null);

(statearr_81914_81965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (24))){
var inst_81890 = (state_81910[(9)]);
var inst_81893 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_81894 = cljs.core.sequential_QMARK_.call(null,inst_81890);
var state_81910__$1 = (function (){var statearr_81915 = state_81910;
(statearr_81915[(10)] = inst_81893);

return statearr_81915;
})();
if(inst_81894){
var statearr_81916_81966 = state_81910__$1;
(statearr_81916_81966[(1)] = (27));

} else {
var statearr_81917_81967 = state_81910__$1;
(statearr_81917_81967[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (4))){
var inst_81820 = (state_81910[(2)]);
var inst_81821 = fluree.db.util.log.error.call(null,inst_81820);
var inst_81822 = cljs.core.ex_data.call(null,inst_81820);
var inst_81823 = cljs.core.ex_message.call(null,inst_81820);
var inst_81824 = cljs.core.assoc.call(null,inst_81822,new cljs.core.Keyword(null,"message","message",-406056002),inst_81823);
var state_81910__$1 = (function (){var statearr_81918 = state_81910;
(statearr_81918[(11)] = inst_81821);

return statearr_81918;
})();
var statearr_81919_81968 = state_81910__$1;
(statearr_81919_81968[(2)] = inst_81824);

(statearr_81919_81968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (15))){
var inst_81842 = (state_81910[(7)]);
var inst_81855 = (state_81910[(2)]);
var inst_81856 = cljs.core.ex_info.call(null,inst_81855,inst_81842);
var inst_81857 = (function(){throw inst_81856})();
var state_81910__$1 = state_81910;
var statearr_81920_81969 = state_81910__$1;
(statearr_81920_81969[(2)] = inst_81857);

(statearr_81920_81969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (21))){
var inst_81881 = (state_81910[(8)]);
var state_81910__$1 = state_81910;
var statearr_81921_81970 = state_81910__$1;
(statearr_81921_81970[(2)] = inst_81881);

(statearr_81921_81970[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (13))){
var inst_81850 = (state_81910[(12)]);
var state_81910__$1 = state_81910;
var statearr_81922_81971 = state_81910__$1;
(statearr_81922_81971[(2)] = inst_81850);

(statearr_81922_81971[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (22))){
var inst_81890 = (state_81910[(2)]);
var inst_81891 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_81910__$1 = (function (){var statearr_81923 = state_81910;
(statearr_81923[(9)] = inst_81890);

return statearr_81923;
})();
if(cljs.core.truth_(inst_81891)){
var statearr_81924_81972 = state_81910__$1;
(statearr_81924_81972[(1)] = (24));

} else {
var statearr_81925_81973 = state_81910__$1;
(statearr_81925_81973[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (29))){
var inst_81834 = (state_81910[(13)]);
var inst_81893 = (state_81910[(10)]);
var inst_81899 = (state_81910[(2)]);
var inst_81900 = fluree.db.util.core.response_time_formatted.call(null,inst_81834);
var inst_81901 = [(200),inst_81899,(100),inst_81900];
var inst_81902 = cljs.core.PersistentHashMap.fromArrays(inst_81893,inst_81901);
var state_81910__$1 = state_81910;
var statearr_81926_81974 = state_81910__$1;
(statearr_81926_81974[(2)] = inst_81902);

(statearr_81926_81974[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (6))){
var inst_81843 = (state_81910[(14)]);
var inst_81842 = (state_81910[(7)]);
var inst_81841 = (state_81910[(2)]);
var inst_81842__$1 = fluree.db.util.async.throw_err.call(null,inst_81841);
var inst_81843__$1 = cljs.core.map_QMARK_.call(null,inst_81842__$1);
var state_81910__$1 = (function (){var statearr_81927 = state_81910;
(statearr_81927[(14)] = inst_81843__$1);

(statearr_81927[(7)] = inst_81842__$1);

return statearr_81927;
})();
if(inst_81843__$1){
var statearr_81928_81975 = state_81910__$1;
(statearr_81928_81975[(1)] = (7));

} else {
var statearr_81929_81976 = state_81910__$1;
(statearr_81929_81976[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (28))){
var inst_81890 = (state_81910[(9)]);
var state_81910__$1 = state_81910;
var statearr_81930_81977 = state_81910__$1;
(statearr_81930_81977[(2)] = inst_81890);

(statearr_81930_81977[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (25))){
var inst_81890 = (state_81910[(9)]);
var state_81910__$1 = state_81910;
var statearr_81931_81978 = state_81910__$1;
(statearr_81931_81978[(2)] = inst_81890);

(statearr_81931_81978[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (17))){
var inst_81873 = cljs.core.pr_str.call(null,query_map);
var inst_81874 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_81873].join('');
var inst_81875 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81876 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_81877 = cljs.core.PersistentHashMap.fromArrays(inst_81875,inst_81876);
var inst_81878 = cljs.core.ex_info.call(null,inst_81874,inst_81877);
var inst_81879 = (function(){throw inst_81878})();
var state_81910__$1 = state_81910;
var statearr_81932_81979 = state_81910__$1;
(statearr_81932_81979[(2)] = inst_81879);

(statearr_81932_81979[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (3))){
var inst_81908 = (state_81910[(2)]);
var state_81910__$1 = state_81910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81910__$1,inst_81908);
} else {
if((state_val_81911 === (12))){
var inst_81842 = (state_81910[(7)]);
var inst_81860 = (state_81910[(2)]);
var inst_81861 = cljs.core.nth.call(null,inst_81842,(0),null);
var inst_81862 = cljs.core.nth.call(null,inst_81842,(1),null);
var inst_81863 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_81864 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_81865 = cljs.core.keys.call(null,inst_81864);
var inst_81866 = cljs.core._EQ_.call(null,inst_81863,inst_81865);
var state_81910__$1 = (function (){var statearr_81933 = state_81910;
(statearr_81933[(15)] = inst_81861);

(statearr_81933[(16)] = inst_81860);

(statearr_81933[(17)] = inst_81862);

return statearr_81933;
})();
if(inst_81866){
var statearr_81934_81980 = state_81910__$1;
(statearr_81934_81980[(1)] = (16));

} else {
var statearr_81935_81981 = state_81910__$1;
(statearr_81935_81981[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (2))){
var _ = (function (){var statearr_81936 = state_81910;
(statearr_81936[(4)] = cljs.core.cons.call(null,(5),(state_81910[(4)])));

return statearr_81936;
})();
var inst_81834 = fluree.db.util.core.current_time_millis.call(null);
var inst_81835 = db;
var inst_81836 = cljs.core.__destructure_map.call(null,inst_81835);
var inst_81837 = cljs.core.get.call(null,inst_81836,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_81838 = cljs.core.get.call(null,inst_81836,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_81839 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_81910__$1 = (function (){var statearr_81937 = state_81910;
(statearr_81937[(13)] = inst_81834);

(statearr_81937[(18)] = inst_81838);

(statearr_81937[(19)] = inst_81837);

return statearr_81937;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81910__$1,(6),inst_81839);
} else {
if((state_val_81911 === (23))){
var inst_81886 = (state_81910[(2)]);
var inst_81887 = fluree.db.util.async.throw_err.call(null,inst_81886);
var state_81910__$1 = state_81910;
var statearr_81938_81982 = state_81910__$1;
(statearr_81938_81982[(2)] = inst_81887);

(statearr_81938_81982[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (19))){
var inst_81870 = (state_81910[(2)]);
var inst_81871 = fluree.db.util.async.throw_err.call(null,inst_81870);
var state_81910__$1 = state_81910;
var statearr_81939_81983 = state_81910__$1;
(statearr_81939_81983[(2)] = inst_81871);

(statearr_81939_81983[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (11))){
var state_81910__$1 = state_81910;
var statearr_81941_81984 = state_81910__$1;
(statearr_81941_81984[(2)] = null);

(statearr_81941_81984[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (9))){
var inst_81848 = (state_81910[(2)]);
var state_81910__$1 = state_81910;
if(cljs.core.truth_(inst_81848)){
var statearr_81942_81985 = state_81910__$1;
(statearr_81942_81985[(1)] = (10));

} else {
var statearr_81943_81986 = state_81910__$1;
(statearr_81943_81986[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (5))){
var _ = (function (){var statearr_81944 = state_81910;
(statearr_81944[(4)] = cljs.core.rest.call(null,(state_81910[(4)])));

return statearr_81944;
})();
var state_81910__$1 = state_81910;
var ex81940 = (state_81910__$1[(2)]);
var statearr_81945_81987 = state_81910__$1;
(statearr_81945_81987[(5)] = ex81940);


var statearr_81946_81988 = state_81910__$1;
(statearr_81946_81988[(1)] = (4));

(statearr_81946_81988[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (14))){
var inst_81838 = (state_81910[(18)]);
var inst_81837 = (state_81910[(19)]);
var inst_81853 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81837),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_81838)].join('');
var state_81910__$1 = state_81910;
var statearr_81947_81989 = state_81910__$1;
(statearr_81947_81989[(2)] = inst_81853);

(statearr_81947_81989[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (26))){
var inst_81905 = (state_81910[(2)]);
var _ = (function (){var statearr_81948 = state_81910;
(statearr_81948[(4)] = cljs.core.rest.call(null,(state_81910[(4)])));

return statearr_81948;
})();
var state_81910__$1 = state_81910;
var statearr_81949_81990 = state_81910__$1;
(statearr_81949_81990[(2)] = inst_81905);

(statearr_81949_81990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (16))){
var inst_81861 = (state_81910[(15)]);
var inst_81862 = (state_81910[(17)]);
var inst_81868 = fluree.db.query.block.block_range.call(null,db,inst_81861,inst_81862,opts);
var state_81910__$1 = state_81910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81910__$1,(19),inst_81868);
} else {
if((state_val_81911 === (10))){
var inst_81850 = (state_81910[(12)]);
var inst_81842 = (state_81910[(7)]);
var inst_81850__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_81842);
var state_81910__$1 = (function (){var statearr_81950 = state_81910;
(statearr_81950[(12)] = inst_81850__$1);

return statearr_81950;
})();
if(cljs.core.truth_(inst_81850__$1)){
var statearr_81951_81991 = state_81910__$1;
(statearr_81951_81991[(1)] = (13));

} else {
var statearr_81952_81992 = state_81910__$1;
(statearr_81952_81992[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (18))){
var inst_81881 = (state_81910[(2)]);
var inst_81882 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_81910__$1 = (function (){var statearr_81953 = state_81910;
(statearr_81953[(8)] = inst_81881);

return statearr_81953;
})();
if(cljs.core.truth_(inst_81882)){
var statearr_81954_81993 = state_81910__$1;
(statearr_81954_81993[(1)] = (20));

} else {
var statearr_81955_81994 = state_81910__$1;
(statearr_81955_81994[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81911 === (8))){
var inst_81843 = (state_81910[(14)]);
var state_81910__$1 = state_81910;
var statearr_81956_81995 = state_81910__$1;
(statearr_81956_81995[(2)] = inst_81843);

(statearr_81956_81995[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_81957 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81957[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_81957[(1)] = (1));

return statearr_81957;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_81910){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_81910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e81958){var ex__16224__auto__ = e81958;
var statearr_81959_81996 = state_81910;
(statearr_81959_81996[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_81910[(4)]))){
var statearr_81960_81997 = state_81910;
(statearr_81960_81997[(1)] = cljs.core.first.call(null,(state_81910[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81998 = state_81910;
state_81910 = G__81998;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_81910){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_81910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_81961 = f__16346__auto__.call(null);
(statearr_81961[(6)] = c__16345__auto__);

return statearr_81961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__82000 = arguments.length;
switch (G__82000) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_82195){
var state_val_82196 = (state_82195[(1)]);
if((state_val_82196 === (62))){
var inst_82193 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82195__$1,inst_82193);
} else {
if((state_val_82196 === (7))){
var inst_82021 = (state_82195[(7)]);
var inst_82031 = cljs.core.not_EQ_.call(null,(1),inst_82021);
var state_82195__$1 = state_82195;
var statearr_82197_82288 = state_82195__$1;
(statearr_82197_82288[(2)] = inst_82031);

(statearr_82197_82288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (59))){
var inst_82181 = (state_82195[(2)]);
var inst_82182 = fluree.db.util.async.throw_err.call(null,inst_82181);
var state_82195__$1 = state_82195;
var statearr_82198_82289 = state_82195__$1;
(statearr_82198_82289[(2)] = inst_82182);

(statearr_82198_82289[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (20))){
var inst_82089 = (state_82195[(8)]);
var inst_82097 = (state_82195[(9)]);
var inst_82089__$1 = (state_82195[(2)]);
var inst_82090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82091 = cljs.core.get.call(null,inst_82089__$1,(0));
var inst_82092 = cljs.core.get.call(null,inst_82089__$1,(1));
var inst_82093 = cljs.core.get.call(null,inst_82089__$1,(2));
var inst_82094 = cljs.core.get.call(null,inst_82089__$1,(3));
var inst_82095 = [inst_82091,inst_82092,inst_82093,inst_82094];
var inst_82096 = (new cljs.core.PersistentVector(null,4,(5),inst_82090,inst_82095,null));
var inst_82097__$1 = cljs.core.nth.call(null,inst_82096,(0),null);
var inst_82098 = cljs.core.nth.call(null,inst_82096,(1),null);
var inst_82099 = cljs.core.nth.call(null,inst_82096,(2),null);
var inst_82100 = cljs.core.nth.call(null,inst_82096,(3),null);
var inst_82101 = (inst_82097__$1 == null);
var inst_82102 = cljs.core.not.call(null,inst_82101);
var state_82195__$1 = (function (){var statearr_82199 = state_82195;
(statearr_82199[(10)] = inst_82098);

(statearr_82199[(8)] = inst_82089__$1);

(statearr_82199[(9)] = inst_82097__$1);

(statearr_82199[(11)] = inst_82100);

(statearr_82199[(12)] = inst_82099);

return statearr_82199;
})();
if(inst_82102){
var statearr_82200_82290 = state_82195__$1;
(statearr_82200_82290[(1)] = (30));

} else {
var statearr_82201_82291 = state_82195__$1;
(statearr_82201_82291[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (58))){
var inst_82029 = (state_82195[(13)]);
var inst_82185 = (state_82195[(2)]);
var state_82195__$1 = (function (){var statearr_82202 = state_82195;
(statearr_82202[(14)] = inst_82185);

return statearr_82202;
})();
if(cljs.core.truth_(inst_82029)){
var statearr_82203_82292 = state_82195__$1;
(statearr_82203_82292[(1)] = (60));

} else {
var statearr_82204_82293 = state_82195__$1;
(statearr_82204_82293[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (60))){
var inst_82173 = (state_82195[(15)]);
var inst_82185 = (state_82195[(14)]);
var inst_82187 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_82188 = cljs.core.count.call(null,inst_82173);
var inst_82189 = [inst_82185,inst_82188,(200)];
var inst_82190 = cljs.core.PersistentHashMap.fromArrays(inst_82187,inst_82189);
var state_82195__$1 = state_82195;
var statearr_82205_82294 = state_82195__$1;
(statearr_82205_82294[(2)] = inst_82190);

(statearr_82205_82294[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (27))){
var inst_82008 = (state_82195[(16)]);
var inst_82077 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82008)].join('');
var inst_82078 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82079 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_82080 = cljs.core.PersistentHashMap.fromArrays(inst_82078,inst_82079);
var inst_82081 = cljs.core.ex_info.call(null,inst_82077,inst_82080);
var inst_82082 = (function(){throw inst_82081})();
var state_82195__$1 = state_82195;
var statearr_82206_82295 = state_82195__$1;
(statearr_82206_82295[(2)] = inst_82082);

(statearr_82206_82295[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (1))){
var inst_82005 = query_map;
var inst_82006 = cljs.core.__destructure_map.call(null,inst_82005);
var inst_82007 = cljs.core.get.call(null,inst_82006,new cljs.core.Keyword(null,"block","block",664686210));
var inst_82008 = cljs.core.get.call(null,inst_82006,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_82009 = cljs.core.get.call(null,inst_82006,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_82195__$1 = (function (){var statearr_82207 = state_82195;
(statearr_82207[(17)] = inst_82009);

(statearr_82207[(18)] = inst_82007);

(statearr_82207[(16)] = inst_82008);

return statearr_82207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(2),sources);
} else {
if((state_val_82196 === (24))){
var inst_82008 = (state_82195[(16)]);
var inst_82066 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82008)].join('');
var inst_82067 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82068 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_82069 = cljs.core.PersistentHashMap.fromArrays(inst_82067,inst_82068);
var inst_82070 = cljs.core.ex_info.call(null,inst_82066,inst_82069);
var inst_82071 = (function(){throw inst_82070})();
var state_82195__$1 = state_82195;
var statearr_82208_82296 = state_82195__$1;
(statearr_82208_82296[(2)] = inst_82071);

(statearr_82208_82296[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (55))){
var inst_82009 = (state_82195[(17)]);
var inst_82176 = (state_82195[(2)]);
var inst_82177 = fluree.db.util.async.throw_err.call(null,inst_82176);
var state_82195__$1 = (function (){var statearr_82209 = state_82195;
(statearr_82209[(19)] = inst_82177);

return statearr_82209;
})();
if(cljs.core.truth_(inst_82009)){
var statearr_82210_82297 = state_82195__$1;
(statearr_82210_82297[(1)] = (56));

} else {
var statearr_82211_82298 = state_82195__$1;
(statearr_82211_82298[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (39))){
var inst_82098 = (state_82195[(10)]);
var inst_82097 = (state_82195[(9)]);
var inst_82100 = (state_82195[(11)]);
var inst_82099 = (state_82195[(12)]);
var inst_82121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82123 = [inst_82098,inst_82097,inst_82099,inst_82100];
var inst_82124 = (new cljs.core.PersistentVector(null,4,(5),inst_82122,inst_82123,null));
var inst_82125 = [inst_82124,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_82126 = (new cljs.core.PersistentVector(null,2,(5),inst_82121,inst_82125,null));
var state_82195__$1 = state_82195;
var statearr_82212_82299 = state_82195__$1;
(statearr_82212_82299[(2)] = inst_82126);

(statearr_82212_82299[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (46))){
var inst_82131 = (state_82195[(20)]);
var state_82195__$1 = state_82195;
var statearr_82213_82300 = state_82195__$1;
(statearr_82213_82300[(2)] = inst_82131);

(statearr_82213_82300[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (4))){
var state_82195__$1 = state_82195;
var statearr_82214_82301 = state_82195__$1;
(statearr_82214_82301[(2)] = null);

(statearr_82214_82301[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (54))){
var inst_82173 = (state_82195[(15)]);
var inst_82012 = (state_82195[(21)]);
var inst_82172 = (state_82195[(2)]);
var inst_82173__$1 = fluree.db.util.async.throw_err.call(null,inst_82172);
var inst_82174 = fluree.db.api_js.format_history_resp.call(null,inst_82012,inst_82173__$1);
var state_82195__$1 = (function (){var statearr_82215 = state_82195;
(statearr_82215[(15)] = inst_82173__$1);

return statearr_82215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(55),inst_82174);
} else {
if((state_val_82196 === (15))){
var inst_82012 = (state_82195[(21)]);
var inst_82053 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_82012);
var state_82195__$1 = state_82195;
var statearr_82216_82302 = state_82195__$1;
(statearr_82216_82302[(2)] = inst_82053);

(statearr_82216_82302[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (48))){
var inst_82098 = (state_82195[(10)]);
var inst_82097 = (state_82195[(9)]);
var inst_82100 = (state_82195[(11)]);
var inst_82099 = (state_82195[(12)]);
var inst_82142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82144 = [inst_82098,inst_82099,inst_82097,inst_82100];
var inst_82145 = (new cljs.core.PersistentVector(null,4,(5),inst_82143,inst_82144,null));
var inst_82146 = [inst_82145,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_82147 = (new cljs.core.PersistentVector(null,2,(5),inst_82142,inst_82146,null));
var state_82195__$1 = state_82195;
var statearr_82217_82303 = state_82195__$1;
(statearr_82217_82303[(2)] = inst_82147);

(statearr_82217_82303[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (50))){
var inst_82160 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82218_82304 = state_82195__$1;
(statearr_82218_82304[(2)] = inst_82160);

(statearr_82218_82304[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (21))){
var inst_82008 = (state_82195[(16)]);
var inst_82064 = cljs.core.empty_QMARK_.call(null,inst_82008);
var state_82195__$1 = state_82195;
if(inst_82064){
var statearr_82219_82305 = state_82195__$1;
(statearr_82219_82305[(1)] = (24));

} else {
var statearr_82220_82306 = state_82195__$1;
(statearr_82220_82306[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (31))){
var inst_82108 = (state_82195[(22)]);
var inst_82097 = (state_82195[(9)]);
var inst_82108__$1 = (inst_82097 == null);
var state_82195__$1 = (function (){var statearr_82221 = state_82195;
(statearr_82221[(22)] = inst_82108__$1);

return statearr_82221;
})();
if(cljs.core.truth_(inst_82108__$1)){
var statearr_82222_82307 = state_82195__$1;
(statearr_82222_82307[(1)] = (33));

} else {
var statearr_82223_82308 = state_82195__$1;
(statearr_82223_82308[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (32))){
var inst_82055 = (state_82195[(23)]);
var inst_82045 = (state_82195[(24)]);
var inst_82012 = (state_82195[(21)]);
var inst_82164 = (state_82195[(2)]);
var inst_82165 = cljs.core.nth.call(null,inst_82164,(0),null);
var inst_82166 = cljs.core.nth.call(null,inst_82164,(1),null);
var inst_82167 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_82168 = [inst_82045,inst_82055];
var inst_82169 = cljs.core.PersistentHashMap.fromArrays(inst_82167,inst_82168);
var inst_82170 = fluree.db.query.range.time_range.call(null,inst_82012,inst_82166,cljs.core._EQ_,inst_82165,inst_82169);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(54),inst_82170);
} else {
if((state_val_82196 === (40))){
var inst_82128 = (state_82195[(25)]);
var inst_82097 = (state_82195[(9)]);
var inst_82128__$1 = (inst_82097 == null);
var state_82195__$1 = (function (){var statearr_82224 = state_82195;
(statearr_82224[(25)] = inst_82128__$1);

return statearr_82224;
})();
if(cljs.core.truth_(inst_82128__$1)){
var statearr_82225_82309 = state_82195__$1;
(statearr_82225_82309[(1)] = (42));

} else {
var statearr_82226_82310 = state_82195__$1;
(statearr_82226_82310[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (56))){
var inst_82177 = (state_82195[(19)]);
var inst_82012 = (state_82195[(21)]);
var inst_82179 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_82012,inst_82177);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(59),inst_82179);
} else {
if((state_val_82196 === (33))){
var inst_82098 = (state_82195[(10)]);
var inst_82111 = (state_82195[(26)]);
var inst_82110 = (inst_82098 == null);
var inst_82111__$1 = cljs.core.not.call(null,inst_82110);
var state_82195__$1 = (function (){var statearr_82227 = state_82195;
(statearr_82227[(26)] = inst_82111__$1);

return statearr_82227;
})();
if(inst_82111__$1){
var statearr_82228_82311 = state_82195__$1;
(statearr_82228_82311[(1)] = (36));

} else {
var statearr_82229_82312 = state_82195__$1;
(statearr_82229_82312[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (13))){
var inst_82039 = (state_82195[(2)]);
var inst_82040 = fluree.db.util.async.throw_err.call(null,inst_82039);
var inst_82041 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_82040);
var inst_82042 = (inst_82041 - (1));
var state_82195__$1 = state_82195;
var statearr_82230_82313 = state_82195__$1;
(statearr_82230_82313[(2)] = inst_82042);

(statearr_82230_82313[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (22))){
var state_82195__$1 = state_82195;
var statearr_82231_82314 = state_82195__$1;
(statearr_82231_82314[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (36))){
var inst_82099 = (state_82195[(12)]);
var inst_82113 = (inst_82099 == null);
var state_82195__$1 = state_82195;
var statearr_82233_82315 = state_82195__$1;
(statearr_82233_82315[(2)] = inst_82113);

(statearr_82233_82315[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (41))){
var inst_82162 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82234_82316 = state_82195__$1;
(statearr_82234_82316[(2)] = inst_82162);

(statearr_82234_82316[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (43))){
var inst_82128 = (state_82195[(25)]);
var state_82195__$1 = state_82195;
var statearr_82235_82317 = state_82195__$1;
(statearr_82235_82317[(2)] = inst_82128);

(statearr_82235_82317[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (61))){
var inst_82185 = (state_82195[(14)]);
var state_82195__$1 = state_82195;
var statearr_82236_82318 = state_82195__$1;
(statearr_82236_82318[(2)] = inst_82185);

(statearr_82236_82318[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (29))){
var inst_82085 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82237_82319 = state_82195__$1;
(statearr_82237_82319[(2)] = inst_82085);

(statearr_82237_82319[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (44))){
var inst_82140 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
if(cljs.core.truth_(inst_82140)){
var statearr_82238_82320 = state_82195__$1;
(statearr_82238_82320[(1)] = (48));

} else {
var statearr_82239_82321 = state_82195__$1;
(statearr_82239_82321[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (6))){
var inst_82016 = (state_82195[(2)]);
var inst_82017 = fluree.db.util.async.throw_err.call(null,inst_82016);
var state_82195__$1 = state_82195;
var statearr_82240_82322 = state_82195__$1;
(statearr_82240_82322[(2)] = inst_82017);

(statearr_82240_82322[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (28))){
var state_82195__$1 = state_82195;
var statearr_82241_82323 = state_82195__$1;
(statearr_82241_82323[(2)] = null);

(statearr_82241_82323[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (51))){
var inst_82008 = (state_82195[(16)]);
var inst_82150 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_82008)].join('');
var inst_82151 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82152 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_82153 = cljs.core.PersistentHashMap.fromArrays(inst_82151,inst_82152);
var inst_82154 = cljs.core.ex_info.call(null,inst_82150,inst_82153);
var inst_82155 = (function(){throw inst_82154})();
var state_82195__$1 = state_82195;
var statearr_82242_82324 = state_82195__$1;
(statearr_82242_82324[(2)] = inst_82155);

(statearr_82242_82324[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (25))){
var inst_82008 = (state_82195[(16)]);
var state_82195__$1 = state_82195;
var statearr_82243_82325 = state_82195__$1;
(statearr_82243_82325[(2)] = inst_82008);

(statearr_82243_82325[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (34))){
var inst_82108 = (state_82195[(22)]);
var state_82195__$1 = state_82195;
var statearr_82244_82326 = state_82195__$1;
(statearr_82244_82326[(2)] = inst_82108);

(statearr_82244_82326[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (17))){
var inst_82049 = (state_82195[(2)]);
var inst_82050 = fluree.db.util.async.throw_err.call(null,inst_82049);
var inst_82051 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_82050);
var state_82195__$1 = state_82195;
var statearr_82245_82327 = state_82195__$1;
(statearr_82245_82327[(2)] = inst_82051);

(statearr_82245_82327[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (3))){
var inst_82012 = (state_82195[(21)]);
var inst_82014 = fluree.db.api_js.resolve_block_range.call(null,inst_82012,query_map);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(6),inst_82014);
} else {
if((state_val_82196 === (12))){
var inst_82022 = (state_82195[(27)]);
var inst_82045 = (state_82195[(2)]);
var state_82195__$1 = (function (){var statearr_82246 = state_82195;
(statearr_82246[(24)] = inst_82045);

return statearr_82246;
})();
if(cljs.core.truth_(inst_82022)){
var statearr_82247_82328 = state_82195__$1;
(statearr_82247_82328[(1)] = (14));

} else {
var statearr_82248_82329 = state_82195__$1;
(statearr_82248_82329[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (2))){
var inst_82007 = (state_82195[(18)]);
var inst_82011 = (state_82195[(2)]);
var inst_82012 = fluree.db.util.async.throw_err.call(null,inst_82011);
var state_82195__$1 = (function (){var statearr_82249 = state_82195;
(statearr_82249[(21)] = inst_82012);

return statearr_82249;
})();
if(cljs.core.truth_(inst_82007)){
var statearr_82250_82330 = state_82195__$1;
(statearr_82250_82330[(1)] = (3));

} else {
var statearr_82251_82331 = state_82195__$1;
(statearr_82251_82331[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (23))){
var inst_82087 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82252_82332 = state_82195__$1;
(statearr_82252_82332[(2)] = inst_82087);

(statearr_82252_82332[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (47))){
var inst_82137 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82253_82333 = state_82195__$1;
(statearr_82253_82333[(2)] = inst_82137);

(statearr_82253_82333[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (35))){
var inst_82119 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
if(cljs.core.truth_(inst_82119)){
var statearr_82254_82334 = state_82195__$1;
(statearr_82254_82334[(1)] = (39));

} else {
var statearr_82255_82335 = state_82195__$1;
(statearr_82255_82335[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (19))){
var inst_82008 = (state_82195[(16)]);
var inst_82062 = cljs.core.sequential_QMARK_.call(null,inst_82008);
var state_82195__$1 = state_82195;
if(inst_82062){
var statearr_82256_82336 = state_82195__$1;
(statearr_82256_82336[(1)] = (21));

} else {
var statearr_82257_82337 = state_82195__$1;
(statearr_82257_82337[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (57))){
var inst_82177 = (state_82195[(19)]);
var state_82195__$1 = state_82195;
var statearr_82258_82338 = state_82195__$1;
(statearr_82258_82338[(2)] = inst_82177);

(statearr_82258_82338[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (11))){
var state_82195__$1 = state_82195;
var statearr_82259_82339 = state_82195__$1;
(statearr_82259_82339[(2)] = (-1));

(statearr_82259_82339[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (9))){
var inst_82034 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
if(cljs.core.truth_(inst_82034)){
var statearr_82260_82340 = state_82195__$1;
(statearr_82260_82340[(1)] = (10));

} else {
var statearr_82261_82341 = state_82195__$1;
(statearr_82261_82341[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (5))){
var inst_82021 = (state_82195[(7)]);
var inst_82020 = (state_82195[(2)]);
var inst_82021__$1 = cljs.core.nth.call(null,inst_82020,(0),null);
var inst_82022 = cljs.core.nth.call(null,inst_82020,(1),null);
var inst_82029 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_82195__$1 = (function (){var statearr_82262 = state_82195;
(statearr_82262[(27)] = inst_82022);

(statearr_82262[(13)] = inst_82029);

(statearr_82262[(7)] = inst_82021__$1);

return statearr_82262;
})();
if(cljs.core.truth_(inst_82021__$1)){
var statearr_82263_82342 = state_82195__$1;
(statearr_82263_82342[(1)] = (7));

} else {
var statearr_82264_82343 = state_82195__$1;
(statearr_82264_82343[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (14))){
var inst_82022 = (state_82195[(27)]);
var inst_82012 = (state_82195[(21)]);
var inst_82047 = fluree.db.time_travel.as_of_block.call(null,inst_82012,inst_82022);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(17),inst_82047);
} else {
if((state_val_82196 === (45))){
var inst_82099 = (state_82195[(12)]);
var inst_82133 = (inst_82099 == null);
var inst_82134 = cljs.core.not.call(null,inst_82133);
var state_82195__$1 = state_82195;
var statearr_82265_82344 = state_82195__$1;
(statearr_82265_82344[(2)] = inst_82134);

(statearr_82265_82344[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (53))){
var inst_82158 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82266_82345 = state_82195__$1;
(statearr_82266_82345[(2)] = inst_82158);

(statearr_82266_82345[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (26))){
var inst_82074 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82267_82346 = state_82195__$1;
(statearr_82267_82346[(2)] = inst_82074);

(statearr_82267_82346[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (16))){
var inst_82008 = (state_82195[(16)]);
var inst_82055 = (state_82195[(2)]);
var inst_82056 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_82008);
var state_82195__$1 = (function (){var statearr_82268 = state_82195;
(statearr_82268[(23)] = inst_82055);

return statearr_82268;
})();
if(inst_82056){
var statearr_82269_82347 = state_82195__$1;
(statearr_82269_82347[(1)] = (18));

} else {
var statearr_82270_82348 = state_82195__$1;
(statearr_82270_82348[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (38))){
var inst_82116 = (state_82195[(2)]);
var state_82195__$1 = state_82195;
var statearr_82271_82349 = state_82195__$1;
(statearr_82271_82349[(2)] = inst_82116);

(statearr_82271_82349[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (30))){
var inst_82089 = (state_82195[(8)]);
var inst_82104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82105 = [inst_82089,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_82106 = (new cljs.core.PersistentVector(null,2,(5),inst_82104,inst_82105,null));
var state_82195__$1 = state_82195;
var statearr_82272_82350 = state_82195__$1;
(statearr_82272_82350[(2)] = inst_82106);

(statearr_82272_82350[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (10))){
var inst_82012 = (state_82195[(21)]);
var inst_82021 = (state_82195[(7)]);
var inst_82036 = (inst_82021 - (1));
var inst_82037 = fluree.db.time_travel.as_of_block.call(null,inst_82012,inst_82036);
var state_82195__$1 = state_82195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82195__$1,(13),inst_82037);
} else {
if((state_val_82196 === (18))){
var inst_82008 = (state_82195[(16)]);
var inst_82058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82059 = [inst_82008];
var inst_82060 = (new cljs.core.PersistentVector(null,1,(5),inst_82058,inst_82059,null));
var state_82195__$1 = state_82195;
var statearr_82273_82351 = state_82195__$1;
(statearr_82273_82351[(2)] = inst_82060);

(statearr_82273_82351[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (52))){
var state_82195__$1 = state_82195;
var statearr_82274_82352 = state_82195__$1;
(statearr_82274_82352[(2)] = null);

(statearr_82274_82352[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (42))){
var inst_82098 = (state_82195[(10)]);
var inst_82131 = (state_82195[(20)]);
var inst_82130 = (inst_82098 == null);
var inst_82131__$1 = cljs.core.not.call(null,inst_82130);
var state_82195__$1 = (function (){var statearr_82275 = state_82195;
(statearr_82275[(20)] = inst_82131__$1);

return statearr_82275;
})();
if(inst_82131__$1){
var statearr_82276_82353 = state_82195__$1;
(statearr_82276_82353[(1)] = (45));

} else {
var statearr_82277_82354 = state_82195__$1;
(statearr_82277_82354[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (37))){
var inst_82111 = (state_82195[(26)]);
var state_82195__$1 = state_82195;
var statearr_82278_82355 = state_82195__$1;
(statearr_82278_82355[(2)] = inst_82111);

(statearr_82278_82355[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (8))){
var inst_82021 = (state_82195[(7)]);
var state_82195__$1 = state_82195;
var statearr_82279_82356 = state_82195__$1;
(statearr_82279_82356[(2)] = inst_82021);

(statearr_82279_82356[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82196 === (49))){
var state_82195__$1 = state_82195;
var statearr_82280_82357 = state_82195__$1;
(statearr_82280_82357[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_82282 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82282[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_82282[(1)] = (1));

return statearr_82282;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_82195){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_82195);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e82283){var ex__16224__auto__ = e82283;
var statearr_82284_82358 = state_82195;
(statearr_82284_82358[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_82195[(4)]))){
var statearr_82285_82359 = state_82195;
(statearr_82285_82359[(1)] = cljs.core.first.call(null,(state_82195[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82360 = state_82195;
state_82195 = G__82360;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_82195){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_82195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_82286 = f__16346__auto__.call(null);
(statearr_82286[(6)] = c__16345__auto__);

return statearr_82286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__82368 = arguments.length;
switch (G__82368) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = block;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4210__auto__ = block;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__82361_SHARP_){
return cljs.core.dissoc.call(null,p1__82361_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_82457){
var state_val_82458 = (state_82457[(1)]);
if((state_val_82458 === (7))){
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82408 = (state_82457[(9)]);
var inst_82414 = (state_82457[(10)]);
var inst_82424 = (function (){var responses = inst_82408;
var responses_STAR_ = inst_82411;
var statuses = inst_82414;
var fuel = inst_82418;
return (function (p1__82364_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__82364_SHARP_);
});
})();
var inst_82425 = cljs.core.some.call(null,inst_82424,inst_82414);
var state_82457__$1 = state_82457;
if(cljs.core.truth_(inst_82425)){
var statearr_82459_82507 = state_82457__$1;
(statearr_82459_82507[(1)] = (9));

} else {
var statearr_82460_82508 = state_82457__$1;
(statearr_82460_82508[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (20))){
var inst_82452 = (state_82457[(2)]);
var state_82457__$1 = state_82457;
var statearr_82461_82509 = state_82457__$1;
(statearr_82461_82509[(2)] = inst_82452);

(statearr_82461_82509[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (1))){
var inst_82403 = cljs.core.async.chan.call(null,(1));
var inst_82404 = (function (){var c__16345__auto____$1 = inst_82403;
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_82401){
var state_val_82402 = (state_82401[(1)]);
if((state_val_82402 === (1))){
var inst_82369 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_82370 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_82371 = cljs.core.assoc.call(null,inst_82370,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_82372 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_82373 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_82374 = cljs.core.PersistentHashMap.EMPTY;
var inst_82375 = inst_82369;
var inst_82376 = inst_82371;
var inst_82377 = inst_82372;
var inst_82378 = inst_82373;
var inst_82379 = inst_82374;
var state_82401__$1 = (function (){var statearr_82462 = state_82401;
(statearr_82462[(7)] = inst_82379);

(statearr_82462[(8)] = inst_82376);

(statearr_82462[(9)] = inst_82378);

(statearr_82462[(10)] = inst_82375);

(statearr_82462[(11)] = inst_82377);

return statearr_82462;
})();
var statearr_82463_82510 = state_82401__$1;
(statearr_82463_82510[(2)] = null);

(statearr_82463_82510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82402 === (2))){
var inst_82376 = (state_82401[(8)]);
var inst_82381 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_82376);
var inst_82382 = cljs.core.merge.call(null,opts,inst_82381);
var inst_82383 = cljs.core.assoc.call(null,inst_82376,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82382);
var inst_82384 = fluree.db.api_js.query_async.call(null,db,inst_82383,db_fn);
var state_82401__$1 = state_82401;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82401__$1,(4),inst_82384);
} else {
if((state_val_82402 === (3))){
var inst_82399 = (state_82401[(2)]);
var state_82401__$1 = state_82401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82401__$1,inst_82399);
} else {
if((state_val_82402 === (4))){
var inst_82379 = (state_82401[(7)]);
var inst_82375 = (state_82401[(10)]);
var inst_82377 = (state_82401[(11)]);
var inst_82386 = (state_82401[(2)]);
var inst_82387 = cljs.core.assoc.call(null,inst_82379,inst_82375,inst_82386);
var inst_82388 = cljs.core.first.call(null,inst_82377);
var state_82401__$1 = (function (){var statearr_82464 = state_82401;
(statearr_82464[(12)] = inst_82387);

return statearr_82464;
})();
if(cljs.core.truth_(inst_82388)){
var statearr_82465_82511 = state_82401__$1;
(statearr_82465_82511[(1)] = (5));

} else {
var statearr_82466_82512 = state_82401__$1;
(statearr_82466_82512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82402 === (5))){
var inst_82378 = (state_82401[(9)]);
var inst_82377 = (state_82401[(11)]);
var inst_82387 = (state_82401[(12)]);
var inst_82390 = cljs.core.first.call(null,inst_82377);
var inst_82391 = cljs.core.first.call(null,inst_82378);
var inst_82392 = cljs.core.rest.call(null,inst_82377);
var inst_82393 = cljs.core.rest.call(null,inst_82378);
var inst_82375 = inst_82390;
var inst_82376 = inst_82391;
var inst_82377__$1 = inst_82392;
var inst_82378__$1 = inst_82393;
var inst_82379 = inst_82387;
var state_82401__$1 = (function (){var statearr_82467 = state_82401;
(statearr_82467[(7)] = inst_82379);

(statearr_82467[(8)] = inst_82376);

(statearr_82467[(9)] = inst_82378__$1);

(statearr_82467[(10)] = inst_82375);

(statearr_82467[(11)] = inst_82377__$1);

return statearr_82467;
})();
var statearr_82468_82513 = state_82401__$1;
(statearr_82468_82513[(2)] = null);

(statearr_82468_82513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82402 === (6))){
var inst_82387 = (state_82401[(12)]);
var state_82401__$1 = state_82401;
var statearr_82469_82514 = state_82401__$1;
(statearr_82469_82514[(2)] = inst_82387);

(statearr_82469_82514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82402 === (7))){
var inst_82397 = (state_82401[(2)]);
var state_82401__$1 = state_82401;
var statearr_82470_82515 = state_82401__$1;
(statearr_82470_82515[(2)] = inst_82397);

(statearr_82470_82515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_82471 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82471[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_82471[(1)] = (1));

return statearr_82471;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_82401){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_82401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e82472){var ex__16224__auto__ = e82472;
var statearr_82473_82516 = state_82401;
(statearr_82473_82516[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_82401[(4)]))){
var statearr_82474_82517 = state_82401;
(statearr_82474_82517[(1)] = cljs.core.first.call(null,(state_82401[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82518 = state_82401;
state_82401 = G__82518;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_82401){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_82401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_82475 = f__16346__auto__.call(null);
(statearr_82475[(6)] = c__16345__auto____$1);

return statearr_82475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});
})();
var inst_82405 = cljs.core.async.impl.dispatch.run.call(null,inst_82404);
var state_82457__$1 = (function (){var statearr_82476 = state_82457;
(statearr_82476[(11)] = inst_82405);

return statearr_82476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82457__$1,(2),inst_82403);
} else {
if((state_val_82458 === (4))){
var inst_82408 = (state_82457[(9)]);
var state_82457__$1 = state_82457;
var statearr_82477_82519 = state_82457__$1;
(statearr_82477_82519[(2)] = inst_82408);

(statearr_82477_82519[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (15))){
var state_82457__$1 = state_82457;
var statearr_82478_82520 = state_82457__$1;
(statearr_82478_82520[(2)] = (400));

(statearr_82478_82520[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (13))){
var state_82457__$1 = state_82457;
var statearr_82479_82521 = state_82457__$1;
(statearr_82479_82521[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (6))){
var inst_82414 = (state_82457[(10)]);
var inst_82422 = cljs.core.first.call(null,inst_82414);
var state_82457__$1 = state_82457;
var statearr_82481_82522 = state_82457__$1;
(statearr_82481_82522[(2)] = inst_82422);

(statearr_82481_82522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (17))){
var inst_82435 = (state_82457[(2)]);
var state_82457__$1 = state_82457;
var statearr_82482_82523 = state_82457__$1;
(statearr_82482_82523[(2)] = inst_82435);

(statearr_82482_82523[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (3))){
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82408 = (state_82457[(9)]);
var inst_82414 = (state_82457[(10)]);
var inst_82413 = cljs.core.vals.call(null,inst_82408);
var inst_82414__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_82413);
var inst_82415 = (function (){var responses = inst_82408;
var responses_STAR_ = inst_82411;
var statuses = inst_82414__$1;
return (function (p1__82362_SHARP_){
var or__4212__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__82362_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
});
})();
var inst_82416 = cljs.core.vals.call(null,inst_82408);
var inst_82417 = cljs.core.map.call(null,inst_82415,inst_82416);
var inst_82418__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_82417);
var inst_82419 = (function (){var responses = inst_82408;
var responses_STAR_ = inst_82411;
var statuses = inst_82414__$1;
var fuel = inst_82418__$1;
return (function (p1__82363_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__82363_SHARP_);
});
})();
var inst_82420 = cljs.core.every_QMARK_.call(null,inst_82419,inst_82414__$1);
var state_82457__$1 = (function (){var statearr_82483 = state_82457;
(statearr_82483[(8)] = inst_82418__$1);

(statearr_82483[(10)] = inst_82414__$1);

return statearr_82483;
})();
if(inst_82420){
var statearr_82484_82524 = state_82457__$1;
(statearr_82484_82524[(1)] = (6));

} else {
var statearr_82485_82525 = state_82457__$1;
(statearr_82485_82525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (12))){
var state_82457__$1 = state_82457;
var statearr_82486_82526 = state_82457__$1;
(statearr_82486_82526[(2)] = (500));

(statearr_82486_82526[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (2))){
var inst_82408 = (state_82457[(9)]);
var inst_82407 = (state_82457[(2)]);
var inst_82408__$1 = fluree.db.util.async.throw_err.call(null,inst_82407);
var inst_82409 = (function (){var responses = inst_82408__$1;
return (function (acc,index,response){
var resp = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_82410 = cljs.core.PersistentHashMap.EMPTY;
var inst_82411 = cljs.core.reduce_kv.call(null,inst_82409,inst_82410,inst_82408__$1);
var state_82457__$1 = (function (){var statearr_82487 = state_82457;
(statearr_82487[(7)] = inst_82411);

(statearr_82487[(9)] = inst_82408__$1);

return statearr_82487;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_82488_82527 = state_82457__$1;
(statearr_82488_82527[(1)] = (3));

} else {
var statearr_82489_82528 = state_82457__$1;
(statearr_82489_82528[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (19))){
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82441 = (state_82457[(12)]);
var inst_82450 = cljs.core.assoc.call(null,inst_82411,new cljs.core.Keyword(null,"status","status",-1997798413),inst_82441,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_82418);
var state_82457__$1 = state_82457;
var statearr_82490_82529 = state_82457__$1;
(statearr_82490_82529[(2)] = inst_82450);

(statearr_82490_82529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (11))){
var inst_82439 = (state_82457[(2)]);
var state_82457__$1 = state_82457;
var statearr_82491_82530 = state_82457__$1;
(statearr_82491_82530[(2)] = inst_82439);

(statearr_82491_82530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (9))){
var state_82457__$1 = state_82457;
var statearr_82492_82531 = state_82457__$1;
(statearr_82492_82531[(2)] = (207));

(statearr_82492_82531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (5))){
var inst_82455 = (state_82457[(2)]);
var state_82457__$1 = state_82457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82457__$1,inst_82455);
} else {
if((state_val_82458 === (14))){
var inst_82437 = (state_82457[(2)]);
var state_82457__$1 = state_82457;
var statearr_82493_82532 = state_82457__$1;
(statearr_82493_82532[(2)] = inst_82437);

(statearr_82493_82532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (16))){
var state_82457__$1 = state_82457;
var statearr_82494_82533 = state_82457__$1;
(statearr_82494_82533[(2)] = null);

(statearr_82494_82533[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (10))){
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82408 = (state_82457[(9)]);
var inst_82414 = (state_82457[(10)]);
var inst_82428 = (function (){var responses = inst_82408;
var responses_STAR_ = inst_82411;
var statuses = inst_82414;
var fuel = inst_82418;
return (function (p1__82365_SHARP_){
return ((499) < p1__82365_SHARP_);
});
})();
var inst_82429 = cljs.core.some.call(null,inst_82428,inst_82414);
var state_82457__$1 = state_82457;
if(cljs.core.truth_(inst_82429)){
var statearr_82495_82534 = state_82457__$1;
(statearr_82495_82534[(1)] = (12));

} else {
var statearr_82496_82535 = state_82457__$1;
(statearr_82496_82535[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (18))){
var inst_82446 = (state_82457[(13)]);
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82441 = (state_82457[(12)]);
var inst_82448 = cljs.core.assoc.call(null,inst_82411,new cljs.core.Keyword(null,"status","status",-1997798413),inst_82441,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_82418,new cljs.core.Keyword(null,"block","block",664686210),inst_82446);
var state_82457__$1 = state_82457;
var statearr_82497_82536 = state_82457__$1;
(statearr_82497_82536[(2)] = inst_82448);

(statearr_82497_82536[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82458 === (8))){
var inst_82446 = (state_82457[(13)]);
var inst_82411 = (state_82457[(7)]);
var inst_82418 = (state_82457[(8)]);
var inst_82441 = (state_82457[(12)]);
var inst_82408 = (state_82457[(9)]);
var inst_82414 = (state_82457[(10)]);
var inst_82441__$1 = (state_82457[(2)]);
var inst_82442 = (function (){var responses = inst_82408;
var responses_STAR_ = inst_82411;
var statuses = inst_82414;
var fuel = inst_82418;
var status = inst_82441__$1;
return (function (p1__82366_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__82366_SHARP_));
});
})();
var inst_82443 = cljs.core.vals.call(null,inst_82408);
var inst_82444 = cljs.core.filter.call(null,inst_82442,inst_82443);
var inst_82445 = cljs.core.first.call(null,inst_82444);
var inst_82446__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_82445);
var state_82457__$1 = (function (){var statearr_82498 = state_82457;
(statearr_82498[(13)] = inst_82446__$1);

(statearr_82498[(12)] = inst_82441__$1);

return statearr_82498;
})();
if(cljs.core.truth_(inst_82446__$1)){
var statearr_82499_82537 = state_82457__$1;
(statearr_82499_82537[(1)] = (18));

} else {
var statearr_82500_82538 = state_82457__$1;
(statearr_82500_82538[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_82501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82501[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_82501[(1)] = (1));

return statearr_82501;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_82457){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_82457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e82502){var ex__16224__auto__ = e82502;
var statearr_82503_82539 = state_82457;
(statearr_82503_82539[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_82457[(4)]))){
var statearr_82504_82540 = state_82457;
(statearr_82504_82540[(1)] = cljs.core.first.call(null,(state_82457[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82541 = state_82457;
state_82457 = G__82541;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_82457){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_82457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_82505 = f__16346__auto__.call(null);
(statearr_82505[(6)] = c__16345__auto__);

return statearr_82505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__82543 = arguments.length;
switch (G__82543) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__82544 = opts;
var map__82544__$1 = cljs.core.__destructure_map.call(null,map__82544);
var auth = cljs.core.get.call(null,map__82544__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__82544__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__82544__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__82544__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__82545 = (cljs.core.truth_((function (){var and__4210__auto__ = auth;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4210__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__82545,(0),null);
var authority = cljs.core.nth.call(null,vec__82545,(1),null);
var action__$1 = (function (){var or__4212__auto__ = action;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4212__auto__ = nonce;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4212__auto__ = expire;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e82548){var e = e82548;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__82551 = arguments.length;
switch (G__82551) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_82582){
var state_val_82583 = (state_82582[(1)]);
if((state_val_82583 === (7))){
var state_82582__$1 = state_82582;
var statearr_82584_82605 = state_82582__$1;
(statearr_82584_82605[(2)] = opts);

(statearr_82584_82605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (1))){
var state_82582__$1 = state_82582;
var statearr_82585_82606 = state_82582__$1;
(statearr_82585_82606[(2)] = null);

(statearr_82585_82606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (4))){
var inst_82552 = (state_82582[(2)]);
var inst_82553 = fluree.db.util.log.error.call(null,inst_82552);
var inst_82554 = cljs.core.ex_data.call(null,inst_82552);
var inst_82555 = cljs.core.ex_message.call(null,inst_82552);
var inst_82556 = cljs.core.assoc.call(null,inst_82554,new cljs.core.Keyword(null,"message","message",-406056002),inst_82555);
var state_82582__$1 = (function (){var statearr_82586 = state_82582;
(statearr_82586[(7)] = inst_82553);

return statearr_82586;
})();
var statearr_82587_82607 = state_82582__$1;
(statearr_82587_82607[(2)] = inst_82556);

(statearr_82587_82607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (6))){
var inst_82566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82567 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_82568 = (new cljs.core.PersistentVector(null,1,(5),inst_82566,inst_82567,null));
var inst_82569 = cljs.core.assoc_in.call(null,opts,inst_82568,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_82582__$1 = state_82582;
var statearr_82588_82608 = state_82582__$1;
(statearr_82588_82608[(2)] = inst_82569);

(statearr_82588_82608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (3))){
var inst_82580 = (state_82582[(2)]);
var state_82582__$1 = state_82582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_82582__$1,inst_82580);
} else {
if((state_val_82583 === (2))){
var _ = (function (){var statearr_82590 = state_82582;
(statearr_82590[(4)] = cljs.core.cons.call(null,(5),(state_82582[(4)])));

return statearr_82590;
})();
var inst_82562 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_82563 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_82564 = (inst_82563 == null);
var state_82582__$1 = (function (){var statearr_82591 = state_82582;
(statearr_82591[(8)] = inst_82562);

return statearr_82591;
})();
if(cljs.core.truth_(inst_82564)){
var statearr_82592_82609 = state_82582__$1;
(statearr_82592_82609[(1)] = (6));

} else {
var statearr_82593_82610 = state_82582__$1;
(statearr_82593_82610[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (9))){
var inst_82576 = (state_82582[(2)]);
var inst_82577 = fluree.db.util.async.throw_err.call(null,inst_82576);
var _ = (function (){var statearr_82594 = state_82582;
(statearr_82594[(4)] = cljs.core.rest.call(null,(state_82582[(4)])));

return statearr_82594;
})();
var state_82582__$1 = state_82582;
var statearr_82595_82611 = state_82582__$1;
(statearr_82595_82611[(2)] = inst_82577);

(statearr_82595_82611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (5))){
var _ = (function (){var statearr_82596 = state_82582;
(statearr_82596[(4)] = cljs.core.rest.call(null,(state_82582[(4)])));

return statearr_82596;
})();
var state_82582__$1 = state_82582;
var ex82589 = (state_82582__$1[(2)]);
var statearr_82597_82612 = state_82582__$1;
(statearr_82597_82612[(5)] = ex82589);


var statearr_82598_82613 = state_82582__$1;
(statearr_82598_82613[(1)] = (4));

(statearr_82598_82613[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82583 === (8))){
var inst_82562 = (state_82582[(8)]);
var inst_82572 = (state_82582[(2)]);
var inst_82573 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_82562,inst_82572);
var inst_82574 = fluree.db.operations.command_async.call(null,conn,inst_82573);
var state_82582__$1 = state_82582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_82582__$1,(9),inst_82574);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__16221__auto__ = null;
var fluree$db$api_js$state_machine__16221__auto____0 = (function (){
var statearr_82599 = [null,null,null,null,null,null,null,null,null];
(statearr_82599[(0)] = fluree$db$api_js$state_machine__16221__auto__);

(statearr_82599[(1)] = (1));

return statearr_82599;
});
var fluree$db$api_js$state_machine__16221__auto____1 = (function (state_82582){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_82582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e82600){var ex__16224__auto__ = e82600;
var statearr_82601_82614 = state_82582;
(statearr_82601_82614[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_82582[(4)]))){
var statearr_82602_82615 = state_82582;
(statearr_82602_82615[(1)] = cljs.core.first.call(null,(state_82582[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82616 = state_82582;
state_82582 = G__82616;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__16221__auto__ = function(state_82582){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__16221__auto____1.call(this,state_82582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__16221__auto____0;
fluree$db$api_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__16221__auto____1;
return fluree$db$api_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_82603 = f__16346__auto__.call(null);
(statearr_82603[(6)] = c__16345__auto__);

return statearr_82603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

