// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__80139 = arguments.length;
switch (G__80139) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80181){
var state_val_80182 = (state_80181[(1)]);
if((state_val_80182 === (7))){
var inst_80151 = typeof user === 'string';
var state_80181__$1 = state_80181;
if(cljs.core.truth_(inst_80151)){
var statearr_80183_80212 = state_80181__$1;
(statearr_80183_80212[(1)] = (9));

} else {
var statearr_80184_80213 = state_80181__$1;
(statearr_80184_80213[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (1))){
var state_80181__$1 = state_80181;
var statearr_80185_80214 = state_80181__$1;
(statearr_80185_80214[(2)] = null);

(statearr_80185_80214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (4))){
var inst_80140 = (state_80181[(2)]);
var inst_80141 = fluree.db.util.log.error.call(null,inst_80140);
var inst_80142 = reject.call(null,inst_80140);
var state_80181__$1 = (function (){var statearr_80186 = state_80181;
(statearr_80186[(7)] = inst_80141);

return statearr_80186;
})();
var statearr_80187_80215 = state_80181__$1;
(statearr_80187_80215[(2)] = inst_80142);

(statearr_80187_80215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (15))){
var inst_80170 = (state_80181[(2)]);
var inst_80171 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_80170);
var inst_80172 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_80173 = cljs.core.constantly.call(null,inst_80171);
var inst_80174 = cljs.core.swap_BANG_.call(null,inst_80172,inst_80173);
var inst_80175 = fluree.db.connection.add_token.call(null,conn,inst_80171);
var inst_80176 = resolve.call(null,inst_80170);
var _ = (function (){var statearr_80188 = state_80181;
(statearr_80188[(4)] = cljs.core.rest.call(null,(state_80181[(4)])));

return statearr_80188;
})();
var state_80181__$1 = (function (){var statearr_80189 = state_80181;
(statearr_80189[(8)] = inst_80175);

(statearr_80189[(9)] = inst_80174);

return statearr_80189;
})();
var statearr_80190_80216 = state_80181__$1;
(statearr_80190_80216[(2)] = inst_80176);

(statearr_80190_80216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (13))){
var state_80181__$1 = state_80181;
var statearr_80191_80217 = state_80181__$1;
(statearr_80191_80217[(2)] = null);

(statearr_80191_80217[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (6))){
var state_80181__$1 = state_80181;
var statearr_80192_80218 = state_80181__$1;
(statearr_80192_80218[(2)] = user);

(statearr_80192_80218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (3))){
var inst_80179 = (state_80181[(2)]);
var state_80181__$1 = state_80181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80181__$1,inst_80179);
} else {
if((state_val_80182 === (12))){
var state_80181__$1 = state_80181;
var statearr_80193_80219 = state_80181__$1;
(statearr_80193_80219[(2)] = user);

(statearr_80193_80219[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (2))){
var _ = (function (){var statearr_80194 = state_80181;
(statearr_80194[(4)] = cljs.core.cons.call(null,(5),(state_80181[(4)])));

return statearr_80194;
})();
var inst_80148 = typeof user === 'number';
var state_80181__$1 = state_80181;
if(cljs.core.truth_(inst_80148)){
var statearr_80195_80220 = state_80181__$1;
(statearr_80195_80220[(1)] = (6));

} else {
var statearr_80196_80221 = state_80181__$1;
(statearr_80196_80221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (11))){
var inst_80162 = (state_80181[(2)]);
var state_80181__$1 = state_80181;
var statearr_80198_80222 = state_80181__$1;
(statearr_80198_80222[(2)] = inst_80162);

(statearr_80198_80222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (9))){
var inst_80153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80154 = ["_user/username",user];
var inst_80155 = (new cljs.core.PersistentVector(null,2,(5),inst_80153,inst_80154,null));
var state_80181__$1 = state_80181;
var statearr_80199_80223 = state_80181__$1;
(statearr_80199_80223[(2)] = inst_80155);

(statearr_80199_80223[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (5))){
var _ = (function (){var statearr_80200 = state_80181;
(statearr_80200[(4)] = cljs.core.rest.call(null,(state_80181[(4)])));

return statearr_80200;
})();
var state_80181__$1 = state_80181;
var ex80197 = (state_80181__$1[(2)]);
var statearr_80201_80224 = state_80181__$1;
(statearr_80201_80224[(5)] = ex80197);


var statearr_80202_80225 = state_80181__$1;
(statearr_80202_80225[(1)] = (4));

(statearr_80202_80225[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (14))){
var inst_80160 = (state_80181[(2)]);
var state_80181__$1 = state_80181;
var statearr_80203_80226 = state_80181__$1;
(statearr_80203_80226[(2)] = inst_80160);

(statearr_80203_80226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (10))){
var state_80181__$1 = state_80181;
var statearr_80204_80227 = state_80181__$1;
(statearr_80204_80227[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80182 === (8))){
var inst_80164 = (state_80181[(2)]);
var inst_80165 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_80166 = [account,inst_80164,password,expireSeconds,syncTo];
var inst_80167 = cljs.core.PersistentHashMap.fromArrays(inst_80165,inst_80166);
var inst_80168 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_80167);
var state_80181__$1 = state_80181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80181__$1,(15),inst_80168);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__16221__auto__ = null;
var fluree$db$connection_js$state_machine__16221__auto____0 = (function (){
var statearr_80206 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80206[(0)] = fluree$db$connection_js$state_machine__16221__auto__);

(statearr_80206[(1)] = (1));

return statearr_80206;
});
var fluree$db$connection_js$state_machine__16221__auto____1 = (function (state_80181){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80207){var ex__16224__auto__ = e80207;
var statearr_80208_80228 = state_80181;
(statearr_80208_80228[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80181[(4)]))){
var statearr_80209_80229 = state_80181;
(statearr_80209_80229[(1)] = cljs.core.first.call(null,(state_80181[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80230 = state_80181;
state_80181 = G__80230;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__16221__auto__ = function(state_80181){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__16221__auto____1.call(this,state_80181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__16221__auto____0;
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__16221__auto____1;
return fluree$db$connection_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80210 = f__16346__auto__.call(null);
(statearr_80210[(6)] = c__16345__auto__);

return statearr_80210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__80232 = arguments.length;
switch (G__80232) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80241){
var state_val_80242 = (state_80241[(1)]);
if((state_val_80242 === (1))){
var inst_80233 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_80234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80235 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_80236 = (new cljs.core.PersistentVector(null,4,(5),inst_80234,inst_80235,null));
var inst_80237 = cljs.core.async.put_BANG_.call(null,inst_80233,inst_80236);
var inst_80238 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__80243 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__80244 = null;
var count__80245 = (0);
var i__80246 = (0);
while(true){
if((i__80246 < count__80245)){
var k = cljs.core._nth.call(null,chunk__80244,i__80246);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__80254 = seq__80243;
var G__80255 = chunk__80244;
var G__80256 = count__80245;
var G__80257 = (i__80246 + (1));
seq__80243 = G__80254;
chunk__80244 = G__80255;
count__80245 = G__80256;
i__80246 = G__80257;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__80243);
if(temp__5753__auto__){
var seq__80243__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__80243__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__80243__$1);
var G__80258 = cljs.core.chunk_rest.call(null,seq__80243__$1);
var G__80259 = c__4638__auto__;
var G__80260 = cljs.core.count.call(null,c__4638__auto__);
var G__80261 = (0);
seq__80243 = G__80258;
chunk__80244 = G__80259;
count__80245 = G__80260;
i__80246 = G__80261;
continue;
} else {
var k = cljs.core.first.call(null,seq__80243__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__80262 = cljs.core.next.call(null,seq__80243__$1);
var G__80263 = null;
var G__80264 = (0);
var G__80265 = (0);
seq__80243 = G__80262;
chunk__80244 = G__80263;
count__80245 = G__80264;
i__80246 = G__80265;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_80239 = cljs.core.async.take_BANG_.call(null,pc,inst_80238);
var state_80241__$1 = (function (){var statearr_80247 = state_80241;
(statearr_80247[(7)] = inst_80237);

return statearr_80247;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80241__$1,inst_80239);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__16221__auto__ = null;
var fluree$db$connection_js$state_machine__16221__auto____0 = (function (){
var statearr_80248 = [null,null,null,null,null,null,null,null];
(statearr_80248[(0)] = fluree$db$connection_js$state_machine__16221__auto__);

(statearr_80248[(1)] = (1));

return statearr_80248;
});
var fluree$db$connection_js$state_machine__16221__auto____1 = (function (state_80241){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80241);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80249){var ex__16224__auto__ = e80249;
var statearr_80250_80266 = state_80241;
(statearr_80250_80266[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80241[(4)]))){
var statearr_80251_80267 = state_80241;
(statearr_80251_80267[(1)] = cljs.core.first.call(null,(state_80241[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80268 = state_80241;
state_80241 = G__80268;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__16221__auto__ = function(state_80241){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__16221__auto____1.call(this,state_80241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__16221__auto____0;
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__16221__auto____1;
return fluree$db$connection_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80252 = f__16346__auto__.call(null);
(statearr_80252[(6)] = c__16345__auto__);

return statearr_80252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__80270 = arguments.length;
switch (G__80270) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80304){
var state_val_80305 = (state_80304[(1)]);
if((state_val_80305 === (1))){
var state_80304__$1 = state_80304;
var statearr_80306_80327 = state_80304__$1;
(statearr_80306_80327[(2)] = null);

(statearr_80306_80327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80305 === (2))){
var _ = (function (){var statearr_80307 = state_80304;
(statearr_80307[(4)] = cljs.core.cons.call(null,(5),(state_80304[(4)])));

return statearr_80307;
})();
var inst_80279 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_80280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80281 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_80282 = (new cljs.core.PersistentVector(null,1,(5),inst_80280,inst_80281,null));
var inst_80283 = cljs.core.PersistentHashMap.EMPTY;
var inst_80284 = cljs.core.atom.call(null,inst_80283);
var inst_80285 = cljs.core.assoc_in.call(null,inst_80279,inst_80282,inst_80284);
var inst_80286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80287 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_80288 = (new cljs.core.PersistentVector(null,1,(5),inst_80286,inst_80287,null));
var inst_80289 = cljs.core.PersistentHashMap.EMPTY;
var inst_80290 = cljs.core.atom.call(null,inst_80289);
var inst_80291 = cljs.core.assoc_in.call(null,inst_80285,inst_80288,inst_80290);
var inst_80292 = cljs.core.async.promise_chan.call(null);
var inst_80293 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_80291);
var inst_80294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80295 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_80292,null];
var inst_80296 = (new cljs.core.PersistentVector(null,4,(5),inst_80294,inst_80295,null));
var inst_80297 = cljs.core.async.put_BANG_.call(null,inst_80293,inst_80296);
var inst_80298 = (function (){var conn = inst_80291;
var pc = inst_80292;
return (function (x){
if((x == null)){
} else {
var seq__80308_80328 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__80309_80329 = null;
var count__80310_80330 = (0);
var i__80311_80331 = (0);
while(true){
if((i__80311_80331 < count__80310_80330)){
var k_80332 = cljs.core._nth.call(null,chunk__80309_80329,i__80311_80331);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_80332], null),cljs.core.get.call(null,x,k_80332,null));


var G__80333 = seq__80308_80328;
var G__80334 = chunk__80309_80329;
var G__80335 = count__80310_80330;
var G__80336 = (i__80311_80331 + (1));
seq__80308_80328 = G__80333;
chunk__80309_80329 = G__80334;
count__80310_80330 = G__80335;
i__80311_80331 = G__80336;
continue;
} else {
var temp__5753__auto___80337 = cljs.core.seq.call(null,seq__80308_80328);
if(temp__5753__auto___80337){
var seq__80308_80338__$1 = temp__5753__auto___80337;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__80308_80338__$1)){
var c__4638__auto___80339 = cljs.core.chunk_first.call(null,seq__80308_80338__$1);
var G__80340 = cljs.core.chunk_rest.call(null,seq__80308_80338__$1);
var G__80341 = c__4638__auto___80339;
var G__80342 = cljs.core.count.call(null,c__4638__auto___80339);
var G__80343 = (0);
seq__80308_80328 = G__80340;
chunk__80309_80329 = G__80341;
count__80310_80330 = G__80342;
i__80311_80331 = G__80343;
continue;
} else {
var k_80344 = cljs.core.first.call(null,seq__80308_80338__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_80344], null),cljs.core.get.call(null,x,k_80344,null));


var G__80345 = cljs.core.next.call(null,seq__80308_80338__$1);
var G__80346 = null;
var G__80347 = (0);
var G__80348 = (0);
seq__80308_80328 = G__80345;
chunk__80309_80329 = G__80346;
count__80310_80330 = G__80347;
i__80311_80331 = G__80348;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_80299 = cljs.core.async.take_BANG_.call(null,inst_80292,inst_80298);
var ___$1 = (function (){var statearr_80312 = state_80304;
(statearr_80312[(4)] = cljs.core.rest.call(null,(state_80304[(4)])));

return statearr_80312;
})();
var state_80304__$1 = (function (){var statearr_80313 = state_80304;
(statearr_80313[(7)] = inst_80297);

return statearr_80313;
})();
var statearr_80314_80349 = state_80304__$1;
(statearr_80314_80349[(2)] = inst_80299);

(statearr_80314_80349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80305 === (3))){
var inst_80302 = (state_80304[(2)]);
var state_80304__$1 = state_80304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80304__$1,inst_80302);
} else {
if((state_val_80305 === (4))){
var inst_80271 = (state_80304[(2)]);
var inst_80272 = fluree.db.util.log.error.call(null,inst_80271);
var inst_80273 = reject.call(null,inst_80271);
var state_80304__$1 = (function (){var statearr_80316 = state_80304;
(statearr_80316[(8)] = inst_80272);

return statearr_80316;
})();
var statearr_80317_80350 = state_80304__$1;
(statearr_80317_80350[(2)] = inst_80273);

(statearr_80317_80350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80305 === (5))){
var _ = (function (){var statearr_80318 = state_80304;
(statearr_80318[(4)] = cljs.core.rest.call(null,(state_80304[(4)])));

return statearr_80318;
})();
var state_80304__$1 = state_80304;
var ex80315 = (state_80304__$1[(2)]);
var statearr_80319_80351 = state_80304__$1;
(statearr_80319_80351[(5)] = ex80315);


var statearr_80320_80352 = state_80304__$1;
(statearr_80320_80352[(1)] = (4));

(statearr_80320_80352[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__16221__auto__ = null;
var fluree$db$connection_js$state_machine__16221__auto____0 = (function (){
var statearr_80321 = [null,null,null,null,null,null,null,null,null];
(statearr_80321[(0)] = fluree$db$connection_js$state_machine__16221__auto__);

(statearr_80321[(1)] = (1));

return statearr_80321;
});
var fluree$db$connection_js$state_machine__16221__auto____1 = (function (state_80304){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80322){var ex__16224__auto__ = e80322;
var statearr_80323_80353 = state_80304;
(statearr_80323_80353[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80304[(4)]))){
var statearr_80324_80354 = state_80304;
(statearr_80324_80354[(1)] = cljs.core.first.call(null,(state_80304[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80355 = state_80304;
state_80304 = G__80355;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__16221__auto__ = function(state_80304){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__16221__auto____1.call(this,state_80304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__16221__auto____0;
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__16221__auto____1;
return fluree$db$connection_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80325 = f__16346__auto__.call(null);
(statearr_80325[(6)] = c__16345__auto__);

return statearr_80325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__80357 = arguments.length;
switch (G__80357) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__80359 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__80359,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__80359,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__80362 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__80362,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__80362,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80415){
var state_val_80416 = (state_80415[(1)]);
if((state_val_80416 === (7))){
var inst_80376 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80377 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_80378 = cljs.core.PersistentHashMap.fromArrays(inst_80376,inst_80377);
var inst_80379 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_80378);
var inst_80380 = (function(){throw inst_80379})();
var state_80415__$1 = state_80415;
var statearr_80417_80446 = state_80415__$1;
(statearr_80417_80446[(2)] = inst_80380);

(statearr_80417_80446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (1))){
var state_80415__$1 = state_80415;
var statearr_80418_80447 = state_80415__$1;
(statearr_80418_80447[(2)] = null);

(statearr_80418_80447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (4))){
var inst_80365 = (state_80415[(2)]);
var inst_80366 = cljs.core.clj__GT_js.call(null,inst_80365);
var inst_80367 = reject.call(null,inst_80366);
var state_80415__$1 = state_80415;
var statearr_80419_80448 = state_80415__$1;
(statearr_80419_80448[(2)] = inst_80367);

(statearr_80419_80448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (13))){
var inst_80394 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80395 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_80396 = cljs.core.PersistentHashMap.fromArrays(inst_80394,inst_80395);
var inst_80397 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_80396);
var inst_80398 = (function(){throw inst_80397})();
var state_80415__$1 = state_80415;
var statearr_80420_80449 = state_80415__$1;
(statearr_80420_80449[(2)] = inst_80398);

(statearr_80420_80449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (6))){
var state_80415__$1 = state_80415;
var statearr_80421_80450 = state_80415__$1;
(statearr_80421_80450[(2)] = null);

(statearr_80421_80450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (3))){
var inst_80413 = (state_80415[(2)]);
var state_80415__$1 = state_80415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80415__$1,inst_80413);
} else {
if((state_val_80416 === (12))){
var state_80415__$1 = state_80415;
var statearr_80422_80451 = state_80415__$1;
(statearr_80422_80451[(2)] = null);

(statearr_80422_80451[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (2))){
var _ = (function (){var statearr_80423 = state_80415;
(statearr_80423[(4)] = cljs.core.cons.call(null,(5),(state_80415[(4)])));

return statearr_80423;
})();
var inst_80373 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_80415__$1 = state_80415;
if(cljs.core.truth_(inst_80373)){
var statearr_80424_80452 = state_80415__$1;
(statearr_80424_80452[(1)] = (6));

} else {
var statearr_80425_80453 = state_80415__$1;
(statearr_80425_80453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (11))){
var inst_80391 = (state_80415[(2)]);
var state_80415__$1 = (function (){var statearr_80427 = state_80415;
(statearr_80427[(7)] = inst_80391);

return statearr_80427;
})();
if(cljs.core.truth_(password)){
var statearr_80428_80454 = state_80415__$1;
(statearr_80428_80454[(1)] = (12));

} else {
var statearr_80429_80455 = state_80415__$1;
(statearr_80429_80455[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (9))){
var state_80415__$1 = state_80415;
var statearr_80430_80456 = state_80415__$1;
(statearr_80430_80456[(2)] = null);

(statearr_80430_80456[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (5))){
var _ = (function (){var statearr_80431 = state_80415;
(statearr_80431[(4)] = cljs.core.rest.call(null,(state_80415[(4)])));

return statearr_80431;
})();
var state_80415__$1 = state_80415;
var ex80426 = (state_80415__$1[(2)]);
var statearr_80432_80457 = state_80415__$1;
(statearr_80432_80457[(5)] = ex80426);


var statearr_80433_80458 = state_80415__$1;
(statearr_80433_80458[(1)] = (4));

(statearr_80433_80458[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (14))){
var inst_80400 = (state_80415[(2)]);
var inst_80401 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_80402 = fluree.db.util.core.without_nils.call(null,inst_80401);
var inst_80403 = cljs.core.async.promise_chan.call(null);
var inst_80404 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_80405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80406 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_80402,inst_80403,null];
var inst_80407 = (new cljs.core.PersistentVector(null,4,(5),inst_80405,inst_80406,null));
var inst_80408 = cljs.core.async.put_BANG_.call(null,inst_80404,inst_80407);
var inst_80409 = (function (){var _ = inst_80400;
var data = inst_80402;
var pc = inst_80403;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_80410 = cljs.core.async.take_BANG_.call(null,inst_80403,inst_80409);
var _ = (function (){var statearr_80434 = state_80415;
(statearr_80434[(4)] = cljs.core.rest.call(null,(state_80415[(4)])));

return statearr_80434;
})();
var state_80415__$1 = (function (){var statearr_80435 = state_80415;
(statearr_80435[(8)] = inst_80408);

return statearr_80435;
})();
var statearr_80436_80459 = state_80415__$1;
(statearr_80436_80459[(2)] = inst_80410);

(statearr_80436_80459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (10))){
var inst_80385 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80386 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_80387 = cljs.core.PersistentHashMap.fromArrays(inst_80385,inst_80386);
var inst_80388 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_80387);
var inst_80389 = (function(){throw inst_80388})();
var state_80415__$1 = state_80415;
var statearr_80437_80460 = state_80415__$1;
(statearr_80437_80460[(2)] = inst_80389);

(statearr_80437_80460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80416 === (8))){
var inst_80382 = (state_80415[(2)]);
var state_80415__$1 = (function (){var statearr_80438 = state_80415;
(statearr_80438[(9)] = inst_80382);

return statearr_80438;
})();
if(cljs.core.truth_(ledger)){
var statearr_80439_80461 = state_80415__$1;
(statearr_80439_80461[(1)] = (9));

} else {
var statearr_80440_80462 = state_80415__$1;
(statearr_80440_80462[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__16221__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__16221__auto____0 = (function (){
var statearr_80441 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80441[(0)] = fluree$db$connection_js$password_generate_$_state_machine__16221__auto__);

(statearr_80441[(1)] = (1));

return statearr_80441;
});
var fluree$db$connection_js$password_generate_$_state_machine__16221__auto____1 = (function (state_80415){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80442){var ex__16224__auto__ = e80442;
var statearr_80443_80463 = state_80415;
(statearr_80443_80463[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80415[(4)]))){
var statearr_80444_80464 = state_80415;
(statearr_80444_80464[(1)] = cljs.core.first.call(null,(state_80415[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80465 = state_80415;
state_80415 = G__80465;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__16221__auto__ = function(state_80415){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__16221__auto____1.call(this,state_80415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__16221__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__16221__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80445 = f__16346__auto__.call(null);
(statearr_80445[(6)] = c__16345__auto__);

return statearr_80445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__80467 = arguments.length;
switch (G__80467) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80534){
var state_val_80535 = (state_80534[(1)]);
if((state_val_80535 === (7))){
var inst_80479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80480 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_80481 = cljs.core.PersistentHashMap.fromArrays(inst_80479,inst_80480);
var inst_80482 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_80481);
var inst_80483 = (function(){throw inst_80482})();
var state_80534__$1 = state_80534;
var statearr_80536_80575 = state_80534__$1;
(statearr_80536_80575[(2)] = inst_80483);

(statearr_80536_80575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (20))){
var inst_80517 = (state_80534[(2)]);
var inst_80518 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_80519 = [ledger,password,user,auth,expire];
var inst_80520 = cljs.core.PersistentHashMap.fromArrays(inst_80518,inst_80519);
var inst_80521 = fluree.db.util.core.without_nils.call(null,inst_80520);
var inst_80522 = cljs.core.async.promise_chan.call(null);
var inst_80523 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_80524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80525 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_80521,inst_80522,null];
var inst_80526 = (new cljs.core.PersistentVector(null,4,(5),inst_80524,inst_80525,null));
var inst_80527 = cljs.core.async.put_BANG_.call(null,inst_80523,inst_80526);
var inst_80528 = (function (){var _ = inst_80517;
var data = inst_80521;
var pc = inst_80522;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_80529 = cljs.core.async.take_BANG_.call(null,inst_80522,inst_80528);
var _ = (function (){var statearr_80537 = state_80534;
(statearr_80537[(4)] = cljs.core.rest.call(null,(state_80534[(4)])));

return statearr_80537;
})();
var state_80534__$1 = (function (){var statearr_80538 = state_80534;
(statearr_80538[(7)] = inst_80527);

return statearr_80538;
})();
var statearr_80539_80576 = state_80534__$1;
(statearr_80539_80576[(2)] = inst_80529);

(statearr_80539_80576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (1))){
var state_80534__$1 = state_80534;
var statearr_80540_80577 = state_80534__$1;
(statearr_80540_80577[(2)] = null);

(statearr_80540_80577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (4))){
var inst_80468 = (state_80534[(2)]);
var inst_80469 = cljs.core.clj__GT_js.call(null,inst_80468);
var inst_80470 = reject.call(null,inst_80469);
var state_80534__$1 = state_80534;
var statearr_80541_80578 = state_80534__$1;
(statearr_80541_80578[(2)] = inst_80470);

(statearr_80541_80578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (15))){
var inst_80504 = (state_80534[(8)]);
var state_80534__$1 = state_80534;
var statearr_80542_80579 = state_80534__$1;
(statearr_80542_80579[(2)] = inst_80504);

(statearr_80542_80579[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (13))){
var inst_80497 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80498 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_80499 = cljs.core.PersistentHashMap.fromArrays(inst_80497,inst_80498);
var inst_80500 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_80499);
var inst_80501 = (function(){throw inst_80500})();
var state_80534__$1 = state_80534;
var statearr_80543_80580 = state_80534__$1;
(statearr_80543_80580[(2)] = inst_80501);

(statearr_80543_80580[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (6))){
var state_80534__$1 = state_80534;
var statearr_80544_80581 = state_80534__$1;
(statearr_80544_80581[(2)] = null);

(statearr_80544_80581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (17))){
var inst_80508 = (state_80534[(2)]);
var state_80534__$1 = state_80534;
if(cljs.core.truth_(inst_80508)){
var statearr_80545_80582 = state_80534__$1;
(statearr_80545_80582[(1)] = (18));

} else {
var statearr_80546_80583 = state_80534__$1;
(statearr_80546_80583[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (3))){
var inst_80532 = (state_80534[(2)]);
var state_80534__$1 = state_80534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80534__$1,inst_80532);
} else {
if((state_val_80535 === (12))){
var state_80534__$1 = state_80534;
var statearr_80547_80584 = state_80534__$1;
(statearr_80547_80584[(2)] = null);

(statearr_80547_80584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (2))){
var _ = (function (){var statearr_80548 = state_80534;
(statearr_80548[(4)] = cljs.core.cons.call(null,(5),(state_80534[(4)])));

return statearr_80548;
})();
var inst_80476 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_80534__$1 = state_80534;
if(cljs.core.truth_(inst_80476)){
var statearr_80549_80585 = state_80534__$1;
(statearr_80549_80585[(1)] = (6));

} else {
var statearr_80550_80586 = state_80534__$1;
(statearr_80550_80586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (19))){
var inst_80511 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80512 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_80513 = cljs.core.PersistentHashMap.fromArrays(inst_80511,inst_80512);
var inst_80514 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_80513);
var inst_80515 = (function(){throw inst_80514})();
var state_80534__$1 = state_80534;
var statearr_80551_80587 = state_80534__$1;
(statearr_80551_80587[(2)] = inst_80515);

(statearr_80551_80587[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (11))){
var inst_80494 = (state_80534[(2)]);
var state_80534__$1 = (function (){var statearr_80553 = state_80534;
(statearr_80553[(9)] = inst_80494);

return statearr_80553;
})();
if(cljs.core.truth_(password)){
var statearr_80554_80588 = state_80534__$1;
(statearr_80554_80588[(1)] = (12));

} else {
var statearr_80555_80589 = state_80534__$1;
(statearr_80555_80589[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (9))){
var state_80534__$1 = state_80534;
var statearr_80556_80590 = state_80534__$1;
(statearr_80556_80590[(2)] = null);

(statearr_80556_80590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (5))){
var _ = (function (){var statearr_80557 = state_80534;
(statearr_80557[(4)] = cljs.core.rest.call(null,(state_80534[(4)])));

return statearr_80557;
})();
var state_80534__$1 = state_80534;
var ex80552 = (state_80534__$1[(2)]);
var statearr_80558_80591 = state_80534__$1;
(statearr_80558_80591[(5)] = ex80552);


var statearr_80559_80592 = state_80534__$1;
(statearr_80559_80592[(1)] = (4));

(statearr_80559_80592[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (14))){
var inst_80504 = (state_80534[(8)]);
var inst_80503 = (state_80534[(2)]);
var inst_80504__$1 = user;
var state_80534__$1 = (function (){var statearr_80560 = state_80534;
(statearr_80560[(8)] = inst_80504__$1);

(statearr_80560[(10)] = inst_80503);

return statearr_80560;
})();
if(cljs.core.truth_(inst_80504__$1)){
var statearr_80561_80593 = state_80534__$1;
(statearr_80561_80593[(1)] = (15));

} else {
var statearr_80562_80594 = state_80534__$1;
(statearr_80562_80594[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (16))){
var state_80534__$1 = state_80534;
var statearr_80563_80595 = state_80534__$1;
(statearr_80563_80595[(2)] = auth);

(statearr_80563_80595[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (10))){
var inst_80488 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80489 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_80490 = cljs.core.PersistentHashMap.fromArrays(inst_80488,inst_80489);
var inst_80491 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_80490);
var inst_80492 = (function(){throw inst_80491})();
var state_80534__$1 = state_80534;
var statearr_80564_80596 = state_80534__$1;
(statearr_80564_80596[(2)] = inst_80492);

(statearr_80564_80596[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (18))){
var state_80534__$1 = state_80534;
var statearr_80565_80597 = state_80534__$1;
(statearr_80565_80597[(2)] = null);

(statearr_80565_80597[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80535 === (8))){
var inst_80485 = (state_80534[(2)]);
var state_80534__$1 = (function (){var statearr_80566 = state_80534;
(statearr_80566[(11)] = inst_80485);

return statearr_80566;
})();
if(cljs.core.truth_(ledger)){
var statearr_80567_80598 = state_80534__$1;
(statearr_80567_80598[(1)] = (9));

} else {
var statearr_80568_80599 = state_80534__$1;
(statearr_80568_80599[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__16221__auto__ = null;
var fluree$db$connection_js$state_machine__16221__auto____0 = (function (){
var statearr_80569 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80569[(0)] = fluree$db$connection_js$state_machine__16221__auto__);

(statearr_80569[(1)] = (1));

return statearr_80569;
});
var fluree$db$connection_js$state_machine__16221__auto____1 = (function (state_80534){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80570){var ex__16224__auto__ = e80570;
var statearr_80571_80600 = state_80534;
(statearr_80571_80600[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80534[(4)]))){
var statearr_80572_80601 = state_80534;
(statearr_80572_80601[(1)] = cljs.core.first.call(null,(state_80534[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80602 = state_80534;
state_80534 = G__80602;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__16221__auto__ = function(state_80534){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__16221__auto____1.call(this,state_80534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__16221__auto____0;
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__16221__auto____1;
return fluree$db$connection_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80573 = f__16346__auto__.call(null);
(statearr_80573[(6)] = c__16345__auto__);

return statearr_80573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__80604 = arguments.length;
switch (G__80604) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80639){
var state_val_80640 = (state_80639[(1)]);
if((state_val_80640 === (1))){
var state_80639__$1 = state_80639;
var statearr_80641_80661 = state_80639__$1;
(statearr_80641_80661[(2)] = null);

(statearr_80641_80661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (2))){
var _ = (function (){var statearr_80642 = state_80639;
(statearr_80642[(4)] = cljs.core.cons.call(null,(5),(state_80639[(4)])));

return statearr_80642;
})();
var inst_80613 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_80639__$1 = state_80639;
if(cljs.core.truth_(inst_80613)){
var statearr_80643_80662 = state_80639__$1;
(statearr_80643_80662[(1)] = (6));

} else {
var statearr_80644_80663 = state_80639__$1;
(statearr_80644_80663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (3))){
var inst_80637 = (state_80639[(2)]);
var state_80639__$1 = state_80639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80639__$1,inst_80637);
} else {
if((state_val_80640 === (4))){
var inst_80605 = (state_80639[(2)]);
var inst_80606 = cljs.core.clj__GT_js.call(null,inst_80605);
var inst_80607 = reject.call(null,inst_80606);
var state_80639__$1 = state_80639;
var statearr_80646_80664 = state_80639__$1;
(statearr_80646_80664[(2)] = inst_80607);

(statearr_80646_80664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (5))){
var _ = (function (){var statearr_80647 = state_80639;
(statearr_80647[(4)] = cljs.core.rest.call(null,(state_80639[(4)])));

return statearr_80647;
})();
var state_80639__$1 = state_80639;
var ex80645 = (state_80639__$1[(2)]);
var statearr_80648_80665 = state_80639__$1;
(statearr_80648_80665[(5)] = ex80645);


var statearr_80649_80666 = state_80639__$1;
(statearr_80649_80666[(1)] = (4));

(statearr_80649_80666[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (6))){
var state_80639__$1 = state_80639;
var statearr_80650_80667 = state_80639__$1;
(statearr_80650_80667[(2)] = null);

(statearr_80650_80667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (7))){
var inst_80616 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80617 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_80618 = cljs.core.PersistentHashMap.fromArrays(inst_80616,inst_80617);
var inst_80619 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_80618);
var inst_80620 = (function(){throw inst_80619})();
var state_80639__$1 = state_80639;
var statearr_80651_80668 = state_80639__$1;
(statearr_80651_80668[(2)] = inst_80620);

(statearr_80651_80668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80640 === (8))){
var inst_80622 = (state_80639[(2)]);
var inst_80623 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_80624 = [jwt,expire];
var inst_80625 = cljs.core.PersistentHashMap.fromArrays(inst_80623,inst_80624);
var inst_80626 = fluree.db.util.core.without_nils.call(null,inst_80625);
var inst_80627 = cljs.core.async.promise_chan.call(null);
var inst_80628 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_80629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80630 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_80626,inst_80627,null];
var inst_80631 = (new cljs.core.PersistentVector(null,4,(5),inst_80629,inst_80630,null));
var inst_80632 = cljs.core.async.put_BANG_.call(null,inst_80628,inst_80631);
var inst_80633 = (function (){var _ = inst_80622;
var data = inst_80626;
var pc = inst_80627;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_80634 = cljs.core.async.take_BANG_.call(null,inst_80627,inst_80633);
var _ = (function (){var statearr_80652 = state_80639;
(statearr_80652[(4)] = cljs.core.rest.call(null,(state_80639[(4)])));

return statearr_80652;
})();
var state_80639__$1 = (function (){var statearr_80653 = state_80639;
(statearr_80653[(7)] = inst_80632);

return statearr_80653;
})();
var statearr_80654_80669 = state_80639__$1;
(statearr_80654_80669[(2)] = inst_80634);

(statearr_80654_80669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__16221__auto__ = null;
var fluree$db$connection_js$state_machine__16221__auto____0 = (function (){
var statearr_80655 = [null,null,null,null,null,null,null,null];
(statearr_80655[(0)] = fluree$db$connection_js$state_machine__16221__auto__);

(statearr_80655[(1)] = (1));

return statearr_80655;
});
var fluree$db$connection_js$state_machine__16221__auto____1 = (function (state_80639){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80656){var ex__16224__auto__ = e80656;
var statearr_80657_80670 = state_80639;
(statearr_80657_80670[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80639[(4)]))){
var statearr_80658_80671 = state_80639;
(statearr_80658_80671[(1)] = cljs.core.first.call(null,(state_80639[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80672 = state_80639;
state_80639 = G__80672;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__16221__auto__ = function(state_80639){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__16221__auto____1.call(this,state_80639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__16221__auto____0;
fluree$db$connection_js$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__16221__auto____1;
return fluree$db$connection_js$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80659 = f__16346__auto__.call(null);
(statearr_80659[(6)] = c__16345__auto__);

return statearr_80659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

