// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46255 = arguments.length;
var i__4819__auto___46256 = (0);
while(true){
if((i__4819__auto___46256 < len__4818__auto___46255)){
args__4824__auto__.push((arguments[i__4819__auto___46256]));

var G__46257 = (i__4819__auto___46256 + (1));
i__4819__auto___46256 = G__46257;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq46252){
var G__46253 = cljs.core.first.call(null,seq46252);
var seq46252__$1 = cljs.core.next.call(null,seq46252);
var G__46254 = cljs.core.first.call(null,seq46252__$1);
var seq46252__$2 = cljs.core.next.call(null,seq46252__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46253,G__46254,seq46252__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e46258){var e = e46258;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e46259){var e = e46259;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e46260){var e = e46260;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e46261){var e = e46261;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e46262){var e = e46262;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46265 = arguments.length;
var i__4819__auto___46266 = (0);
while(true){
if((i__4819__auto___46266 < len__4818__auto___46265)){
args__4824__auto__.push((arguments[i__4819__auto___46266]));

var G__46267 = (i__4819__auto___46266 + (1));
i__4819__auto___46266 = G__46267;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46264){var e = e46264;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq46263){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46263));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46270 = arguments.length;
var i__4819__auto___46271 = (0);
while(true){
if((i__4819__auto___46271 < len__4818__auto___46270)){
args__4824__auto__.push((arguments[i__4819__auto___46271]));

var G__46272 = (i__4819__auto___46271 + (1));
i__4819__auto___46271 = G__46272;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46269){var e = e46269;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq46268){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46268));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e46273){var e = e46273;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46276 = arguments.length;
var i__4819__auto___46277 = (0);
while(true){
if((i__4819__auto___46277 < len__4818__auto___46276)){
args__4824__auto__.push((arguments[i__4819__auto___46277]));

var G__46278 = (i__4819__auto___46277 + (1));
i__4819__auto___46277 = G__46278;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e46275){var e = e46275;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq46274){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46274));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46281 = arguments.length;
var i__4819__auto___46282 = (0);
while(true){
if((i__4819__auto___46282 < len__4818__auto___46281)){
args__4824__auto__.push((arguments[i__4819__auto___46282]));

var G__46283 = (i__4819__auto___46282 + (1));
i__4819__auto___46282 = G__46283;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e46280){var e = e46280;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq46279){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46279));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e46284){var e = e46284;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e46285){var e = e46285;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46288 = arguments.length;
var i__4819__auto___46289 = (0);
while(true){
if((i__4819__auto___46289 < len__4818__auto___46288)){
args__4824__auto__.push((arguments[i__4819__auto___46289]));

var G__46290 = (i__4819__auto___46289 + (1));
i__4819__auto___46289 = G__46290;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46287){var e = e46287;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq46286){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46286));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46293 = arguments.length;
var i__4819__auto___46294 = (0);
while(true){
if((i__4819__auto___46294 < len__4818__auto___46293)){
args__4824__auto__.push((arguments[i__4819__auto___46294]));

var G__46295 = (i__4819__auto___46294 + (1));
i__4819__auto___46294 = G__46295;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46292){var e = e46292;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq46291){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46291));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46298 = arguments.length;
var i__4819__auto___46299 = (0);
while(true){
if((i__4819__auto___46299 < len__4818__auto___46298)){
args__4824__auto__.push((arguments[i__4819__auto___46299]));

var G__46300 = (i__4819__auto___46299 + (1));
i__4819__auto___46299 = G__46300;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e46297){var e = e46297;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq46296){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46296));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46303 = arguments.length;
var i__4819__auto___46304 = (0);
while(true){
if((i__4819__auto___46304 < len__4818__auto___46303)){
args__4824__auto__.push((arguments[i__4819__auto___46304]));

var G__46305 = (i__4819__auto___46304 + (1));
i__4819__auto___46304 = G__46305;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e46302){var e = e46302;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq46301){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46301));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46308 = arguments.length;
var i__4819__auto___46309 = (0);
while(true){
if((i__4819__auto___46309 < len__4818__auto___46308)){
args__4824__auto__.push((arguments[i__4819__auto___46309]));

var G__46310 = (i__4819__auto___46309 + (1));
i__4819__auto___46309 = G__46310;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e46307){var e = e46307;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq46306){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46306));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46313 = arguments.length;
var i__4819__auto___46314 = (0);
while(true){
if((i__4819__auto___46314 < len__4818__auto___46313)){
args__4824__auto__.push((arguments[i__4819__auto___46314]));

var G__46315 = (i__4819__auto___46314 + (1));
i__4819__auto___46314 = G__46315;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e46312){var e = e46312;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq46311){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46311));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46318 = arguments.length;
var i__4819__auto___46319 = (0);
while(true){
if((i__4819__auto___46319 < len__4818__auto___46318)){
args__4824__auto__.push((arguments[i__4819__auto___46319]));

var G__46320 = (i__4819__auto___46319 + (1));
i__4819__auto___46319 = G__46320;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e46317){var e = e46317;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq46316){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46316));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__46322 = arguments.length;
switch (G__46322) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46350){
var state_val_46351 = (state_46350[(1)]);
if((state_val_46351 === (7))){
var inst_46335 = (state_46350[(7)]);
var inst_46338 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46335,"query",query_map);
var state_46350__$1 = state_46350;
var statearr_46352_46438 = state_46350__$1;
(statearr_46352_46438[(2)] = inst_46338);

(statearr_46352_46438[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (1))){
var state_46350__$1 = state_46350;
var statearr_46353_46439 = state_46350__$1;
(statearr_46353_46439[(2)] = null);

(statearr_46353_46439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (4))){
var inst_46323 = (state_46350[(2)]);
var state_46350__$1 = state_46350;
var statearr_46354_46440 = state_46350__$1;
(statearr_46354_46440[(2)] = inst_46323);

(statearr_46354_46440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (6))){
var inst_46335 = (state_46350[(7)]);
var inst_46335__$1 = (state_46350[(2)]);
var inst_46336 = fluree.db.util.core.exception_QMARK_.call(null,inst_46335__$1);
var state_46350__$1 = (function (){var statearr_46355 = state_46350;
(statearr_46355[(7)] = inst_46335__$1);

return statearr_46355;
})();
if(inst_46336){
var statearr_46356_46441 = state_46350__$1;
(statearr_46356_46441[(1)] = (7));

} else {
var statearr_46357_46442 = state_46350__$1;
(statearr_46357_46442[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (3))){
var inst_46348 = (state_46350[(2)]);
var state_46350__$1 = state_46350;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46350__$1,inst_46348);
} else {
if((state_val_46351 === (2))){
var inst_46329 = (state_46350[(8)]);
var _ = (function (){var statearr_46359 = state_46350;
(statearr_46359[(4)] = cljs.core.cons.call(null,(5),(state_46350[(4)])));

return statearr_46359;
})();
var inst_46329__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_46330 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_46331 = cljs.core.assoc.call(null,inst_46330,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_46329__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_46332 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_46331);
var inst_46333 = fluree.db.query.fql.query.call(null,db,inst_46332);
var state_46350__$1 = (function (){var statearr_46360 = state_46350;
(statearr_46360[(8)] = inst_46329__$1);

return statearr_46360;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46350__$1,(6),inst_46333);
} else {
if((state_val_46351 === (9))){
var inst_46345 = (state_46350[(2)]);
var _ = (function (){var statearr_46361 = state_46350;
(statearr_46361[(4)] = cljs.core.rest.call(null,(state_46350[(4)])));

return statearr_46361;
})();
var state_46350__$1 = state_46350;
var statearr_46362_46443 = state_46350__$1;
(statearr_46362_46443[(2)] = inst_46345);

(statearr_46362_46443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (5))){
var _ = (function (){var statearr_46363 = state_46350;
(statearr_46363[(4)] = cljs.core.rest.call(null,(state_46350[(4)])));

return statearr_46363;
})();
var state_46350__$1 = state_46350;
var ex46358 = (state_46350__$1[(2)]);
var statearr_46364_46444 = state_46350__$1;
(statearr_46364_46444[(5)] = ex46358);


if((ex46358 instanceof Error)){
var statearr_46365_46445 = state_46350__$1;
(statearr_46365_46445[(1)] = (4));

(statearr_46365_46445[(5)] = null);

} else {
throw ex46358;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46351 === (8))){
var inst_46335 = (state_46350[(7)]);
var inst_46329 = (state_46350[(8)]);
var inst_46340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46341 = cljs.core.deref.call(null,inst_46329);
var inst_46342 = [inst_46335,inst_46341];
var inst_46343 = (new cljs.core.PersistentVector(null,2,(5),inst_46340,inst_46342,null));
var state_46350__$1 = state_46350;
var statearr_46366_46446 = state_46350__$1;
(statearr_46366_46446[(2)] = inst_46343);

(statearr_46366_46446[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16221__auto____0 = (function (){
var statearr_46367 = [null,null,null,null,null,null,null,null,null];
(statearr_46367[(0)] = fluree$db$dbfunctions$internal$state_machine__16221__auto__);

(statearr_46367[(1)] = (1));

return statearr_46367;
});
var fluree$db$dbfunctions$internal$state_machine__16221__auto____1 = (function (state_46350){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46350);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46368){var ex__16224__auto__ = e46368;
var statearr_46369_46447 = state_46350;
(statearr_46369_46447[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46350[(4)]))){
var statearr_46370_46448 = state_46350;
(statearr_46370_46448[(1)] = cljs.core.first.call(null,(state_46350[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46449 = state_46350;
state_46350 = G__46449;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16221__auto__ = function(state_46350){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____1.call(this,state_46350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46371 = f__16346__auto__.call(null);
(statearr_46371[(6)] = c__16345__auto__);

return statearr_46371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46416){
var state_val_46417 = (state_46416[(1)]);
if((state_val_46417 === (7))){
var inst_46402 = (state_46416[(2)]);
var inst_46403 = fluree.db.query.fql.query.call(null,db,inst_46402);
var state_46416__$1 = state_46416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46416__$1,(8),inst_46403);
} else {
if((state_val_46417 === (1))){
var inst_46372 = typeof select === 'string';
var state_46416__$1 = state_46416;
if(cljs.core.truth_(inst_46372)){
var statearr_46418_46450 = state_46416__$1;
(statearr_46418_46450[(1)] = (2));

} else {
var statearr_46419_46451 = state_46416__$1;
(statearr_46419_46451[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (4))){
var inst_46378 = (state_46416[(7)]);
var inst_46385 = (state_46416[(8)]);
var inst_46377 = (state_46416[(2)]);
var inst_46378__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_46379 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_46380 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_46381 = [inst_46378__$1,(100000)];
var inst_46382 = cljs.core.PersistentHashMap.fromArrays(inst_46380,inst_46381);
var inst_46383 = [inst_46377,from,where,block,limit,inst_46382];
var inst_46384 = cljs.core.PersistentHashMap.fromArrays(inst_46379,inst_46383);
var inst_46385__$1 = fluree.db.util.core.without_nils.call(null,inst_46384);
var inst_46386 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_46385__$1);
var inst_46387 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_46385__$1);
var inst_46388 = cljs.core.first.call(null,inst_46387);
var inst_46389 = fluree.db.dbfunctions.internal.str.call(null,inst_46388);
var inst_46390 = cljs.core._EQ_.call(null,"[",inst_46389);
var inst_46391 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_46385__$1);
var inst_46392 = cljs.core.last.call(null,inst_46391);
var inst_46393 = fluree.db.dbfunctions.internal.str.call(null,inst_46392);
var inst_46394 = cljs.core._EQ_.call(null,"]",inst_46393);
var inst_46395 = fluree.db.dbfunctions.internal.and.call(null,inst_46386,inst_46390,inst_46394);
var state_46416__$1 = (function (){var statearr_46420 = state_46416;
(statearr_46420[(7)] = inst_46378__$1);

(statearr_46420[(8)] = inst_46385__$1);

return statearr_46420;
})();
if(cljs.core.truth_(inst_46395)){
var statearr_46421_46452 = state_46416__$1;
(statearr_46421_46452[(1)] = (5));

} else {
var statearr_46422_46453 = state_46416__$1;
(statearr_46422_46453[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (6))){
var inst_46385 = (state_46416[(8)]);
var state_46416__$1 = state_46416;
var statearr_46423_46454 = state_46416__$1;
(statearr_46423_46454[(2)] = inst_46385);

(statearr_46423_46454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (3))){
var state_46416__$1 = state_46416;
var statearr_46424_46455 = state_46416__$1;
(statearr_46424_46455[(2)] = select);

(statearr_46424_46455[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (2))){
var inst_46374 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_46416__$1 = state_46416;
var statearr_46425_46456 = state_46416__$1;
(statearr_46425_46456[(2)] = inst_46374);

(statearr_46425_46456[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (11))){
var inst_46414 = (state_46416[(2)]);
var state_46416__$1 = state_46416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46416__$1,inst_46414);
} else {
if((state_val_46417 === (9))){
var inst_46405 = (state_46416[(9)]);
var state_46416__$1 = state_46416;
var statearr_46426_46457 = state_46416__$1;
(statearr_46426_46457[(2)] = inst_46405);

(statearr_46426_46457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (5))){
var inst_46385 = (state_46416[(8)]);
var inst_46397 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_46385);
var inst_46398 = cljs.reader.read_string.call(null,inst_46397);
var inst_46399 = cljs.core.assoc.call(null,inst_46385,new cljs.core.Keyword(null,"where","where",-2044795965),inst_46398);
var state_46416__$1 = state_46416;
var statearr_46427_46458 = state_46416__$1;
(statearr_46427_46458[(2)] = inst_46399);

(statearr_46427_46458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (10))){
var inst_46378 = (state_46416[(7)]);
var inst_46405 = (state_46416[(9)]);
var inst_46409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46410 = cljs.core.deref.call(null,inst_46378);
var inst_46411 = [inst_46405,inst_46410];
var inst_46412 = (new cljs.core.PersistentVector(null,2,(5),inst_46409,inst_46411,null));
var state_46416__$1 = state_46416;
var statearr_46428_46459 = state_46416__$1;
(statearr_46428_46459[(2)] = inst_46412);

(statearr_46428_46459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46417 === (8))){
var inst_46405 = (state_46416[(9)]);
var inst_46405__$1 = (state_46416[(2)]);
var inst_46406 = fluree.db.util.core.exception_QMARK_.call(null,inst_46405__$1);
var state_46416__$1 = (function (){var statearr_46429 = state_46416;
(statearr_46429[(9)] = inst_46405__$1);

return statearr_46429;
})();
if(inst_46406){
var statearr_46430_46460 = state_46416__$1;
(statearr_46430_46460[(1)] = (9));

} else {
var statearr_46431_46461 = state_46416__$1;
(statearr_46431_46461[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16221__auto____0 = (function (){
var statearr_46432 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46432[(0)] = fluree$db$dbfunctions$internal$state_machine__16221__auto__);

(statearr_46432[(1)] = (1));

return statearr_46432;
});
var fluree$db$dbfunctions$internal$state_machine__16221__auto____1 = (function (state_46416){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46433){var ex__16224__auto__ = e46433;
var statearr_46434_46462 = state_46416;
(statearr_46434_46462[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46416[(4)]))){
var statearr_46435_46463 = state_46416;
(statearr_46435_46463[(1)] = cljs.core.first.call(null,(state_46416[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46464 = state_46416;
state_46416 = G__46464;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16221__auto__ = function(state_46416){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____1.call(this,state_46416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46436 = f__16346__auto__.call(null);
(statearr_46436[(6)] = c__16345__auto__);

return statearr_46436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__46468 = path;
var vec__46469 = G__46468;
var seq__46470 = cljs.core.seq.call(null,vec__46469);
var first__46471 = cljs.core.first.call(null,seq__46470);
var seq__46470__$1 = cljs.core.next.call(null,seq__46470);
var var$ = first__46471;
var r = seq__46470__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__46468__$1 = G__46468;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__46475 = G__46468__$1;
var seq__46476 = cljs.core.seq.call(null,vec__46475);
var first__46477 = cljs.core.first.call(null,seq__46476);
var seq__46476__$1 = cljs.core.next.call(null,seq__46476);
var var$__$1 = first__46477;
var r__$1 = seq__46476__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__46478 = r__$1;
var G__46479 = n__$2;
var G__46480 = next_clauses;
G__46468__$1 = G__46478;
n__$1 = G__46479;
where_clauses__$1 = G__46480;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__46481 = r__$1;
var G__46482 = next_n;
var G__46483 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__46468__$1 = G__46481;
n__$1 = G__46482;
where_clauses__$1 = G__46483;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46520){
var state_val_46521 = (state_46520[(1)]);
if((state_val_46521 === (7))){
var inst_46493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46494 = [path];
var inst_46495 = (new cljs.core.PersistentVector(null,1,(5),inst_46493,inst_46494,null));
var state_46520__$1 = state_46520;
var statearr_46522_46550 = state_46520__$1;
(statearr_46522_46550[(2)] = inst_46495);

(statearr_46522_46550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (1))){
var state_46520__$1 = state_46520;
var statearr_46523_46551 = state_46520__$1;
(statearr_46523_46551[(2)] = null);

(statearr_46523_46551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (4))){
var inst_46484 = (state_46520[(2)]);
var state_46520__$1 = state_46520;
var statearr_46524_46552 = state_46520__$1;
(statearr_46524_46552[(2)] = inst_46484);

(statearr_46524_46552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (13))){
var inst_46511 = (state_46520[(2)]);
var inst_46512 = fluree.db.util.async.throw_err.call(null,inst_46511);
var _ = (function (){var statearr_46525 = state_46520;
(statearr_46525[(4)] = cljs.core.rest.call(null,(state_46520[(4)])));

return statearr_46525;
})();
var state_46520__$1 = state_46520;
var statearr_46526_46553 = state_46520__$1;
(statearr_46526_46553[(2)] = inst_46512);

(statearr_46526_46553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (6))){
var state_46520__$1 = state_46520;
var statearr_46528_46554 = state_46520__$1;
(statearr_46528_46554[(2)] = path);

(statearr_46528_46554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (3))){
var inst_46518 = (state_46520[(2)]);
var state_46520__$1 = state_46520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46520__$1,inst_46518);
} else {
if((state_val_46521 === (12))){
var _ = (function (){var statearr_46529 = state_46520;
(statearr_46529[(4)] = cljs.core.rest.call(null,(state_46520[(4)])));

return statearr_46529;
})();
var state_46520__$1 = state_46520;
var ex46527 = (state_46520__$1[(2)]);
var statearr_46530_46555 = state_46520__$1;
(statearr_46530_46555[(5)] = ex46527);


var statearr_46531_46556 = state_46520__$1;
(statearr_46531_46556[(1)] = (11));

(statearr_46531_46556[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (2))){
var _ = (function (){var statearr_46532 = state_46520;
(statearr_46532[(4)] = cljs.core.cons.call(null,(5),(state_46520[(4)])));

return statearr_46532;
})();
var inst_46490 = cljs.core.vector_QMARK_.call(null,path);
var state_46520__$1 = state_46520;
if(inst_46490){
var statearr_46533_46557 = state_46520__$1;
(statearr_46533_46557[(1)] = (6));

} else {
var statearr_46534_46558 = state_46520__$1;
(statearr_46534_46558[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (11))){
var inst_46497 = (state_46520[(7)]);
var inst_46502 = (state_46520[(2)]);
var inst_46503 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46502,"relationship?",startSubject,inst_46497,endSubject);
var state_46520__$1 = state_46520;
var statearr_46536_46559 = state_46520__$1;
(statearr_46536_46559[(2)] = inst_46503);

(statearr_46536_46559[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (9))){
var inst_46501 = (state_46520[(8)]);
var _ = (function (){var statearr_46537 = state_46520;
(statearr_46537[(4)] = cljs.core.cons.call(null,(12),(state_46520[(4)])));

return statearr_46537;
})();
var inst_46509 = fluree.db.dbfunctions.internal.query.call(null,db,inst_46501);
var state_46520__$1 = state_46520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46520__$1,(13),inst_46509);
} else {
if((state_val_46521 === (5))){
var _ = (function (){var statearr_46538 = state_46520;
(statearr_46538[(4)] = cljs.core.rest.call(null,(state_46520[(4)])));

return statearr_46538;
})();
var state_46520__$1 = state_46520;
var ex46535 = (state_46520__$1[(2)]);
var statearr_46539_46560 = state_46520__$1;
(statearr_46539_46560[(5)] = ex46535);


if((ex46535 instanceof Error)){
var statearr_46540_46561 = state_46520__$1;
(statearr_46540_46561[(1)] = (4));

(statearr_46540_46561[(5)] = null);

} else {
throw ex46535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (10))){
var inst_46515 = (state_46520[(2)]);
var _ = (function (){var statearr_46541 = state_46520;
(statearr_46541[(4)] = cljs.core.rest.call(null,(state_46520[(4)])));

return statearr_46541;
})();
var state_46520__$1 = state_46520;
var statearr_46542_46562 = state_46520__$1;
(statearr_46542_46562[(2)] = inst_46515);

(statearr_46542_46562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46521 === (8))){
var inst_46497 = (state_46520[(7)]);
var inst_46497__$1 = (state_46520[(2)]);
var inst_46498 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_46497__$1,endSubject);
var inst_46499 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_46500 = ["?var1",inst_46498];
var inst_46501 = cljs.core.PersistentHashMap.fromArrays(inst_46499,inst_46500);
var state_46520__$1 = (function (){var statearr_46543 = state_46520;
(statearr_46543[(8)] = inst_46501);

(statearr_46543[(7)] = inst_46497__$1);

return statearr_46543;
})();
var statearr_46544_46563 = state_46520__$1;
(statearr_46544_46563[(2)] = null);

(statearr_46544_46563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_46545 = [null,null,null,null,null,null,null,null,null];
(statearr_46545[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__);

(statearr_46545[(1)] = (1));

return statearr_46545;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____1 = (function (state_46520){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46546){var ex__16224__auto__ = e46546;
var statearr_46547_46564 = state_46520;
(statearr_46547_46564[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46520[(4)]))){
var statearr_46548_46565 = state_46520;
(statearr_46548_46565[(1)] = cljs.core.first.call(null,(state_46520[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46566 = state_46520;
state_46520 = G__46566;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__ = function(state_46520){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____1.call(this,state_46520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46549 = f__16346__auto__.call(null);
(statearr_46549[(6)] = c__16345__auto__);

return statearr_46549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e46567){var e = e46567;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e46568){var e = e46568;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e46569){var e = e46569;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e46570){var e = e46570;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46573 = arguments.length;
var i__4819__auto___46574 = (0);
while(true){
if((i__4819__auto___46574 < len__4818__auto___46573)){
args__4824__auto__.push((arguments[i__4819__auto___46574]));

var G__46575 = (i__4819__auto___46574 + (1));
i__4819__auto___46574 = G__46575;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e46572){var e = e46572;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq46571){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46571));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46578 = arguments.length;
var i__4819__auto___46579 = (0);
while(true){
if((i__4819__auto___46579 < len__4818__auto___46578)){
args__4824__auto__.push((arguments[i__4819__auto___46579]));

var G__46580 = (i__4819__auto___46579 + (1));
i__4819__auto___46579 = G__46580;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e46577){var e = e46577;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq46576){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46576));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46583 = arguments.length;
var i__4819__auto___46584 = (0);
while(true){
if((i__4819__auto___46584 < len__4818__auto___46583)){
args__4824__auto__.push((arguments[i__4819__auto___46584]));

var G__46585 = (i__4819__auto___46584 + (1));
i__4819__auto___46584 = G__46585;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e46582){var e = e46582;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq46581){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46581));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46588 = arguments.length;
var i__4819__auto___46589 = (0);
while(true){
if((i__4819__auto___46589 < len__4818__auto___46588)){
args__4824__auto__.push((arguments[i__4819__auto___46589]));

var G__46590 = (i__4819__auto___46589 + (1));
i__4819__auto___46589 = G__46590;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e46587){var e = e46587;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq46586){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46586));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e46591){var e = e46591;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e46592){var e = e46592;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e46593){var e = e46593;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e46594){var e = e46594;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e46595){var e = e46595;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__46601 = path;
var vec__46602 = G__46601;
var seq__46603 = cljs.core.seq.call(null,vec__46602);
var first__46604 = cljs.core.first.call(null,seq__46603);
var seq__46603__$1 = cljs.core.next.call(null,seq__46603);
var pred = first__46604;
var r = seq__46603__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__46601__$1 = G__46601;
var subjects__$1 = subjects;
while(true){
var vec__46608 = G__46601__$1;
var seq__46609 = cljs.core.seq.call(null,vec__46608);
var first__46610 = cljs.core.first.call(null,seq__46609);
var seq__46609__$1 = cljs.core.next.call(null,seq__46609);
var pred__$1 = first__46610;
var r__$1 = seq__46609__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__46601__$1,subjects__$1,vec__46608,seq__46609,first__46610,seq__46609__$1,pred__$1,r__$1,subjects__$2,G__46601,vec__46602,seq__46603,first__46604,seq__46603__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__46601__$1,subjects__$1,vec__46608,seq__46609,first__46610,seq__46609__$1,pred__$1,r__$1,subjects__$2,G__46601,vec__46602,seq__46603,first__46604,seq__46603__$1,pred,r,subjects){
return (function (p1__46596_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__46596_SHARP_,pred__$1);
});})(G__46601__$1,subjects__$1,vec__46608,seq__46609,first__46610,seq__46609__$1,pred__$1,r__$1,subjects__$2,G__46601,vec__46602,seq__46603,first__46604,seq__46603__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__46601__$1,subjects__$1,vec__46608,seq__46609,first__46610,seq__46609__$1,pred__$1,r__$1,subjects__$2,G__46601,vec__46602,seq__46603,first__46604,seq__46603__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__46611 = r__$1;
var G__46612 = next_subjects;
G__46601__$1 = G__46611;
subjects__$1 = G__46612;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e46597){var e = e46597;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e46613){var e = e46613;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e46614){var e = e46614;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46617 = arguments.length;
var i__4819__auto___46618 = (0);
while(true){
if((i__4819__auto___46618 < len__4818__auto___46617)){
args__4824__auto__.push((arguments[i__4819__auto___46618]));

var G__46619 = (i__4819__auto___46618 + (1));
i__4819__auto___46618 = G__46619;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e46616){var e = e46616;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq46615){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46615));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e46620){var e = e46620;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46623 = arguments.length;
var i__4819__auto___46624 = (0);
while(true){
if((i__4819__auto___46624 < len__4818__auto___46623)){
args__4824__auto__.push((arguments[i__4819__auto___46624]));

var G__46625 = (i__4819__auto___46624 + (1));
i__4819__auto___46624 = G__46625;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e46622){var e = e46622;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq46621){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq46621));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e46626){var e = e46626;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46683){
var state_val_46684 = (state_46683[(1)]);
if((state_val_46684 === (7))){
var inst_46629 = (state_46683[(2)]);
var state_46683__$1 = state_46683;
var statearr_46685_46719 = state_46683__$1;
(statearr_46685_46719[(2)] = inst_46629);

(statearr_46685_46719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (1))){
var state_46683__$1 = state_46683;
var statearr_46686_46720 = state_46683__$1;
(statearr_46686_46720[(2)] = null);

(statearr_46686_46720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (4))){
var inst_46628 = (state_46683[(2)]);
var state_46683__$1 = (function (){var statearr_46687 = state_46683;
(statearr_46687[(7)] = inst_46628);

return statearr_46687;
})();
var statearr_46688_46721 = state_46683__$1;
(statearr_46688_46721[(2)] = null);

(statearr_46688_46721[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (15))){
var inst_46654 = (state_46683[(8)]);
var inst_46651 = (state_46683[(9)]);
var inst_46653 = (state_46683[(10)]);
var inst_46663 = (state_46683[(11)]);
var inst_46666 = (state_46683[(12)]);
var inst_46664 = (state_46683[(13)]);
var inst_46670 = (function (){var db = inst_46651;
var prevT = inst_46653;
var db_SINGLEQUOTE_ = inst_46654;
var prev_vals = inst_46663;
var fuel = inst_46664;
var G__46665 = inst_46666;
return (function (p1__46627_SHARP_){
var f = p1__46627_SHARP_;
return f.o;
});
})();
var inst_46671 = inst_46670.call(null,inst_46666);
var state_46683__$1 = state_46683;
var statearr_46689_46722 = state_46683__$1;
(statearr_46689_46722[(2)] = inst_46671);

(statearr_46689_46722[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (13))){
var inst_46663 = (state_46683[(11)]);
var inst_46666 = (state_46683[(12)]);
var inst_46662 = (state_46683[(2)]);
var inst_46663__$1 = fluree.db.util.async.throw_err.call(null,inst_46662);
var inst_46664 = fluree.db.dbfunctions.internal.count.call(null,inst_46663__$1);
var inst_46666__$1 = cljs.core.first.call(null,inst_46663__$1);
var inst_46667 = (inst_46666__$1 == null);
var state_46683__$1 = (function (){var statearr_46690 = state_46683;
(statearr_46690[(11)] = inst_46663__$1);

(statearr_46690[(12)] = inst_46666__$1);

(statearr_46690[(13)] = inst_46664);

return statearr_46690;
})();
if(cljs.core.truth_(inst_46667)){
var statearr_46691_46723 = state_46683__$1;
(statearr_46691_46723[(1)] = (14));

} else {
var statearr_46692_46724 = state_46683__$1;
(statearr_46692_46724[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (6))){
var inst_46638 = (state_46683[(2)]);
var state_46683__$1 = state_46683;
var statearr_46693_46725 = state_46683__$1;
(statearr_46693_46725[(2)] = inst_46638);

(statearr_46693_46725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (3))){
var inst_46681 = (state_46683[(2)]);
var state_46683__$1 = state_46683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46683__$1,inst_46681);
} else {
if((state_val_46684 === (12))){
var inst_46678 = (state_46683[(2)]);
var _ = (function (){var statearr_46694 = state_46683;
(statearr_46694[(4)] = cljs.core.rest.call(null,(state_46683[(4)])));

return statearr_46694;
})();
var state_46683__$1 = state_46683;
var statearr_46695_46726 = state_46683__$1;
(statearr_46695_46726[(2)] = inst_46678);

(statearr_46695_46726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (2))){
var _ = (function (){var statearr_46697 = state_46683;
(statearr_46697[(4)] = cljs.core.cons.call(null,(9),(state_46683[(4)])));

return statearr_46697;
})();
var inst_46644 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46645 = typeof inst_46644 === 'string';
var state_46683__$1 = state_46683;
if(cljs.core.truth_(inst_46645)){
var statearr_46698_46727 = state_46683__$1;
(statearr_46698_46727[(1)] = (10));

} else {
var statearr_46699_46728 = state_46683__$1;
(statearr_46699_46728[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (11))){
var inst_46654 = (state_46683[(8)]);
var inst_46651 = (state_46683[(9)]);
var inst_46653 = (state_46683[(10)]);
var inst_46651__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46652 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_46651__$1);
var inst_46653__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_46652);
var inst_46654__$1 = cljs.core.assoc.call(null,inst_46651__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_46653__$1);
var inst_46655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46656 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46657 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46658 = [inst_46656,inst_46657];
var inst_46659 = (new cljs.core.PersistentVector(null,2,(5),inst_46655,inst_46658,null));
var inst_46660 = fluree.db.dbproto._search.call(null,inst_46654__$1,inst_46659);
var state_46683__$1 = (function (){var statearr_46700 = state_46683;
(statearr_46700[(8)] = inst_46654__$1);

(statearr_46700[(9)] = inst_46651__$1);

(statearr_46700[(10)] = inst_46653__$1);

return statearr_46700;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46683__$1,(13),inst_46660);
} else {
if((state_val_46684 === (9))){
var _ = (function (){var statearr_46701 = state_46683;
(statearr_46701[(4)] = cljs.core.rest.call(null,(state_46683[(4)])));

return statearr_46701;
})();
var state_46683__$1 = state_46683;
var ex46696 = (state_46683__$1[(2)]);
var statearr_46702_46729 = state_46683__$1;
(statearr_46702_46729[(5)] = ex46696);


var statearr_46703_46730 = state_46683__$1;
(statearr_46703_46730[(1)] = (4));

(statearr_46703_46730[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (5))){
var inst_46628 = (state_46683[(7)]);
var _ = (function (){var statearr_46704 = state_46683;
(statearr_46704[(4)] = cljs.core.cons.call(null,(8),(state_46683[(4)])));

return statearr_46704;
})();
var inst_46635 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46628,"?pO","Context Object");
var ___$1 = (function (){var statearr_46705 = state_46683;
(statearr_46705[(4)] = cljs.core.rest.call(null,(state_46683[(4)])));

return statearr_46705;
})();
var state_46683__$1 = state_46683;
var statearr_46706_46731 = state_46683__$1;
(statearr_46706_46731[(2)] = inst_46635);

(statearr_46706_46731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (14))){
var state_46683__$1 = state_46683;
var statearr_46707_46732 = state_46683__$1;
(statearr_46707_46732[(2)] = null);

(statearr_46707_46732[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (16))){
var inst_46664 = (state_46683[(13)]);
var inst_46673 = (state_46683[(2)]);
var inst_46674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46675 = [inst_46673,inst_46664];
var inst_46676 = (new cljs.core.PersistentVector(null,2,(5),inst_46674,inst_46675,null));
var state_46683__$1 = state_46683;
var statearr_46709_46733 = state_46683__$1;
(statearr_46709_46733[(2)] = inst_46676);

(statearr_46709_46733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (10))){
var inst_46647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46648 = [null,(0)];
var inst_46649 = (new cljs.core.PersistentVector(null,2,(5),inst_46647,inst_46648,null));
var state_46683__$1 = state_46683;
var statearr_46710_46734 = state_46683__$1;
(statearr_46710_46734[(2)] = inst_46649);

(statearr_46710_46734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46684 === (8))){
var _ = (function (){var statearr_46711 = state_46683;
(statearr_46711[(4)] = cljs.core.rest.call(null,(state_46683[(4)])));

return statearr_46711;
})();
var state_46683__$1 = state_46683;
var ex46708 = (state_46683__$1[(2)]);
var statearr_46712_46735 = state_46683__$1;
(statearr_46712_46735[(5)] = ex46708);


var statearr_46713_46736 = state_46683__$1;
(statearr_46713_46736[(1)] = (7));

(statearr_46713_46736[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____0 = (function (){
var statearr_46714 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46714[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__);

(statearr_46714[(1)] = (1));

return statearr_46714;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____1 = (function (state_46683){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46715){var ex__16224__auto__ = e46715;
var statearr_46716_46737 = state_46683;
(statearr_46716_46737[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46683[(4)]))){
var statearr_46717_46738 = state_46683;
(statearr_46717_46738[(1)] = cljs.core.first.call(null,(state_46683[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46739 = state_46683;
state_46683 = G__46739;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__ = function(state_46683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____1.call(this,state_46683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46718 = f__16346__auto__.call(null);
(statearr_46718[(6)] = c__16345__auto__);

return statearr_46718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46791){
var state_val_46792 = (state_46791[(1)]);
if((state_val_46792 === (7))){
var inst_46741 = (state_46791[(2)]);
var state_46791__$1 = state_46791;
var statearr_46793_46822 = state_46791__$1;
(statearr_46793_46822[(2)] = inst_46741);

(statearr_46793_46822[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (1))){
var state_46791__$1 = state_46791;
var statearr_46794_46823 = state_46791__$1;
(statearr_46794_46823[(2)] = null);

(statearr_46794_46823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (4))){
var inst_46740 = (state_46791[(2)]);
var state_46791__$1 = (function (){var statearr_46795 = state_46791;
(statearr_46795[(7)] = inst_46740);

return statearr_46795;
})();
var statearr_46796_46824 = state_46791__$1;
(statearr_46796_46824[(2)] = null);

(statearr_46796_46824[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (13))){
var inst_46786 = (state_46791[(2)]);
var _ = (function (){var statearr_46797 = state_46791;
(statearr_46797[(4)] = cljs.core.rest.call(null,(state_46791[(4)])));

return statearr_46797;
})();
var state_46791__$1 = state_46791;
var statearr_46798_46825 = state_46791__$1;
(statearr_46798_46825[(2)] = inst_46786);

(statearr_46798_46825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (6))){
var inst_46750 = (state_46791[(2)]);
var state_46791__$1 = state_46791;
var statearr_46799_46826 = state_46791__$1;
(statearr_46799_46826[(2)] = inst_46750);

(statearr_46799_46826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (3))){
var inst_46789 = (state_46791[(2)]);
var state_46791__$1 = state_46791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46791__$1,inst_46789);
} else {
if((state_val_46792 === (12))){
var inst_46773 = (state_46791[(8)]);
var inst_46782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46783 = [null,inst_46773];
var inst_46784 = (new cljs.core.PersistentVector(null,2,(5),inst_46782,inst_46783,null));
var state_46791__$1 = state_46791;
var statearr_46800_46827 = state_46791__$1;
(statearr_46800_46827[(2)] = inst_46784);

(statearr_46800_46827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (2))){
var _ = (function (){var statearr_46802 = state_46791;
(statearr_46802[(4)] = cljs.core.cons.call(null,(9),(state_46791[(4)])));

return statearr_46802;
})();
var inst_46759 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_46760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46762 = [null,pred_name,"?o"];
var inst_46763 = (new cljs.core.PersistentVector(null,3,(5),inst_46761,inst_46762,null));
var inst_46764 = [inst_46763];
var inst_46765 = (new cljs.core.PersistentVector(null,1,(5),inst_46760,inst_46764,null));
var inst_46766 = ["?o",inst_46765,opts];
var inst_46767 = cljs.core.PersistentHashMap.fromArrays(inst_46759,inst_46766);
var inst_46768 = fluree.db.dbfunctions.internal.query.call(null,db,inst_46767);
var state_46791__$1 = state_46791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46791__$1,(10),inst_46768);
} else {
if((state_val_46792 === (11))){
var inst_46773 = (state_46791[(8)]);
var inst_46772 = (state_46791[(9)]);
var inst_46777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46778 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_46772);
var inst_46779 = [inst_46778,inst_46773];
var inst_46780 = (new cljs.core.PersistentVector(null,2,(5),inst_46777,inst_46779,null));
var state_46791__$1 = state_46791;
var statearr_46803_46828 = state_46791__$1;
(statearr_46803_46828[(2)] = inst_46780);

(statearr_46803_46828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (9))){
var _ = (function (){var statearr_46804 = state_46791;
(statearr_46804[(4)] = cljs.core.rest.call(null,(state_46791[(4)])));

return statearr_46804;
})();
var state_46791__$1 = state_46791;
var ex46801 = (state_46791__$1[(2)]);
var statearr_46805_46829 = state_46791__$1;
(statearr_46805_46829[(5)] = ex46801);


var statearr_46806_46830 = state_46791__$1;
(statearr_46806_46830[(1)] = (4));

(statearr_46806_46830[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (5))){
var inst_46740 = (state_46791[(7)]);
var _ = (function (){var statearr_46808 = state_46791;
(statearr_46808[(4)] = cljs.core.cons.call(null,(8),(state_46791[(4)])));

return statearr_46808;
})();
var inst_46747 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46740,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_46809 = state_46791;
(statearr_46809[(4)] = cljs.core.rest.call(null,(state_46791[(4)])));

return statearr_46809;
})();
var state_46791__$1 = state_46791;
var statearr_46810_46831 = state_46791__$1;
(statearr_46810_46831[(2)] = inst_46747);

(statearr_46810_46831[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (10))){
var inst_46772 = (state_46791[(9)]);
var inst_46770 = (state_46791[(2)]);
var inst_46771 = fluree.db.util.async.throw_err.call(null,inst_46770);
var inst_46772__$1 = cljs.core.nth.call(null,inst_46771,(0),null);
var inst_46773 = cljs.core.nth.call(null,inst_46771,(1),null);
var inst_46774 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_46772__$1);
var inst_46775 = cljs.core.not.call(null,inst_46774);
var state_46791__$1 = (function (){var statearr_46811 = state_46791;
(statearr_46811[(8)] = inst_46773);

(statearr_46811[(9)] = inst_46772__$1);

return statearr_46811;
})();
if(inst_46775){
var statearr_46812_46832 = state_46791__$1;
(statearr_46812_46832[(1)] = (11));

} else {
var statearr_46813_46833 = state_46791__$1;
(statearr_46813_46833[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46792 === (8))){
var _ = (function (){var statearr_46814 = state_46791;
(statearr_46814[(4)] = cljs.core.rest.call(null,(state_46791[(4)])));

return statearr_46814;
})();
var state_46791__$1 = state_46791;
var ex46807 = (state_46791__$1[(2)]);
var statearr_46815_46834 = state_46791__$1;
(statearr_46815_46834[(5)] = ex46807);


var statearr_46816_46835 = state_46791__$1;
(statearr_46816_46835[(1)] = (7));

(statearr_46816_46835[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____0 = (function (){
var statearr_46817 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46817[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__);

(statearr_46817[(1)] = (1));

return statearr_46817;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____1 = (function (state_46791){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46818){var ex__16224__auto__ = e46818;
var statearr_46819_46836 = state_46791;
(statearr_46819_46836[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46791[(4)]))){
var statearr_46820_46837 = state_46791;
(statearr_46820_46837[(1)] = cljs.core.first.call(null,(state_46791[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46838 = state_46791;
state_46791 = G__46838;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__ = function(state_46791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____1.call(this,state_46791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46821 = f__16346__auto__.call(null);
(statearr_46821[(6)] = c__16345__auto__);

return statearr_46821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e46839){var e = e46839;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__46841 = arguments.length;
switch (G__46841) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46911){
var state_val_46912 = (state_46911[(1)]);
if((state_val_46912 === (7))){
var inst_46843 = (state_46911[(2)]);
var state_46911__$1 = state_46911;
var statearr_46913_46957 = state_46911__$1;
(statearr_46913_46957[(2)] = inst_46843);

(statearr_46913_46957[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (20))){
var inst_46887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46888 = ["*"];
var inst_46889 = (new cljs.core.PersistentVector(null,1,(5),inst_46887,inst_46888,null));
var state_46911__$1 = state_46911;
var statearr_46914_46958 = state_46911__$1;
(statearr_46914_46958[(2)] = inst_46889);

(statearr_46914_46958[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (1))){
var state_46911__$1 = state_46911;
var statearr_46915_46959 = state_46911__$1;
(statearr_46915_46959[(2)] = null);

(statearr_46915_46959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (4))){
var inst_46842 = (state_46911[(2)]);
var state_46911__$1 = (function (){var statearr_46916 = state_46911;
(statearr_46916[(7)] = inst_46842);

return statearr_46916;
})();
var statearr_46917_46960 = state_46911__$1;
(statearr_46917_46960[(2)] = null);

(statearr_46917_46960[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (15))){
var inst_46906 = (state_46911[(2)]);
var _ = (function (){var statearr_46918 = state_46911;
(statearr_46918[(4)] = cljs.core.rest.call(null,(state_46911[(4)])));

return statearr_46918;
})();
var state_46911__$1 = state_46911;
var statearr_46919_46961 = state_46911__$1;
(statearr_46919_46961[(2)] = inst_46906);

(statearr_46919_46961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (21))){
var inst_46877 = (state_46911[(8)]);
var inst_46870 = (state_46911[(9)]);
var inst_46891 = (state_46911[(2)]);
var inst_46892 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_46893 = cljs.core.PersistentHashMap.EMPTY;
var inst_46894 = [inst_46891,inst_46877,inst_46893];
var inst_46895 = cljs.core.PersistentHashMap.fromArrays(inst_46892,inst_46894);
var inst_46896 = fluree.db.dbfunctions.internal.query.call(null,inst_46870,inst_46895);
var state_46911__$1 = state_46911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46911__$1,(22),inst_46896);
} else {
if((state_val_46912 === (13))){
var inst_46865 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46911__$1 = state_46911;
var statearr_46920_46962 = state_46911__$1;
(statearr_46920_46962[(2)] = inst_46865);

(statearr_46920_46962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (22))){
var inst_46898 = (state_46911[(2)]);
var inst_46899 = fluree.db.util.async.throw_err.call(null,inst_46898);
var inst_46900 = cljs.core.nth.call(null,inst_46899,(0),null);
var inst_46901 = cljs.core.nth.call(null,inst_46899,(1),null);
var inst_46902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46903 = [inst_46900,inst_46901];
var inst_46904 = (new cljs.core.PersistentVector(null,2,(5),inst_46902,inst_46903,null));
var state_46911__$1 = state_46911;
var statearr_46921_46963 = state_46911__$1;
(statearr_46921_46963[(2)] = inst_46904);

(statearr_46921_46963[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (6))){
var inst_46852 = (state_46911[(2)]);
var state_46911__$1 = state_46911;
var statearr_46922_46964 = state_46911__$1;
(statearr_46922_46964[(2)] = inst_46852);

(statearr_46922_46964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (17))){
var inst_46874 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46875 = fluree.db.dbfunctions.internal.get.call(null,inst_46874,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_46911__$1 = state_46911;
var statearr_46923_46965 = state_46911__$1;
(statearr_46923_46965[(2)] = inst_46875);

(statearr_46923_46965[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (3))){
var inst_46909 = (state_46911[(2)]);
var state_46911__$1 = state_46911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46911__$1,inst_46909);
} else {
if((state_val_46912 === (12))){
var inst_46863 = (state_46911[(2)]);
var state_46911__$1 = state_46911;
if(cljs.core.truth_(inst_46863)){
var statearr_46924_46966 = state_46911__$1;
(statearr_46924_46966[(1)] = (13));

} else {
var statearr_46925_46967 = state_46911__$1;
(statearr_46925_46967[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (2))){
var inst_46858 = (state_46911[(10)]);
var _ = (function (){var statearr_46926 = state_46911;
(statearr_46926[(4)] = cljs.core.cons.call(null,(9),(state_46911[(4)])));

return statearr_46926;
})();
var inst_46858__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46911__$1 = (function (){var statearr_46927 = state_46911;
(statearr_46927[(10)] = inst_46858__$1);

return statearr_46927;
})();
if(cljs.core.truth_(inst_46858__$1)){
var statearr_46928_46968 = state_46911__$1;
(statearr_46928_46968[(1)] = (10));

} else {
var statearr_46929_46969 = state_46911__$1;
(statearr_46929_46969[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (19))){
var inst_46879 = cljs.core.PersistentVector.EMPTY;
var inst_46880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46881 = ["*"];
var inst_46882 = (new cljs.core.PersistentVector(null,1,(5),inst_46880,inst_46881,null));
var inst_46883 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_46884 = cljs.core.concat.call(null,inst_46882,inst_46883);
var inst_46885 = cljs.core.into.call(null,inst_46879,inst_46884);
var state_46911__$1 = state_46911;
var statearr_46931_46970 = state_46911__$1;
(statearr_46931_46970[(2)] = inst_46885);

(statearr_46931_46970[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (11))){
var inst_46858 = (state_46911[(10)]);
var state_46911__$1 = state_46911;
var statearr_46932_46971 = state_46911__$1;
(statearr_46932_46971[(2)] = inst_46858);

(statearr_46932_46971[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (9))){
var _ = (function (){var statearr_46933 = state_46911;
(statearr_46933[(4)] = cljs.core.rest.call(null,(state_46911[(4)])));

return statearr_46933;
})();
var state_46911__$1 = state_46911;
var ex46930 = (state_46911__$1[(2)]);
var statearr_46934_46972 = state_46911__$1;
(statearr_46934_46972[(5)] = ex46930);


var statearr_46935_46973 = state_46911__$1;
(statearr_46935_46973[(1)] = (4));

(statearr_46935_46973[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (5))){
var inst_46842 = (state_46911[(7)]);
var _ = (function (){var statearr_46936 = state_46911;
(statearr_46936[(4)] = cljs.core.cons.call(null,(8),(state_46911[(4)])));

return statearr_46936;
})();
var inst_46849 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46842,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_46937 = state_46911;
(statearr_46937[(4)] = cljs.core.rest.call(null,(state_46911[(4)])));

return statearr_46937;
})();
var state_46911__$1 = state_46911;
var statearr_46938_46974 = state_46911__$1;
(statearr_46938_46974[(2)] = inst_46849);

(statearr_46938_46974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (14))){
var inst_46871 = (state_46911[(11)]);
var inst_46870 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46871__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_46911__$1 = (function (){var statearr_46939 = state_46911;
(statearr_46939[(9)] = inst_46870);

(statearr_46939[(11)] = inst_46871__$1);

return statearr_46939;
})();
if(cljs.core.truth_(inst_46871__$1)){
var statearr_46940_46975 = state_46911__$1;
(statearr_46940_46975[(1)] = (16));

} else {
var statearr_46941_46976 = state_46911__$1;
(statearr_46941_46976[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (16))){
var inst_46871 = (state_46911[(11)]);
var state_46911__$1 = state_46911;
var statearr_46942_46977 = state_46911__$1;
(statearr_46942_46977[(2)] = inst_46871);

(statearr_46942_46977[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (10))){
var inst_46860 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_46911__$1 = state_46911;
var statearr_46944_46978 = state_46911__$1;
(statearr_46944_46978[(2)] = inst_46860);

(statearr_46944_46978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (18))){
var inst_46877 = (state_46911[(2)]);
var state_46911__$1 = (function (){var statearr_46945 = state_46911;
(statearr_46945[(8)] = inst_46877);

return statearr_46945;
})();
if(cljs.core.truth_(additional_params)){
var statearr_46946_46979 = state_46911__$1;
(statearr_46946_46979[(1)] = (19));

} else {
var statearr_46947_46980 = state_46911__$1;
(statearr_46947_46980[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46912 === (8))){
var _ = (function (){var statearr_46948 = state_46911;
(statearr_46948[(4)] = cljs.core.rest.call(null,(state_46911[(4)])));

return statearr_46948;
})();
var state_46911__$1 = state_46911;
var ex46943 = (state_46911__$1[(2)]);
var statearr_46949_46981 = state_46911__$1;
(statearr_46949_46981[(5)] = ex46943);


var statearr_46950_46982 = state_46911__$1;
(statearr_46950_46982[(1)] = (7));

(statearr_46950_46982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16221__auto____0 = (function (){
var statearr_46951 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46951[(0)] = fluree$db$dbfunctions$internal$state_machine__16221__auto__);

(statearr_46951[(1)] = (1));

return statearr_46951;
});
var fluree$db$dbfunctions$internal$state_machine__16221__auto____1 = (function (state_46911){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46952){var ex__16224__auto__ = e46952;
var statearr_46953_46983 = state_46911;
(statearr_46953_46983[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46911[(4)]))){
var statearr_46954_46984 = state_46911;
(statearr_46954_46984[(1)] = cljs.core.first.call(null,(state_46911[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46985 = state_46911;
state_46911 = G__46985;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16221__auto__ = function(state_46911){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____1.call(this,state_46911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46955 = f__16346__auto__.call(null);
(statearr_46955[(6)] = c__16345__auto__);

return statearr_46955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__46987 = arguments.length;
switch (G__46987) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_47031){
var state_val_47032 = (state_47031[(1)]);
if((state_val_47032 === (7))){
var inst_47009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47010 = ["*"];
var inst_47011 = (new cljs.core.PersistentVector(null,1,(5),inst_47009,inst_47010,null));
var state_47031__$1 = state_47031;
var statearr_47033_47053 = state_47031__$1;
(statearr_47033_47053[(2)] = inst_47011);

(statearr_47033_47053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (1))){
var state_47031__$1 = state_47031;
var statearr_47034_47054 = state_47031__$1;
(statearr_47034_47054[(2)] = null);

(statearr_47034_47054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (4))){
var inst_46988 = (state_47031[(2)]);
var inst_46989 = fluree.db.dbfunctions.internal.function_error.call(null,inst_46988,"?p","Context Object",additional_params);
var state_47031__$1 = state_47031;
var statearr_47035_47055 = state_47031__$1;
(statearr_47035_47055[(2)] = inst_46989);

(statearr_47035_47055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (6))){
var inst_47001 = cljs.core.PersistentVector.EMPTY;
var inst_47002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47003 = ["*"];
var inst_47004 = (new cljs.core.PersistentVector(null,1,(5),inst_47002,inst_47003,null));
var inst_47005 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_47006 = cljs.core.concat.call(null,inst_47004,inst_47005);
var inst_47007 = cljs.core.into.call(null,inst_47001,inst_47006);
var state_47031__$1 = state_47031;
var statearr_47036_47056 = state_47031__$1;
(statearr_47036_47056[(2)] = inst_47007);

(statearr_47036_47056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (3))){
var inst_47029 = (state_47031[(2)]);
var state_47031__$1 = state_47031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47031__$1,inst_47029);
} else {
if((state_val_47032 === (2))){
var _ = (function (){var statearr_47038 = state_47031;
(statearr_47038[(4)] = cljs.core.cons.call(null,(5),(state_47031[(4)])));

return statearr_47038;
})();
var inst_46998 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46999 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47031__$1 = (function (){var statearr_47039 = state_47031;
(statearr_47039[(7)] = inst_46999);

(statearr_47039[(8)] = inst_46998);

return statearr_47039;
})();
if(cljs.core.truth_(additional_params)){
var statearr_47040_47057 = state_47031__$1;
(statearr_47040_47057[(1)] = (6));

} else {
var statearr_47041_47058 = state_47031__$1;
(statearr_47041_47058[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (9))){
var inst_47020 = (state_47031[(2)]);
var inst_47021 = fluree.db.util.async.throw_err.call(null,inst_47020);
var inst_47022 = cljs.core.nth.call(null,inst_47021,(0),null);
var inst_47023 = cljs.core.nth.call(null,inst_47021,(1),null);
var inst_47024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47025 = [inst_47022,inst_47023];
var inst_47026 = (new cljs.core.PersistentVector(null,2,(5),inst_47024,inst_47025,null));
var _ = (function (){var statearr_47042 = state_47031;
(statearr_47042[(4)] = cljs.core.rest.call(null,(state_47031[(4)])));

return statearr_47042;
})();
var state_47031__$1 = state_47031;
var statearr_47043_47059 = state_47031__$1;
(statearr_47043_47059[(2)] = inst_47026);

(statearr_47043_47059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (5))){
var _ = (function (){var statearr_47044 = state_47031;
(statearr_47044[(4)] = cljs.core.rest.call(null,(state_47031[(4)])));

return statearr_47044;
})();
var state_47031__$1 = state_47031;
var ex47037 = (state_47031__$1[(2)]);
var statearr_47045_47060 = state_47031__$1;
(statearr_47045_47060[(5)] = ex47037);


var statearr_47046_47061 = state_47031__$1;
(statearr_47046_47061[(1)] = (4));

(statearr_47046_47061[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47032 === (8))){
var inst_46999 = (state_47031[(7)]);
var inst_46998 = (state_47031[(8)]);
var inst_47013 = (state_47031[(2)]);
var inst_47014 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_47015 = cljs.core.PersistentHashMap.EMPTY;
var inst_47016 = [inst_47013,inst_46999,inst_47015];
var inst_47017 = cljs.core.PersistentHashMap.fromArrays(inst_47014,inst_47016);
var inst_47018 = fluree.db.dbfunctions.internal.query.call(null,inst_46998,inst_47017);
var state_47031__$1 = state_47031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47031__$1,(9),inst_47018);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16221__auto____0 = (function (){
var statearr_47047 = [null,null,null,null,null,null,null,null,null];
(statearr_47047[(0)] = fluree$db$dbfunctions$internal$state_machine__16221__auto__);

(statearr_47047[(1)] = (1));

return statearr_47047;
});
var fluree$db$dbfunctions$internal$state_machine__16221__auto____1 = (function (state_47031){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_47031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e47048){var ex__16224__auto__ = e47048;
var statearr_47049_47062 = state_47031;
(statearr_47049_47062[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_47031[(4)]))){
var statearr_47050_47063 = state_47031;
(statearr_47050_47063[(1)] = cljs.core.first.call(null,(state_47031[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47064 = state_47031;
state_47031 = G__47064;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16221__auto__ = function(state_47031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16221__auto____1.call(this,state_47031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_47051 = f__16346__auto__.call(null);
(statearr_47051[(6)] = c__16345__auto__);

return statearr_47051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_47108){
var state_val_47109 = (state_47108[(1)]);
if((state_val_47109 === (1))){
var state_47108__$1 = state_47108;
var statearr_47110_47124 = state_47108__$1;
(statearr_47110_47124[(2)] = null);

(statearr_47110_47124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47109 === (2))){
var _ = (function (){var statearr_47111 = state_47108;
(statearr_47111[(4)] = cljs.core.cons.call(null,(5),(state_47108[(4)])));

return statearr_47111;
})();
var inst_47075 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_47076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47077 = ["_user/_auth"];
var inst_47078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47079 = ["*"];
var inst_47080 = (new cljs.core.PersistentVector(null,1,(5),inst_47078,inst_47079,null));
var inst_47081 = [inst_47080];
var inst_47082 = cljs.core.PersistentHashMap.fromArrays(inst_47077,inst_47081);
var inst_47083 = [inst_47082];
var inst_47084 = (new cljs.core.PersistentVector(null,1,(5),inst_47076,inst_47083,null));
var inst_47085 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47086 = cljs.core.PersistentHashMap.EMPTY;
var inst_47087 = [inst_47084,inst_47085,inst_47086];
var inst_47088 = cljs.core.PersistentHashMap.fromArrays(inst_47075,inst_47087);
var inst_47089 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47090 = fluree.db.dbfunctions.internal.query.call(null,inst_47089,inst_47088);
var state_47108__$1 = state_47108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47108__$1,(6),inst_47090);
} else {
if((state_val_47109 === (3))){
var inst_47106 = (state_47108[(2)]);
var state_47108__$1 = state_47108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47108__$1,inst_47106);
} else {
if((state_val_47109 === (4))){
var inst_47065 = (state_47108[(2)]);
var inst_47066 = fluree.db.dbfunctions.internal.function_error.call(null,inst_47065,"?user_id-from-auth","Context Object");
var state_47108__$1 = state_47108;
var statearr_47113_47125 = state_47108__$1;
(statearr_47113_47125[(2)] = inst_47066);

(statearr_47113_47125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47109 === (5))){
var _ = (function (){var statearr_47114 = state_47108;
(statearr_47114[(4)] = cljs.core.rest.call(null,(state_47108[(4)])));

return statearr_47114;
})();
var state_47108__$1 = state_47108;
var ex47112 = (state_47108__$1[(2)]);
var statearr_47115_47126 = state_47108__$1;
(statearr_47115_47126[(5)] = ex47112);


var statearr_47116_47127 = state_47108__$1;
(statearr_47116_47127[(1)] = (4));

(statearr_47116_47127[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47109 === (6))){
var inst_47092 = (state_47108[(2)]);
var inst_47093 = fluree.db.util.async.throw_err.call(null,inst_47092);
var inst_47094 = cljs.core.nth.call(null,inst_47093,(0),null);
var inst_47095 = cljs.core.nth.call(null,inst_47093,(1),null);
var inst_47096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47097 = ["_user/_auth","_id"];
var inst_47098 = (new cljs.core.PersistentVector(null,2,(5),inst_47096,inst_47097,null));
var inst_47099 = fluree.db.dbfunctions.internal.get_in.call(null,inst_47094,inst_47098);
var inst_47100 = cljs.core.first.call(null,inst_47099);
var inst_47101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47102 = [inst_47100,inst_47095];
var inst_47103 = (new cljs.core.PersistentVector(null,2,(5),inst_47101,inst_47102,null));
var _ = (function (){var statearr_47117 = state_47108;
(statearr_47117[(4)] = cljs.core.rest.call(null,(state_47108[(4)])));

return statearr_47117;
})();
var state_47108__$1 = state_47108;
var statearr_47118_47128 = state_47108__$1;
(statearr_47118_47128[(2)] = inst_47103);

(statearr_47118_47128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____0 = (function (){
var statearr_47119 = [null,null,null,null,null,null,null];
(statearr_47119[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__);

(statearr_47119[(1)] = (1));

return statearr_47119;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____1 = (function (state_47108){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_47108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e47120){var ex__16224__auto__ = e47120;
var statearr_47121_47129 = state_47108;
(statearr_47121_47129[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_47108[(4)]))){
var statearr_47122_47130 = state_47108;
(statearr_47122_47130[(1)] = cljs.core.first.call(null,(state_47108[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47131 = state_47108;
state_47108 = G__47131;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__ = function(state_47108){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____1.call(this,state_47108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_47123 = f__16346__auto__.call(null);
(statearr_47123[(6)] = c__16345__auto__);

return statearr_47123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_47148){
var state_val_47149 = (state_47148[(1)]);
if((state_val_47149 === (1))){
var state_47148__$1 = state_47148;
var statearr_47150_47164 = state_47148__$1;
(statearr_47150_47164[(2)] = null);

(statearr_47150_47164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47149 === (2))){
var _ = (function (){var statearr_47151 = state_47148;
(statearr_47151[(4)] = cljs.core.cons.call(null,(5),(state_47148[(4)])));

return statearr_47151;
})();
var inst_47138 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47139 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47140 = fluree.db.dbproto._subid.call(null,inst_47139,inst_47138);
var state_47148__$1 = state_47148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47148__$1,(6),inst_47140);
} else {
if((state_val_47149 === (3))){
var inst_47146 = (state_47148[(2)]);
var state_47148__$1 = state_47148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47148__$1,inst_47146);
} else {
if((state_val_47149 === (4))){
var inst_47132 = (state_47148[(2)]);
var state_47148__$1 = state_47148;
var statearr_47153_47165 = state_47148__$1;
(statearr_47153_47165[(2)] = inst_47132);

(statearr_47153_47165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47149 === (5))){
var _ = (function (){var statearr_47154 = state_47148;
(statearr_47154[(4)] = cljs.core.rest.call(null,(state_47148[(4)])));

return statearr_47154;
})();
var state_47148__$1 = state_47148;
var ex47152 = (state_47148__$1[(2)]);
var statearr_47155_47166 = state_47148__$1;
(statearr_47155_47166[(5)] = ex47152);


if((ex47152 instanceof Error)){
var statearr_47156_47167 = state_47148__$1;
(statearr_47156_47167[(1)] = (4));

(statearr_47156_47167[(5)] = null);

} else {
throw ex47152;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47149 === (6))){
var inst_47142 = (state_47148[(2)]);
var inst_47143 = fluree.db.util.async.throw_err.call(null,inst_47142);
var _ = (function (){var statearr_47157 = state_47148;
(statearr_47157[(4)] = cljs.core.rest.call(null,(state_47148[(4)])));

return statearr_47157;
})();
var state_47148__$1 = state_47148;
var statearr_47158_47168 = state_47148__$1;
(statearr_47158_47168[(2)] = inst_47143);

(statearr_47158_47168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____0 = (function (){
var statearr_47159 = [null,null,null,null,null,null,null];
(statearr_47159[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__);

(statearr_47159[(1)] = (1));

return statearr_47159;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____1 = (function (state_47148){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_47148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e47160){var ex__16224__auto__ = e47160;
var statearr_47161_47169 = state_47148;
(statearr_47161_47169[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_47148[(4)]))){
var statearr_47162_47170 = state_47148;
(statearr_47162_47170[(1)] = cljs.core.first.call(null,(state_47148[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47171 = state_47148;
state_47148 = G__47171;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__ = function(state_47148){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____1.call(this,state_47148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_47163 = f__16346__auto__.call(null);
(statearr_47163[(6)] = c__16345__auto__);

return statearr_47163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__47172_SHARP_){
return p1__47172_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__47173_SHARP_){
return p1__47173_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e47174){var e = e47174;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__47175_SHARP_){
return p1__47175_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__47176_SHARP_){
return p1__47176_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e47177){var e = e47177;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e47178){var e = e47178;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_47258){
var state_val_47259 = (state_47258[(1)]);
if((state_val_47259 === (7))){
var inst_47197 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_47198 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47199 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_47200 = cljs.core.PersistentHashMap.fromArrays(inst_47198,inst_47199);
var inst_47201 = cljs.core.ex_info.call(null,inst_47197,inst_47200);
var inst_47202 = (function(){throw inst_47201})();
var state_47258__$1 = state_47258;
var statearr_47260_47295 = state_47258__$1;
(statearr_47260_47295[(2)] = inst_47202);

(statearr_47260_47295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (1))){
var state_47258__$1 = state_47258;
var statearr_47261_47296 = state_47258__$1;
(statearr_47261_47296[(2)] = null);

(statearr_47261_47296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (4))){
var inst_47179 = (state_47258[(2)]);
var state_47258__$1 = state_47258;
var statearr_47262_47297 = state_47258__$1;
(statearr_47262_47297[(2)] = inst_47179);

(statearr_47262_47297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (15))){
var inst_47242 = (state_47258[(7)]);
var inst_47238 = (state_47258[(2)]);
var inst_47239 = fluree.db.util.async.throw_err.call(null,inst_47238);
var inst_47240 = cljs.core.nth.call(null,inst_47239,(0),null);
var inst_47241 = cljs.core.nth.call(null,inst_47239,(1),null);
var inst_47242__$1 = cljs.core.first.call(null,inst_47240);
var inst_47243 = cljs.core._EQ_.call(null,inst_47242__$1,compare_val);
var state_47258__$1 = (function (){var statearr_47263 = state_47258;
(statearr_47263[(7)] = inst_47242__$1);

(statearr_47263[(8)] = inst_47241);

return statearr_47263;
})();
if(inst_47243){
var statearr_47264_47298 = state_47258__$1;
(statearr_47264_47298[(1)] = (16));

} else {
var statearr_47265_47299 = state_47258__$1;
(statearr_47265_47299[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (13))){
var state_47258__$1 = state_47258;
var statearr_47266_47300 = state_47258__$1;
(statearr_47266_47300[(2)] = null);

(statearr_47266_47300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (6))){
var state_47258__$1 = state_47258;
var statearr_47267_47301 = state_47258__$1;
(statearr_47267_47301[(2)] = null);

(statearr_47267_47301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (17))){
var inst_47242 = (state_47258[(7)]);
var inst_47246 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47242)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_47247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47248 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_47249 = cljs.core.PersistentHashMap.fromArrays(inst_47247,inst_47248);
var inst_47250 = cljs.core.ex_info.call(null,inst_47246,inst_47249);
var inst_47251 = (function(){throw inst_47250})();
var state_47258__$1 = state_47258;
var statearr_47268_47302 = state_47258__$1;
(statearr_47268_47302[(2)] = inst_47251);

(statearr_47268_47302[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (3))){
var inst_47256 = (state_47258[(2)]);
var state_47258__$1 = state_47258;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47258__$1,inst_47256);
} else {
if((state_val_47259 === (12))){
var inst_47194 = (state_47258[(9)]);
var inst_47217 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_47194);
var inst_47218 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47219 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_47220 = cljs.core.PersistentHashMap.fromArrays(inst_47218,inst_47219);
var inst_47221 = cljs.core.ex_info.call(null,inst_47217,inst_47220);
var inst_47222 = (function(){throw inst_47221})();
var state_47258__$1 = state_47258;
var statearr_47269_47303 = state_47258__$1;
(statearr_47269_47303[(2)] = inst_47222);

(statearr_47269_47303[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (2))){
var inst_47192 = (state_47258[(10)]);
var inst_47193 = (state_47258[(11)]);
var inst_47191 = (state_47258[(12)]);
var _ = (function (){var statearr_47270 = state_47258;
(statearr_47270[(4)] = cljs.core.cons.call(null,(5),(state_47258[(4)])));

return statearr_47270;
})();
var inst_47189 = _QMARK_ctx;
var inst_47190 = cljs.core.__destructure_map.call(null,inst_47189);
var inst_47191__$1 = cljs.core.get.call(null,inst_47190,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_47192__$1 = cljs.core.get.call(null,inst_47190,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_47193__$1 = cljs.core.get.call(null,inst_47190,new cljs.core.Keyword(null,"db","db",993250759));
var inst_47194 = fluree.db.dbproto._p_prop.call(null,inst_47193__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_47192__$1);
var state_47258__$1 = (function (){var statearr_47271 = state_47258;
(statearr_47271[(9)] = inst_47194);

(statearr_47271[(10)] = inst_47192__$1);

(statearr_47271[(11)] = inst_47193__$1);

(statearr_47271[(12)] = inst_47191__$1);

return statearr_47271;
})();
if(cljs.core.truth_(inst_47191__$1)){
var statearr_47272_47304 = state_47258__$1;
(statearr_47272_47304[(1)] = (6));

} else {
var statearr_47273_47305 = state_47258__$1;
(statearr_47273_47305[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (11))){
var inst_47192 = (state_47258[(10)]);
var inst_47193 = (state_47258[(11)]);
var inst_47214 = (state_47258[(2)]);
var inst_47215 = fluree.db.dbproto._p_prop.call(null,inst_47193,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_47192);
var state_47258__$1 = (function (){var statearr_47275 = state_47258;
(statearr_47275[(13)] = inst_47214);

return statearr_47275;
})();
if(cljs.core.truth_(inst_47215)){
var statearr_47276_47306 = state_47258__$1;
(statearr_47276_47306[(1)] = (12));

} else {
var statearr_47277_47307 = state_47258__$1;
(statearr_47277_47307[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (9))){
var state_47258__$1 = state_47258;
var statearr_47278_47308 = state_47258__$1;
(statearr_47278_47308[(2)] = null);

(statearr_47278_47308[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (5))){
var _ = (function (){var statearr_47279 = state_47258;
(statearr_47279[(4)] = cljs.core.rest.call(null,(state_47258[(4)])));

return statearr_47279;
})();
var state_47258__$1 = state_47258;
var ex47274 = (state_47258__$1[(2)]);
var statearr_47280_47309 = state_47258__$1;
(statearr_47280_47309[(5)] = ex47274);


if((ex47274 instanceof Error)){
var statearr_47281_47310 = state_47258__$1;
(statearr_47281_47310[(1)] = (4));

(statearr_47281_47310[(5)] = null);

} else {
throw ex47274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (14))){
var inst_47194 = (state_47258[(9)]);
var inst_47193 = (state_47258[(11)]);
var inst_47191 = (state_47258[(12)]);
var inst_47225 = (state_47258[(2)]);
var inst_47226 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_47227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47229 = [inst_47191,inst_47194,"?current-val"];
var inst_47230 = (new cljs.core.PersistentVector(null,3,(5),inst_47228,inst_47229,null));
var inst_47231 = [inst_47230];
var inst_47232 = (new cljs.core.PersistentVector(null,1,(5),inst_47227,inst_47231,null));
var inst_47233 = cljs.core.PersistentHashMap.EMPTY;
var inst_47234 = ["?current-val",inst_47232,inst_47233];
var inst_47235 = cljs.core.PersistentHashMap.fromArrays(inst_47226,inst_47234);
var inst_47236 = fluree.db.dbfunctions.internal.query.call(null,inst_47193,inst_47235);
var state_47258__$1 = (function (){var statearr_47282 = state_47258;
(statearr_47282[(14)] = inst_47225);

return statearr_47282;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47258__$1,(15),inst_47236);
} else {
if((state_val_47259 === (16))){
var state_47258__$1 = state_47258;
var statearr_47283_47311 = state_47258__$1;
(statearr_47283_47311[(2)] = new_val);

(statearr_47283_47311[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (10))){
var inst_47207 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_47208 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_47209 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_47210 = cljs.core.PersistentHashMap.fromArrays(inst_47208,inst_47209);
var inst_47211 = cljs.core.ex_info.call(null,inst_47207,inst_47210);
var inst_47212 = (function(){throw inst_47211})();
var state_47258__$1 = state_47258;
var statearr_47284_47312 = state_47258__$1;
(statearr_47284_47312[(2)] = inst_47212);

(statearr_47284_47312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (18))){
var inst_47253 = (state_47258[(2)]);
var _ = (function (){var statearr_47285 = state_47258;
(statearr_47285[(4)] = cljs.core.rest.call(null,(state_47258[(4)])));

return statearr_47285;
})();
var state_47258__$1 = state_47258;
var statearr_47286_47313 = state_47258__$1;
(statearr_47286_47313[(2)] = inst_47253);

(statearr_47286_47313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47259 === (8))){
var inst_47194 = (state_47258[(9)]);
var inst_47204 = (state_47258[(2)]);
var state_47258__$1 = (function (){var statearr_47287 = state_47258;
(statearr_47287[(15)] = inst_47204);

return statearr_47287;
})();
if(cljs.core.truth_(inst_47194)){
var statearr_47288_47314 = state_47258__$1;
(statearr_47288_47314[(1)] = (9));

} else {
var statearr_47289_47315 = state_47258__$1;
(statearr_47289_47315[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____0 = (function (){
var statearr_47290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47290[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__);

(statearr_47290[(1)] = (1));

return statearr_47290;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____1 = (function (state_47258){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_47258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e47291){var ex__16224__auto__ = e47291;
var statearr_47292_47316 = state_47258;
(statearr_47292_47316[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_47258[(4)]))){
var statearr_47293_47317 = state_47258;
(statearr_47293_47317[(1)] = cljs.core.first.call(null,(state_47258[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47318 = state_47258;
state_47258 = G__47318;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__ = function(state_47258){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____1.call(this,state_47258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_47294 = f__16346__auto__.call(null);
(statearr_47294[(6)] = c__16345__auto__);

return statearr_47294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
