// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__43873 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__43873,(0),null);
var network = cljs.core.nth.call(null,vec__43873,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__43873,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__43876){
var map__43877 = p__43876;
var map__43877__$1 = cljs.core.__destructure_map.call(null,map__43877);
var opts = map__43877__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__43877__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_43937){
var state_val_43938 = (state_43937[(1)]);
if((state_val_43938 === (7))){
var inst_43908 = cljs.core.not.call(null,reindex_QMARK_);
var state_43937__$1 = state_43937;
var statearr_43939_43963 = state_43937__$1;
(statearr_43939_43963[(2)] = inst_43908);

(statearr_43939_43963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (1))){
var state_43937__$1 = state_43937;
var statearr_43940_43964 = state_43937__$1;
(statearr_43940_43964[(2)] = null);

(statearr_43940_43964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (4))){
var inst_43878 = (state_43937[(2)]);
var state_43937__$1 = state_43937;
var statearr_43941_43965 = state_43937__$1;
(statearr_43941_43965[(2)] = inst_43878);

(statearr_43941_43965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (6))){
var inst_43898 = (state_43937[(7)]);
var inst_43892 = (state_43937[(8)]);
var inst_43906 = (state_43937[(9)]);
var inst_43891 = (state_43937[(2)]);
var inst_43892__$1 = fluree.db.util.async.throw_err.call(null,inst_43891);
var inst_43893 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_43894 = cljs.core.__destructure_map.call(null,inst_43893);
var inst_43895 = cljs.core.get.call(null,inst_43894,new cljs.core.Keyword(null,"post","post",269697687));
var inst_43896 = cljs.core.get.call(null,inst_43894,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_43897 = fluree.db.flake.size_bytes.call(null,inst_43892__$1);
var inst_43898__$1 = (inst_43896 + inst_43897);
var inst_43899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43900 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_43901 = (new cljs.core.PersistentVector(null,2,(5),inst_43899,inst_43900,null));
var inst_43902 = cljs.core.get_in.call(null,db,inst_43901);
var inst_43903 = cljs.core.__destructure_map.call(null,inst_43902);
var inst_43904 = cljs.core.get.call(null,inst_43903,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_43905 = cljs.core.get.call(null,inst_43903,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_43906__$1 = (inst_43898__$1 > inst_43905);
var state_43937__$1 = (function (){var statearr_43942 = state_43937;
(statearr_43942[(10)] = inst_43895);

(statearr_43942[(7)] = inst_43898__$1);

(statearr_43942[(8)] = inst_43892__$1);

(statearr_43942[(11)] = inst_43904);

(statearr_43942[(9)] = inst_43906__$1);

return statearr_43942;
})();
if(cljs.core.truth_(inst_43906__$1)){
var statearr_43943_43966 = state_43937__$1;
(statearr_43943_43966[(1)] = (7));

} else {
var statearr_43944_43967 = state_43937__$1;
(statearr_43944_43967[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (3))){
var inst_43935 = (state_43937[(2)]);
var state_43937__$1 = state_43937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43937__$1,inst_43935);
} else {
if((state_val_43938 === (12))){
var inst_43895 = (state_43937[(10)]);
var inst_43898 = (state_43937[(7)]);
var inst_43892 = (state_43937[(8)]);
var inst_43921 = (state_43937[(2)]);
var inst_43922 = cljs.core.into.call(null,inst_43895,inst_43892);
var inst_43923 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_43924 = cljs.core.swap_BANG_.call(null,inst_43923,cljs.core.empty);
var inst_43925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43926 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_43927 = (new cljs.core.PersistentVector(null,2,(5),inst_43925,inst_43926,null));
var inst_43928 = cljs.core.assoc_in.call(null,db,inst_43927,inst_43922);
var inst_43929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43930 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_43931 = (new cljs.core.PersistentVector(null,2,(5),inst_43929,inst_43930,null));
var inst_43932 = cljs.core.assoc_in.call(null,inst_43928,inst_43931,inst_43898);
var _ = (function (){var statearr_43945 = state_43937;
(statearr_43945[(4)] = cljs.core.rest.call(null,(state_43937[(4)])));

return statearr_43945;
})();
var state_43937__$1 = (function (){var statearr_43946 = state_43937;
(statearr_43946[(12)] = inst_43924);

(statearr_43946[(13)] = inst_43921);

return statearr_43946;
})();
var statearr_43947_43968 = state_43937__$1;
(statearr_43947_43968[(2)] = inst_43932);

(statearr_43947_43968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (2))){
var _ = (function (){var statearr_43948 = state_43937;
(statearr_43948[(4)] = cljs.core.cons.call(null,(5),(state_43937[(4)])));

return statearr_43948;
})();
var inst_43886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43887 = [pred_id];
var inst_43888 = (new cljs.core.PersistentVector(null,1,(5),inst_43886,inst_43887,null));
var inst_43889 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_43888);
var state_43937__$1 = state_43937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43937__$1,(6),inst_43889);
} else {
if((state_val_43938 === (11))){
var state_43937__$1 = state_43937;
var statearr_43950_43969 = state_43937__$1;
(statearr_43950_43969[(2)] = null);

(statearr_43950_43969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (9))){
var inst_43911 = (state_43937[(2)]);
var state_43937__$1 = state_43937;
if(cljs.core.truth_(inst_43911)){
var statearr_43951_43970 = state_43937__$1;
(statearr_43951_43970[(1)] = (10));

} else {
var statearr_43952_43971 = state_43937__$1;
(statearr_43952_43971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (5))){
var _ = (function (){var statearr_43953 = state_43937;
(statearr_43953[(4)] = cljs.core.rest.call(null,(state_43937[(4)])));

return statearr_43953;
})();
var state_43937__$1 = state_43937;
var ex43949 = (state_43937__$1[(2)]);
var statearr_43954_43972 = state_43937__$1;
(statearr_43954_43972[(5)] = ex43949);


if((ex43949 instanceof Error)){
var statearr_43955_43973 = state_43937__$1;
(statearr_43955_43973[(1)] = (4));

(statearr_43955_43973[(5)] = null);

} else {
throw ex43949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (10))){
var inst_43913 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_43914 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_43915 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_43916 = cljs.core.PersistentHashMap.fromArrays(inst_43914,inst_43915);
var inst_43917 = cljs.core.ex_info.call(null,inst_43913,inst_43916);
var inst_43918 = (function(){throw inst_43917})();
var state_43937__$1 = state_43937;
var statearr_43956_43974 = state_43937__$1;
(statearr_43956_43974[(2)] = inst_43918);

(statearr_43956_43974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43938 === (8))){
var inst_43906 = (state_43937[(9)]);
var state_43937__$1 = state_43937;
var statearr_43957_43975 = state_43937__$1;
(statearr_43957_43975[(2)] = inst_43906);

(statearr_43957_43975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____0 = (function (){
var statearr_43958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43958[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__);

(statearr_43958[(1)] = (1));

return statearr_43958;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____1 = (function (state_43937){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_43937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e43959){var ex__16224__auto__ = e43959;
var statearr_43960_43976 = state_43937;
(statearr_43960_43976[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_43937[(4)]))){
var statearr_43961_43977 = state_43937;
(statearr_43961_43977[(1)] = cljs.core.first.call(null,(state_43937[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43978 = state_43937;
state_43937 = G__43978;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__ = function(state_43937){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____1.call(this,state_43937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_43962 = f__16346__auto__.call(null);
(statearr_43962[(6)] = c__16345__auto__);

return statearr_43962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__43983 = arguments.length;
switch (G__43983) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44179){
var state_val_44180 = (state_44179[(1)]);
if((state_val_44180 === (7))){
var state_44179__$1 = state_44179;
var statearr_44181_44248 = state_44179__$1;
(statearr_44181_44248[(2)] = null);

(statearr_44181_44248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (20))){
var inst_44103 = (state_44179[(7)]);
var inst_44104 = (state_44179[(8)]);
var inst_44072 = (state_44179[(9)]);
var inst_44102 = (state_44179[(10)]);
var inst_44105 = (state_44179[(11)]);
var inst_44021 = (state_44179[(12)]);
var inst_44022 = (state_44179[(13)]);
var inst_44101 = (state_44179[(14)]);
var inst_44115 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_44116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44117 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_44118 = (new cljs.core.PersistentVector(null,2,(5),inst_44116,inst_44117,null));
var inst_44119 = cljs.core.get_in.call(null,inst_44072,inst_44118);
var inst_44120 = (inst_44021 + inst_44119);
var inst_44121 = [inst_44101,inst_44102,inst_44103,inst_44104,inst_44120];
var inst_44122 = cljs.core.PersistentHashMap.fromArrays(inst_44115,inst_44121);
var inst_44123 = cljs.core.assoc.call(null,inst_44072,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_44105,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_44122);
var state_44179__$1 = (function (){var statearr_44182 = state_44179;
(statearr_44182[(15)] = inst_44123);

return statearr_44182;
})();
if(cljs.core.truth_(inst_44022)){
var statearr_44183_44249 = state_44179__$1;
(statearr_44183_44249[(1)] = (23));

} else {
var statearr_44184_44250 = state_44179__$1;
(statearr_44184_44250[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (27))){
var inst_44123 = (state_44179[(15)]);
var state_44179__$1 = state_44179;
var statearr_44185_44251 = state_44179__$1;
(statearr_44185_44251[(2)] = inst_44123);

(statearr_44185_44251[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (1))){
var state_44179__$1 = state_44179;
var statearr_44186_44252 = state_44179__$1;
(statearr_44186_44252[(2)] = null);

(statearr_44186_44252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (24))){
var inst_44123 = (state_44179[(15)]);
var inst_44126 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_44123);
var inst_44127 = (inst_44126 == null);
var state_44179__$1 = state_44179;
var statearr_44187_44253 = state_44179__$1;
(statearr_44187_44253[(2)] = inst_44127);

(statearr_44187_44253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (39))){
var inst_44155 = (state_44179[(16)]);
var inst_44112 = (state_44179[(17)]);
var inst_44154 = (state_44179[(18)]);
var inst_44153 = (state_44179[(19)]);
var inst_44162 = (state_44179[(20)]);
var inst_44169 = (state_44179[(2)]);
var inst_44100 = inst_44112;
var inst_44101 = inst_44154;
var inst_44102 = inst_44155;
var inst_44103 = inst_44162;
var inst_44104 = inst_44169;
var inst_44105 = inst_44153;
var state_44179__$1 = (function (){var statearr_44188 = state_44179;
(statearr_44188[(21)] = inst_44100);

(statearr_44188[(7)] = inst_44103);

(statearr_44188[(8)] = inst_44104);

(statearr_44188[(10)] = inst_44102);

(statearr_44188[(11)] = inst_44105);

(statearr_44188[(14)] = inst_44101);

return statearr_44188;
})();
var statearr_44189_44254 = state_44179__$1;
(statearr_44189_44254[(2)] = null);

(statearr_44189_44254[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (4))){
var inst_43984 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
var statearr_44190_44255 = state_44179__$1;
(statearr_44190_44255[(2)] = inst_43984);

(statearr_44190_44255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (15))){
var inst_44044 = (state_44179[(22)]);
var state_44179__$1 = state_44179;
var statearr_44191_44256 = state_44179__$1;
(statearr_44191_44256[(2)] = inst_44044);

(statearr_44191_44256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (21))){
var inst_44100 = (state_44179[(21)]);
var inst_44020 = (state_44179[(23)]);
var inst_44025 = (state_44179[(24)]);
var inst_44082 = (state_44179[(25)]);
var inst_44103 = (state_44179[(7)]);
var inst_44008 = (state_44179[(26)]);
var inst_44031 = (state_44179[(27)]);
var inst_44104 = (state_44179[(8)]);
var inst_43991 = (state_44179[(28)]);
var inst_44072 = (state_44179[(9)]);
var inst_44112 = (state_44179[(17)]);
var inst_44102 = (state_44179[(10)]);
var inst_44105 = (state_44179[(11)]);
var inst_44021 = (state_44179[(12)]);
var inst_44023 = (state_44179[(29)]);
var inst_44012 = (state_44179[(30)]);
var inst_44022 = (state_44179[(13)]);
var inst_44101 = (state_44179[(14)]);
var inst_44111 = (state_44179[(31)]);
var inst_44006 = (state_44179[(32)]);
var inst_44016 = (state_44179[(33)]);
var inst_44081 = (state_44179[(34)]);
var inst_44150 = inst_44111.s;
var inst_44151 = fluree.db.flake.sid__GT_cid.call(null,inst_44150);
var inst_44152 = (function (){var flakes_bytes = inst_44021;
var seq__44078 = inst_44082;
var t = inst_43991;
var vec__44077 = inst_44008;
var spot = inst_44101;
var seq__44108 = inst_44112;
var add_flakes = inst_44008;
var root_setting_change_QMARK_ = inst_44023;
var ref_QMARK__map = inst_44020;
var r = inst_44112;
var psot = inst_44102;
var add_pred_to_idx_QMARK_ = inst_44031;
var _ = inst_44006;
var cid = inst_44151;
var ecount = inst_44105;
var vec__44107 = inst_44100;
var pred_ecount = inst_44025;
var db_STAR_ = inst_44072;
var schema_change_QMARK_ = inst_44022;
var G__44076 = inst_44100;
var add_preds = inst_44012;
var opst = inst_44104;
var first__44109 = inst_44111;
var first__44079 = inst_44081;
var idx_QMARK__map = inst_44016;
var post = inst_44103;
var f = inst_44111;
return (function (p1__43981_SHARP_){
if(cljs.core.truth_(p1__43981_SHARP_)){
var x__4295__auto__ = p1__43981_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_44153 = cljs.core.update.call(null,inst_44105,inst_44151,inst_44152);
var inst_44154 = cljs.core.conj.call(null,inst_44101,inst_44111);
var inst_44155 = cljs.core.conj.call(null,inst_44102,inst_44111);
var inst_44156 = inst_44111.p;
var inst_44157 = cljs.core.get.call(null,inst_44016,inst_44156);
var state_44179__$1 = (function (){var statearr_44192 = state_44179;
(statearr_44192[(16)] = inst_44155);

(statearr_44192[(18)] = inst_44154);

(statearr_44192[(19)] = inst_44153);

return statearr_44192;
})();
if(cljs.core.truth_(inst_44157)){
var statearr_44193_44257 = state_44179__$1;
(statearr_44193_44257[(1)] = (34));

} else {
var statearr_44194_44258 = state_44179__$1;
(statearr_44194_44258[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (31))){
var inst_44138 = (state_44179[(35)]);
var state_44179__$1 = state_44179;
var statearr_44195_44259 = state_44179__$1;
(statearr_44195_44259[(2)] = inst_44138);

(statearr_44195_44259[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (32))){
var inst_44148 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
var statearr_44196_44260 = state_44179__$1;
(statearr_44196_44260[(2)] = inst_44148);

(statearr_44196_44260[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (33))){
var inst_44138 = (state_44179[(35)]);
var inst_44143 = (state_44179[(2)]);
var inst_44144 = fluree.db.util.async.throw_err.call(null,inst_44143);
var inst_44145 = cljs.core.assoc.call(null,inst_44138,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_44144);
var state_44179__$1 = state_44179;
var statearr_44197_44261 = state_44179__$1;
(statearr_44197_44261[(2)] = inst_44145);

(statearr_44197_44261[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (13))){
var inst_44008 = (state_44179[(26)]);
var inst_43991 = (state_44179[(28)]);
var inst_44072 = (state_44179[(9)]);
var inst_44021 = (state_44179[(12)]);
var inst_44062 = (state_44179[(2)]);
var inst_44063 = cljs.core.assoc.call(null,inst_44062,new cljs.core.Keyword(null,"t","t",-1397832519),inst_43991);
var inst_44064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44065 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_44066 = (new cljs.core.PersistentVector(null,2,(5),inst_44064,inst_44065,null));
var inst_44067 = cljs.core.update_in.call(null,inst_44063,inst_44066,cljs.core._PLUS_,inst_44021);
var inst_44068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44069 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_44070 = (new cljs.core.PersistentVector(null,2,(5),inst_44068,inst_44069,null));
var inst_44071 = cljs.core.count.call(null,inst_44008);
var inst_44072__$1 = cljs.core.update_in.call(null,inst_44067,inst_44070,cljs.core._PLUS_,inst_44071);
var inst_44080 = cljs.core.seq.call(null,inst_44008);
var inst_44081 = cljs.core.first.call(null,inst_44080);
var inst_44082 = cljs.core.next.call(null,inst_44080);
var inst_44083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44084 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_44085 = (new cljs.core.PersistentVector(null,2,(5),inst_44083,inst_44084,null));
var inst_44086 = cljs.core.get_in.call(null,inst_44072__$1,inst_44085);
var inst_44087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44088 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_44089 = (new cljs.core.PersistentVector(null,2,(5),inst_44087,inst_44088,null));
var inst_44090 = cljs.core.get_in.call(null,inst_44072__$1,inst_44089);
var inst_44091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44092 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_44093 = (new cljs.core.PersistentVector(null,2,(5),inst_44091,inst_44092,null));
var inst_44094 = cljs.core.get_in.call(null,inst_44072__$1,inst_44093);
var inst_44095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44096 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_44097 = (new cljs.core.PersistentVector(null,2,(5),inst_44095,inst_44096,null));
var inst_44098 = cljs.core.get_in.call(null,inst_44072__$1,inst_44097);
var inst_44099 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_44100 = inst_44008;
var inst_44101 = inst_44086;
var inst_44102 = inst_44090;
var inst_44103 = inst_44094;
var inst_44104 = inst_44098;
var inst_44105 = inst_44099;
var state_44179__$1 = (function (){var statearr_44198 = state_44179;
(statearr_44198[(21)] = inst_44100);

(statearr_44198[(25)] = inst_44082);

(statearr_44198[(7)] = inst_44103);

(statearr_44198[(8)] = inst_44104);

(statearr_44198[(9)] = inst_44072__$1);

(statearr_44198[(10)] = inst_44102);

(statearr_44198[(11)] = inst_44105);

(statearr_44198[(14)] = inst_44101);

(statearr_44198[(34)] = inst_44081);

return statearr_44198;
})();
var statearr_44199_44262 = state_44179__$1;
(statearr_44199_44262[(2)] = null);

(statearr_44199_44262[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (22))){
var inst_44172 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
var statearr_44200_44263 = state_44179__$1;
(statearr_44200_44263[(2)] = inst_44172);

(statearr_44200_44263[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (36))){
var inst_44020 = (state_44179[(23)]);
var inst_44111 = (state_44179[(31)]);
var inst_44162 = (state_44179[(2)]);
var inst_44163 = inst_44111.p;
var inst_44164 = cljs.core.get.call(null,inst_44020,inst_44163);
var state_44179__$1 = (function (){var statearr_44201 = state_44179;
(statearr_44201[(20)] = inst_44162);

return statearr_44201;
})();
if(cljs.core.truth_(inst_44164)){
var statearr_44202_44264 = state_44179__$1;
(statearr_44202_44264[(1)] = (37));

} else {
var statearr_44203_44265 = state_44179__$1;
(statearr_44203_44265[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (29))){
var inst_44123 = (state_44179[(15)]);
var inst_44133 = (state_44179[(2)]);
var inst_44134 = fluree.db.util.async.throw_err.call(null,inst_44133);
var inst_44135 = cljs.core.assoc.call(null,inst_44123,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_44134);
var state_44179__$1 = state_44179;
var statearr_44204_44266 = state_44179__$1;
(statearr_44204_44266[(2)] = inst_44135);

(statearr_44204_44266[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (6))){
var inst_43991 = (state_44179[(28)]);
var inst_43996 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_43997 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_43998 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43996)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43997)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43991),"."].join('');
var inst_43999 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44000 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_44001 = cljs.core.PersistentHashMap.fromArrays(inst_43999,inst_44000);
var inst_44002 = cljs.core.ex_info.call(null,inst_43998,inst_44001);
var inst_44003 = (function(){throw inst_44002})();
var state_44179__$1 = state_44179;
var statearr_44205_44267 = state_44179__$1;
(statearr_44205_44267[(2)] = inst_44003);

(statearr_44205_44267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (28))){
var inst_44023 = (state_44179[(29)]);
var inst_44138 = (state_44179[(2)]);
var state_44179__$1 = (function (){var statearr_44206 = state_44179;
(statearr_44206[(35)] = inst_44138);

return statearr_44206;
})();
if(cljs.core.truth_(inst_44023)){
var statearr_44207_44268 = state_44179__$1;
(statearr_44207_44268[(1)] = (30));

} else {
var statearr_44208_44269 = state_44179__$1;
(statearr_44208_44269[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (25))){
var inst_44129 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
if(cljs.core.truth_(inst_44129)){
var statearr_44209_44270 = state_44179__$1;
(statearr_44209_44270[(1)] = (26));

} else {
var statearr_44210_44271 = state_44179__$1;
(statearr_44210_44271[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (34))){
var inst_44103 = (state_44179[(7)]);
var inst_44111 = (state_44179[(31)]);
var inst_44159 = cljs.core.conj.call(null,inst_44103,inst_44111);
var state_44179__$1 = state_44179;
var statearr_44211_44272 = state_44179__$1;
(statearr_44211_44272[(2)] = inst_44159);

(statearr_44211_44272[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (17))){
var inst_44051 = (state_44179[(36)]);
var inst_44055 = (state_44179[(2)]);
var inst_44056 = fluree.db.util.async.throw_err.call(null,inst_44055);
var inst_44043 = inst_44051;
var inst_44044 = inst_44056;
var state_44179__$1 = (function (){var statearr_44212 = state_44179;
(statearr_44212[(22)] = inst_44044);

(statearr_44212[(37)] = inst_44043);

return statearr_44212;
})();
var statearr_44213_44273 = state_44179__$1;
(statearr_44213_44273[(2)] = null);

(statearr_44213_44273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (3))){
var inst_44177 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44179__$1,inst_44177);
} else {
if((state_val_44180 === (12))){
var inst_44050 = (state_44179[(38)]);
var inst_44043 = (state_44179[(37)]);
var inst_44049 = cljs.core.seq.call(null,inst_44043);
var inst_44050__$1 = cljs.core.first.call(null,inst_44049);
var inst_44051 = cljs.core.next.call(null,inst_44049);
var state_44179__$1 = (function (){var statearr_44214 = state_44179;
(statearr_44214[(38)] = inst_44050__$1);

(statearr_44214[(36)] = inst_44051);

return statearr_44214;
})();
if(cljs.core.truth_(inst_44050__$1)){
var statearr_44215_44274 = state_44179__$1;
(statearr_44215_44274[(1)] = (14));

} else {
var statearr_44216_44275 = state_44179__$1;
(statearr_44216_44275[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (2))){
var inst_43991 = (state_44179[(28)]);
var _ = (function (){var statearr_44217 = state_44179;
(statearr_44217[(4)] = cljs.core.cons.call(null,(5),(state_44179[(4)])));

return statearr_44217;
})();
var inst_43990 = cljs.core.first.call(null,flakes);
var inst_43991__$1 = inst_43990.t;
var inst_43992 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_43993 = (inst_43992 - (1));
var inst_43994 = cljs.core.not_EQ_.call(null,inst_43991__$1,inst_43993);
var state_44179__$1 = (function (){var statearr_44218 = state_44179;
(statearr_44218[(28)] = inst_43991__$1);

return statearr_44218;
})();
if(inst_43994){
var statearr_44219_44276 = state_44179__$1;
(statearr_44219_44276[(1)] = (6));

} else {
var statearr_44220_44277 = state_44179__$1;
(statearr_44220_44277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (23))){
var inst_44022 = (state_44179[(13)]);
var state_44179__$1 = state_44179;
var statearr_44221_44278 = state_44179__$1;
(statearr_44221_44278[(2)] = inst_44022);

(statearr_44221_44278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (35))){
var inst_44103 = (state_44179[(7)]);
var state_44179__$1 = state_44179;
var statearr_44222_44279 = state_44179__$1;
(statearr_44222_44279[(2)] = inst_44103);

(statearr_44222_44279[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (19))){
var inst_44174 = (state_44179[(2)]);
var _ = (function (){var statearr_44223 = state_44179;
(statearr_44223[(4)] = cljs.core.rest.call(null,(state_44179[(4)])));

return statearr_44223;
})();
var state_44179__$1 = state_44179;
var statearr_44224_44280 = state_44179__$1;
(statearr_44224_44280[(2)] = inst_44174);

(statearr_44224_44280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (11))){
var inst_44031 = (state_44179[(27)]);
var inst_44031__$1 = (state_44179[(2)]);
var inst_44039 = cljs.core.seq.call(null,inst_44031__$1);
var inst_44040 = cljs.core.first.call(null,inst_44039);
var inst_44041 = cljs.core.next.call(null,inst_44039);
var inst_44042 = db;
var inst_44043 = inst_44031__$1;
var inst_44044 = inst_44042;
var state_44179__$1 = (function (){var statearr_44226 = state_44179;
(statearr_44226[(27)] = inst_44031__$1);

(statearr_44226[(22)] = inst_44044);

(statearr_44226[(39)] = inst_44040);

(statearr_44226[(40)] = inst_44041);

(statearr_44226[(37)] = inst_44043);

return statearr_44226;
})();
var statearr_44227_44281 = state_44179__$1;
(statearr_44227_44281[(2)] = null);

(statearr_44227_44281[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (9))){
var inst_44025 = (state_44179[(24)]);
var inst_44008 = (state_44179[(26)]);
var inst_44027 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_44008,inst_44025);
var state_44179__$1 = state_44179;
var statearr_44228_44282 = state_44179__$1;
(statearr_44228_44282[(2)] = inst_44027);

(statearr_44228_44282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (5))){
var _ = (function (){var statearr_44229 = state_44179;
(statearr_44229[(4)] = cljs.core.rest.call(null,(state_44179[(4)])));

return statearr_44229;
})();
var state_44179__$1 = state_44179;
var ex44225 = (state_44179__$1[(2)]);
var statearr_44230_44283 = state_44179__$1;
(statearr_44230_44283[(5)] = ex44225);


if((ex44225 instanceof Error)){
var statearr_44231_44284 = state_44179__$1;
(statearr_44231_44284[(1)] = (4));

(statearr_44231_44284[(5)] = null);

} else {
throw ex44225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (14))){
var inst_44050 = (state_44179[(38)]);
var inst_44044 = (state_44179[(22)]);
var inst_44053 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_44044,inst_44050,opts);
var state_44179__$1 = state_44179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44179__$1,(17),inst_44053);
} else {
if((state_val_44180 === (26))){
var inst_44123 = (state_44179[(15)]);
var inst_44131 = fluree.db.query.schema.schema_map.call(null,inst_44123);
var state_44179__$1 = state_44179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44179__$1,(29),inst_44131);
} else {
if((state_val_44180 === (16))){
var inst_44060 = (state_44179[(2)]);
var state_44179__$1 = state_44179;
var statearr_44232_44285 = state_44179__$1;
(statearr_44232_44285[(2)] = inst_44060);

(statearr_44232_44285[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (38))){
var inst_44104 = (state_44179[(8)]);
var state_44179__$1 = state_44179;
var statearr_44233_44286 = state_44179__$1;
(statearr_44233_44286[(2)] = inst_44104);

(statearr_44233_44286[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (30))){
var inst_44138 = (state_44179[(35)]);
var inst_44141 = fluree.db.query.schema.setting_map.call(null,inst_44138);
var state_44179__$1 = state_44179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44179__$1,(33),inst_44141);
} else {
if((state_val_44180 === (10))){
var inst_44029 = cljs.core.PersistentVector.EMPTY;
var state_44179__$1 = state_44179;
var statearr_44234_44287 = state_44179__$1;
(statearr_44234_44287[(2)] = inst_44029);

(statearr_44234_44287[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (18))){
var inst_44100 = (state_44179[(21)]);
var inst_44111 = (state_44179[(31)]);
var inst_44110 = cljs.core.seq.call(null,inst_44100);
var inst_44111__$1 = cljs.core.first.call(null,inst_44110);
var inst_44112 = cljs.core.next.call(null,inst_44110);
var inst_44113 = cljs.core.not.call(null,inst_44111__$1);
var state_44179__$1 = (function (){var statearr_44235 = state_44179;
(statearr_44235[(17)] = inst_44112);

(statearr_44235[(31)] = inst_44111__$1);

return statearr_44235;
})();
if(inst_44113){
var statearr_44236_44288 = state_44179__$1;
(statearr_44236_44288[(1)] = (20));

} else {
var statearr_44237_44289 = state_44179__$1;
(statearr_44237_44289[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (37))){
var inst_44104 = (state_44179[(8)]);
var inst_44111 = (state_44179[(31)]);
var inst_44166 = cljs.core.conj.call(null,inst_44104,inst_44111);
var state_44179__$1 = state_44179;
var statearr_44238_44290 = state_44179__$1;
(statearr_44238_44290[(2)] = inst_44166);

(statearr_44238_44290[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44180 === (8))){
var inst_44008 = (state_44179[(26)]);
var inst_43991 = (state_44179[(28)]);
var inst_44012 = (state_44179[(30)]);
var inst_44022 = (state_44179[(13)]);
var inst_44006 = (state_44179[(32)]);
var inst_44016 = (state_44179[(33)]);
var inst_44006__$1 = (state_44179[(2)]);
var inst_44007 = (function (){var t = inst_43991;
var _ = inst_44006__$1;
return (function (p1__43979_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__43979_SHARP_.p));
});
})();
var inst_44008__$1 = cljs.core.filter.call(null,inst_44007,flakes);
var inst_44009 = cljs.core.PersistentHashSet.EMPTY;
var inst_44010 = (function (){var t = inst_43991;
var _ = inst_44006__$1;
var add_flakes = inst_44008__$1;
return (function (p1__43980_SHARP_){
return p1__43980_SHARP_.p;
});
})();
var inst_44011 = cljs.core.map.call(null,inst_44010,inst_44008__$1);
var inst_44012__$1 = cljs.core.into.call(null,inst_44009,inst_44011);
var inst_44013 = cljs.core.PersistentHashMap.EMPTY;
var inst_44014 = (function (){var t = inst_43991;
var _ = inst_44006__$1;
var add_flakes = inst_44008__$1;
var add_preds = inst_44012__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_44015 = cljs.core.map.call(null,inst_44014,inst_44012__$1);
var inst_44016__$1 = cljs.core.into.call(null,inst_44013,inst_44015);
var inst_44017 = cljs.core.PersistentHashMap.EMPTY;
var inst_44018 = (function (){var t = inst_43991;
var _ = inst_44006__$1;
var add_flakes = inst_44008__$1;
var add_preds = inst_44012__$1;
var idx_QMARK__map = inst_44016__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_44019 = cljs.core.map.call(null,inst_44018,inst_44012__$1);
var inst_44020 = cljs.core.into.call(null,inst_44017,inst_44019);
var inst_44021 = fluree.db.flake.size_bytes.call(null,inst_44008__$1);
var inst_44022__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_44008__$1);
var inst_44023 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_44008__$1);
var inst_44024 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_44025 = cljs.core.get.call(null,inst_44024,(0));
var state_44179__$1 = (function (){var statearr_44239 = state_44179;
(statearr_44239[(23)] = inst_44020);

(statearr_44239[(24)] = inst_44025);

(statearr_44239[(26)] = inst_44008__$1);

(statearr_44239[(12)] = inst_44021);

(statearr_44239[(29)] = inst_44023);

(statearr_44239[(30)] = inst_44012__$1);

(statearr_44239[(13)] = inst_44022__$1);

(statearr_44239[(32)] = inst_44006__$1);

(statearr_44239[(33)] = inst_44016__$1);

return statearr_44239;
})();
if(cljs.core.truth_(inst_44022__$1)){
var statearr_44240_44291 = state_44179__$1;
(statearr_44240_44291[(1)] = (9));

} else {
var statearr_44241_44292 = state_44179__$1;
(statearr_44241_44292[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_44242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44242[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_44242[(1)] = (1));

return statearr_44242;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_44179){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44243){var ex__16224__auto__ = e44243;
var statearr_44244_44293 = state_44179;
(statearr_44244_44293[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44179[(4)]))){
var statearr_44245_44294 = state_44179;
(statearr_44245_44294[(1)] = cljs.core.first.call(null,(state_44179[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44295 = state_44179;
state_44179 = G__44295;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_44179){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_44179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44246 = f__16346__auto__.call(null);
(statearr_44246[(6)] = c__16345__auto__);

return statearr_44246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__44297 = arguments.length;
switch (G__44297) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__16345__auto___44444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44393){
var state_val_44394 = (state_44393[(1)]);
if((state_val_44394 === (7))){
var state_44393__$1 = state_44393;
var statearr_44395_44445 = state_44393__$1;
(statearr_44395_44445[(2)] = null);

(statearr_44395_44445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (20))){
var inst_44343 = (state_44393[(7)]);
var inst_44341 = (state_44393[(8)]);
var inst_44342 = (state_44393[(9)]);
var inst_44362 = (inst_44341 + (1));
var inst_44363 = cljs.core.assoc.call(null,inst_44343,new cljs.core.Keyword(null,"t","t",-1397832519),inst_44362);
var inst_44364 = fluree.db.graphdb.with_t.call(null,inst_44363,inst_44342,opts);
var state_44393__$1 = state_44393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44393__$1,(23),inst_44364);
} else {
if((state_val_44394 === (1))){
var state_44393__$1 = state_44393;
var statearr_44396_44446 = state_44393__$1;
(statearr_44396_44446[(2)] = null);

(statearr_44396_44446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (24))){
var inst_44367 = (state_44393[(10)]);
var inst_44370 = cljs.core.assoc.call(null,inst_44367,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_44393__$1 = state_44393;
var statearr_44397_44447 = state_44393__$1;
(statearr_44397_44447[(2)] = inst_44370);

(statearr_44397_44447[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (4))){
var inst_44298 = (state_44393[(2)]);
var inst_44299 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_44298);
var state_44393__$1 = state_44393;
var statearr_44398_44448 = state_44393__$1;
(statearr_44398_44448[(2)] = inst_44299);

(statearr_44398_44448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (15))){
var inst_44349 = (state_44393[(11)]);
var state_44393__$1 = state_44393;
var statearr_44399_44449 = state_44393__$1;
(statearr_44399_44449[(2)] = inst_44349);

(statearr_44399_44449[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (21))){
var state_44393__$1 = state_44393;
var statearr_44400_44450 = state_44393__$1;
(statearr_44400_44450[(2)] = null);

(statearr_44400_44450[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (13))){
var inst_44385 = (state_44393[(2)]);
var inst_44386 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_44385);
var state_44393__$1 = state_44393;
var statearr_44401_44451 = state_44393__$1;
(statearr_44401_44451[(2)] = inst_44386);

(statearr_44401_44451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (22))){
var inst_44381 = (state_44393[(2)]);
var state_44393__$1 = state_44393;
var statearr_44402_44452 = state_44393__$1;
(statearr_44402_44452[(2)] = inst_44381);

(statearr_44402_44452[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (6))){
var inst_44309 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_44310 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_44311 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44309)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44310)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_44312 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44313 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_44314 = cljs.core.PersistentHashMap.fromArrays(inst_44312,inst_44313);
var inst_44315 = cljs.core.ex_info.call(null,inst_44311,inst_44314);
var inst_44316 = (function(){throw inst_44315})();
var state_44393__$1 = state_44393;
var statearr_44405_44453 = state_44393__$1;
(statearr_44405_44453[(2)] = inst_44316);

(statearr_44405_44453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (25))){
var inst_44349 = (state_44393[(11)]);
var inst_44367 = (state_44393[(10)]);
var inst_44350 = (state_44393[(12)]);
var inst_44372 = inst_44349.t;
var inst_44373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44374 = [inst_44349];
var inst_44375 = (new cljs.core.PersistentVector(null,1,(5),inst_44373,inst_44374,null));
var inst_44340 = inst_44350;
var inst_44341 = inst_44372;
var inst_44342 = inst_44375;
var inst_44343 = inst_44367;
var state_44393__$1 = (function (){var statearr_44406 = state_44393;
(statearr_44406[(7)] = inst_44343);

(statearr_44406[(8)] = inst_44341);

(statearr_44406[(9)] = inst_44342);

(statearr_44406[(13)] = inst_44340);

return statearr_44406;
})();
var statearr_44407_44454 = state_44393__$1;
(statearr_44407_44454[(2)] = null);

(statearr_44407_44454[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (17))){
var inst_44343 = (state_44393[(7)]);
var inst_44341 = (state_44393[(8)]);
var inst_44342 = (state_44393[(9)]);
var inst_44349 = (state_44393[(11)]);
var inst_44350 = (state_44393[(12)]);
var inst_44358 = cljs.core.conj.call(null,inst_44342,inst_44349);
var tmp44403 = inst_44343;
var tmp44404 = inst_44341;
var inst_44340 = inst_44350;
var inst_44341__$1 = tmp44404;
var inst_44342__$1 = inst_44358;
var inst_44343__$1 = tmp44403;
var state_44393__$1 = (function (){var statearr_44408 = state_44393;
(statearr_44408[(7)] = inst_44343__$1);

(statearr_44408[(8)] = inst_44341__$1);

(statearr_44408[(9)] = inst_44342__$1);

(statearr_44408[(13)] = inst_44340);

return statearr_44408;
})();
var statearr_44409_44455 = state_44393__$1;
(statearr_44409_44455[(2)] = null);

(statearr_44409_44455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (3))){
var inst_44391 = (state_44393[(2)]);
var state_44393__$1 = state_44393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44393__$1,inst_44391);
} else {
if((state_val_44394 === (12))){
var inst_44349 = (state_44393[(11)]);
var inst_44340 = (state_44393[(13)]);
var inst_44348 = cljs.core.seq.call(null,inst_44340);
var inst_44349__$1 = cljs.core.first.call(null,inst_44348);
var inst_44350 = cljs.core.next.call(null,inst_44348);
var state_44393__$1 = (function (){var statearr_44410 = state_44393;
(statearr_44410[(11)] = inst_44349__$1);

(statearr_44410[(12)] = inst_44350);

return statearr_44410;
})();
if(cljs.core.truth_(inst_44349__$1)){
var statearr_44411_44456 = state_44393__$1;
(statearr_44411_44456[(1)] = (14));

} else {
var statearr_44412_44457 = state_44393__$1;
(statearr_44412_44457[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (2))){
var _ = (function (){var statearr_44413 = state_44393;
(statearr_44413[(4)] = cljs.core.cons.call(null,(5),(state_44393[(4)])));

return statearr_44413;
})();
var inst_44305 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_44306 = (inst_44305 + (1));
var inst_44307 = cljs.core.not_EQ_.call(null,block,inst_44306);
var state_44393__$1 = state_44393;
if(inst_44307){
var statearr_44414_44458 = state_44393__$1;
(statearr_44414_44458[(1)] = (6));

} else {
var statearr_44415_44459 = state_44393__$1;
(statearr_44415_44459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (23))){
var inst_44349 = (state_44393[(11)]);
var inst_44366 = (state_44393[(2)]);
var inst_44367 = fluree.db.util.async.throw_err.call(null,inst_44366);
var inst_44368 = (inst_44349 == null);
var state_44393__$1 = (function (){var statearr_44416 = state_44393;
(statearr_44416[(10)] = inst_44367);

return statearr_44416;
})();
if(cljs.core.truth_(inst_44368)){
var statearr_44417_44460 = state_44393__$1;
(statearr_44417_44460[(1)] = (24));

} else {
var statearr_44418_44461 = state_44393__$1;
(statearr_44418_44461[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (19))){
var inst_44383 = (state_44393[(2)]);
var state_44393__$1 = state_44393;
var statearr_44419_44462 = state_44393__$1;
(statearr_44419_44462[(2)] = inst_44383);

(statearr_44419_44462[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (11))){
var inst_44388 = (state_44393[(2)]);
var _ = (function (){var statearr_44421 = state_44393;
(statearr_44421[(4)] = cljs.core.rest.call(null,(state_44393[(4)])));

return statearr_44421;
})();
var state_44393__$1 = state_44393;
var statearr_44422_44463 = state_44393__$1;
(statearr_44422_44463[(2)] = inst_44388);

(statearr_44422_44463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (9))){
var inst_44322 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_44323 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_44322);
var state_44393__$1 = state_44393;
var statearr_44423_44464 = state_44393__$1;
(statearr_44423_44464[(2)] = inst_44323);

(statearr_44423_44464[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (5))){
var _ = (function (){var statearr_44424 = state_44393;
(statearr_44424[(4)] = cljs.core.rest.call(null,(state_44393[(4)])));

return statearr_44424;
})();
var state_44393__$1 = state_44393;
var ex44420 = (state_44393__$1[(2)]);
var statearr_44425_44465 = state_44393__$1;
(statearr_44425_44465[(5)] = ex44420);


var statearr_44426_44466 = state_44393__$1;
(statearr_44426_44466[(1)] = (4));

(statearr_44426_44466[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (14))){
var inst_44341 = (state_44393[(8)]);
var inst_44349 = (state_44393[(11)]);
var inst_44352 = inst_44349.t;
var inst_44353 = cljs.core._EQ_.call(null,inst_44341,inst_44352);
var state_44393__$1 = state_44393;
var statearr_44427_44467 = state_44393__$1;
(statearr_44427_44467[(2)] = inst_44353);

(statearr_44427_44467[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (26))){
var inst_44378 = (state_44393[(2)]);
var state_44393__$1 = state_44393;
var statearr_44428_44468 = state_44393__$1;
(statearr_44428_44468[(2)] = inst_44378);

(statearr_44428_44468[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (16))){
var inst_44356 = (state_44393[(2)]);
var state_44393__$1 = state_44393;
if(cljs.core.truth_(inst_44356)){
var statearr_44429_44469 = state_44393__$1;
(statearr_44429_44469[(1)] = (17));

} else {
var statearr_44430_44470 = state_44393__$1;
(statearr_44430_44470[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (10))){
var inst_44325 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_44326 = cljs.core.first.call(null,inst_44325);
var inst_44334 = cljs.core.seq.call(null,inst_44325);
var inst_44335 = cljs.core.first.call(null,inst_44334);
var inst_44336 = cljs.core.next.call(null,inst_44334);
var inst_44337 = inst_44326.t;
var inst_44338 = cljs.core.PersistentVector.EMPTY;
var inst_44339 = db;
var inst_44340 = inst_44325;
var inst_44341 = inst_44337;
var inst_44342 = inst_44338;
var inst_44343 = inst_44339;
var state_44393__$1 = (function (){var statearr_44431 = state_44393;
(statearr_44431[(7)] = inst_44343);

(statearr_44431[(8)] = inst_44341);

(statearr_44431[(9)] = inst_44342);

(statearr_44431[(14)] = inst_44336);

(statearr_44431[(15)] = inst_44335);

(statearr_44431[(13)] = inst_44340);

return statearr_44431;
})();
var statearr_44432_44471 = state_44393__$1;
(statearr_44432_44471[(2)] = null);

(statearr_44432_44471[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (18))){
var state_44393__$1 = state_44393;
var statearr_44433_44472 = state_44393__$1;
(statearr_44433_44472[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44394 === (8))){
var inst_44319 = (state_44393[(2)]);
var inst_44320 = cljs.core.empty_QMARK_.call(null,flakes);
var state_44393__$1 = (function (){var statearr_44435 = state_44393;
(statearr_44435[(16)] = inst_44319);

return statearr_44435;
})();
if(inst_44320){
var statearr_44436_44473 = state_44393__$1;
(statearr_44436_44473[(1)] = (9));

} else {
var statearr_44437_44474 = state_44393__$1;
(statearr_44437_44474[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_44438 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44438[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_44438[(1)] = (1));

return statearr_44438;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_44393){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44439){var ex__16224__auto__ = e44439;
var statearr_44440_44475 = state_44393;
(statearr_44440_44475[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44393[(4)]))){
var statearr_44441_44476 = state_44393;
(statearr_44441_44476[(1)] = cljs.core.first.call(null,(state_44393[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44477 = state_44393;
state_44393 = G__44477;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_44393){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_44393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44442 = f__16346__auto__.call(null);
(statearr_44442[(6)] = c__16345__auto___44444);

return statearr_44442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44533){
var state_val_44534 = (state_44533[(1)]);
if((state_val_44534 === (7))){
var state_44533__$1 = state_44533;
var statearr_44535_44562 = state_44533__$1;
(statearr_44535_44562[(2)] = tt_id);

(statearr_44535_44562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (1))){
var state_44533__$1 = state_44533;
var statearr_44536_44563 = state_44533__$1;
(statearr_44536_44563[(2)] = null);

(statearr_44536_44563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (4))){
var inst_44478 = (state_44533[(2)]);
var state_44533__$1 = state_44533;
var statearr_44537_44564 = state_44533__$1;
(statearr_44537_44564[(2)] = inst_44478);

(statearr_44537_44564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (13))){
var inst_44526 = (state_44533[(2)]);
var state_44533__$1 = state_44533;
var statearr_44538_44565 = state_44533__$1;
(statearr_44538_44565[(2)] = inst_44526);

(statearr_44538_44565[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (6))){
var inst_44486 = fluree.db.util.core.random_uuid.call(null);
var state_44533__$1 = state_44533;
var statearr_44539_44566 = state_44533__$1;
(statearr_44539_44566[(2)] = inst_44486);

(statearr_44539_44566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (3))){
var inst_44531 = (state_44533[(2)]);
var state_44533__$1 = state_44533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44533__$1,inst_44531);
} else {
if((state_val_44534 === (12))){
var inst_44509 = (state_44533[(7)]);
var state_44533__$1 = state_44533;
var statearr_44540_44567 = state_44533__$1;
(statearr_44540_44567[(2)] = inst_44509);

(statearr_44540_44567[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (2))){
var _ = (function (){var statearr_44541 = state_44533;
(statearr_44541[(4)] = cljs.core.cons.call(null,(5),(state_44533[(4)])));

return statearr_44541;
})();
var inst_44484 = (tt_id == null);
var state_44533__$1 = state_44533;
if(cljs.core.truth_(inst_44484)){
var statearr_44542_44568 = state_44533__$1;
(statearr_44542_44568[(1)] = (6));

} else {
var statearr_44543_44569 = state_44533__$1;
(statearr_44543_44569[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (11))){
var inst_44509 = (state_44533[(7)]);
var inst_44516 = (state_44533[(8)]);
var inst_44519 = fluree.db.graphdb.with_t.call(null,inst_44509,inst_44516);
var state_44533__$1 = state_44533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44533__$1,(14),inst_44519);
} else {
if((state_val_44534 === (9))){
var inst_44516 = (state_44533[(8)]);
var inst_44510 = (state_44533[(9)]);
var inst_44515 = cljs.core.seq.call(null,inst_44510);
var inst_44516__$1 = cljs.core.first.call(null,inst_44515);
var inst_44517 = cljs.core.next.call(null,inst_44515);
var state_44533__$1 = (function (){var statearr_44545 = state_44533;
(statearr_44545[(10)] = inst_44517);

(statearr_44545[(8)] = inst_44516__$1);

return statearr_44545;
})();
if(cljs.core.truth_(inst_44516__$1)){
var statearr_44546_44570 = state_44533__$1;
(statearr_44546_44570[(1)] = (11));

} else {
var statearr_44547_44571 = state_44533__$1;
(statearr_44547_44571[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (5))){
var _ = (function (){var statearr_44548 = state_44533;
(statearr_44548[(4)] = cljs.core.rest.call(null,(state_44533[(4)])));

return statearr_44548;
})();
var state_44533__$1 = state_44533;
var ex44544 = (state_44533__$1[(2)]);
var statearr_44549_44572 = state_44533__$1;
(statearr_44549_44572[(5)] = ex44544);


if((ex44544 instanceof Error)){
var statearr_44550_44573 = state_44533__$1;
(statearr_44550_44573[(1)] = (4));

(statearr_44550_44573[(5)] = null);

} else {
throw ex44544;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (14))){
var inst_44517 = (state_44533[(10)]);
var inst_44521 = (state_44533[(2)]);
var inst_44522 = fluree.db.util.async.throw_err.call(null,inst_44521);
var inst_44509 = inst_44522;
var inst_44510 = inst_44517;
var state_44533__$1 = (function (){var statearr_44551 = state_44533;
(statearr_44551[(7)] = inst_44509);

(statearr_44551[(9)] = inst_44510);

return statearr_44551;
})();
var statearr_44552_44574 = state_44533__$1;
(statearr_44552_44574[(2)] = null);

(statearr_44552_44574[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (10))){
var inst_44528 = (state_44533[(2)]);
var _ = (function (){var statearr_44553 = state_44533;
(statearr_44553[(4)] = cljs.core.rest.call(null,(state_44533[(4)])));

return statearr_44553;
})();
var state_44533__$1 = state_44533;
var statearr_44554_44575 = state_44533__$1;
(statearr_44554_44575[(2)] = inst_44528);

(statearr_44554_44575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44534 === (8))){
var inst_44489 = (state_44533[(2)]);
var inst_44490 = (function (){var tt_id_SINGLEQUOTE_ = inst_44489;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_44491 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_44489);
var inst_44492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44493 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_44494 = (new cljs.core.PersistentVector(null,4,(5),inst_44492,inst_44493,null));
var inst_44495 = cljs.core.reduce.call(null,inst_44490,inst_44491,inst_44494);
var inst_44496 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_44497 = cljs.core.reverse.call(null,inst_44496);
var inst_44498 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_44497);
var inst_44506 = cljs.core.seq.call(null,inst_44498);
var inst_44507 = cljs.core.first.call(null,inst_44506);
var inst_44508 = cljs.core.next.call(null,inst_44506);
var inst_44509 = inst_44495;
var inst_44510 = inst_44498;
var state_44533__$1 = (function (){var statearr_44555 = state_44533;
(statearr_44555[(11)] = inst_44507);

(statearr_44555[(7)] = inst_44509);

(statearr_44555[(12)] = inst_44508);

(statearr_44555[(9)] = inst_44510);

return statearr_44555;
})();
var statearr_44556_44576 = state_44533__$1;
(statearr_44556_44576[(2)] = null);

(statearr_44556_44576[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____0 = (function (){
var statearr_44557 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44557[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__);

(statearr_44557[(1)] = (1));

return statearr_44557;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____1 = (function (state_44533){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44558){var ex__16224__auto__ = e44558;
var statearr_44559_44577 = state_44533;
(statearr_44559_44577[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44533[(4)]))){
var statearr_44560_44578 = state_44533;
(statearr_44560_44578[(1)] = cljs.core.first.call(null,(state_44533[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44579 = state_44533;
state_44533 = G__44579;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__ = function(state_44533){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____1.call(this,state_44533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44561 = f__16346__auto__.call(null);
(statearr_44561[(6)] = c__16345__auto__);

return statearr_44561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__16345__auto___44766 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44697){
var state_val_44698 = (state_44697[(1)]);
if((state_val_44698 === (7))){
var inst_44607 = (state_44697[(7)]);
var inst_44607__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_44697__$1 = (function (){var statearr_44699 = state_44697;
(statearr_44699[(7)] = inst_44607__$1);

return statearr_44699;
})();
if(inst_44607__$1){
var statearr_44700_44767 = state_44697__$1;
(statearr_44700_44767[(1)] = (13));

} else {
var statearr_44701_44768 = state_44697__$1;
(statearr_44701_44768[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (20))){
var state_44697__$1 = state_44697;
var statearr_44702_44769 = state_44697__$1;
(statearr_44702_44769[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (27))){
var inst_44643 = (state_44697[(8)]);
var inst_44647 = inst_44643.s;
var state_44697__$1 = state_44697;
var statearr_44704_44770 = state_44697__$1;
(statearr_44704_44770[(2)] = inst_44647);

(statearr_44704_44770[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (1))){
var state_44697__$1 = state_44697;
var statearr_44705_44771 = state_44697__$1;
(statearr_44705_44771[(2)] = null);

(statearr_44705_44771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (24))){
var inst_44637 = (state_44697[(9)]);
var inst_44641 = cljs.core.first.call(null,inst_44637);
var state_44697__$1 = state_44697;
var statearr_44706_44772 = state_44697__$1;
(statearr_44706_44772[(2)] = inst_44641);

(statearr_44706_44772[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (39))){
var state_44697__$1 = state_44697;
var statearr_44707_44773 = state_44697__$1;
(statearr_44707_44773[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (4))){
var inst_44580 = (state_44697[(2)]);
var inst_44581 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_44582 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44583 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_44584 = cljs.core.PersistentHashMap.fromArrays(inst_44582,inst_44583);
var inst_44585 = cljs.core.ex_info.call(null,inst_44581,inst_44584,inst_44580);
var inst_44586 = cljs.core.async.put_BANG_.call(null,return_chan,inst_44585);
var state_44697__$1 = state_44697;
var statearr_44709_44774 = state_44697__$1;
(statearr_44709_44774[(2)] = inst_44586);

(statearr_44709_44774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (15))){
var inst_44614 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
if(cljs.core.truth_(inst_44614)){
var statearr_44710_44775 = state_44697__$1;
(statearr_44710_44775[(1)] = (16));

} else {
var statearr_44711_44776 = state_44697__$1;
(statearr_44711_44776[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (21))){
var inst_44663 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44712_44777 = state_44697__$1;
(statearr_44712_44777[(2)] = inst_44663);

(statearr_44712_44777[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (31))){
var inst_44661 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44713_44778 = state_44697__$1;
(statearr_44713_44778[(2)] = inst_44661);

(statearr_44713_44778[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (32))){
var inst_44667 = (state_44697[(10)]);
var inst_44669 = cljs.core.async.put_BANG_.call(null,return_chan,inst_44667);
var state_44697__$1 = state_44697;
var statearr_44714_44779 = state_44697__$1;
(statearr_44714_44779[(2)] = inst_44669);

(statearr_44714_44779[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (40))){
var inst_44690 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44715_44780 = state_44697__$1;
(statearr_44715_44780[(2)] = inst_44690);

(statearr_44715_44780[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (33))){
var inst_44671 = (state_44697[(11)]);
var inst_44667 = (state_44697[(10)]);
var inst_44671__$1 = (inst_44667 == null);
var state_44697__$1 = (function (){var statearr_44716 = state_44697;
(statearr_44716[(11)] = inst_44671__$1);

return statearr_44716;
})();
if(cljs.core.truth_(inst_44671__$1)){
var statearr_44717_44781 = state_44697__$1;
(statearr_44717_44781[(1)] = (35));

} else {
var statearr_44718_44782 = state_44697__$1;
(statearr_44718_44782[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (13))){
var inst_44609 = cljs.core.first.call(null,ident);
var inst_44610 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_44609);
var inst_44611 = (inst_44610 == null);
var state_44697__$1 = state_44697;
var statearr_44719_44783 = state_44697__$1;
(statearr_44719_44783[(2)] = inst_44611);

(statearr_44719_44783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (22))){
var inst_44637 = (state_44697[(9)]);
var inst_44636 = (state_44697[(2)]);
var inst_44637__$1 = fluree.db.util.async.throw_err.call(null,inst_44636);
var inst_44638 = (inst_44637__$1 == null);
var state_44697__$1 = (function (){var statearr_44720 = state_44697;
(statearr_44720[(9)] = inst_44637__$1);

return statearr_44720;
})();
if(cljs.core.truth_(inst_44638)){
var statearr_44721_44784 = state_44697__$1;
(statearr_44721_44784[(1)] = (23));

} else {
var statearr_44722_44785 = state_44697__$1;
(statearr_44722_44785[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (36))){
var inst_44671 = (state_44697[(11)]);
var state_44697__$1 = state_44697;
var statearr_44723_44786 = state_44697__$1;
(statearr_44723_44786[(2)] = inst_44671);

(statearr_44723_44786[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (41))){
var inst_44685 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_44697__$1 = state_44697;
var statearr_44724_44787 = state_44697__$1;
(statearr_44724_44787[(2)] = inst_44685);

(statearr_44724_44787[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (43))){
var inst_44688 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44725_44788 = state_44697__$1;
(statearr_44725_44788[(2)] = inst_44688);

(statearr_44725_44788[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (29))){
var inst_44652 = cljs.core.pr_str.call(null,ident);
var inst_44653 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_44652].join('');
var inst_44654 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44655 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_44656 = cljs.core.PersistentHashMap.fromArrays(inst_44654,inst_44655);
var inst_44657 = cljs.core.ex_info.call(null,inst_44653,inst_44656);
var inst_44658 = (function(){throw inst_44657})();
var state_44697__$1 = state_44697;
var statearr_44726_44789 = state_44697__$1;
(statearr_44726_44789[(2)] = inst_44658);

(statearr_44726_44789[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (6))){
var inst_44594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44595 = [ident];
var inst_44596 = (new cljs.core.PersistentVector(null,1,(5),inst_44594,inst_44595,null));
var inst_44597 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_44596);
var state_44697__$1 = state_44697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44697__$1,(9),inst_44597);
} else {
if((state_val_44698 === (28))){
var inst_44649 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44727_44790 = state_44697__$1;
(statearr_44727_44790[(2)] = inst_44649);

(statearr_44727_44790[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (25))){
var inst_44643 = (state_44697[(8)]);
var inst_44643__$1 = (state_44697[(2)]);
var inst_44644 = (inst_44643__$1 == null);
var state_44697__$1 = (function (){var statearr_44728 = state_44697;
(statearr_44728[(8)] = inst_44643__$1);

return statearr_44728;
})();
if(cljs.core.truth_(inst_44644)){
var statearr_44729_44791 = state_44697__$1;
(statearr_44729_44791[(1)] = (26));

} else {
var statearr_44730_44792 = state_44697__$1;
(statearr_44730_44792[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (34))){
var inst_44692 = (state_44697[(2)]);
var _ = (function (){var statearr_44731 = state_44697;
(statearr_44731[(4)] = cljs.core.rest.call(null,(state_44697[(4)])));

return statearr_44731;
})();
var state_44697__$1 = state_44697;
var statearr_44732_44793 = state_44697__$1;
(statearr_44732_44793[(2)] = inst_44692);

(statearr_44732_44793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (17))){
var inst_44625 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_44697__$1 = state_44697;
if(inst_44625){
var statearr_44733_44794 = state_44697__$1;
(statearr_44733_44794[(1)] = (19));

} else {
var statearr_44734_44795 = state_44697__$1;
(statearr_44734_44795[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (3))){
var inst_44695 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44697__$1,inst_44695);
} else {
if((state_val_44698 === (12))){
var inst_44605 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44735_44796 = state_44697__$1;
(statearr_44735_44796[(2)] = inst_44605);

(statearr_44735_44796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (2))){
var _ = (function (){var statearr_44736 = state_44697;
(statearr_44736[(4)] = cljs.core.cons.call(null,(5),(state_44697[(4)])));

return statearr_44736;
})();
var inst_44592 = typeof ident === 'number';
var state_44697__$1 = state_44697;
if(cljs.core.truth_(inst_44592)){
var statearr_44737_44797 = state_44697__$1;
(statearr_44737_44797[(1)] = (6));

} else {
var statearr_44738_44798 = state_44697__$1;
(statearr_44738_44798[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (23))){
var state_44697__$1 = state_44697;
var statearr_44739_44799 = state_44697__$1;
(statearr_44739_44799[(2)] = null);

(statearr_44739_44799[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (35))){
var state_44697__$1 = state_44697;
var statearr_44740_44800 = state_44697__$1;
(statearr_44740_44800[(2)] = strict_QMARK_);

(statearr_44740_44800[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (19))){
var inst_44628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44629 = cljs.core.first.call(null,ident);
var inst_44630 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_44629);
var inst_44631 = cljs.core.second.call(null,ident);
var inst_44632 = [inst_44630,inst_44631];
var inst_44633 = (new cljs.core.PersistentVector(null,2,(5),inst_44628,inst_44632,null));
var inst_44634 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_44633);
var state_44697__$1 = state_44697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44697__$1,(22),inst_44634);
} else {
if((state_val_44698 === (11))){
var state_44697__$1 = state_44697;
var statearr_44742_44801 = state_44697__$1;
(statearr_44742_44801[(2)] = null);

(statearr_44742_44801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (9))){
var inst_44599 = (state_44697[(2)]);
var inst_44600 = fluree.db.util.async.throw_err.call(null,inst_44599);
var inst_44601 = cljs.core.not_empty.call(null,inst_44600);
var state_44697__$1 = state_44697;
if(cljs.core.truth_(inst_44601)){
var statearr_44743_44802 = state_44697__$1;
(statearr_44743_44802[(1)] = (10));

} else {
var statearr_44744_44803 = state_44697__$1;
(statearr_44744_44803[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (5))){
var _ = (function (){var statearr_44745 = state_44697;
(statearr_44745[(4)] = cljs.core.rest.call(null,(state_44697[(4)])));

return statearr_44745;
})();
var state_44697__$1 = state_44697;
var ex44741 = (state_44697__$1[(2)]);
var statearr_44746_44804 = state_44697__$1;
(statearr_44746_44804[(5)] = ex44741);


var statearr_44747_44805 = state_44697__$1;
(statearr_44747_44805[(1)] = (4));

(statearr_44747_44805[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (14))){
var inst_44607 = (state_44697[(7)]);
var state_44697__$1 = state_44697;
var statearr_44748_44806 = state_44697__$1;
(statearr_44748_44806[(2)] = inst_44607);

(statearr_44748_44806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (26))){
var state_44697__$1 = state_44697;
var statearr_44749_44807 = state_44697__$1;
(statearr_44749_44807[(2)] = null);

(statearr_44749_44807[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (16))){
var inst_44616 = cljs.core.first.call(null,ident);
var inst_44617 = cljs.core.pr_str.call(null,inst_44616);
var inst_44618 = ["Subject ID lookup failed. The predicate ",inst_44617," does not exist."].join('');
var inst_44619 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44620 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_44621 = cljs.core.PersistentHashMap.fromArrays(inst_44619,inst_44620);
var inst_44622 = cljs.core.ex_info.call(null,inst_44618,inst_44621);
var inst_44623 = (function(){throw inst_44622})();
var state_44697__$1 = state_44697;
var statearr_44750_44808 = state_44697__$1;
(statearr_44750_44808[(2)] = inst_44623);

(statearr_44750_44808[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (38))){
var inst_44677 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_44678 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44679 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_44680 = cljs.core.PersistentHashMap.fromArrays(inst_44678,inst_44679);
var inst_44681 = cljs.core.ex_info.call(null,inst_44677,inst_44680);
var inst_44682 = cljs.core.async.put_BANG_.call(null,return_chan,inst_44681);
var state_44697__$1 = state_44697;
var statearr_44751_44809 = state_44697__$1;
(statearr_44751_44809[(2)] = inst_44682);

(statearr_44751_44809[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (30))){
var state_44697__$1 = state_44697;
var statearr_44752_44810 = state_44697__$1;
(statearr_44752_44810[(2)] = null);

(statearr_44752_44810[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (10))){
var state_44697__$1 = state_44697;
var statearr_44753_44811 = state_44697__$1;
(statearr_44753_44811[(2)] = ident);

(statearr_44753_44811[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (18))){
var inst_44665 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
var statearr_44754_44812 = state_44697__$1;
(statearr_44754_44812[(2)] = inst_44665);

(statearr_44754_44812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (42))){
var state_44697__$1 = state_44697;
var statearr_44755_44813 = state_44697__$1;
(statearr_44755_44813[(2)] = null);

(statearr_44755_44813[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (37))){
var inst_44675 = (state_44697[(2)]);
var state_44697__$1 = state_44697;
if(cljs.core.truth_(inst_44675)){
var statearr_44756_44814 = state_44697__$1;
(statearr_44756_44814[(1)] = (38));

} else {
var statearr_44757_44815 = state_44697__$1;
(statearr_44757_44815[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44698 === (8))){
var inst_44667 = (state_44697[(10)]);
var inst_44667__$1 = (state_44697[(2)]);
var state_44697__$1 = (function (){var statearr_44758 = state_44697;
(statearr_44758[(10)] = inst_44667__$1);

return statearr_44758;
})();
if(cljs.core.truth_(inst_44667__$1)){
var statearr_44759_44816 = state_44697__$1;
(statearr_44759_44816[(1)] = (32));

} else {
var statearr_44760_44817 = state_44697__$1;
(statearr_44760_44817[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__16221__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__16221__auto____0 = (function (){
var statearr_44761 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44761[(0)] = fluree$db$graphdb$subid_$_state_machine__16221__auto__);

(statearr_44761[(1)] = (1));

return statearr_44761;
});
var fluree$db$graphdb$subid_$_state_machine__16221__auto____1 = (function (state_44697){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44762){var ex__16224__auto__ = e44762;
var statearr_44763_44818 = state_44697;
(statearr_44763_44818[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44697[(4)]))){
var statearr_44764_44819 = state_44697;
(statearr_44764_44819[(1)] = cljs.core.first.call(null,(state_44697[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44820 = state_44697;
state_44697 = G__44820;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__16221__auto__ = function(state_44697){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__16221__auto____1.call(this,state_44697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__16221__auto____0;
fluree$db$graphdb$subid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__16221__auto____1;
return fluree$db$graphdb$subid_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44765 = f__16346__auto__.call(null);
(statearr_44765[(6)] = c__16345__auto___44766);

return statearr_44765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__44821){
var map__44822 = p__44821;
var map__44822__$1 = cljs.core.__destructure_map.call(null,map__44822);
var current_db_fn = cljs.core.get.call(null,map__44822__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__44822__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44838){
var state_val_44839 = (state_44838[(1)]);
if((state_val_44839 === (1))){
var state_44838__$1 = state_44838;
var statearr_44840_44854 = state_44838__$1;
(statearr_44840_44854[(2)] = null);

(statearr_44840_44854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44839 === (2))){
var _ = (function (){var statearr_44841 = state_44838;
(statearr_44841[(4)] = cljs.core.cons.call(null,(5),(state_44838[(4)])));

return statearr_44841;
})();
var inst_44829 = current_db_fn.call(null);
var state_44838__$1 = state_44838;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44838__$1,(6),inst_44829);
} else {
if((state_val_44839 === (3))){
var inst_44836 = (state_44838[(2)]);
var state_44838__$1 = state_44838;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44838__$1,inst_44836);
} else {
if((state_val_44839 === (4))){
var inst_44823 = (state_44838[(2)]);
var state_44838__$1 = state_44838;
var statearr_44843_44855 = state_44838__$1;
(statearr_44843_44855[(2)] = inst_44823);

(statearr_44843_44855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44839 === (5))){
var _ = (function (){var statearr_44844 = state_44838;
(statearr_44844[(4)] = cljs.core.rest.call(null,(state_44838[(4)])));

return statearr_44844;
})();
var state_44838__$1 = state_44838;
var ex44842 = (state_44838__$1[(2)]);
var statearr_44845_44856 = state_44838__$1;
(statearr_44845_44856[(5)] = ex44842);


if((ex44842 instanceof Error)){
var statearr_44846_44857 = state_44838__$1;
(statearr_44846_44857[(1)] = (4));

(statearr_44846_44857[(5)] = null);

} else {
throw ex44842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44839 === (6))){
var inst_44831 = (state_44838[(2)]);
var inst_44832 = fluree.db.util.async.throw_err.call(null,inst_44831);
var inst_44833 = cljs.core.assoc.call(null,inst_44832,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_44847 = state_44838;
(statearr_44847[(4)] = cljs.core.rest.call(null,(state_44838[(4)])));

return statearr_44847;
})();
var state_44838__$1 = state_44838;
var statearr_44848_44858 = state_44838__$1;
(statearr_44848_44858[(2)] = inst_44833);

(statearr_44848_44858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____0 = (function (){
var statearr_44849 = [null,null,null,null,null,null,null];
(statearr_44849[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__);

(statearr_44849[(1)] = (1));

return statearr_44849;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____1 = (function (state_44838){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44850){var ex__16224__auto__ = e44850;
var statearr_44851_44859 = state_44838;
(statearr_44851_44859[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44838[(4)]))){
var statearr_44852_44860 = state_44838;
(statearr_44852_44860[(1)] = cljs.core.first.call(null,(state_44838[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44861 = state_44838;
state_44838 = G__44861;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__ = function(state_44838){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____1.call(this,state_44838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44853 = f__16346__auto__.call(null);
(statearr_44853[(6)] = c__16345__auto__);

return statearr_44853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__44862,property,collection){
var map__44863 = p__44862;
var map__44863__$1 = cljs.core.__destructure_map.call(null,map__44863);
var schema = cljs.core.get.call(null,map__44863__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__44864,property,predicate){
var map__44865 = p__44864;
var map__44865__$1 = cljs.core.__destructure_map.call(null,map__44865);
var this$ = map__44865__$1;
var schema = cljs.core.get.call(null,map__44865__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__44866 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__44866);
} else {
return G__44866;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__44868 = arguments.length;
switch (G__44868) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44900){
var state_val_44901 = (state_44900[(1)]);
if((state_val_44901 === (7))){
var state_44900__$1 = state_44900;
var statearr_44902_44996 = state_44900__$1;
(statearr_44902_44996[(2)] = null);

(statearr_44902_44996[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (1))){
var state_44900__$1 = state_44900;
var statearr_44903_44997 = state_44900__$1;
(statearr_44903_44997[(2)] = null);

(statearr_44903_44997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (4))){
var inst_44869 = (state_44900[(2)]);
var state_44900__$1 = state_44900;
var statearr_44904_44998 = state_44900__$1;
(statearr_44904_44998[(2)] = inst_44869);

(statearr_44904_44998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (6))){
var inst_44883 = (state_44900[(7)]);
var inst_44882 = (state_44900[(2)]);
var inst_44883__$1 = fluree.db.util.async.throw_err.call(null,inst_44882);
var inst_44884 = (inst_44883__$1 == null);
var state_44900__$1 = (function (){var statearr_44905 = state_44900;
(statearr_44905[(7)] = inst_44883__$1);

return statearr_44905;
})();
if(cljs.core.truth_(inst_44884)){
var statearr_44906_44999 = state_44900__$1;
(statearr_44906_44999[(1)] = (7));

} else {
var statearr_44907_45000 = state_44900__$1;
(statearr_44907_45000[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (3))){
var inst_44898 = (state_44900[(2)]);
var state_44900__$1 = state_44900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44900__$1,inst_44898);
} else {
if((state_val_44901 === (12))){
var inst_44895 = (state_44900[(2)]);
var _ = (function (){var statearr_44908 = state_44900;
(statearr_44908[(4)] = cljs.core.rest.call(null,(state_44900[(4)])));

return statearr_44908;
})();
var state_44900__$1 = state_44900;
var statearr_44909_45001 = state_44900__$1;
(statearr_44909_45001[(2)] = inst_44895);

(statearr_44909_45001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (2))){
var _ = (function (){var statearr_44910 = state_44900;
(statearr_44910[(4)] = cljs.core.cons.call(null,(5),(state_44900[(4)])));

return statearr_44910;
})();
var inst_44876 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_44877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44878 = [tag_id,(30)];
var inst_44879 = (new cljs.core.PersistentVector(null,2,(5),inst_44877,inst_44878,null));
var inst_44880 = fluree.db.query.range.index_range.call(null,inst_44876,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_44879);
var state_44900__$1 = state_44900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44900__$1,(6),inst_44880);
} else {
if((state_val_44901 === (11))){
var inst_44889 = (state_44900[(8)]);
var inst_44893 = inst_44889.o;
var state_44900__$1 = state_44900;
var statearr_44912_45002 = state_44900__$1;
(statearr_44912_45002[(2)] = inst_44893);

(statearr_44912_45002[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (9))){
var inst_44889 = (state_44900[(8)]);
var inst_44889__$1 = (state_44900[(2)]);
var inst_44890 = (inst_44889__$1 == null);
var state_44900__$1 = (function (){var statearr_44913 = state_44900;
(statearr_44913[(8)] = inst_44889__$1);

return statearr_44913;
})();
if(cljs.core.truth_(inst_44890)){
var statearr_44914_45003 = state_44900__$1;
(statearr_44914_45003[(1)] = (10));

} else {
var statearr_44915_45004 = state_44900__$1;
(statearr_44915_45004[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (5))){
var _ = (function (){var statearr_44916 = state_44900;
(statearr_44916[(4)] = cljs.core.rest.call(null,(state_44900[(4)])));

return statearr_44916;
})();
var state_44900__$1 = state_44900;
var ex44911 = (state_44900__$1[(2)]);
var statearr_44917_45005 = state_44900__$1;
(statearr_44917_45005[(5)] = ex44911);


if((ex44911 instanceof Error)){
var statearr_44918_45006 = state_44900__$1;
(statearr_44918_45006[(1)] = (4));

(statearr_44918_45006[(5)] = null);

} else {
throw ex44911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (10))){
var state_44900__$1 = state_44900;
var statearr_44919_45007 = state_44900__$1;
(statearr_44919_45007[(2)] = null);

(statearr_44919_45007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44901 === (8))){
var inst_44883 = (state_44900[(7)]);
var inst_44887 = cljs.core.first.call(null,inst_44883);
var state_44900__$1 = state_44900;
var statearr_44920_45008 = state_44900__$1;
(statearr_44920_45008[(2)] = inst_44887);

(statearr_44920_45008[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_44921 = [null,null,null,null,null,null,null,null,null];
(statearr_44921[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_44921[(1)] = (1));

return statearr_44921;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_44900){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44922){var ex__16224__auto__ = e44922;
var statearr_44923_45009 = state_44900;
(statearr_44923_45009[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44900[(4)]))){
var statearr_44924_45010 = state_44900;
(statearr_44924_45010[(1)] = cljs.core.first.call(null,(state_44900[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45011 = state_44900;
state_44900 = G__45011;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_44900){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_44900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44925 = f__16346__auto__.call(null);
(statearr_44925[(6)] = c__16345__auto__);

return statearr_44925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_44961){
var state_val_44962 = (state_44961[(1)]);
if((state_val_44962 === (7))){
var inst_44935 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_44961__$1 = state_44961;
var statearr_44963_45012 = state_44961__$1;
(statearr_44963_45012[(2)] = inst_44935);

(statearr_44963_45012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (1))){
var state_44961__$1 = state_44961;
var statearr_44964_45013 = state_44961__$1;
(statearr_44964_45013[(2)] = null);

(statearr_44964_45013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (4))){
var inst_44926 = (state_44961[(2)]);
var state_44961__$1 = state_44961;
var statearr_44965_45014 = state_44961__$1;
(statearr_44965_45014[(2)] = inst_44926);

(statearr_44965_45014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (15))){
var inst_44956 = (state_44961[(2)]);
var _ = (function (){var statearr_44966 = state_44961;
(statearr_44966[(4)] = cljs.core.rest.call(null,(state_44961[(4)])));

return statearr_44966;
})();
var state_44961__$1 = state_44961;
var statearr_44967_45015 = state_44961__$1;
(statearr_44967_45015[(2)] = inst_44956);

(statearr_44967_45015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (13))){
var inst_44941 = (state_44961[(7)]);
var inst_44947 = clojure.string.includes_QMARK_.call(null,inst_44941,":");
var state_44961__$1 = state_44961;
if(inst_44947){
var statearr_44968_45016 = state_44961__$1;
(statearr_44968_45016[(1)] = (16));

} else {
var statearr_44969_45017 = state_44961__$1;
(statearr_44969_45017[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (6))){
var state_44961__$1 = state_44961;
var statearr_44970_45018 = state_44961__$1;
(statearr_44970_45018[(2)] = pred);

(statearr_44970_45018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (17))){
var inst_44941 = (state_44961[(7)]);
var state_44961__$1 = state_44961;
var statearr_44971_45019 = state_44961__$1;
(statearr_44971_45019[(2)] = inst_44941);

(statearr_44971_45019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (3))){
var inst_44959 = (state_44961[(2)]);
var state_44961__$1 = state_44961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44961__$1,inst_44959);
} else {
if((state_val_44962 === (12))){
var inst_44945 = (state_44961[(2)]);
var state_44961__$1 = state_44961;
if(cljs.core.truth_(inst_44945)){
var statearr_44972_45020 = state_44961__$1;
(statearr_44972_45020[(1)] = (13));

} else {
var statearr_44973_45021 = state_44961__$1;
(statearr_44973_45021[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (2))){
var _ = (function (){var statearr_44974 = state_44961;
(statearr_44974[(4)] = cljs.core.cons.call(null,(5),(state_44961[(4)])));

return statearr_44974;
})();
var inst_44932 = typeof pred === 'string';
var state_44961__$1 = state_44961;
if(cljs.core.truth_(inst_44932)){
var statearr_44975_45022 = state_44961__$1;
(statearr_44975_45022[(1)] = (6));

} else {
var statearr_44976_45023 = state_44961__$1;
(statearr_44976_45023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (11))){
var inst_44937 = (state_44961[(8)]);
var state_44961__$1 = state_44961;
var statearr_44978_45024 = state_44961__$1;
(statearr_44978_45024[(2)] = inst_44937);

(statearr_44978_45024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (9))){
var inst_44937 = (state_44961[(8)]);
var inst_44940 = (state_44961[(2)]);
var inst_44941 = fluree.db.util.async.throw_err.call(null,inst_44940);
var state_44961__$1 = (function (){var statearr_44979 = state_44961;
(statearr_44979[(7)] = inst_44941);

return statearr_44979;
})();
if(cljs.core.truth_(inst_44937)){
var statearr_44980_45025 = state_44961__$1;
(statearr_44980_45025[(1)] = (10));

} else {
var statearr_44981_45026 = state_44961__$1;
(statearr_44981_45026[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (5))){
var _ = (function (){var statearr_44982 = state_44961;
(statearr_44982[(4)] = cljs.core.rest.call(null,(state_44961[(4)])));

return statearr_44982;
})();
var state_44961__$1 = state_44961;
var ex44977 = (state_44961__$1[(2)]);
var statearr_44983_45027 = state_44961__$1;
(statearr_44983_45027[(5)] = ex44977);


if((ex44977 instanceof Error)){
var statearr_44984_45028 = state_44961__$1;
(statearr_44984_45028[(1)] = (4));

(statearr_44984_45028[(5)] = null);

} else {
throw ex44977;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (14))){
var state_44961__$1 = state_44961;
var statearr_44985_45029 = state_44961__$1;
(statearr_44985_45029[(2)] = null);

(statearr_44985_45029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (16))){
var inst_44941 = (state_44961[(7)]);
var inst_44949 = clojure.string.split.call(null,inst_44941,/:/);
var inst_44950 = cljs.core.second.call(null,inst_44949);
var state_44961__$1 = state_44961;
var statearr_44986_45030 = state_44961__$1;
(statearr_44986_45030[(2)] = inst_44950);

(statearr_44986_45030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (10))){
var inst_44941 = (state_44961[(7)]);
var state_44961__$1 = state_44961;
var statearr_44987_45031 = state_44961__$1;
(statearr_44987_45031[(2)] = inst_44941);

(statearr_44987_45031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (18))){
var inst_44953 = (state_44961[(2)]);
var state_44961__$1 = state_44961;
var statearr_44988_45032 = state_44961__$1;
(statearr_44988_45032[(2)] = inst_44953);

(statearr_44988_45032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44962 === (8))){
var inst_44937 = (state_44961[(2)]);
var inst_44938 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_44961__$1 = (function (){var statearr_44989 = state_44961;
(statearr_44989[(8)] = inst_44937);

return statearr_44989;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44961__$1,(9),inst_44938);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_44990 = [null,null,null,null,null,null,null,null,null];
(statearr_44990[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_44990[(1)] = (1));

return statearr_44990;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_44961){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_44961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e44991){var ex__16224__auto__ = e44991;
var statearr_44992_45033 = state_44961;
(statearr_44992_45033[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_44961[(4)]))){
var statearr_44993_45034 = state_44961;
(statearr_44993_45034[(1)] = cljs.core.first.call(null,(state_44961[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45035 = state_44961;
state_44961 = G__45035;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_44961){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_44961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_44994 = f__16346__auto__.call(null);
(statearr_44994[(6)] = c__16345__auto__);

return statearr_44994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__45037 = arguments.length;
switch (G__45037) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45070){
var state_val_45071 = (state_45070[(1)]);
if((state_val_45071 === (7))){
var state_45070__$1 = state_45070;
var statearr_45072_45160 = state_45070__$1;
(statearr_45072_45160[(2)] = null);

(statearr_45072_45160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (1))){
var state_45070__$1 = state_45070;
var statearr_45073_45161 = state_45070__$1;
(statearr_45073_45161[(2)] = null);

(statearr_45073_45161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (4))){
var inst_45038 = (state_45070[(2)]);
var state_45070__$1 = state_45070;
var statearr_45074_45162 = state_45070__$1;
(statearr_45074_45162[(2)] = inst_45038);

(statearr_45074_45162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (6))){
var inst_45053 = (state_45070[(7)]);
var inst_45052 = (state_45070[(2)]);
var inst_45053__$1 = fluree.db.util.async.throw_err.call(null,inst_45052);
var inst_45054 = (inst_45053__$1 == null);
var state_45070__$1 = (function (){var statearr_45075 = state_45070;
(statearr_45075[(7)] = inst_45053__$1);

return statearr_45075;
})();
if(cljs.core.truth_(inst_45054)){
var statearr_45076_45163 = state_45070__$1;
(statearr_45076_45163[(1)] = (7));

} else {
var statearr_45077_45164 = state_45070__$1;
(statearr_45077_45164[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (3))){
var inst_45068 = (state_45070[(2)]);
var state_45070__$1 = state_45070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45070__$1,inst_45068);
} else {
if((state_val_45071 === (12))){
var inst_45065 = (state_45070[(2)]);
var _ = (function (){var statearr_45078 = state_45070;
(statearr_45078[(4)] = cljs.core.rest.call(null,(state_45070[(4)])));

return statearr_45078;
})();
var state_45070__$1 = state_45070;
var statearr_45079_45165 = state_45070__$1;
(statearr_45079_45165[(2)] = inst_45065);

(statearr_45079_45165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (2))){
var _ = (function (){var statearr_45080 = state_45070;
(statearr_45080[(4)] = cljs.core.cons.call(null,(5),(state_45070[(4)])));

return statearr_45080;
})();
var inst_45044 = (30);
var inst_45046 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_45047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45048 = [inst_45044,tag_name];
var inst_45049 = (new cljs.core.PersistentVector(null,2,(5),inst_45047,inst_45048,null));
var inst_45050 = fluree.db.query.range.index_range.call(null,inst_45046,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_45049);
var state_45070__$1 = state_45070;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45070__$1,(6),inst_45050);
} else {
if((state_val_45071 === (11))){
var inst_45059 = (state_45070[(8)]);
var inst_45063 = inst_45059.s;
var state_45070__$1 = state_45070;
var statearr_45082_45166 = state_45070__$1;
(statearr_45082_45166[(2)] = inst_45063);

(statearr_45082_45166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (9))){
var inst_45059 = (state_45070[(8)]);
var inst_45059__$1 = (state_45070[(2)]);
var inst_45060 = (inst_45059__$1 == null);
var state_45070__$1 = (function (){var statearr_45083 = state_45070;
(statearr_45083[(8)] = inst_45059__$1);

return statearr_45083;
})();
if(cljs.core.truth_(inst_45060)){
var statearr_45084_45167 = state_45070__$1;
(statearr_45084_45167[(1)] = (10));

} else {
var statearr_45085_45168 = state_45070__$1;
(statearr_45085_45168[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (5))){
var _ = (function (){var statearr_45086 = state_45070;
(statearr_45086[(4)] = cljs.core.rest.call(null,(state_45070[(4)])));

return statearr_45086;
})();
var state_45070__$1 = state_45070;
var ex45081 = (state_45070__$1[(2)]);
var statearr_45087_45169 = state_45070__$1;
(statearr_45087_45169[(5)] = ex45081);


if((ex45081 instanceof Error)){
var statearr_45088_45170 = state_45070__$1;
(statearr_45088_45170[(1)] = (4));

(statearr_45088_45170[(5)] = null);

} else {
throw ex45081;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (10))){
var state_45070__$1 = state_45070;
var statearr_45089_45171 = state_45070__$1;
(statearr_45089_45171[(2)] = null);

(statearr_45089_45171[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (8))){
var inst_45053 = (state_45070[(7)]);
var inst_45057 = cljs.core.first.call(null,inst_45053);
var state_45070__$1 = state_45070;
var statearr_45090_45172 = state_45070__$1;
(statearr_45090_45172[(2)] = inst_45057);

(statearr_45090_45172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_45091 = [null,null,null,null,null,null,null,null,null];
(statearr_45091[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_45091[(1)] = (1));

return statearr_45091;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_45070){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45092){var ex__16224__auto__ = e45092;
var statearr_45093_45173 = state_45070;
(statearr_45093_45173[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45070[(4)]))){
var statearr_45094_45174 = state_45070;
(statearr_45094_45174[(1)] = cljs.core.first.call(null,(state_45070[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45175 = state_45070;
state_45070 = G__45175;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_45070){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_45070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45095 = f__16346__auto__.call(null);
(statearr_45095[(6)] = c__16345__auto__);

return statearr_45095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45130){
var state_val_45131 = (state_45130[(1)]);
if((state_val_45131 === (7))){
var inst_45109 = typeof pred === 'string';
var state_45130__$1 = state_45130;
if(cljs.core.truth_(inst_45109)){
var statearr_45132_45176 = state_45130__$1;
(statearr_45132_45176[(1)] = (10));

} else {
var statearr_45133_45177 = state_45130__$1;
(statearr_45133_45177[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (1))){
var state_45130__$1 = state_45130;
var statearr_45134_45178 = state_45130__$1;
(statearr_45134_45178[(2)] = null);

(statearr_45134_45178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (4))){
var inst_45096 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
var statearr_45135_45179 = state_45130__$1;
(statearr_45135_45179[(2)] = inst_45096);

(statearr_45135_45179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (15))){
var inst_45123 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
var statearr_45136_45180 = state_45130__$1;
(statearr_45136_45180[(2)] = inst_45123);

(statearr_45136_45180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (13))){
var inst_45114 = (state_45130[(7)]);
var inst_45116 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45114),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_45117 = fluree.db.dbproto._tag_id.call(null,this$,inst_45116);
var state_45130__$1 = state_45130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45130__$1,(16),inst_45117);
} else {
if((state_val_45131 === (6))){
var inst_45104 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_45130__$1 = state_45130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45130__$1,(9),inst_45104);
} else {
if((state_val_45131 === (3))){
var inst_45128 = (state_45130[(2)]);
var state_45130__$1 = state_45130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45130__$1,inst_45128);
} else {
if((state_val_45131 === (12))){
var inst_45114 = (state_45130[(7)]);
var inst_45114__$1 = (state_45130[(2)]);
var state_45130__$1 = (function (){var statearr_45137 = state_45130;
(statearr_45137[(7)] = inst_45114__$1);

return statearr_45137;
})();
if(cljs.core.truth_(inst_45114__$1)){
var statearr_45138_45181 = state_45130__$1;
(statearr_45138_45181[(1)] = (13));

} else {
var statearr_45139_45182 = state_45130__$1;
(statearr_45139_45182[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (2))){
var _ = (function (){var statearr_45140 = state_45130;
(statearr_45140[(4)] = cljs.core.cons.call(null,(5),(state_45130[(4)])));

return statearr_45140;
})();
var inst_45102 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_45130__$1 = state_45130;
if(inst_45102){
var statearr_45141_45183 = state_45130__$1;
(statearr_45141_45183[(1)] = (6));

} else {
var statearr_45142_45184 = state_45130__$1;
(statearr_45142_45184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (11))){
var inst_45112 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_45130__$1 = state_45130;
var statearr_45144_45185 = state_45130__$1;
(statearr_45144_45185[(2)] = inst_45112);

(statearr_45144_45185[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (9))){
var inst_45106 = (state_45130[(2)]);
var inst_45107 = fluree.db.util.async.throw_err.call(null,inst_45106);
var state_45130__$1 = state_45130;
var statearr_45145_45186 = state_45130__$1;
(statearr_45145_45186[(2)] = inst_45107);

(statearr_45145_45186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (5))){
var _ = (function (){var statearr_45146 = state_45130;
(statearr_45146[(4)] = cljs.core.rest.call(null,(state_45130[(4)])));

return statearr_45146;
})();
var state_45130__$1 = state_45130;
var ex45143 = (state_45130__$1[(2)]);
var statearr_45147_45187 = state_45130__$1;
(statearr_45147_45187[(5)] = ex45143);


if((ex45143 instanceof Error)){
var statearr_45148_45188 = state_45130__$1;
(statearr_45148_45188[(1)] = (4));

(statearr_45148_45188[(5)] = null);

} else {
throw ex45143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (14))){
var state_45130__$1 = state_45130;
var statearr_45149_45189 = state_45130__$1;
(statearr_45149_45189[(2)] = null);

(statearr_45149_45189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (16))){
var inst_45119 = (state_45130[(2)]);
var inst_45120 = fluree.db.util.async.throw_err.call(null,inst_45119);
var state_45130__$1 = state_45130;
var statearr_45150_45190 = state_45130__$1;
(statearr_45150_45190[(2)] = inst_45120);

(statearr_45150_45190[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (10))){
var state_45130__$1 = state_45130;
var statearr_45151_45191 = state_45130__$1;
(statearr_45151_45191[(2)] = pred);

(statearr_45151_45191[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45131 === (8))){
var inst_45125 = (state_45130[(2)]);
var _ = (function (){var statearr_45152 = state_45130;
(statearr_45152[(4)] = cljs.core.rest.call(null,(state_45130[(4)])));

return statearr_45152;
})();
var state_45130__$1 = state_45130;
var statearr_45153_45192 = state_45130__$1;
(statearr_45153_45192[(2)] = inst_45125);

(statearr_45153_45192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16221__auto__ = null;
var fluree$db$graphdb$state_machine__16221__auto____0 = (function (){
var statearr_45154 = [null,null,null,null,null,null,null,null];
(statearr_45154[(0)] = fluree$db$graphdb$state_machine__16221__auto__);

(statearr_45154[(1)] = (1));

return statearr_45154;
});
var fluree$db$graphdb$state_machine__16221__auto____1 = (function (state_45130){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45155){var ex__16224__auto__ = e45155;
var statearr_45156_45193 = state_45130;
(statearr_45156_45193[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45130[(4)]))){
var statearr_45157_45194 = state_45130;
(statearr_45157_45194[(1)] = cljs.core.first.call(null,(state_45130[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45195 = state_45130;
state_45130 = G__45195;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16221__auto__ = function(state_45130){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16221__auto____1.call(this,state_45130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16221__auto____0;
fluree$db$graphdb$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16221__auto____1;
return fluree$db$graphdb$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45158 = f__16346__auto__.call(null);
(statearr_45158[(6)] = c__16345__auto__);

return statearr_45158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k45197,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__45201 = k45197;
var G__45201__$1 = (((G__45201 instanceof cljs.core.Keyword))?G__45201.fqn:null);
switch (G__45201__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k45197,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4484__auto__,p__45202){
var vec__45203 = p__45202;
var k__4485__auto__ = cljs.core.nth.call(null,vec__45203,(0),null);
var v__4486__auto__ = cljs.core.nth.call(null,vec__45203,(1),null);
return f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__);
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__45196){
var self__ = this;
var G__45196__$1 = this;
return (new cljs.core.RecordIter((0),G__45196__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4458__auto__));
}).call(null,this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this45198,other45199){
var self__ = this;
var this45198__$1 = this;
return (((!((other45199 == null)))) && ((((this45198__$1.constructor === other45199.constructor)) && (((cljs.core._EQ_.call(null,this45198__$1.conn,other45199.conn)) && (((cljs.core._EQ_.call(null,this45198__$1.network,other45199.network)) && (((cljs.core._EQ_.call(null,this45198__$1.dbid,other45199.dbid)) && (((cljs.core._EQ_.call(null,this45198__$1.block,other45199.block)) && (((cljs.core._EQ_.call(null,this45198__$1.t,other45199.t)) && (((cljs.core._EQ_.call(null,this45198__$1.tt_id,other45199.tt_id)) && (((cljs.core._EQ_.call(null,this45198__$1.stats,other45199.stats)) && (((cljs.core._EQ_.call(null,this45198__$1.spot,other45199.spot)) && (((cljs.core._EQ_.call(null,this45198__$1.psot,other45199.psot)) && (((cljs.core._EQ_.call(null,this45198__$1.post,other45199.post)) && (((cljs.core._EQ_.call(null,this45198__$1.opst,other45199.opst)) && (((cljs.core._EQ_.call(null,this45198__$1.schema,other45199.schema)) && (((cljs.core._EQ_.call(null,this45198__$1.settings,other45199.settings)) && (((cljs.core._EQ_.call(null,this45198__$1.index_configs,other45199.index_configs)) && (((cljs.core._EQ_.call(null,this45198__$1.schema_cache,other45199.schema_cache)) && (((cljs.core._EQ_.call(null,this45198__$1.novelty,other45199.novelty)) && (((cljs.core._EQ_.call(null,this45198__$1.permissions,other45199.permissions)) && (((cljs.core._EQ_.call(null,this45198__$1.fork,other45199.fork)) && (((cljs.core._EQ_.call(null,this45198__$1.fork_block,other45199.fork_block)) && (((cljs.core._EQ_.call(null,this45198__$1.current_db_fn,other45199.current_db_fn)) && (cljs.core._EQ_.call(null,this45198__$1.__extmap,other45199.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k45197){
var self__ = this;
var this__4468__auto____$1 = this;
var G__45206 = k45197;
var G__45206__$1 = (((G__45206 instanceof cljs.core.Keyword))?G__45206.fqn:null);
switch (G__45206__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k45197);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__45196){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__45207 = cljs.core.keyword_identical_QMARK_;
var expr__45208 = k__4470__auto__;
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__45208))){
return (new fluree.db.graphdb.GraphDb(G__45196,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__45196,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__45196,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__45196,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__45196,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__45196,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__45196,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__45196,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__45196,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__45196,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__45196,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__45196,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__45196,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__45196,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__45196,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__45196,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__45196,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__45196,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__45196,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45207.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__45208))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__45196,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4470__auto__,G__45196),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__45196){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__45196,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4467__auto__,(0)),cljs.core._nth.call(null,entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write.call(null,writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__45200){
var extmap__4501__auto__ = (function (){var G__45210 = cljs.core.dissoc.call(null,G__45200,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__45200)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__45210);
} else {
return G__45210;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__45200),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__45200),null,cljs.core.not_empty.call(null,extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
