// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__31196 = match;
var p1 = cljs.core.nth.call(null,vec__31196,(0),null);
var p2 = cljs.core.nth.call(null,vec__31196,(1),null);
var p3 = cljs.core.nth.call(null,vec__31196,(2),null);
var t = cljs.core.nth.call(null,vec__31196,(3),null);
var op = cljs.core.nth.call(null,vec__31196,(4),null);
var m = cljs.core.nth.call(null,vec__31196,(5),null);
var G__31199 = idx;
var G__31199__$1 = (((G__31199 instanceof cljs.core.Keyword))?G__31199.fqn:null);
switch (G__31199__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31199__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__31201 = idx;
var G__31201__$1 = (((G__31201 instanceof cljs.core.Keyword))?G__31201.fqn:null);
switch (G__31201__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31201__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__31203 = idx;
var G__31203__$1 = (((G__31203 instanceof cljs.core.Keyword))?G__31203.fqn:null);
switch (G__31203__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31203__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__31206 = arguments.length;
switch (G__31206) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31207 = (function (){var pred__31210 = cljs.core.identical_QMARK_;
var expr__31211 = test;
if(cljs.core.truth_(pred__31210.call(null,cljs.core._EQ_,expr__31211))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__31210.call(null,cljs.core._LT_,expr__31211))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__31210.call(null,cljs.core._LT__EQ_,expr__31211))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__31210.call(null,cljs.core._GT_,expr__31211))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__31210.call(null,cljs.core._GT__EQ_,expr__31211))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31211)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__31207,(0),null);
var start_match = cljs.core.nth.call(null,vec__31207,(1),null);
var end_test = cljs.core.nth.call(null,vec__31207,(2),null);
var end_match = cljs.core.nth.call(null,vec__31207,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_31450){
var state_val_31451 = (state_31450[(1)]);
if((state_val_31451 === (65))){
var inst_31365 = (state_31450[(7)]);
var inst_31421 = (state_31450[(8)]);
var inst_31421__$1 = (state_31450[(2)]);
var inst_31422 = cljs.core.count.call(null,inst_31421__$1);
var state_31450__$1 = (function (){var statearr_31452 = state_31450;
(statearr_31452[(9)] = inst_31422);

(statearr_31452[(8)] = inst_31421__$1);

return statearr_31452;
})();
if(cljs.core.truth_(inst_31365)){
var statearr_31453_31590 = state_31450__$1;
(statearr_31453_31590[(1)] = (81));

} else {
var statearr_31454_31591 = state_31450__$1;
(statearr_31454_31591[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (70))){
var inst_31396 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31396)){
var statearr_31455_31592 = state_31450__$1;
(statearr_31455_31592[(1)] = (71));

} else {
var statearr_31456_31593 = state_31450__$1;
(statearr_31456_31593[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (62))){
var inst_31349 = (state_31450[(10)]);
var inst_31335 = (state_31450[(11)]);
var inst_31364 = (state_31450[(2)]);
var inst_31365 = fluree.db.dbproto._rhs.call(null,inst_31349);
var state_31450__$1 = (function (){var statearr_31457 = state_31450;
(statearr_31457[(7)] = inst_31365);

(statearr_31457[(12)] = inst_31364);

return statearr_31457;
})();
if(cljs.core.truth_(inst_31335)){
var statearr_31458_31594 = state_31450__$1;
(statearr_31458_31594[(1)] = (63));

} else {
var statearr_31459_31595 = state_31450__$1;
(statearr_31459_31595[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (74))){
var inst_31389 = (state_31450[(13)]);
var inst_31403 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_31389);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(77),inst_31403);
} else {
if((state_val_31451 === (7))){
var inst_31226 = (state_31450[(14)]);
var state_31450__$1 = state_31450;
var statearr_31460_31596 = state_31450__$1;
(statearr_31460_31596[(2)] = inst_31226);

(statearr_31460_31596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (59))){
var inst_31312 = (state_31450[(15)]);
var inst_31356 = (state_31450[(16)]);
var inst_31311 = (state_31450[(17)]);
var inst_31355 = (state_31450[(2)]);
var inst_31356__$1 = fluree.db.util.async.throw_err.call(null,inst_31355);
var inst_31357 = fluree.db.flake.subrange.call(null,inst_31356__$1,start_test,inst_31311,end_test,inst_31312);
var inst_31358 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_31311,inst_31312);
var state_31450__$1 = (function (){var statearr_31461 = state_31450;
(statearr_31461[(16)] = inst_31356__$1);

(statearr_31461[(18)] = inst_31357);

return statearr_31461;
})();
if(inst_31358){
var statearr_31462_31597 = state_31450__$1;
(statearr_31462_31597[(1)] = (60));

} else {
var statearr_31463_31598 = state_31450__$1;
(statearr_31463_31598[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (86))){
var inst_31430 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31464_31599 = state_31450__$1;
(statearr_31464_31599[(2)] = inst_31430);

(statearr_31464_31599[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (20))){
var inst_31227 = (state_31450[(19)]);
var inst_31275 = (state_31450[(20)]);
var inst_31274 = (state_31450[(2)]);
var inst_31275__$1 = (inst_31227 == null);
var state_31450__$1 = (function (){var statearr_31465 = state_31450;
(statearr_31465[(21)] = inst_31274);

(statearr_31465[(20)] = inst_31275__$1);

return statearr_31465;
})();
if(cljs.core.truth_(inst_31275__$1)){
var statearr_31466_31600 = state_31450__$1;
(statearr_31466_31600[(1)] = (22));

} else {
var statearr_31467_31601 = state_31450__$1;
(statearr_31467_31601[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (72))){
var inst_31382 = (state_31450[(22)]);
var inst_31400 = (inst_31382 + (1));
var inst_31401 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_31450__$1 = (function (){var statearr_31468 = state_31450;
(statearr_31468[(23)] = inst_31400);

return statearr_31468;
})();
if(cljs.core.truth_(inst_31401)){
var statearr_31469_31602 = state_31450__$1;
(statearr_31469_31602[(1)] = (74));

} else {
var statearr_31470_31603 = state_31450__$1;
(statearr_31470_31603[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (58))){
var inst_31445 = (state_31450[(2)]);
var _ = (function (){var statearr_31471 = state_31450;
(statearr_31471[(4)] = cljs.core.rest.call(null,(state_31450[(4)])));

return statearr_31471;
})();
var state_31450__$1 = state_31450;
var statearr_31472_31604 = state_31450__$1;
(statearr_31472_31604[(2)] = inst_31445);

(statearr_31472_31604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (60))){
var inst_31232 = (state_31450[(24)]);
var inst_31265 = (state_31450[(25)]);
var inst_31322 = (state_31450[(26)]);
var inst_31339 = (state_31450[(27)]);
var inst_31225 = (state_31450[(28)]);
var inst_31236 = (state_31450[(29)]);
var inst_31292 = (state_31450[(30)]);
var inst_31301 = (state_31450[(31)]);
var inst_31230 = (state_31450[(32)]);
var inst_31318 = (state_31450[(33)]);
var inst_31328 = (state_31450[(34)]);
var inst_31247 = (state_31450[(35)]);
var inst_31310 = (state_31450[(36)]);
var inst_31312 = (state_31450[(15)]);
var inst_31356 = (state_31450[(16)]);
var inst_31349 = (state_31450[(10)]);
var inst_31350 = (state_31450[(37)]);
var inst_31274 = (state_31450[(21)]);
var inst_31256 = (state_31450[(38)]);
var inst_31237 = (state_31450[(39)]);
var inst_31229 = (state_31450[(40)]);
var inst_31317 = (state_31450[(41)]);
var inst_31344 = (state_31450[(42)]);
var inst_31335 = (state_31450[(11)]);
var inst_31329 = (state_31450[(43)]);
var inst_31357 = (state_31450[(18)]);
var inst_31351 = (state_31450[(44)]);
var inst_31283 = (state_31450[(45)]);
var inst_31311 = (state_31450[(17)]);
var inst_31360 = (function (){var no_filter_QMARK_ = inst_31335;
var next_node = inst_31349;
var flakes = inst_31356;
var s1 = inst_31247;
var o2 = inst_31274;
var t1 = inst_31229;
var vec__31219 = inst_31225;
var i = inst_31350;
var m1 = inst_31301;
var root_node = inst_31344;
var to_t = inst_31329;
var s2 = inst_31256;
var p2 = inst_31292;
var permissions = inst_31318;
var limit = inst_31317;
var start_flake = inst_31311;
var vec__31222 = inst_31232;
var acc = inst_31351;
var t2 = inst_31236;
var op1 = inst_31230;
var o1 = inst_31265;
var end_flake = inst_31312;
var base_result = inst_31357;
var p1 = inst_31283;
var idx_compare = inst_31322;
var op2 = inst_31237;
var from_t = inst_31328;
var m2 = inst_31310;
var novelty = inst_31339;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_31361 = cljs.core.reduce.call(null,inst_31360,inst_31357,inst_31357);
var state_31450__$1 = state_31450;
var statearr_31473_31605 = state_31450__$1;
(statearr_31473_31605[(2)] = inst_31361);

(statearr_31473_31605[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (27))){
var inst_31234 = (state_31450[(46)]);
var inst_31284 = (state_31450[(47)]);
var inst_31283 = (state_31450[(2)]);
var inst_31284__$1 = (inst_31234 == null);
var state_31450__$1 = (function (){var statearr_31474 = state_31450;
(statearr_31474[(47)] = inst_31284__$1);

(statearr_31474[(45)] = inst_31283);

return statearr_31474;
})();
if(cljs.core.truth_(inst_31284__$1)){
var statearr_31475_31606 = state_31450__$1;
(statearr_31475_31606[(1)] = (28));

} else {
var statearr_31476_31607 = state_31450__$1;
(statearr_31476_31607[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (1))){
var state_31450__$1 = state_31450;
var statearr_31477_31608 = state_31450__$1;
(statearr_31477_31608[(2)] = null);

(statearr_31477_31608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (69))){
var inst_31382 = (state_31450[(22)]);
var inst_31317 = (state_31450[(41)]);
var inst_31394 = (inst_31382 > inst_31317);
var state_31450__$1 = state_31450;
var statearr_31478_31609 = state_31450__$1;
(statearr_31478_31609[(2)] = inst_31394);

(statearr_31478_31609[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (24))){
var inst_31279 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31279)){
var statearr_31479_31610 = state_31450__$1;
(statearr_31479_31610[(1)] = (25));

} else {
var statearr_31480_31611 = state_31450__$1;
(statearr_31480_31611[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (55))){
var inst_31344 = (state_31450[(42)]);
var inst_31311 = (state_31450[(17)]);
var inst_31343 = (state_31450[(2)]);
var inst_31344__$1 = fluree.db.util.async.throw_err.call(null,inst_31343);
var inst_31345 = fluree.db.dbproto._lookup_leaf.call(null,inst_31344__$1,inst_31311);
var state_31450__$1 = (function (){var statearr_31481 = state_31450;
(statearr_31481[(42)] = inst_31344__$1);

return statearr_31481;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(56),inst_31345);
} else {
if((state_val_31451 === (85))){
var inst_31425 = (state_31450[(48)]);
var state_31450__$1 = state_31450;
var statearr_31482_31612 = state_31450__$1;
(statearr_31482_31612[(2)] = inst_31425);

(statearr_31482_31612[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (39))){
var inst_31299 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31483_31613 = state_31450__$1;
(statearr_31483_31613[(2)] = inst_31299);

(statearr_31483_31613[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (88))){
var inst_31365 = (state_31450[(7)]);
var inst_31344 = (state_31450[(42)]);
var inst_31437 = fluree.db.dbproto._lookup_leaf.call(null,inst_31344,inst_31365);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(90),inst_31437);
} else {
if((state_val_31451 === (46))){
var inst_31313 = (state_31450[(49)]);
var state_31450__$1 = state_31450;
var statearr_31484_31614 = state_31450__$1;
(statearr_31484_31614[(2)] = inst_31313);

(statearr_31484_31614[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (4))){
var inst_31213 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31485_31615 = state_31450__$1;
(statearr_31485_31615[(2)] = inst_31213);

(statearr_31485_31615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (77))){
var inst_31405 = (state_31450[(2)]);
var inst_31406 = fluree.db.util.async.throw_err.call(null,inst_31405);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31406)){
var statearr_31486_31616 = state_31450__$1;
(statearr_31486_31616[(1)] = (78));

} else {
var statearr_31487_31617 = state_31450__$1;
(statearr_31487_31617[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (54))){
var inst_31335 = (state_31450[(2)]);
var inst_31336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31337 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_31338 = (new cljs.core.PersistentVector(null,2,(5),inst_31336,inst_31337,null));
var inst_31339 = cljs.core.get_in.call(null,db,inst_31338);
var inst_31340 = cljs.core.get.call(null,db,idx);
var inst_31341 = fluree.db.dbproto._resolve.call(null,inst_31340);
var state_31450__$1 = (function (){var statearr_31488 = state_31450;
(statearr_31488[(27)] = inst_31339);

(statearr_31488[(11)] = inst_31335);

return statearr_31488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(55),inst_31341);
} else {
if((state_val_31451 === (15))){
var inst_31228 = (state_31450[(50)]);
var state_31450__$1 = state_31450;
var statearr_31489_31618 = state_31450__$1;
(statearr_31489_31618[(2)] = inst_31228);

(statearr_31489_31618[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (48))){
var inst_31323 = (state_31450[(51)]);
var inst_31317 = (state_31450[(2)]);
var inst_31318 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_31319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31320 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_31321 = (new cljs.core.PersistentVector(null,3,(5),inst_31319,inst_31320,null));
var inst_31322 = cljs.core.get_in.call(null,db,inst_31321);
var inst_31323__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_31450__$1 = (function (){var statearr_31490 = state_31450;
(statearr_31490[(26)] = inst_31322);

(statearr_31490[(51)] = inst_31323__$1);

(statearr_31490[(33)] = inst_31318);

(statearr_31490[(41)] = inst_31317);

return statearr_31490;
})();
if(cljs.core.truth_(inst_31323__$1)){
var statearr_31491_31619 = state_31450__$1;
(statearr_31491_31619[(1)] = (49));

} else {
var statearr_31492_31620 = state_31450__$1;
(statearr_31492_31620[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (50))){
var inst_31326 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_31450__$1 = state_31450;
var statearr_31493_31621 = state_31450__$1;
(statearr_31493_31621[(2)] = inst_31326);

(statearr_31493_31621[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (75))){
var inst_31383 = (state_31450[(52)]);
var state_31450__$1 = state_31450;
var statearr_31494_31622 = state_31450__$1;
(statearr_31494_31622[(2)] = inst_31383);

(statearr_31494_31622[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (21))){
var inst_31270 = (state_31450[(2)]);
var inst_31271 = fluree.db.util.async.throw_err.call(null,inst_31270);
var state_31450__$1 = state_31450;
var statearr_31495_31623 = state_31450__$1;
(statearr_31495_31623[(2)] = inst_31271);

(statearr_31495_31623[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (31))){
var state_31450__$1 = state_31450;
var statearr_31496_31624 = state_31450__$1;
(statearr_31496_31624[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_31496_31624[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (32))){
var inst_31234 = (state_31450[(46)]);
var state_31450__$1 = state_31450;
var statearr_31497_31625 = state_31450__$1;
(statearr_31497_31625[(2)] = inst_31234);

(statearr_31497_31625[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (40))){
var inst_31238 = (state_31450[(53)]);
var state_31450__$1 = state_31450;
var statearr_31498_31626 = state_31450__$1;
(statearr_31498_31626[(2)] = inst_31238);

(statearr_31498_31626[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (56))){
var inst_31347 = (state_31450[(2)]);
var inst_31348 = fluree.db.util.async.throw_err.call(null,inst_31347);
var inst_31349 = inst_31348;
var inst_31350 = (0);
var inst_31351 = null;
var state_31450__$1 = (function (){var statearr_31499 = state_31450;
(statearr_31499[(10)] = inst_31349);

(statearr_31499[(37)] = inst_31350);

(statearr_31499[(44)] = inst_31351);

return statearr_31499;
})();
var statearr_31500_31627 = state_31450__$1;
(statearr_31500_31627[(2)] = null);

(statearr_31500_31627[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (33))){
var inst_31231 = (state_31450[(54)]);
var inst_31292 = (state_31450[(2)]);
var state_31450__$1 = (function (){var statearr_31501 = state_31450;
(statearr_31501[(30)] = inst_31292);

return statearr_31501;
})();
if(cljs.core.truth_(inst_31231)){
var statearr_31502_31628 = state_31450__$1;
(statearr_31502_31628[(1)] = (34));

} else {
var statearr_31503_31629 = state_31450__$1;
(statearr_31503_31629[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (13))){
var inst_31252 = (state_31450[(2)]);
var inst_31253 = fluree.db.util.async.throw_err.call(null,inst_31252);
var state_31450__$1 = state_31450;
var statearr_31504_31630 = state_31450__$1;
(statearr_31504_31630[(2)] = inst_31253);

(statearr_31504_31630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (22))){
var inst_31265 = (state_31450[(25)]);
var state_31450__$1 = state_31450;
var statearr_31505_31631 = state_31450__$1;
(statearr_31505_31631[(2)] = inst_31265);

(statearr_31505_31631[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (90))){
var inst_31422 = (state_31450[(9)]);
var inst_31421 = (state_31450[(8)]);
var inst_31439 = (state_31450[(2)]);
var inst_31440 = fluree.db.util.async.throw_err.call(null,inst_31439);
var inst_31349 = inst_31440;
var inst_31350 = inst_31422;
var inst_31351 = inst_31421;
var state_31450__$1 = (function (){var statearr_31506 = state_31450;
(statearr_31506[(10)] = inst_31349);

(statearr_31506[(37)] = inst_31350);

(statearr_31506[(44)] = inst_31351);

return statearr_31506;
})();
var statearr_31507_31632 = state_31450__$1;
(statearr_31507_31632[(2)] = null);

(statearr_31507_31632[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (36))){
var inst_31238 = (state_31450[(53)]);
var inst_31301 = (state_31450[(2)]);
var state_31450__$1 = (function (){var statearr_31508 = state_31450;
(statearr_31508[(31)] = inst_31301);

return statearr_31508;
})();
if(cljs.core.truth_(inst_31238)){
var statearr_31509_31633 = state_31450__$1;
(statearr_31509_31633[(1)] = (40));

} else {
var statearr_31510_31634 = state_31450__$1;
(statearr_31510_31634[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (41))){
var inst_31304 = (cljs.core._LT__EQ_ === end_test);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31304)){
var statearr_31511_31635 = state_31450__$1;
(statearr_31511_31635[(1)] = (43));

} else {
var statearr_31512_31636 = state_31450__$1;
(statearr_31512_31636[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (89))){
var inst_31443 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31513_31637 = state_31450__$1;
(statearr_31513_31637[(2)] = inst_31443);

(statearr_31513_31637[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (43))){
var state_31450__$1 = state_31450;
var statearr_31514_31638 = state_31450__$1;
(statearr_31514_31638[(2)] = (2147483647));

(statearr_31514_31638[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (61))){
var inst_31357 = (state_31450[(18)]);
var state_31450__$1 = state_31450;
var statearr_31515_31639 = state_31450__$1;
(statearr_31515_31639[(2)] = inst_31357);

(statearr_31515_31639[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (29))){
var inst_31284 = (state_31450[(47)]);
var state_31450__$1 = state_31450;
var statearr_31516_31640 = state_31450__$1;
(statearr_31516_31640[(2)] = inst_31284);

(statearr_31516_31640[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (44))){
var state_31450__$1 = state_31450;
var statearr_31517_31641 = state_31450__$1;
(statearr_31517_31641[(2)] = fluree.db.util.core.min_integer);

(statearr_31517_31641[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (6))){
var inst_31226 = (state_31450[(14)]);
var inst_31241 = fluree.db.dbproto._subid.call(null,db,inst_31226);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(9),inst_31241);
} else {
if((state_val_31451 === (28))){
var inst_31274 = (state_31450[(21)]);
var state_31450__$1 = state_31450;
var statearr_31518_31642 = state_31450__$1;
(statearr_31518_31642[(2)] = inst_31274);

(statearr_31518_31642[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (64))){
var inst_31364 = (state_31450[(12)]);
var inst_31350 = (state_31450[(37)]);
var inst_31378 = cljs.core.seq.call(null,inst_31364);
var inst_31379 = cljs.core.first.call(null,inst_31378);
var inst_31380 = cljs.core.next.call(null,inst_31378);
var inst_31381 = inst_31364;
var inst_31382 = inst_31350;
var inst_31383 = inst_31364;
var state_31450__$1 = (function (){var statearr_31519 = state_31450;
(statearr_31519[(55)] = inst_31380);

(statearr_31519[(56)] = inst_31381);

(statearr_31519[(52)] = inst_31383);

(statearr_31519[(22)] = inst_31382);

(statearr_31519[(57)] = inst_31379);

return statearr_31519;
})();
var statearr_31520_31643 = state_31450__$1;
(statearr_31520_31643[(2)] = null);

(statearr_31520_31643[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (51))){
var inst_31328 = (state_31450[(2)]);
var inst_31329 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_31330 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_31450__$1 = (function (){var statearr_31521 = state_31450;
(statearr_31521[(34)] = inst_31328);

(statearr_31521[(43)] = inst_31329);

return statearr_31521;
})();
if(cljs.core.truth_(inst_31330)){
var statearr_31522_31644 = state_31450__$1;
(statearr_31522_31644[(1)] = (52));

} else {
var statearr_31523_31645 = state_31450__$1;
(statearr_31523_31645[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (25))){
var state_31450__$1 = state_31450;
var statearr_31524_31646 = state_31450__$1;
(statearr_31524_31646[(2)] = (-1));

(statearr_31524_31646[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (34))){
var inst_31231 = (state_31450[(54)]);
var state_31450__$1 = state_31450;
var statearr_31525_31647 = state_31450__$1;
(statearr_31525_31647[(2)] = inst_31231);

(statearr_31525_31647[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (17))){
var inst_31261 = (state_31450[(2)]);
var inst_31262 = fluree.db.util.async.throw_err.call(null,inst_31261);
var state_31450__$1 = state_31450;
var statearr_31526_31648 = state_31450__$1;
(statearr_31526_31648[(2)] = inst_31262);

(statearr_31526_31648[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (3))){
var inst_31448 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31450__$1,inst_31448);
} else {
if((state_val_31451 === (12))){
var inst_31228 = (state_31450[(50)]);
var inst_31256 = (state_31450[(2)]);
var inst_31257 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31228);
var state_31450__$1 = (function (){var statearr_31527 = state_31450;
(statearr_31527[(38)] = inst_31256);

return statearr_31527;
})();
if(inst_31257){
var statearr_31528_31649 = state_31450__$1;
(statearr_31528_31649[(1)] = (14));

} else {
var statearr_31529_31650 = state_31450__$1;
(statearr_31529_31650[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (2))){
var inst_31232 = (state_31450[(24)]);
var inst_31225 = (state_31450[(28)]);
var inst_31226 = (state_31450[(14)]);
var _ = (function (){var statearr_31530 = state_31450;
(statearr_31530[(4)] = cljs.core.cons.call(null,(5),(state_31450[(4)])));

return statearr_31530;
})();
var inst_31225__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_31226__$1 = cljs.core.nth.call(null,inst_31225__$1,(0),null);
var inst_31227 = cljs.core.nth.call(null,inst_31225__$1,(1),null);
var inst_31228 = cljs.core.nth.call(null,inst_31225__$1,(2),null);
var inst_31229 = cljs.core.nth.call(null,inst_31225__$1,(3),null);
var inst_31230 = cljs.core.nth.call(null,inst_31225__$1,(4),null);
var inst_31231 = cljs.core.nth.call(null,inst_31225__$1,(5),null);
var inst_31232__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_31233 = cljs.core.nth.call(null,inst_31232__$1,(0),null);
var inst_31234 = cljs.core.nth.call(null,inst_31232__$1,(1),null);
var inst_31235 = cljs.core.nth.call(null,inst_31232__$1,(2),null);
var inst_31236 = cljs.core.nth.call(null,inst_31232__$1,(3),null);
var inst_31237 = cljs.core.nth.call(null,inst_31232__$1,(4),null);
var inst_31238 = cljs.core.nth.call(null,inst_31232__$1,(5),null);
var inst_31239 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31226__$1);
var state_31450__$1 = (function (){var statearr_31531 = state_31450;
(statearr_31531[(24)] = inst_31232__$1);

(statearr_31531[(28)] = inst_31225__$1);

(statearr_31531[(29)] = inst_31236);

(statearr_31531[(50)] = inst_31228);

(statearr_31531[(54)] = inst_31231);

(statearr_31531[(32)] = inst_31230);

(statearr_31531[(46)] = inst_31234);

(statearr_31531[(58)] = inst_31235);

(statearr_31531[(14)] = inst_31226__$1);

(statearr_31531[(53)] = inst_31238);

(statearr_31531[(39)] = inst_31237);

(statearr_31531[(40)] = inst_31229);

(statearr_31531[(59)] = inst_31233);

(statearr_31531[(19)] = inst_31227);

return statearr_31531;
})();
if(inst_31239){
var statearr_31532_31651 = state_31450__$1;
(statearr_31532_31651[(1)] = (6));

} else {
var statearr_31533_31652 = state_31450__$1;
(statearr_31533_31652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (66))){
var inst_31381 = (state_31450[(56)]);
var inst_31391 = (state_31450[(60)]);
var inst_31389 = (state_31450[(13)]);
var inst_31388 = cljs.core.seq.call(null,inst_31381);
var inst_31389__$1 = cljs.core.first.call(null,inst_31388);
var inst_31390 = cljs.core.next.call(null,inst_31388);
var inst_31391__$1 = (inst_31389__$1 == null);
var state_31450__$1 = (function (){var statearr_31534 = state_31450;
(statearr_31534[(61)] = inst_31390);

(statearr_31534[(60)] = inst_31391__$1);

(statearr_31534[(13)] = inst_31389__$1);

return statearr_31534;
})();
if(cljs.core.truth_(inst_31391__$1)){
var statearr_31535_31653 = state_31450__$1;
(statearr_31535_31653[(1)] = (68));

} else {
var statearr_31536_31654 = state_31450__$1;
(statearr_31536_31654[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (23))){
var inst_31275 = (state_31450[(20)]);
var state_31450__$1 = state_31450;
var statearr_31537_31655 = state_31450__$1;
(statearr_31537_31655[(2)] = inst_31275);

(statearr_31537_31655[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (47))){
var state_31450__$1 = state_31450;
var statearr_31538_31656 = state_31450__$1;
(statearr_31538_31656[(2)] = fluree.db.util.core.max_long);

(statearr_31538_31656[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (35))){
var inst_31295 = (cljs.core._GT__EQ_ === start_test);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31295)){
var statearr_31539_31657 = state_31450__$1;
(statearr_31539_31657[(1)] = (37));

} else {
var statearr_31540_31658 = state_31450__$1;
(statearr_31540_31658[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (82))){
var inst_31365 = (state_31450[(7)]);
var state_31450__$1 = state_31450;
var statearr_31541_31659 = state_31450__$1;
(statearr_31541_31659[(2)] = inst_31365);

(statearr_31541_31659[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (76))){
var inst_31390 = (state_31450[(61)]);
var inst_31400 = (state_31450[(23)]);
var inst_31414 = (state_31450[(2)]);
var inst_31381 = inst_31390;
var inst_31382 = inst_31400;
var inst_31383 = inst_31414;
var state_31450__$1 = (function (){var statearr_31542 = state_31450;
(statearr_31542[(56)] = inst_31381);

(statearr_31542[(52)] = inst_31383);

(statearr_31542[(22)] = inst_31382);

return statearr_31542;
})();
var statearr_31543_31660 = state_31450__$1;
(statearr_31543_31660[(2)] = null);

(statearr_31543_31660[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (19))){
var inst_31235 = (state_31450[(58)]);
var state_31450__$1 = state_31450;
var statearr_31544_31661 = state_31450__$1;
(statearr_31544_31661[(2)] = inst_31235);

(statearr_31544_31661[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (57))){
var inst_31339 = (state_31450[(27)]);
var inst_31328 = (state_31450[(34)]);
var inst_31349 = (state_31450[(10)]);
var inst_31329 = (state_31450[(43)]);
var inst_31353 = fluree.db.dbproto._resolve_history_range.call(null,inst_31349,inst_31328,inst_31329,inst_31339);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(59),inst_31353);
} else {
if((state_val_31451 === (68))){
var inst_31391 = (state_31450[(60)]);
var state_31450__$1 = state_31450;
var statearr_31545_31662 = state_31450__$1;
(statearr_31545_31662[(2)] = inst_31391);

(statearr_31545_31662[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (11))){
var inst_31233 = (state_31450[(59)]);
var state_31450__$1 = state_31450;
var statearr_31547_31663 = state_31450__$1;
(statearr_31547_31663[(2)] = inst_31233);

(statearr_31547_31663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (9))){
var inst_31243 = (state_31450[(2)]);
var inst_31244 = fluree.db.util.async.throw_err.call(null,inst_31243);
var state_31450__$1 = state_31450;
var statearr_31548_31664 = state_31450__$1;
(statearr_31548_31664[(2)] = inst_31244);

(statearr_31548_31664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (5))){
var _ = (function (){var statearr_31549 = state_31450;
(statearr_31549[(4)] = cljs.core.rest.call(null,(state_31450[(4)])));

return statearr_31549;
})();
var state_31450__$1 = state_31450;
var ex31546 = (state_31450__$1[(2)]);
var statearr_31550_31665 = state_31450__$1;
(statearr_31550_31665[(5)] = ex31546);


if((ex31546 instanceof Error)){
var statearr_31551_31666 = state_31450__$1;
(statearr_31551_31666[(1)] = (4));

(statearr_31551_31666[(5)] = null);

} else {
throw ex31546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (83))){
var inst_31433 = (state_31450[(2)]);
var inst_31434 = cljs.core.not.call(null,inst_31433);
var state_31450__$1 = state_31450;
if(inst_31434){
var statearr_31552_31667 = state_31450__$1;
(statearr_31552_31667[(1)] = (87));

} else {
var statearr_31553_31668 = state_31450__$1;
(statearr_31553_31668[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (14))){
var inst_31228 = (state_31450[(50)]);
var inst_31259 = fluree.db.dbproto._subid.call(null,db,inst_31228);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(17),inst_31259);
} else {
if((state_val_31451 === (45))){
var inst_31308 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31554_31669 = state_31450__$1;
(statearr_31554_31669[(2)] = inst_31308);

(statearr_31554_31669[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (53))){
var state_31450__$1 = state_31450;
var statearr_31555_31670 = state_31450__$1;
(statearr_31555_31670[(2)] = true);

(statearr_31555_31670[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (78))){
var inst_31383 = (state_31450[(52)]);
var state_31450__$1 = state_31450;
var statearr_31556_31671 = state_31450__$1;
(statearr_31556_31671[(2)] = inst_31383);

(statearr_31556_31671[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (26))){
var inst_31227 = (state_31450[(19)]);
var state_31450__$1 = state_31450;
var statearr_31557_31672 = state_31450__$1;
(statearr_31557_31672[(2)] = inst_31227);

(statearr_31557_31672[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (16))){
var inst_31235 = (state_31450[(58)]);
var inst_31265 = (state_31450[(2)]);
var inst_31266 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31235);
var state_31450__$1 = (function (){var statearr_31558 = state_31450;
(statearr_31558[(25)] = inst_31265);

return statearr_31558;
})();
if(inst_31266){
var statearr_31559_31673 = state_31450__$1;
(statearr_31559_31673[(1)] = (18));

} else {
var statearr_31560_31674 = state_31450__$1;
(statearr_31560_31674[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (81))){
var inst_31322 = (state_31450[(26)]);
var inst_31365 = (state_31450[(7)]);
var inst_31312 = (state_31450[(15)]);
var inst_31425 = (state_31450[(48)]);
var inst_31424 = inst_31322.call(null,inst_31365,inst_31312);
var inst_31425__$1 = (inst_31424 < (0));
var state_31450__$1 = (function (){var statearr_31561 = state_31450;
(statearr_31561[(48)] = inst_31425__$1);

return statearr_31561;
})();
if(cljs.core.truth_(inst_31425__$1)){
var statearr_31562_31675 = state_31450__$1;
(statearr_31562_31675[(1)] = (84));

} else {
var statearr_31563_31676 = state_31450__$1;
(statearr_31563_31676[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (79))){
var inst_31383 = (state_31450[(52)]);
var inst_31389 = (state_31450[(13)]);
var inst_31409 = cljs.core.disj.call(null,inst_31383,inst_31389);
var state_31450__$1 = state_31450;
var statearr_31564_31677 = state_31450__$1;
(statearr_31564_31677[(2)] = inst_31409);

(statearr_31564_31677[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (38))){
var state_31450__$1 = state_31450;
var statearr_31565_31678 = state_31450__$1;
(statearr_31565_31678[(2)] = (2147483647));

(statearr_31565_31678[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (87))){
var inst_31421 = (state_31450[(8)]);
var state_31450__$1 = state_31450;
var statearr_31566_31679 = state_31450__$1;
(statearr_31566_31679[(2)] = inst_31421);

(statearr_31566_31679[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (30))){
var inst_31288 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
if(cljs.core.truth_(inst_31288)){
var statearr_31567_31680 = state_31450__$1;
(statearr_31567_31680[(1)] = (31));

} else {
var statearr_31568_31681 = state_31450__$1;
(statearr_31568_31681[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (73))){
var inst_31417 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31569_31682 = state_31450__$1;
(statearr_31569_31682[(2)] = inst_31417);

(statearr_31569_31682[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (10))){
var inst_31233 = (state_31450[(59)]);
var inst_31250 = fluree.db.dbproto._subid.call(null,db,inst_31233);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(13),inst_31250);
} else {
if((state_val_31451 === (18))){
var inst_31235 = (state_31450[(58)]);
var inst_31268 = fluree.db.dbproto._subid.call(null,db,inst_31235);
var state_31450__$1 = state_31450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31450__$1,(21),inst_31268);
} else {
if((state_val_31451 === (52))){
var inst_31292 = (state_31450[(30)]);
var inst_31318 = (state_31450[(33)]);
var inst_31247 = (state_31450[(35)]);
var inst_31256 = (state_31450[(38)]);
var inst_31283 = (state_31450[(45)]);
var inst_31332 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_31318,inst_31247,inst_31256,inst_31283,inst_31292);
var state_31450__$1 = state_31450;
var statearr_31570_31683 = state_31450__$1;
(statearr_31570_31683[(2)] = inst_31332);

(statearr_31570_31683[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (67))){
var inst_31419 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31571_31684 = state_31450__$1;
(statearr_31571_31684[(2)] = inst_31419);

(statearr_31571_31684[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (71))){
var inst_31383 = (state_31450[(52)]);
var inst_31351 = (state_31450[(44)]);
var inst_31398 = cljs.core.into.call(null,inst_31383,inst_31351);
var state_31450__$1 = state_31450;
var statearr_31572_31685 = state_31450__$1;
(statearr_31572_31685[(2)] = inst_31398);

(statearr_31572_31685[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (42))){
var inst_31265 = (state_31450[(25)]);
var inst_31236 = (state_31450[(29)]);
var inst_31292 = (state_31450[(30)]);
var inst_31301 = (state_31450[(31)]);
var inst_31230 = (state_31450[(32)]);
var inst_31247 = (state_31450[(35)]);
var inst_31310 = (state_31450[(36)]);
var inst_31274 = (state_31450[(21)]);
var inst_31256 = (state_31450[(38)]);
var inst_31237 = (state_31450[(39)]);
var inst_31229 = (state_31450[(40)]);
var inst_31283 = (state_31450[(45)]);
var inst_31313 = (state_31450[(49)]);
var inst_31310__$1 = (state_31450[(2)]);
var inst_31311 = fluree.db.flake.__GT_Flake.call(null,inst_31247,inst_31283,inst_31265,inst_31229,inst_31230,inst_31301);
var inst_31312 = fluree.db.flake.__GT_Flake.call(null,inst_31256,inst_31292,inst_31274,inst_31236,inst_31237,inst_31310__$1);
var inst_31313__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_31450__$1 = (function (){var statearr_31573 = state_31450;
(statearr_31573[(36)] = inst_31310__$1);

(statearr_31573[(15)] = inst_31312);

(statearr_31573[(17)] = inst_31311);

(statearr_31573[(49)] = inst_31313__$1);

return statearr_31573;
})();
if(cljs.core.truth_(inst_31313__$1)){
var statearr_31574_31686 = state_31450__$1;
(statearr_31574_31686[(1)] = (46));

} else {
var statearr_31575_31687 = state_31450__$1;
(statearr_31575_31687[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (80))){
var inst_31411 = (state_31450[(2)]);
var state_31450__$1 = state_31450;
var statearr_31576_31688 = state_31450__$1;
(statearr_31576_31688[(2)] = inst_31411);

(statearr_31576_31688[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (37))){
var state_31450__$1 = state_31450;
var statearr_31577_31689 = state_31450__$1;
(statearr_31577_31689[(2)] = fluree.db.util.core.min_integer);

(statearr_31577_31689[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (63))){
var inst_31364 = (state_31450[(12)]);
var inst_31350 = (state_31450[(37)]);
var inst_31317 = (state_31450[(41)]);
var inst_31351 = (state_31450[(44)]);
var inst_31367 = (inst_31317 - inst_31350);
var inst_31368 = fluree.db.flake.take.call(null,inst_31367,inst_31364);
var inst_31369 = cljs.core.into.call(null,inst_31368,inst_31351);
var state_31450__$1 = state_31450;
var statearr_31578_31690 = state_31450__$1;
(statearr_31578_31690[(2)] = inst_31369);

(statearr_31578_31690[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (8))){
var inst_31233 = (state_31450[(59)]);
var inst_31247 = (state_31450[(2)]);
var inst_31248 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31233);
var state_31450__$1 = (function (){var statearr_31579 = state_31450;
(statearr_31579[(35)] = inst_31247);

return statearr_31579;
})();
if(inst_31248){
var statearr_31580_31691 = state_31450__$1;
(statearr_31580_31691[(1)] = (10));

} else {
var statearr_31581_31692 = state_31450__$1;
(statearr_31581_31692[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (49))){
var inst_31323 = (state_31450[(51)]);
var state_31450__$1 = state_31450;
var statearr_31582_31693 = state_31450__$1;
(statearr_31582_31693[(2)] = inst_31323);

(statearr_31582_31693[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31451 === (84))){
var inst_31422 = (state_31450[(9)]);
var inst_31317 = (state_31450[(41)]);
var inst_31427 = (inst_31422 < inst_31317);
var state_31450__$1 = state_31450;
var statearr_31583_31694 = state_31450__$1;
(statearr_31583_31694[(2)] = inst_31427);

(statearr_31583_31694[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16221__auto__ = null;
var fluree$db$query$range$state_machine__16221__auto____0 = (function (){
var statearr_31584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31584[(0)] = fluree$db$query$range$state_machine__16221__auto__);

(statearr_31584[(1)] = (1));

return statearr_31584;
});
var fluree$db$query$range$state_machine__16221__auto____1 = (function (state_31450){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_31450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e31585){var ex__16224__auto__ = e31585;
var statearr_31586_31695 = state_31450;
(statearr_31586_31695[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_31450[(4)]))){
var statearr_31587_31696 = state_31450;
(statearr_31587_31696[(1)] = cljs.core.first.call(null,(state_31450[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31697 = state_31450;
state_31450 = G__31697;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16221__auto__ = function(state_31450){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16221__auto____1.call(this,state_31450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16221__auto____0;
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16221__auto____1;
return fluree$db$query$range$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_31588 = f__16346__auto__.call(null);
(statearr_31588[(6)] = c__16345__auto__);

return statearr_31588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_31772){
var state_val_31773 = (state_31772[(1)]);
if((state_val_31773 === (7))){
var inst_31767 = (state_31772[(2)]);
var _ = (function (){var statearr_31774 = state_31772;
(statearr_31774[(4)] = cljs.core.rest.call(null,(state_31772[(4)])));

return statearr_31774;
})();
var state_31772__$1 = state_31772;
var statearr_31775_31815 = state_31772__$1;
(statearr_31775_31815[(2)] = inst_31767);

(statearr_31775_31815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (20))){
var inst_31749 = (state_31772[(2)]);
var inst_31750 = fluree.db.util.async.throw_err.call(null,inst_31749);
var state_31772__$1 = state_31772;
var statearr_31776_31816 = state_31772__$1;
(statearr_31776_31816[(2)] = inst_31750);

(statearr_31776_31816[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (1))){
var state_31772__$1 = state_31772;
var statearr_31777_31817 = state_31772__$1;
(statearr_31777_31817[(2)] = null);

(statearr_31777_31817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (4))){
var inst_31698 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31778_31818 = state_31772__$1;
(statearr_31778_31818[(2)] = inst_31698);

(statearr_31778_31818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (15))){
var inst_31745 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_31772__$1 = state_31772;
if(cljs.core.truth_(inst_31745)){
var statearr_31779_31819 = state_31772__$1;
(statearr_31779_31819[(1)] = (17));

} else {
var statearr_31780_31820 = state_31772__$1;
(statearr_31780_31820[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (21))){
var state_31772__$1 = state_31772;
var statearr_31781_31821 = state_31772__$1;
(statearr_31781_31821[(2)] = (0));

(statearr_31781_31821[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (13))){
var inst_31737 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31782_31822 = state_31772__$1;
(statearr_31782_31822[(2)] = inst_31737);

(statearr_31782_31822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (22))){
var state_31772__$1 = state_31772;
var statearr_31783_31823 = state_31772__$1;
(statearr_31783_31823[(2)] = (1));

(statearr_31783_31823[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (6))){
var inst_31729 = (state_31772[(7)]);
var inst_31727 = (state_31772[(8)]);
var inst_31718 = (state_31772[(9)]);
var inst_31726 = cljs.core.seq.call(null,inst_31718);
var inst_31727__$1 = cljs.core.first.call(null,inst_31726);
var inst_31728 = cljs.core.next.call(null,inst_31726);
var inst_31729__$1 = (inst_31727__$1 == null);
var state_31772__$1 = (function (){var statearr_31784 = state_31772;
(statearr_31784[(7)] = inst_31729__$1);

(statearr_31784[(8)] = inst_31727__$1);

(statearr_31784[(10)] = inst_31728);

return statearr_31784;
})();
if(cljs.core.truth_(inst_31729__$1)){
var statearr_31785_31824 = state_31772__$1;
(statearr_31785_31824[(1)] = (8));

} else {
var statearr_31786_31825 = state_31772__$1;
(statearr_31786_31825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (17))){
var inst_31727 = (state_31772[(8)]);
var inst_31747 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_31727);
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31772__$1,(20),inst_31747);
} else {
if((state_val_31773 === (3))){
var inst_31770 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31772__$1,inst_31770);
} else {
if((state_val_31773 === (12))){
var inst_31720 = (state_31772[(11)]);
var inst_31735 = (inst_31720 >= subject_limit);
var state_31772__$1 = state_31772;
var statearr_31787_31826 = state_31772__$1;
(statearr_31787_31826[(2)] = inst_31735);

(statearr_31787_31826[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (2))){
var _ = (function (){var statearr_31788 = state_31772;
(statearr_31788[(4)] = cljs.core.cons.call(null,(5),(state_31772[(4)])));

return statearr_31788;
})();
var inst_31711 = subject_groups;
var inst_31712 = cljs.core.seq.call(null,inst_31711);
var inst_31713 = cljs.core.first.call(null,inst_31712);
var inst_31714 = cljs.core.next.call(null,inst_31712);
var inst_31715 = flake_start;
var inst_31716 = subject_start;
var inst_31717 = cljs.core.PersistentVector.EMPTY;
var inst_31718 = inst_31711;
var inst_31719 = inst_31715;
var inst_31720 = inst_31716;
var inst_31721 = inst_31717;
var state_31772__$1 = (function (){var statearr_31789 = state_31772;
(statearr_31789[(12)] = inst_31714);

(statearr_31789[(11)] = inst_31720);

(statearr_31789[(13)] = inst_31721);

(statearr_31789[(14)] = inst_31713);

(statearr_31789[(9)] = inst_31718);

(statearr_31789[(15)] = inst_31719);

return statearr_31789;
})();
var statearr_31790_31827 = state_31772__$1;
(statearr_31790_31827[(2)] = null);

(statearr_31790_31827[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (23))){
var inst_31720 = (state_31772[(11)]);
var inst_31721 = (state_31772[(13)]);
var inst_31754 = (state_31772[(16)]);
var inst_31728 = (state_31772[(10)]);
var inst_31753 = (state_31772[(17)]);
var inst_31719 = (state_31772[(15)]);
var inst_31759 = (state_31772[(2)]);
var inst_31760 = (inst_31719 + inst_31754);
var inst_31761 = (inst_31720 + inst_31759);
var inst_31762 = cljs.core.into.call(null,inst_31721,inst_31753);
var inst_31718 = inst_31728;
var inst_31719__$1 = inst_31760;
var inst_31720__$1 = inst_31761;
var inst_31721__$1 = inst_31762;
var state_31772__$1 = (function (){var statearr_31791 = state_31772;
(statearr_31791[(11)] = inst_31720__$1);

(statearr_31791[(13)] = inst_31721__$1);

(statearr_31791[(9)] = inst_31718);

(statearr_31791[(15)] = inst_31719__$1);

return statearr_31791;
})();
var statearr_31792_31828 = state_31772__$1;
(statearr_31792_31828[(2)] = null);

(statearr_31792_31828[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (19))){
var inst_31754 = (state_31772[(16)]);
var inst_31753 = (state_31772[(17)]);
var inst_31753__$1 = (state_31772[(2)]);
var inst_31754__$1 = cljs.core.count.call(null,inst_31753__$1);
var inst_31755 = cljs.core._EQ_.call(null,(0),inst_31754__$1);
var state_31772__$1 = (function (){var statearr_31793 = state_31772;
(statearr_31793[(16)] = inst_31754__$1);

(statearr_31793[(17)] = inst_31753__$1);

return statearr_31793;
})();
if(inst_31755){
var statearr_31794_31829 = state_31772__$1;
(statearr_31794_31829[(1)] = (21));

} else {
var statearr_31795_31830 = state_31772__$1;
(statearr_31795_31830[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (11))){
var inst_31732 = (state_31772[(18)]);
var state_31772__$1 = state_31772;
var statearr_31797_31831 = state_31772__$1;
(statearr_31797_31831[(2)] = inst_31732);

(statearr_31797_31831[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (9))){
var inst_31732 = (state_31772[(18)]);
var inst_31719 = (state_31772[(15)]);
var inst_31732__$1 = (inst_31719 >= flake_limit);
var state_31772__$1 = (function (){var statearr_31798 = state_31772;
(statearr_31798[(18)] = inst_31732__$1);

return statearr_31798;
})();
if(cljs.core.truth_(inst_31732__$1)){
var statearr_31799_31832 = state_31772__$1;
(statearr_31799_31832[(1)] = (11));

} else {
var statearr_31800_31833 = state_31772__$1;
(statearr_31800_31833[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (5))){
var _ = (function (){var statearr_31801 = state_31772;
(statearr_31801[(4)] = cljs.core.rest.call(null,(state_31772[(4)])));

return statearr_31801;
})();
var state_31772__$1 = state_31772;
var ex31796 = (state_31772__$1[(2)]);
var statearr_31802_31834 = state_31772__$1;
(statearr_31802_31834[(5)] = ex31796);


if((ex31796 instanceof Error)){
var statearr_31803_31835 = state_31772__$1;
(statearr_31803_31835[(1)] = (4));

(statearr_31803_31835[(5)] = null);

} else {
throw ex31796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (14))){
var inst_31720 = (state_31772[(11)]);
var inst_31721 = (state_31772[(13)]);
var inst_31719 = (state_31772[(15)]);
var inst_31741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31742 = [inst_31719,inst_31720,inst_31721];
var inst_31743 = (new cljs.core.PersistentVector(null,3,(5),inst_31741,inst_31742,null));
var state_31772__$1 = state_31772;
var statearr_31804_31836 = state_31772__$1;
(statearr_31804_31836[(2)] = inst_31743);

(statearr_31804_31836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (16))){
var inst_31765 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31805_31837 = state_31772__$1;
(statearr_31805_31837[(2)] = inst_31765);

(statearr_31805_31837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (10))){
var inst_31739 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
if(cljs.core.truth_(inst_31739)){
var statearr_31806_31838 = state_31772__$1;
(statearr_31806_31838[(1)] = (14));

} else {
var statearr_31807_31839 = state_31772__$1;
(statearr_31807_31839[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (18))){
var inst_31727 = (state_31772[(8)]);
var state_31772__$1 = state_31772;
var statearr_31808_31840 = state_31772__$1;
(statearr_31808_31840[(2)] = inst_31727);

(statearr_31808_31840[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31773 === (8))){
var inst_31729 = (state_31772[(7)]);
var state_31772__$1 = state_31772;
var statearr_31809_31841 = state_31772__$1;
(statearr_31809_31841[(2)] = inst_31729);

(statearr_31809_31841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____0 = (function (){
var statearr_31810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31810[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__);

(statearr_31810[(1)] = (1));

return statearr_31810;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____1 = (function (state_31772){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_31772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e31811){var ex__16224__auto__ = e31811;
var statearr_31812_31842 = state_31772;
(statearr_31812_31842[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_31772[(4)]))){
var statearr_31813_31843 = state_31772;
(statearr_31813_31843[(1)] = cljs.core.first.call(null,(state_31772[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31844 = state_31772;
state_31772 = G__31844;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__ = function(state_31772){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____1.call(this,state_31772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_31814 = f__16346__auto__.call(null);
(statearr_31814[(6)] = c__16345__auto__);

return statearr_31814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_31890){
var state_val_31891 = (state_31890[(1)]);
if((state_val_31891 === (7))){
var state_31890__$1 = state_31890;
var statearr_31892_31930 = state_31890__$1;
(statearr_31892_31930[(2)] = null);

(statearr_31892_31930[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (20))){
var inst_31876 = (state_31890[(2)]);
var inst_31877 = fluree.db.util.async.throw_err.call(null,inst_31876);
var inst_31855 = inst_31877;
var state_31890__$1 = (function (){var statearr_31893 = state_31890;
(statearr_31893[(7)] = inst_31855);

return statearr_31893;
})();
var statearr_31894_31931 = state_31890__$1;
(statearr_31894_31931[(2)] = null);

(statearr_31894_31931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (1))){
var state_31890__$1 = state_31890;
var statearr_31895_31932 = state_31890__$1;
(statearr_31895_31932[(2)] = null);

(statearr_31895_31932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (4))){
var inst_31845 = (state_31890[(2)]);
var state_31890__$1 = state_31890;
var statearr_31896_31933 = state_31890__$1;
(statearr_31896_31933[(2)] = inst_31845);

(statearr_31896_31933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (15))){
var inst_31855 = (state_31890[(7)]);
var inst_31872 = (state_31890[(8)]);
var inst_31872__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_31855);
var state_31890__$1 = (function (){var statearr_31897 = state_31890;
(statearr_31897[(8)] = inst_31872__$1);

return statearr_31897;
})();
if(cljs.core.truth_(inst_31872__$1)){
var statearr_31898_31934 = state_31890__$1;
(statearr_31898_31934[(1)] = (17));

} else {
var statearr_31899_31935 = state_31890__$1;
(statearr_31899_31935[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (13))){
var inst_31865 = (state_31890[(2)]);
var inst_31866 = fluree.db.util.async.throw_err.call(null,inst_31865);
var _ = (function (){var statearr_31900 = state_31890;
(statearr_31900[(4)] = cljs.core.rest.call(null,(state_31890[(4)])));

return statearr_31900;
})();
var state_31890__$1 = state_31890;
var statearr_31901_31936 = state_31890__$1;
(statearr_31901_31936[(2)] = inst_31866);

(statearr_31901_31936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (6))){
var inst_31853 = (state_31890[(2)]);
var inst_31854 = fluree.db.util.async.throw_err.call(null,inst_31853);
var inst_31855 = inst_31854;
var state_31890__$1 = (function (){var statearr_31902 = state_31890;
(statearr_31902[(7)] = inst_31855);

return statearr_31902;
})();
var statearr_31903_31937 = state_31890__$1;
(statearr_31903_31937[(2)] = null);

(statearr_31903_31937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (17))){
var inst_31872 = (state_31890[(8)]);
var inst_31874 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_31872);
var state_31890__$1 = state_31890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31890__$1,(20),inst_31874);
} else {
if((state_val_31891 === (3))){
var inst_31888 = (state_31890[(2)]);
var state_31890__$1 = state_31890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31890__$1,inst_31888);
} else {
if((state_val_31891 === (12))){
var _ = (function (){var statearr_31905 = state_31890;
(statearr_31905[(4)] = cljs.core.rest.call(null,(state_31890[(4)])));

return statearr_31905;
})();
var state_31890__$1 = state_31890;
var ex31904 = (state_31890__$1[(2)]);
var statearr_31906_31938 = state_31890__$1;
(statearr_31906_31938[(5)] = ex31904);


var statearr_31907_31939 = state_31890__$1;
(statearr_31907_31939[(1)] = (11));

(statearr_31907_31939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (2))){
var _ = (function (){var statearr_31908 = state_31890;
(statearr_31908[(4)] = cljs.core.cons.call(null,(5),(state_31890[(4)])));

return statearr_31908;
})();
var inst_31851 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_31890__$1 = state_31890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31890__$1,(6),inst_31851);
} else {
if((state_val_31891 === (19))){
var inst_31881 = (state_31890[(2)]);
var state_31890__$1 = state_31890;
var statearr_31909_31940 = state_31890__$1;
(statearr_31909_31940[(2)] = inst_31881);

(statearr_31909_31940[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (11))){
var inst_31857 = (state_31890[(2)]);
var state_31890__$1 = (function (){var statearr_31911 = state_31890;
(statearr_31911[(9)] = inst_31857);

return statearr_31911;
})();
var statearr_31912_31941 = state_31890__$1;
(statearr_31912_31941[(2)] = null);

(statearr_31912_31941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (9))){
var inst_31855 = (state_31890[(7)]);
var _ = (function (){var statearr_31913 = state_31890;
(statearr_31913[(4)] = cljs.core.cons.call(null,(12),(state_31890[(4)])));

return statearr_31913;
})();
var inst_31863 = fluree.db.dbproto._resolve_to_t.call(null,inst_31855,t,novelty,fast_forward_db_QMARK_);
var state_31890__$1 = state_31890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31890__$1,(13),inst_31863);
} else {
if((state_val_31891 === (5))){
var _ = (function (){var statearr_31914 = state_31890;
(statearr_31914[(4)] = cljs.core.rest.call(null,(state_31890[(4)])));

return statearr_31914;
})();
var state_31890__$1 = state_31890;
var ex31910 = (state_31890__$1[(2)]);
var statearr_31915_31942 = state_31890__$1;
(statearr_31915_31942[(5)] = ex31910);


if((ex31910 instanceof Error)){
var statearr_31916_31943 = state_31890__$1;
(statearr_31916_31943[(1)] = (4));

(statearr_31916_31943[(5)] = null);

} else {
throw ex31910;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (14))){
var inst_31869 = (state_31890[(10)]);
var state_31890__$1 = state_31890;
var statearr_31917_31944 = state_31890__$1;
(statearr_31917_31944[(2)] = inst_31869);

(statearr_31917_31944[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (16))){
var inst_31883 = (state_31890[(2)]);
var state_31890__$1 = state_31890;
var statearr_31918_31945 = state_31890__$1;
(statearr_31918_31945[(2)] = inst_31883);

(statearr_31918_31945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (10))){
var inst_31869 = (state_31890[(10)]);
var inst_31869__$1 = (state_31890[(2)]);
var state_31890__$1 = (function (){var statearr_31919 = state_31890;
(statearr_31919[(10)] = inst_31869__$1);

return statearr_31919;
})();
if(cljs.core.truth_(inst_31869__$1)){
var statearr_31920_31946 = state_31890__$1;
(statearr_31920_31946[(1)] = (14));

} else {
var statearr_31921_31947 = state_31890__$1;
(statearr_31921_31947[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (18))){
var state_31890__$1 = state_31890;
var statearr_31922_31948 = state_31890__$1;
(statearr_31922_31948[(2)] = null);

(statearr_31922_31948[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31891 === (8))){
var inst_31885 = (state_31890[(2)]);
var _ = (function (){var statearr_31923 = state_31890;
(statearr_31923[(4)] = cljs.core.rest.call(null,(state_31890[(4)])));

return statearr_31923;
})();
var state_31890__$1 = state_31890;
var statearr_31924_31949 = state_31890__$1;
(statearr_31924_31949[(2)] = inst_31885);

(statearr_31924_31949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____0 = (function (){
var statearr_31925 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31925[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__);

(statearr_31925[(1)] = (1));

return statearr_31925;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____1 = (function (state_31890){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_31890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e31926){var ex__16224__auto__ = e31926;
var statearr_31927_31950 = state_31890;
(statearr_31927_31950[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_31890[(4)]))){
var statearr_31928_31951 = state_31890;
(statearr_31928_31951[(1)] = cljs.core.first.call(null,(state_31890[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31952 = state_31890;
state_31890 = G__31952;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__ = function(state_31890){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____1.call(this,state_31890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_31929 = f__16346__auto__.call(null);
(statearr_31929[(6)] = c__16345__auto__);

return statearr_31929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__31959 = arguments.length;
switch (G__31959) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31960 = (function (){var pred__31963 = cljs.core.identical_QMARK_;
var expr__31964 = test;
if(cljs.core.truth_(pred__31963.call(null,cljs.core._EQ_,expr__31964))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__31963.call(null,cljs.core._LT_,expr__31964))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__31963.call(null,cljs.core._LT__EQ_,expr__31964))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__31963.call(null,cljs.core._GT_,expr__31964))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__31963.call(null,cljs.core._GT__EQ_,expr__31964))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31964)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__31960,(0),null);
var start_match = cljs.core.nth.call(null,vec__31960,(1),null);
var end_test = cljs.core.nth.call(null,vec__31960,(2),null);
var end_match = cljs.core.nth.call(null,vec__31960,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_32336){
var state_val_32337 = (state_32336[(1)]);
if((state_val_32337 === (121))){
var inst_32292 = (state_32336[(7)]);
var state_32336__$1 = state_32336;
var statearr_32338_32531 = state_32336__$1;
(statearr_32338_32531[(2)] = inst_32292);

(statearr_32338_32531[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (65))){
var inst_32144 = (state_32336[(8)]);
var inst_32150 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32339 = state_32336;
(statearr_32339[(9)] = inst_32150);

return statearr_32339;
})();
if(cljs.core.truth_(inst_32144)){
var statearr_32340_32532 = state_32336__$1;
(statearr_32340_32532[(1)] = (66));

} else {
var statearr_32341_32533 = state_32336__$1;
(statearr_32341_32533[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (70))){
var inst_32328 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32342_32534 = state_32336__$1;
(statearr_32342_32534[(2)] = inst_32328);

(statearr_32342_32534[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (62))){
var inst_32143 = (state_32336[(2)]);
var inst_32144 = fluree.db.util.async.throw_err.call(null,inst_32143);
var inst_32145 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_32336__$1 = (function (){var statearr_32343 = state_32336;
(statearr_32343[(8)] = inst_32144);

return statearr_32343;
})();
if(cljs.core.truth_(inst_32145)){
var statearr_32344_32535 = state_32336__$1;
(statearr_32344_32535[(1)] = (63));

} else {
var statearr_32345_32536 = state_32336__$1;
(statearr_32345_32536[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (74))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32134 = (state_32336[(12)]);
var inst_31997 = (state_32336[(13)]);
var inst_32140 = (state_32336[(14)]);
var inst_32144 = (state_32336[(8)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32124 = (state_32336[(17)]);
var inst_32058 = (state_32336[(18)]);
var inst_32135 = (state_32336[(19)]);
var inst_32001 = (state_32336[(20)]);
var inst_32130 = (state_32336[(21)]);
var inst_32094 = (state_32336[(22)]);
var inst_32157 = (state_32336[(23)]);
var inst_32129 = (state_32336[(24)]);
var inst_32156 = (state_32336[(25)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_32117 = (state_32336[(28)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32163 = (state_32336[(31)]);
var inst_32067 = (state_32336[(32)]);
var inst_32123 = (state_32336[(33)]);
var inst_32076 = (state_32336[(34)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32013 = (state_32336[(37)]);
var inst_32113 = (state_32336[(38)]);
var inst_31991 = (state_32336[(39)]);
var inst_31993 = (state_32336[(40)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32150 = (state_32336[(9)]);
var inst_32171 = (state_32336[(47)]);
var inst_32125 = (state_32336[(48)]);
var inst_32173 = (function (){var no_filter_QMARK_ = inst_32150;
var t = inst_32130;
var max_limit_QMARK_ = inst_32124;
var next_node = inst_32153;
var fast_forward_db_QMARK_ = inst_32135;
var s1 = inst_32013;
var o2 = inst_32076;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var i = inst_32155;
var vec__31979 = inst_32054;
var m1 = inst_32103;
var root_node = inst_32140;
var s2 = inst_32022;
var p2 = inst_32094;
var permissions = inst_32125;
var G__32164 = inst_32171;
var limit = inst_32123;
var map__31978 = inst_32001;
var start_flake = inst_32113;
var flake_limit = inst_32117;
var offset = inst_32154;
var acc = inst_32157;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_32067;
var end_flake = inst_32114;
var base_result = inst_32163;
var map__31985 = inst_32116;
var s = inst_32156;
var node_start = inst_32144;
var p1 = inst_32085;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32058;
var idx_compare = inst_32129;
var op2 = inst_31998;
var m2 = inst_32112;
var vec__31982 = inst_32055;
var novelty = inst_32134;
return (function (p1__31954_SHARP_){
return subject_fn.call(null,p1__31954_SHARP_.s);
});
})();
var inst_32174 = cljs.core.filter.call(null,inst_32173,inst_32171);
var state_32336__$1 = state_32336;
var statearr_32346_32537 = state_32336__$1;
(statearr_32346_32537[(2)] = inst_32174);

(statearr_32346_32537[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (110))){
var inst_32305 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32347_32538 = state_32336__$1;
(statearr_32347_32538[(2)] = inst_32305);

(statearr_32347_32538[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (7))){
var inst_31987 = (state_32336[(49)]);
var state_32336__$1 = state_32336;
var statearr_32348_32539 = state_32336__$1;
(statearr_32348_32539[(2)] = inst_31987);

(statearr_32348_32539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (59))){
var state_32336__$1 = state_32336;
var statearr_32349_32540 = state_32336__$1;
(statearr_32349_32540[(2)] = fluree.db.util.core.max_long);

(statearr_32349_32540[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (86))){
var inst_32150 = (state_32336[(9)]);
var state_32336__$1 = state_32336;
var statearr_32350_32541 = state_32336__$1;
(statearr_32350_32541[(2)] = inst_32150);

(statearr_32350_32541[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (20))){
var state_32336__$1 = state_32336;
var statearr_32351_32542 = state_32336__$1;
(statearr_32351_32542[(2)] = null);

(statearr_32351_32542[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (72))){
var inst_32163 = (state_32336[(31)]);
var state_32336__$1 = state_32336;
var statearr_32352_32543 = state_32336__$1;
(statearr_32352_32543[(2)] = inst_32163);

(statearr_32352_32543[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (58))){
var inst_32118 = (state_32336[(50)]);
var state_32336__$1 = state_32336;
var statearr_32353_32544 = state_32336__$1;
(statearr_32353_32544[(2)] = inst_32118);

(statearr_32353_32544[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (60))){
var inst_32123 = (state_32336[(33)]);
var inst_32123__$1 = (state_32336[(2)]);
var inst_32124 = cljs.core._EQ_.call(null,inst_32123__$1,fluree.db.util.core.max_long);
var inst_32125 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_32126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32127 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_32128 = (new cljs.core.PersistentVector(null,3,(5),inst_32126,inst_32127,null));
var inst_32129 = cljs.core.get_in.call(null,db,inst_32128);
var inst_32130 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_32131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32132 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_32133 = (new cljs.core.PersistentVector(null,2,(5),inst_32131,inst_32132,null));
var inst_32134 = cljs.core.get_in.call(null,db,inst_32133);
var inst_32135 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_32136 = cljs.core.get.call(null,db,idx);
var inst_32137 = fluree.db.dbproto._resolve.call(null,inst_32136);
var state_32336__$1 = (function (){var statearr_32354 = state_32336;
(statearr_32354[(12)] = inst_32134);

(statearr_32354[(17)] = inst_32124);

(statearr_32354[(19)] = inst_32135);

(statearr_32354[(21)] = inst_32130);

(statearr_32354[(24)] = inst_32129);

(statearr_32354[(33)] = inst_32123__$1);

(statearr_32354[(48)] = inst_32125);

return statearr_32354;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(61),inst_32137);
} else {
if((state_val_32337 === (27))){
var inst_32056 = (state_32336[(51)]);
var state_32336__$1 = state_32336;
var statearr_32355_32545 = state_32336__$1;
(statearr_32355_32545[(2)] = inst_32056);

(statearr_32355_32545[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (1))){
var state_32336__$1 = state_32336;
var statearr_32356_32546 = state_32336__$1;
(statearr_32356_32546[(2)] = null);

(statearr_32356_32546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (69))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32113 = (state_32336[(38)]);
var inst_32162 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_32153);
var inst_32163 = fluree.db.flake.subrange.call(null,inst_32162,start_test,inst_32113,end_test,inst_32114);
var inst_32165 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_32113,inst_32114);
var state_32336__$1 = (function (){var statearr_32357 = state_32336;
(statearr_32357[(31)] = inst_32163);

return statearr_32357;
})();
if(inst_32165){
var statearr_32358_32547 = state_32336__$1;
(statearr_32358_32547[(1)] = (71));

} else {
var statearr_32359_32548 = state_32336__$1;
(statearr_32359_32548[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (101))){
var inst_32117 = (state_32336[(28)]);
var inst_32249 = (state_32336[(52)]);
var inst_32251 = (state_32336[(53)]);
var inst_32250 = (state_32336[(54)]);
var inst_32254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32255 = (inst_32251 - inst_32117);
var inst_32256 = (inst_32250 - inst_32255);
var inst_32257 = cljs.core.take.call(null,inst_32256,inst_32249);
var inst_32258 = [inst_32117,inst_32257];
var inst_32259 = (new cljs.core.PersistentVector(null,2,(5),inst_32254,inst_32258,null));
var state_32336__$1 = state_32336;
var statearr_32360_32549 = state_32336__$1;
(statearr_32360_32549[(2)] = inst_32259);

(statearr_32360_32549[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (24))){
var inst_32036 = (state_32336[(55)]);
var inst_31997 = (state_32336[(13)]);
var inst_31999 = (state_32336[(56)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32004 = (state_32336[(57)]);
var inst_31996 = (state_32336[(58)]);
var inst_32001 = (state_32336[(20)]);
var inst_31988 = (state_32336[(59)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_31992 = (state_32336[(60)]);
var inst_32013 = (state_32336[(37)]);
var inst_31995 = (state_32336[(61)]);
var inst_31991 = (state_32336[(39)]);
var inst_31993 = (state_32336[(40)]);
var inst_31990 = (state_32336[(43)]);
var inst_31998 = (state_32336[(45)]);
var inst_31989 = (state_32336[(62)]);
var inst_32046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32048 = [null,null];
var inst_32049 = (new cljs.core.PersistentVector(null,2,(5),inst_32047,inst_32048,null));
var inst_32050 = (function (){var bool = inst_32036;
var s1 = inst_32013;
var o2 = inst_31996;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var m1 = inst_31992;
var s2 = inst_32022;
var p2 = inst_31995;
var map__31978 = inst_32001;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_31989;
var p1 = inst_31988;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32004;
var op2 = inst_31998;
var m2 = inst_31999;
var temp__5755__auto__ = inst_32036;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_32051 = [inst_32049,inst_32050];
var inst_32052 = (new cljs.core.PersistentVector(null,2,(5),inst_32046,inst_32051,null));
var state_32336__$1 = state_32336;
var statearr_32361_32550 = state_32336__$1;
(statearr_32361_32550[(2)] = inst_32052);

(statearr_32361_32550[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (102))){
var inst_32249 = (state_32336[(52)]);
var inst_32251 = (state_32336[(53)]);
var inst_32261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32262 = [inst_32251,inst_32249];
var inst_32263 = (new cljs.core.PersistentVector(null,2,(5),inst_32261,inst_32262,null));
var state_32336__$1 = state_32336;
var statearr_32362_32551 = state_32336__$1;
(statearr_32362_32551[(2)] = inst_32263);

(statearr_32362_32551[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (55))){
var state_32336__$1 = state_32336;
var statearr_32363_32552 = state_32336__$1;
(statearr_32363_32552[(2)] = (2147483647));

(statearr_32363_32552[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (85))){
var inst_32199 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
if(cljs.core.truth_(inst_32199)){
var statearr_32364_32553 = state_32336__$1;
(statearr_32364_32553[(1)] = (89));

} else {
var statearr_32365_32554 = state_32336__$1;
(statearr_32365_32554[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (39))){
var inst_32086 = (state_32336[(63)]);
var inst_31995 = (state_32336[(61)]);
var inst_32085 = (state_32336[(2)]);
var inst_32086__$1 = (inst_31995 == null);
var state_32336__$1 = (function (){var statearr_32366 = state_32336;
(statearr_32366[(63)] = inst_32086__$1);

(statearr_32366[(42)] = inst_32085);

return statearr_32366;
})();
if(cljs.core.truth_(inst_32086__$1)){
var statearr_32367_32555 = state_32336__$1;
(statearr_32367_32555[(1)] = (40));

} else {
var statearr_32368_32556 = state_32336__$1;
(statearr_32368_32556[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (88))){
var inst_32196 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32369_32557 = state_32336__$1;
(statearr_32369_32557[(2)] = inst_32196);

(statearr_32369_32557[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (46))){
var inst_31992 = (state_32336[(60)]);
var state_32336__$1 = state_32336;
var statearr_32370_32558 = state_32336__$1;
(statearr_32370_32558[(2)] = inst_31992);

(statearr_32370_32558[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (4))){
var inst_31966 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32371_32559 = state_32336__$1;
(statearr_32371_32559[(2)] = inst_31966);

(statearr_32371_32559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (77))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32134 = (state_32336[(12)]);
var inst_31997 = (state_32336[(13)]);
var inst_32140 = (state_32336[(14)]);
var inst_32144 = (state_32336[(8)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32124 = (state_32336[(17)]);
var inst_32177 = (state_32336[(64)]);
var inst_32058 = (state_32336[(18)]);
var inst_32135 = (state_32336[(19)]);
var inst_32001 = (state_32336[(20)]);
var inst_32130 = (state_32336[(21)]);
var inst_32094 = (state_32336[(22)]);
var inst_32157 = (state_32336[(23)]);
var inst_32129 = (state_32336[(24)]);
var inst_32156 = (state_32336[(25)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_32117 = (state_32336[(28)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32163 = (state_32336[(31)]);
var inst_32067 = (state_32336[(32)]);
var inst_32123 = (state_32336[(33)]);
var inst_32076 = (state_32336[(34)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32013 = (state_32336[(37)]);
var inst_32113 = (state_32336[(38)]);
var inst_31991 = (state_32336[(39)]);
var inst_31993 = (state_32336[(40)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32150 = (state_32336[(9)]);
var inst_32125 = (state_32336[(48)]);
var inst_32179 = (function (){var no_filter_QMARK_ = inst_32150;
var t = inst_32130;
var max_limit_QMARK_ = inst_32124;
var next_node = inst_32153;
var fast_forward_db_QMARK_ = inst_32135;
var s1 = inst_32013;
var o2 = inst_32076;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var i = inst_32155;
var vec__31979 = inst_32054;
var m1 = inst_32103;
var root_node = inst_32140;
var s2 = inst_32022;
var p2 = inst_32094;
var permissions = inst_32125;
var G__32164 = inst_32177;
var limit = inst_32123;
var map__31978 = inst_32001;
var start_flake = inst_32113;
var flake_limit = inst_32117;
var offset = inst_32154;
var acc = inst_32157;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_32067;
var end_flake = inst_32114;
var base_result = inst_32163;
var map__31985 = inst_32116;
var s = inst_32156;
var node_start = inst_32144;
var p1 = inst_32085;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32058;
var idx_compare = inst_32129;
var op2 = inst_31998;
var m2 = inst_32112;
var vec__31982 = inst_32055;
var novelty = inst_32134;
return (function (p1__31955_SHARP_){
return predicate_fn.call(null,p1__31955_SHARP_.p);
});
})();
var inst_32180 = cljs.core.filter.call(null,inst_32179,inst_32177);
var state_32336__$1 = state_32336;
var statearr_32372_32560 = state_32336__$1;
(statearr_32372_32560[(2)] = inst_32180);

(statearr_32372_32560[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (106))){
var inst_32190 = (state_32336[(65)]);
var state_32336__$1 = state_32336;
var statearr_32373_32561 = state_32336__$1;
(statearr_32373_32561[(2)] = inst_32190);

(statearr_32373_32561[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (119))){
var inst_32308 = (state_32336[(66)]);
var state_32336__$1 = state_32336;
var statearr_32374_32562 = state_32336__$1;
(statearr_32374_32562[(2)] = inst_32308);

(statearr_32374_32562[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (95))){
var inst_32233 = (state_32336[(67)]);
var inst_32223 = (state_32336[(68)]);
var inst_32156 = (state_32336[(25)]);
var inst_32123 = (state_32336[(33)]);
var inst_32232 = (state_32336[(69)]);
var inst_32231 = (state_32336[(70)]);
var inst_32231__$1 = cljs.core.count.call(null,inst_32223);
var inst_32232__$1 = (inst_32156 + inst_32231__$1);
var inst_32233__$1 = (inst_32232__$1 - inst_32123);
var inst_32234 = cljs.core.pos_int_QMARK_.call(null,inst_32233__$1);
var state_32336__$1 = (function (){var statearr_32375 = state_32336;
(statearr_32375[(67)] = inst_32233__$1);

(statearr_32375[(69)] = inst_32232__$1);

(statearr_32375[(70)] = inst_32231__$1);

return statearr_32375;
})();
if(inst_32234){
var statearr_32376_32563 = state_32336__$1;
(statearr_32376_32563[(1)] = (98));

} else {
var statearr_32377_32564 = state_32336__$1;
(statearr_32377_32564[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (54))){
var inst_31997 = (state_32336[(13)]);
var inst_32094 = (state_32336[(22)]);
var inst_32022 = (state_32336[(27)]);
var inst_32067 = (state_32336[(32)]);
var inst_32076 = (state_32336[(34)]);
var inst_32013 = (state_32336[(37)]);
var inst_31991 = (state_32336[(39)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32118 = (state_32336[(50)]);
var inst_32112__$1 = (state_32336[(2)]);
var inst_32113 = fluree.db.flake.__GT_Flake.call(null,inst_32013,inst_32085,inst_32067,inst_31990,inst_31991,inst_32103);
var inst_32114 = fluree.db.flake.__GT_Flake.call(null,inst_32022,inst_32094,inst_32076,inst_31997,inst_31998,inst_32112__$1);
var inst_32115 = opts;
var inst_32116__$1 = cljs.core.__destructure_map.call(null,inst_32115);
var inst_32117 = cljs.core.get.call(null,inst_32116__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_32118__$1 = cljs.core.get.call(null,inst_32116__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_32119 = cljs.core.get.call(null,inst_32116__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_32336__$1 = (function (){var statearr_32378 = state_32336;
(statearr_32378[(10)] = inst_32114);

(statearr_32378[(28)] = inst_32117);

(statearr_32378[(71)] = inst_32119);

(statearr_32378[(38)] = inst_32113);

(statearr_32378[(44)] = inst_32116__$1);

(statearr_32378[(46)] = inst_32112__$1);

(statearr_32378[(50)] = inst_32118__$1);

return statearr_32378;
})();
if(cljs.core.truth_(inst_32118__$1)){
var statearr_32379_32565 = state_32336__$1;
(statearr_32379_32565[(1)] = (58));

} else {
var statearr_32380_32566 = state_32336__$1;
(statearr_32380_32566[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (92))){
var inst_32212 = (state_32336[(72)]);
var inst_32157 = (state_32336[(23)]);
var inst_32156 = (state_32336[(25)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32216 = (inst_32154 - inst_32212);
var inst_32217 = [inst_32216,inst_32155,inst_32156,inst_32157];
var inst_32218 = (new cljs.core.PersistentVector(null,4,(5),inst_32215,inst_32217,null));
var state_32336__$1 = state_32336;
var statearr_32381_32567 = state_32336__$1;
(statearr_32381_32567[(2)] = inst_32218);

(statearr_32381_32567[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (104))){
var inst_32274 = (state_32336[(2)]);
var inst_32275 = fluree.db.util.async.throw_err.call(null,inst_32274);
var state_32336__$1 = state_32336;
var statearr_32382_32568 = state_32336__$1;
(statearr_32382_32568[(2)] = inst_32275);

(statearr_32382_32568[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (15))){
var inst_31996 = (state_32336[(58)]);
var inst_32026 = cljs.core.boolean_QMARK_.call(null,inst_31996);
var state_32336__$1 = state_32336;
if(inst_32026){
var statearr_32383_32569 = state_32336__$1;
(statearr_32383_32569[(1)] = (17));

} else {
var statearr_32384_32570 = state_32336__$1;
(statearr_32384_32570[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (48))){
var inst_31999 = (state_32336[(56)]);
var inst_32103 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32385 = state_32336;
(statearr_32385[(41)] = inst_32103);

return statearr_32385;
})();
if(cljs.core.truth_(inst_31999)){
var statearr_32386_32571 = state_32336__$1;
(statearr_32386_32571[(1)] = (52));

} else {
var statearr_32387_32572 = state_32336__$1;
(statearr_32387_32572[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (50))){
var state_32336__$1 = state_32336;
var statearr_32388_32573 = state_32336__$1;
(statearr_32388_32573[(2)] = (2147483647));

(statearr_32388_32573[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (116))){
var inst_32308 = (state_32336[(66)]);
var inst_32316 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32389 = state_32336;
(statearr_32389[(73)] = inst_32316);

return statearr_32389;
})();
if(cljs.core.truth_(inst_32308)){
var statearr_32390_32574 = state_32336__$1;
(statearr_32390_32574[(1)] = (118));

} else {
var statearr_32391_32575 = state_32336__$1;
(statearr_32391_32575[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (75))){
var inst_32171 = (state_32336[(47)]);
var state_32336__$1 = state_32336;
var statearr_32392_32576 = state_32336__$1;
(statearr_32392_32576[(2)] = inst_32171);

(statearr_32392_32576[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (99))){
var inst_32232 = (state_32336[(69)]);
var inst_32241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32242 = [inst_32232,inst_32232];
var inst_32243 = (new cljs.core.PersistentVector(null,2,(5),inst_32241,inst_32242,null));
var state_32336__$1 = state_32336;
var statearr_32393_32577 = state_32336__$1;
(statearr_32393_32577[(2)] = inst_32243);

(statearr_32393_32577[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (21))){
var state_32336__$1 = state_32336;
var statearr_32394_32578 = state_32336__$1;
(statearr_32394_32578[(2)] = null);

(statearr_32394_32578[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (31))){
var inst_32057 = (state_32336[(74)]);
var state_32336__$1 = state_32336;
var statearr_32395_32579 = state_32336__$1;
(statearr_32395_32579[(2)] = inst_32057);

(statearr_32395_32579[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (113))){
var inst_32302 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32396_32580 = state_32336__$1;
(statearr_32396_32580[(2)] = inst_32302);

(statearr_32396_32580[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (32))){
var inst_31988 = (state_32336[(59)]);
var inst_32077 = (state_32336[(75)]);
var inst_32076 = (state_32336[(2)]);
var inst_32077__$1 = (inst_31988 == null);
var state_32336__$1 = (function (){var statearr_32397 = state_32336;
(statearr_32397[(34)] = inst_32076);

(statearr_32397[(75)] = inst_32077__$1);

return statearr_32397;
})();
if(cljs.core.truth_(inst_32077__$1)){
var statearr_32398_32581 = state_32336__$1;
(statearr_32398_32581[(1)] = (34));

} else {
var statearr_32399_32582 = state_32336__$1;
(statearr_32399_32582[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (40))){
var inst_32076 = (state_32336[(34)]);
var state_32336__$1 = state_32336;
var statearr_32400_32583 = state_32336__$1;
(statearr_32400_32583[(2)] = inst_32076);

(statearr_32400_32583[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (91))){
var inst_32190 = (state_32336[(65)]);
var inst_32288 = (state_32336[(2)]);
var inst_32289 = cljs.core.nth.call(null,inst_32288,(0),null);
var inst_32290 = cljs.core.nth.call(null,inst_32288,(1),null);
var inst_32291 = cljs.core.nth.call(null,inst_32288,(2),null);
var inst_32292 = cljs.core.nth.call(null,inst_32288,(3),null);
var state_32336__$1 = (function (){var statearr_32401 = state_32336;
(statearr_32401[(76)] = inst_32291);

(statearr_32401[(7)] = inst_32292);

(statearr_32401[(77)] = inst_32289);

(statearr_32401[(78)] = inst_32290);

return statearr_32401;
})();
if(cljs.core.truth_(inst_32190)){
var statearr_32402_32584 = state_32336__$1;
(statearr_32402_32584[(1)] = (105));

} else {
var statearr_32403_32585 = state_32336__$1;
(statearr_32403_32585[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (117))){
var inst_32312 = (state_32336[(2)]);
var inst_32313 = fluree.db.util.async.throw_err.call(null,inst_32312);
var state_32336__$1 = state_32336;
var statearr_32404_32586 = state_32336__$1;
(statearr_32404_32586[(2)] = inst_32313);

(statearr_32404_32586[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (108))){
var inst_32297 = (state_32336[(79)]);
var inst_32117 = (state_32336[(28)]);
var inst_32290 = (state_32336[(78)]);
var inst_32297__$1 = (inst_32290 < inst_32117);
var state_32336__$1 = (function (){var statearr_32405 = state_32336;
(statearr_32405[(79)] = inst_32297__$1);

return statearr_32405;
})();
if(cljs.core.truth_(inst_32297__$1)){
var statearr_32406_32587 = state_32336__$1;
(statearr_32406_32587[(1)] = (111));

} else {
var statearr_32407_32588 = state_32336__$1;
(statearr_32407_32588[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (56))){
var state_32336__$1 = state_32336;
var statearr_32408_32589 = state_32336__$1;
(statearr_32408_32589[(2)] = fluree.db.util.core.min_integer);

(statearr_32408_32589[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (33))){
var inst_32072 = (state_32336[(2)]);
var inst_32073 = fluree.db.util.async.throw_err.call(null,inst_32072);
var state_32336__$1 = state_32336;
var statearr_32409_32590 = state_32336__$1;
(statearr_32409_32590[(2)] = inst_32073);

(statearr_32409_32590[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (13))){
var inst_32018 = (state_32336[(2)]);
var inst_32019 = fluree.db.util.async.throw_err.call(null,inst_32018);
var state_32336__$1 = state_32336;
var statearr_32410_32591 = state_32336__$1;
(statearr_32410_32591[(2)] = inst_32019);

(statearr_32410_32591[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (22))){
var inst_32032 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32411_32592 = state_32336__$1;
(statearr_32411_32592[(2)] = inst_32032);

(statearr_32411_32592[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (90))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32212 = (state_32336[(72)]);
var inst_32134 = (state_32336[(12)]);
var inst_31997 = (state_32336[(13)]);
var inst_32140 = (state_32336[(14)]);
var inst_32144 = (state_32336[(8)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32124 = (state_32336[(17)]);
var inst_32058 = (state_32336[(18)]);
var inst_32135 = (state_32336[(19)]);
var inst_32001 = (state_32336[(20)]);
var inst_32130 = (state_32336[(21)]);
var inst_32094 = (state_32336[(22)]);
var inst_32157 = (state_32336[(23)]);
var inst_32129 = (state_32336[(24)]);
var inst_32156 = (state_32336[(25)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_32117 = (state_32336[(28)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32163 = (state_32336[(31)]);
var inst_32067 = (state_32336[(32)]);
var inst_32123 = (state_32336[(33)]);
var inst_32076 = (state_32336[(34)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32013 = (state_32336[(37)]);
var inst_32113 = (state_32336[(38)]);
var inst_31991 = (state_32336[(39)]);
var inst_32189 = (state_32336[(81)]);
var inst_31993 = (state_32336[(40)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32211 = (state_32336[(80)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32190 = (state_32336[(65)]);
var inst_32150 = (state_32336[(9)]);
var inst_32125 = (state_32336[(48)]);
var inst_32210 = (function (){var no_filter_QMARK_ = inst_32150;
var base_result_SINGLEQUOTE_ = inst_32189;
var t = inst_32130;
var max_limit_QMARK_ = inst_32124;
var next_node = inst_32153;
var fast_forward_db_QMARK_ = inst_32135;
var s1 = inst_32013;
var o2 = inst_32076;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var i = inst_32155;
var rhs = inst_32190;
var vec__31979 = inst_32054;
var m1 = inst_32103;
var root_node = inst_32140;
var s2 = inst_32022;
var p2 = inst_32094;
var permissions = inst_32125;
var limit = inst_32123;
var map__31978 = inst_32001;
var start_flake = inst_32113;
var flake_limit = inst_32117;
var offset = inst_32154;
var acc = inst_32157;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_32067;
var end_flake = inst_32114;
var base_result = inst_32163;
var map__31985 = inst_32116;
var s = inst_32156;
var node_start = inst_32144;
var p1 = inst_32085;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32058;
var idx_compare = inst_32129;
var op2 = inst_31998;
var m2 = inst_32112;
var vec__31982 = inst_32055;
var novelty = inst_32134;
return (function (p1__31957_SHARP_){
return p1__31957_SHARP_.s;
});
})();
var inst_32211__$1 = cljs.core.partition_by.call(null,inst_32210,inst_32189);
var inst_32212__$1 = cljs.core.count.call(null,inst_32211__$1);
var inst_32213 = (inst_32154 > inst_32212__$1);
var state_32336__$1 = (function (){var statearr_32412 = state_32336;
(statearr_32412[(72)] = inst_32212__$1);

(statearr_32412[(80)] = inst_32211__$1);

return statearr_32412;
})();
if(cljs.core.truth_(inst_32213)){
var statearr_32413_32593 = state_32336__$1;
(statearr_32413_32593[(1)] = (92));

} else {
var statearr_32414_32594 = state_32336__$1;
(statearr_32414_32594[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (109))){
var inst_32295 = (state_32336[(82)]);
var state_32336__$1 = state_32336;
var statearr_32415_32595 = state_32336__$1;
(statearr_32415_32595[(2)] = inst_32295);

(statearr_32415_32595[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (36))){
var inst_32081 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
if(cljs.core.truth_(inst_32081)){
var statearr_32416_32596 = state_32336__$1;
(statearr_32416_32596[(1)] = (37));

} else {
var statearr_32417_32597 = state_32336__$1;
(statearr_32417_32597[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (41))){
var inst_32086 = (state_32336[(63)]);
var state_32336__$1 = state_32336;
var statearr_32418_32598 = state_32336__$1;
(statearr_32418_32598[(2)] = inst_32086);

(statearr_32418_32598[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (118))){
var inst_32316 = (state_32336[(73)]);
var state_32336__$1 = state_32336;
var statearr_32419_32599 = state_32336__$1;
(statearr_32419_32599[(2)] = inst_32316);

(statearr_32419_32599[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (89))){
var inst_32157 = (state_32336[(23)]);
var inst_32156 = (state_32336[(25)]);
var inst_32117 = (state_32336[(28)]);
var inst_32155 = (state_32336[(35)]);
var inst_32189 = (state_32336[(81)]);
var inst_32201 = cljs.core.count.call(null,inst_32189);
var inst_32202 = (inst_32117 - inst_32155);
var inst_32203 = cljs.core.take.call(null,inst_32202,inst_32189);
var inst_32204 = cljs.core.into.call(null,inst_32157,inst_32203);
var inst_32205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32206 = (inst_32155 + inst_32201);
var inst_32207 = [(0),inst_32206,inst_32156,inst_32204];
var inst_32208 = (new cljs.core.PersistentVector(null,4,(5),inst_32205,inst_32207,null));
var state_32336__$1 = state_32336;
var statearr_32420_32600 = state_32336__$1;
(statearr_32420_32600[(2)] = inst_32208);

(statearr_32420_32600[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (100))){
var inst_32223 = (state_32336[(68)]);
var inst_32117 = (state_32336[(28)]);
var inst_32155 = (state_32336[(35)]);
var inst_32249 = (state_32336[(52)]);
var inst_32251 = (state_32336[(53)]);
var inst_32250 = (state_32336[(54)]);
var inst_32245 = (state_32336[(2)]);
var inst_32246 = cljs.core.nth.call(null,inst_32245,(0),null);
var inst_32247 = cljs.core.nth.call(null,inst_32245,(1),null);
var inst_32248 = cljs.core.take.call(null,inst_32247,inst_32223);
var inst_32249__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_32248);
var inst_32250__$1 = cljs.core.count.call(null,inst_32249__$1);
var inst_32251__$1 = (inst_32155 + inst_32250__$1);
var inst_32252 = (inst_32251__$1 > inst_32117);
var state_32336__$1 = (function (){var statearr_32421 = state_32336;
(statearr_32421[(83)] = inst_32246);

(statearr_32421[(52)] = inst_32249__$1);

(statearr_32421[(53)] = inst_32251__$1);

(statearr_32421[(54)] = inst_32250__$1);

return statearr_32421;
})();
if(cljs.core.truth_(inst_32252)){
var statearr_32422_32601 = state_32336__$1;
(statearr_32422_32601[(1)] = (101));

} else {
var statearr_32423_32602 = state_32336__$1;
(statearr_32423_32602[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (122))){
var inst_32291 = (state_32336[(76)]);
var inst_32316 = (state_32336[(73)]);
var inst_32292 = (state_32336[(7)]);
var inst_32289 = (state_32336[(77)]);
var inst_32290 = (state_32336[(78)]);
var inst_32153 = inst_32316;
var inst_32154 = inst_32289;
var inst_32155 = inst_32290;
var inst_32156 = inst_32291;
var inst_32157 = inst_32292;
var state_32336__$1 = (function (){var statearr_32424 = state_32336;
(statearr_32424[(11)] = inst_32153);

(statearr_32424[(23)] = inst_32157);

(statearr_32424[(25)] = inst_32156);

(statearr_32424[(35)] = inst_32155);

(statearr_32424[(36)] = inst_32154);

return statearr_32424;
})();
var statearr_32425_32603 = state_32336__$1;
(statearr_32425_32603[(2)] = null);

(statearr_32425_32603[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (43))){
var state_32336__$1 = state_32336;
var statearr_32426_32604 = state_32336__$1;
(statearr_32426_32604[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_32426_32604[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (61))){
var inst_32134 = (state_32336[(12)]);
var inst_32140 = (state_32336[(14)]);
var inst_32135 = (state_32336[(19)]);
var inst_32130 = (state_32336[(21)]);
var inst_32113 = (state_32336[(38)]);
var inst_32139 = (state_32336[(2)]);
var inst_32140__$1 = fluree.db.util.async.throw_err.call(null,inst_32139);
var inst_32141 = fluree.db.query.range.find_next_valid_node.call(null,inst_32140__$1,inst_32113,inst_32130,inst_32134,inst_32135);
var state_32336__$1 = (function (){var statearr_32427 = state_32336;
(statearr_32427[(14)] = inst_32140__$1);

return statearr_32427;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(62),inst_32141);
} else {
if((state_val_32337 === (29))){
var inst_32063 = (state_32336[(2)]);
var inst_32064 = fluree.db.util.async.throw_err.call(null,inst_32063);
var state_32336__$1 = state_32336;
var statearr_32428_32605 = state_32336__$1;
(statearr_32428_32605[(2)] = inst_32064);

(statearr_32428_32605[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (44))){
var inst_31995 = (state_32336[(61)]);
var state_32336__$1 = state_32336;
var statearr_32429_32606 = state_32336__$1;
(statearr_32429_32606[(2)] = inst_31995);

(statearr_32429_32606[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (93))){
var inst_32154 = (state_32336[(36)]);
var inst_32211 = (state_32336[(80)]);
var inst_32150 = (state_32336[(9)]);
var inst_32223 = cljs.core.drop.call(null,inst_32154,inst_32211);
var state_32336__$1 = (function (){var statearr_32430 = state_32336;
(statearr_32430[(68)] = inst_32223);

return statearr_32430;
})();
if(cljs.core.truth_(inst_32150)){
var statearr_32431_32607 = state_32336__$1;
(statearr_32431_32607[(1)] = (95));

} else {
var statearr_32432_32608 = state_32336__$1;
(statearr_32432_32608[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (6))){
var inst_31987 = (state_32336[(49)]);
var inst_32007 = fluree.db.dbproto._subid.call(null,db,inst_31987);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(9),inst_32007);
} else {
if((state_val_32337 === (111))){
var inst_32291 = (state_32336[(76)]);
var inst_32123 = (state_32336[(33)]);
var inst_32299 = (inst_32291 < inst_32123);
var state_32336__$1 = state_32336;
var statearr_32433_32609 = state_32336__$1;
(statearr_32433_32609[(2)] = inst_32299);

(statearr_32433_32609[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (28))){
var inst_32057 = (state_32336[(74)]);
var inst_32067 = (state_32336[(2)]);
var inst_32068 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_32057);
var state_32336__$1 = (function (){var statearr_32434 = state_32336;
(statearr_32434[(32)] = inst_32067);

return statearr_32434;
})();
if(inst_32068){
var statearr_32435_32610 = state_32336__$1;
(statearr_32435_32610[(1)] = (30));

} else {
var statearr_32436_32611 = state_32336__$1;
(statearr_32436_32611[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (64))){
var state_32336__$1 = state_32336;
var statearr_32437_32612 = state_32336__$1;
(statearr_32437_32612[(2)] = true);

(statearr_32437_32612[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (103))){
var inst_32246 = (state_32336[(83)]);
var inst_32265 = (state_32336[(2)]);
var inst_32266 = cljs.core.nth.call(null,inst_32265,(0),null);
var inst_32267 = cljs.core.nth.call(null,inst_32265,(1),null);
var inst_32268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32269 = [inst_32266,inst_32246,inst_32267];
var inst_32270 = (new cljs.core.PersistentVector(null,3,(5),inst_32268,inst_32269,null));
var state_32336__$1 = state_32336;
var statearr_32438_32613 = state_32336__$1;
(statearr_32438_32613[(2)] = inst_32270);

(statearr_32438_32613[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (51))){
var inst_32101 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32439_32614 = state_32336__$1;
(statearr_32439_32614[(2)] = inst_32101);

(statearr_32439_32614[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (25))){
var inst_32056 = (state_32336[(51)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32054__$1 = (state_32336[(2)]);
var inst_32055__$1 = cljs.core.nth.call(null,inst_32054__$1,(0),null);
var inst_32056__$1 = cljs.core.nth.call(null,inst_32055__$1,(0),null);
var inst_32057 = cljs.core.nth.call(null,inst_32055__$1,(1),null);
var inst_32058 = cljs.core.nth.call(null,inst_32054__$1,(1),null);
var inst_32059 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_32056__$1);
var state_32336__$1 = (function (){var statearr_32440 = state_32336;
(statearr_32440[(51)] = inst_32056__$1);

(statearr_32440[(74)] = inst_32057);

(statearr_32440[(18)] = inst_32058);

(statearr_32440[(29)] = inst_32054__$1);

(statearr_32440[(30)] = inst_32055__$1);

return statearr_32440;
})();
if(inst_32059){
var statearr_32441_32615 = state_32336__$1;
(statearr_32441_32615[(1)] = (26));

} else {
var statearr_32442_32616 = state_32336__$1;
(statearr_32442_32616[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (34))){
var inst_32067 = (state_32336[(32)]);
var state_32336__$1 = state_32336;
var statearr_32443_32617 = state_32336__$1;
(statearr_32443_32617[(2)] = inst_32067);

(statearr_32443_32617[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (17))){
var inst_31996 = (state_32336[(58)]);
var state_32336__$1 = state_32336;
var statearr_32444_32618 = state_32336__$1;
(statearr_32444_32618[(2)] = inst_31996);

(statearr_32444_32618[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (3))){
var inst_32334 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32336__$1,inst_32334);
} else {
if((state_val_32337 === (12))){
var inst_31989 = (state_32336[(62)]);
var inst_32022 = (state_32336[(2)]);
var inst_32023 = cljs.core.boolean_QMARK_.call(null,inst_31989);
var state_32336__$1 = (function (){var statearr_32445 = state_32336;
(statearr_32445[(27)] = inst_32022);

return statearr_32445;
})();
if(inst_32023){
var statearr_32446_32619 = state_32336__$1;
(statearr_32446_32619[(1)] = (14));

} else {
var statearr_32447_32620 = state_32336__$1;
(statearr_32447_32620[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (2))){
var inst_31986 = (state_32336[(16)]);
var inst_32001 = (state_32336[(20)]);
var inst_31987 = (state_32336[(49)]);
var inst_31993 = (state_32336[(40)]);
var _ = (function (){var statearr_32448 = state_32336;
(statearr_32448[(4)] = cljs.core.cons.call(null,(5),(state_32336[(4)])));

return statearr_32448;
})();
var inst_31986__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_31987__$1 = cljs.core.nth.call(null,inst_31986__$1,(0),null);
var inst_31988 = cljs.core.nth.call(null,inst_31986__$1,(1),null);
var inst_31989 = cljs.core.nth.call(null,inst_31986__$1,(2),null);
var inst_31990 = cljs.core.nth.call(null,inst_31986__$1,(3),null);
var inst_31991 = cljs.core.nth.call(null,inst_31986__$1,(4),null);
var inst_31992 = cljs.core.nth.call(null,inst_31986__$1,(5),null);
var inst_31993__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_31994 = cljs.core.nth.call(null,inst_31993__$1,(0),null);
var inst_31995 = cljs.core.nth.call(null,inst_31993__$1,(1),null);
var inst_31996 = cljs.core.nth.call(null,inst_31993__$1,(2),null);
var inst_31997 = cljs.core.nth.call(null,inst_31993__$1,(3),null);
var inst_31998 = cljs.core.nth.call(null,inst_31993__$1,(4),null);
var inst_31999 = cljs.core.nth.call(null,inst_31993__$1,(5),null);
var inst_32000 = opts;
var inst_32001__$1 = cljs.core.__destructure_map.call(null,inst_32000);
var inst_32002 = cljs.core.get.call(null,inst_32001__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_32003 = cljs.core.get.call(null,inst_32001__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_32004 = cljs.core.get.call(null,inst_32001__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_32005 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31987__$1);
var state_32336__$1 = (function (){var statearr_32449 = state_32336;
(statearr_32449[(13)] = inst_31997);

(statearr_32449[(56)] = inst_31999);

(statearr_32449[(15)] = inst_32003);

(statearr_32449[(16)] = inst_31986__$1);

(statearr_32449[(57)] = inst_32004);

(statearr_32449[(58)] = inst_31996);

(statearr_32449[(20)] = inst_32001__$1);

(statearr_32449[(59)] = inst_31988);

(statearr_32449[(26)] = inst_32002);

(statearr_32449[(49)] = inst_31987__$1);

(statearr_32449[(60)] = inst_31992);

(statearr_32449[(61)] = inst_31995);

(statearr_32449[(39)] = inst_31991);

(statearr_32449[(40)] = inst_31993__$1);

(statearr_32449[(43)] = inst_31990);

(statearr_32449[(45)] = inst_31998);

(statearr_32449[(62)] = inst_31989);

(statearr_32449[(84)] = inst_31994);

return statearr_32449;
})();
if(inst_32005){
var statearr_32450_32621 = state_32336__$1;
(statearr_32450_32621[(1)] = (6));

} else {
var statearr_32451_32622 = state_32336__$1;
(statearr_32451_32622[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (66))){
var inst_32144 = (state_32336[(8)]);
var inst_32119 = (state_32336[(71)]);
var inst_32152 = cljs.core.PersistentVector.EMPTY;
var inst_32153 = inst_32144;
var inst_32154 = inst_32119;
var inst_32155 = (0);
var inst_32156 = (0);
var inst_32157 = inst_32152;
var state_32336__$1 = (function (){var statearr_32452 = state_32336;
(statearr_32452[(11)] = inst_32153);

(statearr_32452[(23)] = inst_32157);

(statearr_32452[(25)] = inst_32156);

(statearr_32452[(35)] = inst_32155);

(statearr_32452[(36)] = inst_32154);

return statearr_32452;
})();
var statearr_32453_32623 = state_32336__$1;
(statearr_32453_32623[(2)] = null);

(statearr_32453_32623[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (107))){
var inst_32308 = (state_32336[(66)]);
var inst_32308__$1 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32454 = state_32336;
(statearr_32454[(66)] = inst_32308__$1);

return statearr_32454;
})();
if(cljs.core.truth_(inst_32308__$1)){
var statearr_32455_32624 = state_32336__$1;
(statearr_32455_32624[(1)] = (114));

} else {
var statearr_32456_32625 = state_32336__$1;
(statearr_32456_32625[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (23))){
var inst_32004 = (state_32336[(57)]);
var inst_31996 = (state_32336[(58)]);
var inst_31989 = (state_32336[(62)]);
var inst_32039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32041 = [inst_31989,inst_31996];
var inst_32042 = (new cljs.core.PersistentVector(null,2,(5),inst_32040,inst_32041,null));
var inst_32043 = [inst_32042,inst_32004];
var inst_32044 = (new cljs.core.PersistentVector(null,2,(5),inst_32039,inst_32043,null));
var state_32336__$1 = state_32336;
var statearr_32457_32626 = state_32336__$1;
(statearr_32457_32626[(2)] = inst_32044);

(statearr_32457_32626[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (47))){
var inst_32097 = (cljs.core._GT__EQ_ === start_test);
var state_32336__$1 = state_32336;
if(cljs.core.truth_(inst_32097)){
var statearr_32458_32627 = state_32336__$1;
(statearr_32458_32627[(1)] = (49));

} else {
var statearr_32459_32628 = state_32336__$1;
(statearr_32459_32628[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (35))){
var inst_32077 = (state_32336[(75)]);
var state_32336__$1 = state_32336;
var statearr_32460_32629 = state_32336__$1;
(statearr_32460_32629[(2)] = inst_32077);

(statearr_32460_32629[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (82))){
var inst_32153 = (state_32336[(11)]);
var inst_32124 = (state_32336[(17)]);
var inst_32189 = (state_32336[(2)]);
var inst_32190 = fluree.db.dbproto._rhs.call(null,inst_32153);
var state_32336__$1 = (function (){var statearr_32461 = state_32336;
(statearr_32461[(81)] = inst_32189);

(statearr_32461[(65)] = inst_32190);

return statearr_32461;
})();
if(cljs.core.truth_(inst_32124)){
var statearr_32462_32630 = state_32336__$1;
(statearr_32462_32630[(1)] = (83));

} else {
var statearr_32463_32631 = state_32336__$1;
(statearr_32463_32631[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (76))){
var inst_32003 = (state_32336[(15)]);
var inst_32177 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32464 = state_32336;
(statearr_32464[(64)] = inst_32177);

return statearr_32464;
})();
if(cljs.core.truth_(inst_32003)){
var statearr_32465_32632 = state_32336__$1;
(statearr_32465_32632[(1)] = (77));

} else {
var statearr_32466_32633 = state_32336__$1;
(statearr_32466_32633[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (97))){
var inst_32157 = (state_32336[(23)]);
var inst_32277 = (state_32336[(2)]);
var inst_32278 = cljs.core.nth.call(null,inst_32277,(0),null);
var inst_32279 = cljs.core.nth.call(null,inst_32277,(1),null);
var inst_32280 = cljs.core.nth.call(null,inst_32277,(2),null);
var inst_32281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32282 = cljs.core.into.call(null,inst_32157,inst_32280);
var inst_32283 = [(0),inst_32278,inst_32279,inst_32282];
var inst_32284 = (new cljs.core.PersistentVector(null,4,(5),inst_32281,inst_32283,null));
var state_32336__$1 = state_32336;
var statearr_32467_32634 = state_32336__$1;
(statearr_32467_32634[(2)] = inst_32284);

(statearr_32467_32634[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (19))){
var inst_32034 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32468_32635 = state_32336__$1;
(statearr_32468_32635[(2)] = inst_32034);

(statearr_32468_32635[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (57))){
var inst_32110 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32469_32636 = state_32336__$1;
(statearr_32469_32636[(2)] = inst_32110);

(statearr_32469_32636[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (68))){
var inst_32331 = (state_32336[(2)]);
var _ = (function (){var statearr_32470 = state_32336;
(statearr_32470[(4)] = cljs.core.rest.call(null,(state_32336[(4)])));

return statearr_32470;
})();
var state_32336__$1 = state_32336;
var statearr_32471_32637 = state_32336__$1;
(statearr_32471_32637[(2)] = inst_32331);

(statearr_32471_32637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (11))){
var inst_31994 = (state_32336[(84)]);
var state_32336__$1 = state_32336;
var statearr_32472_32638 = state_32336__$1;
(statearr_32472_32638[(2)] = inst_31994);

(statearr_32472_32638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (115))){
var state_32336__$1 = state_32336;
var statearr_32474_32639 = state_32336__$1;
(statearr_32474_32639[(2)] = null);

(statearr_32474_32639[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (9))){
var inst_32009 = (state_32336[(2)]);
var inst_32010 = fluree.db.util.async.throw_err.call(null,inst_32009);
var state_32336__$1 = state_32336;
var statearr_32475_32640 = state_32336__$1;
(statearr_32475_32640[(2)] = inst_32010);

(statearr_32475_32640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (5))){
var _ = (function (){var statearr_32476 = state_32336;
(statearr_32476[(4)] = cljs.core.rest.call(null,(state_32336[(4)])));

return statearr_32476;
})();
var state_32336__$1 = state_32336;
var ex32473 = (state_32336__$1[(2)]);
var statearr_32477_32641 = state_32336__$1;
(statearr_32477_32641[(5)] = ex32473);


if((ex32473 instanceof Error)){
var statearr_32478_32642 = state_32336__$1;
(statearr_32478_32642[(1)] = (4));

(statearr_32478_32642[(5)] = null);

} else {
throw ex32473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (112))){
var inst_32297 = (state_32336[(79)]);
var state_32336__$1 = state_32336;
var statearr_32479_32643 = state_32336__$1;
(statearr_32479_32643[(2)] = inst_32297);

(statearr_32479_32643[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (83))){
var inst_32192 = (state_32336[(85)]);
var inst_32154 = (state_32336[(36)]);
var inst_32192__$1 = cljs.core._EQ_.call(null,(0),inst_32154);
var state_32336__$1 = (function (){var statearr_32480 = state_32336;
(statearr_32480[(85)] = inst_32192__$1);

return statearr_32480;
})();
if(inst_32192__$1){
var statearr_32481_32644 = state_32336__$1;
(statearr_32481_32644[(1)] = (86));

} else {
var statearr_32482_32645 = state_32336__$1;
(statearr_32482_32645[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (14))){
var inst_31989 = (state_32336[(62)]);
var state_32336__$1 = state_32336;
var statearr_32483_32646 = state_32336__$1;
(statearr_32483_32646[(2)] = inst_31989);

(statearr_32483_32646[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (45))){
var inst_31992 = (state_32336[(60)]);
var inst_32094 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32484 = state_32336;
(statearr_32484[(22)] = inst_32094);

return statearr_32484;
})();
if(cljs.core.truth_(inst_31992)){
var statearr_32485_32647 = state_32336__$1;
(statearr_32485_32647[(1)] = (46));

} else {
var statearr_32486_32648 = state_32336__$1;
(statearr_32486_32648[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (53))){
var inst_32106 = (cljs.core._LT__EQ_ === end_test);
var state_32336__$1 = state_32336;
if(cljs.core.truth_(inst_32106)){
var statearr_32487_32649 = state_32336__$1;
(statearr_32487_32649[(1)] = (55));

} else {
var statearr_32488_32650 = state_32336__$1;
(statearr_32488_32650[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (78))){
var inst_32177 = (state_32336[(64)]);
var state_32336__$1 = state_32336;
var statearr_32489_32651 = state_32336__$1;
(statearr_32489_32651[(2)] = inst_32177);

(statearr_32489_32651[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (26))){
var inst_32056 = (state_32336[(51)]);
var inst_32061 = fluree.db.dbproto._subid.call(null,db,inst_32056);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(29),inst_32061);
} else {
if((state_val_32337 === (123))){
var inst_32326 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32490_32652 = state_32336__$1;
(statearr_32490_32652[(2)] = inst_32326);

(statearr_32490_32652[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (16))){
var inst_32036 = (state_32336[(55)]);
var inst_32036__$1 = (state_32336[(2)]);
var inst_32037 = (inst_32036__$1 == null);
var state_32336__$1 = (function (){var statearr_32491 = state_32336;
(statearr_32491[(55)] = inst_32036__$1);

return statearr_32491;
})();
if(cljs.core.truth_(inst_32037)){
var statearr_32492_32653 = state_32336__$1;
(statearr_32492_32653[(1)] = (23));

} else {
var statearr_32493_32654 = state_32336__$1;
(statearr_32493_32654[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (81))){
var inst_32183 = (state_32336[(86)]);
var state_32336__$1 = state_32336;
var statearr_32494_32655 = state_32336__$1;
(statearr_32494_32655[(2)] = inst_32183);

(statearr_32494_32655[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (120))){
var inst_32320 = (state_32336[(2)]);
var inst_32321 = cljs.core.not.call(null,inst_32320);
var state_32336__$1 = state_32336;
if(inst_32321){
var statearr_32495_32656 = state_32336__$1;
(statearr_32495_32656[(1)] = (121));

} else {
var statearr_32496_32657 = state_32336__$1;
(statearr_32496_32657[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (79))){
var inst_32058 = (state_32336[(18)]);
var inst_32183 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32497 = state_32336;
(statearr_32497[(86)] = inst_32183);

return statearr_32497;
})();
if(cljs.core.truth_(inst_32058)){
var statearr_32498_32658 = state_32336__$1;
(statearr_32498_32658[(1)] = (80));

} else {
var statearr_32499_32659 = state_32336__$1;
(statearr_32499_32659[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (38))){
var inst_31988 = (state_32336[(59)]);
var state_32336__$1 = state_32336;
var statearr_32500_32660 = state_32336__$1;
(statearr_32500_32660[(2)] = inst_31988);

(statearr_32500_32660[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (98))){
var inst_32233 = (state_32336[(67)]);
var inst_32123 = (state_32336[(33)]);
var inst_32231 = (state_32336[(70)]);
var inst_32236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32237 = (inst_32231 - inst_32233);
var inst_32238 = [inst_32123,inst_32237];
var inst_32239 = (new cljs.core.PersistentVector(null,2,(5),inst_32236,inst_32238,null));
var state_32336__$1 = state_32336;
var statearr_32501_32661 = state_32336__$1;
(statearr_32501_32661[(2)] = inst_32239);

(statearr_32501_32661[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (87))){
var inst_32192 = (state_32336[(85)]);
var state_32336__$1 = state_32336;
var statearr_32502_32662 = state_32336__$1;
(statearr_32502_32662[(2)] = inst_32192);

(statearr_32502_32662[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (30))){
var inst_32057 = (state_32336[(74)]);
var inst_32070 = fluree.db.dbproto._subid.call(null,db,inst_32057);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(33),inst_32070);
} else {
if((state_val_32337 === (73))){
var inst_32002 = (state_32336[(26)]);
var inst_32171 = (state_32336[(2)]);
var state_32336__$1 = (function (){var statearr_32503 = state_32336;
(statearr_32503[(47)] = inst_32171);

return statearr_32503;
})();
if(cljs.core.truth_(inst_32002)){
var statearr_32504_32663 = state_32336__$1;
(statearr_32504_32663[(1)] = (74));

} else {
var statearr_32505_32664 = state_32336__$1;
(statearr_32505_32664[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (96))){
var inst_32223 = (state_32336[(68)]);
var inst_32156 = (state_32336[(25)]);
var inst_32117 = (state_32336[(28)]);
var inst_32123 = (state_32336[(33)]);
var inst_32155 = (state_32336[(35)]);
var inst_32272 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_32223,inst_32155,inst_32156,inst_32117,inst_32123);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(104),inst_32272);
} else {
if((state_val_32337 === (10))){
var inst_31994 = (state_32336[(84)]);
var inst_32016 = fluree.db.dbproto._subid.call(null,db,inst_31994);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(13),inst_32016);
} else {
if((state_val_32337 === (18))){
var state_32336__$1 = state_32336;
var statearr_32506_32665 = state_32336__$1;
(statearr_32506_32665[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (105))){
var inst_32114 = (state_32336[(10)]);
var inst_32295 = (state_32336[(82)]);
var inst_32129 = (state_32336[(24)]);
var inst_32190 = (state_32336[(65)]);
var inst_32294 = inst_32129.call(null,inst_32190,inst_32114);
var inst_32295__$1 = (inst_32294 < (0));
var state_32336__$1 = (function (){var statearr_32508 = state_32336;
(statearr_32508[(82)] = inst_32295__$1);

return statearr_32508;
})();
if(cljs.core.truth_(inst_32295__$1)){
var statearr_32509_32666 = state_32336__$1;
(statearr_32509_32666[(1)] = (108));

} else {
var statearr_32510_32667 = state_32336__$1;
(statearr_32510_32667[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (52))){
var inst_31999 = (state_32336[(56)]);
var state_32336__$1 = state_32336;
var statearr_32511_32668 = state_32336__$1;
(statearr_32511_32668[(2)] = inst_31999);

(statearr_32511_32668[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (114))){
var inst_32134 = (state_32336[(12)]);
var inst_32140 = (state_32336[(14)]);
var inst_32135 = (state_32336[(19)]);
var inst_32130 = (state_32336[(21)]);
var inst_32190 = (state_32336[(65)]);
var inst_32310 = fluree.db.query.range.find_next_valid_node.call(null,inst_32140,inst_32190,inst_32130,inst_32134,inst_32135);
var state_32336__$1 = state_32336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32336__$1,(117),inst_32310);
} else {
if((state_val_32337 === (67))){
var state_32336__$1 = state_32336;
var statearr_32512_32669 = state_32336__$1;
(statearr_32512_32669[(2)] = null);

(statearr_32512_32669[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (71))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32134 = (state_32336[(12)]);
var inst_31997 = (state_32336[(13)]);
var inst_32140 = (state_32336[(14)]);
var inst_32144 = (state_32336[(8)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32124 = (state_32336[(17)]);
var inst_32058 = (state_32336[(18)]);
var inst_32135 = (state_32336[(19)]);
var inst_32001 = (state_32336[(20)]);
var inst_32130 = (state_32336[(21)]);
var inst_32094 = (state_32336[(22)]);
var inst_32157 = (state_32336[(23)]);
var inst_32129 = (state_32336[(24)]);
var inst_32156 = (state_32336[(25)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_32117 = (state_32336[(28)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32163 = (state_32336[(31)]);
var inst_32067 = (state_32336[(32)]);
var inst_32123 = (state_32336[(33)]);
var inst_32076 = (state_32336[(34)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32013 = (state_32336[(37)]);
var inst_32113 = (state_32336[(38)]);
var inst_31991 = (state_32336[(39)]);
var inst_31993 = (state_32336[(40)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32150 = (state_32336[(9)]);
var inst_32125 = (state_32336[(48)]);
var inst_32167 = (function (){var no_filter_QMARK_ = inst_32150;
var t = inst_32130;
var max_limit_QMARK_ = inst_32124;
var next_node = inst_32153;
var fast_forward_db_QMARK_ = inst_32135;
var s1 = inst_32013;
var o2 = inst_32076;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var i = inst_32155;
var vec__31979 = inst_32054;
var m1 = inst_32103;
var root_node = inst_32140;
var s2 = inst_32022;
var p2 = inst_32094;
var permissions = inst_32125;
var G__32164 = inst_32163;
var limit = inst_32123;
var map__31978 = inst_32001;
var start_flake = inst_32113;
var flake_limit = inst_32117;
var offset = inst_32154;
var acc = inst_32157;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_32067;
var end_flake = inst_32114;
var base_result = inst_32163;
var map__31985 = inst_32116;
var s = inst_32156;
var node_start = inst_32144;
var p1 = inst_32085;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32058;
var idx_compare = inst_32129;
var op2 = inst_31998;
var m2 = inst_32112;
var vec__31982 = inst_32055;
var novelty = inst_32134;
return (function (p1__31953_SHARP_){
return cljs.core._EQ_.call(null,p1__31953_SHARP_.o,start_flake.o);
});
})();
var inst_32168 = cljs.core.filter.call(null,inst_32167,inst_32163);
var state_32336__$1 = state_32336;
var statearr_32513_32670 = state_32336__$1;
(statearr_32513_32670[(2)] = inst_32168);

(statearr_32513_32670[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (42))){
var inst_32090 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
if(cljs.core.truth_(inst_32090)){
var statearr_32514_32671 = state_32336__$1;
(statearr_32514_32671[(1)] = (43));

} else {
var statearr_32515_32672 = state_32336__$1;
(statearr_32515_32672[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (80))){
var inst_32114 = (state_32336[(10)]);
var inst_32153 = (state_32336[(11)]);
var inst_32134 = (state_32336[(12)]);
var inst_31997 = (state_32336[(13)]);
var inst_32140 = (state_32336[(14)]);
var inst_32144 = (state_32336[(8)]);
var inst_32003 = (state_32336[(15)]);
var inst_31986 = (state_32336[(16)]);
var inst_32124 = (state_32336[(17)]);
var inst_32058 = (state_32336[(18)]);
var inst_32135 = (state_32336[(19)]);
var inst_32001 = (state_32336[(20)]);
var inst_32130 = (state_32336[(21)]);
var inst_32094 = (state_32336[(22)]);
var inst_32157 = (state_32336[(23)]);
var inst_32129 = (state_32336[(24)]);
var inst_32156 = (state_32336[(25)]);
var inst_32002 = (state_32336[(26)]);
var inst_32022 = (state_32336[(27)]);
var inst_32117 = (state_32336[(28)]);
var inst_32054 = (state_32336[(29)]);
var inst_32055 = (state_32336[(30)]);
var inst_32163 = (state_32336[(31)]);
var inst_32067 = (state_32336[(32)]);
var inst_32123 = (state_32336[(33)]);
var inst_32076 = (state_32336[(34)]);
var inst_32155 = (state_32336[(35)]);
var inst_32154 = (state_32336[(36)]);
var inst_32013 = (state_32336[(37)]);
var inst_32113 = (state_32336[(38)]);
var inst_31991 = (state_32336[(39)]);
var inst_31993 = (state_32336[(40)]);
var inst_32103 = (state_32336[(41)]);
var inst_32085 = (state_32336[(42)]);
var inst_31990 = (state_32336[(43)]);
var inst_32116 = (state_32336[(44)]);
var inst_31998 = (state_32336[(45)]);
var inst_32112 = (state_32336[(46)]);
var inst_32150 = (state_32336[(9)]);
var inst_32183 = (state_32336[(86)]);
var inst_32125 = (state_32336[(48)]);
var inst_32185 = (function (){var no_filter_QMARK_ = inst_32150;
var t = inst_32130;
var max_limit_QMARK_ = inst_32124;
var next_node = inst_32153;
var fast_forward_db_QMARK_ = inst_32135;
var s1 = inst_32013;
var o2 = inst_32076;
var t1 = inst_31990;
var predicate_fn = inst_32003;
var i = inst_32155;
var vec__31979 = inst_32054;
var m1 = inst_32103;
var root_node = inst_32140;
var s2 = inst_32022;
var p2 = inst_32094;
var permissions = inst_32125;
var G__32164 = inst_32183;
var limit = inst_32123;
var map__31978 = inst_32001;
var start_flake = inst_32113;
var flake_limit = inst_32117;
var offset = inst_32154;
var acc = inst_32157;
var t2 = inst_31997;
var op1 = inst_31991;
var o1 = inst_32067;
var end_flake = inst_32114;
var base_result = inst_32163;
var map__31985 = inst_32116;
var s = inst_32156;
var node_start = inst_32144;
var p1 = inst_32085;
var subject_fn = inst_32002;
var vec__31972 = inst_31986;
var vec__31975 = inst_31993;
var object_fn = inst_32058;
var idx_compare = inst_32129;
var op2 = inst_31998;
var m2 = inst_32112;
var vec__31982 = inst_32055;
var novelty = inst_32134;
return (function (p1__31956_SHARP_){
return object_fn.call(null,p1__31956_SHARP_.o);
});
})();
var inst_32186 = cljs.core.filter.call(null,inst_32185,inst_32183);
var state_32336__$1 = state_32336;
var statearr_32516_32673 = state_32336__$1;
(statearr_32516_32673[(2)] = inst_32186);

(statearr_32516_32673[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (37))){
var state_32336__$1 = state_32336;
var statearr_32517_32674 = state_32336__$1;
(statearr_32517_32674[(2)] = (-1));

(statearr_32517_32674[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (63))){
var inst_32094 = (state_32336[(22)]);
var inst_32022 = (state_32336[(27)]);
var inst_32013 = (state_32336[(37)]);
var inst_32085 = (state_32336[(42)]);
var inst_32125 = (state_32336[(48)]);
var inst_32147 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_32125,inst_32013,inst_32022,inst_32085,inst_32094);
var state_32336__$1 = state_32336;
var statearr_32518_32675 = state_32336__$1;
(statearr_32518_32675[(2)] = inst_32147);

(statearr_32518_32675[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (94))){
var inst_32286 = (state_32336[(2)]);
var state_32336__$1 = state_32336;
var statearr_32519_32676 = state_32336__$1;
(statearr_32519_32676[(2)] = inst_32286);

(statearr_32519_32676[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (8))){
var inst_31994 = (state_32336[(84)]);
var inst_32013 = (state_32336[(2)]);
var inst_32014 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_31994);
var state_32336__$1 = (function (){var statearr_32520 = state_32336;
(statearr_32520[(37)] = inst_32013);

return statearr_32520;
})();
if(inst_32014){
var statearr_32521_32677 = state_32336__$1;
(statearr_32521_32677[(1)] = (10));

} else {
var statearr_32522_32678 = state_32336__$1;
(statearr_32522_32678[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (49))){
var state_32336__$1 = state_32336;
var statearr_32523_32679 = state_32336__$1;
(statearr_32523_32679[(2)] = fluree.db.util.core.min_integer);

(statearr_32523_32679[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32337 === (84))){
var inst_32124 = (state_32336[(17)]);
var state_32336__$1 = state_32336;
var statearr_32524_32680 = state_32336__$1;
(statearr_32524_32680[(2)] = inst_32124);

(statearr_32524_32680[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16221__auto__ = null;
var fluree$db$query$range$state_machine__16221__auto____0 = (function (){
var statearr_32525 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32525[(0)] = fluree$db$query$range$state_machine__16221__auto__);

(statearr_32525[(1)] = (1));

return statearr_32525;
});
var fluree$db$query$range$state_machine__16221__auto____1 = (function (state_32336){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_32336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e32526){var ex__16224__auto__ = e32526;
var statearr_32527_32681 = state_32336;
(statearr_32527_32681[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_32336[(4)]))){
var statearr_32528_32682 = state_32336;
(statearr_32528_32682[(1)] = cljs.core.first.call(null,(state_32336[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32683 = state_32336;
state_32336 = G__32683;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16221__auto__ = function(state_32336){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16221__auto____1.call(this,state_32336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16221__auto____0;
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16221__auto____1;
return fluree$db$query$range$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_32529 = f__16346__auto__.call(null);
(statearr_32529[(6)] = c__16345__auto__);

return statearr_32529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_32739){
var state_val_32740 = (state_32739[(1)]);
if((state_val_32740 === (7))){
var inst_32713 = (state_32739[(7)]);
var inst_32703 = (state_32739[(8)]);
var inst_32711 = fluree.db.flake.Flake__GT_parts.call(null,inst_32703);
var inst_32712 = cljs.core.nth.call(null,inst_32711,(0),null);
var inst_32713__$1 = cljs.core.nth.call(null,inst_32711,(1),null);
var inst_32714 = cljs.core.nth.call(null,inst_32711,(2),null);
var inst_32715 = cljs.core.nth.call(null,inst_32711,(3),null);
var inst_32716 = cljs.core.nth.call(null,inst_32711,(4),null);
var inst_32717 = cljs.core.nth.call(null,inst_32711,(5),null);
var inst_32718 = fluree.db.dbproto._tag.call(null,db,inst_32714,inst_32713__$1);
var state_32739__$1 = (function (){var statearr_32741 = state_32739;
(statearr_32741[(7)] = inst_32713__$1);

(statearr_32741[(9)] = inst_32716);

(statearr_32741[(10)] = inst_32715);

(statearr_32741[(11)] = inst_32712);

(statearr_32741[(12)] = inst_32717);

return statearr_32741;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32739__$1,(10),inst_32718);
} else {
if((state_val_32740 === (1))){
var inst_32691 = flakes;
var inst_32692 = cljs.core.seq.call(null,inst_32691);
var inst_32693 = cljs.core.first.call(null,inst_32692);
var inst_32694 = cljs.core.next.call(null,inst_32692);
var inst_32695 = cljs.core.PersistentVector.EMPTY;
var inst_32696 = inst_32691;
var inst_32697 = inst_32695;
var state_32739__$1 = (function (){var statearr_32742 = state_32739;
(statearr_32742[(13)] = inst_32693);

(statearr_32742[(14)] = inst_32694);

(statearr_32742[(15)] = inst_32697);

(statearr_32742[(16)] = inst_32696);

return statearr_32742;
})();
var statearr_32743_32761 = state_32739__$1;
(statearr_32743_32761[(2)] = null);

(statearr_32743_32761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (4))){
var inst_32703 = (state_32739[(8)]);
var inst_32706 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_32703);
var state_32739__$1 = state_32739;
if(inst_32706){
var statearr_32744_32762 = state_32739__$1;
(statearr_32744_32762[(1)] = (7));

} else {
var statearr_32745_32763 = state_32739__$1;
(statearr_32745_32763[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (6))){
var inst_32735 = (state_32739[(2)]);
var state_32739__$1 = state_32739;
var statearr_32746_32764 = state_32739__$1;
(statearr_32746_32764[(2)] = inst_32735);

(statearr_32746_32764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (3))){
var inst_32737 = (state_32739[(2)]);
var state_32739__$1 = state_32739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32739__$1,inst_32737);
} else {
if((state_val_32740 === (2))){
var inst_32703 = (state_32739[(8)]);
var inst_32696 = (state_32739[(16)]);
var inst_32702 = cljs.core.seq.call(null,inst_32696);
var inst_32703__$1 = cljs.core.first.call(null,inst_32702);
var inst_32704 = cljs.core.next.call(null,inst_32702);
var state_32739__$1 = (function (){var statearr_32747 = state_32739;
(statearr_32747[(17)] = inst_32704);

(statearr_32747[(8)] = inst_32703__$1);

return statearr_32747;
})();
if(cljs.core.truth_(inst_32703__$1)){
var statearr_32748_32765 = state_32739__$1;
(statearr_32748_32765[(1)] = (4));

} else {
var statearr_32749_32766 = state_32739__$1;
(statearr_32749_32766[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (9))){
var inst_32732 = (state_32739[(2)]);
var state_32739__$1 = state_32739;
var statearr_32750_32767 = state_32739__$1;
(statearr_32750_32767[(2)] = inst_32732);

(statearr_32750_32767[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (5))){
var inst_32697 = (state_32739[(15)]);
var state_32739__$1 = state_32739;
var statearr_32751_32768 = state_32739__$1;
(statearr_32751_32768[(2)] = inst_32697);

(statearr_32751_32768[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (10))){
var inst_32704 = (state_32739[(17)]);
var inst_32713 = (state_32739[(7)]);
var inst_32716 = (state_32739[(9)]);
var inst_32715 = (state_32739[(10)]);
var inst_32697 = (state_32739[(15)]);
var inst_32712 = (state_32739[(11)]);
var inst_32717 = (state_32739[(12)]);
var inst_32720 = (state_32739[(2)]);
var inst_32721 = fluree.db.util.async.throw_err.call(null,inst_32720);
var inst_32722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32723 = [inst_32712,inst_32713,inst_32721,inst_32715,inst_32716,inst_32717];
var inst_32724 = (new cljs.core.PersistentVector(null,6,(5),inst_32722,inst_32723,null));
var inst_32725 = fluree.db.flake.parts__GT_Flake.call(null,inst_32724);
var inst_32726 = cljs.core.conj.call(null,inst_32697,inst_32725);
var inst_32696 = inst_32704;
var inst_32697__$1 = inst_32726;
var state_32739__$1 = (function (){var statearr_32752 = state_32739;
(statearr_32752[(15)] = inst_32697__$1);

(statearr_32752[(16)] = inst_32696);

return statearr_32752;
})();
var statearr_32753_32769 = state_32739__$1;
(statearr_32753_32769[(2)] = null);

(statearr_32753_32769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32740 === (8))){
var inst_32704 = (state_32739[(17)]);
var inst_32697 = (state_32739[(15)]);
var inst_32703 = (state_32739[(8)]);
var inst_32729 = cljs.core.conj.call(null,inst_32697,inst_32703);
var inst_32696 = inst_32704;
var inst_32697__$1 = inst_32729;
var state_32739__$1 = (function (){var statearr_32754 = state_32739;
(statearr_32754[(15)] = inst_32697__$1);

(statearr_32754[(16)] = inst_32696);

return statearr_32754;
})();
var statearr_32755_32770 = state_32739__$1;
(statearr_32755_32770[(2)] = null);

(statearr_32755_32770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____0 = (function (){
var statearr_32756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32756[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__);

(statearr_32756[(1)] = (1));

return statearr_32756;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____1 = (function (state_32739){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_32739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e32757){var ex__16224__auto__ = e32757;
var statearr_32758_32771 = state_32739;
(statearr_32758_32771[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_32739[(4)]))){
var statearr_32759_32772 = state_32739;
(statearr_32759_32772[(1)] = cljs.core.first.call(null,(state_32739[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32773 = state_32739;
state_32739 = G__32773;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__ = function(state_32739){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____1.call(this,state_32739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_32760 = f__16346__auto__.call(null);
(statearr_32760[(6)] = c__16345__auto__);

return statearr_32760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__32775 = arguments.length;
switch (G__32775) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_32945){
var state_val_32946 = (state_32945[(1)]);
if((state_val_32946 === (65))){
var state_32945__$1 = state_32945;
var statearr_32947_33047 = state_32945__$1;
(statearr_32947_33047[(2)] = null);

(statearr_32947_33047[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (70))){
var inst_32940 = (state_32945[(2)]);
var _ = (function (){var statearr_32948 = state_32945;
(statearr_32948[(4)] = cljs.core.rest.call(null,(state_32945[(4)])));

return statearr_32948;
})();
var state_32945__$1 = state_32945;
var statearr_32949_33048 = state_32945__$1;
(statearr_32949_33048[(2)] = inst_32940);

(statearr_32949_33048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (62))){
var inst_32926 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32950_33049 = state_32945__$1;
(statearr_32950_33049[(2)] = inst_32926);

(statearr_32950_33049[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (7))){
var state_32945__$1 = state_32945;
var statearr_32951_33050 = state_32945__$1;
(statearr_32951_33050[(2)] = false);

(statearr_32951_33050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (59))){
var inst_32900 = (state_32945[(2)]);
var inst_32901 = fluree.db.util.async.throw_err.call(null,inst_32900);
var state_32945__$1 = state_32945;
var statearr_32952_33051 = state_32945__$1;
(statearr_32952_33051[(2)] = inst_32901);

(statearr_32952_33051[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (20))){
var state_32945__$1 = state_32945;
var statearr_32953_33052 = state_32945__$1;
(statearr_32953_33052[(2)] = null);

(statearr_32953_33052[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (58))){
var inst_32890 = (state_32945[(2)]);
var inst_32891 = fluree.db.util.async.throw_err.call(null,inst_32890);
var inst_32892 = cljs.core.take.call(null,(1),inst_32891);
var state_32945__$1 = state_32945;
var statearr_32954_33053 = state_32945__$1;
(statearr_32954_33053[(2)] = inst_32892);

(statearr_32954_33053[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (60))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32786 = (state_32945[(9)]);
var inst_32789 = (state_32945[(10)]);
var inst_32906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32907 = [inst_32787,inst_32786,inst_32826,inst_32789];
var inst_32908 = (new cljs.core.PersistentVector(null,4,(5),inst_32906,inst_32907,null));
var inst_32909 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_32908,opts);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(63),inst_32909);
} else {
if((state_val_32946 === (27))){
var inst_32826 = (state_32945[(8)]);
var inst_32837 = (state_32945[(11)]);
var inst_32837__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_32826);
var state_32945__$1 = (function (){var statearr_32955 = state_32945;
(statearr_32955[(11)] = inst_32837__$1);

return statearr_32955;
})();
if(inst_32837__$1){
var statearr_32956_33054 = state_32945__$1;
(statearr_32956_33054[(1)] = (30));

} else {
var statearr_32957_33055 = state_32945__$1;
(statearr_32957_33055[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (1))){
var state_32945__$1 = state_32945;
var statearr_32958_33056 = state_32945__$1;
(statearr_32958_33056[(2)] = null);

(statearr_32958_33056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (69))){
var inst_32932 = (state_32945[(12)]);
var state_32945__$1 = state_32945;
var statearr_32959_33057 = state_32945__$1;
(statearr_32959_33057[(2)] = inst_32932);

(statearr_32959_33057[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (24))){
var inst_32787 = (state_32945[(7)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32787)){
var statearr_32960_33058 = state_32945__$1;
(statearr_32960_33058[(1)] = (27));

} else {
var statearr_32961_33059 = state_32945__$1;
(statearr_32961_33059[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (55))){
var inst_32826 = (state_32945[(8)]);
var inst_32884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32885 = [inst_32826];
var inst_32886 = (new cljs.core.PersistentVector(null,1,(5),inst_32884,inst_32885,null));
var inst_32887 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_32888 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32886,inst_32887);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(58),inst_32888);
} else {
if((state_val_32946 === (39))){
var inst_32857 = (state_32945[(2)]);
var inst_32858 = fluree.db.util.async.throw_err.call(null,inst_32857);
var state_32945__$1 = state_32945;
var statearr_32962_33060 = state_32945__$1;
(statearr_32962_33060[(2)] = inst_32858);

(statearr_32962_33060[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (46))){
var inst_32870 = (state_32945[(13)]);
var inst_32870__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_32945__$1 = (function (){var statearr_32963 = state_32945;
(statearr_32963[(13)] = inst_32870__$1);

return statearr_32963;
})();
if(cljs.core.truth_(inst_32870__$1)){
var statearr_32964_33061 = state_32945__$1;
(statearr_32964_33061[(1)] = (49));

} else {
var statearr_32965_33062 = state_32945__$1;
(statearr_32965_33062[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (4))){
var inst_32776 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32966_33063 = state_32945__$1;
(statearr_32966_33063[(2)] = inst_32776);

(statearr_32966_33063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (54))){
var inst_32882 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32882)){
var statearr_32967_33064 = state_32945__$1;
(statearr_32967_33064[(1)] = (55));

} else {
var statearr_32968_33065 = state_32945__$1;
(statearr_32968_33065[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (15))){
var inst_32788 = (state_32945[(14)]);
var inst_32807 = fluree.db.dbproto._tag_id.call(null,db,inst_32788);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(18),inst_32807);
} else {
if((state_val_32946 === (48))){
var inst_32928 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32969_33066 = state_32945__$1;
(statearr_32969_33066[(2)] = inst_32928);

(statearr_32969_33066[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (50))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32790 = (state_32945[(15)]);
var inst_32785 = (state_32945[(16)]);
var inst_32870 = (state_32945[(13)]);
var inst_32786 = (state_32945[(9)]);
var inst_32801 = (state_32945[(17)]);
var inst_32796 = (state_32945[(18)]);
var inst_32789 = (state_32945[(10)]);
var inst_32874 = (function (){var t = inst_32789;
var p = inst_32787;
var idx_predicate_QMARK_ = inst_32790;
var o = inst_32826;
var vec__32782 = inst_32785;
var tag_predicate_QMARK_ = inst_32796;
var temp__5751__auto__ = inst_32870;
var s = inst_32786;
var o_coerce_QMARK_ = inst_32801;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_32945__$1 = state_32945;
var statearr_32970_33067 = state_32945__$1;
(statearr_32970_33067[(2)] = inst_32874);

(statearr_32970_33067[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (21))){
var inst_32822 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32971_33068 = state_32945__$1;
(statearr_32971_33068[(2)] = inst_32822);

(statearr_32971_33068[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (31))){
var inst_32837 = (state_32945[(11)]);
var state_32945__$1 = state_32945;
var statearr_32972_33069 = state_32945__$1;
(statearr_32972_33069[(2)] = inst_32837);

(statearr_32972_33069[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (32))){
var inst_32847 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32973_33070 = state_32945__$1;
(statearr_32973_33070[(2)] = inst_32847);

(statearr_32973_33070[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (40))){
var inst_32790 = (state_32945[(15)]);
var inst_32861 = (state_32945[(19)]);
var inst_32861__$1 = cljs.core.not.call(null,inst_32790);
var state_32945__$1 = (function (){var statearr_32974 = state_32945;
(statearr_32974[(19)] = inst_32861__$1);

return statearr_32974;
})();
if(inst_32861__$1){
var statearr_32975_33071 = state_32945__$1;
(statearr_32975_33071[(1)] = (43));

} else {
var statearr_32976_33072 = state_32945__$1;
(statearr_32976_33072[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (56))){
var inst_32787 = (state_32945[(7)]);
var inst_32876 = (state_32945[(20)]);
var inst_32786 = (state_32945[(9)]);
var inst_32789 = (state_32945[(10)]);
var inst_32894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32895 = [inst_32787,inst_32786,null,inst_32789];
var inst_32896 = (new cljs.core.PersistentVector(null,4,(5),inst_32894,inst_32895,null));
var inst_32897 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_32876);
var inst_32898 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_32896,inst_32897);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(59),inst_32898);
} else {
if((state_val_32946 === (33))){
var inst_32826 = (state_32945[(8)]);
var inst_32840 = cljs.core.fn_QMARK_.call(null,inst_32826);
var inst_32841 = (!(inst_32840));
var state_32945__$1 = state_32945;
var statearr_32977_33073 = state_32945__$1;
(statearr_32977_33073[(2)] = inst_32841);

(statearr_32977_33073[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (13))){
var inst_32788 = (state_32945[(14)]);
var inst_32805 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_32788);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32805)){
var statearr_32978_33074 = state_32945__$1;
(statearr_32978_33074[(1)] = (15));

} else {
var statearr_32979_33075 = state_32945__$1;
(statearr_32979_33075[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (22))){
var inst_32818 = (state_32945[(2)]);
var inst_32819 = fluree.db.util.async.throw_err.call(null,inst_32818);
var state_32945__$1 = state_32945;
var statearr_32980_33076 = state_32945__$1;
(statearr_32980_33076[(2)] = inst_32819);

(statearr_32980_33076[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (36))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32786 = (state_32945[(9)]);
var inst_32789 = (state_32945[(10)]);
var inst_32852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32853 = [inst_32787,inst_32826,inst_32786,inst_32789];
var inst_32854 = (new cljs.core.PersistentVector(null,4,(5),inst_32852,inst_32853,null));
var inst_32855 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_32854,opts);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(39),inst_32855);
} else {
if((state_val_32946 === (41))){
var inst_32787 = (state_32945[(7)]);
var state_32945__$1 = state_32945;
var statearr_32981_33077 = state_32945__$1;
(statearr_32981_33077[(2)] = inst_32787);

(statearr_32981_33077[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (43))){
var inst_32826 = (state_32945[(8)]);
var state_32945__$1 = state_32945;
var statearr_32982_33078 = state_32945__$1;
(statearr_32982_33078[(2)] = inst_32826);

(statearr_32982_33078[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (61))){
var inst_32826 = (state_32945[(8)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32826)){
var statearr_32983_33079 = state_32945__$1;
(statearr_32983_33079[(1)] = (64));

} else {
var statearr_32984_33080 = state_32945__$1;
(statearr_32984_33080[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (29))){
var inst_32850 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32850)){
var statearr_32985_33081 = state_32945__$1;
(statearr_32985_33081[(1)] = (36));

} else {
var statearr_32986_33082 = state_32945__$1;
(statearr_32986_33082[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (44))){
var inst_32861 = (state_32945[(19)]);
var state_32945__$1 = state_32945;
var statearr_32987_33083 = state_32945__$1;
(statearr_32987_33083[(2)] = inst_32861);

(statearr_32987_33083[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (6))){
var inst_32787 = (state_32945[(7)]);
var inst_32792 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_32787);
var inst_32793 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_32792);
var state_32945__$1 = state_32945;
var statearr_32988_33084 = state_32945__$1;
(statearr_32988_33084[(2)] = inst_32793);

(statearr_32988_33084[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (28))){
var inst_32787 = (state_32945[(7)]);
var state_32945__$1 = state_32945;
var statearr_32989_33085 = state_32945__$1;
(statearr_32989_33085[(2)] = inst_32787);

(statearr_32989_33085[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (64))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32786 = (state_32945[(9)]);
var inst_32789 = (state_32945[(10)]);
var inst_32915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32916 = [inst_32826,inst_32787,inst_32786,inst_32789];
var inst_32917 = (new cljs.core.PersistentVector(null,4,(5),inst_32915,inst_32916,null));
var inst_32918 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_32917,opts);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(67),inst_32918);
} else {
if((state_val_32946 === (51))){
var inst_32787 = (state_32945[(7)]);
var inst_32877 = (state_32945[(21)]);
var inst_32876 = (state_32945[(2)]);
var inst_32877__$1 = cljs.core._EQ_.call(null,"_id",inst_32787);
var state_32945__$1 = (function (){var statearr_32990 = state_32945;
(statearr_32990[(21)] = inst_32877__$1);

(statearr_32990[(20)] = inst_32876);

return statearr_32990;
})();
if(inst_32877__$1){
var statearr_32991_33086 = state_32945__$1;
(statearr_32991_33086[(1)] = (52));

} else {
var statearr_32992_33087 = state_32945__$1;
(statearr_32992_33087[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (25))){
var inst_32796 = (state_32945[(18)]);
var inst_32932 = (state_32945[(2)]);
var state_32945__$1 = (function (){var statearr_32993 = state_32945;
(statearr_32993[(12)] = inst_32932);

return statearr_32993;
})();
if(cljs.core.truth_(inst_32796)){
var statearr_32994_33088 = state_32945__$1;
(statearr_32994_33088[(1)] = (68));

} else {
var statearr_32995_33089 = state_32945__$1;
(statearr_32995_33089[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (34))){
var inst_32790 = (state_32945[(15)]);
var state_32945__$1 = state_32945;
var statearr_32996_33090 = state_32945__$1;
(statearr_32996_33090[(2)] = inst_32790);

(statearr_32996_33090[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (17))){
var inst_32824 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_32997_33091 = state_32945__$1;
(statearr_32997_33091[(2)] = inst_32824);

(statearr_32997_33091[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (3))){
var inst_32943 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32945__$1,inst_32943);
} else {
if((state_val_32946 === (12))){
var inst_32788 = (state_32945[(14)]);
var state_32945__$1 = state_32945;
var statearr_32998_33092 = state_32945__$1;
(statearr_32998_33092[(2)] = inst_32788);

(statearr_32998_33092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (2))){
var inst_32787 = (state_32945[(7)]);
var inst_32785 = (state_32945[(16)]);
var _ = (function (){var statearr_32999 = state_32945;
(statearr_32999[(4)] = cljs.core.cons.call(null,(5),(state_32945[(4)])));

return statearr_32999;
})();
var inst_32785__$1 = fparts;
var inst_32786 = cljs.core.nth.call(null,inst_32785__$1,(0),null);
var inst_32787__$1 = cljs.core.nth.call(null,inst_32785__$1,(1),null);
var inst_32788 = cljs.core.nth.call(null,inst_32785__$1,(2),null);
var inst_32789 = cljs.core.nth.call(null,inst_32785__$1,(3),null);
var inst_32790 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_32787__$1);
var state_32945__$1 = (function (){var statearr_33000 = state_32945;
(statearr_33000[(7)] = inst_32787__$1);

(statearr_33000[(15)] = inst_32790);

(statearr_33000[(16)] = inst_32785__$1);

(statearr_33000[(14)] = inst_32788);

(statearr_33000[(9)] = inst_32786);

(statearr_33000[(10)] = inst_32789);

return statearr_33000;
})();
if(cljs.core.truth_(inst_32787__$1)){
var statearr_33001_33093 = state_32945__$1;
(statearr_33001_33093[(1)] = (6));

} else {
var statearr_33002_33094 = state_32945__$1;
(statearr_33002_33094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (66))){
var inst_32924 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_33003_33095 = state_32945__$1;
(statearr_33003_33095[(2)] = inst_32924);

(statearr_33003_33095[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (23))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32786 = (state_32945[(9)]);
var inst_32789 = (state_32945[(10)]);
var inst_32828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32829 = [inst_32786,inst_32787,inst_32826,inst_32789];
var inst_32830 = (new cljs.core.PersistentVector(null,4,(5),inst_32828,inst_32829,null));
var inst_32831 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32830,opts);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(26),inst_32831);
} else {
if((state_val_32946 === (47))){
var inst_32787 = (state_32945[(7)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32787)){
var statearr_33004_33096 = state_32945__$1;
(statearr_33004_33096[(1)] = (60));

} else {
var statearr_33005_33097 = state_32945__$1;
(statearr_33005_33097[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (35))){
var inst_32844 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_33006_33098 = state_32945__$1;
(statearr_33006_33098[(2)] = inst_32844);

(statearr_33006_33098[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (19))){
var inst_32787 = (state_32945[(7)]);
var inst_32788 = (state_32945[(14)]);
var inst_32814 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_32787);
var inst_32815 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32814),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32788)].join('');
var inst_32816 = fluree.db.dbproto._tag_id.call(null,db,inst_32815);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(22),inst_32816);
} else {
if((state_val_32946 === (57))){
var inst_32903 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_33007_33099 = state_32945__$1;
(statearr_33007_33099[(2)] = inst_32903);

(statearr_33007_33099[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (68))){
var inst_32932 = (state_32945[(12)]);
var inst_32934 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_32932);
var state_32945__$1 = state_32945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32945__$1,(71),inst_32934);
} else {
if((state_val_32946 === (11))){
var inst_32801 = (state_32945[(17)]);
var inst_32801__$1 = (state_32945[(2)]);
var inst_32802 = cljs.core.not.call(null,inst_32801__$1);
var state_32945__$1 = (function (){var statearr_33009 = state_32945;
(statearr_33009[(17)] = inst_32801__$1);

return statearr_33009;
})();
if(inst_32802){
var statearr_33010_33100 = state_32945__$1;
(statearr_33010_33100[(1)] = (12));

} else {
var statearr_33011_33101 = state_32945__$1;
(statearr_33011_33101[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (9))){
var inst_32788 = (state_32945[(14)]);
var inst_32798 = typeof inst_32788 === 'string';
var state_32945__$1 = state_32945;
var statearr_33012_33102 = state_32945__$1;
(statearr_33012_33102[(2)] = inst_32798);

(statearr_33012_33102[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (5))){
var _ = (function (){var statearr_33013 = state_32945;
(statearr_33013[(4)] = cljs.core.rest.call(null,(state_32945[(4)])));

return statearr_33013;
})();
var state_32945__$1 = state_32945;
var ex33008 = (state_32945__$1[(2)]);
var statearr_33014_33103 = state_32945__$1;
(statearr_33014_33103[(5)] = ex33008);


if((ex33008 instanceof Error)){
var statearr_33015_33104 = state_32945__$1;
(statearr_33015_33104[(1)] = (4));

(statearr_33015_33104[(5)] = null);

} else {
throw ex33008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (14))){
var inst_32786 = (state_32945[(9)]);
var inst_32826 = (state_32945[(2)]);
var state_32945__$1 = (function (){var statearr_33016 = state_32945;
(statearr_33016[(8)] = inst_32826);

return statearr_33016;
})();
if(cljs.core.truth_(inst_32786)){
var statearr_33017_33105 = state_32945__$1;
(statearr_33017_33105[(1)] = (23));

} else {
var statearr_33018_33106 = state_32945__$1;
(statearr_33018_33106[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (45))){
var inst_32865 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_33019_33107 = state_32945__$1;
(statearr_33019_33107[(2)] = inst_32865);

(statearr_33019_33107[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (53))){
var inst_32877 = (state_32945[(21)]);
var state_32945__$1 = state_32945;
var statearr_33020_33108 = state_32945__$1;
(statearr_33020_33108[(2)] = inst_32877);

(statearr_33020_33108[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (26))){
var inst_32833 = (state_32945[(2)]);
var inst_32834 = fluree.db.util.async.throw_err.call(null,inst_32833);
var state_32945__$1 = state_32945;
var statearr_33021_33109 = state_32945__$1;
(statearr_33021_33109[(2)] = inst_32834);

(statearr_33021_33109[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (16))){
var inst_32788 = (state_32945[(14)]);
var inst_32812 = typeof inst_32788 === 'string';
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32812)){
var statearr_33022_33110 = state_32945__$1;
(statearr_33022_33110[(1)] = (19));

} else {
var statearr_33023_33111 = state_32945__$1;
(statearr_33023_33111[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (38))){
var inst_32930 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
var statearr_33024_33112 = state_32945__$1;
(statearr_33024_33112[(2)] = inst_32930);

(statearr_33024_33112[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (30))){
var inst_32790 = (state_32945[(15)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32790)){
var statearr_33025_33113 = state_32945__$1;
(statearr_33025_33113[(1)] = (33));

} else {
var statearr_33026_33114 = state_32945__$1;
(statearr_33026_33114[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (10))){
var inst_32796 = (state_32945[(18)]);
var state_32945__$1 = state_32945;
var statearr_33027_33115 = state_32945__$1;
(statearr_33027_33115[(2)] = inst_32796);

(statearr_33027_33115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (18))){
var inst_32809 = (state_32945[(2)]);
var inst_32810 = fluree.db.util.async.throw_err.call(null,inst_32809);
var state_32945__$1 = state_32945;
var statearr_33028_33116 = state_32945__$1;
(statearr_33028_33116[(2)] = inst_32810);

(statearr_33028_33116[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (52))){
var inst_32826 = (state_32945[(8)]);
var inst_32879 = cljs.core.int_QMARK_.call(null,inst_32826);
var state_32945__$1 = state_32945;
var statearr_33029_33117 = state_32945__$1;
(statearr_33029_33117[(2)] = inst_32879);

(statearr_33029_33117[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (67))){
var inst_32920 = (state_32945[(2)]);
var inst_32921 = fluree.db.util.async.throw_err.call(null,inst_32920);
var state_32945__$1 = state_32945;
var statearr_33030_33118 = state_32945__$1;
(statearr_33030_33118[(2)] = inst_32921);

(statearr_33030_33118[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (71))){
var inst_32936 = (state_32945[(2)]);
var inst_32937 = fluree.db.util.async.throw_err.call(null,inst_32936);
var state_32945__$1 = state_32945;
var statearr_33031_33119 = state_32945__$1;
(statearr_33031_33119[(2)] = inst_32937);

(statearr_33031_33119[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (42))){
var inst_32868 = (state_32945[(2)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32868)){
var statearr_33032_33120 = state_32945__$1;
(statearr_33032_33120[(1)] = (46));

} else {
var statearr_33033_33121 = state_32945__$1;
(statearr_33033_33121[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (37))){
var inst_32787 = (state_32945[(7)]);
var state_32945__$1 = state_32945;
if(cljs.core.truth_(inst_32787)){
var statearr_33034_33122 = state_32945__$1;
(statearr_33034_33122[(1)] = (40));

} else {
var statearr_33035_33123 = state_32945__$1;
(statearr_33035_33123[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (63))){
var inst_32911 = (state_32945[(2)]);
var inst_32912 = fluree.db.util.async.throw_err.call(null,inst_32911);
var state_32945__$1 = state_32945;
var statearr_33036_33124 = state_32945__$1;
(statearr_33036_33124[(2)] = inst_32912);

(statearr_33036_33124[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (8))){
var inst_32796 = (state_32945[(18)]);
var inst_32796__$1 = (state_32945[(2)]);
var state_32945__$1 = (function (){var statearr_33037 = state_32945;
(statearr_33037[(18)] = inst_32796__$1);

return statearr_33037;
})();
if(cljs.core.truth_(inst_32796__$1)){
var statearr_33038_33125 = state_32945__$1;
(statearr_33038_33125[(1)] = (9));

} else {
var statearr_33039_33126 = state_32945__$1;
(statearr_33039_33126[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32946 === (49))){
var inst_32787 = (state_32945[(7)]);
var inst_32826 = (state_32945[(8)]);
var inst_32790 = (state_32945[(15)]);
var inst_32785 = (state_32945[(16)]);
var inst_32870 = (state_32945[(13)]);
var inst_32786 = (state_32945[(9)]);
var inst_32801 = (state_32945[(17)]);
var inst_32796 = (state_32945[(18)]);
var inst_32789 = (state_32945[(10)]);
var inst_32872 = (function (){var obj_fn = inst_32870;
var t = inst_32789;
var p = inst_32787;
var idx_predicate_QMARK_ = inst_32790;
var o = inst_32826;
var vec__32782 = inst_32785;
var tag_predicate_QMARK_ = inst_32796;
var temp__5751__auto__ = inst_32870;
var s = inst_32786;
var o_coerce_QMARK_ = inst_32801;
return (function (x){
var and__4210__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_32945__$1 = state_32945;
var statearr_33040_33127 = state_32945__$1;
(statearr_33040_33127[(2)] = inst_32872);

(statearr_33040_33127[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16221__auto__ = null;
var fluree$db$query$range$state_machine__16221__auto____0 = (function (){
var statearr_33041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33041[(0)] = fluree$db$query$range$state_machine__16221__auto__);

(statearr_33041[(1)] = (1));

return statearr_33041;
});
var fluree$db$query$range$state_machine__16221__auto____1 = (function (state_32945){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_32945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e33042){var ex__16224__auto__ = e33042;
var statearr_33043_33128 = state_32945;
(statearr_33043_33128[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_32945[(4)]))){
var statearr_33044_33129 = state_32945;
(statearr_33044_33129[(1)] = cljs.core.first.call(null,(state_32945[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33130 = state_32945;
state_32945 = G__33130;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16221__auto__ = function(state_32945){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16221__auto____1.call(this,state_32945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16221__auto____0;
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16221__auto____1;
return fluree$db$query$range$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_33045 = f__16346__auto__.call(null);
(statearr_33045[(6)] = c__16345__auto__);

return statearr_33045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__33132 = arguments.length;
switch (G__33132) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_33167){
var state_val_33168 = (state_33167[(1)]);
if((state_val_33168 === (7))){
var inst_33154 = cljs.core.pr_str.call(null,name);
var inst_33155 = ["Invalid collection name: ",inst_33154].join('');
var inst_33156 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33157 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_33158 = cljs.core.PersistentHashMap.fromArrays(inst_33156,inst_33157);
var inst_33159 = cljs.core.ex_info.call(null,inst_33155,inst_33158);
var inst_33160 = (function(){throw inst_33159})();
var state_33167__$1 = state_33167;
var statearr_33169_33189 = state_33167__$1;
(statearr_33169_33189[(2)] = inst_33160);

(statearr_33169_33189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (1))){
var state_33167__$1 = state_33167;
var statearr_33170_33190 = state_33167__$1;
(statearr_33170_33190[(2)] = null);

(statearr_33170_33190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (4))){
var inst_33133 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33171_33191 = state_33167__$1;
(statearr_33171_33191[(2)] = inst_33133);

(statearr_33171_33191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (6))){
var inst_33139 = (state_33167[(7)]);
var inst_33141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33142 = fluree.db.flake.max_subject_id.call(null,inst_33139);
var inst_33143 = [inst_33142];
var inst_33144 = (new cljs.core.PersistentVector(null,1,(5),inst_33141,inst_33143,null));
var inst_33145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33146 = fluree.db.flake.min_subject_id.call(null,inst_33139);
var inst_33147 = [inst_33146];
var inst_33148 = (new cljs.core.PersistentVector(null,1,(5),inst_33145,inst_33147,null));
var inst_33149 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_33144,cljs.core._LT__EQ_,inst_33148,opts);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33167__$1,(9),inst_33149);
} else {
if((state_val_33168 === (3))){
var inst_33165 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33167__$1,inst_33165);
} else {
if((state_val_33168 === (2))){
var inst_33139 = (state_33167[(7)]);
var _ = (function (){var statearr_33173 = state_33167;
(statearr_33173[(4)] = cljs.core.cons.call(null,(5),(state_33167[(4)])));

return statearr_33173;
})();
var inst_33139__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_33167__$1 = (function (){var statearr_33174 = state_33167;
(statearr_33174[(7)] = inst_33139__$1);

return statearr_33174;
})();
if(cljs.core.truth_(inst_33139__$1)){
var statearr_33175_33192 = state_33167__$1;
(statearr_33175_33192[(1)] = (6));

} else {
var statearr_33176_33193 = state_33167__$1;
(statearr_33176_33193[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (9))){
var inst_33151 = (state_33167[(2)]);
var inst_33152 = fluree.db.util.async.throw_err.call(null,inst_33151);
var state_33167__$1 = state_33167;
var statearr_33177_33194 = state_33167__$1;
(statearr_33177_33194[(2)] = inst_33152);

(statearr_33177_33194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (5))){
var _ = (function (){var statearr_33178 = state_33167;
(statearr_33178[(4)] = cljs.core.rest.call(null,(state_33167[(4)])));

return statearr_33178;
})();
var state_33167__$1 = state_33167;
var ex33172 = (state_33167__$1[(2)]);
var statearr_33179_33195 = state_33167__$1;
(statearr_33179_33195[(5)] = ex33172);


var statearr_33180_33196 = state_33167__$1;
(statearr_33180_33196[(1)] = (4));

(statearr_33180_33196[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (8))){
var inst_33162 = (state_33167[(2)]);
var _ = (function (){var statearr_33181 = state_33167;
(statearr_33181[(4)] = cljs.core.rest.call(null,(state_33167[(4)])));

return statearr_33181;
})();
var state_33167__$1 = state_33167;
var statearr_33182_33197 = state_33167__$1;
(statearr_33182_33197[(2)] = inst_33162);

(statearr_33182_33197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16221__auto__ = null;
var fluree$db$query$range$state_machine__16221__auto____0 = (function (){
var statearr_33183 = [null,null,null,null,null,null,null,null];
(statearr_33183[(0)] = fluree$db$query$range$state_machine__16221__auto__);

(statearr_33183[(1)] = (1));

return statearr_33183;
});
var fluree$db$query$range$state_machine__16221__auto____1 = (function (state_33167){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_33167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e33184){var ex__16224__auto__ = e33184;
var statearr_33185_33198 = state_33167;
(statearr_33185_33198[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_33167[(4)]))){
var statearr_33186_33199 = state_33167;
(statearr_33186_33199[(1)] = cljs.core.first.call(null,(state_33167[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33200 = state_33167;
state_33167 = G__33200;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16221__auto__ = function(state_33167){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16221__auto____1.call(this,state_33167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16221__auto____0;
fluree$db$query$range$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16221__auto____1;
return fluree$db$query$range$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_33187 = f__16346__auto__.call(null);
(statearr_33187[(6)] = c__16345__auto__);

return statearr_33187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__33204 = flakes;
var vec__33205 = G__33204;
var seq__33206 = cljs.core.seq.call(null,vec__33205);
var first__33207 = cljs.core.first.call(null,seq__33206);
var seq__33206__$1 = cljs.core.next.call(null,seq__33206);
var flake_SINGLEQUOTE_ = first__33207;
var r = seq__33206__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__33204__$1 = G__33204;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__33213 = G__33204__$1;
var seq__33214 = cljs.core.seq.call(null,vec__33213);
var first__33215 = cljs.core.first.call(null,seq__33214);
var seq__33214__$1 = cljs.core.next.call(null,seq__33214);
var flake_SINGLEQUOTE___$1 = first__33215;
var r__$1 = seq__33214__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e33217){var e = e33217;
return null;
}})();
var map__33216 = cmd_map;
var map__33216__$1 = cljs.core.__destructure_map.call(null,map__33216);
var type = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__33216__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__33218 = r__$1;
var G__33219 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__33204__$1 = G__33218;
result_STAR___$1 = G__33219;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__33228 = blocks;
var vec__33229 = G__33228;
var seq__33230 = cljs.core.seq.call(null,vec__33229);
var first__33231 = cljs.core.first.call(null,seq__33230);
var seq__33230__$1 = cljs.core.next.call(null,seq__33230);
var block_SINGLEQUOTE_ = first__33231;
var r = seq__33230__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__33228__$1 = G__33228;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__33236 = G__33228__$1;
var seq__33237 = cljs.core.seq.call(null,vec__33236);
var first__33238 = cljs.core.first.call(null,seq__33237);
var seq__33237__$1 = cljs.core.next.call(null,seq__33237);
var block_SINGLEQUOTE___$1 = first__33238;
var r__$1 = seq__33237__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__33239 = block_SINGLEQUOTE___$1;
var map__33239__$1 = cljs.core.__destructure_map.call(null,map__33239);
var block = cljs.core.get.call(null,map__33239__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__33239__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__33239__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33220_SHARP_){
var f = p1__33220_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33221_SHARP_){
var f = p1__33221_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33222_SHARP_){
var f = p1__33222_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,instant,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33223_SHARP_){
var f = p1__33223_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,instant,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33224_SHARP_){
return cljs.core._EQ_.call(null,p1__33224_SHARP_.p,(106));
});})(G__33228__$1,result_STAR___$1,map__33239,map__33239__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__33236,seq__33237,first__33238,seq__33237__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33228,vec__33229,seq__33230,first__33231,seq__33230__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__33240 = r__$1;
var G__33241 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__33228__$1 = G__33240;
result_STAR___$1 = G__33241;
continue;
}
break;
}
});
