// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k45554,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__45558 = k45554;
var G__45558__$1 = (((G__45558 instanceof cljs.core.Keyword))?G__45558.fqn:null);
switch (G__45558__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k45554,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4484__auto__,p__45559){
var vec__45560 = p__45559;
var k__4485__auto__ = cljs.core.nth.call(null,vec__45560,(0),null);
var v__4486__auto__ = cljs.core.nth.call(null,vec__45560,(1),null);
return f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__);
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__45553){
var self__ = this;
var G__45553__$1 = this;
return (new cljs.core.RecordIter((0),G__45553__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4458__auto__));
}).call(null,this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this45555,other45556){
var self__ = this;
var this45555__$1 = this;
return (((!((other45556 == null)))) && ((((this45555__$1.constructor === other45556.constructor)) && (((cljs.core._EQ_.call(null,this45555__$1.conn,other45556.conn)) && (((cljs.core._EQ_.call(null,this45555__$1.network,other45556.network)) && (((cljs.core._EQ_.call(null,this45555__$1.dbid,other45556.dbid)) && (((cljs.core._EQ_.call(null,this45555__$1.db_name,other45556.db_name)) && (((cljs.core._EQ_.call(null,this45555__$1.update_chan,other45556.update_chan)) && (((cljs.core._EQ_.call(null,this45555__$1.transact_chan,other45556.transact_chan)) && (((cljs.core._EQ_.call(null,this45555__$1.state,other45556.state)) && (((cljs.core._EQ_.call(null,this45555__$1.schema_cache,other45556.schema_cache)) && (((cljs.core._EQ_.call(null,this45555__$1.blank_db,other45556.blank_db)) && (((cljs.core._EQ_.call(null,this45555__$1.close,other45556.close)) && (((cljs.core._EQ_.call(null,this45555__$1.id,other45556.id)) && (cljs.core._EQ_.call(null,this45555__$1.__extmap,other45556.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k45554){
var self__ = this;
var this__4468__auto____$1 = this;
var G__45563 = k45554;
var G__45563__$1 = (((G__45563 instanceof cljs.core.Keyword))?G__45563.fqn:null);
switch (G__45563__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k45554);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__45553){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__45564 = cljs.core.keyword_identical_QMARK_;
var expr__45565 = k__4470__auto__;
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__45565))){
return (new fluree.db.session.DbSession(G__45553,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,G__45553,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__45553,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__45553,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__45553,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__45553,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__45553,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__45553,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__45553,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__45553,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__45564.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__45565))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__45553,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4470__auto__,G__45553),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__45553){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__45553,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4467__auto__,(0)),cljs.core._nth.call(null,entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write.call(null,writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__45557){
var extmap__4501__auto__ = (function (){var G__45567 = cljs.core.dissoc.call(null,G__45557,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__45557)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__45567);
} else {
return G__45567;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__45557),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__45557),null,cljs.core.not_empty.call(null,extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__45570 = session;
var map__45570__$1 = cljs.core.__destructure_map.call(null,map__45570);
var network = cljs.core.get.call(null,map__45570__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__45570__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__16345__auto___45721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45673){
var state_val_45674 = (state_45673[(1)]);
if((state_val_45674 === (7))){
var inst_45591 = (state_45673[(7)]);
var inst_45596 = cljs.core.empty_QMARK_.call(null,inst_45591);
var state_45673__$1 = state_45673;
if(inst_45596){
var statearr_45675_45722 = state_45673__$1;
(statearr_45675_45722[(1)] = (10));

} else {
var statearr_45676_45723 = state_45673__$1;
(statearr_45676_45723[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (20))){
var inst_45582 = (state_45673[(8)]);
var inst_45622 = (state_45673[(9)]);
var inst_45584 = (state_45673[(10)]);
var inst_45583 = (state_45673[(11)]);
var inst_45627 = fluree.db.storage.core.read_block.call(null,inst_45582,inst_45583,inst_45584,inst_45622);
var state_45673__$1 = state_45673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(22),inst_45627);
} else {
if((state_val_45674 === (27))){
var inst_45660 = (state_45673[(12)]);
var inst_45662 = (state_45673[(2)]);
var inst_45663 = fluree.db.util.async.throw_err.call(null,inst_45662);
var state_45673__$1 = (function (){var statearr_45677 = state_45673;
(statearr_45677[(13)] = inst_45663);

return statearr_45677;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(28),inst_45660);
} else {
if((state_val_45674 === (1))){
var state_45673__$1 = state_45673;
var statearr_45678_45724 = state_45673__$1;
(statearr_45678_45724[(2)] = null);

(statearr_45678_45724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (24))){
var inst_45622 = (state_45673[(9)]);
var inst_45584 = (state_45673[(10)]);
var inst_45583 = (state_45673[(11)]);
var inst_45644 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45622)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45583),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45584),"."].join('');
var inst_45645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45646 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_45647 = cljs.core.PersistentHashMap.fromArrays(inst_45645,inst_45646);
var inst_45648 = cljs.core.ex_info.call(null,inst_45644,inst_45647);
var inst_45649 = (function(){throw inst_45648})();
var state_45673__$1 = state_45673;
var statearr_45679_45725 = state_45673__$1;
(statearr_45679_45725[(2)] = inst_45649);

(statearr_45679_45725[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (4))){
var inst_45571 = (state_45673[(2)]);
var inst_45572 = cljs.core.async.put_BANG_.call(null,pc,inst_45571);
var state_45673__$1 = state_45673;
var statearr_45680_45726 = state_45673__$1;
(statearr_45680_45726[(2)] = inst_45572);

(statearr_45680_45726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (15))){
var state_45673__$1 = state_45673;
var statearr_45681_45727 = state_45673__$1;
(statearr_45681_45727[(2)] = null);

(statearr_45681_45727[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (21))){
var inst_45653 = (state_45673[(2)]);
var state_45673__$1 = state_45673;
var statearr_45682_45728 = state_45673__$1;
(statearr_45682_45728[(2)] = inst_45653);

(statearr_45682_45728[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (13))){
var inst_45591 = (state_45673[(7)]);
var inst_45616 = (state_45673[(14)]);
var inst_45615 = (state_45673[(2)]);
var inst_45616__$1 = fluree.db.util.async.throw_err.call(null,inst_45615);
var inst_45617 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_45591);
var state_45673__$1 = (function (){var statearr_45683 = state_45673;
(statearr_45683[(15)] = inst_45617);

(statearr_45683[(14)] = inst_45616__$1);

return statearr_45683;
})();
if(cljs.core.truth_(inst_45616__$1)){
var statearr_45684_45729 = state_45673__$1;
(statearr_45684_45729[(1)] = (14));

} else {
var statearr_45685_45730 = state_45673__$1;
(statearr_45685_45730[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (22))){
var inst_45630 = (state_45673[(16)]);
var inst_45629 = (state_45673[(2)]);
var inst_45630__$1 = fluree.db.util.async.throw_err.call(null,inst_45629);
var state_45673__$1 = (function (){var statearr_45686 = state_45673;
(statearr_45686[(16)] = inst_45630__$1);

return statearr_45686;
})();
if(cljs.core.truth_(inst_45630__$1)){
var statearr_45687_45731 = state_45673__$1;
(statearr_45687_45731[(1)] = (23));

} else {
var statearr_45688_45732 = state_45673__$1;
(statearr_45688_45732[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (6))){
var inst_45591 = (state_45673[(7)]);
var inst_45590 = (state_45673[(2)]);
var inst_45591__$1 = fluree.db.util.async.throw_err.call(null,inst_45590);
var inst_45592 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_45591__$1);
var inst_45593 = cljs.core.keyword.call(null,inst_45592);
var inst_45594 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_45593);
var state_45673__$1 = (function (){var statearr_45689 = state_45673;
(statearr_45689[(7)] = inst_45591__$1);

return statearr_45689;
})();
if(inst_45594){
var statearr_45690_45733 = state_45673__$1;
(statearr_45690_45733[(1)] = (7));

} else {
var statearr_45691_45734 = state_45673__$1;
(statearr_45691_45734[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (28))){
var inst_45663 = (state_45673[(13)]);
var inst_45658 = (state_45673[(17)]);
var inst_45665 = (state_45673[(2)]);
var inst_45666 = fluree.db.util.async.throw_err.call(null,inst_45665);
var inst_45667 = cljs.core.assoc.call(null,inst_45658,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_45663,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_45666);
var inst_45668 = cljs.core.async.put_BANG_.call(null,pc,inst_45667);
var _ = (function (){var statearr_45692 = state_45673;
(statearr_45692[(4)] = cljs.core.rest.call(null,(state_45673[(4)])));

return statearr_45692;
})();
var state_45673__$1 = state_45673;
var statearr_45693_45735 = state_45673__$1;
(statearr_45693_45735[(2)] = inst_45668);

(statearr_45693_45735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (25))){
var inst_45651 = (state_45673[(2)]);
var state_45673__$1 = state_45673;
var statearr_45694_45736 = state_45673__$1;
(statearr_45694_45736[(2)] = inst_45651);

(statearr_45694_45736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (17))){
var inst_45622 = (state_45673[(9)]);
var inst_45617 = (state_45673[(15)]);
var inst_45624 = (inst_45622 > inst_45617);
var state_45673__$1 = state_45673;
if(cljs.core.truth_(inst_45624)){
var statearr_45695_45737 = state_45673__$1;
(statearr_45695_45737[(1)] = (19));

} else {
var statearr_45696_45738 = state_45673__$1;
(statearr_45696_45738[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (3))){
var inst_45671 = (state_45673[(2)]);
var state_45673__$1 = state_45673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45673__$1,inst_45671);
} else {
if((state_val_45674 === (12))){
var inst_45603 = (state_45673[(2)]);
var inst_45604 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45605 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_45606 = cljs.core.PersistentHashMap.fromArrays(inst_45604,inst_45605);
var inst_45607 = cljs.core.ex_info.call(null,inst_45603,inst_45606);
var inst_45608 = (function(){throw inst_45607})();
var state_45673__$1 = state_45673;
var statearr_45697_45739 = state_45673__$1;
(statearr_45697_45739[(2)] = inst_45608);

(statearr_45697_45739[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (2))){
var inst_45582 = (state_45673[(8)]);
var inst_45584 = (state_45673[(10)]);
var inst_45583 = (state_45673[(11)]);
var _ = (function (){var statearr_45698 = state_45673;
(statearr_45698[(4)] = cljs.core.cons.call(null,(5),(state_45673[(4)])));

return statearr_45698;
})();
var inst_45579 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_45580 = session;
var inst_45581 = cljs.core.__destructure_map.call(null,inst_45580);
var inst_45582__$1 = cljs.core.get.call(null,inst_45581,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_45583__$1 = cljs.core.get.call(null,inst_45581,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_45584__$1 = cljs.core.get.call(null,inst_45581,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_45585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45586 = [inst_45583__$1,inst_45584__$1];
var inst_45587 = (new cljs.core.PersistentVector(null,2,(5),inst_45585,inst_45586,null));
var inst_45588 = fluree.db.operations.ledger_info_async.call(null,inst_45582__$1,inst_45587);
var state_45673__$1 = (function (){var statearr_45699 = state_45673;
(statearr_45699[(8)] = inst_45582__$1);

(statearr_45699[(18)] = inst_45579);

(statearr_45699[(10)] = inst_45584__$1);

(statearr_45699[(11)] = inst_45583__$1);

return statearr_45699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(6),inst_45588);
} else {
if((state_val_45674 === (23))){
var inst_45630 = (state_45673[(16)]);
var inst_45621 = (state_45673[(19)]);
var inst_45633 = cljs.core.__destructure_map.call(null,inst_45630);
var inst_45634 = cljs.core.get.call(null,inst_45633,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_45635 = cljs.core.get.call(null,inst_45633,new cljs.core.Keyword(null,"block","block",664686210));
var inst_45636 = cljs.core.get.call(null,inst_45633,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_45637 = fluree.db.dbproto._with.call(null,inst_45621,inst_45635,inst_45634);
var state_45673__$1 = (function (){var statearr_45700 = state_45673;
(statearr_45700[(20)] = inst_45636);

return statearr_45700;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(26),inst_45637);
} else {
if((state_val_45674 === (19))){
var inst_45621 = (state_45673[(19)]);
var state_45673__$1 = state_45673;
var statearr_45701_45740 = state_45673__$1;
(statearr_45701_45740[(2)] = inst_45621);

(statearr_45701_45740[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (11))){
var inst_45584 = (state_45673[(10)]);
var inst_45591 = (state_45673[(7)]);
var inst_45583 = (state_45673[(11)]);
var inst_45600 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_45591);
var inst_45601 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45583),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45584)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45600),"."].join('');
var state_45673__$1 = state_45673;
var statearr_45703_45741 = state_45673__$1;
(statearr_45703_45741[(2)] = inst_45601);

(statearr_45703_45741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (9))){
var inst_45582 = (state_45673[(8)]);
var inst_45579 = (state_45673[(18)]);
var inst_45584 = (state_45673[(10)]);
var inst_45591 = (state_45673[(7)]);
var inst_45583 = (state_45673[(11)]);
var inst_45611 = (state_45673[(2)]);
var inst_45612 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_45591);
var inst_45613 = fluree.db.storage.core.reify_db.call(null,inst_45582,inst_45583,inst_45584,inst_45579,inst_45612);
var state_45673__$1 = (function (){var statearr_45704 = state_45673;
(statearr_45704[(21)] = inst_45611);

return statearr_45704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(13),inst_45613);
} else {
if((state_val_45674 === (5))){
var _ = (function (){var statearr_45705 = state_45673;
(statearr_45705[(4)] = cljs.core.rest.call(null,(state_45673[(4)])));

return statearr_45705;
})();
var state_45673__$1 = state_45673;
var ex45702 = (state_45673__$1[(2)]);
var statearr_45706_45742 = state_45673__$1;
(statearr_45706_45742[(5)] = ex45702);


var statearr_45707_45743 = state_45673__$1;
(statearr_45707_45743[(1)] = (4));

(statearr_45707_45743[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (14))){
var inst_45616 = (state_45673[(14)]);
var inst_45619 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_45616);
var inst_45620 = (inst_45619 + (1));
var inst_45621 = inst_45616;
var inst_45622 = inst_45620;
var state_45673__$1 = (function (){var statearr_45708 = state_45673;
(statearr_45708[(19)] = inst_45621);

(statearr_45708[(9)] = inst_45622);

return statearr_45708;
})();
var statearr_45709_45744 = state_45673__$1;
(statearr_45709_45744[(2)] = null);

(statearr_45709_45744[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (26))){
var inst_45622 = (state_45673[(9)]);
var inst_45639 = (state_45673[(2)]);
var inst_45640 = fluree.db.util.async.throw_err.call(null,inst_45639);
var inst_45641 = (inst_45622 + (1));
var inst_45621 = inst_45640;
var inst_45622__$1 = inst_45641;
var state_45673__$1 = (function (){var statearr_45710 = state_45673;
(statearr_45710[(19)] = inst_45621);

(statearr_45710[(9)] = inst_45622__$1);

return statearr_45710;
})();
var statearr_45711_45745 = state_45673__$1;
(statearr_45711_45745[(2)] = null);

(statearr_45711_45745[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (16))){
var inst_45658 = (state_45673[(17)]);
var inst_45658__$1 = (state_45673[(2)]);
var inst_45659 = fluree.db.query.schema.schema_map.call(null,inst_45658__$1);
var inst_45660 = fluree.db.query.schema.setting_map.call(null,inst_45658__$1);
var state_45673__$1 = (function (){var statearr_45712 = state_45673;
(statearr_45712[(12)] = inst_45660);

(statearr_45712[(17)] = inst_45658__$1);

return statearr_45712;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45673__$1,(27),inst_45659);
} else {
if((state_val_45674 === (10))){
var inst_45584 = (state_45673[(10)]);
var inst_45583 = (state_45673[(11)]);
var inst_45598 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45583),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45584)," is not found on this ledger group."].join('');
var state_45673__$1 = state_45673;
var statearr_45713_45746 = state_45673__$1;
(statearr_45713_45746[(2)] = inst_45598);

(statearr_45713_45746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (18))){
var inst_45655 = (state_45673[(2)]);
var state_45673__$1 = state_45673;
var statearr_45714_45747 = state_45673__$1;
(statearr_45714_45747[(2)] = inst_45655);

(statearr_45714_45747[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45674 === (8))){
var state_45673__$1 = state_45673;
var statearr_45715_45748 = state_45673__$1;
(statearr_45715_45748[(2)] = null);

(statearr_45715_45748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____0 = (function (){
var statearr_45716 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45716[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__);

(statearr_45716[(1)] = (1));

return statearr_45716;
});
var fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____1 = (function (state_45673){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45717){var ex__16224__auto__ = e45717;
var statearr_45718_45749 = state_45673;
(statearr_45718_45749[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45673[(4)]))){
var statearr_45719_45750 = state_45673;
(statearr_45719_45750[(1)] = cljs.core.first.call(null,(state_45673[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45751 = state_45673;
state_45673 = G__45751;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__ = function(state_45673){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____1.call(this,state_45673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__16221__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45720 = f__16346__auto__.call(null);
(statearr_45720[(6)] = c__16345__auto___45721);

return statearr_45720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45753){
var state_val_45754 = (state_45753[(1)]);
if((state_val_45754 === (1))){
var state_45753__$1 = state_45753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45753__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16221__auto__ = null;
var fluree$db$session$state_machine__16221__auto____0 = (function (){
var statearr_45755 = [null,null,null,null,null,null,null];
(statearr_45755[(0)] = fluree$db$session$state_machine__16221__auto__);

(statearr_45755[(1)] = (1));

return statearr_45755;
});
var fluree$db$session$state_machine__16221__auto____1 = (function (state_45753){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45756){var ex__16224__auto__ = e45756;
var statearr_45757_45760 = state_45753;
(statearr_45757_45760[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45753[(4)]))){
var statearr_45758_45761 = state_45753;
(statearr_45758_45761[(1)] = cljs.core.first.call(null,(state_45753[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45762 = state_45753;
state_45753 = G__45762;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$state_machine__16221__auto__ = function(state_45753){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16221__auto____1.call(this,state_45753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16221__auto____0;
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16221__auto____1;
return fluree$db$session$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45759 = f__16346__auto__.call(null);
(statearr_45759[(6)] = c__16345__auto__);

return statearr_45759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__45764){
var map__45765 = p__45764;
var map__45765__$1 = cljs.core.__destructure_map.call(null,map__45765);
var data = map__45765__$1;
var block = cljs.core.get.call(null,map__45765__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__45765__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__45765__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45824){
var state_val_45825 = (state_45824[(1)]);
if((state_val_45825 === (7))){
var inst_45776 = (state_45824[(7)]);
var inst_45779 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_45780 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_45781 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45779),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45780),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45776),". No-op."].join('');
var inst_45782 = fluree.db.util.log.info.call(null,inst_45781);
var state_45824__$1 = state_45824;
var statearr_45826_45860 = state_45824__$1;
(statearr_45826_45860[(2)] = inst_45782);

(statearr_45826_45860[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (1))){
var state_45824__$1 = state_45824;
var statearr_45827_45861 = state_45824__$1;
(statearr_45827_45861[(2)] = null);

(statearr_45827_45861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (4))){
var inst_45766 = (state_45824[(2)]);
var state_45824__$1 = state_45824;
var statearr_45828_45862 = state_45824__$1;
(statearr_45828_45862[(2)] = inst_45766);

(statearr_45828_45862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (15))){
var inst_45805 = (state_45824[(2)]);
var state_45824__$1 = state_45824;
var statearr_45829_45863 = state_45824__$1;
(statearr_45829_45863[(2)] = inst_45805);

(statearr_45829_45863[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (13))){
var inst_45796 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_45797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45798 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_45799 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_45800 = [inst_45798,inst_45799];
var inst_45801 = (new cljs.core.PersistentVector(null,2,(5),inst_45797,inst_45800,null));
var inst_45802 = fluree.db.conn_events.process_event.call(null,inst_45796,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_45801,data);
var state_45824__$1 = state_45824;
var statearr_45830_45864 = state_45824__$1;
(statearr_45830_45864[(2)] = inst_45802);

(statearr_45830_45864[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (6))){
var inst_45776 = (state_45824[(7)]);
var inst_45775 = (state_45824[(8)]);
var inst_45774 = (state_45824[(2)]);
var inst_45775__$1 = fluree.db.util.async.throw_err.call(null,inst_45774);
var inst_45776__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_45775__$1);
var inst_45777 = (block <= inst_45776__$1);
var state_45824__$1 = (function (){var statearr_45831 = state_45824;
(statearr_45831[(7)] = inst_45776__$1);

(statearr_45831[(8)] = inst_45775__$1);

return statearr_45831;
})();
if(cljs.core.truth_(inst_45777)){
var statearr_45832_45865 = state_45824__$1;
(statearr_45832_45865[(1)] = (7));

} else {
var statearr_45833_45866 = state_45824__$1;
(statearr_45833_45866[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (17))){
var state_45824__$1 = state_45824;
var statearr_45834_45867 = state_45824__$1;
(statearr_45834_45867[(2)] = null);

(statearr_45834_45867[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (3))){
var inst_45822 = (state_45824[(2)]);
var state_45824__$1 = state_45824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45824__$1,inst_45822);
} else {
if((state_val_45825 === (12))){
var inst_45817 = (state_45824[(2)]);
var state_45824__$1 = state_45824;
var statearr_45835_45868 = state_45824__$1;
(statearr_45835_45868[(2)] = inst_45817);

(statearr_45835_45868[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (2))){
var inst_45772 = (state_45824[(9)]);
var _ = (function (){var statearr_45836 = state_45824;
(statearr_45836[(4)] = cljs.core.cons.call(null,(5),(state_45824[(4)])));

return statearr_45836;
})();
var inst_45772__$1 = fluree.db.session.current_db.call(null,session);
var state_45824__$1 = (function (){var statearr_45837 = state_45824;
(statearr_45837[(9)] = inst_45772__$1);

return statearr_45837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45824__$1,(6),inst_45772__$1);
} else {
if((state_val_45825 === (11))){
var state_45824__$1 = state_45824;
var statearr_45839_45869 = state_45824__$1;
(statearr_45839_45869[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (9))){
var inst_45819 = (state_45824[(2)]);
var _ = (function (){var statearr_45841 = state_45824;
(statearr_45841[(4)] = cljs.core.rest.call(null,(state_45824[(4)])));

return statearr_45841;
})();
var state_45824__$1 = state_45824;
var statearr_45842_45870 = state_45824__$1;
(statearr_45842_45870[(2)] = inst_45819);

(statearr_45842_45870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (5))){
var _ = (function (){var statearr_45843 = state_45824;
(statearr_45843[(4)] = cljs.core.rest.call(null,(state_45824[(4)])));

return statearr_45843;
})();
var state_45824__$1 = state_45824;
var ex45838 = (state_45824__$1[(2)]);
var statearr_45844_45871 = state_45824__$1;
(statearr_45844_45871[(5)] = ex45838);


if((ex45838 instanceof Error)){
var statearr_45845_45872 = state_45824__$1;
(statearr_45845_45872[(1)] = (4));

(statearr_45845_45872[(5)] = null);

} else {
throw ex45838;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (14))){
var state_45824__$1 = state_45824;
var statearr_45846_45873 = state_45824__$1;
(statearr_45846_45873[(2)] = null);

(statearr_45846_45873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (16))){
var inst_45776 = (state_45824[(7)]);
var inst_45808 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_45809 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_45810 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45808),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45809),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45776),". Forcing a db reload."].join('');
var inst_45811 = fluree.db.util.log.info.call(null,inst_45810);
var inst_45812 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_45824__$1 = (function (){var statearr_45847 = state_45824;
(statearr_45847[(10)] = inst_45811);

return statearr_45847;
})();
var statearr_45848_45874 = state_45824__$1;
(statearr_45848_45874[(2)] = inst_45812);

(statearr_45848_45874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (10))){
var inst_45776 = (state_45824[(7)]);
var inst_45775 = (state_45824[(8)]);
var inst_45772 = (state_45824[(9)]);
var inst_45787 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_45788 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_45789 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45787),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45788),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_45790 = fluree.db.util.log.trace.call(null,inst_45789);
var inst_45791 = (function (){var current_db_ch = inst_45772;
var current_db = inst_45775;
var current_block = inst_45776;
return (function (p1__45763_SHARP_){
if((p1__45763_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__45763_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__45763_SHARP_);
}
});
})();
var inst_45792 = cljs.core.map.call(null,inst_45791,flakes);
var inst_45793 = fluree.db.dbproto._with.call(null,inst_45775,block,inst_45792);
var inst_45794 = fluree.db.session.cas_db_BANG_.call(null,session,inst_45772,inst_45793);
var state_45824__$1 = (function (){var statearr_45849 = state_45824;
(statearr_45849[(11)] = inst_45790);

return statearr_45849;
})();
if(inst_45794){
var statearr_45850_45875 = state_45824__$1;
(statearr_45850_45875[(1)] = (13));

} else {
var statearr_45851_45876 = state_45824__$1;
(statearr_45851_45876[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (18))){
var inst_45815 = (state_45824[(2)]);
var state_45824__$1 = state_45824;
var statearr_45852_45877 = state_45824__$1;
(statearr_45852_45877[(2)] = inst_45815);

(statearr_45852_45877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45825 === (8))){
var inst_45776 = (state_45824[(7)]);
var inst_45784 = ((1) + inst_45776);
var inst_45785 = cljs.core._EQ_.call(null,block,inst_45784);
var state_45824__$1 = state_45824;
if(inst_45785){
var statearr_45853_45878 = state_45824__$1;
(statearr_45853_45878[(1)] = (10));

} else {
var statearr_45854_45879 = state_45824__$1;
(statearr_45854_45879[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16221__auto__ = null;
var fluree$db$session$state_machine__16221__auto____0 = (function (){
var statearr_45855 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45855[(0)] = fluree$db$session$state_machine__16221__auto__);

(statearr_45855[(1)] = (1));

return statearr_45855;
});
var fluree$db$session$state_machine__16221__auto____1 = (function (state_45824){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45856){var ex__16224__auto__ = e45856;
var statearr_45857_45880 = state_45824;
(statearr_45857_45880[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45824[(4)]))){
var statearr_45858_45881 = state_45824;
(statearr_45858_45881[(1)] = cljs.core.first.call(null,(state_45824[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45882 = state_45824;
state_45824 = G__45882;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$state_machine__16221__auto__ = function(state_45824){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16221__auto____1.call(this,state_45824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16221__auto____0;
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16221__auto____1;
return fluree$db$session$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45859 = f__16346__auto__.call(null);
(statearr_45859[(6)] = c__16345__auto__);

return statearr_45859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45889){
var state_val_45890 = (state_45889[(1)]);
if((state_val_45890 === (1))){
var inst_45883 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_45884 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_45885 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_45886 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45884),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45885)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_45887 = fluree.db.util.log.debug.call(null,inst_45886);
var state_45889__$1 = (function (){var statearr_45891 = state_45889;
(statearr_45891[(7)] = inst_45887);

(statearr_45891[(8)] = inst_45883);

return statearr_45891;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45889__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16221__auto__ = null;
var fluree$db$session$state_machine__16221__auto____0 = (function (){
var statearr_45892 = [null,null,null,null,null,null,null,null,null];
(statearr_45892[(0)] = fluree$db$session$state_machine__16221__auto__);

(statearr_45892[(1)] = (1));

return statearr_45892;
});
var fluree$db$session$state_machine__16221__auto____1 = (function (state_45889){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45893){var ex__16224__auto__ = e45893;
var statearr_45894_45897 = state_45889;
(statearr_45894_45897[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45889[(4)]))){
var statearr_45895_45898 = state_45889;
(statearr_45895_45898[(1)] = cljs.core.first.call(null,(state_45889[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45899 = state_45889;
state_45889 = G__45899;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$state_machine__16221__auto__ = function(state_45889){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16221__auto____1.call(this,state_45889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16221__auto____0;
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16221__auto____1;
return fluree$db$session$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45896 = f__16346__auto__.call(null);
(statearr_45896[(6)] = c__16345__auto__);

return statearr_45896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__45901 = arguments.length;
switch (G__45901) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__45902 = session;
var map__45902__$1 = cljs.core.__destructure_map.call(null,map__45902);
var conn = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__45902__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_45956){
var state_val_45957 = (state_45956[(1)]);
if((state_val_45957 === (7))){
var inst_45952 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45958_45989 = state_45956__$1;
(statearr_45958_45989[(2)] = inst_45952);

(statearr_45958_45989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (1))){
var state_45956__$1 = state_45956;
var statearr_45959_45990 = state_45956__$1;
(statearr_45959_45990[(2)] = null);

(statearr_45959_45990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (4))){
var inst_45907 = (state_45956[(7)]);
var inst_45906 = (state_45956[(2)]);
var inst_45907__$1 = fluree.db.util.async.throw_err.call(null,inst_45906);
var inst_45908 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_45909 = (inst_45907__$1 == null);
var state_45956__$1 = (function (){var statearr_45960 = state_45956;
(statearr_45960[(8)] = inst_45908);

(statearr_45960[(7)] = inst_45907__$1);

return statearr_45960;
})();
if(cljs.core.truth_(inst_45909)){
var statearr_45961_45991 = state_45956__$1;
(statearr_45961_45991[(1)] = (5));

} else {
var statearr_45962_45992 = state_45956__$1;
(statearr_45962_45992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (15))){
var inst_45944 = (state_45956[(2)]);
var state_45956__$1 = (function (){var statearr_45963 = state_45956;
(statearr_45963[(9)] = inst_45944);

return statearr_45963;
})();
var statearr_45964_45993 = state_45956__$1;
(statearr_45964_45993[(2)] = null);

(statearr_45964_45993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (13))){
var inst_45948 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45966_45994 = state_45956__$1;
(statearr_45966_45994[(2)] = inst_45948);

(statearr_45966_45994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (6))){
var inst_45908 = (state_45956[(8)]);
var inst_45914 = (inst_45908 == null);
var state_45956__$1 = state_45956;
if(cljs.core.truth_(inst_45914)){
var statearr_45967_45995 = state_45956__$1;
(statearr_45967_45995[(1)] = (8));

} else {
var statearr_45968_45996 = state_45956__$1;
(statearr_45968_45996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (17))){
var _ = (function (){var statearr_45969 = state_45956;
(statearr_45969[(4)] = cljs.core.rest.call(null,(state_45956[(4)])));

return statearr_45969;
})();
var state_45956__$1 = state_45956;
var ex45965 = (state_45956__$1[(2)]);
var statearr_45970_45997 = state_45956__$1;
(statearr_45970_45997[(5)] = ex45965);


var statearr_45971_45998 = state_45956__$1;
(statearr_45971_45998[(1)] = (16));

(statearr_45971_45998[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (3))){
var inst_45954 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45956__$1,inst_45954);
} else {
if((state_val_45957 === (12))){
var state_45956__$1 = state_45956;
var statearr_45972_45999 = state_45956__$1;
(statearr_45972_45999[(2)] = null);

(statearr_45972_45999[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (2))){
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45956__$1,(4),update_chan);
} else {
if((state_val_45957 === (11))){
var state_45956__$1 = state_45956;
var statearr_45973_46000 = state_45956__$1;
(statearr_45973_46000[(2)] = null);

(statearr_45973_46000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (9))){
var state_45956__$1 = state_45956;
var statearr_45974_46001 = state_45956__$1;
(statearr_45974_46001[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (5))){
var inst_45911 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_45912 = fluree.db.util.log.info.call(null,inst_45911);
var state_45956__$1 = state_45956;
var statearr_45976_46002 = state_45956__$1;
(statearr_45976_46002[(2)] = inst_45912);

(statearr_45976_46002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (14))){
var inst_45908 = (state_45956[(8)]);
var inst_45907 = (state_45956[(7)]);
var _ = (function (){var statearr_45977 = state_45956;
(statearr_45977[(4)] = cljs.core.cons.call(null,(17),(state_45956[(4)])));

return statearr_45977;
})();
var inst_45932 = cljs.core.nth.call(null,inst_45907,(0),null);
var inst_45933 = cljs.core.nth.call(null,inst_45907,(1),null);
var inst_45934 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_45935 = cljs.core.pr_str.call(null,inst_45907);
var inst_45936 = fluree.db.util.core.trunc.call(null,inst_45935,(200));
var inst_45937 = fluree.db.util.log.trace.call(null,inst_45934,inst_45936);
var inst_45938 = fluree.db.session.process_ledger_update.call(null,inst_45908,inst_45932,inst_45933);
var state_45956__$1 = (function (){var statearr_45978 = state_45956;
(statearr_45978[(10)] = inst_45937);

return statearr_45978;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45956__$1,(18),inst_45938);
} else {
if((state_val_45957 === (16))){
var inst_45907 = (state_45956[(7)]);
var inst_45922 = (state_45956[(2)]);
var inst_45923 = fluree.db.util.log.error.call(null,inst_45922,"Exception processing ledger updates for message: ",inst_45907);
var state_45956__$1 = state_45956;
var statearr_45979_46003 = state_45956__$1;
(statearr_45979_46003[(2)] = inst_45923);

(statearr_45979_46003[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (10))){
var inst_45950 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45980_46004 = state_45956__$1;
(statearr_45980_46004[(2)] = inst_45950);

(statearr_45980_46004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (18))){
var inst_45940 = (state_45956[(2)]);
var inst_45941 = fluree.db.util.async.throw_err.call(null,inst_45940);
var _ = (function (){var statearr_45981 = state_45956;
(statearr_45981[(4)] = cljs.core.rest.call(null,(state_45956[(4)])));

return statearr_45981;
})();
var state_45956__$1 = state_45956;
var statearr_45982_46005 = state_45956__$1;
(statearr_45982_46005[(2)] = inst_45941);

(statearr_45982_46005[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (8))){
var inst_45907 = (state_45956[(7)]);
var inst_45916 = cljs.core.first.call(null,inst_45907);
var inst_45917 = cljs.core.pr_str.call(null,inst_45916);
var inst_45918 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_45917].join('');
var inst_45919 = fluree.db.util.log.warn.call(null,inst_45918);
var state_45956__$1 = state_45956;
var statearr_45983_46006 = state_45956__$1;
(statearr_45983_46006[(2)] = inst_45919);

(statearr_45983_46006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____0 = (function (){
var statearr_45984 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45984[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__);

(statearr_45984[(1)] = (1));

return statearr_45984;
});
var fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____1 = (function (state_45956){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_45956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e45985){var ex__16224__auto__ = e45985;
var statearr_45986_46007 = state_45956;
(statearr_45986_46007[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_45956[(4)]))){
var statearr_45987_46008 = state_45956;
(statearr_45987_46008[(1)] = cljs.core.first.call(null,(state_45956[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46009 = state_45956;
state_45956 = G__46009;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__ = function(state_45956){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____1.call(this,state_45956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__16221__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_45988 = f__16346__auto__.call(null);
(statearr_45988[(6)] = c__16345__auto__);

return statearr_45988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__46010){
var map__46011 = p__46010;
var map__46011__$1 = cljs.core.__destructure_map.call(null,map__46011);
var network = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__46011__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__46015 = block_result;
var map__46015__$1 = cljs.core.__destructure_map.call(null,map__46015);
var block = cljs.core.get.call(null,map__46015__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__46015__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__46015__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__46015__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__46015__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__46016 = tx_result;
var map__46016__$1 = cljs.core.__destructure_map.call(null,map__46016);
var t = cljs.core.get.call(null,map__46016__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__46016__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__46012_SHARP_){
return cljs.core._EQ_.call(null,t,p1__46012_SHARP_.t);
}):(function (p1__46013_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__46013_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__46014_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__46014_SHARP_))){
return cljs.core.nth.call(null,p1__46014_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__46017 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__46017,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__46017,(1),null);
var error = cljs.core.nth.call(null,vec__46017,(2),null);
var message = cljs.core.nth.call(null,vec__46017,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__46021 = arguments.length;
switch (G__46021) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__46022){
var map__46023 = p__46022;
var map__46023__$1 = cljs.core.__destructure_map.call(null,map__46023);
var state = cljs.core.get.call(null,map__46023__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__46023__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__46023__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__46023__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__46024 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__46024,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__46024,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__46024,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__46027 = cljs.core.seq.call(null,tids);
var chunk__46028 = null;
var count__46029 = (0);
var i__46030 = (0);
while(true){
if((i__46030 < count__46029)){
var tid = cljs.core._nth.call(null,chunk__46028,i__46030);
var temp__5753__auto___46143__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___46143__$1)){
var keyed_callbacks_46144 = temp__5753__auto___46143__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_46145 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__46071_46146 = cljs.core.seq.call(null,keyed_callbacks_46144);
var chunk__46072_46147 = null;
var count__46073_46148 = (0);
var i__46074_46149 = (0);
while(true){
if((i__46074_46149 < count__46073_46148)){
var vec__46083_46150 = cljs.core._nth.call(null,chunk__46072_46147,i__46074_46149);
var k_46151 = cljs.core.nth.call(null,vec__46083_46150,(0),null);
var f_46152 = cljs.core.nth.call(null,vec__46083_46150,(1),null);
try{f_46152.call(null,tx_response_46145);
}catch (e46086){var e_46153 = e46086;
fluree.db.util.log.error.call(null,e_46153,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__46154 = seq__46071_46146;
var G__46155 = chunk__46072_46147;
var G__46156 = count__46073_46148;
var G__46157 = (i__46074_46149 + (1));
seq__46071_46146 = G__46154;
chunk__46072_46147 = G__46155;
count__46073_46148 = G__46156;
i__46074_46149 = G__46157;
continue;
} else {
var temp__5753__auto___46158__$2 = cljs.core.seq.call(null,seq__46071_46146);
if(temp__5753__auto___46158__$2){
var seq__46071_46159__$1 = temp__5753__auto___46158__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46071_46159__$1)){
var c__4638__auto___46160 = cljs.core.chunk_first.call(null,seq__46071_46159__$1);
var G__46161 = cljs.core.chunk_rest.call(null,seq__46071_46159__$1);
var G__46162 = c__4638__auto___46160;
var G__46163 = cljs.core.count.call(null,c__4638__auto___46160);
var G__46164 = (0);
seq__46071_46146 = G__46161;
chunk__46072_46147 = G__46162;
count__46073_46148 = G__46163;
i__46074_46149 = G__46164;
continue;
} else {
var vec__46087_46165 = cljs.core.first.call(null,seq__46071_46159__$1);
var k_46166 = cljs.core.nth.call(null,vec__46087_46165,(0),null);
var f_46167 = cljs.core.nth.call(null,vec__46087_46165,(1),null);
try{f_46167.call(null,tx_response_46145);
}catch (e46090){var e_46168 = e46090;
fluree.db.util.log.error.call(null,e_46168,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__46169 = cljs.core.next.call(null,seq__46071_46159__$1);
var G__46170 = null;
var G__46171 = (0);
var G__46172 = (0);
seq__46071_46146 = G__46169;
chunk__46072_46147 = G__46170;
count__46073_46148 = G__46171;
i__46074_46149 = G__46172;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__46173 = seq__46027;
var G__46174 = chunk__46028;
var G__46175 = count__46029;
var G__46176 = (i__46030 + (1));
seq__46027 = G__46173;
chunk__46028 = G__46174;
count__46029 = G__46175;
i__46030 = G__46176;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq.call(null,seq__46027);
if(temp__5753__auto____$1){
var seq__46027__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46027__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__46027__$1);
var G__46177 = cljs.core.chunk_rest.call(null,seq__46027__$1);
var G__46178 = c__4638__auto__;
var G__46179 = cljs.core.count.call(null,c__4638__auto__);
var G__46180 = (0);
seq__46027 = G__46177;
chunk__46028 = G__46178;
count__46029 = G__46179;
i__46030 = G__46180;
continue;
} else {
var tid = cljs.core.first.call(null,seq__46027__$1);
var temp__5753__auto___46181__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___46181__$2)){
var keyed_callbacks_46182 = temp__5753__auto___46181__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_46183 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__46091_46184 = cljs.core.seq.call(null,keyed_callbacks_46182);
var chunk__46092_46185 = null;
var count__46093_46186 = (0);
var i__46094_46187 = (0);
while(true){
if((i__46094_46187 < count__46093_46186)){
var vec__46103_46188 = cljs.core._nth.call(null,chunk__46092_46185,i__46094_46187);
var k_46189 = cljs.core.nth.call(null,vec__46103_46188,(0),null);
var f_46190 = cljs.core.nth.call(null,vec__46103_46188,(1),null);
try{f_46190.call(null,tx_response_46183);
}catch (e46106){var e_46191 = e46106;
fluree.db.util.log.error.call(null,e_46191,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__46192 = seq__46091_46184;
var G__46193 = chunk__46092_46185;
var G__46194 = count__46093_46186;
var G__46195 = (i__46094_46187 + (1));
seq__46091_46184 = G__46192;
chunk__46092_46185 = G__46193;
count__46093_46186 = G__46194;
i__46094_46187 = G__46195;
continue;
} else {
var temp__5753__auto___46196__$3 = cljs.core.seq.call(null,seq__46091_46184);
if(temp__5753__auto___46196__$3){
var seq__46091_46197__$1 = temp__5753__auto___46196__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46091_46197__$1)){
var c__4638__auto___46198 = cljs.core.chunk_first.call(null,seq__46091_46197__$1);
var G__46199 = cljs.core.chunk_rest.call(null,seq__46091_46197__$1);
var G__46200 = c__4638__auto___46198;
var G__46201 = cljs.core.count.call(null,c__4638__auto___46198);
var G__46202 = (0);
seq__46091_46184 = G__46199;
chunk__46092_46185 = G__46200;
count__46093_46186 = G__46201;
i__46094_46187 = G__46202;
continue;
} else {
var vec__46107_46203 = cljs.core.first.call(null,seq__46091_46197__$1);
var k_46204 = cljs.core.nth.call(null,vec__46107_46203,(0),null);
var f_46205 = cljs.core.nth.call(null,vec__46107_46203,(1),null);
try{f_46205.call(null,tx_response_46183);
}catch (e46110){var e_46206 = e46110;
fluree.db.util.log.error.call(null,e_46206,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__46207 = cljs.core.next.call(null,seq__46091_46197__$1);
var G__46208 = null;
var G__46209 = (0);
var G__46210 = (0);
seq__46091_46184 = G__46207;
chunk__46092_46185 = G__46208;
count__46093_46186 = G__46209;
i__46094_46187 = G__46210;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__46211 = cljs.core.next.call(null,seq__46027__$1);
var G__46212 = null;
var G__46213 = (0);
var G__46214 = (0);
seq__46027 = G__46211;
chunk__46028 = G__46212;
count__46029 = G__46213;
i__46030 = G__46214;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_46215 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__16345__auto___46216 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_46127){
var state_val_46128 = (state_46127[(1)]);
if((state_val_46128 === (1))){
var state_46127__$1 = state_46127;
var statearr_46129_46217 = state_46127__$1;
(statearr_46129_46217[(2)] = null);

(statearr_46129_46217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (2))){
var inst_46112 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_46127__$1 = state_46127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46127__$1,(4),inst_46112);
} else {
if((state_val_46128 === (3))){
var inst_46125 = (state_46127[(2)]);
var state_46127__$1 = state_46127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46127__$1,inst_46125);
} else {
if((state_val_46128 === (4))){
var inst_46114 = (state_46127[(7)]);
var inst_46114__$1 = (state_46127[(2)]);
var inst_46115 = (inst_46114__$1 == null);
var state_46127__$1 = (function (){var statearr_46130 = state_46127;
(statearr_46130[(7)] = inst_46114__$1);

return statearr_46130;
})();
if(cljs.core.truth_(inst_46115)){
var statearr_46131_46218 = state_46127__$1;
(statearr_46131_46218[(1)] = (5));

} else {
var statearr_46132_46219 = state_46127__$1;
(statearr_46132_46219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (5))){
var inst_46117 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_46118 = fluree.db.util.log.info.call(null,inst_46117);
var state_46127__$1 = state_46127;
var statearr_46133_46220 = state_46127__$1;
(statearr_46133_46220[(2)] = inst_46118);

(statearr_46133_46220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (6))){
var inst_46114 = (state_46127[(7)]);
var inst_46120 = transact_handler_46215.call(null,conn,inst_46114);
var state_46127__$1 = (function (){var statearr_46134 = state_46127;
(statearr_46134[(8)] = inst_46120);

return statearr_46134;
})();
var statearr_46135_46221 = state_46127__$1;
(statearr_46135_46221[(2)] = null);

(statearr_46135_46221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46128 === (7))){
var inst_46123 = (state_46127[(2)]);
var state_46127__$1 = state_46127;
var statearr_46136_46222 = state_46127__$1;
(statearr_46136_46222[(2)] = inst_46123);

(statearr_46136_46222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16221__auto__ = null;
var fluree$db$session$state_machine__16221__auto____0 = (function (){
var statearr_46137 = [null,null,null,null,null,null,null,null,null];
(statearr_46137[(0)] = fluree$db$session$state_machine__16221__auto__);

(statearr_46137[(1)] = (1));

return statearr_46137;
});
var fluree$db$session$state_machine__16221__auto____1 = (function (state_46127){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_46127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e46138){var ex__16224__auto__ = e46138;
var statearr_46139_46223 = state_46127;
(statearr_46139_46223[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_46127[(4)]))){
var statearr_46140_46224 = state_46127;
(statearr_46140_46224[(1)] = cljs.core.first.call(null,(state_46127[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46225 = state_46127;
state_46127 = G__46225;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$session$state_machine__16221__auto__ = function(state_46127){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16221__auto____1.call(this,state_46127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16221__auto____0;
fluree$db$session$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16221__auto____1;
return fluree$db$session$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_46141 = f__16346__auto__.call(null);
(statearr_46141[(6)] = c__16345__auto___46216);

return statearr_46141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__46227){
var map__46228 = p__46227;
var map__46228__$1 = cljs.core.__destructure_map.call(null,map__46228);
var session = map__46228__$1;
var state = cljs.core.get.call(null,map__46228__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (p1__46226_SHARP_){
return cljs.core.assoc.call(null,p1__46226_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__46226_SHARP_) + (1)));
}));

var or__4212__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var _ = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.call(null,state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.call(null,st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__46231 = arguments.length;
switch (G__46231) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__46232 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__46229_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__46229_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__46232);
} else {
return G__46232;
}
})();
var seq__46233 = cljs.core.seq.call(null,sessions);
var chunk__46234 = null;
var count__46235 = (0);
var i__46236 = (0);
while(true){
if((i__46236 < count__46235)){
var session = cljs.core._nth.call(null,chunk__46234,i__46236);
fluree.db.session.close.call(null,session);


var G__46238 = seq__46233;
var G__46239 = chunk__46234;
var G__46240 = count__46235;
var G__46241 = (i__46236 + (1));
seq__46233 = G__46238;
chunk__46234 = G__46239;
count__46235 = G__46240;
i__46236 = G__46241;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__46233);
if(temp__5753__auto__){
var seq__46233__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46233__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__46233__$1);
var G__46242 = cljs.core.chunk_rest.call(null,seq__46233__$1);
var G__46243 = c__4638__auto__;
var G__46244 = cljs.core.count.call(null,c__4638__auto__);
var G__46245 = (0);
seq__46233 = G__46242;
chunk__46234 = G__46243;
count__46235 = G__46244;
i__46236 = G__46245;
continue;
} else {
var session = cljs.core.first.call(null,seq__46233__$1);
fluree.db.session.close.call(null,session);


var G__46246 = cljs.core.next.call(null,seq__46233__$1);
var G__46247 = null;
var G__46248 = (0);
var G__46249 = (0);
seq__46233 = G__46246;
chunk__46234 = G__46247;
count__46235 = G__46248;
i__46236 = G__46249;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
