// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34661){
var state_val_34662 = (state_34661[(1)]);
if((state_val_34662 === (7))){
var inst_34650 = (state_34661[(7)]);
var inst_34652 = fluree.db.storage.core.serde.call(null,conn);
var inst_34653 = fluree.db.serde.protocol._deserialize_block.call(null,inst_34652,inst_34650);
var state_34661__$1 = state_34661;
var statearr_34663_34682 = state_34661__$1;
(statearr_34663_34682[(2)] = inst_34653);

(statearr_34663_34682[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (1))){
var state_34661__$1 = state_34661;
var statearr_34664_34683 = state_34661__$1;
(statearr_34664_34683[(2)] = null);

(statearr_34664_34683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (4))){
var inst_34640 = (state_34661[(2)]);
var state_34661__$1 = state_34661;
var statearr_34665_34684 = state_34661__$1;
(statearr_34665_34684[(2)] = inst_34640);

(statearr_34665_34684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (6))){
var inst_34650 = (state_34661[(7)]);
var inst_34649 = (state_34661[(2)]);
var inst_34650__$1 = fluree.db.util.async.throw_err.call(null,inst_34649);
var state_34661__$1 = (function (){var statearr_34666 = state_34661;
(statearr_34666[(7)] = inst_34650__$1);

return statearr_34666;
})();
if(cljs.core.truth_(inst_34650__$1)){
var statearr_34667_34685 = state_34661__$1;
(statearr_34667_34685[(1)] = (7));

} else {
var statearr_34668_34686 = state_34661__$1;
(statearr_34668_34686[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (3))){
var inst_34659 = (state_34661[(2)]);
var state_34661__$1 = state_34661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34661__$1,inst_34659);
} else {
if((state_val_34662 === (2))){
var _ = (function (){var statearr_34670 = state_34661;
(statearr_34670[(4)] = cljs.core.cons.call(null,(5),(state_34661[(4)])));

return statearr_34670;
})();
var inst_34646 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_34647 = fluree.db.storage.core.storage_read.call(null,conn,inst_34646);
var state_34661__$1 = state_34661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34661__$1,(6),inst_34647);
} else {
if((state_val_34662 === (9))){
var inst_34656 = (state_34661[(2)]);
var _ = (function (){var statearr_34671 = state_34661;
(statearr_34671[(4)] = cljs.core.rest.call(null,(state_34661[(4)])));

return statearr_34671;
})();
var state_34661__$1 = state_34661;
var statearr_34672_34687 = state_34661__$1;
(statearr_34672_34687[(2)] = inst_34656);

(statearr_34672_34687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (5))){
var _ = (function (){var statearr_34673 = state_34661;
(statearr_34673[(4)] = cljs.core.rest.call(null,(state_34661[(4)])));

return statearr_34673;
})();
var state_34661__$1 = state_34661;
var ex34669 = (state_34661__$1[(2)]);
var statearr_34674_34688 = state_34661__$1;
(statearr_34674_34688[(5)] = ex34669);


if((ex34669 instanceof Error)){
var statearr_34675_34689 = state_34661__$1;
(statearr_34675_34689[(1)] = (4));

(statearr_34675_34689[(5)] = null);

} else {
throw ex34669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34662 === (8))){
var state_34661__$1 = state_34661;
var statearr_34676_34690 = state_34661__$1;
(statearr_34676_34690[(2)] = null);

(statearr_34676_34690[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__16221__auto____0 = (function (){
var statearr_34677 = [null,null,null,null,null,null,null,null];
(statearr_34677[(0)] = fluree$db$storage$core$read_block_$_state_machine__16221__auto__);

(statearr_34677[(1)] = (1));

return statearr_34677;
});
var fluree$db$storage$core$read_block_$_state_machine__16221__auto____1 = (function (state_34661){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34678){var ex__16224__auto__ = e34678;
var statearr_34679_34691 = state_34661;
(statearr_34679_34691[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34661[(4)]))){
var statearr_34680_34692 = state_34661;
(statearr_34680_34692[(1)] = cljs.core.first.call(null,(state_34661[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34693 = state_34661;
state_34661 = G__34693;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__16221__auto__ = function(state_34661){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__16221__auto____1.call(this,state_34661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34681 = f__16346__auto__.call(null);
(statearr_34681[(6)] = c__16345__auto__);

return statearr_34681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34716){
var state_val_34717 = (state_34716[(1)]);
if((state_val_34717 === (7))){
var inst_34705 = (state_34716[(7)]);
var inst_34707 = fluree.db.storage.core.serde.call(null,conn);
var inst_34708 = fluree.db.serde.protocol._deserialize_block.call(null,inst_34707,inst_34705);
var state_34716__$1 = state_34716;
var statearr_34718_34737 = state_34716__$1;
(statearr_34718_34737[(2)] = inst_34708);

(statearr_34718_34737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (1))){
var state_34716__$1 = state_34716;
var statearr_34719_34738 = state_34716__$1;
(statearr_34719_34738[(2)] = null);

(statearr_34719_34738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (4))){
var inst_34694 = (state_34716[(2)]);
var state_34716__$1 = state_34716;
var statearr_34720_34739 = state_34716__$1;
(statearr_34720_34739[(2)] = inst_34694);

(statearr_34720_34739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (6))){
var inst_34705 = (state_34716[(7)]);
var inst_34704 = (state_34716[(2)]);
var inst_34705__$1 = fluree.db.util.async.throw_err.call(null,inst_34704);
var state_34716__$1 = (function (){var statearr_34721 = state_34716;
(statearr_34721[(7)] = inst_34705__$1);

return statearr_34721;
})();
if(cljs.core.truth_(inst_34705__$1)){
var statearr_34722_34740 = state_34716__$1;
(statearr_34722_34740[(1)] = (7));

} else {
var statearr_34723_34741 = state_34716__$1;
(statearr_34723_34741[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (3))){
var inst_34714 = (state_34716[(2)]);
var state_34716__$1 = state_34716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34716__$1,inst_34714);
} else {
if((state_val_34717 === (2))){
var _ = (function (){var statearr_34725 = state_34716;
(statearr_34725[(4)] = cljs.core.cons.call(null,(5),(state_34716[(4)])));

return statearr_34725;
})();
var inst_34700 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_34701 = [inst_34700,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_34702 = fluree.db.storage.core.storage_read.call(null,conn,inst_34701);
var state_34716__$1 = state_34716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34716__$1,(6),inst_34702);
} else {
if((state_val_34717 === (9))){
var inst_34711 = (state_34716[(2)]);
var _ = (function (){var statearr_34726 = state_34716;
(statearr_34726[(4)] = cljs.core.rest.call(null,(state_34716[(4)])));

return statearr_34726;
})();
var state_34716__$1 = state_34716;
var statearr_34727_34742 = state_34716__$1;
(statearr_34727_34742[(2)] = inst_34711);

(statearr_34727_34742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (5))){
var _ = (function (){var statearr_34728 = state_34716;
(statearr_34728[(4)] = cljs.core.rest.call(null,(state_34716[(4)])));

return statearr_34728;
})();
var state_34716__$1 = state_34716;
var ex34724 = (state_34716__$1[(2)]);
var statearr_34729_34743 = state_34716__$1;
(statearr_34729_34743[(5)] = ex34724);


if((ex34724 instanceof Error)){
var statearr_34730_34744 = state_34716__$1;
(statearr_34730_34744[(1)] = (4));

(statearr_34730_34744[(5)] = null);

} else {
throw ex34724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34717 === (8))){
var state_34716__$1 = state_34716;
var statearr_34731_34745 = state_34716__$1;
(statearr_34731_34745[(2)] = null);

(statearr_34731_34745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____0 = (function (){
var statearr_34732 = [null,null,null,null,null,null,null,null];
(statearr_34732[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__);

(statearr_34732[(1)] = (1));

return statearr_34732;
});
var fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____1 = (function (state_34716){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34733){var ex__16224__auto__ = e34733;
var statearr_34734_34746 = state_34716;
(statearr_34734_34746[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34716[(4)]))){
var statearr_34735_34747 = state_34716;
(statearr_34735_34747[(1)] = cljs.core.first.call(null,(state_34716[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34748 = state_34716;
state_34716 = G__34748;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__ = function(state_34716){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____1.call(this,state_34716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34736 = f__16346__auto__.call(null);
(statearr_34736[(6)] = c__16345__auto__);

return statearr_34736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34772){
var state_val_34773 = (state_34772[(1)]);
if((state_val_34773 === (1))){
var state_34772__$1 = state_34772;
var statearr_34774_34788 = state_34772__$1;
(statearr_34774_34788[(2)] = null);

(statearr_34774_34788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (2))){
var _ = (function (){var statearr_34775 = state_34772;
(statearr_34775[(4)] = cljs.core.cons.call(null,(5),(state_34772[(4)])));

return statearr_34775;
})();
var inst_34755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34756 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_34757 = (new cljs.core.PersistentVector(null,3,(5),inst_34755,inst_34756,null));
var inst_34758 = cljs.core.select_keys.call(null,block_data,inst_34757);
var inst_34759 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_34758);
var inst_34760 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_34759);
var inst_34761 = [inst_34760,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_34762 = fluree.db.storage.core.serde.call(null,conn);
var inst_34763 = fluree.db.serde.protocol._serialize_block.call(null,inst_34762,inst_34758);
var inst_34764 = fluree.db.storage.core.storage_write.call(null,conn,inst_34761,inst_34763);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34772__$1,(6),inst_34764);
} else {
if((state_val_34773 === (3))){
var inst_34770 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34772__$1,inst_34770);
} else {
if((state_val_34773 === (4))){
var inst_34749 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
var statearr_34777_34789 = state_34772__$1;
(statearr_34777_34789[(2)] = inst_34749);

(statearr_34777_34789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (5))){
var _ = (function (){var statearr_34778 = state_34772;
(statearr_34778[(4)] = cljs.core.rest.call(null,(state_34772[(4)])));

return statearr_34778;
})();
var state_34772__$1 = state_34772;
var ex34776 = (state_34772__$1[(2)]);
var statearr_34779_34790 = state_34772__$1;
(statearr_34779_34790[(5)] = ex34776);


if((ex34776 instanceof Error)){
var statearr_34780_34791 = state_34772__$1;
(statearr_34780_34791[(1)] = (4));

(statearr_34780_34791[(5)] = null);

} else {
throw ex34776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (6))){
var inst_34766 = (state_34772[(2)]);
var inst_34767 = fluree.db.util.async.throw_err.call(null,inst_34766);
var _ = (function (){var statearr_34781 = state_34772;
(statearr_34781[(4)] = cljs.core.rest.call(null,(state_34772[(4)])));

return statearr_34781;
})();
var state_34772__$1 = state_34772;
var statearr_34782_34792 = state_34772__$1;
(statearr_34782_34792[(2)] = inst_34767);

(statearr_34782_34792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____0 = (function (){
var statearr_34783 = [null,null,null,null,null,null,null];
(statearr_34783[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__);

(statearr_34783[(1)] = (1));

return statearr_34783;
});
var fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____1 = (function (state_34772){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34784){var ex__16224__auto__ = e34784;
var statearr_34785_34793 = state_34772;
(statearr_34785_34793[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34772[(4)]))){
var statearr_34786_34794 = state_34772;
(statearr_34786_34794[(1)] = cljs.core.first.call(null,(state_34772[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34795 = state_34772;
state_34772 = G__34795;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__ = function(state_34772){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____1.call(this,state_34772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34787 = f__16346__auto__.call(null);
(statearr_34787[(6)] = c__16345__auto__);

return statearr_34787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34818){
var state_val_34819 = (state_34818[(1)]);
if((state_val_34819 === (1))){
var state_34818__$1 = state_34818;
var statearr_34820_34834 = state_34818__$1;
(statearr_34820_34834[(2)] = null);

(statearr_34820_34834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (2))){
var _ = (function (){var statearr_34821 = state_34818;
(statearr_34821[(4)] = cljs.core.cons.call(null,(5),(state_34818[(4)])));

return statearr_34821;
})();
var inst_34802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34803 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_34804 = (new cljs.core.PersistentVector(null,3,(5),inst_34802,inst_34803,null));
var inst_34805 = cljs.core.select_keys.call(null,block_data,inst_34804);
var inst_34806 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_34805);
var inst_34807 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_34806);
var inst_34808 = fluree.db.storage.core.serde.call(null,conn);
var inst_34809 = fluree.db.serde.protocol._serialize_block.call(null,inst_34808,inst_34805);
var inst_34810 = fluree.db.storage.core.storage_write.call(null,conn,inst_34807,inst_34809);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34818__$1,(6),inst_34810);
} else {
if((state_val_34819 === (3))){
var inst_34816 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34818__$1,inst_34816);
} else {
if((state_val_34819 === (4))){
var inst_34796 = (state_34818[(2)]);
var state_34818__$1 = state_34818;
var statearr_34823_34835 = state_34818__$1;
(statearr_34823_34835[(2)] = inst_34796);

(statearr_34823_34835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (5))){
var _ = (function (){var statearr_34824 = state_34818;
(statearr_34824[(4)] = cljs.core.rest.call(null,(state_34818[(4)])));

return statearr_34824;
})();
var state_34818__$1 = state_34818;
var ex34822 = (state_34818__$1[(2)]);
var statearr_34825_34836 = state_34818__$1;
(statearr_34825_34836[(5)] = ex34822);


if((ex34822 instanceof Error)){
var statearr_34826_34837 = state_34818__$1;
(statearr_34826_34837[(1)] = (4));

(statearr_34826_34837[(5)] = null);

} else {
throw ex34822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34819 === (6))){
var inst_34812 = (state_34818[(2)]);
var inst_34813 = fluree.db.util.async.throw_err.call(null,inst_34812);
var _ = (function (){var statearr_34827 = state_34818;
(statearr_34827[(4)] = cljs.core.rest.call(null,(state_34818[(4)])));

return statearr_34827;
})();
var state_34818__$1 = state_34818;
var statearr_34828_34838 = state_34818__$1;
(statearr_34828_34838[(2)] = inst_34813);

(statearr_34828_34838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__16221__auto____0 = (function (){
var statearr_34829 = [null,null,null,null,null,null,null];
(statearr_34829[(0)] = fluree$db$storage$core$write_block_$_state_machine__16221__auto__);

(statearr_34829[(1)] = (1));

return statearr_34829;
});
var fluree$db$storage$core$write_block_$_state_machine__16221__auto____1 = (function (state_34818){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34830){var ex__16224__auto__ = e34830;
var statearr_34831_34839 = state_34818;
(statearr_34831_34839[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34818[(4)]))){
var statearr_34832_34840 = state_34818;
(statearr_34832_34840[(1)] = cljs.core.first.call(null,(state_34818[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34841 = state_34818;
state_34818 = G__34841;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__16221__auto__ = function(state_34818){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__16221__auto____1.call(this,state_34818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34833 = f__16346__auto__.call(null);
(statearr_34833[(6)] = c__16345__auto__);

return statearr_34833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34861){
var state_val_34862 = (state_34861[(1)]);
if((state_val_34862 === (1))){
var state_34861__$1 = state_34861;
var statearr_34863_34877 = state_34861__$1;
(statearr_34863_34877[(2)] = null);

(statearr_34863_34877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (2))){
var _ = (function (){var statearr_34864 = state_34861;
(statearr_34864[(4)] = cljs.core.cons.call(null,(5),(state_34861[(4)])));

return statearr_34864;
})();
var inst_34848 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_34849 = [history,next_his_key];
var inst_34850 = cljs.core.PersistentHashMap.fromArrays(inst_34848,inst_34849);
var inst_34851 = fluree.db.storage.core.serde.call(null,conn);
var inst_34852 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_34851,inst_34850);
var inst_34853 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_34852);
var state_34861__$1 = state_34861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34861__$1,(6),inst_34853);
} else {
if((state_val_34862 === (3))){
var inst_34859 = (state_34861[(2)]);
var state_34861__$1 = state_34861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34861__$1,inst_34859);
} else {
if((state_val_34862 === (4))){
var inst_34842 = (state_34861[(2)]);
var state_34861__$1 = state_34861;
var statearr_34866_34878 = state_34861__$1;
(statearr_34866_34878[(2)] = inst_34842);

(statearr_34866_34878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (5))){
var _ = (function (){var statearr_34867 = state_34861;
(statearr_34867[(4)] = cljs.core.rest.call(null,(state_34861[(4)])));

return statearr_34867;
})();
var state_34861__$1 = state_34861;
var ex34865 = (state_34861__$1[(2)]);
var statearr_34868_34879 = state_34861__$1;
(statearr_34868_34879[(5)] = ex34865);


if((ex34865 instanceof Error)){
var statearr_34869_34880 = state_34861__$1;
(statearr_34869_34880[(1)] = (4));

(statearr_34869_34880[(5)] = null);

} else {
throw ex34865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34862 === (6))){
var inst_34855 = (state_34861[(2)]);
var inst_34856 = fluree.db.util.async.throw_err.call(null,inst_34855);
var _ = (function (){var statearr_34870 = state_34861;
(statearr_34870[(4)] = cljs.core.rest.call(null,(state_34861[(4)])));

return statearr_34870;
})();
var state_34861__$1 = state_34861;
var statearr_34871_34881 = state_34861__$1;
(statearr_34871_34881[(2)] = inst_34856);

(statearr_34871_34881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__16221__auto____0 = (function (){
var statearr_34872 = [null,null,null,null,null,null,null];
(statearr_34872[(0)] = fluree$db$storage$core$write_history_$_state_machine__16221__auto__);

(statearr_34872[(1)] = (1));

return statearr_34872;
});
var fluree$db$storage$core$write_history_$_state_machine__16221__auto____1 = (function (state_34861){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34873){var ex__16224__auto__ = e34873;
var statearr_34874_34882 = state_34861;
(statearr_34874_34882[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34861[(4)]))){
var statearr_34875_34883 = state_34861;
(statearr_34875_34883[(1)] = cljs.core.first.call(null,(state_34861[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34884 = state_34861;
state_34861 = G__34884;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__16221__auto__ = function(state_34861){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__16221__auto____1.call(this,state_34861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_history_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34876 = f__16346__auto__.call(null);
(statearr_34876[(6)] = c__16345__auto__);

return statearr_34876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34910){
var state_val_34911 = (state_34910[(1)]);
if((state_val_34911 === (1))){
var state_34910__$1 = state_34910;
var statearr_34912_34929 = state_34910__$1;
(statearr_34912_34929[(2)] = null);

(statearr_34912_34929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (2))){
var inst_34891 = (state_34910[(7)]);
var _ = (function (){var statearr_34913 = state_34910;
(statearr_34913[(4)] = cljs.core.cons.call(null,(5),(state_34910[(4)])));

return statearr_34913;
})();
var inst_34891__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_34892 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34891__$1),"-his"].join('');
var inst_34893 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_34894 = [flakes,inst_34892];
var inst_34895 = cljs.core.PersistentHashMap.fromArrays(inst_34893,inst_34894);
var inst_34896 = fluree.db.storage.core.serde.call(null,conn);
var inst_34897 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_34896,inst_34895);
var inst_34898 = fluree.db.storage.core.write_history.call(null,conn,history,inst_34892,null);
var inst_34899 = fluree.db.storage.core.storage_write.call(null,conn,inst_34891__$1,inst_34897);
var state_34910__$1 = (function (){var statearr_34914 = state_34910;
(statearr_34914[(7)] = inst_34891__$1);

(statearr_34914[(8)] = inst_34899);

return statearr_34914;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34910__$1,(6),inst_34898);
} else {
if((state_val_34911 === (3))){
var inst_34908 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34910__$1,inst_34908);
} else {
if((state_val_34911 === (4))){
var inst_34885 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34916_34930 = state_34910__$1;
(statearr_34916_34930[(2)] = inst_34885);

(statearr_34916_34930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (5))){
var _ = (function (){var statearr_34917 = state_34910;
(statearr_34917[(4)] = cljs.core.rest.call(null,(state_34910[(4)])));

return statearr_34917;
})();
var state_34910__$1 = state_34910;
var ex34915 = (state_34910__$1[(2)]);
var statearr_34918_34931 = state_34910__$1;
(statearr_34918_34931[(5)] = ex34915);


if((ex34915 instanceof Error)){
var statearr_34919_34932 = state_34910__$1;
(statearr_34919_34932[(1)] = (4));

(statearr_34919_34932[(5)] = null);

} else {
throw ex34915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34911 === (6))){
var inst_34899 = (state_34910[(8)]);
var inst_34901 = (state_34910[(2)]);
var inst_34902 = fluree.db.util.async.throw_err.call(null,inst_34901);
var state_34910__$1 = (function (){var statearr_34920 = state_34910;
(statearr_34920[(9)] = inst_34902);

return statearr_34920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34910__$1,(7),inst_34899);
} else {
if((state_val_34911 === (7))){
var inst_34891 = (state_34910[(7)]);
var inst_34904 = (state_34910[(2)]);
var inst_34905 = fluree.db.util.async.throw_err.call(null,inst_34904);
var _ = (function (){var statearr_34921 = state_34910;
(statearr_34921[(4)] = cljs.core.rest.call(null,(state_34910[(4)])));

return statearr_34921;
})();
var state_34910__$1 = (function (){var statearr_34922 = state_34910;
(statearr_34922[(10)] = inst_34905);

return statearr_34922;
})();
var statearr_34923_34933 = state_34910__$1;
(statearr_34923_34933[(2)] = inst_34891);

(statearr_34923_34933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____0 = (function (){
var statearr_34924 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34924[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__);

(statearr_34924[(1)] = (1));

return statearr_34924;
});
var fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____1 = (function (state_34910){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34925){var ex__16224__auto__ = e34925;
var statearr_34926_34934 = state_34910;
(statearr_34926_34934[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34910[(4)]))){
var statearr_34927_34935 = state_34910;
(statearr_34927_34935[(1)] = cljs.core.first.call(null,(state_34910[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34936 = state_34910;
state_34910 = G__34936;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__ = function(state_34910){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____1.call(this,state_34910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34928 = f__16346__auto__.call(null);
(statearr_34928[(6)] = c__16345__auto__);

return statearr_34928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34953){
var state_val_34954 = (state_34953[(1)]);
if((state_val_34954 === (1))){
var state_34953__$1 = state_34953;
var statearr_34955_34970 = state_34953__$1;
(statearr_34955_34970[(2)] = null);

(statearr_34955_34970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (2))){
var _ = (function (){var statearr_34956 = state_34953;
(statearr_34956[(4)] = cljs.core.cons.call(null,(5),(state_34953[(4)])));

return statearr_34956;
})();
var inst_34943 = fluree.db.storage.core.serde.call(null,conn);
var inst_34944 = fluree.db.serde.protocol._serialize_branch.call(null,inst_34943,data);
var inst_34945 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_34944);
var state_34953__$1 = state_34953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34953__$1,(6),inst_34945);
} else {
if((state_val_34954 === (3))){
var inst_34951 = (state_34953[(2)]);
var state_34953__$1 = state_34953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34953__$1,inst_34951);
} else {
if((state_val_34954 === (4))){
var inst_34937 = (state_34953[(2)]);
var state_34953__$1 = state_34953;
var statearr_34958_34971 = state_34953__$1;
(statearr_34958_34971[(2)] = inst_34937);

(statearr_34958_34971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (5))){
var _ = (function (){var statearr_34959 = state_34953;
(statearr_34959[(4)] = cljs.core.rest.call(null,(state_34953[(4)])));

return statearr_34959;
})();
var state_34953__$1 = state_34953;
var ex34957 = (state_34953__$1[(2)]);
var statearr_34960_34972 = state_34953__$1;
(statearr_34960_34972[(5)] = ex34957);


if((ex34957 instanceof Error)){
var statearr_34961_34973 = state_34953__$1;
(statearr_34961_34973[(1)] = (4));

(statearr_34961_34973[(5)] = null);

} else {
throw ex34957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34954 === (6))){
var inst_34947 = (state_34953[(2)]);
var inst_34948 = fluree.db.util.async.throw_err.call(null,inst_34947);
var _ = (function (){var statearr_34962 = state_34953;
(statearr_34962[(4)] = cljs.core.rest.call(null,(state_34953[(4)])));

return statearr_34962;
})();
var state_34953__$1 = (function (){var statearr_34963 = state_34953;
(statearr_34963[(7)] = inst_34948);

return statearr_34963;
})();
var statearr_34964_34974 = state_34953__$1;
(statearr_34964_34974[(2)] = key);

(statearr_34964_34974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____0 = (function (){
var statearr_34965 = [null,null,null,null,null,null,null,null];
(statearr_34965[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__);

(statearr_34965[(1)] = (1));

return statearr_34965;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____1 = (function (state_34953){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34966){var ex__16224__auto__ = e34966;
var statearr_34967_34975 = state_34953;
(statearr_34967_34975[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34953[(4)]))){
var statearr_34968_34976 = state_34953;
(statearr_34968_34976[(1)] = cljs.core.first.call(null,(state_34953[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34977 = state_34953;
state_34953 = G__34977;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__ = function(state_34953){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____1.call(this,state_34953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34969 = f__16346__auto__.call(null);
(statearr_34969[(6)] = c__16345__auto__);

return statearr_34969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__34978_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__34978_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__34979){
var map__34980 = p__34979;
var map__34980__$1 = cljs.core.__destructure_map.call(null,map__34980);
var progress = map__34980__$1;
var garbage = cljs.core.get.call(null,map__34980__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35008){
var state_val_35009 = (state_35008[(1)]);
if((state_val_35009 === (1))){
var state_35008__$1 = state_35008;
var statearr_35010_35026 = state_35008__$1;
(statearr_35010_35026[(2)] = null);

(statearr_35010_35026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35009 === (2))){
var inst_34994 = (state_35008[(7)]);
var _ = (function (){var statearr_35011 = state_35008;
(statearr_35011[(4)] = cljs.core.cons.call(null,(5),(state_35008[(4)])));

return statearr_35011;
})();
var inst_34988 = db;
var inst_34989 = cljs.core.__destructure_map.call(null,inst_34988);
var inst_34990 = cljs.core.get.call(null,inst_34989,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_34991 = cljs.core.get.call(null,inst_34989,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_34992 = cljs.core.get.call(null,inst_34989,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_34993 = cljs.core.get.call(null,inst_34989,new cljs.core.Keyword(null,"block","block",664686210));
var inst_34994__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_34991,inst_34992,inst_34993);
var inst_34995 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_34996 = [inst_34992,inst_34993,garbage];
var inst_34997 = cljs.core.PersistentHashMap.fromArrays(inst_34995,inst_34996);
var inst_34998 = fluree.db.storage.core.serde.call(null,inst_34990);
var inst_34999 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_34998,inst_34997);
var inst_35000 = fluree.db.storage.core.storage_write.call(null,inst_34990,inst_34994__$1,inst_34999);
var state_35008__$1 = (function (){var statearr_35012 = state_35008;
(statearr_35012[(7)] = inst_34994__$1);

return statearr_35012;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35008__$1,(6),inst_35000);
} else {
if((state_val_35009 === (3))){
var inst_35006 = (state_35008[(2)]);
var state_35008__$1 = state_35008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35008__$1,inst_35006);
} else {
if((state_val_35009 === (4))){
var inst_34981 = (state_35008[(2)]);
var state_35008__$1 = state_35008;
var statearr_35014_35027 = state_35008__$1;
(statearr_35014_35027[(2)] = inst_34981);

(statearr_35014_35027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35009 === (5))){
var _ = (function (){var statearr_35015 = state_35008;
(statearr_35015[(4)] = cljs.core.rest.call(null,(state_35008[(4)])));

return statearr_35015;
})();
var state_35008__$1 = state_35008;
var ex35013 = (state_35008__$1[(2)]);
var statearr_35016_35028 = state_35008__$1;
(statearr_35016_35028[(5)] = ex35013);


if((ex35013 instanceof Error)){
var statearr_35017_35029 = state_35008__$1;
(statearr_35017_35029[(1)] = (4));

(statearr_35017_35029[(5)] = null);

} else {
throw ex35013;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35009 === (6))){
var inst_34994 = (state_35008[(7)]);
var inst_35002 = (state_35008[(2)]);
var inst_35003 = fluree.db.util.async.throw_err.call(null,inst_35002);
var _ = (function (){var statearr_35018 = state_35008;
(statearr_35018[(4)] = cljs.core.rest.call(null,(state_35008[(4)])));

return statearr_35018;
})();
var state_35008__$1 = (function (){var statearr_35019 = state_35008;
(statearr_35019[(8)] = inst_35003);

return statearr_35019;
})();
var statearr_35020_35030 = state_35008__$1;
(statearr_35020_35030[(2)] = inst_34994);

(statearr_35020_35030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____0 = (function (){
var statearr_35021 = [null,null,null,null,null,null,null,null,null];
(statearr_35021[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__);

(statearr_35021[(1)] = (1));

return statearr_35021;
});
var fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____1 = (function (state_35008){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35022){var ex__16224__auto__ = e35022;
var statearr_35023_35031 = state_35008;
(statearr_35023_35031[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35008[(4)]))){
var statearr_35024_35032 = state_35008;
(statearr_35024_35032[(1)] = cljs.core.first.call(null,(state_35008[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35033 = state_35008;
state_35008 = G__35033;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__ = function(state_35008){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____1.call(this,state_35008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__16221__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35025 = f__16346__auto__.call(null);
(statearr_35025[(6)] = c__16345__auto__);

return statearr_35025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__35035 = arguments.length;
switch (G__35035) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35091){
var state_val_35092 = (state_35091[(1)]);
if((state_val_35092 === (7))){
var state_35091__$1 = state_35091;
var statearr_35093_35119 = state_35091__$1;
(statearr_35093_35119[(2)] = (0));

(statearr_35093_35119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (1))){
var state_35091__$1 = state_35091;
var statearr_35094_35120 = state_35091__$1;
(statearr_35094_35120[(2)] = null);

(statearr_35094_35120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (4))){
var inst_35036 = (state_35091[(2)]);
var state_35091__$1 = state_35091;
var statearr_35095_35121 = state_35091__$1;
(statearr_35095_35121[(2)] = inst_35036);

(statearr_35095_35121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (6))){
var inst_35061 = (state_35091[(7)]);
var state_35091__$1 = state_35091;
var statearr_35096_35122 = state_35091__$1;
(statearr_35096_35122[(2)] = inst_35061);

(statearr_35096_35122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (3))){
var inst_35089 = (state_35091[(2)]);
var state_35091__$1 = state_35091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35091__$1,inst_35089);
} else {
if((state_val_35092 === (12))){
var inst_35058 = (state_35091[(8)]);
var inst_35085 = (state_35091[(2)]);
var inst_35086 = fluree.db.util.async.throw_err.call(null,inst_35085);
var _ = (function (){var statearr_35097 = state_35091;
(statearr_35097[(4)] = cljs.core.rest.call(null,(state_35091[(4)])));

return statearr_35097;
})();
var state_35091__$1 = (function (){var statearr_35098 = state_35091;
(statearr_35098[(9)] = inst_35086);

return statearr_35098;
})();
var statearr_35099_35123 = state_35091__$1;
(statearr_35099_35123[(2)] = inst_35058);

(statearr_35099_35123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (2))){
var inst_35061 = (state_35091[(7)]);
var inst_35051 = (state_35091[(10)]);
var inst_35053 = (state_35091[(11)]);
var inst_35049 = (state_35091[(12)]);
var _ = (function (){var statearr_35100 = state_35091;
(statearr_35100[(4)] = cljs.core.cons.call(null,(5),(state_35091[(4)])));

return statearr_35100;
})();
var inst_35043 = db;
var inst_35044 = cljs.core.__destructure_map.call(null,inst_35043);
var inst_35045 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_35046 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_35047 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_35048 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_35049__$1 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_35050 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_35051__$1 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"block","block",664686210));
var inst_35052 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_35053__$1 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_35054 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_35055 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_35056 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_35057 = cljs.core.get.call(null,inst_35044,new cljs.core.Keyword(null,"post","post",269697687));
var inst_35058 = fluree.db.storage.core.ledger_root_key.call(null,inst_35045,inst_35053__$1,inst_35051__$1);
var inst_35059 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_35060 = fluree.db.storage.core.child_data.call(null,inst_35052);
var inst_35061__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_35049__$1);
var state_35091__$1 = (function (){var statearr_35101 = state_35091;
(statearr_35101[(13)] = inst_35047);

(statearr_35101[(14)] = inst_35054);

(statearr_35101[(7)] = inst_35061__$1);

(statearr_35101[(15)] = inst_35057);

(statearr_35101[(16)] = inst_35060);

(statearr_35101[(8)] = inst_35058);

(statearr_35101[(17)] = inst_35055);

(statearr_35101[(10)] = inst_35051__$1);

(statearr_35101[(18)] = inst_35056);

(statearr_35101[(19)] = inst_35050);

(statearr_35101[(20)] = inst_35046);

(statearr_35101[(11)] = inst_35053__$1);

(statearr_35101[(21)] = inst_35059);

(statearr_35101[(22)] = inst_35048);

(statearr_35101[(12)] = inst_35049__$1);

return statearr_35101;
})();
if(cljs.core.truth_(inst_35061__$1)){
var statearr_35102_35124 = state_35091__$1;
(statearr_35102_35124[(1)] = (6));

} else {
var statearr_35103_35125 = state_35091__$1;
(statearr_35103_35125[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (11))){
var inst_35047 = (state_35091[(13)]);
var inst_35057 = (state_35091[(15)]);
var inst_35060 = (state_35091[(16)]);
var inst_35058 = (state_35091[(8)]);
var inst_35055 = (state_35091[(17)]);
var inst_35051 = (state_35091[(10)]);
var inst_35056 = (state_35091[(18)]);
var inst_35050 = (state_35091[(19)]);
var inst_35065 = (state_35091[(23)]);
var inst_35046 = (state_35091[(20)]);
var inst_35053 = (state_35091[(11)]);
var inst_35059 = (state_35091[(21)]);
var inst_35048 = (state_35091[(22)]);
var inst_35049 = (state_35091[(12)]);
var inst_35070 = (state_35091[(2)]);
var inst_35071 = fluree.db.storage.core.child_data.call(null,inst_35055);
var inst_35072 = fluree.db.storage.core.child_data.call(null,inst_35057);
var inst_35073 = fluree.db.util.core.current_time_millis.call(null);
var inst_35074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35075 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_35076 = (new cljs.core.PersistentVector(null,2,(5),inst_35074,inst_35075,null));
var inst_35077 = cljs.core.select_keys.call(null,inst_35049,inst_35076);
var inst_35078 = fluree.db.storage.core.child_data.call(null,inst_35048);
var inst_35079 = [inst_35051,inst_35060,inst_35053,inst_35065,inst_35070,inst_35071,inst_35072,inst_35046,inst_35073,inst_35047,inst_35056,inst_35077,inst_35078];
var inst_35080 = cljs.core.PersistentHashMap.fromArrays(inst_35059,inst_35079);
var inst_35081 = fluree.db.storage.core.serde.call(null,inst_35050);
var inst_35082 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_35081,inst_35080);
var inst_35083 = fluree.db.storage.core.storage_write.call(null,inst_35050,inst_35058,inst_35082);
var state_35091__$1 = state_35091;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35091__$1,(12),inst_35083);
} else {
if((state_val_35092 === (9))){
var inst_35066 = (state_35091[(24)]);
var state_35091__$1 = state_35091;
var statearr_35105_35126 = state_35091__$1;
(statearr_35105_35126[(2)] = inst_35066);

(statearr_35105_35126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (5))){
var _ = (function (){var statearr_35106 = state_35091;
(statearr_35106[(4)] = cljs.core.rest.call(null,(state_35091[(4)])));

return statearr_35106;
})();
var state_35091__$1 = state_35091;
var ex35104 = (state_35091__$1[(2)]);
var statearr_35107_35127 = state_35091__$1;
(statearr_35107_35127[(5)] = ex35104);


if((ex35104 instanceof Error)){
var statearr_35108_35128 = state_35091__$1;
(statearr_35108_35128[(1)] = (4));

(statearr_35108_35128[(5)] = null);

} else {
throw ex35104;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (10))){
var inst_35054 = (state_35091[(14)]);
var state_35091__$1 = state_35091;
var statearr_35109_35129 = state_35091__$1;
(statearr_35109_35129[(2)] = inst_35054);

(statearr_35109_35129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35092 === (8))){
var inst_35066 = (state_35091[(24)]);
var inst_35065 = (state_35091[(2)]);
var inst_35066__$1 = custom_ecount;
var state_35091__$1 = (function (){var statearr_35110 = state_35091;
(statearr_35110[(23)] = inst_35065);

(statearr_35110[(24)] = inst_35066__$1);

return statearr_35110;
})();
if(cljs.core.truth_(inst_35066__$1)){
var statearr_35111_35130 = state_35091__$1;
(statearr_35111_35130[(1)] = (9));

} else {
var statearr_35112_35131 = state_35091__$1;
(statearr_35112_35131[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16221__auto__ = null;
var fluree$db$storage$core$state_machine__16221__auto____0 = (function (){
var statearr_35113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35113[(0)] = fluree$db$storage$core$state_machine__16221__auto__);

(statearr_35113[(1)] = (1));

return statearr_35113;
});
var fluree$db$storage$core$state_machine__16221__auto____1 = (function (state_35091){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35114){var ex__16224__auto__ = e35114;
var statearr_35115_35132 = state_35091;
(statearr_35115_35132[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35091[(4)]))){
var statearr_35116_35133 = state_35091;
(statearr_35116_35133[(1)] = cljs.core.first.call(null,(state_35091[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35134 = state_35091;
state_35091 = G__35134;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16221__auto__ = function(state_35091){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16221__auto____1.call(this,state_35091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16221__auto____0;
fluree$db$storage$core$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16221__auto____1;
return fluree$db$storage$core$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35117 = f__16346__auto__.call(null);
(statearr_35117[(6)] = c__16345__auto__);

return statearr_35117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__16345__auto___35193 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35167){
var state_val_35168 = (state_35167[(1)]);
if((state_val_35168 === (7))){
var inst_35147 = (state_35167[(7)]);
var state_35167__$1 = state_35167;
var statearr_35169_35194 = state_35167__$1;
(statearr_35169_35194[(2)] = inst_35147);

(statearr_35169_35194[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (1))){
var state_35167__$1 = state_35167;
var statearr_35170_35195 = state_35167__$1;
(statearr_35170_35195[(2)] = null);

(statearr_35170_35195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (4))){
var inst_35135 = (state_35167[(2)]);
var inst_35136 = error_fn.call(null);
var inst_35137 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35135);
var inst_35138 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35167__$1 = (function (){var statearr_35171 = state_35167;
(statearr_35171[(8)] = inst_35137);

(statearr_35171[(9)] = inst_35136);

return statearr_35171;
})();
var statearr_35172_35196 = state_35167__$1;
(statearr_35172_35196[(2)] = inst_35138);

(statearr_35172_35196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (6))){
var inst_35146 = (state_35167[(10)]);
var inst_35147 = (state_35167[(7)]);
var inst_35146__$1 = (state_35167[(2)]);
var inst_35147__$1 = (inst_35146__$1 == null);
var state_35167__$1 = (function (){var statearr_35173 = state_35167;
(statearr_35173[(10)] = inst_35146__$1);

(statearr_35173[(7)] = inst_35147__$1);

return statearr_35173;
})();
if(cljs.core.truth_(inst_35147__$1)){
var statearr_35174_35197 = state_35167__$1;
(statearr_35174_35197[(1)] = (7));

} else {
var statearr_35175_35198 = state_35167__$1;
(statearr_35175_35198[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (3))){
var inst_35165 = (state_35167[(2)]);
var state_35167__$1 = state_35167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35167__$1,inst_35165);
} else {
if((state_val_35168 === (12))){
var inst_35162 = (state_35167[(2)]);
var _ = (function (){var statearr_35176 = state_35167;
(statearr_35176[(4)] = cljs.core.rest.call(null,(state_35167[(4)])));

return statearr_35176;
})();
var state_35167__$1 = state_35167;
var statearr_35177_35199 = state_35167__$1;
(statearr_35177_35199[(2)] = inst_35162);

(statearr_35177_35199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (2))){
var _ = (function (){var statearr_35178 = state_35167;
(statearr_35178[(4)] = cljs.core.cons.call(null,(5),(state_35167[(4)])));

return statearr_35178;
})();
var inst_35144 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35167__$1 = state_35167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35167__$1,(6),inst_35144);
} else {
if((state_val_35168 === (11))){
var inst_35146 = (state_35167[(10)]);
var inst_35156 = fluree.db.storage.core.serde.call(null,conn);
var inst_35157 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_35156,inst_35146);
var inst_35158 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_35157);
var inst_35159 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_35158);
var inst_35160 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35159);
var state_35167__$1 = state_35167;
var statearr_35180_35200 = state_35167__$1;
(statearr_35180_35200[(2)] = inst_35160);

(statearr_35180_35200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (9))){
var inst_35152 = (state_35167[(2)]);
var state_35167__$1 = state_35167;
if(cljs.core.truth_(inst_35152)){
var statearr_35181_35201 = state_35167__$1;
(statearr_35181_35201[(1)] = (10));

} else {
var statearr_35182_35202 = state_35167__$1;
(statearr_35182_35202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (5))){
var _ = (function (){var statearr_35183 = state_35167;
(statearr_35183[(4)] = cljs.core.rest.call(null,(state_35167[(4)])));

return statearr_35183;
})();
var state_35167__$1 = state_35167;
var ex35179 = (state_35167__$1[(2)]);
var statearr_35184_35203 = state_35167__$1;
(statearr_35184_35203[(5)] = ex35179);


var statearr_35185_35204 = state_35167__$1;
(statearr_35185_35204[(1)] = (4));

(statearr_35185_35204[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (10))){
var inst_35154 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35167__$1 = state_35167;
var statearr_35186_35205 = state_35167__$1;
(statearr_35186_35205[(2)] = inst_35154);

(statearr_35186_35205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35168 === (8))){
var inst_35146 = (state_35167[(10)]);
var inst_35150 = (inst_35146 instanceof Error);
var state_35167__$1 = state_35167;
var statearr_35187_35206 = state_35167__$1;
(statearr_35187_35206[(2)] = inst_35150);

(statearr_35187_35206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__16221__auto____0 = (function (){
var statearr_35188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35188[(0)] = fluree$db$storage$core$reify_history_$_state_machine__16221__auto__);

(statearr_35188[(1)] = (1));

return statearr_35188;
});
var fluree$db$storage$core$reify_history_$_state_machine__16221__auto____1 = (function (state_35167){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35189){var ex__16224__auto__ = e35189;
var statearr_35190_35207 = state_35167;
(statearr_35190_35207[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35167[(4)]))){
var statearr_35191_35208 = state_35167;
(statearr_35191_35208[(1)] = cljs.core.first.call(null,(state_35167[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35209 = state_35167;
state_35167 = G__35209;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__16221__auto__ = function(state_35167){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__16221__auto____1.call(this,state_35167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__16221__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__16221__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35192 = f__16346__auto__.call(null);
(statearr_35192[(6)] = c__16345__auto___35193);

return statearr_35192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__35211 = arguments.length;
switch (G__35211) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__16345__auto___35321 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35274){
var state_val_35275 = (state_35274[(1)]);
if((state_val_35275 === (7))){
var state_35274__$1 = state_35274;
var statearr_35276_35322 = state_35274__$1;
(statearr_35276_35322[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_35276_35322[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (20))){
var inst_35253 = cljs.core.PersistentVector.EMPTY;
var state_35274__$1 = state_35274;
var statearr_35277_35323 = state_35274__$1;
(statearr_35277_35323[(2)] = inst_35253);

(statearr_35277_35323[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (1))){
var state_35274__$1 = state_35274;
var statearr_35278_35324 = state_35274__$1;
(statearr_35278_35324[(2)] = null);

(statearr_35278_35324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (24))){
var state_35274__$1 = state_35274;
var statearr_35279_35325 = state_35274__$1;
(statearr_35279_35325[(2)] = null);

(statearr_35279_35325[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (4))){
var inst_35214 = (state_35274[(2)]);
var inst_35215 = error_fn.call(null);
var inst_35216 = cljs.core.async.put_BANG_.call(null,result_ch,inst_35214);
var inst_35217 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_35274__$1 = (function (){var statearr_35280 = state_35274;
(statearr_35280[(7)] = inst_35215);

(statearr_35280[(8)] = inst_35216);

return statearr_35280;
})();
var statearr_35281_35326 = state_35274__$1;
(statearr_35281_35326[(2)] = inst_35217);

(statearr_35281_35326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (15))){
var inst_35239 = (state_35274[(2)]);
var state_35274__$1 = state_35274;
var statearr_35282_35327 = state_35274__$1;
(statearr_35282_35327[(2)] = inst_35239);

(statearr_35282_35327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (21))){
var inst_35227 = (state_35274[(9)]);
var inst_35243 = (state_35274[(10)]);
var inst_35256 = (state_35274[(11)]);
var inst_35226 = (state_35274[(12)]);
var inst_35228 = (state_35274[(13)]);
var inst_35263 = (state_35274[(2)]);
var inst_35264 = (function (){var base_node = inst_35226;
var first_flake = inst_35227;
var node_t = inst_35228;
var source = inst_35243;
var coll = inst_35256;
var conj_QMARK_ = inst_35263;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_35265 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_35226);
var inst_35266 = cljs.core.reduce.call(null,inst_35264,inst_35265,inst_35256);
var inst_35267 = cljs.core.doall.call(null,inst_35266);
var inst_35268 = cljs.core.assoc.call(null,inst_35226,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_35267);
var inst_35269 = cljs.core.async.put_BANG_.call(null,result_ch,inst_35268);
var _ = (function (){var statearr_35283 = state_35274;
(statearr_35283[(4)] = cljs.core.rest.call(null,(state_35274[(4)])));

return statearr_35283;
})();
var state_35274__$1 = state_35274;
var statearr_35284_35328 = state_35274__$1;
(statearr_35284_35328[(2)] = inst_35269);

(statearr_35284_35328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (13))){
var state_35274__$1 = state_35274;
var statearr_35285_35329 = state_35274__$1;
(statearr_35285_35329[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_35285_35329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (22))){
var inst_35227 = (state_35274[(9)]);
var inst_35243 = (state_35274[(10)]);
var inst_35256 = (state_35274[(11)]);
var inst_35226 = (state_35274[(12)]);
var inst_35228 = (state_35274[(13)]);
var inst_35257 = (function (){var base_node = inst_35226;
var first_flake = inst_35227;
var node_t = inst_35228;
var source = inst_35243;
var coll = inst_35256;
return (function (f){
return f.op === true;
});
})();
var state_35274__$1 = state_35274;
var statearr_35286_35330 = state_35274__$1;
(statearr_35286_35330[(2)] = inst_35257);

(statearr_35286_35330[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (6))){
var inst_35226 = (state_35274[(12)]);
var inst_35228 = (state_35274[(13)]);
var inst_35225 = (state_35274[(2)]);
var inst_35226__$1 = fluree.db.util.async.throw_err.call(null,inst_35225);
var inst_35227 = fluree.db.dbproto._first_flake.call(null,inst_35226__$1);
var inst_35228__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_35226__$1);
var inst_35229 = (inst_35228__$1 > t);
var state_35274__$1 = (function (){var statearr_35287 = state_35274;
(statearr_35287[(9)] = inst_35227);

(statearr_35287[(12)] = inst_35226__$1);

(statearr_35287[(13)] = inst_35228__$1);

return statearr_35287;
})();
if(cljs.core.truth_(inst_35229)){
var statearr_35288_35331 = state_35274__$1;
(statearr_35288_35331[(1)] = (7));

} else {
var statearr_35289_35332 = state_35274__$1;
(statearr_35289_35332[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (17))){
var inst_35227 = (state_35274[(9)]);
var inst_35244 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_35227,rhs,leftmost_QMARK_,t);
var state_35274__$1 = state_35274;
var statearr_35290_35333 = state_35274__$1;
(statearr_35290_35333[(2)] = inst_35244);

(statearr_35290_35333[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (3))){
var inst_35272 = (state_35274[(2)]);
var state_35274__$1 = state_35274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35274__$1,inst_35272);
} else {
if((state_val_35275 === (12))){
var inst_35241 = (state_35274[(2)]);
var state_35274__$1 = state_35274;
var statearr_35291_35334 = state_35274__$1;
(statearr_35291_35334[(2)] = inst_35241);

(statearr_35291_35334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (2))){
var _ = (function (){var statearr_35292 = state_35274;
(statearr_35292[(4)] = cljs.core.cons.call(null,(5),(state_35274[(4)])));

return statearr_35292;
})();
var inst_35223 = fluree.db.dbproto._resolve.call(null,node);
var state_35274__$1 = state_35274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35274__$1,(6),inst_35223);
} else {
if((state_val_35275 === (23))){
var inst_35227 = (state_35274[(9)]);
var inst_35243 = (state_35274[(10)]);
var inst_35256 = (state_35274[(11)]);
var inst_35226 = (state_35274[(12)]);
var inst_35228 = (state_35274[(13)]);
var inst_35259 = (function (){var base_node = inst_35226;
var first_flake = inst_35227;
var node_t = inst_35228;
var source = inst_35243;
var coll = inst_35256;
return (function (f){
return f.op === false;
});
})();
var state_35274__$1 = state_35274;
var statearr_35293_35335 = state_35274__$1;
(statearr_35293_35335[(2)] = inst_35259);

(statearr_35293_35335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (19))){
var inst_35246 = (state_35274[(14)]);
var inst_35249 = (state_35274[(2)]);
var inst_35250 = fluree.db.util.async.throw_err.call(null,inst_35249);
var inst_35251 = cljs.core.take_while.call(null,inst_35246,inst_35250);
var state_35274__$1 = state_35274;
var statearr_35294_35336 = state_35274__$1;
(statearr_35294_35336[(2)] = inst_35251);

(statearr_35294_35336[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (11))){
var inst_35228 = (state_35274[(13)]);
var inst_35235 = cljs.core._EQ_.call(null,inst_35228,t);
var state_35274__$1 = state_35274;
if(inst_35235){
var statearr_35296_35337 = state_35274__$1;
(statearr_35296_35337[(1)] = (13));

} else {
var statearr_35297_35338 = state_35274__$1;
(statearr_35297_35338[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (9))){
var inst_35243 = (state_35274[(10)]);
var inst_35243__$1 = (state_35274[(2)]);
var state_35274__$1 = (function (){var statearr_35298 = state_35274;
(statearr_35298[(10)] = inst_35243__$1);

return statearr_35298;
})();
var G__35299_35339 = inst_35243__$1;
var G__35299_35340__$1 = (((G__35299_35339 instanceof cljs.core.Keyword))?G__35299_35339.fqn:null);
switch (G__35299_35340__$1) {
case "novelty":
var statearr_35300_35342 = state_35274__$1;
(statearr_35300_35342[(1)] = (17));


break;
case "history":
var statearr_35301_35343 = state_35274__$1;
(statearr_35301_35343[(1)] = (18));


break;
case "none":
var statearr_35302_35344 = state_35274__$1;
(statearr_35302_35344[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35299_35340__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (5))){
var _ = (function (){var statearr_35303 = state_35274;
(statearr_35303[(4)] = cljs.core.rest.call(null,(state_35274[(4)])));

return statearr_35303;
})();
var state_35274__$1 = state_35274;
var ex35295 = (state_35274__$1[(2)]);
var statearr_35304_35345 = state_35274__$1;
(statearr_35304_35345[(5)] = ex35295);


var statearr_35305_35346 = state_35274__$1;
(statearr_35305_35346[(1)] = (4));

(statearr_35305_35346[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (14))){
var state_35274__$1 = state_35274;
var statearr_35306_35347 = state_35274__$1;
(statearr_35306_35347[(2)] = null);

(statearr_35306_35347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (16))){
var inst_35243 = (state_35274[(10)]);
var inst_35256 = (state_35274[(2)]);
var state_35274__$1 = (function (){var statearr_35307 = state_35274;
(statearr_35307[(11)] = inst_35256);

return statearr_35307;
})();
var G__35308_35348 = inst_35243;
var G__35308_35349__$1 = (((G__35308_35348 instanceof cljs.core.Keyword))?G__35308_35348.fqn:null);
switch (G__35308_35349__$1) {
case "novelty":
var statearr_35309_35351 = state_35274__$1;
(statearr_35309_35351[(1)] = (22));


break;
case "history":
var statearr_35310_35352 = state_35274__$1;
(statearr_35310_35352[(1)] = (23));


break;
case "none":
var statearr_35311_35353 = state_35274__$1;
(statearr_35311_35353[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35308_35349__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (10))){
var state_35274__$1 = state_35274;
var statearr_35312_35354 = state_35274__$1;
(statearr_35312_35354[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_35312_35354[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35275 === (18))){
var inst_35227 = (state_35274[(9)]);
var inst_35243 = (state_35274[(10)]);
var inst_35226 = (state_35274[(12)]);
var inst_35228 = (state_35274[(13)]);
var inst_35246 = (function (){var base_node = inst_35226;
var first_flake = inst_35227;
var node_t = inst_35228;
var source = inst_35243;
return (function (p1__35213_SHARP_){
return (p1__35213_SHARP_.t <= t);
});
})();
var inst_35247 = fluree.db.dbproto._resolve_history.call(null,node);
var state_35274__$1 = (function (){var statearr_35313 = state_35274;
(statearr_35313[(14)] = inst_35246);

return statearr_35313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35274__$1,(19),inst_35247);
} else {
if((state_val_35275 === (8))){
var inst_35228 = (state_35274[(13)]);
var inst_35232 = (inst_35228 < t);
var state_35274__$1 = state_35274;
if(cljs.core.truth_(inst_35232)){
var statearr_35314_35355 = state_35274__$1;
(statearr_35314_35355[(1)] = (10));

} else {
var statearr_35315_35356 = state_35274__$1;
(statearr_35315_35356[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____0 = (function (){
var statearr_35316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35316[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__);

(statearr_35316[(1)] = (1));

return statearr_35316;
});
var fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____1 = (function (state_35274){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35317){var ex__16224__auto__ = e35317;
var statearr_35318_35357 = state_35274;
(statearr_35318_35357[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35274[(4)]))){
var statearr_35319_35358 = state_35274;
(statearr_35319_35358[(1)] = cljs.core.first.call(null,(state_35274[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35359 = state_35274;
state_35274 = G__35359;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__ = function(state_35274){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____1.call(this,state_35274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__16221__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35320 = f__16346__auto__.call(null);
(statearr_35320[(6)] = c__16345__auto___35321);

return statearr_35320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35419){
var state_val_35420 = (state_35419[(1)]);
if((state_val_35420 === (7))){
var inst_35370 = (state_35419[(7)]);
var inst_35374 = (inst_35370 <= from_t);
var state_35419__$1 = state_35419;
var statearr_35421_35461 = state_35419__$1;
(statearr_35421_35461[(2)] = inst_35374);

(statearr_35421_35461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (20))){
var inst_35404 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_35405 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35404)].join('');
var inst_35406 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35407 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_35408 = cljs.core.PersistentHashMap.fromArrays(inst_35406,inst_35407);
var inst_35409 = cljs.core.ex_info.call(null,inst_35405,inst_35408);
var inst_35410 = (function(){throw inst_35409})();
var state_35419__$1 = state_35419;
var statearr_35422_35462 = state_35419__$1;
(statearr_35422_35462[(2)] = inst_35410);

(statearr_35422_35462[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (1))){
var state_35419__$1 = state_35419;
var statearr_35423_35463 = state_35419__$1;
(statearr_35423_35463[(2)] = null);

(statearr_35423_35463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (4))){
var inst_35362 = (state_35419[(2)]);
var inst_35363 = fluree.db.util.log.error.call(null,inst_35362);
var inst_35364 = (function(){throw inst_35362})();
var state_35419__$1 = (function (){var statearr_35424 = state_35419;
(statearr_35424[(8)] = inst_35363);

return statearr_35424;
})();
var statearr_35425_35464 = state_35419__$1;
(statearr_35425_35464[(2)] = inst_35364);

(statearr_35425_35464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (15))){
var inst_35389 = (state_35419[(2)]);
var state_35419__$1 = (function (){var statearr_35426 = state_35419;
(statearr_35426[(9)] = inst_35389);

return statearr_35426;
})();
if(cljs.core.truth_(from_t)){
var statearr_35427_35465 = state_35419__$1;
(statearr_35427_35465[(1)] = (16));

} else {
var statearr_35428_35466 = state_35419__$1;
(statearr_35428_35466[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (21))){
var inst_35399 = (state_35419[(10)]);
var inst_35398 = (state_35419[(11)]);
var inst_35400 = (state_35419[(12)]);
var inst_35412 = (state_35419[(2)]);
var inst_35413 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_35399,inst_35400,leftmost_QMARK_,to_t);
var inst_35414 = cljs.core.into.call(null,inst_35413,inst_35398);
var _ = (function (){var statearr_35429 = state_35419;
(statearr_35429[(4)] = cljs.core.rest.call(null,(state_35419[(4)])));

return statearr_35429;
})();
var state_35419__$1 = (function (){var statearr_35430 = state_35419;
(statearr_35430[(13)] = inst_35412);

return statearr_35430;
})();
var statearr_35431_35467 = state_35419__$1;
(statearr_35431_35467[(2)] = inst_35414);

(statearr_35431_35467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (13))){
var inst_35370 = (state_35419[(7)]);
var inst_35382 = (state_35419[(14)]);
var inst_35385 = (function (){var node_t = inst_35370;
var G__35378 = inst_35382;
return (function (p1__35360_SHARP_){
return (p1__35360_SHARP_.t < to_t);
});
})();
var inst_35386 = cljs.core.drop_while.call(null,inst_35385,inst_35382);
var state_35419__$1 = state_35419;
var statearr_35432_35468 = state_35419__$1;
(statearr_35432_35468[(2)] = inst_35386);

(statearr_35432_35468[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (6))){
var inst_35371 = (state_35419[(15)]);
var state_35419__$1 = state_35419;
var statearr_35433_35469 = state_35419__$1;
(statearr_35433_35469[(2)] = inst_35371);

(statearr_35433_35469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (17))){
var inst_35389 = (state_35419[(9)]);
var state_35419__$1 = state_35419;
var statearr_35434_35470 = state_35419__$1;
(statearr_35434_35470[(2)] = inst_35389);

(statearr_35434_35470[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (3))){
var inst_35417 = (state_35419[(2)]);
var state_35419__$1 = state_35419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35419__$1,inst_35417);
} else {
if((state_val_35420 === (12))){
var inst_35370 = (state_35419[(7)]);
var inst_35381 = (state_35419[(2)]);
var inst_35382 = fluree.db.util.async.throw_err.call(null,inst_35381);
var inst_35383 = (to_t > inst_35370);
var state_35419__$1 = (function (){var statearr_35435 = state_35419;
(statearr_35435[(14)] = inst_35382);

return statearr_35435;
})();
if(cljs.core.truth_(inst_35383)){
var statearr_35436_35471 = state_35419__$1;
(statearr_35436_35471[(1)] = (13));

} else {
var statearr_35437_35472 = state_35419__$1;
(statearr_35437_35472[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (2))){
var inst_35371 = (state_35419[(15)]);
var _ = (function (){var statearr_35438 = state_35419;
(statearr_35438[(4)] = cljs.core.cons.call(null,(5),(state_35419[(4)])));

return statearr_35438;
})();
var inst_35370 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_35371__$1 = (from_t == null);
var state_35419__$1 = (function (){var statearr_35439 = state_35419;
(statearr_35439[(7)] = inst_35370);

(statearr_35439[(15)] = inst_35371__$1);

return statearr_35439;
})();
if(cljs.core.truth_(inst_35371__$1)){
var statearr_35440_35473 = state_35419__$1;
(statearr_35440_35473[(1)] = (6));

} else {
var statearr_35441_35474 = state_35419__$1;
(statearr_35441_35474[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (19))){
var state_35419__$1 = state_35419;
var statearr_35442_35475 = state_35419__$1;
(statearr_35442_35475[(2)] = null);

(statearr_35442_35475[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (11))){
var inst_35398 = (state_35419[(2)]);
var inst_35399 = fluree.db.dbproto._first_flake.call(null,node);
var inst_35400 = fluree.db.dbproto._rhs.call(null,node);
var inst_35401 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_35419__$1 = (function (){var statearr_35444 = state_35419;
(statearr_35444[(10)] = inst_35399);

(statearr_35444[(11)] = inst_35398);

(statearr_35444[(12)] = inst_35400);

return statearr_35444;
})();
if(cljs.core.truth_(inst_35401)){
var statearr_35445_35476 = state_35419__$1;
(statearr_35445_35476[(1)] = (19));

} else {
var statearr_35446_35477 = state_35419__$1;
(statearr_35446_35477[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (9))){
var inst_35379 = fluree.db.dbproto._resolve_history.call(null,node);
var state_35419__$1 = state_35419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35419__$1,(12),inst_35379);
} else {
if((state_val_35420 === (5))){
var _ = (function (){var statearr_35447 = state_35419;
(statearr_35447[(4)] = cljs.core.rest.call(null,(state_35419[(4)])));

return statearr_35447;
})();
var state_35419__$1 = state_35419;
var ex35443 = (state_35419__$1[(2)]);
var statearr_35448_35478 = state_35419__$1;
(statearr_35448_35478[(5)] = ex35443);


var statearr_35449_35479 = state_35419__$1;
(statearr_35449_35479[(1)] = (4));

(statearr_35449_35479[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (14))){
var inst_35382 = (state_35419[(14)]);
var state_35419__$1 = state_35419;
var statearr_35450_35480 = state_35419__$1;
(statearr_35450_35480[(2)] = inst_35382);

(statearr_35450_35480[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (16))){
var inst_35370 = (state_35419[(7)]);
var inst_35389 = (state_35419[(9)]);
var inst_35391 = (function (){var node_t = inst_35370;
var G__35378 = inst_35389;
return (function (p1__35361_SHARP_){
return (p1__35361_SHARP_.t <= from_t);
});
})();
var inst_35392 = cljs.core.take_while.call(null,inst_35391,inst_35389);
var state_35419__$1 = state_35419;
var statearr_35451_35481 = state_35419__$1;
(statearr_35451_35481[(2)] = inst_35392);

(statearr_35451_35481[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (10))){
var state_35419__$1 = state_35419;
var statearr_35452_35482 = state_35419__$1;
(statearr_35452_35482[(2)] = null);

(statearr_35452_35482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (18))){
var inst_35395 = (state_35419[(2)]);
var state_35419__$1 = state_35419;
var statearr_35453_35483 = state_35419__$1;
(statearr_35453_35483[(2)] = inst_35395);

(statearr_35453_35483[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35420 === (8))){
var inst_35376 = (state_35419[(2)]);
var state_35419__$1 = state_35419;
if(cljs.core.truth_(inst_35376)){
var statearr_35454_35484 = state_35419__$1;
(statearr_35454_35484[(1)] = (9));

} else {
var statearr_35455_35485 = state_35419__$1;
(statearr_35455_35485[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____0 = (function (){
var statearr_35456 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35456[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__);

(statearr_35456[(1)] = (1));

return statearr_35456;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____1 = (function (state_35419){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35457){var ex__16224__auto__ = e35457;
var statearr_35458_35486 = state_35419;
(statearr_35458_35486[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35419[(4)]))){
var statearr_35459_35487 = state_35419;
(statearr_35459_35487[(1)] = cljs.core.first.call(null,(state_35419[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35488 = state_35419;
state_35419 = G__35488;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__ = function(state_35419){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____1.call(this,state_35419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35460 = f__16346__auto__.call(null);
(statearr_35460[(6)] = c__16345__auto__);

return statearr_35460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35509){
var state_val_35510 = (state_35509[(1)]);
if((state_val_35510 === (7))){
var inst_35498 = (state_35509[(7)]);
var inst_35500 = fluree.db.storage.core.serde.call(null,conn);
var inst_35501 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_35500,inst_35498);
var state_35509__$1 = state_35509;
var statearr_35511_35530 = state_35509__$1;
(statearr_35511_35530[(2)] = inst_35501);

(statearr_35511_35530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (1))){
var state_35509__$1 = state_35509;
var statearr_35512_35531 = state_35509__$1;
(statearr_35512_35531[(2)] = null);

(statearr_35512_35531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (4))){
var inst_35489 = (state_35509[(2)]);
var state_35509__$1 = state_35509;
var statearr_35513_35532 = state_35509__$1;
(statearr_35513_35532[(2)] = inst_35489);

(statearr_35513_35532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (6))){
var inst_35498 = (state_35509[(7)]);
var inst_35497 = (state_35509[(2)]);
var inst_35498__$1 = fluree.db.util.async.throw_err.call(null,inst_35497);
var state_35509__$1 = (function (){var statearr_35514 = state_35509;
(statearr_35514[(7)] = inst_35498__$1);

return statearr_35514;
})();
if(cljs.core.truth_(inst_35498__$1)){
var statearr_35515_35533 = state_35509__$1;
(statearr_35515_35533[(1)] = (7));

} else {
var statearr_35516_35534 = state_35509__$1;
(statearr_35516_35534[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (3))){
var inst_35507 = (state_35509[(2)]);
var state_35509__$1 = state_35509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35509__$1,inst_35507);
} else {
if((state_val_35510 === (2))){
var _ = (function (){var statearr_35518 = state_35509;
(statearr_35518[(4)] = cljs.core.cons.call(null,(5),(state_35509[(4)])));

return statearr_35518;
})();
var inst_35495 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35509__$1 = state_35509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35509__$1,(6),inst_35495);
} else {
if((state_val_35510 === (9))){
var inst_35504 = (state_35509[(2)]);
var _ = (function (){var statearr_35519 = state_35509;
(statearr_35519[(4)] = cljs.core.rest.call(null,(state_35509[(4)])));

return statearr_35519;
})();
var state_35509__$1 = state_35509;
var statearr_35520_35535 = state_35509__$1;
(statearr_35520_35535[(2)] = inst_35504);

(statearr_35520_35535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (5))){
var _ = (function (){var statearr_35521 = state_35509;
(statearr_35521[(4)] = cljs.core.rest.call(null,(state_35509[(4)])));

return statearr_35521;
})();
var state_35509__$1 = state_35509;
var ex35517 = (state_35509__$1[(2)]);
var statearr_35522_35536 = state_35509__$1;
(statearr_35522_35536[(5)] = ex35517);


if((ex35517 instanceof Error)){
var statearr_35523_35537 = state_35509__$1;
(statearr_35523_35537[(1)] = (4));

(statearr_35523_35537[(5)] = null);

} else {
throw ex35517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35510 === (8))){
var state_35509__$1 = state_35509;
var statearr_35524_35538 = state_35509__$1;
(statearr_35524_35538[(2)] = null);

(statearr_35524_35538[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__16221__auto____0 = (function (){
var statearr_35525 = [null,null,null,null,null,null,null,null];
(statearr_35525[(0)] = fluree$db$storage$core$read_branch_$_state_machine__16221__auto__);

(statearr_35525[(1)] = (1));

return statearr_35525;
});
var fluree$db$storage$core$read_branch_$_state_machine__16221__auto____1 = (function (state_35509){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35526){var ex__16224__auto__ = e35526;
var statearr_35527_35539 = state_35509;
(statearr_35527_35539[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35509[(4)]))){
var statearr_35528_35540 = state_35509;
(statearr_35528_35540[(1)] = cljs.core.first.call(null,(state_35509[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35541 = state_35509;
state_35509 = G__35541;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__16221__auto__ = function(state_35509){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__16221__auto____1.call(this,state_35509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35529 = f__16346__auto__.call(null);
(statearr_35529[(6)] = c__16345__auto__);

return statearr_35529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__16345__auto___35620 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35592){
var state_val_35593 = (state_35592[(1)]);
if((state_val_35593 === (7))){
var inst_35559 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_35560 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35561 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_35562 = cljs.core.PersistentHashMap.fromArrays(inst_35560,inst_35561);
var inst_35563 = cljs.core.ex_info.call(null,inst_35559,inst_35562);
var inst_35564 = (function(){throw inst_35563})();
var state_35592__$1 = state_35592;
var statearr_35594_35621 = state_35592__$1;
(statearr_35594_35621[(2)] = inst_35564);

(statearr_35594_35621[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (1))){
var state_35592__$1 = state_35592;
var statearr_35595_35622 = state_35592__$1;
(statearr_35595_35622[(2)] = null);

(statearr_35595_35622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (4))){
var inst_35542 = (state_35592[(2)]);
var inst_35543 = error_fn.call(null);
var inst_35544 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35542);
var inst_35545 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35592__$1 = (function (){var statearr_35596 = state_35592;
(statearr_35596[(7)] = inst_35544);

(statearr_35596[(8)] = inst_35543);

return statearr_35596;
})();
var statearr_35597_35623 = state_35592__$1;
(statearr_35597_35623[(2)] = inst_35545);

(statearr_35597_35623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (6))){
var inst_35556 = (state_35592[(9)]);
var inst_35555 = (state_35592[(2)]);
var inst_35556__$1 = fluree.db.util.async.throw_err.call(null,inst_35555);
var inst_35557 = (inst_35556__$1 == null);
var state_35592__$1 = (function (){var statearr_35598 = state_35592;
(statearr_35598[(9)] = inst_35556__$1);

return statearr_35598;
})();
if(cljs.core.truth_(inst_35557)){
var statearr_35599_35624 = state_35592__$1;
(statearr_35599_35624[(1)] = (7));

} else {
var statearr_35600_35625 = state_35592__$1;
(statearr_35600_35625[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (3))){
var inst_35590 = (state_35592[(2)]);
var state_35592__$1 = state_35592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35592__$1,inst_35590);
} else {
if((state_val_35593 === (12))){
var inst_35556 = (state_35592[(9)]);
var inst_35573 = (state_35592[(2)]);
var inst_35574 = cljs.core.__destructure_map.call(null,inst_35556);
var inst_35575 = cljs.core.get.call(null,inst_35574,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_35576 = cljs.core.get.call(null,inst_35574,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_35577 = config;
var inst_35578 = cljs.core.__destructure_map.call(null,inst_35577);
var inst_35579 = cljs.core.get.call(null,inst_35578,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_35581 = (function (){var data = inst_35556;
var _ = inst_35573;
var map__35551 = inst_35574;
var children = inst_35575;
var rhs = inst_35576;
var map__35552 = inst_35578;
var comparator = inst_35579;
return (function (idx,p__35580){
var map__35601 = p__35580;
var map__35601__$1 = cljs.core.__destructure_map.call(null,map__35601);
var child = map__35601__$1;
var id = cljs.core.get.call(null,map__35601__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__35601__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__35601__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__35601__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__35601__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_35582 = cljs.core.map_indexed.call(null,inst_35581,inst_35575);
var inst_35583 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_35582);
var inst_35584 = cljs.core.interleave.call(null,inst_35583,inst_35582);
var inst_35585 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_35579,inst_35584);
var inst_35586 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_35576,inst_35585,config,leftmost_QMARK_);
var inst_35587 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35586);
var _ = (function (){var statearr_35602 = state_35592;
(statearr_35602[(4)] = cljs.core.rest.call(null,(state_35592[(4)])));

return statearr_35602;
})();
var state_35592__$1 = state_35592;
var statearr_35603_35626 = state_35592__$1;
(statearr_35603_35626[(2)] = inst_35587);

(statearr_35603_35626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (2))){
var _ = (function (){var statearr_35604 = state_35592;
(statearr_35604[(4)] = cljs.core.cons.call(null,(5),(state_35592[(4)])));

return statearr_35604;
})();
var inst_35553 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_35592__$1 = state_35592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35592__$1,(6),inst_35553);
} else {
if((state_val_35593 === (11))){
var state_35592__$1 = state_35592;
var statearr_35606_35627 = state_35592__$1;
(statearr_35606_35627[(2)] = null);

(statearr_35606_35627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (9))){
var inst_35556 = (state_35592[(9)]);
var inst_35567 = (state_35592[(2)]);
var inst_35568 = fluree.db.util.core.exception_QMARK_.call(null,inst_35556);
var state_35592__$1 = (function (){var statearr_35607 = state_35592;
(statearr_35607[(10)] = inst_35567);

return statearr_35607;
})();
if(inst_35568){
var statearr_35608_35628 = state_35592__$1;
(statearr_35608_35628[(1)] = (10));

} else {
var statearr_35609_35629 = state_35592__$1;
(statearr_35609_35629[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (5))){
var _ = (function (){var statearr_35610 = state_35592;
(statearr_35610[(4)] = cljs.core.rest.call(null,(state_35592[(4)])));

return statearr_35610;
})();
var state_35592__$1 = state_35592;
var ex35605 = (state_35592__$1[(2)]);
var statearr_35611_35630 = state_35592__$1;
(statearr_35611_35630[(5)] = ex35605);


var statearr_35612_35631 = state_35592__$1;
(statearr_35612_35631[(1)] = (4));

(statearr_35612_35631[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (10))){
var inst_35556 = (state_35592[(9)]);
var inst_35570 = (function(){throw inst_35556})();
var state_35592__$1 = state_35592;
var statearr_35613_35632 = state_35592__$1;
(statearr_35613_35632[(2)] = inst_35570);

(statearr_35613_35632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35593 === (8))){
var state_35592__$1 = state_35592;
var statearr_35614_35633 = state_35592__$1;
(statearr_35614_35633[(2)] = null);

(statearr_35614_35633[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____0 = (function (){
var statearr_35615 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35615[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__);

(statearr_35615[(1)] = (1));

return statearr_35615;
});
var fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____1 = (function (state_35592){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35616){var ex__16224__auto__ = e35616;
var statearr_35617_35634 = state_35592;
(statearr_35617_35634[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35592[(4)]))){
var statearr_35618_35635 = state_35592;
(statearr_35618_35635[(1)] = cljs.core.first.call(null,(state_35592[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35636 = state_35592;
state_35592 = G__35636;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__ = function(state_35592){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____1.call(this,state_35592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__16221__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35619 = f__16346__auto__.call(null);
(statearr_35619[(6)] = c__16345__auto___35620);

return statearr_35619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35657){
var state_val_35658 = (state_35657[(1)]);
if((state_val_35658 === (7))){
var state_35657__$1 = state_35657;
var statearr_35659_35679 = state_35657__$1;
(statearr_35659_35679[(2)] = null);

(statearr_35659_35679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (1))){
var state_35657__$1 = state_35657;
var statearr_35660_35680 = state_35657__$1;
(statearr_35660_35680[(2)] = null);

(statearr_35660_35680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (4))){
var inst_35637 = (state_35657[(2)]);
var state_35657__$1 = state_35657;
var statearr_35661_35681 = state_35657__$1;
(statearr_35661_35681[(2)] = inst_35637);

(statearr_35661_35681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (6))){
var inst_35643 = (state_35657[(7)]);
var inst_35645 = fluree.db.storage.core.serde.call(null,conn);
var state_35657__$1 = (function (){var statearr_35662 = state_35657;
(statearr_35662[(8)] = inst_35645);

return statearr_35662;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35657__$1,(9),inst_35643);
} else {
if((state_val_35658 === (3))){
var inst_35655 = (state_35657[(2)]);
var state_35657__$1 = state_35657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35657__$1,inst_35655);
} else {
if((state_val_35658 === (2))){
var inst_35643 = (state_35657[(7)]);
var _ = (function (){var statearr_35664 = state_35657;
(statearr_35664[(4)] = cljs.core.cons.call(null,(5),(state_35657[(4)])));

return statearr_35664;
})();
var inst_35643__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_35657__$1 = (function (){var statearr_35665 = state_35657;
(statearr_35665[(7)] = inst_35643__$1);

return statearr_35665;
})();
if(cljs.core.truth_(inst_35643__$1)){
var statearr_35666_35682 = state_35657__$1;
(statearr_35666_35682[(1)] = (6));

} else {
var statearr_35667_35683 = state_35657__$1;
(statearr_35667_35683[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (9))){
var inst_35645 = (state_35657[(8)]);
var inst_35647 = (state_35657[(2)]);
var inst_35648 = fluree.db.util.async.throw_err.call(null,inst_35647);
var inst_35649 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_35645,inst_35648);
var state_35657__$1 = state_35657;
var statearr_35668_35684 = state_35657__$1;
(statearr_35668_35684[(2)] = inst_35649);

(statearr_35668_35684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (5))){
var _ = (function (){var statearr_35669 = state_35657;
(statearr_35669[(4)] = cljs.core.rest.call(null,(state_35657[(4)])));

return statearr_35669;
})();
var state_35657__$1 = state_35657;
var ex35663 = (state_35657__$1[(2)]);
var statearr_35670_35685 = state_35657__$1;
(statearr_35670_35685[(5)] = ex35663);


if((ex35663 instanceof Error)){
var statearr_35671_35686 = state_35657__$1;
(statearr_35671_35686[(1)] = (4));

(statearr_35671_35686[(5)] = null);

} else {
throw ex35663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35658 === (8))){
var inst_35652 = (state_35657[(2)]);
var _ = (function (){var statearr_35672 = state_35657;
(statearr_35672[(4)] = cljs.core.rest.call(null,(state_35657[(4)])));

return statearr_35672;
})();
var state_35657__$1 = state_35657;
var statearr_35673_35687 = state_35657__$1;
(statearr_35673_35687[(2)] = inst_35652);

(statearr_35673_35687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____0 = (function (){
var statearr_35674 = [null,null,null,null,null,null,null,null,null];
(statearr_35674[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__);

(statearr_35674[(1)] = (1));

return statearr_35674;
});
var fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____1 = (function (state_35657){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35675){var ex__16224__auto__ = e35675;
var statearr_35676_35688 = state_35657;
(statearr_35676_35688[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35657[(4)]))){
var statearr_35677_35689 = state_35657;
(statearr_35677_35689[(1)] = cljs.core.first.call(null,(state_35657[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35690 = state_35657;
state_35657 = G__35690;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__ = function(state_35657){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____1.call(this,state_35657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35678 = f__16346__auto__.call(null);
(statearr_35678[(6)] = c__16345__auto__);

return statearr_35678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__16345__auto___35763 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35735){
var state_val_35736 = (state_35735[(1)]);
if((state_val_35736 === (7))){
var inst_35707 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_35708 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35709 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_35710 = cljs.core.PersistentHashMap.fromArrays(inst_35708,inst_35709);
var inst_35711 = cljs.core.ex_info.call(null,inst_35707,inst_35710);
var inst_35712 = (function(){throw inst_35711})();
var state_35735__$1 = state_35735;
var statearr_35737_35764 = state_35735__$1;
(statearr_35737_35764[(2)] = inst_35712);

(statearr_35737_35764[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (1))){
var state_35735__$1 = state_35735;
var statearr_35738_35765 = state_35735__$1;
(statearr_35738_35765[(2)] = null);

(statearr_35738_35765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (4))){
var inst_35691 = (state_35735[(2)]);
var inst_35692 = error_fn.call(null);
var inst_35693 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35691);
var inst_35694 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_35735__$1 = (function (){var statearr_35739 = state_35735;
(statearr_35739[(7)] = inst_35692);

(statearr_35739[(8)] = inst_35693);

return statearr_35739;
})();
var statearr_35740_35766 = state_35735__$1;
(statearr_35740_35766[(2)] = inst_35694);

(statearr_35740_35766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (6))){
var inst_35704 = (state_35735[(9)]);
var inst_35704__$1 = (state_35735[(2)]);
var inst_35705 = (inst_35704__$1 == null);
var state_35735__$1 = (function (){var statearr_35741 = state_35735;
(statearr_35741[(9)] = inst_35704__$1);

return statearr_35741;
})();
if(cljs.core.truth_(inst_35705)){
var statearr_35742_35767 = state_35735__$1;
(statearr_35742_35767[(1)] = (7));

} else {
var statearr_35743_35768 = state_35735__$1;
(statearr_35743_35768[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (3))){
var inst_35733 = (state_35735[(2)]);
var state_35735__$1 = state_35735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35735__$1,inst_35733);
} else {
if((state_val_35736 === (12))){
var inst_35704 = (state_35735[(9)]);
var inst_35721 = (state_35735[(2)]);
var inst_35722 = cljs.core.__destructure_map.call(null,inst_35704);
var inst_35723 = cljs.core.get.call(null,inst_35722,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_35724 = cljs.core.get.call(null,inst_35722,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_35725 = config;
var inst_35726 = cljs.core.__destructure_map.call(null,inst_35725);
var inst_35727 = cljs.core.get.call(null,inst_35726,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_35728 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_35727,inst_35723);
var inst_35729 = fluree.db.index.data_node.call(null,block,t,inst_35728,rhs,config);
var inst_35730 = cljs.core.async.put_BANG_.call(null,return_ch,inst_35729);
var _ = (function (){var statearr_35744 = state_35735;
(statearr_35744[(4)] = cljs.core.rest.call(null,(state_35735[(4)])));

return statearr_35744;
})();
var state_35735__$1 = (function (){var statearr_35745 = state_35735;
(statearr_35745[(10)] = inst_35724);

(statearr_35745[(11)] = inst_35721);

return statearr_35745;
})();
var statearr_35746_35769 = state_35735__$1;
(statearr_35746_35769[(2)] = inst_35730);

(statearr_35746_35769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (2))){
var _ = (function (){var statearr_35747 = state_35735;
(statearr_35747[(4)] = cljs.core.cons.call(null,(5),(state_35735[(4)])));

return statearr_35747;
})();
var inst_35702 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_35735__$1 = state_35735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35735__$1,(6),inst_35702);
} else {
if((state_val_35736 === (11))){
var state_35735__$1 = state_35735;
var statearr_35749_35770 = state_35735__$1;
(statearr_35749_35770[(2)] = null);

(statearr_35749_35770[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (9))){
var inst_35704 = (state_35735[(9)]);
var inst_35715 = (state_35735[(2)]);
var inst_35716 = fluree.db.util.core.exception_QMARK_.call(null,inst_35704);
var state_35735__$1 = (function (){var statearr_35750 = state_35735;
(statearr_35750[(12)] = inst_35715);

return statearr_35750;
})();
if(inst_35716){
var statearr_35751_35771 = state_35735__$1;
(statearr_35751_35771[(1)] = (10));

} else {
var statearr_35752_35772 = state_35735__$1;
(statearr_35752_35772[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (5))){
var _ = (function (){var statearr_35753 = state_35735;
(statearr_35753[(4)] = cljs.core.rest.call(null,(state_35735[(4)])));

return statearr_35753;
})();
var state_35735__$1 = state_35735;
var ex35748 = (state_35735__$1[(2)]);
var statearr_35754_35773 = state_35735__$1;
(statearr_35754_35773[(5)] = ex35748);


var statearr_35755_35774 = state_35735__$1;
(statearr_35755_35774[(1)] = (4));

(statearr_35755_35774[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (10))){
var inst_35704 = (state_35735[(9)]);
var inst_35718 = (function(){throw inst_35704})();
var state_35735__$1 = state_35735;
var statearr_35756_35775 = state_35735__$1;
(statearr_35756_35775[(2)] = inst_35718);

(statearr_35756_35775[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35736 === (8))){
var state_35735__$1 = state_35735;
var statearr_35757_35776 = state_35735__$1;
(statearr_35757_35776[(2)] = null);

(statearr_35757_35776[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____0 = (function (){
var statearr_35758 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35758[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__);

(statearr_35758[(1)] = (1));

return statearr_35758;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____1 = (function (state_35735){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35759){var ex__16224__auto__ = e35759;
var statearr_35760_35777 = state_35735;
(statearr_35760_35777[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35735[(4)]))){
var statearr_35761_35778 = state_35735;
(statearr_35761_35778[(1)] = cljs.core.first.call(null,(state_35735[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35779 = state_35735;
state_35735 = G__35779;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__ = function(state_35735){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____1.call(this,state_35735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35762 = f__16346__auto__.call(null);
(statearr_35762[(6)] = c__16345__auto___35763);

return statearr_35762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k35781,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__35785 = k35781;
var G__35785__$1 = (((G__35785 instanceof cljs.core.Keyword))?G__35785.fqn:null);
switch (G__35785__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k35781,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4484__auto__,p__35786){
var vec__35787 = p__35786;
var k__4485__auto__ = cljs.core.nth.call(null,vec__35787,(0),null);
var v__4486__auto__ = cljs.core.nth.call(null,vec__35787,(1),null);
return f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__);
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35780){
var self__ = this;
var G__35780__$1 = this;
return (new cljs.core.RecordIter((0),G__35780__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4458__auto__));
}).call(null,this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35782,other35783){
var self__ = this;
var this35782__$1 = this;
return (((!((other35783 == null)))) && ((((this35782__$1.constructor === other35783.constructor)) && (((cljs.core._EQ_.call(null,this35782__$1.conn,other35783.conn)) && (((cljs.core._EQ_.call(null,this35782__$1.config,other35783.config)) && (((cljs.core._EQ_.call(null,this35782__$1.network,other35783.network)) && (((cljs.core._EQ_.call(null,this35782__$1.dbid,other35783.dbid)) && (((cljs.core._EQ_.call(null,this35782__$1.id,other35783.id)) && (((cljs.core._EQ_.call(null,this35782__$1.leaf,other35783.leaf)) && (((cljs.core._EQ_.call(null,this35782__$1.first,other35783.first)) && (((cljs.core._EQ_.call(null,this35782__$1.rhs,other35783.rhs)) && (((cljs.core._EQ_.call(null,this35782__$1.size,other35783.size)) && (((cljs.core._EQ_.call(null,this35782__$1.block,other35783.block)) && (((cljs.core._EQ_.call(null,this35782__$1.t,other35783.t)) && (((cljs.core._EQ_.call(null,this35782__$1.tt_id,other35783.tt_id)) && (((cljs.core._EQ_.call(null,this35782__$1.leftmost_QMARK_,other35783.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this35782__$1.tempid,other35783.tempid)) && (cljs.core._EQ_.call(null,this35782__$1.__extmap,other35783.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k35781){
var self__ = this;
var this__4468__auto____$1 = this;
var G__35790 = k35781;
var G__35790__$1 = (((G__35790 instanceof cljs.core.Keyword))?G__35790.fqn:null);
switch (G__35790__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k35781);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__35780){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__35791 = cljs.core.keyword_identical_QMARK_;
var expr__35792 = k__4470__auto__;
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(G__35780,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__35780,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__35780,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__35780,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__35780,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__35780,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__35780,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__35780,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__35780,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__35780,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__35780,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__35780,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__35780,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35791.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__35792))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__35780,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4470__auto__,G__35780),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__35780){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__35780,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4467__auto__,(0)),cljs.core._nth.call(null,entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write.call(null,writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__35784){
var extmap__4501__auto__ = (function (){var G__35794 = cljs.core.dissoc.call(null,G__35784,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__35784)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__35794);
} else {
return G__35794;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__35784),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__35784),null,cljs.core.not_empty.call(null,extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__35797 = blank_db;
var map__35797__$1 = cljs.core.__destructure_map.call(null,map__35797);
var network = cljs.core.get.call(null,map__35797__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__35797__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__35797__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__35798 = root_data;
var map__35798__$1 = cljs.core.__destructure_map.call(null,map__35798);
var block = cljs.core.get.call(null,map__35798__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__35798__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__35798__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__35798__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35820){
var state_val_35821 = (state_35820[(1)]);
if((state_val_35821 === (7))){
var state_35820__$1 = state_35820;
var statearr_35822_35842 = state_35820__$1;
(statearr_35822_35842[(2)] = null);

(statearr_35822_35842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (1))){
var state_35820__$1 = state_35820;
var statearr_35823_35843 = state_35820__$1;
(statearr_35823_35843[(2)] = null);

(statearr_35823_35843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (4))){
var inst_35799 = (state_35820[(2)]);
var state_35820__$1 = state_35820;
var statearr_35824_35844 = state_35820__$1;
(statearr_35824_35844[(2)] = inst_35799);

(statearr_35824_35844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (6))){
var inst_35806 = (state_35820[(7)]);
var inst_35808 = fluree.db.storage.core.serde.call(null,conn);
var state_35820__$1 = (function (){var statearr_35825 = state_35820;
(statearr_35825[(8)] = inst_35808);

return statearr_35825;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35820__$1,(9),inst_35806);
} else {
if((state_val_35821 === (3))){
var inst_35818 = (state_35820[(2)]);
var state_35820__$1 = state_35820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35820__$1,inst_35818);
} else {
if((state_val_35821 === (2))){
var inst_35806 = (state_35820[(7)]);
var _ = (function (){var statearr_35827 = state_35820;
(statearr_35827[(4)] = cljs.core.cons.call(null,(5),(state_35820[(4)])));

return statearr_35827;
})();
var inst_35805 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_35806__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_35805);
var state_35820__$1 = (function (){var statearr_35828 = state_35820;
(statearr_35828[(7)] = inst_35806__$1);

return statearr_35828;
})();
if(cljs.core.truth_(inst_35806__$1)){
var statearr_35829_35845 = state_35820__$1;
(statearr_35829_35845[(1)] = (6));

} else {
var statearr_35830_35846 = state_35820__$1;
(statearr_35830_35846[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (9))){
var inst_35808 = (state_35820[(8)]);
var inst_35810 = (state_35820[(2)]);
var inst_35811 = fluree.db.util.async.throw_err.call(null,inst_35810);
var inst_35812 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_35808,inst_35811);
var state_35820__$1 = state_35820;
var statearr_35831_35847 = state_35820__$1;
(statearr_35831_35847[(2)] = inst_35812);

(statearr_35831_35847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (5))){
var _ = (function (){var statearr_35832 = state_35820;
(statearr_35832[(4)] = cljs.core.rest.call(null,(state_35820[(4)])));

return statearr_35832;
})();
var state_35820__$1 = state_35820;
var ex35826 = (state_35820__$1[(2)]);
var statearr_35833_35848 = state_35820__$1;
(statearr_35833_35848[(5)] = ex35826);


if((ex35826 instanceof Error)){
var statearr_35834_35849 = state_35820__$1;
(statearr_35834_35849[(1)] = (4));

(statearr_35834_35849[(5)] = null);

} else {
throw ex35826;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35821 === (8))){
var inst_35815 = (state_35820[(2)]);
var _ = (function (){var statearr_35835 = state_35820;
(statearr_35835[(4)] = cljs.core.rest.call(null,(state_35820[(4)])));

return statearr_35835;
})();
var state_35820__$1 = state_35820;
var statearr_35836_35850 = state_35820__$1;
(statearr_35836_35850[(2)] = inst_35815);

(statearr_35836_35850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____0 = (function (){
var statearr_35837 = [null,null,null,null,null,null,null,null,null];
(statearr_35837[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__);

(statearr_35837[(1)] = (1));

return statearr_35837;
});
var fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____1 = (function (state_35820){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35838){var ex__16224__auto__ = e35838;
var statearr_35839_35851 = state_35820;
(statearr_35839_35851[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35820[(4)]))){
var statearr_35840_35852 = state_35820;
(statearr_35840_35852[(1)] = cljs.core.first.call(null,(state_35820[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35853 = state_35820;
state_35820 = G__35853;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__ = function(state_35820){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____1.call(this,state_35820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35841 = f__16346__auto__.call(null);
(statearr_35841[(6)] = c__16345__auto__);

return statearr_35841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35875){
var state_val_35876 = (state_35875[(1)]);
if((state_val_35876 === (7))){
var inst_35864 = (state_35875[(7)]);
var inst_35866 = fluree.db.storage.core.serde.call(null,conn);
var inst_35867 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_35866,inst_35864);
var state_35875__$1 = state_35875;
var statearr_35877_35896 = state_35875__$1;
(statearr_35877_35896[(2)] = inst_35867);

(statearr_35877_35896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (1))){
var state_35875__$1 = state_35875;
var statearr_35878_35897 = state_35875__$1;
(statearr_35878_35897[(2)] = null);

(statearr_35878_35897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (4))){
var inst_35854 = (state_35875[(2)]);
var state_35875__$1 = state_35875;
var statearr_35879_35898 = state_35875__$1;
(statearr_35879_35898[(2)] = inst_35854);

(statearr_35879_35898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (6))){
var inst_35864 = (state_35875[(7)]);
var inst_35863 = (state_35875[(2)]);
var inst_35864__$1 = fluree.db.util.async.throw_err.call(null,inst_35863);
var state_35875__$1 = (function (){var statearr_35880 = state_35875;
(statearr_35880[(7)] = inst_35864__$1);

return statearr_35880;
})();
if(cljs.core.truth_(inst_35864__$1)){
var statearr_35881_35899 = state_35875__$1;
(statearr_35881_35899[(1)] = (7));

} else {
var statearr_35882_35900 = state_35875__$1;
(statearr_35882_35900[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (3))){
var inst_35873 = (state_35875[(2)]);
var state_35875__$1 = state_35875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35875__$1,inst_35873);
} else {
if((state_val_35876 === (2))){
var _ = (function (){var statearr_35884 = state_35875;
(statearr_35884[(4)] = cljs.core.cons.call(null,(5),(state_35875[(4)])));

return statearr_35884;
})();
var inst_35860 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_35861 = fluree.db.storage.core.storage_read.call(null,conn,inst_35860);
var state_35875__$1 = state_35875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35875__$1,(6),inst_35861);
} else {
if((state_val_35876 === (9))){
var inst_35870 = (state_35875[(2)]);
var _ = (function (){var statearr_35885 = state_35875;
(statearr_35885[(4)] = cljs.core.rest.call(null,(state_35875[(4)])));

return statearr_35885;
})();
var state_35875__$1 = state_35875;
var statearr_35886_35901 = state_35875__$1;
(statearr_35886_35901[(2)] = inst_35870);

(statearr_35886_35901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (5))){
var _ = (function (){var statearr_35887 = state_35875;
(statearr_35887[(4)] = cljs.core.rest.call(null,(state_35875[(4)])));

return statearr_35887;
})();
var state_35875__$1 = state_35875;
var ex35883 = (state_35875__$1[(2)]);
var statearr_35888_35902 = state_35875__$1;
(statearr_35888_35902[(5)] = ex35883);


if((ex35883 instanceof Error)){
var statearr_35889_35903 = state_35875__$1;
(statearr_35889_35903[(1)] = (4));

(statearr_35889_35903[(5)] = null);

} else {
throw ex35883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35876 === (8))){
var state_35875__$1 = state_35875;
var statearr_35890_35904 = state_35875__$1;
(statearr_35890_35904[(2)] = null);

(statearr_35890_35904[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____0 = (function (){
var statearr_35891 = [null,null,null,null,null,null,null,null];
(statearr_35891[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__);

(statearr_35891[(1)] = (1));

return statearr_35891;
});
var fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____1 = (function (state_35875){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35892){var ex__16224__auto__ = e35892;
var statearr_35893_35905 = state_35875;
(statearr_35893_35905[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35875[(4)]))){
var statearr_35894_35906 = state_35875;
(statearr_35894_35906[(1)] = cljs.core.first.call(null,(state_35875[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35907 = state_35875;
state_35875 = G__35907;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__ = function(state_35875){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____1.call(this,state_35875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__16221__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35895 = f__16346__auto__.call(null);
(statearr_35895[(6)] = c__16345__auto__);

return statearr_35895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_35943){
var state_val_35944 = (state_35943[(1)]);
if((state_val_35944 === (7))){
var inst_35917 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_35918 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35919 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_35920 = cljs.core.PersistentHashMap.fromArrays(inst_35918,inst_35919);
var inst_35921 = cljs.core.ex_info.call(null,inst_35917,inst_35920);
var inst_35922 = (function(){throw inst_35921})();
var state_35943__$1 = state_35943;
var statearr_35945_35967 = state_35943__$1;
(statearr_35945_35967[(2)] = inst_35922);

(statearr_35945_35967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (1))){
var state_35943__$1 = state_35943;
var statearr_35946_35968 = state_35943__$1;
(statearr_35946_35968[(2)] = null);

(statearr_35946_35968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (4))){
var inst_35908 = (state_35943[(2)]);
var state_35943__$1 = state_35943;
var statearr_35947_35969 = state_35943__$1;
(statearr_35947_35969[(2)] = inst_35908);

(statearr_35947_35969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (6))){
var state_35943__$1 = state_35943;
var statearr_35948_35970 = state_35943__$1;
(statearr_35948_35970[(2)] = null);

(statearr_35948_35970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (3))){
var inst_35941 = (state_35943[(2)]);
var state_35943__$1 = state_35943;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35943__$1,inst_35941);
} else {
if((state_val_35944 === (2))){
var inst_35914 = (state_35943[(7)]);
var _ = (function (){var statearr_35949 = state_35943;
(statearr_35949[(4)] = cljs.core.cons.call(null,(5),(state_35943[(4)])));

return statearr_35949;
})();
var inst_35914__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_35943__$1 = (function (){var statearr_35950 = state_35943;
(statearr_35950[(7)] = inst_35914__$1);

return statearr_35950;
})();
if(cljs.core.truth_(inst_35914__$1)){
var statearr_35951_35971 = state_35943__$1;
(statearr_35951_35971[(1)] = (6));

} else {
var statearr_35952_35972 = state_35943__$1;
(statearr_35952_35972[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (11))){
var inst_35933 = (state_35943[(8)]);
var inst_35936 = (state_35943[(2)]);
var inst_35937 = fluree.db.util.async.throw_err.call(null,inst_35936);
var inst_35938 = cljs.core.assoc.call(null,inst_35933,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_35937);
var _ = (function (){var statearr_35954 = state_35943;
(statearr_35954[(4)] = cljs.core.rest.call(null,(state_35943[(4)])));

return statearr_35954;
})();
var state_35943__$1 = state_35943;
var statearr_35955_35973 = state_35943__$1;
(statearr_35955_35973[(2)] = inst_35938);

(statearr_35955_35973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (9))){
var inst_35928 = (state_35943[(9)]);
var inst_35926 = (state_35943[(2)]);
var inst_35927 = fluree.db.util.async.throw_err.call(null,inst_35926);
var inst_35928__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_35927);
var inst_35929 = fluree.db.query.schema.schema_map.call(null,inst_35928__$1);
var state_35943__$1 = (function (){var statearr_35956 = state_35943;
(statearr_35956[(9)] = inst_35928__$1);

return statearr_35956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35943__$1,(10),inst_35929);
} else {
if((state_val_35944 === (5))){
var _ = (function (){var statearr_35957 = state_35943;
(statearr_35957[(4)] = cljs.core.rest.call(null,(state_35943[(4)])));

return statearr_35957;
})();
var state_35943__$1 = state_35943;
var ex35953 = (state_35943__$1[(2)]);
var statearr_35958_35974 = state_35943__$1;
(statearr_35958_35974[(5)] = ex35953);


if((ex35953 instanceof Error)){
var statearr_35959_35975 = state_35943__$1;
(statearr_35959_35975[(1)] = (4));

(statearr_35959_35975[(5)] = null);

} else {
throw ex35953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35944 === (10))){
var inst_35933 = (state_35943[(8)]);
var inst_35928 = (state_35943[(9)]);
var inst_35931 = (state_35943[(2)]);
var inst_35932 = fluree.db.util.async.throw_err.call(null,inst_35931);
var inst_35933__$1 = cljs.core.assoc.call(null,inst_35928,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_35932);
var inst_35934 = fluree.db.query.schema.setting_map.call(null,inst_35933__$1);
var state_35943__$1 = (function (){var statearr_35960 = state_35943;
(statearr_35960[(8)] = inst_35933__$1);

return statearr_35960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35943__$1,(11),inst_35934);
} else {
if((state_val_35944 === (8))){
var inst_35914 = (state_35943[(7)]);
var inst_35924 = (state_35943[(2)]);
var state_35943__$1 = (function (){var statearr_35961 = state_35943;
(statearr_35961[(10)] = inst_35924);

return statearr_35961;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35943__$1,(9),inst_35914);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__16221__auto____0 = (function (){
var statearr_35962 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35962[(0)] = fluree$db$storage$core$reify_db_$_state_machine__16221__auto__);

(statearr_35962[(1)] = (1));

return statearr_35962;
});
var fluree$db$storage$core$reify_db_$_state_machine__16221__auto____1 = (function (state_35943){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_35943);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e35963){var ex__16224__auto__ = e35963;
var statearr_35964_35976 = state_35943;
(statearr_35964_35976[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_35943[(4)]))){
var statearr_35965_35977 = state_35943;
(statearr_35965_35977[(1)] = cljs.core.first.call(null,(state_35943[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35978 = state_35943;
state_35943 = G__35978;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__16221__auto__ = function(state_35943){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__16221__auto____1.call(this,state_35943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__16221__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__16221__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_35966 = f__16346__auto__.call(null);
(statearr_35966[(6)] = c__16345__auto__);

return statearr_35966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__35980 = arguments.length;
switch (G__35980) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_36033){
var state_val_36034 = (state_36033[(1)]);
if((state_val_36034 === (7))){
var inst_35990 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_35991 = (new Error(inst_35990));
var inst_35992 = (function(){throw inst_35991})();
var state_36033__$1 = state_36033;
var statearr_36035_36075 = state_36033__$1;
(statearr_36035_36075[(2)] = inst_35992);

(statearr_36035_36075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (20))){
var inst_36024 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
var statearr_36036_36076 = state_36033__$1;
(statearr_36036_36076[(2)] = inst_36024);

(statearr_36036_36076[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (1))){
var state_36033__$1 = state_36033;
var statearr_36037_36077 = state_36033__$1;
(statearr_36037_36077[(2)] = null);

(statearr_36037_36077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (4))){
var inst_35981 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
var statearr_36038_36078 = state_36033__$1;
(statearr_36038_36078[(2)] = inst_35981);

(statearr_36038_36078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (15))){
var inst_35999 = (state_36033[(7)]);
var state_36033__$1 = state_36033;
var statearr_36039_36079 = state_36033__$1;
(statearr_36039_36079[(2)] = inst_35999);

(statearr_36039_36079[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (21))){
var inst_35998 = (state_36033[(8)]);
var inst_36003 = (state_36033[(9)]);
var inst_35999 = (state_36033[(7)]);
var inst_36017 = (inst_35998 + (1));
var inst_36018 = cljs.core.conj.call(null,inst_35999,inst_36003);
var inst_35998__$1 = inst_36017;
var inst_35999__$1 = inst_36018;
var state_36033__$1 = (function (){var statearr_36040 = state_36033;
(statearr_36040[(8)] = inst_35998__$1);

(statearr_36040[(7)] = inst_35999__$1);

return statearr_36040;
})();
var statearr_36041_36080 = state_36033__$1;
(statearr_36041_36080[(2)] = null);

(statearr_36041_36080[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (13))){
var inst_36003 = (state_36033[(9)]);
var inst_36007 = (inst_36003 instanceof Error);
var state_36033__$1 = state_36033;
var statearr_36042_36081 = state_36033__$1;
(statearr_36042_36081[(2)] = inst_36007);

(statearr_36042_36081[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (22))){
var state_36033__$1 = state_36033;
var statearr_36043_36082 = state_36033__$1;
(statearr_36043_36082[(2)] = null);

(statearr_36043_36082[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (6))){
var state_36033__$1 = state_36033;
var statearr_36044_36083 = state_36033__$1;
(statearr_36044_36083[(2)] = null);

(statearr_36044_36083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (17))){
var inst_36026 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
var statearr_36045_36084 = state_36033__$1;
(statearr_36045_36084[(2)] = inst_36026);

(statearr_36045_36084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (3))){
var inst_36031 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36033__$1,inst_36031);
} else {
if((state_val_36034 === (12))){
var inst_36004 = (state_36033[(10)]);
var state_36033__$1 = state_36033;
var statearr_36046_36085 = state_36033__$1;
(statearr_36046_36085[(2)] = inst_36004);

(statearr_36046_36085[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (2))){
var _ = (function (){var statearr_36047 = state_36033;
(statearr_36047[(4)] = cljs.core.cons.call(null,(5),(state_36033[(4)])));

return statearr_36047;
})();
var inst_35987 = (end >= start);
var state_36033__$1 = state_36033;
if(cljs.core.truth_(inst_35987)){
var statearr_36048_36086 = state_36033__$1;
(statearr_36048_36086[(1)] = (6));

} else {
var statearr_36049_36087 = state_36033__$1;
(statearr_36049_36087[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (23))){
var inst_36022 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
var statearr_36050_36088 = state_36033__$1;
(statearr_36050_36088[(2)] = inst_36022);

(statearr_36050_36088[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (19))){
var state_36033__$1 = state_36033;
var statearr_36051_36089 = state_36033__$1;
(statearr_36051_36089[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (11))){
var inst_36004 = (state_36033[(10)]);
var inst_36003 = (state_36033[(9)]);
var inst_36003__$1 = (state_36033[(2)]);
var inst_36004__$1 = (inst_36003__$1 == null);
var state_36033__$1 = (function (){var statearr_36054 = state_36033;
(statearr_36054[(10)] = inst_36004__$1);

(statearr_36054[(9)] = inst_36003__$1);

return statearr_36054;
})();
if(cljs.core.truth_(inst_36004__$1)){
var statearr_36055_36090 = state_36033__$1;
(statearr_36055_36090[(1)] = (12));

} else {
var statearr_36056_36091 = state_36033__$1;
(statearr_36056_36091[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (9))){
var inst_35998 = (state_36033[(8)]);
var inst_36001 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_35998);
var state_36033__$1 = state_36033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36033__$1,(11),inst_36001);
} else {
if((state_val_36034 === (5))){
var _ = (function (){var statearr_36057 = state_36033;
(statearr_36057[(4)] = cljs.core.rest.call(null,(state_36033[(4)])));

return statearr_36057;
})();
var state_36033__$1 = state_36033;
var ex36053 = (state_36033__$1[(2)]);
var statearr_36058_36092 = state_36033__$1;
(statearr_36058_36092[(5)] = ex36053);


if((ex36053 instanceof Error)){
var statearr_36059_36093 = state_36033__$1;
(statearr_36059_36093[(1)] = (4));

(statearr_36059_36093[(5)] = null);

} else {
throw ex36053;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (14))){
var inst_36009 = (state_36033[(2)]);
var state_36033__$1 = state_36033;
if(cljs.core.truth_(inst_36009)){
var statearr_36060_36094 = state_36033__$1;
(statearr_36060_36094[(1)] = (15));

} else {
var statearr_36061_36095 = state_36033__$1;
(statearr_36061_36095[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (16))){
var inst_35998 = (state_36033[(8)]);
var inst_36012 = cljs.core._EQ_.call(null,inst_35998,end);
var state_36033__$1 = state_36033;
if(inst_36012){
var statearr_36062_36096 = state_36033__$1;
(statearr_36062_36096[(1)] = (18));

} else {
var statearr_36063_36097 = state_36033__$1;
(statearr_36063_36097[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (10))){
var inst_36028 = (state_36033[(2)]);
var _ = (function (){var statearr_36064 = state_36033;
(statearr_36064[(4)] = cljs.core.rest.call(null,(state_36033[(4)])));

return statearr_36064;
})();
var state_36033__$1 = state_36033;
var statearr_36065_36098 = state_36033__$1;
(statearr_36065_36098[(2)] = inst_36028);

(statearr_36065_36098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (18))){
var inst_36003 = (state_36033[(9)]);
var inst_35999 = (state_36033[(7)]);
var inst_36014 = cljs.core.conj.call(null,inst_35999,inst_36003);
var state_36033__$1 = state_36033;
var statearr_36066_36099 = state_36033__$1;
(statearr_36066_36099[(2)] = inst_36014);

(statearr_36066_36099[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36034 === (8))){
var inst_35994 = (state_36033[(2)]);
var inst_35995 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_35996 = start;
var inst_35997 = cljs.core.PersistentVector.EMPTY;
var inst_35998 = inst_35996;
var inst_35999 = inst_35997;
var state_36033__$1 = (function (){var statearr_36067 = state_36033;
(statearr_36067[(8)] = inst_35998);

(statearr_36067[(11)] = inst_35994);

(statearr_36067[(7)] = inst_35999);

(statearr_36067[(12)] = inst_35995);

return statearr_36067;
})();
var statearr_36068_36100 = state_36033__$1;
(statearr_36068_36100[(2)] = null);

(statearr_36068_36100[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16221__auto__ = null;
var fluree$db$storage$core$state_machine__16221__auto____0 = (function (){
var statearr_36069 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36069[(0)] = fluree$db$storage$core$state_machine__16221__auto__);

(statearr_36069[(1)] = (1));

return statearr_36069;
});
var fluree$db$storage$core$state_machine__16221__auto____1 = (function (state_36033){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_36033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e36070){var ex__16224__auto__ = e36070;
var statearr_36071_36101 = state_36033;
(statearr_36071_36101[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_36033[(4)]))){
var statearr_36072_36102 = state_36033;
(statearr_36072_36102[(1)] = cljs.core.first.call(null,(state_36033[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36103 = state_36033;
state_36033 = G__36103;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16221__auto__ = function(state_36033){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16221__auto____1.call(this,state_36033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16221__auto____0;
fluree$db$storage$core$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16221__auto____1;
return fluree$db$storage$core$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_36073 = f__16346__auto__.call(null);
(statearr_36073[(6)] = c__16345__auto__);

return statearr_36073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_36119){
var state_val_36120 = (state_36119[(1)]);
if((state_val_36120 === (1))){
var state_36119__$1 = state_36119;
var statearr_36121_36135 = state_36119__$1;
(statearr_36121_36135[(2)] = null);

(statearr_36121_36135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36120 === (2))){
var _ = (function (){var statearr_36122 = state_36119;
(statearr_36122[(4)] = cljs.core.cons.call(null,(5),(state_36119[(4)])));

return statearr_36122;
})();
var inst_36110 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_36119__$1 = state_36119;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36119__$1,(6),inst_36110);
} else {
if((state_val_36120 === (3))){
var inst_36117 = (state_36119[(2)]);
var state_36119__$1 = state_36119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36119__$1,inst_36117);
} else {
if((state_val_36120 === (4))){
var inst_36104 = (state_36119[(2)]);
var state_36119__$1 = state_36119;
var statearr_36124_36136 = state_36119__$1;
(statearr_36124_36136[(2)] = inst_36104);

(statearr_36124_36136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36120 === (5))){
var _ = (function (){var statearr_36125 = state_36119;
(statearr_36125[(4)] = cljs.core.rest.call(null,(state_36119[(4)])));

return statearr_36125;
})();
var state_36119__$1 = state_36119;
var ex36123 = (state_36119__$1[(2)]);
var statearr_36126_36137 = state_36119__$1;
(statearr_36126_36137[(5)] = ex36123);


if((ex36123 instanceof Error)){
var statearr_36127_36138 = state_36119__$1;
(statearr_36127_36138[(1)] = (4));

(statearr_36127_36138[(5)] = null);

} else {
throw ex36123;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36120 === (6))){
var inst_36112 = (state_36119[(2)]);
var inst_36113 = fluree.db.util.async.throw_err.call(null,inst_36112);
var inst_36114 = cljs.core.first.call(null,inst_36113);
var _ = (function (){var statearr_36128 = state_36119;
(statearr_36128[(4)] = cljs.core.rest.call(null,(state_36119[(4)])));

return statearr_36128;
})();
var state_36119__$1 = state_36119;
var statearr_36129_36139 = state_36119__$1;
(statearr_36129_36139[(2)] = inst_36114);

(statearr_36129_36139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__16221__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__16221__auto____0 = (function (){
var statearr_36130 = [null,null,null,null,null,null,null];
(statearr_36130[(0)] = fluree$db$storage$core$block_$_state_machine__16221__auto__);

(statearr_36130[(1)] = (1));

return statearr_36130;
});
var fluree$db$storage$core$block_$_state_machine__16221__auto____1 = (function (state_36119){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_36119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e36131){var ex__16224__auto__ = e36131;
var statearr_36132_36140 = state_36119;
(statearr_36132_36140[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_36119[(4)]))){
var statearr_36133_36141 = state_36119;
(statearr_36133_36141[(1)] = cljs.core.first.call(null,(state_36119[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36142 = state_36119;
state_36119 = G__36142;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__16221__auto__ = function(state_36119){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__16221__auto____1.call(this,state_36119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__16221__auto____0;
fluree$db$storage$core$block_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__16221__auto____1;
return fluree$db$storage$core$block_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_36134 = f__16346__auto__.call(null);
(statearr_36134[(6)] = c__16345__auto__);

return statearr_36134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
