// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.js');
fluree.db.util.core.max_long = ((9007199254740991) - (1));
fluree.db.util.core.min_long = (- fluree.db.util.core.max_long);
fluree.db.util.core.max_integer = (2147483647);
fluree.db.util.core.min_integer = (- (2147483647));
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
fluree.db.util.core.cljs_env_QMARK_ = (function fluree$db$util$core$cljs_env_QMARK_(env){
return cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});
var ret__4867__auto___20150 = /**
 * Return then if we are generating cljs code and else for Clojure code.
 * https://groups.google.com/d/msg/clojurescript/iBY5HaQda4A/w1lAQi9_AwsJ
 */
fluree.db.util.core.if_cljs = (function fluree$db$util$core$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(fluree.db.util.core.cljs_env_QMARK_.call(null,_AMPERSAND_env)){
return then;
} else {
return else$;
}
});
(fluree.db.util.core.if_cljs.cljs$lang$macro = true);

var ret__4867__auto___20157 = (function (){
/**
 * A cross-platform variant of try-catch that catches all exceptions.
 * Does not (yet) support finally, and does not need or want an exception class.
 */
fluree.db.util.core.try_catchall = (function fluree$db$util$core$try_catchall(var_args){
var args__4824__auto__ = [];
var len__4818__auto___20158 = arguments.length;
var i__4819__auto___20159 = (0);
while(true){
if((i__4819__auto___20159 < len__4818__auto___20158)){
args__4824__auto__.push((arguments[i__4819__auto___20159]));

var G__20160 = (i__4819__auto___20159 + (1));
i__4819__auto___20159 = G__20160;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
var try_body = cljs.core.butlast.call(null,body);
var vec__20154 = cljs.core.last.call(null,body);
var seq__20155 = cljs.core.seq.call(null,vec__20154);
var first__20156 = cljs.core.first.call(null,seq__20155);
var seq__20155__$1 = cljs.core.next.call(null,seq__20155);
var catch$ = first__20156;
var first__20156__$1 = cljs.core.first.call(null,seq__20155__$1);
var seq__20155__$2 = cljs.core.next.call(null,seq__20155__$1);
var sym = first__20156__$1;
var catch_body = seq__20155__$2;
var catch_form = vec__20154;
if(cljs.core._EQ_.call(null,catch$,new cljs.core.Symbol(null,"catch","catch",-1616370245,null))){
} else {
throw (new Error("Assert failed: (= catch (quote catch))"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("js","Object","js/Object",61215323,null),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)),catch_body))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","Throwable","fluree.db.util.core/Throwable",853138167,null),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)),catch_body))),null,(1),null))))),null,(1),null)))));
}));

(fluree.db.util.core.try_catchall.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_catchall.cljs$lang$applyTo = (function (seq20151){
var G__20152 = cljs.core.first.call(null,seq20151);
var seq20151__$1 = cljs.core.next.call(null,seq20151);
var G__20153 = cljs.core.first.call(null,seq20151__$1);
var seq20151__$2 = cljs.core.next.call(null,seq20151__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20152,G__20153,seq20151__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_catchall.cljs$lang$macro = true);

var ret__4867__auto___20164 = (function (){
/**
 * Like try but supports catch*. catch* is like catch but supports CLJ/CLJS with
 *   less boilerplate. In CLJ it catches `Exception`. In CLJS it catches `:default`.
 *   Use it like this: `(try* ... (catch* err (handle-err err)))`.
 *   Also supports an optional finally clause.
 */
fluree.db.util.core.try_STAR_ = (function fluree$db$util$core$try_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___20165 = arguments.length;
var i__4819__auto___20166 = (0);
while(true){
if((i__4819__auto___20166 < len__4818__auto___20165)){
args__4824__auto__.push((arguments[i__4819__auto___20166]));

var G__20167 = (i__4819__auto___20166 + (1));
i__4819__auto___20166 = G__20167;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs-exceptions","try*","cljs-exceptions/try*",-1080387872,null),null,(1),null)),body))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("clj-exceptions","try*","clj-exceptions/try*",1421445009,null),null,(1),null)),body))),null,(1),null)))));
}));

(fluree.db.util.core.try_STAR_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_STAR_.cljs$lang$applyTo = (function (seq20161){
var G__20162 = cljs.core.first.call(null,seq20161);
var seq20161__$1 = cljs.core.next.call(null,seq20161);
var G__20163 = cljs.core.first.call(null,seq20161__$1);
var seq20161__$2 = cljs.core.next.call(null,seq20161__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20162,G__20163,seq20161__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_STAR_.cljs$lang$macro = true);

fluree.db.util.core.index_of = (function fluree$db$util$core$index_of(coll,value){
return cljs.core.some.call(null,(function (p__20168){
var vec__20169 = p__20168;
var item = cljs.core.nth.call(null,vec__20169,(0),null);
var idx = cljs.core.nth.call(null,vec__20169,(1),null);
if(cljs.core._EQ_.call(null,value,item)){
return idx;
} else {
return null;
}
}),cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,coll,cljs.core.range.call(null))));
});
/**
 * Generates random UUID in both clojure/script
 */
fluree.db.util.core.random_uuid = (function fluree$db$util$core$random_uuid(){
return cljs.core.random_uuid.call(null);
});
/**
 * Given a date, returns epoch millis if possible.
 */
fluree.db.util.core.date__GT_millis = (function fluree$db$util$core$date__GT_millis(date){
if(typeof date === 'string'){
return Date.parse(date).getTime();
} else {
if(typeof date === 'number'){
return date;
} else {
if((date instanceof Date)){
return date.getTime();
} else {
throw cljs.core.ex_info.call(null,["Invalid date: ",cljs.core.pr_str.call(null,date)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-date","db/invalid-date",2030527951)], null));

}
}
}
});
/**
 * Returns current time in epoch milliseonds for closure/script
 */
fluree.db.util.core.current_time_millis = (function fluree$db$util$core$current_time_millis(){
return (new Date()).getTime();
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.util.core.response_time_formatted = (function fluree$db$util$core$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
fluree.db.util.core.deep_merge = (function fluree$db$util$core$deep_merge(var_args){
var args__4824__auto__ = [];
var len__4818__auto___20177 = arguments.length;
var i__4819__auto___20178 = (0);
while(true){
if((i__4819__auto___20178 < len__4818__auto___20177)){
args__4824__auto__.push((arguments[i__4819__auto___20178]));

var G__20179 = (i__4819__auto___20178 + (1));
i__4819__auto___20178 = G__20179;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (v,vs){
var rec_merge = (function fluree$db$util$core$rec_merge(v1,v2){
if(((cljs.core.map_QMARK_.call(null,v1)) && (cljs.core.map_QMARK_.call(null,v2)))){
return cljs.core.merge_with.call(null,fluree.db.util.core.deep_merge,v1,v2);
} else {
return v2;
}
});
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,vs))){
return cljs.core.reduce.call(null,(function (p1__20173_SHARP_,p2__20174_SHARP_){
return rec_merge.call(null,p1__20173_SHARP_,p2__20174_SHARP_);
}),v,vs);
} else {
return v;
}
}));

(fluree.db.util.core.deep_merge.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.util.core.deep_merge.cljs$lang$applyTo = (function (seq20175){
var G__20176 = cljs.core.first.call(null,seq20175);
var seq20175__$1 = cljs.core.next.call(null,seq20175);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20176,seq20175__$1);
}));

fluree.db.util.core.email_QMARK_ = (function fluree$db$util$core$email_QMARK_(email){
return cljs.core.re_matches.call(null,/^[\w-\+]+(\.[\w]+)*@[\w-]+(\.[\w]+)*(\.[a-z]{2,})$/,email);
});
/**
 * Tests if an predicate identity two-tuple
 *   in form of [pred-name-or-id pred-value]
 */
fluree.db.util.core.pred_ident_QMARK_ = (function fluree$db$util$core$pred_ident_QMARK_(x){
return ((cljs.core.sequential_QMARK_.call(null,x)) && (((cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,x))) && (typeof cljs.core.first.call(null,x) === 'string'))));
});
fluree.db.util.core.temp_ident_QMARK_ = (function fluree$db$util$core$temp_ident_QMARK_(x){
return typeof x === 'string';
});
/**
 * Tests if an _id is a numeric or predicate-ident
 */
fluree.db.util.core.subj_ident_QMARK_ = (function fluree$db$util$core$subj_ident_QMARK_(x){
return ((cljs.core.int_QMARK_.call(null,x)) || (fluree.db.util.core.pred_ident_QMARK_.call(null,x)));
});
/**
 * Converts string to integer. Assumes you've already verified the string is
 *   parsable to an integer.
 */
fluree.db.util.core.str__GT_int = (function fluree$db$util$core$str__GT_int(s){
return parseInt(s);
});
/**
 * Converts a keyword to string. Can safely be called on a
 *   string which will return itself.
 */
fluree.db.util.core.keyword__GT_str = (function fluree$db$util$core$keyword__GT_str(k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),(1));
} else {
if(typeof k === 'string'){
return k;
} else {
throw cljs.core.ex_info.call(null,["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,k))," to string: ",cljs.core.pr_str.call(null,k)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Converts a string to a keyword, checking to see if
 *   the string starts with a ':', which it strips before converting.
 */
fluree.db.util.core.str__GT_keyword = (function fluree$db$util$core$str__GT_keyword(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_.call(null,s,":")){
return cljs.core.keyword.call(null,cljs.core.subs.call(null,s,(1)));
} else {
return cljs.core.keyword.call(null,s);
}
} else {
if((s instanceof cljs.core.Keyword)){
return s;
} else {
throw cljs.core.ex_info.call(null,["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,s))," to keyword: ",cljs.core.pr_str.call(null,s)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Takes time as a string and returns an java.time.Instant.
 */
fluree.db.util.core.str__GT_epoch_ms = (function fluree$db$util$core$str__GT_epoch_ms(time_str){
try{return Date.parse(time_str);
}catch (e20180){var _ = e20180;
throw cljs.core.ex_info.call(null,["Invalid time string. Ensure format is ISO-8601 compatible. Provided: ",cljs.core.pr_str.call(null,time_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-time","db/invalid-time",-1496866235)], null));
}});
/**
 * Truncate string s to n characters.
 */
fluree.db.util.core.trunc = (function fluree$db$util$core$trunc(s,n){
if((cljs.core.count.call(null,s) < n)){
return s;
} else {
return [cljs.core.subs.call(null,s,(0),n)," ..."].join('');
}
});
var ret__4867__auto___20188 = (function (){
fluree.db.util.core.some_of = (function fluree$db$util$core$some_of(var_args){
var G__20187 = arguments.length;
switch (G__20187) {
case 2:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___20190 = arguments.length;
var i__4819__auto___20191 = (0);
while(true){
if((i__4819__auto___20191 < len__4818__auto___20190)){
args_arr__4839__auto__.push((arguments[i__4819__auto___20191]));

var G__20192 = (i__4819__auto___20191 + (1));
i__4819__auto___20191 = G__20192;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((3)),(0),null));
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4840__auto__);

}
});

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,more){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"x__20181__auto__","x__20181__auto__",-145827730,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__20181__auto__","x__20181__auto__",-145827730,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","some-of","fluree.db.util.core/some-of",1946305325,null),null,(1),null)),more))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__20181__auto__","x__20181__auto__",-145827730,null),null,(1),null))))),null,(1),null)))));
}));

/** @this {Function} */
(fluree.db.util.core.some_of.cljs$lang$applyTo = (function (seq20183){
var G__20184 = cljs.core.first.call(null,seq20183);
var seq20183__$1 = cljs.core.next.call(null,seq20183);
var G__20185 = cljs.core.first.call(null,seq20183__$1);
var seq20183__$2 = cljs.core.next.call(null,seq20183__$1);
var G__20186 = cljs.core.first.call(null,seq20183__$2);
var seq20183__$3 = cljs.core.next.call(null,seq20183__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20184,G__20185,G__20186,seq20183__$3);
}));

(fluree.db.util.core.some_of.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.util.core.some_of.cljs$lang$macro = true);

/**
 * Filters map k/v pairs dropping any where predicate applied to value is false.
 */
fluree.db.util.core.filter_vals = (function fluree$db$util$core$filter_vals(pred,m){
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
if(cljs.core.truth_(pred.call(null,v))){
return cljs.core.assoc.call(null,m__$1,k,v);
} else {
return m__$1;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Remove all keys from a map that have nil or empty collection values.
 */
fluree.db.util.core.without_nils = (function fluree$db$util$core$without_nils(m){
return fluree.db.util.core.filter_vals.call(null,(function (p1__20193_SHARP_){
if(cljs.core.coll_QMARK_.call(null,p1__20193_SHARP_)){
return cljs.core.not_empty.call(null,p1__20193_SHARP_);
} else {
return (!((p1__20193_SHARP_ == null)));
}
}),m);
});
/**
 * Like range, but includes start/end values.
 */
fluree.db.util.core.inclusive_range = (function fluree$db$util$core$inclusive_range(var_args){
var G__20195 = arguments.length;
switch (G__20195) {
case 0:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.call(null);
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.call(null,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.call(null,start,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return cljs.core.range.call(null,start,(end + step),step);
}));

(fluree.db.util.core.inclusive_range.cljs$lang$maxFixedArity = 3);

/**
 * x-platform, returns true if is an execption
 */
fluree.db.util.core.exception_QMARK_ = (function fluree$db$util$core$exception_QMARK_(x){
return (x instanceof Error);
});
fluree.db.util.core.url_encode = (function fluree$db$util$core$url_encode(string){
var G__20197 = string;
var G__20197__$1 = (((G__20197 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20197));
var G__20197__$2 = (((G__20197__$1 == null))?null:encodeURIComponent(G__20197__$1));
if((G__20197__$2 == null)){
return null;
} else {
return G__20197__$2.replace("+","%20");
}
});
fluree.db.util.core.url_decode = (function fluree$db$util$core$url_decode(var_args){
var G__20199 = arguments.length;
switch (G__20199) {
case 1:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1 = (function (string){
return fluree.db.util.core.url_decode.call(null,string,"UTF-8");
}));

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2 = (function (string,encoding){
var G__20200 = string;
var G__20200__$1 = (((G__20200 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20200));
if((G__20200__$1 == null)){
return null;
} else {
return decodeURIComponent(G__20200__$1);
}
}));

(fluree.db.util.core.url_decode.cljs$lang$maxFixedArity = 2);

fluree.db.util.core.map_invert = (function fluree$db$util$core$map_invert(m){
return cljs.core.reduce.call(null,(function (m__$1,p__20202){
var vec__20203 = p__20202;
var k = cljs.core.nth.call(null,vec__20203,(0),null);
var v = cljs.core.nth.call(null,vec__20203,(1),null);
return cljs.core.assoc.call(null,m__$1,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Zero pads x
 */
fluree.db.util.core.zero_pad = (function fluree$db$util$core$zero_pad(x,pad){
var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((s.length < pad)){
var G__20206 = ["0",s].join('');
s = G__20206;
continue;
} else {
return s;
}
break;
}
});
