// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status >= (500));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__37177 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__37177,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__37177;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__37178 = opts;
var map__37178__$1 = cljs.core.__destructure_map.call(null,map__37178);
var request_timeout = cljs.core.get.call(null,map__37178__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__37178__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__37178__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__37179 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__37179__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__37179,headers):G__37179);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__37179__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__37179__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__37180 = opts;
var map__37180__$1 = cljs.core.__destructure_map.call(null,map__37180);
var request_timeout = cljs.core.get.call(null,map__37180__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__37180__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__37180__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__37180__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__37180__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__37181 = cljs.core.PersistentArrayMap.EMPTY;
var G__37181__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__37181,headers):G__37181);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__37181__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__37181__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__37182 = output_format;
var G__37182__$1 = (((G__37182 instanceof cljs.core.Keyword))?G__37182.fqn:null);
switch (G__37182__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__37184 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__37184,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__37184;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37216){
var state_val_37217 = (state_37216[(1)]);
if((state_val_37217 === (7))){
var inst_37212 = (state_37216[(2)]);
var state_37216__$1 = state_37216;
var statearr_37218_37243 = state_37216__$1;
(statearr_37218_37243[(2)] = inst_37212);

(statearr_37218_37243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (1))){
var state_37216__$1 = state_37216;
var statearr_37219_37244 = state_37216__$1;
(statearr_37219_37244[(2)] = null);

(statearr_37219_37244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (4))){
var inst_37187 = (state_37216[(7)]);
var inst_37187__$1 = (state_37216[(2)]);
var inst_37188 = (inst_37187__$1 == null);
var state_37216__$1 = (function (){var statearr_37220 = state_37216;
(statearr_37220[(7)] = inst_37187__$1);

return statearr_37220;
})();
if(cljs.core.truth_(inst_37188)){
var statearr_37221_37245 = state_37216__$1;
(statearr_37221_37245[(1)] = (5));

} else {
var statearr_37222_37246 = state_37216__$1;
(statearr_37222_37246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (6))){
var inst_37187 = (state_37216[(7)]);
var inst_37195 = cljs.core.nth.call(null,inst_37187,(0),null);
var inst_37196 = cljs.core.nth.call(null,inst_37187,(1),null);
var state_37216__$1 = (function (){var statearr_37223 = state_37216;
(statearr_37223[(8)] = inst_37196);

(statearr_37223[(9)] = inst_37195);

return statearr_37223;
})();
var statearr_37224_37247 = state_37216__$1;
(statearr_37224_37247[(2)] = null);

(statearr_37224_37247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (3))){
var inst_37214 = (state_37216[(2)]);
var state_37216__$1 = state_37216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37216__$1,inst_37214);
} else {
if((state_val_37217 === (2))){
var state_37216__$1 = state_37216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37216__$1,(4),pub_chan);
} else {
if((state_val_37217 === (11))){
var _ = (function (){var statearr_37226 = state_37216;
(statearr_37226[(4)] = cljs.core.rest.call(null,(state_37216[(4)])));

return statearr_37226;
})();
var state_37216__$1 = state_37216;
var ex37225 = (state_37216__$1[(2)]);
var statearr_37227_37248 = state_37216__$1;
(statearr_37227_37248[(5)] = ex37225);


var statearr_37228_37249 = state_37216__$1;
(statearr_37228_37249[(1)] = (10));

(statearr_37228_37249[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (9))){
var inst_37209 = (state_37216[(2)]);
var state_37216__$1 = (function (){var statearr_37229 = state_37216;
(statearr_37229[(10)] = inst_37209);

return statearr_37229;
})();
var statearr_37230_37250 = state_37216__$1;
(statearr_37230_37250[(2)] = null);

(statearr_37230_37250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (5))){
var inst_37190 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_37216__$1 = state_37216;
var statearr_37231_37251 = state_37216__$1;
(statearr_37231_37251[(2)] = inst_37190);

(statearr_37231_37251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (10))){
var inst_37196 = (state_37216[(8)]);
var inst_37195 = (state_37216[(9)]);
var inst_37197 = (state_37216[(2)]);
var inst_37198 = fluree.db.util.log.error.call(null,inst_37197,"Error sending websocket message:",inst_37195);
var inst_37199 = cljs.core.async.put_BANG_.call(null,inst_37196,false);
var state_37216__$1 = (function (){var statearr_37232 = state_37216;
(statearr_37232[(11)] = inst_37198);

return statearr_37232;
})();
var statearr_37233_37252 = state_37216__$1;
(statearr_37233_37252[(2)] = inst_37199);

(statearr_37233_37252[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37217 === (8))){
var inst_37196 = (state_37216[(8)]);
var inst_37195 = (state_37216[(9)]);
var _ = (function (){var statearr_37234 = state_37216;
(statearr_37234[(4)] = cljs.core.cons.call(null,(11),(state_37216[(4)])));

return statearr_37234;
})();
var inst_37205 = ws.send(inst_37195);
var inst_37206 = cljs.core.async.put_BANG_.call(null,inst_37196,true);
var ___$1 = (function (){var statearr_37235 = state_37216;
(statearr_37235[(4)] = cljs.core.rest.call(null,(state_37216[(4)])));

return statearr_37235;
})();
var state_37216__$1 = (function (){var statearr_37236 = state_37216;
(statearr_37236[(12)] = inst_37205);

return statearr_37236;
})();
var statearr_37237_37253 = state_37216__$1;
(statearr_37237_37253[(2)] = inst_37206);

(statearr_37237_37253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____0 = (function (){
var statearr_37238 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37238[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__);

(statearr_37238[(1)] = (1));

return statearr_37238;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____1 = (function (state_37216){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37239){var ex__16224__auto__ = e37239;
var statearr_37240_37254 = state_37216;
(statearr_37240_37254[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37216[(4)]))){
var statearr_37241_37255 = state_37216;
(statearr_37241_37255[(1)] = cljs.core.first.call(null,(state_37216[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37256 = state_37216;
state_37216 = G__37256;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__ = function(state_37216){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____1.call(this,state_37216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37242 = f__16346__auto__.call(null);
(statearr_37242[(6)] = c__16345__auto__);

return statearr_37242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__16345__auto___37294 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37281){
var state_val_37282 = (state_37281[(1)]);
if((state_val_37282 === (1))){
var inst_37260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37261 = [open_QMARK_,timeout_chan];
var inst_37262 = (new cljs.core.PersistentVector(null,2,(5),inst_37260,inst_37261,null));
var state_37281__$1 = state_37281;
return cljs.core.async.ioc_alts_BANG_.call(null,state_37281__$1,(2),inst_37262,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_37282 === (2))){
var inst_37264 = (state_37281[(2)]);
var inst_37265 = cljs.core.nth.call(null,inst_37264,(0),null);
var inst_37266 = cljs.core.nth.call(null,inst_37264,(1),null);
var inst_37267 = cljs.core._EQ_.call(null,inst_37266,timeout_chan);
var state_37281__$1 = (function (){var statearr_37283 = state_37281;
(statearr_37283[(7)] = inst_37265);

return statearr_37283;
})();
if(inst_37267){
var statearr_37284_37295 = state_37281__$1;
(statearr_37284_37295[(1)] = (3));

} else {
var statearr_37285_37296 = state_37281__$1;
(statearr_37285_37296[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37282 === (3))){
var inst_37269 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_37270 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37271 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_37272 = cljs.core.PersistentHashMap.fromArrays(inst_37270,inst_37271);
var inst_37273 = cljs.core.ex_info.call(null,inst_37269,inst_37272);
var inst_37274 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_37273);
var inst_37275 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_37281__$1 = (function (){var statearr_37286 = state_37281;
(statearr_37286[(8)] = inst_37274);

return statearr_37286;
})();
var statearr_37287_37297 = state_37281__$1;
(statearr_37287_37297[(2)] = inst_37275);

(statearr_37287_37297[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37282 === (4))){
var inst_37277 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_37281__$1 = state_37281;
var statearr_37288_37298 = state_37281__$1;
(statearr_37288_37298[(2)] = inst_37277);

(statearr_37288_37298[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37282 === (5))){
var inst_37279 = (state_37281[(2)]);
var state_37281__$1 = state_37281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37281__$1,inst_37279);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____0 = (function (){
var statearr_37289 = [null,null,null,null,null,null,null,null,null];
(statearr_37289[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__);

(statearr_37289[(1)] = (1));

return statearr_37289;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____1 = (function (state_37281){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37290){var ex__16224__auto__ = e37290;
var statearr_37291_37299 = state_37281;
(statearr_37291_37299[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37281[(4)]))){
var statearr_37292_37300 = state_37281;
(statearr_37292_37300[(1)] = cljs.core.first.call(null,(state_37281[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37301 = state_37281;
state_37281 = G__37301;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__ = function(state_37281){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____1.call(this,state_37281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37293 = f__16346__auto__.call(null);
(statearr_37293[(6)] = c__16345__auto___37294);

return statearr_37293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
