// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45317(s__45318){
return (new cljs.core.LazySeq(null,(function (){
var s__45318__$1 = s__45318;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45318__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45323 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45323,(0),null);
var item_set = cljs.core.nth.call(null,vec__45323,(1),null);
var iterys__4607__auto__ = ((function (s__45318__$1,vec__45323,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__45317_$_iter__45319(s__45320){
return (new cljs.core.LazySeq(null,((function (s__45318__$1,vec__45323,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__45320__$1 = s__45320;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45320__$1);
if(temp__5753__auto____$1){
var s__45320__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45320__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45320__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45322 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45321 = (0);
while(true){
if((i__45321 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45321);
cljs.core.chunk_append.call(null,b__45322,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__45371 = (i__45321 + (1));
i__45321 = G__45371;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45322),tailrecursion$priority_map$iter__45317_$_iter__45319.call(null,cljs.core.chunk_rest.call(null,s__45320__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45322),null);
}
} else {
var item = cljs.core.first.call(null,s__45320__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__45317_$_iter__45319.call(null,cljs.core.rest.call(null,s__45320__$2)));
}
} else {
return null;
}
break;
}
});})(s__45318__$1,vec__45323,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__45318__$1,vec__45323,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45317.call(null,cljs.core.rest.call(null,s__45318__$1)));
} else {
var G__45372 = cljs.core.rest.call(null,s__45318__$1);
s__45318__$1 = G__45372;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45326(s__45327){
return (new cljs.core.LazySeq(null,(function (){
var s__45327__$1 = s__45327;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45327__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45332 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45332,(0),null);
var item_set = cljs.core.nth.call(null,vec__45332,(1),null);
var iterys__4607__auto__ = ((function (s__45327__$1,vec__45332,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__45326_$_iter__45328(s__45329){
return (new cljs.core.LazySeq(null,((function (s__45327__$1,vec__45332,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__45329__$1 = s__45329;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45329__$1);
if(temp__5753__auto____$1){
var s__45329__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45329__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45329__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45331 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45330 = (0);
while(true){
if((i__45330 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45330);
cljs.core.chunk_append.call(null,b__45331,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__45373 = (i__45330 + (1));
i__45330 = G__45373;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45331),tailrecursion$priority_map$iter__45326_$_iter__45328.call(null,cljs.core.chunk_rest.call(null,s__45329__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45331),null);
}
} else {
var item = cljs.core.first.call(null,s__45329__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__45326_$_iter__45328.call(null,cljs.core.rest.call(null,s__45329__$2)));
}
} else {
return null;
}
break;
}
});})(s__45327__$1,vec__45332,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__45327__$1,vec__45332,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45326.call(null,cljs.core.rest.call(null,s__45327__$1)));
} else {
var G__45374 = cljs.core.rest.call(null,s__45327__$1);
s__45327__$1 = G__45374;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45335(s__45336){
return (new cljs.core.LazySeq(null,(function (){
var s__45336__$1 = s__45336;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45336__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45341 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45341,(0),null);
var item_set = cljs.core.nth.call(null,vec__45341,(1),null);
var iterys__4607__auto__ = ((function (s__45336__$1,vec__45341,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__45335_$_iter__45337(s__45338){
return (new cljs.core.LazySeq(null,((function (s__45336__$1,vec__45341,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__45338__$1 = s__45338;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45338__$1);
if(temp__5753__auto____$1){
var s__45338__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45338__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45338__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45340 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45339 = (0);
while(true){
if((i__45339 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45339);
cljs.core.chunk_append.call(null,b__45340,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__45375 = (i__45339 + (1));
i__45339 = G__45375;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45340),tailrecursion$priority_map$iter__45335_$_iter__45337.call(null,cljs.core.chunk_rest.call(null,s__45338__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45340),null);
}
} else {
var item = cljs.core.first.call(null,s__45338__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__45335_$_iter__45337.call(null,cljs.core.rest.call(null,s__45338__$2)));
}
} else {
return null;
}
break;
}
});})(s__45336__$1,vec__45341,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__45336__$1,vec__45341,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45335.call(null,cljs.core.rest.call(null,s__45336__$1)));
} else {
var G__45376 = cljs.core.rest.call(null,s__45336__$1);
s__45336__$1 = G__45376;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45344(s__45345){
return (new cljs.core.LazySeq(null,(function (){
var s__45345__$1 = s__45345;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45345__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45350 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45350,(0),null);
var item_set = cljs.core.nth.call(null,vec__45350,(1),null);
var iterys__4607__auto__ = ((function (s__45345__$1,vec__45350,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__45344_$_iter__45346(s__45347){
return (new cljs.core.LazySeq(null,((function (s__45345__$1,vec__45350,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__45347__$1 = s__45347;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45347__$1);
if(temp__5753__auto____$1){
var s__45347__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45347__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45347__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45349 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45348 = (0);
while(true){
if((i__45348 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45348);
cljs.core.chunk_append.call(null,b__45349,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__45377 = (i__45348 + (1));
i__45348 = G__45377;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45349),tailrecursion$priority_map$iter__45344_$_iter__45346.call(null,cljs.core.chunk_rest.call(null,s__45347__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45349),null);
}
} else {
var item = cljs.core.first.call(null,s__45347__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__45344_$_iter__45346.call(null,cljs.core.rest.call(null,s__45347__$2)));
}
} else {
return null;
}
break;
}
});})(s__45345__$1,vec__45350,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__45345__$1,vec__45350,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45344.call(null,cljs.core.rest.call(null,s__45345__$1)));
} else {
var G__45378 = cljs.core.rest.call(null,s__45345__$1);
s__45345__$1 = G__45378;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__45379 = null;
var G__45379__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__45379__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__45379 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__45379__2.call(this,self__,item);
case 3:
return G__45379__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__45379.cljs$core$IFn$_invoke$arity$2 = G__45379__2;
G__45379.cljs$core$IFn$_invoke$arity$3 = G__45379__3;
return G__45379;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args45316){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args45316)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45353(s__45354){
return (new cljs.core.LazySeq(null,(function (){
var s__45354__$1 = s__45354;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45354__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45359 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45359,(0),null);
var item_set = cljs.core.nth.call(null,vec__45359,(1),null);
var iterys__4607__auto__ = ((function (s__45354__$1,vec__45359,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__45353_$_iter__45355(s__45356){
return (new cljs.core.LazySeq(null,((function (s__45354__$1,vec__45359,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__45356__$1 = s__45356;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45356__$1);
if(temp__5753__auto____$1){
var s__45356__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45356__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45356__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45358 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45357 = (0);
while(true){
if((i__45357 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45357);
cljs.core.chunk_append.call(null,b__45358,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__45380 = (i__45357 + (1));
i__45357 = G__45380;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45358),tailrecursion$priority_map$iter__45353_$_iter__45355.call(null,cljs.core.chunk_rest.call(null,s__45356__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45358),null);
}
} else {
var item = cljs.core.first.call(null,s__45356__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__45353_$_iter__45355.call(null,cljs.core.rest.call(null,s__45356__$2)));
}
} else {
return null;
}
break;
}
});})(s__45354__$1,vec__45359,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__45354__$1,vec__45359,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45353.call(null,cljs.core.rest.call(null,s__45354__$1)));
} else {
var G__45381 = cljs.core.rest.call(null,s__45354__$1);
s__45354__$1 = G__45381;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__45362(s__45363){
return (new cljs.core.LazySeq(null,(function (){
var s__45363__$1 = s__45363;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__45363__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__45368 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__45368,(0),null);
var item_set = cljs.core.nth.call(null,vec__45368,(1),null);
var iterys__4607__auto__ = ((function (s__45363__$1,vec__45368,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__45362_$_iter__45364(s__45365){
return (new cljs.core.LazySeq(null,((function (s__45363__$1,vec__45368,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__45365__$1 = s__45365;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__45365__$1);
if(temp__5753__auto____$1){
var s__45365__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__45365__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__45365__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__45367 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__45366 = (0);
while(true){
if((i__45366 < size__4610__auto__)){
var item = cljs.core._nth.call(null,c__4609__auto__,i__45366);
cljs.core.chunk_append.call(null,b__45367,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__45382 = (i__45366 + (1));
i__45366 = G__45382;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45367),tailrecursion$priority_map$iter__45362_$_iter__45364.call(null,cljs.core.chunk_rest.call(null,s__45365__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__45367),null);
}
} else {
var item = cljs.core.first.call(null,s__45365__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__45362_$_iter__45364.call(null,cljs.core.rest.call(null,s__45365__$2)));
}
} else {
return null;
}
break;
}
});})(s__45363__$1,vec__45368,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__45363__$1,vec__45368,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq.call(null,iterys__4607__auto__.call(null,item_set));
if(fs__4608__auto__){
return cljs.core.concat.call(null,fs__4608__auto__,tailrecursion$priority_map$iter__45362.call(null,cljs.core.rest.call(null,s__45363__$1)));
} else {
var G__45383 = cljs.core.rest.call(null,s__45363__$1);
s__45363__$1 = G__45383;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__45385 = arguments.length;
switch (G__45385) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45388 = arguments.length;
var i__4819__auto___45389 = (0);
while(true){
if((i__4819__auto___45389 < len__4818__auto___45388)){
args__4824__auto__.push((arguments[i__4819__auto___45389]));

var G__45390 = (i__4819__auto___45389 + (1));
i__4819__auto___45389 = G__45390;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__45391 = cljs.core.nnext.call(null,in$);
var G__45392 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__45391;
out = G__45392;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq45387){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq45387));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45395 = arguments.length;
var i__4819__auto___45396 = (0);
while(true){
if((i__4819__auto___45396 < len__4818__auto___45395)){
args__4824__auto__.push((arguments[i__4819__auto___45396]));

var G__45397 = (i__4819__auto___45396 + (1));
i__4819__auto___45396 = G__45397;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__45398 = cljs.core.nnext.call(null,in$);
var G__45399 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__45398;
out = G__45399;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq45393){
var G__45394 = cljs.core.first.call(null,seq45393);
var seq45393__$1 = cljs.core.next.call(null,seq45393);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45394,seq45393__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45402 = arguments.length;
var i__4819__auto___45403 = (0);
while(true){
if((i__4819__auto___45403 < len__4818__auto___45402)){
args__4824__auto__.push((arguments[i__4819__auto___45403]));

var G__45404 = (i__4819__auto___45403 + (1));
i__4819__auto___45403 = G__45404;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__45405 = cljs.core.nnext.call(null,in$);
var G__45406 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__45405;
out = G__45406;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq45400){
var G__45401 = cljs.core.first.call(null,seq45400);
var seq45400__$1 = cljs.core.next.call(null,seq45400);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45401,seq45400__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45410 = arguments.length;
var i__4819__auto___45411 = (0);
while(true){
if((i__4819__auto___45411 < len__4818__auto___45410)){
args__4824__auto__.push((arguments[i__4819__auto___45411]));

var G__45412 = (i__4819__auto___45411 + (1));
i__4819__auto___45411 = G__45412;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__45413 = cljs.core.nnext.call(null,in$);
var G__45414 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__45413;
out = G__45414;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq45407){
var G__45408 = cljs.core.first.call(null,seq45407);
var seq45407__$1 = cljs.core.next.call(null,seq45407);
var G__45409 = cljs.core.first.call(null,seq45407__$1);
var seq45407__$2 = cljs.core.next.call(null,seq45407__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45408,G__45409,seq45407__$2);
}));

