// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__9784 = s;
var map__9784__$1 = cljs.core.__destructure_map(map__9784);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9784__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9784__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__9786 = info;
var map__9787 = G__9786;
var map__9787__$1 = cljs.core.__destructure_map(map__9787);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9787__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__9786__$1 = G__9786;
while(true){
var d__$2 = d__$1;
var map__9789 = G__9786__$1;
var map__9789__$1 = cljs.core.__destructure_map(map__9789);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9789__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__9790 = (d__$2 + (1));
var G__9791 = shadow__$1;
d__$1 = G__9790;
G__9786__$1 = G__9791;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__9792){
var map__9793 = p__9792;
var map__9793__$1 = cljs.core.__destructure_map(map__9793);
var name_var = map__9793__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9793__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9793__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__9794 = info;
var map__9794__$1 = cljs.core.__destructure_map(map__9794);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9794__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9794__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__9795 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__9795) : cljs.compiler.munge.call(null,G__9795));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__9797 = arguments.length;
switch (G__9797) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__9798 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11639,11639,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__9798.cljs$core$IFn$_invoke$arity$1 ? fexpr__9798.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__9798.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__9800 = cp;
switch (G__9800) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__9802_9806 = cljs.core.seq(s);
var chunk__9803_9807 = null;
var count__9804_9808 = (0);
var i__9805_9809 = (0);
while(true){
if((i__9805_9809 < count__9804_9808)){
var c_9810 = chunk__9803_9807.cljs$core$IIndexed$_nth$arity$2(null,i__9805_9809);
sb.append(cljs.compiler.escape_char(c_9810));


var G__9811 = seq__9802_9806;
var G__9812 = chunk__9803_9807;
var G__9813 = count__9804_9808;
var G__9814 = (i__9805_9809 + (1));
seq__9802_9806 = G__9811;
chunk__9803_9807 = G__9812;
count__9804_9808 = G__9813;
i__9805_9809 = G__9814;
continue;
} else {
var temp__5753__auto___9815 = cljs.core.seq(seq__9802_9806);
if(temp__5753__auto___9815){
var seq__9802_9816__$1 = temp__5753__auto___9815;
if(cljs.core.chunked_seq_QMARK_(seq__9802_9816__$1)){
var c__4638__auto___9817 = cljs.core.chunk_first(seq__9802_9816__$1);
var G__9818 = cljs.core.chunk_rest(seq__9802_9816__$1);
var G__9819 = c__4638__auto___9817;
var G__9820 = cljs.core.count(c__4638__auto___9817);
var G__9821 = (0);
seq__9802_9806 = G__9818;
chunk__9803_9807 = G__9819;
count__9804_9808 = G__9820;
i__9805_9809 = G__9821;
continue;
} else {
var c_9822 = cljs.core.first(seq__9802_9816__$1);
sb.append(cljs.compiler.escape_char(c_9822));


var G__9823 = cljs.core.next(seq__9802_9816__$1);
var G__9824 = null;
var G__9825 = (0);
var G__9826 = (0);
seq__9802_9806 = G__9823;
chunk__9803_9807 = G__9824;
count__9804_9808 = G__9825;
i__9805_9809 = G__9826;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__9827 = cljs.core.get_global_hierarchy;
return (fexpr__9827.cljs$core$IFn$_invoke$arity$0 ? fexpr__9827.cljs$core$IFn$_invoke$arity$0() : fexpr__9827.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__9828_9833 = ast;
var map__9828_9834__$1 = cljs.core.__destructure_map(map__9828_9833);
var env_9835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9828_9834__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_9835))){
var map__9829_9836 = env_9835;
var map__9829_9837__$1 = cljs.core.__destructure_map(map__9829_9836);
var line_9838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9829_9837__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_9839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9829_9837__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__9830 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__9832 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__9831 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__9831.cljs$core$IFn$_invoke$arity$1 ? fexpr__9831.cljs$core$IFn$_invoke$arity$1(G__9832) : fexpr__9831.call(null,G__9832));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__9830,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__9830;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_9838 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_9839)?(column_9839 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__9848 = arguments.length;
switch (G__9848) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___9855 = arguments.length;
var i__4819__auto___9856 = (0);
while(true){
if((i__4819__auto___9856 < len__4818__auto___9855)){
args_arr__4839__auto__.push((arguments[i__4819__auto___9856]));

var G__9857 = (i__4819__auto___9856 + (1));
i__4819__auto___9856 = G__9857;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_9858 = (function (){var G__9849 = a;
if((!(typeof a === 'string'))){
return G__9849.toString();
} else {
return G__9849;
}
})();
var temp__5757__auto___9859 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___9859 == null)){
} else {
var sm_data_9860 = temp__5757__auto___9859;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_9860,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__9840_SHARP_){
return (p1__9840_SHARP_ + s_9858.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_9858], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9850 = cljs.core.seq(xs);
var chunk__9851 = null;
var count__9852 = (0);
var i__9853 = (0);
while(true){
if((i__9853 < count__9852)){
var x = chunk__9851.cljs$core$IIndexed$_nth$arity$2(null,i__9853);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9861 = seq__9850;
var G__9862 = chunk__9851;
var G__9863 = count__9852;
var G__9864 = (i__9853 + (1));
seq__9850 = G__9861;
chunk__9851 = G__9862;
count__9852 = G__9863;
i__9853 = G__9864;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__9850);
if(temp__5753__auto__){
var seq__9850__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9850__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__9850__$1);
var G__9865 = cljs.core.chunk_rest(seq__9850__$1);
var G__9866 = c__4638__auto__;
var G__9867 = cljs.core.count(c__4638__auto__);
var G__9868 = (0);
seq__9850 = G__9865;
chunk__9851 = G__9866;
count__9852 = G__9867;
i__9853 = G__9868;
continue;
} else {
var x = cljs.core.first(seq__9850__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9869 = cljs.core.next(seq__9850__$1);
var G__9870 = null;
var G__9871 = (0);
var G__9872 = (0);
seq__9850 = G__9869;
chunk__9851 = G__9870;
count__9852 = G__9871;
i__9853 = G__9872;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq9842){
var G__9843 = cljs.core.first(seq9842);
var seq9842__$1 = cljs.core.next(seq9842);
var G__9844 = cljs.core.first(seq9842__$1);
var seq9842__$2 = cljs.core.next(seq9842__$1);
var G__9845 = cljs.core.first(seq9842__$2);
var seq9842__$3 = cljs.core.next(seq9842__$2);
var G__9846 = cljs.core.first(seq9842__$3);
var seq9842__$4 = cljs.core.next(seq9842__$3);
var G__9847 = cljs.core.first(seq9842__$4);
var seq9842__$5 = cljs.core.next(seq9842__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9843,G__9844,G__9845,G__9846,G__9847,seq9842__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__9873){
var map__9874 = p__9873;
var map__9874__$1 = cljs.core.__destructure_map(map__9874);
var m = map__9874__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9874__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__9882 = arguments.length;
switch (G__9882) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___9888 = arguments.length;
var i__4819__auto___9889 = (0);
while(true){
if((i__4819__auto___9889 < len__4818__auto___9888)){
args_arr__4839__auto__.push((arguments[i__4819__auto___9889]));

var G__9890 = (i__4819__auto___9889 + (1));
i__4819__auto___9889 = G__9890;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9883_9891 = cljs.core.seq(xs);
var chunk__9884_9892 = null;
var count__9885_9893 = (0);
var i__9886_9894 = (0);
while(true){
if((i__9886_9894 < count__9885_9893)){
var x_9895 = chunk__9884_9892.cljs$core$IIndexed$_nth$arity$2(null,i__9886_9894);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9895);


var G__9896 = seq__9883_9891;
var G__9897 = chunk__9884_9892;
var G__9898 = count__9885_9893;
var G__9899 = (i__9886_9894 + (1));
seq__9883_9891 = G__9896;
chunk__9884_9892 = G__9897;
count__9885_9893 = G__9898;
i__9886_9894 = G__9899;
continue;
} else {
var temp__5753__auto___9900 = cljs.core.seq(seq__9883_9891);
if(temp__5753__auto___9900){
var seq__9883_9901__$1 = temp__5753__auto___9900;
if(cljs.core.chunked_seq_QMARK_(seq__9883_9901__$1)){
var c__4638__auto___9902 = cljs.core.chunk_first(seq__9883_9901__$1);
var G__9903 = cljs.core.chunk_rest(seq__9883_9901__$1);
var G__9904 = c__4638__auto___9902;
var G__9905 = cljs.core.count(c__4638__auto___9902);
var G__9906 = (0);
seq__9883_9891 = G__9903;
chunk__9884_9892 = G__9904;
count__9885_9893 = G__9905;
i__9886_9894 = G__9906;
continue;
} else {
var x_9907 = cljs.core.first(seq__9883_9901__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9907);


var G__9908 = cljs.core.next(seq__9883_9901__$1);
var G__9909 = null;
var G__9910 = (0);
var G__9911 = (0);
seq__9883_9891 = G__9908;
chunk__9884_9892 = G__9909;
count__9885_9893 = G__9910;
i__9886_9894 = G__9911;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq9876){
var G__9877 = cljs.core.first(seq9876);
var seq9876__$1 = cljs.core.next(seq9876);
var G__9878 = cljs.core.first(seq9876__$1);
var seq9876__$2 = cljs.core.next(seq9876__$1);
var G__9879 = cljs.core.first(seq9876__$2);
var seq9876__$3 = cljs.core.next(seq9876__$2);
var G__9880 = cljs.core.first(seq9876__$3);
var seq9876__$4 = cljs.core.next(seq9876__$3);
var G__9881 = cljs.core.first(seq9876__$4);
var seq9876__$5 = cljs.core.next(seq9876__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9877,G__9878,G__9879,G__9880,G__9881,seq9876__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__9912_9916 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__9913_9917 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__9914_9918 = true;
var _STAR_print_fn_STAR__temp_val__9915_9919 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__9914_9918);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__9915_9919);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__9913_9917);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__9912_9916);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__9920 = cljs.core.get_global_hierarchy;
return (fexpr__9920.cljs$core$IFn$_invoke$arity$0 ? fexpr__9920.cljs$core$IFn$_invoke$arity$0() : fexpr__9920.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__9921 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9921,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9921,(1),null);
var G__9924 = ns;
var G__9925 = name;
var G__9926 = (function (){
var G__9927 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__9927) : cljs.compiler.emit_constant.call(null,G__9927));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__9924,G__9925,G__9926) : cljs.compiler.emit_record_value.call(null,G__9924,G__9925,G__9926));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__9928 = cljs.core.keys(x);
var G__9929 = cljs.core.vals(x);
var G__9930 = cljs.compiler.emit_constants_comma_sep;
var G__9931 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__9928,G__9929,G__9930,G__9931) : cljs.compiler.emit_map.call(null,G__9928,G__9929,G__9930,G__9931));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__9932 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__9933 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__9932,G__9933) : cljs.compiler.emit_with_meta.call(null,G__9932,G__9933));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__9934 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9934,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9934,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9934,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__9937 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9937) : x.call(null,G__9937));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__9938 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9938) : x.call(null,G__9938));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__9940 = items;
var G__9941 = (function (p1__9939_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__9939_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__9940,G__9941) : cljs.compiler.emit_js_object.call(null,G__9940,G__9941));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__9943){
var map__9944 = p__9943;
var map__9944__$1 = cljs.core.__destructure_map(map__9944);
var ast = map__9944__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9944__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9944__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9944__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__9945 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__9945__$1 = cljs.core.__destructure_map(map__9945);
var cenv = map__9945__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9945__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4212__auto__ = js_module_name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__9946 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4210__auto__ = (function (){var G__9947 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__9947) : cljs.compiler.es5_GT__EQ_.call(null,G__9947));
})();
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4210__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__9946,cljs.analyzer.es5_allowed);
} else {
return G__9946;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4212__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__9948 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__9948,reserved);
} else {
return G__9948;
}
})();
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__9949_9950 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__9949_9951__$1 = (((G__9949_9950 instanceof cljs.core.Keyword))?G__9949_9950.fqn:null);
switch (G__9949_9951__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4210__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__9953){
var map__9954 = p__9953;
var map__9954__$1 = cljs.core.__destructure_map(map__9954);
var arg = map__9954__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9954__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9954__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9954__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9954__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__9955 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__9955__$1 = cljs.core.__destructure_map(map__9955);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9955__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__9956){
var map__9957 = p__9956;
var map__9957__$1 = cljs.core.__destructure_map(map__9957);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9957__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9957__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9957__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__9958_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__9958_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__9959 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9959) : comma_sep.call(null,G__9959));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__9960 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9960) : comma_sep.call(null,G__9960));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__9961){
var map__9962 = p__9961;
var map__9962__$1 = cljs.core.__destructure_map(map__9962);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9962__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9962__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9962__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__9963){
var map__9964 = p__9963;
var map__9964__$1 = cljs.core.__destructure_map(map__9964);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9964__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9964__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__9965_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__9965_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__9966 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9966) : comma_sep.call(null,G__9966));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__9967){
var map__9968 = p__9967;
var map__9968__$1 = cljs.core.__destructure_map(map__9968);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9968__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9968__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___9991 = cljs.core.seq(items);
if(temp__5753__auto___9991){
var items_9992__$1 = temp__5753__auto___9991;
var vec__9969_9993 = items_9992__$1;
var seq__9970_9994 = cljs.core.seq(vec__9969_9993);
var first__9971_9995 = cljs.core.first(seq__9970_9994);
var seq__9970_9996__$1 = cljs.core.next(seq__9970_9994);
var vec__9972_9997 = first__9971_9995;
var k_9998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9972_9997,(0),null);
var v_9999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9972_9997,(1),null);
var r_10000 = seq__9970_9996__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_9998),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9999) : emit_js_object_val.call(null,v_9999)));

var seq__9975_10001 = cljs.core.seq(r_10000);
var chunk__9976_10002 = null;
var count__9977_10003 = (0);
var i__9978_10004 = (0);
while(true){
if((i__9978_10004 < count__9977_10003)){
var vec__9985_10005 = chunk__9976_10002.cljs$core$IIndexed$_nth$arity$2(null,i__9978_10004);
var k_10006__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9985_10005,(0),null);
var v_10007__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9985_10005,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10006__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10007__$1) : emit_js_object_val.call(null,v_10007__$1)));


var G__10008 = seq__9975_10001;
var G__10009 = chunk__9976_10002;
var G__10010 = count__9977_10003;
var G__10011 = (i__9978_10004 + (1));
seq__9975_10001 = G__10008;
chunk__9976_10002 = G__10009;
count__9977_10003 = G__10010;
i__9978_10004 = G__10011;
continue;
} else {
var temp__5753__auto___10012__$1 = cljs.core.seq(seq__9975_10001);
if(temp__5753__auto___10012__$1){
var seq__9975_10013__$1 = temp__5753__auto___10012__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9975_10013__$1)){
var c__4638__auto___10014 = cljs.core.chunk_first(seq__9975_10013__$1);
var G__10015 = cljs.core.chunk_rest(seq__9975_10013__$1);
var G__10016 = c__4638__auto___10014;
var G__10017 = cljs.core.count(c__4638__auto___10014);
var G__10018 = (0);
seq__9975_10001 = G__10015;
chunk__9976_10002 = G__10016;
count__9977_10003 = G__10017;
i__9978_10004 = G__10018;
continue;
} else {
var vec__9988_10019 = cljs.core.first(seq__9975_10013__$1);
var k_10020__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9988_10019,(0),null);
var v_10021__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9988_10019,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10020__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10021__$1) : emit_js_object_val.call(null,v_10021__$1)));


var G__10022 = cljs.core.next(seq__9975_10013__$1);
var G__10023 = null;
var G__10024 = (0);
var G__10025 = (0);
seq__9975_10001 = G__10022;
chunk__9976_10002 = G__10023;
count__9977_10003 = G__10024;
i__9978_10004 = G__10025;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__10026){
var map__10027 = p__10026;
var map__10027__$1 = cljs.core.__destructure_map(map__10027);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10027__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10027__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10027__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__10028){
var map__10029 = p__10028;
var map__10029__$1 = cljs.core.__destructure_map(map__10029);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10029__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10029__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__10030){
var map__10031 = p__10030;
var map__10031__$1 = cljs.core.__destructure_map(map__10031);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10031__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__10032){
var map__10033 = p__10032;
var map__10033__$1 = cljs.core.__destructure_map(map__10033);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10033__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10033__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__10034 = cljs.analyzer.unwrap_quote(expr);
var map__10034__$1 = cljs.core.__destructure_map(map__10034);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10034__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10034__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10034__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4210__auto__){
var and__4210__auto____$1 = form;
if(cljs.core.truth_(and__4210__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__10035 = cljs.analyzer.unwrap_quote(expr);
var map__10035__$1 = cljs.core.__destructure_map(map__10035);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10035__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10035__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10035__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4212__auto__ = (function (){var fexpr__10036 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__10036.cljs$core$IFn$_invoke$arity$1 ? fexpr__10036.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10036.call(null,tag));
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__10037){
var map__10038 = p__10037;
var map__10038__$1 = cljs.core.__destructure_map(map__10038);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10038__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10038__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10038__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10038__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10038__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4212__auto__ = unchecked;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__10039){
var map__10040 = p__10039;
var map__10040__$1 = cljs.core.__destructure_map(map__10040);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10040__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10040__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10040__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10040__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__10041_10069 = cljs.core.seq(nodes);
var chunk__10042_10070 = null;
var count__10043_10071 = (0);
var i__10044_10072 = (0);
while(true){
if((i__10044_10072 < count__10043_10071)){
var map__10057_10073 = chunk__10042_10070.cljs$core$IIndexed$_nth$arity$2(null,i__10044_10072);
var map__10057_10074__$1 = cljs.core.__destructure_map(map__10057_10073);
var ts_10075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10057_10074__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__10058_10076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10057_10074__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__10058_10077__$1 = cljs.core.__destructure_map(map__10058_10076);
var then_10078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10058_10077__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__10059_10079 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_10075));
var chunk__10060_10080 = null;
var count__10061_10081 = (0);
var i__10062_10082 = (0);
while(true){
if((i__10062_10082 < count__10061_10081)){
var test_10083 = chunk__10060_10080.cljs$core$IIndexed$_nth$arity$2(null,i__10062_10082);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10083,":");


var G__10084 = seq__10059_10079;
var G__10085 = chunk__10060_10080;
var G__10086 = count__10061_10081;
var G__10087 = (i__10062_10082 + (1));
seq__10059_10079 = G__10084;
chunk__10060_10080 = G__10085;
count__10061_10081 = G__10086;
i__10062_10082 = G__10087;
continue;
} else {
var temp__5753__auto___10088 = cljs.core.seq(seq__10059_10079);
if(temp__5753__auto___10088){
var seq__10059_10089__$1 = temp__5753__auto___10088;
if(cljs.core.chunked_seq_QMARK_(seq__10059_10089__$1)){
var c__4638__auto___10090 = cljs.core.chunk_first(seq__10059_10089__$1);
var G__10091 = cljs.core.chunk_rest(seq__10059_10089__$1);
var G__10092 = c__4638__auto___10090;
var G__10093 = cljs.core.count(c__4638__auto___10090);
var G__10094 = (0);
seq__10059_10079 = G__10091;
chunk__10060_10080 = G__10092;
count__10061_10081 = G__10093;
i__10062_10082 = G__10094;
continue;
} else {
var test_10095 = cljs.core.first(seq__10059_10089__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10095,":");


var G__10096 = cljs.core.next(seq__10059_10089__$1);
var G__10097 = null;
var G__10098 = (0);
var G__10099 = (0);
seq__10059_10079 = G__10096;
chunk__10060_10080 = G__10097;
count__10061_10081 = G__10098;
i__10062_10082 = G__10099;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10078);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10078);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10100 = seq__10041_10069;
var G__10101 = chunk__10042_10070;
var G__10102 = count__10043_10071;
var G__10103 = (i__10044_10072 + (1));
seq__10041_10069 = G__10100;
chunk__10042_10070 = G__10101;
count__10043_10071 = G__10102;
i__10044_10072 = G__10103;
continue;
} else {
var temp__5753__auto___10104 = cljs.core.seq(seq__10041_10069);
if(temp__5753__auto___10104){
var seq__10041_10105__$1 = temp__5753__auto___10104;
if(cljs.core.chunked_seq_QMARK_(seq__10041_10105__$1)){
var c__4638__auto___10106 = cljs.core.chunk_first(seq__10041_10105__$1);
var G__10107 = cljs.core.chunk_rest(seq__10041_10105__$1);
var G__10108 = c__4638__auto___10106;
var G__10109 = cljs.core.count(c__4638__auto___10106);
var G__10110 = (0);
seq__10041_10069 = G__10107;
chunk__10042_10070 = G__10108;
count__10043_10071 = G__10109;
i__10044_10072 = G__10110;
continue;
} else {
var map__10063_10111 = cljs.core.first(seq__10041_10105__$1);
var map__10063_10112__$1 = cljs.core.__destructure_map(map__10063_10111);
var ts_10113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10063_10112__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__10064_10114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10063_10112__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__10064_10115__$1 = cljs.core.__destructure_map(map__10064_10114);
var then_10116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10064_10115__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__10065_10117 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_10113));
var chunk__10066_10118 = null;
var count__10067_10119 = (0);
var i__10068_10120 = (0);
while(true){
if((i__10068_10120 < count__10067_10119)){
var test_10121 = chunk__10066_10118.cljs$core$IIndexed$_nth$arity$2(null,i__10068_10120);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10121,":");


var G__10122 = seq__10065_10117;
var G__10123 = chunk__10066_10118;
var G__10124 = count__10067_10119;
var G__10125 = (i__10068_10120 + (1));
seq__10065_10117 = G__10122;
chunk__10066_10118 = G__10123;
count__10067_10119 = G__10124;
i__10068_10120 = G__10125;
continue;
} else {
var temp__5753__auto___10126__$1 = cljs.core.seq(seq__10065_10117);
if(temp__5753__auto___10126__$1){
var seq__10065_10127__$1 = temp__5753__auto___10126__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10065_10127__$1)){
var c__4638__auto___10128 = cljs.core.chunk_first(seq__10065_10127__$1);
var G__10129 = cljs.core.chunk_rest(seq__10065_10127__$1);
var G__10130 = c__4638__auto___10128;
var G__10131 = cljs.core.count(c__4638__auto___10128);
var G__10132 = (0);
seq__10065_10117 = G__10129;
chunk__10066_10118 = G__10130;
count__10067_10119 = G__10131;
i__10068_10120 = G__10132;
continue;
} else {
var test_10133 = cljs.core.first(seq__10065_10127__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10133,":");


var G__10134 = cljs.core.next(seq__10065_10127__$1);
var G__10135 = null;
var G__10136 = (0);
var G__10137 = (0);
seq__10065_10117 = G__10134;
chunk__10066_10118 = G__10135;
count__10067_10119 = G__10136;
i__10068_10120 = G__10137;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10116);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10116);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10138 = cljs.core.next(seq__10041_10105__$1);
var G__10139 = null;
var G__10140 = (0);
var G__10141 = (0);
seq__10041_10069 = G__10138;
chunk__10042_10070 = G__10139;
count__10043_10071 = G__10140;
i__10044_10072 = G__10141;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__10142){
var map__10143 = p__10142;
var map__10143__$1 = cljs.core.__destructure_map(map__10143);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10143__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10143__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10147 = env;
var G__10148 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10147,G__10148) : cljs.compiler.resolve_type.call(null,G__10147,G__10148));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__10149 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10149,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10149,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__10144_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__10144_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__10144_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__10152 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__10152,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__10152;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10155 = env;
var G__10156 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10155,G__10156) : cljs.compiler.resolve_type.call(null,G__10155,G__10156));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10157_SHARP_){
return cljs.compiler.resolve_type(env,p1__10157_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__10158 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10159 = cljs.core.seq(vec__10158);
var first__10160 = cljs.core.first(seq__10159);
var seq__10159__$1 = cljs.core.next(seq__10159);
var p = first__10160;
var first__10160__$1 = cljs.core.first(seq__10159__$1);
var seq__10159__$2 = cljs.core.next(seq__10159__$1);
var ts = first__10160__$1;
var first__10160__$2 = cljs.core.first(seq__10159__$2);
var seq__10159__$3 = cljs.core.next(seq__10159__$2);
var n = first__10160__$2;
var xs = seq__10159__$3;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__10161 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10162 = cljs.core.seq(vec__10161);
var first__10163 = cljs.core.first(seq__10162);
var seq__10162__$1 = cljs.core.next(seq__10162);
var p = first__10163;
var first__10163__$1 = cljs.core.first(seq__10162__$1);
var seq__10162__$2 = cljs.core.next(seq__10162__$1);
var ts = first__10163__$1;
var xs = seq__10162__$2;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__10165 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__10164 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__10164.cljs$core$IFn$_invoke$arity$1 ? fexpr__10164.cljs$core$IFn$_invoke$arity$1(G__10165) : fexpr__10164.call(null,G__10165));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__10168 = arguments.length;
switch (G__10168) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__10176 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10166_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__10166_SHARP_);
} else {
return p1__10166_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__10177 = cljs.core.seq(vec__10176);
var first__10178 = cljs.core.first(seq__10177);
var seq__10177__$1 = cljs.core.next(seq__10177);
var x = first__10178;
var ys = seq__10177__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__10179 = cljs.core.seq(ys);
var chunk__10180 = null;
var count__10181 = (0);
var i__10182 = (0);
while(true){
if((i__10182 < count__10181)){
var next_line = chunk__10180.cljs$core$IIndexed$_nth$arity$2(null,i__10182);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10188 = seq__10179;
var G__10189 = chunk__10180;
var G__10190 = count__10181;
var G__10191 = (i__10182 + (1));
seq__10179 = G__10188;
chunk__10180 = G__10189;
count__10181 = G__10190;
i__10182 = G__10191;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10179);
if(temp__5753__auto__){
var seq__10179__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10179__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10179__$1);
var G__10192 = cljs.core.chunk_rest(seq__10179__$1);
var G__10193 = c__4638__auto__;
var G__10194 = cljs.core.count(c__4638__auto__);
var G__10195 = (0);
seq__10179 = G__10192;
chunk__10180 = G__10193;
count__10181 = G__10194;
i__10182 = G__10195;
continue;
} else {
var next_line = cljs.core.first(seq__10179__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10196 = cljs.core.next(seq__10179__$1);
var G__10197 = null;
var G__10198 = (0);
var G__10199 = (0);
seq__10179 = G__10196;
chunk__10180 = G__10197;
count__10181 = G__10198;
i__10182 = G__10199;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__10183_10200 = cljs.core.seq(docs__$2);
var chunk__10184_10201 = null;
var count__10185_10202 = (0);
var i__10186_10203 = (0);
while(true){
if((i__10186_10203 < count__10185_10202)){
var e_10204 = chunk__10184_10201.cljs$core$IIndexed$_nth$arity$2(null,i__10186_10203);
if(cljs.core.truth_(e_10204)){
print_comment_lines(e_10204);
} else {
}


var G__10205 = seq__10183_10200;
var G__10206 = chunk__10184_10201;
var G__10207 = count__10185_10202;
var G__10208 = (i__10186_10203 + (1));
seq__10183_10200 = G__10205;
chunk__10184_10201 = G__10206;
count__10185_10202 = G__10207;
i__10186_10203 = G__10208;
continue;
} else {
var temp__5753__auto___10209 = cljs.core.seq(seq__10183_10200);
if(temp__5753__auto___10209){
var seq__10183_10210__$1 = temp__5753__auto___10209;
if(cljs.core.chunked_seq_QMARK_(seq__10183_10210__$1)){
var c__4638__auto___10211 = cljs.core.chunk_first(seq__10183_10210__$1);
var G__10212 = cljs.core.chunk_rest(seq__10183_10210__$1);
var G__10213 = c__4638__auto___10211;
var G__10214 = cljs.core.count(c__4638__auto___10211);
var G__10215 = (0);
seq__10183_10200 = G__10212;
chunk__10184_10201 = G__10213;
count__10185_10202 = G__10214;
i__10186_10203 = G__10215;
continue;
} else {
var e_10216 = cljs.core.first(seq__10183_10210__$1);
if(cljs.core.truth_(e_10216)){
print_comment_lines(e_10216);
} else {
}


var G__10217 = cljs.core.next(seq__10183_10210__$1);
var G__10218 = null;
var G__10219 = (0);
var G__10220 = (0);
seq__10183_10200 = G__10217;
chunk__10184_10201 = G__10218;
count__10185_10202 = G__10219;
i__10186_10203 = G__10220;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4210__auto__ = cljs.core.some((function (p1__10222_SHARP_){
return goog.string.startsWith(p1__10222_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = opts;
if(cljs.core.truth_(and__4210__auto____$1)){
var and__4210__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4210__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4210__auto____$2;
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__10223){
var map__10224 = p__10223;
var map__10224__$1 = cljs.core.__destructure_map(map__10224);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10224__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4212__auto__ = init;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return test;
} else {
return and__4210__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__10225){
var map__10226 = p__10225;
var map__10226__$1 = cljs.core.__destructure_map(map__10226);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10226__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10226__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10226__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__10227_10251 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__10228_10252 = null;
var count__10229_10253 = (0);
var i__10230_10254 = (0);
while(true){
if((i__10230_10254 < count__10229_10253)){
var vec__10237_10255 = chunk__10228_10252.cljs$core$IIndexed$_nth$arity$2(null,i__10230_10254);
var i_10256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10237_10255,(0),null);
var param_10257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10237_10255,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10257);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10258 = seq__10227_10251;
var G__10259 = chunk__10228_10252;
var G__10260 = count__10229_10253;
var G__10261 = (i__10230_10254 + (1));
seq__10227_10251 = G__10258;
chunk__10228_10252 = G__10259;
count__10229_10253 = G__10260;
i__10230_10254 = G__10261;
continue;
} else {
var temp__5753__auto___10262 = cljs.core.seq(seq__10227_10251);
if(temp__5753__auto___10262){
var seq__10227_10263__$1 = temp__5753__auto___10262;
if(cljs.core.chunked_seq_QMARK_(seq__10227_10263__$1)){
var c__4638__auto___10264 = cljs.core.chunk_first(seq__10227_10263__$1);
var G__10265 = cljs.core.chunk_rest(seq__10227_10263__$1);
var G__10266 = c__4638__auto___10264;
var G__10267 = cljs.core.count(c__4638__auto___10264);
var G__10268 = (0);
seq__10227_10251 = G__10265;
chunk__10228_10252 = G__10266;
count__10229_10253 = G__10267;
i__10230_10254 = G__10268;
continue;
} else {
var vec__10240_10269 = cljs.core.first(seq__10227_10263__$1);
var i_10270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10240_10269,(0),null);
var param_10271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10240_10269,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10271);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10272 = cljs.core.next(seq__10227_10263__$1);
var G__10273 = null;
var G__10274 = (0);
var G__10275 = (0);
seq__10227_10251 = G__10272;
chunk__10228_10252 = G__10273;
count__10229_10253 = G__10274;
i__10230_10254 = G__10275;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10243_10276 = cljs.core.seq(params);
var chunk__10244_10277 = null;
var count__10245_10278 = (0);
var i__10246_10279 = (0);
while(true){
if((i__10246_10279 < count__10245_10278)){
var param_10280 = chunk__10244_10277.cljs$core$IIndexed$_nth$arity$2(null,i__10246_10279);
cljs.compiler.emit(param_10280);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10280,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10281 = seq__10243_10276;
var G__10282 = chunk__10244_10277;
var G__10283 = count__10245_10278;
var G__10284 = (i__10246_10279 + (1));
seq__10243_10276 = G__10281;
chunk__10244_10277 = G__10282;
count__10245_10278 = G__10283;
i__10246_10279 = G__10284;
continue;
} else {
var temp__5753__auto___10285 = cljs.core.seq(seq__10243_10276);
if(temp__5753__auto___10285){
var seq__10243_10286__$1 = temp__5753__auto___10285;
if(cljs.core.chunked_seq_QMARK_(seq__10243_10286__$1)){
var c__4638__auto___10287 = cljs.core.chunk_first(seq__10243_10286__$1);
var G__10288 = cljs.core.chunk_rest(seq__10243_10286__$1);
var G__10289 = c__4638__auto___10287;
var G__10290 = cljs.core.count(c__4638__auto___10287);
var G__10291 = (0);
seq__10243_10276 = G__10288;
chunk__10244_10277 = G__10289;
count__10245_10278 = G__10290;
i__10246_10279 = G__10291;
continue;
} else {
var param_10292 = cljs.core.first(seq__10243_10286__$1);
cljs.compiler.emit(param_10292);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10292,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10293 = cljs.core.next(seq__10243_10286__$1);
var G__10294 = null;
var G__10295 = (0);
var G__10296 = (0);
seq__10243_10276 = G__10293;
chunk__10244_10277 = G__10294;
count__10245_10278 = G__10295;
i__10246_10279 = G__10296;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10247_10297 = cljs.core.seq(params);
var chunk__10248_10298 = null;
var count__10249_10299 = (0);
var i__10250_10300 = (0);
while(true){
if((i__10250_10300 < count__10249_10299)){
var param_10301 = chunk__10248_10298.cljs$core$IIndexed$_nth$arity$2(null,i__10250_10300);
cljs.compiler.emit(param_10301);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10301,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10302 = seq__10247_10297;
var G__10303 = chunk__10248_10298;
var G__10304 = count__10249_10299;
var G__10305 = (i__10250_10300 + (1));
seq__10247_10297 = G__10302;
chunk__10248_10298 = G__10303;
count__10249_10299 = G__10304;
i__10250_10300 = G__10305;
continue;
} else {
var temp__5753__auto___10306 = cljs.core.seq(seq__10247_10297);
if(temp__5753__auto___10306){
var seq__10247_10307__$1 = temp__5753__auto___10306;
if(cljs.core.chunked_seq_QMARK_(seq__10247_10307__$1)){
var c__4638__auto___10308 = cljs.core.chunk_first(seq__10247_10307__$1);
var G__10309 = cljs.core.chunk_rest(seq__10247_10307__$1);
var G__10310 = c__4638__auto___10308;
var G__10311 = cljs.core.count(c__4638__auto___10308);
var G__10312 = (0);
seq__10247_10297 = G__10309;
chunk__10248_10298 = G__10310;
count__10249_10299 = G__10311;
i__10250_10300 = G__10312;
continue;
} else {
var param_10313 = cljs.core.first(seq__10247_10307__$1);
cljs.compiler.emit(param_10313);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10313,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10314 = cljs.core.next(seq__10247_10307__$1);
var G__10315 = null;
var G__10316 = (0);
var G__10317 = (0);
seq__10247_10297 = G__10314;
chunk__10248_10298 = G__10315;
count__10249_10299 = G__10316;
i__10250_10300 = G__10317;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__10318 = cljs.core.seq(params);
var chunk__10319 = null;
var count__10320 = (0);
var i__10321 = (0);
while(true){
if((i__10321 < count__10320)){
var param = chunk__10319.cljs$core$IIndexed$_nth$arity$2(null,i__10321);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10322 = seq__10318;
var G__10323 = chunk__10319;
var G__10324 = count__10320;
var G__10325 = (i__10321 + (1));
seq__10318 = G__10322;
chunk__10319 = G__10323;
count__10320 = G__10324;
i__10321 = G__10325;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10318);
if(temp__5753__auto__){
var seq__10318__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10318__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10318__$1);
var G__10326 = cljs.core.chunk_rest(seq__10318__$1);
var G__10327 = c__4638__auto__;
var G__10328 = cljs.core.count(c__4638__auto__);
var G__10329 = (0);
seq__10318 = G__10326;
chunk__10319 = G__10327;
count__10320 = G__10328;
i__10321 = G__10329;
continue;
} else {
var param = cljs.core.first(seq__10318__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10330 = cljs.core.next(seq__10318__$1);
var G__10331 = null;
var G__10332 = (0);
var G__10333 = (0);
seq__10318 = G__10330;
chunk__10319 = G__10331;
count__10320 = G__10332;
i__10321 = G__10333;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__10334){
var map__10335 = p__10334;
var map__10335__$1 = cljs.core.__destructure_map(map__10335);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10335__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__10336){
var map__10337 = p__10336;
var map__10337__$1 = cljs.core.__destructure_map(map__10337);
var f = map__10337__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10337__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_10346__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10347 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10346__$1);
var delegate_name_10348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10347),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_10348," = function (");

var seq__10338_10349 = cljs.core.seq(params);
var chunk__10339_10350 = null;
var count__10340_10351 = (0);
var i__10341_10352 = (0);
while(true){
if((i__10341_10352 < count__10340_10351)){
var param_10353 = chunk__10339_10350.cljs$core$IIndexed$_nth$arity$2(null,i__10341_10352);
cljs.compiler.emit(param_10353);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10353,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10354 = seq__10338_10349;
var G__10355 = chunk__10339_10350;
var G__10356 = count__10340_10351;
var G__10357 = (i__10341_10352 + (1));
seq__10338_10349 = G__10354;
chunk__10339_10350 = G__10355;
count__10340_10351 = G__10356;
i__10341_10352 = G__10357;
continue;
} else {
var temp__5753__auto___10358 = cljs.core.seq(seq__10338_10349);
if(temp__5753__auto___10358){
var seq__10338_10359__$1 = temp__5753__auto___10358;
if(cljs.core.chunked_seq_QMARK_(seq__10338_10359__$1)){
var c__4638__auto___10360 = cljs.core.chunk_first(seq__10338_10359__$1);
var G__10361 = cljs.core.chunk_rest(seq__10338_10359__$1);
var G__10362 = c__4638__auto___10360;
var G__10363 = cljs.core.count(c__4638__auto___10360);
var G__10364 = (0);
seq__10338_10349 = G__10361;
chunk__10339_10350 = G__10362;
count__10340_10351 = G__10363;
i__10341_10352 = G__10364;
continue;
} else {
var param_10365 = cljs.core.first(seq__10338_10359__$1);
cljs.compiler.emit(param_10365);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10365,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10366 = cljs.core.next(seq__10338_10359__$1);
var G__10367 = null;
var G__10368 = (0);
var G__10369 = (0);
seq__10338_10349 = G__10366;
chunk__10339_10350 = G__10367;
count__10340_10351 = G__10368;
i__10341_10352 = G__10369;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_10347," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_10370 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_10370,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_10348,".call(this,");

var seq__10342_10371 = cljs.core.seq(params);
var chunk__10343_10372 = null;
var count__10344_10373 = (0);
var i__10345_10374 = (0);
while(true){
if((i__10345_10374 < count__10344_10373)){
var param_10375 = chunk__10343_10372.cljs$core$IIndexed$_nth$arity$2(null,i__10345_10374);
cljs.compiler.emit(param_10375);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10375,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10376 = seq__10342_10371;
var G__10377 = chunk__10343_10372;
var G__10378 = count__10344_10373;
var G__10379 = (i__10345_10374 + (1));
seq__10342_10371 = G__10376;
chunk__10343_10372 = G__10377;
count__10344_10373 = G__10378;
i__10345_10374 = G__10379;
continue;
} else {
var temp__5753__auto___10380 = cljs.core.seq(seq__10342_10371);
if(temp__5753__auto___10380){
var seq__10342_10381__$1 = temp__5753__auto___10380;
if(cljs.core.chunked_seq_QMARK_(seq__10342_10381__$1)){
var c__4638__auto___10382 = cljs.core.chunk_first(seq__10342_10381__$1);
var G__10383 = cljs.core.chunk_rest(seq__10342_10381__$1);
var G__10384 = c__4638__auto___10382;
var G__10385 = cljs.core.count(c__4638__auto___10382);
var G__10386 = (0);
seq__10342_10371 = G__10383;
chunk__10343_10372 = G__10384;
count__10344_10373 = G__10385;
i__10345_10374 = G__10386;
continue;
} else {
var param_10387 = cljs.core.first(seq__10342_10381__$1);
cljs.compiler.emit(param_10387);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10387,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10388 = cljs.core.next(seq__10342_10381__$1);
var G__10389 = null;
var G__10390 = (0);
var G__10391 = (0);
seq__10342_10371 = G__10388;
chunk__10343_10372 = G__10389;
count__10344_10373 = G__10390;
i__10345_10374 = G__10391;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10347,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_10347,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_10346__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10347,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_10348,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10347,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__10395){
var map__10396 = p__10395;
var map__10396__$1 = cljs.core.__destructure_map(map__10396);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10392_SHARP_){
var and__4210__auto__ = p1__10392_SHARP_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__10392_SHARP_));
} else {
return and__4210__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4212__auto__ = in_loop;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_10448__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10449 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10448__$1);
var maxparams_10450 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_10451 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10449),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_10452 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__10393_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__10393_SHARP_)));
}),cljs.core.seq(mmap_10451));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_10449," = null;");

var seq__10397_10453 = cljs.core.seq(ms_10452);
var chunk__10398_10454 = null;
var count__10399_10455 = (0);
var i__10400_10456 = (0);
while(true){
if((i__10400_10456 < count__10399_10455)){
var vec__10407_10457 = chunk__10398_10454.cljs$core$IIndexed$_nth$arity$2(null,i__10400_10456);
var n_10458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10407_10457,(0),null);
var meth_10459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10407_10457,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10458," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10459))){
cljs.compiler.emit_variadic_fn_method(meth_10459);
} else {
cljs.compiler.emit_fn_method(meth_10459);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10460 = seq__10397_10453;
var G__10461 = chunk__10398_10454;
var G__10462 = count__10399_10455;
var G__10463 = (i__10400_10456 + (1));
seq__10397_10453 = G__10460;
chunk__10398_10454 = G__10461;
count__10399_10455 = G__10462;
i__10400_10456 = G__10463;
continue;
} else {
var temp__5753__auto___10464 = cljs.core.seq(seq__10397_10453);
if(temp__5753__auto___10464){
var seq__10397_10465__$1 = temp__5753__auto___10464;
if(cljs.core.chunked_seq_QMARK_(seq__10397_10465__$1)){
var c__4638__auto___10466 = cljs.core.chunk_first(seq__10397_10465__$1);
var G__10467 = cljs.core.chunk_rest(seq__10397_10465__$1);
var G__10468 = c__4638__auto___10466;
var G__10469 = cljs.core.count(c__4638__auto___10466);
var G__10470 = (0);
seq__10397_10453 = G__10467;
chunk__10398_10454 = G__10468;
count__10399_10455 = G__10469;
i__10400_10456 = G__10470;
continue;
} else {
var vec__10410_10471 = cljs.core.first(seq__10397_10465__$1);
var n_10472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10410_10471,(0),null);
var meth_10473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10410_10471,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10472," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10473))){
cljs.compiler.emit_variadic_fn_method(meth_10473);
} else {
cljs.compiler.emit_fn_method(meth_10473);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10474 = cljs.core.next(seq__10397_10465__$1);
var G__10475 = null;
var G__10476 = (0);
var G__10477 = (0);
seq__10397_10453 = G__10474;
chunk__10398_10454 = G__10475;
count__10399_10455 = G__10476;
i__10400_10456 = G__10477;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10449," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_10450),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_10450)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_10450));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__10413_10478 = cljs.core.seq(ms_10452);
var chunk__10414_10479 = null;
var count__10415_10480 = (0);
var i__10416_10481 = (0);
while(true){
if((i__10416_10481 < count__10415_10480)){
var vec__10423_10482 = chunk__10414_10479.cljs$core$IIndexed$_nth$arity$2(null,i__10416_10481);
var n_10483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10423_10482,(0),null);
var meth_10484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10423_10482,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10484))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10485 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10485," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10486 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10485," = new cljs.core.IndexedSeq(",a_10486,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10483,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10450)),(((cljs.core.count(maxparams_10450) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10485,");"], 0));
} else {
var pcnt_10487 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_10484));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10487,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10483,".call(this",(((pcnt_10487 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10487,maxparams_10450)),null,(1),null)),(2),null))),");");
}


var G__10488 = seq__10413_10478;
var G__10489 = chunk__10414_10479;
var G__10490 = count__10415_10480;
var G__10491 = (i__10416_10481 + (1));
seq__10413_10478 = G__10488;
chunk__10414_10479 = G__10489;
count__10415_10480 = G__10490;
i__10416_10481 = G__10491;
continue;
} else {
var temp__5753__auto___10492 = cljs.core.seq(seq__10413_10478);
if(temp__5753__auto___10492){
var seq__10413_10493__$1 = temp__5753__auto___10492;
if(cljs.core.chunked_seq_QMARK_(seq__10413_10493__$1)){
var c__4638__auto___10494 = cljs.core.chunk_first(seq__10413_10493__$1);
var G__10495 = cljs.core.chunk_rest(seq__10413_10493__$1);
var G__10496 = c__4638__auto___10494;
var G__10497 = cljs.core.count(c__4638__auto___10494);
var G__10498 = (0);
seq__10413_10478 = G__10495;
chunk__10414_10479 = G__10496;
count__10415_10480 = G__10497;
i__10416_10481 = G__10498;
continue;
} else {
var vec__10426_10499 = cljs.core.first(seq__10413_10493__$1);
var n_10500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10426_10499,(0),null);
var meth_10501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10426_10499,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10501))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10502 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10502," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10503 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10502," = new cljs.core.IndexedSeq(",a_10503,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10500,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10450)),(((cljs.core.count(maxparams_10450) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10502,");"], 0));
} else {
var pcnt_10504 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_10501));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10504,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10500,".call(this",(((pcnt_10504 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10504,maxparams_10450)),null,(1),null)),(2),null))),");");
}


var G__10505 = cljs.core.next(seq__10413_10493__$1);
var G__10506 = null;
var G__10507 = (0);
var G__10508 = (0);
seq__10413_10478 = G__10505;
chunk__10414_10479 = G__10506;
count__10415_10480 = G__10507;
i__10416_10481 = G__10508;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_10509 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_10452)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_10509,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10449,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10449,".cljs$lang$applyTo = ",cljs.core.some((function (p1__10394_SHARP_){
var vec__10429 = p1__10394_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10429,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10429,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_10452),".cljs$lang$applyTo;");
} else {
}

var seq__10432_10510 = cljs.core.seq(ms_10452);
var chunk__10433_10511 = null;
var count__10434_10512 = (0);
var i__10435_10513 = (0);
while(true){
if((i__10435_10513 < count__10434_10512)){
var vec__10442_10514 = chunk__10433_10511.cljs$core$IIndexed$_nth$arity$2(null,i__10435_10513);
var n_10515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10442_10514,(0),null);
var meth_10516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10442_10514,(1),null);
var c_10517 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_10516));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10516))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10449,".cljs$core$IFn$_invoke$arity$variadic = ",n_10515,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10449,".cljs$core$IFn$_invoke$arity$",c_10517," = ",n_10515,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10518 = seq__10432_10510;
var G__10519 = chunk__10433_10511;
var G__10520 = count__10434_10512;
var G__10521 = (i__10435_10513 + (1));
seq__10432_10510 = G__10518;
chunk__10433_10511 = G__10519;
count__10434_10512 = G__10520;
i__10435_10513 = G__10521;
continue;
} else {
var temp__5753__auto___10522 = cljs.core.seq(seq__10432_10510);
if(temp__5753__auto___10522){
var seq__10432_10523__$1 = temp__5753__auto___10522;
if(cljs.core.chunked_seq_QMARK_(seq__10432_10523__$1)){
var c__4638__auto___10524 = cljs.core.chunk_first(seq__10432_10523__$1);
var G__10525 = cljs.core.chunk_rest(seq__10432_10523__$1);
var G__10526 = c__4638__auto___10524;
var G__10527 = cljs.core.count(c__4638__auto___10524);
var G__10528 = (0);
seq__10432_10510 = G__10525;
chunk__10433_10511 = G__10526;
count__10434_10512 = G__10527;
i__10435_10513 = G__10528;
continue;
} else {
var vec__10445_10529 = cljs.core.first(seq__10432_10523__$1);
var n_10530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10445_10529,(0),null);
var meth_10531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10445_10529,(1),null);
var c_10532 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_10531));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_10531))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10449,".cljs$core$IFn$_invoke$arity$variadic = ",n_10530,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10449,".cljs$core$IFn$_invoke$arity$",c_10532," = ",n_10530,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10533 = cljs.core.next(seq__10432_10523__$1);
var G__10534 = null;
var G__10535 = (0);
var G__10536 = (0);
seq__10432_10510 = G__10533;
chunk__10433_10511 = G__10534;
count__10434_10512 = G__10535;
i__10435_10513 = G__10536;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10449,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__10537){
var map__10538 = p__10537;
var map__10538__$1 = cljs.core.__destructure_map(map__10538);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10538__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10538__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10539_10543 = cljs.core.seq(statements);
var chunk__10540_10544 = null;
var count__10541_10545 = (0);
var i__10542_10546 = (0);
while(true){
if((i__10542_10546 < count__10541_10545)){
var s_10547 = chunk__10540_10544.cljs$core$IIndexed$_nth$arity$2(null,i__10542_10546);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10547);


var G__10548 = seq__10539_10543;
var G__10549 = chunk__10540_10544;
var G__10550 = count__10541_10545;
var G__10551 = (i__10542_10546 + (1));
seq__10539_10543 = G__10548;
chunk__10540_10544 = G__10549;
count__10541_10545 = G__10550;
i__10542_10546 = G__10551;
continue;
} else {
var temp__5753__auto___10552 = cljs.core.seq(seq__10539_10543);
if(temp__5753__auto___10552){
var seq__10539_10553__$1 = temp__5753__auto___10552;
if(cljs.core.chunked_seq_QMARK_(seq__10539_10553__$1)){
var c__4638__auto___10554 = cljs.core.chunk_first(seq__10539_10553__$1);
var G__10555 = cljs.core.chunk_rest(seq__10539_10553__$1);
var G__10556 = c__4638__auto___10554;
var G__10557 = cljs.core.count(c__4638__auto___10554);
var G__10558 = (0);
seq__10539_10543 = G__10555;
chunk__10540_10544 = G__10556;
count__10541_10545 = G__10557;
i__10542_10546 = G__10558;
continue;
} else {
var s_10559 = cljs.core.first(seq__10539_10553__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10559);


var G__10560 = cljs.core.next(seq__10539_10553__$1);
var G__10561 = null;
var G__10562 = (0);
var G__10563 = (0);
seq__10539_10543 = G__10560;
chunk__10540_10544 = G__10561;
count__10541_10545 = G__10562;
i__10542_10546 = G__10563;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__10564){
var map__10565 = p__10564;
var map__10565__$1 = cljs.core.__destructure_map(map__10565);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10565__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10565__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10565__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10565__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10565__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__10566,is_loop){
var map__10567 = p__10566;
var map__10567__$1 = cljs.core.__destructure_map(map__10567);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10567__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10567__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10567__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__10568_10578 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__10569_10579 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__10569_10579);

try{var seq__10570_10580 = cljs.core.seq(bindings);
var chunk__10571_10581 = null;
var count__10572_10582 = (0);
var i__10573_10583 = (0);
while(true){
if((i__10573_10583 < count__10572_10582)){
var map__10576_10584 = chunk__10571_10581.cljs$core$IIndexed$_nth$arity$2(null,i__10573_10583);
var map__10576_10585__$1 = cljs.core.__destructure_map(map__10576_10584);
var binding_10586 = map__10576_10585__$1;
var init_10587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10576_10585__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10586);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10587,";");


var G__10588 = seq__10570_10580;
var G__10589 = chunk__10571_10581;
var G__10590 = count__10572_10582;
var G__10591 = (i__10573_10583 + (1));
seq__10570_10580 = G__10588;
chunk__10571_10581 = G__10589;
count__10572_10582 = G__10590;
i__10573_10583 = G__10591;
continue;
} else {
var temp__5753__auto___10592 = cljs.core.seq(seq__10570_10580);
if(temp__5753__auto___10592){
var seq__10570_10593__$1 = temp__5753__auto___10592;
if(cljs.core.chunked_seq_QMARK_(seq__10570_10593__$1)){
var c__4638__auto___10594 = cljs.core.chunk_first(seq__10570_10593__$1);
var G__10595 = cljs.core.chunk_rest(seq__10570_10593__$1);
var G__10596 = c__4638__auto___10594;
var G__10597 = cljs.core.count(c__4638__auto___10594);
var G__10598 = (0);
seq__10570_10580 = G__10595;
chunk__10571_10581 = G__10596;
count__10572_10582 = G__10597;
i__10573_10583 = G__10598;
continue;
} else {
var map__10577_10599 = cljs.core.first(seq__10570_10593__$1);
var map__10577_10600__$1 = cljs.core.__destructure_map(map__10577_10599);
var binding_10601 = map__10577_10600__$1;
var init_10602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10577_10600__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10601);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10602,";");


var G__10603 = cljs.core.next(seq__10570_10593__$1);
var G__10604 = null;
var G__10605 = (0);
var G__10606 = (0);
seq__10570_10580 = G__10603;
chunk__10571_10581 = G__10604;
count__10572_10582 = G__10605;
i__10573_10583 = G__10606;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__10568_10578);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__10607){
var map__10608 = p__10607;
var map__10608__$1 = cljs.core.__destructure_map(map__10608);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10608__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10608__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10608__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4695__auto___10609 = cljs.core.count(exprs);
var i_10610 = (0);
while(true){
if((i_10610 < n__4695__auto___10609)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10610) : temps.call(null,i_10610))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_10610) : exprs.call(null,i_10610)),";");

var G__10611 = (i_10610 + (1));
i_10610 = G__10611;
continue;
} else {
}
break;
}

var n__4695__auto___10612 = cljs.core.count(exprs);
var i_10613 = (0);
while(true){
if((i_10613 < n__4695__auto___10612)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_10613) : params.call(null,i_10613)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10613) : temps.call(null,i_10613)),";");

var G__10614 = (i_10613 + (1));
i_10613 = G__10614;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__10615){
var map__10616 = p__10615;
var map__10616__$1 = cljs.core.__destructure_map(map__10616);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10617_10625 = cljs.core.seq(bindings);
var chunk__10618_10626 = null;
var count__10619_10627 = (0);
var i__10620_10628 = (0);
while(true){
if((i__10620_10628 < count__10619_10627)){
var map__10623_10629 = chunk__10618_10626.cljs$core$IIndexed$_nth$arity$2(null,i__10620_10628);
var map__10623_10630__$1 = cljs.core.__destructure_map(map__10623_10629);
var binding_10631 = map__10623_10630__$1;
var init_10632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10623_10630__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10631)," = ",init_10632,";");


var G__10633 = seq__10617_10625;
var G__10634 = chunk__10618_10626;
var G__10635 = count__10619_10627;
var G__10636 = (i__10620_10628 + (1));
seq__10617_10625 = G__10633;
chunk__10618_10626 = G__10634;
count__10619_10627 = G__10635;
i__10620_10628 = G__10636;
continue;
} else {
var temp__5753__auto___10637 = cljs.core.seq(seq__10617_10625);
if(temp__5753__auto___10637){
var seq__10617_10638__$1 = temp__5753__auto___10637;
if(cljs.core.chunked_seq_QMARK_(seq__10617_10638__$1)){
var c__4638__auto___10639 = cljs.core.chunk_first(seq__10617_10638__$1);
var G__10640 = cljs.core.chunk_rest(seq__10617_10638__$1);
var G__10641 = c__4638__auto___10639;
var G__10642 = cljs.core.count(c__4638__auto___10639);
var G__10643 = (0);
seq__10617_10625 = G__10640;
chunk__10618_10626 = G__10641;
count__10619_10627 = G__10642;
i__10620_10628 = G__10643;
continue;
} else {
var map__10624_10644 = cljs.core.first(seq__10617_10638__$1);
var map__10624_10645__$1 = cljs.core.__destructure_map(map__10624_10644);
var binding_10646 = map__10624_10645__$1;
var init_10647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10624_10645__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10646)," = ",init_10647,";");


var G__10648 = cljs.core.next(seq__10617_10638__$1);
var G__10649 = null;
var G__10650 = (0);
var G__10651 = (0);
seq__10617_10625 = G__10648;
chunk__10618_10626 = G__10649;
count__10619_10627 = G__10650;
i__10620_10628 = G__10651;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__10654){
var map__10655 = p__10654;
var map__10655__$1 = cljs.core.__destructure_map(map__10655);
var expr = map__10655__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10655__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10655__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10655__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4210__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4210__auto__ = protocol;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = tag;
if(cljs.core.truth_(and__4210__auto____$1)){
var or__4212__auto__ = (function (){var and__4210__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto____$2)){
var and__4210__auto____$3 = protocol;
if(cljs.core.truth_(and__4210__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4210__auto____$3;
}
} else {
return and__4210__auto____$2;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto____$2 = (function (){var or__4212__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4210__auto____$2)){
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
var and__4210__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4210__auto____$3){
var and__4210__auto____$4 = cljs.core.not((function (){var fexpr__10659 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__10659.cljs$core$IFn$_invoke$arity$1 ? fexpr__10659.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10659.call(null,tag));
})());
if(and__4210__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4210__auto____$4;
}
} else {
return and__4210__auto____$3;
}
}
} else {
return and__4210__auto____$2;
}
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__10660 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__10660.cljs$core$IFn$_invoke$arity$1 ? fexpr__10660.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__10660.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__10656 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (arity > mfa);
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__10652_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10652_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__10653_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10653_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10656,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10656,(1),null);
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_10663 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_10663,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_10664 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_10664,args)),(((mfa_10664 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_10664,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var G__10662 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__10661 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__10661.cljs$core$IFn$_invoke$arity$1 ? fexpr__10661.cljs$core$IFn$_invoke$arity$1(G__10662) : fexpr__10661.call(null,G__10662));
} else {
return and__4210__auto__;
}
})())){
var fprop_10665 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10665," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10665,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10665," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10665,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__10666){
var map__10667 = p__10666;
var map__10667__$1 = cljs.core.__destructure_map(map__10667);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10667__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10667__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10667__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__10668){
var map__10669 = p__10668;
var map__10669__$1 = cljs.core.__destructure_map(map__10669);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10669__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10669__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10669__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10670_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10670_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__10671 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10671,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10671,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__10674 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10674__$1 = cljs.core.__destructure_map(map__10674);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10674__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10674__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__10675 = options;
var map__10675__$1 = cljs.core.__destructure_map(map__10675);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10675__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10675__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10675__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__10676 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__10679 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__10679__$1 = cljs.core.__destructure_map(map__10679);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10679__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10679__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10676,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10676,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__10680_10708 = cljs.core.seq(libs_to_load);
var chunk__10681_10709 = null;
var count__10682_10710 = (0);
var i__10683_10711 = (0);
while(true){
if((i__10683_10711 < count__10682_10710)){
var lib_10712 = chunk__10681_10709.cljs$core$IIndexed$_nth$arity$2(null,i__10683_10711);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10712)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10712),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10712),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10712),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10712),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10712,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10712),"');");
}

}
}
}


var G__10713 = seq__10680_10708;
var G__10714 = chunk__10681_10709;
var G__10715 = count__10682_10710;
var G__10716 = (i__10683_10711 + (1));
seq__10680_10708 = G__10713;
chunk__10681_10709 = G__10714;
count__10682_10710 = G__10715;
i__10683_10711 = G__10716;
continue;
} else {
var temp__5753__auto___10717 = cljs.core.seq(seq__10680_10708);
if(temp__5753__auto___10717){
var seq__10680_10718__$1 = temp__5753__auto___10717;
if(cljs.core.chunked_seq_QMARK_(seq__10680_10718__$1)){
var c__4638__auto___10719 = cljs.core.chunk_first(seq__10680_10718__$1);
var G__10720 = cljs.core.chunk_rest(seq__10680_10718__$1);
var G__10721 = c__4638__auto___10719;
var G__10722 = cljs.core.count(c__4638__auto___10719);
var G__10723 = (0);
seq__10680_10708 = G__10720;
chunk__10681_10709 = G__10721;
count__10682_10710 = G__10722;
i__10683_10711 = G__10723;
continue;
} else {
var lib_10724 = cljs.core.first(seq__10680_10718__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10724)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10724),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10724),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10724),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10724),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10724,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10724),"');");
}

}
}
}


var G__10725 = cljs.core.next(seq__10680_10718__$1);
var G__10726 = null;
var G__10727 = (0);
var G__10728 = (0);
seq__10680_10708 = G__10725;
chunk__10681_10709 = G__10726;
count__10682_10710 = G__10727;
i__10683_10711 = G__10728;
continue;
}
} else {
}
}
break;
}

var seq__10684_10729 = cljs.core.seq(node_libs);
var chunk__10685_10730 = null;
var count__10686_10731 = (0);
var i__10687_10732 = (0);
while(true){
if((i__10687_10732 < count__10686_10731)){
var lib_10733 = chunk__10685_10730.cljs$core$IIndexed$_nth$arity$2(null,i__10687_10732);
var vec__10694_10734 = cljs.analyzer.lib_AMPERSAND_sublib(lib_10733);
var lib_SINGLEQUOTE__10735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10694_10734,(0),null);
var sublib_10736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10694_10734,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10733)," = require('",lib_SINGLEQUOTE__10735,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_10736),";"], 0));


var G__10737 = seq__10684_10729;
var G__10738 = chunk__10685_10730;
var G__10739 = count__10686_10731;
var G__10740 = (i__10687_10732 + (1));
seq__10684_10729 = G__10737;
chunk__10685_10730 = G__10738;
count__10686_10731 = G__10739;
i__10687_10732 = G__10740;
continue;
} else {
var temp__5753__auto___10741 = cljs.core.seq(seq__10684_10729);
if(temp__5753__auto___10741){
var seq__10684_10742__$1 = temp__5753__auto___10741;
if(cljs.core.chunked_seq_QMARK_(seq__10684_10742__$1)){
var c__4638__auto___10743 = cljs.core.chunk_first(seq__10684_10742__$1);
var G__10744 = cljs.core.chunk_rest(seq__10684_10742__$1);
var G__10745 = c__4638__auto___10743;
var G__10746 = cljs.core.count(c__4638__auto___10743);
var G__10747 = (0);
seq__10684_10729 = G__10744;
chunk__10685_10730 = G__10745;
count__10686_10731 = G__10746;
i__10687_10732 = G__10747;
continue;
} else {
var lib_10748 = cljs.core.first(seq__10684_10742__$1);
var vec__10697_10749 = cljs.analyzer.lib_AMPERSAND_sublib(lib_10748);
var lib_SINGLEQUOTE__10750 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10697_10749,(0),null);
var sublib_10751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10697_10749,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10748)," = require('",lib_SINGLEQUOTE__10750,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_10751),";"], 0));


var G__10752 = cljs.core.next(seq__10684_10742__$1);
var G__10753 = null;
var G__10754 = (0);
var G__10755 = (0);
seq__10684_10729 = G__10752;
chunk__10685_10730 = G__10753;
count__10686_10731 = G__10754;
i__10687_10732 = G__10755;
continue;
}
} else {
}
}
break;
}

var seq__10700_10756 = cljs.core.seq(global_exports_libs);
var chunk__10701_10757 = null;
var count__10702_10758 = (0);
var i__10703_10759 = (0);
while(true){
if((i__10703_10759 < count__10702_10758)){
var lib_10760 = chunk__10701_10757.cljs$core$IIndexed$_nth$arity$2(null,i__10703_10759);
var map__10706_10761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_10760))));
var map__10706_10762__$1 = cljs.core.__destructure_map(map__10706_10761);
var global_exports_10763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10706_10762__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_10763,lib_10760);


var G__10764 = seq__10700_10756;
var G__10765 = chunk__10701_10757;
var G__10766 = count__10702_10758;
var G__10767 = (i__10703_10759 + (1));
seq__10700_10756 = G__10764;
chunk__10701_10757 = G__10765;
count__10702_10758 = G__10766;
i__10703_10759 = G__10767;
continue;
} else {
var temp__5753__auto___10768 = cljs.core.seq(seq__10700_10756);
if(temp__5753__auto___10768){
var seq__10700_10769__$1 = temp__5753__auto___10768;
if(cljs.core.chunked_seq_QMARK_(seq__10700_10769__$1)){
var c__4638__auto___10770 = cljs.core.chunk_first(seq__10700_10769__$1);
var G__10771 = cljs.core.chunk_rest(seq__10700_10769__$1);
var G__10772 = c__4638__auto___10770;
var G__10773 = cljs.core.count(c__4638__auto___10770);
var G__10774 = (0);
seq__10700_10756 = G__10771;
chunk__10701_10757 = G__10772;
count__10702_10758 = G__10773;
i__10703_10759 = G__10774;
continue;
} else {
var lib_10775 = cljs.core.first(seq__10700_10769__$1);
var map__10707_10776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_10775))));
var map__10707_10777__$1 = cljs.core.__destructure_map(map__10707_10776);
var global_exports_10778 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10707_10777__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_10778,lib_10775);


var G__10779 = cljs.core.next(seq__10700_10769__$1);
var G__10780 = null;
var G__10781 = (0);
var G__10782 = (0);
seq__10700_10756 = G__10779;
chunk__10701_10757 = G__10780;
count__10702_10758 = G__10781;
i__10703_10759 = G__10782;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__10783){
var map__10784 = p__10783;
var map__10784__$1 = cljs.core.__destructure_map(map__10784);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10784__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__10785){
var map__10786 = p__10785;
var map__10786__$1 = cljs.core.__destructure_map(map__10786);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10786__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__10787){
var map__10788 = p__10787;
var map__10788__$1 = cljs.core.__destructure_map(map__10788);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10788__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10788__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10788__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10788__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10788__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10789_10813 = cljs.core.seq(protocols);
var chunk__10790_10814 = null;
var count__10791_10815 = (0);
var i__10792_10816 = (0);
while(true){
if((i__10792_10816 < count__10791_10815)){
var protocol_10817 = chunk__10790_10814.cljs$core$IIndexed$_nth$arity$2(null,i__10792_10816);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10817)),"}");


var G__10818 = seq__10789_10813;
var G__10819 = chunk__10790_10814;
var G__10820 = count__10791_10815;
var G__10821 = (i__10792_10816 + (1));
seq__10789_10813 = G__10818;
chunk__10790_10814 = G__10819;
count__10791_10815 = G__10820;
i__10792_10816 = G__10821;
continue;
} else {
var temp__5753__auto___10822 = cljs.core.seq(seq__10789_10813);
if(temp__5753__auto___10822){
var seq__10789_10823__$1 = temp__5753__auto___10822;
if(cljs.core.chunked_seq_QMARK_(seq__10789_10823__$1)){
var c__4638__auto___10824 = cljs.core.chunk_first(seq__10789_10823__$1);
var G__10825 = cljs.core.chunk_rest(seq__10789_10823__$1);
var G__10826 = c__4638__auto___10824;
var G__10827 = cljs.core.count(c__4638__auto___10824);
var G__10828 = (0);
seq__10789_10813 = G__10825;
chunk__10790_10814 = G__10826;
count__10791_10815 = G__10827;
i__10792_10816 = G__10828;
continue;
} else {
var protocol_10829 = cljs.core.first(seq__10789_10823__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10829)),"}");


var G__10830 = cljs.core.next(seq__10789_10823__$1);
var G__10831 = null;
var G__10832 = (0);
var G__10833 = (0);
seq__10789_10813 = G__10830;
chunk__10790_10814 = G__10831;
count__10791_10815 = G__10832;
i__10792_10816 = G__10833;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10793_10834 = cljs.core.seq(fields__$1);
var chunk__10794_10835 = null;
var count__10795_10836 = (0);
var i__10796_10837 = (0);
while(true){
if((i__10796_10837 < count__10795_10836)){
var fld_10838 = chunk__10794_10835.cljs$core$IIndexed$_nth$arity$2(null,i__10796_10837);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10838," = ",fld_10838,";");


var G__10839 = seq__10793_10834;
var G__10840 = chunk__10794_10835;
var G__10841 = count__10795_10836;
var G__10842 = (i__10796_10837 + (1));
seq__10793_10834 = G__10839;
chunk__10794_10835 = G__10840;
count__10795_10836 = G__10841;
i__10796_10837 = G__10842;
continue;
} else {
var temp__5753__auto___10843 = cljs.core.seq(seq__10793_10834);
if(temp__5753__auto___10843){
var seq__10793_10844__$1 = temp__5753__auto___10843;
if(cljs.core.chunked_seq_QMARK_(seq__10793_10844__$1)){
var c__4638__auto___10845 = cljs.core.chunk_first(seq__10793_10844__$1);
var G__10846 = cljs.core.chunk_rest(seq__10793_10844__$1);
var G__10847 = c__4638__auto___10845;
var G__10848 = cljs.core.count(c__4638__auto___10845);
var G__10849 = (0);
seq__10793_10834 = G__10846;
chunk__10794_10835 = G__10847;
count__10795_10836 = G__10848;
i__10796_10837 = G__10849;
continue;
} else {
var fld_10850 = cljs.core.first(seq__10793_10844__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10850," = ",fld_10850,";");


var G__10851 = cljs.core.next(seq__10793_10844__$1);
var G__10852 = null;
var G__10853 = (0);
var G__10854 = (0);
seq__10793_10834 = G__10851;
chunk__10794_10835 = G__10852;
count__10795_10836 = G__10853;
i__10796_10837 = G__10854;
continue;
}
} else {
}
}
break;
}

var seq__10797_10855 = cljs.core.seq(pmasks);
var chunk__10798_10856 = null;
var count__10799_10857 = (0);
var i__10800_10858 = (0);
while(true){
if((i__10800_10858 < count__10799_10857)){
var vec__10807_10859 = chunk__10798_10856.cljs$core$IIndexed$_nth$arity$2(null,i__10800_10858);
var pno_10860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10807_10859,(0),null);
var pmask_10861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10807_10859,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10860,"$ = ",pmask_10861,";");


var G__10862 = seq__10797_10855;
var G__10863 = chunk__10798_10856;
var G__10864 = count__10799_10857;
var G__10865 = (i__10800_10858 + (1));
seq__10797_10855 = G__10862;
chunk__10798_10856 = G__10863;
count__10799_10857 = G__10864;
i__10800_10858 = G__10865;
continue;
} else {
var temp__5753__auto___10866 = cljs.core.seq(seq__10797_10855);
if(temp__5753__auto___10866){
var seq__10797_10867__$1 = temp__5753__auto___10866;
if(cljs.core.chunked_seq_QMARK_(seq__10797_10867__$1)){
var c__4638__auto___10868 = cljs.core.chunk_first(seq__10797_10867__$1);
var G__10869 = cljs.core.chunk_rest(seq__10797_10867__$1);
var G__10870 = c__4638__auto___10868;
var G__10871 = cljs.core.count(c__4638__auto___10868);
var G__10872 = (0);
seq__10797_10855 = G__10869;
chunk__10798_10856 = G__10870;
count__10799_10857 = G__10871;
i__10800_10858 = G__10872;
continue;
} else {
var vec__10810_10873 = cljs.core.first(seq__10797_10867__$1);
var pno_10874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10810_10873,(0),null);
var pmask_10875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10810_10873,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10874,"$ = ",pmask_10875,";");


var G__10876 = cljs.core.next(seq__10797_10867__$1);
var G__10877 = null;
var G__10878 = (0);
var G__10879 = (0);
seq__10797_10855 = G__10876;
chunk__10798_10856 = G__10877;
count__10799_10857 = G__10878;
i__10800_10858 = G__10879;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__10880){
var map__10881 = p__10880;
var map__10881__$1 = cljs.core.__destructure_map(map__10881);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10881__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10881__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10881__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10881__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10881__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10882_10906 = cljs.core.seq(protocols);
var chunk__10883_10907 = null;
var count__10884_10908 = (0);
var i__10885_10909 = (0);
while(true){
if((i__10885_10909 < count__10884_10908)){
var protocol_10910 = chunk__10883_10907.cljs$core$IIndexed$_nth$arity$2(null,i__10885_10909);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10910)),"}");


var G__10911 = seq__10882_10906;
var G__10912 = chunk__10883_10907;
var G__10913 = count__10884_10908;
var G__10914 = (i__10885_10909 + (1));
seq__10882_10906 = G__10911;
chunk__10883_10907 = G__10912;
count__10884_10908 = G__10913;
i__10885_10909 = G__10914;
continue;
} else {
var temp__5753__auto___10915 = cljs.core.seq(seq__10882_10906);
if(temp__5753__auto___10915){
var seq__10882_10916__$1 = temp__5753__auto___10915;
if(cljs.core.chunked_seq_QMARK_(seq__10882_10916__$1)){
var c__4638__auto___10917 = cljs.core.chunk_first(seq__10882_10916__$1);
var G__10918 = cljs.core.chunk_rest(seq__10882_10916__$1);
var G__10919 = c__4638__auto___10917;
var G__10920 = cljs.core.count(c__4638__auto___10917);
var G__10921 = (0);
seq__10882_10906 = G__10918;
chunk__10883_10907 = G__10919;
count__10884_10908 = G__10920;
i__10885_10909 = G__10921;
continue;
} else {
var protocol_10922 = cljs.core.first(seq__10882_10916__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10922)),"}");


var G__10923 = cljs.core.next(seq__10882_10916__$1);
var G__10924 = null;
var G__10925 = (0);
var G__10926 = (0);
seq__10882_10906 = G__10923;
chunk__10883_10907 = G__10924;
count__10884_10908 = G__10925;
i__10885_10909 = G__10926;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10886_10927 = cljs.core.seq(fields__$1);
var chunk__10887_10928 = null;
var count__10888_10929 = (0);
var i__10889_10930 = (0);
while(true){
if((i__10889_10930 < count__10888_10929)){
var fld_10931 = chunk__10887_10928.cljs$core$IIndexed$_nth$arity$2(null,i__10889_10930);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10931," = ",fld_10931,";");


var G__10932 = seq__10886_10927;
var G__10933 = chunk__10887_10928;
var G__10934 = count__10888_10929;
var G__10935 = (i__10889_10930 + (1));
seq__10886_10927 = G__10932;
chunk__10887_10928 = G__10933;
count__10888_10929 = G__10934;
i__10889_10930 = G__10935;
continue;
} else {
var temp__5753__auto___10936 = cljs.core.seq(seq__10886_10927);
if(temp__5753__auto___10936){
var seq__10886_10937__$1 = temp__5753__auto___10936;
if(cljs.core.chunked_seq_QMARK_(seq__10886_10937__$1)){
var c__4638__auto___10938 = cljs.core.chunk_first(seq__10886_10937__$1);
var G__10939 = cljs.core.chunk_rest(seq__10886_10937__$1);
var G__10940 = c__4638__auto___10938;
var G__10941 = cljs.core.count(c__4638__auto___10938);
var G__10942 = (0);
seq__10886_10927 = G__10939;
chunk__10887_10928 = G__10940;
count__10888_10929 = G__10941;
i__10889_10930 = G__10942;
continue;
} else {
var fld_10943 = cljs.core.first(seq__10886_10937__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10943," = ",fld_10943,";");


var G__10944 = cljs.core.next(seq__10886_10937__$1);
var G__10945 = null;
var G__10946 = (0);
var G__10947 = (0);
seq__10886_10927 = G__10944;
chunk__10887_10928 = G__10945;
count__10888_10929 = G__10946;
i__10889_10930 = G__10947;
continue;
}
} else {
}
}
break;
}

var seq__10890_10948 = cljs.core.seq(pmasks);
var chunk__10891_10949 = null;
var count__10892_10950 = (0);
var i__10893_10951 = (0);
while(true){
if((i__10893_10951 < count__10892_10950)){
var vec__10900_10952 = chunk__10891_10949.cljs$core$IIndexed$_nth$arity$2(null,i__10893_10951);
var pno_10953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10900_10952,(0),null);
var pmask_10954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10900_10952,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10953,"$ = ",pmask_10954,";");


var G__10955 = seq__10890_10948;
var G__10956 = chunk__10891_10949;
var G__10957 = count__10892_10950;
var G__10958 = (i__10893_10951 + (1));
seq__10890_10948 = G__10955;
chunk__10891_10949 = G__10956;
count__10892_10950 = G__10957;
i__10893_10951 = G__10958;
continue;
} else {
var temp__5753__auto___10959 = cljs.core.seq(seq__10890_10948);
if(temp__5753__auto___10959){
var seq__10890_10960__$1 = temp__5753__auto___10959;
if(cljs.core.chunked_seq_QMARK_(seq__10890_10960__$1)){
var c__4638__auto___10961 = cljs.core.chunk_first(seq__10890_10960__$1);
var G__10962 = cljs.core.chunk_rest(seq__10890_10960__$1);
var G__10963 = c__4638__auto___10961;
var G__10964 = cljs.core.count(c__4638__auto___10961);
var G__10965 = (0);
seq__10890_10948 = G__10962;
chunk__10891_10949 = G__10963;
count__10892_10950 = G__10964;
i__10893_10951 = G__10965;
continue;
} else {
var vec__10903_10966 = cljs.core.first(seq__10890_10960__$1);
var pno_10967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10903_10966,(0),null);
var pmask_10968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10903_10966,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10967,"$ = ",pmask_10968,";");


var G__10969 = cljs.core.next(seq__10890_10960__$1);
var G__10970 = null;
var G__10971 = (0);
var G__10972 = (0);
seq__10890_10948 = G__10969;
chunk__10891_10949 = G__10970;
count__10892_10950 = G__10971;
i__10893_10951 = G__10972;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__10973){
var map__10974 = p__10973;
var map__10974__$1 = cljs.core.__destructure_map(map__10974);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10974__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10974__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10974__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10974__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10974__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__10975){
var map__10976 = p__10975;
var map__10976__$1 = cljs.core.__destructure_map(map__10976);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10976__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10976__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10976__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10976__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10976__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4210__auto__ = code;
if(cljs.core.truth_(and__4210__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4210__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__10981 = cljs.core.seq(table);
var chunk__10982 = null;
var count__10983 = (0);
var i__10984 = (0);
while(true){
if((i__10984 < count__10983)){
var vec__10991 = chunk__10982.cljs$core$IIndexed$_nth$arity$2(null,i__10984);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10991,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10991,(1),null);
var ns_10997 = cljs.core.namespace(sym);
var name_10998 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10999 = seq__10981;
var G__11000 = chunk__10982;
var G__11001 = count__10983;
var G__11002 = (i__10984 + (1));
seq__10981 = G__10999;
chunk__10982 = G__11000;
count__10983 = G__11001;
i__10984 = G__11002;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10981);
if(temp__5753__auto__){
var seq__10981__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10981__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10981__$1);
var G__11003 = cljs.core.chunk_rest(seq__10981__$1);
var G__11004 = c__4638__auto__;
var G__11005 = cljs.core.count(c__4638__auto__);
var G__11006 = (0);
seq__10981 = G__11003;
chunk__10982 = G__11004;
count__10983 = G__11005;
i__10984 = G__11006;
continue;
} else {
var vec__10994 = cljs.core.first(seq__10981__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10994,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10994,(1),null);
var ns_11007 = cljs.core.namespace(sym);
var name_11008 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__11009 = cljs.core.next(seq__10981__$1);
var G__11010 = null;
var G__11011 = (0);
var G__11012 = (0);
seq__10981 = G__11009;
chunk__10982 = G__11010;
count__10983 = G__11011;
i__10984 = G__11012;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__11014 = arguments.length;
switch (G__11014) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_11019 = cljs.core.first(ks);
var vec__11015_11020 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_11019);
var top_11021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11015_11020,(0),null);
var prefix_SINGLEQUOTE__11022 = vec__11015_11020;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_11019)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__11022) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_11021)) || (cljs.core.contains_QMARK_(known_externs,top_11021)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11022)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_11021);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11022)),";");
}
} else {
}

var m_11023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_11019);
if(cljs.core.empty_QMARK_(m_11023)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__11022,m_11023,top_level,known_externs);
}

var G__11024 = cljs.core.next(ks);
ks = G__11024;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

