// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__13024 = cljs.core.get_global_hierarchy;
return (fexpr__13024.cljs$core$IFn$_invoke$arity$0 ? fexpr__13024.cljs$core$IFn$_invoke$arity$0() : fexpr__13024.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["set websocket id:",ws_id], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["process event:",event_type,event_data], 0));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__13025 = cljs.core.seq(callbacks);
var chunk__13026 = null;
var count__13027 = (0);
var i__13028 = (0);
while(true){
if((i__13028 < count__13027)){
var vec__13037 = chunk__13026.cljs$core$IIndexed$_nth$arity$2(null,i__13028);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13037,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13037,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e13040){var e_13045 = e13040;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_13045,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__13046 = seq__13025;
var G__13047 = chunk__13026;
var G__13048 = count__13027;
var G__13049 = (i__13028 + (1));
seq__13025 = G__13046;
chunk__13026 = G__13047;
count__13027 = G__13048;
i__13028 = G__13049;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__13025);
if(temp__5753__auto__){
var seq__13025__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__13025__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__13025__$1);
var G__13050 = cljs.core.chunk_rest(seq__13025__$1);
var G__13051 = c__4638__auto__;
var G__13052 = cljs.core.count(c__4638__auto__);
var G__13053 = (0);
seq__13025 = G__13050;
chunk__13026 = G__13051;
count__13027 = G__13052;
i__13028 = G__13053;
continue;
} else {
var vec__13041 = cljs.core.first(seq__13025__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13041,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13041,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e13044){var e_13054 = e13044;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_13054,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__13055 = cljs.core.next(seq__13025__$1);
var G__13056 = null;
var G__13057 = (0);
var G__13058 = (0);
seq__13025 = G__13055;
chunk__13026 = G__13056;
count__13027 = G__13057;
i__13028 = G__13058;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__13061 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13061,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13061,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13061,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13061,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__13064 = conn;
var map__13064__$1 = cljs.core.__destructure_map(map__13064);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13064__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__13065 = event_type__$1;
var G__13065__$1 = (((G__13065 instanceof cljs.core.Keyword))?G__13065.fqn:null);
switch (G__13065__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Found response channel for subject",subject], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__13059_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__13059_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__13066 = error_data;
var map__13066__$1 = cljs.core.__destructure_map(map__13066);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13066__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e13060){var e = e13060;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
