// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61399_61568 = cljs.core.seq(servers);
var chunk__61400_61569 = null;
var count__61401_61570 = (0);
var i__61402_61571 = (0);
while(true){
if((i__61402_61571 < count__61401_61570)){
var server_61572 = chunk__61400_61569.cljs$core$IIndexed$_nth$arity$2(null,i__61402_61571);
var healthcheck_uri_61573 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61572),"/fdb/health"].join('');
var resp_chan_61574 = fluree.db.util.xhttp.post_json(healthcheck_uri_61573,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2739__auto___61575 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572){
return (function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = ((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572){
return (function (state_61463){
var state_val_61464 = (state_61463[(1)]);
if((state_val_61464 === (1))){
var state_61463__$1 = state_61463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61463__$1,(2),resp_chan_61574);
} else {
if((state_val_61464 === (2))){
var inst_61452 = (state_61463[(7)]);
var inst_61452__$1 = (state_61463[(2)]);
var inst_61453 = fluree.db.util.core.exception_QMARK_(inst_61452__$1);
var state_61463__$1 = (function (){var statearr_61465 = state_61463;
(statearr_61465[(7)] = inst_61452__$1);

return statearr_61465;
})();
if(inst_61453){
var statearr_61466_61576 = state_61463__$1;
(statearr_61466_61576[(1)] = (3));

} else {
var statearr_61467_61577 = state_61463__$1;
(statearr_61467_61577[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61464 === (3))){
var inst_61452 = (state_61463[(7)]);
var inst_61455 = cljs.core.ex_message(inst_61452);
var inst_61456 = cljs.core.ex_data(inst_61452);
var inst_61457 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61455,inst_61456], 0));
var state_61463__$1 = state_61463;
var statearr_61468_61578 = state_61463__$1;
(statearr_61468_61578[(2)] = inst_61457);

(statearr_61468_61578[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61464 === (4))){
var inst_61459 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61572);
var state_61463__$1 = state_61463;
var statearr_61469_61579 = state_61463__$1;
(statearr_61469_61579[(2)] = inst_61459);

(statearr_61469_61579[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61464 === (5))){
var inst_61461 = (state_61463[(2)]);
var state_61463__$1 = state_61463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61463__$1,inst_61461);
} else {
return null;
}
}
}
}
}
});})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572))
;
return ((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,switch__2716__auto__,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0 = (function (){
var statearr_61470 = [null,null,null,null,null,null,null,null];
(statearr_61470[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__);

(statearr_61470[(1)] = (1));

return statearr_61470;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1 = (function (state_61463){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61463);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61471){var ex__2720__auto__ = e61471;
var statearr_61472_61580 = state_61463;
(statearr_61472_61580[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61463[(4)]))){
var statearr_61473_61581 = state_61463;
(statearr_61473_61581[(1)] = cljs.core.first((state_61463[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61582 = state_61463;
state_61463 = G__61582;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = function(state_61463){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1.call(this,state_61463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__;
})()
;})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,switch__2716__auto__,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572))
})();
var state__2741__auto__ = (function (){var statearr_61474 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61474[(6)] = c__2739__auto___61575);

return statearr_61474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
});})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61575,healthcheck_uri_61573,resp_chan_61574,server_61572))
);



var G__61583 = seq__61399_61568;
var G__61584 = chunk__61400_61569;
var G__61585 = count__61401_61570;
var G__61586 = (i__61402_61571 + (1));
seq__61399_61568 = G__61583;
chunk__61400_61569 = G__61584;
count__61401_61570 = G__61585;
i__61402_61571 = G__61586;
continue;
} else {
var temp__5753__auto___61587 = cljs.core.seq(seq__61399_61568);
if(temp__5753__auto___61587){
var seq__61399_61588__$1 = temp__5753__auto___61587;
if(cljs.core.chunked_seq_QMARK_(seq__61399_61588__$1)){
var c__4638__auto___61589 = cljs.core.chunk_first(seq__61399_61588__$1);
var G__61590 = cljs.core.chunk_rest(seq__61399_61588__$1);
var G__61591 = c__4638__auto___61589;
var G__61592 = cljs.core.count(c__4638__auto___61589);
var G__61593 = (0);
seq__61399_61568 = G__61590;
chunk__61400_61569 = G__61591;
count__61401_61570 = G__61592;
i__61402_61571 = G__61593;
continue;
} else {
var server_61594 = cljs.core.first(seq__61399_61588__$1);
var healthcheck_uri_61595 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61594),"/fdb/health"].join('');
var resp_chan_61596 = fluree.db.util.xhttp.post_json(healthcheck_uri_61595,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2739__auto___61597 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587){
return (function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = ((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587){
return (function (state_61487){
var state_val_61488 = (state_61487[(1)]);
if((state_val_61488 === (1))){
var state_61487__$1 = state_61487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61487__$1,(2),resp_chan_61596);
} else {
if((state_val_61488 === (2))){
var inst_61476 = (state_61487[(7)]);
var inst_61476__$1 = (state_61487[(2)]);
var inst_61477 = fluree.db.util.core.exception_QMARK_(inst_61476__$1);
var state_61487__$1 = (function (){var statearr_61489 = state_61487;
(statearr_61489[(7)] = inst_61476__$1);

return statearr_61489;
})();
if(inst_61477){
var statearr_61490_61598 = state_61487__$1;
(statearr_61490_61598[(1)] = (3));

} else {
var statearr_61491_61599 = state_61487__$1;
(statearr_61491_61599[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61488 === (3))){
var inst_61476 = (state_61487[(7)]);
var inst_61479 = cljs.core.ex_message(inst_61476);
var inst_61480 = cljs.core.ex_data(inst_61476);
var inst_61481 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61479,inst_61480], 0));
var state_61487__$1 = state_61487;
var statearr_61492_61600 = state_61487__$1;
(statearr_61492_61600[(2)] = inst_61481);

(statearr_61492_61600[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61488 === (4))){
var inst_61483 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61594);
var state_61487__$1 = state_61487;
var statearr_61493_61601 = state_61487__$1;
(statearr_61493_61601[(2)] = inst_61483);

(statearr_61493_61601[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61488 === (5))){
var inst_61485 = (state_61487[(2)]);
var state_61487__$1 = state_61487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61487__$1,inst_61485);
} else {
return null;
}
}
}
}
}
});})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587))
;
return ((function (seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,switch__2716__auto__,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0 = (function (){
var statearr_61494 = [null,null,null,null,null,null,null,null];
(statearr_61494[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__);

(statearr_61494[(1)] = (1));

return statearr_61494;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1 = (function (state_61487){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61487);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61495){var ex__2720__auto__ = e61495;
var statearr_61496_61602 = state_61487;
(statearr_61496_61602[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61487[(4)]))){
var statearr_61497_61603 = state_61487;
(statearr_61497_61603[(1)] = cljs.core.first((state_61487[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61604 = state_61487;
state_61487 = G__61604;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = function(state_61487){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1.call(this,state_61487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__;
})()
;})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,switch__2716__auto__,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587))
})();
var state__2741__auto__ = (function (){var statearr_61498 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61498[(6)] = c__2739__auto___61597);

return statearr_61498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
});})(seq__61399_61568,chunk__61400_61569,count__61401_61570,i__61402_61571,c__2739__auto___61597,healthcheck_uri_61595,resp_chan_61596,server_61594,seq__61399_61588__$1,temp__5753__auto___61587))
);



var G__61605 = cljs.core.next(seq__61399_61588__$1);
var G__61606 = null;
var G__61607 = (0);
var G__61608 = (0);
seq__61399_61568 = G__61605;
chunk__61400_61569 = G__61606;
count__61401_61570 = G__61607;
i__61402_61571 = G__61608;
continue;
}
} else {
}
}
break;
}

var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61542){
var state_val_61543 = (state_61542[(1)]);
if((state_val_61543 === (7))){
var inst_61514 = (state_61542[(7)]);
var inst_61521 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61514,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61542__$1 = state_61542;
if(inst_61521){
var statearr_61544_61609 = state_61542__$1;
(statearr_61544_61609[(1)] = (9));

} else {
var statearr_61545_61610 = state_61542__$1;
(statearr_61545_61610[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (1))){
var inst_61507 = (state_61542[(8)]);
var inst_61506 = (state_61542[(9)]);
var inst_61506__$1 = promise_chan;
var inst_61507__$1 = cljs.core.async.timeout((60000));
var inst_61508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61509 = [inst_61506__$1,inst_61507__$1];
var inst_61510 = (new cljs.core.PersistentVector(null,2,(5),inst_61508,inst_61509,null));
var state_61542__$1 = (function (){var statearr_61546 = state_61542;
(statearr_61546[(8)] = inst_61507__$1);

(statearr_61546[(9)] = inst_61506__$1);

return statearr_61546;
})();
return cljs.core.async.ioc_alts_BANG_(state_61542__$1,(2),inst_61510);
} else {
if((state_val_61543 === (4))){
var inst_61507 = (state_61542[(8)]);
var inst_61514 = (state_61542[(7)]);
var inst_61518 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61514,inst_61507);
var state_61542__$1 = state_61542;
if(inst_61518){
var statearr_61547_61611 = state_61542__$1;
(statearr_61547_61611[(1)] = (6));

} else {
var statearr_61548_61612 = state_61542__$1;
(statearr_61548_61612[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (13))){
var state_61542__$1 = state_61542;
var statearr_61549_61613 = state_61542__$1;
(statearr_61549_61613[(2)] = null);

(statearr_61549_61613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (6))){
var state_61542__$1 = state_61542;
var statearr_61550_61614 = state_61542__$1;
(statearr_61550_61614[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61550_61614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (3))){
var state_61542__$1 = state_61542;
var statearr_61551_61615 = state_61542__$1;
(statearr_61551_61615[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61551_61615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (12))){
var inst_61532 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61533 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61534 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61535 = cljs.core.PersistentHashMap.fromArrays(inst_61533,inst_61534);
var inst_61536 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61535);
var inst_61537 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61536);
var state_61542__$1 = (function (){var statearr_61552 = state_61542;
(statearr_61552[(10)] = inst_61532);

return statearr_61552;
})();
var statearr_61553_61616 = state_61542__$1;
(statearr_61553_61616[(2)] = inst_61537);

(statearr_61553_61616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (2))){
var inst_61506 = (state_61542[(9)]);
var inst_61514 = (state_61542[(7)]);
var inst_61512 = (state_61542[(2)]);
var inst_61513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61512,(0),null);
var inst_61514__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61512,(1),null);
var inst_61515 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61514__$1,inst_61506);
var state_61542__$1 = (function (){var statearr_61554 = state_61542;
(statearr_61554[(11)] = inst_61513);

(statearr_61554[(7)] = inst_61514__$1);

return statearr_61554;
})();
if(inst_61515){
var statearr_61555_61617 = state_61542__$1;
(statearr_61555_61617[(1)] = (3));

} else {
var statearr_61556_61618 = state_61542__$1;
(statearr_61556_61618[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (11))){
var inst_61525 = (state_61542[(2)]);
var state_61542__$1 = state_61542;
var statearr_61557_61619 = state_61542__$1;
(statearr_61557_61619[(2)] = inst_61525);

(statearr_61557_61619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (9))){
var inst_61513 = (state_61542[(11)]);
var state_61542__$1 = state_61542;
var statearr_61558_61620 = state_61542__$1;
(statearr_61558_61620[(2)] = inst_61513);

(statearr_61558_61620[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (5))){
var inst_61529 = (state_61542[(2)]);
var inst_61530 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61529);
var state_61542__$1 = state_61542;
if(inst_61530){
var statearr_61559_61621 = state_61542__$1;
(statearr_61559_61621[(1)] = (12));

} else {
var statearr_61560_61622 = state_61542__$1;
(statearr_61560_61622[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (14))){
var inst_61540 = (state_61542[(2)]);
var state_61542__$1 = state_61542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61542__$1,inst_61540);
} else {
if((state_val_61543 === (10))){
var state_61542__$1 = state_61542;
var statearr_61561_61623 = state_61542__$1;
(statearr_61561_61623[(2)] = null);

(statearr_61561_61623[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61543 === (8))){
var inst_61527 = (state_61542[(2)]);
var state_61542__$1 = state_61542;
var statearr_61562_61624 = state_61542__$1;
(statearr_61562_61624[(2)] = inst_61527);

(statearr_61562_61624[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0 = (function (){
var statearr_61563 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61563[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__);

(statearr_61563[(1)] = (1));

return statearr_61563;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1 = (function (state_61542){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61542);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61564){var ex__2720__auto__ = e61564;
var statearr_61565_61625 = state_61542;
(statearr_61565_61625[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61542[(4)]))){
var statearr_61566_61626 = state_61542;
(statearr_61566_61626[(1)] = cljs.core.first((state_61542[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61627 = state_61542;
state_61542 = G__61627;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__ = function(state_61542){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1.call(this,state_61542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_61567 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61567[(6)] = c__2739__auto__);

return statearr_61567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61671){
var state_val_61672 = (state_61671[(1)]);
if((state_val_61672 === (7))){
var state_61671__$1 = state_61671;
var statearr_61673_61699 = state_61671__$1;
(statearr_61673_61699[(2)] = null);

(statearr_61673_61699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (1))){
var state_61671__$1 = state_61671;
var statearr_61674_61700 = state_61671__$1;
(statearr_61674_61700[(2)] = null);

(statearr_61674_61700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (4))){
var inst_61628 = (state_61671[(2)]);
var state_61671__$1 = state_61671;
var statearr_61675_61701 = state_61671__$1;
(statearr_61675_61701[(2)] = inst_61628);

(statearr_61675_61701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (6))){
var inst_61650 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_61671__$1 = state_61671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61671__$1,(9),inst_61650);
} else {
if((state_val_61672 === (3))){
var inst_61669 = (state_61671[(2)]);
var state_61671__$1 = state_61671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61671__$1,inst_61669);
} else {
if((state_val_61672 === (12))){
var inst_61663 = (state_61671[(2)]);
var state_61671__$1 = state_61671;
var statearr_61676_61702 = state_61671__$1;
(statearr_61676_61702[(2)] = inst_61663);

(statearr_61676_61702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (2))){
var inst_61639 = (state_61671[(7)]);
var inst_61634 = (state_61671[(8)]);
var inst_61644 = (state_61671[(9)]);
var _ = (function (){var statearr_61677 = state_61671;
(statearr_61677[(4)] = cljs.core.cons((5),(state_61671[(4)])));

return statearr_61677;
})();
var inst_61634__$1 = fluree.db.util.core.random_uuid();
var inst_61635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61636 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61637 = (new cljs.core.PersistentVector(null,2,(5),inst_61635,inst_61636,null));
var inst_61638 = (function (){var lock_id = inst_61634__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_61639__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61637,inst_61638);
var inst_61640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61641 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61642 = (new cljs.core.PersistentVector(null,3,(5),inst_61640,inst_61641,null));
var inst_61643 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61639__$1,inst_61642);
var inst_61644__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61634__$1,inst_61643);
var inst_61645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61646 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61647 = (new cljs.core.PersistentVector(null,3,(5),inst_61645,inst_61646,null));
var inst_61648 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61639__$1,inst_61647);
var state_61671__$1 = (function (){var statearr_61678 = state_61671;
(statearr_61678[(7)] = inst_61639__$1);

(statearr_61678[(8)] = inst_61634__$1);

(statearr_61678[(10)] = inst_61648);

(statearr_61678[(9)] = inst_61644__$1);

return statearr_61678;
})();
if(inst_61644__$1){
var statearr_61679_61703 = state_61671__$1;
(statearr_61679_61703[(1)] = (6));

} else {
var statearr_61680_61704 = state_61671__$1;
(statearr_61680_61704[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (11))){
var inst_61655 = (state_61671[(11)]);
var inst_61654 = (state_61671[(12)]);
var inst_61648 = (state_61671[(10)]);
var inst_61661 = fluree.db.util.xhttp.try_socket(inst_61654,sub_chan,pub_chan,inst_61648,(60000),inst_61655);
var state_61671__$1 = state_61671;
var statearr_61682_61705 = state_61671__$1;
(statearr_61682_61705[(2)] = inst_61661);

(statearr_61682_61705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (9))){
var inst_61639 = (state_61671[(7)]);
var inst_61652 = (state_61671[(13)]);
var inst_61634 = (state_61671[(8)]);
var inst_61654 = (state_61671[(12)]);
var inst_61648 = (state_61671[(10)]);
var inst_61644 = (state_61671[(9)]);
var inst_61652__$1 = (state_61671[(2)]);
var inst_61653 = clojure.string.replace(inst_61652__$1,"http","ws");
var inst_61654__$1 = [inst_61653,"/fdb/ws"].join('');
var inst_61655 = (function (){var lock_id = inst_61634;
var state = inst_61639;
var have_lock_QMARK_ = inst_61644;
var resp_chan = inst_61648;
var healthy_server = inst_61652__$1;
var ws_url = inst_61654__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_61656 = fluree.db.util.core.exception_QMARK_(inst_61652__$1);
var state_61671__$1 = (function (){var statearr_61683 = state_61671;
(statearr_61683[(13)] = inst_61652__$1);

(statearr_61683[(11)] = inst_61655);

(statearr_61683[(12)] = inst_61654__$1);

return statearr_61683;
})();
if(inst_61656){
var statearr_61684_61706 = state_61671__$1;
(statearr_61684_61706[(1)] = (10));

} else {
var statearr_61685_61707 = state_61671__$1;
(statearr_61685_61707[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (5))){
var _ = (function (){var statearr_61686 = state_61671;
(statearr_61686[(4)] = cljs.core.rest((state_61671[(4)])));

return statearr_61686;
})();
var state_61671__$1 = state_61671;
var ex61681 = (state_61671__$1[(2)]);
var statearr_61687_61708 = state_61671__$1;
(statearr_61687_61708[(5)] = ex61681);


if((ex61681 instanceof Error)){
var statearr_61688_61709 = state_61671__$1;
(statearr_61688_61709[(1)] = (4));

(statearr_61688_61709[(5)] = null);

} else {
throw ex61681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (10))){
var inst_61652 = (state_61671[(13)]);
var inst_61648 = (state_61671[(10)]);
var inst_61658 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_61659 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61648,inst_61652);
var state_61671__$1 = (function (){var statearr_61689 = state_61671;
(statearr_61689[(14)] = inst_61658);

return statearr_61689;
})();
var statearr_61690_61710 = state_61671__$1;
(statearr_61690_61710[(2)] = inst_61659);

(statearr_61690_61710[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61672 === (8))){
var inst_61648 = (state_61671[(10)]);
var inst_61666 = (state_61671[(2)]);
var _ = (function (){var statearr_61691 = state_61671;
(statearr_61691[(4)] = cljs.core.rest((state_61671[(4)])));

return statearr_61691;
})();
var state_61671__$1 = (function (){var statearr_61692 = state_61671;
(statearr_61692[(15)] = inst_61666);

return statearr_61692;
})();
var statearr_61693_61711 = state_61671__$1;
(statearr_61693_61711[(2)] = inst_61648);

(statearr_61693_61711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2717__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2717__auto____0 = (function (){
var statearr_61694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61694[(0)] = fluree$db$connection$establish_socket_$_state_machine__2717__auto__);

(statearr_61694[(1)] = (1));

return statearr_61694;
});
var fluree$db$connection$establish_socket_$_state_machine__2717__auto____1 = (function (state_61671){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61671);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61695){var ex__2720__auto__ = e61695;
var statearr_61696_61712 = state_61671;
(statearr_61696_61712[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61671[(4)]))){
var statearr_61697_61713 = state_61671;
(statearr_61697_61713[(1)] = cljs.core.first((state_61671[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61714 = state_61671;
state_61671 = G__61714;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2717__auto__ = function(state_61671){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2717__auto____1.call(this,state_61671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2717__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2717__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_61698 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61698[(6)] = c__2739__auto__);

return statearr_61698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k61716,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__61720 = k61716;
var G__61720__$1 = (((G__61720 instanceof cljs.core.Keyword))?G__61720.fqn:null);
switch (G__61720__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k61716,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__61721){
var vec__61722 = p__61721;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61722,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61722,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61715){
var self__ = this;
var G__61715__$1 = this;
return (new cljs.core.RecordIter((0),G__61715__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__61725 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__61725(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61717,other61718){
var self__ = this;
var this61717__$1 = this;
return (((!((other61718 == null)))) && ((((this61717__$1.constructor === other61718.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.id,other61718.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.servers,other61718.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.state,other61718.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.req_chan,other61718.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.sub_chan,other61718.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.pub_chan,other61718.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.group,other61718.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.storage_read,other61718.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.storage_write,other61718.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.object_cache,other61718.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.parallelism,other61718.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.serializer,other61718.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.default_network,other61718.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.transactor_QMARK_,other61718.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.publish,other61718.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.transact_handler,other61718.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.tx_private_key,other61718.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.tx_key_id,other61718.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.meta,other61718.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.add_listener,other61718.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.remove_listener,other61718.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.close,other61718.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61717__$1.__extmap,other61718.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k61716){
var self__ = this;
var this__4468__auto____$1 = this;
var G__61726 = k61716;
var G__61726__$1 = (((G__61726 instanceof cljs.core.Keyword))?G__61726.fqn:null);
switch (G__61726__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k61716);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__61715){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__61727 = cljs.core.keyword_identical_QMARK_;
var expr__61728 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__61730 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__61731 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61730,G__61731) : pred__61727.call(null,G__61730,G__61731));
})())){
return (new fluree.db.connection.Connection(G__61715,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61732 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__61733 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61732,G__61733) : pred__61727.call(null,G__61732,G__61733));
})())){
return (new fluree.db.connection.Connection(self__.id,G__61715,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61734 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__61735 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61734,G__61735) : pred__61727.call(null,G__61734,G__61735));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61715,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61736 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__61737 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61736,G__61737) : pred__61727.call(null,G__61736,G__61737));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61715,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61738 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__61739 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61738,G__61739) : pred__61727.call(null,G__61738,G__61739));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61715,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61740 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__61741 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61740,G__61741) : pred__61727.call(null,G__61740,G__61741));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61715,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61742 = new cljs.core.Keyword(null,"group","group",582596132);
var G__61743 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61742,G__61743) : pred__61727.call(null,G__61742,G__61743));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61715,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61744 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__61745 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61744,G__61745) : pred__61727.call(null,G__61744,G__61745));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61715,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61746 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__61747 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61746,G__61747) : pred__61727.call(null,G__61746,G__61747));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61715,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61748 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__61749 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61748,G__61749) : pred__61727.call(null,G__61748,G__61749));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61715,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61750 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__61751 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61750,G__61751) : pred__61727.call(null,G__61750,G__61751));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61715,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61752 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__61753 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61752,G__61753) : pred__61727.call(null,G__61752,G__61753));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61715,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61754 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__61755 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61754,G__61755) : pred__61727.call(null,G__61754,G__61755));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61715,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61756 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__61757 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61756,G__61757) : pred__61727.call(null,G__61756,G__61757));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61715,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61758 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__61759 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61758,G__61759) : pred__61727.call(null,G__61758,G__61759));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61715,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61760 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__61761 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61760,G__61761) : pred__61727.call(null,G__61760,G__61761));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61715,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61762 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__61763 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61762,G__61763) : pred__61727.call(null,G__61762,G__61763));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61715,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61764 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__61765 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61764,G__61765) : pred__61727.call(null,G__61764,G__61765));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61715,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61766 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__61767 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61766,G__61767) : pred__61727.call(null,G__61766,G__61767));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61715,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61768 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__61769 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61768,G__61769) : pred__61727.call(null,G__61768,G__61769));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61715,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61770 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__61771 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61770,G__61771) : pred__61727.call(null,G__61770,G__61771));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61715,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61772 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__61773 = expr__61728;
return (pred__61727.cljs$core$IFn$_invoke$arity$2 ? pred__61727.cljs$core$IFn$_invoke$arity$2(G__61772,G__61773) : pred__61727.call(null,G__61772,G__61773));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61715,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__61715),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__61715){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61715,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61719){
var extmap__4501__auto__ = (function (){var G__61774 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__61719,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__61719)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__61774);
} else {
return G__61774;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61719),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61719),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__61780 = servers_STAR_;
var vec__61781 = G__61780;
var seq__61782 = cljs.core.seq(vec__61781);
var first__61783 = cljs.core.first(seq__61782);
var seq__61782__$1 = cljs.core.next(seq__61782);
var server = first__61783;
var r = seq__61782__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61780__$1 = G__61780;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61787 = G__61780__$1;
var seq__61788 = cljs.core.seq(vec__61787);
var first__61789 = cljs.core.first(seq__61788);
var seq__61788__$1 = cljs.core.next(seq__61788);
var server__$1 = first__61789;
var r__$1 = seq__61788__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__61790 = r__$1;
var G__61791 = is_https_QMARK_;
var G__61792 = result_STAR_;
G__61780__$1 = G__61790;
https_QMARK___$1 = G__61791;
result__$1 = G__61792;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61793 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61793 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__61793);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61822){
var state_val_61823 = (state_61822[(1)]);
if((state_val_61823 === (7))){
var inst_61808 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61809 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61810 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61811 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61812 = fluree.db.connection.establish_socket(inst_61808,inst_61809,inst_61810,inst_61811);
var state_61822__$1 = state_61822;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61822__$1,(9),inst_61812);
} else {
if((state_val_61823 === (1))){
var state_61822__$1 = state_61822;
var statearr_61824_61843 = state_61822__$1;
(statearr_61824_61843[(2)] = null);

(statearr_61824_61843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (4))){
var inst_61794 = (state_61822[(2)]);
var state_61822__$1 = state_61822;
var statearr_61825_61844 = state_61822__$1;
(statearr_61825_61844[(2)] = inst_61794);

(statearr_61825_61844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (6))){
var inst_61805 = (state_61822[(7)]);
var state_61822__$1 = state_61822;
var statearr_61826_61845 = state_61822__$1;
(statearr_61826_61845[(2)] = inst_61805);

(statearr_61826_61845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (3))){
var inst_61820 = (state_61822[(2)]);
var state_61822__$1 = state_61822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61822__$1,inst_61820);
} else {
if((state_val_61823 === (2))){
var inst_61805 = (state_61822[(7)]);
var _ = (function (){var statearr_61828 = state_61822;
(statearr_61828[(4)] = cljs.core.cons((5),(state_61822[(4)])));

return statearr_61828;
})();
var inst_61800 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_61801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61802 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61803 = [inst_61802,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61804 = (new cljs.core.PersistentVector(null,3,(5),inst_61801,inst_61803,null));
var inst_61805__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61800,inst_61804);
var state_61822__$1 = (function (){var statearr_61829 = state_61822;
(statearr_61829[(7)] = inst_61805__$1);

return statearr_61829;
})();
if(cljs.core.truth_(inst_61805__$1)){
var statearr_61830_61846 = state_61822__$1;
(statearr_61830_61846[(1)] = (6));

} else {
var statearr_61831_61847 = state_61822__$1;
(statearr_61831_61847[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (9))){
var inst_61814 = (state_61822[(2)]);
var inst_61815 = fluree.db.util.async.throw_err(inst_61814);
var state_61822__$1 = state_61822;
var statearr_61832_61848 = state_61822__$1;
(statearr_61832_61848[(2)] = inst_61815);

(statearr_61832_61848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (5))){
var _ = (function (){var statearr_61833 = state_61822;
(statearr_61833[(4)] = cljs.core.rest((state_61822[(4)])));

return statearr_61833;
})();
var state_61822__$1 = state_61822;
var ex61827 = (state_61822__$1[(2)]);
var statearr_61834_61849 = state_61822__$1;
(statearr_61834_61849[(5)] = ex61827);


if((ex61827 instanceof Error)){
var statearr_61835_61850 = state_61822__$1;
(statearr_61835_61850[(1)] = (4));

(statearr_61835_61850[(5)] = null);

} else {
throw ex61827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61823 === (8))){
var inst_61817 = (state_61822[(2)]);
var _ = (function (){var statearr_61836 = state_61822;
(statearr_61836[(4)] = cljs.core.rest((state_61822[(4)])));

return statearr_61836;
})();
var state_61822__$1 = state_61822;
var statearr_61837_61851 = state_61822__$1;
(statearr_61837_61851[(2)] = inst_61817);

(statearr_61837_61851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2717__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2717__auto____0 = (function (){
var statearr_61838 = [null,null,null,null,null,null,null,null];
(statearr_61838[(0)] = fluree$db$connection$get_socket_$_state_machine__2717__auto__);

(statearr_61838[(1)] = (1));

return statearr_61838;
});
var fluree$db$connection$get_socket_$_state_machine__2717__auto____1 = (function (state_61822){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61822);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61839){var ex__2720__auto__ = e61839;
var statearr_61840_61852 = state_61822;
(statearr_61840_61852[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61822[(4)]))){
var statearr_61841_61853 = state_61822;
(statearr_61841_61853[(1)] = cljs.core.first((state_61822[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61854 = state_61822;
state_61822 = G__61854;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2717__auto__ = function(state_61822){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2717__auto____1.call(this,state_61822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2717__auto____0;
fluree$db$connection$get_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2717__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_61842 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61842[(6)] = c__2739__auto__);

return statearr_61842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e61855){var e = e61855;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61982){
var state_val_61983 = (state_61982[(1)]);
if((state_val_61983 === (7))){
var inst_61978 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
var statearr_61985_62055 = state_61982__$1;
(statearr_61985_62055[(2)] = inst_61978);

(statearr_61985_62055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (20))){
var _ = (function (){var statearr_61986 = state_61982;
(statearr_61986[(4)] = cljs.core.rest((state_61982[(4)])));

return statearr_61986;
})();
var state_61982__$1 = state_61982;
var ex61984 = (state_61982__$1[(2)]);
var statearr_61987_62056 = state_61982__$1;
(statearr_61987_62056[(5)] = ex61984);


var statearr_61988_62057 = state_61982__$1;
(statearr_61988_62057[(1)] = (10));

(statearr_61988_62057[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (27))){
var inst_61970 = (state_61982[(2)]);
var _ = (function (){var statearr_61989 = state_61982;
(statearr_61989[(4)] = cljs.core.rest((state_61982[(4)])));

return statearr_61989;
})();
var state_61982__$1 = state_61982;
var statearr_61990_62058 = state_61982__$1;
(statearr_61990_62058[(2)] = inst_61970);

(statearr_61990_62058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (1))){
var inst_61857 = (0);
var state_61982__$1 = (function (){var statearr_61991 = state_61982;
(statearr_61991[(7)] = inst_61857);

return statearr_61991;
})();
var statearr_61992_62059 = state_61982__$1;
(statearr_61992_62059[(2)] = null);

(statearr_61992_62059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (24))){
var inst_61948 = (state_61982[(8)]);
var inst_61948__$1 = (state_61982[(2)]);
var inst_61949 = inst_61948__$1 === true;
var state_61982__$1 = (function (){var statearr_61993 = state_61982;
(statearr_61993[(8)] = inst_61948__$1);

return statearr_61993;
})();
if(cljs.core.truth_(inst_61949)){
var statearr_61994_62060 = state_61982__$1;
(statearr_61994_62060[(1)] = (25));

} else {
var statearr_61995_62061 = state_61982__$1;
(statearr_61995_62061[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (4))){
var inst_61860 = (state_61982[(9)]);
var inst_61860__$1 = (state_61982[(2)]);
var state_61982__$1 = (function (){var statearr_61996 = state_61982;
(statearr_61996[(9)] = inst_61860__$1);

return statearr_61996;
})();
if(cljs.core.truth_(inst_61860__$1)){
var statearr_61997_62062 = state_61982__$1;
(statearr_61997_62062[(1)] = (5));

} else {
var statearr_61998_62063 = state_61982__$1;
(statearr_61998_62063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (15))){
var inst_61873 = (state_61982[(10)]);
var state_61982__$1 = state_61982;
var statearr_61999_62064 = state_61982__$1;
(statearr_61999_62064[(2)] = inst_61873);

(statearr_61999_62064[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (21))){
var inst_61904 = (state_61982[(11)]);
var inst_61896 = (state_61982[(12)]);
var inst_61900 = (state_61982[(13)]);
var inst_61905 = (state_61982[(14)]);
var inst_61857 = (state_61982[(7)]);
var inst_61901 = (state_61982[(15)]);
var inst_61899 = (state_61982[(16)]);
var inst_61860 = (state_61982[(9)]);
var inst_61897 = (state_61982[(17)]);
var inst_61898 = (state_61982[(18)]);
var inst_61907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61908 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61904];
var inst_61909 = (new cljs.core.PersistentVector(null,2,(5),inst_61907,inst_61908,null));
var inst_61910 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_61909,inst_61899);
var inst_61937 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61938 = (function (){var vec__61892 = inst_61860;
var resp_chan = inst_61899;
var timeout = inst_61905;
var i = inst_61857;
var data = inst_61898;
var map__61895 = inst_61901;
var _ = inst_61896;
var req_id = inst_61904;
var operation = inst_61897;
var msg = inst_61860;
var c__2739__auto____$1 = inst_61937;
var opts = inst_61900;
return (function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61935){
var state_val_61936 = (state_61935[(1)]);
if((state_val_61936 === (1))){
var inst_61914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61915 = cljs.core.async.timeout(timeout);
var inst_61916 = [resp_chan,inst_61915];
var inst_61917 = (new cljs.core.PersistentVector(null,2,(5),inst_61914,inst_61916,null));
var state_61935__$1 = state_61935;
return cljs.core.async.ioc_alts_BANG_(state_61935__$1,(2),inst_61917);
} else {
if((state_val_61936 === (2))){
var inst_61920 = (state_61935[(7)]);
var inst_61919 = (state_61935[(2)]);
var inst_61920__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61919,(0),null);
var inst_61921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61919,(1),null);
var inst_61922 = (function (){var vec__61911 = inst_61919;
var resp = inst_61920__$1;
var c = inst_61921;
return (function (p1__61856_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__61856_SHARP_,req_id);
});
})();
var inst_61923 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61922);
var inst_61924 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61921,resp_chan);
var state_61935__$1 = (function (){var statearr_62000 = state_61935;
(statearr_62000[(8)] = inst_61923);

(statearr_62000[(7)] = inst_61920__$1);

return statearr_62000;
})();
if(inst_61924){
var statearr_62001_62065 = state_61935__$1;
(statearr_62001_62065[(1)] = (3));

} else {
var statearr_62002_62066 = state_61935__$1;
(statearr_62002_62066[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61936 === (3))){
var inst_61920 = (state_61935[(7)]);
var state_61935__$1 = state_61935;
var statearr_62003_62067 = state_61935__$1;
(statearr_62003_62067[(2)] = inst_61920);

(statearr_62003_62067[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61936 === (4))){
var inst_61927 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_61928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61929 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_61930 = cljs.core.PersistentHashMap.fromArrays(inst_61928,inst_61929);
var inst_61931 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61927,inst_61930);
var state_61935__$1 = state_61935;
var statearr_62004_62068 = state_61935__$1;
(statearr_62004_62068[(2)] = inst_61931);

(statearr_62004_62068[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61936 === (5))){
var inst_61933 = (state_61935[(2)]);
var state_61935__$1 = state_61935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61935__$1,inst_61933);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2717__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2717__auto____0 = (function (){
var statearr_62005 = [null,null,null,null,null,null,null,null,null];
(statearr_62005[(0)] = fluree$db$connection$msg_producer_$_state_machine__2717__auto__);

(statearr_62005[(1)] = (1));

return statearr_62005;
});
var fluree$db$connection$msg_producer_$_state_machine__2717__auto____1 = (function (state_61935){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61935);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62006){var ex__2720__auto__ = e62006;
var statearr_62007_62069 = state_61935;
(statearr_62007_62069[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61935[(4)]))){
var statearr_62008_62070 = state_61935;
(statearr_62008_62070[(1)] = cljs.core.first((state_61935[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62071 = state_61935;
state_61935 = G__62071;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2717__auto__ = function(state_61935){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2717__auto____1.call(this,state_61935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2717__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2717__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62009 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62009[(6)] = c__2739__auto____$1);

return statearr_62009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
});
})();
var inst_61939 = cljs.core.async.impl.dispatch.run(inst_61938);
var state_61982__$1 = (function (){var statearr_62010 = state_61982;
(statearr_62010[(19)] = inst_61910);

(statearr_62010[(20)] = inst_61939);

return statearr_62010;
})();
var statearr_62011_62072 = state_61982__$1;
(statearr_62011_62072[(2)] = inst_61937);

(statearr_62011_62072[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (31))){
var inst_61958 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_61982__$1 = state_61982;
var statearr_62012_62073 = state_61982__$1;
(statearr_62012_62073[(2)] = inst_61958);

(statearr_62012_62073[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (32))){
var state_61982__$1 = state_61982;
var statearr_62013_62074 = state_61982__$1;
(statearr_62013_62074[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (33))){
var inst_61966 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
var statearr_62015_62075 = state_61982__$1;
(statearr_62015_62075[(2)] = inst_61966);

(statearr_62015_62075[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (13))){
var inst_61873 = (state_61982[(10)]);
var inst_61870 = (state_61982[(2)]);
var inst_61871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61870,(0),null);
var inst_61872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61870,(1),null);
var inst_61873__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61870,(2),null);
var state_61982__$1 = (function (){var statearr_62016 = state_61982;
(statearr_62016[(21)] = inst_61871);

(statearr_62016[(22)] = inst_61872);

(statearr_62016[(10)] = inst_61873__$1);

return statearr_62016;
})();
if(cljs.core.truth_(inst_61873__$1)){
var statearr_62017_62076 = state_61982__$1;
(statearr_62017_62076[(1)] = (14));

} else {
var statearr_62018_62077 = state_61982__$1;
(statearr_62018_62077[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (22))){
var state_61982__$1 = state_61982;
var statearr_62019_62078 = state_61982__$1;
(statearr_62019_62078[(2)] = null);

(statearr_62019_62078[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (36))){
var inst_61964 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
var statearr_62020_62079 = state_61982__$1;
(statearr_62020_62079[(2)] = inst_61964);

(statearr_62020_62079[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (29))){
var inst_61948 = (state_61982[(8)]);
var inst_61956 = (inst_61948 == null);
var state_61982__$1 = state_61982;
if(cljs.core.truth_(inst_61956)){
var statearr_62021_62080 = state_61982__$1;
(statearr_62021_62080[(1)] = (31));

} else {
var statearr_62022_62081 = state_61982__$1;
(statearr_62022_62081[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (6))){
var state_61982__$1 = state_61982;
var statearr_62023_62082 = state_61982__$1;
(statearr_62023_62082[(2)] = null);

(statearr_62023_62082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (28))){
var inst_61948 = (state_61982[(8)]);
var inst_61954 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61948,"Error processing message in producer."], 0));
var state_61982__$1 = state_61982;
var statearr_62024_62083 = state_61982__$1;
(statearr_62024_62083[(2)] = inst_61954);

(statearr_62024_62083[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (25))){
var state_61982__$1 = state_61982;
var statearr_62025_62084 = state_61982__$1;
(statearr_62025_62084[(2)] = null);

(statearr_62025_62084[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (34))){
var inst_61948 = (state_61982[(8)]);
var inst_61961 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_61948], 0));
var state_61982__$1 = state_61982;
var statearr_62026_62085 = state_61982__$1;
(statearr_62026_62085[(2)] = inst_61961);

(statearr_62026_62085[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (17))){
var inst_61862 = (state_61982[(23)]);
var inst_61873 = (state_61982[(10)]);
var inst_61880 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61873,inst_61862);
var state_61982__$1 = state_61982;
var statearr_62027_62086 = state_61982__$1;
(statearr_62027_62086[(2)] = inst_61880);

(statearr_62027_62086[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (3))){
var inst_61980 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61982__$1,inst_61980);
} else {
if((state_val_61983 === (12))){
var state_61982__$1 = state_61982;
var statearr_62028_62087 = state_61982__$1;
(statearr_62028_62087[(2)] = null);

(statearr_62028_62087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (2))){
var state_61982__$1 = state_61982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61982__$1,(4),req_chan);
} else {
if((state_val_61983 === (23))){
var inst_61904 = (state_61982[(11)]);
var inst_61897 = (state_61982[(17)]);
var inst_61898 = (state_61982[(18)]);
var inst_61942 = (state_61982[(2)]);
var inst_61943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61944 = [inst_61897,inst_61904,inst_61898];
var inst_61945 = (new cljs.core.PersistentVector(null,3,(5),inst_61943,inst_61944,null));
var inst_61946 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_61945) : publish_fn.call(null,conn,inst_61945));
var state_61982__$1 = (function (){var statearr_62029 = state_61982;
(statearr_62029[(24)] = inst_61942);

return statearr_62029;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61982__$1,(24),inst_61946);
} else {
if((state_val_61983 === (35))){
var state_61982__$1 = state_61982;
var statearr_62030_62088 = state_61982__$1;
(statearr_62030_62088[(2)] = null);

(statearr_62030_62088[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (19))){
var inst_61886 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
var statearr_62031_62089 = state_61982__$1;
(statearr_62031_62089[(2)] = inst_61886);

(statearr_62031_62089[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (11))){
var inst_61860 = (state_61982[(9)]);
var state_61982__$1 = state_61982;
var statearr_62032_62090 = state_61982__$1;
(statearr_62032_62090[(2)] = inst_61860);

(statearr_62032_62090[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (9))){
var inst_61857 = (state_61982[(7)]);
var inst_61973 = (state_61982[(2)]);
var inst_61974 = (inst_61857 + (1));
var inst_61857__$1 = inst_61974;
var state_61982__$1 = (function (){var statearr_62033 = state_61982;
(statearr_62033[(7)] = inst_61857__$1);

(statearr_62033[(25)] = inst_61973);

return statearr_62033;
})();
var statearr_62034_62091 = state_61982__$1;
(statearr_62034_62091[(2)] = null);

(statearr_62034_62091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (5))){
var state_61982__$1 = state_61982;
var statearr_62035_62092 = state_61982__$1;
(statearr_62035_62092[(2)] = null);

(statearr_62035_62092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (14))){
var inst_61873 = (state_61982[(10)]);
var inst_61875 = fluree.db.util.async.channel_QMARK_(inst_61873);
var state_61982__$1 = state_61982;
var statearr_62036_62093 = state_61982__$1;
(statearr_62036_62093[(2)] = inst_61875);

(statearr_62036_62093[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (26))){
var inst_61948 = (state_61982[(8)]);
var inst_61952 = fluree.db.util.core.exception_QMARK_(inst_61948);
var state_61982__$1 = state_61982;
if(inst_61952){
var statearr_62037_62094 = state_61982__$1;
(statearr_62037_62094[(1)] = (28));

} else {
var statearr_62038_62095 = state_61982__$1;
(statearr_62038_62095[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (16))){
var inst_61878 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
if(cljs.core.truth_(inst_61878)){
var statearr_62039_62096 = state_61982__$1;
(statearr_62039_62096[(1)] = (17));

} else {
var statearr_62040_62097 = state_61982__$1;
(statearr_62040_62097[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (30))){
var inst_61968 = (state_61982[(2)]);
var state_61982__$1 = state_61982;
var statearr_62041_62098 = state_61982__$1;
(statearr_62041_62098[(2)] = inst_61968);

(statearr_62041_62098[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (10))){
var inst_61860 = (state_61982[(9)]);
var inst_61862 = (state_61982[(2)]);
var inst_61866 = cljs.core.sequential_QMARK_(inst_61860);
var state_61982__$1 = (function (){var statearr_62042 = state_61982;
(statearr_62042[(23)] = inst_61862);

return statearr_62042;
})();
if(inst_61866){
var statearr_62043_62099 = state_61982__$1;
(statearr_62043_62099[(1)] = (11));

} else {
var statearr_62044_62100 = state_61982__$1;
(statearr_62044_62100[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (18))){
var inst_61862 = (state_61982[(23)]);
var inst_61860 = (state_61982[(9)]);
var inst_61882 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61860], 0));
var inst_61883 = ["Error processing ledger request, no valid return channel: ",inst_61882].join('');
var inst_61884 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61862,inst_61883], 0));
var state_61982__$1 = state_61982;
var statearr_62045_62101 = state_61982__$1;
(statearr_62045_62101[(2)] = inst_61884);

(statearr_62045_62101[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61983 === (8))){
var inst_61900 = (state_61982[(13)]);
var inst_61901 = (state_61982[(15)]);
var inst_61899 = (state_61982[(16)]);
var inst_61860 = (state_61982[(9)]);
var _ = (function (){var statearr_62046 = state_61982;
(statearr_62046[(4)] = cljs.core.cons((20),(state_61982[(4)])));

return statearr_62046;
})();
var inst_61896 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_61860], 0));
var inst_61897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61860,(0),null);
var inst_61898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61860,(1),null);
var inst_61899__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61860,(2),null);
var inst_61900__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61860,(3),null);
var inst_61901__$1 = cljs.core.__destructure_map(inst_61900__$1);
var inst_61902 = fluree.db.util.core.random_uuid();
var inst_61903 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_61902);
var inst_61904 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61901__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_61903);
var inst_61905 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61901__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_61982__$1 = (function (){var statearr_62047 = state_61982;
(statearr_62047[(11)] = inst_61904);

(statearr_62047[(12)] = inst_61896);

(statearr_62047[(13)] = inst_61900__$1);

(statearr_62047[(14)] = inst_61905);

(statearr_62047[(15)] = inst_61901__$1);

(statearr_62047[(16)] = inst_61899__$1);

(statearr_62047[(17)] = inst_61897);

(statearr_62047[(18)] = inst_61898);

return statearr_62047;
})();
if(cljs.core.truth_(inst_61899__$1)){
var statearr_62048_62102 = state_61982__$1;
(statearr_62048_62102[(1)] = (21));

} else {
var statearr_62049_62103 = state_61982__$1;
(statearr_62049_62103[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2717__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2717__auto____0 = (function (){
var statearr_62050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62050[(0)] = fluree$db$connection$msg_producer_$_state_machine__2717__auto__);

(statearr_62050[(1)] = (1));

return statearr_62050;
});
var fluree$db$connection$msg_producer_$_state_machine__2717__auto____1 = (function (state_61982){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61982);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62051){var ex__2720__auto__ = e62051;
var statearr_62052_62104 = state_61982;
(statearr_62052_62104[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61982[(4)]))){
var statearr_62053_62105 = state_61982;
(statearr_62053_62105[(1)] = cljs.core.first((state_61982[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62106 = state_61982;
state_61982 = G__62106;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2717__auto__ = function(state_61982){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2717__auto____1.call(this,state_61982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2717__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2717__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62054 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62054[(6)] = c__2739__auto__);

return statearr_62054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62107 = conn;
var map__62107__$1 = cljs.core.__destructure_map(map__62107);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62107__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62192){
var state_val_62193 = (state_62192[(1)]);
if((state_val_62193 === (7))){
var inst_62188 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62194_62245 = state_62192__$1;
(statearr_62194_62245[(2)] = inst_62188);

(statearr_62194_62245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (20))){
var inst_62126 = (state_62192[(7)]);
var inst_62140 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62141 = [inst_62126];
var inst_62142 = cljs.core.PersistentHashMap.fromArrays(inst_62140,inst_62141);
var inst_62143 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_62142], 0));
var state_62192__$1 = state_62192;
var statearr_62195_62246 = state_62192__$1;
(statearr_62195_62246[(2)] = inst_62143);

(statearr_62195_62246[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (27))){
var state_62192__$1 = state_62192;
var statearr_62196_62247 = state_62192__$1;
(statearr_62196_62247[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (1))){
var inst_62108 = (0);
var state_62192__$1 = (function (){var statearr_62198 = state_62192;
(statearr_62198[(8)] = inst_62108);

return statearr_62198;
})();
var statearr_62199_62248 = state_62192__$1;
(statearr_62199_62248[(2)] = null);

(statearr_62199_62248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (24))){
var inst_62119 = (state_62192[(9)]);
var inst_62168 = fluree.db.util.core.exception_QMARK_(inst_62119);
var state_62192__$1 = state_62192;
if(inst_62168){
var statearr_62200_62249 = state_62192__$1;
(statearr_62200_62249[(1)] = (26));

} else {
var statearr_62201_62250 = state_62192__$1;
(statearr_62201_62250[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (4))){
var inst_62113 = (state_62192[(10)]);
var inst_62118 = (state_62192[(2)]);
var inst_62119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62118,(0),null);
var inst_62120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62118,(1),null);
var inst_62121 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62120,inst_62113);
var state_62192__$1 = (function (){var statearr_62202 = state_62192;
(statearr_62202[(9)] = inst_62119);

return statearr_62202;
})();
if(inst_62121){
var statearr_62203_62251 = state_62192__$1;
(statearr_62203_62251[(1)] = (5));

} else {
var statearr_62204_62252 = state_62192__$1;
(statearr_62204_62252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (15))){
var inst_62126 = (state_62192[(7)]);
var inst_62135 = typeof inst_62126 === 'string';
var state_62192__$1 = state_62192;
if(cljs.core.truth_(inst_62135)){
var statearr_62205_62253 = state_62192__$1;
(statearr_62205_62253[(1)] = (17));

} else {
var statearr_62206_62254 = state_62192__$1;
(statearr_62206_62254[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (21))){
var state_62192__$1 = state_62192;
var statearr_62207_62255 = state_62192__$1;
(statearr_62207_62255[(2)] = null);

(statearr_62207_62255[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (31))){
var inst_62182 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62208_62256 = state_62192__$1;
(statearr_62208_62256[(2)] = inst_62182);

(statearr_62208_62256[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (13))){
var inst_62152 = (state_62192[(2)]);
var inst_62153 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62154 = fluree.db.connection.close_websocket(inst_62153);
var inst_62155 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62156 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_62155);
var state_62192__$1 = (function (){var statearr_62209 = state_62192;
(statearr_62209[(11)] = inst_62154);

(statearr_62209[(12)] = inst_62152);

return statearr_62209;
})();
var statearr_62210_62257 = state_62192__$1;
(statearr_62210_62257[(2)] = inst_62156);

(statearr_62210_62257[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (22))){
var inst_62146 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62211_62258 = state_62192__$1;
(statearr_62211_62258[(2)] = inst_62146);

(statearr_62211_62258[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (29))){
var inst_62119 = (state_62192[(9)]);
var inst_62174 = fluree.db.util.json.parse(inst_62119);
var inst_62175 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62174], 0));
var inst_62176 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_62175], 0));
var inst_62177 = fluree.db.util.json.parse(inst_62119);
var inst_62178 = fluree.db.conn_events.process_events(conn,inst_62177);
var inst_62108 = (0);
var state_62192__$1 = (function (){var statearr_62212 = state_62192;
(statearr_62212[(8)] = inst_62108);

(statearr_62212[(13)] = inst_62178);

(statearr_62212[(14)] = inst_62176);

return statearr_62212;
})();
var statearr_62213_62259 = state_62192__$1;
(statearr_62213_62259[(2)] = null);

(statearr_62213_62259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (6))){
var inst_62119 = (state_62192[(9)]);
var inst_62164 = (inst_62119 == null);
var state_62192__$1 = state_62192;
if(cljs.core.truth_(inst_62164)){
var statearr_62214_62260 = state_62192__$1;
(statearr_62214_62260[(1)] = (23));

} else {
var statearr_62215_62261 = state_62192__$1;
(statearr_62215_62261[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (28))){
var inst_62184 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62216_62262 = state_62192__$1;
(statearr_62216_62262[(2)] = inst_62184);

(statearr_62216_62262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (25))){
var inst_62186 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62217_62263 = state_62192__$1;
(statearr_62217_62263[(2)] = inst_62186);

(statearr_62217_62263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (17))){
var inst_62126 = (state_62192[(7)]);
var inst_62137 = cljs.core.eval(inst_62126);
var state_62192__$1 = state_62192;
var statearr_62218_62264 = state_62192__$1;
(statearr_62218_62264[(2)] = inst_62137);

(statearr_62218_62264[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (3))){
var inst_62190 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62192__$1,inst_62190);
} else {
if((state_val_62193 === (12))){
var inst_62126 = (state_62192[(7)]);
var inst_62131 = cljs.core.fn_QMARK_(inst_62126);
var state_62192__$1 = state_62192;
if(inst_62131){
var statearr_62219_62265 = state_62192__$1;
(statearr_62219_62265[(1)] = (14));

} else {
var statearr_62220_62266 = state_62192__$1;
(statearr_62220_62266[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (2))){
var inst_62113 = (state_62192[(10)]);
var inst_62113__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_62114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62115 = [sub_chan,inst_62113__$1];
var inst_62116 = (new cljs.core.PersistentVector(null,2,(5),inst_62114,inst_62115,null));
var state_62192__$1 = (function (){var statearr_62221 = state_62192;
(statearr_62221[(10)] = inst_62113__$1);

return statearr_62221;
})();
return cljs.core.async.ioc_alts_BANG_(state_62192__$1,(4),inst_62116);
} else {
if((state_val_62193 === (23))){
var inst_62166 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_62192__$1 = state_62192;
var statearr_62222_62267 = state_62192__$1;
(statearr_62222_62267[(2)] = inst_62166);

(statearr_62222_62267[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (19))){
var inst_62148 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62223_62268 = state_62192__$1;
(statearr_62223_62268[(2)] = inst_62148);

(statearr_62223_62268[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (11))){
var inst_62129 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_62192__$1 = state_62192;
var statearr_62224_62269 = state_62192__$1;
(statearr_62224_62269[(2)] = inst_62129);

(statearr_62224_62269[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (9))){
var inst_62108 = (state_62192[(8)]);
var inst_62158 = fluree.db.connection.ping_transactor(conn);
var inst_62159 = (inst_62108 + (1));
var inst_62108__$1 = inst_62159;
var state_62192__$1 = (function (){var statearr_62225 = state_62192;
(statearr_62225[(8)] = inst_62108__$1);

(statearr_62225[(15)] = inst_62158);

return statearr_62225;
})();
var statearr_62226_62270 = state_62192__$1;
(statearr_62226_62270[(2)] = null);

(statearr_62226_62270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (5))){
var inst_62108 = (state_62192[(8)]);
var inst_62123 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_62108);
var state_62192__$1 = state_62192;
if(inst_62123){
var statearr_62227_62271 = state_62192__$1;
(statearr_62227_62271[(1)] = (8));

} else {
var statearr_62228_62272 = state_62192__$1;
(statearr_62228_62272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (14))){
var inst_62126 = (state_62192[(7)]);
var inst_62133 = (inst_62126.cljs$core$IFn$_invoke$arity$0 ? inst_62126.cljs$core$IFn$_invoke$arity$0() : inst_62126.call(null));
var state_62192__$1 = state_62192;
var statearr_62229_62273 = state_62192__$1;
(statearr_62229_62273[(2)] = inst_62133);

(statearr_62229_62273[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (26))){
var inst_62119 = (state_62192[(9)]);
var inst_62170 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62119], 0));
var inst_62108 = (0);
var state_62192__$1 = (function (){var statearr_62230 = state_62192;
(statearr_62230[(8)] = inst_62108);

(statearr_62230[(16)] = inst_62170);

return statearr_62230;
})();
var statearr_62231_62274 = state_62192__$1;
(statearr_62231_62274[(2)] = null);

(statearr_62231_62274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (16))){
var inst_62150 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62232_62275 = state_62192__$1;
(statearr_62232_62275[(2)] = inst_62150);

(statearr_62232_62275[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (30))){
var state_62192__$1 = state_62192;
var statearr_62233_62276 = state_62192__$1;
(statearr_62233_62276[(2)] = null);

(statearr_62233_62276[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (10))){
var inst_62162 = (state_62192[(2)]);
var state_62192__$1 = state_62192;
var statearr_62234_62277 = state_62192__$1;
(statearr_62234_62277[(2)] = inst_62162);

(statearr_62234_62277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (18))){
var state_62192__$1 = state_62192;
var statearr_62235_62278 = state_62192__$1;
(statearr_62235_62278[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62193 === (8))){
var inst_62126 = (state_62192[(7)]);
var inst_62125 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_62126__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62127 = (inst_62126__$1 == null);
var state_62192__$1 = (function (){var statearr_62237 = state_62192;
(statearr_62237[(17)] = inst_62125);

(statearr_62237[(7)] = inst_62126__$1);

return statearr_62237;
})();
if(cljs.core.truth_(inst_62127)){
var statearr_62238_62279 = state_62192__$1;
(statearr_62238_62279[(1)] = (11));

} else {
var statearr_62239_62280 = state_62192__$1;
(statearr_62239_62280[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2717__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2717__auto____0 = (function (){
var statearr_62240 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62240[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2717__auto__);

(statearr_62240[(1)] = (1));

return statearr_62240;
});
var fluree$db$connection$msg_consumer_$_state_machine__2717__auto____1 = (function (state_62192){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62192);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62241){var ex__2720__auto__ = e62241;
var statearr_62242_62281 = state_62192;
(statearr_62242_62281[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62192[(4)]))){
var statearr_62243_62282 = state_62192;
(statearr_62243_62282[(1)] = cljs.core.first((state_62192[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62283 = state_62192;
state_62192 = G__62283;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2717__auto__ = function(state_62192){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2717__auto____1.call(this,state_62192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2717__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2717__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62244 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62244[(6)] = c__2739__auto__);

return statearr_62244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62285 = arguments.length;
switch (G__62285) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62286 = opts;
var map__62286__$1 = cljs.core.__destructure_map(map__62286);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62286__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62286__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62338){
var state_val_62339 = (state_62338[(1)]);
if((state_val_62339 === (7))){
var inst_62296 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62298 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62299 = (new cljs.core.PersistentVector(null,2,(5),inst_62297,inst_62298,null));
var inst_62300 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62296,inst_62299);
var state_62338__$1 = state_62338;
var statearr_62340_62371 = state_62338__$1;
(statearr_62340_62371[(2)] = inst_62300);

(statearr_62340_62371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (1))){
var state_62338__$1 = state_62338;
var statearr_62341_62372 = state_62338__$1;
(statearr_62341_62372[(2)] = null);

(statearr_62341_62372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (4))){
var inst_62287 = (state_62338[(2)]);
var state_62338__$1 = state_62338;
var statearr_62342_62373 = state_62338__$1;
(statearr_62342_62373[(2)] = inst_62287);

(statearr_62342_62373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (15))){
var inst_62307 = (state_62338[(7)]);
var inst_62326 = (state_62338[(2)]);
var inst_62327 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62328 = [(5000),inst_62326,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62329 = cljs.core.PersistentHashMap.fromArrays(inst_62327,inst_62328);
var inst_62330 = fluree.db.util.xhttp.get(inst_62307,inst_62329);
var state_62338__$1 = state_62338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62338__$1,(16),inst_62330);
} else {
if((state_val_62339 === (13))){
var inst_62307 = (state_62338[(7)]);
var inst_62317 = (state_62338[(8)]);
var inst_62319 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62320 = [inst_62317];
var inst_62321 = cljs.core.PersistentHashMap.fromArrays(inst_62319,inst_62320);
var inst_62322 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62307,inst_62321,private$);
var inst_62323 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62322);
var state_62338__$1 = state_62338;
var statearr_62343_62374 = state_62338__$1;
(statearr_62343_62374[(2)] = inst_62323);

(statearr_62343_62374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (6))){
var inst_62293 = (state_62338[(9)]);
var state_62338__$1 = state_62338;
var statearr_62344_62375 = state_62338__$1;
(statearr_62344_62375[(2)] = inst_62293);

(statearr_62344_62375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (3))){
var inst_62336 = (state_62338[(2)]);
var state_62338__$1 = state_62338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62338__$1,inst_62336);
} else {
if((state_val_62339 === (12))){
var inst_62317 = (state_62338[(2)]);
var state_62338__$1 = (function (){var statearr_62345 = state_62338;
(statearr_62345[(8)] = inst_62317);

return statearr_62345;
})();
if(cljs.core.truth_(private$)){
var statearr_62346_62376 = state_62338__$1;
(statearr_62346_62376[(1)] = (13));

} else {
var statearr_62347_62377 = state_62338__$1;
(statearr_62347_62377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (2))){
var inst_62293 = (state_62338[(9)]);
var _ = (function (){var statearr_62348 = state_62338;
(statearr_62348[(4)] = cljs.core.cons((5),(state_62338[(4)])));

return statearr_62348;
})();
var inst_62293__$1 = jwt;
var state_62338__$1 = (function (){var statearr_62349 = state_62338;
(statearr_62349[(9)] = inst_62293__$1);

return statearr_62349;
})();
if(cljs.core.truth_(inst_62293__$1)){
var statearr_62350_62378 = state_62338__$1;
(statearr_62350_62378[(1)] = (6));

} else {
var statearr_62351_62379 = state_62338__$1;
(statearr_62351_62379[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (11))){
var inst_62311 = (state_62338[(10)]);
var state_62338__$1 = state_62338;
var statearr_62353_62380 = state_62338__$1;
(statearr_62353_62380[(2)] = inst_62311);

(statearr_62353_62380[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (9))){
var inst_62302 = (state_62338[(11)]);
var inst_62303 = (state_62338[(12)]);
var inst_62306 = (state_62338[(2)]);
var inst_62307 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62306),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62303)].join('');
var inst_62309 = ["Accept"];
var inst_62310 = ["application/json"];
var inst_62311 = cljs.core.PersistentHashMap.fromArrays(inst_62309,inst_62310);
var state_62338__$1 = (function (){var statearr_62354 = state_62338;
(statearr_62354[(7)] = inst_62307);

(statearr_62354[(10)] = inst_62311);

return statearr_62354;
})();
if(cljs.core.truth_(inst_62302)){
var statearr_62355_62381 = state_62338__$1;
(statearr_62355_62381[(1)] = (10));

} else {
var statearr_62356_62382 = state_62338__$1;
(statearr_62356_62382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (5))){
var _ = (function (){var statearr_62357 = state_62338;
(statearr_62357[(4)] = cljs.core.rest((state_62338[(4)])));

return statearr_62357;
})();
var state_62338__$1 = state_62338;
var ex62352 = (state_62338__$1[(2)]);
var statearr_62358_62383 = state_62338__$1;
(statearr_62358_62383[(5)] = ex62352);


if((ex62352 instanceof Error)){
var statearr_62359_62384 = state_62338__$1;
(statearr_62359_62384[(1)] = (4));

(statearr_62359_62384[(5)] = null);

} else {
throw ex62352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (14))){
var inst_62317 = (state_62338[(8)]);
var state_62338__$1 = state_62338;
var statearr_62360_62385 = state_62338__$1;
(statearr_62360_62385[(2)] = inst_62317);

(statearr_62360_62385[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (16))){
var inst_62332 = (state_62338[(2)]);
var inst_62333 = fluree.db.util.async.throw_err(inst_62332);
var _ = (function (){var statearr_62361 = state_62338;
(statearr_62361[(4)] = cljs.core.rest((state_62338[(4)])));

return statearr_62361;
})();
var state_62338__$1 = state_62338;
var statearr_62362_62386 = state_62338__$1;
(statearr_62362_62386[(2)] = inst_62333);

(statearr_62362_62386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (10))){
var inst_62302 = (state_62338[(11)]);
var inst_62311 = (state_62338[(10)]);
var inst_62313 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62302)].join('');
var inst_62314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62311,"Authorization",inst_62313);
var state_62338__$1 = state_62338;
var statearr_62363_62387 = state_62338__$1;
(statearr_62363_62387[(2)] = inst_62314);

(statearr_62363_62387[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62339 === (8))){
var inst_62302 = (state_62338[(2)]);
var inst_62303 = clojure.string.replace(k,"_","/");
var inst_62304 = fluree.db.connection.get_server(conn_id,servers);
var state_62338__$1 = (function (){var statearr_62364 = state_62338;
(statearr_62364[(11)] = inst_62302);

(statearr_62364[(12)] = inst_62303);

return statearr_62364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62338__$1,(9),inst_62304);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2717__auto__ = null;
var fluree$db$connection$state_machine__2717__auto____0 = (function (){
var statearr_62365 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62365[(0)] = fluree$db$connection$state_machine__2717__auto__);

(statearr_62365[(1)] = (1));

return statearr_62365;
});
var fluree$db$connection$state_machine__2717__auto____1 = (function (state_62338){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62338);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62366){var ex__2720__auto__ = e62366;
var statearr_62367_62388 = state_62338;
(statearr_62367_62388[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62338[(4)]))){
var statearr_62368_62389 = state_62338;
(statearr_62368_62389[(1)] = cljs.core.first((state_62338[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62390 = state_62338;
state_62338 = G__62390;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2717__auto__ = function(state_62338){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2717__auto____1.call(this,state_62338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2717__auto____0;
fluree$db$connection$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2717__auto____1;
return fluree$db$connection$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62369 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62369[(6)] = c__2739__auto__);

return statearr_62369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62391_SHARP_){
if(cljs.core.truth_(p1__62391_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62392_SHARP_){
var or__4212__auto__ = p1__62392_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e62393){var e = e62393;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62394 = opts;
var map__62394__$1 = cljs.core.__destructure_map(map__62394);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62394__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62394__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62395_62396 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62395_62396.cljs$core$IFn$_invoke$arity$0 ? fexpr__62395_62396.cljs$core$IFn$_invoke$arity$0() : fexpr__62395_62396.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___62437 = arguments.length;
var i__4819__auto___62438 = (0);
while(true){
if((i__4819__auto___62438 < len__4818__auto___62437)){
args__4824__auto__.push((arguments[i__4819__auto___62438]));

var G__62439 = (i__4819__auto___62438 + (1));
i__4819__auto___62438 = G__62439;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62399){
var vec__62400 = p__62399;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62400,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2739__auto___62440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62420){
var state_val_62421 = (state_62420[(1)]);
if((state_val_62421 === (1))){
var inst_62403 = fluree.db.connection.get_socket(conn);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62420__$1,(2),inst_62403);
} else {
if((state_val_62421 === (2))){
var inst_62406 = (state_62420[(7)]);
var inst_62405 = (state_62420[(8)]);
var inst_62405__$1 = (state_62420[(2)]);
var inst_62406__$1 = (inst_62405__$1 == null);
var state_62420__$1 = (function (){var statearr_62422 = state_62420;
(statearr_62422[(7)] = inst_62406__$1);

(statearr_62422[(8)] = inst_62405__$1);

return statearr_62422;
})();
if(cljs.core.truth_(inst_62406__$1)){
var statearr_62423_62441 = state_62420__$1;
(statearr_62423_62441[(1)] = (3));

} else {
var statearr_62424_62442 = state_62420__$1;
(statearr_62424_62442[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (3))){
var inst_62406 = (state_62420[(7)]);
var state_62420__$1 = state_62420;
var statearr_62425_62443 = state_62420__$1;
(statearr_62425_62443[(2)] = inst_62406);

(statearr_62425_62443[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (4))){
var inst_62405 = (state_62420[(8)]);
var inst_62409 = fluree.db.util.core.exception_QMARK_(inst_62405);
var state_62420__$1 = state_62420;
var statearr_62426_62444 = state_62420__$1;
(statearr_62426_62444[(2)] = inst_62409);

(statearr_62426_62444[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (5))){
var inst_62411 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
if(cljs.core.truth_(inst_62411)){
var statearr_62427_62445 = state_62420__$1;
(statearr_62427_62445[(1)] = (6));

} else {
var statearr_62428_62446 = state_62420__$1;
(statearr_62428_62446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (6))){
var inst_62405 = (state_62420[(8)]);
var inst_62413 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62405,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62414 = cljs.core.async.close_BANG_(conn);
var state_62420__$1 = (function (){var statearr_62429 = state_62420;
(statearr_62429[(9)] = inst_62413);

return statearr_62429;
})();
var statearr_62430_62447 = state_62420__$1;
(statearr_62430_62447[(2)] = inst_62414);

(statearr_62430_62447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (7))){
var inst_62416 = fluree.db.connection.msg_consumer(conn);
var state_62420__$1 = state_62420;
var statearr_62431_62448 = state_62420__$1;
(statearr_62431_62448[(2)] = inst_62416);

(statearr_62431_62448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62421 === (8))){
var inst_62418 = (state_62420[(2)]);
var state_62420__$1 = state_62420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62420__$1,inst_62418);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2717__auto__ = null;
var fluree$db$connection$state_machine__2717__auto____0 = (function (){
var statearr_62432 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62432[(0)] = fluree$db$connection$state_machine__2717__auto__);

(statearr_62432[(1)] = (1));

return statearr_62432;
});
var fluree$db$connection$state_machine__2717__auto____1 = (function (state_62420){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62420);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62433){var ex__2720__auto__ = e62433;
var statearr_62434_62449 = state_62420;
(statearr_62434_62449[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62420[(4)]))){
var statearr_62435_62450 = state_62420;
(statearr_62435_62450[(1)] = cljs.core.first((state_62420[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62451 = state_62420;
state_62420 = G__62451;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2717__auto__ = function(state_62420){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2717__auto____1.call(this,state_62420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2717__auto____0;
fluree$db$connection$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2717__auto____1;
return fluree$db$connection$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62436 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62436[(6)] = c__2739__auto___62440);

return statearr_62436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62397){
var G__62398 = cljs.core.first(seq62397);
var seq62397__$1 = cljs.core.next(seq62397);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62398,seq62397__$1);
}));

