// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28725 = arguments.length;
var i__4819__auto___28726 = (0);
while(true){
if((i__4819__auto___28726 < len__4818__auto___28725)){
args__4824__auto__.push((arguments[i__4819__auto___28726]));

var G__28727 = (i__4819__auto___28726 + (1));
i__4819__auto___28726 = G__28727;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28722){
var G__28723 = cljs.core.first(seq28722);
var seq28722__$1 = cljs.core.next(seq28722);
var G__28724 = cljs.core.first(seq28722__$1);
var seq28722__$2 = cljs.core.next(seq28722__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28723,G__28724,seq28722__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28728){var e = e28728;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28729){var e = e28729;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28730){var e = e28730;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28731){var e = e28731;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28732){var e = e28732;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28735 = arguments.length;
var i__4819__auto___28736 = (0);
while(true){
if((i__4819__auto___28736 < len__4818__auto___28735)){
args__4824__auto__.push((arguments[i__4819__auto___28736]));

var G__28737 = (i__4819__auto___28736 + (1));
i__4819__auto___28736 = G__28737;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28734){var e = e28734;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28733){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28733));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28740 = arguments.length;
var i__4819__auto___28741 = (0);
while(true){
if((i__4819__auto___28741 < len__4818__auto___28740)){
args__4824__auto__.push((arguments[i__4819__auto___28741]));

var G__28742 = (i__4819__auto___28741 + (1));
i__4819__auto___28741 = G__28742;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28739){var e = e28739;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28738){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28738));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28743){var e = e28743;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28746 = arguments.length;
var i__4819__auto___28747 = (0);
while(true){
if((i__4819__auto___28747 < len__4818__auto___28746)){
args__4824__auto__.push((arguments[i__4819__auto___28747]));

var G__28748 = (i__4819__auto___28747 + (1));
i__4819__auto___28747 = G__28748;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28745){var e = e28745;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28744){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28744));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28751 = arguments.length;
var i__4819__auto___28752 = (0);
while(true){
if((i__4819__auto___28752 < len__4818__auto___28751)){
args__4824__auto__.push((arguments[i__4819__auto___28752]));

var G__28753 = (i__4819__auto___28752 + (1));
i__4819__auto___28752 = G__28753;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28750){var e = e28750;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28749){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28749));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28754){var e = e28754;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28755){var e = e28755;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28758 = arguments.length;
var i__4819__auto___28759 = (0);
while(true){
if((i__4819__auto___28759 < len__4818__auto___28758)){
args__4824__auto__.push((arguments[i__4819__auto___28759]));

var G__28760 = (i__4819__auto___28759 + (1));
i__4819__auto___28759 = G__28760;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28757){var e = e28757;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28756){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28756));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28763 = arguments.length;
var i__4819__auto___28764 = (0);
while(true){
if((i__4819__auto___28764 < len__4818__auto___28763)){
args__4824__auto__.push((arguments[i__4819__auto___28764]));

var G__28765 = (i__4819__auto___28764 + (1));
i__4819__auto___28764 = G__28765;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28762){var e = e28762;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28761){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28761));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28768 = arguments.length;
var i__4819__auto___28769 = (0);
while(true){
if((i__4819__auto___28769 < len__4818__auto___28768)){
args__4824__auto__.push((arguments[i__4819__auto___28769]));

var G__28770 = (i__4819__auto___28769 + (1));
i__4819__auto___28769 = G__28770;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28767){var e = e28767;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28766){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28766));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28773 = arguments.length;
var i__4819__auto___28774 = (0);
while(true){
if((i__4819__auto___28774 < len__4818__auto___28773)){
args__4824__auto__.push((arguments[i__4819__auto___28774]));

var G__28775 = (i__4819__auto___28774 + (1));
i__4819__auto___28774 = G__28775;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28772){var e = e28772;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28771){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28771));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28778 = arguments.length;
var i__4819__auto___28779 = (0);
while(true){
if((i__4819__auto___28779 < len__4818__auto___28778)){
args__4824__auto__.push((arguments[i__4819__auto___28779]));

var G__28780 = (i__4819__auto___28779 + (1));
i__4819__auto___28779 = G__28780;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28777){var e = e28777;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28776){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28776));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28783 = arguments.length;
var i__4819__auto___28784 = (0);
while(true){
if((i__4819__auto___28784 < len__4818__auto___28783)){
args__4824__auto__.push((arguments[i__4819__auto___28784]));

var G__28785 = (i__4819__auto___28784 + (1));
i__4819__auto___28784 = G__28785;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28782){var e = e28782;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28781){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28781));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28788 = arguments.length;
var i__4819__auto___28789 = (0);
while(true){
if((i__4819__auto___28789 < len__4818__auto___28788)){
args__4824__auto__.push((arguments[i__4819__auto___28789]));

var G__28790 = (i__4819__auto___28789 + (1));
i__4819__auto___28789 = G__28790;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28787){var e = e28787;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28786){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28786));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28792 = arguments.length;
switch (G__28792) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28820){
var state_val_28821 = (state_28820[(1)]);
if((state_val_28821 === (7))){
var inst_28805 = (state_28820[(7)]);
var inst_28808 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28805,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28820__$1 = state_28820;
var statearr_28822_28908 = state_28820__$1;
(statearr_28822_28908[(2)] = inst_28808);

(statearr_28822_28908[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (1))){
var state_28820__$1 = state_28820;
var statearr_28823_28909 = state_28820__$1;
(statearr_28823_28909[(2)] = null);

(statearr_28823_28909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (4))){
var inst_28793 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
var statearr_28824_28910 = state_28820__$1;
(statearr_28824_28910[(2)] = inst_28793);

(statearr_28824_28910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (6))){
var inst_28805 = (state_28820[(7)]);
var inst_28805__$1 = (state_28820[(2)]);
var inst_28806 = fluree.db.util.core.exception_QMARK_(inst_28805__$1);
var state_28820__$1 = (function (){var statearr_28825 = state_28820;
(statearr_28825[(7)] = inst_28805__$1);

return statearr_28825;
})();
if(inst_28806){
var statearr_28826_28911 = state_28820__$1;
(statearr_28826_28911[(1)] = (7));

} else {
var statearr_28827_28912 = state_28820__$1;
(statearr_28827_28912[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (3))){
var inst_28818 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28820__$1,inst_28818);
} else {
if((state_val_28821 === (2))){
var inst_28799 = (state_28820[(8)]);
var _ = (function (){var statearr_28829 = state_28820;
(statearr_28829[(4)] = cljs.core.cons((5),(state_28820[(4)])));

return statearr_28829;
})();
var inst_28799__$1 = cljs.core.volatile_BANG_((0));
var inst_28800 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28801 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28800,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28799__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28802 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28801);
var inst_28803 = fluree.db.query.fql.query(db,inst_28802);
var state_28820__$1 = (function (){var statearr_28830 = state_28820;
(statearr_28830[(8)] = inst_28799__$1);

return statearr_28830;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28820__$1,(6),inst_28803);
} else {
if((state_val_28821 === (9))){
var inst_28815 = (state_28820[(2)]);
var _ = (function (){var statearr_28831 = state_28820;
(statearr_28831[(4)] = cljs.core.rest((state_28820[(4)])));

return statearr_28831;
})();
var state_28820__$1 = state_28820;
var statearr_28832_28913 = state_28820__$1;
(statearr_28832_28913[(2)] = inst_28815);

(statearr_28832_28913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (5))){
var _ = (function (){var statearr_28833 = state_28820;
(statearr_28833[(4)] = cljs.core.rest((state_28820[(4)])));

return statearr_28833;
})();
var state_28820__$1 = state_28820;
var ex28828 = (state_28820__$1[(2)]);
var statearr_28834_28914 = state_28820__$1;
(statearr_28834_28914[(5)] = ex28828);


if((ex28828 instanceof Error)){
var statearr_28835_28915 = state_28820__$1;
(statearr_28835_28915[(1)] = (4));

(statearr_28835_28915[(5)] = null);

} else {
throw ex28828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (8))){
var inst_28799 = (state_28820[(8)]);
var inst_28805 = (state_28820[(7)]);
var inst_28810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28811 = cljs.core.deref(inst_28799);
var inst_28812 = [inst_28805,inst_28811];
var inst_28813 = (new cljs.core.PersistentVector(null,2,(5),inst_28810,inst_28812,null));
var state_28820__$1 = state_28820;
var statearr_28836_28916 = state_28820__$1;
(statearr_28836_28916[(2)] = inst_28813);

(statearr_28836_28916[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2717__auto____0 = (function (){
var statearr_28837 = [null,null,null,null,null,null,null,null,null];
(statearr_28837[(0)] = fluree$db$dbfunctions$internal$state_machine__2717__auto__);

(statearr_28837[(1)] = (1));

return statearr_28837;
});
var fluree$db$dbfunctions$internal$state_machine__2717__auto____1 = (function (state_28820){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28820);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28838){var ex__2720__auto__ = e28838;
var statearr_28839_28917 = state_28820;
(statearr_28839_28917[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28820[(4)]))){
var statearr_28840_28918 = state_28820;
(statearr_28840_28918[(1)] = cljs.core.first((state_28820[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28919 = state_28820;
state_28820 = G__28919;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2717__auto__ = function(state_28820){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____1.call(this,state_28820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28841 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28841[(6)] = c__2739__auto__);

return statearr_28841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28886){
var state_val_28887 = (state_28886[(1)]);
if((state_val_28887 === (7))){
var inst_28872 = (state_28886[(2)]);
var inst_28873 = fluree.db.query.fql.query(db,inst_28872);
var state_28886__$1 = state_28886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28886__$1,(8),inst_28873);
} else {
if((state_val_28887 === (1))){
var inst_28842 = typeof select === 'string';
var state_28886__$1 = state_28886;
if(cljs.core.truth_(inst_28842)){
var statearr_28888_28920 = state_28886__$1;
(statearr_28888_28920[(1)] = (2));

} else {
var statearr_28889_28921 = state_28886__$1;
(statearr_28889_28921[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (4))){
var inst_28848 = (state_28886[(7)]);
var inst_28855 = (state_28886[(8)]);
var inst_28847 = (state_28886[(2)]);
var inst_28848__$1 = cljs.core.volatile_BANG_((0));
var inst_28849 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28850 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28851 = [inst_28848__$1,(100000)];
var inst_28852 = cljs.core.PersistentHashMap.fromArrays(inst_28850,inst_28851);
var inst_28853 = [inst_28847,from,where,block,limit,inst_28852];
var inst_28854 = cljs.core.PersistentHashMap.fromArrays(inst_28849,inst_28853);
var inst_28855__$1 = fluree.db.util.core.without_nils(inst_28854);
var inst_28856 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28855__$1);
var inst_28857 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28855__$1);
var inst_28858 = cljs.core.first(inst_28857);
var inst_28859 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28858], 0));
var inst_28860 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28859);
var inst_28861 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28855__$1);
var inst_28862 = cljs.core.last(inst_28861);
var inst_28863 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28862], 0));
var inst_28864 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28863);
var inst_28865 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28856,inst_28860,inst_28864], 0));
var state_28886__$1 = (function (){var statearr_28890 = state_28886;
(statearr_28890[(7)] = inst_28848__$1);

(statearr_28890[(8)] = inst_28855__$1);

return statearr_28890;
})();
if(cljs.core.truth_(inst_28865)){
var statearr_28891_28922 = state_28886__$1;
(statearr_28891_28922[(1)] = (5));

} else {
var statearr_28892_28923 = state_28886__$1;
(statearr_28892_28923[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (6))){
var inst_28855 = (state_28886[(8)]);
var state_28886__$1 = state_28886;
var statearr_28893_28924 = state_28886__$1;
(statearr_28893_28924[(2)] = inst_28855);

(statearr_28893_28924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (3))){
var state_28886__$1 = state_28886;
var statearr_28894_28925 = state_28886__$1;
(statearr_28894_28925[(2)] = select);

(statearr_28894_28925[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (2))){
var inst_28844 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28886__$1 = state_28886;
var statearr_28895_28926 = state_28886__$1;
(statearr_28895_28926[(2)] = inst_28844);

(statearr_28895_28926[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (11))){
var inst_28884 = (state_28886[(2)]);
var state_28886__$1 = state_28886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28886__$1,inst_28884);
} else {
if((state_val_28887 === (9))){
var inst_28875 = (state_28886[(9)]);
var state_28886__$1 = state_28886;
var statearr_28896_28927 = state_28886__$1;
(statearr_28896_28927[(2)] = inst_28875);

(statearr_28896_28927[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (5))){
var inst_28855 = (state_28886[(8)]);
var inst_28867 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28855);
var inst_28868 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28867);
var inst_28869 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28855,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28868);
var state_28886__$1 = state_28886;
var statearr_28897_28928 = state_28886__$1;
(statearr_28897_28928[(2)] = inst_28869);

(statearr_28897_28928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (10))){
var inst_28848 = (state_28886[(7)]);
var inst_28875 = (state_28886[(9)]);
var inst_28879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28880 = cljs.core.deref(inst_28848);
var inst_28881 = [inst_28875,inst_28880];
var inst_28882 = (new cljs.core.PersistentVector(null,2,(5),inst_28879,inst_28881,null));
var state_28886__$1 = state_28886;
var statearr_28898_28929 = state_28886__$1;
(statearr_28898_28929[(2)] = inst_28882);

(statearr_28898_28929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (8))){
var inst_28875 = (state_28886[(9)]);
var inst_28875__$1 = (state_28886[(2)]);
var inst_28876 = fluree.db.util.core.exception_QMARK_(inst_28875__$1);
var state_28886__$1 = (function (){var statearr_28899 = state_28886;
(statearr_28899[(9)] = inst_28875__$1);

return statearr_28899;
})();
if(inst_28876){
var statearr_28900_28930 = state_28886__$1;
(statearr_28900_28930[(1)] = (9));

} else {
var statearr_28901_28931 = state_28886__$1;
(statearr_28901_28931[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2717__auto____0 = (function (){
var statearr_28902 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28902[(0)] = fluree$db$dbfunctions$internal$state_machine__2717__auto__);

(statearr_28902[(1)] = (1));

return statearr_28902;
});
var fluree$db$dbfunctions$internal$state_machine__2717__auto____1 = (function (state_28886){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28886);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28903){var ex__2720__auto__ = e28903;
var statearr_28904_28932 = state_28886;
(statearr_28904_28932[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28886[(4)]))){
var statearr_28905_28933 = state_28886;
(statearr_28905_28933[(1)] = cljs.core.first((state_28886[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28934 = state_28886;
state_28886 = G__28934;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2717__auto__ = function(state_28886){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____1.call(this,state_28886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28906 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28906[(6)] = c__2739__auto__);

return statearr_28906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28938 = path;
var vec__28939 = G__28938;
var seq__28940 = cljs.core.seq(vec__28939);
var first__28941 = cljs.core.first(seq__28940);
var seq__28940__$1 = cljs.core.next(seq__28940);
var var$ = first__28941;
var r = seq__28940__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28938__$1 = G__28938;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28945 = G__28938__$1;
var seq__28946 = cljs.core.seq(vec__28945);
var first__28947 = cljs.core.first(seq__28946);
var seq__28946__$1 = cljs.core.next(seq__28946);
var var$__$1 = first__28947;
var r__$1 = seq__28946__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28948 = r__$1;
var G__28949 = n__$2;
var G__28950 = next_clauses;
G__28938__$1 = G__28948;
n__$1 = G__28949;
where_clauses__$1 = G__28950;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28951 = r__$1;
var G__28952 = next_n;
var G__28953 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28938__$1 = G__28951;
n__$1 = G__28952;
where_clauses__$1 = G__28953;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28990){
var state_val_28991 = (state_28990[(1)]);
if((state_val_28991 === (7))){
var inst_28963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28964 = [path];
var inst_28965 = (new cljs.core.PersistentVector(null,1,(5),inst_28963,inst_28964,null));
var state_28990__$1 = state_28990;
var statearr_28992_29020 = state_28990__$1;
(statearr_28992_29020[(2)] = inst_28965);

(statearr_28992_29020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (1))){
var state_28990__$1 = state_28990;
var statearr_28993_29021 = state_28990__$1;
(statearr_28993_29021[(2)] = null);

(statearr_28993_29021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (4))){
var inst_28954 = (state_28990[(2)]);
var state_28990__$1 = state_28990;
var statearr_28994_29022 = state_28990__$1;
(statearr_28994_29022[(2)] = inst_28954);

(statearr_28994_29022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (13))){
var inst_28981 = (state_28990[(2)]);
var inst_28982 = fluree.db.util.async.throw_err(inst_28981);
var _ = (function (){var statearr_28995 = state_28990;
(statearr_28995[(4)] = cljs.core.rest((state_28990[(4)])));

return statearr_28995;
})();
var state_28990__$1 = state_28990;
var statearr_28996_29023 = state_28990__$1;
(statearr_28996_29023[(2)] = inst_28982);

(statearr_28996_29023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (6))){
var state_28990__$1 = state_28990;
var statearr_28998_29024 = state_28990__$1;
(statearr_28998_29024[(2)] = path);

(statearr_28998_29024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (3))){
var inst_28988 = (state_28990[(2)]);
var state_28990__$1 = state_28990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28990__$1,inst_28988);
} else {
if((state_val_28991 === (12))){
var _ = (function (){var statearr_28999 = state_28990;
(statearr_28999[(4)] = cljs.core.rest((state_28990[(4)])));

return statearr_28999;
})();
var state_28990__$1 = state_28990;
var ex28997 = (state_28990__$1[(2)]);
var statearr_29000_29025 = state_28990__$1;
(statearr_29000_29025[(5)] = ex28997);


var statearr_29001_29026 = state_28990__$1;
(statearr_29001_29026[(1)] = (11));

(statearr_29001_29026[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (2))){
var _ = (function (){var statearr_29002 = state_28990;
(statearr_29002[(4)] = cljs.core.cons((5),(state_28990[(4)])));

return statearr_29002;
})();
var inst_28960 = cljs.core.vector_QMARK_(path);
var state_28990__$1 = state_28990;
if(inst_28960){
var statearr_29003_29027 = state_28990__$1;
(statearr_29003_29027[(1)] = (6));

} else {
var statearr_29004_29028 = state_28990__$1;
(statearr_29004_29028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (11))){
var inst_28967 = (state_28990[(7)]);
var inst_28972 = (state_28990[(2)]);
var inst_28973 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28972,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28967,endSubject], 0));
var state_28990__$1 = state_28990;
var statearr_29006_29029 = state_28990__$1;
(statearr_29006_29029[(2)] = inst_28973);

(statearr_29006_29029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (9))){
var inst_28971 = (state_28990[(8)]);
var _ = (function (){var statearr_29007 = state_28990;
(statearr_29007[(4)] = cljs.core.cons((12),(state_28990[(4)])));

return statearr_29007;
})();
var inst_28979 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28971);
var state_28990__$1 = state_28990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28990__$1,(13),inst_28979);
} else {
if((state_val_28991 === (5))){
var _ = (function (){var statearr_29008 = state_28990;
(statearr_29008[(4)] = cljs.core.rest((state_28990[(4)])));

return statearr_29008;
})();
var state_28990__$1 = state_28990;
var ex29005 = (state_28990__$1[(2)]);
var statearr_29009_29030 = state_28990__$1;
(statearr_29009_29030[(5)] = ex29005);


if((ex29005 instanceof Error)){
var statearr_29010_29031 = state_28990__$1;
(statearr_29010_29031[(1)] = (4));

(statearr_29010_29031[(5)] = null);

} else {
throw ex29005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (10))){
var inst_28985 = (state_28990[(2)]);
var _ = (function (){var statearr_29011 = state_28990;
(statearr_29011[(4)] = cljs.core.rest((state_28990[(4)])));

return statearr_29011;
})();
var state_28990__$1 = state_28990;
var statearr_29012_29032 = state_28990__$1;
(statearr_29012_29032[(2)] = inst_28985);

(statearr_29012_29032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28991 === (8))){
var inst_28967 = (state_28990[(7)]);
var inst_28967__$1 = (state_28990[(2)]);
var inst_28968 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28967__$1,endSubject);
var inst_28969 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28970 = ["?var1",inst_28968];
var inst_28971 = cljs.core.PersistentHashMap.fromArrays(inst_28969,inst_28970);
var state_28990__$1 = (function (){var statearr_29013 = state_28990;
(statearr_29013[(7)] = inst_28967__$1);

(statearr_29013[(8)] = inst_28971);

return statearr_29013;
})();
var statearr_29014_29033 = state_28990__$1;
(statearr_29014_29033[(2)] = null);

(statearr_29014_29033[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_29015 = [null,null,null,null,null,null,null,null,null];
(statearr_29015[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__);

(statearr_29015[(1)] = (1));

return statearr_29015;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____1 = (function (state_28990){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28990);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29016){var ex__2720__auto__ = e29016;
var statearr_29017_29034 = state_28990;
(statearr_29017_29034[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28990[(4)]))){
var statearr_29018_29035 = state_28990;
(statearr_29018_29035[(1)] = cljs.core.first((state_28990[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29036 = state_28990;
state_28990 = G__29036;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__ = function(state_28990){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____1.call(this,state_28990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29019 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29019[(6)] = c__2739__auto__);

return statearr_29019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e29037){var e = e29037;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29038){var e = e29038;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e29039){var e = e29039;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e29040){var e = e29040;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29043 = arguments.length;
var i__4819__auto___29044 = (0);
while(true){
if((i__4819__auto___29044 < len__4818__auto___29043)){
args__4824__auto__.push((arguments[i__4819__auto___29044]));

var G__29045 = (i__4819__auto___29044 + (1));
i__4819__auto___29044 = G__29045;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e29042){var e = e29042;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29041){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29041));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29048 = arguments.length;
var i__4819__auto___29049 = (0);
while(true){
if((i__4819__auto___29049 < len__4818__auto___29048)){
args__4824__auto__.push((arguments[i__4819__auto___29049]));

var G__29050 = (i__4819__auto___29049 + (1));
i__4819__auto___29049 = G__29050;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e29047){var e = e29047;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29046){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29046));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29053 = arguments.length;
var i__4819__auto___29054 = (0);
while(true){
if((i__4819__auto___29054 < len__4818__auto___29053)){
args__4824__auto__.push((arguments[i__4819__auto___29054]));

var G__29055 = (i__4819__auto___29054 + (1));
i__4819__auto___29054 = G__29055;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e29052){var e = e29052;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29051){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29051));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29058 = arguments.length;
var i__4819__auto___29059 = (0);
while(true){
if((i__4819__auto___29059 < len__4818__auto___29058)){
args__4824__auto__.push((arguments[i__4819__auto___29059]));

var G__29060 = (i__4819__auto___29059 + (1));
i__4819__auto___29059 = G__29060;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e29057){var e = e29057;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29056){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29056));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e29061){var e = e29061;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e29062){var e = e29062;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e29063){var e = e29063;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29064){var e = e29064;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29065){var e = e29065;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29071 = path;
var vec__29072 = G__29071;
var seq__29073 = cljs.core.seq(vec__29072);
var first__29074 = cljs.core.first(seq__29073);
var seq__29073__$1 = cljs.core.next(seq__29073);
var pred = first__29074;
var r = seq__29073__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29071__$1 = G__29071;
var subjects__$1 = subjects;
while(true){
var vec__29078 = G__29071__$1;
var seq__29079 = cljs.core.seq(vec__29078);
var first__29080 = cljs.core.first(seq__29079);
var seq__29079__$1 = cljs.core.next(seq__29079);
var pred__$1 = first__29080;
var r__$1 = seq__29079__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__29071__$1,subjects__$1,vec__29078,seq__29079,first__29080,seq__29079__$1,pred__$1,r__$1,subjects__$2,G__29071,vec__29072,seq__29073,first__29074,seq__29073__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__29071__$1,subjects__$1,vec__29078,seq__29079,first__29080,seq__29079__$1,pred__$1,r__$1,subjects__$2,G__29071,vec__29072,seq__29073,first__29074,seq__29073__$1,pred,r,subjects){
return (function (p1__29066_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__29066_SHARP_,pred__$1);
});})(G__29071__$1,subjects__$1,vec__29078,seq__29079,first__29080,seq__29079__$1,pred__$1,r__$1,subjects__$2,G__29071,vec__29072,seq__29073,first__29074,seq__29073__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__29071__$1,subjects__$1,vec__29078,seq__29079,first__29080,seq__29079__$1,pred__$1,r__$1,subjects__$2,G__29071,vec__29072,seq__29073,first__29074,seq__29073__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__29081 = r__$1;
var G__29082 = next_subjects;
G__29071__$1 = G__29081;
subjects__$1 = G__29082;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29067){var e = e29067;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e29083){var e = e29083;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e29084){var e = e29084;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29087 = arguments.length;
var i__4819__auto___29088 = (0);
while(true){
if((i__4819__auto___29088 < len__4818__auto___29087)){
args__4824__auto__.push((arguments[i__4819__auto___29088]));

var G__29089 = (i__4819__auto___29088 + (1));
i__4819__auto___29088 = G__29089;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e29086){var e = e29086;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq29085){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29085));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e29090){var e = e29090;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___29093 = arguments.length;
var i__4819__auto___29094 = (0);
while(true){
if((i__4819__auto___29094 < len__4818__auto___29093)){
args__4824__auto__.push((arguments[i__4819__auto___29094]));

var G__29095 = (i__4819__auto___29094 + (1));
i__4819__auto___29094 = G__29095;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e29092){var e = e29092;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29091){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29091));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e29096){var e = e29096;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29153){
var state_val_29154 = (state_29153[(1)]);
if((state_val_29154 === (7))){
var inst_29099 = (state_29153[(2)]);
var state_29153__$1 = state_29153;
var statearr_29155_29189 = state_29153__$1;
(statearr_29155_29189[(2)] = inst_29099);

(statearr_29155_29189[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (1))){
var state_29153__$1 = state_29153;
var statearr_29156_29190 = state_29153__$1;
(statearr_29156_29190[(2)] = null);

(statearr_29156_29190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (4))){
var inst_29098 = (state_29153[(2)]);
var state_29153__$1 = (function (){var statearr_29157 = state_29153;
(statearr_29157[(7)] = inst_29098);

return statearr_29157;
})();
var statearr_29158_29191 = state_29153__$1;
(statearr_29158_29191[(2)] = null);

(statearr_29158_29191[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (15))){
var inst_29123 = (state_29153[(8)]);
var inst_29121 = (state_29153[(9)]);
var inst_29133 = (state_29153[(10)]);
var inst_29134 = (state_29153[(11)]);
var inst_29124 = (state_29153[(12)]);
var inst_29136 = (state_29153[(13)]);
var inst_29140 = (function (){var db = inst_29121;
var prevT = inst_29123;
var db_SINGLEQUOTE_ = inst_29124;
var prev_vals = inst_29133;
var fuel = inst_29134;
var G__29135 = inst_29136;
return (function (p1__29097_SHARP_){
var f = p1__29097_SHARP_;
return f.o;
});
})();
var inst_29141 = (inst_29140.cljs$core$IFn$_invoke$arity$1 ? inst_29140.cljs$core$IFn$_invoke$arity$1(inst_29136) : inst_29140.call(null,inst_29136));
var state_29153__$1 = state_29153;
var statearr_29159_29192 = state_29153__$1;
(statearr_29159_29192[(2)] = inst_29141);

(statearr_29159_29192[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (13))){
var inst_29133 = (state_29153[(10)]);
var inst_29136 = (state_29153[(13)]);
var inst_29132 = (state_29153[(2)]);
var inst_29133__$1 = fluree.db.util.async.throw_err(inst_29132);
var inst_29134 = fluree.db.dbfunctions.internal.count(inst_29133__$1);
var inst_29136__$1 = cljs.core.first(inst_29133__$1);
var inst_29137 = (inst_29136__$1 == null);
var state_29153__$1 = (function (){var statearr_29160 = state_29153;
(statearr_29160[(10)] = inst_29133__$1);

(statearr_29160[(11)] = inst_29134);

(statearr_29160[(13)] = inst_29136__$1);

return statearr_29160;
})();
if(cljs.core.truth_(inst_29137)){
var statearr_29161_29193 = state_29153__$1;
(statearr_29161_29193[(1)] = (14));

} else {
var statearr_29162_29194 = state_29153__$1;
(statearr_29162_29194[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (6))){
var inst_29108 = (state_29153[(2)]);
var state_29153__$1 = state_29153;
var statearr_29163_29195 = state_29153__$1;
(statearr_29163_29195[(2)] = inst_29108);

(statearr_29163_29195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (3))){
var inst_29151 = (state_29153[(2)]);
var state_29153__$1 = state_29153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29153__$1,inst_29151);
} else {
if((state_val_29154 === (12))){
var inst_29148 = (state_29153[(2)]);
var _ = (function (){var statearr_29164 = state_29153;
(statearr_29164[(4)] = cljs.core.rest((state_29153[(4)])));

return statearr_29164;
})();
var state_29153__$1 = state_29153;
var statearr_29165_29196 = state_29153__$1;
(statearr_29165_29196[(2)] = inst_29148);

(statearr_29165_29196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (2))){
var _ = (function (){var statearr_29167 = state_29153;
(statearr_29167[(4)] = cljs.core.cons((9),(state_29153[(4)])));

return statearr_29167;
})();
var inst_29114 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29115 = typeof inst_29114 === 'string';
var state_29153__$1 = state_29153;
if(cljs.core.truth_(inst_29115)){
var statearr_29168_29197 = state_29153__$1;
(statearr_29168_29197[(1)] = (10));

} else {
var statearr_29169_29198 = state_29153__$1;
(statearr_29169_29198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (11))){
var inst_29123 = (state_29153[(8)]);
var inst_29121 = (state_29153[(9)]);
var inst_29124 = (state_29153[(12)]);
var inst_29121__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29122 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29121__$1);
var inst_29123__$1 = fluree.db.dbfunctions.internal.inc(inst_29122);
var inst_29124__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29121__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29123__$1);
var inst_29125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29126 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29127 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29128 = [inst_29126,inst_29127];
var inst_29129 = (new cljs.core.PersistentVector(null,2,(5),inst_29125,inst_29128,null));
var inst_29130 = fluree.db.dbproto._search(inst_29124__$1,inst_29129);
var state_29153__$1 = (function (){var statearr_29170 = state_29153;
(statearr_29170[(8)] = inst_29123__$1);

(statearr_29170[(9)] = inst_29121__$1);

(statearr_29170[(12)] = inst_29124__$1);

return statearr_29170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29153__$1,(13),inst_29130);
} else {
if((state_val_29154 === (9))){
var _ = (function (){var statearr_29171 = state_29153;
(statearr_29171[(4)] = cljs.core.rest((state_29153[(4)])));

return statearr_29171;
})();
var state_29153__$1 = state_29153;
var ex29166 = (state_29153__$1[(2)]);
var statearr_29172_29199 = state_29153__$1;
(statearr_29172_29199[(5)] = ex29166);


var statearr_29173_29200 = state_29153__$1;
(statearr_29173_29200[(1)] = (4));

(statearr_29173_29200[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (5))){
var inst_29098 = (state_29153[(7)]);
var _ = (function (){var statearr_29174 = state_29153;
(statearr_29174[(4)] = cljs.core.cons((8),(state_29153[(4)])));

return statearr_29174;
})();
var inst_29105 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29098,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_29175 = state_29153;
(statearr_29175[(4)] = cljs.core.rest((state_29153[(4)])));

return statearr_29175;
})();
var state_29153__$1 = state_29153;
var statearr_29176_29201 = state_29153__$1;
(statearr_29176_29201[(2)] = inst_29105);

(statearr_29176_29201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (14))){
var state_29153__$1 = state_29153;
var statearr_29177_29202 = state_29153__$1;
(statearr_29177_29202[(2)] = null);

(statearr_29177_29202[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (16))){
var inst_29134 = (state_29153[(11)]);
var inst_29143 = (state_29153[(2)]);
var inst_29144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29145 = [inst_29143,inst_29134];
var inst_29146 = (new cljs.core.PersistentVector(null,2,(5),inst_29144,inst_29145,null));
var state_29153__$1 = state_29153;
var statearr_29179_29203 = state_29153__$1;
(statearr_29179_29203[(2)] = inst_29146);

(statearr_29179_29203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (10))){
var inst_29117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29118 = [null,(0)];
var inst_29119 = (new cljs.core.PersistentVector(null,2,(5),inst_29117,inst_29118,null));
var state_29153__$1 = state_29153;
var statearr_29180_29204 = state_29153__$1;
(statearr_29180_29204[(2)] = inst_29119);

(statearr_29180_29204[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29154 === (8))){
var _ = (function (){var statearr_29181 = state_29153;
(statearr_29181[(4)] = cljs.core.rest((state_29153[(4)])));

return statearr_29181;
})();
var state_29153__$1 = state_29153;
var ex29178 = (state_29153__$1[(2)]);
var statearr_29182_29205 = state_29153__$1;
(statearr_29182_29205[(5)] = ex29178);


var statearr_29183_29206 = state_29153__$1;
(statearr_29183_29206[(1)] = (7));

(statearr_29183_29206[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____0 = (function (){
var statearr_29184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29184[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__);

(statearr_29184[(1)] = (1));

return statearr_29184;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____1 = (function (state_29153){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29153);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29185){var ex__2720__auto__ = e29185;
var statearr_29186_29207 = state_29153;
(statearr_29186_29207[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29153[(4)]))){
var statearr_29187_29208 = state_29153;
(statearr_29187_29208[(1)] = cljs.core.first((state_29153[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29209 = state_29153;
state_29153 = G__29209;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__ = function(state_29153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____1.call(this,state_29153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29188 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29188[(6)] = c__2739__auto__);

return statearr_29188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29261){
var state_val_29262 = (state_29261[(1)]);
if((state_val_29262 === (7))){
var inst_29211 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29263_29292 = state_29261__$1;
(statearr_29263_29292[(2)] = inst_29211);

(statearr_29263_29292[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (1))){
var state_29261__$1 = state_29261;
var statearr_29264_29293 = state_29261__$1;
(statearr_29264_29293[(2)] = null);

(statearr_29264_29293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (4))){
var inst_29210 = (state_29261[(2)]);
var state_29261__$1 = (function (){var statearr_29265 = state_29261;
(statearr_29265[(7)] = inst_29210);

return statearr_29265;
})();
var statearr_29266_29294 = state_29261__$1;
(statearr_29266_29294[(2)] = null);

(statearr_29266_29294[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (13))){
var inst_29256 = (state_29261[(2)]);
var _ = (function (){var statearr_29267 = state_29261;
(statearr_29267[(4)] = cljs.core.rest((state_29261[(4)])));

return statearr_29267;
})();
var state_29261__$1 = state_29261;
var statearr_29268_29295 = state_29261__$1;
(statearr_29268_29295[(2)] = inst_29256);

(statearr_29268_29295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (6))){
var inst_29220 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
var statearr_29269_29296 = state_29261__$1;
(statearr_29269_29296[(2)] = inst_29220);

(statearr_29269_29296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (3))){
var inst_29259 = (state_29261[(2)]);
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29261__$1,inst_29259);
} else {
if((state_val_29262 === (12))){
var inst_29243 = (state_29261[(8)]);
var inst_29252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29253 = [null,inst_29243];
var inst_29254 = (new cljs.core.PersistentVector(null,2,(5),inst_29252,inst_29253,null));
var state_29261__$1 = state_29261;
var statearr_29270_29297 = state_29261__$1;
(statearr_29270_29297[(2)] = inst_29254);

(statearr_29270_29297[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (2))){
var _ = (function (){var statearr_29272 = state_29261;
(statearr_29272[(4)] = cljs.core.cons((9),(state_29261[(4)])));

return statearr_29272;
})();
var inst_29229 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29232 = [null,pred_name,"?o"];
var inst_29233 = (new cljs.core.PersistentVector(null,3,(5),inst_29231,inst_29232,null));
var inst_29234 = [inst_29233];
var inst_29235 = (new cljs.core.PersistentVector(null,1,(5),inst_29230,inst_29234,null));
var inst_29236 = ["?o",inst_29235,opts];
var inst_29237 = cljs.core.PersistentHashMap.fromArrays(inst_29229,inst_29236);
var inst_29238 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29237);
var state_29261__$1 = state_29261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29261__$1,(10),inst_29238);
} else {
if((state_val_29262 === (11))){
var inst_29243 = (state_29261[(8)]);
var inst_29242 = (state_29261[(9)]);
var inst_29247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29248 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29242);
var inst_29249 = [inst_29248,inst_29243];
var inst_29250 = (new cljs.core.PersistentVector(null,2,(5),inst_29247,inst_29249,null));
var state_29261__$1 = state_29261;
var statearr_29273_29298 = state_29261__$1;
(statearr_29273_29298[(2)] = inst_29250);

(statearr_29273_29298[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (9))){
var _ = (function (){var statearr_29274 = state_29261;
(statearr_29274[(4)] = cljs.core.rest((state_29261[(4)])));

return statearr_29274;
})();
var state_29261__$1 = state_29261;
var ex29271 = (state_29261__$1[(2)]);
var statearr_29275_29299 = state_29261__$1;
(statearr_29275_29299[(5)] = ex29271);


var statearr_29276_29300 = state_29261__$1;
(statearr_29276_29300[(1)] = (4));

(statearr_29276_29300[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (5))){
var inst_29210 = (state_29261[(7)]);
var _ = (function (){var statearr_29278 = state_29261;
(statearr_29278[(4)] = cljs.core.cons((8),(state_29261[(4)])));

return statearr_29278;
})();
var inst_29217 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29210,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29279 = state_29261;
(statearr_29279[(4)] = cljs.core.rest((state_29261[(4)])));

return statearr_29279;
})();
var state_29261__$1 = state_29261;
var statearr_29280_29301 = state_29261__$1;
(statearr_29280_29301[(2)] = inst_29217);

(statearr_29280_29301[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (10))){
var inst_29242 = (state_29261[(9)]);
var inst_29240 = (state_29261[(2)]);
var inst_29241 = fluree.db.util.async.throw_err(inst_29240);
var inst_29242__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29241,(0),null);
var inst_29243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29241,(1),null);
var inst_29244 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29242__$1);
var inst_29245 = cljs.core.not(inst_29244);
var state_29261__$1 = (function (){var statearr_29281 = state_29261;
(statearr_29281[(8)] = inst_29243);

(statearr_29281[(9)] = inst_29242__$1);

return statearr_29281;
})();
if(inst_29245){
var statearr_29282_29302 = state_29261__$1;
(statearr_29282_29302[(1)] = (11));

} else {
var statearr_29283_29303 = state_29261__$1;
(statearr_29283_29303[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29262 === (8))){
var _ = (function (){var statearr_29284 = state_29261;
(statearr_29284[(4)] = cljs.core.rest((state_29261[(4)])));

return statearr_29284;
})();
var state_29261__$1 = state_29261;
var ex29277 = (state_29261__$1[(2)]);
var statearr_29285_29304 = state_29261__$1;
(statearr_29285_29304[(5)] = ex29277);


var statearr_29286_29305 = state_29261__$1;
(statearr_29286_29305[(1)] = (7));

(statearr_29286_29305[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____0 = (function (){
var statearr_29287 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29287[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__);

(statearr_29287[(1)] = (1));

return statearr_29287;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____1 = (function (state_29261){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29261);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29288){var ex__2720__auto__ = e29288;
var statearr_29289_29306 = state_29261;
(statearr_29289_29306[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29261[(4)]))){
var statearr_29290_29307 = state_29261;
(statearr_29290_29307[(1)] = cljs.core.first((state_29261[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29308 = state_29261;
state_29261 = G__29308;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__ = function(state_29261){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____1.call(this,state_29261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29291 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29291[(6)] = c__2739__auto__);

return statearr_29291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e29309){var e = e29309;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29311 = arguments.length;
switch (G__29311) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29381){
var state_val_29382 = (state_29381[(1)]);
if((state_val_29382 === (7))){
var inst_29313 = (state_29381[(2)]);
var state_29381__$1 = state_29381;
var statearr_29383_29427 = state_29381__$1;
(statearr_29383_29427[(2)] = inst_29313);

(statearr_29383_29427[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (20))){
var inst_29357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29358 = ["*"];
var inst_29359 = (new cljs.core.PersistentVector(null,1,(5),inst_29357,inst_29358,null));
var state_29381__$1 = state_29381;
var statearr_29384_29428 = state_29381__$1;
(statearr_29384_29428[(2)] = inst_29359);

(statearr_29384_29428[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (1))){
var state_29381__$1 = state_29381;
var statearr_29385_29429 = state_29381__$1;
(statearr_29385_29429[(2)] = null);

(statearr_29385_29429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (4))){
var inst_29312 = (state_29381[(2)]);
var state_29381__$1 = (function (){var statearr_29386 = state_29381;
(statearr_29386[(7)] = inst_29312);

return statearr_29386;
})();
var statearr_29387_29430 = state_29381__$1;
(statearr_29387_29430[(2)] = null);

(statearr_29387_29430[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (15))){
var inst_29376 = (state_29381[(2)]);
var _ = (function (){var statearr_29388 = state_29381;
(statearr_29388[(4)] = cljs.core.rest((state_29381[(4)])));

return statearr_29388;
})();
var state_29381__$1 = state_29381;
var statearr_29389_29431 = state_29381__$1;
(statearr_29389_29431[(2)] = inst_29376);

(statearr_29389_29431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (21))){
var inst_29340 = (state_29381[(8)]);
var inst_29347 = (state_29381[(9)]);
var inst_29361 = (state_29381[(2)]);
var inst_29362 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29363 = cljs.core.PersistentHashMap.EMPTY;
var inst_29364 = [inst_29361,inst_29347,inst_29363];
var inst_29365 = cljs.core.PersistentHashMap.fromArrays(inst_29362,inst_29364);
var inst_29366 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29340,inst_29365);
var state_29381__$1 = state_29381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29381__$1,(22),inst_29366);
} else {
if((state_val_29382 === (13))){
var inst_29335 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29381__$1 = state_29381;
var statearr_29390_29432 = state_29381__$1;
(statearr_29390_29432[(2)] = inst_29335);

(statearr_29390_29432[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (22))){
var inst_29368 = (state_29381[(2)]);
var inst_29369 = fluree.db.util.async.throw_err(inst_29368);
var inst_29370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29369,(0),null);
var inst_29371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29369,(1),null);
var inst_29372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29373 = [inst_29370,inst_29371];
var inst_29374 = (new cljs.core.PersistentVector(null,2,(5),inst_29372,inst_29373,null));
var state_29381__$1 = state_29381;
var statearr_29391_29433 = state_29381__$1;
(statearr_29391_29433[(2)] = inst_29374);

(statearr_29391_29433[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (6))){
var inst_29322 = (state_29381[(2)]);
var state_29381__$1 = state_29381;
var statearr_29392_29434 = state_29381__$1;
(statearr_29392_29434[(2)] = inst_29322);

(statearr_29392_29434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (17))){
var inst_29344 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29345 = fluree.db.dbfunctions.internal.get(inst_29344,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29381__$1 = state_29381;
var statearr_29393_29435 = state_29381__$1;
(statearr_29393_29435[(2)] = inst_29345);

(statearr_29393_29435[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (3))){
var inst_29379 = (state_29381[(2)]);
var state_29381__$1 = state_29381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29381__$1,inst_29379);
} else {
if((state_val_29382 === (12))){
var inst_29333 = (state_29381[(2)]);
var state_29381__$1 = state_29381;
if(cljs.core.truth_(inst_29333)){
var statearr_29394_29436 = state_29381__$1;
(statearr_29394_29436[(1)] = (13));

} else {
var statearr_29395_29437 = state_29381__$1;
(statearr_29395_29437[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (2))){
var inst_29328 = (state_29381[(10)]);
var _ = (function (){var statearr_29396 = state_29381;
(statearr_29396[(4)] = cljs.core.cons((9),(state_29381[(4)])));

return statearr_29396;
})();
var inst_29328__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29381__$1 = (function (){var statearr_29397 = state_29381;
(statearr_29397[(10)] = inst_29328__$1);

return statearr_29397;
})();
if(cljs.core.truth_(inst_29328__$1)){
var statearr_29398_29438 = state_29381__$1;
(statearr_29398_29438[(1)] = (10));

} else {
var statearr_29399_29439 = state_29381__$1;
(statearr_29399_29439[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (19))){
var inst_29349 = cljs.core.PersistentVector.EMPTY;
var inst_29350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29351 = ["*"];
var inst_29352 = (new cljs.core.PersistentVector(null,1,(5),inst_29350,inst_29351,null));
var inst_29353 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29354 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29352,inst_29353);
var inst_29355 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29349,inst_29354);
var state_29381__$1 = state_29381;
var statearr_29401_29440 = state_29381__$1;
(statearr_29401_29440[(2)] = inst_29355);

(statearr_29401_29440[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (11))){
var inst_29328 = (state_29381[(10)]);
var state_29381__$1 = state_29381;
var statearr_29402_29441 = state_29381__$1;
(statearr_29402_29441[(2)] = inst_29328);

(statearr_29402_29441[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (9))){
var _ = (function (){var statearr_29403 = state_29381;
(statearr_29403[(4)] = cljs.core.rest((state_29381[(4)])));

return statearr_29403;
})();
var state_29381__$1 = state_29381;
var ex29400 = (state_29381__$1[(2)]);
var statearr_29404_29442 = state_29381__$1;
(statearr_29404_29442[(5)] = ex29400);


var statearr_29405_29443 = state_29381__$1;
(statearr_29405_29443[(1)] = (4));

(statearr_29405_29443[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (5))){
var inst_29312 = (state_29381[(7)]);
var _ = (function (){var statearr_29406 = state_29381;
(statearr_29406[(4)] = cljs.core.cons((8),(state_29381[(4)])));

return statearr_29406;
})();
var inst_29319 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29312,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29407 = state_29381;
(statearr_29407[(4)] = cljs.core.rest((state_29381[(4)])));

return statearr_29407;
})();
var state_29381__$1 = state_29381;
var statearr_29408_29444 = state_29381__$1;
(statearr_29408_29444[(2)] = inst_29319);

(statearr_29408_29444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (14))){
var inst_29341 = (state_29381[(11)]);
var inst_29340 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29341__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29381__$1 = (function (){var statearr_29409 = state_29381;
(statearr_29409[(8)] = inst_29340);

(statearr_29409[(11)] = inst_29341__$1);

return statearr_29409;
})();
if(cljs.core.truth_(inst_29341__$1)){
var statearr_29410_29445 = state_29381__$1;
(statearr_29410_29445[(1)] = (16));

} else {
var statearr_29411_29446 = state_29381__$1;
(statearr_29411_29446[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (16))){
var inst_29341 = (state_29381[(11)]);
var state_29381__$1 = state_29381;
var statearr_29412_29447 = state_29381__$1;
(statearr_29412_29447[(2)] = inst_29341);

(statearr_29412_29447[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (10))){
var inst_29330 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29381__$1 = state_29381;
var statearr_29414_29448 = state_29381__$1;
(statearr_29414_29448[(2)] = inst_29330);

(statearr_29414_29448[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (18))){
var inst_29347 = (state_29381[(2)]);
var state_29381__$1 = (function (){var statearr_29415 = state_29381;
(statearr_29415[(9)] = inst_29347);

return statearr_29415;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29416_29449 = state_29381__$1;
(statearr_29416_29449[(1)] = (19));

} else {
var statearr_29417_29450 = state_29381__$1;
(statearr_29417_29450[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29382 === (8))){
var _ = (function (){var statearr_29418 = state_29381;
(statearr_29418[(4)] = cljs.core.rest((state_29381[(4)])));

return statearr_29418;
})();
var state_29381__$1 = state_29381;
var ex29413 = (state_29381__$1[(2)]);
var statearr_29419_29451 = state_29381__$1;
(statearr_29419_29451[(5)] = ex29413);


var statearr_29420_29452 = state_29381__$1;
(statearr_29420_29452[(1)] = (7));

(statearr_29420_29452[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2717__auto____0 = (function (){
var statearr_29421 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29421[(0)] = fluree$db$dbfunctions$internal$state_machine__2717__auto__);

(statearr_29421[(1)] = (1));

return statearr_29421;
});
var fluree$db$dbfunctions$internal$state_machine__2717__auto____1 = (function (state_29381){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29381);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29422){var ex__2720__auto__ = e29422;
var statearr_29423_29453 = state_29381;
(statearr_29423_29453[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29381[(4)]))){
var statearr_29424_29454 = state_29381;
(statearr_29424_29454[(1)] = cljs.core.first((state_29381[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29455 = state_29381;
state_29381 = G__29455;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2717__auto__ = function(state_29381){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____1.call(this,state_29381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29425 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29425[(6)] = c__2739__auto__);

return statearr_29425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29457 = arguments.length;
switch (G__29457) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29501){
var state_val_29502 = (state_29501[(1)]);
if((state_val_29502 === (7))){
var inst_29479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29480 = ["*"];
var inst_29481 = (new cljs.core.PersistentVector(null,1,(5),inst_29479,inst_29480,null));
var state_29501__$1 = state_29501;
var statearr_29503_29523 = state_29501__$1;
(statearr_29503_29523[(2)] = inst_29481);

(statearr_29503_29523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (1))){
var state_29501__$1 = state_29501;
var statearr_29504_29524 = state_29501__$1;
(statearr_29504_29524[(2)] = null);

(statearr_29504_29524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (4))){
var inst_29458 = (state_29501[(2)]);
var inst_29459 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29458,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29501__$1 = state_29501;
var statearr_29505_29525 = state_29501__$1;
(statearr_29505_29525[(2)] = inst_29459);

(statearr_29505_29525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (6))){
var inst_29471 = cljs.core.PersistentVector.EMPTY;
var inst_29472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29473 = ["*"];
var inst_29474 = (new cljs.core.PersistentVector(null,1,(5),inst_29472,inst_29473,null));
var inst_29475 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29476 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29474,inst_29475);
var inst_29477 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29471,inst_29476);
var state_29501__$1 = state_29501;
var statearr_29506_29526 = state_29501__$1;
(statearr_29506_29526[(2)] = inst_29477);

(statearr_29506_29526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (3))){
var inst_29499 = (state_29501[(2)]);
var state_29501__$1 = state_29501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29501__$1,inst_29499);
} else {
if((state_val_29502 === (2))){
var _ = (function (){var statearr_29508 = state_29501;
(statearr_29508[(4)] = cljs.core.cons((5),(state_29501[(4)])));

return statearr_29508;
})();
var inst_29468 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29469 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29501__$1 = (function (){var statearr_29509 = state_29501;
(statearr_29509[(7)] = inst_29468);

(statearr_29509[(8)] = inst_29469);

return statearr_29509;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29510_29527 = state_29501__$1;
(statearr_29510_29527[(1)] = (6));

} else {
var statearr_29511_29528 = state_29501__$1;
(statearr_29511_29528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (9))){
var inst_29490 = (state_29501[(2)]);
var inst_29491 = fluree.db.util.async.throw_err(inst_29490);
var inst_29492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29491,(0),null);
var inst_29493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29491,(1),null);
var inst_29494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29495 = [inst_29492,inst_29493];
var inst_29496 = (new cljs.core.PersistentVector(null,2,(5),inst_29494,inst_29495,null));
var _ = (function (){var statearr_29512 = state_29501;
(statearr_29512[(4)] = cljs.core.rest((state_29501[(4)])));

return statearr_29512;
})();
var state_29501__$1 = state_29501;
var statearr_29513_29529 = state_29501__$1;
(statearr_29513_29529[(2)] = inst_29496);

(statearr_29513_29529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (5))){
var _ = (function (){var statearr_29514 = state_29501;
(statearr_29514[(4)] = cljs.core.rest((state_29501[(4)])));

return statearr_29514;
})();
var state_29501__$1 = state_29501;
var ex29507 = (state_29501__$1[(2)]);
var statearr_29515_29530 = state_29501__$1;
(statearr_29515_29530[(5)] = ex29507);


var statearr_29516_29531 = state_29501__$1;
(statearr_29516_29531[(1)] = (4));

(statearr_29516_29531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29502 === (8))){
var inst_29468 = (state_29501[(7)]);
var inst_29469 = (state_29501[(8)]);
var inst_29483 = (state_29501[(2)]);
var inst_29484 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29485 = cljs.core.PersistentHashMap.EMPTY;
var inst_29486 = [inst_29483,inst_29469,inst_29485];
var inst_29487 = cljs.core.PersistentHashMap.fromArrays(inst_29484,inst_29486);
var inst_29488 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29468,inst_29487);
var state_29501__$1 = state_29501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29501__$1,(9),inst_29488);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2717__auto____0 = (function (){
var statearr_29517 = [null,null,null,null,null,null,null,null,null];
(statearr_29517[(0)] = fluree$db$dbfunctions$internal$state_machine__2717__auto__);

(statearr_29517[(1)] = (1));

return statearr_29517;
});
var fluree$db$dbfunctions$internal$state_machine__2717__auto____1 = (function (state_29501){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29501);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29518){var ex__2720__auto__ = e29518;
var statearr_29519_29532 = state_29501;
(statearr_29519_29532[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29501[(4)]))){
var statearr_29520_29533 = state_29501;
(statearr_29520_29533[(1)] = cljs.core.first((state_29501[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29534 = state_29501;
state_29501 = G__29534;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2717__auto__ = function(state_29501){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2717__auto____1.call(this,state_29501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29521 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29521[(6)] = c__2739__auto__);

return statearr_29521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29578){
var state_val_29579 = (state_29578[(1)]);
if((state_val_29579 === (1))){
var state_29578__$1 = state_29578;
var statearr_29580_29594 = state_29578__$1;
(statearr_29580_29594[(2)] = null);

(statearr_29580_29594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29579 === (2))){
var _ = (function (){var statearr_29581 = state_29578;
(statearr_29581[(4)] = cljs.core.cons((5),(state_29578[(4)])));

return statearr_29581;
})();
var inst_29545 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29547 = ["_user/_auth"];
var inst_29548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29549 = ["*"];
var inst_29550 = (new cljs.core.PersistentVector(null,1,(5),inst_29548,inst_29549,null));
var inst_29551 = [inst_29550];
var inst_29552 = cljs.core.PersistentHashMap.fromArrays(inst_29547,inst_29551);
var inst_29553 = [inst_29552];
var inst_29554 = (new cljs.core.PersistentVector(null,1,(5),inst_29546,inst_29553,null));
var inst_29555 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29556 = cljs.core.PersistentHashMap.EMPTY;
var inst_29557 = [inst_29554,inst_29555,inst_29556];
var inst_29558 = cljs.core.PersistentHashMap.fromArrays(inst_29545,inst_29557);
var inst_29559 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29560 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29559,inst_29558);
var state_29578__$1 = state_29578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29578__$1,(6),inst_29560);
} else {
if((state_val_29579 === (3))){
var inst_29576 = (state_29578[(2)]);
var state_29578__$1 = state_29578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29578__$1,inst_29576);
} else {
if((state_val_29579 === (4))){
var inst_29535 = (state_29578[(2)]);
var inst_29536 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29535,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29578__$1 = state_29578;
var statearr_29583_29595 = state_29578__$1;
(statearr_29583_29595[(2)] = inst_29536);

(statearr_29583_29595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29579 === (5))){
var _ = (function (){var statearr_29584 = state_29578;
(statearr_29584[(4)] = cljs.core.rest((state_29578[(4)])));

return statearr_29584;
})();
var state_29578__$1 = state_29578;
var ex29582 = (state_29578__$1[(2)]);
var statearr_29585_29596 = state_29578__$1;
(statearr_29585_29596[(5)] = ex29582);


var statearr_29586_29597 = state_29578__$1;
(statearr_29586_29597[(1)] = (4));

(statearr_29586_29597[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29579 === (6))){
var inst_29562 = (state_29578[(2)]);
var inst_29563 = fluree.db.util.async.throw_err(inst_29562);
var inst_29564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29563,(0),null);
var inst_29565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29563,(1),null);
var inst_29566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29567 = ["_user/_auth","_id"];
var inst_29568 = (new cljs.core.PersistentVector(null,2,(5),inst_29566,inst_29567,null));
var inst_29569 = fluree.db.dbfunctions.internal.get_in(inst_29564,inst_29568);
var inst_29570 = cljs.core.first(inst_29569);
var inst_29571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29572 = [inst_29570,inst_29565];
var inst_29573 = (new cljs.core.PersistentVector(null,2,(5),inst_29571,inst_29572,null));
var _ = (function (){var statearr_29587 = state_29578;
(statearr_29587[(4)] = cljs.core.rest((state_29578[(4)])));

return statearr_29587;
})();
var state_29578__$1 = state_29578;
var statearr_29588_29598 = state_29578__$1;
(statearr_29588_29598[(2)] = inst_29573);

(statearr_29588_29598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____0 = (function (){
var statearr_29589 = [null,null,null,null,null,null,null];
(statearr_29589[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__);

(statearr_29589[(1)] = (1));

return statearr_29589;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____1 = (function (state_29578){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29578);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29590){var ex__2720__auto__ = e29590;
var statearr_29591_29599 = state_29578;
(statearr_29591_29599[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29578[(4)]))){
var statearr_29592_29600 = state_29578;
(statearr_29592_29600[(1)] = cljs.core.first((state_29578[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29601 = state_29578;
state_29578 = G__29601;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__ = function(state_29578){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____1.call(this,state_29578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29593 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29593[(6)] = c__2739__auto__);

return statearr_29593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29618){
var state_val_29619 = (state_29618[(1)]);
if((state_val_29619 === (1))){
var state_29618__$1 = state_29618;
var statearr_29620_29634 = state_29618__$1;
(statearr_29620_29634[(2)] = null);

(statearr_29620_29634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29619 === (2))){
var _ = (function (){var statearr_29621 = state_29618;
(statearr_29621[(4)] = cljs.core.cons((5),(state_29618[(4)])));

return statearr_29621;
})();
var inst_29608 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29609 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29610 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29609,inst_29608);
var state_29618__$1 = state_29618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29618__$1,(6),inst_29610);
} else {
if((state_val_29619 === (3))){
var inst_29616 = (state_29618[(2)]);
var state_29618__$1 = state_29618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29618__$1,inst_29616);
} else {
if((state_val_29619 === (4))){
var inst_29602 = (state_29618[(2)]);
var state_29618__$1 = state_29618;
var statearr_29623_29635 = state_29618__$1;
(statearr_29623_29635[(2)] = inst_29602);

(statearr_29623_29635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29619 === (5))){
var _ = (function (){var statearr_29624 = state_29618;
(statearr_29624[(4)] = cljs.core.rest((state_29618[(4)])));

return statearr_29624;
})();
var state_29618__$1 = state_29618;
var ex29622 = (state_29618__$1[(2)]);
var statearr_29625_29636 = state_29618__$1;
(statearr_29625_29636[(5)] = ex29622);


if((ex29622 instanceof Error)){
var statearr_29626_29637 = state_29618__$1;
(statearr_29626_29637[(1)] = (4));

(statearr_29626_29637[(5)] = null);

} else {
throw ex29622;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29619 === (6))){
var inst_29612 = (state_29618[(2)]);
var inst_29613 = fluree.db.util.async.throw_err(inst_29612);
var _ = (function (){var statearr_29627 = state_29618;
(statearr_29627[(4)] = cljs.core.rest((state_29618[(4)])));

return statearr_29627;
})();
var state_29618__$1 = state_29618;
var statearr_29628_29638 = state_29618__$1;
(statearr_29628_29638[(2)] = inst_29613);

(statearr_29628_29638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____0 = (function (){
var statearr_29629 = [null,null,null,null,null,null,null];
(statearr_29629[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__);

(statearr_29629[(1)] = (1));

return statearr_29629;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____1 = (function (state_29618){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29618);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29630){var ex__2720__auto__ = e29630;
var statearr_29631_29639 = state_29618;
(statearr_29631_29639[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29618[(4)]))){
var statearr_29632_29640 = state_29618;
(statearr_29632_29640[(1)] = cljs.core.first((state_29618[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29641 = state_29618;
state_29618 = G__29641;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__ = function(state_29618){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____1.call(this,state_29618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29633 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29633[(6)] = c__2739__auto__);

return statearr_29633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29642_SHARP_){
return p1__29642_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29643_SHARP_){
return p1__29643_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29644){var e = e29644;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29645_SHARP_){
return p1__29645_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29646_SHARP_){
return p1__29646_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29647){var e = e29647;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29649 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29649);
})() | (0));
return num;
}catch (e29648){var e = e29648;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_29729){
var state_val_29730 = (state_29729[(1)]);
if((state_val_29730 === (7))){
var inst_29668 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29669 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29670 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29671 = cljs.core.PersistentHashMap.fromArrays(inst_29669,inst_29670);
var inst_29672 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29668,inst_29671);
var inst_29673 = (function(){throw inst_29672})();
var state_29729__$1 = state_29729;
var statearr_29731_29766 = state_29729__$1;
(statearr_29731_29766[(2)] = inst_29673);

(statearr_29731_29766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (1))){
var state_29729__$1 = state_29729;
var statearr_29732_29767 = state_29729__$1;
(statearr_29732_29767[(2)] = null);

(statearr_29732_29767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (4))){
var inst_29650 = (state_29729[(2)]);
var state_29729__$1 = state_29729;
var statearr_29733_29768 = state_29729__$1;
(statearr_29733_29768[(2)] = inst_29650);

(statearr_29733_29768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (15))){
var inst_29713 = (state_29729[(7)]);
var inst_29709 = (state_29729[(2)]);
var inst_29710 = fluree.db.util.async.throw_err(inst_29709);
var inst_29711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29710,(0),null);
var inst_29712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29710,(1),null);
var inst_29713__$1 = cljs.core.first(inst_29711);
var inst_29714 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29713__$1,compare_val);
var state_29729__$1 = (function (){var statearr_29734 = state_29729;
(statearr_29734[(7)] = inst_29713__$1);

(statearr_29734[(8)] = inst_29712);

return statearr_29734;
})();
if(inst_29714){
var statearr_29735_29769 = state_29729__$1;
(statearr_29735_29769[(1)] = (16));

} else {
var statearr_29736_29770 = state_29729__$1;
(statearr_29736_29770[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (13))){
var state_29729__$1 = state_29729;
var statearr_29737_29771 = state_29729__$1;
(statearr_29737_29771[(2)] = null);

(statearr_29737_29771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (6))){
var state_29729__$1 = state_29729;
var statearr_29738_29772 = state_29729__$1;
(statearr_29738_29772[(2)] = null);

(statearr_29738_29772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (17))){
var inst_29713 = (state_29729[(7)]);
var inst_29717 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29713)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29718 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29719 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29720 = cljs.core.PersistentHashMap.fromArrays(inst_29718,inst_29719);
var inst_29721 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29717,inst_29720);
var inst_29722 = (function(){throw inst_29721})();
var state_29729__$1 = state_29729;
var statearr_29739_29773 = state_29729__$1;
(statearr_29739_29773[(2)] = inst_29722);

(statearr_29739_29773[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (3))){
var inst_29727 = (state_29729[(2)]);
var state_29729__$1 = state_29729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29729__$1,inst_29727);
} else {
if((state_val_29730 === (12))){
var inst_29665 = (state_29729[(9)]);
var inst_29688 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29665], 0));
var inst_29689 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29690 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29691 = cljs.core.PersistentHashMap.fromArrays(inst_29689,inst_29690);
var inst_29692 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29688,inst_29691);
var inst_29693 = (function(){throw inst_29692})();
var state_29729__$1 = state_29729;
var statearr_29740_29774 = state_29729__$1;
(statearr_29740_29774[(2)] = inst_29693);

(statearr_29740_29774[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (2))){
var inst_29664 = (state_29729[(10)]);
var inst_29663 = (state_29729[(11)]);
var inst_29662 = (state_29729[(12)]);
var _ = (function (){var statearr_29741 = state_29729;
(statearr_29741[(4)] = cljs.core.cons((5),(state_29729[(4)])));

return statearr_29741;
})();
var inst_29660 = _QMARK_ctx;
var inst_29661 = cljs.core.__destructure_map(inst_29660);
var inst_29662__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29661,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29663__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29661,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29664__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29661,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29665 = fluree.db.dbproto._p_prop(inst_29664__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29663__$1);
var state_29729__$1 = (function (){var statearr_29742 = state_29729;
(statearr_29742[(10)] = inst_29664__$1);

(statearr_29742[(11)] = inst_29663__$1);

(statearr_29742[(9)] = inst_29665);

(statearr_29742[(12)] = inst_29662__$1);

return statearr_29742;
})();
if(cljs.core.truth_(inst_29662__$1)){
var statearr_29743_29775 = state_29729__$1;
(statearr_29743_29775[(1)] = (6));

} else {
var statearr_29744_29776 = state_29729__$1;
(statearr_29744_29776[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (11))){
var inst_29664 = (state_29729[(10)]);
var inst_29663 = (state_29729[(11)]);
var inst_29685 = (state_29729[(2)]);
var inst_29686 = fluree.db.dbproto._p_prop(inst_29664,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29663);
var state_29729__$1 = (function (){var statearr_29746 = state_29729;
(statearr_29746[(13)] = inst_29685);

return statearr_29746;
})();
if(cljs.core.truth_(inst_29686)){
var statearr_29747_29777 = state_29729__$1;
(statearr_29747_29777[(1)] = (12));

} else {
var statearr_29748_29778 = state_29729__$1;
(statearr_29748_29778[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (9))){
var state_29729__$1 = state_29729;
var statearr_29749_29779 = state_29729__$1;
(statearr_29749_29779[(2)] = null);

(statearr_29749_29779[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (5))){
var _ = (function (){var statearr_29750 = state_29729;
(statearr_29750[(4)] = cljs.core.rest((state_29729[(4)])));

return statearr_29750;
})();
var state_29729__$1 = state_29729;
var ex29745 = (state_29729__$1[(2)]);
var statearr_29751_29780 = state_29729__$1;
(statearr_29751_29780[(5)] = ex29745);


if((ex29745 instanceof Error)){
var statearr_29752_29781 = state_29729__$1;
(statearr_29752_29781[(1)] = (4));

(statearr_29752_29781[(5)] = null);

} else {
throw ex29745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (14))){
var inst_29664 = (state_29729[(10)]);
var inst_29665 = (state_29729[(9)]);
var inst_29662 = (state_29729[(12)]);
var inst_29696 = (state_29729[(2)]);
var inst_29697 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29700 = [inst_29662,inst_29665,"?current-val"];
var inst_29701 = (new cljs.core.PersistentVector(null,3,(5),inst_29699,inst_29700,null));
var inst_29702 = [inst_29701];
var inst_29703 = (new cljs.core.PersistentVector(null,1,(5),inst_29698,inst_29702,null));
var inst_29704 = cljs.core.PersistentHashMap.EMPTY;
var inst_29705 = ["?current-val",inst_29703,inst_29704];
var inst_29706 = cljs.core.PersistentHashMap.fromArrays(inst_29697,inst_29705);
var inst_29707 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29664,inst_29706);
var state_29729__$1 = (function (){var statearr_29753 = state_29729;
(statearr_29753[(14)] = inst_29696);

return statearr_29753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29729__$1,(15),inst_29707);
} else {
if((state_val_29730 === (16))){
var state_29729__$1 = state_29729;
var statearr_29754_29782 = state_29729__$1;
(statearr_29754_29782[(2)] = new_val);

(statearr_29754_29782[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (10))){
var inst_29678 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29679 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29680 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29681 = cljs.core.PersistentHashMap.fromArrays(inst_29679,inst_29680);
var inst_29682 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29678,inst_29681);
var inst_29683 = (function(){throw inst_29682})();
var state_29729__$1 = state_29729;
var statearr_29755_29783 = state_29729__$1;
(statearr_29755_29783[(2)] = inst_29683);

(statearr_29755_29783[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (18))){
var inst_29724 = (state_29729[(2)]);
var _ = (function (){var statearr_29756 = state_29729;
(statearr_29756[(4)] = cljs.core.rest((state_29729[(4)])));

return statearr_29756;
})();
var state_29729__$1 = state_29729;
var statearr_29757_29784 = state_29729__$1;
(statearr_29757_29784[(2)] = inst_29724);

(statearr_29757_29784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29730 === (8))){
var inst_29665 = (state_29729[(9)]);
var inst_29675 = (state_29729[(2)]);
var state_29729__$1 = (function (){var statearr_29758 = state_29729;
(statearr_29758[(15)] = inst_29675);

return statearr_29758;
})();
if(cljs.core.truth_(inst_29665)){
var statearr_29759_29785 = state_29729__$1;
(statearr_29759_29785[(1)] = (9));

} else {
var statearr_29760_29786 = state_29729__$1;
(statearr_29760_29786[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____0 = (function (){
var statearr_29761 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29761[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__);

(statearr_29761[(1)] = (1));

return statearr_29761;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____1 = (function (state_29729){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_29729);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e29762){var ex__2720__auto__ = e29762;
var statearr_29763_29787 = state_29729;
(statearr_29763_29787[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_29729[(4)]))){
var statearr_29764_29788 = state_29729;
(statearr_29764_29788[(1)] = cljs.core.first((state_29729[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29789 = state_29729;
state_29729 = G__29789;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__ = function(state_29729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____1.call(this,state_29729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_29765 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_29765[(6)] = c__2739__auto__);

return statearr_29765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
