// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20172){var e = e20172;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20173_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20173_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20173_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20173_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20173_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20174_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20174_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20175_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20175_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20180 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20180,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20180,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20176_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20176_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__20183 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20183,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20183,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20177_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20177_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20178_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20178_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20179_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20179_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20186_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__20186_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__20187 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20187) : intersecting_vars.call(null,G__20187));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20190,optional_QMARK_,fuel,max_fuel){
var map__20191 = p__20190;
var map__20191__$1 = cljs.core.__destructure_map(map__20191);
var res = map__20191__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20191__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20257){
var state_val_20258 = (state_20257[(1)]);
if((state_val_20258 === (7))){
var inst_20246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20247 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20248 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20247,clause);
var inst_20249 = [null,inst_20248];
var inst_20250 = (new cljs.core.PersistentVector(null,2,(5),inst_20246,inst_20249,null));
var state_20257__$1 = state_20257;
var statearr_20259_20287 = state_20257__$1;
(statearr_20259_20287[(2)] = inst_20250);

(statearr_20259_20287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (1))){
var state_20257__$1 = state_20257;
var statearr_20260_20288 = state_20257__$1;
(statearr_20260_20288[(2)] = null);

(statearr_20260_20288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (4))){
var inst_20192 = (state_20257[(2)]);
var state_20257__$1 = state_20257;
var statearr_20261_20289 = state_20257__$1;
(statearr_20261_20289[(2)] = inst_20192);

(statearr_20261_20289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (15))){
var inst_20235 = (state_20257[(2)]);
var inst_20236 = fluree.db.util.async.throw_err(inst_20235);
var inst_20237 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20236);
var inst_20238 = cljs.core.count(inst_20237);
var inst_20239 = fluree.db.query.analytical.add_fuel(inst_20238,fuel,max_fuel);
var inst_20240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20241 = [inst_20236,r];
var inst_20242 = (new cljs.core.PersistentVector(null,2,(5),inst_20240,inst_20241,null));
var state_20257__$1 = (function (){var statearr_20262 = state_20257;
(statearr_20262[(7)] = inst_20239);

return statearr_20262;
})();
var statearr_20263_20290 = state_20257__$1;
(statearr_20263_20290[(2)] = inst_20242);

(statearr_20263_20290[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (13))){
var inst_20201 = (state_20257[(8)]);
var inst_20214 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20215 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20214);
var inst_20216 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20201);
var inst_20217 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20216);
var inst_20218 = cljs.core.set(inst_20217);
var inst_20219 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20215);
var inst_20220 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20219);
var inst_20221 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20218,inst_20220);
var inst_20222 = (function (){var all_wd = inst_20201;
var optional = inst_20215;
var all_wd_vars = inst_20218;
var all_vars = inst_20221;
return (function (p1__20188_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20188_SHARP_) : all_vars.call(null,p1__20188_SHARP_));
});
})();
var inst_20223 = cljs.core.keys(vars);
var inst_20224 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20222,inst_20223);
var inst_20225 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20224);
var inst_20226 = cljs.core.set(inst_20225);
var inst_20227 = (function (){var all_wd = inst_20201;
var optional = inst_20215;
var all_wd_vars = inst_20218;
var all_vars = inst_20221;
var intersecting_vars = inst_20226;
return (function (p1__20189_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20189_SHARP_);
});
})();
var inst_20228 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20227,inst_20201);
var inst_20229 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20228);
var inst_20230 = fluree.db.query.analytical.select_from_tuples(inst_20229,res);
var inst_20231 = fluree.db.query.analytical.replace_vars_wikidata(inst_20201,inst_20226,vars);
var inst_20232 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20226,inst_20221);
var inst_20233 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20231,inst_20229,inst_20230,inst_20232,inst_20215);
var state_20257__$1 = state_20257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20257__$1,(15),inst_20233);
} else {
if((state_val_20258 === (6))){
var inst_20202 = (state_20257[(9)]);
var inst_20200 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20201 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20200);
var inst_20202__$1 = optional_QMARK_;
var state_20257__$1 = (function (){var statearr_20264 = state_20257;
(statearr_20264[(8)] = inst_20201);

(statearr_20264[(9)] = inst_20202__$1);

return statearr_20264;
})();
if(cljs.core.truth_(inst_20202__$1)){
var statearr_20265_20291 = state_20257__$1;
(statearr_20265_20291[(1)] = (9));

} else {
var statearr_20266_20292 = state_20257__$1;
(statearr_20266_20292[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (3))){
var inst_20255 = (state_20257[(2)]);
var state_20257__$1 = state_20257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20257__$1,inst_20255);
} else {
if((state_val_20258 === (12))){
var inst_20210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20211 = [null,r];
var inst_20212 = (new cljs.core.PersistentVector(null,2,(5),inst_20210,inst_20211,null));
var state_20257__$1 = state_20257;
var statearr_20267_20293 = state_20257__$1;
(statearr_20267_20293[(2)] = inst_20212);

(statearr_20267_20293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (2))){
var _ = (function (){var statearr_20268 = state_20257;
(statearr_20268[(4)] = cljs.core.cons((5),(state_20257[(4)])));

return statearr_20268;
})();
var inst_20198 = (r == null);
var state_20257__$1 = state_20257;
if(cljs.core.truth_(inst_20198)){
var statearr_20269_20294 = state_20257__$1;
(statearr_20269_20294[(1)] = (6));

} else {
var statearr_20270_20295 = state_20257__$1;
(statearr_20270_20295[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (11))){
var inst_20208 = (state_20257[(2)]);
var state_20257__$1 = state_20257;
if(cljs.core.truth_(inst_20208)){
var statearr_20272_20296 = state_20257__$1;
(statearr_20272_20296[(1)] = (12));

} else {
var statearr_20273_20297 = state_20257__$1;
(statearr_20273_20297[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (9))){
var inst_20201 = (state_20257[(8)]);
var inst_20204 = cljs.core.empty_QMARK_(inst_20201);
var inst_20205 = (!(inst_20204));
var state_20257__$1 = state_20257;
var statearr_20274_20298 = state_20257__$1;
(statearr_20274_20298[(2)] = inst_20205);

(statearr_20274_20298[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (5))){
var _ = (function (){var statearr_20275 = state_20257;
(statearr_20275[(4)] = cljs.core.rest((state_20257[(4)])));

return statearr_20275;
})();
var state_20257__$1 = state_20257;
var ex20271 = (state_20257__$1[(2)]);
var statearr_20276_20299 = state_20257__$1;
(statearr_20276_20299[(5)] = ex20271);


if((ex20271 instanceof Error)){
var statearr_20277_20300 = state_20257__$1;
(statearr_20277_20300[(1)] = (4));

(statearr_20277_20300[(5)] = null);

} else {
throw ex20271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (14))){
var inst_20244 = (state_20257[(2)]);
var state_20257__$1 = state_20257;
var statearr_20278_20301 = state_20257__$1;
(statearr_20278_20301[(2)] = inst_20244);

(statearr_20278_20301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (10))){
var inst_20202 = (state_20257[(9)]);
var state_20257__$1 = state_20257;
var statearr_20279_20302 = state_20257__$1;
(statearr_20279_20302[(2)] = inst_20202);

(statearr_20279_20302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20258 === (8))){
var inst_20252 = (state_20257[(2)]);
var _ = (function (){var statearr_20280 = state_20257;
(statearr_20280[(4)] = cljs.core.rest((state_20257[(4)])));

return statearr_20280;
})();
var state_20257__$1 = state_20257;
var statearr_20281_20303 = state_20257__$1;
(statearr_20281_20303[(2)] = inst_20252);

(statearr_20281_20303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____0 = (function (){
var statearr_20282 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20282[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__);

(statearr_20282[(1)] = (1));

return statearr_20282;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____1 = (function (state_20257){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20257);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20283){var ex__2720__auto__ = e20283;
var statearr_20284_20304 = state_20257;
(statearr_20284_20304[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20257[(4)]))){
var statearr_20285_20305 = state_20257;
(statearr_20285_20305[(1)] = cljs.core.first((state_20257[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20306 = state_20257;
state_20257 = G__20306;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__ = function(state_20257){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____1.call(this,state_20257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20286 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20286[(6)] = c__2739__auto__);

return statearr_20286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20308 = arguments.length;
switch (G__20308) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20402){
var state_val_20403 = (state_20402[(1)]);
if((state_val_20403 === (7))){
var inst_20315 = (state_20402[(7)]);
var inst_20325 = clojure.string.starts_with_QMARK_(inst_20315,"$fdb");
var state_20402__$1 = state_20402;
if(inst_20325){
var statearr_20404_20453 = state_20402__$1;
(statearr_20404_20453[(1)] = (9));

} else {
var statearr_20405_20454 = state_20402__$1;
(statearr_20405_20454[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (20))){
var state_20402__$1 = state_20402;
var statearr_20406_20455 = state_20402__$1;
(statearr_20406_20455[(2)] = null);

(statearr_20406_20455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (27))){
var inst_20365 = (state_20402[(8)]);
var state_20402__$1 = state_20402;
var statearr_20407_20456 = state_20402__$1;
(statearr_20407_20456[(2)] = inst_20365);

(statearr_20407_20456[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (1))){
var state_20402__$1 = state_20402;
var statearr_20408_20457 = state_20402__$1;
(statearr_20408_20457[(2)] = null);

(statearr_20408_20457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (24))){
var inst_20388 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20409_20458 = state_20402__$1;
(statearr_20409_20458[(2)] = inst_20388);

(statearr_20409_20458[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (4))){
var inst_20309 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20410_20459 = state_20402__$1;
(statearr_20410_20459[(2)] = inst_20309);

(statearr_20410_20459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (15))){
var inst_20332 = (state_20402[(9)]);
var inst_20338 = (state_20402[(2)]);
var inst_20339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20340 = cljs.core.PersistentVector.EMPTY;
var inst_20341 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20342 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20340,inst_20341);
var inst_20343 = [inst_20332,inst_20342];
var inst_20344 = (new cljs.core.PersistentVector(null,2,(5),inst_20339,inst_20343,null));
var state_20402__$1 = (function (){var statearr_20411 = state_20402;
(statearr_20411[(10)] = inst_20338);

return statearr_20411;
})();
var statearr_20412_20460 = state_20402__$1;
(statearr_20412_20460[(2)] = inst_20344);

(statearr_20412_20460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (21))){
var inst_20391 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20413_20461 = state_20402__$1;
(statearr_20413_20461[(2)] = inst_20391);

(statearr_20413_20461[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (13))){
var inst_20332 = (state_20402[(9)]);
var inst_20335 = (function(){throw inst_20332})();
var state_20402__$1 = state_20402;
var statearr_20414_20462 = state_20402__$1;
(statearr_20414_20462[(2)] = inst_20335);

(statearr_20414_20462[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (22))){
var inst_20354 = (state_20402[(11)]);
var inst_20356 = (state_20402[(12)]);
var inst_20358 = fluree.db.query.analytical.parse_block_from_source(inst_20354);
var inst_20359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20360 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20356];
var inst_20361 = (new cljs.core.PersistentVector(null,2,(5),inst_20359,inst_20360,null));
var inst_20362 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20361);
var state_20402__$1 = (function (){var statearr_20415 = state_20402;
(statearr_20415[(13)] = inst_20358);

return statearr_20415;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20402__$1,(25),inst_20362);
} else {
if((state_val_20403 === (29))){
var inst_20369 = (state_20402[(2)]);
var inst_20370 = fluree.db.util.async.throw_err(inst_20369);
var state_20402__$1 = state_20402;
var statearr_20416_20463 = state_20402__$1;
(statearr_20416_20463[(2)] = inst_20370);

(statearr_20416_20463[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (6))){
var inst_20318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20319 = cljs.core.PersistentVector.EMPTY;
var inst_20320 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20321 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20319,inst_20320);
var inst_20322 = [db,inst_20321];
var inst_20323 = (new cljs.core.PersistentVector(null,2,(5),inst_20318,inst_20322,null));
var state_20402__$1 = state_20402;
var statearr_20417_20464 = state_20402__$1;
(statearr_20417_20464[(2)] = inst_20323);

(statearr_20417_20464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (28))){
var inst_20373 = (state_20402[(2)]);
var inst_20374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20375 = cljs.core.PersistentVector.EMPTY;
var inst_20376 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20377 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20375,inst_20376);
var inst_20378 = [inst_20373,inst_20377];
var inst_20379 = (new cljs.core.PersistentVector(null,2,(5),inst_20374,inst_20378,null));
var state_20402__$1 = state_20402;
var statearr_20418_20465 = state_20402__$1;
(statearr_20418_20465[(2)] = inst_20379);

(statearr_20418_20465[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (25))){
var inst_20358 = (state_20402[(13)]);
var inst_20364 = (state_20402[(2)]);
var inst_20365 = fluree.db.util.async.throw_err(inst_20364);
var state_20402__$1 = (function (){var statearr_20419 = state_20402;
(statearr_20419[(8)] = inst_20365);

return statearr_20419;
})();
if(cljs.core.truth_(inst_20358)){
var statearr_20420_20466 = state_20402__$1;
(statearr_20420_20466[(1)] = (26));

} else {
var statearr_20421_20467 = state_20402__$1;
(statearr_20421_20467[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (17))){
var state_20402__$1 = state_20402;
var statearr_20422_20468 = state_20402__$1;
(statearr_20422_20468[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (3))){
var inst_20400 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20402__$1,inst_20400);
} else {
if((state_val_20403 === (12))){
var inst_20332 = (state_20402[(9)]);
var inst_20331 = (state_20402[(2)]);
var inst_20332__$1 = fluree.db.util.async.throw_err(inst_20331);
var inst_20333 = fluree.db.util.core.exception_QMARK_(inst_20332__$1);
var state_20402__$1 = (function (){var statearr_20424 = state_20402;
(statearr_20424[(9)] = inst_20332__$1);

return statearr_20424;
})();
if(inst_20333){
var statearr_20425_20469 = state_20402__$1;
(statearr_20425_20469[(1)] = (13));

} else {
var statearr_20426_20470 = state_20402__$1;
(statearr_20426_20470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (2))){
var inst_20315 = (state_20402[(7)]);
var _ = (function (){var statearr_20427 = state_20402;
(statearr_20427[(4)] = cljs.core.cons((5),(state_20402[(4)])));

return statearr_20427;
})();
var inst_20315__$1 = cljs.core.first(clause);
var inst_20316 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20315__$1);
var state_20402__$1 = (function (){var statearr_20428 = state_20402;
(statearr_20428[(7)] = inst_20315__$1);

return statearr_20428;
})();
if(inst_20316){
var statearr_20429_20471 = state_20402__$1;
(statearr_20429_20471[(1)] = (6));

} else {
var statearr_20430_20472 = state_20402__$1;
(statearr_20430_20472[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (23))){
var inst_20315 = (state_20402[(7)]);
var inst_20381 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20315)," is not supported in Fluree"].join('');
var inst_20382 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20383 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20384 = cljs.core.PersistentHashMap.fromArrays(inst_20382,inst_20383);
var inst_20385 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20381,inst_20384);
var inst_20386 = (function(){throw inst_20385})();
var state_20402__$1 = state_20402;
var statearr_20431_20473 = state_20402__$1;
(statearr_20431_20473[(2)] = inst_20386);

(statearr_20431_20473[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (19))){
var inst_20315 = (state_20402[(7)]);
var inst_20356 = (state_20402[(12)]);
var inst_20353 = fluree.db.query.analytical.isolate_source_name(inst_20315);
var inst_20354 = fluree.db.query.analytical.isolate_source_block(inst_20315);
var inst_20355 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20353);
var inst_20356__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20355);
var state_20402__$1 = (function (){var statearr_20432 = state_20402;
(statearr_20432[(11)] = inst_20354);

(statearr_20432[(12)] = inst_20356__$1);

return statearr_20432;
})();
if(cljs.core.truth_(inst_20356__$1)){
var statearr_20433_20474 = state_20402__$1;
(statearr_20433_20474[(1)] = (22));

} else {
var statearr_20434_20475 = state_20402__$1;
(statearr_20434_20475[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (11))){
var inst_20395 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20436_20476 = state_20402__$1;
(statearr_20436_20476[(2)] = inst_20395);

(statearr_20436_20476[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (9))){
var inst_20315 = (state_20402[(7)]);
var inst_20327 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20315,(4));
var inst_20328 = fluree.db.query.analytical.parse_block_from_source(inst_20327);
var inst_20329 = fluree.db.time_travel.as_of_block(db,inst_20328);
var state_20402__$1 = state_20402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20402__$1,(12),inst_20329);
} else {
if((state_val_20403 === (5))){
var _ = (function (){var statearr_20437 = state_20402;
(statearr_20437[(4)] = cljs.core.rest((state_20402[(4)])));

return statearr_20437;
})();
var state_20402__$1 = state_20402;
var ex20435 = (state_20402__$1[(2)]);
var statearr_20438_20477 = state_20402__$1;
(statearr_20438_20477[(5)] = ex20435);


if((ex20435 instanceof Error)){
var statearr_20439_20478 = state_20402__$1;
(statearr_20439_20478[(1)] = (4));

(statearr_20439_20478[(5)] = null);

} else {
throw ex20435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (14))){
var state_20402__$1 = state_20402;
var statearr_20440_20479 = state_20402__$1;
(statearr_20440_20479[(2)] = null);

(statearr_20440_20479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (26))){
var inst_20358 = (state_20402[(13)]);
var inst_20365 = (state_20402[(8)]);
var inst_20367 = fluree.db.time_travel.as_of_block(inst_20365,inst_20358);
var state_20402__$1 = state_20402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20402__$1,(29),inst_20367);
} else {
if((state_val_20403 === (16))){
var inst_20348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20349 = ["$wd",clause];
var inst_20350 = (new cljs.core.PersistentVector(null,2,(5),inst_20348,inst_20349,null));
var state_20402__$1 = state_20402;
var statearr_20441_20480 = state_20402__$1;
(statearr_20441_20480[(2)] = inst_20350);

(statearr_20441_20480[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (10))){
var inst_20315 = (state_20402[(7)]);
var inst_20346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20315);
var state_20402__$1 = state_20402;
if(inst_20346){
var statearr_20442_20481 = state_20402__$1;
(statearr_20442_20481[(1)] = (16));

} else {
var statearr_20443_20482 = state_20402__$1;
(statearr_20443_20482[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (18))){
var inst_20393 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20444_20483 = state_20402__$1;
(statearr_20444_20483[(2)] = inst_20393);

(statearr_20444_20483[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (8))){
var inst_20397 = (state_20402[(2)]);
var _ = (function (){var statearr_20445 = state_20402;
(statearr_20445[(4)] = cljs.core.rest((state_20402[(4)])));

return statearr_20445;
})();
var state_20402__$1 = state_20402;
var statearr_20446_20484 = state_20402__$1;
(statearr_20446_20484[(2)] = inst_20397);

(statearr_20446_20484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2717__auto__ = null;
var fluree$db$query$analytical$state_machine__2717__auto____0 = (function (){
var statearr_20447 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20447[(0)] = fluree$db$query$analytical$state_machine__2717__auto__);

(statearr_20447[(1)] = (1));

return statearr_20447;
});
var fluree$db$query$analytical$state_machine__2717__auto____1 = (function (state_20402){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20402);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20448){var ex__2720__auto__ = e20448;
var statearr_20449_20485 = state_20402;
(statearr_20449_20485[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20402[(4)]))){
var statearr_20450_20486 = state_20402;
(statearr_20450_20486[(1)] = cljs.core.first((state_20402[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20487 = state_20402;
state_20402 = G__20487;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2717__auto__ = function(state_20402){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2717__auto____1.call(this,state_20402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2717__auto____0;
fluree$db$query$analytical$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2717__auto____1;
return fluree$db$query$analytical$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20451 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20451[(6)] = c__2739__auto__);

return statearr_20451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20488){
var vec__20489 = p__20488;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20489,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20489,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20492_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20492_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20496 = subjects;
var vec__20497 = G__20496;
var seq__20498 = cljs.core.seq(vec__20497);
var first__20499 = cljs.core.first(seq__20498);
var seq__20498__$1 = cljs.core.next(seq__20498);
var subject = first__20499;
var r = seq__20498__$1;
var acc = expanded_map;
var G__20496__$1 = G__20496;
var acc__$1 = acc;
while(true){
var vec__20503 = G__20496__$1;
var seq__20504 = cljs.core.seq(vec__20503);
var first__20505 = cljs.core.first(seq__20504);
var seq__20504__$1 = cljs.core.next(seq__20504);
var subject__$1 = first__20505;
var r__$1 = seq__20504__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20506 = r__$1;
var G__20507 = acc__$2;
G__20496__$1 = G__20506;
acc__$1 = G__20507;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20496__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20496__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20496__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20496__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20496__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20496__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20503,seq__20504,first__20505,seq__20504__$1,subject__$1,r__$1,acc__$2,G__20496,vec__20497,seq__20498,first__20499,seq__20498__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20508 = r__$1;
var G__20509 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20496__$1 = G__20508;
acc__$1 = G__20509;
continue;
} else {
var G__20510 = subjects;
var G__20511 = acc_STAR_;
G__20496__$1 = G__20510;
acc__$1 = G__20511;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20512_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20512_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20603){
var state_val_20604 = (state_20603[(1)]);
if((state_val_20604 === (7))){
var state_20603__$1 = state_20603;
var statearr_20605_20651 = state_20603__$1;
(statearr_20605_20651[(2)] = (100));

(statearr_20605_20651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (20))){
var inst_20552 = (state_20603[(7)]);
var state_20603__$1 = state_20603;
var statearr_20606_20652 = state_20603__$1;
(statearr_20606_20652[(2)] = inst_20552);

(statearr_20606_20652[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (1))){
var state_20603__$1 = state_20603;
var statearr_20607_20653 = state_20603__$1;
(statearr_20607_20653[(2)] = null);

(statearr_20607_20653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (24))){
var inst_20589 = (state_20603[(8)]);
var inst_20524 = (state_20603[(9)]);
var inst_20591 = (state_20603[(10)]);
var inst_20590 = (state_20603[(11)]);
var inst_20594 = (function (){var max_depth = inst_20524;
var recur_map__$1 = inst_20590;
var subjects = inst_20589;
var tuples = inst_20591;
return (function (p1__20513_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20513_SHARP_)],null));
});
})();
var inst_20595 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20594,inst_20591);
var inst_20596 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20595);
var state_20603__$1 = state_20603;
var statearr_20608_20654 = state_20603__$1;
(statearr_20608_20654[(2)] = inst_20596);

(statearr_20608_20654[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (4))){
var inst_20514 = (state_20603[(2)]);
var state_20603__$1 = state_20603;
var statearr_20609_20655 = state_20603__$1;
(statearr_20609_20655[(2)] = inst_20514);

(statearr_20609_20655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (15))){
var inst_20537 = (state_20603[(12)]);
var inst_20548 = cljs.core.PersistentVector.EMPTY;
var inst_20549 = cljs.core.seq(inst_20537);
var inst_20550 = cljs.core.first(inst_20549);
var inst_20551 = cljs.core.next(inst_20549);
var inst_20552 = inst_20548;
var inst_20553 = inst_20537;
var state_20603__$1 = (function (){var statearr_20610 = state_20603;
(statearr_20610[(13)] = inst_20553);

(statearr_20610[(7)] = inst_20552);

(statearr_20610[(14)] = inst_20550);

(statearr_20610[(15)] = inst_20551);

return statearr_20610;
})();
var statearr_20611_20656 = state_20603__$1;
(statearr_20611_20656[(2)] = null);

(statearr_20611_20656[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (21))){
var inst_20573 = (state_20603[(2)]);
var state_20603__$1 = state_20603;
var statearr_20612_20657 = state_20603__$1;
(statearr_20612_20657[(2)] = inst_20573);

(statearr_20612_20657[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (13))){
var inst_20586 = (state_20603[(2)]);
var state_20603__$1 = state_20603;
var statearr_20613_20658 = state_20603__$1;
(statearr_20613_20658[(2)] = inst_20586);

(statearr_20613_20658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (22))){
var inst_20560 = (state_20603[(16)]);
var inst_20552 = (state_20603[(7)]);
var inst_20567 = (state_20603[(2)]);
var inst_20568 = fluree.db.util.async.throw_err(inst_20567);
var inst_20569 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20552,inst_20568);
var inst_20552__$1 = inst_20569;
var inst_20553 = inst_20560;
var state_20603__$1 = (function (){var statearr_20614 = state_20603;
(statearr_20614[(13)] = inst_20553);

(statearr_20614[(7)] = inst_20552__$1);

return statearr_20614;
})();
var statearr_20615_20659 = state_20603__$1;
(statearr_20615_20659[(2)] = null);

(statearr_20615_20659[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (6))){
var inst_20520 = (state_20603[(17)]);
var state_20603__$1 = state_20603;
var statearr_20616_20660 = state_20603__$1;
(statearr_20616_20660[(2)] = inst_20520);

(statearr_20616_20660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (25))){
var inst_20598 = (state_20603[(2)]);
var _ = (function (){var statearr_20617 = state_20603;
(statearr_20617[(4)] = cljs.core.rest((state_20603[(4)])));

return statearr_20617;
})();
var state_20603__$1 = state_20603;
var statearr_20618_20661 = state_20603__$1;
(statearr_20618_20661[(2)] = inst_20598);

(statearr_20618_20661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (17))){
var inst_20553 = (state_20603[(13)]);
var inst_20559 = (state_20603[(18)]);
var inst_20558 = cljs.core.seq(inst_20553);
var inst_20559__$1 = cljs.core.first(inst_20558);
var inst_20560 = cljs.core.next(inst_20558);
var state_20603__$1 = (function (){var statearr_20619 = state_20603;
(statearr_20619[(16)] = inst_20560);

(statearr_20619[(18)] = inst_20559__$1);

return statearr_20619;
})();
if(cljs.core.truth_(inst_20559__$1)){
var statearr_20620_20662 = state_20603__$1;
(statearr_20620_20662[(1)] = (19));

} else {
var statearr_20621_20663 = state_20603__$1;
(statearr_20621_20663[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (3))){
var inst_20601 = (state_20603[(2)]);
var state_20603__$1 = state_20603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20603__$1,inst_20601);
} else {
if((state_val_20604 === (12))){
var inst_20526 = (state_20603[(19)]);
var inst_20537 = (state_20603[(12)]);
var inst_20532 = cljs.core.vals(inst_20526);
var inst_20533 = cljs.core.flatten(inst_20532);
var inst_20534 = cljs.core.set(inst_20533);
var inst_20535 = cljs.core.keys(inst_20526);
var inst_20536 = cljs.core.set(inst_20535);
var inst_20537__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20534,inst_20536);
var inst_20538 = cljs.core.empty_QMARK_(inst_20537__$1);
var state_20603__$1 = (function (){var statearr_20622 = state_20603;
(statearr_20622[(12)] = inst_20537__$1);

return statearr_20622;
})();
if(inst_20538){
var statearr_20623_20664 = state_20603__$1;
(statearr_20623_20664[(1)] = (14));

} else {
var statearr_20624_20665 = state_20603__$1;
(statearr_20624_20665[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (2))){
var inst_20520 = (state_20603[(17)]);
var _ = (function (){var statearr_20625 = state_20603;
(statearr_20625[(4)] = cljs.core.cons((5),(state_20603[(4)])));

return statearr_20625;
})();
var inst_20520__$1 = depth;
var state_20603__$1 = (function (){var statearr_20626 = state_20603;
(statearr_20626[(17)] = inst_20520__$1);

return statearr_20626;
})();
if(cljs.core.truth_(inst_20520__$1)){
var statearr_20627_20666 = state_20603__$1;
(statearr_20627_20666[(1)] = (6));

} else {
var statearr_20628_20667 = state_20603__$1;
(statearr_20628_20667[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (23))){
var inst_20591 = (state_20603[(10)]);
var state_20603__$1 = state_20603;
var statearr_20629_20668 = state_20603__$1;
(statearr_20629_20668[(2)] = inst_20591);

(statearr_20629_20668[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (19))){
var inst_20559 = (state_20603[(18)]);
var inst_20562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20563 = [inst_20559,predicate];
var inst_20564 = (new cljs.core.PersistentVector(null,2,(5),inst_20562,inst_20563,null));
var inst_20565 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20564);
var state_20603__$1 = state_20603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20603__$1,(22),inst_20565);
} else {
if((state_val_20604 === (11))){
var inst_20526 = (state_20603[(19)]);
var state_20603__$1 = state_20603;
var statearr_20631_20669 = state_20603__$1;
(statearr_20631_20669[(2)] = inst_20526);

(statearr_20631_20669[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (9))){
var inst_20524 = (state_20603[(9)]);
var inst_20527 = (state_20603[(20)]);
var inst_20529 = (inst_20527 >= inst_20524);
var state_20603__$1 = state_20603;
if(cljs.core.truth_(inst_20529)){
var statearr_20632_20670 = state_20603__$1;
(statearr_20632_20670[(1)] = (11));

} else {
var statearr_20633_20671 = state_20603__$1;
(statearr_20633_20671[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (5))){
var _ = (function (){var statearr_20634 = state_20603;
(statearr_20634[(4)] = cljs.core.rest((state_20603[(4)])));

return statearr_20634;
})();
var state_20603__$1 = state_20603;
var ex20630 = (state_20603__$1[(2)]);
var statearr_20635_20672 = state_20603__$1;
(statearr_20635_20672[(5)] = ex20630);


if((ex20630 instanceof Error)){
var statearr_20636_20673 = state_20603__$1;
(statearr_20636_20673[(1)] = (4));

(statearr_20636_20673[(5)] = null);

} else {
throw ex20630;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (14))){
var inst_20526 = (state_20603[(19)]);
var state_20603__$1 = state_20603;
var statearr_20637_20674 = state_20603__$1;
(statearr_20637_20674[(2)] = inst_20526);

(statearr_20637_20674[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (16))){
var inst_20584 = (state_20603[(2)]);
var state_20603__$1 = state_20603;
var statearr_20638_20675 = state_20603__$1;
(statearr_20638_20675[(2)] = inst_20584);

(statearr_20638_20675[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (10))){
var inst_20589 = (state_20603[(8)]);
var inst_20590 = (state_20603[(11)]);
var inst_20588 = (state_20603[(2)]);
var inst_20589__$1 = cljs.core.keys(inst_20588);
var inst_20590__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20589__$1,inst_20588);
var inst_20591 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20589__$1,inst_20590__$1);
var state_20603__$1 = (function (){var statearr_20639 = state_20603;
(statearr_20639[(8)] = inst_20589__$1);

(statearr_20639[(10)] = inst_20591);

(statearr_20639[(11)] = inst_20590__$1);

return statearr_20639;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20640_20676 = state_20603__$1;
(statearr_20640_20676[(1)] = (23));

} else {
var statearr_20641_20677 = state_20603__$1;
(statearr_20641_20677[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (18))){
var inst_20526 = (state_20603[(19)]);
var inst_20527 = (state_20603[(20)]);
var inst_20575 = (state_20603[(2)]);
var inst_20576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20577 = [(0),(2)];
var inst_20578 = (new cljs.core.PersistentVector(null,2,(5),inst_20576,inst_20577,null));
var inst_20579 = fluree.db.query.analytical.get_ns_arrays(inst_20578,inst_20575);
var inst_20580 = fluree.db.query.analytical.tuples__GT_map(inst_20526,inst_20579);
var inst_20581 = (inst_20527 + (1));
var inst_20526__$1 = inst_20580;
var inst_20527__$1 = inst_20581;
var state_20603__$1 = (function (){var statearr_20642 = state_20603;
(statearr_20642[(19)] = inst_20526__$1);

(statearr_20642[(20)] = inst_20527__$1);

return statearr_20642;
})();
var statearr_20643_20678 = state_20603__$1;
(statearr_20643_20678[(2)] = null);

(statearr_20643_20678[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20604 === (8))){
var inst_20524 = (state_20603[(2)]);
var inst_20525 = recur_map;
var inst_20526 = inst_20525;
var inst_20527 = (1);
var state_20603__$1 = (function (){var statearr_20644 = state_20603;
(statearr_20644[(19)] = inst_20526);

(statearr_20644[(9)] = inst_20524);

(statearr_20644[(20)] = inst_20527);

return statearr_20644;
})();
var statearr_20645_20679 = state_20603__$1;
(statearr_20645_20679[(2)] = null);

(statearr_20645_20679[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____0 = (function (){
var statearr_20646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20646[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__);

(statearr_20646[(1)] = (1));

return statearr_20646;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____1 = (function (state_20603){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20603);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20647){var ex__2720__auto__ = e20647;
var statearr_20648_20680 = state_20603;
(statearr_20648_20680[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20603[(4)]))){
var statearr_20649_20681 = state_20603;
(statearr_20649_20681[(1)] = cljs.core.first((state_20603[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20682 = state_20603;
state_20603 = G__20682;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__ = function(state_20603){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____1.call(this,state_20603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20650 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20650[(6)] = c__2739__auto__);

return statearr_20650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20683,clause,fuel,max_fuel){
var map__20684 = p__20683;
var map__20684__$1 = cljs.core.__destructure_map(map__20684);
var res = map__20684__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20684__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20684__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20684__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20795){
var state_val_20796 = (state_20795[(1)]);
if((state_val_20796 === (7))){
var inst_20701 = (state_20795[(7)]);
var state_20795__$1 = state_20795;
var statearr_20797_20850 = state_20795__$1;
(statearr_20797_20850[(2)] = inst_20701);

(statearr_20797_20850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (20))){
var inst_20729 = (state_20795[(8)]);
var inst_20760 = typeof inst_20729 === 'number';
var state_20795__$1 = state_20795;
if(cljs.core.truth_(inst_20760)){
var statearr_20798_20851 = state_20795__$1;
(statearr_20798_20851[(1)] = (22));

} else {
var statearr_20799_20852 = state_20795__$1;
(statearr_20799_20852[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (27))){
var inst_20775 = (state_20795[(2)]);
var state_20795__$1 = state_20795;
var statearr_20800_20853 = state_20795__$1;
(statearr_20800_20853[(2)] = inst_20775);

(statearr_20800_20853[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (1))){
var state_20795__$1 = state_20795;
var statearr_20801_20854 = state_20795__$1;
(statearr_20801_20854[(2)] = null);

(statearr_20801_20854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (24))){
var inst_20777 = (state_20795[(2)]);
var state_20795__$1 = state_20795;
var statearr_20802_20855 = state_20795__$1;
(statearr_20802_20855[(2)] = inst_20777);

(statearr_20802_20855[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (4))){
var inst_20685 = (state_20795[(2)]);
var state_20795__$1 = state_20795;
var statearr_20803_20856 = state_20795__$1;
(statearr_20803_20856[(2)] = inst_20685);

(statearr_20803_20856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (15))){
var inst_20743 = (state_20795[(2)]);
var inst_20744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20745 = fluree.db.query.analytical.variable_QMARK_(inst_20744);
var state_20795__$1 = (function (){var statearr_20804 = state_20795;
(statearr_20804[(9)] = inst_20743);

return statearr_20804;
})();
if(cljs.core.truth_(inst_20745)){
var statearr_20805_20857 = state_20795__$1;
(statearr_20805_20857[(1)] = (16));

} else {
var statearr_20806_20858 = state_20795__$1;
(statearr_20806_20858[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (21))){
var inst_20732 = (state_20795[(10)]);
var inst_20731 = (state_20795[(11)]);
var inst_20702 = (state_20795[(12)]);
var inst_20779 = (state_20795[(2)]);
var inst_20780 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20732,inst_20779,inst_20702,inst_20731);
var state_20795__$1 = state_20795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20795__$1,(28),inst_20780);
} else {
if((state_val_20796 === (13))){
var inst_20711 = (state_20795[(13)]);
var inst_20735 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20711)].join('');
var inst_20736 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20737 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20738 = cljs.core.PersistentHashMap.fromArrays(inst_20736,inst_20737);
var inst_20739 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20735,inst_20738);
var inst_20740 = (function(){throw inst_20739})();
var state_20795__$1 = state_20795;
var statearr_20807_20859 = state_20795__$1;
(statearr_20807_20859[(2)] = inst_20740);

(statearr_20807_20859[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (22))){
var inst_20727 = (state_20795[(14)]);
var inst_20729 = (state_20795[(8)]);
var inst_20762 = cljs.core.PersistentHashMap.EMPTY;
var inst_20763 = cljs.core.flatten(inst_20727);
var inst_20764 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20762,inst_20729,inst_20763);
var state_20795__$1 = state_20795;
var statearr_20808_20860 = state_20795__$1;
(statearr_20808_20860[(2)] = inst_20764);

(statearr_20808_20860[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (6))){
var inst_20713 = (state_20795[(15)]);
var state_20795__$1 = state_20795;
var statearr_20809_20861 = state_20795__$1;
(statearr_20809_20861[(2)] = inst_20713);

(statearr_20809_20861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (28))){
var inst_20782 = (state_20795[(2)]);
var inst_20783 = fluree.db.util.async.throw_err(inst_20782);
var state_20795__$1 = state_20795;
var statearr_20810_20862 = state_20795__$1;
(statearr_20810_20862[(2)] = inst_20783);

(statearr_20810_20862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (25))){
var inst_20727 = (state_20795[(14)]);
var inst_20723 = (state_20795[(16)]);
var inst_20768 = cljs.core.PersistentHashMap.EMPTY;
var inst_20769 = cljs.core.first(inst_20723);
var inst_20770 = cljs.core.first(inst_20769);
var inst_20771 = cljs.core.flatten(inst_20727);
var inst_20772 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20768,inst_20770,inst_20771);
var state_20795__$1 = state_20795;
var statearr_20811_20863 = state_20795__$1;
(statearr_20811_20863[(2)] = inst_20772);

(statearr_20811_20863[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (17))){
var inst_20711 = (state_20795[(13)]);
var inst_20748 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20711)].join('');
var inst_20749 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20750 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20751 = cljs.core.PersistentHashMap.fromArrays(inst_20749,inst_20750);
var inst_20752 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20748,inst_20751);
var inst_20753 = (function(){throw inst_20752})();
var state_20795__$1 = state_20795;
var statearr_20812_20864 = state_20795__$1;
(statearr_20812_20864[(2)] = inst_20753);

(statearr_20812_20864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (3))){
var inst_20793 = (state_20795[(2)]);
var state_20795__$1 = state_20795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20795__$1,inst_20793);
} else {
if((state_val_20796 === (12))){
var inst_20698 = (state_20795[(17)]);
var inst_20786 = (state_20795[(2)]);
var inst_20787 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20788 = cljs.core.keys(inst_20698);
var inst_20789 = [inst_20788,vars,inst_20786];
var inst_20790 = cljs.core.PersistentHashMap.fromArrays(inst_20787,inst_20789);
var _ = (function (){var statearr_20813 = state_20795;
(statearr_20813[(4)] = cljs.core.rest((state_20795[(4)])));

return statearr_20813;
})();
var state_20795__$1 = state_20795;
var statearr_20814_20865 = state_20795__$1;
(statearr_20814_20865[(2)] = inst_20790);

(statearr_20814_20865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (2))){
var inst_20713 = (state_20795[(15)]);
var inst_20698 = (state_20795[(17)]);
var inst_20702 = (state_20795[(12)]);
var inst_20701 = (state_20795[(7)]);
var _ = (function (){var statearr_20815 = state_20795;
(statearr_20815[(4)] = cljs.core.cons((5),(state_20795[(4)])));

return statearr_20815;
})();
var inst_20695 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20696 = cljs.core.__destructure_map(inst_20695);
var inst_20697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20696,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20698__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20696,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20696,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20700 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20701__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20699);
var inst_20702__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20699);
var inst_20704 = (function (){var map__20691 = inst_20696;
var search = inst_20697;
var rel = inst_20698__$1;
var opts = inst_20699;
var common_keys = inst_20700;
var object_fn = inst_20701__$1;
var recur_depth = inst_20702__$1;
return (function (p__20703,common_key){
var vec__20816 = p__20703;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20816,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20816,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20819 = cljs.core._EQ_;
var expr__20820 = idx_of;
if(cljs.core.truth_((pred__20819.cljs$core$IFn$_invoke$arity$2 ? pred__20819.cljs$core$IFn$_invoke$arity$2((0),expr__20820) : pred__20819.call(null,(0),expr__20820)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20819.cljs$core$IFn$_invoke$arity$2 ? pred__20819.cljs$core$IFn$_invoke$arity$2((1),expr__20820) : pred__20819.call(null,(1),expr__20820)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20819.cljs$core$IFn$_invoke$arity$2 ? pred__20819.cljs$core$IFn$_invoke$arity$2((2),expr__20820) : pred__20819.call(null,(2),expr__20820)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20820)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20706 = cljs.core.PersistentHashMap.EMPTY;
var inst_20707 = [inst_20706,inst_20697];
var inst_20708 = (new cljs.core.PersistentVector(null,2,(5),inst_20705,inst_20707,null));
var inst_20709 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20704,inst_20708,inst_20700);
var inst_20710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20709,(0),null);
var inst_20711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20709,(1),null);
var inst_20712 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20713__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20710);
var state_20795__$1 = (function (){var statearr_20822 = state_20795;
(statearr_20822[(15)] = inst_20713__$1);

(statearr_20822[(17)] = inst_20698__$1);

(statearr_20822[(13)] = inst_20711);

(statearr_20822[(12)] = inst_20702__$1);

(statearr_20822[(18)] = inst_20712);

(statearr_20822[(7)] = inst_20701__$1);

return statearr_20822;
})();
if(cljs.core.truth_(inst_20713__$1)){
var statearr_20823_20866 = state_20795__$1;
(statearr_20823_20866[(1)] = (6));

} else {
var statearr_20824_20867 = state_20795__$1;
(statearr_20824_20867[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (23))){
var inst_20729 = (state_20795[(8)]);
var inst_20766 = cljs.core.coll_QMARK_(inst_20729);
var state_20795__$1 = state_20795;
if(inst_20766){
var statearr_20825_20868 = state_20795__$1;
(statearr_20825_20868[(1)] = (25));

} else {
var statearr_20826_20869 = state_20795__$1;
(statearr_20826_20869[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (19))){
var inst_20727 = (state_20795[(14)]);
var inst_20757 = cljs.core.PersistentHashMap.EMPTY;
var inst_20758 = fluree.db.query.analytical.tuples__GT_map(inst_20757,inst_20727);
var state_20795__$1 = state_20795;
var statearr_20827_20870 = state_20795__$1;
(statearr_20827_20870[(2)] = inst_20758);

(statearr_20827_20870[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (11))){
var inst_20727 = (state_20795[(14)]);
var state_20795__$1 = state_20795;
var statearr_20829_20871 = state_20795__$1;
(statearr_20829_20871[(2)] = inst_20727);

(statearr_20829_20871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (9))){
var inst_20698 = (state_20795[(17)]);
var inst_20723 = (state_20795[(16)]);
var inst_20702 = (state_20795[(12)]);
var inst_20722 = (state_20795[(2)]);
var inst_20723__$1 = fluree.db.util.async.throw_err(inst_20722);
var inst_20724 = cljs.core.count(inst_20723__$1);
var inst_20725 = fluree.db.query.analytical.add_fuel(inst_20724,fuel,max_fuel);
var inst_20726 = cljs.core.vals(inst_20698);
var inst_20727 = fluree.db.query.analytical.get_ns_arrays(inst_20726,inst_20723__$1);
var state_20795__$1 = (function (){var statearr_20830 = state_20795;
(statearr_20830[(14)] = inst_20727);

(statearr_20830[(16)] = inst_20723__$1);

(statearr_20830[(19)] = inst_20725);

return statearr_20830;
})();
if(cljs.core.truth_(inst_20702)){
var statearr_20831_20872 = state_20795__$1;
(statearr_20831_20872[(1)] = (10));

} else {
var statearr_20832_20873 = state_20795__$1;
(statearr_20832_20873[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (5))){
var _ = (function (){var statearr_20833 = state_20795;
(statearr_20833[(4)] = cljs.core.rest((state_20795[(4)])));

return statearr_20833;
})();
var state_20795__$1 = state_20795;
var ex20828 = (state_20795__$1[(2)]);
var statearr_20834_20874 = state_20795__$1;
(statearr_20834_20874[(5)] = ex20828);


if((ex20828 instanceof Error)){
var statearr_20835_20875 = state_20795__$1;
(statearr_20835_20875[(1)] = (4));

(statearr_20835_20875[(5)] = null);

} else {
throw ex20828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (14))){
var state_20795__$1 = state_20795;
var statearr_20836_20876 = state_20795__$1;
(statearr_20836_20876[(2)] = null);

(statearr_20836_20876[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (26))){
var state_20795__$1 = state_20795;
var statearr_20837_20877 = state_20795__$1;
(statearr_20837_20877[(2)] = null);

(statearr_20837_20877[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (16))){
var state_20795__$1 = state_20795;
var statearr_20838_20878 = state_20795__$1;
(statearr_20838_20878[(2)] = null);

(statearr_20838_20878[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (10))){
var inst_20732 = (state_20795[(10)]);
var inst_20711 = (state_20795[(13)]);
var inst_20729 = cljs.core.first(inst_20711);
var inst_20730 = cljs.core.first(clause);
var inst_20731 = fluree.db.query.analytical.variable_QMARK_(inst_20730);
var inst_20732__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20711,(1));
var inst_20733 = fluree.db.query.analytical.variable_QMARK_(inst_20732__$1);
var state_20795__$1 = (function (){var statearr_20839 = state_20795;
(statearr_20839[(10)] = inst_20732__$1);

(statearr_20839[(11)] = inst_20731);

(statearr_20839[(8)] = inst_20729);

return statearr_20839;
})();
if(cljs.core.truth_(inst_20733)){
var statearr_20840_20879 = state_20795__$1;
(statearr_20840_20879[(1)] = (13));

} else {
var statearr_20841_20880 = state_20795__$1;
(statearr_20841_20880[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (18))){
var inst_20731 = (state_20795[(11)]);
var inst_20755 = (state_20795[(2)]);
var state_20795__$1 = (function (){var statearr_20842 = state_20795;
(statearr_20842[(20)] = inst_20755);

return statearr_20842;
})();
if(cljs.core.truth_(inst_20731)){
var statearr_20843_20881 = state_20795__$1;
(statearr_20843_20881[(1)] = (19));

} else {
var statearr_20844_20882 = state_20795__$1;
(statearr_20844_20882[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20796 === (8))){
var inst_20711 = (state_20795[(13)]);
var inst_20712 = (state_20795[(18)]);
var inst_20717 = (state_20795[(2)]);
var inst_20718 = [inst_20717];
var inst_20719 = cljs.core.PersistentHashMap.fromArrays(inst_20712,inst_20718);
var inst_20720 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20711,inst_20719);
var state_20795__$1 = state_20795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20795__$1,(9),inst_20720);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____0 = (function (){
var statearr_20845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20845[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__);

(statearr_20845[(1)] = (1));

return statearr_20845;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____1 = (function (state_20795){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20795);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20846){var ex__2720__auto__ = e20846;
var statearr_20847_20883 = state_20795;
(statearr_20847_20883[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20795[(4)]))){
var statearr_20848_20884 = state_20795;
(statearr_20848_20884[(1)] = cljs.core.first((state_20795[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20885 = state_20795;
state_20795 = G__20885;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__ = function(state_20795){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____1.call(this,state_20795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20849 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20849[(6)] = c__2739__auto__);

return statearr_20849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20886,res,clause){
var map__20887 = p__20886;
var map__20887__$1 = cljs.core.__destructure_map(map__20887);
var db = map__20887__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20887__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20887__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20887__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20996){
var state_val_20997 = (state_20996[(1)]);
if((state_val_20997 === (7))){
var inst_20896 = (state_20996[(7)]);
var state_20996__$1 = state_20996;
var statearr_20998_21039 = state_20996__$1;
(statearr_20998_21039[(2)] = inst_20896);

(statearr_20998_21039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (20))){
var state_20996__$1 = state_20996;
var statearr_20999_21040 = state_20996__$1;
(statearr_20999_21040[(2)] = null);

(statearr_20999_21040[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (1))){
var state_20996__$1 = state_20996;
var statearr_21000_21041 = state_20996__$1;
(statearr_21000_21041[(2)] = null);

(statearr_21000_21041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (24))){
var inst_20898 = (state_20996[(8)]);
var inst_20969 = (state_20996[(2)]);
var inst_20970 = fluree.db.flake.sid__GT_cid(inst_20969);
var inst_20971 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20970);
var inst_20972 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20974 = [inst_20898];
var inst_20975 = (new cljs.core.PersistentVector(null,1,(5),inst_20973,inst_20974,null));
var inst_20976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20978 = [inst_20971];
var inst_20979 = (new cljs.core.PersistentVector(null,1,(5),inst_20977,inst_20978,null));
var inst_20980 = [inst_20979];
var inst_20981 = (new cljs.core.PersistentVector(null,1,(5),inst_20976,inst_20980,null));
var inst_20982 = cljs.core.PersistentHashMap.EMPTY;
var inst_20983 = [inst_20975,inst_20981,inst_20982];
var inst_20984 = cljs.core.PersistentHashMap.fromArrays(inst_20972,inst_20983);
var state_20996__$1 = state_20996;
var statearr_21001_21042 = state_20996__$1;
(statearr_21001_21042[(2)] = inst_20984);

(statearr_21001_21042[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (4))){
var inst_20889 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
var statearr_21002_21043 = state_20996__$1;
(statearr_21002_21043[(2)] = inst_20889);

(statearr_21002_21043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (15))){
var inst_20896 = (state_20996[(7)]);
var inst_20898 = (state_20996[(8)]);
var inst_20917 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20918 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20920 = [inst_20896];
var inst_20921 = (new cljs.core.PersistentVector(null,1,(5),inst_20919,inst_20920,null));
var inst_20922 = (function (){var subject_var = inst_20896;
var object_var = inst_20898;
var min_sid = inst_20917;
var max_sid = (0);
return (function (p1__20888_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20888_SHARP_);
});
})();
var inst_20923 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20917,(0));
var inst_20924 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20922,inst_20923);
var inst_20925 = cljs.core.PersistentHashMap.EMPTY;
var inst_20926 = [inst_20921,inst_20924,inst_20925];
var inst_20927 = cljs.core.PersistentHashMap.fromArrays(inst_20918,inst_20926);
var state_20996__$1 = state_20996;
var statearr_21003_21044 = state_20996__$1;
(statearr_21003_21044[(2)] = inst_20927);

(statearr_21003_21044[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (21))){
var inst_20987 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
var statearr_21004_21045 = state_20996__$1;
(statearr_21004_21045[(2)] = inst_20987);

(statearr_21004_21045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (13))){
var inst_20898 = (state_20996[(8)]);
var state_20996__$1 = state_20996;
if(cljs.core.truth_(inst_20898)){
var statearr_21005_21046 = state_20996__$1;
(statearr_21005_21046[(1)] = (19));

} else {
var statearr_21006_21047 = state_20996__$1;
(statearr_21006_21047[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (22))){
var inst_20960 = (state_20996[(9)]);
var state_20996__$1 = state_20996;
var statearr_21007_21048 = state_20996__$1;
(statearr_21007_21048[(2)] = inst_20960);

(statearr_21007_21048[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (6))){
var inst_20898 = (state_20996[(8)]);
var state_20996__$1 = state_20996;
var statearr_21008_21049 = state_20996__$1;
(statearr_21008_21049[(2)] = inst_20898);

(statearr_21008_21049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (25))){
var inst_20966 = (state_20996[(2)]);
var inst_20967 = fluree.db.util.async.throw_err(inst_20966);
var state_20996__$1 = state_20996;
var statearr_21009_21050 = state_20996__$1;
(statearr_21009_21050[(2)] = inst_20967);

(statearr_21009_21050[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (17))){
var inst_20957 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
var statearr_21010_21051 = state_20996__$1;
(statearr_21010_21051[(2)] = inst_20957);

(statearr_21010_21051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (3))){
var inst_20994 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20996__$1,inst_20994);
} else {
if((state_val_20997 === (12))){
var inst_20911 = ["_tx",null,"_block",null];
var inst_20912 = (new cljs.core.PersistentArrayMap(null,2,inst_20911,null));
var inst_20913 = (new cljs.core.PersistentHashSet(null,inst_20912,null));
var inst_20914 = cljs.core.last(clause);
var inst_20915 = (inst_20913.cljs$core$IFn$_invoke$arity$1 ? inst_20913.cljs$core$IFn$_invoke$arity$1(inst_20914) : inst_20913.call(null,inst_20914));
var state_20996__$1 = state_20996;
if(cljs.core.truth_(inst_20915)){
var statearr_21011_21052 = state_20996__$1;
(statearr_21011_21052[(1)] = (15));

} else {
var statearr_21012_21053 = state_20996__$1;
(statearr_21012_21053[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (2))){
var inst_20896 = (state_20996[(7)]);
var _ = (function (){var statearr_21013 = state_20996;
(statearr_21013[(4)] = cljs.core.cons((5),(state_20996[(4)])));

return statearr_21013;
})();
var inst_20895 = cljs.core.first(clause);
var inst_20896__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20895);
var inst_20897 = cljs.core.last(clause);
var inst_20898 = fluree.db.query.analytical.variable_QMARK_(inst_20897);
var state_20996__$1 = (function (){var statearr_21014 = state_20996;
(statearr_21014[(7)] = inst_20896__$1);

(statearr_21014[(8)] = inst_20898);

return statearr_21014;
})();
if(cljs.core.truth_(inst_20896__$1)){
var statearr_21015_21054 = state_20996__$1;
(statearr_21015_21054[(1)] = (6));

} else {
var statearr_21016_21055 = state_20996__$1;
(statearr_21016_21055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (23))){
var inst_20960 = (state_20996[(9)]);
var inst_20964 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20960);
var state_20996__$1 = state_20996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20996__$1,(25),inst_20964);
} else {
if((state_val_20997 === (19))){
var inst_20960 = (state_20996[(9)]);
var inst_20960__$1 = cljs.core.first(clause);
var inst_20961 = typeof inst_20960__$1 === 'number';
var state_20996__$1 = (function (){var statearr_21017 = state_20996;
(statearr_21017[(9)] = inst_20960__$1);

return statearr_21017;
})();
if(cljs.core.truth_(inst_20961)){
var statearr_21018_21056 = state_20996__$1;
(statearr_21018_21056[(1)] = (22));

} else {
var statearr_21019_21057 = state_20996__$1;
(statearr_21019_21057[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (11))){
var inst_20991 = (state_20996[(2)]);
var _ = (function (){var statearr_21021 = state_20996;
(statearr_21021[(4)] = cljs.core.rest((state_20996[(4)])));

return statearr_21021;
})();
var state_20996__$1 = state_20996;
var statearr_21022_21058 = state_20996__$1;
(statearr_21022_21058[(2)] = inst_20991);

(statearr_21022_21058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (9))){
var inst_20904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20905 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20906 = cljs.core.PersistentHashMap.fromArrays(inst_20904,inst_20905);
var inst_20907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20906);
var inst_20908 = (function(){throw inst_20907})();
var state_20996__$1 = state_20996;
var statearr_21023_21059 = state_20996__$1;
(statearr_21023_21059[(2)] = inst_20908);

(statearr_21023_21059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (5))){
var _ = (function (){var statearr_21024 = state_20996;
(statearr_21024[(4)] = cljs.core.rest((state_20996[(4)])));

return statearr_21024;
})();
var state_20996__$1 = state_20996;
var ex21020 = (state_20996__$1[(2)]);
var statearr_21025_21060 = state_20996__$1;
(statearr_21025_21060[(5)] = ex21020);


if((ex21020 instanceof Error)){
var statearr_21026_21061 = state_20996__$1;
(statearr_21026_21061[(1)] = (4));

(statearr_21026_21061[(5)] = null);

} else {
throw ex21020;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (14))){
var inst_20989 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
var statearr_21027_21062 = state_20996__$1;
(statearr_21027_21062[(2)] = inst_20989);

(statearr_21027_21062[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (16))){
var inst_20930 = (state_20996[(10)]);
var inst_20933 = (state_20996[(11)]);
var inst_20932 = (state_20996[(12)]);
var inst_20929 = cljs.core.last(clause);
var inst_20930__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20929);
var inst_20931 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20932__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20931,inst_20930__$1);
var inst_20933__$1 = fluree.db.flake.min_subject_id(inst_20930__$1);
var inst_20934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20935 = [inst_20932__$1];
var inst_20936 = (new cljs.core.PersistentVector(null,1,(5),inst_20934,inst_20935,null));
var inst_20937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20938 = [inst_20933__$1];
var inst_20939 = (new cljs.core.PersistentVector(null,1,(5),inst_20937,inst_20938,null));
var inst_20940 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20936,cljs.core._LT__EQ_,inst_20939);
var state_20996__$1 = (function (){var statearr_21028 = state_20996;
(statearr_21028[(10)] = inst_20930__$1);

(statearr_21028[(11)] = inst_20933__$1);

(statearr_21028[(12)] = inst_20932__$1);

return statearr_21028;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20996__$1,(18),inst_20940);
} else {
if((state_val_20997 === (10))){
var inst_20896 = (state_20996[(7)]);
var state_20996__$1 = state_20996;
if(cljs.core.truth_(inst_20896)){
var statearr_21029_21063 = state_20996__$1;
(statearr_21029_21063[(1)] = (12));

} else {
var statearr_21030_21064 = state_20996__$1;
(statearr_21030_21064[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (18))){
var inst_20930 = (state_20996[(10)]);
var inst_20896 = (state_20996[(7)]);
var inst_20933 = (state_20996[(11)]);
var inst_20932 = (state_20996[(12)]);
var inst_20898 = (state_20996[(8)]);
var inst_20942 = (state_20996[(2)]);
var inst_20943 = fluree.db.util.async.throw_err(inst_20942);
var inst_20944 = (function (){var subject_var = inst_20896;
var object_var = inst_20898;
var partition = inst_20930;
var max_sid = inst_20932;
var min_sid = inst_20933;
var flakes = inst_20943;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20945 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20944);
var inst_20946 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20947 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20945,inst_20946);
var inst_20948 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20950 = [inst_20896];
var inst_20951 = (new cljs.core.PersistentVector(null,1,(5),inst_20949,inst_20950,null));
var inst_20952 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20947,inst_20943);
var inst_20953 = cljs.core.PersistentHashMap.EMPTY;
var inst_20954 = [inst_20951,inst_20952,inst_20953];
var inst_20955 = cljs.core.PersistentHashMap.fromArrays(inst_20948,inst_20954);
var state_20996__$1 = state_20996;
var statearr_21031_21065 = state_20996__$1;
(statearr_21031_21065[(2)] = inst_20955);

(statearr_21031_21065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20997 === (8))){
var inst_20902 = (state_20996[(2)]);
var state_20996__$1 = state_20996;
if(cljs.core.truth_(inst_20902)){
var statearr_21032_21066 = state_20996__$1;
(statearr_21032_21066[(1)] = (9));

} else {
var statearr_21033_21067 = state_20996__$1;
(statearr_21033_21067[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____0 = (function (){
var statearr_21034 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21034[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__);

(statearr_21034[(1)] = (1));

return statearr_21034;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____1 = (function (state_20996){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20996);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e21035){var ex__2720__auto__ = e21035;
var statearr_21036_21068 = state_20996;
(statearr_21036_21068[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20996[(4)]))){
var statearr_21037_21069 = state_20996;
(statearr_21037_21069[(1)] = cljs.core.first((state_20996[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21070 = state_20996;
state_20996 = G__21070;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__ = function(state_20996){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____1.call(this,state_20996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_21038 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_21038[(6)] = c__2739__auto__);

return statearr_21038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21077 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21077;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__21078(s__21079){
return (new cljs.core.LazySeq(null,(function (){
var s__21079__$1 = s__21079;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__21079__$1);
if(temp__5753__auto__){
var s__21079__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21079__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__21079__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__21081 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__21080 = (0);
while(true){
if((i__21080 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__21080);
var delta = (x - mean);
cljs.core.chunk_append(b__21081,(delta * delta));

var G__21083 = (i__21080 + (1));
i__21080 = G__21083;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21081),fluree$db$query$analytical$variance_$_iter__21078(cljs.core.chunk_rest(s__21079__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21081),null);
}
} else {
var x = cljs.core.first(s__21079__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21078(cljs.core.rest(s__21079__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21082 = variance(coll);
return Math.sqrt(G__21082);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__21084 = null;
var G__21084__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21084__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21084 = function(n,coll){
switch(arguments.length){
case 1:
return G__21084__1.call(this,n);
case 2:
return G__21084__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21084.cljs$core$IFn$_invoke$arity$1 = G__21084__1;
G__21084.cljs$core$IFn$_invoke$arity$2 = G__21084__2;
return G__21084;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21085 = null;
var G__21085__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21085__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21085 = function(n,coll){
switch(arguments.length){
case 1:
return G__21085__1.call(this,n);
case 2:
return G__21085__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21085.cljs$core$IFn$_invoke$arity$1 = G__21085__1;
G__21085.cljs$core$IFn$_invoke$arity$2 = G__21085__2;
return G__21085;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21086 = null;
var G__21086__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21086__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21086 = function(n,coll){
switch(arguments.length){
case 1:
return G__21086__1.call(this,n);
case 2:
return G__21086__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21086.cljs$core$IFn$_invoke$arity$1 = G__21086__1;
G__21086.cljs$core$IFn$_invoke$arity$2 = G__21086__2;
return G__21086;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__21087 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21087,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21087,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21087,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21090 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21093 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21093) : agg_fn.call(null,G__21093));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21090,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21090,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21094 = agg;
var map__21094__$1 = cljs.core.__destructure_map(map__21094);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21094__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21094__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21094__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21096 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21096,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21096,(1),null);
var map__21099 = res__$1;
var map__21099__$1 = cljs.core.__destructure_map(map__21099);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21099__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21099__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21095_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21095_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21100_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21100_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21101_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21101_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21102_SHARP_,p2__21103_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21102_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21103_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21104_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21104_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21107,row,b_tuple){
var vec__21108 = p__21107;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21108,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21108,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21105_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21105_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21106_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21106_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21111_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21111_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21112_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21112_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21117 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21119 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21118 = (function (p1__21113_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21113_SHARP_);
});
return fexpr__21118(G__21119);
})()),cljs.core.set(b_idxs));
var fexpr__21116 = (function (p1__21114_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21114_SHARP_);
});
return fexpr__21116(G__21117);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21115_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21115_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21120_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21120_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21121_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21121_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21126 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21128 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21127 = (function (p1__21122_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21122_SHARP_);
});
return fexpr__21127(G__21128);
})()),cljs.core.set(b_idxs));
var fexpr__21125 = (function (p1__21123_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21123_SHARP_);
});
return fexpr__21125(G__21126);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21124_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21124_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21130 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21130,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21130,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21129_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21129_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__21135 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21135,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21135,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21133_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21133_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21134_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21134_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21138,filters,optional_QMARK_){
var map__21139 = p__21138;
var map__21139__$1 = cljs.core.__destructure_map(map__21139);
var tuple_map = map__21139__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21139__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21139__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21139__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21140 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21140,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21140,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21143 = res;
var map__21143__$1 = cljs.core.__destructure_map(map__21143);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21143__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21143__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_21199){
var state_val_21200 = (state_21199[(1)]);
if((state_val_21200 === (7))){
var inst_21173 = (state_21199[(7)]);
var inst_21171 = (state_21199[(2)]);
var inst_21172 = fluree.db.util.async.throw_err(inst_21171);
var inst_21173__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21172,(0),null);
var inst_21174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21172,(1),null);
var inst_21175 = (inst_21173__$1 == null);
var state_21199__$1 = (function (){var statearr_21201 = state_21199;
(statearr_21201[(7)] = inst_21173__$1);

(statearr_21201[(8)] = inst_21174);

return statearr_21201;
})();
if(cljs.core.truth_(inst_21175)){
var statearr_21202_21231 = state_21199__$1;
(statearr_21202_21231[(1)] = (8));

} else {
var statearr_21203_21232 = state_21199__$1;
(statearr_21203_21232[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (1))){
var inst_21151 = optional_clauses;
var inst_21152 = cljs.core.seq(inst_21151);
var inst_21153 = cljs.core.first(inst_21152);
var inst_21154 = cljs.core.next(inst_21152);
var inst_21155 = where_tuples;
var inst_21156 = inst_21151;
var inst_21157 = inst_21155;
var state_21199__$1 = (function (){var statearr_21204 = state_21199;
(statearr_21204[(9)] = inst_21156);

(statearr_21204[(10)] = inst_21157);

(statearr_21204[(11)] = inst_21154);

(statearr_21204[(12)] = inst_21153);

return statearr_21204;
})();
var statearr_21205_21233 = state_21199__$1;
(statearr_21205_21233[(2)] = null);

(statearr_21205_21233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (4))){
var inst_21164 = (state_21199[(13)]);
var inst_21157 = (state_21199[(10)]);
var inst_21163 = (state_21199[(14)]);
var inst_21169 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21157,inst_21163,inst_21164,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21157,inst_21163,inst_21164,true,fuel,max_fuel,opts));
var state_21199__$1 = state_21199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21199__$1,(7),inst_21169);
} else {
if((state_val_21200 === (15))){
var state_21199__$1 = state_21199;
var statearr_21206_21234 = state_21199__$1;
(statearr_21206_21234[(2)] = null);

(statearr_21206_21234[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (13))){
var inst_21190 = (state_21199[(2)]);
var state_21199__$1 = state_21199;
var statearr_21207_21235 = state_21199__$1;
(statearr_21207_21235[(2)] = inst_21190);

(statearr_21207_21235[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (6))){
var inst_21195 = (state_21199[(2)]);
var state_21199__$1 = state_21199;
var statearr_21208_21236 = state_21199__$1;
(statearr_21208_21236[(2)] = inst_21195);

(statearr_21208_21236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (3))){
var inst_21197 = (state_21199[(2)]);
var state_21199__$1 = state_21199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21199__$1,inst_21197);
} else {
if((state_val_21200 === (12))){
var state_21199__$1 = state_21199;
var statearr_21209_21237 = state_21199__$1;
(statearr_21209_21237[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (2))){
var inst_21156 = (state_21199[(9)]);
var inst_21163 = (state_21199[(14)]);
var inst_21162 = cljs.core.seq(inst_21156);
var inst_21163__$1 = cljs.core.first(inst_21162);
var inst_21164 = cljs.core.next(inst_21162);
var state_21199__$1 = (function (){var statearr_21211 = state_21199;
(statearr_21211[(13)] = inst_21164);

(statearr_21211[(14)] = inst_21163__$1);

return statearr_21211;
})();
if(cljs.core.truth_(inst_21163__$1)){
var statearr_21212_21238 = state_21199__$1;
(statearr_21212_21238[(1)] = (4));

} else {
var statearr_21213_21239 = state_21199__$1;
(statearr_21213_21239[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (11))){
var inst_21173 = (state_21199[(7)]);
var inst_21174 = (state_21199[(8)]);
var inst_21156 = inst_21174;
var inst_21157 = inst_21173;
var state_21199__$1 = (function (){var statearr_21214 = state_21199;
(statearr_21214[(9)] = inst_21156);

(statearr_21214[(10)] = inst_21157);

return statearr_21214;
})();
var statearr_21215_21240 = state_21199__$1;
(statearr_21215_21240[(2)] = null);

(statearr_21215_21240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (9))){
var inst_21163 = (state_21199[(14)]);
var inst_21179 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21163);
var state_21199__$1 = state_21199;
if(cljs.core.truth_(inst_21179)){
var statearr_21216_21241 = state_21199__$1;
(statearr_21216_21241[(1)] = (11));

} else {
var statearr_21217_21242 = state_21199__$1;
(statearr_21217_21242[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (5))){
var inst_21157 = (state_21199[(10)]);
var state_21199__$1 = state_21199;
var statearr_21218_21243 = state_21199__$1;
(statearr_21218_21243[(2)] = inst_21157);

(statearr_21218_21243[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (14))){
var inst_21157 = (state_21199[(10)]);
var inst_21173 = (state_21199[(7)]);
var inst_21174 = (state_21199[(8)]);
var inst_21184 = fluree.db.query.analytical.left_outer_join(inst_21157,inst_21173);
var inst_21156 = inst_21174;
var inst_21157__$1 = inst_21184;
var state_21199__$1 = (function (){var statearr_21219 = state_21199;
(statearr_21219[(9)] = inst_21156);

(statearr_21219[(10)] = inst_21157__$1);

return statearr_21219;
})();
var statearr_21220_21244 = state_21199__$1;
(statearr_21220_21244[(2)] = null);

(statearr_21220_21244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (16))){
var inst_21188 = (state_21199[(2)]);
var state_21199__$1 = state_21199;
var statearr_21222_21245 = state_21199__$1;
(statearr_21222_21245[(2)] = inst_21188);

(statearr_21222_21245[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (10))){
var inst_21192 = (state_21199[(2)]);
var state_21199__$1 = state_21199;
var statearr_21223_21246 = state_21199__$1;
(statearr_21223_21246[(2)] = inst_21192);

(statearr_21223_21246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21200 === (8))){
var inst_21157 = (state_21199[(10)]);
var inst_21174 = (state_21199[(8)]);
var tmp21221 = inst_21157;
var inst_21156 = inst_21174;
var inst_21157__$1 = tmp21221;
var state_21199__$1 = (function (){var statearr_21224 = state_21199;
(statearr_21224[(9)] = inst_21156);

(statearr_21224[(10)] = inst_21157__$1);

return statearr_21224;
})();
var statearr_21225_21247 = state_21199__$1;
(statearr_21225_21247[(2)] = null);

(statearr_21225_21247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____0 = (function (){
var statearr_21226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21226[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__);

(statearr_21226[(1)] = (1));

return statearr_21226;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____1 = (function (state_21199){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_21199);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e21227){var ex__2720__auto__ = e21227;
var statearr_21228_21248 = state_21199;
(statearr_21228_21248[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_21199[(4)]))){
var statearr_21229_21249 = state_21199;
(statearr_21229_21249[(1)] = cljs.core.first((state_21199[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21250 = state_21199;
state_21199 = G__21250;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__ = function(state_21199){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____1.call(this,state_21199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_21230 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_21230[(6)] = c__2739__auto__);

return statearr_21230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21252){
var vec__21253 = p__21252;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21253,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21253,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21251_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21251_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21257,p__21258,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21259 = p__21257;
var map__21259__$1 = cljs.core.__destructure_map(map__21259);
var q_map = map__21259__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21259__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21260 = p__21258;
var map__21260__$1 = cljs.core.__destructure_map(map__21260);
var res = map__21260__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21260__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_21497){
var state_val_21498 = (state_21497[(1)]);
if((state_val_21498 === (65))){
var inst_21446 = (state_21497[(7)]);
var inst_21447 = (state_21497[(8)]);
var inst_21458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21459 = fluree.db.query.analytical.full_text__GT_tuples(inst_21446,res,inst_21447);
var inst_21460 = [inst_21459,r];
var inst_21461 = (new cljs.core.PersistentVector(null,2,(5),inst_21458,inst_21460,null));
var state_21497__$1 = state_21497;
var statearr_21499_21612 = state_21497__$1;
(statearr_21499_21612[(2)] = inst_21461);

(statearr_21499_21612[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (70))){
var inst_21473 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21500_21613 = state_21497__$1;
(statearr_21500_21613[(2)] = inst_21473);

(statearr_21500_21613[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (62))){
var inst_21447 = (state_21497[(8)]);
var inst_21455 = cljs.core.second(inst_21447);
var inst_21456 = clojure.string.starts_with_QMARK_(inst_21455,"fullText:");
var state_21497__$1 = state_21497;
if(inst_21456){
var statearr_21501_21614 = state_21497__$1;
(statearr_21501_21614[(1)] = (65));

} else {
var statearr_21502_21615 = state_21497__$1;
(statearr_21502_21615[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (7))){
var inst_21366 = (state_21497[(9)]);
var inst_21365 = cljs.core.count(clause);
var inst_21366__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21365);
var state_21497__$1 = (function (){var statearr_21503 = state_21497;
(statearr_21503[(9)] = inst_21366__$1);

return statearr_21503;
})();
if(inst_21366__$1){
var statearr_21504_21616 = state_21497__$1;
(statearr_21504_21616[(1)] = (31));

} else {
var statearr_21505_21617 = state_21497__$1;
(statearr_21505_21617[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (59))){
var inst_21480 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21506_21618 = state_21497__$1;
(statearr_21506_21618[(2)] = inst_21480);

(statearr_21506_21618[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (20))){
var inst_21329 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21507_21619 = state_21497__$1;
(statearr_21507_21619[(2)] = inst_21329);

(statearr_21507_21619[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (58))){
var state_21497__$1 = state_21497;
var statearr_21508_21620 = state_21497__$1;
(statearr_21508_21620[(2)] = null);

(statearr_21508_21620[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (60))){
var inst_21446 = (state_21497[(7)]);
var inst_21444 = (state_21497[(2)]);
var inst_21445 = fluree.db.util.async.throw_err(inst_21444);
var inst_21446__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21445,(0),null);
var inst_21447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21445,(1),null);
var inst_21448 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21446__$1);
var state_21497__$1 = (function (){var statearr_21509 = state_21497;
(statearr_21509[(7)] = inst_21446__$1);

(statearr_21509[(8)] = inst_21447);

return statearr_21509;
})();
if(inst_21448){
var statearr_21510_21621 = state_21497__$1;
(statearr_21510_21621[(1)] = (61));

} else {
var statearr_21511_21622 = state_21497__$1;
(statearr_21511_21622[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (27))){
var inst_21359 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21512_21623 = state_21497__$1;
(statearr_21512_21623[(2)] = inst_21359);

(statearr_21512_21623[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (1))){
var state_21497__$1 = state_21497;
var statearr_21513_21624 = state_21497__$1;
(statearr_21513_21624[(2)] = null);

(statearr_21513_21624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (69))){
var state_21497__$1 = state_21497;
var statearr_21514_21625 = state_21497__$1;
(statearr_21514_21625[(2)] = null);

(statearr_21514_21625[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (24))){
var inst_21323 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21515_21626 = state_21497__$1;
(statearr_21515_21626[(2)] = inst_21323);

(statearr_21515_21626[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (55))){
var inst_21429 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21430 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21431 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21432 = cljs.core.PersistentHashMap.fromArrays(inst_21430,inst_21431);
var inst_21433 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21429,inst_21432);
var inst_21434 = (function(){throw inst_21433})();
var state_21497__$1 = state_21497;
var statearr_21516_21627 = state_21497__$1;
(statearr_21516_21627[(2)] = inst_21434);

(statearr_21516_21627[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (39))){
var inst_21386 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
if(cljs.core.truth_(inst_21386)){
var statearr_21517_21628 = state_21497__$1;
(statearr_21517_21628[(1)] = (40));

} else {
var statearr_21518_21629 = state_21497__$1;
(statearr_21518_21629[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (46))){
var inst_21486 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21519_21630 = state_21497__$1;
(statearr_21519_21630[(2)] = inst_21486);

(statearr_21519_21630[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (4))){
var inst_21261 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21520_21631 = state_21497__$1;
(statearr_21520_21631[(2)] = inst_21261);

(statearr_21520_21631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (54))){
var inst_21422 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21423 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21424 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21425 = cljs.core.PersistentHashMap.fromArrays(inst_21423,inst_21424);
var inst_21426 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21422,inst_21425);
var inst_21427 = (function(){throw inst_21426})();
var state_21497__$1 = state_21497;
var statearr_21521_21632 = state_21497__$1;
(statearr_21521_21632[(2)] = inst_21427);

(statearr_21521_21632[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (15))){
var inst_21361 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21522_21633 = state_21497__$1;
(statearr_21522_21633[(2)] = inst_21361);

(statearr_21522_21633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (48))){
var inst_21410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21411 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21412 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21411);
var inst_21413 = [inst_21412,r];
var inst_21414 = (new cljs.core.PersistentVector(null,2,(5),inst_21410,inst_21413,null));
var state_21497__$1 = state_21497;
var statearr_21523_21634 = state_21497__$1;
(statearr_21523_21634[(2)] = inst_21414);

(statearr_21523_21634[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (50))){
var inst_21484 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21524_21635 = state_21497__$1;
(statearr_21524_21635[(2)] = inst_21484);

(statearr_21524_21635[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (21))){
var inst_21270 = (state_21497[(10)]);
var inst_21307 = (state_21497[(11)]);
var inst_21297 = (state_21497[(12)]);
var inst_21295 = (state_21497[(13)]);
var inst_21274 = (state_21497[(14)]);
var inst_21298 = (state_21497[(15)]);
var inst_21300 = (state_21497[(16)]);
var inst_21306 = (state_21497[(17)]);
var inst_21299 = (state_21497[(18)]);
var inst_21311 = (state_21497[(2)]);
var inst_21312 = fluree.db.util.async.throw_err(inst_21311);
var inst_21313 = (function (){var new_res = inst_21312;
var rest = inst_21307;
var tuples = inst_21300;
var G__21291 = inst_21299;
var seq__21293 = inst_21298;
var first__21304 = inst_21306;
var seq__21303 = inst_21307;
var first__21294 = inst_21297;
var vec__21292 = inst_21295;
var segment_type = inst_21270;
var pred__21271 = inst_21274;
var expr__21272 = inst_21270;
var clause_group = inst_21306;
var vec__21302 = inst_21299;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21314 = cljs.core.keys(vars);
var inst_21315 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21313,inst_21312,inst_21314);
var inst_21316 = fluree.db.query.analytical.res_absorb_vars(inst_21315);
var state_21497__$1 = (function (){var statearr_21525 = state_21497;
(statearr_21525[(19)] = inst_21316);

return statearr_21525;
})();
if(cljs.core.truth_(inst_21300)){
var statearr_21526_21636 = state_21497__$1;
(statearr_21526_21636[(1)] = (22));

} else {
var statearr_21527_21637 = state_21497__$1;
(statearr_21527_21637[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (31))){
var inst_21368 = cljs.core.second(clause);
var inst_21369 = clojure.string.starts_with_QMARK_(inst_21368,"fullText:");
var state_21497__$1 = state_21497;
var statearr_21528_21638 = state_21497__$1;
(statearr_21528_21638[(2)] = inst_21369);

(statearr_21528_21638[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (32))){
var inst_21366 = (state_21497[(9)]);
var state_21497__$1 = state_21497;
var statearr_21529_21639 = state_21497__$1;
(statearr_21529_21639[(2)] = inst_21366);

(statearr_21529_21639[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (40))){
var inst_21388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21389 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21497__$1 = (function (){var statearr_21530 = state_21497;
(statearr_21530[(20)] = inst_21388);

return statearr_21530;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(43),inst_21389);
} else {
if((state_val_21498 === (56))){
var inst_21436 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21531_21640 = state_21497__$1;
(statearr_21531_21640[(2)] = inst_21436);

(statearr_21531_21640[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (33))){
var inst_21372 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
if(cljs.core.truth_(inst_21372)){
var statearr_21532_21641 = state_21497__$1;
(statearr_21532_21641[(1)] = (34));

} else {
var statearr_21533_21642 = state_21497__$1;
(statearr_21533_21642[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (13))){
var inst_21295 = (state_21497[(13)]);
var inst_21295__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21296 = cljs.core.seq(inst_21295__$1);
var inst_21297 = cljs.core.first(inst_21296);
var inst_21298 = cljs.core.next(inst_21296);
var inst_21299 = inst_21295__$1;
var inst_21300 = null;
var state_21497__$1 = (function (){var statearr_21534 = state_21497;
(statearr_21534[(12)] = inst_21297);

(statearr_21534[(13)] = inst_21295__$1);

(statearr_21534[(15)] = inst_21298);

(statearr_21534[(16)] = inst_21300);

(statearr_21534[(18)] = inst_21299);

return statearr_21534;
})();
var statearr_21535_21643 = state_21497__$1;
(statearr_21535_21643[(2)] = null);

(statearr_21535_21643[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (22))){
var inst_21307 = (state_21497[(11)]);
var inst_21316 = (state_21497[(19)]);
var inst_21300 = (state_21497[(16)]);
var inst_21318 = fluree.db.query.union.results(inst_21300,inst_21316);
var inst_21299 = inst_21307;
var inst_21300__$1 = inst_21318;
var state_21497__$1 = (function (){var statearr_21536 = state_21497;
(statearr_21536[(16)] = inst_21300__$1);

(statearr_21536[(18)] = inst_21299);

return statearr_21536;
})();
var statearr_21537_21644 = state_21497__$1;
(statearr_21537_21644[(2)] = null);

(statearr_21537_21644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (36))){
var inst_21490 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21538_21645 = state_21497__$1;
(statearr_21538_21645[(2)] = inst_21490);

(statearr_21538_21645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (41))){
var inst_21396 = cljs.core.count(clause);
var inst_21397 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21396);
var state_21497__$1 = state_21497;
if(inst_21397){
var statearr_21539_21646 = state_21497__$1;
(statearr_21539_21646[(1)] = (44));

} else {
var statearr_21540_21647 = state_21497__$1;
(statearr_21540_21647[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (43))){
var inst_21388 = (state_21497[(20)]);
var inst_21391 = (state_21497[(2)]);
var inst_21392 = fluree.db.util.async.throw_err(inst_21391);
var inst_21393 = [inst_21392,r];
var inst_21394 = (new cljs.core.PersistentVector(null,2,(5),inst_21388,inst_21393,null));
var state_21497__$1 = state_21497;
var statearr_21541_21648 = state_21497__$1;
(statearr_21541_21648[(2)] = inst_21394);

(statearr_21541_21648[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (61))){
var inst_21447 = (state_21497[(8)]);
var inst_21450 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21447,r,res,optional_QMARK_,fuel,max_fuel);
var state_21497__$1 = state_21497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(64),inst_21450);
} else {
if((state_val_21498 === (29))){
var inst_21270 = (state_21497[(10)]);
var inst_21353 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21270)].join('');
var inst_21354 = (new Error(inst_21353));
var inst_21355 = (function(){throw inst_21354})();
var state_21497__$1 = state_21497;
var statearr_21542_21649 = state_21497__$1;
(statearr_21542_21649[(2)] = inst_21355);

(statearr_21542_21649[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (44))){
var inst_21399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21400 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21497__$1 = (function (){var statearr_21543 = state_21497;
(statearr_21543[(21)] = inst_21399);

return statearr_21543;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(47),inst_21400);
} else {
if((state_val_21498 === (6))){
var inst_21270 = (state_21497[(10)]);
var inst_21274 = (state_21497[(14)]);
var inst_21269 = cljs.core.keys(clause);
var inst_21270__$1 = cljs.core.first(inst_21269);
var inst_21274__$1 = cljs.core._EQ_;
var inst_21275 = (function (){var G__21544 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21545 = inst_21270__$1;
return (inst_21274__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21274__$1.cljs$core$IFn$_invoke$arity$2(G__21544,G__21545) : inst_21274__$1.call(null,G__21544,G__21545));
})();
var state_21497__$1 = (function (){var statearr_21546 = state_21497;
(statearr_21546[(10)] = inst_21270__$1);

(statearr_21546[(14)] = inst_21274__$1);

return statearr_21546;
})();
if(cljs.core.truth_(inst_21275)){
var statearr_21547_21650 = state_21497__$1;
(statearr_21547_21650[(1)] = (9));

} else {
var statearr_21548_21651 = state_21497__$1;
(statearr_21548_21651[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (28))){
var inst_21347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21348 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21349 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21348,optional_QMARK_);
var inst_21350 = [inst_21349,r];
var inst_21351 = (new cljs.core.PersistentVector(null,2,(5),inst_21347,inst_21350,null));
var state_21497__$1 = state_21497;
var statearr_21549_21652 = state_21497__$1;
(statearr_21549_21652[(2)] = inst_21351);

(statearr_21549_21652[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (64))){
var inst_21452 = (state_21497[(2)]);
var inst_21453 = fluree.db.util.async.throw_err(inst_21452);
var state_21497__$1 = state_21497;
var statearr_21550_21653 = state_21497__$1;
(statearr_21550_21653[(2)] = inst_21453);

(statearr_21550_21653[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (51))){
var inst_21419 = cljs.core.first(clause);
var inst_21420 = cljs.core.sequential_QMARK_(inst_21419);
var state_21497__$1 = state_21497;
if(inst_21420){
var statearr_21551_21654 = state_21497__$1;
(statearr_21551_21654[(1)] = (54));

} else {
var statearr_21552_21655 = state_21497__$1;
(statearr_21552_21655[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (25))){
var inst_21270 = (state_21497[(10)]);
var inst_21274 = (state_21497[(14)]);
var inst_21335 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21336 = (function (){var segment_type = inst_21270;
var pred__21271 = inst_21274;
var expr__21272 = inst_21270;
var bindings = inst_21335;
return (function (p1__21256_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21256_SHARP_);
});
})();
var inst_21337 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21336,inst_21335);
var inst_21338 = cljs.core.PersistentHashMap.EMPTY;
var inst_21339 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21338,inst_21337);
var inst_21340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21341 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21339);
var inst_21342 = [inst_21341,r];
var inst_21343 = (new cljs.core.PersistentVector(null,2,(5),inst_21340,inst_21342,null));
var state_21497__$1 = state_21497;
var statearr_21553_21656 = state_21497__$1;
(statearr_21553_21656[(2)] = inst_21343);

(statearr_21553_21656[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (34))){
var inst_21374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21375 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21376 = [inst_21375,r];
var inst_21377 = (new cljs.core.PersistentVector(null,2,(5),inst_21374,inst_21376,null));
var state_21497__$1 = state_21497;
var statearr_21554_21657 = state_21497__$1;
(statearr_21554_21657[(2)] = inst_21377);

(statearr_21554_21657[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (17))){
var inst_21331 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21555_21658 = state_21497__$1;
(statearr_21555_21658[(2)] = inst_21331);

(statearr_21555_21658[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (3))){
var inst_21495 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21497__$1,inst_21495);
} else {
if((state_val_21498 === (12))){
var inst_21277 = (state_21497[(22)]);
var inst_21281 = (state_21497[(2)]);
var inst_21282 = fluree.db.util.async.throw_err(inst_21281);
var inst_21283 = [inst_21282,r];
var inst_21284 = (new cljs.core.PersistentVector(null,2,(5),inst_21277,inst_21283,null));
var state_21497__$1 = state_21497;
var statearr_21556_21659 = state_21497__$1;
(statearr_21556_21659[(2)] = inst_21284);

(statearr_21556_21659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (2))){
var _ = (function (){var statearr_21557 = state_21497;
(statearr_21557[(4)] = cljs.core.cons((5),(state_21497[(4)])));

return statearr_21557;
})();
var inst_21267 = cljs.core.map_QMARK_(clause);
var state_21497__$1 = state_21497;
if(inst_21267){
var statearr_21558_21660 = state_21497__$1;
(statearr_21558_21660[(1)] = (6));

} else {
var statearr_21559_21661 = state_21497__$1;
(statearr_21559_21661[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (66))){
var state_21497__$1 = state_21497;
var statearr_21560_21662 = state_21497__$1;
(statearr_21560_21662[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (23))){
var inst_21307 = (state_21497[(11)]);
var inst_21316 = (state_21497[(19)]);
var inst_21299 = inst_21307;
var inst_21300 = inst_21316;
var state_21497__$1 = (function (){var statearr_21562 = state_21497;
(statearr_21562[(16)] = inst_21300);

(statearr_21562[(18)] = inst_21299);

return statearr_21562;
})();
var statearr_21563_21663 = state_21497__$1;
(statearr_21563_21663[(2)] = null);

(statearr_21563_21663[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (47))){
var inst_21399 = (state_21497[(21)]);
var inst_21402 = (state_21497[(2)]);
var inst_21403 = fluree.db.util.async.throw_err(inst_21402);
var inst_21404 = [inst_21403,r];
var inst_21405 = (new cljs.core.PersistentVector(null,2,(5),inst_21399,inst_21404,null));
var state_21497__$1 = state_21497;
var statearr_21564_21664 = state_21497__$1;
(statearr_21564_21664[(2)] = inst_21405);

(statearr_21564_21664[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (35))){
var inst_21380 = (state_21497[(23)]);
var inst_21379 = cljs.core.count(clause);
var inst_21380__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21379);
var state_21497__$1 = (function (){var statearr_21565 = state_21497;
(statearr_21565[(23)] = inst_21380__$1);

return statearr_21565;
})();
if(inst_21380__$1){
var statearr_21566_21665 = state_21497__$1;
(statearr_21566_21665[(1)] = (37));

} else {
var statearr_21567_21666 = state_21497__$1;
(statearr_21567_21666[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (19))){
var inst_21300 = (state_21497[(16)]);
var inst_21325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21326 = [inst_21300,r];
var inst_21327 = (new cljs.core.PersistentVector(null,2,(5),inst_21325,inst_21326,null));
var state_21497__$1 = state_21497;
var statearr_21568_21667 = state_21497__$1;
(statearr_21568_21667[(2)] = inst_21327);

(statearr_21568_21667[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (57))){
var inst_21442 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21497__$1 = state_21497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(60),inst_21442);
} else {
if((state_val_21498 === (68))){
var inst_21446 = (state_21497[(7)]);
var inst_21447 = (state_21497[(8)]);
var inst_21464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21465 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21446,res,inst_21447,fuel,max_fuel);
var state_21497__$1 = (function (){var statearr_21569 = state_21497;
(statearr_21569[(24)] = inst_21464);

return statearr_21569;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(71),inst_21465);
} else {
if((state_val_21498 === (11))){
var inst_21363 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21571_21668 = state_21497__$1;
(statearr_21571_21668[(2)] = inst_21363);

(statearr_21571_21668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (9))){
var inst_21277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21278 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21279 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21278,res,fuel,max_fuel,opts);
var state_21497__$1 = (function (){var statearr_21572 = state_21497;
(statearr_21572[(22)] = inst_21277);

return statearr_21572;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(12),inst_21279);
} else {
if((state_val_21498 === (5))){
var _ = (function (){var statearr_21573 = state_21497;
(statearr_21573[(4)] = cljs.core.rest((state_21497[(4)])));

return statearr_21573;
})();
var state_21497__$1 = state_21497;
var ex21570 = (state_21497__$1[(2)]);
var statearr_21574_21669 = state_21497__$1;
(statearr_21574_21669[(5)] = ex21570);


if((ex21570 instanceof Error)){
var statearr_21575_21670 = state_21497__$1;
(statearr_21575_21670[(1)] = (4));

(statearr_21575_21670[(5)] = null);

} else {
throw ex21570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (14))){
var inst_21270 = (state_21497[(10)]);
var inst_21274 = (state_21497[(14)]);
var inst_21333 = (function (){var G__21576 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21577 = inst_21270;
return (inst_21274.cljs$core$IFn$_invoke$arity$2 ? inst_21274.cljs$core$IFn$_invoke$arity$2(G__21576,G__21577) : inst_21274.call(null,G__21576,G__21577));
})();
var state_21497__$1 = state_21497;
if(cljs.core.truth_(inst_21333)){
var statearr_21578_21671 = state_21497__$1;
(statearr_21578_21671[(1)] = (25));

} else {
var statearr_21579_21672 = state_21497__$1;
(statearr_21579_21672[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (45))){
var inst_21407 = cljs.core.count(clause);
var inst_21408 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21407);
var state_21497__$1 = state_21497;
if(inst_21408){
var statearr_21580_21673 = state_21497__$1;
(statearr_21580_21673[(1)] = (48));

} else {
var statearr_21581_21674 = state_21497__$1;
(statearr_21581_21674[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (53))){
var inst_21482 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21582_21675 = state_21497__$1;
(statearr_21582_21675[(2)] = inst_21482);

(statearr_21582_21675[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (26))){
var inst_21270 = (state_21497[(10)]);
var inst_21274 = (state_21497[(14)]);
var inst_21345 = (function (){var G__21583 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21584 = inst_21270;
return (inst_21274.cljs$core$IFn$_invoke$arity$2 ? inst_21274.cljs$core$IFn$_invoke$arity$2(G__21583,G__21584) : inst_21274.call(null,G__21583,G__21584));
})();
var state_21497__$1 = state_21497;
if(cljs.core.truth_(inst_21345)){
var statearr_21585_21676 = state_21497__$1;
(statearr_21585_21676[(1)] = (28));

} else {
var statearr_21586_21677 = state_21497__$1;
(statearr_21586_21677[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (16))){
var inst_21306 = (state_21497[(17)]);
var inst_21299 = (state_21497[(18)]);
var inst_21305 = cljs.core.seq(inst_21299);
var inst_21306__$1 = cljs.core.first(inst_21305);
var inst_21307 = cljs.core.next(inst_21305);
var state_21497__$1 = (function (){var statearr_21587 = state_21497;
(statearr_21587[(11)] = inst_21307);

(statearr_21587[(17)] = inst_21306__$1);

return statearr_21587;
})();
if(cljs.core.truth_(inst_21306__$1)){
var statearr_21588_21678 = state_21497__$1;
(statearr_21588_21678[(1)] = (18));

} else {
var statearr_21589_21679 = state_21497__$1;
(statearr_21589_21679[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (38))){
var inst_21380 = (state_21497[(23)]);
var state_21497__$1 = state_21497;
var statearr_21590_21680 = state_21497__$1;
(statearr_21590_21680[(2)] = inst_21380);

(statearr_21590_21680[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (30))){
var inst_21357 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21591_21681 = state_21497__$1;
(statearr_21591_21681[(2)] = inst_21357);

(statearr_21591_21681[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (10))){
var inst_21270 = (state_21497[(10)]);
var inst_21274 = (state_21497[(14)]);
var inst_21286 = (function (){var G__21592 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21593 = inst_21270;
return (inst_21274.cljs$core$IFn$_invoke$arity$2 ? inst_21274.cljs$core$IFn$_invoke$arity$2(G__21592,G__21593) : inst_21274.call(null,G__21592,G__21593));
})();
var state_21497__$1 = state_21497;
if(cljs.core.truth_(inst_21286)){
var statearr_21594_21682 = state_21497__$1;
(statearr_21594_21682[(1)] = (13));

} else {
var statearr_21595_21683 = state_21497__$1;
(statearr_21595_21683[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (18))){
var inst_21306 = (state_21497[(17)]);
var inst_21309 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21306,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21306,q_map,vars,fuel,max_fuel,opts));
var state_21497__$1 = state_21497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21497__$1,(21),inst_21309);
} else {
if((state_val_21498 === (52))){
var state_21497__$1 = state_21497;
var statearr_21596_21684 = state_21497__$1;
(statearr_21596_21684[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (67))){
var inst_21475 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21598_21685 = state_21497__$1;
(statearr_21598_21685[(2)] = inst_21475);

(statearr_21598_21685[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (71))){
var inst_21464 = (state_21497[(24)]);
var inst_21467 = (state_21497[(2)]);
var inst_21468 = fluree.db.util.async.throw_err(inst_21467);
var inst_21469 = [inst_21468,r];
var inst_21470 = (new cljs.core.PersistentVector(null,2,(5),inst_21464,inst_21469,null));
var state_21497__$1 = state_21497;
var statearr_21599_21686 = state_21497__$1;
(statearr_21599_21686[(2)] = inst_21470);

(statearr_21599_21686[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (42))){
var inst_21488 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21600_21687 = state_21497__$1;
(statearr_21600_21687[(2)] = inst_21488);

(statearr_21600_21687[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (37))){
var inst_21382 = cljs.core.second(clause);
var inst_21383 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21382,"rdf:type");
var state_21497__$1 = state_21497;
var statearr_21601_21688 = state_21497__$1;
(statearr_21601_21688[(2)] = inst_21383);

(statearr_21601_21688[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (63))){
var inst_21477 = (state_21497[(2)]);
var state_21497__$1 = state_21497;
var statearr_21602_21689 = state_21497__$1;
(statearr_21602_21689[(2)] = inst_21477);

(statearr_21602_21689[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (8))){
var inst_21492 = (state_21497[(2)]);
var _ = (function (){var statearr_21603 = state_21497;
(statearr_21603[(4)] = cljs.core.rest((state_21497[(4)])));

return statearr_21603;
})();
var state_21497__$1 = state_21497;
var statearr_21604_21690 = state_21497__$1;
(statearr_21604_21690[(2)] = inst_21492);

(statearr_21604_21690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21498 === (49))){
var inst_21416 = cljs.core.count(clause);
var inst_21417 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21416);
var state_21497__$1 = state_21497;
if(inst_21417){
var statearr_21605_21691 = state_21497__$1;
(statearr_21605_21691[(1)] = (51));

} else {
var statearr_21606_21692 = state_21497__$1;
(statearr_21606_21692[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____0 = (function (){
var statearr_21607 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21607[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__);

(statearr_21607[(1)] = (1));

return statearr_21607;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____1 = (function (state_21497){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_21497);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e21608){var ex__2720__auto__ = e21608;
var statearr_21609_21693 = state_21497;
(statearr_21609_21693[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_21497[(4)]))){
var statearr_21610_21694 = state_21497;
(statearr_21610_21694[(1)] = cljs.core.first((state_21497[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21695 = state_21497;
state_21497 = G__21695;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__ = function(state_21497){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____1.call(this,state_21497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_21611 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_21611[(6)] = c__2739__auto__);

return statearr_21611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21697 = arguments.length;
switch (G__21697) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_21777){
var state_val_21778 = (state_21777[(1)]);
if((state_val_21778 === (7))){
var inst_21772 = (state_21777[(2)]);
var _ = (function (){var statearr_21779 = state_21777;
(statearr_21779[(4)] = cljs.core.rest((state_21777[(4)])));

return statearr_21779;
})();
var state_21777__$1 = state_21777;
var statearr_21780_21828 = state_21777__$1;
(statearr_21780_21828[(2)] = inst_21772);

(statearr_21780_21828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (20))){
var inst_21737 = (state_21777[(7)]);
var inst_21749 = (state_21777[(2)]);
var inst_21719 = inst_21737;
var inst_21720 = inst_21749;
var state_21777__$1 = (function (){var statearr_21781 = state_21777;
(statearr_21781[(8)] = inst_21719);

(statearr_21781[(9)] = inst_21720);

return statearr_21781;
})();
var statearr_21782_21829 = state_21777__$1;
(statearr_21782_21829[(2)] = null);

(statearr_21782_21829[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (1))){
var state_21777__$1 = state_21777;
var statearr_21783_21830 = state_21777__$1;
(statearr_21783_21830[(2)] = null);

(statearr_21783_21830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (24))){
var inst_21736 = (state_21777[(10)]);
var inst_21720 = (state_21777[(9)]);
var inst_21737 = (state_21777[(7)]);
var inst_21757 = fluree.db.query.analytical.inner_join(inst_21720,inst_21736);
var inst_21719 = inst_21737;
var inst_21720__$1 = inst_21757;
var state_21777__$1 = (function (){var statearr_21784 = state_21777;
(statearr_21784[(8)] = inst_21719);

(statearr_21784[(9)] = inst_21720__$1);

return statearr_21784;
})();
var statearr_21785_21831 = state_21777__$1;
(statearr_21785_21831[(2)] = null);

(statearr_21785_21831[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (4))){
var inst_21698 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21787_21832 = state_21777__$1;
(statearr_21787_21832[(2)] = inst_21698);

(statearr_21787_21832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (15))){
var inst_21736 = (state_21777[(10)]);
var state_21777__$1 = state_21777;
if(cljs.core.truth_(inst_21736)){
var statearr_21788_21833 = state_21777__$1;
(statearr_21788_21833[(1)] = (18));

} else {
var statearr_21789_21834 = state_21777__$1;
(statearr_21789_21834[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (21))){
var inst_21720 = (state_21777[(9)]);
var inst_21737 = (state_21777[(7)]);
var tmp21786 = inst_21720;
var inst_21719 = inst_21737;
var inst_21720__$1 = tmp21786;
var state_21777__$1 = (function (){var statearr_21790 = state_21777;
(statearr_21790[(8)] = inst_21719);

(statearr_21790[(9)] = inst_21720__$1);

return statearr_21790;
})();
var statearr_21791_21835 = state_21777__$1;
(statearr_21791_21835[(2)] = null);

(statearr_21791_21835[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (13))){
var inst_21720 = (state_21777[(9)]);
var inst_21743 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21720,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21744 = cljs.core.empty_QMARK_(inst_21743);
var state_21777__$1 = state_21777;
if(inst_21744){
var statearr_21792_21836 = state_21777__$1;
(statearr_21792_21836[(1)] = (15));

} else {
var statearr_21793_21837 = state_21777__$1;
(statearr_21793_21837[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (22))){
var state_21777__$1 = state_21777;
var statearr_21794_21838 = state_21777__$1;
(statearr_21794_21838[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (6))){
var inst_21726 = (state_21777[(11)]);
var inst_21719 = (state_21777[(8)]);
var inst_21725 = cljs.core.seq(inst_21719);
var inst_21726__$1 = cljs.core.first(inst_21725);
var inst_21727 = cljs.core.next(inst_21725);
var state_21777__$1 = (function (){var statearr_21796 = state_21777;
(statearr_21796[(11)] = inst_21726__$1);

(statearr_21796[(12)] = inst_21727);

return statearr_21796;
})();
if(cljs.core.truth_(inst_21726__$1)){
var statearr_21797_21839 = state_21777__$1;
(statearr_21797_21839[(1)] = (8));

} else {
var statearr_21798_21840 = state_21777__$1;
(statearr_21798_21840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (25))){
var state_21777__$1 = state_21777;
var statearr_21799_21841 = state_21777__$1;
(statearr_21799_21841[(2)] = null);

(statearr_21799_21841[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (17))){
var inst_21765 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21800_21842 = state_21777__$1;
(statearr_21800_21842[(2)] = inst_21765);

(statearr_21800_21842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (3))){
var inst_21775 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21777__$1,inst_21775);
} else {
if((state_val_21778 === (12))){
var inst_21736 = (state_21777[(10)]);
var inst_21737 = (state_21777[(7)]);
var inst_21719 = inst_21737;
var inst_21720 = inst_21736;
var state_21777__$1 = (function (){var statearr_21801 = state_21777;
(statearr_21801[(8)] = inst_21719);

(statearr_21801[(9)] = inst_21720);

return statearr_21801;
})();
var statearr_21802_21843 = state_21777__$1;
(statearr_21802_21843[(2)] = null);

(statearr_21802_21843[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (2))){
var _ = (function (){var statearr_21803 = state_21777;
(statearr_21803[(4)] = cljs.core.cons((5),(state_21777[(4)])));

return statearr_21803;
})();
var inst_21711 = where;
var inst_21712 = cljs.core.seq(inst_21711);
var inst_21713 = cljs.core.first(inst_21712);
var inst_21714 = cljs.core.next(inst_21712);
var inst_21715 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21716 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21717 = [inst_21716];
var inst_21718 = cljs.core.PersistentHashMap.fromArrays(inst_21715,inst_21717);
var inst_21719 = inst_21711;
var inst_21720 = inst_21718;
var state_21777__$1 = (function (){var statearr_21804 = state_21777;
(statearr_21804[(8)] = inst_21719);

(statearr_21804[(13)] = inst_21714);

(statearr_21804[(14)] = inst_21713);

(statearr_21804[(9)] = inst_21720);

return statearr_21804;
})();
var statearr_21805_21844 = state_21777__$1;
(statearr_21805_21844[(2)] = null);

(statearr_21805_21844[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (23))){
var inst_21763 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21806_21845 = state_21777__$1;
(statearr_21806_21845[(2)] = inst_21763);

(statearr_21806_21845[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (19))){
var inst_21720 = (state_21777[(9)]);
var state_21777__$1 = state_21777;
var statearr_21807_21846 = state_21777__$1;
(statearr_21807_21846[(2)] = inst_21720);

(statearr_21807_21846[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (11))){
var inst_21726 = (state_21777[(11)]);
var inst_21734 = (state_21777[(2)]);
var inst_21735 = fluree.db.util.async.throw_err(inst_21734);
var inst_21736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21735,(0),null);
var inst_21737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21735,(1),null);
var inst_21738 = cljs.core.count(inst_21726);
var inst_21739 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21738);
var state_21777__$1 = (function (){var statearr_21809 = state_21777;
(statearr_21809[(10)] = inst_21736);

(statearr_21809[(7)] = inst_21737);

return statearr_21809;
})();
if(inst_21739){
var statearr_21810_21847 = state_21777__$1;
(statearr_21810_21847[(1)] = (12));

} else {
var statearr_21811_21848 = state_21777__$1;
(statearr_21811_21848[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (9))){
var inst_21720 = (state_21777[(9)]);
var state_21777__$1 = state_21777;
var statearr_21812_21849 = state_21777__$1;
(statearr_21812_21849[(2)] = inst_21720);

(statearr_21812_21849[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (5))){
var _ = (function (){var statearr_21813 = state_21777;
(statearr_21813[(4)] = cljs.core.rest((state_21777[(4)])));

return statearr_21813;
})();
var state_21777__$1 = state_21777;
var ex21808 = (state_21777__$1[(2)]);
var statearr_21814_21850 = state_21777__$1;
(statearr_21814_21850[(5)] = ex21808);


if((ex21808 instanceof Error)){
var statearr_21815_21851 = state_21777__$1;
(statearr_21815_21851[(1)] = (4));

(statearr_21815_21851[(5)] = null);

} else {
throw ex21808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (14))){
var inst_21767 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21816_21852 = state_21777__$1;
(statearr_21816_21852[(2)] = inst_21767);

(statearr_21816_21852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (26))){
var inst_21761 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21817_21853 = state_21777__$1;
(statearr_21817_21853[(2)] = inst_21761);

(statearr_21817_21853[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (16))){
var inst_21736 = (state_21777[(10)]);
var inst_21752 = (inst_21736 == null);
var state_21777__$1 = state_21777;
if(cljs.core.truth_(inst_21752)){
var statearr_21818_21854 = state_21777__$1;
(statearr_21818_21854[(1)] = (21));

} else {
var statearr_21819_21855 = state_21777__$1;
(statearr_21819_21855[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (10))){
var inst_21770 = (state_21777[(2)]);
var state_21777__$1 = state_21777;
var statearr_21820_21856 = state_21777__$1;
(statearr_21820_21856[(2)] = inst_21770);

(statearr_21820_21856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (18))){
var inst_21736 = (state_21777[(10)]);
var state_21777__$1 = state_21777;
var statearr_21821_21857 = state_21777__$1;
(statearr_21821_21857[(2)] = inst_21736);

(statearr_21821_21857[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21778 === (8))){
var inst_21726 = (state_21777[(11)]);
var inst_21720 = (state_21777[(9)]);
var inst_21727 = (state_21777[(12)]);
var inst_21732 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21720,inst_21726,inst_21727,false,fuel,max_fuel,opts);
var state_21777__$1 = state_21777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21777__$1,(11),inst_21732);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2717__auto__ = null;
var fluree$db$query$analytical$state_machine__2717__auto____0 = (function (){
var statearr_21822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21822[(0)] = fluree$db$query$analytical$state_machine__2717__auto__);

(statearr_21822[(1)] = (1));

return statearr_21822;
});
var fluree$db$query$analytical$state_machine__2717__auto____1 = (function (state_21777){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_21777);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e21823){var ex__2720__auto__ = e21823;
var statearr_21824_21858 = state_21777;
(statearr_21824_21858[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_21777[(4)]))){
var statearr_21825_21859 = state_21777;
(statearr_21825_21859[(1)] = cljs.core.first((state_21777[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21860 = state_21777;
state_21777 = G__21860;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2717__auto__ = function(state_21777){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2717__auto____1.call(this,state_21777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2717__auto____0;
fluree$db$query$analytical$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2717__auto____1;
return fluree$db$query$analytical$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_21826 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_21826[(6)] = c__2739__auto__);

return statearr_21826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_21895){
var state_val_21896 = (state_21895[(1)]);
if((state_val_21896 === (7))){
var inst_21877 = (state_21895[(7)]);
var inst_21872 = (state_21895[(8)]);
var inst_21879 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21872,inst_21877,fuel,max_fuel,opts);
var state_21895__$1 = state_21895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21895__$1,(10),inst_21879);
} else {
if((state_val_21896 === (1))){
var state_21895__$1 = state_21895;
var statearr_21897_21922 = state_21895__$1;
(statearr_21897_21922[(2)] = null);

(statearr_21897_21922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (4))){
var inst_21861 = (state_21895[(2)]);
var state_21895__$1 = state_21895;
var statearr_21898_21923 = state_21895__$1;
(statearr_21898_21923[(2)] = inst_21861);

(statearr_21898_21923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (13))){
var inst_21890 = (state_21895[(2)]);
var _ = (function (){var statearr_21899 = state_21895;
(statearr_21899[(4)] = cljs.core.rest((state_21895[(4)])));

return statearr_21899;
})();
var state_21895__$1 = state_21895;
var statearr_21900_21924 = state_21895__$1;
(statearr_21900_21924[(2)] = inst_21890);

(statearr_21900_21924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (6))){
var inst_21872 = (state_21895[(8)]);
var inst_21876 = (state_21895[(2)]);
var inst_21877 = fluree.db.util.async.throw_err(inst_21876);
var state_21895__$1 = (function (){var statearr_21901 = state_21895;
(statearr_21901[(7)] = inst_21877);

return statearr_21901;
})();
if(cljs.core.truth_(inst_21872)){
var statearr_21902_21925 = state_21895__$1;
(statearr_21902_21925[(1)] = (7));

} else {
var statearr_21903_21926 = state_21895__$1;
(statearr_21903_21926[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (3))){
var inst_21893 = (state_21895[(2)]);
var state_21895__$1 = state_21895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21895__$1,inst_21893);
} else {
if((state_val_21896 === (12))){
var inst_21885 = (state_21895[(9)]);
var state_21895__$1 = state_21895;
var statearr_21904_21927 = state_21895__$1;
(statearr_21904_21927[(2)] = inst_21885);

(statearr_21904_21927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (2))){
var _ = (function (){var statearr_21905 = state_21895;
(statearr_21905[(4)] = cljs.core.cons((5),(state_21895[(4)])));

return statearr_21905;
})();
var inst_21868 = q_map;
var inst_21869 = cljs.core.__destructure_map(inst_21868);
var inst_21870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21869,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21869,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21869,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21869,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21874 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21871,q_map,inst_21870,fuel,max_fuel,opts);
var state_21895__$1 = (function (){var statearr_21906 = state_21895;
(statearr_21906[(10)] = inst_21873);

(statearr_21906[(8)] = inst_21872);

return statearr_21906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21895__$1,(6),inst_21874);
} else {
if((state_val_21896 === (11))){
var inst_21873 = (state_21895[(10)]);
var inst_21885 = (state_21895[(9)]);
var inst_21887 = fluree.db.query.analytical.tuples__GT_filtered(inst_21885,inst_21873,null);
var state_21895__$1 = state_21895;
var statearr_21908_21928 = state_21895__$1;
(statearr_21908_21928[(2)] = inst_21887);

(statearr_21908_21928[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (9))){
var inst_21873 = (state_21895[(10)]);
var inst_21885 = (state_21895[(2)]);
var state_21895__$1 = (function (){var statearr_21909 = state_21895;
(statearr_21909[(9)] = inst_21885);

return statearr_21909;
})();
if(cljs.core.truth_(inst_21873)){
var statearr_21910_21929 = state_21895__$1;
(statearr_21910_21929[(1)] = (11));

} else {
var statearr_21911_21930 = state_21895__$1;
(statearr_21911_21930[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (5))){
var _ = (function (){var statearr_21912 = state_21895;
(statearr_21912[(4)] = cljs.core.rest((state_21895[(4)])));

return statearr_21912;
})();
var state_21895__$1 = state_21895;
var ex21907 = (state_21895__$1[(2)]);
var statearr_21913_21931 = state_21895__$1;
(statearr_21913_21931[(5)] = ex21907);


if((ex21907 instanceof Error)){
var statearr_21914_21932 = state_21895__$1;
(statearr_21914_21932[(1)] = (4));

(statearr_21914_21932[(5)] = null);

} else {
throw ex21907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (10))){
var inst_21881 = (state_21895[(2)]);
var inst_21882 = fluree.db.util.async.throw_err(inst_21881);
var state_21895__$1 = state_21895;
var statearr_21915_21933 = state_21895__$1;
(statearr_21915_21933[(2)] = inst_21882);

(statearr_21915_21933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21896 === (8))){
var inst_21877 = (state_21895[(7)]);
var state_21895__$1 = state_21895;
var statearr_21916_21934 = state_21895__$1;
(statearr_21916_21934[(2)] = inst_21877);

(statearr_21916_21934[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2717__auto____0 = (function (){
var statearr_21917 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21917[(0)] = fluree$db$query$analytical$q_$_state_machine__2717__auto__);

(statearr_21917[(1)] = (1));

return statearr_21917;
});
var fluree$db$query$analytical$q_$_state_machine__2717__auto____1 = (function (state_21895){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_21895);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e21918){var ex__2720__auto__ = e21918;
var statearr_21919_21935 = state_21895;
(statearr_21919_21935[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_21895[(4)]))){
var statearr_21920_21936 = state_21895;
(statearr_21920_21936[(1)] = cljs.core.first((state_21895[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21937 = state_21895;
state_21895 = G__21937;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2717__auto__ = function(state_21895){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2717__auto____1.call(this,state_21895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2717__auto____0;
fluree$db$query$analytical$q_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2717__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_21921 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_21921[(6)] = c__2739__auto__);

return statearr_21921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
