// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19952_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19952_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19956 = coll;
var vec__19957 = G__19956;
var seq__19958 = cljs.core.seq(vec__19957);
var first__19959 = cljs.core.first(seq__19958);
var seq__19958__$1 = cljs.core.next(seq__19958);
var clause = first__19959;
var r = seq__19958__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19956__$1 = G__19956;
var res__$1 = res;
while(true){
var vec__19963 = G__19956__$1;
var seq__19964 = cljs.core.seq(vec__19963);
var first__19965 = cljs.core.first(seq__19964);
var seq__19964__$1 = cljs.core.next(seq__19964);
var clause__$1 = first__19965;
var r__$1 = seq__19964__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19966 = r__$1;
var G__19967 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19956__$1 = G__19966;
res__$1 = G__19967;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__19968){
var map__19969 = p__19968;
var map__19969__$1 = cljs.core.__destructure_map(map__19969);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19969__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19973 = coll;
var vec__19974 = G__19973;
var seq__19975 = cljs.core.seq(vec__19974);
var first__19976 = cljs.core.first(seq__19975);
var seq__19975__$1 = cljs.core.next(seq__19975);
var clause = first__19976;
var r = seq__19975__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19973__$1 = G__19973;
var res__$1 = res;
while(true){
var vec__19980 = G__19973__$1;
var seq__19981 = cljs.core.seq(vec__19980);
var first__19982 = cljs.core.first(seq__19981);
var seq__19981__$1 = cljs.core.next(seq__19981);
var clause__$1 = first__19982;
var r__$1 = seq__19981__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19983 = r__$1;
var G__19984 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19973__$1 = G__19983;
res__$1 = G__19984;
continue;
} else {
var G__19985 = r__$1;
var G__19986 = res__$2;
G__19973__$1 = G__19985;
res__$1 = G__19986;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19990 = coll;
var vec__19991 = G__19990;
var seq__19992 = cljs.core.seq(vec__19991);
var first__19993 = cljs.core.first(seq__19992);
var seq__19992__$1 = cljs.core.next(seq__19992);
var clause = first__19993;
var r = seq__19992__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19990__$1 = G__19990;
var res__$1 = res;
while(true){
var vec__19997 = G__19990__$1;
var seq__19998 = cljs.core.seq(vec__19997);
var first__19999 = cljs.core.first(seq__19998);
var seq__19998__$1 = cljs.core.next(seq__19998);
var clause__$1 = first__19999;
var r__$1 = seq__19998__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__20000 = r__$1;
var G__20001 = res__$2;
G__19990__$1 = G__20000;
res__$1 = G__20001;
continue;
} else {
var G__20002 = r__$1;
var G__20003 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19990__$1 = G__20002;
res__$1 = G__20003;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__20006 = clause;
var G__20006__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__20006):G__20006);
var G__20006__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__20006__$1)
;
var G__20006__$3 = (function (){var fexpr__20007 = (function (p1__20004_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20004_SHARP_)," ."].join('');
});
return fexpr__20007(G__20006__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__20008 = (function (p1__20005_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20005_SHARP_),"}"].join('');
});
return fexpr__20008(G__20006__$3);
} else {
return G__20006__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__20012 = opts;
var map__20012__$1 = cljs.core.__destructure_map(map__20012);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20012__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20012__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20012__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20012__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20012__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20009_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20009_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20010_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20010_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__20011_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__20011_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20026){
var state_val_20027 = (state_20026[(1)]);
if((state_val_20027 === (1))){
var inst_20013 = fluree.db.util.core.url_encode(query);
var inst_20014 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20013)].join('');
var inst_20015 = ["User-Agent","Accept"];
var inst_20016 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_20017 = cljs.core.PersistentHashMap.fromArrays(inst_20015,inst_20016);
var inst_20018 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_20019 = [inst_20017,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_20020 = cljs.core.PersistentHashMap.fromArrays(inst_20018,inst_20019);
var inst_20021 = fluree.db.util.xhttp.get(inst_20014,inst_20020);
var state_20026__$1 = state_20026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20026__$1,(2),inst_20021);
} else {
if((state_val_20027 === (2))){
var inst_20023 = (state_20026[(2)]);
var inst_20024 = fluree.db.util.async.throw_err(inst_20023);
var state_20026__$1 = state_20026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20026__$1,inst_20024);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____0 = (function (){
var statearr_20028 = [null,null,null,null,null,null,null];
(statearr_20028[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__);

(statearr_20028[(1)] = (1));

return statearr_20028;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____1 = (function (state_20026){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20026);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20029){var ex__2720__auto__ = e20029;
var statearr_20030_20033 = state_20026;
(statearr_20030_20033[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20026[(4)]))){
var statearr_20031_20034 = state_20026;
(statearr_20031_20034[(1)] = cljs.core.first((state_20026[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20035 = state_20026;
state_20026 = G__20035;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__ = function(state_20026){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____1.call(this,state_20026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20032 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20032[(6)] = c__2739__auto__);

return statearr_20032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20053){
var state_val_20054 = (state_20053[(1)]);
if((state_val_20054 === (1))){
var inst_20036 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20053__$1,(2),inst_20036);
} else {
if((state_val_20054 === (2))){
var inst_20039 = (state_20053[(7)]);
var inst_20038 = (state_20053[(2)]);
var inst_20039__$1 = fluree.db.util.async.throw_err(inst_20038);
var inst_20040 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20039__$1);
var inst_20041 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20040);
var state_20053__$1 = (function (){var statearr_20055 = state_20053;
(statearr_20055[(7)] = inst_20039__$1);

return statearr_20055;
})();
if(inst_20041){
var statearr_20056_20065 = state_20053__$1;
(statearr_20056_20065[(1)] = (3));

} else {
var statearr_20057_20066 = state_20053__$1;
(statearr_20057_20066[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (3))){
var inst_20039 = (state_20053[(7)]);
var state_20053__$1 = state_20053;
var statearr_20058_20067 = state_20053__$1;
(statearr_20058_20067[(2)] = inst_20039);

(statearr_20058_20067[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (4))){
var inst_20039 = (state_20053[(7)]);
var inst_20044 = (function (){var body = inst_20039;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20045 = cljs.core.second(inst_20039);
var inst_20046 = cljs.core.second(inst_20045);
var inst_20047 = cljs.core.first(inst_20046);
var inst_20048 = cljs.core.second(inst_20047);
var inst_20049 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20044,inst_20048);
var state_20053__$1 = state_20053;
var statearr_20059_20068 = state_20053__$1;
(statearr_20059_20068[(2)] = inst_20049);

(statearr_20059_20068[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (5))){
var inst_20051 = (state_20053[(2)]);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20053__$1,inst_20051);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____0 = (function (){
var statearr_20060 = [null,null,null,null,null,null,null,null];
(statearr_20060[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__);

(statearr_20060[(1)] = (1));

return statearr_20060;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____1 = (function (state_20053){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20053);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20061){var ex__2720__auto__ = e20061;
var statearr_20062_20069 = state_20053;
(statearr_20062_20069[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20053[(4)]))){
var statearr_20063_20070 = state_20053;
(statearr_20063_20070[(1)] = cljs.core.first((state_20053[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20071 = state_20053;
state_20053 = G__20071;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__ = function(state_20053){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____1.call(this,state_20053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20064 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20064[(6)] = c__2739__auto__);

return statearr_20064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20072_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20072_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20073_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20073_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20074_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20074_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20074_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20074_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_20120){
var state_val_20121 = (state_20120[(1)]);
if((state_val_20121 === (7))){
var inst_20085 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20120__$1 = state_20120;
var statearr_20122_20150 = state_20120__$1;
(statearr_20122_20150[(2)] = inst_20085);

(statearr_20122_20150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (1))){
var state_20120__$1 = state_20120;
var statearr_20123_20151 = state_20120__$1;
(statearr_20123_20151[(2)] = null);

(statearr_20123_20151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (4))){
var inst_20075 = (state_20120[(2)]);
var state_20120__$1 = state_20120;
var statearr_20124_20152 = state_20120__$1;
(statearr_20124_20152[(2)] = inst_20075);

(statearr_20124_20152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (15))){
var inst_20093 = (state_20120[(7)]);
var inst_20094 = (state_20120[(8)]);
var inst_20099 = (state_20120[(9)]);
var inst_20104 = (state_20120[(2)]);
var inst_20105 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20099,(0),inst_20104);
var inst_20106 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20107 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20093);
var inst_20108 = [inst_20094,inst_20107];
var inst_20109 = cljs.core.PersistentHashMap.fromArrays(inst_20106,inst_20108);
var inst_20110 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20105,inst_20109);
var inst_20111 = (function(){throw inst_20110})();
var state_20120__$1 = state_20120;
var statearr_20125_20153 = state_20120__$1;
(statearr_20125_20153[(2)] = inst_20111);

(statearr_20125_20153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (13))){
var inst_20098 = (state_20120[(10)]);
var state_20120__$1 = state_20120;
var statearr_20126_20154 = state_20120__$1;
(statearr_20126_20154[(2)] = inst_20098);

(statearr_20126_20154[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (6))){
var state_20120__$1 = state_20120;
var statearr_20127_20155 = state_20120__$1;
(statearr_20127_20155[(2)] = null);

(statearr_20127_20155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (3))){
var inst_20118 = (state_20120[(2)]);
var state_20120__$1 = state_20120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20120__$1,inst_20118);
} else {
if((state_val_20121 === (12))){
var inst_20115 = (state_20120[(2)]);
var _ = (function (){var statearr_20128 = state_20120;
(statearr_20128[(4)] = cljs.core.rest((state_20120[(4)])));

return statearr_20128;
})();
var state_20120__$1 = state_20120;
var statearr_20129_20156 = state_20120__$1;
(statearr_20129_20156[(2)] = inst_20115);

(statearr_20129_20156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (2))){
var _ = (function (){var statearr_20130 = state_20120;
(statearr_20130[(4)] = cljs.core.cons((5),(state_20120[(4)])));

return statearr_20130;
})();
var inst_20082 = cljs.core.empty_QMARK_(matching_vars);
var state_20120__$1 = state_20120;
if(inst_20082){
var statearr_20131_20157 = state_20120__$1;
(statearr_20131_20157[(1)] = (6));

} else {
var statearr_20132_20158 = state_20120__$1;
(statearr_20132_20158[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (11))){
var inst_20093 = (state_20120[(7)]);
var inst_20113 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20093,all_vars);
var state_20120__$1 = state_20120;
var statearr_20134_20159 = state_20120__$1;
(statearr_20134_20159[(2)] = inst_20113);

(statearr_20134_20159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (9))){
var inst_20093 = (state_20120[(7)]);
var inst_20094 = (state_20120[(8)]);
var inst_20091 = (state_20120[(2)]);
var inst_20092 = fluree.db.util.async.throw_err(inst_20091);
var inst_20093__$1 = cljs.core.__destructure_map(inst_20092);
var inst_20094__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20093__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20093__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20096 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20094__$1);
var state_20120__$1 = (function (){var statearr_20135 = state_20120;
(statearr_20135[(7)] = inst_20093__$1);

(statearr_20135[(8)] = inst_20094__$1);

(statearr_20135[(11)] = inst_20095);

return statearr_20135;
})();
if(inst_20096){
var statearr_20136_20160 = state_20120__$1;
(statearr_20136_20160[(1)] = (10));

} else {
var statearr_20137_20161 = state_20120__$1;
(statearr_20137_20161[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (5))){
var _ = (function (){var statearr_20138 = state_20120;
(statearr_20138[(4)] = cljs.core.rest((state_20120[(4)])));

return statearr_20138;
})();
var state_20120__$1 = state_20120;
var ex20133 = (state_20120__$1[(2)]);
var statearr_20139_20162 = state_20120__$1;
(statearr_20139_20162[(5)] = ex20133);


if((ex20133 instanceof Error)){
var statearr_20140_20163 = state_20120__$1;
(statearr_20140_20163[(1)] = (4));

(statearr_20140_20163[(5)] = null);

} else {
throw ex20133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (14))){
var state_20120__$1 = state_20120;
var statearr_20141_20164 = state_20120__$1;
(statearr_20141_20164[(2)] = (1000));

(statearr_20141_20164[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (10))){
var inst_20093 = (state_20120[(7)]);
var inst_20098 = (state_20120[(10)]);
var inst_20095 = (state_20120[(11)]);
var inst_20098__$1 = cljs.core.count(inst_20095);
var inst_20099 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20093);
var inst_20100 = (inst_20098__$1 < (1000));
var state_20120__$1 = (function (){var statearr_20142 = state_20120;
(statearr_20142[(10)] = inst_20098__$1);

(statearr_20142[(9)] = inst_20099);

return statearr_20142;
})();
if(cljs.core.truth_(inst_20100)){
var statearr_20143_20165 = state_20120__$1;
(statearr_20143_20165[(1)] = (13));

} else {
var statearr_20144_20166 = state_20120__$1;
(statearr_20144_20166[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20121 === (8))){
var inst_20087 = (state_20120[(2)]);
var inst_20088 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20087,optional_clauses);
var inst_20089 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20088);
var state_20120__$1 = state_20120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20120__$1,(9),inst_20089);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____0 = (function (){
var statearr_20145 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20145[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__);

(statearr_20145[(1)] = (1));

return statearr_20145;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____1 = (function (state_20120){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_20120);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e20146){var ex__2720__auto__ = e20146;
var statearr_20147_20167 = state_20120;
(statearr_20147_20167[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_20120[(4)]))){
var statearr_20148_20168 = state_20120;
(statearr_20148_20168[(1)] = cljs.core.first((state_20120[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20169 = state_20120;
state_20120 = G__20169;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__ = function(state_20120){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____1.call(this,state_20120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_20149 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_20149[(6)] = c__2739__auto__);

return statearr_20149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
