// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15821){
var state_val_15822 = (state_15821[(1)]);
if((state_val_15822 === (1))){
var state_15821__$1 = state_15821;
var statearr_15823_15837 = state_15821__$1;
(statearr_15823_15837[(2)] = null);

(statearr_15823_15837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15822 === (2))){
var _ = (function (){var statearr_15824 = state_15821;
(statearr_15824[(4)] = cljs.core.cons((5),(state_15821[(4)])));

return statearr_15824;
})();
var inst_15812 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15821__$1 = state_15821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15821__$1,(6),inst_15812);
} else {
if((state_val_15822 === (3))){
var inst_15819 = (state_15821[(2)]);
var state_15821__$1 = state_15821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15821__$1,inst_15819);
} else {
if((state_val_15822 === (4))){
var inst_15806 = (state_15821[(2)]);
var state_15821__$1 = state_15821;
var statearr_15826_15838 = state_15821__$1;
(statearr_15826_15838[(2)] = inst_15806);

(statearr_15826_15838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15822 === (5))){
var _ = (function (){var statearr_15827 = state_15821;
(statearr_15827[(4)] = cljs.core.rest((state_15821[(4)])));

return statearr_15827;
})();
var state_15821__$1 = state_15821;
var ex15825 = (state_15821__$1[(2)]);
var statearr_15828_15839 = state_15821__$1;
(statearr_15828_15839[(5)] = ex15825);


if((ex15825 instanceof Error)){
var statearr_15829_15840 = state_15821__$1;
(statearr_15829_15840[(1)] = (4));

(statearr_15829_15840[(5)] = null);

} else {
throw ex15825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15822 === (6))){
var inst_15814 = (state_15821[(2)]);
var inst_15815 = fluree.db.util.async.throw_err(inst_15814);
var inst_15816 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15815);
var _ = (function (){var statearr_15830 = state_15821;
(statearr_15830[(4)] = cljs.core.rest((state_15821[(4)])));

return statearr_15830;
})();
var state_15821__$1 = state_15821;
var statearr_15831_15841 = state_15821__$1;
(statearr_15831_15841[(2)] = inst_15816);

(statearr_15831_15841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____0 = (function (){
var statearr_15832 = [null,null,null,null,null,null,null];
(statearr_15832[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__);

(statearr_15832[(1)] = (1));

return statearr_15832;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____1 = (function (state_15821){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15821);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15833){var ex__2720__auto__ = e15833;
var statearr_15834_15842 = state_15821;
(statearr_15834_15842[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15821[(4)]))){
var statearr_15835_15843 = state_15821;
(statearr_15835_15843[(1)] = cljs.core.first((state_15821[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15844 = state_15821;
state_15821 = G__15844;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__ = function(state_15821){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____1.call(this,state_15821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15836 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15836[(6)] = c__2739__auto__);

return statearr_15836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15876){
var state_val_15877 = (state_15876[(1)]);
if((state_val_15877 === (7))){
var inst_15860 = (state_15876[(7)]);
var inst_15862 = cljs.core.empty_QMARK_(inst_15860);
var inst_15863 = (!(inst_15862));
var state_15876__$1 = state_15876;
var statearr_15878_15902 = state_15876__$1;
(statearr_15878_15902[(2)] = inst_15863);

(statearr_15878_15902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (1))){
var state_15876__$1 = state_15876;
var statearr_15879_15903 = state_15876__$1;
(statearr_15879_15903[(2)] = null);

(statearr_15879_15903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (4))){
var inst_15846 = (state_15876[(2)]);
var state_15876__$1 = state_15876;
var statearr_15880_15904 = state_15876__$1;
(statearr_15880_15904[(2)] = inst_15846);

(statearr_15880_15904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (6))){
var inst_15852 = (state_15876[(8)]);
var inst_15860 = (state_15876[(7)]);
var inst_15858 = (state_15876[(2)]);
var inst_15859 = fluree.db.util.async.throw_err(inst_15858);
var inst_15860__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15852,inst_15859);
var state_15876__$1 = (function (){var statearr_15881 = state_15876;
(statearr_15881[(7)] = inst_15860__$1);

return statearr_15881;
})();
if(cljs.core.truth_(inst_15860__$1)){
var statearr_15882_15905 = state_15876__$1;
(statearr_15882_15905[(1)] = (7));

} else {
var statearr_15883_15906 = state_15876__$1;
(statearr_15883_15906[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (3))){
var inst_15874 = (state_15876[(2)]);
var state_15876__$1 = state_15876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15876__$1,inst_15874);
} else {
if((state_val_15877 === (12))){
var inst_15871 = (state_15876[(2)]);
var _ = (function (){var statearr_15884 = state_15876;
(statearr_15884[(4)] = cljs.core.rest((state_15876[(4)])));

return statearr_15884;
})();
var state_15876__$1 = state_15876;
var statearr_15885_15907 = state_15876__$1;
(statearr_15885_15907[(2)] = inst_15871);

(statearr_15885_15907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (2))){
var _ = (function (){var statearr_15886 = state_15876;
(statearr_15886[(4)] = cljs.core.cons((5),(state_15876[(4)])));

return statearr_15886;
})();
var inst_15852 = (function (){return (function (p1__15845_SHARP_){
return p1__15845_SHARP_.o;
});
})();
var inst_15853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15854 = [pred_id];
var inst_15855 = (new cljs.core.PersistentVector(null,1,(5),inst_15853,inst_15854,null));
var inst_15856 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15855);
var state_15876__$1 = (function (){var statearr_15887 = state_15876;
(statearr_15887[(8)] = inst_15852);

return statearr_15887;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15876__$1,(6),inst_15856);
} else {
if((state_val_15877 === (11))){
var state_15876__$1 = state_15876;
var statearr_15889_15908 = state_15876__$1;
(statearr_15889_15908[(2)] = true);

(statearr_15889_15908[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (9))){
var inst_15866 = (state_15876[(2)]);
var state_15876__$1 = state_15876;
if(cljs.core.truth_(inst_15866)){
var statearr_15890_15909 = state_15876__$1;
(statearr_15890_15909[(1)] = (10));

} else {
var statearr_15891_15910 = state_15876__$1;
(statearr_15891_15910[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (5))){
var _ = (function (){var statearr_15892 = state_15876;
(statearr_15892[(4)] = cljs.core.rest((state_15876[(4)])));

return statearr_15892;
})();
var state_15876__$1 = state_15876;
var ex15888 = (state_15876__$1[(2)]);
var statearr_15893_15911 = state_15876__$1;
(statearr_15893_15911[(5)] = ex15888);


if((ex15888 instanceof Error)){
var statearr_15894_15912 = state_15876__$1;
(statearr_15894_15912[(1)] = (4));

(statearr_15894_15912[(5)] = null);

} else {
throw ex15888;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (10))){
var inst_15860 = (state_15876[(7)]);
var inst_15868 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15860);
var state_15876__$1 = state_15876;
var statearr_15895_15913 = state_15876__$1;
(statearr_15895_15913[(2)] = inst_15868);

(statearr_15895_15913[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15877 === (8))){
var inst_15860 = (state_15876[(7)]);
var state_15876__$1 = state_15876;
var statearr_15896_15914 = state_15876__$1;
(statearr_15896_15914[(2)] = inst_15860);

(statearr_15896_15914[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_15897 = [null,null,null,null,null,null,null,null,null];
(statearr_15897[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__);

(statearr_15897[(1)] = (1));

return statearr_15897;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____1 = (function (state_15876){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15876);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15898){var ex__2720__auto__ = e15898;
var statearr_15899_15915 = state_15876;
(statearr_15899_15915[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15876[(4)]))){
var statearr_15900_15916 = state_15876;
(statearr_15900_15916[(1)] = cljs.core.first((state_15876[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15917 = state_15876;
state_15876 = G__15917;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__ = function(state_15876){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____1.call(this,state_15876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15901 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15901[(6)] = c__2739__auto__);

return statearr_15901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15998){
var state_val_15999 = (state_15998[(1)]);
if((state_val_15999 === (7))){
var state_15998__$1 = state_15998;
var statearr_16000_16038 = state_15998__$1;
(statearr_16000_16038[(2)] = flakes);

(statearr_16000_16038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (20))){
var inst_15955 = (state_15998[(7)]);
var inst_15988 = (state_15998[(2)]);
var inst_15947 = inst_15955;
var inst_15948 = inst_15988;
var state_15998__$1 = (function (){var statearr_16001 = state_15998;
(statearr_16001[(8)] = inst_15947);

(statearr_16001[(9)] = inst_15948);

return statearr_16001;
})();
var statearr_16002_16039 = state_15998__$1;
(statearr_16002_16039[(2)] = null);

(statearr_16002_16039[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (1))){
var state_15998__$1 = state_15998;
var statearr_16003_16040 = state_15998__$1;
(statearr_16003_16040[(2)] = null);

(statearr_16003_16040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (4))){
var inst_15920 = (state_15998[(2)]);
var state_15998__$1 = state_15998;
var statearr_16004_16041 = state_15998__$1;
(statearr_16004_16041[(2)] = inst_15920);

(statearr_16004_16041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (15))){
var inst_15954 = (state_15998[(10)]);
var inst_15972 = inst_15954.o;
var state_15998__$1 = state_15998;
var statearr_16005_16042 = state_15998__$1;
(statearr_16005_16042[(2)] = inst_15972);

(statearr_16005_16042[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (13))){
var inst_15991 = (state_15998[(2)]);
var state_15998__$1 = state_15998;
var statearr_16006_16043 = state_15998__$1;
(statearr_16006_16043[(2)] = inst_15991);

(statearr_16006_16043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (6))){
var inst_15927 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15998__$1 = state_15998;
var statearr_16007_16044 = state_15998__$1;
(statearr_16007_16044[(2)] = inst_15927);

(statearr_16007_16044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (17))){
var inst_15969 = (state_15998[(2)]);
var inst_15970 = fluree.db.util.async.throw_err(inst_15969);
var state_15998__$1 = state_15998;
var statearr_16008_16045 = state_15998__$1;
(statearr_16008_16045[(2)] = inst_15970);

(statearr_16008_16045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (3))){
var inst_15996 = (state_15998[(2)]);
var state_15998__$1 = state_15998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15998__$1,inst_15996);
} else {
if((state_val_15999 === (12))){
var inst_15954 = (state_15998[(10)]);
var inst_15961 = (state_15998[(11)]);
var inst_15959 = inst_15954.p;
var inst_15960 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15959);
var inst_15961__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_15960);
var inst_15962 = inst_15954.op;
var inst_15963 = inst_15962 === false;
var inst_15964 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_15961__$1);
var state_15998__$1 = (function (){var statearr_16009 = state_15998;
(statearr_16009[(12)] = inst_15963);

(statearr_16009[(11)] = inst_15961__$1);

return statearr_16009;
})();
if(inst_15964){
var statearr_16010_16046 = state_15998__$1;
(statearr_16010_16046[(1)] = (14));

} else {
var statearr_16011_16047 = state_15998__$1;
(statearr_16011_16047[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (2))){
var _ = (function (){var statearr_16012 = state_15998;
(statearr_16012[(4)] = cljs.core.cons((5),(state_15998[(4)])));

return statearr_16012;
})();
var state_15998__$1 = state_15998;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16013_16048 = state_15998__$1;
(statearr_16013_16048[(1)] = (6));

} else {
var statearr_16014_16049 = state_15998__$1;
(statearr_16014_16049[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (19))){
var inst_15954 = (state_15998[(10)]);
var inst_15974 = (state_15998[(13)]);
var inst_15948 = (state_15998[(9)]);
var inst_15961 = (state_15998[(11)]);
var inst_15982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15983 = inst_15954.s;
var inst_15984 = [inst_15983,inst_15961,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15985 = (new cljs.core.PersistentVector(null,3,(5),inst_15982,inst_15984,null));
var inst_15986 = cljs.core.assoc_in(inst_15948,inst_15985,inst_15974);
var state_15998__$1 = state_15998;
var statearr_16015_16050 = state_15998__$1;
(statearr_16015_16050[(2)] = inst_15986);

(statearr_16015_16050[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (11))){
var inst_15948 = (state_15998[(9)]);
var state_15998__$1 = state_15998;
var statearr_16017_16051 = state_15998__$1;
(statearr_16017_16051[(2)] = inst_15948);

(statearr_16017_16051[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (9))){
var inst_15954 = (state_15998[(10)]);
var inst_15947 = (state_15998[(8)]);
var inst_15953 = cljs.core.seq(inst_15947);
var inst_15954__$1 = cljs.core.first(inst_15953);
var inst_15955 = cljs.core.next(inst_15953);
var inst_15956 = cljs.core.not(inst_15954__$1);
var state_15998__$1 = (function (){var statearr_16018 = state_15998;
(statearr_16018[(7)] = inst_15955);

(statearr_16018[(10)] = inst_15954__$1);

return statearr_16018;
})();
if(inst_15956){
var statearr_16019_16052 = state_15998__$1;
(statearr_16019_16052[(1)] = (11));

} else {
var statearr_16020_16053 = state_15998__$1;
(statearr_16020_16053[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (5))){
var _ = (function (){var statearr_16021 = state_15998;
(statearr_16021[(4)] = cljs.core.rest((state_15998[(4)])));

return statearr_16021;
})();
var state_15998__$1 = state_15998;
var ex16016 = (state_15998__$1[(2)]);
var statearr_16022_16054 = state_15998__$1;
(statearr_16022_16054[(5)] = ex16016);


if((ex16016 instanceof Error)){
var statearr_16023_16055 = state_15998__$1;
(statearr_16023_16055[(1)] = (4));

(statearr_16023_16055[(5)] = null);

} else {
throw ex16016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (14))){
var inst_15954 = (state_15998[(10)]);
var inst_15966 = inst_15954.o;
var inst_15967 = fluree.db.query.schema.convert_type_to_kw(inst_15966,db);
var state_15998__$1 = state_15998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15998__$1,(17),inst_15967);
} else {
if((state_val_15999 === (16))){
var inst_15963 = (state_15998[(12)]);
var inst_15974 = (state_15998[(2)]);
var state_15998__$1 = (function (){var statearr_16024 = state_15998;
(statearr_16024[(13)] = inst_15974);

return statearr_16024;
})();
if(cljs.core.truth_(inst_15963)){
var statearr_16025_16056 = state_15998__$1;
(statearr_16025_16056[(1)] = (18));

} else {
var statearr_16026_16057 = state_15998__$1;
(statearr_16026_16057[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (10))){
var inst_15993 = (state_15998[(2)]);
var _ = (function (){var statearr_16027 = state_15998;
(statearr_16027[(4)] = cljs.core.rest((state_15998[(4)])));

return statearr_16027;
})();
var state_15998__$1 = state_15998;
var statearr_16028_16058 = state_15998__$1;
(statearr_16028_16058[(2)] = inst_15993);

(statearr_16028_16058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (18))){
var inst_15954 = (state_15998[(10)]);
var inst_15974 = (state_15998[(13)]);
var inst_15948 = (state_15998[(9)]);
var inst_15961 = (state_15998[(11)]);
var inst_15976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15977 = inst_15954.s;
var inst_15978 = [inst_15977,inst_15961,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15979 = (new cljs.core.PersistentVector(null,3,(5),inst_15976,inst_15978,null));
var inst_15980 = cljs.core.assoc_in(inst_15948,inst_15979,inst_15974);
var state_15998__$1 = state_15998;
var statearr_16029_16059 = state_15998__$1;
(statearr_16029_16059[(2)] = inst_15980);

(statearr_16029_16059[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15999 === (8))){
var inst_15930 = (state_15998[(2)]);
var inst_15931 = cljs.core.PersistentHashSet.EMPTY;
var inst_15932 = cljs.core.vals(tempids);
var inst_15933 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15931,inst_15932);
var inst_15934 = (function (){var pred_flakes = inst_15930;
var is_new_QMARK_ = inst_15933;
return (function (p1__15919_SHARP_,p2__15918_SHARP_){
var f = p2__15918_SHARP_;
return cljs.core.assoc_in(p1__15919_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16030 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16030) : is_new_QMARK_.call(null,G__16030));
})()));
});
})();
var inst_15935 = cljs.core.PersistentHashMap.EMPTY;
var inst_15936 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15934,inst_15935,inst_15930);
var inst_15944 = cljs.core.seq(inst_15930);
var inst_15945 = cljs.core.first(inst_15944);
var inst_15946 = cljs.core.next(inst_15944);
var inst_15947 = inst_15930;
var inst_15948 = inst_15936;
var state_15998__$1 = (function (){var statearr_16031 = state_15998;
(statearr_16031[(8)] = inst_15947);

(statearr_16031[(14)] = inst_15945);

(statearr_16031[(15)] = inst_15946);

(statearr_16031[(9)] = inst_15948);

return statearr_16031;
})();
var statearr_16032_16060 = state_15998__$1;
(statearr_16032_16060[(2)] = null);

(statearr_16032_16060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____0 = (function (){
var statearr_16033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16033[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__);

(statearr_16033[(1)] = (1));

return statearr_16033;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____1 = (function (state_15998){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15998);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e16034){var ex__2720__auto__ = e16034;
var statearr_16035_16061 = state_15998;
(statearr_16035_16061[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15998[(4)]))){
var statearr_16036_16062 = state_15998;
(statearr_16036_16062[(1)] = cljs.core.first((state_15998[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16063 = state_15998;
state_15998 = G__16063;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__ = function(state_15998){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____1.call(this,state_15998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_16037 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_16037[(6)] = c__2739__auto__);

return statearr_16037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16065 = arguments.length;
switch (G__16065) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16068 = arguments.length;
switch (G__16068) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_16380){
var state_val_16381 = (state_16380[(1)]);
if((state_val_16381 === (121))){
var inst_16335 = (state_16380[(7)]);
var state_16380__$1 = state_16380;
var statearr_16382_16575 = state_16380__$1;
(statearr_16382_16575[(2)] = inst_16335);

(statearr_16382_16575[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (65))){
var inst_16234 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16234)){
var statearr_16383_16576 = state_16380__$1;
(statearr_16383_16576[(1)] = (66));

} else {
var statearr_16384_16577 = state_16380__$1;
(statearr_16384_16577[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (70))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16244 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16245 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16244,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,3,inst_16244,null));
var inst_16246 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16245,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16245,null));
var inst_16247 = (inst_16246.cljs$core$IFn$_invoke$arity$1 ? inst_16246.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16246.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16247)){
var statearr_16385_16578 = state_16380__$1;
(statearr_16385_16578[(1)] = (72));

} else {
var statearr_16386_16579 = state_16380__$1;
(statearr_16386_16579[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (62))){
var inst_16224 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16387_16580 = state_16380__$1;
(statearr_16387_16580[(2)] = inst_16224);

(statearr_16387_16580[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (74))){
var inst_16330 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16388_16581 = state_16380__$1;
(statearr_16388_16581[(2)] = inst_16330);

(statearr_16388_16581[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (110))){
var inst_16357 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16357)){
var statearr_16389_16582 = state_16380__$1;
(statearr_16389_16582[(1)] = (117));

} else {
var statearr_16390_16583 = state_16380__$1;
(statearr_16390_16583[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (7))){
var inst_16375 = (state_16380[(2)]);
var _ = (function (){var statearr_16391 = state_16380;
(statearr_16391[(4)] = cljs.core.rest((state_16380[(4)])));

return statearr_16391;
})();
var state_16380__$1 = state_16380;
var statearr_16392_16584 = state_16380__$1;
(statearr_16392_16584[(2)] = inst_16375);

(statearr_16392_16584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (59))){
var inst_16228 = (state_16380[(10)]);
var inst_16108 = (state_16380[(11)]);
var inst_16227 = (state_16380[(2)]);
var inst_16228__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16393 = state_16380;
(statearr_16393[(12)] = inst_16227);

(statearr_16393[(10)] = inst_16228__$1);

return statearr_16393;
})();
if(cljs.core.truth_(inst_16228__$1)){
var statearr_16394_16585 = state_16380__$1;
(statearr_16394_16585[(1)] = (63));

} else {
var statearr_16395_16586 = state_16380__$1;
(statearr_16395_16586[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (86))){
var inst_16270 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16396_16587 = state_16380__$1;
(statearr_16396_16587[(2)] = inst_16270);

(statearr_16396_16587[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (20))){
var inst_16134 = (state_16380[(13)]);
var inst_16108 = (state_16380[(11)]);
var inst_16134__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16397 = state_16380;
(statearr_16397[(13)] = inst_16134__$1);

return statearr_16397;
})();
if(cljs.core.truth_(inst_16134__$1)){
var statearr_16398_16588 = state_16380__$1;
(statearr_16398_16588[(1)] = (23));

} else {
var statearr_16399_16589 = state_16380__$1;
(statearr_16399_16589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (72))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16249 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16400_16590 = state_16380__$1;
(statearr_16400_16590[(2)] = inst_16249);

(statearr_16400_16590[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (58))){
var inst_16189 = (state_16380[(14)]);
var state_16380__$1 = state_16380;
var statearr_16401_16591 = state_16380__$1;
(statearr_16401_16591[(2)] = inst_16189);

(statearr_16401_16591[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (60))){
var inst_16096 = (state_16380[(15)]);
var inst_16107 = (state_16380[(16)]);
var inst_16215 = fluree.db.dbproto._p_prop(inst_16096,new cljs.core.Keyword(null,"name","name",1843675177),inst_16107);
var inst_16216 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16215)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16217 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16218 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16219 = cljs.core.PersistentHashMap.fromArrays(inst_16217,inst_16218);
var inst_16220 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16216,inst_16219);
var inst_16221 = (function(){throw inst_16220})();
var state_16380__$1 = state_16380;
var statearr_16402_16592 = state_16380__$1;
(statearr_16402_16592[(2)] = inst_16221);

(statearr_16402_16592[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (27))){
var inst_16137 = (state_16380[(17)]);
var state_16380__$1 = state_16380;
var statearr_16403_16593 = state_16380__$1;
(statearr_16403_16593[(2)] = inst_16137);

(statearr_16403_16593[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (1))){
var state_16380__$1 = state_16380;
var statearr_16404_16594 = state_16380__$1;
(statearr_16404_16594[(2)] = null);

(statearr_16404_16594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (69))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16405_16595 = state_16380__$1;
(statearr_16405_16595[(2)] = inst_16227);

(statearr_16405_16595[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (101))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16308 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16406_16596 = state_16380__$1;
(statearr_16406_16596[(2)] = inst_16308);

(statearr_16406_16596[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (24))){
var inst_16134 = (state_16380[(13)]);
var state_16380__$1 = state_16380;
var statearr_16407_16597 = state_16380__$1;
(statearr_16407_16597[(2)] = inst_16134);

(statearr_16407_16597[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (102))){
var inst_16310 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16408_16598 = state_16380__$1;
(statearr_16408_16598[(2)] = inst_16310);

(statearr_16408_16598[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (55))){
var inst_16206 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16409_16599 = state_16380__$1;
(statearr_16409_16599[(2)] = inst_16206);

(statearr_16409_16599[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (85))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16268 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16410_16600 = state_16380__$1;
(statearr_16410_16600[(2)] = inst_16268);

(statearr_16410_16600[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (39))){
var inst_16171 = (state_16380[(18)]);
var state_16380__$1 = state_16380;
var statearr_16411_16601 = state_16380__$1;
(statearr_16411_16601[(2)] = inst_16171);

(statearr_16411_16601[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (88))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16412_16602 = state_16380__$1;
(statearr_16412_16602[(2)] = inst_16227);

(statearr_16412_16602[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (46))){
var inst_16190 = (state_16380[(19)]);
var inst_16108 = (state_16380[(11)]);
var inst_16189 = (state_16380[(2)]);
var inst_16190__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16413 = state_16380;
(statearr_16413[(19)] = inst_16190__$1);

(statearr_16413[(14)] = inst_16189);

return statearr_16413;
})();
if(cljs.core.truth_(inst_16190__$1)){
var statearr_16414_16603 = state_16380__$1;
(statearr_16414_16603[(1)] = (47));

} else {
var statearr_16415_16604 = state_16380__$1;
(statearr_16415_16604[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (4))){
var inst_16069 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16416_16605 = state_16380__$1;
(statearr_16416_16605[(2)] = inst_16069);

(statearr_16416_16605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (77))){
var inst_16328 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16417_16606 = state_16380__$1;
(statearr_16417_16606[(2)] = inst_16328);

(statearr_16417_16606[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (106))){
var inst_16320 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16418_16607 = state_16380__$1;
(statearr_16418_16607[(2)] = inst_16320);

(statearr_16418_16607[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (119))){
var inst_16106 = (state_16380[(20)]);
var inst_16370 = (state_16380[(2)]);
var inst_16095 = inst_16106;
var inst_16096 = inst_16370;
var state_16380__$1 = (function (){var statearr_16419 = state_16380;
(statearr_16419[(21)] = inst_16095);

(statearr_16419[(15)] = inst_16096);

return statearr_16419;
})();
var statearr_16420_16608 = state_16380__$1;
(statearr_16420_16608[(2)] = null);

(statearr_16420_16608[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (95))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16292 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16293 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16292,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,5,inst_16292,null));
var inst_16294 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16293,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16293,null));
var inst_16295 = (inst_16294.cljs$core$IFn$_invoke$arity$1 ? inst_16294.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16294.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16295)){
var statearr_16421_16609 = state_16380__$1;
(statearr_16421_16609[(1)] = (96));

} else {
var statearr_16422_16610 = state_16380__$1;
(statearr_16422_16610[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (54))){
var inst_16197 = (state_16380[(22)]);
var state_16380__$1 = state_16380;
var statearr_16423_16611 = state_16380__$1;
(statearr_16423_16611[(2)] = inst_16197);

(statearr_16423_16611[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (92))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16424_16612 = state_16380__$1;
(statearr_16424_16612[(2)] = inst_16227);

(statearr_16424_16612[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (104))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16425_16613 = state_16380__$1;
(statearr_16425_16613[(2)] = inst_16227);

(statearr_16425_16613[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (15))){
var inst_16116 = (state_16380[(23)]);
var state_16380__$1 = state_16380;
var statearr_16426_16614 = state_16380__$1;
(statearr_16426_16614[(2)] = inst_16116);

(statearr_16426_16614[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (48))){
var inst_16190 = (state_16380[(19)]);
var state_16380__$1 = state_16380;
var statearr_16427_16615 = state_16380__$1;
(statearr_16427_16615[(2)] = inst_16190);

(statearr_16427_16615[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (50))){
var inst_16197 = (state_16380[(22)]);
var inst_16108 = (state_16380[(11)]);
var inst_16195 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16196 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16195);
var inst_16197__$1 = inst_16196 === true;
var state_16380__$1 = (function (){var statearr_16428 = state_16380;
(statearr_16428[(22)] = inst_16197__$1);

return statearr_16428;
})();
if(cljs.core.truth_(inst_16197__$1)){
var statearr_16429_16616 = state_16380__$1;
(statearr_16429_16616[(1)] = (53));

} else {
var statearr_16430_16617 = state_16380__$1;
(statearr_16430_16617[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (116))){
var inst_16351 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16431_16618 = state_16380__$1;
(statearr_16431_16618[(2)] = inst_16351);

(statearr_16431_16618[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (75))){
var inst_16240 = (state_16380[(8)]);
var state_16380__$1 = state_16380;
var G__16432_16619 = inst_16240;
var G__16432_16620__$1 = (((G__16432_16619 instanceof cljs.core.Keyword))?G__16432_16619.fqn:null);
switch (G__16432_16620__$1) {
case "long":
var statearr_16433_16622 = state_16380__$1;
(statearr_16433_16622[(1)] = (79));


break;
case "bigint":
var statearr_16434_16623 = state_16380__$1;
(statearr_16434_16623[(1)] = (83));


break;
case "double":
var statearr_16435_16624 = state_16380__$1;
(statearr_16435_16624[(1)] = (87));


break;
case "float":
var statearr_16436_16625 = state_16380__$1;
(statearr_16436_16625[(1)] = (91));


break;
case "bigdec":
var statearr_16437_16626 = state_16380__$1;
(statearr_16437_16626[(1)] = (95));


break;
case "string":
var statearr_16438_16627 = state_16380__$1;
(statearr_16438_16627[(1)] = (99));


break;
case "instant":
var statearr_16439_16628 = state_16380__$1;
(statearr_16439_16628[(1)] = (103));


break;
default:
var statearr_16440_16629 = state_16380__$1;
(statearr_16440_16629[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (99))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16302 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16303 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16302,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,5,inst_16302,null));
var inst_16304 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16303,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16303,null));
var inst_16305 = (inst_16304.cljs$core$IFn$_invoke$arity$1 ? inst_16304.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16304.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16305)){
var statearr_16441_16630 = state_16380__$1;
(statearr_16441_16630[(1)] = (100));

} else {
var statearr_16442_16631 = state_16380__$1;
(statearr_16442_16631[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (21))){
var inst_16132 = (state_16380[(24)]);
var state_16380__$1 = state_16380;
var statearr_16443_16632 = state_16380__$1;
(statearr_16443_16632[(2)] = inst_16132);

(statearr_16443_16632[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (31))){
var inst_16148 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16444_16633 = state_16380__$1;
(statearr_16444_16633[(2)] = inst_16148);

(statearr_16444_16633[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (113))){
var inst_16354 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16445_16634 = state_16380__$1;
(statearr_16445_16634[(2)] = inst_16354);

(statearr_16445_16634[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (32))){
var state_16380__$1 = state_16380;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16446_16635 = state_16380__$1;
(statearr_16446_16635[(1)] = (35));

} else {
var statearr_16447_16636 = state_16380__$1;
(statearr_16447_16636[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (40))){
var inst_16184 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16184)){
var statearr_16448_16637 = state_16380__$1;
(statearr_16448_16637[(1)] = (44));

} else {
var statearr_16449_16638 = state_16380__$1;
(statearr_16449_16638[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (91))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16282 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16283 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16282,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,3,inst_16282,null));
var inst_16284 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16283,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16283,null));
var inst_16285 = (inst_16284.cljs$core$IFn$_invoke$arity$1 ? inst_16284.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16284.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16285)){
var statearr_16450_16639 = state_16380__$1;
(statearr_16450_16639[(1)] = (92));

} else {
var statearr_16451_16640 = state_16380__$1;
(statearr_16451_16640[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (117))){
var state_16380__$1 = state_16380;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16452_16641 = state_16380__$1;
(statearr_16452_16641[(1)] = (120));

} else {
var statearr_16453_16642 = state_16380__$1;
(statearr_16453_16642[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (108))){
var inst_16339 = (state_16380[(25)]);
var inst_16108 = (state_16380[(11)]);
var inst_16339__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16454 = state_16380;
(statearr_16454[(25)] = inst_16339__$1);

return statearr_16454;
})();
if(cljs.core.truth_(inst_16339__$1)){
var statearr_16455_16643 = state_16380__$1;
(statearr_16455_16643[(1)] = (111));

} else {
var statearr_16456_16644 = state_16380__$1;
(statearr_16456_16644[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (56))){
var inst_16201 = (state_16380[(2)]);
var inst_16202 = fluree.db.util.async.throw_err(inst_16201);
var inst_16203 = cljs.core.not(inst_16202);
var state_16380__$1 = state_16380;
var statearr_16457_16645 = state_16380__$1;
(statearr_16457_16645[(2)] = inst_16203);

(statearr_16457_16645[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (33))){
var inst_16131 = (state_16380[(26)]);
var state_16380__$1 = state_16380;
var statearr_16458_16646 = state_16380__$1;
(statearr_16458_16646[(2)] = inst_16131);

(statearr_16458_16646[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (13))){
var inst_16126 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16126)){
var statearr_16459_16647 = state_16380__$1;
(statearr_16459_16647[(1)] = (17));

} else {
var statearr_16460_16648 = state_16380__$1;
(statearr_16460_16648[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (22))){
var inst_16157 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16157)){
var statearr_16461_16649 = state_16380__$1;
(statearr_16461_16649[(1)] = (32));

} else {
var statearr_16462_16650 = state_16380__$1;
(statearr_16462_16650[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (90))){
var inst_16280 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16463_16651 = state_16380__$1;
(statearr_16463_16651[(2)] = inst_16280);

(statearr_16463_16651[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (109))){
var inst_16337 = (state_16380[(27)]);
var state_16380__$1 = state_16380;
var statearr_16464_16652 = state_16380__$1;
(statearr_16464_16652[(2)] = inst_16337);

(statearr_16464_16652[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (36))){
var inst_16131 = (state_16380[(26)]);
var state_16380__$1 = state_16380;
var statearr_16465_16653 = state_16380__$1;
(statearr_16465_16653[(2)] = inst_16131);

(statearr_16465_16653[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (41))){
var inst_16108 = (state_16380[(11)]);
var inst_16176 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16177 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16176);
var inst_16178 = inst_16177 === true;
var state_16380__$1 = state_16380;
var statearr_16466_16654 = state_16380__$1;
(statearr_16466_16654[(2)] = inst_16178);

(statearr_16466_16654[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (118))){
var inst_16335 = (state_16380[(7)]);
var state_16380__$1 = state_16380;
var statearr_16467_16655 = state_16380__$1;
(statearr_16467_16655[(2)] = inst_16335);

(statearr_16467_16655[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (89))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16278 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16468_16656 = state_16380__$1;
(statearr_16468_16656[(2)] = inst_16278);

(statearr_16468_16656[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (100))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16469_16657 = state_16380__$1;
(statearr_16469_16657[(2)] = inst_16227);

(statearr_16469_16657[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (122))){
var inst_16367 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16470_16658 = state_16380__$1;
(statearr_16470_16658[(2)] = inst_16367);

(statearr_16470_16658[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (43))){
var inst_16181 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16471_16659 = state_16380__$1;
(statearr_16471_16659[(2)] = inst_16181);

(statearr_16471_16659[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (61))){
var inst_16189 = (state_16380[(14)]);
var state_16380__$1 = state_16380;
var statearr_16472_16660 = state_16380__$1;
(statearr_16472_16660[(2)] = inst_16189);

(statearr_16472_16660[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (29))){
var inst_16108 = (state_16380[(11)]);
var inst_16143 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16144 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16143);
var inst_16145 = inst_16144 === true;
var state_16380__$1 = state_16380;
var statearr_16473_16661 = state_16380__$1;
(statearr_16473_16661[(2)] = inst_16145);

(statearr_16473_16661[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (44))){
var inst_16170 = (state_16380[(28)]);
var inst_16186 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16170,"a component","a non-component",throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16474_16662 = state_16380__$1;
(statearr_16474_16662[(2)] = inst_16186);

(statearr_16474_16662[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (93))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16288 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16475_16663 = state_16380__$1;
(statearr_16475_16663[(2)] = inst_16288);

(statearr_16475_16663[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (6))){
var inst_16095 = (state_16380[(21)]);
var inst_16107 = (state_16380[(16)]);
var inst_16104 = cljs.core.seq(inst_16095);
var inst_16105 = cljs.core.first(inst_16104);
var inst_16106 = cljs.core.next(inst_16104);
var inst_16107__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16105,(0),null);
var inst_16108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16105,(1),null);
var inst_16109 = cljs.core.not(inst_16107__$1);
var state_16380__$1 = (function (){var statearr_16476 = state_16380;
(statearr_16476[(20)] = inst_16106);

(statearr_16476[(16)] = inst_16107__$1);

(statearr_16476[(11)] = inst_16108);

return statearr_16476;
})();
if(inst_16109){
var statearr_16477_16664 = state_16380__$1;
(statearr_16477_16664[(1)] = (8));

} else {
var statearr_16478_16665 = state_16380__$1;
(statearr_16478_16665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (111))){
var inst_16343 = (state_16380[(29)]);
var inst_16108 = (state_16380[(11)]);
var inst_16341 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16342 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16341);
var inst_16343__$1 = inst_16342 === true;
var state_16380__$1 = (function (){var statearr_16479 = state_16380;
(statearr_16479[(29)] = inst_16343__$1);

return statearr_16479;
})();
if(cljs.core.truth_(inst_16343__$1)){
var statearr_16480_16666 = state_16380__$1;
(statearr_16480_16666[(1)] = (114));

} else {
var statearr_16481_16667 = state_16380__$1;
(statearr_16481_16667[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (28))){
var inst_16151 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16482_16668 = state_16380__$1;
(statearr_16482_16668[(2)] = inst_16151);

(statearr_16482_16668[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (64))){
var inst_16228 = (state_16380[(10)]);
var state_16380__$1 = state_16380;
var statearr_16483_16669 = state_16380__$1;
(statearr_16483_16669[(2)] = inst_16228);

(statearr_16483_16669[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (103))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16312 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16313 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16312,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,2,inst_16312,null));
var inst_16314 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16313,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16313,null));
var inst_16315 = (inst_16314.cljs$core$IFn$_invoke$arity$1 ? inst_16314.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16314.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16315)){
var statearr_16484_16670 = state_16380__$1;
(statearr_16484_16670[(1)] = (104));

} else {
var statearr_16485_16671 = state_16380__$1;
(statearr_16485_16671[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (51))){
var inst_16193 = (state_16380[(30)]);
var state_16380__$1 = state_16380;
var statearr_16486_16672 = state_16380__$1;
(statearr_16486_16672[(2)] = inst_16193);

(statearr_16486_16672[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (25))){
var inst_16154 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16487_16673 = state_16380__$1;
(statearr_16487_16673[(2)] = inst_16154);

(statearr_16487_16673[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (34))){
var inst_16171 = (state_16380[(18)]);
var inst_16108 = (state_16380[(11)]);
var inst_16170 = (state_16380[(2)]);
var inst_16171__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16488 = state_16380;
(statearr_16488[(28)] = inst_16170);

(statearr_16488[(18)] = inst_16171__$1);

return statearr_16488;
})();
if(cljs.core.truth_(inst_16171__$1)){
var statearr_16489_16674 = state_16380__$1;
(statearr_16489_16674[(1)] = (38));

} else {
var statearr_16490_16675 = state_16380__$1;
(statearr_16490_16675[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (17))){
var inst_16096 = (state_16380[(15)]);
var inst_16128 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16096,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16491_16676 = state_16380__$1;
(statearr_16491_16676[(2)] = inst_16128);

(statearr_16491_16676[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (3))){
var inst_16378 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16380__$1,inst_16378);
} else {
if((state_val_16381 === (12))){
var inst_16112 = (state_16380[(31)]);
var state_16380__$1 = state_16380;
var statearr_16492_16677 = state_16380__$1;
(statearr_16492_16677[(2)] = inst_16112);

(statearr_16492_16677[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (2))){
var _ = (function (){var statearr_16493 = state_16380;
(statearr_16493[(4)] = cljs.core.cons((5),(state_16380[(4)])));

return statearr_16493;
})();
var inst_16088 = pred_changes;
var inst_16089 = cljs.core.seq(inst_16088);
var inst_16090 = cljs.core.first(inst_16089);
var inst_16091 = cljs.core.next(inst_16089);
var inst_16092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(0),null);
var inst_16093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16090,(1),null);
var inst_16094 = db;
var inst_16095 = inst_16088;
var inst_16096 = inst_16094;
var state_16380__$1 = (function (){var statearr_16494 = state_16380;
(statearr_16494[(32)] = inst_16092);

(statearr_16494[(33)] = inst_16093);

(statearr_16494[(21)] = inst_16095);

(statearr_16494[(34)] = inst_16091);

(statearr_16494[(15)] = inst_16096);

return statearr_16494;
})();
var statearr_16495_16678 = state_16380__$1;
(statearr_16495_16678[(2)] = null);

(statearr_16495_16678[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (66))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16108 = (state_16380[(11)]);
var inst_16237 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16238 = cljs.core.__destructure_map(inst_16237);
var inst_16239__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16238,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16240__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16238,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16241 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16240__$1,inst_16239__$1);
var state_16380__$1 = (function (){var statearr_16496 = state_16380;
(statearr_16496[(8)] = inst_16240__$1);

(statearr_16496[(9)] = inst_16239__$1);

return statearr_16496;
})();
if(inst_16241){
var statearr_16497_16679 = state_16380__$1;
(statearr_16497_16679[(1)] = (69));

} else {
var statearr_16498_16680 = state_16380__$1;
(statearr_16498_16680[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (107))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16322 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16499_16681 = state_16380__$1;
(statearr_16499_16681[(2)] = inst_16322);

(statearr_16499_16681[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (23))){
var inst_16137 = (state_16380[(17)]);
var inst_16108 = (state_16380[(11)]);
var inst_16136 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16137__$1 = inst_16136 === true;
var state_16380__$1 = (function (){var statearr_16500 = state_16380;
(statearr_16500[(17)] = inst_16137__$1);

return statearr_16500;
})();
if(cljs.core.truth_(inst_16137__$1)){
var statearr_16501_16682 = state_16380__$1;
(statearr_16501_16682[(1)] = (26));

} else {
var statearr_16502_16683 = state_16380__$1;
(statearr_16502_16683[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (47))){
var inst_16193 = (state_16380[(30)]);
var inst_16108 = (state_16380[(11)]);
var inst_16192 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16193__$1 = cljs.core.not(inst_16192);
var state_16380__$1 = (function (){var statearr_16503 = state_16380;
(statearr_16503[(30)] = inst_16193__$1);

return statearr_16503;
})();
if(inst_16193__$1){
var statearr_16504_16684 = state_16380__$1;
(statearr_16504_16684[(1)] = (50));

} else {
var statearr_16505_16685 = state_16380__$1;
(statearr_16505_16685[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (35))){
var inst_16160 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16161 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16162 = cljs.core.PersistentHashMap.fromArrays(inst_16160,inst_16161);
var inst_16163 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16162);
var inst_16164 = (function(){throw inst_16163})();
var state_16380__$1 = state_16380;
var statearr_16506_16686 = state_16380__$1;
(statearr_16506_16686[(2)] = inst_16164);

(statearr_16506_16686[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (82))){
var inst_16260 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16507_16687 = state_16380__$1;
(statearr_16507_16687[(2)] = inst_16260);

(statearr_16507_16687[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (76))){
var state_16380__$1 = state_16380;
var statearr_16508_16688 = state_16380__$1;
(statearr_16508_16688[(2)] = null);

(statearr_16508_16688[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (97))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16298 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16509_16689 = state_16380__$1;
(statearr_16509_16689[(2)] = inst_16298);

(statearr_16509_16689[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (19))){
var inst_16132 = (state_16380[(24)]);
var inst_16108 = (state_16380[(11)]);
var inst_16131 = (state_16380[(2)]);
var inst_16132__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16510 = state_16380;
(statearr_16510[(26)] = inst_16131);

(statearr_16510[(24)] = inst_16132__$1);

return statearr_16510;
})();
if(cljs.core.truth_(inst_16132__$1)){
var statearr_16511_16690 = state_16380__$1;
(statearr_16511_16690[(1)] = (20));

} else {
var statearr_16512_16691 = state_16380__$1;
(statearr_16512_16691[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (57))){
var state_16380__$1 = state_16380;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16513_16692 = state_16380__$1;
(statearr_16513_16692[(1)] = (60));

} else {
var statearr_16514_16693 = state_16380__$1;
(statearr_16514_16693[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (68))){
var inst_16337 = (state_16380[(27)]);
var inst_16108 = (state_16380[(11)]);
var inst_16335 = (state_16380[(2)]);
var inst_16336 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16337__$1 = inst_16336 === true;
var state_16380__$1 = (function (){var statearr_16515 = state_16380;
(statearr_16515[(27)] = inst_16337__$1);

(statearr_16515[(7)] = inst_16335);

return statearr_16515;
})();
if(cljs.core.truth_(inst_16337__$1)){
var statearr_16516_16694 = state_16380__$1;
(statearr_16516_16694[(1)] = (108));

} else {
var statearr_16517_16695 = state_16380__$1;
(statearr_16517_16695[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (11))){
var inst_16116 = (state_16380[(23)]);
var inst_16108 = (state_16380[(11)]);
var inst_16114 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16115 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16114);
var inst_16116__$1 = inst_16115 === false;
var state_16380__$1 = (function (){var statearr_16518 = state_16380;
(statearr_16518[(23)] = inst_16116__$1);

return statearr_16518;
})();
if(cljs.core.truth_(inst_16116__$1)){
var statearr_16519_16696 = state_16380__$1;
(statearr_16519_16696[(1)] = (14));

} else {
var statearr_16520_16697 = state_16380__$1;
(statearr_16520_16697[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (115))){
var inst_16343 = (state_16380[(29)]);
var state_16380__$1 = state_16380;
var statearr_16522_16698 = state_16380__$1;
(statearr_16522_16698[(2)] = inst_16343);

(statearr_16522_16698[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (9))){
var inst_16112 = (state_16380[(31)]);
var inst_16108 = (state_16380[(11)]);
var inst_16112__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16108);
var state_16380__$1 = (function (){var statearr_16523 = state_16380;
(statearr_16523[(31)] = inst_16112__$1);

return statearr_16523;
})();
if(cljs.core.truth_(inst_16112__$1)){
var statearr_16524_16699 = state_16380__$1;
(statearr_16524_16699[(1)] = (11));

} else {
var statearr_16525_16700 = state_16380__$1;
(statearr_16525_16700[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (5))){
var _ = (function (){var statearr_16526 = state_16380;
(statearr_16526[(4)] = cljs.core.rest((state_16380[(4)])));

return statearr_16526;
})();
var state_16380__$1 = state_16380;
var ex16521 = (state_16380__$1[(2)]);
var statearr_16527_16701 = state_16380__$1;
(statearr_16527_16701[(5)] = ex16521);


if((ex16521 instanceof Error)){
var statearr_16528_16702 = state_16380__$1;
(statearr_16528_16702[(1)] = (4));

(statearr_16528_16702[(5)] = null);

} else {
throw ex16521;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (112))){
var inst_16339 = (state_16380[(25)]);
var state_16380__$1 = state_16380;
var statearr_16529_16703 = state_16380__$1;
(statearr_16529_16703[(2)] = inst_16339);

(statearr_16529_16703[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (83))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16262 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16263 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16262,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,3,inst_16262,null));
var inst_16264 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16263,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16263,null));
var inst_16265 = (inst_16264.cljs$core$IFn$_invoke$arity$1 ? inst_16264.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16264.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16265)){
var statearr_16530_16704 = state_16380__$1;
(statearr_16530_16704[(1)] = (84));

} else {
var statearr_16531_16705 = state_16380__$1;
(statearr_16531_16705[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (14))){
var inst_16108 = (state_16380[(11)]);
var inst_16118 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16119 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16118);
var inst_16120 = inst_16119 === true;
var state_16380__$1 = state_16380;
var statearr_16532_16706 = state_16380__$1;
(statearr_16532_16706[(2)] = inst_16120);

(statearr_16532_16706[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (45))){
var inst_16170 = (state_16380[(28)]);
var state_16380__$1 = state_16380;
var statearr_16533_16707 = state_16380__$1;
(statearr_16533_16707[(2)] = inst_16170);

(statearr_16533_16707[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (53))){
var inst_16096 = (state_16380[(15)]);
var inst_16107 = (state_16380[(16)]);
var inst_16199 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16096,inst_16107);
var state_16380__$1 = state_16380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16380__$1,(56),inst_16199);
} else {
if((state_val_16381 === (78))){
var inst_16325 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16534_16708 = state_16380__$1;
(statearr_16534_16708[(2)] = inst_16325);

(statearr_16534_16708[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (26))){
var inst_16141 = (state_16380[(35)]);
var inst_16108 = (state_16380[(11)]);
var inst_16139 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16140 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16139);
var inst_16141__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16140);
var state_16380__$1 = (function (){var statearr_16535 = state_16380;
(statearr_16535[(35)] = inst_16141__$1);

return statearr_16535;
})();
if(inst_16141__$1){
var statearr_16536_16709 = state_16380__$1;
(statearr_16536_16709[(1)] = (29));

} else {
var statearr_16537_16710 = state_16380__$1;
(statearr_16537_16710[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (16))){
var inst_16123 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16538_16711 = state_16380__$1;
(statearr_16538_16711[(2)] = inst_16123);

(statearr_16538_16711[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (81))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16258 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16539_16712 = state_16380__$1;
(statearr_16539_16712[(2)] = inst_16258);

(statearr_16539_16712[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (120))){
var inst_16360 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16361 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16362 = cljs.core.PersistentHashMap.fromArrays(inst_16360,inst_16361);
var inst_16363 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16362);
var inst_16364 = (function(){throw inst_16363})();
var state_16380__$1 = state_16380;
var statearr_16540_16713 = state_16380__$1;
(statearr_16540_16713[(2)] = inst_16364);

(statearr_16540_16713[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (79))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16252 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16253 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16252,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,2,inst_16252,null));
var inst_16254 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16253,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16253,null));
var inst_16255 = (inst_16254.cljs$core$IFn$_invoke$arity$1 ? inst_16254.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16254.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16255)){
var statearr_16541_16714 = state_16380__$1;
(statearr_16541_16714[(1)] = (80));

} else {
var statearr_16542_16715 = state_16380__$1;
(statearr_16542_16715[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (38))){
var inst_16174 = (state_16380[(36)]);
var inst_16108 = (state_16380[(11)]);
var inst_16173 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16174__$1 = cljs.core.not(inst_16173);
var state_16380__$1 = (function (){var statearr_16543 = state_16380;
(statearr_16543[(36)] = inst_16174__$1);

return statearr_16543;
})();
if(inst_16174__$1){
var statearr_16544_16716 = state_16380__$1;
(statearr_16544_16716[(1)] = (41));

} else {
var statearr_16545_16717 = state_16380__$1;
(statearr_16545_16717[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (98))){
var inst_16300 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16546_16718 = state_16380__$1;
(statearr_16546_16718[(2)] = inst_16300);

(statearr_16546_16718[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (87))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16272 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16273 = (inst_16240.cljs$core$IFn$_invoke$arity$5 ? inst_16240.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16272,null) : inst_16240.call(null,cljs.core.PersistentArrayMap,null,3,inst_16272,null));
var inst_16274 = (inst_16240.cljs$core$IFn$_invoke$arity$4 ? inst_16240.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16273,null) : inst_16240.call(null,cljs.core.PersistentHashSet,null,inst_16273,null));
var inst_16275 = (inst_16274.cljs$core$IFn$_invoke$arity$1 ? inst_16274.cljs$core$IFn$_invoke$arity$1(inst_16239) : inst_16274.call(null,inst_16239));
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16275)){
var statearr_16547_16719 = state_16380__$1;
(statearr_16547_16719[(1)] = (88));

} else {
var statearr_16548_16720 = state_16380__$1;
(statearr_16548_16720[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (30))){
var inst_16141 = (state_16380[(35)]);
var state_16380__$1 = state_16380;
var statearr_16549_16721 = state_16380__$1;
(statearr_16549_16721[(2)] = inst_16141);

(statearr_16549_16721[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (73))){
var state_16380__$1 = state_16380;
var statearr_16550_16722 = state_16380__$1;
(statearr_16550_16722[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (96))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16552_16723 = state_16380__$1;
(statearr_16552_16723[(2)] = inst_16227);

(statearr_16552_16723[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (10))){
var inst_16373 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16553_16724 = state_16380__$1;
(statearr_16553_16724[(2)] = inst_16373);

(statearr_16553_16724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (18))){
var inst_16096 = (state_16380[(15)]);
var state_16380__$1 = state_16380;
var statearr_16554_16725 = state_16380__$1;
(statearr_16554_16725[(2)] = inst_16096);

(statearr_16554_16725[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (105))){
var inst_16240 = (state_16380[(8)]);
var inst_16239 = (state_16380[(9)]);
var inst_16318 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16239,inst_16240,throw_QMARK_);
var state_16380__$1 = state_16380;
var statearr_16555_16726 = state_16380__$1;
(statearr_16555_16726[(2)] = inst_16318);

(statearr_16555_16726[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (52))){
var inst_16209 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16556_16727 = state_16380__$1;
(statearr_16556_16727[(2)] = inst_16209);

(statearr_16556_16727[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (114))){
var inst_16108 = (state_16380[(11)]);
var inst_16345 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16346 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16345);
var inst_16347 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16346);
var inst_16348 = (!(inst_16347));
var state_16380__$1 = state_16380;
var statearr_16557_16728 = state_16380__$1;
(statearr_16557_16728[(2)] = inst_16348);

(statearr_16557_16728[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (67))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16558_16729 = state_16380__$1;
(statearr_16558_16729[(2)] = inst_16227);

(statearr_16558_16729[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (71))){
var inst_16332 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16559_16730 = state_16380__$1;
(statearr_16559_16730[(2)] = inst_16332);

(statearr_16559_16730[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (42))){
var inst_16174 = (state_16380[(36)]);
var state_16380__$1 = state_16380;
var statearr_16560_16731 = state_16380__$1;
(statearr_16560_16731[(2)] = inst_16174);

(statearr_16560_16731[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (80))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16561_16732 = state_16380__$1;
(statearr_16561_16732[(2)] = inst_16227);

(statearr_16561_16732[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (37))){
var inst_16167 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16562_16733 = state_16380__$1;
(statearr_16562_16733[(2)] = inst_16167);

(statearr_16562_16733[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (63))){
var inst_16108 = (state_16380[(11)]);
var inst_16230 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16108);
var inst_16231 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16230);
var state_16380__$1 = state_16380;
var statearr_16563_16734 = state_16380__$1;
(statearr_16563_16734[(2)] = inst_16231);

(statearr_16563_16734[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (94))){
var inst_16290 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
var statearr_16564_16735 = state_16380__$1;
(statearr_16564_16735[(2)] = inst_16290);

(statearr_16564_16735[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (8))){
var inst_16096 = (state_16380[(15)]);
var state_16380__$1 = state_16380;
var statearr_16565_16736 = state_16380__$1;
(statearr_16565_16736[(2)] = inst_16096);

(statearr_16565_16736[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (49))){
var inst_16212 = (state_16380[(2)]);
var state_16380__$1 = state_16380;
if(cljs.core.truth_(inst_16212)){
var statearr_16566_16737 = state_16380__$1;
(statearr_16566_16737[(1)] = (57));

} else {
var statearr_16567_16738 = state_16380__$1;
(statearr_16567_16738[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16381 === (84))){
var inst_16227 = (state_16380[(12)]);
var state_16380__$1 = state_16380;
var statearr_16568_16739 = state_16380__$1;
(statearr_16568_16739[(2)] = inst_16227);

(statearr_16568_16739[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2717__auto__ = null;
var fluree$db$query$schema$state_machine__2717__auto____0 = (function (){
var statearr_16569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16569[(0)] = fluree$db$query$schema$state_machine__2717__auto__);

(statearr_16569[(1)] = (1));

return statearr_16569;
});
var fluree$db$query$schema$state_machine__2717__auto____1 = (function (state_16380){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_16380);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e16570){var ex__2720__auto__ = e16570;
var statearr_16571_16740 = state_16380;
(statearr_16571_16740[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_16380[(4)]))){
var statearr_16572_16741 = state_16380;
(statearr_16572_16741[(1)] = cljs.core.first((state_16380[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16742 = state_16380;
state_16380 = G__16742;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2717__auto__ = function(state_16380){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2717__auto____1.call(this,state_16380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2717__auto____0;
fluree$db$query$schema$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2717__auto____1;
return fluree$db$query$schema$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_16573 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_16573[(6)] = c__2739__auto__);

return statearr_16573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16744 = arguments.length;
switch (G__16744) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_16768){
var state_val_16769 = (state_16768[(1)]);
if((state_val_16769 === (7))){
var state_16768__$1 = state_16768;
var statearr_16770_16790 = state_16768__$1;
(statearr_16770_16790[(2)] = db);

(statearr_16770_16790[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (1))){
var state_16768__$1 = state_16768;
var statearr_16771_16791 = state_16768__$1;
(statearr_16771_16791[(2)] = null);

(statearr_16771_16791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (4))){
var inst_16745 = (state_16768[(2)]);
var state_16768__$1 = state_16768;
var statearr_16772_16792 = state_16768__$1;
(statearr_16772_16792[(2)] = inst_16745);

(statearr_16772_16792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (6))){
var inst_16754 = (state_16768[(7)]);
var inst_16753 = (state_16768[(2)]);
var inst_16754__$1 = fluree.db.util.async.throw_err(inst_16753);
var inst_16755 = cljs.core.empty_QMARK_(inst_16754__$1);
var state_16768__$1 = (function (){var statearr_16773 = state_16768;
(statearr_16773[(7)] = inst_16754__$1);

return statearr_16773;
})();
if(inst_16755){
var statearr_16774_16793 = state_16768__$1;
(statearr_16774_16793[(1)] = (7));

} else {
var statearr_16775_16794 = state_16768__$1;
(statearr_16775_16794[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (3))){
var inst_16766 = (state_16768[(2)]);
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16768__$1,inst_16766);
} else {
if((state_val_16769 === (2))){
var _ = (function (){var statearr_16777 = state_16768;
(statearr_16777[(4)] = cljs.core.cons((5),(state_16768[(4)])));

return statearr_16777;
})();
var inst_16751 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16768__$1,(6),inst_16751);
} else {
if((state_val_16769 === (9))){
var inst_16763 = (state_16768[(2)]);
var _ = (function (){var statearr_16778 = state_16768;
(statearr_16778[(4)] = cljs.core.rest((state_16768[(4)])));

return statearr_16778;
})();
var state_16768__$1 = state_16768;
var statearr_16779_16795 = state_16768__$1;
(statearr_16779_16795[(2)] = inst_16763);

(statearr_16779_16795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (5))){
var _ = (function (){var statearr_16780 = state_16768;
(statearr_16780[(4)] = cljs.core.rest((state_16768[(4)])));

return statearr_16780;
})();
var state_16768__$1 = state_16768;
var ex16776 = (state_16768__$1[(2)]);
var statearr_16781_16796 = state_16768__$1;
(statearr_16781_16796[(5)] = ex16776);


if((ex16776 instanceof Error)){
var statearr_16782_16797 = state_16768__$1;
(statearr_16782_16797[(1)] = (4));

(statearr_16782_16797[(5)] = null);

} else {
throw ex16776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (10))){
var inst_16760 = (state_16768[(2)]);
var inst_16761 = fluree.db.util.async.throw_err(inst_16760);
var state_16768__$1 = state_16768;
var statearr_16783_16798 = state_16768__$1;
(statearr_16783_16798[(2)] = inst_16761);

(statearr_16783_16798[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16769 === (8))){
var inst_16754 = (state_16768[(7)]);
var inst_16758 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16754,db,true);
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16768__$1,(10),inst_16758);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2717__auto__ = null;
var fluree$db$query$schema$state_machine__2717__auto____0 = (function (){
var statearr_16784 = [null,null,null,null,null,null,null,null];
(statearr_16784[(0)] = fluree$db$query$schema$state_machine__2717__auto__);

(statearr_16784[(1)] = (1));

return statearr_16784;
});
var fluree$db$query$schema$state_machine__2717__auto____1 = (function (state_16768){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_16768);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e16785){var ex__2720__auto__ = e16785;
var statearr_16786_16799 = state_16768;
(statearr_16786_16799[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_16768[(4)]))){
var statearr_16787_16800 = state_16768;
(statearr_16787_16800[(1)] = cljs.core.first((state_16768[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16801 = state_16768;
state_16768 = G__16801;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2717__auto__ = function(state_16768){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2717__auto____1.call(this,state_16768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2717__auto____0;
fluree$db$query$schema$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2717__auto____1;
return fluree$db$query$schema$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_16788 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_16788[(6)] = c__2739__auto__);

return statearr_16788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16803 = arguments.length;
switch (G__16803) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16805 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16805,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16805,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16805,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16808_SHARP_,p2__16809_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16808_SHARP_,p2__16809_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16810_SHARP_){
var f = p1__16810_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_16876){
var state_val_16877 = (state_16876[(1)]);
if((state_val_16877 === (1))){
var state_16876__$1 = state_16876;
var statearr_16878_16896 = state_16876__$1;
(statearr_16878_16896[(2)] = null);

(statearr_16878_16896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16877 === (2))){
var _ = (function (){var statearr_16879 = state_16876;
(statearr_16879[(4)] = cljs.core.cons((5),(state_16876[(4)])));

return statearr_16879;
})();
var inst_16828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16829 = fluree.db.flake.max_subject_id((1));
var inst_16830 = [inst_16829];
var inst_16831 = (new cljs.core.PersistentVector(null,1,(5),inst_16828,inst_16830,null));
var inst_16832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16833 = [(0)];
var inst_16834 = (new cljs.core.PersistentVector(null,1,(5),inst_16832,inst_16833,null));
var inst_16835 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16831,cljs.core._LT__EQ_,inst_16834);
var state_16876__$1 = state_16876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16876__$1,(6),inst_16835);
} else {
if((state_val_16877 === (3))){
var inst_16874 = (state_16876[(2)]);
var state_16876__$1 = state_16876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16876__$1,inst_16874);
} else {
if((state_val_16877 === (4))){
var inst_16816 = (state_16876[(2)]);
var state_16876__$1 = state_16876;
var statearr_16881_16897 = state_16876__$1;
(statearr_16881_16897[(2)] = inst_16816);

(statearr_16881_16897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16877 === (5))){
var _ = (function (){var statearr_16882 = state_16876;
(statearr_16882[(4)] = cljs.core.rest((state_16876[(4)])));

return statearr_16882;
})();
var state_16876__$1 = state_16876;
var ex16880 = (state_16876__$1[(2)]);
var statearr_16883_16898 = state_16876__$1;
(statearr_16883_16898[(5)] = ex16880);


if((ex16880 instanceof Error)){
var statearr_16884_16899 = state_16876__$1;
(statearr_16884_16899[(1)] = (4));

(statearr_16884_16899[(5)] = null);

} else {
throw ex16880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16877 === (6))){
var inst_16837 = (state_16876[(2)]);
var inst_16838 = fluree.db.util.async.throw_err(inst_16837);
var inst_16839 = (function (){var schema_flakes = inst_16838;
return (function (p1__16811_SHARP_){
return (p1__16811_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16840 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16839,inst_16838);
var inst_16841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16840,(0),null);
var inst_16842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16840,(1),null);
var inst_16843 = (function (){var schema_flakes = inst_16838;
var vec__16822 = inst_16840;
var collection_flakes = inst_16841;
var predicate_flakes = inst_16842;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16814_SHARP_,p2__16813_SHARP_){
var f = p2__16813_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16814_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16844 = [(-1),"_tx"];
var inst_16845 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16846 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16847 = cljs.core.PersistentHashMap.fromArrays(inst_16845,inst_16846);
var inst_16848 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16849 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16850 = cljs.core.PersistentHashMap.fromArrays(inst_16848,inst_16849);
var inst_16851 = [inst_16847,inst_16850];
var inst_16852 = cljs.core.PersistentHashMap.fromArrays(inst_16844,inst_16851);
var inst_16853 = (function (){var schema_flakes = inst_16838;
var vec__16822 = inst_16840;
var collection_flakes = inst_16841;
var predicate_flakes = inst_16842;
return (function (p1__16812_SHARP_){
return p1__16812_SHARP_.s;
});
})();
var inst_16854 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16853,inst_16841);
var inst_16855 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16843,inst_16852,inst_16854);
var inst_16857 = (function (){var schema_flakes = inst_16838;
var vec__16822 = inst_16840;
var collection_flakes = inst_16841;
var predicate_flakes = inst_16842;
var coll = inst_16855;
return (function (p__16856,pred_flakes){
var vec__16885 = p__16856;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16885,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16885,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16888 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16888.cljs$core$IFn$_invoke$arity$1 ? fexpr__16888.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16888.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16859 = cljs.core.PersistentHashMap.EMPTY;
var inst_16860 = cljs.core.PersistentHashSet.EMPTY;
var inst_16861 = [inst_16859,inst_16860];
var inst_16862 = (new cljs.core.PersistentVector(null,2,(5),inst_16858,inst_16861,null));
var inst_16863 = (function (){var schema_flakes = inst_16838;
var vec__16822 = inst_16840;
var collection_flakes = inst_16841;
var predicate_flakes = inst_16842;
var coll = inst_16855;
return (function (p1__16815_SHARP_){
return p1__16815_SHARP_.s;
});
})();
var inst_16864 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16863,inst_16842);
var inst_16865 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16857,inst_16862,inst_16864);
var inst_16866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16865,(0),null);
var inst_16867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16865,(1),null);
var inst_16868 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16869 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16870 = [inst_16869,inst_16855,inst_16866,inst_16867];
var inst_16871 = cljs.core.PersistentHashMap.fromArrays(inst_16868,inst_16870);
var _ = (function (){var statearr_16889 = state_16876;
(statearr_16889[(4)] = cljs.core.rest((state_16876[(4)])));

return statearr_16889;
})();
var state_16876__$1 = state_16876;
var statearr_16890_16900 = state_16876__$1;
(statearr_16890_16900[(2)] = inst_16871);

(statearr_16890_16900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2717__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2717__auto____0 = (function (){
var statearr_16891 = [null,null,null,null,null,null,null];
(statearr_16891[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2717__auto__);

(statearr_16891[(1)] = (1));

return statearr_16891;
});
var fluree$db$query$schema$schema_map_$_state_machine__2717__auto____1 = (function (state_16876){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_16876);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e16892){var ex__2720__auto__ = e16892;
var statearr_16893_16901 = state_16876;
(statearr_16893_16901[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_16876[(4)]))){
var statearr_16894_16902 = state_16876;
(statearr_16894_16902[(1)] = cljs.core.first((state_16876[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16903 = state_16876;
state_16876 = G__16903;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2717__auto__ = function(state_16876){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2717__auto____1.call(this,state_16876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2717__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2717__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_16895 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_16895[(6)] = c__2739__auto__);

return statearr_16895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_16945){
var state_val_16946 = (state_16945[(1)]);
if((state_val_16946 === (7))){
var inst_16928 = (state_16945[(2)]);
var inst_16929 = fluree.db.query.schema.flake__GT_pred_map(inst_16928);
var inst_16930 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16931 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(114));
var inst_16932 = cljs.core.boolean$(inst_16931);
var inst_16933 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(110));
var inst_16934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(117));
var inst_16935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16934);
var inst_16936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(111));
var inst_16937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(115));
var inst_16938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16929,(112));
var inst_16939 = [inst_16932,inst_16933,inst_16935,inst_16936,inst_16937,inst_16938];
var inst_16940 = cljs.core.PersistentHashMap.fromArrays(inst_16930,inst_16939);
var _ = (function (){var statearr_16947 = state_16945;
(statearr_16947[(4)] = cljs.core.rest((state_16945[(4)])));

return statearr_16947;
})();
var state_16945__$1 = state_16945;
var statearr_16948_16971 = state_16945__$1;
(statearr_16948_16971[(2)] = inst_16940);

(statearr_16948_16971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (1))){
var state_16945__$1 = state_16945;
var statearr_16949_16972 = state_16945__$1;
(statearr_16949_16972[(2)] = null);

(statearr_16949_16972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (4))){
var inst_16904 = (state_16945[(2)]);
var state_16945__$1 = state_16945;
var statearr_16950_16973 = state_16945__$1;
(statearr_16950_16973[(2)] = inst_16904);

(statearr_16950_16973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (6))){
var _ = (function (){var statearr_16951 = state_16945;
(statearr_16951[(4)] = cljs.core.cons((9),(state_16945[(4)])));

return statearr_16951;
})();
var inst_16916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16918 = ["_setting/id","root"];
var inst_16919 = (new cljs.core.PersistentVector(null,2,(5),inst_16917,inst_16918,null));
var inst_16920 = [inst_16919];
var inst_16921 = (new cljs.core.PersistentVector(null,1,(5),inst_16916,inst_16920,null));
var inst_16922 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16921);
var state_16945__$1 = state_16945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16945__$1,(10),inst_16922);
} else {
if((state_val_16946 === (3))){
var inst_16943 = (state_16945[(2)]);
var state_16945__$1 = state_16945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16945__$1,inst_16943);
} else {
if((state_val_16946 === (2))){
var _ = (function (){var statearr_16954 = state_16945;
(statearr_16954[(4)] = cljs.core.cons((5),(state_16945[(4)])));

return statearr_16954;
})();
var state_16945__$1 = state_16945;
var statearr_16955_16974 = state_16945__$1;
(statearr_16955_16974[(2)] = null);

(statearr_16955_16974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (9))){
var _ = (function (){var statearr_16956 = state_16945;
(statearr_16956[(4)] = cljs.core.rest((state_16945[(4)])));

return statearr_16956;
})();
var state_16945__$1 = state_16945;
var ex16952 = (state_16945__$1[(2)]);
var statearr_16957_16975 = state_16945__$1;
(statearr_16957_16975[(5)] = ex16952);


var statearr_16958_16976 = state_16945__$1;
(statearr_16958_16976[(1)] = (8));

(statearr_16958_16976[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (5))){
var _ = (function (){var statearr_16959 = state_16945;
(statearr_16959[(4)] = cljs.core.rest((state_16945[(4)])));

return statearr_16959;
})();
var state_16945__$1 = state_16945;
var ex16953 = (state_16945__$1[(2)]);
var statearr_16960_16977 = state_16945__$1;
(statearr_16960_16977[(5)] = ex16953);


if((ex16953 instanceof Error)){
var statearr_16961_16978 = state_16945__$1;
(statearr_16961_16978[(1)] = (4));

(statearr_16961_16978[(5)] = null);

} else {
throw ex16953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (10))){
var inst_16924 = (state_16945[(2)]);
var inst_16925 = fluree.db.util.async.throw_err(inst_16924);
var _ = (function (){var statearr_16962 = state_16945;
(statearr_16962[(4)] = cljs.core.rest((state_16945[(4)])));

return statearr_16962;
})();
var state_16945__$1 = state_16945;
var statearr_16963_16979 = state_16945__$1;
(statearr_16963_16979[(2)] = inst_16925);

(statearr_16963_16979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16946 === (8))){
var inst_16910 = (state_16945[(2)]);
var state_16945__$1 = (function (){var statearr_16964 = state_16945;
(statearr_16964[(7)] = inst_16910);

return statearr_16964;
})();
var statearr_16965_16980 = state_16945__$1;
(statearr_16965_16980[(2)] = null);

(statearr_16965_16980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2717__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2717__auto____0 = (function (){
var statearr_16966 = [null,null,null,null,null,null,null,null];
(statearr_16966[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2717__auto__);

(statearr_16966[(1)] = (1));

return statearr_16966;
});
var fluree$db$query$schema$setting_map_$_state_machine__2717__auto____1 = (function (state_16945){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_16945);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e16967){var ex__2720__auto__ = e16967;
var statearr_16968_16981 = state_16945;
(statearr_16968_16981[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_16945[(4)]))){
var statearr_16969_16982 = state_16945;
(statearr_16969_16982[(1)] = cljs.core.first((state_16945[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16983 = state_16945;
state_16945 = G__16983;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2717__auto__ = function(state_16945){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2717__auto____1.call(this,state_16945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2717__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2717__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_16970 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_16970[(6)] = c__2739__auto__);

return statearr_16970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
