// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k27982,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__27986 = k27982;
var G__27986__$1 = (((G__27986 instanceof cljs.core.Keyword))?G__27986.fqn:null);
switch (G__27986__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27982,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__27987){
var vec__27988 = p__27987;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27988,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27988,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27981){
var self__ = this;
var G__27981__$1 = this;
return (new cljs.core.RecordIter((0),G__27981__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__27991 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__27991(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27983,other27984){
var self__ = this;
var this27983__$1 = this;
return (((!((other27984 == null)))) && ((((this27983__$1.constructor === other27984.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.conn,other27984.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.network,other27984.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.dbid,other27984.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.db_name,other27984.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.update_chan,other27984.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.transact_chan,other27984.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.state,other27984.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.schema_cache,other27984.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.blank_db,other27984.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.close,other27984.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.id,other27984.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27983__$1.__extmap,other27984.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k27982){
var self__ = this;
var this__4468__auto____$1 = this;
var G__27992 = k27982;
var G__27992__$1 = (((G__27992 instanceof cljs.core.Keyword))?G__27992.fqn:null);
switch (G__27992__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27982);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__27981){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__27993 = cljs.core.keyword_identical_QMARK_;
var expr__27994 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__27996 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27997 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__27996,G__27997) : pred__27993.call(null,G__27996,G__27997));
})())){
return (new fluree.db.session.DbSession(G__27981,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27998 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27999 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__27998,G__27999) : pred__27993.call(null,G__27998,G__27999));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27981,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28000 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28001 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28000,G__28001) : pred__27993.call(null,G__28000,G__28001));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27981,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28002 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__28003 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28002,G__28003) : pred__27993.call(null,G__28002,G__28003));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27981,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28004 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__28005 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28004,G__28005) : pred__27993.call(null,G__28004,G__28005));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27981,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28006 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__28007 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28006,G__28007) : pred__27993.call(null,G__28006,G__28007));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27981,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28008 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__28009 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28008,G__28009) : pred__27993.call(null,G__28008,G__28009));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27981,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28010 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28011 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28010,G__28011) : pred__27993.call(null,G__28010,G__28011));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27981,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28012 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__28013 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28012,G__28013) : pred__27993.call(null,G__28012,G__28013));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27981,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28014 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__28015 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28014,G__28015) : pred__27993.call(null,G__28014,G__28015));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27981,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28016 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__28017 = expr__27994;
return (pred__27993.cljs$core$IFn$_invoke$arity$2 ? pred__27993.cljs$core$IFn$_invoke$arity$2(G__28016,G__28017) : pred__27993.call(null,G__28016,G__28017));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27981,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__27981),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__27981){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27981,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27985){
var extmap__4501__auto__ = (function (){var G__28018 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27985,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27985)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28018);
} else {
return G__28018;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27985),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27985),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28021 = session;
var map__28021__$1 = cljs.core.__destructure_map(map__28021);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28021__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28021__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___28172 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28124){
var state_val_28125 = (state_28124[(1)]);
if((state_val_28125 === (7))){
var inst_28042 = (state_28124[(7)]);
var inst_28047 = cljs.core.empty_QMARK_(inst_28042);
var state_28124__$1 = state_28124;
if(inst_28047){
var statearr_28126_28173 = state_28124__$1;
(statearr_28126_28173[(1)] = (10));

} else {
var statearr_28127_28174 = state_28124__$1;
(statearr_28127_28174[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (20))){
var inst_28033 = (state_28124[(8)]);
var inst_28073 = (state_28124[(9)]);
var inst_28035 = (state_28124[(10)]);
var inst_28034 = (state_28124[(11)]);
var inst_28078 = fluree.db.storage.core.read_block(inst_28033,inst_28034,inst_28035,inst_28073);
var state_28124__$1 = state_28124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(22),inst_28078);
} else {
if((state_val_28125 === (27))){
var inst_28111 = (state_28124[(12)]);
var inst_28113 = (state_28124[(2)]);
var inst_28114 = fluree.db.util.async.throw_err(inst_28113);
var state_28124__$1 = (function (){var statearr_28128 = state_28124;
(statearr_28128[(13)] = inst_28114);

return statearr_28128;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(28),inst_28111);
} else {
if((state_val_28125 === (1))){
var state_28124__$1 = state_28124;
var statearr_28129_28175 = state_28124__$1;
(statearr_28129_28175[(2)] = null);

(statearr_28129_28175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (24))){
var inst_28073 = (state_28124[(9)]);
var inst_28035 = (state_28124[(10)]);
var inst_28034 = (state_28124[(11)]);
var inst_28095 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28073)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28034),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28035),"."].join('');
var inst_28096 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28097 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28098 = cljs.core.PersistentHashMap.fromArrays(inst_28096,inst_28097);
var inst_28099 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28095,inst_28098);
var inst_28100 = (function(){throw inst_28099})();
var state_28124__$1 = state_28124;
var statearr_28130_28176 = state_28124__$1;
(statearr_28130_28176[(2)] = inst_28100);

(statearr_28130_28176[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (4))){
var inst_28022 = (state_28124[(2)]);
var inst_28023 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28022);
var state_28124__$1 = state_28124;
var statearr_28131_28177 = state_28124__$1;
(statearr_28131_28177[(2)] = inst_28023);

(statearr_28131_28177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (15))){
var state_28124__$1 = state_28124;
var statearr_28132_28178 = state_28124__$1;
(statearr_28132_28178[(2)] = null);

(statearr_28132_28178[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (21))){
var inst_28104 = (state_28124[(2)]);
var state_28124__$1 = state_28124;
var statearr_28133_28179 = state_28124__$1;
(statearr_28133_28179[(2)] = inst_28104);

(statearr_28133_28179[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (13))){
var inst_28042 = (state_28124[(7)]);
var inst_28067 = (state_28124[(14)]);
var inst_28066 = (state_28124[(2)]);
var inst_28067__$1 = fluree.db.util.async.throw_err(inst_28066);
var inst_28068 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28042);
var state_28124__$1 = (function (){var statearr_28134 = state_28124;
(statearr_28134[(15)] = inst_28068);

(statearr_28134[(14)] = inst_28067__$1);

return statearr_28134;
})();
if(cljs.core.truth_(inst_28067__$1)){
var statearr_28135_28180 = state_28124__$1;
(statearr_28135_28180[(1)] = (14));

} else {
var statearr_28136_28181 = state_28124__$1;
(statearr_28136_28181[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (22))){
var inst_28081 = (state_28124[(16)]);
var inst_28080 = (state_28124[(2)]);
var inst_28081__$1 = fluree.db.util.async.throw_err(inst_28080);
var state_28124__$1 = (function (){var statearr_28137 = state_28124;
(statearr_28137[(16)] = inst_28081__$1);

return statearr_28137;
})();
if(cljs.core.truth_(inst_28081__$1)){
var statearr_28138_28182 = state_28124__$1;
(statearr_28138_28182[(1)] = (23));

} else {
var statearr_28139_28183 = state_28124__$1;
(statearr_28139_28183[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (6))){
var inst_28042 = (state_28124[(7)]);
var inst_28041 = (state_28124[(2)]);
var inst_28042__$1 = fluree.db.util.async.throw_err(inst_28041);
var inst_28043 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28042__$1);
var inst_28044 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_28043);
var inst_28045 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_28044);
var state_28124__$1 = (function (){var statearr_28140 = state_28124;
(statearr_28140[(7)] = inst_28042__$1);

return statearr_28140;
})();
if(inst_28045){
var statearr_28141_28184 = state_28124__$1;
(statearr_28141_28184[(1)] = (7));

} else {
var statearr_28142_28185 = state_28124__$1;
(statearr_28142_28185[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (28))){
var inst_28114 = (state_28124[(13)]);
var inst_28109 = (state_28124[(17)]);
var inst_28116 = (state_28124[(2)]);
var inst_28117 = fluree.db.util.async.throw_err(inst_28116);
var inst_28118 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28109,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28114,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28117], 0));
var inst_28119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28118);
var _ = (function (){var statearr_28143 = state_28124;
(statearr_28143[(4)] = cljs.core.rest((state_28124[(4)])));

return statearr_28143;
})();
var state_28124__$1 = state_28124;
var statearr_28144_28186 = state_28124__$1;
(statearr_28144_28186[(2)] = inst_28119);

(statearr_28144_28186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (25))){
var inst_28102 = (state_28124[(2)]);
var state_28124__$1 = state_28124;
var statearr_28145_28187 = state_28124__$1;
(statearr_28145_28187[(2)] = inst_28102);

(statearr_28145_28187[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (17))){
var inst_28073 = (state_28124[(9)]);
var inst_28068 = (state_28124[(15)]);
var inst_28075 = (inst_28073 > inst_28068);
var state_28124__$1 = state_28124;
if(cljs.core.truth_(inst_28075)){
var statearr_28146_28188 = state_28124__$1;
(statearr_28146_28188[(1)] = (19));

} else {
var statearr_28147_28189 = state_28124__$1;
(statearr_28147_28189[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (3))){
var inst_28122 = (state_28124[(2)]);
var state_28124__$1 = state_28124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28124__$1,inst_28122);
} else {
if((state_val_28125 === (12))){
var inst_28054 = (state_28124[(2)]);
var inst_28055 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28056 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28057 = cljs.core.PersistentHashMap.fromArrays(inst_28055,inst_28056);
var inst_28058 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28054,inst_28057);
var inst_28059 = (function(){throw inst_28058})();
var state_28124__$1 = state_28124;
var statearr_28148_28190 = state_28124__$1;
(statearr_28148_28190[(2)] = inst_28059);

(statearr_28148_28190[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (2))){
var inst_28033 = (state_28124[(8)]);
var inst_28035 = (state_28124[(10)]);
var inst_28034 = (state_28124[(11)]);
var _ = (function (){var statearr_28149 = state_28124;
(statearr_28149[(4)] = cljs.core.cons((5),(state_28124[(4)])));

return statearr_28149;
})();
var inst_28030 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_28031 = session;
var inst_28032 = cljs.core.__destructure_map(inst_28031);
var inst_28033__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28032,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28034__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28032,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28035__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28032,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28037 = [inst_28034__$1,inst_28035__$1];
var inst_28038 = (new cljs.core.PersistentVector(null,2,(5),inst_28036,inst_28037,null));
var inst_28039 = fluree.db.operations.ledger_info_async(inst_28033__$1,inst_28038);
var state_28124__$1 = (function (){var statearr_28150 = state_28124;
(statearr_28150[(8)] = inst_28033__$1);

(statearr_28150[(10)] = inst_28035__$1);

(statearr_28150[(18)] = inst_28030);

(statearr_28150[(11)] = inst_28034__$1);

return statearr_28150;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(6),inst_28039);
} else {
if((state_val_28125 === (23))){
var inst_28081 = (state_28124[(16)]);
var inst_28072 = (state_28124[(19)]);
var inst_28084 = cljs.core.__destructure_map(inst_28081);
var inst_28085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28084,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28084,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28084,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28088 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28072,inst_28086,inst_28085);
var state_28124__$1 = (function (){var statearr_28151 = state_28124;
(statearr_28151[(20)] = inst_28087);

return statearr_28151;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(26),inst_28088);
} else {
if((state_val_28125 === (19))){
var inst_28072 = (state_28124[(19)]);
var state_28124__$1 = state_28124;
var statearr_28152_28191 = state_28124__$1;
(statearr_28152_28191[(2)] = inst_28072);

(statearr_28152_28191[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (11))){
var inst_28042 = (state_28124[(7)]);
var inst_28035 = (state_28124[(10)]);
var inst_28034 = (state_28124[(11)]);
var inst_28051 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28042);
var inst_28052 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28034),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28035)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28051),"."].join('');
var state_28124__$1 = state_28124;
var statearr_28154_28192 = state_28124__$1;
(statearr_28154_28192[(2)] = inst_28052);

(statearr_28154_28192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (9))){
var inst_28033 = (state_28124[(8)]);
var inst_28042 = (state_28124[(7)]);
var inst_28035 = (state_28124[(10)]);
var inst_28030 = (state_28124[(18)]);
var inst_28034 = (state_28124[(11)]);
var inst_28062 = (state_28124[(2)]);
var inst_28063 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_28042);
var inst_28064 = fluree.db.storage.core.reify_db(inst_28033,inst_28034,inst_28035,inst_28030,inst_28063);
var state_28124__$1 = (function (){var statearr_28155 = state_28124;
(statearr_28155[(21)] = inst_28062);

return statearr_28155;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(13),inst_28064);
} else {
if((state_val_28125 === (5))){
var _ = (function (){var statearr_28156 = state_28124;
(statearr_28156[(4)] = cljs.core.rest((state_28124[(4)])));

return statearr_28156;
})();
var state_28124__$1 = state_28124;
var ex28153 = (state_28124__$1[(2)]);
var statearr_28157_28193 = state_28124__$1;
(statearr_28157_28193[(5)] = ex28153);


var statearr_28158_28194 = state_28124__$1;
(statearr_28158_28194[(1)] = (4));

(statearr_28158_28194[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (14))){
var inst_28067 = (state_28124[(14)]);
var inst_28070 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28067);
var inst_28071 = (inst_28070 + (1));
var inst_28072 = inst_28067;
var inst_28073 = inst_28071;
var state_28124__$1 = (function (){var statearr_28159 = state_28124;
(statearr_28159[(9)] = inst_28073);

(statearr_28159[(19)] = inst_28072);

return statearr_28159;
})();
var statearr_28160_28195 = state_28124__$1;
(statearr_28160_28195[(2)] = null);

(statearr_28160_28195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (26))){
var inst_28073 = (state_28124[(9)]);
var inst_28090 = (state_28124[(2)]);
var inst_28091 = fluree.db.util.async.throw_err(inst_28090);
var inst_28092 = (inst_28073 + (1));
var inst_28072 = inst_28091;
var inst_28073__$1 = inst_28092;
var state_28124__$1 = (function (){var statearr_28161 = state_28124;
(statearr_28161[(9)] = inst_28073__$1);

(statearr_28161[(19)] = inst_28072);

return statearr_28161;
})();
var statearr_28162_28196 = state_28124__$1;
(statearr_28162_28196[(2)] = null);

(statearr_28162_28196[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (16))){
var inst_28109 = (state_28124[(17)]);
var inst_28109__$1 = (state_28124[(2)]);
var inst_28110 = fluree.db.query.schema.schema_map(inst_28109__$1);
var inst_28111 = fluree.db.query.schema.setting_map(inst_28109__$1);
var state_28124__$1 = (function (){var statearr_28163 = state_28124;
(statearr_28163[(12)] = inst_28111);

(statearr_28163[(17)] = inst_28109__$1);

return statearr_28163;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28124__$1,(27),inst_28110);
} else {
if((state_val_28125 === (10))){
var inst_28035 = (state_28124[(10)]);
var inst_28034 = (state_28124[(11)]);
var inst_28049 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28034),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28035)," is not found on this ledger group."].join('');
var state_28124__$1 = state_28124;
var statearr_28164_28197 = state_28124__$1;
(statearr_28164_28197[(2)] = inst_28049);

(statearr_28164_28197[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (18))){
var inst_28106 = (state_28124[(2)]);
var state_28124__$1 = state_28124;
var statearr_28165_28198 = state_28124__$1;
(statearr_28165_28198[(2)] = inst_28106);

(statearr_28165_28198[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28125 === (8))){
var state_28124__$1 = state_28124;
var statearr_28166_28199 = state_28124__$1;
(statearr_28166_28199[(2)] = null);

(statearr_28166_28199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____0 = (function (){
var statearr_28167 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28167[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__);

(statearr_28167[(1)] = (1));

return statearr_28167;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____1 = (function (state_28124){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28124);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28168){var ex__2720__auto__ = e28168;
var statearr_28169_28200 = state_28124;
(statearr_28169_28200[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28124[(4)]))){
var statearr_28170_28201 = state_28124;
(statearr_28170_28201[(1)] = cljs.core.first((state_28124[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28202 = state_28124;
state_28124 = G__28202;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__ = function(state_28124){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____1.call(this,state_28124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2717__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28171 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28171[(6)] = c__2739__auto___28172);

return statearr_28171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__28203 = cljs.core.get_global_hierarchy;
return (fexpr__28203.cljs$core$IFn$_invoke$arity$0 ? fexpr__28203.cljs$core$IFn$_invoke$arity$0() : fexpr__28203.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28205){
var state_val_28206 = (state_28205[(1)]);
if((state_val_28206 === (1))){
var state_28205__$1 = state_28205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28205__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2717__auto__ = null;
var fluree$db$session$state_machine__2717__auto____0 = (function (){
var statearr_28207 = [null,null,null,null,null,null,null];
(statearr_28207[(0)] = fluree$db$session$state_machine__2717__auto__);

(statearr_28207[(1)] = (1));

return statearr_28207;
});
var fluree$db$session$state_machine__2717__auto____1 = (function (state_28205){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28205);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28208){var ex__2720__auto__ = e28208;
var statearr_28209_28212 = state_28205;
(statearr_28209_28212[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28205[(4)]))){
var statearr_28210_28213 = state_28205;
(statearr_28210_28213[(1)] = cljs.core.first((state_28205[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28214 = state_28205;
state_28205 = G__28214;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$state_machine__2717__auto__ = function(state_28205){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2717__auto____1.call(this,state_28205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2717__auto____0;
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2717__auto____1;
return fluree$db$session$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28211 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28211[(6)] = c__2739__auto__);

return statearr_28211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28216){
var map__28217 = p__28216;
var map__28217__$1 = cljs.core.__destructure_map(map__28217);
var data = map__28217__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28217__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28217__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28217__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28276){
var state_val_28277 = (state_28276[(1)]);
if((state_val_28277 === (7))){
var inst_28228 = (state_28276[(7)]);
var inst_28231 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28232 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28233 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28231),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28232),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28228),". No-op."].join('');
var inst_28234 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28233], 0));
var state_28276__$1 = state_28276;
var statearr_28278_28316 = state_28276__$1;
(statearr_28278_28316[(2)] = inst_28234);

(statearr_28278_28316[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (1))){
var state_28276__$1 = state_28276;
var statearr_28279_28317 = state_28276__$1;
(statearr_28279_28317[(2)] = null);

(statearr_28279_28317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (4))){
var inst_28218 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
var statearr_28280_28318 = state_28276__$1;
(statearr_28280_28318[(2)] = inst_28218);

(statearr_28280_28318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (15))){
var inst_28257 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
var statearr_28281_28319 = state_28276__$1;
(statearr_28281_28319[(2)] = inst_28257);

(statearr_28281_28319[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (13))){
var inst_28248 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28250 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28251 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28252 = [inst_28250,inst_28251];
var inst_28253 = (new cljs.core.PersistentVector(null,2,(5),inst_28249,inst_28252,null));
var inst_28254 = (function (){var G__28282 = inst_28248;
var G__28283 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28284 = inst_28253;
var G__28285 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28282,G__28283,G__28284,G__28285) : fluree.db.conn_events.process_event.call(null,G__28282,G__28283,G__28284,G__28285));
})();
var state_28276__$1 = state_28276;
var statearr_28286_28320 = state_28276__$1;
(statearr_28286_28320[(2)] = inst_28254);

(statearr_28286_28320[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (6))){
var inst_28227 = (state_28276[(8)]);
var inst_28228 = (state_28276[(7)]);
var inst_28226 = (state_28276[(2)]);
var inst_28227__$1 = fluree.db.util.async.throw_err(inst_28226);
var inst_28228__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28227__$1);
var inst_28229 = (block <= inst_28228__$1);
var state_28276__$1 = (function (){var statearr_28287 = state_28276;
(statearr_28287[(8)] = inst_28227__$1);

(statearr_28287[(7)] = inst_28228__$1);

return statearr_28287;
})();
if(cljs.core.truth_(inst_28229)){
var statearr_28288_28321 = state_28276__$1;
(statearr_28288_28321[(1)] = (7));

} else {
var statearr_28289_28322 = state_28276__$1;
(statearr_28289_28322[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (17))){
var state_28276__$1 = state_28276;
var statearr_28290_28323 = state_28276__$1;
(statearr_28290_28323[(2)] = null);

(statearr_28290_28323[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (3))){
var inst_28274 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28276__$1,inst_28274);
} else {
if((state_val_28277 === (12))){
var inst_28269 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
var statearr_28291_28324 = state_28276__$1;
(statearr_28291_28324[(2)] = inst_28269);

(statearr_28291_28324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (2))){
var inst_28224 = (state_28276[(9)]);
var _ = (function (){var statearr_28292 = state_28276;
(statearr_28292[(4)] = cljs.core.cons((5),(state_28276[(4)])));

return statearr_28292;
})();
var inst_28224__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28276__$1 = (function (){var statearr_28293 = state_28276;
(statearr_28293[(9)] = inst_28224__$1);

return statearr_28293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28276__$1,(6),inst_28224__$1);
} else {
if((state_val_28277 === (11))){
var state_28276__$1 = state_28276;
var statearr_28295_28325 = state_28276__$1;
(statearr_28295_28325[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (9))){
var inst_28271 = (state_28276[(2)]);
var _ = (function (){var statearr_28297 = state_28276;
(statearr_28297[(4)] = cljs.core.rest((state_28276[(4)])));

return statearr_28297;
})();
var state_28276__$1 = state_28276;
var statearr_28298_28326 = state_28276__$1;
(statearr_28298_28326[(2)] = inst_28271);

(statearr_28298_28326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (5))){
var _ = (function (){var statearr_28299 = state_28276;
(statearr_28299[(4)] = cljs.core.rest((state_28276[(4)])));

return statearr_28299;
})();
var state_28276__$1 = state_28276;
var ex28294 = (state_28276__$1[(2)]);
var statearr_28300_28327 = state_28276__$1;
(statearr_28300_28327[(5)] = ex28294);


if((ex28294 instanceof Error)){
var statearr_28301_28328 = state_28276__$1;
(statearr_28301_28328[(1)] = (4));

(statearr_28301_28328[(5)] = null);

} else {
throw ex28294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (14))){
var state_28276__$1 = state_28276;
var statearr_28302_28329 = state_28276__$1;
(statearr_28302_28329[(2)] = null);

(statearr_28302_28329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (16))){
var inst_28228 = (state_28276[(7)]);
var inst_28260 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28261 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28262 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28260),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28261),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28228),". Forcing a db reload."].join('');
var inst_28263 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28262], 0));
var inst_28264 = fluree.db.session.reload_db_BANG_(session);
var state_28276__$1 = (function (){var statearr_28303 = state_28276;
(statearr_28303[(10)] = inst_28263);

return statearr_28303;
})();
var statearr_28304_28330 = state_28276__$1;
(statearr_28304_28330[(2)] = inst_28264);

(statearr_28304_28330[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (10))){
var inst_28224 = (state_28276[(9)]);
var inst_28227 = (state_28276[(8)]);
var inst_28228 = (state_28276[(7)]);
var inst_28239 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28240 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28241 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28239),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28240),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28242 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28241], 0));
var inst_28243 = (function (){var current_db_ch = inst_28224;
var current_db = inst_28227;
var current_block = inst_28228;
return (function (p1__28215_SHARP_){
if((p1__28215_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28215_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__28215_SHARP_);
}
});
})();
var inst_28244 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_28243,flakes);
var inst_28245 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28227,block,inst_28244);
var inst_28246 = fluree.db.session.cas_db_BANG_(session,inst_28224,inst_28245);
var state_28276__$1 = (function (){var statearr_28305 = state_28276;
(statearr_28305[(11)] = inst_28242);

return statearr_28305;
})();
if(inst_28246){
var statearr_28306_28331 = state_28276__$1;
(statearr_28306_28331[(1)] = (13));

} else {
var statearr_28307_28332 = state_28276__$1;
(statearr_28307_28332[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (18))){
var inst_28267 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
var statearr_28308_28333 = state_28276__$1;
(statearr_28308_28333[(2)] = inst_28267);

(statearr_28308_28333[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (8))){
var inst_28228 = (state_28276[(7)]);
var inst_28236 = ((1) + inst_28228);
var inst_28237 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_28236);
var state_28276__$1 = state_28276;
if(inst_28237){
var statearr_28309_28334 = state_28276__$1;
(statearr_28309_28334[(1)] = (10));

} else {
var statearr_28310_28335 = state_28276__$1;
(statearr_28310_28335[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2717__auto__ = null;
var fluree$db$session$state_machine__2717__auto____0 = (function (){
var statearr_28311 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28311[(0)] = fluree$db$session$state_machine__2717__auto__);

(statearr_28311[(1)] = (1));

return statearr_28311;
});
var fluree$db$session$state_machine__2717__auto____1 = (function (state_28276){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28276);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28312){var ex__2720__auto__ = e28312;
var statearr_28313_28336 = state_28276;
(statearr_28313_28336[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28276[(4)]))){
var statearr_28314_28337 = state_28276;
(statearr_28314_28337[(1)] = cljs.core.first((state_28276[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28338 = state_28276;
state_28276 = G__28338;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$state_machine__2717__auto__ = function(state_28276){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2717__auto____1.call(this,state_28276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2717__auto____0;
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2717__auto____1;
return fluree$db$session$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28315 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28315[(6)] = c__2739__auto__);

return statearr_28315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28345){
var state_val_28346 = (state_28345[(1)]);
if((state_val_28346 === (1))){
var inst_28339 = fluree.db.session.clear_db_BANG_(session);
var inst_28340 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28341 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28342 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28340),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28341)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28343 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28342], 0));
var state_28345__$1 = (function (){var statearr_28347 = state_28345;
(statearr_28347[(7)] = inst_28339);

(statearr_28347[(8)] = inst_28343);

return statearr_28347;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28345__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2717__auto__ = null;
var fluree$db$session$state_machine__2717__auto____0 = (function (){
var statearr_28348 = [null,null,null,null,null,null,null,null,null];
(statearr_28348[(0)] = fluree$db$session$state_machine__2717__auto__);

(statearr_28348[(1)] = (1));

return statearr_28348;
});
var fluree$db$session$state_machine__2717__auto____1 = (function (state_28345){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28345);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28349){var ex__2720__auto__ = e28349;
var statearr_28350_28353 = state_28345;
(statearr_28350_28353[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28345[(4)]))){
var statearr_28351_28354 = state_28345;
(statearr_28351_28354[(1)] = cljs.core.first((state_28345[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28355 = state_28345;
state_28345 = G__28355;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$state_machine__2717__auto__ = function(state_28345){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2717__auto____1.call(this,state_28345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2717__auto____0;
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2717__auto____1;
return fluree$db$session$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28352 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28352[(6)] = c__2739__auto__);

return statearr_28352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28357 = arguments.length;
switch (G__28357) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__28358 = session;
var map__28358__$1 = cljs.core.__destructure_map(map__28358);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28358__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28359_28362 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28359_28362.cljs$core$IFn$_invoke$arity$3 ? fexpr__28359_28362.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28359_28362.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28360_28363 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28360_28363.cljs$core$IFn$_invoke$arity$0 ? fexpr__28360_28363.cljs$core$IFn$_invoke$arity$0() : fexpr__28360_28363.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28416){
var state_val_28417 = (state_28416[(1)]);
if((state_val_28417 === (7))){
var inst_28412 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
var statearr_28418_28449 = state_28416__$1;
(statearr_28418_28449[(2)] = inst_28412);

(statearr_28418_28449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (1))){
var state_28416__$1 = state_28416;
var statearr_28419_28450 = state_28416__$1;
(statearr_28419_28450[(2)] = null);

(statearr_28419_28450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (4))){
var inst_28367 = (state_28416[(7)]);
var inst_28366 = (state_28416[(2)]);
var inst_28367__$1 = fluree.db.util.async.throw_err(inst_28366);
var inst_28368 = fluree.db.session.from_cache(network,ledger_id);
var inst_28369 = (inst_28367__$1 == null);
var state_28416__$1 = (function (){var statearr_28420 = state_28416;
(statearr_28420[(7)] = inst_28367__$1);

(statearr_28420[(8)] = inst_28368);

return statearr_28420;
})();
if(cljs.core.truth_(inst_28369)){
var statearr_28421_28451 = state_28416__$1;
(statearr_28421_28451[(1)] = (5));

} else {
var statearr_28422_28452 = state_28416__$1;
(statearr_28422_28452[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (15))){
var inst_28404 = (state_28416[(2)]);
var state_28416__$1 = (function (){var statearr_28423 = state_28416;
(statearr_28423[(9)] = inst_28404);

return statearr_28423;
})();
var statearr_28424_28453 = state_28416__$1;
(statearr_28424_28453[(2)] = null);

(statearr_28424_28453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (13))){
var inst_28408 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
var statearr_28426_28454 = state_28416__$1;
(statearr_28426_28454[(2)] = inst_28408);

(statearr_28426_28454[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (6))){
var inst_28368 = (state_28416[(8)]);
var inst_28374 = (inst_28368 == null);
var state_28416__$1 = state_28416;
if(cljs.core.truth_(inst_28374)){
var statearr_28427_28455 = state_28416__$1;
(statearr_28427_28455[(1)] = (8));

} else {
var statearr_28428_28456 = state_28416__$1;
(statearr_28428_28456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (17))){
var _ = (function (){var statearr_28429 = state_28416;
(statearr_28429[(4)] = cljs.core.rest((state_28416[(4)])));

return statearr_28429;
})();
var state_28416__$1 = state_28416;
var ex28425 = (state_28416__$1[(2)]);
var statearr_28430_28457 = state_28416__$1;
(statearr_28430_28457[(5)] = ex28425);


var statearr_28431_28458 = state_28416__$1;
(statearr_28431_28458[(1)] = (16));

(statearr_28431_28458[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (3))){
var inst_28414 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28416__$1,inst_28414);
} else {
if((state_val_28417 === (12))){
var state_28416__$1 = state_28416;
var statearr_28432_28459 = state_28416__$1;
(statearr_28432_28459[(2)] = null);

(statearr_28432_28459[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (2))){
var state_28416__$1 = state_28416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28416__$1,(4),update_chan);
} else {
if((state_val_28417 === (11))){
var state_28416__$1 = state_28416;
var statearr_28433_28460 = state_28416__$1;
(statearr_28433_28460[(2)] = null);

(statearr_28433_28460[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (9))){
var state_28416__$1 = state_28416;
var statearr_28434_28461 = state_28416__$1;
(statearr_28434_28461[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (5))){
var inst_28371 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28372 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28371], 0));
var state_28416__$1 = state_28416;
var statearr_28436_28462 = state_28416__$1;
(statearr_28436_28462[(2)] = inst_28372);

(statearr_28436_28462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (14))){
var inst_28367 = (state_28416[(7)]);
var inst_28368 = (state_28416[(8)]);
var _ = (function (){var statearr_28437 = state_28416;
(statearr_28437[(4)] = cljs.core.cons((17),(state_28416[(4)])));

return statearr_28437;
})();
var inst_28392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28367,(0),null);
var inst_28393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28367,(1),null);
var inst_28394 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28395 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28367], 0));
var inst_28396 = fluree.db.util.core.trunc(inst_28395,(200));
var inst_28397 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28394,inst_28396], 0));
var inst_28398 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28368,inst_28392,inst_28393) : fluree.db.session.process_ledger_update.call(null,inst_28368,inst_28392,inst_28393));
var state_28416__$1 = (function (){var statearr_28438 = state_28416;
(statearr_28438[(10)] = inst_28397);

return statearr_28438;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28416__$1,(18),inst_28398);
} else {
if((state_val_28417 === (16))){
var inst_28367 = (state_28416[(7)]);
var inst_28382 = (state_28416[(2)]);
var inst_28383 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28382,"Exception processing ledger updates for message: ",inst_28367], 0));
var state_28416__$1 = state_28416;
var statearr_28439_28463 = state_28416__$1;
(statearr_28439_28463[(2)] = inst_28383);

(statearr_28439_28463[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (10))){
var inst_28410 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
var statearr_28440_28464 = state_28416__$1;
(statearr_28440_28464[(2)] = inst_28410);

(statearr_28440_28464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (18))){
var inst_28400 = (state_28416[(2)]);
var inst_28401 = fluree.db.util.async.throw_err(inst_28400);
var _ = (function (){var statearr_28441 = state_28416;
(statearr_28441[(4)] = cljs.core.rest((state_28416[(4)])));

return statearr_28441;
})();
var state_28416__$1 = state_28416;
var statearr_28442_28465 = state_28416__$1;
(statearr_28442_28465[(2)] = inst_28401);

(statearr_28442_28465[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (8))){
var inst_28367 = (state_28416[(7)]);
var inst_28376 = cljs.core.first(inst_28367);
var inst_28377 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28376], 0));
var inst_28378 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28377].join('');
var inst_28379 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28378], 0));
var state_28416__$1 = state_28416;
var statearr_28443_28466 = state_28416__$1;
(statearr_28443_28466[(2)] = inst_28379);

(statearr_28443_28466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____0 = (function (){
var statearr_28444 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28444[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__);

(statearr_28444[(1)] = (1));

return statearr_28444;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____1 = (function (state_28416){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28416);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28445){var ex__2720__auto__ = e28445;
var statearr_28446_28467 = state_28416;
(statearr_28446_28467[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28416[(4)]))){
var statearr_28447_28468 = state_28416;
(statearr_28447_28468[(1)] = cljs.core.first((state_28416[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28469 = state_28416;
state_28416 = G__28469;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__ = function(state_28416){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____1.call(this,state_28416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2717__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28448 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28448[(6)] = c__2739__auto__);

return statearr_28448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28470){
var map__28471 = p__28470;
var map__28471__$1 = cljs.core.__destructure_map(map__28471);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28471__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28475 = block_result;
var map__28475__$1 = cljs.core.__destructure_map(map__28475);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28475__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28475__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28475__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28475__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28475__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28476 = tx_result;
var map__28476__$1 = cljs.core.__destructure_map(map__28476);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28476__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28476__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28472_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28472_SHARP_.t);
}):(function (p1__28473_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28473_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28474_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28474_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28474_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28477 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28477,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28477,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28477,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28477,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28481 = arguments.length;
switch (G__28481) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28482){
var map__28483 = p__28482;
var map__28483__$1 = cljs.core.__destructure_map(map__28483);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28483__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28483__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28483__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28483__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28484 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28484,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28484,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28484,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28488_28608 = network;
var G__28489_28609 = ledger_id;
var G__28490_28610 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28491_28611 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28492 = cljs.core.seq(tids);
var chunk__28493 = null;
var count__28494 = (0);
var i__28495 = (0);
while(true){
if((i__28495 < count__28494)){
var tid = chunk__28493.cljs$core$IIndexed$_nth$arity$2(null,i__28495);
var temp__5753__auto___28613__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28613__$1)){
var keyed_callbacks_28614 = temp__5753__auto___28613__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28615 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28536_28616 = cljs.core.seq(keyed_callbacks_28614);
var chunk__28537_28617 = null;
var count__28538_28618 = (0);
var i__28539_28619 = (0);
while(true){
if((i__28539_28619 < count__28538_28618)){
var vec__28548_28620 = chunk__28537_28617.cljs$core$IIndexed$_nth$arity$2(null,i__28539_28619);
var k_28621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28548_28620,(0),null);
var f_28622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28548_28620,(1),null);
try{(f_28622.cljs$core$IFn$_invoke$arity$1 ? f_28622.cljs$core$IFn$_invoke$arity$1(tx_response_28615) : f_28622.call(null,tx_response_28615));
}catch (e28551){var e_28623 = e28551;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28623,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28624 = seq__28536_28616;
var G__28625 = chunk__28537_28617;
var G__28626 = count__28538_28618;
var G__28627 = (i__28539_28619 + (1));
seq__28536_28616 = G__28624;
chunk__28537_28617 = G__28625;
count__28538_28618 = G__28626;
i__28539_28619 = G__28627;
continue;
} else {
var temp__5753__auto___28628__$2 = cljs.core.seq(seq__28536_28616);
if(temp__5753__auto___28628__$2){
var seq__28536_28629__$1 = temp__5753__auto___28628__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28536_28629__$1)){
var c__4638__auto___28630 = cljs.core.chunk_first(seq__28536_28629__$1);
var G__28631 = cljs.core.chunk_rest(seq__28536_28629__$1);
var G__28632 = c__4638__auto___28630;
var G__28633 = cljs.core.count(c__4638__auto___28630);
var G__28634 = (0);
seq__28536_28616 = G__28631;
chunk__28537_28617 = G__28632;
count__28538_28618 = G__28633;
i__28539_28619 = G__28634;
continue;
} else {
var vec__28552_28635 = cljs.core.first(seq__28536_28629__$1);
var k_28636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28552_28635,(0),null);
var f_28637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28552_28635,(1),null);
try{(f_28637.cljs$core$IFn$_invoke$arity$1 ? f_28637.cljs$core$IFn$_invoke$arity$1(tx_response_28615) : f_28637.call(null,tx_response_28615));
}catch (e28555){var e_28638 = e28555;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28638,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28639 = cljs.core.next(seq__28536_28629__$1);
var G__28640 = null;
var G__28641 = (0);
var G__28642 = (0);
seq__28536_28616 = G__28639;
chunk__28537_28617 = G__28640;
count__28538_28618 = G__28641;
i__28539_28619 = G__28642;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28643 = seq__28492;
var G__28644 = chunk__28493;
var G__28645 = count__28494;
var G__28646 = (i__28495 + (1));
seq__28492 = G__28643;
chunk__28493 = G__28644;
count__28494 = G__28645;
i__28495 = G__28646;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__28492);
if(temp__5753__auto____$1){
var seq__28492__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28492__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__28492__$1);
var G__28647 = cljs.core.chunk_rest(seq__28492__$1);
var G__28648 = c__4638__auto__;
var G__28649 = cljs.core.count(c__4638__auto__);
var G__28650 = (0);
seq__28492 = G__28647;
chunk__28493 = G__28648;
count__28494 = G__28649;
i__28495 = G__28650;
continue;
} else {
var tid = cljs.core.first(seq__28492__$1);
var temp__5753__auto___28651__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28651__$2)){
var keyed_callbacks_28652 = temp__5753__auto___28651__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28653 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28556_28654 = cljs.core.seq(keyed_callbacks_28652);
var chunk__28557_28655 = null;
var count__28558_28656 = (0);
var i__28559_28657 = (0);
while(true){
if((i__28559_28657 < count__28558_28656)){
var vec__28568_28658 = chunk__28557_28655.cljs$core$IIndexed$_nth$arity$2(null,i__28559_28657);
var k_28659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28568_28658,(0),null);
var f_28660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28568_28658,(1),null);
try{(f_28660.cljs$core$IFn$_invoke$arity$1 ? f_28660.cljs$core$IFn$_invoke$arity$1(tx_response_28653) : f_28660.call(null,tx_response_28653));
}catch (e28571){var e_28661 = e28571;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28661,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28662 = seq__28556_28654;
var G__28663 = chunk__28557_28655;
var G__28664 = count__28558_28656;
var G__28665 = (i__28559_28657 + (1));
seq__28556_28654 = G__28662;
chunk__28557_28655 = G__28663;
count__28558_28656 = G__28664;
i__28559_28657 = G__28665;
continue;
} else {
var temp__5753__auto___28666__$3 = cljs.core.seq(seq__28556_28654);
if(temp__5753__auto___28666__$3){
var seq__28556_28667__$1 = temp__5753__auto___28666__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28556_28667__$1)){
var c__4638__auto___28668 = cljs.core.chunk_first(seq__28556_28667__$1);
var G__28669 = cljs.core.chunk_rest(seq__28556_28667__$1);
var G__28670 = c__4638__auto___28668;
var G__28671 = cljs.core.count(c__4638__auto___28668);
var G__28672 = (0);
seq__28556_28654 = G__28669;
chunk__28557_28655 = G__28670;
count__28558_28656 = G__28671;
i__28559_28657 = G__28672;
continue;
} else {
var vec__28572_28673 = cljs.core.first(seq__28556_28667__$1);
var k_28674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28572_28673,(0),null);
var f_28675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28572_28673,(1),null);
try{(f_28675.cljs$core$IFn$_invoke$arity$1 ? f_28675.cljs$core$IFn$_invoke$arity$1(tx_response_28653) : f_28675.call(null,tx_response_28653));
}catch (e28575){var e_28676 = e28575;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28676,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28677 = cljs.core.next(seq__28556_28667__$1);
var G__28678 = null;
var G__28679 = (0);
var G__28680 = (0);
seq__28556_28654 = G__28677;
chunk__28557_28655 = G__28678;
count__28558_28656 = G__28679;
i__28559_28657 = G__28680;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28681 = cljs.core.next(seq__28492__$1);
var G__28682 = null;
var G__28683 = (0);
var G__28684 = (0);
seq__28492 = G__28681;
chunk__28493 = G__28682;
count__28494 = G__28683;
i__28495 = G__28684;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28487_28612 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28487_28612.cljs$core$IFn$_invoke$arity$4 ? fexpr__28487_28612.cljs$core$IFn$_invoke$arity$4(G__28488_28608,G__28489_28609,G__28490_28610,G__28491_28611) : fexpr__28487_28612.call(null,G__28488_28608,G__28489_28609,G__28490_28610,G__28491_28611));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28685 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2739__auto___28686 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_28592){
var state_val_28593 = (state_28592[(1)]);
if((state_val_28593 === (1))){
var state_28592__$1 = state_28592;
var statearr_28594_28687 = state_28592__$1;
(statearr_28594_28687[(2)] = null);

(statearr_28594_28687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (2))){
var inst_28577 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28592__$1,(4),inst_28577);
} else {
if((state_val_28593 === (3))){
var inst_28590 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28592__$1,inst_28590);
} else {
if((state_val_28593 === (4))){
var inst_28579 = (state_28592[(7)]);
var inst_28579__$1 = (state_28592[(2)]);
var inst_28580 = (inst_28579__$1 == null);
var state_28592__$1 = (function (){var statearr_28595 = state_28592;
(statearr_28595[(7)] = inst_28579__$1);

return statearr_28595;
})();
if(cljs.core.truth_(inst_28580)){
var statearr_28596_28688 = state_28592__$1;
(statearr_28596_28688[(1)] = (5));

} else {
var statearr_28597_28689 = state_28592__$1;
(statearr_28597_28689[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (5))){
var inst_28582 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28583 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28582], 0));
var state_28592__$1 = state_28592;
var statearr_28598_28690 = state_28592__$1;
(statearr_28598_28690[(2)] = inst_28583);

(statearr_28598_28690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (6))){
var inst_28579 = (state_28592[(7)]);
var inst_28585 = (transact_handler_28685.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28685.cljs$core$IFn$_invoke$arity$2(conn,inst_28579) : transact_handler_28685.call(null,conn,inst_28579));
var state_28592__$1 = (function (){var statearr_28599 = state_28592;
(statearr_28599[(8)] = inst_28585);

return statearr_28599;
})();
var statearr_28600_28691 = state_28592__$1;
(statearr_28600_28691[(2)] = null);

(statearr_28600_28691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (7))){
var inst_28588 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
var statearr_28601_28692 = state_28592__$1;
(statearr_28601_28692[(2)] = inst_28588);

(statearr_28601_28692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2717__auto__ = null;
var fluree$db$session$state_machine__2717__auto____0 = (function (){
var statearr_28602 = [null,null,null,null,null,null,null,null,null];
(statearr_28602[(0)] = fluree$db$session$state_machine__2717__auto__);

(statearr_28602[(1)] = (1));

return statearr_28602;
});
var fluree$db$session$state_machine__2717__auto____1 = (function (state_28592){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_28592);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e28603){var ex__2720__auto__ = e28603;
var statearr_28604_28693 = state_28592;
(statearr_28604_28693[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_28592[(4)]))){
var statearr_28605_28694 = state_28592;
(statearr_28605_28694[(1)] = cljs.core.first((state_28592[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28695 = state_28592;
state_28592 = G__28695;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$session$state_machine__2717__auto__ = function(state_28592){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2717__auto____1.call(this,state_28592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2717__auto____0;
fluree$db$session$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2717__auto____1;
return fluree$db$session$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_28606 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_28606[(6)] = c__2739__auto___28686);

return statearr_28606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__28697){
var map__28698 = p__28697;
var map__28698__$1 = cljs.core.__destructure_map(map__28698);
var session = map__28698__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28698__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__28696_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28696_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28696_SHARP_) + (1))], 0));
}));

var or__4212__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28701 = arguments.length;
switch (G__28701) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28702 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28699_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28699_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28702);
} else {
return G__28702;
}
})();
var seq__28703 = cljs.core.seq(sessions);
var chunk__28704 = null;
var count__28705 = (0);
var i__28706 = (0);
while(true){
if((i__28706 < count__28705)){
var session = chunk__28704.cljs$core$IIndexed$_nth$arity$2(null,i__28706);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28708 = seq__28703;
var G__28709 = chunk__28704;
var G__28710 = count__28705;
var G__28711 = (i__28706 + (1));
seq__28703 = G__28708;
chunk__28704 = G__28709;
count__28705 = G__28710;
i__28706 = G__28711;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28703);
if(temp__5753__auto__){
var seq__28703__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28703__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__28703__$1);
var G__28712 = cljs.core.chunk_rest(seq__28703__$1);
var G__28713 = c__4638__auto__;
var G__28714 = cljs.core.count(c__4638__auto__);
var G__28715 = (0);
seq__28703 = G__28712;
chunk__28704 = G__28713;
count__28705 = G__28714;
i__28706 = G__28715;
continue;
} else {
var session = cljs.core.first(seq__28703__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28716 = cljs.core.next(seq__28703__$1);
var G__28717 = null;
var G__28718 = (0);
var G__28719 = (0);
seq__28703 = G__28716;
chunk__28704 = G__28717;
count__28705 = G__28718;
i__28706 = G__28719;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
