// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.spec');
goog.require('cljs.core');
goog.require('fluree.db.util.json');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
goog.require('clojure.string');
fluree.db.spec.EMAIL = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
fluree.db.spec.safe_name = (function fluree$db$spec$safe_name(x){
try{return cljs.core.name(x);
}catch (e21940){var e = e21940;
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}});
/**
 * (type-check type object) transforms a object to match the type. If it cannot be transformed, it throws an ex-info with a map from paths into the object to errors encountered at those paths.
 */
fluree.db.spec.type_check = (function fluree$db$spec$type_check(var_args){
var G__21943 = arguments.length;
switch (G__21943) {
case 2:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2 = (function (object,spec){
var errors = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var conformed = fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4(object,spec,cljs.core.PersistentVector.EMPTY,errors);
var error_seq = cljs.core.reduce_kv((function (e,k,v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(e,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,new cljs.core.Keyword(null,"path","path",-188191168),k));
}),cljs.core.PersistentVector.EMPTY,cljs.core.deref(errors));
if(cljs.core.empty_QMARK_(error_seq)){
return conformed;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Could not conform object: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([object], 0))," to type ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([spec], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.print_str,"Validation error.",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__21941_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(p1__21941_SHARP_))," at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.spec.safe_name,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(p1__21941_SHARP_))),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.spec.safe_name(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(p1__21941_SHARP_)))," but got \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"object","object",1474613949).cljs$core$IFn$_invoke$arity$1(p1__21941_SHARP_)),"\"."].join('');
}),error_seq)),new cljs.core.Keyword(null,"errors","errors",-908790718),error_seq], null)], null));
}
}));

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4 = (function (object,spec,path,errors_atom){
try{var error = (function() { 
var G__21953__delegate = function (p__21945){
var vec__21946 = p__21945;
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21946,(0),null);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Invalid object";
}
})(),cljs.core.PersistentArrayMap.EMPTY);
};
var G__21953 = function (var_args){
var p__21945 = null;
if (arguments.length > 0) {
var G__21954__i = 0, G__21954__a = new Array(arguments.length -  0);
while (G__21954__i < G__21954__a.length) {G__21954__a[G__21954__i] = arguments[G__21954__i + 0]; ++G__21954__i;}
  p__21945 = new cljs.core.IndexedSeq(G__21954__a,0,null);
} 
return G__21953__delegate.call(this,p__21945);};
G__21953.cljs$lang$maxFixedArity = 0;
G__21953.cljs$lang$applyTo = (function (arglist__21955){
var p__21945 = cljs.core.seq(arglist__21955);
return G__21953__delegate(p__21945);
});
G__21953.cljs$core$IFn$_invoke$arity$variadic = G__21953__delegate;
return G__21953;
})()
;
var spec__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.name(spec):spec);
if((spec__$1 == null)){
if((object == null)){
return object;
} else {
return error();
}
} else {
if(typeof spec__$1 === 'string'){
var optional = clojure.string.ends_with_QMARK_(spec__$1,"?");
var base_spec = ((optional)?cljs.core.subs.cljs$core$IFn$_invoke$arity$3(spec__$1,(0),(((spec__$1).length) - (1))):spec__$1);
if(((optional) && ((object == null)))){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"any")){
return object;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"boolean")){
if(cljs.core.boolean_QMARK_(object)){
return object;
} else {
return error();
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"int")){
return (object | (0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"long")){
if(typeof object === 'number'){
return cljs.core.long$(object);
} else {
if(typeof object === 'string'){
var i = parseInt(object);
if((((fluree.db.util.core.min_long <= i)) && ((i <= fluree.db.util.core.max_long)))){
return i;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Long ",object," is outside of javascript max integer size of 2^53 - 1."].join('')], 0));
}
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bigint")){
var i = ((typeof object === 'string')?parseInt(object):object);
if((((fluree.db.util.core.min_long <= i)) && ((i <= fluree.db.util.core.max_long)))){
return i;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Bigintegers are not supported in javascript. max integer size of 2^53 - 1, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join('')], 0));
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"float")){
if(typeof object === 'number'){
return object;
} else {
if(typeof object === 'string'){
return parseFloat(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"double")){
if(typeof object === 'number'){
return object;
} else {
if(typeof object === 'string'){
return parseFloat(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bigdec")){
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Javascript does not support big decimals. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join('')], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"string")){
if((object instanceof cljs.core.Keyword)){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(object),(1));
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);

}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bytes")){
if(typeof object === 'string'){
var uc = object.toLowerCase();
if(cljs.core.truth_(cljs.core.re_matches(/^[0-9a-f]+$/,uc))){
return uc;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bytes type must be in hex string form."], 0));
}
} else {
if(cljs.core.sequential_QMARK_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(object))){
return alphabase.core.bytes__GT_hex(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"instant")){
try{return fluree.db.util.core.date__GT_millis(object);
}catch (e21949){var e = e21949;
return error();
}} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"uri")){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"email")){
if(cljs.core.truth_((function (){var and__4210__auto__ = typeof object === 'string';
if(and__4210__auto__){
return cljs.core.re_find(fluree.db.spec.EMAIL,object);
} else {
return and__4210__auto__;
}
})())){
return object;
} else {
return error();
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"tag")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"ref")))){
return cljs.core.long$(object);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"uuid")){
if(typeof object === 'string'){
return object;
} else {
if(cljs.core.uuid_QMARK_(object)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"json")){
try{if(typeof object === 'string'){
fluree.db.util.json.parse(object);

return object;
} else {
return fluree.db.util.json.stringify(object);
}
}catch (e21950){var _ = e21950;
return error();
}} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"geojson")){
try{var parsed = ((typeof object === 'string')?fluree.db.util.json.parse(object):object);
if(cljs.core.truth_((fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(parsed) : fluree.db.util.json.valid_geojson_QMARK_.call(null,parsed)))){
if(typeof object === 'string'){
return object;
} else {
return fluree.db.util.json.stringify(object);
}
} else {
return error();
}
}catch (e21951){var _ = e21951;
return error();
}} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Unknown base spec ",base_spec].join('')], 0));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Unknown type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('')], 0));

}
}
}catch (e21944){var e = e21944;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(errors_atom,cljs.core.assoc,path,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"object","object",1474613949),object], null));

return object;
}}));

(fluree.db.spec.type_check.cljs$lang$maxFixedArity = 4);

