// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6784 = s;
var map__6784__$1 = cljs.core.__destructure_map(map__6784);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6784__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6784__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6786 = info;
var map__6787 = G__6786;
var map__6787__$1 = cljs.core.__destructure_map(map__6787);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6787__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6786__$1 = G__6786;
while(true){
var d__$2 = d__$1;
var map__6789 = G__6786__$1;
var map__6789__$1 = cljs.core.__destructure_map(map__6789);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6789__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6790 = (d__$2 + (1));
var G__6791 = shadow__$1;
d__$1 = G__6790;
G__6786__$1 = G__6791;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6792){
var map__6793 = p__6792;
var map__6793__$1 = cljs.core.__destructure_map(map__6793);
var name_var = map__6793__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6793__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6793__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6794 = info;
var map__6794__$1 = cljs.core.__destructure_map(map__6794);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6794__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6794__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__6795 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__6795) : cljs.compiler.munge.call(null,G__6795));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6797 = arguments.length;
switch (G__6797) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__6798 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11648,11648,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__6798.cljs$core$IFn$_invoke$arity$1 ? fexpr__6798.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__6798.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6800 = cp;
switch (G__6800) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6802_6806 = cljs.core.seq(s);
var chunk__6803_6807 = null;
var count__6804_6808 = (0);
var i__6805_6809 = (0);
while(true){
if((i__6805_6809 < count__6804_6808)){
var c_6810 = chunk__6803_6807.cljs$core$IIndexed$_nth$arity$2(null,i__6805_6809);
sb.append(cljs.compiler.escape_char(c_6810));


var G__6811 = seq__6802_6806;
var G__6812 = chunk__6803_6807;
var G__6813 = count__6804_6808;
var G__6814 = (i__6805_6809 + (1));
seq__6802_6806 = G__6811;
chunk__6803_6807 = G__6812;
count__6804_6808 = G__6813;
i__6805_6809 = G__6814;
continue;
} else {
var temp__5753__auto___6815 = cljs.core.seq(seq__6802_6806);
if(temp__5753__auto___6815){
var seq__6802_6816__$1 = temp__5753__auto___6815;
if(cljs.core.chunked_seq_QMARK_(seq__6802_6816__$1)){
var c__4679__auto___6817 = cljs.core.chunk_first(seq__6802_6816__$1);
var G__6818 = cljs.core.chunk_rest(seq__6802_6816__$1);
var G__6819 = c__4679__auto___6817;
var G__6820 = cljs.core.count(c__4679__auto___6817);
var G__6821 = (0);
seq__6802_6806 = G__6818;
chunk__6803_6807 = G__6819;
count__6804_6808 = G__6820;
i__6805_6809 = G__6821;
continue;
} else {
var c_6822 = cljs.core.first(seq__6802_6816__$1);
sb.append(cljs.compiler.escape_char(c_6822));


var G__6823 = cljs.core.next(seq__6802_6816__$1);
var G__6824 = null;
var G__6825 = (0);
var G__6826 = (0);
seq__6802_6806 = G__6823;
chunk__6803_6807 = G__6824;
count__6804_6808 = G__6825;
i__6805_6809 = G__6826;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6827 = cljs.core.get_global_hierarchy;
return (fexpr__6827.cljs$core$IFn$_invoke$arity$0 ? fexpr__6827.cljs$core$IFn$_invoke$arity$0() : fexpr__6827.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6828_6833 = ast;
var map__6828_6834__$1 = cljs.core.__destructure_map(map__6828_6833);
var env_6835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6828_6834__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6835))){
var map__6829_6836 = env_6835;
var map__6829_6837__$1 = cljs.core.__destructure_map(map__6829_6836);
var line_6838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6829_6837__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6829_6837__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6830 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__6832 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__6831 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__6831.cljs$core$IFn$_invoke$arity$1 ? fexpr__6831.cljs$core$IFn$_invoke$arity$1(G__6832) : fexpr__6831.call(null,G__6832));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__6830,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6830;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6838 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6839)?(column_6839 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6848 = arguments.length;
switch (G__6848) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6855 = arguments.length;
var i__4865__auto___6856 = (0);
while(true){
if((i__4865__auto___6856 < len__4864__auto___6855)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6856]));

var G__6857 = (i__4865__auto___6856 + (1));
i__4865__auto___6856 = G__6857;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_6858 = (function (){var G__6849 = a;
if((!(typeof a === 'string'))){
return G__6849.toString();
} else {
return G__6849;
}
})();
var temp__5757__auto___6859 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6859 == null)){
} else {
var sm_data_6860 = temp__5757__auto___6859;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_6860,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6840_SHARP_){
return (p1__6840_SHARP_ + s_6858.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_6858], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6850 = cljs.core.seq(xs);
var chunk__6851 = null;
var count__6852 = (0);
var i__6853 = (0);
while(true){
if((i__6853 < count__6852)){
var x = chunk__6851.cljs$core$IIndexed$_nth$arity$2(null,i__6853);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6861 = seq__6850;
var G__6862 = chunk__6851;
var G__6863 = count__6852;
var G__6864 = (i__6853 + (1));
seq__6850 = G__6861;
chunk__6851 = G__6862;
count__6852 = G__6863;
i__6853 = G__6864;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__6850);
if(temp__5753__auto__){
var seq__6850__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6850__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__6850__$1);
var G__6865 = cljs.core.chunk_rest(seq__6850__$1);
var G__6866 = c__4679__auto__;
var G__6867 = cljs.core.count(c__4679__auto__);
var G__6868 = (0);
seq__6850 = G__6865;
chunk__6851 = G__6866;
count__6852 = G__6867;
i__6853 = G__6868;
continue;
} else {
var x = cljs.core.first(seq__6850__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6869 = cljs.core.next(seq__6850__$1);
var G__6870 = null;
var G__6871 = (0);
var G__6872 = (0);
seq__6850 = G__6869;
chunk__6851 = G__6870;
count__6852 = G__6871;
i__6853 = G__6872;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6842){
var G__6843 = cljs.core.first(seq6842);
var seq6842__$1 = cljs.core.next(seq6842);
var G__6844 = cljs.core.first(seq6842__$1);
var seq6842__$2 = cljs.core.next(seq6842__$1);
var G__6845 = cljs.core.first(seq6842__$2);
var seq6842__$3 = cljs.core.next(seq6842__$2);
var G__6846 = cljs.core.first(seq6842__$3);
var seq6842__$4 = cljs.core.next(seq6842__$3);
var G__6847 = cljs.core.first(seq6842__$4);
var seq6842__$5 = cljs.core.next(seq6842__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6843,G__6844,G__6845,G__6846,G__6847,seq6842__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__6873){
var map__6874 = p__6873;
var map__6874__$1 = cljs.core.__destructure_map(map__6874);
var m = map__6874__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6874__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6882 = arguments.length;
switch (G__6882) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6888 = arguments.length;
var i__4865__auto___6889 = (0);
while(true){
if((i__4865__auto___6889 < len__4864__auto___6888)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6889]));

var G__6890 = (i__4865__auto___6889 + (1));
i__4865__auto___6889 = G__6890;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6883_6891 = cljs.core.seq(xs);
var chunk__6884_6892 = null;
var count__6885_6893 = (0);
var i__6886_6894 = (0);
while(true){
if((i__6886_6894 < count__6885_6893)){
var x_6895 = chunk__6884_6892.cljs$core$IIndexed$_nth$arity$2(null,i__6886_6894);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6895);


var G__6896 = seq__6883_6891;
var G__6897 = chunk__6884_6892;
var G__6898 = count__6885_6893;
var G__6899 = (i__6886_6894 + (1));
seq__6883_6891 = G__6896;
chunk__6884_6892 = G__6897;
count__6885_6893 = G__6898;
i__6886_6894 = G__6899;
continue;
} else {
var temp__5753__auto___6900 = cljs.core.seq(seq__6883_6891);
if(temp__5753__auto___6900){
var seq__6883_6901__$1 = temp__5753__auto___6900;
if(cljs.core.chunked_seq_QMARK_(seq__6883_6901__$1)){
var c__4679__auto___6902 = cljs.core.chunk_first(seq__6883_6901__$1);
var G__6903 = cljs.core.chunk_rest(seq__6883_6901__$1);
var G__6904 = c__4679__auto___6902;
var G__6905 = cljs.core.count(c__4679__auto___6902);
var G__6906 = (0);
seq__6883_6891 = G__6903;
chunk__6884_6892 = G__6904;
count__6885_6893 = G__6905;
i__6886_6894 = G__6906;
continue;
} else {
var x_6907 = cljs.core.first(seq__6883_6901__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6907);


var G__6908 = cljs.core.next(seq__6883_6901__$1);
var G__6909 = null;
var G__6910 = (0);
var G__6911 = (0);
seq__6883_6891 = G__6908;
chunk__6884_6892 = G__6909;
count__6885_6893 = G__6910;
i__6886_6894 = G__6911;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6876){
var G__6877 = cljs.core.first(seq6876);
var seq6876__$1 = cljs.core.next(seq6876);
var G__6878 = cljs.core.first(seq6876__$1);
var seq6876__$2 = cljs.core.next(seq6876__$1);
var G__6879 = cljs.core.first(seq6876__$2);
var seq6876__$3 = cljs.core.next(seq6876__$2);
var G__6880 = cljs.core.first(seq6876__$3);
var seq6876__$4 = cljs.core.next(seq6876__$3);
var G__6881 = cljs.core.first(seq6876__$4);
var seq6876__$5 = cljs.core.next(seq6876__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6877,G__6878,G__6879,G__6880,G__6881,seq6876__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6912_6916 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6913_6917 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6914_6918 = true;
var _STAR_print_fn_STAR__temp_val__6915_6919 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6914_6918);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6915_6919);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6913_6917);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6912_6916);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6920 = cljs.core.get_global_hierarchy;
return (fexpr__6920.cljs$core$IFn$_invoke$arity$0 ? fexpr__6920.cljs$core$IFn$_invoke$arity$0() : fexpr__6920.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__6921 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6921,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6921,(1),null);
var G__6924 = ns;
var G__6925 = name;
var G__6926 = (function (){
var G__6927 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__6927) : cljs.compiler.emit_constant.call(null,G__6927));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__6924,G__6925,G__6926) : cljs.compiler.emit_record_value.call(null,G__6924,G__6925,G__6926));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__6928 = cljs.core.keys(x);
var G__6929 = cljs.core.vals(x);
var G__6930 = cljs.compiler.emit_constants_comma_sep;
var G__6931 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__6928,G__6929,G__6930,G__6931) : cljs.compiler.emit_map.call(null,G__6928,G__6929,G__6930,G__6931));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__6932 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__6933 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__6932,G__6933) : cljs.compiler.emit_with_meta.call(null,G__6932,G__6933));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__6934 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6934,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6934,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6934,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
var G__6937 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6937) : x.call(null,G__6937));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
var G__6938 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6938) : x.call(null,G__6938));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__6940 = items;
var G__6941 = (function (p1__6939_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__6939_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__6940,G__6941) : cljs.compiler.emit_js_object.call(null,G__6940,G__6941));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6943){
var map__6944 = p__6943;
var map__6944__$1 = cljs.core.__destructure_map(map__6944);
var ast = map__6944__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6944__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6944__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6944__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6945 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__6945__$1 = cljs.core.__destructure_map(map__6945);
var cenv = map__6945__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6945__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4253__auto__ = js_module_name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6946 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4251__auto__ = (function (){var G__6947 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__6947) : cljs.compiler.es5_GT__EQ_.call(null,G__6947));
})();
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4251__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__6946,cljs.analyzer.es5_allowed);
} else {
return G__6946;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4253__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__6948 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__6948,reserved);
} else {
return G__6948;
}
})();
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__6949_6950 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6949_6951__$1 = (((G__6949_6950 instanceof cljs.core.Keyword))?G__6949_6950.fqn:null);
switch (G__6949_6951__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4251__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6953){
var map__6954 = p__6953;
var map__6954__$1 = cljs.core.__destructure_map(map__6954);
var arg = map__6954__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6954__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6954__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6954__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6954__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6955 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6955__$1 = cljs.core.__destructure_map(map__6955);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6955__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6956){
var map__6957 = p__6956;
var map__6957__$1 = cljs.core.__destructure_map(map__6957);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__6958_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6958_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__6959 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6959) : comma_sep.call(null,G__6959));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__6960 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6960) : comma_sep.call(null,G__6960));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6961){
var map__6962 = p__6961;
var map__6962__$1 = cljs.core.__destructure_map(map__6962);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6963){
var map__6964 = p__6963;
var map__6964__$1 = cljs.core.__destructure_map(map__6964);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6964__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6964__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__6965_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6965_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__6966 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6966) : comma_sep.call(null,G__6966));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6967){
var map__6968 = p__6967;
var map__6968__$1 = cljs.core.__destructure_map(map__6968);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6968__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6968__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___6991 = cljs.core.seq(items);
if(temp__5753__auto___6991){
var items_6992__$1 = temp__5753__auto___6991;
var vec__6969_6993 = items_6992__$1;
var seq__6970_6994 = cljs.core.seq(vec__6969_6993);
var first__6971_6995 = cljs.core.first(seq__6970_6994);
var seq__6970_6996__$1 = cljs.core.next(seq__6970_6994);
var vec__6972_6997 = first__6971_6995;
var k_6998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6972_6997,(0),null);
var v_6999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6972_6997,(1),null);
var r_7000 = seq__6970_6996__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_6998),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_6999) : emit_js_object_val.call(null,v_6999)));

var seq__6975_7001 = cljs.core.seq(r_7000);
var chunk__6976_7002 = null;
var count__6977_7003 = (0);
var i__6978_7004 = (0);
while(true){
if((i__6978_7004 < count__6977_7003)){
var vec__6985_7005 = chunk__6976_7002.cljs$core$IIndexed$_nth$arity$2(null,i__6978_7004);
var k_7006__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6985_7005,(0),null);
var v_7007__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6985_7005,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7006__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7007__$1) : emit_js_object_val.call(null,v_7007__$1)));


var G__7008 = seq__6975_7001;
var G__7009 = chunk__6976_7002;
var G__7010 = count__6977_7003;
var G__7011 = (i__6978_7004 + (1));
seq__6975_7001 = G__7008;
chunk__6976_7002 = G__7009;
count__6977_7003 = G__7010;
i__6978_7004 = G__7011;
continue;
} else {
var temp__5753__auto___7012__$1 = cljs.core.seq(seq__6975_7001);
if(temp__5753__auto___7012__$1){
var seq__6975_7013__$1 = temp__5753__auto___7012__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6975_7013__$1)){
var c__4679__auto___7014 = cljs.core.chunk_first(seq__6975_7013__$1);
var G__7015 = cljs.core.chunk_rest(seq__6975_7013__$1);
var G__7016 = c__4679__auto___7014;
var G__7017 = cljs.core.count(c__4679__auto___7014);
var G__7018 = (0);
seq__6975_7001 = G__7015;
chunk__6976_7002 = G__7016;
count__6977_7003 = G__7017;
i__6978_7004 = G__7018;
continue;
} else {
var vec__6988_7019 = cljs.core.first(seq__6975_7013__$1);
var k_7020__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6988_7019,(0),null);
var v_7021__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6988_7019,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7020__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7021__$1) : emit_js_object_val.call(null,v_7021__$1)));


var G__7022 = cljs.core.next(seq__6975_7013__$1);
var G__7023 = null;
var G__7024 = (0);
var G__7025 = (0);
seq__6975_7001 = G__7022;
chunk__6976_7002 = G__7023;
count__6977_7003 = G__7024;
i__6978_7004 = G__7025;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__7026){
var map__7027 = p__7026;
var map__7027__$1 = cljs.core.__destructure_map(map__7027);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7027__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7027__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7027__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__7028){
var map__7029 = p__7028;
var map__7029__$1 = cljs.core.__destructure_map(map__7029);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7029__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7029__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__7030){
var map__7031 = p__7030;
var map__7031__$1 = cljs.core.__destructure_map(map__7031);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7031__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__7032){
var map__7033 = p__7032;
var map__7033__$1 = cljs.core.__destructure_map(map__7033);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7033__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7033__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__7034 = cljs.analyzer.unwrap_quote(expr);
var map__7034__$1 = cljs.core.__destructure_map(map__7034);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = (function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4251__auto__){
var and__4251__auto____$1 = form;
if(cljs.core.truth_(and__4251__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__7035 = cljs.analyzer.unwrap_quote(expr);
var map__7035__$1 = cljs.core.__destructure_map(map__7035);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7035__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7035__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7035__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4253__auto__ = (function (){var fexpr__7036 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__7036.cljs$core$IFn$_invoke$arity$1 ? fexpr__7036.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7036.call(null,tag));
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__7037){
var map__7038 = p__7037;
var map__7038__$1 = cljs.core.__destructure_map(map__7038);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7038__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7038__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7038__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7038__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7038__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4253__auto__ = unchecked;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__7039){
var map__7040 = p__7039;
var map__7040__$1 = cljs.core.__destructure_map(map__7040);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7040__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7040__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7040__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7040__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__7041_7069 = cljs.core.seq(nodes);
var chunk__7042_7070 = null;
var count__7043_7071 = (0);
var i__7044_7072 = (0);
while(true){
if((i__7044_7072 < count__7043_7071)){
var map__7057_7073 = chunk__7042_7070.cljs$core$IIndexed$_nth$arity$2(null,i__7044_7072);
var map__7057_7074__$1 = cljs.core.__destructure_map(map__7057_7073);
var ts_7075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7057_7074__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7058_7076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7057_7074__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7058_7077__$1 = cljs.core.__destructure_map(map__7058_7076);
var then_7078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7058_7077__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7059_7079 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7075));
var chunk__7060_7080 = null;
var count__7061_7081 = (0);
var i__7062_7082 = (0);
while(true){
if((i__7062_7082 < count__7061_7081)){
var test_7083 = chunk__7060_7080.cljs$core$IIndexed$_nth$arity$2(null,i__7062_7082);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7083,":");


var G__7084 = seq__7059_7079;
var G__7085 = chunk__7060_7080;
var G__7086 = count__7061_7081;
var G__7087 = (i__7062_7082 + (1));
seq__7059_7079 = G__7084;
chunk__7060_7080 = G__7085;
count__7061_7081 = G__7086;
i__7062_7082 = G__7087;
continue;
} else {
var temp__5753__auto___7088 = cljs.core.seq(seq__7059_7079);
if(temp__5753__auto___7088){
var seq__7059_7089__$1 = temp__5753__auto___7088;
if(cljs.core.chunked_seq_QMARK_(seq__7059_7089__$1)){
var c__4679__auto___7090 = cljs.core.chunk_first(seq__7059_7089__$1);
var G__7091 = cljs.core.chunk_rest(seq__7059_7089__$1);
var G__7092 = c__4679__auto___7090;
var G__7093 = cljs.core.count(c__4679__auto___7090);
var G__7094 = (0);
seq__7059_7079 = G__7091;
chunk__7060_7080 = G__7092;
count__7061_7081 = G__7093;
i__7062_7082 = G__7094;
continue;
} else {
var test_7095 = cljs.core.first(seq__7059_7089__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7095,":");


var G__7096 = cljs.core.next(seq__7059_7089__$1);
var G__7097 = null;
var G__7098 = (0);
var G__7099 = (0);
seq__7059_7079 = G__7096;
chunk__7060_7080 = G__7097;
count__7061_7081 = G__7098;
i__7062_7082 = G__7099;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7078);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7078);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7100 = seq__7041_7069;
var G__7101 = chunk__7042_7070;
var G__7102 = count__7043_7071;
var G__7103 = (i__7044_7072 + (1));
seq__7041_7069 = G__7100;
chunk__7042_7070 = G__7101;
count__7043_7071 = G__7102;
i__7044_7072 = G__7103;
continue;
} else {
var temp__5753__auto___7104 = cljs.core.seq(seq__7041_7069);
if(temp__5753__auto___7104){
var seq__7041_7105__$1 = temp__5753__auto___7104;
if(cljs.core.chunked_seq_QMARK_(seq__7041_7105__$1)){
var c__4679__auto___7106 = cljs.core.chunk_first(seq__7041_7105__$1);
var G__7107 = cljs.core.chunk_rest(seq__7041_7105__$1);
var G__7108 = c__4679__auto___7106;
var G__7109 = cljs.core.count(c__4679__auto___7106);
var G__7110 = (0);
seq__7041_7069 = G__7107;
chunk__7042_7070 = G__7108;
count__7043_7071 = G__7109;
i__7044_7072 = G__7110;
continue;
} else {
var map__7063_7111 = cljs.core.first(seq__7041_7105__$1);
var map__7063_7112__$1 = cljs.core.__destructure_map(map__7063_7111);
var ts_7113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7063_7112__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7064_7114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7063_7112__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7064_7115__$1 = cljs.core.__destructure_map(map__7064_7114);
var then_7116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7064_7115__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7065_7117 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7113));
var chunk__7066_7118 = null;
var count__7067_7119 = (0);
var i__7068_7120 = (0);
while(true){
if((i__7068_7120 < count__7067_7119)){
var test_7121 = chunk__7066_7118.cljs$core$IIndexed$_nth$arity$2(null,i__7068_7120);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7121,":");


var G__7122 = seq__7065_7117;
var G__7123 = chunk__7066_7118;
var G__7124 = count__7067_7119;
var G__7125 = (i__7068_7120 + (1));
seq__7065_7117 = G__7122;
chunk__7066_7118 = G__7123;
count__7067_7119 = G__7124;
i__7068_7120 = G__7125;
continue;
} else {
var temp__5753__auto___7126__$1 = cljs.core.seq(seq__7065_7117);
if(temp__5753__auto___7126__$1){
var seq__7065_7127__$1 = temp__5753__auto___7126__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7065_7127__$1)){
var c__4679__auto___7128 = cljs.core.chunk_first(seq__7065_7127__$1);
var G__7129 = cljs.core.chunk_rest(seq__7065_7127__$1);
var G__7130 = c__4679__auto___7128;
var G__7131 = cljs.core.count(c__4679__auto___7128);
var G__7132 = (0);
seq__7065_7117 = G__7129;
chunk__7066_7118 = G__7130;
count__7067_7119 = G__7131;
i__7068_7120 = G__7132;
continue;
} else {
var test_7133 = cljs.core.first(seq__7065_7127__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7133,":");


var G__7134 = cljs.core.next(seq__7065_7127__$1);
var G__7135 = null;
var G__7136 = (0);
var G__7137 = (0);
seq__7065_7117 = G__7134;
chunk__7066_7118 = G__7135;
count__7067_7119 = G__7136;
i__7068_7120 = G__7137;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7116);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7116);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7138 = cljs.core.next(seq__7041_7105__$1);
var G__7139 = null;
var G__7140 = (0);
var G__7141 = (0);
seq__7041_7069 = G__7138;
chunk__7042_7070 = G__7139;
count__7043_7071 = G__7140;
i__7044_7072 = G__7141;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7142){
var map__7143 = p__7142;
var map__7143__$1 = cljs.core.__destructure_map(map__7143);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7143__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7143__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7147 = env;
var G__7148 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7147,G__7148) : cljs.compiler.resolve_type.call(null,G__7147,G__7148));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7149 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7149,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7149,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__7144_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__7144_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__7144_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__7152 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7152,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7152;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7155 = env;
var G__7156 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7155,G__7156) : cljs.compiler.resolve_type.call(null,G__7155,G__7156));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7157_SHARP_){
return cljs.compiler.resolve_type(env,p1__7157_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__7158 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7159 = cljs.core.seq(vec__7158);
var first__7160 = cljs.core.first(seq__7159);
var seq__7159__$1 = cljs.core.next(seq__7159);
var p = first__7160;
var first__7160__$1 = cljs.core.first(seq__7159__$1);
var seq__7159__$2 = cljs.core.next(seq__7159__$1);
var ts = first__7160__$1;
var first__7160__$2 = cljs.core.first(seq__7159__$2);
var seq__7159__$3 = cljs.core.next(seq__7159__$2);
var n = first__7160__$2;
var xs = seq__7159__$3;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__7161 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7162 = cljs.core.seq(vec__7161);
var first__7163 = cljs.core.first(seq__7162);
var seq__7162__$1 = cljs.core.next(seq__7162);
var p = first__7163;
var first__7163__$1 = cljs.core.first(seq__7162__$1);
var seq__7162__$2 = cljs.core.next(seq__7162__$1);
var ts = first__7163__$1;
var xs = seq__7162__$2;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__7165 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__7164 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__7164.cljs$core$IFn$_invoke$arity$1 ? fexpr__7164.cljs$core$IFn$_invoke$arity$1(G__7165) : fexpr__7164.call(null,G__7165));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7168 = arguments.length;
switch (G__7168) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7176 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7166_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__7166_SHARP_);
} else {
return p1__7166_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__7177 = cljs.core.seq(vec__7176);
var first__7178 = cljs.core.first(seq__7177);
var seq__7177__$1 = cljs.core.next(seq__7177);
var x = first__7178;
var ys = seq__7177__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__7179 = cljs.core.seq(ys);
var chunk__7180 = null;
var count__7181 = (0);
var i__7182 = (0);
while(true){
if((i__7182 < count__7181)){
var next_line = chunk__7180.cljs$core$IIndexed$_nth$arity$2(null,i__7182);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7188 = seq__7179;
var G__7189 = chunk__7180;
var G__7190 = count__7181;
var G__7191 = (i__7182 + (1));
seq__7179 = G__7188;
chunk__7180 = G__7189;
count__7181 = G__7190;
i__7182 = G__7191;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7179);
if(temp__5753__auto__){
var seq__7179__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7179__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__7179__$1);
var G__7192 = cljs.core.chunk_rest(seq__7179__$1);
var G__7193 = c__4679__auto__;
var G__7194 = cljs.core.count(c__4679__auto__);
var G__7195 = (0);
seq__7179 = G__7192;
chunk__7180 = G__7193;
count__7181 = G__7194;
i__7182 = G__7195;
continue;
} else {
var next_line = cljs.core.first(seq__7179__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7196 = cljs.core.next(seq__7179__$1);
var G__7197 = null;
var G__7198 = (0);
var G__7199 = (0);
seq__7179 = G__7196;
chunk__7180 = G__7197;
count__7181 = G__7198;
i__7182 = G__7199;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__7183_7200 = cljs.core.seq(docs__$2);
var chunk__7184_7201 = null;
var count__7185_7202 = (0);
var i__7186_7203 = (0);
while(true){
if((i__7186_7203 < count__7185_7202)){
var e_7204 = chunk__7184_7201.cljs$core$IIndexed$_nth$arity$2(null,i__7186_7203);
if(cljs.core.truth_(e_7204)){
print_comment_lines(e_7204);
} else {
}


var G__7205 = seq__7183_7200;
var G__7206 = chunk__7184_7201;
var G__7207 = count__7185_7202;
var G__7208 = (i__7186_7203 + (1));
seq__7183_7200 = G__7205;
chunk__7184_7201 = G__7206;
count__7185_7202 = G__7207;
i__7186_7203 = G__7208;
continue;
} else {
var temp__5753__auto___7209 = cljs.core.seq(seq__7183_7200);
if(temp__5753__auto___7209){
var seq__7183_7210__$1 = temp__5753__auto___7209;
if(cljs.core.chunked_seq_QMARK_(seq__7183_7210__$1)){
var c__4679__auto___7211 = cljs.core.chunk_first(seq__7183_7210__$1);
var G__7212 = cljs.core.chunk_rest(seq__7183_7210__$1);
var G__7213 = c__4679__auto___7211;
var G__7214 = cljs.core.count(c__4679__auto___7211);
var G__7215 = (0);
seq__7183_7200 = G__7212;
chunk__7184_7201 = G__7213;
count__7185_7202 = G__7214;
i__7186_7203 = G__7215;
continue;
} else {
var e_7216 = cljs.core.first(seq__7183_7210__$1);
if(cljs.core.truth_(e_7216)){
print_comment_lines(e_7216);
} else {
}


var G__7217 = cljs.core.next(seq__7183_7210__$1);
var G__7218 = null;
var G__7219 = (0);
var G__7220 = (0);
seq__7183_7200 = G__7217;
chunk__7184_7201 = G__7218;
count__7185_7202 = G__7219;
i__7186_7203 = G__7220;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4251__auto__ = cljs.core.some((function (p1__7222_SHARP_){
return goog.string.startsWith(p1__7222_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = opts;
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4251__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7223){
var map__7224 = p__7223;
var map__7224__$1 = cljs.core.__destructure_map(map__7224);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7224__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4253__auto__ = init;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return test;
} else {
return and__4251__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7225){
var map__7226 = p__7225;
var map__7226__$1 = cljs.core.__destructure_map(map__7226);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7226__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7226__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7226__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__7227_7251 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__7228_7252 = null;
var count__7229_7253 = (0);
var i__7230_7254 = (0);
while(true){
if((i__7230_7254 < count__7229_7253)){
var vec__7237_7255 = chunk__7228_7252.cljs$core$IIndexed$_nth$arity$2(null,i__7230_7254);
var i_7256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7237_7255,(0),null);
var param_7257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7237_7255,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7257);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7258 = seq__7227_7251;
var G__7259 = chunk__7228_7252;
var G__7260 = count__7229_7253;
var G__7261 = (i__7230_7254 + (1));
seq__7227_7251 = G__7258;
chunk__7228_7252 = G__7259;
count__7229_7253 = G__7260;
i__7230_7254 = G__7261;
continue;
} else {
var temp__5753__auto___7262 = cljs.core.seq(seq__7227_7251);
if(temp__5753__auto___7262){
var seq__7227_7263__$1 = temp__5753__auto___7262;
if(cljs.core.chunked_seq_QMARK_(seq__7227_7263__$1)){
var c__4679__auto___7264 = cljs.core.chunk_first(seq__7227_7263__$1);
var G__7265 = cljs.core.chunk_rest(seq__7227_7263__$1);
var G__7266 = c__4679__auto___7264;
var G__7267 = cljs.core.count(c__4679__auto___7264);
var G__7268 = (0);
seq__7227_7251 = G__7265;
chunk__7228_7252 = G__7266;
count__7229_7253 = G__7267;
i__7230_7254 = G__7268;
continue;
} else {
var vec__7240_7269 = cljs.core.first(seq__7227_7263__$1);
var i_7270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7240_7269,(0),null);
var param_7271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7240_7269,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7271);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7272 = cljs.core.next(seq__7227_7263__$1);
var G__7273 = null;
var G__7274 = (0);
var G__7275 = (0);
seq__7227_7251 = G__7272;
chunk__7228_7252 = G__7273;
count__7229_7253 = G__7274;
i__7230_7254 = G__7275;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7243_7276 = cljs.core.seq(params);
var chunk__7244_7277 = null;
var count__7245_7278 = (0);
var i__7246_7279 = (0);
while(true){
if((i__7246_7279 < count__7245_7278)){
var param_7280 = chunk__7244_7277.cljs$core$IIndexed$_nth$arity$2(null,i__7246_7279);
cljs.compiler.emit(param_7280);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7280,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7281 = seq__7243_7276;
var G__7282 = chunk__7244_7277;
var G__7283 = count__7245_7278;
var G__7284 = (i__7246_7279 + (1));
seq__7243_7276 = G__7281;
chunk__7244_7277 = G__7282;
count__7245_7278 = G__7283;
i__7246_7279 = G__7284;
continue;
} else {
var temp__5753__auto___7285 = cljs.core.seq(seq__7243_7276);
if(temp__5753__auto___7285){
var seq__7243_7286__$1 = temp__5753__auto___7285;
if(cljs.core.chunked_seq_QMARK_(seq__7243_7286__$1)){
var c__4679__auto___7287 = cljs.core.chunk_first(seq__7243_7286__$1);
var G__7288 = cljs.core.chunk_rest(seq__7243_7286__$1);
var G__7289 = c__4679__auto___7287;
var G__7290 = cljs.core.count(c__4679__auto___7287);
var G__7291 = (0);
seq__7243_7276 = G__7288;
chunk__7244_7277 = G__7289;
count__7245_7278 = G__7290;
i__7246_7279 = G__7291;
continue;
} else {
var param_7292 = cljs.core.first(seq__7243_7286__$1);
cljs.compiler.emit(param_7292);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7292,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7293 = cljs.core.next(seq__7243_7286__$1);
var G__7294 = null;
var G__7295 = (0);
var G__7296 = (0);
seq__7243_7276 = G__7293;
chunk__7244_7277 = G__7294;
count__7245_7278 = G__7295;
i__7246_7279 = G__7296;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7247_7297 = cljs.core.seq(params);
var chunk__7248_7298 = null;
var count__7249_7299 = (0);
var i__7250_7300 = (0);
while(true){
if((i__7250_7300 < count__7249_7299)){
var param_7301 = chunk__7248_7298.cljs$core$IIndexed$_nth$arity$2(null,i__7250_7300);
cljs.compiler.emit(param_7301);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7301,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7302 = seq__7247_7297;
var G__7303 = chunk__7248_7298;
var G__7304 = count__7249_7299;
var G__7305 = (i__7250_7300 + (1));
seq__7247_7297 = G__7302;
chunk__7248_7298 = G__7303;
count__7249_7299 = G__7304;
i__7250_7300 = G__7305;
continue;
} else {
var temp__5753__auto___7306 = cljs.core.seq(seq__7247_7297);
if(temp__5753__auto___7306){
var seq__7247_7307__$1 = temp__5753__auto___7306;
if(cljs.core.chunked_seq_QMARK_(seq__7247_7307__$1)){
var c__4679__auto___7308 = cljs.core.chunk_first(seq__7247_7307__$1);
var G__7309 = cljs.core.chunk_rest(seq__7247_7307__$1);
var G__7310 = c__4679__auto___7308;
var G__7311 = cljs.core.count(c__4679__auto___7308);
var G__7312 = (0);
seq__7247_7297 = G__7309;
chunk__7248_7298 = G__7310;
count__7249_7299 = G__7311;
i__7250_7300 = G__7312;
continue;
} else {
var param_7313 = cljs.core.first(seq__7247_7307__$1);
cljs.compiler.emit(param_7313);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7313,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7314 = cljs.core.next(seq__7247_7307__$1);
var G__7315 = null;
var G__7316 = (0);
var G__7317 = (0);
seq__7247_7297 = G__7314;
chunk__7248_7298 = G__7315;
count__7249_7299 = G__7316;
i__7250_7300 = G__7317;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7318 = cljs.core.seq(params);
var chunk__7319 = null;
var count__7320 = (0);
var i__7321 = (0);
while(true){
if((i__7321 < count__7320)){
var param = chunk__7319.cljs$core$IIndexed$_nth$arity$2(null,i__7321);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7322 = seq__7318;
var G__7323 = chunk__7319;
var G__7324 = count__7320;
var G__7325 = (i__7321 + (1));
seq__7318 = G__7322;
chunk__7319 = G__7323;
count__7320 = G__7324;
i__7321 = G__7325;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7318);
if(temp__5753__auto__){
var seq__7318__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7318__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__7318__$1);
var G__7326 = cljs.core.chunk_rest(seq__7318__$1);
var G__7327 = c__4679__auto__;
var G__7328 = cljs.core.count(c__4679__auto__);
var G__7329 = (0);
seq__7318 = G__7326;
chunk__7319 = G__7327;
count__7320 = G__7328;
i__7321 = G__7329;
continue;
} else {
var param = cljs.core.first(seq__7318__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7330 = cljs.core.next(seq__7318__$1);
var G__7331 = null;
var G__7332 = (0);
var G__7333 = (0);
seq__7318 = G__7330;
chunk__7319 = G__7331;
count__7320 = G__7332;
i__7321 = G__7333;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7334){
var map__7335 = p__7334;
var map__7335__$1 = cljs.core.__destructure_map(map__7335);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7335__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7336){
var map__7337 = p__7336;
var map__7337__$1 = cljs.core.__destructure_map(map__7337);
var f = map__7337__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7337__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_7346__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7347 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7346__$1);
var delegate_name_7348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7347),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_7348," = function (");

var seq__7338_7349 = cljs.core.seq(params);
var chunk__7339_7350 = null;
var count__7340_7351 = (0);
var i__7341_7352 = (0);
while(true){
if((i__7341_7352 < count__7340_7351)){
var param_7353 = chunk__7339_7350.cljs$core$IIndexed$_nth$arity$2(null,i__7341_7352);
cljs.compiler.emit(param_7353);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7353,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7354 = seq__7338_7349;
var G__7355 = chunk__7339_7350;
var G__7356 = count__7340_7351;
var G__7357 = (i__7341_7352 + (1));
seq__7338_7349 = G__7354;
chunk__7339_7350 = G__7355;
count__7340_7351 = G__7356;
i__7341_7352 = G__7357;
continue;
} else {
var temp__5753__auto___7358 = cljs.core.seq(seq__7338_7349);
if(temp__5753__auto___7358){
var seq__7338_7359__$1 = temp__5753__auto___7358;
if(cljs.core.chunked_seq_QMARK_(seq__7338_7359__$1)){
var c__4679__auto___7360 = cljs.core.chunk_first(seq__7338_7359__$1);
var G__7361 = cljs.core.chunk_rest(seq__7338_7359__$1);
var G__7362 = c__4679__auto___7360;
var G__7363 = cljs.core.count(c__4679__auto___7360);
var G__7364 = (0);
seq__7338_7349 = G__7361;
chunk__7339_7350 = G__7362;
count__7340_7351 = G__7363;
i__7341_7352 = G__7364;
continue;
} else {
var param_7365 = cljs.core.first(seq__7338_7359__$1);
cljs.compiler.emit(param_7365);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7365,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7366 = cljs.core.next(seq__7338_7359__$1);
var G__7367 = null;
var G__7368 = (0);
var G__7369 = (0);
seq__7338_7349 = G__7366;
chunk__7339_7350 = G__7367;
count__7340_7351 = G__7368;
i__7341_7352 = G__7369;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_7347," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_7370 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_7370,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_7348,".call(this,");

var seq__7342_7371 = cljs.core.seq(params);
var chunk__7343_7372 = null;
var count__7344_7373 = (0);
var i__7345_7374 = (0);
while(true){
if((i__7345_7374 < count__7344_7373)){
var param_7375 = chunk__7343_7372.cljs$core$IIndexed$_nth$arity$2(null,i__7345_7374);
cljs.compiler.emit(param_7375);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7375,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7376 = seq__7342_7371;
var G__7377 = chunk__7343_7372;
var G__7378 = count__7344_7373;
var G__7379 = (i__7345_7374 + (1));
seq__7342_7371 = G__7376;
chunk__7343_7372 = G__7377;
count__7344_7373 = G__7378;
i__7345_7374 = G__7379;
continue;
} else {
var temp__5753__auto___7380 = cljs.core.seq(seq__7342_7371);
if(temp__5753__auto___7380){
var seq__7342_7381__$1 = temp__5753__auto___7380;
if(cljs.core.chunked_seq_QMARK_(seq__7342_7381__$1)){
var c__4679__auto___7382 = cljs.core.chunk_first(seq__7342_7381__$1);
var G__7383 = cljs.core.chunk_rest(seq__7342_7381__$1);
var G__7384 = c__4679__auto___7382;
var G__7385 = cljs.core.count(c__4679__auto___7382);
var G__7386 = (0);
seq__7342_7371 = G__7383;
chunk__7343_7372 = G__7384;
count__7344_7373 = G__7385;
i__7345_7374 = G__7386;
continue;
} else {
var param_7387 = cljs.core.first(seq__7342_7381__$1);
cljs.compiler.emit(param_7387);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7387,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7388 = cljs.core.next(seq__7342_7381__$1);
var G__7389 = null;
var G__7390 = (0);
var G__7391 = (0);
seq__7342_7371 = G__7388;
chunk__7343_7372 = G__7389;
count__7344_7373 = G__7390;
i__7345_7374 = G__7391;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7347,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_7347,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_7346__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7347,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7348,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7347,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7395){
var map__7396 = p__7395;
var map__7396__$1 = cljs.core.__destructure_map(map__7396);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7396__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__7392_SHARP_){
var and__4251__auto__ = p1__7392_SHARP_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7392_SHARP_));
} else {
return and__4251__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4253__auto__ = in_loop;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7448__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7449 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7448__$1);
var maxparams_7450 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7451 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7449),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7452 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__7393_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__7393_SHARP_)));
}),cljs.core.seq(mmap_7451));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_7449," = null;");

var seq__7397_7453 = cljs.core.seq(ms_7452);
var chunk__7398_7454 = null;
var count__7399_7455 = (0);
var i__7400_7456 = (0);
while(true){
if((i__7400_7456 < count__7399_7455)){
var vec__7407_7457 = chunk__7398_7454.cljs$core$IIndexed$_nth$arity$2(null,i__7400_7456);
var n_7458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7407_7457,(0),null);
var meth_7459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7407_7457,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7458," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7459))){
cljs.compiler.emit_variadic_fn_method(meth_7459);
} else {
cljs.compiler.emit_fn_method(meth_7459);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7460 = seq__7397_7453;
var G__7461 = chunk__7398_7454;
var G__7462 = count__7399_7455;
var G__7463 = (i__7400_7456 + (1));
seq__7397_7453 = G__7460;
chunk__7398_7454 = G__7461;
count__7399_7455 = G__7462;
i__7400_7456 = G__7463;
continue;
} else {
var temp__5753__auto___7464 = cljs.core.seq(seq__7397_7453);
if(temp__5753__auto___7464){
var seq__7397_7465__$1 = temp__5753__auto___7464;
if(cljs.core.chunked_seq_QMARK_(seq__7397_7465__$1)){
var c__4679__auto___7466 = cljs.core.chunk_first(seq__7397_7465__$1);
var G__7467 = cljs.core.chunk_rest(seq__7397_7465__$1);
var G__7468 = c__4679__auto___7466;
var G__7469 = cljs.core.count(c__4679__auto___7466);
var G__7470 = (0);
seq__7397_7453 = G__7467;
chunk__7398_7454 = G__7468;
count__7399_7455 = G__7469;
i__7400_7456 = G__7470;
continue;
} else {
var vec__7410_7471 = cljs.core.first(seq__7397_7465__$1);
var n_7472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7410_7471,(0),null);
var meth_7473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7410_7471,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7472," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7473))){
cljs.compiler.emit_variadic_fn_method(meth_7473);
} else {
cljs.compiler.emit_fn_method(meth_7473);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7474 = cljs.core.next(seq__7397_7465__$1);
var G__7475 = null;
var G__7476 = (0);
var G__7477 = (0);
seq__7397_7453 = G__7474;
chunk__7398_7454 = G__7475;
count__7399_7455 = G__7476;
i__7400_7456 = G__7477;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7449," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_7450),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7450)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_7450));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__7413_7478 = cljs.core.seq(ms_7452);
var chunk__7414_7479 = null;
var count__7415_7480 = (0);
var i__7416_7481 = (0);
while(true){
if((i__7416_7481 < count__7415_7480)){
var vec__7423_7482 = chunk__7414_7479.cljs$core$IIndexed$_nth$arity$2(null,i__7416_7481);
var n_7483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7423_7482,(0),null);
var meth_7484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7423_7482,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7484))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7485 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7485," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7486 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7485," = new cljs.core.IndexedSeq(",a_7486,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7483,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7450)),(((cljs.core.count(maxparams_7450) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7485,");"], 0));
} else {
var pcnt_7487 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7484));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7487,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7483,".call(this",(((pcnt_7487 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7487,maxparams_7450)),null,(1),null)),(2),null))),");");
}


var G__7488 = seq__7413_7478;
var G__7489 = chunk__7414_7479;
var G__7490 = count__7415_7480;
var G__7491 = (i__7416_7481 + (1));
seq__7413_7478 = G__7488;
chunk__7414_7479 = G__7489;
count__7415_7480 = G__7490;
i__7416_7481 = G__7491;
continue;
} else {
var temp__5753__auto___7492 = cljs.core.seq(seq__7413_7478);
if(temp__5753__auto___7492){
var seq__7413_7493__$1 = temp__5753__auto___7492;
if(cljs.core.chunked_seq_QMARK_(seq__7413_7493__$1)){
var c__4679__auto___7494 = cljs.core.chunk_first(seq__7413_7493__$1);
var G__7495 = cljs.core.chunk_rest(seq__7413_7493__$1);
var G__7496 = c__4679__auto___7494;
var G__7497 = cljs.core.count(c__4679__auto___7494);
var G__7498 = (0);
seq__7413_7478 = G__7495;
chunk__7414_7479 = G__7496;
count__7415_7480 = G__7497;
i__7416_7481 = G__7498;
continue;
} else {
var vec__7426_7499 = cljs.core.first(seq__7413_7493__$1);
var n_7500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7426_7499,(0),null);
var meth_7501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7426_7499,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7501))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7502 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7502," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7503 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7502," = new cljs.core.IndexedSeq(",a_7503,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7500,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7450)),(((cljs.core.count(maxparams_7450) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7502,");"], 0));
} else {
var pcnt_7504 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7501));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7504,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7500,".call(this",(((pcnt_7504 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7504,maxparams_7450)),null,(1),null)),(2),null))),");");
}


var G__7505 = cljs.core.next(seq__7413_7493__$1);
var G__7506 = null;
var G__7507 = (0);
var G__7508 = (0);
seq__7413_7478 = G__7505;
chunk__7414_7479 = G__7506;
count__7415_7480 = G__7507;
i__7416_7481 = G__7508;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_7509 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_7452)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_7509,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7449,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7449,".cljs$lang$applyTo = ",cljs.core.some((function (p1__7394_SHARP_){
var vec__7429 = p1__7394_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7429,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7429,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7452),".cljs$lang$applyTo;");
} else {
}

var seq__7432_7510 = cljs.core.seq(ms_7452);
var chunk__7433_7511 = null;
var count__7434_7512 = (0);
var i__7435_7513 = (0);
while(true){
if((i__7435_7513 < count__7434_7512)){
var vec__7442_7514 = chunk__7433_7511.cljs$core$IIndexed$_nth$arity$2(null,i__7435_7513);
var n_7515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7442_7514,(0),null);
var meth_7516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7442_7514,(1),null);
var c_7517 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7516));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7516))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7449,".cljs$core$IFn$_invoke$arity$variadic = ",n_7515,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7449,".cljs$core$IFn$_invoke$arity$",c_7517," = ",n_7515,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7518 = seq__7432_7510;
var G__7519 = chunk__7433_7511;
var G__7520 = count__7434_7512;
var G__7521 = (i__7435_7513 + (1));
seq__7432_7510 = G__7518;
chunk__7433_7511 = G__7519;
count__7434_7512 = G__7520;
i__7435_7513 = G__7521;
continue;
} else {
var temp__5753__auto___7522 = cljs.core.seq(seq__7432_7510);
if(temp__5753__auto___7522){
var seq__7432_7523__$1 = temp__5753__auto___7522;
if(cljs.core.chunked_seq_QMARK_(seq__7432_7523__$1)){
var c__4679__auto___7524 = cljs.core.chunk_first(seq__7432_7523__$1);
var G__7525 = cljs.core.chunk_rest(seq__7432_7523__$1);
var G__7526 = c__4679__auto___7524;
var G__7527 = cljs.core.count(c__4679__auto___7524);
var G__7528 = (0);
seq__7432_7510 = G__7525;
chunk__7433_7511 = G__7526;
count__7434_7512 = G__7527;
i__7435_7513 = G__7528;
continue;
} else {
var vec__7445_7529 = cljs.core.first(seq__7432_7523__$1);
var n_7530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7445_7529,(0),null);
var meth_7531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7445_7529,(1),null);
var c_7532 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7531));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7531))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7449,".cljs$core$IFn$_invoke$arity$variadic = ",n_7530,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7449,".cljs$core$IFn$_invoke$arity$",c_7532," = ",n_7530,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7533 = cljs.core.next(seq__7432_7523__$1);
var G__7534 = null;
var G__7535 = (0);
var G__7536 = (0);
seq__7432_7510 = G__7533;
chunk__7433_7511 = G__7534;
count__7434_7512 = G__7535;
i__7435_7513 = G__7536;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7449,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7537){
var map__7538 = p__7537;
var map__7538__$1 = cljs.core.__destructure_map(map__7538);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7539_7543 = cljs.core.seq(statements);
var chunk__7540_7544 = null;
var count__7541_7545 = (0);
var i__7542_7546 = (0);
while(true){
if((i__7542_7546 < count__7541_7545)){
var s_7547 = chunk__7540_7544.cljs$core$IIndexed$_nth$arity$2(null,i__7542_7546);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7547);


var G__7548 = seq__7539_7543;
var G__7549 = chunk__7540_7544;
var G__7550 = count__7541_7545;
var G__7551 = (i__7542_7546 + (1));
seq__7539_7543 = G__7548;
chunk__7540_7544 = G__7549;
count__7541_7545 = G__7550;
i__7542_7546 = G__7551;
continue;
} else {
var temp__5753__auto___7552 = cljs.core.seq(seq__7539_7543);
if(temp__5753__auto___7552){
var seq__7539_7553__$1 = temp__5753__auto___7552;
if(cljs.core.chunked_seq_QMARK_(seq__7539_7553__$1)){
var c__4679__auto___7554 = cljs.core.chunk_first(seq__7539_7553__$1);
var G__7555 = cljs.core.chunk_rest(seq__7539_7553__$1);
var G__7556 = c__4679__auto___7554;
var G__7557 = cljs.core.count(c__4679__auto___7554);
var G__7558 = (0);
seq__7539_7543 = G__7555;
chunk__7540_7544 = G__7556;
count__7541_7545 = G__7557;
i__7542_7546 = G__7558;
continue;
} else {
var s_7559 = cljs.core.first(seq__7539_7553__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7559);


var G__7560 = cljs.core.next(seq__7539_7553__$1);
var G__7561 = null;
var G__7562 = (0);
var G__7563 = (0);
seq__7539_7543 = G__7560;
chunk__7540_7544 = G__7561;
count__7541_7545 = G__7562;
i__7542_7546 = G__7563;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7564){
var map__7565 = p__7564;
var map__7565__$1 = cljs.core.__destructure_map(map__7565);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7565__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7565__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7565__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7565__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7565__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7566,is_loop){
var map__7567 = p__7566;
var map__7567__$1 = cljs.core.__destructure_map(map__7567);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7567__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7567__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7567__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7568_7578 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7569_7579 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7569_7579);

try{var seq__7570_7580 = cljs.core.seq(bindings);
var chunk__7571_7581 = null;
var count__7572_7582 = (0);
var i__7573_7583 = (0);
while(true){
if((i__7573_7583 < count__7572_7582)){
var map__7576_7584 = chunk__7571_7581.cljs$core$IIndexed$_nth$arity$2(null,i__7573_7583);
var map__7576_7585__$1 = cljs.core.__destructure_map(map__7576_7584);
var binding_7586 = map__7576_7585__$1;
var init_7587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7576_7585__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7586);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7587,";");


var G__7588 = seq__7570_7580;
var G__7589 = chunk__7571_7581;
var G__7590 = count__7572_7582;
var G__7591 = (i__7573_7583 + (1));
seq__7570_7580 = G__7588;
chunk__7571_7581 = G__7589;
count__7572_7582 = G__7590;
i__7573_7583 = G__7591;
continue;
} else {
var temp__5753__auto___7592 = cljs.core.seq(seq__7570_7580);
if(temp__5753__auto___7592){
var seq__7570_7593__$1 = temp__5753__auto___7592;
if(cljs.core.chunked_seq_QMARK_(seq__7570_7593__$1)){
var c__4679__auto___7594 = cljs.core.chunk_first(seq__7570_7593__$1);
var G__7595 = cljs.core.chunk_rest(seq__7570_7593__$1);
var G__7596 = c__4679__auto___7594;
var G__7597 = cljs.core.count(c__4679__auto___7594);
var G__7598 = (0);
seq__7570_7580 = G__7595;
chunk__7571_7581 = G__7596;
count__7572_7582 = G__7597;
i__7573_7583 = G__7598;
continue;
} else {
var map__7577_7599 = cljs.core.first(seq__7570_7593__$1);
var map__7577_7600__$1 = cljs.core.__destructure_map(map__7577_7599);
var binding_7601 = map__7577_7600__$1;
var init_7602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7577_7600__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7601);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7602,";");


var G__7603 = cljs.core.next(seq__7570_7593__$1);
var G__7604 = null;
var G__7605 = (0);
var G__7606 = (0);
seq__7570_7580 = G__7603;
chunk__7571_7581 = G__7604;
count__7572_7582 = G__7605;
i__7573_7583 = G__7606;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7568_7578);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7607){
var map__7608 = p__7607;
var map__7608__$1 = cljs.core.__destructure_map(map__7608);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7608__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7608__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7608__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4741__auto___7609 = cljs.core.count(exprs);
var i_7610 = (0);
while(true){
if((i_7610 < n__4741__auto___7609)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7610) : temps.call(null,i_7610))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_7610) : exprs.call(null,i_7610)),";");

var G__7611 = (i_7610 + (1));
i_7610 = G__7611;
continue;
} else {
}
break;
}

var n__4741__auto___7612 = cljs.core.count(exprs);
var i_7613 = (0);
while(true){
if((i_7613 < n__4741__auto___7612)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_7613) : params.call(null,i_7613)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7613) : temps.call(null,i_7613)),";");

var G__7614 = (i_7613 + (1));
i_7613 = G__7614;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7615){
var map__7616 = p__7615;
var map__7616__$1 = cljs.core.__destructure_map(map__7616);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7616__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7616__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7616__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7617_7625 = cljs.core.seq(bindings);
var chunk__7618_7626 = null;
var count__7619_7627 = (0);
var i__7620_7628 = (0);
while(true){
if((i__7620_7628 < count__7619_7627)){
var map__7623_7629 = chunk__7618_7626.cljs$core$IIndexed$_nth$arity$2(null,i__7620_7628);
var map__7623_7630__$1 = cljs.core.__destructure_map(map__7623_7629);
var binding_7631 = map__7623_7630__$1;
var init_7632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7623_7630__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7631)," = ",init_7632,";");


var G__7633 = seq__7617_7625;
var G__7634 = chunk__7618_7626;
var G__7635 = count__7619_7627;
var G__7636 = (i__7620_7628 + (1));
seq__7617_7625 = G__7633;
chunk__7618_7626 = G__7634;
count__7619_7627 = G__7635;
i__7620_7628 = G__7636;
continue;
} else {
var temp__5753__auto___7637 = cljs.core.seq(seq__7617_7625);
if(temp__5753__auto___7637){
var seq__7617_7638__$1 = temp__5753__auto___7637;
if(cljs.core.chunked_seq_QMARK_(seq__7617_7638__$1)){
var c__4679__auto___7639 = cljs.core.chunk_first(seq__7617_7638__$1);
var G__7640 = cljs.core.chunk_rest(seq__7617_7638__$1);
var G__7641 = c__4679__auto___7639;
var G__7642 = cljs.core.count(c__4679__auto___7639);
var G__7643 = (0);
seq__7617_7625 = G__7640;
chunk__7618_7626 = G__7641;
count__7619_7627 = G__7642;
i__7620_7628 = G__7643;
continue;
} else {
var map__7624_7644 = cljs.core.first(seq__7617_7638__$1);
var map__7624_7645__$1 = cljs.core.__destructure_map(map__7624_7644);
var binding_7646 = map__7624_7645__$1;
var init_7647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7624_7645__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7646)," = ",init_7647,";");


var G__7648 = cljs.core.next(seq__7617_7638__$1);
var G__7649 = null;
var G__7650 = (0);
var G__7651 = (0);
seq__7617_7625 = G__7648;
chunk__7618_7626 = G__7649;
count__7619_7627 = G__7650;
i__7620_7628 = G__7651;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7654){
var map__7655 = p__7654;
var map__7655__$1 = cljs.core.__destructure_map(map__7655);
var expr = map__7655__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4251__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4251__auto__ = protocol;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = tag;
if(cljs.core.truth_(and__4251__auto____$1)){
var or__4253__auto__ = (function (){var and__4251__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = protocol;
if(cljs.core.truth_(and__4251__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto____$2 = (function (){var or__4253__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4251__auto____$2)){
var or__4253__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
var and__4251__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4251__auto____$3){
var and__4251__auto____$4 = cljs.core.not((function (){var fexpr__7659 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__7659.cljs$core$IFn$_invoke$arity$1 ? fexpr__7659.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7659.call(null,tag));
})());
if(and__4251__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
}
} else {
return and__4251__auto____$2;
}
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__7660 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__7660.cljs$core$IFn$_invoke$arity$1 ? fexpr__7660.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__7660.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4253__auto__){
return or__4253__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7656 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (arity > mfa);
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7652_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7652_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7653_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7653_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7656,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7656,(1),null);
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7663 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_7663,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7664 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_7664,args)),(((mfa_7664 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_7664,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var G__7662 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__7661 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__7661.cljs$core$IFn$_invoke$arity$1 ? fexpr__7661.cljs$core$IFn$_invoke$arity$1(G__7662) : fexpr__7661.call(null,G__7662));
} else {
return and__4251__auto__;
}
})())){
var fprop_7665 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7665," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7665,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7665," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7665,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7666){
var map__7667 = p__7666;
var map__7667__$1 = cljs.core.__destructure_map(map__7667);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7667__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7667__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7667__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7668){
var map__7669 = p__7668;
var map__7669__$1 = cljs.core.__destructure_map(map__7669);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7669__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7669__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7669__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7670_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7670_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7671 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7671,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7671,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7674 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7674__$1 = cljs.core.__destructure_map(map__7674);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7674__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7674__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7675 = options;
var map__7675__$1 = cljs.core.__destructure_map(map__7675);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7675__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7675__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7675__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7676 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7682 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7682__$1 = cljs.core.__destructure_map(map__7682);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7682__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7682__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7676,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7676,(1),null);
var vec__7679 = (function (){var map__7683 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7683__$1 = cljs.core.__destructure_map(map__7683);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7683__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7683__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7679,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7679,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7684_7728 = cljs.core.seq(libs_to_load__$1);
var chunk__7685_7729 = null;
var count__7686_7730 = (0);
var i__7687_7731 = (0);
while(true){
if((i__7687_7731 < count__7686_7730)){
var lib_7732 = chunk__7685_7729.cljs$core$IIndexed$_nth$arity$2(null,i__7687_7731);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7732)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7732),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7732),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7732),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7732),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7732,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7732),"');");
}

}
}
}


var G__7733 = seq__7684_7728;
var G__7734 = chunk__7685_7729;
var G__7735 = count__7686_7730;
var G__7736 = (i__7687_7731 + (1));
seq__7684_7728 = G__7733;
chunk__7685_7729 = G__7734;
count__7686_7730 = G__7735;
i__7687_7731 = G__7736;
continue;
} else {
var temp__5753__auto___7737 = cljs.core.seq(seq__7684_7728);
if(temp__5753__auto___7737){
var seq__7684_7738__$1 = temp__5753__auto___7737;
if(cljs.core.chunked_seq_QMARK_(seq__7684_7738__$1)){
var c__4679__auto___7739 = cljs.core.chunk_first(seq__7684_7738__$1);
var G__7740 = cljs.core.chunk_rest(seq__7684_7738__$1);
var G__7741 = c__4679__auto___7739;
var G__7742 = cljs.core.count(c__4679__auto___7739);
var G__7743 = (0);
seq__7684_7728 = G__7740;
chunk__7685_7729 = G__7741;
count__7686_7730 = G__7742;
i__7687_7731 = G__7743;
continue;
} else {
var lib_7744 = cljs.core.first(seq__7684_7738__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7744)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7744),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7744),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7744),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7744),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7744,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7744),"');");
}

}
}
}


var G__7745 = cljs.core.next(seq__7684_7738__$1);
var G__7746 = null;
var G__7747 = (0);
var G__7748 = (0);
seq__7684_7728 = G__7745;
chunk__7685_7729 = G__7746;
count__7686_7730 = G__7747;
i__7687_7731 = G__7748;
continue;
}
} else {
}
}
break;
}

var seq__7688_7749 = cljs.core.seq(node_libs);
var chunk__7689_7750 = null;
var count__7690_7751 = (0);
var i__7691_7752 = (0);
while(true){
if((i__7691_7752 < count__7690_7751)){
var lib_7753 = chunk__7689_7750.cljs$core$IIndexed$_nth$arity$2(null,i__7691_7752);
var vec__7698_7754 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7753);
var lib_SINGLEQUOTE__7755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7698_7754,(0),null);
var sublib_7756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7698_7754,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7753)," = require('",lib_SINGLEQUOTE__7755,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7756),";"], 0));


var G__7757 = seq__7688_7749;
var G__7758 = chunk__7689_7750;
var G__7759 = count__7690_7751;
var G__7760 = (i__7691_7752 + (1));
seq__7688_7749 = G__7757;
chunk__7689_7750 = G__7758;
count__7690_7751 = G__7759;
i__7691_7752 = G__7760;
continue;
} else {
var temp__5753__auto___7761 = cljs.core.seq(seq__7688_7749);
if(temp__5753__auto___7761){
var seq__7688_7762__$1 = temp__5753__auto___7761;
if(cljs.core.chunked_seq_QMARK_(seq__7688_7762__$1)){
var c__4679__auto___7763 = cljs.core.chunk_first(seq__7688_7762__$1);
var G__7764 = cljs.core.chunk_rest(seq__7688_7762__$1);
var G__7765 = c__4679__auto___7763;
var G__7766 = cljs.core.count(c__4679__auto___7763);
var G__7767 = (0);
seq__7688_7749 = G__7764;
chunk__7689_7750 = G__7765;
count__7690_7751 = G__7766;
i__7691_7752 = G__7767;
continue;
} else {
var lib_7768 = cljs.core.first(seq__7688_7762__$1);
var vec__7701_7769 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7768);
var lib_SINGLEQUOTE__7770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7701_7769,(0),null);
var sublib_7771 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7701_7769,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7768)," = require('",lib_SINGLEQUOTE__7770,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7771),";"], 0));


var G__7772 = cljs.core.next(seq__7688_7762__$1);
var G__7773 = null;
var G__7774 = (0);
var G__7775 = (0);
seq__7688_7749 = G__7772;
chunk__7689_7750 = G__7773;
count__7690_7751 = G__7774;
i__7691_7752 = G__7775;
continue;
}
} else {
}
}
break;
}

var seq__7704_7776 = cljs.core.seq(goog_modules);
var chunk__7705_7777 = null;
var count__7706_7778 = (0);
var i__7707_7779 = (0);
while(true){
if((i__7707_7779 < count__7706_7778)){
var lib_7780 = chunk__7705_7777.cljs$core$IIndexed$_nth$arity$2(null,i__7707_7779);
var vec__7714_7781 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7780);
var lib_SINGLEQUOTE__7782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7714_7781,(0),null);
var sublib_7783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7714_7781,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7782,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7780)," = goog.module.get('",lib_SINGLEQUOTE__7782,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7783),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7784 = seq__7704_7776;
var G__7785 = chunk__7705_7777;
var G__7786 = count__7706_7778;
var G__7787 = (i__7707_7779 + (1));
seq__7704_7776 = G__7784;
chunk__7705_7777 = G__7785;
count__7706_7778 = G__7786;
i__7707_7779 = G__7787;
continue;
} else {
var temp__5753__auto___7788 = cljs.core.seq(seq__7704_7776);
if(temp__5753__auto___7788){
var seq__7704_7789__$1 = temp__5753__auto___7788;
if(cljs.core.chunked_seq_QMARK_(seq__7704_7789__$1)){
var c__4679__auto___7790 = cljs.core.chunk_first(seq__7704_7789__$1);
var G__7791 = cljs.core.chunk_rest(seq__7704_7789__$1);
var G__7792 = c__4679__auto___7790;
var G__7793 = cljs.core.count(c__4679__auto___7790);
var G__7794 = (0);
seq__7704_7776 = G__7791;
chunk__7705_7777 = G__7792;
count__7706_7778 = G__7793;
i__7707_7779 = G__7794;
continue;
} else {
var lib_7795 = cljs.core.first(seq__7704_7789__$1);
var vec__7717_7796 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7795);
var lib_SINGLEQUOTE__7797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7717_7796,(0),null);
var sublib_7798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7717_7796,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7797,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7795)," = goog.module.get('",lib_SINGLEQUOTE__7797,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7798),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7799 = cljs.core.next(seq__7704_7789__$1);
var G__7800 = null;
var G__7801 = (0);
var G__7802 = (0);
seq__7704_7776 = G__7799;
chunk__7705_7777 = G__7800;
count__7706_7778 = G__7801;
i__7707_7779 = G__7802;
continue;
}
} else {
}
}
break;
}

var seq__7720_7803 = cljs.core.seq(global_exports_libs);
var chunk__7721_7804 = null;
var count__7722_7805 = (0);
var i__7723_7806 = (0);
while(true){
if((i__7723_7806 < count__7722_7805)){
var lib_7807 = chunk__7721_7804.cljs$core$IIndexed$_nth$arity$2(null,i__7723_7806);
var map__7726_7808 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7807))));
var map__7726_7809__$1 = cljs.core.__destructure_map(map__7726_7808);
var global_exports_7810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7726_7809__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7810,lib_7807);


var G__7811 = seq__7720_7803;
var G__7812 = chunk__7721_7804;
var G__7813 = count__7722_7805;
var G__7814 = (i__7723_7806 + (1));
seq__7720_7803 = G__7811;
chunk__7721_7804 = G__7812;
count__7722_7805 = G__7813;
i__7723_7806 = G__7814;
continue;
} else {
var temp__5753__auto___7815 = cljs.core.seq(seq__7720_7803);
if(temp__5753__auto___7815){
var seq__7720_7816__$1 = temp__5753__auto___7815;
if(cljs.core.chunked_seq_QMARK_(seq__7720_7816__$1)){
var c__4679__auto___7817 = cljs.core.chunk_first(seq__7720_7816__$1);
var G__7818 = cljs.core.chunk_rest(seq__7720_7816__$1);
var G__7819 = c__4679__auto___7817;
var G__7820 = cljs.core.count(c__4679__auto___7817);
var G__7821 = (0);
seq__7720_7803 = G__7818;
chunk__7721_7804 = G__7819;
count__7722_7805 = G__7820;
i__7723_7806 = G__7821;
continue;
} else {
var lib_7822 = cljs.core.first(seq__7720_7816__$1);
var map__7727_7823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7822))));
var map__7727_7824__$1 = cljs.core.__destructure_map(map__7727_7823);
var global_exports_7825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727_7824__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7825,lib_7822);


var G__7826 = cljs.core.next(seq__7720_7816__$1);
var G__7827 = null;
var G__7828 = (0);
var G__7829 = (0);
seq__7720_7803 = G__7826;
chunk__7721_7804 = G__7827;
count__7722_7805 = G__7828;
i__7723_7806 = G__7829;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7830){
var map__7831 = p__7830;
var map__7831__$1 = cljs.core.__destructure_map(map__7831);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7831__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7832){
var map__7833 = p__7832;
var map__7833__$1 = cljs.core.__destructure_map(map__7833);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7833__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7834){
var map__7835 = p__7834;
var map__7835__$1 = cljs.core.__destructure_map(map__7835);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7835__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7835__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7835__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7835__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7835__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7836_7860 = cljs.core.seq(protocols);
var chunk__7837_7861 = null;
var count__7838_7862 = (0);
var i__7839_7863 = (0);
while(true){
if((i__7839_7863 < count__7838_7862)){
var protocol_7864 = chunk__7837_7861.cljs$core$IIndexed$_nth$arity$2(null,i__7839_7863);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7864)),"}");


var G__7865 = seq__7836_7860;
var G__7866 = chunk__7837_7861;
var G__7867 = count__7838_7862;
var G__7868 = (i__7839_7863 + (1));
seq__7836_7860 = G__7865;
chunk__7837_7861 = G__7866;
count__7838_7862 = G__7867;
i__7839_7863 = G__7868;
continue;
} else {
var temp__5753__auto___7869 = cljs.core.seq(seq__7836_7860);
if(temp__5753__auto___7869){
var seq__7836_7870__$1 = temp__5753__auto___7869;
if(cljs.core.chunked_seq_QMARK_(seq__7836_7870__$1)){
var c__4679__auto___7871 = cljs.core.chunk_first(seq__7836_7870__$1);
var G__7872 = cljs.core.chunk_rest(seq__7836_7870__$1);
var G__7873 = c__4679__auto___7871;
var G__7874 = cljs.core.count(c__4679__auto___7871);
var G__7875 = (0);
seq__7836_7860 = G__7872;
chunk__7837_7861 = G__7873;
count__7838_7862 = G__7874;
i__7839_7863 = G__7875;
continue;
} else {
var protocol_7876 = cljs.core.first(seq__7836_7870__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7876)),"}");


var G__7877 = cljs.core.next(seq__7836_7870__$1);
var G__7878 = null;
var G__7879 = (0);
var G__7880 = (0);
seq__7836_7860 = G__7877;
chunk__7837_7861 = G__7878;
count__7838_7862 = G__7879;
i__7839_7863 = G__7880;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7840_7881 = cljs.core.seq(fields__$1);
var chunk__7841_7882 = null;
var count__7842_7883 = (0);
var i__7843_7884 = (0);
while(true){
if((i__7843_7884 < count__7842_7883)){
var fld_7885 = chunk__7841_7882.cljs$core$IIndexed$_nth$arity$2(null,i__7843_7884);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7885," = ",fld_7885,";");


var G__7886 = seq__7840_7881;
var G__7887 = chunk__7841_7882;
var G__7888 = count__7842_7883;
var G__7889 = (i__7843_7884 + (1));
seq__7840_7881 = G__7886;
chunk__7841_7882 = G__7887;
count__7842_7883 = G__7888;
i__7843_7884 = G__7889;
continue;
} else {
var temp__5753__auto___7890 = cljs.core.seq(seq__7840_7881);
if(temp__5753__auto___7890){
var seq__7840_7891__$1 = temp__5753__auto___7890;
if(cljs.core.chunked_seq_QMARK_(seq__7840_7891__$1)){
var c__4679__auto___7892 = cljs.core.chunk_first(seq__7840_7891__$1);
var G__7893 = cljs.core.chunk_rest(seq__7840_7891__$1);
var G__7894 = c__4679__auto___7892;
var G__7895 = cljs.core.count(c__4679__auto___7892);
var G__7896 = (0);
seq__7840_7881 = G__7893;
chunk__7841_7882 = G__7894;
count__7842_7883 = G__7895;
i__7843_7884 = G__7896;
continue;
} else {
var fld_7897 = cljs.core.first(seq__7840_7891__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7897," = ",fld_7897,";");


var G__7898 = cljs.core.next(seq__7840_7891__$1);
var G__7899 = null;
var G__7900 = (0);
var G__7901 = (0);
seq__7840_7881 = G__7898;
chunk__7841_7882 = G__7899;
count__7842_7883 = G__7900;
i__7843_7884 = G__7901;
continue;
}
} else {
}
}
break;
}

var seq__7844_7902 = cljs.core.seq(pmasks);
var chunk__7845_7903 = null;
var count__7846_7904 = (0);
var i__7847_7905 = (0);
while(true){
if((i__7847_7905 < count__7846_7904)){
var vec__7854_7906 = chunk__7845_7903.cljs$core$IIndexed$_nth$arity$2(null,i__7847_7905);
var pno_7907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7854_7906,(0),null);
var pmask_7908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7854_7906,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7907,"$ = ",pmask_7908,";");


var G__7909 = seq__7844_7902;
var G__7910 = chunk__7845_7903;
var G__7911 = count__7846_7904;
var G__7912 = (i__7847_7905 + (1));
seq__7844_7902 = G__7909;
chunk__7845_7903 = G__7910;
count__7846_7904 = G__7911;
i__7847_7905 = G__7912;
continue;
} else {
var temp__5753__auto___7913 = cljs.core.seq(seq__7844_7902);
if(temp__5753__auto___7913){
var seq__7844_7914__$1 = temp__5753__auto___7913;
if(cljs.core.chunked_seq_QMARK_(seq__7844_7914__$1)){
var c__4679__auto___7915 = cljs.core.chunk_first(seq__7844_7914__$1);
var G__7916 = cljs.core.chunk_rest(seq__7844_7914__$1);
var G__7917 = c__4679__auto___7915;
var G__7918 = cljs.core.count(c__4679__auto___7915);
var G__7919 = (0);
seq__7844_7902 = G__7916;
chunk__7845_7903 = G__7917;
count__7846_7904 = G__7918;
i__7847_7905 = G__7919;
continue;
} else {
var vec__7857_7920 = cljs.core.first(seq__7844_7914__$1);
var pno_7921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7857_7920,(0),null);
var pmask_7922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7857_7920,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7921,"$ = ",pmask_7922,";");


var G__7923 = cljs.core.next(seq__7844_7914__$1);
var G__7924 = null;
var G__7925 = (0);
var G__7926 = (0);
seq__7844_7902 = G__7923;
chunk__7845_7903 = G__7924;
count__7846_7904 = G__7925;
i__7847_7905 = G__7926;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7927){
var map__7928 = p__7927;
var map__7928__$1 = cljs.core.__destructure_map(map__7928);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7928__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7928__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7928__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7928__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7928__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7929_7953 = cljs.core.seq(protocols);
var chunk__7930_7954 = null;
var count__7931_7955 = (0);
var i__7932_7956 = (0);
while(true){
if((i__7932_7956 < count__7931_7955)){
var protocol_7957 = chunk__7930_7954.cljs$core$IIndexed$_nth$arity$2(null,i__7932_7956);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7957)),"}");


var G__7958 = seq__7929_7953;
var G__7959 = chunk__7930_7954;
var G__7960 = count__7931_7955;
var G__7961 = (i__7932_7956 + (1));
seq__7929_7953 = G__7958;
chunk__7930_7954 = G__7959;
count__7931_7955 = G__7960;
i__7932_7956 = G__7961;
continue;
} else {
var temp__5753__auto___7962 = cljs.core.seq(seq__7929_7953);
if(temp__5753__auto___7962){
var seq__7929_7963__$1 = temp__5753__auto___7962;
if(cljs.core.chunked_seq_QMARK_(seq__7929_7963__$1)){
var c__4679__auto___7964 = cljs.core.chunk_first(seq__7929_7963__$1);
var G__7965 = cljs.core.chunk_rest(seq__7929_7963__$1);
var G__7966 = c__4679__auto___7964;
var G__7967 = cljs.core.count(c__4679__auto___7964);
var G__7968 = (0);
seq__7929_7953 = G__7965;
chunk__7930_7954 = G__7966;
count__7931_7955 = G__7967;
i__7932_7956 = G__7968;
continue;
} else {
var protocol_7969 = cljs.core.first(seq__7929_7963__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7969)),"}");


var G__7970 = cljs.core.next(seq__7929_7963__$1);
var G__7971 = null;
var G__7972 = (0);
var G__7973 = (0);
seq__7929_7953 = G__7970;
chunk__7930_7954 = G__7971;
count__7931_7955 = G__7972;
i__7932_7956 = G__7973;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7933_7974 = cljs.core.seq(fields__$1);
var chunk__7934_7975 = null;
var count__7935_7976 = (0);
var i__7936_7977 = (0);
while(true){
if((i__7936_7977 < count__7935_7976)){
var fld_7978 = chunk__7934_7975.cljs$core$IIndexed$_nth$arity$2(null,i__7936_7977);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7978," = ",fld_7978,";");


var G__7979 = seq__7933_7974;
var G__7980 = chunk__7934_7975;
var G__7981 = count__7935_7976;
var G__7982 = (i__7936_7977 + (1));
seq__7933_7974 = G__7979;
chunk__7934_7975 = G__7980;
count__7935_7976 = G__7981;
i__7936_7977 = G__7982;
continue;
} else {
var temp__5753__auto___7983 = cljs.core.seq(seq__7933_7974);
if(temp__5753__auto___7983){
var seq__7933_7984__$1 = temp__5753__auto___7983;
if(cljs.core.chunked_seq_QMARK_(seq__7933_7984__$1)){
var c__4679__auto___7985 = cljs.core.chunk_first(seq__7933_7984__$1);
var G__7986 = cljs.core.chunk_rest(seq__7933_7984__$1);
var G__7987 = c__4679__auto___7985;
var G__7988 = cljs.core.count(c__4679__auto___7985);
var G__7989 = (0);
seq__7933_7974 = G__7986;
chunk__7934_7975 = G__7987;
count__7935_7976 = G__7988;
i__7936_7977 = G__7989;
continue;
} else {
var fld_7990 = cljs.core.first(seq__7933_7984__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7990," = ",fld_7990,";");


var G__7991 = cljs.core.next(seq__7933_7984__$1);
var G__7992 = null;
var G__7993 = (0);
var G__7994 = (0);
seq__7933_7974 = G__7991;
chunk__7934_7975 = G__7992;
count__7935_7976 = G__7993;
i__7936_7977 = G__7994;
continue;
}
} else {
}
}
break;
}

var seq__7937_7995 = cljs.core.seq(pmasks);
var chunk__7938_7996 = null;
var count__7939_7997 = (0);
var i__7940_7998 = (0);
while(true){
if((i__7940_7998 < count__7939_7997)){
var vec__7947_7999 = chunk__7938_7996.cljs$core$IIndexed$_nth$arity$2(null,i__7940_7998);
var pno_8000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7947_7999,(0),null);
var pmask_8001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7947_7999,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8000,"$ = ",pmask_8001,";");


var G__8002 = seq__7937_7995;
var G__8003 = chunk__7938_7996;
var G__8004 = count__7939_7997;
var G__8005 = (i__7940_7998 + (1));
seq__7937_7995 = G__8002;
chunk__7938_7996 = G__8003;
count__7939_7997 = G__8004;
i__7940_7998 = G__8005;
continue;
} else {
var temp__5753__auto___8006 = cljs.core.seq(seq__7937_7995);
if(temp__5753__auto___8006){
var seq__7937_8007__$1 = temp__5753__auto___8006;
if(cljs.core.chunked_seq_QMARK_(seq__7937_8007__$1)){
var c__4679__auto___8008 = cljs.core.chunk_first(seq__7937_8007__$1);
var G__8009 = cljs.core.chunk_rest(seq__7937_8007__$1);
var G__8010 = c__4679__auto___8008;
var G__8011 = cljs.core.count(c__4679__auto___8008);
var G__8012 = (0);
seq__7937_7995 = G__8009;
chunk__7938_7996 = G__8010;
count__7939_7997 = G__8011;
i__7940_7998 = G__8012;
continue;
} else {
var vec__7950_8013 = cljs.core.first(seq__7937_8007__$1);
var pno_8014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7950_8013,(0),null);
var pmask_8015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7950_8013,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8014,"$ = ",pmask_8015,";");


var G__8016 = cljs.core.next(seq__7937_8007__$1);
var G__8017 = null;
var G__8018 = (0);
var G__8019 = (0);
seq__7937_7995 = G__8016;
chunk__7938_7996 = G__8017;
count__7939_7997 = G__8018;
i__7940_7998 = G__8019;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__8020){
var map__8021 = p__8020;
var map__8021__$1 = cljs.core.__destructure_map(map__8021);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8021__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8021__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8021__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8021__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8021__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__8022){
var map__8023 = p__8022;
var map__8023__$1 = cljs.core.__destructure_map(map__8023);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8023__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8023__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8023__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8023__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8023__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4251__auto__ = code;
if(cljs.core.truth_(and__4251__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4251__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__6776__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6776__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__8028 = cljs.core.seq(table);
var chunk__8029 = null;
var count__8030 = (0);
var i__8031 = (0);
while(true){
if((i__8031 < count__8030)){
var vec__8038 = chunk__8029.cljs$core$IIndexed$_nth$arity$2(null,i__8031);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8038,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8038,(1),null);
var ns_8044 = cljs.core.namespace(sym);
var name_8045 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8046 = seq__8028;
var G__8047 = chunk__8029;
var G__8048 = count__8030;
var G__8049 = (i__8031 + (1));
seq__8028 = G__8046;
chunk__8029 = G__8047;
count__8030 = G__8048;
i__8031 = G__8049;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__8028);
if(temp__5753__auto__){
var seq__8028__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8028__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__8028__$1);
var G__8050 = cljs.core.chunk_rest(seq__8028__$1);
var G__8051 = c__4679__auto__;
var G__8052 = cljs.core.count(c__4679__auto__);
var G__8053 = (0);
seq__8028 = G__8050;
chunk__8029 = G__8051;
count__8030 = G__8052;
i__8031 = G__8053;
continue;
} else {
var vec__8041 = cljs.core.first(seq__8028__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8041,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8041,(1),null);
var ns_8054 = cljs.core.namespace(sym);
var name_8055 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8056 = cljs.core.next(seq__8028__$1);
var G__8057 = null;
var G__8058 = (0);
var G__8059 = (0);
seq__8028 = G__8056;
chunk__8029 = G__8057;
count__8030 = G__8058;
i__8031 = G__8059;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__8061 = arguments.length;
switch (G__8061) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_8066 = cljs.core.first(ks);
var vec__8062_8067 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_8066);
var top_8068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8062_8067,(0),null);
var prefix_SINGLEQUOTE__8069 = vec__8062_8067;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_8066)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__8069) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_8068)) || (cljs.core.contains_QMARK_(known_externs,top_8068)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8069)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_8068);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8069)),";");
}
} else {
}

var m_8070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_8066);
if(cljs.core.empty_QMARK_(m_8070)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__8069,m_8070,top_level,known_externs);
}

var G__8071 = cljs.core.next(ks);
ks = G__8071;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

