// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__72546_72715 = cljs.core.seq(servers);
var chunk__72547_72716 = null;
var count__72548_72717 = (0);
var i__72549_72718 = (0);
while(true){
if((i__72549_72718 < count__72548_72717)){
var server_72719 = chunk__72547_72716.cljs$core$IIndexed$_nth$arity$2(null,i__72549_72718);
var healthcheck_uri_72720 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72719),"/fdb/health"].join('');
var resp_chan_72721 = fluree.db.util.xhttp.post_json(healthcheck_uri_72720,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11484__auto___72722 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719){
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = ((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719){
return (function (state_72610){
var state_val_72611 = (state_72610[(1)]);
if((state_val_72611 === (1))){
var state_72610__$1 = state_72610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72610__$1,(2),resp_chan_72721);
} else {
if((state_val_72611 === (2))){
var inst_72599 = (state_72610[(7)]);
var inst_72599__$1 = (state_72610[(2)]);
var inst_72600 = fluree.db.util.core.exception_QMARK_(inst_72599__$1);
var state_72610__$1 = (function (){var statearr_72612 = state_72610;
(statearr_72612[(7)] = inst_72599__$1);

return statearr_72612;
})();
if(inst_72600){
var statearr_72613_72723 = state_72610__$1;
(statearr_72613_72723[(1)] = (3));

} else {
var statearr_72614_72724 = state_72610__$1;
(statearr_72614_72724[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72611 === (3))){
var inst_72599 = (state_72610[(7)]);
var inst_72602 = cljs.core.ex_message(inst_72599);
var inst_72603 = cljs.core.ex_data(inst_72599);
var inst_72604 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_72602,inst_72603], 0));
var state_72610__$1 = state_72610;
var statearr_72615_72725 = state_72610__$1;
(statearr_72615_72725[(2)] = inst_72604);

(statearr_72615_72725[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72611 === (4))){
var inst_72606 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_72719);
var state_72610__$1 = state_72610;
var statearr_72616_72726 = state_72610__$1;
(statearr_72616_72726[(2)] = inst_72606);

(statearr_72616_72726[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72611 === (5))){
var inst_72608 = (state_72610[(2)]);
var state_72610__$1 = state_72610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72610__$1,inst_72608);
} else {
return null;
}
}
}
}
}
});})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719))
;
return ((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,switch__11409__auto__,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0 = (function (){
var statearr_72617 = [null,null,null,null,null,null,null,null];
(statearr_72617[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__);

(statearr_72617[(1)] = (1));

return statearr_72617;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1 = (function (state_72610){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72610);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72618){var ex__11413__auto__ = e72618;
var statearr_72619_72727 = state_72610;
(statearr_72619_72727[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72610[(4)]))){
var statearr_72620_72728 = state_72610;
(statearr_72620_72728[(1)] = cljs.core.first((state_72610[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72729 = state_72610;
state_72610 = G__72729;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = function(state_72610){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1.call(this,state_72610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__;
})()
;})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,switch__11409__auto__,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719))
})();
var state__11486__auto__ = (function (){var statearr_72621 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72621[(6)] = c__11484__auto___72722);

return statearr_72621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72722,healthcheck_uri_72720,resp_chan_72721,server_72719))
);



var G__72730 = seq__72546_72715;
var G__72731 = chunk__72547_72716;
var G__72732 = count__72548_72717;
var G__72733 = (i__72549_72718 + (1));
seq__72546_72715 = G__72730;
chunk__72547_72716 = G__72731;
count__72548_72717 = G__72732;
i__72549_72718 = G__72733;
continue;
} else {
var temp__5753__auto___72734 = cljs.core.seq(seq__72546_72715);
if(temp__5753__auto___72734){
var seq__72546_72735__$1 = temp__5753__auto___72734;
if(cljs.core.chunked_seq_QMARK_(seq__72546_72735__$1)){
var c__4679__auto___72736 = cljs.core.chunk_first(seq__72546_72735__$1);
var G__72737 = cljs.core.chunk_rest(seq__72546_72735__$1);
var G__72738 = c__4679__auto___72736;
var G__72739 = cljs.core.count(c__4679__auto___72736);
var G__72740 = (0);
seq__72546_72715 = G__72737;
chunk__72547_72716 = G__72738;
count__72548_72717 = G__72739;
i__72549_72718 = G__72740;
continue;
} else {
var server_72741 = cljs.core.first(seq__72546_72735__$1);
var healthcheck_uri_72742 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_72741),"/fdb/health"].join('');
var resp_chan_72743 = fluree.db.util.xhttp.post_json(healthcheck_uri_72742,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11484__auto___72744 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734){
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = ((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734){
return (function (state_72634){
var state_val_72635 = (state_72634[(1)]);
if((state_val_72635 === (1))){
var state_72634__$1 = state_72634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72634__$1,(2),resp_chan_72743);
} else {
if((state_val_72635 === (2))){
var inst_72623 = (state_72634[(7)]);
var inst_72623__$1 = (state_72634[(2)]);
var inst_72624 = fluree.db.util.core.exception_QMARK_(inst_72623__$1);
var state_72634__$1 = (function (){var statearr_72636 = state_72634;
(statearr_72636[(7)] = inst_72623__$1);

return statearr_72636;
})();
if(inst_72624){
var statearr_72637_72745 = state_72634__$1;
(statearr_72637_72745[(1)] = (3));

} else {
var statearr_72638_72746 = state_72634__$1;
(statearr_72638_72746[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72635 === (3))){
var inst_72623 = (state_72634[(7)]);
var inst_72626 = cljs.core.ex_message(inst_72623);
var inst_72627 = cljs.core.ex_data(inst_72623);
var inst_72628 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_72626,inst_72627], 0));
var state_72634__$1 = state_72634;
var statearr_72639_72747 = state_72634__$1;
(statearr_72639_72747[(2)] = inst_72628);

(statearr_72639_72747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72635 === (4))){
var inst_72630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_72741);
var state_72634__$1 = state_72634;
var statearr_72640_72748 = state_72634__$1;
(statearr_72640_72748[(2)] = inst_72630);

(statearr_72640_72748[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72635 === (5))){
var inst_72632 = (state_72634[(2)]);
var state_72634__$1 = state_72634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72634__$1,inst_72632);
} else {
return null;
}
}
}
}
}
});})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734))
;
return ((function (seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,switch__11409__auto__,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0 = (function (){
var statearr_72641 = [null,null,null,null,null,null,null,null];
(statearr_72641[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__);

(statearr_72641[(1)] = (1));

return statearr_72641;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1 = (function (state_72634){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72634);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72642){var ex__11413__auto__ = e72642;
var statearr_72643_72749 = state_72634;
(statearr_72643_72749[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72634[(4)]))){
var statearr_72644_72750 = state_72634;
(statearr_72644_72750[(1)] = cljs.core.first((state_72634[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72751 = state_72634;
state_72634 = G__72751;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = function(state_72634){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1.call(this,state_72634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__;
})()
;})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,switch__11409__auto__,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734))
})();
var state__11486__auto__ = (function (){var statearr_72645 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72645[(6)] = c__11484__auto___72744);

return statearr_72645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});})(seq__72546_72715,chunk__72547_72716,count__72548_72717,i__72549_72718,c__11484__auto___72744,healthcheck_uri_72742,resp_chan_72743,server_72741,seq__72546_72735__$1,temp__5753__auto___72734))
);



var G__72752 = cljs.core.next(seq__72546_72735__$1);
var G__72753 = null;
var G__72754 = (0);
var G__72755 = (0);
seq__72546_72715 = G__72752;
chunk__72547_72716 = G__72753;
count__72548_72717 = G__72754;
i__72549_72718 = G__72755;
continue;
}
} else {
}
}
break;
}

var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_72689){
var state_val_72690 = (state_72689[(1)]);
if((state_val_72690 === (7))){
var inst_72661 = (state_72689[(7)]);
var inst_72668 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72661,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_72689__$1 = state_72689;
if(inst_72668){
var statearr_72691_72756 = state_72689__$1;
(statearr_72691_72756[(1)] = (9));

} else {
var statearr_72692_72757 = state_72689__$1;
(statearr_72692_72757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (1))){
var inst_72653 = (state_72689[(8)]);
var inst_72654 = (state_72689[(9)]);
var inst_72653__$1 = promise_chan;
var inst_72654__$1 = cljs.core.async.timeout((60000));
var inst_72655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72656 = [inst_72653__$1,inst_72654__$1];
var inst_72657 = (new cljs.core.PersistentVector(null,2,(5),inst_72655,inst_72656,null));
var state_72689__$1 = (function (){var statearr_72693 = state_72689;
(statearr_72693[(8)] = inst_72653__$1);

(statearr_72693[(9)] = inst_72654__$1);

return statearr_72693;
})();
return cljs.core.async.ioc_alts_BANG_(state_72689__$1,(2),inst_72657);
} else {
if((state_val_72690 === (4))){
var inst_72661 = (state_72689[(7)]);
var inst_72654 = (state_72689[(9)]);
var inst_72665 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72661,inst_72654);
var state_72689__$1 = state_72689;
if(inst_72665){
var statearr_72694_72758 = state_72689__$1;
(statearr_72694_72758[(1)] = (6));

} else {
var statearr_72695_72759 = state_72689__$1;
(statearr_72695_72759[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (13))){
var state_72689__$1 = state_72689;
var statearr_72696_72760 = state_72689__$1;
(statearr_72696_72760[(2)] = null);

(statearr_72696_72760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (6))){
var state_72689__$1 = state_72689;
var statearr_72697_72761 = state_72689__$1;
(statearr_72697_72761[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_72697_72761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (3))){
var state_72689__$1 = state_72689;
var statearr_72698_72762 = state_72689__$1;
(statearr_72698_72762[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_72698_72762[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (12))){
var inst_72679 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_72680 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72681 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_72682 = cljs.core.PersistentHashMap.fromArrays(inst_72680,inst_72681);
var inst_72683 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_72682);
var inst_72684 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_72683);
var state_72689__$1 = (function (){var statearr_72699 = state_72689;
(statearr_72699[(10)] = inst_72679);

return statearr_72699;
})();
var statearr_72700_72763 = state_72689__$1;
(statearr_72700_72763[(2)] = inst_72684);

(statearr_72700_72763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (2))){
var inst_72661 = (state_72689[(7)]);
var inst_72653 = (state_72689[(8)]);
var inst_72659 = (state_72689[(2)]);
var inst_72660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72659,(0),null);
var inst_72661__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72659,(1),null);
var inst_72662 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72661__$1,inst_72653);
var state_72689__$1 = (function (){var statearr_72701 = state_72689;
(statearr_72701[(11)] = inst_72660);

(statearr_72701[(7)] = inst_72661__$1);

return statearr_72701;
})();
if(inst_72662){
var statearr_72702_72764 = state_72689__$1;
(statearr_72702_72764[(1)] = (3));

} else {
var statearr_72703_72765 = state_72689__$1;
(statearr_72703_72765[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (11))){
var inst_72672 = (state_72689[(2)]);
var state_72689__$1 = state_72689;
var statearr_72704_72766 = state_72689__$1;
(statearr_72704_72766[(2)] = inst_72672);

(statearr_72704_72766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (9))){
var inst_72660 = (state_72689[(11)]);
var state_72689__$1 = state_72689;
var statearr_72705_72767 = state_72689__$1;
(statearr_72705_72767[(2)] = inst_72660);

(statearr_72705_72767[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (5))){
var inst_72676 = (state_72689[(2)]);
var inst_72677 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_72676);
var state_72689__$1 = state_72689;
if(inst_72677){
var statearr_72706_72768 = state_72689__$1;
(statearr_72706_72768[(1)] = (12));

} else {
var statearr_72707_72769 = state_72689__$1;
(statearr_72707_72769[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (14))){
var inst_72687 = (state_72689[(2)]);
var state_72689__$1 = state_72689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72689__$1,inst_72687);
} else {
if((state_val_72690 === (10))){
var state_72689__$1 = state_72689;
var statearr_72708_72770 = state_72689__$1;
(statearr_72708_72770[(2)] = null);

(statearr_72708_72770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72690 === (8))){
var inst_72674 = (state_72689[(2)]);
var state_72689__$1 = state_72689;
var statearr_72709_72771 = state_72689__$1;
(statearr_72709_72771[(2)] = inst_72674);

(statearr_72709_72771[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0 = (function (){
var statearr_72710 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72710[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__);

(statearr_72710[(1)] = (1));

return statearr_72710;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1 = (function (state_72689){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72689);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72711){var ex__11413__auto__ = e72711;
var statearr_72712_72772 = state_72689;
(statearr_72712_72772[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72689[(4)]))){
var statearr_72713_72773 = state_72689;
(statearr_72713_72773[(1)] = cljs.core.first((state_72689[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72774 = state_72689;
state_72689 = G__72774;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__ = function(state_72689){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1.call(this,state_72689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_72714 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72714[(6)] = c__11484__auto__);

return statearr_72714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_72818){
var state_val_72819 = (state_72818[(1)]);
if((state_val_72819 === (7))){
var state_72818__$1 = state_72818;
var statearr_72820_72846 = state_72818__$1;
(statearr_72820_72846[(2)] = null);

(statearr_72820_72846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (1))){
var state_72818__$1 = state_72818;
var statearr_72821_72847 = state_72818__$1;
(statearr_72821_72847[(2)] = null);

(statearr_72821_72847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (4))){
var inst_72775 = (state_72818[(2)]);
var state_72818__$1 = state_72818;
var statearr_72822_72848 = state_72818__$1;
(statearr_72822_72848[(2)] = inst_72775);

(statearr_72822_72848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (6))){
var inst_72797 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_72818__$1 = state_72818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72818__$1,(9),inst_72797);
} else {
if((state_val_72819 === (3))){
var inst_72816 = (state_72818[(2)]);
var state_72818__$1 = state_72818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72818__$1,inst_72816);
} else {
if((state_val_72819 === (12))){
var inst_72810 = (state_72818[(2)]);
var state_72818__$1 = state_72818;
var statearr_72823_72849 = state_72818__$1;
(statearr_72823_72849[(2)] = inst_72810);

(statearr_72823_72849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (2))){
var inst_72781 = (state_72818[(7)]);
var inst_72791 = (state_72818[(8)]);
var inst_72786 = (state_72818[(9)]);
var _ = (function (){var statearr_72824 = state_72818;
(statearr_72824[(4)] = cljs.core.cons((5),(state_72818[(4)])));

return statearr_72824;
})();
var inst_72781__$1 = fluree.db.util.core.random_uuid();
var inst_72782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72783 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_72784 = (new cljs.core.PersistentVector(null,2,(5),inst_72782,inst_72783,null));
var inst_72785 = (function (){var lock_id = inst_72781__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_72786__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_72784,inst_72785);
var inst_72787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72788 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_72789 = (new cljs.core.PersistentVector(null,3,(5),inst_72787,inst_72788,null));
var inst_72790 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72786__$1,inst_72789);
var inst_72791__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72781__$1,inst_72790);
var inst_72792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72793 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72794 = (new cljs.core.PersistentVector(null,3,(5),inst_72792,inst_72793,null));
var inst_72795 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72786__$1,inst_72794);
var state_72818__$1 = (function (){var statearr_72825 = state_72818;
(statearr_72825[(7)] = inst_72781__$1);

(statearr_72825[(10)] = inst_72795);

(statearr_72825[(8)] = inst_72791__$1);

(statearr_72825[(9)] = inst_72786__$1);

return statearr_72825;
})();
if(inst_72791__$1){
var statearr_72826_72850 = state_72818__$1;
(statearr_72826_72850[(1)] = (6));

} else {
var statearr_72827_72851 = state_72818__$1;
(statearr_72827_72851[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (11))){
var inst_72801 = (state_72818[(11)]);
var inst_72795 = (state_72818[(10)]);
var inst_72802 = (state_72818[(12)]);
var inst_72808 = fluree.db.util.xhttp.try_socket(inst_72801,sub_chan,pub_chan,inst_72795,(60000),inst_72802);
var state_72818__$1 = state_72818;
var statearr_72829_72852 = state_72818__$1;
(statearr_72829_72852[(2)] = inst_72808);

(statearr_72829_72852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (9))){
var inst_72799 = (state_72818[(13)]);
var inst_72801 = (state_72818[(11)]);
var inst_72781 = (state_72818[(7)]);
var inst_72795 = (state_72818[(10)]);
var inst_72791 = (state_72818[(8)]);
var inst_72786 = (state_72818[(9)]);
var inst_72799__$1 = (state_72818[(2)]);
var inst_72800 = clojure.string.replace(inst_72799__$1,"http","ws");
var inst_72801__$1 = [inst_72800,"/fdb/ws"].join('');
var inst_72802 = (function (){var lock_id = inst_72781;
var state = inst_72786;
var have_lock_QMARK_ = inst_72791;
var resp_chan = inst_72795;
var healthy_server = inst_72799__$1;
var ws_url = inst_72801__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_72803 = fluree.db.util.core.exception_QMARK_(inst_72799__$1);
var state_72818__$1 = (function (){var statearr_72830 = state_72818;
(statearr_72830[(13)] = inst_72799__$1);

(statearr_72830[(11)] = inst_72801__$1);

(statearr_72830[(12)] = inst_72802);

return statearr_72830;
})();
if(inst_72803){
var statearr_72831_72853 = state_72818__$1;
(statearr_72831_72853[(1)] = (10));

} else {
var statearr_72832_72854 = state_72818__$1;
(statearr_72832_72854[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (5))){
var _ = (function (){var statearr_72833 = state_72818;
(statearr_72833[(4)] = cljs.core.rest((state_72818[(4)])));

return statearr_72833;
})();
var state_72818__$1 = state_72818;
var ex72828 = (state_72818__$1[(2)]);
var statearr_72834_72855 = state_72818__$1;
(statearr_72834_72855[(5)] = ex72828);


if((ex72828 instanceof Error)){
var statearr_72835_72856 = state_72818__$1;
(statearr_72835_72856[(1)] = (4));

(statearr_72835_72856[(5)] = null);

} else {
throw ex72828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (10))){
var inst_72799 = (state_72818[(13)]);
var inst_72795 = (state_72818[(10)]);
var inst_72805 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_72806 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_72795,inst_72799);
var state_72818__$1 = (function (){var statearr_72836 = state_72818;
(statearr_72836[(14)] = inst_72805);

return statearr_72836;
})();
var statearr_72837_72857 = state_72818__$1;
(statearr_72837_72857[(2)] = inst_72806);

(statearr_72837_72857[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72819 === (8))){
var inst_72795 = (state_72818[(10)]);
var inst_72813 = (state_72818[(2)]);
var _ = (function (){var statearr_72838 = state_72818;
(statearr_72838[(4)] = cljs.core.rest((state_72818[(4)])));

return statearr_72838;
})();
var state_72818__$1 = (function (){var statearr_72839 = state_72818;
(statearr_72839[(15)] = inst_72813);

return statearr_72839;
})();
var statearr_72840_72858 = state_72818__$1;
(statearr_72840_72858[(2)] = inst_72795);

(statearr_72840_72858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__11410__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__11410__auto____0 = (function (){
var statearr_72841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72841[(0)] = fluree$db$connection$establish_socket_$_state_machine__11410__auto__);

(statearr_72841[(1)] = (1));

return statearr_72841;
});
var fluree$db$connection$establish_socket_$_state_machine__11410__auto____1 = (function (state_72818){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72818);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72842){var ex__11413__auto__ = e72842;
var statearr_72843_72859 = state_72818;
(statearr_72843_72859[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72818[(4)]))){
var statearr_72844_72860 = state_72818;
(statearr_72844_72860[(1)] = cljs.core.first((state_72818[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72861 = state_72818;
state_72818 = G__72861;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__11410__auto__ = function(state_72818){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__11410__auto____1.call(this,state_72818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__11410__auto____0;
fluree$db$connection$establish_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__11410__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_72845 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72845[(6)] = c__11484__auto__);

return statearr_72845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k72863,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__72867 = k72863;
var G__72867__$1 = (((G__72867 instanceof cljs.core.Keyword))?G__72867.fqn:null);
switch (G__72867__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k72863,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__72868){
var vec__72869 = p__72868;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72869,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72869,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__72862){
var self__ = this;
var G__72862__$1 = this;
return (new cljs.core.RecordIter((0),G__72862__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__72872 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__72872(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this72864,other72865){
var self__ = this;
var this72864__$1 = this;
return (((!((other72865 == null)))) && ((((this72864__$1.constructor === other72865.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.id,other72865.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.servers,other72865.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.state,other72865.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.req_chan,other72865.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.sub_chan,other72865.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.pub_chan,other72865.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.group,other72865.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.storage_read,other72865.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.storage_write,other72865.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.object_cache,other72865.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.parallelism,other72865.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.serializer,other72865.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.default_network,other72865.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.transactor_QMARK_,other72865.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.publish,other72865.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.transact_handler,other72865.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.tx_private_key,other72865.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.tx_key_id,other72865.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.meta,other72865.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.add_listener,other72865.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.remove_listener,other72865.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.close,other72865.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this72864__$1.__extmap,other72865.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k72863){
var self__ = this;
var this__4509__auto____$1 = this;
var G__72873 = k72863;
var G__72873__$1 = (((G__72873 instanceof cljs.core.Keyword))?G__72873.fqn:null);
switch (G__72873__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k72863);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__72862){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__72874 = cljs.core.keyword_identical_QMARK_;
var expr__72875 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__72877 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__72878 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72877,G__72878) : pred__72874.call(null,G__72877,G__72878));
})())){
return (new fluree.db.connection.Connection(G__72862,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72879 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__72880 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72879,G__72880) : pred__72874.call(null,G__72879,G__72880));
})())){
return (new fluree.db.connection.Connection(self__.id,G__72862,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72881 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__72882 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72881,G__72882) : pred__72874.call(null,G__72881,G__72882));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__72862,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72883 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__72884 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72883,G__72884) : pred__72874.call(null,G__72883,G__72884));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__72862,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72885 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__72886 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72885,G__72886) : pred__72874.call(null,G__72885,G__72886));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__72862,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72887 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__72888 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72887,G__72888) : pred__72874.call(null,G__72887,G__72888));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__72862,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72889 = new cljs.core.Keyword(null,"group","group",582596132);
var G__72890 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72889,G__72890) : pred__72874.call(null,G__72889,G__72890));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__72862,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72891 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__72892 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72891,G__72892) : pred__72874.call(null,G__72891,G__72892));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__72862,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72893 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__72894 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72893,G__72894) : pred__72874.call(null,G__72893,G__72894));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__72862,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72895 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__72896 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72895,G__72896) : pred__72874.call(null,G__72895,G__72896));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__72862,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72897 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__72898 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72897,G__72898) : pred__72874.call(null,G__72897,G__72898));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__72862,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72899 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__72900 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72899,G__72900) : pred__72874.call(null,G__72899,G__72900));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__72862,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72901 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__72902 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72901,G__72902) : pred__72874.call(null,G__72901,G__72902));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__72862,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72903 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__72904 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72903,G__72904) : pred__72874.call(null,G__72903,G__72904));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__72862,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72905 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__72906 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72905,G__72906) : pred__72874.call(null,G__72905,G__72906));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__72862,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72907 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__72908 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72907,G__72908) : pred__72874.call(null,G__72907,G__72908));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__72862,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72909 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__72910 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72909,G__72910) : pred__72874.call(null,G__72909,G__72910));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__72862,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72911 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__72912 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72911,G__72912) : pred__72874.call(null,G__72911,G__72912));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__72862,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72913 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__72914 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72913,G__72914) : pred__72874.call(null,G__72913,G__72914));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__72862,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72915 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__72916 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72915,G__72916) : pred__72874.call(null,G__72915,G__72916));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__72862,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72917 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__72918 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72917,G__72918) : pred__72874.call(null,G__72917,G__72918));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__72862,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__72919 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__72920 = expr__72875;
return (pred__72874.cljs$core$IFn$_invoke$arity$2 ? pred__72874.cljs$core$IFn$_invoke$arity$2(G__72919,G__72920) : pred__72874.call(null,G__72919,G__72920));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__72862,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__72862),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__72862){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__72862,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__72866){
var extmap__4542__auto__ = (function (){var G__72921 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__72866,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__72866)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__72921);
} else {
return G__72921;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__72866),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__72866),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__72927 = servers_STAR_;
var vec__72928 = G__72927;
var seq__72929 = cljs.core.seq(vec__72928);
var first__72930 = cljs.core.first(seq__72929);
var seq__72929__$1 = cljs.core.next(seq__72929);
var server = first__72930;
var r = seq__72929__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__72927__$1 = G__72927;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__72934 = G__72927__$1;
var seq__72935 = cljs.core.seq(vec__72934);
var first__72936 = cljs.core.first(seq__72935);
var seq__72935__$1 = cljs.core.next(seq__72935);
var server__$1 = first__72936;
var r__$1 = seq__72935__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__72937 = r__$1;
var G__72938 = is_https_QMARK_;
var G__72939 = result_STAR_;
G__72927__$1 = G__72937;
https_QMARK___$1 = G__72938;
result__$1 = G__72939;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__72940 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__72940 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__72940);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_72969){
var state_val_72970 = (state_72969[(1)]);
if((state_val_72970 === (7))){
var inst_72955 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72956 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72957 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72958 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72959 = fluree.db.connection.establish_socket(inst_72955,inst_72956,inst_72957,inst_72958);
var state_72969__$1 = state_72969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72969__$1,(9),inst_72959);
} else {
if((state_val_72970 === (1))){
var state_72969__$1 = state_72969;
var statearr_72971_72990 = state_72969__$1;
(statearr_72971_72990[(2)] = null);

(statearr_72971_72990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (4))){
var inst_72941 = (state_72969[(2)]);
var state_72969__$1 = state_72969;
var statearr_72972_72991 = state_72969__$1;
(statearr_72972_72991[(2)] = inst_72941);

(statearr_72972_72991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (6))){
var inst_72952 = (state_72969[(7)]);
var state_72969__$1 = state_72969;
var statearr_72973_72992 = state_72969__$1;
(statearr_72973_72992[(2)] = inst_72952);

(statearr_72973_72992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (3))){
var inst_72967 = (state_72969[(2)]);
var state_72969__$1 = state_72969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72969__$1,inst_72967);
} else {
if((state_val_72970 === (2))){
var inst_72952 = (state_72969[(7)]);
var _ = (function (){var statearr_72975 = state_72969;
(statearr_72975[(4)] = cljs.core.cons((5),(state_72969[(4)])));

return statearr_72975;
})();
var inst_72947 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_72948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72949 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72950 = [inst_72949,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_72951 = (new cljs.core.PersistentVector(null,3,(5),inst_72948,inst_72950,null));
var inst_72952__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72947,inst_72951);
var state_72969__$1 = (function (){var statearr_72976 = state_72969;
(statearr_72976[(7)] = inst_72952__$1);

return statearr_72976;
})();
if(cljs.core.truth_(inst_72952__$1)){
var statearr_72977_72993 = state_72969__$1;
(statearr_72977_72993[(1)] = (6));

} else {
var statearr_72978_72994 = state_72969__$1;
(statearr_72978_72994[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (9))){
var inst_72961 = (state_72969[(2)]);
var inst_72962 = fluree.db.util.async.throw_err(inst_72961);
var state_72969__$1 = state_72969;
var statearr_72979_72995 = state_72969__$1;
(statearr_72979_72995[(2)] = inst_72962);

(statearr_72979_72995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (5))){
var _ = (function (){var statearr_72980 = state_72969;
(statearr_72980[(4)] = cljs.core.rest((state_72969[(4)])));

return statearr_72980;
})();
var state_72969__$1 = state_72969;
var ex72974 = (state_72969__$1[(2)]);
var statearr_72981_72996 = state_72969__$1;
(statearr_72981_72996[(5)] = ex72974);


if((ex72974 instanceof Error)){
var statearr_72982_72997 = state_72969__$1;
(statearr_72982_72997[(1)] = (4));

(statearr_72982_72997[(5)] = null);

} else {
throw ex72974;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72970 === (8))){
var inst_72964 = (state_72969[(2)]);
var _ = (function (){var statearr_72983 = state_72969;
(statearr_72983[(4)] = cljs.core.rest((state_72969[(4)])));

return statearr_72983;
})();
var state_72969__$1 = state_72969;
var statearr_72984_72998 = state_72969__$1;
(statearr_72984_72998[(2)] = inst_72964);

(statearr_72984_72998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__11410__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__11410__auto____0 = (function (){
var statearr_72985 = [null,null,null,null,null,null,null,null];
(statearr_72985[(0)] = fluree$db$connection$get_socket_$_state_machine__11410__auto__);

(statearr_72985[(1)] = (1));

return statearr_72985;
});
var fluree$db$connection$get_socket_$_state_machine__11410__auto____1 = (function (state_72969){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72969);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72986){var ex__11413__auto__ = e72986;
var statearr_72987_72999 = state_72969;
(statearr_72987_72999[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72969[(4)]))){
var statearr_72988_73000 = state_72969;
(statearr_72988_73000[(1)] = cljs.core.first((state_72969[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73001 = state_72969;
state_72969 = G__73001;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__11410__auto__ = function(state_72969){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__11410__auto____1.call(this,state_72969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__11410__auto____0;
fluree$db$connection$get_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__11410__auto____1;
return fluree$db$connection$get_socket_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_72989 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72989[(6)] = c__11484__auto__);

return statearr_72989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e73002){var e = e73002;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73129){
var state_val_73130 = (state_73129[(1)]);
if((state_val_73130 === (7))){
var inst_73125 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
var statearr_73132_73202 = state_73129__$1;
(statearr_73132_73202[(2)] = inst_73125);

(statearr_73132_73202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (20))){
var _ = (function (){var statearr_73133 = state_73129;
(statearr_73133[(4)] = cljs.core.rest((state_73129[(4)])));

return statearr_73133;
})();
var state_73129__$1 = state_73129;
var ex73131 = (state_73129__$1[(2)]);
var statearr_73134_73203 = state_73129__$1;
(statearr_73134_73203[(5)] = ex73131);


var statearr_73135_73204 = state_73129__$1;
(statearr_73135_73204[(1)] = (10));

(statearr_73135_73204[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (27))){
var inst_73117 = (state_73129[(2)]);
var _ = (function (){var statearr_73136 = state_73129;
(statearr_73136[(4)] = cljs.core.rest((state_73129[(4)])));

return statearr_73136;
})();
var state_73129__$1 = state_73129;
var statearr_73137_73205 = state_73129__$1;
(statearr_73137_73205[(2)] = inst_73117);

(statearr_73137_73205[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (1))){
var inst_73004 = (0);
var state_73129__$1 = (function (){var statearr_73138 = state_73129;
(statearr_73138[(7)] = inst_73004);

return statearr_73138;
})();
var statearr_73139_73206 = state_73129__$1;
(statearr_73139_73206[(2)] = null);

(statearr_73139_73206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (24))){
var inst_73095 = (state_73129[(8)]);
var inst_73095__$1 = (state_73129[(2)]);
var inst_73096 = inst_73095__$1 === true;
var state_73129__$1 = (function (){var statearr_73140 = state_73129;
(statearr_73140[(8)] = inst_73095__$1);

return statearr_73140;
})();
if(cljs.core.truth_(inst_73096)){
var statearr_73141_73207 = state_73129__$1;
(statearr_73141_73207[(1)] = (25));

} else {
var statearr_73142_73208 = state_73129__$1;
(statearr_73142_73208[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (4))){
var inst_73007 = (state_73129[(9)]);
var inst_73007__$1 = (state_73129[(2)]);
var state_73129__$1 = (function (){var statearr_73143 = state_73129;
(statearr_73143[(9)] = inst_73007__$1);

return statearr_73143;
})();
if(cljs.core.truth_(inst_73007__$1)){
var statearr_73144_73209 = state_73129__$1;
(statearr_73144_73209[(1)] = (5));

} else {
var statearr_73145_73210 = state_73129__$1;
(statearr_73145_73210[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (15))){
var inst_73020 = (state_73129[(10)]);
var state_73129__$1 = state_73129;
var statearr_73146_73211 = state_73129__$1;
(statearr_73146_73211[(2)] = inst_73020);

(statearr_73146_73211[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (21))){
var inst_73051 = (state_73129[(11)]);
var inst_73046 = (state_73129[(12)]);
var inst_73052 = (state_73129[(13)]);
var inst_73007 = (state_73129[(9)]);
var inst_73047 = (state_73129[(14)]);
var inst_73043 = (state_73129[(15)]);
var inst_73044 = (state_73129[(16)]);
var inst_73045 = (state_73129[(17)]);
var inst_73048 = (state_73129[(18)]);
var inst_73004 = (state_73129[(7)]);
var inst_73054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73055 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73051];
var inst_73056 = (new cljs.core.PersistentVector(null,2,(5),inst_73054,inst_73055,null));
var inst_73057 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_73056,inst_73046);
var inst_73084 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_73085 = (function (){var resp_chan = inst_73046;
var timeout = inst_73052;
var map__73042 = inst_73048;
var i = inst_73004;
var data = inst_73045;
var vec__73039 = inst_73007;
var c__11484__auto____$1 = inst_73084;
var _ = inst_73043;
var req_id = inst_73051;
var operation = inst_73044;
var msg = inst_73007;
var opts = inst_73047;
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73082){
var state_val_73083 = (state_73082[(1)]);
if((state_val_73083 === (1))){
var inst_73061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73062 = cljs.core.async.timeout(timeout);
var inst_73063 = [resp_chan,inst_73062];
var inst_73064 = (new cljs.core.PersistentVector(null,2,(5),inst_73061,inst_73063,null));
var state_73082__$1 = state_73082;
return cljs.core.async.ioc_alts_BANG_(state_73082__$1,(2),inst_73064);
} else {
if((state_val_73083 === (2))){
var inst_73067 = (state_73082[(7)]);
var inst_73066 = (state_73082[(2)]);
var inst_73067__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73066,(0),null);
var inst_73068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73066,(1),null);
var inst_73069 = (function (){var vec__73058 = inst_73066;
var resp = inst_73067__$1;
var c = inst_73068;
return (function (p1__73003_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__73003_SHARP_,req_id);
});
})();
var inst_73070 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73069);
var inst_73071 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73068,resp_chan);
var state_73082__$1 = (function (){var statearr_73147 = state_73082;
(statearr_73147[(7)] = inst_73067__$1);

(statearr_73147[(8)] = inst_73070);

return statearr_73147;
})();
if(inst_73071){
var statearr_73148_73212 = state_73082__$1;
(statearr_73148_73212[(1)] = (3));

} else {
var statearr_73149_73213 = state_73082__$1;
(statearr_73149_73213[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73083 === (3))){
var inst_73067 = (state_73082[(7)]);
var state_73082__$1 = state_73082;
var statearr_73150_73214 = state_73082__$1;
(statearr_73150_73214[(2)] = inst_73067);

(statearr_73150_73214[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73083 === (4))){
var inst_73074 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_73075 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73076 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73077 = cljs.core.PersistentHashMap.fromArrays(inst_73075,inst_73076);
var inst_73078 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73074,inst_73077);
var state_73082__$1 = state_73082;
var statearr_73151_73215 = state_73082__$1;
(statearr_73151_73215[(2)] = inst_73078);

(statearr_73151_73215[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73083 === (5))){
var inst_73080 = (state_73082[(2)]);
var state_73082__$1 = state_73082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73082__$1,inst_73080);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11410__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11410__auto____0 = (function (){
var statearr_73152 = [null,null,null,null,null,null,null,null,null];
(statearr_73152[(0)] = fluree$db$connection$msg_producer_$_state_machine__11410__auto__);

(statearr_73152[(1)] = (1));

return statearr_73152;
});
var fluree$db$connection$msg_producer_$_state_machine__11410__auto____1 = (function (state_73082){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73082);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73153){var ex__11413__auto__ = e73153;
var statearr_73154_73216 = state_73082;
(statearr_73154_73216[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73082[(4)]))){
var statearr_73155_73217 = state_73082;
(statearr_73155_73217[(1)] = cljs.core.first((state_73082[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73218 = state_73082;
state_73082 = G__73218;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11410__auto__ = function(state_73082){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11410__auto____1.call(this,state_73082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11410__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11410__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73156 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73156[(6)] = c__11484__auto____$1);

return statearr_73156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});
})();
var inst_73086 = cljs.core.async.impl.dispatch.run(inst_73085);
var state_73129__$1 = (function (){var statearr_73157 = state_73129;
(statearr_73157[(19)] = inst_73057);

(statearr_73157[(20)] = inst_73086);

return statearr_73157;
})();
var statearr_73158_73219 = state_73129__$1;
(statearr_73158_73219[(2)] = inst_73084);

(statearr_73158_73219[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (31))){
var inst_73105 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_73129__$1 = state_73129;
var statearr_73159_73220 = state_73129__$1;
(statearr_73159_73220[(2)] = inst_73105);

(statearr_73159_73220[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (32))){
var state_73129__$1 = state_73129;
var statearr_73160_73221 = state_73129__$1;
(statearr_73160_73221[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (33))){
var inst_73113 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
var statearr_73162_73222 = state_73129__$1;
(statearr_73162_73222[(2)] = inst_73113);

(statearr_73162_73222[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (13))){
var inst_73020 = (state_73129[(10)]);
var inst_73017 = (state_73129[(2)]);
var inst_73018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73017,(0),null);
var inst_73019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73017,(1),null);
var inst_73020__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73017,(2),null);
var state_73129__$1 = (function (){var statearr_73163 = state_73129;
(statearr_73163[(21)] = inst_73019);

(statearr_73163[(10)] = inst_73020__$1);

(statearr_73163[(22)] = inst_73018);

return statearr_73163;
})();
if(cljs.core.truth_(inst_73020__$1)){
var statearr_73164_73223 = state_73129__$1;
(statearr_73164_73223[(1)] = (14));

} else {
var statearr_73165_73224 = state_73129__$1;
(statearr_73165_73224[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (22))){
var state_73129__$1 = state_73129;
var statearr_73166_73225 = state_73129__$1;
(statearr_73166_73225[(2)] = null);

(statearr_73166_73225[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (36))){
var inst_73111 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
var statearr_73167_73226 = state_73129__$1;
(statearr_73167_73226[(2)] = inst_73111);

(statearr_73167_73226[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (29))){
var inst_73095 = (state_73129[(8)]);
var inst_73103 = (inst_73095 == null);
var state_73129__$1 = state_73129;
if(cljs.core.truth_(inst_73103)){
var statearr_73168_73227 = state_73129__$1;
(statearr_73168_73227[(1)] = (31));

} else {
var statearr_73169_73228 = state_73129__$1;
(statearr_73169_73228[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (6))){
var state_73129__$1 = state_73129;
var statearr_73170_73229 = state_73129__$1;
(statearr_73170_73229[(2)] = null);

(statearr_73170_73229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (28))){
var inst_73095 = (state_73129[(8)]);
var inst_73101 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73095,"Error processing message in producer."], 0));
var state_73129__$1 = state_73129;
var statearr_73171_73230 = state_73129__$1;
(statearr_73171_73230[(2)] = inst_73101);

(statearr_73171_73230[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (25))){
var state_73129__$1 = state_73129;
var statearr_73172_73231 = state_73129__$1;
(statearr_73172_73231[(2)] = null);

(statearr_73172_73231[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (34))){
var inst_73095 = (state_73129[(8)]);
var inst_73108 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_73095], 0));
var state_73129__$1 = state_73129;
var statearr_73173_73232 = state_73129__$1;
(statearr_73173_73232[(2)] = inst_73108);

(statearr_73173_73232[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (17))){
var inst_73009 = (state_73129[(23)]);
var inst_73020 = (state_73129[(10)]);
var inst_73027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73020,inst_73009);
var state_73129__$1 = state_73129;
var statearr_73174_73233 = state_73129__$1;
(statearr_73174_73233[(2)] = inst_73027);

(statearr_73174_73233[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (3))){
var inst_73127 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73129__$1,inst_73127);
} else {
if((state_val_73130 === (12))){
var state_73129__$1 = state_73129;
var statearr_73175_73234 = state_73129__$1;
(statearr_73175_73234[(2)] = null);

(statearr_73175_73234[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (2))){
var state_73129__$1 = state_73129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73129__$1,(4),req_chan);
} else {
if((state_val_73130 === (23))){
var inst_73051 = (state_73129[(11)]);
var inst_73044 = (state_73129[(16)]);
var inst_73045 = (state_73129[(17)]);
var inst_73089 = (state_73129[(2)]);
var inst_73090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73091 = [inst_73044,inst_73051,inst_73045];
var inst_73092 = (new cljs.core.PersistentVector(null,3,(5),inst_73090,inst_73091,null));
var inst_73093 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_73092) : publish_fn.call(null,conn,inst_73092));
var state_73129__$1 = (function (){var statearr_73176 = state_73129;
(statearr_73176[(24)] = inst_73089);

return statearr_73176;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73129__$1,(24),inst_73093);
} else {
if((state_val_73130 === (35))){
var state_73129__$1 = state_73129;
var statearr_73177_73235 = state_73129__$1;
(statearr_73177_73235[(2)] = null);

(statearr_73177_73235[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (19))){
var inst_73033 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
var statearr_73178_73236 = state_73129__$1;
(statearr_73178_73236[(2)] = inst_73033);

(statearr_73178_73236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (11))){
var inst_73007 = (state_73129[(9)]);
var state_73129__$1 = state_73129;
var statearr_73179_73237 = state_73129__$1;
(statearr_73179_73237[(2)] = inst_73007);

(statearr_73179_73237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (9))){
var inst_73004 = (state_73129[(7)]);
var inst_73120 = (state_73129[(2)]);
var inst_73121 = (inst_73004 + (1));
var inst_73004__$1 = inst_73121;
var state_73129__$1 = (function (){var statearr_73180 = state_73129;
(statearr_73180[(25)] = inst_73120);

(statearr_73180[(7)] = inst_73004__$1);

return statearr_73180;
})();
var statearr_73181_73238 = state_73129__$1;
(statearr_73181_73238[(2)] = null);

(statearr_73181_73238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (5))){
var state_73129__$1 = state_73129;
var statearr_73182_73239 = state_73129__$1;
(statearr_73182_73239[(2)] = null);

(statearr_73182_73239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (14))){
var inst_73020 = (state_73129[(10)]);
var inst_73022 = fluree.db.util.async.channel_QMARK_(inst_73020);
var state_73129__$1 = state_73129;
var statearr_73183_73240 = state_73129__$1;
(statearr_73183_73240[(2)] = inst_73022);

(statearr_73183_73240[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (26))){
var inst_73095 = (state_73129[(8)]);
var inst_73099 = fluree.db.util.core.exception_QMARK_(inst_73095);
var state_73129__$1 = state_73129;
if(inst_73099){
var statearr_73184_73241 = state_73129__$1;
(statearr_73184_73241[(1)] = (28));

} else {
var statearr_73185_73242 = state_73129__$1;
(statearr_73185_73242[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (16))){
var inst_73025 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
if(cljs.core.truth_(inst_73025)){
var statearr_73186_73243 = state_73129__$1;
(statearr_73186_73243[(1)] = (17));

} else {
var statearr_73187_73244 = state_73129__$1;
(statearr_73187_73244[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (30))){
var inst_73115 = (state_73129[(2)]);
var state_73129__$1 = state_73129;
var statearr_73188_73245 = state_73129__$1;
(statearr_73188_73245[(2)] = inst_73115);

(statearr_73188_73245[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (10))){
var inst_73007 = (state_73129[(9)]);
var inst_73009 = (state_73129[(2)]);
var inst_73013 = cljs.core.sequential_QMARK_(inst_73007);
var state_73129__$1 = (function (){var statearr_73189 = state_73129;
(statearr_73189[(23)] = inst_73009);

return statearr_73189;
})();
if(inst_73013){
var statearr_73190_73246 = state_73129__$1;
(statearr_73190_73246[(1)] = (11));

} else {
var statearr_73191_73247 = state_73129__$1;
(statearr_73191_73247[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (18))){
var inst_73007 = (state_73129[(9)]);
var inst_73009 = (state_73129[(23)]);
var inst_73029 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73007], 0));
var inst_73030 = ["Error processing ledger request, no valid return channel: ",inst_73029].join('');
var inst_73031 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73009,inst_73030], 0));
var state_73129__$1 = state_73129;
var statearr_73192_73248 = state_73129__$1;
(statearr_73192_73248[(2)] = inst_73031);

(statearr_73192_73248[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73130 === (8))){
var inst_73046 = (state_73129[(12)]);
var inst_73007 = (state_73129[(9)]);
var inst_73047 = (state_73129[(14)]);
var inst_73048 = (state_73129[(18)]);
var _ = (function (){var statearr_73193 = state_73129;
(statearr_73193[(4)] = cljs.core.cons((20),(state_73129[(4)])));

return statearr_73193;
})();
var inst_73043 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_73007], 0));
var inst_73044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73007,(0),null);
var inst_73045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73007,(1),null);
var inst_73046__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73007,(2),null);
var inst_73047__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73007,(3),null);
var inst_73048__$1 = cljs.core.__destructure_map(inst_73047__$1);
var inst_73049 = fluree.db.util.core.random_uuid();
var inst_73050 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73049);
var inst_73051 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73048__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_73050);
var inst_73052 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73048__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_73129__$1 = (function (){var statearr_73194 = state_73129;
(statearr_73194[(11)] = inst_73051);

(statearr_73194[(12)] = inst_73046__$1);

(statearr_73194[(13)] = inst_73052);

(statearr_73194[(14)] = inst_73047__$1);

(statearr_73194[(15)] = inst_73043);

(statearr_73194[(16)] = inst_73044);

(statearr_73194[(17)] = inst_73045);

(statearr_73194[(18)] = inst_73048__$1);

return statearr_73194;
})();
if(cljs.core.truth_(inst_73046__$1)){
var statearr_73195_73249 = state_73129__$1;
(statearr_73195_73249[(1)] = (21));

} else {
var statearr_73196_73250 = state_73129__$1;
(statearr_73196_73250[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11410__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11410__auto____0 = (function (){
var statearr_73197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73197[(0)] = fluree$db$connection$msg_producer_$_state_machine__11410__auto__);

(statearr_73197[(1)] = (1));

return statearr_73197;
});
var fluree$db$connection$msg_producer_$_state_machine__11410__auto____1 = (function (state_73129){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73129);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73198){var ex__11413__auto__ = e73198;
var statearr_73199_73251 = state_73129;
(statearr_73199_73251[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73129[(4)]))){
var statearr_73200_73252 = state_73129;
(statearr_73200_73252[(1)] = cljs.core.first((state_73129[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73253 = state_73129;
state_73129 = G__73253;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11410__auto__ = function(state_73129){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11410__auto____1.call(this,state_73129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11410__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11410__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73201 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73201[(6)] = c__11484__auto__);

return statearr_73201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__73254 = conn;
var map__73254__$1 = cljs.core.__destructure_map(map__73254);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73254__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73339){
var state_val_73340 = (state_73339[(1)]);
if((state_val_73340 === (7))){
var inst_73335 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73341_73392 = state_73339__$1;
(statearr_73341_73392[(2)] = inst_73335);

(statearr_73341_73392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (20))){
var inst_73273 = (state_73339[(7)]);
var inst_73287 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_73288 = [inst_73273];
var inst_73289 = cljs.core.PersistentHashMap.fromArrays(inst_73287,inst_73288);
var inst_73290 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_73289], 0));
var state_73339__$1 = state_73339;
var statearr_73342_73393 = state_73339__$1;
(statearr_73342_73393[(2)] = inst_73290);

(statearr_73342_73393[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (27))){
var state_73339__$1 = state_73339;
var statearr_73343_73394 = state_73339__$1;
(statearr_73343_73394[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (1))){
var inst_73255 = (0);
var state_73339__$1 = (function (){var statearr_73345 = state_73339;
(statearr_73345[(8)] = inst_73255);

return statearr_73345;
})();
var statearr_73346_73395 = state_73339__$1;
(statearr_73346_73395[(2)] = null);

(statearr_73346_73395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (24))){
var inst_73266 = (state_73339[(9)]);
var inst_73315 = fluree.db.util.core.exception_QMARK_(inst_73266);
var state_73339__$1 = state_73339;
if(inst_73315){
var statearr_73347_73396 = state_73339__$1;
(statearr_73347_73396[(1)] = (26));

} else {
var statearr_73348_73397 = state_73339__$1;
(statearr_73348_73397[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (4))){
var inst_73260 = (state_73339[(10)]);
var inst_73265 = (state_73339[(2)]);
var inst_73266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73265,(0),null);
var inst_73267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73265,(1),null);
var inst_73268 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73267,inst_73260);
var state_73339__$1 = (function (){var statearr_73349 = state_73339;
(statearr_73349[(9)] = inst_73266);

return statearr_73349;
})();
if(inst_73268){
var statearr_73350_73398 = state_73339__$1;
(statearr_73350_73398[(1)] = (5));

} else {
var statearr_73351_73399 = state_73339__$1;
(statearr_73351_73399[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (15))){
var inst_73273 = (state_73339[(7)]);
var inst_73282 = typeof inst_73273 === 'string';
var state_73339__$1 = state_73339;
if(cljs.core.truth_(inst_73282)){
var statearr_73352_73400 = state_73339__$1;
(statearr_73352_73400[(1)] = (17));

} else {
var statearr_73353_73401 = state_73339__$1;
(statearr_73353_73401[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (21))){
var state_73339__$1 = state_73339;
var statearr_73354_73402 = state_73339__$1;
(statearr_73354_73402[(2)] = null);

(statearr_73354_73402[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (31))){
var inst_73329 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73355_73403 = state_73339__$1;
(statearr_73355_73403[(2)] = inst_73329);

(statearr_73355_73403[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (13))){
var inst_73299 = (state_73339[(2)]);
var inst_73300 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73301 = fluree.db.connection.close_websocket(inst_73300);
var inst_73302 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73303 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_73302);
var state_73339__$1 = (function (){var statearr_73356 = state_73339;
(statearr_73356[(11)] = inst_73299);

(statearr_73356[(12)] = inst_73301);

return statearr_73356;
})();
var statearr_73357_73404 = state_73339__$1;
(statearr_73357_73404[(2)] = inst_73303);

(statearr_73357_73404[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (22))){
var inst_73293 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73358_73405 = state_73339__$1;
(statearr_73358_73405[(2)] = inst_73293);

(statearr_73358_73405[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (29))){
var inst_73266 = (state_73339[(9)]);
var inst_73321 = fluree.db.util.json.parse(inst_73266);
var inst_73322 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73321], 0));
var inst_73323 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_73322], 0));
var inst_73324 = fluree.db.util.json.parse(inst_73266);
var inst_73325 = fluree.db.conn_events.process_events(conn,inst_73324);
var inst_73255 = (0);
var state_73339__$1 = (function (){var statearr_73359 = state_73339;
(statearr_73359[(13)] = inst_73323);

(statearr_73359[(14)] = inst_73325);

(statearr_73359[(8)] = inst_73255);

return statearr_73359;
})();
var statearr_73360_73406 = state_73339__$1;
(statearr_73360_73406[(2)] = null);

(statearr_73360_73406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (6))){
var inst_73266 = (state_73339[(9)]);
var inst_73311 = (inst_73266 == null);
var state_73339__$1 = state_73339;
if(cljs.core.truth_(inst_73311)){
var statearr_73361_73407 = state_73339__$1;
(statearr_73361_73407[(1)] = (23));

} else {
var statearr_73362_73408 = state_73339__$1;
(statearr_73362_73408[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (28))){
var inst_73331 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73363_73409 = state_73339__$1;
(statearr_73363_73409[(2)] = inst_73331);

(statearr_73363_73409[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (25))){
var inst_73333 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73364_73410 = state_73339__$1;
(statearr_73364_73410[(2)] = inst_73333);

(statearr_73364_73410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (17))){
var inst_73273 = (state_73339[(7)]);
var inst_73284 = cljs.core.eval(inst_73273);
var state_73339__$1 = state_73339;
var statearr_73365_73411 = state_73339__$1;
(statearr_73365_73411[(2)] = inst_73284);

(statearr_73365_73411[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (3))){
var inst_73337 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73339__$1,inst_73337);
} else {
if((state_val_73340 === (12))){
var inst_73273 = (state_73339[(7)]);
var inst_73278 = cljs.core.fn_QMARK_(inst_73273);
var state_73339__$1 = state_73339;
if(inst_73278){
var statearr_73366_73412 = state_73339__$1;
(statearr_73366_73412[(1)] = (14));

} else {
var statearr_73367_73413 = state_73339__$1;
(statearr_73367_73413[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (2))){
var inst_73260 = (state_73339[(10)]);
var inst_73260__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_73261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73262 = [sub_chan,inst_73260__$1];
var inst_73263 = (new cljs.core.PersistentVector(null,2,(5),inst_73261,inst_73262,null));
var state_73339__$1 = (function (){var statearr_73368 = state_73339;
(statearr_73368[(10)] = inst_73260__$1);

return statearr_73368;
})();
return cljs.core.async.ioc_alts_BANG_(state_73339__$1,(4),inst_73263);
} else {
if((state_val_73340 === (23))){
var inst_73313 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_73339__$1 = state_73339;
var statearr_73369_73414 = state_73339__$1;
(statearr_73369_73414[(2)] = inst_73313);

(statearr_73369_73414[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (19))){
var inst_73295 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73370_73415 = state_73339__$1;
(statearr_73370_73415[(2)] = inst_73295);

(statearr_73370_73415[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (11))){
var inst_73276 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_73339__$1 = state_73339;
var statearr_73371_73416 = state_73339__$1;
(statearr_73371_73416[(2)] = inst_73276);

(statearr_73371_73416[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (9))){
var inst_73255 = (state_73339[(8)]);
var inst_73305 = fluree.db.connection.ping_transactor(conn);
var inst_73306 = (inst_73255 + (1));
var inst_73255__$1 = inst_73306;
var state_73339__$1 = (function (){var statearr_73372 = state_73339;
(statearr_73372[(15)] = inst_73305);

(statearr_73372[(8)] = inst_73255__$1);

return statearr_73372;
})();
var statearr_73373_73417 = state_73339__$1;
(statearr_73373_73417[(2)] = null);

(statearr_73373_73417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (5))){
var inst_73255 = (state_73339[(8)]);
var inst_73270 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_73255);
var state_73339__$1 = state_73339;
if(inst_73270){
var statearr_73374_73418 = state_73339__$1;
(statearr_73374_73418[(1)] = (8));

} else {
var statearr_73375_73419 = state_73339__$1;
(statearr_73375_73419[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (14))){
var inst_73273 = (state_73339[(7)]);
var inst_73280 = (inst_73273.cljs$core$IFn$_invoke$arity$0 ? inst_73273.cljs$core$IFn$_invoke$arity$0() : inst_73273.call(null));
var state_73339__$1 = state_73339;
var statearr_73376_73420 = state_73339__$1;
(statearr_73376_73420[(2)] = inst_73280);

(statearr_73376_73420[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (26))){
var inst_73266 = (state_73339[(9)]);
var inst_73317 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73266], 0));
var inst_73255 = (0);
var state_73339__$1 = (function (){var statearr_73377 = state_73339;
(statearr_73377[(16)] = inst_73317);

(statearr_73377[(8)] = inst_73255);

return statearr_73377;
})();
var statearr_73378_73421 = state_73339__$1;
(statearr_73378_73421[(2)] = null);

(statearr_73378_73421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (16))){
var inst_73297 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73379_73422 = state_73339__$1;
(statearr_73379_73422[(2)] = inst_73297);

(statearr_73379_73422[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (30))){
var state_73339__$1 = state_73339;
var statearr_73380_73423 = state_73339__$1;
(statearr_73380_73423[(2)] = null);

(statearr_73380_73423[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (10))){
var inst_73309 = (state_73339[(2)]);
var state_73339__$1 = state_73339;
var statearr_73381_73424 = state_73339__$1;
(statearr_73381_73424[(2)] = inst_73309);

(statearr_73381_73424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (18))){
var state_73339__$1 = state_73339;
var statearr_73382_73425 = state_73339__$1;
(statearr_73382_73425[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73340 === (8))){
var inst_73273 = (state_73339[(7)]);
var inst_73272 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_73273__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73274 = (inst_73273__$1 == null);
var state_73339__$1 = (function (){var statearr_73384 = state_73339;
(statearr_73384[(7)] = inst_73273__$1);

(statearr_73384[(17)] = inst_73272);

return statearr_73384;
})();
if(cljs.core.truth_(inst_73274)){
var statearr_73385_73426 = state_73339__$1;
(statearr_73385_73426[(1)] = (11));

} else {
var statearr_73386_73427 = state_73339__$1;
(statearr_73386_73427[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__11410__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__11410__auto____0 = (function (){
var statearr_73387 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73387[(0)] = fluree$db$connection$msg_consumer_$_state_machine__11410__auto__);

(statearr_73387[(1)] = (1));

return statearr_73387;
});
var fluree$db$connection$msg_consumer_$_state_machine__11410__auto____1 = (function (state_73339){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73339);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73388){var ex__11413__auto__ = e73388;
var statearr_73389_73428 = state_73339;
(statearr_73389_73428[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73339[(4)]))){
var statearr_73390_73429 = state_73339;
(statearr_73390_73429[(1)] = cljs.core.first((state_73339[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73430 = state_73339;
state_73339 = G__73430;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__11410__auto__ = function(state_73339){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__11410__auto____1.call(this,state_73339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__11410__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__11410__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73391 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73391[(6)] = c__11484__auto__);

return statearr_73391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__73432 = arguments.length;
switch (G__73432) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__73433 = opts;
var map__73433__$1 = cljs.core.__destructure_map(map__73433);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73433__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73433__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73485){
var state_val_73486 = (state_73485[(1)]);
if((state_val_73486 === (7))){
var inst_73443 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_73444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73445 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73446 = (new cljs.core.PersistentVector(null,2,(5),inst_73444,inst_73445,null));
var inst_73447 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73443,inst_73446);
var state_73485__$1 = state_73485;
var statearr_73487_73518 = state_73485__$1;
(statearr_73487_73518[(2)] = inst_73447);

(statearr_73487_73518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (1))){
var state_73485__$1 = state_73485;
var statearr_73488_73519 = state_73485__$1;
(statearr_73488_73519[(2)] = null);

(statearr_73488_73519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (4))){
var inst_73434 = (state_73485[(2)]);
var state_73485__$1 = state_73485;
var statearr_73489_73520 = state_73485__$1;
(statearr_73489_73520[(2)] = inst_73434);

(statearr_73489_73520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (15))){
var inst_73454 = (state_73485[(7)]);
var inst_73473 = (state_73485[(2)]);
var inst_73474 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_73475 = [(5000),inst_73473,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_73476 = cljs.core.PersistentHashMap.fromArrays(inst_73474,inst_73475);
var inst_73477 = fluree.db.util.xhttp.get(inst_73454,inst_73476);
var state_73485__$1 = state_73485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73485__$1,(16),inst_73477);
} else {
if((state_val_73486 === (13))){
var inst_73454 = (state_73485[(7)]);
var inst_73464 = (state_73485[(8)]);
var inst_73466 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_73467 = [inst_73464];
var inst_73468 = cljs.core.PersistentHashMap.fromArrays(inst_73466,inst_73467);
var inst_73469 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_73454,inst_73468,private$);
var inst_73470 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_73469);
var state_73485__$1 = state_73485;
var statearr_73490_73521 = state_73485__$1;
(statearr_73490_73521[(2)] = inst_73470);

(statearr_73490_73521[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (6))){
var inst_73440 = (state_73485[(9)]);
var state_73485__$1 = state_73485;
var statearr_73491_73522 = state_73485__$1;
(statearr_73491_73522[(2)] = inst_73440);

(statearr_73491_73522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (3))){
var inst_73483 = (state_73485[(2)]);
var state_73485__$1 = state_73485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73485__$1,inst_73483);
} else {
if((state_val_73486 === (12))){
var inst_73464 = (state_73485[(2)]);
var state_73485__$1 = (function (){var statearr_73492 = state_73485;
(statearr_73492[(8)] = inst_73464);

return statearr_73492;
})();
if(cljs.core.truth_(private$)){
var statearr_73493_73523 = state_73485__$1;
(statearr_73493_73523[(1)] = (13));

} else {
var statearr_73494_73524 = state_73485__$1;
(statearr_73494_73524[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (2))){
var inst_73440 = (state_73485[(9)]);
var _ = (function (){var statearr_73495 = state_73485;
(statearr_73495[(4)] = cljs.core.cons((5),(state_73485[(4)])));

return statearr_73495;
})();
var inst_73440__$1 = jwt;
var state_73485__$1 = (function (){var statearr_73496 = state_73485;
(statearr_73496[(9)] = inst_73440__$1);

return statearr_73496;
})();
if(cljs.core.truth_(inst_73440__$1)){
var statearr_73497_73525 = state_73485__$1;
(statearr_73497_73525[(1)] = (6));

} else {
var statearr_73498_73526 = state_73485__$1;
(statearr_73498_73526[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (11))){
var inst_73458 = (state_73485[(10)]);
var state_73485__$1 = state_73485;
var statearr_73500_73527 = state_73485__$1;
(statearr_73500_73527[(2)] = inst_73458);

(statearr_73500_73527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (9))){
var inst_73449 = (state_73485[(11)]);
var inst_73450 = (state_73485[(12)]);
var inst_73453 = (state_73485[(2)]);
var inst_73454 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73453),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73450)].join('');
var inst_73456 = ["Accept"];
var inst_73457 = ["application/json"];
var inst_73458 = cljs.core.PersistentHashMap.fromArrays(inst_73456,inst_73457);
var state_73485__$1 = (function (){var statearr_73501 = state_73485;
(statearr_73501[(7)] = inst_73454);

(statearr_73501[(10)] = inst_73458);

return statearr_73501;
})();
if(cljs.core.truth_(inst_73449)){
var statearr_73502_73528 = state_73485__$1;
(statearr_73502_73528[(1)] = (10));

} else {
var statearr_73503_73529 = state_73485__$1;
(statearr_73503_73529[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (5))){
var _ = (function (){var statearr_73504 = state_73485;
(statearr_73504[(4)] = cljs.core.rest((state_73485[(4)])));

return statearr_73504;
})();
var state_73485__$1 = state_73485;
var ex73499 = (state_73485__$1[(2)]);
var statearr_73505_73530 = state_73485__$1;
(statearr_73505_73530[(5)] = ex73499);


if((ex73499 instanceof Error)){
var statearr_73506_73531 = state_73485__$1;
(statearr_73506_73531[(1)] = (4));

(statearr_73506_73531[(5)] = null);

} else {
throw ex73499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (14))){
var inst_73464 = (state_73485[(8)]);
var state_73485__$1 = state_73485;
var statearr_73507_73532 = state_73485__$1;
(statearr_73507_73532[(2)] = inst_73464);

(statearr_73507_73532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (16))){
var inst_73479 = (state_73485[(2)]);
var inst_73480 = fluree.db.util.async.throw_err(inst_73479);
var _ = (function (){var statearr_73508 = state_73485;
(statearr_73508[(4)] = cljs.core.rest((state_73485[(4)])));

return statearr_73508;
})();
var state_73485__$1 = state_73485;
var statearr_73509_73533 = state_73485__$1;
(statearr_73509_73533[(2)] = inst_73480);

(statearr_73509_73533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (10))){
var inst_73449 = (state_73485[(11)]);
var inst_73458 = (state_73485[(10)]);
var inst_73460 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73449)].join('');
var inst_73461 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73458,"Authorization",inst_73460);
var state_73485__$1 = state_73485;
var statearr_73510_73534 = state_73485__$1;
(statearr_73510_73534[(2)] = inst_73461);

(statearr_73510_73534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73486 === (8))){
var inst_73449 = (state_73485[(2)]);
var inst_73450 = clojure.string.replace(k,"_","/");
var inst_73451 = fluree.db.connection.get_server(conn_id,servers);
var state_73485__$1 = (function (){var statearr_73511 = state_73485;
(statearr_73511[(11)] = inst_73449);

(statearr_73511[(12)] = inst_73450);

return statearr_73511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73485__$1,(9),inst_73451);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11410__auto__ = null;
var fluree$db$connection$state_machine__11410__auto____0 = (function (){
var statearr_73512 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73512[(0)] = fluree$db$connection$state_machine__11410__auto__);

(statearr_73512[(1)] = (1));

return statearr_73512;
});
var fluree$db$connection$state_machine__11410__auto____1 = (function (state_73485){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73485);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73513){var ex__11413__auto__ = e73513;
var statearr_73514_73535 = state_73485;
(statearr_73514_73535[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73485[(4)]))){
var statearr_73515_73536 = state_73485;
(statearr_73515_73536[(1)] = cljs.core.first((state_73485[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73537 = state_73485;
state_73485 = G__73537;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11410__auto__ = function(state_73485){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11410__auto____1.call(this,state_73485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11410__auto____0;
fluree$db$connection$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11410__auto____1;
return fluree$db$connection$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73516 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73516[(6)] = c__11484__auto__);

return statearr_73516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__73538_SHARP_){
if(cljs.core.truth_(p1__73538_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__73539_SHARP_){
var or__4253__auto__ = p1__73539_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e73540){var e = e73540;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__73541 = opts;
var map__73541__$1 = cljs.core.__destructure_map(map__73541);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73541__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73541__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__73542_73543 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__73542_73543.cljs$core$IFn$_invoke$arity$0 ? fexpr__73542_73543.cljs$core$IFn$_invoke$arity$0() : fexpr__73542_73543.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73584 = arguments.length;
var i__4865__auto___73585 = (0);
while(true){
if((i__4865__auto___73585 < len__4864__auto___73584)){
args__4870__auto__.push((arguments[i__4865__auto___73585]));

var G__73586 = (i__4865__auto___73585 + (1));
i__4865__auto___73585 = G__73586;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__73546){
var vec__73547 = p__73546;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73547,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__11484__auto___73587 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73567){
var state_val_73568 = (state_73567[(1)]);
if((state_val_73568 === (1))){
var inst_73550 = fluree.db.connection.get_socket(conn);
var state_73567__$1 = state_73567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73567__$1,(2),inst_73550);
} else {
if((state_val_73568 === (2))){
var inst_73553 = (state_73567[(7)]);
var inst_73552 = (state_73567[(8)]);
var inst_73552__$1 = (state_73567[(2)]);
var inst_73553__$1 = (inst_73552__$1 == null);
var state_73567__$1 = (function (){var statearr_73569 = state_73567;
(statearr_73569[(7)] = inst_73553__$1);

(statearr_73569[(8)] = inst_73552__$1);

return statearr_73569;
})();
if(cljs.core.truth_(inst_73553__$1)){
var statearr_73570_73588 = state_73567__$1;
(statearr_73570_73588[(1)] = (3));

} else {
var statearr_73571_73589 = state_73567__$1;
(statearr_73571_73589[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (3))){
var inst_73553 = (state_73567[(7)]);
var state_73567__$1 = state_73567;
var statearr_73572_73590 = state_73567__$1;
(statearr_73572_73590[(2)] = inst_73553);

(statearr_73572_73590[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (4))){
var inst_73552 = (state_73567[(8)]);
var inst_73556 = fluree.db.util.core.exception_QMARK_(inst_73552);
var state_73567__$1 = state_73567;
var statearr_73573_73591 = state_73567__$1;
(statearr_73573_73591[(2)] = inst_73556);

(statearr_73573_73591[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (5))){
var inst_73558 = (state_73567[(2)]);
var state_73567__$1 = state_73567;
if(cljs.core.truth_(inst_73558)){
var statearr_73574_73592 = state_73567__$1;
(statearr_73574_73592[(1)] = (6));

} else {
var statearr_73575_73593 = state_73567__$1;
(statearr_73575_73593[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (6))){
var inst_73552 = (state_73567[(8)]);
var inst_73560 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73552,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_73561 = cljs.core.async.close_BANG_(conn);
var state_73567__$1 = (function (){var statearr_73576 = state_73567;
(statearr_73576[(9)] = inst_73560);

return statearr_73576;
})();
var statearr_73577_73594 = state_73567__$1;
(statearr_73577_73594[(2)] = inst_73561);

(statearr_73577_73594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (7))){
var inst_73563 = fluree.db.connection.msg_consumer(conn);
var state_73567__$1 = state_73567;
var statearr_73578_73595 = state_73567__$1;
(statearr_73578_73595[(2)] = inst_73563);

(statearr_73578_73595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73568 === (8))){
var inst_73565 = (state_73567[(2)]);
var state_73567__$1 = state_73567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73567__$1,inst_73565);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11410__auto__ = null;
var fluree$db$connection$state_machine__11410__auto____0 = (function (){
var statearr_73579 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73579[(0)] = fluree$db$connection$state_machine__11410__auto__);

(statearr_73579[(1)] = (1));

return statearr_73579;
});
var fluree$db$connection$state_machine__11410__auto____1 = (function (state_73567){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73567);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73580){var ex__11413__auto__ = e73580;
var statearr_73581_73596 = state_73567;
(statearr_73581_73596[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73567[(4)]))){
var statearr_73582_73597 = state_73567;
(statearr_73582_73597[(1)] = cljs.core.first((state_73567[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73598 = state_73567;
state_73567 = G__73598;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11410__auto__ = function(state_73567){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11410__auto____1.call(this,state_73567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11410__auto____0;
fluree$db$connection$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11410__auto____1;
return fluree$db$connection$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73583 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73583[(6)] = c__11484__auto___73587);

return statearr_73583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq73544){
var G__73545 = cljs.core.first(seq73544);
var seq73544__$1 = cljs.core.next(seq73544);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73545,seq73544__$1);
}));

