// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__37355 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37355,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37355,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37355,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__37358){
var map__37359 = p__37358;
var map__37359__$1 = cljs.core.__destructure_map(map__37359);
var opts = map__37359__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37359__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_37419){
var state_val_37420 = (state_37419[(1)]);
if((state_val_37420 === (7))){
var inst_37390 = cljs.core.not(reindex_QMARK_);
var state_37419__$1 = state_37419;
var statearr_37421_37445 = state_37419__$1;
(statearr_37421_37445[(2)] = inst_37390);

(statearr_37421_37445[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (1))){
var state_37419__$1 = state_37419;
var statearr_37422_37446 = state_37419__$1;
(statearr_37422_37446[(2)] = null);

(statearr_37422_37446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (4))){
var inst_37360 = (state_37419[(2)]);
var state_37419__$1 = state_37419;
var statearr_37423_37447 = state_37419__$1;
(statearr_37423_37447[(2)] = inst_37360);

(statearr_37423_37447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (6))){
var inst_37380 = (state_37419[(7)]);
var inst_37374 = (state_37419[(8)]);
var inst_37388 = (state_37419[(9)]);
var inst_37373 = (state_37419[(2)]);
var inst_37374__$1 = fluree.db.util.async.throw_err(inst_37373);
var inst_37375 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_37376 = cljs.core.__destructure_map(inst_37375);
var inst_37377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37376,new cljs.core.Keyword(null,"post","post",269697687));
var inst_37378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37376,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_37379 = fluree.db.flake.size_bytes(inst_37374__$1);
var inst_37380__$1 = (inst_37378 + inst_37379);
var inst_37381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37382 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_37383 = (new cljs.core.PersistentVector(null,2,(5),inst_37381,inst_37382,null));
var inst_37384 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_37383);
var inst_37385 = cljs.core.__destructure_map(inst_37384);
var inst_37386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37385,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_37387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37385,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_37388__$1 = (inst_37380__$1 > inst_37387);
var state_37419__$1 = (function (){var statearr_37424 = state_37419;
(statearr_37424[(7)] = inst_37380__$1);

(statearr_37424[(8)] = inst_37374__$1);

(statearr_37424[(10)] = inst_37386);

(statearr_37424[(11)] = inst_37377);

(statearr_37424[(9)] = inst_37388__$1);

return statearr_37424;
})();
if(cljs.core.truth_(inst_37388__$1)){
var statearr_37425_37448 = state_37419__$1;
(statearr_37425_37448[(1)] = (7));

} else {
var statearr_37426_37449 = state_37419__$1;
(statearr_37426_37449[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (3))){
var inst_37417 = (state_37419[(2)]);
var state_37419__$1 = state_37419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37419__$1,inst_37417);
} else {
if((state_val_37420 === (12))){
var inst_37380 = (state_37419[(7)]);
var inst_37374 = (state_37419[(8)]);
var inst_37377 = (state_37419[(11)]);
var inst_37403 = (state_37419[(2)]);
var inst_37404 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37377,inst_37374);
var inst_37405 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_37406 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37405,cljs.core.empty);
var inst_37407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37408 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_37409 = (new cljs.core.PersistentVector(null,2,(5),inst_37407,inst_37408,null));
var inst_37410 = cljs.core.assoc_in(db,inst_37409,inst_37404);
var inst_37411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37412 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37413 = (new cljs.core.PersistentVector(null,2,(5),inst_37411,inst_37412,null));
var inst_37414 = cljs.core.assoc_in(inst_37410,inst_37413,inst_37380);
var _ = (function (){var statearr_37427 = state_37419;
(statearr_37427[(4)] = cljs.core.rest((state_37419[(4)])));

return statearr_37427;
})();
var state_37419__$1 = (function (){var statearr_37428 = state_37419;
(statearr_37428[(12)] = inst_37406);

(statearr_37428[(13)] = inst_37403);

return statearr_37428;
})();
var statearr_37429_37450 = state_37419__$1;
(statearr_37429_37450[(2)] = inst_37414);

(statearr_37429_37450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (2))){
var _ = (function (){var statearr_37430 = state_37419;
(statearr_37430[(4)] = cljs.core.cons((5),(state_37419[(4)])));

return statearr_37430;
})();
var inst_37368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37369 = [pred_id];
var inst_37370 = (new cljs.core.PersistentVector(null,1,(5),inst_37368,inst_37369,null));
var inst_37371 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_37370);
var state_37419__$1 = state_37419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37419__$1,(6),inst_37371);
} else {
if((state_val_37420 === (11))){
var state_37419__$1 = state_37419;
var statearr_37432_37451 = state_37419__$1;
(statearr_37432_37451[(2)] = null);

(statearr_37432_37451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (9))){
var inst_37393 = (state_37419[(2)]);
var state_37419__$1 = state_37419;
if(cljs.core.truth_(inst_37393)){
var statearr_37433_37452 = state_37419__$1;
(statearr_37433_37452[(1)] = (10));

} else {
var statearr_37434_37453 = state_37419__$1;
(statearr_37434_37453[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (5))){
var _ = (function (){var statearr_37435 = state_37419;
(statearr_37435[(4)] = cljs.core.rest((state_37419[(4)])));

return statearr_37435;
})();
var state_37419__$1 = state_37419;
var ex37431 = (state_37419__$1[(2)]);
var statearr_37436_37454 = state_37419__$1;
(statearr_37436_37454[(5)] = ex37431);


if((ex37431 instanceof Error)){
var statearr_37437_37455 = state_37419__$1;
(statearr_37437_37455[(1)] = (4));

(statearr_37437_37455[(5)] = null);

} else {
throw ex37431;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (10))){
var inst_37395 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_37396 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_37397 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_37398 = cljs.core.PersistentHashMap.fromArrays(inst_37396,inst_37397);
var inst_37399 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37395,inst_37398);
var inst_37400 = (function(){throw inst_37399})();
var state_37419__$1 = state_37419;
var statearr_37438_37456 = state_37419__$1;
(statearr_37438_37456[(2)] = inst_37400);

(statearr_37438_37456[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37420 === (8))){
var inst_37388 = (state_37419[(9)]);
var state_37419__$1 = state_37419;
var statearr_37439_37457 = state_37419__$1;
(statearr_37439_37457[(2)] = inst_37388);

(statearr_37439_37457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____0 = (function (){
var statearr_37440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37440[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__);

(statearr_37440[(1)] = (1));

return statearr_37440;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____1 = (function (state_37419){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_37419);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e37441){var ex__11413__auto__ = e37441;
var statearr_37442_37458 = state_37419;
(statearr_37442_37458[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_37419[(4)]))){
var statearr_37443_37459 = state_37419;
(statearr_37443_37459[(1)] = cljs.core.first((state_37419[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37460 = state_37419;
state_37419 = G__37460;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__ = function(state_37419){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____1.call(this,state_37419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_37444 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_37444[(6)] = c__11484__auto__);

return statearr_37444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__37465 = arguments.length;
switch (G__37465) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_37661){
var state_val_37662 = (state_37661[(1)]);
if((state_val_37662 === (7))){
var state_37661__$1 = state_37661;
var statearr_37663_37731 = state_37661__$1;
(statearr_37663_37731[(2)] = null);

(statearr_37663_37731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (20))){
var inst_37586 = (state_37661[(7)]);
var inst_37587 = (state_37661[(8)]);
var inst_37554 = (state_37661[(9)]);
var inst_37583 = (state_37661[(10)]);
var inst_37503 = (state_37661[(11)]);
var inst_37585 = (state_37661[(12)]);
var inst_37584 = (state_37661[(13)]);
var inst_37504 = (state_37661[(14)]);
var inst_37597 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37599 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37600 = (new cljs.core.PersistentVector(null,2,(5),inst_37598,inst_37599,null));
var inst_37601 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37554,inst_37600);
var inst_37602 = (inst_37503 + inst_37601);
var inst_37603 = [inst_37583,inst_37584,inst_37585,inst_37586,inst_37602];
var inst_37604 = cljs.core.PersistentHashMap.fromArrays(inst_37597,inst_37603);
var inst_37605 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_37554,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_37587,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_37604], 0));
var state_37661__$1 = (function (){var statearr_37664 = state_37661;
(statearr_37664[(15)] = inst_37605);

return statearr_37664;
})();
if(cljs.core.truth_(inst_37504)){
var statearr_37665_37732 = state_37661__$1;
(statearr_37665_37732[(1)] = (23));

} else {
var statearr_37666_37733 = state_37661__$1;
(statearr_37666_37733[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (27))){
var inst_37605 = (state_37661[(15)]);
var state_37661__$1 = state_37661;
var statearr_37667_37734 = state_37661__$1;
(statearr_37667_37734[(2)] = inst_37605);

(statearr_37667_37734[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (1))){
var state_37661__$1 = state_37661;
var statearr_37668_37735 = state_37661__$1;
(statearr_37668_37735[(2)] = null);

(statearr_37668_37735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (24))){
var inst_37605 = (state_37661[(15)]);
var inst_37608 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_37605);
var inst_37609 = (inst_37608 == null);
var state_37661__$1 = state_37661;
var statearr_37669_37736 = state_37661__$1;
(statearr_37669_37736[(2)] = inst_37609);

(statearr_37669_37736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (39))){
var inst_37635 = (state_37661[(16)]);
var inst_37637 = (state_37661[(17)]);
var inst_37636 = (state_37661[(18)]);
var inst_37644 = (state_37661[(19)]);
var inst_37594 = (state_37661[(20)]);
var inst_37651 = (state_37661[(2)]);
var inst_37582 = inst_37594;
var inst_37583 = inst_37636;
var inst_37584 = inst_37637;
var inst_37585 = inst_37644;
var inst_37586 = inst_37651;
var inst_37587 = inst_37635;
var state_37661__$1 = (function (){var statearr_37670 = state_37661;
(statearr_37670[(7)] = inst_37586);

(statearr_37670[(21)] = inst_37582);

(statearr_37670[(8)] = inst_37587);

(statearr_37670[(10)] = inst_37583);

(statearr_37670[(12)] = inst_37585);

(statearr_37670[(13)] = inst_37584);

return statearr_37670;
})();
var statearr_37671_37737 = state_37661__$1;
(statearr_37671_37737[(2)] = null);

(statearr_37671_37737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (4))){
var inst_37466 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37672_37738 = state_37661__$1;
(statearr_37672_37738[(2)] = inst_37466);

(statearr_37672_37738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (15))){
var inst_37526 = (state_37661[(22)]);
var state_37661__$1 = state_37661;
var statearr_37673_37739 = state_37661__$1;
(statearr_37673_37739[(2)] = inst_37526);

(statearr_37673_37739[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (21))){
var inst_37564 = (state_37661[(23)]);
var inst_37586 = (state_37661[(7)]);
var inst_37582 = (state_37661[(21)]);
var inst_37473 = (state_37661[(24)]);
var inst_37587 = (state_37661[(8)]);
var inst_37513 = (state_37661[(25)]);
var inst_37554 = (state_37661[(9)]);
var inst_37563 = (state_37661[(26)]);
var inst_37505 = (state_37661[(27)]);
var inst_37490 = (state_37661[(28)]);
var inst_37488 = (state_37661[(29)]);
var inst_37583 = (state_37661[(10)]);
var inst_37507 = (state_37661[(30)]);
var inst_37503 = (state_37661[(11)]);
var inst_37498 = (state_37661[(31)]);
var inst_37585 = (state_37661[(12)]);
var inst_37502 = (state_37661[(32)]);
var inst_37584 = (state_37661[(13)]);
var inst_37504 = (state_37661[(14)]);
var inst_37593 = (state_37661[(33)]);
var inst_37594 = (state_37661[(20)]);
var inst_37494 = (state_37661[(34)]);
var inst_37632 = inst_37593.s;
var inst_37633 = fluree.db.flake.sid__GT_cid(inst_37632);
var inst_37634 = (function (){var flakes_bytes = inst_37503;
var t = inst_37473;
var spot = inst_37583;
var add_flakes = inst_37490;
var root_setting_change_QMARK_ = inst_37505;
var ref_QMARK__map = inst_37502;
var r = inst_37594;
var G__37558 = inst_37582;
var psot = inst_37584;
var seq__37590 = inst_37594;
var add_pred_to_idx_QMARK_ = inst_37513;
var _ = inst_37488;
var cid = inst_37633;
var ecount = inst_37587;
var vec__37589 = inst_37582;
var pred_ecount = inst_37507;
var first__37591 = inst_37593;
var vec__37559 = inst_37490;
var db_STAR_ = inst_37554;
var schema_change_QMARK_ = inst_37504;
var seq__37560 = inst_37564;
var add_preds = inst_37494;
var opst = inst_37586;
var first__37561 = inst_37563;
var idx_QMARK__map = inst_37498;
var post = inst_37585;
var f = inst_37593;
return (function (p1__37463_SHARP_){
if(cljs.core.truth_(p1__37463_SHARP_)){
var x__4336__auto__ = p1__37463_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_37635 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_37587,inst_37633,inst_37634);
var inst_37636 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37583,inst_37593);
var inst_37637 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37584,inst_37593);
var inst_37638 = inst_37593.p;
var inst_37639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37498,inst_37638);
var state_37661__$1 = (function (){var statearr_37674 = state_37661;
(statearr_37674[(16)] = inst_37635);

(statearr_37674[(17)] = inst_37637);

(statearr_37674[(18)] = inst_37636);

return statearr_37674;
})();
if(cljs.core.truth_(inst_37639)){
var statearr_37675_37740 = state_37661__$1;
(statearr_37675_37740[(1)] = (34));

} else {
var statearr_37676_37741 = state_37661__$1;
(statearr_37676_37741[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (31))){
var inst_37620 = (state_37661[(35)]);
var state_37661__$1 = state_37661;
var statearr_37677_37742 = state_37661__$1;
(statearr_37677_37742[(2)] = inst_37620);

(statearr_37677_37742[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (32))){
var inst_37630 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37678_37743 = state_37661__$1;
(statearr_37678_37743[(2)] = inst_37630);

(statearr_37678_37743[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (33))){
var inst_37620 = (state_37661[(35)]);
var inst_37625 = (state_37661[(2)]);
var inst_37626 = fluree.db.util.async.throw_err(inst_37625);
var inst_37627 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37620,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_37626);
var state_37661__$1 = state_37661;
var statearr_37679_37744 = state_37661__$1;
(statearr_37679_37744[(2)] = inst_37627);

(statearr_37679_37744[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (13))){
var inst_37473 = (state_37661[(24)]);
var inst_37554 = (state_37661[(9)]);
var inst_37490 = (state_37661[(28)]);
var inst_37503 = (state_37661[(11)]);
var inst_37544 = (state_37661[(2)]);
var inst_37545 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37544,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37473);
var inst_37546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37547 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37548 = (new cljs.core.PersistentVector(null,2,(5),inst_37546,inst_37547,null));
var inst_37549 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_37545,inst_37548,cljs.core._PLUS_,inst_37503);
var inst_37550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37551 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_37552 = (new cljs.core.PersistentVector(null,2,(5),inst_37550,inst_37551,null));
var inst_37553 = cljs.core.count(inst_37490);
var inst_37554__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_37549,inst_37552,cljs.core._PLUS_,inst_37553);
var inst_37562 = cljs.core.seq(inst_37490);
var inst_37563 = cljs.core.first(inst_37562);
var inst_37564 = cljs.core.next(inst_37562);
var inst_37565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37566 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_37567 = (new cljs.core.PersistentVector(null,2,(5),inst_37565,inst_37566,null));
var inst_37568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37554__$1,inst_37567);
var inst_37569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37570 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_37571 = (new cljs.core.PersistentVector(null,2,(5),inst_37569,inst_37570,null));
var inst_37572 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37554__$1,inst_37571);
var inst_37573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37574 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_37575 = (new cljs.core.PersistentVector(null,2,(5),inst_37573,inst_37574,null));
var inst_37576 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37554__$1,inst_37575);
var inst_37577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37578 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_37579 = (new cljs.core.PersistentVector(null,2,(5),inst_37577,inst_37578,null));
var inst_37580 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37554__$1,inst_37579);
var inst_37581 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_37582 = inst_37490;
var inst_37583 = inst_37568;
var inst_37584 = inst_37572;
var inst_37585 = inst_37576;
var inst_37586 = inst_37580;
var inst_37587 = inst_37581;
var state_37661__$1 = (function (){var statearr_37680 = state_37661;
(statearr_37680[(23)] = inst_37564);

(statearr_37680[(7)] = inst_37586);

(statearr_37680[(21)] = inst_37582);

(statearr_37680[(8)] = inst_37587);

(statearr_37680[(9)] = inst_37554__$1);

(statearr_37680[(26)] = inst_37563);

(statearr_37680[(10)] = inst_37583);

(statearr_37680[(12)] = inst_37585);

(statearr_37680[(13)] = inst_37584);

return statearr_37680;
})();
var statearr_37681_37745 = state_37661__$1;
(statearr_37681_37745[(2)] = null);

(statearr_37681_37745[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (22))){
var inst_37654 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37682_37746 = state_37661__$1;
(statearr_37682_37746[(2)] = inst_37654);

(statearr_37682_37746[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (36))){
var inst_37502 = (state_37661[(32)]);
var inst_37593 = (state_37661[(33)]);
var inst_37644 = (state_37661[(2)]);
var inst_37645 = inst_37593.p;
var inst_37646 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37502,inst_37645);
var state_37661__$1 = (function (){var statearr_37683 = state_37661;
(statearr_37683[(19)] = inst_37644);

return statearr_37683;
})();
if(cljs.core.truth_(inst_37646)){
var statearr_37684_37747 = state_37661__$1;
(statearr_37684_37747[(1)] = (37));

} else {
var statearr_37685_37748 = state_37661__$1;
(statearr_37685_37748[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (29))){
var inst_37605 = (state_37661[(15)]);
var inst_37615 = (state_37661[(2)]);
var inst_37616 = fluree.db.util.async.throw_err(inst_37615);
var inst_37617 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37605,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_37616);
var state_37661__$1 = state_37661;
var statearr_37686_37749 = state_37661__$1;
(statearr_37686_37749[(2)] = inst_37617);

(statearr_37686_37749[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (6))){
var inst_37473 = (state_37661[(24)]);
var inst_37478 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37479 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_37480 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37478)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37479)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37473),"."].join('');
var inst_37481 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37482 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37483 = cljs.core.PersistentHashMap.fromArrays(inst_37481,inst_37482);
var inst_37484 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37480,inst_37483);
var inst_37485 = (function(){throw inst_37484})();
var state_37661__$1 = state_37661;
var statearr_37687_37750 = state_37661__$1;
(statearr_37687_37750[(2)] = inst_37485);

(statearr_37687_37750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (28))){
var inst_37505 = (state_37661[(27)]);
var inst_37620 = (state_37661[(2)]);
var state_37661__$1 = (function (){var statearr_37688 = state_37661;
(statearr_37688[(35)] = inst_37620);

return statearr_37688;
})();
if(cljs.core.truth_(inst_37505)){
var statearr_37689_37751 = state_37661__$1;
(statearr_37689_37751[(1)] = (30));

} else {
var statearr_37690_37752 = state_37661__$1;
(statearr_37690_37752[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (25))){
var inst_37611 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
if(cljs.core.truth_(inst_37611)){
var statearr_37691_37753 = state_37661__$1;
(statearr_37691_37753[(1)] = (26));

} else {
var statearr_37692_37754 = state_37661__$1;
(statearr_37692_37754[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (34))){
var inst_37585 = (state_37661[(12)]);
var inst_37593 = (state_37661[(33)]);
var inst_37641 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37585,inst_37593);
var state_37661__$1 = state_37661;
var statearr_37693_37755 = state_37661__$1;
(statearr_37693_37755[(2)] = inst_37641);

(statearr_37693_37755[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (17))){
var inst_37533 = (state_37661[(36)]);
var inst_37537 = (state_37661[(2)]);
var inst_37538 = fluree.db.util.async.throw_err(inst_37537);
var inst_37525 = inst_37533;
var inst_37526 = inst_37538;
var state_37661__$1 = (function (){var statearr_37694 = state_37661;
(statearr_37694[(37)] = inst_37525);

(statearr_37694[(22)] = inst_37526);

return statearr_37694;
})();
var statearr_37695_37756 = state_37661__$1;
(statearr_37695_37756[(2)] = null);

(statearr_37695_37756[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (3))){
var inst_37659 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37661__$1,inst_37659);
} else {
if((state_val_37662 === (12))){
var inst_37525 = (state_37661[(37)]);
var inst_37532 = (state_37661[(38)]);
var inst_37531 = cljs.core.seq(inst_37525);
var inst_37532__$1 = cljs.core.first(inst_37531);
var inst_37533 = cljs.core.next(inst_37531);
var state_37661__$1 = (function (){var statearr_37696 = state_37661;
(statearr_37696[(36)] = inst_37533);

(statearr_37696[(38)] = inst_37532__$1);

return statearr_37696;
})();
if(cljs.core.truth_(inst_37532__$1)){
var statearr_37697_37757 = state_37661__$1;
(statearr_37697_37757[(1)] = (14));

} else {
var statearr_37698_37758 = state_37661__$1;
(statearr_37698_37758[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (2))){
var inst_37473 = (state_37661[(24)]);
var _ = (function (){var statearr_37699 = state_37661;
(statearr_37699[(4)] = cljs.core.cons((5),(state_37661[(4)])));

return statearr_37699;
})();
var inst_37472 = cljs.core.first(flakes);
var inst_37473__$1 = inst_37472.t;
var inst_37474 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_37475 = (inst_37474 - (1));
var inst_37476 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_37473__$1,inst_37475);
var state_37661__$1 = (function (){var statearr_37700 = state_37661;
(statearr_37700[(24)] = inst_37473__$1);

return statearr_37700;
})();
if(inst_37476){
var statearr_37701_37759 = state_37661__$1;
(statearr_37701_37759[(1)] = (6));

} else {
var statearr_37702_37760 = state_37661__$1;
(statearr_37702_37760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (23))){
var inst_37504 = (state_37661[(14)]);
var state_37661__$1 = state_37661;
var statearr_37703_37761 = state_37661__$1;
(statearr_37703_37761[(2)] = inst_37504);

(statearr_37703_37761[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (35))){
var inst_37585 = (state_37661[(12)]);
var state_37661__$1 = state_37661;
var statearr_37704_37762 = state_37661__$1;
(statearr_37704_37762[(2)] = inst_37585);

(statearr_37704_37762[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (19))){
var inst_37656 = (state_37661[(2)]);
var _ = (function (){var statearr_37705 = state_37661;
(statearr_37705[(4)] = cljs.core.rest((state_37661[(4)])));

return statearr_37705;
})();
var state_37661__$1 = state_37661;
var statearr_37706_37763 = state_37661__$1;
(statearr_37706_37763[(2)] = inst_37656);

(statearr_37706_37763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (11))){
var inst_37513 = (state_37661[(25)]);
var inst_37513__$1 = (state_37661[(2)]);
var inst_37521 = cljs.core.seq(inst_37513__$1);
var inst_37522 = cljs.core.first(inst_37521);
var inst_37523 = cljs.core.next(inst_37521);
var inst_37524 = db;
var inst_37525 = inst_37513__$1;
var inst_37526 = inst_37524;
var state_37661__$1 = (function (){var statearr_37708 = state_37661;
(statearr_37708[(39)] = inst_37522);

(statearr_37708[(25)] = inst_37513__$1);

(statearr_37708[(40)] = inst_37523);

(statearr_37708[(37)] = inst_37525);

(statearr_37708[(22)] = inst_37526);

return statearr_37708;
})();
var statearr_37709_37764 = state_37661__$1;
(statearr_37709_37764[(2)] = null);

(statearr_37709_37764[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (9))){
var inst_37490 = (state_37661[(28)]);
var inst_37507 = (state_37661[(30)]);
var inst_37509 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_37490,inst_37507);
var state_37661__$1 = state_37661;
var statearr_37710_37765 = state_37661__$1;
(statearr_37710_37765[(2)] = inst_37509);

(statearr_37710_37765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (5))){
var _ = (function (){var statearr_37711 = state_37661;
(statearr_37711[(4)] = cljs.core.rest((state_37661[(4)])));

return statearr_37711;
})();
var state_37661__$1 = state_37661;
var ex37707 = (state_37661__$1[(2)]);
var statearr_37712_37766 = state_37661__$1;
(statearr_37712_37766[(5)] = ex37707);


if((ex37707 instanceof Error)){
var statearr_37713_37767 = state_37661__$1;
(statearr_37713_37767[(1)] = (4));

(statearr_37713_37767[(5)] = null);

} else {
throw ex37707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (14))){
var inst_37532 = (state_37661[(38)]);
var inst_37526 = (state_37661[(22)]);
var inst_37535 = fluree.db.graphdb.add_predicate_to_idx(inst_37526,inst_37532,opts);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37661__$1,(17),inst_37535);
} else {
if((state_val_37662 === (26))){
var inst_37605 = (state_37661[(15)]);
var inst_37613 = fluree.db.query.schema.schema_map(inst_37605);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37661__$1,(29),inst_37613);
} else {
if((state_val_37662 === (16))){
var inst_37542 = (state_37661[(2)]);
var state_37661__$1 = state_37661;
var statearr_37714_37768 = state_37661__$1;
(statearr_37714_37768[(2)] = inst_37542);

(statearr_37714_37768[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (38))){
var inst_37586 = (state_37661[(7)]);
var state_37661__$1 = state_37661;
var statearr_37715_37769 = state_37661__$1;
(statearr_37715_37769[(2)] = inst_37586);

(statearr_37715_37769[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (30))){
var inst_37620 = (state_37661[(35)]);
var inst_37623 = fluree.db.query.schema.setting_map(inst_37620);
var state_37661__$1 = state_37661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37661__$1,(33),inst_37623);
} else {
if((state_val_37662 === (10))){
var inst_37511 = cljs.core.PersistentVector.EMPTY;
var state_37661__$1 = state_37661;
var statearr_37716_37770 = state_37661__$1;
(statearr_37716_37770[(2)] = inst_37511);

(statearr_37716_37770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (18))){
var inst_37582 = (state_37661[(21)]);
var inst_37593 = (state_37661[(33)]);
var inst_37592 = cljs.core.seq(inst_37582);
var inst_37593__$1 = cljs.core.first(inst_37592);
var inst_37594 = cljs.core.next(inst_37592);
var inst_37595 = cljs.core.not(inst_37593__$1);
var state_37661__$1 = (function (){var statearr_37717 = state_37661;
(statearr_37717[(33)] = inst_37593__$1);

(statearr_37717[(20)] = inst_37594);

return statearr_37717;
})();
if(inst_37595){
var statearr_37718_37771 = state_37661__$1;
(statearr_37718_37771[(1)] = (20));

} else {
var statearr_37719_37772 = state_37661__$1;
(statearr_37719_37772[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (37))){
var inst_37586 = (state_37661[(7)]);
var inst_37593 = (state_37661[(33)]);
var inst_37648 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37586,inst_37593);
var state_37661__$1 = state_37661;
var statearr_37720_37773 = state_37661__$1;
(statearr_37720_37773[(2)] = inst_37648);

(statearr_37720_37773[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37662 === (8))){
var inst_37473 = (state_37661[(24)]);
var inst_37490 = (state_37661[(28)]);
var inst_37488 = (state_37661[(29)]);
var inst_37498 = (state_37661[(31)]);
var inst_37504 = (state_37661[(14)]);
var inst_37494 = (state_37661[(34)]);
var inst_37488__$1 = (state_37661[(2)]);
var inst_37489 = (function (){var t = inst_37473;
var _ = inst_37488__$1;
return (function (p1__37461_SHARP_){
return cljs.core.not((function (){var G__37721 = p1__37461_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__37721) : fluree.db.graphdb.exclude_predicates.call(null,G__37721));
})());
});
})();
var inst_37490__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_37489,flakes);
var inst_37491 = cljs.core.PersistentHashSet.EMPTY;
var inst_37492 = (function (){var t = inst_37473;
var _ = inst_37488__$1;
var add_flakes = inst_37490__$1;
return (function (p1__37462_SHARP_){
return p1__37462_SHARP_.p;
});
})();
var inst_37493 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37492,inst_37490__$1);
var inst_37494__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37491,inst_37493);
var inst_37495 = cljs.core.PersistentHashMap.EMPTY;
var inst_37496 = (function (){var t = inst_37473;
var _ = inst_37488__$1;
var add_flakes = inst_37490__$1;
var add_preds = inst_37494__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_37497 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37496,inst_37494__$1);
var inst_37498__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37495,inst_37497);
var inst_37499 = cljs.core.PersistentHashMap.EMPTY;
var inst_37500 = (function (){var t = inst_37473;
var _ = inst_37488__$1;
var add_flakes = inst_37490__$1;
var add_preds = inst_37494__$1;
var idx_QMARK__map = inst_37498__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_37501 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37500,inst_37494__$1);
var inst_37502 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37499,inst_37501);
var inst_37503 = fluree.db.flake.size_bytes(inst_37490__$1);
var inst_37504__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_37490__$1);
var inst_37505 = fluree.db.util.schema.setting_change_QMARK_(inst_37490__$1);
var inst_37506 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_37507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37506,(0));
var state_37661__$1 = (function (){var statearr_37722 = state_37661;
(statearr_37722[(27)] = inst_37505);

(statearr_37722[(28)] = inst_37490__$1);

(statearr_37722[(29)] = inst_37488__$1);

(statearr_37722[(30)] = inst_37507);

(statearr_37722[(11)] = inst_37503);

(statearr_37722[(31)] = inst_37498__$1);

(statearr_37722[(32)] = inst_37502);

(statearr_37722[(14)] = inst_37504__$1);

(statearr_37722[(34)] = inst_37494__$1);

return statearr_37722;
})();
if(cljs.core.truth_(inst_37504__$1)){
var statearr_37723_37774 = state_37661__$1;
(statearr_37723_37774[(1)] = (9));

} else {
var statearr_37724_37775 = state_37661__$1;
(statearr_37724_37775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_37725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37725[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_37725[(1)] = (1));

return statearr_37725;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_37661){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_37661);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e37726){var ex__11413__auto__ = e37726;
var statearr_37727_37776 = state_37661;
(statearr_37727_37776[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_37661[(4)]))){
var statearr_37728_37777 = state_37661;
(statearr_37728_37777[(1)] = cljs.core.first((state_37661[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37778 = state_37661;
state_37661 = G__37778;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_37661){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_37661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_37729 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_37729[(6)] = c__11484__auto__);

return statearr_37729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__37780 = arguments.length;
switch (G__37780) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___37927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_37876){
var state_val_37877 = (state_37876[(1)]);
if((state_val_37877 === (7))){
var state_37876__$1 = state_37876;
var statearr_37878_37928 = state_37876__$1;
(statearr_37878_37928[(2)] = null);

(statearr_37878_37928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (20))){
var inst_37826 = (state_37876[(7)]);
var inst_37825 = (state_37876[(8)]);
var inst_37824 = (state_37876[(9)]);
var inst_37845 = (inst_37824 + (1));
var inst_37846 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37826,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37845);
var inst_37847 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_37846,inst_37825,opts);
var state_37876__$1 = state_37876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37876__$1,(23),inst_37847);
} else {
if((state_val_37877 === (1))){
var state_37876__$1 = state_37876;
var statearr_37879_37929 = state_37876__$1;
(statearr_37879_37929[(2)] = null);

(statearr_37879_37929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (24))){
var inst_37850 = (state_37876[(10)]);
var inst_37853 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37850,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_37876__$1 = state_37876;
var statearr_37880_37930 = state_37876__$1;
(statearr_37880_37930[(2)] = inst_37853);

(statearr_37880_37930[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (4))){
var inst_37781 = (state_37876[(2)]);
var inst_37782 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_37781);
var state_37876__$1 = state_37876;
var statearr_37881_37931 = state_37876__$1;
(statearr_37881_37931[(2)] = inst_37782);

(statearr_37881_37931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (15))){
var inst_37832 = (state_37876[(11)]);
var state_37876__$1 = state_37876;
var statearr_37882_37932 = state_37876__$1;
(statearr_37882_37932[(2)] = inst_37832);

(statearr_37882_37932[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (21))){
var state_37876__$1 = state_37876;
var statearr_37883_37933 = state_37876__$1;
(statearr_37883_37933[(2)] = null);

(statearr_37883_37933[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (13))){
var inst_37868 = (state_37876[(2)]);
var inst_37869 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_37868);
var state_37876__$1 = state_37876;
var statearr_37884_37934 = state_37876__$1;
(statearr_37884_37934[(2)] = inst_37869);

(statearr_37884_37934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (22))){
var inst_37864 = (state_37876[(2)]);
var state_37876__$1 = state_37876;
var statearr_37885_37935 = state_37876__$1;
(statearr_37885_37935[(2)] = inst_37864);

(statearr_37885_37935[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (6))){
var inst_37792 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37793 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37794 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37792)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37793)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_37795 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37796 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37797 = cljs.core.PersistentHashMap.fromArrays(inst_37795,inst_37796);
var inst_37798 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37794,inst_37797);
var inst_37799 = (function(){throw inst_37798})();
var state_37876__$1 = state_37876;
var statearr_37888_37936 = state_37876__$1;
(statearr_37888_37936[(2)] = inst_37799);

(statearr_37888_37936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (25))){
var inst_37833 = (state_37876[(12)]);
var inst_37850 = (state_37876[(10)]);
var inst_37832 = (state_37876[(11)]);
var inst_37855 = inst_37832.t;
var inst_37856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37857 = [inst_37832];
var inst_37858 = (new cljs.core.PersistentVector(null,1,(5),inst_37856,inst_37857,null));
var inst_37823 = inst_37833;
var inst_37824 = inst_37855;
var inst_37825 = inst_37858;
var inst_37826 = inst_37850;
var state_37876__$1 = (function (){var statearr_37889 = state_37876;
(statearr_37889[(7)] = inst_37826);

(statearr_37889[(8)] = inst_37825);

(statearr_37889[(9)] = inst_37824);

(statearr_37889[(13)] = inst_37823);

return statearr_37889;
})();
var statearr_37890_37937 = state_37876__$1;
(statearr_37890_37937[(2)] = null);

(statearr_37890_37937[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (17))){
var inst_37833 = (state_37876[(12)]);
var inst_37826 = (state_37876[(7)]);
var inst_37825 = (state_37876[(8)]);
var inst_37824 = (state_37876[(9)]);
var inst_37832 = (state_37876[(11)]);
var inst_37841 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37825,inst_37832);
var tmp37886 = inst_37826;
var tmp37887 = inst_37824;
var inst_37823 = inst_37833;
var inst_37824__$1 = tmp37887;
var inst_37825__$1 = inst_37841;
var inst_37826__$1 = tmp37886;
var state_37876__$1 = (function (){var statearr_37891 = state_37876;
(statearr_37891[(7)] = inst_37826__$1);

(statearr_37891[(8)] = inst_37825__$1);

(statearr_37891[(9)] = inst_37824__$1);

(statearr_37891[(13)] = inst_37823);

return statearr_37891;
})();
var statearr_37892_37938 = state_37876__$1;
(statearr_37892_37938[(2)] = null);

(statearr_37892_37938[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (3))){
var inst_37874 = (state_37876[(2)]);
var state_37876__$1 = state_37876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37876__$1,inst_37874);
} else {
if((state_val_37877 === (12))){
var inst_37823 = (state_37876[(13)]);
var inst_37832 = (state_37876[(11)]);
var inst_37831 = cljs.core.seq(inst_37823);
var inst_37832__$1 = cljs.core.first(inst_37831);
var inst_37833 = cljs.core.next(inst_37831);
var state_37876__$1 = (function (){var statearr_37893 = state_37876;
(statearr_37893[(12)] = inst_37833);

(statearr_37893[(11)] = inst_37832__$1);

return statearr_37893;
})();
if(cljs.core.truth_(inst_37832__$1)){
var statearr_37894_37939 = state_37876__$1;
(statearr_37894_37939[(1)] = (14));

} else {
var statearr_37895_37940 = state_37876__$1;
(statearr_37895_37940[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (2))){
var _ = (function (){var statearr_37896 = state_37876;
(statearr_37896[(4)] = cljs.core.cons((5),(state_37876[(4)])));

return statearr_37896;
})();
var inst_37788 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37789 = (inst_37788 + (1));
var inst_37790 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_37789);
var state_37876__$1 = state_37876;
if(inst_37790){
var statearr_37897_37941 = state_37876__$1;
(statearr_37897_37941[(1)] = (6));

} else {
var statearr_37898_37942 = state_37876__$1;
(statearr_37898_37942[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (23))){
var inst_37832 = (state_37876[(11)]);
var inst_37849 = (state_37876[(2)]);
var inst_37850 = fluree.db.util.async.throw_err(inst_37849);
var inst_37851 = (inst_37832 == null);
var state_37876__$1 = (function (){var statearr_37899 = state_37876;
(statearr_37899[(10)] = inst_37850);

return statearr_37899;
})();
if(cljs.core.truth_(inst_37851)){
var statearr_37900_37943 = state_37876__$1;
(statearr_37900_37943[(1)] = (24));

} else {
var statearr_37901_37944 = state_37876__$1;
(statearr_37901_37944[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (19))){
var inst_37866 = (state_37876[(2)]);
var state_37876__$1 = state_37876;
var statearr_37902_37945 = state_37876__$1;
(statearr_37902_37945[(2)] = inst_37866);

(statearr_37902_37945[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (11))){
var inst_37871 = (state_37876[(2)]);
var _ = (function (){var statearr_37904 = state_37876;
(statearr_37904[(4)] = cljs.core.rest((state_37876[(4)])));

return statearr_37904;
})();
var state_37876__$1 = state_37876;
var statearr_37905_37946 = state_37876__$1;
(statearr_37905_37946[(2)] = inst_37871);

(statearr_37905_37946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (9))){
var inst_37805 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_37806 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_37805);
var state_37876__$1 = state_37876;
var statearr_37906_37947 = state_37876__$1;
(statearr_37906_37947[(2)] = inst_37806);

(statearr_37906_37947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (5))){
var _ = (function (){var statearr_37907 = state_37876;
(statearr_37907[(4)] = cljs.core.rest((state_37876[(4)])));

return statearr_37907;
})();
var state_37876__$1 = state_37876;
var ex37903 = (state_37876__$1[(2)]);
var statearr_37908_37948 = state_37876__$1;
(statearr_37908_37948[(5)] = ex37903);


var statearr_37909_37949 = state_37876__$1;
(statearr_37909_37949[(1)] = (4));

(statearr_37909_37949[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (14))){
var inst_37824 = (state_37876[(9)]);
var inst_37832 = (state_37876[(11)]);
var inst_37835 = inst_37832.t;
var inst_37836 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37824,inst_37835);
var state_37876__$1 = state_37876;
var statearr_37910_37950 = state_37876__$1;
(statearr_37910_37950[(2)] = inst_37836);

(statearr_37910_37950[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (26))){
var inst_37861 = (state_37876[(2)]);
var state_37876__$1 = state_37876;
var statearr_37911_37951 = state_37876__$1;
(statearr_37911_37951[(2)] = inst_37861);

(statearr_37911_37951[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (16))){
var inst_37839 = (state_37876[(2)]);
var state_37876__$1 = state_37876;
if(cljs.core.truth_(inst_37839)){
var statearr_37912_37952 = state_37876__$1;
(statearr_37912_37952[(1)] = (17));

} else {
var statearr_37913_37953 = state_37876__$1;
(statearr_37913_37953[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (10))){
var inst_37808 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_37809 = cljs.core.first(inst_37808);
var inst_37817 = cljs.core.seq(inst_37808);
var inst_37818 = cljs.core.first(inst_37817);
var inst_37819 = cljs.core.next(inst_37817);
var inst_37820 = inst_37809.t;
var inst_37821 = cljs.core.PersistentVector.EMPTY;
var inst_37822 = db;
var inst_37823 = inst_37808;
var inst_37824 = inst_37820;
var inst_37825 = inst_37821;
var inst_37826 = inst_37822;
var state_37876__$1 = (function (){var statearr_37914 = state_37876;
(statearr_37914[(14)] = inst_37819);

(statearr_37914[(15)] = inst_37818);

(statearr_37914[(7)] = inst_37826);

(statearr_37914[(8)] = inst_37825);

(statearr_37914[(9)] = inst_37824);

(statearr_37914[(13)] = inst_37823);

return statearr_37914;
})();
var statearr_37915_37954 = state_37876__$1;
(statearr_37915_37954[(2)] = null);

(statearr_37915_37954[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (18))){
var state_37876__$1 = state_37876;
var statearr_37916_37955 = state_37876__$1;
(statearr_37916_37955[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37877 === (8))){
var inst_37802 = (state_37876[(2)]);
var inst_37803 = cljs.core.empty_QMARK_(flakes);
var state_37876__$1 = (function (){var statearr_37918 = state_37876;
(statearr_37918[(16)] = inst_37802);

return statearr_37918;
})();
if(inst_37803){
var statearr_37919_37956 = state_37876__$1;
(statearr_37919_37956[(1)] = (9));

} else {
var statearr_37920_37957 = state_37876__$1;
(statearr_37920_37957[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_37921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37921[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_37921[(1)] = (1));

return statearr_37921;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_37876){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_37876);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e37922){var ex__11413__auto__ = e37922;
var statearr_37923_37958 = state_37876;
(statearr_37923_37958[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_37876[(4)]))){
var statearr_37924_37959 = state_37876;
(statearr_37924_37959[(1)] = cljs.core.first((state_37876[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37960 = state_37876;
state_37876 = G__37960;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_37876){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_37876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_37925 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_37925[(6)] = c__11484__auto___37927);

return statearr_37925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38016){
var state_val_38017 = (state_38016[(1)]);
if((state_val_38017 === (7))){
var state_38016__$1 = state_38016;
var statearr_38018_38045 = state_38016__$1;
(statearr_38018_38045[(2)] = tt_id);

(statearr_38018_38045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (1))){
var state_38016__$1 = state_38016;
var statearr_38019_38046 = state_38016__$1;
(statearr_38019_38046[(2)] = null);

(statearr_38019_38046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (4))){
var inst_37961 = (state_38016[(2)]);
var state_38016__$1 = state_38016;
var statearr_38020_38047 = state_38016__$1;
(statearr_38020_38047[(2)] = inst_37961);

(statearr_38020_38047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (13))){
var inst_38009 = (state_38016[(2)]);
var state_38016__$1 = state_38016;
var statearr_38021_38048 = state_38016__$1;
(statearr_38021_38048[(2)] = inst_38009);

(statearr_38021_38048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (6))){
var inst_37969 = fluree.db.util.core.random_uuid();
var state_38016__$1 = state_38016;
var statearr_38022_38049 = state_38016__$1;
(statearr_38022_38049[(2)] = inst_37969);

(statearr_38022_38049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (3))){
var inst_38014 = (state_38016[(2)]);
var state_38016__$1 = state_38016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38016__$1,inst_38014);
} else {
if((state_val_38017 === (12))){
var inst_37992 = (state_38016[(7)]);
var state_38016__$1 = state_38016;
var statearr_38023_38050 = state_38016__$1;
(statearr_38023_38050[(2)] = inst_37992);

(statearr_38023_38050[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (2))){
var _ = (function (){var statearr_38024 = state_38016;
(statearr_38024[(4)] = cljs.core.cons((5),(state_38016[(4)])));

return statearr_38024;
})();
var inst_37967 = (tt_id == null);
var state_38016__$1 = state_38016;
if(cljs.core.truth_(inst_37967)){
var statearr_38025_38051 = state_38016__$1;
(statearr_38025_38051[(1)] = (6));

} else {
var statearr_38026_38052 = state_38016__$1;
(statearr_38026_38052[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (11))){
var inst_37999 = (state_38016[(8)]);
var inst_37992 = (state_38016[(7)]);
var inst_38002 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_37992,inst_37999);
var state_38016__$1 = state_38016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38016__$1,(14),inst_38002);
} else {
if((state_val_38017 === (9))){
var inst_37999 = (state_38016[(8)]);
var inst_37993 = (state_38016[(9)]);
var inst_37998 = cljs.core.seq(inst_37993);
var inst_37999__$1 = cljs.core.first(inst_37998);
var inst_38000 = cljs.core.next(inst_37998);
var state_38016__$1 = (function (){var statearr_38028 = state_38016;
(statearr_38028[(8)] = inst_37999__$1);

(statearr_38028[(10)] = inst_38000);

return statearr_38028;
})();
if(cljs.core.truth_(inst_37999__$1)){
var statearr_38029_38053 = state_38016__$1;
(statearr_38029_38053[(1)] = (11));

} else {
var statearr_38030_38054 = state_38016__$1;
(statearr_38030_38054[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (5))){
var _ = (function (){var statearr_38031 = state_38016;
(statearr_38031[(4)] = cljs.core.rest((state_38016[(4)])));

return statearr_38031;
})();
var state_38016__$1 = state_38016;
var ex38027 = (state_38016__$1[(2)]);
var statearr_38032_38055 = state_38016__$1;
(statearr_38032_38055[(5)] = ex38027);


if((ex38027 instanceof Error)){
var statearr_38033_38056 = state_38016__$1;
(statearr_38033_38056[(1)] = (4));

(statearr_38033_38056[(5)] = null);

} else {
throw ex38027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (14))){
var inst_38000 = (state_38016[(10)]);
var inst_38004 = (state_38016[(2)]);
var inst_38005 = fluree.db.util.async.throw_err(inst_38004);
var inst_37992 = inst_38005;
var inst_37993 = inst_38000;
var state_38016__$1 = (function (){var statearr_38034 = state_38016;
(statearr_38034[(7)] = inst_37992);

(statearr_38034[(9)] = inst_37993);

return statearr_38034;
})();
var statearr_38035_38057 = state_38016__$1;
(statearr_38035_38057[(2)] = null);

(statearr_38035_38057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (10))){
var inst_38011 = (state_38016[(2)]);
var _ = (function (){var statearr_38036 = state_38016;
(statearr_38036[(4)] = cljs.core.rest((state_38016[(4)])));

return statearr_38036;
})();
var state_38016__$1 = state_38016;
var statearr_38037_38058 = state_38016__$1;
(statearr_38037_38058[(2)] = inst_38011);

(statearr_38037_38058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38017 === (8))){
var inst_37972 = (state_38016[(2)]);
var inst_37973 = (function (){var tt_id_SINGLEQUOTE_ = inst_37972;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_37974 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_37972);
var inst_37975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37976 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_37977 = (new cljs.core.PersistentVector(null,4,(5),inst_37975,inst_37976,null));
var inst_37978 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37973,inst_37974,inst_37977);
var inst_37979 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_37980 = cljs.core.reverse(inst_37979);
var inst_37981 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_37980);
var inst_37989 = cljs.core.seq(inst_37981);
var inst_37990 = cljs.core.first(inst_37989);
var inst_37991 = cljs.core.next(inst_37989);
var inst_37992 = inst_37978;
var inst_37993 = inst_37981;
var state_38016__$1 = (function (){var statearr_38038 = state_38016;
(statearr_38038[(7)] = inst_37992);

(statearr_38038[(9)] = inst_37993);

(statearr_38038[(11)] = inst_37991);

(statearr_38038[(12)] = inst_37990);

return statearr_38038;
})();
var statearr_38039_38059 = state_38016__$1;
(statearr_38039_38059[(2)] = null);

(statearr_38039_38059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____0 = (function (){
var statearr_38040 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38040[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__);

(statearr_38040[(1)] = (1));

return statearr_38040;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____1 = (function (state_38016){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38016);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38041){var ex__11413__auto__ = e38041;
var statearr_38042_38060 = state_38016;
(statearr_38042_38060[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38016[(4)]))){
var statearr_38043_38061 = state_38016;
(statearr_38043_38061[(1)] = cljs.core.first((state_38016[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38062 = state_38016;
state_38016 = G__38062;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__ = function(state_38016){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____1.call(this,state_38016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38044 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38044[(6)] = c__11484__auto__);

return statearr_38044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___38249 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38180){
var state_val_38181 = (state_38180[(1)]);
if((state_val_38181 === (7))){
var inst_38090 = (state_38180[(7)]);
var inst_38090__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_38180__$1 = (function (){var statearr_38182 = state_38180;
(statearr_38182[(7)] = inst_38090__$1);

return statearr_38182;
})();
if(inst_38090__$1){
var statearr_38183_38250 = state_38180__$1;
(statearr_38183_38250[(1)] = (13));

} else {
var statearr_38184_38251 = state_38180__$1;
(statearr_38184_38251[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (20))){
var state_38180__$1 = state_38180;
var statearr_38185_38252 = state_38180__$1;
(statearr_38185_38252[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (27))){
var inst_38126 = (state_38180[(8)]);
var inst_38130 = inst_38126.s;
var state_38180__$1 = state_38180;
var statearr_38187_38253 = state_38180__$1;
(statearr_38187_38253[(2)] = inst_38130);

(statearr_38187_38253[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (1))){
var state_38180__$1 = state_38180;
var statearr_38188_38254 = state_38180__$1;
(statearr_38188_38254[(2)] = null);

(statearr_38188_38254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (24))){
var inst_38120 = (state_38180[(9)]);
var inst_38124 = cljs.core.first(inst_38120);
var state_38180__$1 = state_38180;
var statearr_38189_38255 = state_38180__$1;
(statearr_38189_38255[(2)] = inst_38124);

(statearr_38189_38255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (39))){
var state_38180__$1 = state_38180;
var statearr_38190_38256 = state_38180__$1;
(statearr_38190_38256[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (4))){
var inst_38063 = (state_38180[(2)]);
var inst_38064 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38065 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38066 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_38067 = cljs.core.PersistentHashMap.fromArrays(inst_38065,inst_38066);
var inst_38068 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_38064,inst_38067,inst_38063);
var inst_38069 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38068);
var state_38180__$1 = state_38180;
var statearr_38192_38257 = state_38180__$1;
(statearr_38192_38257[(2)] = inst_38069);

(statearr_38192_38257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (15))){
var inst_38097 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
if(cljs.core.truth_(inst_38097)){
var statearr_38193_38258 = state_38180__$1;
(statearr_38193_38258[(1)] = (16));

} else {
var statearr_38194_38259 = state_38180__$1;
(statearr_38194_38259[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (21))){
var inst_38146 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38195_38260 = state_38180__$1;
(statearr_38195_38260[(2)] = inst_38146);

(statearr_38195_38260[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (31))){
var inst_38144 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38196_38261 = state_38180__$1;
(statearr_38196_38261[(2)] = inst_38144);

(statearr_38196_38261[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (32))){
var inst_38150 = (state_38180[(10)]);
var inst_38152 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38150);
var state_38180__$1 = state_38180;
var statearr_38197_38262 = state_38180__$1;
(statearr_38197_38262[(2)] = inst_38152);

(statearr_38197_38262[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (40))){
var inst_38173 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38198_38263 = state_38180__$1;
(statearr_38198_38263[(2)] = inst_38173);

(statearr_38198_38263[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (33))){
var inst_38154 = (state_38180[(11)]);
var inst_38150 = (state_38180[(10)]);
var inst_38154__$1 = (inst_38150 == null);
var state_38180__$1 = (function (){var statearr_38199 = state_38180;
(statearr_38199[(11)] = inst_38154__$1);

return statearr_38199;
})();
if(cljs.core.truth_(inst_38154__$1)){
var statearr_38200_38264 = state_38180__$1;
(statearr_38200_38264[(1)] = (35));

} else {
var statearr_38201_38265 = state_38180__$1;
(statearr_38201_38265[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (13))){
var inst_38092 = cljs.core.first(ident);
var inst_38093 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_38092);
var inst_38094 = (inst_38093 == null);
var state_38180__$1 = state_38180;
var statearr_38202_38266 = state_38180__$1;
(statearr_38202_38266[(2)] = inst_38094);

(statearr_38202_38266[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (22))){
var inst_38120 = (state_38180[(9)]);
var inst_38119 = (state_38180[(2)]);
var inst_38120__$1 = fluree.db.util.async.throw_err(inst_38119);
var inst_38121 = (inst_38120__$1 == null);
var state_38180__$1 = (function (){var statearr_38203 = state_38180;
(statearr_38203[(9)] = inst_38120__$1);

return statearr_38203;
})();
if(cljs.core.truth_(inst_38121)){
var statearr_38204_38267 = state_38180__$1;
(statearr_38204_38267[(1)] = (23));

} else {
var statearr_38205_38268 = state_38180__$1;
(statearr_38205_38268[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (36))){
var inst_38154 = (state_38180[(11)]);
var state_38180__$1 = state_38180;
var statearr_38206_38269 = state_38180__$1;
(statearr_38206_38269[(2)] = inst_38154);

(statearr_38206_38269[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (41))){
var inst_38168 = cljs.core.async.close_BANG_(return_chan);
var state_38180__$1 = state_38180;
var statearr_38207_38270 = state_38180__$1;
(statearr_38207_38270[(2)] = inst_38168);

(statearr_38207_38270[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (43))){
var inst_38171 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38208_38271 = state_38180__$1;
(statearr_38208_38271[(2)] = inst_38171);

(statearr_38208_38271[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (29))){
var inst_38135 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_38136 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_38135].join('');
var inst_38137 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38138 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_38139 = cljs.core.PersistentHashMap.fromArrays(inst_38137,inst_38138);
var inst_38140 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38136,inst_38139);
var inst_38141 = (function(){throw inst_38140})();
var state_38180__$1 = state_38180;
var statearr_38209_38272 = state_38180__$1;
(statearr_38209_38272[(2)] = inst_38141);

(statearr_38209_38272[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (6))){
var inst_38077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38078 = [ident];
var inst_38079 = (new cljs.core.PersistentVector(null,1,(5),inst_38077,inst_38078,null));
var inst_38080 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38079);
var state_38180__$1 = state_38180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38180__$1,(9),inst_38080);
} else {
if((state_val_38181 === (28))){
var inst_38132 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38210_38273 = state_38180__$1;
(statearr_38210_38273[(2)] = inst_38132);

(statearr_38210_38273[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (25))){
var inst_38126 = (state_38180[(8)]);
var inst_38126__$1 = (state_38180[(2)]);
var inst_38127 = (inst_38126__$1 == null);
var state_38180__$1 = (function (){var statearr_38211 = state_38180;
(statearr_38211[(8)] = inst_38126__$1);

return statearr_38211;
})();
if(cljs.core.truth_(inst_38127)){
var statearr_38212_38274 = state_38180__$1;
(statearr_38212_38274[(1)] = (26));

} else {
var statearr_38213_38275 = state_38180__$1;
(statearr_38213_38275[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (34))){
var inst_38175 = (state_38180[(2)]);
var _ = (function (){var statearr_38214 = state_38180;
(statearr_38214[(4)] = cljs.core.rest((state_38180[(4)])));

return statearr_38214;
})();
var state_38180__$1 = state_38180;
var statearr_38215_38276 = state_38180__$1;
(statearr_38215_38276[(2)] = inst_38175);

(statearr_38215_38276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (17))){
var inst_38108 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_38180__$1 = state_38180;
if(inst_38108){
var statearr_38216_38277 = state_38180__$1;
(statearr_38216_38277[(1)] = (19));

} else {
var statearr_38217_38278 = state_38180__$1;
(statearr_38217_38278[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (3))){
var inst_38178 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38180__$1,inst_38178);
} else {
if((state_val_38181 === (12))){
var inst_38088 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38218_38279 = state_38180__$1;
(statearr_38218_38279[(2)] = inst_38088);

(statearr_38218_38279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (2))){
var _ = (function (){var statearr_38219 = state_38180;
(statearr_38219[(4)] = cljs.core.cons((5),(state_38180[(4)])));

return statearr_38219;
})();
var inst_38075 = typeof ident === 'number';
var state_38180__$1 = state_38180;
if(cljs.core.truth_(inst_38075)){
var statearr_38220_38280 = state_38180__$1;
(statearr_38220_38280[(1)] = (6));

} else {
var statearr_38221_38281 = state_38180__$1;
(statearr_38221_38281[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (23))){
var state_38180__$1 = state_38180;
var statearr_38222_38282 = state_38180__$1;
(statearr_38222_38282[(2)] = null);

(statearr_38222_38282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (35))){
var state_38180__$1 = state_38180;
var statearr_38223_38283 = state_38180__$1;
(statearr_38223_38283[(2)] = strict_QMARK_);

(statearr_38223_38283[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (19))){
var inst_38111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38112 = cljs.core.first(ident);
var inst_38113 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_38112);
var inst_38114 = cljs.core.second(ident);
var inst_38115 = [inst_38113,inst_38114];
var inst_38116 = (new cljs.core.PersistentVector(null,2,(5),inst_38111,inst_38115,null));
var inst_38117 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_38116);
var state_38180__$1 = state_38180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38180__$1,(22),inst_38117);
} else {
if((state_val_38181 === (11))){
var state_38180__$1 = state_38180;
var statearr_38225_38284 = state_38180__$1;
(statearr_38225_38284[(2)] = null);

(statearr_38225_38284[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (9))){
var inst_38082 = (state_38180[(2)]);
var inst_38083 = fluree.db.util.async.throw_err(inst_38082);
var inst_38084 = cljs.core.not_empty(inst_38083);
var state_38180__$1 = state_38180;
if(cljs.core.truth_(inst_38084)){
var statearr_38226_38285 = state_38180__$1;
(statearr_38226_38285[(1)] = (10));

} else {
var statearr_38227_38286 = state_38180__$1;
(statearr_38227_38286[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (5))){
var _ = (function (){var statearr_38228 = state_38180;
(statearr_38228[(4)] = cljs.core.rest((state_38180[(4)])));

return statearr_38228;
})();
var state_38180__$1 = state_38180;
var ex38224 = (state_38180__$1[(2)]);
var statearr_38229_38287 = state_38180__$1;
(statearr_38229_38287[(5)] = ex38224);


var statearr_38230_38288 = state_38180__$1;
(statearr_38230_38288[(1)] = (4));

(statearr_38230_38288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (14))){
var inst_38090 = (state_38180[(7)]);
var state_38180__$1 = state_38180;
var statearr_38231_38289 = state_38180__$1;
(statearr_38231_38289[(2)] = inst_38090);

(statearr_38231_38289[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (26))){
var state_38180__$1 = state_38180;
var statearr_38232_38290 = state_38180__$1;
(statearr_38232_38290[(2)] = null);

(statearr_38232_38290[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (16))){
var inst_38099 = cljs.core.first(ident);
var inst_38100 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38099], 0));
var inst_38101 = ["Subject ID lookup failed. The predicate ",inst_38100," does not exist."].join('');
var inst_38102 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38103 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_38104 = cljs.core.PersistentHashMap.fromArrays(inst_38102,inst_38103);
var inst_38105 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38101,inst_38104);
var inst_38106 = (function(){throw inst_38105})();
var state_38180__$1 = state_38180;
var statearr_38233_38291 = state_38180__$1;
(statearr_38233_38291[(2)] = inst_38106);

(statearr_38233_38291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (38))){
var inst_38160 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38161 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38162 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_38163 = cljs.core.PersistentHashMap.fromArrays(inst_38161,inst_38162);
var inst_38164 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38160,inst_38163);
var inst_38165 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38164);
var state_38180__$1 = state_38180;
var statearr_38234_38292 = state_38180__$1;
(statearr_38234_38292[(2)] = inst_38165);

(statearr_38234_38292[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (30))){
var state_38180__$1 = state_38180;
var statearr_38235_38293 = state_38180__$1;
(statearr_38235_38293[(2)] = null);

(statearr_38235_38293[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (10))){
var state_38180__$1 = state_38180;
var statearr_38236_38294 = state_38180__$1;
(statearr_38236_38294[(2)] = ident);

(statearr_38236_38294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (18))){
var inst_38148 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
var statearr_38237_38295 = state_38180__$1;
(statearr_38237_38295[(2)] = inst_38148);

(statearr_38237_38295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (42))){
var state_38180__$1 = state_38180;
var statearr_38238_38296 = state_38180__$1;
(statearr_38238_38296[(2)] = null);

(statearr_38238_38296[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (37))){
var inst_38158 = (state_38180[(2)]);
var state_38180__$1 = state_38180;
if(cljs.core.truth_(inst_38158)){
var statearr_38239_38297 = state_38180__$1;
(statearr_38239_38297[(1)] = (38));

} else {
var statearr_38240_38298 = state_38180__$1;
(statearr_38240_38298[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38181 === (8))){
var inst_38150 = (state_38180[(10)]);
var inst_38150__$1 = (state_38180[(2)]);
var state_38180__$1 = (function (){var statearr_38241 = state_38180;
(statearr_38241[(10)] = inst_38150__$1);

return statearr_38241;
})();
if(cljs.core.truth_(inst_38150__$1)){
var statearr_38242_38299 = state_38180__$1;
(statearr_38242_38299[(1)] = (32));

} else {
var statearr_38243_38300 = state_38180__$1;
(statearr_38243_38300[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__11410__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__11410__auto____0 = (function (){
var statearr_38244 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38244[(0)] = fluree$db$graphdb$subid_$_state_machine__11410__auto__);

(statearr_38244[(1)] = (1));

return statearr_38244;
});
var fluree$db$graphdb$subid_$_state_machine__11410__auto____1 = (function (state_38180){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38180);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38245){var ex__11413__auto__ = e38245;
var statearr_38246_38301 = state_38180;
(statearr_38246_38301[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38180[(4)]))){
var statearr_38247_38302 = state_38180;
(statearr_38247_38302[(1)] = cljs.core.first((state_38180[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38303 = state_38180;
state_38180 = G__38303;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__11410__auto__ = function(state_38180){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__11410__auto____1.call(this,state_38180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__11410__auto____0;
fluree$db$graphdb$subid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__11410__auto____1;
return fluree$db$graphdb$subid_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38248 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38248[(6)] = c__11484__auto___38249);

return statearr_38248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__38304){
var map__38305 = p__38304;
var map__38305__$1 = cljs.core.__destructure_map(map__38305);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38305__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38305__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38321){
var state_val_38322 = (state_38321[(1)]);
if((state_val_38322 === (1))){
var state_38321__$1 = state_38321;
var statearr_38323_38337 = state_38321__$1;
(statearr_38323_38337[(2)] = null);

(statearr_38323_38337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38322 === (2))){
var _ = (function (){var statearr_38324 = state_38321;
(statearr_38324[(4)] = cljs.core.cons((5),(state_38321[(4)])));

return statearr_38324;
})();
var inst_38312 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_38321__$1 = state_38321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38321__$1,(6),inst_38312);
} else {
if((state_val_38322 === (3))){
var inst_38319 = (state_38321[(2)]);
var state_38321__$1 = state_38321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38321__$1,inst_38319);
} else {
if((state_val_38322 === (4))){
var inst_38306 = (state_38321[(2)]);
var state_38321__$1 = state_38321;
var statearr_38326_38338 = state_38321__$1;
(statearr_38326_38338[(2)] = inst_38306);

(statearr_38326_38338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38322 === (5))){
var _ = (function (){var statearr_38327 = state_38321;
(statearr_38327[(4)] = cljs.core.rest((state_38321[(4)])));

return statearr_38327;
})();
var state_38321__$1 = state_38321;
var ex38325 = (state_38321__$1[(2)]);
var statearr_38328_38339 = state_38321__$1;
(statearr_38328_38339[(5)] = ex38325);


if((ex38325 instanceof Error)){
var statearr_38329_38340 = state_38321__$1;
(statearr_38329_38340[(1)] = (4));

(statearr_38329_38340[(5)] = null);

} else {
throw ex38325;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38322 === (6))){
var inst_38314 = (state_38321[(2)]);
var inst_38315 = fluree.db.util.async.throw_err(inst_38314);
var inst_38316 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38315,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_38330 = state_38321;
(statearr_38330[(4)] = cljs.core.rest((state_38321[(4)])));

return statearr_38330;
})();
var state_38321__$1 = state_38321;
var statearr_38331_38341 = state_38321__$1;
(statearr_38331_38341[(2)] = inst_38316);

(statearr_38331_38341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____0 = (function (){
var statearr_38332 = [null,null,null,null,null,null,null];
(statearr_38332[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__);

(statearr_38332[(1)] = (1));

return statearr_38332;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____1 = (function (state_38321){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38321);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38333){var ex__11413__auto__ = e38333;
var statearr_38334_38342 = state_38321;
(statearr_38334_38342[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38321[(4)]))){
var statearr_38335_38343 = state_38321;
(statearr_38335_38343[(1)] = cljs.core.first((state_38321[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38344 = state_38321;
state_38321 = G__38344;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__ = function(state_38321){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____1.call(this,state_38321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38336 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38336[(6)] = c__11484__auto__);

return statearr_38336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__38345,property,collection){
var map__38346 = p__38345;
var map__38346__$1 = cljs.core.__destructure_map(map__38346);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38346__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__38347 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__38347.cljs$core$IFn$_invoke$arity$1 ? fexpr__38347.cljs$core$IFn$_invoke$arity$1(property) : fexpr__38347.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__38348,property,predicate){
var map__38349 = p__38348;
var map__38349__$1 = cljs.core.__destructure_map(map__38349);
var this$ = map__38349__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38349__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__38350 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__38350.cljs$core$IFn$_invoke$arity$1 ? fexpr__38350.cljs$core$IFn$_invoke$arity$1(property) : fexpr__38350.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__38351 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__38351);
} else {
return G__38351;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__38353 = arguments.length;
switch (G__38353) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38385){
var state_val_38386 = (state_38385[(1)]);
if((state_val_38386 === (7))){
var state_38385__$1 = state_38385;
var statearr_38387_38481 = state_38385__$1;
(statearr_38387_38481[(2)] = null);

(statearr_38387_38481[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (1))){
var state_38385__$1 = state_38385;
var statearr_38388_38482 = state_38385__$1;
(statearr_38388_38482[(2)] = null);

(statearr_38388_38482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (4))){
var inst_38354 = (state_38385[(2)]);
var state_38385__$1 = state_38385;
var statearr_38389_38483 = state_38385__$1;
(statearr_38389_38483[(2)] = inst_38354);

(statearr_38389_38483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (6))){
var inst_38368 = (state_38385[(7)]);
var inst_38367 = (state_38385[(2)]);
var inst_38368__$1 = fluree.db.util.async.throw_err(inst_38367);
var inst_38369 = (inst_38368__$1 == null);
var state_38385__$1 = (function (){var statearr_38390 = state_38385;
(statearr_38390[(7)] = inst_38368__$1);

return statearr_38390;
})();
if(cljs.core.truth_(inst_38369)){
var statearr_38391_38484 = state_38385__$1;
(statearr_38391_38484[(1)] = (7));

} else {
var statearr_38392_38485 = state_38385__$1;
(statearr_38392_38485[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (3))){
var inst_38383 = (state_38385[(2)]);
var state_38385__$1 = state_38385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38385__$1,inst_38383);
} else {
if((state_val_38386 === (12))){
var inst_38380 = (state_38385[(2)]);
var _ = (function (){var statearr_38393 = state_38385;
(statearr_38393[(4)] = cljs.core.rest((state_38385[(4)])));

return statearr_38393;
})();
var state_38385__$1 = state_38385;
var statearr_38394_38486 = state_38385__$1;
(statearr_38394_38486[(2)] = inst_38380);

(statearr_38394_38486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (2))){
var _ = (function (){var statearr_38395 = state_38385;
(statearr_38395[(4)] = cljs.core.cons((5),(state_38385[(4)])));

return statearr_38395;
})();
var inst_38361 = fluree.db.dbproto._rootdb(this$);
var inst_38362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38363 = [tag_id,(30)];
var inst_38364 = (new cljs.core.PersistentVector(null,2,(5),inst_38362,inst_38363,null));
var inst_38365 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_38361,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38364);
var state_38385__$1 = state_38385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38385__$1,(6),inst_38365);
} else {
if((state_val_38386 === (11))){
var inst_38374 = (state_38385[(8)]);
var inst_38378 = inst_38374.o;
var state_38385__$1 = state_38385;
var statearr_38397_38487 = state_38385__$1;
(statearr_38397_38487[(2)] = inst_38378);

(statearr_38397_38487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (9))){
var inst_38374 = (state_38385[(8)]);
var inst_38374__$1 = (state_38385[(2)]);
var inst_38375 = (inst_38374__$1 == null);
var state_38385__$1 = (function (){var statearr_38398 = state_38385;
(statearr_38398[(8)] = inst_38374__$1);

return statearr_38398;
})();
if(cljs.core.truth_(inst_38375)){
var statearr_38399_38488 = state_38385__$1;
(statearr_38399_38488[(1)] = (10));

} else {
var statearr_38400_38489 = state_38385__$1;
(statearr_38400_38489[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (5))){
var _ = (function (){var statearr_38401 = state_38385;
(statearr_38401[(4)] = cljs.core.rest((state_38385[(4)])));

return statearr_38401;
})();
var state_38385__$1 = state_38385;
var ex38396 = (state_38385__$1[(2)]);
var statearr_38402_38490 = state_38385__$1;
(statearr_38402_38490[(5)] = ex38396);


if((ex38396 instanceof Error)){
var statearr_38403_38491 = state_38385__$1;
(statearr_38403_38491[(1)] = (4));

(statearr_38403_38491[(5)] = null);

} else {
throw ex38396;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (10))){
var state_38385__$1 = state_38385;
var statearr_38404_38492 = state_38385__$1;
(statearr_38404_38492[(2)] = null);

(statearr_38404_38492[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38386 === (8))){
var inst_38368 = (state_38385[(7)]);
var inst_38372 = cljs.core.first(inst_38368);
var state_38385__$1 = state_38385;
var statearr_38405_38493 = state_38385__$1;
(statearr_38405_38493[(2)] = inst_38372);

(statearr_38405_38493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_38406 = [null,null,null,null,null,null,null,null,null];
(statearr_38406[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_38406[(1)] = (1));

return statearr_38406;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_38385){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38385);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38407){var ex__11413__auto__ = e38407;
var statearr_38408_38494 = state_38385;
(statearr_38408_38494[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38385[(4)]))){
var statearr_38409_38495 = state_38385;
(statearr_38409_38495[(1)] = cljs.core.first((state_38385[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38496 = state_38385;
state_38385 = G__38496;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_38385){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_38385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38410 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38410[(6)] = c__11484__auto__);

return statearr_38410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38446){
var state_val_38447 = (state_38446[(1)]);
if((state_val_38447 === (7))){
var inst_38420 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_38446__$1 = state_38446;
var statearr_38448_38497 = state_38446__$1;
(statearr_38448_38497[(2)] = inst_38420);

(statearr_38448_38497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (1))){
var state_38446__$1 = state_38446;
var statearr_38449_38498 = state_38446__$1;
(statearr_38449_38498[(2)] = null);

(statearr_38449_38498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (4))){
var inst_38411 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38450_38499 = state_38446__$1;
(statearr_38450_38499[(2)] = inst_38411);

(statearr_38450_38499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (15))){
var inst_38441 = (state_38446[(2)]);
var _ = (function (){var statearr_38451 = state_38446;
(statearr_38451[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38451;
})();
var state_38446__$1 = state_38446;
var statearr_38452_38500 = state_38446__$1;
(statearr_38452_38500[(2)] = inst_38441);

(statearr_38452_38500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (13))){
var inst_38426 = (state_38446[(7)]);
var inst_38432 = clojure.string.includes_QMARK_(inst_38426,":");
var state_38446__$1 = state_38446;
if(inst_38432){
var statearr_38453_38501 = state_38446__$1;
(statearr_38453_38501[(1)] = (16));

} else {
var statearr_38454_38502 = state_38446__$1;
(statearr_38454_38502[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (6))){
var state_38446__$1 = state_38446;
var statearr_38455_38503 = state_38446__$1;
(statearr_38455_38503[(2)] = pred);

(statearr_38455_38503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (17))){
var inst_38426 = (state_38446[(7)]);
var state_38446__$1 = state_38446;
var statearr_38456_38504 = state_38446__$1;
(statearr_38456_38504[(2)] = inst_38426);

(statearr_38456_38504[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (3))){
var inst_38444 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38446__$1,inst_38444);
} else {
if((state_val_38447 === (12))){
var inst_38430 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38430)){
var statearr_38457_38505 = state_38446__$1;
(statearr_38457_38505[(1)] = (13));

} else {
var statearr_38458_38506 = state_38446__$1;
(statearr_38458_38506[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (2))){
var _ = (function (){var statearr_38459 = state_38446;
(statearr_38459[(4)] = cljs.core.cons((5),(state_38446[(4)])));

return statearr_38459;
})();
var inst_38417 = typeof pred === 'string';
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38417)){
var statearr_38460_38507 = state_38446__$1;
(statearr_38460_38507[(1)] = (6));

} else {
var statearr_38461_38508 = state_38446__$1;
(statearr_38461_38508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (11))){
var inst_38422 = (state_38446[(8)]);
var state_38446__$1 = state_38446;
var statearr_38463_38509 = state_38446__$1;
(statearr_38463_38509[(2)] = inst_38422);

(statearr_38463_38509[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (9))){
var inst_38422 = (state_38446[(8)]);
var inst_38425 = (state_38446[(2)]);
var inst_38426 = fluree.db.util.async.throw_err(inst_38425);
var state_38446__$1 = (function (){var statearr_38464 = state_38446;
(statearr_38464[(7)] = inst_38426);

return statearr_38464;
})();
if(cljs.core.truth_(inst_38422)){
var statearr_38465_38510 = state_38446__$1;
(statearr_38465_38510[(1)] = (10));

} else {
var statearr_38466_38511 = state_38446__$1;
(statearr_38466_38511[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (5))){
var _ = (function (){var statearr_38467 = state_38446;
(statearr_38467[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38467;
})();
var state_38446__$1 = state_38446;
var ex38462 = (state_38446__$1[(2)]);
var statearr_38468_38512 = state_38446__$1;
(statearr_38468_38512[(5)] = ex38462);


if((ex38462 instanceof Error)){
var statearr_38469_38513 = state_38446__$1;
(statearr_38469_38513[(1)] = (4));

(statearr_38469_38513[(5)] = null);

} else {
throw ex38462;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (14))){
var state_38446__$1 = state_38446;
var statearr_38470_38514 = state_38446__$1;
(statearr_38470_38514[(2)] = null);

(statearr_38470_38514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (16))){
var inst_38426 = (state_38446[(7)]);
var inst_38434 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_38426,/:/);
var inst_38435 = cljs.core.second(inst_38434);
var state_38446__$1 = state_38446;
var statearr_38471_38515 = state_38446__$1;
(statearr_38471_38515[(2)] = inst_38435);

(statearr_38471_38515[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (10))){
var inst_38426 = (state_38446[(7)]);
var state_38446__$1 = state_38446;
var statearr_38472_38516 = state_38446__$1;
(statearr_38472_38516[(2)] = inst_38426);

(statearr_38472_38516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (18))){
var inst_38438 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38473_38517 = state_38446__$1;
(statearr_38473_38517[(2)] = inst_38438);

(statearr_38473_38517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38447 === (8))){
var inst_38422 = (state_38446[(2)]);
var inst_38423 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_38446__$1 = (function (){var statearr_38474 = state_38446;
(statearr_38474[(8)] = inst_38422);

return statearr_38474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38446__$1,(9),inst_38423);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_38475 = [null,null,null,null,null,null,null,null,null];
(statearr_38475[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_38475[(1)] = (1));

return statearr_38475;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_38446){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38446);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38476){var ex__11413__auto__ = e38476;
var statearr_38477_38518 = state_38446;
(statearr_38477_38518[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38446[(4)]))){
var statearr_38478_38519 = state_38446;
(statearr_38478_38519[(1)] = cljs.core.first((state_38446[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38520 = state_38446;
state_38446 = G__38520;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_38446){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_38446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38479 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38479[(6)] = c__11484__auto__);

return statearr_38479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__38522 = arguments.length;
switch (G__38522) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38555){
var state_val_38556 = (state_38555[(1)]);
if((state_val_38556 === (7))){
var state_38555__$1 = state_38555;
var statearr_38557_38645 = state_38555__$1;
(statearr_38557_38645[(2)] = null);

(statearr_38557_38645[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (1))){
var state_38555__$1 = state_38555;
var statearr_38558_38646 = state_38555__$1;
(statearr_38558_38646[(2)] = null);

(statearr_38558_38646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (4))){
var inst_38523 = (state_38555[(2)]);
var state_38555__$1 = state_38555;
var statearr_38559_38647 = state_38555__$1;
(statearr_38559_38647[(2)] = inst_38523);

(statearr_38559_38647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (6))){
var inst_38538 = (state_38555[(7)]);
var inst_38537 = (state_38555[(2)]);
var inst_38538__$1 = fluree.db.util.async.throw_err(inst_38537);
var inst_38539 = (inst_38538__$1 == null);
var state_38555__$1 = (function (){var statearr_38560 = state_38555;
(statearr_38560[(7)] = inst_38538__$1);

return statearr_38560;
})();
if(cljs.core.truth_(inst_38539)){
var statearr_38561_38648 = state_38555__$1;
(statearr_38561_38648[(1)] = (7));

} else {
var statearr_38562_38649 = state_38555__$1;
(statearr_38562_38649[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (3))){
var inst_38553 = (state_38555[(2)]);
var state_38555__$1 = state_38555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38555__$1,inst_38553);
} else {
if((state_val_38556 === (12))){
var inst_38550 = (state_38555[(2)]);
var _ = (function (){var statearr_38563 = state_38555;
(statearr_38563[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38563;
})();
var state_38555__$1 = state_38555;
var statearr_38564_38650 = state_38555__$1;
(statearr_38564_38650[(2)] = inst_38550);

(statearr_38564_38650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (2))){
var _ = (function (){var statearr_38565 = state_38555;
(statearr_38565[(4)] = cljs.core.cons((5),(state_38555[(4)])));

return statearr_38565;
})();
var inst_38529 = (30);
var inst_38531 = fluree.db.dbproto._rootdb(this$);
var inst_38532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38533 = [inst_38529,tag_name];
var inst_38534 = (new cljs.core.PersistentVector(null,2,(5),inst_38532,inst_38533,null));
var inst_38535 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_38531,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_38534);
var state_38555__$1 = state_38555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38555__$1,(6),inst_38535);
} else {
if((state_val_38556 === (11))){
var inst_38544 = (state_38555[(8)]);
var inst_38548 = inst_38544.s;
var state_38555__$1 = state_38555;
var statearr_38567_38651 = state_38555__$1;
(statearr_38567_38651[(2)] = inst_38548);

(statearr_38567_38651[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (9))){
var inst_38544 = (state_38555[(8)]);
var inst_38544__$1 = (state_38555[(2)]);
var inst_38545 = (inst_38544__$1 == null);
var state_38555__$1 = (function (){var statearr_38568 = state_38555;
(statearr_38568[(8)] = inst_38544__$1);

return statearr_38568;
})();
if(cljs.core.truth_(inst_38545)){
var statearr_38569_38652 = state_38555__$1;
(statearr_38569_38652[(1)] = (10));

} else {
var statearr_38570_38653 = state_38555__$1;
(statearr_38570_38653[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (5))){
var _ = (function (){var statearr_38571 = state_38555;
(statearr_38571[(4)] = cljs.core.rest((state_38555[(4)])));

return statearr_38571;
})();
var state_38555__$1 = state_38555;
var ex38566 = (state_38555__$1[(2)]);
var statearr_38572_38654 = state_38555__$1;
(statearr_38572_38654[(5)] = ex38566);


if((ex38566 instanceof Error)){
var statearr_38573_38655 = state_38555__$1;
(statearr_38573_38655[(1)] = (4));

(statearr_38573_38655[(5)] = null);

} else {
throw ex38566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (10))){
var state_38555__$1 = state_38555;
var statearr_38574_38656 = state_38555__$1;
(statearr_38574_38656[(2)] = null);

(statearr_38574_38656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38556 === (8))){
var inst_38538 = (state_38555[(7)]);
var inst_38542 = cljs.core.first(inst_38538);
var state_38555__$1 = state_38555;
var statearr_38575_38657 = state_38555__$1;
(statearr_38575_38657[(2)] = inst_38542);

(statearr_38575_38657[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_38576 = [null,null,null,null,null,null,null,null,null];
(statearr_38576[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_38576[(1)] = (1));

return statearr_38576;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_38555){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38555);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38577){var ex__11413__auto__ = e38577;
var statearr_38578_38658 = state_38555;
(statearr_38578_38658[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38555[(4)]))){
var statearr_38579_38659 = state_38555;
(statearr_38579_38659[(1)] = cljs.core.first((state_38555[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38660 = state_38555;
state_38555 = G__38660;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_38555){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_38555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38580 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38580[(6)] = c__11484__auto__);

return statearr_38580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_38615){
var state_val_38616 = (state_38615[(1)]);
if((state_val_38616 === (7))){
var inst_38594 = typeof pred === 'string';
var state_38615__$1 = state_38615;
if(cljs.core.truth_(inst_38594)){
var statearr_38617_38661 = state_38615__$1;
(statearr_38617_38661[(1)] = (10));

} else {
var statearr_38618_38662 = state_38615__$1;
(statearr_38618_38662[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (1))){
var state_38615__$1 = state_38615;
var statearr_38619_38663 = state_38615__$1;
(statearr_38619_38663[(2)] = null);

(statearr_38619_38663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (4))){
var inst_38581 = (state_38615[(2)]);
var state_38615__$1 = state_38615;
var statearr_38620_38664 = state_38615__$1;
(statearr_38620_38664[(2)] = inst_38581);

(statearr_38620_38664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (15))){
var inst_38608 = (state_38615[(2)]);
var state_38615__$1 = state_38615;
var statearr_38621_38665 = state_38615__$1;
(statearr_38621_38665[(2)] = inst_38608);

(statearr_38621_38665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (13))){
var inst_38599 = (state_38615[(7)]);
var inst_38601 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38599),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_38602 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_38601);
var state_38615__$1 = state_38615;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38615__$1,(16),inst_38602);
} else {
if((state_val_38616 === (6))){
var inst_38589 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_38615__$1 = state_38615;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38615__$1,(9),inst_38589);
} else {
if((state_val_38616 === (3))){
var inst_38613 = (state_38615[(2)]);
var state_38615__$1 = state_38615;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38615__$1,inst_38613);
} else {
if((state_val_38616 === (12))){
var inst_38599 = (state_38615[(7)]);
var inst_38599__$1 = (state_38615[(2)]);
var state_38615__$1 = (function (){var statearr_38622 = state_38615;
(statearr_38622[(7)] = inst_38599__$1);

return statearr_38622;
})();
if(cljs.core.truth_(inst_38599__$1)){
var statearr_38623_38666 = state_38615__$1;
(statearr_38623_38666[(1)] = (13));

} else {
var statearr_38624_38667 = state_38615__$1;
(statearr_38624_38667[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (2))){
var _ = (function (){var statearr_38625 = state_38615;
(statearr_38625[(4)] = cljs.core.cons((5),(state_38615[(4)])));

return statearr_38625;
})();
var inst_38587 = clojure.string.includes_QMARK_(tag_name,"/");
var state_38615__$1 = state_38615;
if(inst_38587){
var statearr_38626_38668 = state_38615__$1;
(statearr_38626_38668[(1)] = (6));

} else {
var statearr_38627_38669 = state_38615__$1;
(statearr_38627_38669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (11))){
var inst_38597 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_38615__$1 = state_38615;
var statearr_38629_38670 = state_38615__$1;
(statearr_38629_38670[(2)] = inst_38597);

(statearr_38629_38670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (9))){
var inst_38591 = (state_38615[(2)]);
var inst_38592 = fluree.db.util.async.throw_err(inst_38591);
var state_38615__$1 = state_38615;
var statearr_38630_38671 = state_38615__$1;
(statearr_38630_38671[(2)] = inst_38592);

(statearr_38630_38671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (5))){
var _ = (function (){var statearr_38631 = state_38615;
(statearr_38631[(4)] = cljs.core.rest((state_38615[(4)])));

return statearr_38631;
})();
var state_38615__$1 = state_38615;
var ex38628 = (state_38615__$1[(2)]);
var statearr_38632_38672 = state_38615__$1;
(statearr_38632_38672[(5)] = ex38628);


if((ex38628 instanceof Error)){
var statearr_38633_38673 = state_38615__$1;
(statearr_38633_38673[(1)] = (4));

(statearr_38633_38673[(5)] = null);

} else {
throw ex38628;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (14))){
var state_38615__$1 = state_38615;
var statearr_38634_38674 = state_38615__$1;
(statearr_38634_38674[(2)] = null);

(statearr_38634_38674[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (16))){
var inst_38604 = (state_38615[(2)]);
var inst_38605 = fluree.db.util.async.throw_err(inst_38604);
var state_38615__$1 = state_38615;
var statearr_38635_38675 = state_38615__$1;
(statearr_38635_38675[(2)] = inst_38605);

(statearr_38635_38675[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (10))){
var state_38615__$1 = state_38615;
var statearr_38636_38676 = state_38615__$1;
(statearr_38636_38676[(2)] = pred);

(statearr_38636_38676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38616 === (8))){
var inst_38610 = (state_38615[(2)]);
var _ = (function (){var statearr_38637 = state_38615;
(statearr_38637[(4)] = cljs.core.rest((state_38615[(4)])));

return statearr_38637;
})();
var state_38615__$1 = state_38615;
var statearr_38638_38677 = state_38615__$1;
(statearr_38638_38677[(2)] = inst_38610);

(statearr_38638_38677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11410__auto__ = null;
var fluree$db$graphdb$state_machine__11410__auto____0 = (function (){
var statearr_38639 = [null,null,null,null,null,null,null,null];
(statearr_38639[(0)] = fluree$db$graphdb$state_machine__11410__auto__);

(statearr_38639[(1)] = (1));

return statearr_38639;
});
var fluree$db$graphdb$state_machine__11410__auto____1 = (function (state_38615){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_38615);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e38640){var ex__11413__auto__ = e38640;
var statearr_38641_38678 = state_38615;
(statearr_38641_38678[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_38615[(4)]))){
var statearr_38642_38679 = state_38615;
(statearr_38642_38679[(1)] = cljs.core.first((state_38615[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38680 = state_38615;
state_38615 = G__38680;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11410__auto__ = function(state_38615){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11410__auto____1.call(this,state_38615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11410__auto____0;
fluree$db$graphdb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11410__auto____1;
return fluree$db$graphdb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_38643 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_38643[(6)] = c__11484__auto__);

return statearr_38643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k38682,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__38686 = k38682;
var G__38686__$1 = (((G__38686 instanceof cljs.core.Keyword))?G__38686.fqn:null);
switch (G__38686__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38682,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__38687){
var vec__38688 = p__38687;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38688,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38688,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38681){
var self__ = this;
var G__38681__$1 = this;
return (new cljs.core.RecordIter((0),G__38681__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__38691 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__38691(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38683,other38684){
var self__ = this;
var this38683__$1 = this;
return (((!((other38684 == null)))) && ((((this38683__$1.constructor === other38684.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.conn,other38684.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.network,other38684.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.dbid,other38684.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.block,other38684.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.t,other38684.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.tt_id,other38684.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.stats,other38684.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.spot,other38684.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.psot,other38684.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.post,other38684.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.opst,other38684.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.schema,other38684.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.settings,other38684.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.index_configs,other38684.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.schema_cache,other38684.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.novelty,other38684.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.permissions,other38684.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.fork,other38684.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.fork_block,other38684.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.current_db_fn,other38684.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38683__$1.__extmap,other38684.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k38682){
var self__ = this;
var this__4509__auto____$1 = this;
var G__38692 = k38682;
var G__38692__$1 = (((G__38692 instanceof cljs.core.Keyword))?G__38692.fqn:null);
switch (G__38692__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k38682);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__38681){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__38693 = cljs.core.keyword_identical_QMARK_;
var expr__38694 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__38696 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__38697 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38696,G__38697) : pred__38693.call(null,G__38696,G__38697));
})())){
return (new fluree.db.graphdb.GraphDb(G__38681,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38698 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__38699 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38698,G__38699) : pred__38693.call(null,G__38698,G__38699));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__38681,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38700 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__38701 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38700,G__38701) : pred__38693.call(null,G__38700,G__38701));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__38681,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38702 = new cljs.core.Keyword(null,"block","block",664686210);
var G__38703 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38702,G__38703) : pred__38693.call(null,G__38702,G__38703));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__38681,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38704 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__38705 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38704,G__38705) : pred__38693.call(null,G__38704,G__38705));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__38681,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38706 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__38707 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38706,G__38707) : pred__38693.call(null,G__38706,G__38707));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__38681,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38708 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__38709 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38708,G__38709) : pred__38693.call(null,G__38708,G__38709));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__38681,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38710 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__38711 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38710,G__38711) : pred__38693.call(null,G__38710,G__38711));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__38681,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38712 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__38713 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38712,G__38713) : pred__38693.call(null,G__38712,G__38713));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__38681,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38714 = new cljs.core.Keyword(null,"post","post",269697687);
var G__38715 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38714,G__38715) : pred__38693.call(null,G__38714,G__38715));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__38681,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38716 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__38717 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38716,G__38717) : pred__38693.call(null,G__38716,G__38717));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__38681,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38718 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__38719 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38718,G__38719) : pred__38693.call(null,G__38718,G__38719));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__38681,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38720 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__38721 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38720,G__38721) : pred__38693.call(null,G__38720,G__38721));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__38681,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38722 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__38723 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38722,G__38723) : pred__38693.call(null,G__38722,G__38723));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__38681,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38724 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__38725 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38724,G__38725) : pred__38693.call(null,G__38724,G__38725));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__38681,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38726 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__38727 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38726,G__38727) : pred__38693.call(null,G__38726,G__38727));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__38681,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38728 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__38729 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38728,G__38729) : pred__38693.call(null,G__38728,G__38729));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__38681,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38730 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__38731 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38730,G__38731) : pred__38693.call(null,G__38730,G__38731));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__38681,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38732 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__38733 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38732,G__38733) : pred__38693.call(null,G__38732,G__38733));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__38681,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38734 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__38735 = expr__38694;
return (pred__38693.cljs$core$IFn$_invoke$arity$2 ? pred__38693.cljs$core$IFn$_invoke$arity$2(G__38734,G__38735) : pred__38693.call(null,G__38734,G__38735));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__38681,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__38681),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__38681){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__38681,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__38685){
var extmap__4542__auto__ = (function (){var G__38736 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38685,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__38685)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38736);
} else {
return G__38736;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__38685),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__38685),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
