// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__29511 = arguments.length;
switch (G__29511) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__29514 = arguments.length;
switch (G__29514) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___29567 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29545){
var state_val_29546 = (state_29545[(1)]);
if((state_val_29546 === (1))){
var state_29545__$1 = state_29545;
var statearr_29547_29568 = state_29545__$1;
(statearr_29547_29568[(2)] = null);

(statearr_29547_29568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (2))){
var _ = (function (){var statearr_29548 = state_29545;
(statearr_29548[(4)] = cljs.core.cons((5),(state_29545[(4)])));

return statearr_29548;
})();
var inst_29522 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_29545__$1 = state_29545;
if(cljs.core.truth_(inst_29522)){
var statearr_29549_29569 = state_29545__$1;
(statearr_29549_29569[(1)] = (6));

} else {
var statearr_29550_29570 = state_29545__$1;
(statearr_29550_29570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (3))){
var inst_29543 = (state_29545[(2)]);
var state_29545__$1 = state_29545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29545__$1,inst_29543);
} else {
if((state_val_29546 === (4))){
var inst_29515 = (state_29545[(2)]);
var inst_29516 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_29515);
var state_29545__$1 = state_29545;
var statearr_29552_29571 = state_29545__$1;
(statearr_29552_29571[(2)] = inst_29516);

(statearr_29552_29571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (5))){
var _ = (function (){var statearr_29553 = state_29545;
(statearr_29553[(4)] = cljs.core.rest((state_29545[(4)])));

return statearr_29553;
})();
var state_29545__$1 = state_29545;
var ex29551 = (state_29545__$1[(2)]);
var statearr_29554_29572 = state_29545__$1;
(statearr_29554_29572[(5)] = ex29551);


var statearr_29555_29573 = state_29545__$1;
(statearr_29555_29573[(1)] = (4));

(statearr_29555_29573[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (6))){
var inst_29524 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29525 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_29526 = cljs.core.PersistentHashMap.fromArrays(inst_29524,inst_29525);
var inst_29527 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_29526);
var inst_29528 = (function(){throw inst_29527})();
var state_29545__$1 = state_29545;
var statearr_29556_29574 = state_29545__$1;
(statearr_29556_29574[(2)] = inst_29528);

(statearr_29556_29574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (7))){
var inst_29530 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29532 = [operation,data,pc,opts];
var inst_29533 = (new cljs.core.PersistentVector(null,4,(5),inst_29531,inst_29532,null));
var inst_29534 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29530,inst_29533);
var inst_29535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29536 = [operation,data,pc,opts];
var inst_29537 = (new cljs.core.PersistentVector(null,4,(5),inst_29535,inst_29536,null));
var inst_29538 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_29537], 0));
var state_29545__$1 = (function (){var statearr_29557 = state_29545;
(statearr_29557[(7)] = inst_29534);

return statearr_29557;
})();
var statearr_29558_29575 = state_29545__$1;
(statearr_29558_29575[(2)] = inst_29538);

(statearr_29558_29575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29546 === (8))){
var inst_29540 = (state_29545[(2)]);
var _ = (function (){var statearr_29559 = state_29545;
(statearr_29559[(4)] = cljs.core.rest((state_29545[(4)])));

return statearr_29559;
})();
var state_29545__$1 = state_29545;
var statearr_29560_29576 = state_29545__$1;
(statearr_29560_29576[(2)] = inst_29540);

(statearr_29560_29576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__11410__auto__ = null;
var fluree$db$operations$state_machine__11410__auto____0 = (function (){
var statearr_29561 = [null,null,null,null,null,null,null,null];
(statearr_29561[(0)] = fluree$db$operations$state_machine__11410__auto__);

(statearr_29561[(1)] = (1));

return statearr_29561;
});
var fluree$db$operations$state_machine__11410__auto____1 = (function (state_29545){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29545);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29562){var ex__11413__auto__ = e29562;
var statearr_29563_29577 = state_29545;
(statearr_29563_29577[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29545[(4)]))){
var statearr_29564_29578 = state_29545;
(statearr_29564_29578[(1)] = cljs.core.first((state_29545[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29579 = state_29545;
state_29545 = G__29579;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11410__auto__ = function(state_29545){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11410__auto____1.call(this,state_29545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11410__auto____0;
fluree$db$operations$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11410__auto____1;
return fluree$db$operations$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29565 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29565[(6)] = c__11484__auto___29567);

return statearr_29565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__29581 = arguments.length;
switch (G__29581) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__29582){
var map__29583 = p__29582;
var map__29583__$1 = cljs.core.__destructure_map(map__29583);
var opts = map__29583__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29583__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__29584 = session;
var map__29584__$1 = cljs.core.__destructure_map(map__29584);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29584__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29584__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29584__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29611 = arguments.length;
var i__4865__auto___29612 = (0);
while(true){
if((i__4865__auto___29612 < len__4864__auto___29611)){
args__4870__auto__.push((arguments[i__4865__auto___29612]));

var G__29613 = (i__4865__auto___29612 + (1));
i__4865__auto___29612 = G__29613;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__29588){
var vec__29589 = p__29588;
var map__29592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29589,(0),null);
var map__29592__$1 = cljs.core.__destructure_map(map__29592);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29592__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29592__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__29589;
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29604){
var state_val_29605 = (state_29604[(1)]);
if((state_val_29605 === (1))){
var inst_29594 = session;
var inst_29595 = cljs.core.__destructure_map(inst_29594);
var inst_29596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29595,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_29597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29595,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_29598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29595,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_29599 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_29600 = [inst_29596,inst_29597,toBlock,toTime];
var inst_29601 = cljs.core.PersistentHashMap.fromArrays(inst_29599,inst_29600);
var inst_29602 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_29598,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_29601);
var state_29604__$1 = state_29604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29604__$1,inst_29602);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__11410__auto__ = null;
var fluree$db$operations$state_machine__11410__auto____0 = (function (){
var statearr_29606 = [null,null,null,null,null,null,null];
(statearr_29606[(0)] = fluree$db$operations$state_machine__11410__auto__);

(statearr_29606[(1)] = (1));

return statearr_29606;
});
var fluree$db$operations$state_machine__11410__auto____1 = (function (state_29604){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29604);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29607){var ex__11413__auto__ = e29607;
var statearr_29608_29614 = state_29604;
(statearr_29608_29614[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29604[(4)]))){
var statearr_29609_29615 = state_29604;
(statearr_29609_29615[(1)] = cljs.core.first((state_29604[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29616 = state_29604;
state_29604 = G__29616;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11410__auto__ = function(state_29604){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11410__auto____1.call(this,state_29604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11410__auto____0;
fluree$db$operations$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11410__auto____1;
return fluree$db$operations$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29610 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29610[(6)] = c__11484__auto__);

return statearr_29610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq29586){
var G__29587 = cljs.core.first(seq29586);
var seq29586__$1 = cljs.core.next(seq29586);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29587,seq29586__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__29617 = session;
var map__29617__$1 = cljs.core.__destructure_map(map__29617);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29617__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29617__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29617__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__29619 = arguments.length;
switch (G__29619) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__29620 = opts;
var map__29620__$1 = cljs.core.__destructure_map(map__29620);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29620__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29620__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
