// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e30891){var e = e30891;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__30892_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__30892_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__30892_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__30892_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__30892_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30893_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30893_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30894_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30894_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__30899 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30895_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30895_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4251__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__30902 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30902,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30902,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30896_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30896_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30897_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30897_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30898_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__30898_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30905_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__30905_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__30906 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__30906) : intersecting_vars.call(null,G__30906));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__30909,optional_QMARK_,fuel,max_fuel){
var map__30910 = p__30909;
var map__30910__$1 = cljs.core.__destructure_map(map__30910);
var res = map__30910__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30910__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30976){
var state_val_30977 = (state_30976[(1)]);
if((state_val_30977 === (7))){
var inst_30965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30966 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_30967 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30966,clause);
var inst_30968 = [null,inst_30967];
var inst_30969 = (new cljs.core.PersistentVector(null,2,(5),inst_30965,inst_30968,null));
var state_30976__$1 = state_30976;
var statearr_30978_31006 = state_30976__$1;
(statearr_30978_31006[(2)] = inst_30969);

(statearr_30978_31006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (1))){
var state_30976__$1 = state_30976;
var statearr_30979_31007 = state_30976__$1;
(statearr_30979_31007[(2)] = null);

(statearr_30979_31007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (4))){
var inst_30911 = (state_30976[(2)]);
var state_30976__$1 = state_30976;
var statearr_30980_31008 = state_30976__$1;
(statearr_30980_31008[(2)] = inst_30911);

(statearr_30980_31008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (15))){
var inst_30954 = (state_30976[(2)]);
var inst_30955 = fluree.db.util.async.throw_err(inst_30954);
var inst_30956 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_30955);
var inst_30957 = cljs.core.count(inst_30956);
var inst_30958 = fluree.db.query.analytical.add_fuel(inst_30957,fuel,max_fuel);
var inst_30959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30960 = [inst_30955,r];
var inst_30961 = (new cljs.core.PersistentVector(null,2,(5),inst_30959,inst_30960,null));
var state_30976__$1 = (function (){var statearr_30981 = state_30976;
(statearr_30981[(7)] = inst_30958);

return statearr_30981;
})();
var statearr_30982_31009 = state_30976__$1;
(statearr_30982_31009[(2)] = inst_30961);

(statearr_30982_31009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (13))){
var inst_30920 = (state_30976[(8)]);
var inst_30933 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30934 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_30933);
var inst_30935 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_30920);
var inst_30936 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30935);
var inst_30937 = cljs.core.set(inst_30936);
var inst_30938 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_30934);
var inst_30939 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30938);
var inst_30940 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30937,inst_30939);
var inst_30941 = (function (){var all_wd = inst_30920;
var optional = inst_30934;
var all_wd_vars = inst_30937;
var all_vars = inst_30940;
return (function (p1__30907_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__30907_SHARP_) : all_vars.call(null,p1__30907_SHARP_));
});
})();
var inst_30942 = cljs.core.keys(vars);
var inst_30943 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30941,inst_30942);
var inst_30944 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_30943);
var inst_30945 = cljs.core.set(inst_30944);
var inst_30946 = (function (){var all_wd = inst_30920;
var optional = inst_30934;
var all_wd_vars = inst_30937;
var all_vars = inst_30940;
var intersecting_vars = inst_30945;
return (function (p1__30908_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__30908_SHARP_);
});
})();
var inst_30947 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30946,inst_30920);
var inst_30948 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30947);
var inst_30949 = fluree.db.query.analytical.select_from_tuples(inst_30948,res);
var inst_30950 = fluree.db.query.analytical.replace_vars_wikidata(inst_30920,inst_30945,vars);
var inst_30951 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_30945,inst_30940);
var inst_30952 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_30950,inst_30948,inst_30949,inst_30951,inst_30934);
var state_30976__$1 = state_30976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30976__$1,(15),inst_30952);
} else {
if((state_val_30977 === (6))){
var inst_30921 = (state_30976[(9)]);
var inst_30919 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30920 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_30919);
var inst_30921__$1 = optional_QMARK_;
var state_30976__$1 = (function (){var statearr_30983 = state_30976;
(statearr_30983[(8)] = inst_30920);

(statearr_30983[(9)] = inst_30921__$1);

return statearr_30983;
})();
if(cljs.core.truth_(inst_30921__$1)){
var statearr_30984_31010 = state_30976__$1;
(statearr_30984_31010[(1)] = (9));

} else {
var statearr_30985_31011 = state_30976__$1;
(statearr_30985_31011[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (3))){
var inst_30974 = (state_30976[(2)]);
var state_30976__$1 = state_30976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30976__$1,inst_30974);
} else {
if((state_val_30977 === (12))){
var inst_30929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30930 = [null,r];
var inst_30931 = (new cljs.core.PersistentVector(null,2,(5),inst_30929,inst_30930,null));
var state_30976__$1 = state_30976;
var statearr_30986_31012 = state_30976__$1;
(statearr_30986_31012[(2)] = inst_30931);

(statearr_30986_31012[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (2))){
var _ = (function (){var statearr_30987 = state_30976;
(statearr_30987[(4)] = cljs.core.cons((5),(state_30976[(4)])));

return statearr_30987;
})();
var inst_30917 = (r == null);
var state_30976__$1 = state_30976;
if(cljs.core.truth_(inst_30917)){
var statearr_30988_31013 = state_30976__$1;
(statearr_30988_31013[(1)] = (6));

} else {
var statearr_30989_31014 = state_30976__$1;
(statearr_30989_31014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (11))){
var inst_30927 = (state_30976[(2)]);
var state_30976__$1 = state_30976;
if(cljs.core.truth_(inst_30927)){
var statearr_30991_31015 = state_30976__$1;
(statearr_30991_31015[(1)] = (12));

} else {
var statearr_30992_31016 = state_30976__$1;
(statearr_30992_31016[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (9))){
var inst_30920 = (state_30976[(8)]);
var inst_30923 = cljs.core.empty_QMARK_(inst_30920);
var inst_30924 = (!(inst_30923));
var state_30976__$1 = state_30976;
var statearr_30993_31017 = state_30976__$1;
(statearr_30993_31017[(2)] = inst_30924);

(statearr_30993_31017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (5))){
var _ = (function (){var statearr_30994 = state_30976;
(statearr_30994[(4)] = cljs.core.rest((state_30976[(4)])));

return statearr_30994;
})();
var state_30976__$1 = state_30976;
var ex30990 = (state_30976__$1[(2)]);
var statearr_30995_31018 = state_30976__$1;
(statearr_30995_31018[(5)] = ex30990);


if((ex30990 instanceof Error)){
var statearr_30996_31019 = state_30976__$1;
(statearr_30996_31019[(1)] = (4));

(statearr_30996_31019[(5)] = null);

} else {
throw ex30990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (14))){
var inst_30963 = (state_30976[(2)]);
var state_30976__$1 = state_30976;
var statearr_30997_31020 = state_30976__$1;
(statearr_30997_31020[(2)] = inst_30963);

(statearr_30997_31020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (10))){
var inst_30921 = (state_30976[(9)]);
var state_30976__$1 = state_30976;
var statearr_30998_31021 = state_30976__$1;
(statearr_30998_31021[(2)] = inst_30921);

(statearr_30998_31021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30977 === (8))){
var inst_30971 = (state_30976[(2)]);
var _ = (function (){var statearr_30999 = state_30976;
(statearr_30999[(4)] = cljs.core.rest((state_30976[(4)])));

return statearr_30999;
})();
var state_30976__$1 = state_30976;
var statearr_31000_31022 = state_30976__$1;
(statearr_31000_31022[(2)] = inst_30971);

(statearr_31000_31022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____0 = (function (){
var statearr_31001 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31001[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__);

(statearr_31001[(1)] = (1));

return statearr_31001;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____1 = (function (state_30976){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30976);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31002){var ex__11413__auto__ = e31002;
var statearr_31003_31023 = state_30976;
(statearr_31003_31023[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30976[(4)]))){
var statearr_31004_31024 = state_30976;
(statearr_31004_31024[(1)] = cljs.core.first((state_30976[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31025 = state_30976;
state_30976 = G__31025;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__ = function(state_30976){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____1.call(this,state_30976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31005 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31005[(6)] = c__11484__auto__);

return statearr_31005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__31027 = arguments.length;
switch (G__31027) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_31121){
var state_val_31122 = (state_31121[(1)]);
if((state_val_31122 === (7))){
var inst_31034 = (state_31121[(7)]);
var inst_31044 = clojure.string.starts_with_QMARK_(inst_31034,"$fdb");
var state_31121__$1 = state_31121;
if(inst_31044){
var statearr_31123_31172 = state_31121__$1;
(statearr_31123_31172[(1)] = (9));

} else {
var statearr_31124_31173 = state_31121__$1;
(statearr_31124_31173[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (20))){
var state_31121__$1 = state_31121;
var statearr_31125_31174 = state_31121__$1;
(statearr_31125_31174[(2)] = null);

(statearr_31125_31174[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (27))){
var inst_31084 = (state_31121[(8)]);
var state_31121__$1 = state_31121;
var statearr_31126_31175 = state_31121__$1;
(statearr_31126_31175[(2)] = inst_31084);

(statearr_31126_31175[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (1))){
var state_31121__$1 = state_31121;
var statearr_31127_31176 = state_31121__$1;
(statearr_31127_31176[(2)] = null);

(statearr_31127_31176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (24))){
var inst_31107 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
var statearr_31128_31177 = state_31121__$1;
(statearr_31128_31177[(2)] = inst_31107);

(statearr_31128_31177[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (4))){
var inst_31028 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
var statearr_31129_31178 = state_31121__$1;
(statearr_31129_31178[(2)] = inst_31028);

(statearr_31129_31178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (15))){
var inst_31051 = (state_31121[(9)]);
var inst_31057 = (state_31121[(2)]);
var inst_31058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31059 = cljs.core.PersistentVector.EMPTY;
var inst_31060 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31061 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31059,inst_31060);
var inst_31062 = [inst_31051,inst_31061];
var inst_31063 = (new cljs.core.PersistentVector(null,2,(5),inst_31058,inst_31062,null));
var state_31121__$1 = (function (){var statearr_31130 = state_31121;
(statearr_31130[(10)] = inst_31057);

return statearr_31130;
})();
var statearr_31131_31179 = state_31121__$1;
(statearr_31131_31179[(2)] = inst_31063);

(statearr_31131_31179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (21))){
var inst_31110 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
var statearr_31132_31180 = state_31121__$1;
(statearr_31132_31180[(2)] = inst_31110);

(statearr_31132_31180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (13))){
var inst_31051 = (state_31121[(9)]);
var inst_31054 = (function(){throw inst_31051})();
var state_31121__$1 = state_31121;
var statearr_31133_31181 = state_31121__$1;
(statearr_31133_31181[(2)] = inst_31054);

(statearr_31133_31181[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (22))){
var inst_31073 = (state_31121[(11)]);
var inst_31075 = (state_31121[(12)]);
var inst_31077 = fluree.db.query.analytical.parse_block_from_source(inst_31073);
var inst_31078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31079 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_31075];
var inst_31080 = (new cljs.core.PersistentVector(null,2,(5),inst_31078,inst_31079,null));
var inst_31081 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_31080);
var state_31121__$1 = (function (){var statearr_31134 = state_31121;
(statearr_31134[(13)] = inst_31077);

return statearr_31134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31121__$1,(25),inst_31081);
} else {
if((state_val_31122 === (29))){
var inst_31088 = (state_31121[(2)]);
var inst_31089 = fluree.db.util.async.throw_err(inst_31088);
var state_31121__$1 = state_31121;
var statearr_31135_31182 = state_31121__$1;
(statearr_31135_31182[(2)] = inst_31089);

(statearr_31135_31182[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (6))){
var inst_31037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31038 = cljs.core.PersistentVector.EMPTY;
var inst_31039 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31040 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31038,inst_31039);
var inst_31041 = [db,inst_31040];
var inst_31042 = (new cljs.core.PersistentVector(null,2,(5),inst_31037,inst_31041,null));
var state_31121__$1 = state_31121;
var statearr_31136_31183 = state_31121__$1;
(statearr_31136_31183[(2)] = inst_31042);

(statearr_31136_31183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (28))){
var inst_31092 = (state_31121[(2)]);
var inst_31093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31094 = cljs.core.PersistentVector.EMPTY;
var inst_31095 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31096 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31094,inst_31095);
var inst_31097 = [inst_31092,inst_31096];
var inst_31098 = (new cljs.core.PersistentVector(null,2,(5),inst_31093,inst_31097,null));
var state_31121__$1 = state_31121;
var statearr_31137_31184 = state_31121__$1;
(statearr_31137_31184[(2)] = inst_31098);

(statearr_31137_31184[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (25))){
var inst_31077 = (state_31121[(13)]);
var inst_31083 = (state_31121[(2)]);
var inst_31084 = fluree.db.util.async.throw_err(inst_31083);
var state_31121__$1 = (function (){var statearr_31138 = state_31121;
(statearr_31138[(8)] = inst_31084);

return statearr_31138;
})();
if(cljs.core.truth_(inst_31077)){
var statearr_31139_31185 = state_31121__$1;
(statearr_31139_31185[(1)] = (26));

} else {
var statearr_31140_31186 = state_31121__$1;
(statearr_31140_31186[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (17))){
var state_31121__$1 = state_31121;
var statearr_31141_31187 = state_31121__$1;
(statearr_31141_31187[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (3))){
var inst_31119 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31121__$1,inst_31119);
} else {
if((state_val_31122 === (12))){
var inst_31051 = (state_31121[(9)]);
var inst_31050 = (state_31121[(2)]);
var inst_31051__$1 = fluree.db.util.async.throw_err(inst_31050);
var inst_31052 = fluree.db.util.core.exception_QMARK_(inst_31051__$1);
var state_31121__$1 = (function (){var statearr_31143 = state_31121;
(statearr_31143[(9)] = inst_31051__$1);

return statearr_31143;
})();
if(inst_31052){
var statearr_31144_31188 = state_31121__$1;
(statearr_31144_31188[(1)] = (13));

} else {
var statearr_31145_31189 = state_31121__$1;
(statearr_31145_31189[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (2))){
var inst_31034 = (state_31121[(7)]);
var _ = (function (){var statearr_31146 = state_31121;
(statearr_31146[(4)] = cljs.core.cons((5),(state_31121[(4)])));

return statearr_31146;
})();
var inst_31034__$1 = cljs.core.first(clause);
var inst_31035 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_31034__$1);
var state_31121__$1 = (function (){var statearr_31147 = state_31121;
(statearr_31147[(7)] = inst_31034__$1);

return statearr_31147;
})();
if(inst_31035){
var statearr_31148_31190 = state_31121__$1;
(statearr_31148_31190[(1)] = (6));

} else {
var statearr_31149_31191 = state_31121__$1;
(statearr_31149_31191[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (23))){
var inst_31034 = (state_31121[(7)]);
var inst_31100 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31034)," is not supported in Fluree"].join('');
var inst_31101 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31102 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31103 = cljs.core.PersistentHashMap.fromArrays(inst_31101,inst_31102);
var inst_31104 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31100,inst_31103);
var inst_31105 = (function(){throw inst_31104})();
var state_31121__$1 = state_31121;
var statearr_31150_31192 = state_31121__$1;
(statearr_31150_31192[(2)] = inst_31105);

(statearr_31150_31192[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (19))){
var inst_31034 = (state_31121[(7)]);
var inst_31075 = (state_31121[(12)]);
var inst_31072 = fluree.db.query.analytical.isolate_source_name(inst_31034);
var inst_31073 = fluree.db.query.analytical.isolate_source_block(inst_31034);
var inst_31074 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31072);
var inst_31075__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_31074);
var state_31121__$1 = (function (){var statearr_31151 = state_31121;
(statearr_31151[(11)] = inst_31073);

(statearr_31151[(12)] = inst_31075__$1);

return statearr_31151;
})();
if(cljs.core.truth_(inst_31075__$1)){
var statearr_31152_31193 = state_31121__$1;
(statearr_31152_31193[(1)] = (22));

} else {
var statearr_31153_31194 = state_31121__$1;
(statearr_31153_31194[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (11))){
var inst_31114 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
var statearr_31155_31195 = state_31121__$1;
(statearr_31155_31195[(2)] = inst_31114);

(statearr_31155_31195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (9))){
var inst_31034 = (state_31121[(7)]);
var inst_31046 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_31034,(4));
var inst_31047 = fluree.db.query.analytical.parse_block_from_source(inst_31046);
var inst_31048 = fluree.db.time_travel.as_of_block(db,inst_31047);
var state_31121__$1 = state_31121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31121__$1,(12),inst_31048);
} else {
if((state_val_31122 === (5))){
var _ = (function (){var statearr_31156 = state_31121;
(statearr_31156[(4)] = cljs.core.rest((state_31121[(4)])));

return statearr_31156;
})();
var state_31121__$1 = state_31121;
var ex31154 = (state_31121__$1[(2)]);
var statearr_31157_31196 = state_31121__$1;
(statearr_31157_31196[(5)] = ex31154);


if((ex31154 instanceof Error)){
var statearr_31158_31197 = state_31121__$1;
(statearr_31158_31197[(1)] = (4));

(statearr_31158_31197[(5)] = null);

} else {
throw ex31154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (14))){
var state_31121__$1 = state_31121;
var statearr_31159_31198 = state_31121__$1;
(statearr_31159_31198[(2)] = null);

(statearr_31159_31198[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (26))){
var inst_31084 = (state_31121[(8)]);
var inst_31077 = (state_31121[(13)]);
var inst_31086 = fluree.db.time_travel.as_of_block(inst_31084,inst_31077);
var state_31121__$1 = state_31121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31121__$1,(29),inst_31086);
} else {
if((state_val_31122 === (16))){
var inst_31067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31068 = ["$wd",clause];
var inst_31069 = (new cljs.core.PersistentVector(null,2,(5),inst_31067,inst_31068,null));
var state_31121__$1 = state_31121;
var statearr_31160_31199 = state_31121__$1;
(statearr_31160_31199[(2)] = inst_31069);

(statearr_31160_31199[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (10))){
var inst_31034 = (state_31121[(7)]);
var inst_31065 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_31034);
var state_31121__$1 = state_31121;
if(inst_31065){
var statearr_31161_31200 = state_31121__$1;
(statearr_31161_31200[(1)] = (16));

} else {
var statearr_31162_31201 = state_31121__$1;
(statearr_31162_31201[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (18))){
var inst_31112 = (state_31121[(2)]);
var state_31121__$1 = state_31121;
var statearr_31163_31202 = state_31121__$1;
(statearr_31163_31202[(2)] = inst_31112);

(statearr_31163_31202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31122 === (8))){
var inst_31116 = (state_31121[(2)]);
var _ = (function (){var statearr_31164 = state_31121;
(statearr_31164[(4)] = cljs.core.rest((state_31121[(4)])));

return statearr_31164;
})();
var state_31121__$1 = state_31121;
var statearr_31165_31203 = state_31121__$1;
(statearr_31165_31203[(2)] = inst_31116);

(statearr_31165_31203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11410__auto__ = null;
var fluree$db$query$analytical$state_machine__11410__auto____0 = (function (){
var statearr_31166 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31166[(0)] = fluree$db$query$analytical$state_machine__11410__auto__);

(statearr_31166[(1)] = (1));

return statearr_31166;
});
var fluree$db$query$analytical$state_machine__11410__auto____1 = (function (state_31121){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_31121);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31167){var ex__11413__auto__ = e31167;
var statearr_31168_31204 = state_31121;
(statearr_31168_31204[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_31121[(4)]))){
var statearr_31169_31205 = state_31121;
(statearr_31169_31205[(1)] = cljs.core.first((state_31121[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31206 = state_31121;
state_31121 = G__31206;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11410__auto__ = function(state_31121){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11410__auto____1.call(this,state_31121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11410__auto____0;
fluree$db$query$analytical$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11410__auto____1;
return fluree$db$query$analytical$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31170 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31170[(6)] = c__11484__auto__);

return statearr_31170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__31207){
var vec__31208 = p__31207;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31208,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31208,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31211_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__31211_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__31215 = subjects;
var vec__31216 = G__31215;
var seq__31217 = cljs.core.seq(vec__31216);
var first__31218 = cljs.core.first(seq__31217);
var seq__31217__$1 = cljs.core.next(seq__31217);
var subject = first__31218;
var r = seq__31217__$1;
var acc = expanded_map;
var G__31215__$1 = G__31215;
var acc__$1 = acc;
while(true){
var vec__31222 = G__31215__$1;
var seq__31223 = cljs.core.seq(vec__31222);
var first__31224 = cljs.core.first(seq__31223);
var seq__31223__$1 = cljs.core.next(seq__31223);
var subject__$1 = first__31224;
var r__$1 = seq__31223__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__31225 = r__$1;
var G__31226 = acc__$2;
G__31215__$1 = G__31225;
acc__$1 = G__31226;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__31215__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__31215__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__31215__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__31215__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__31215__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__31215__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31222,seq__31223,first__31224,seq__31223__$1,subject__$1,r__$1,acc__$2,G__31215,vec__31216,seq__31217,first__31218,seq__31217__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__31227 = r__$1;
var G__31228 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__31215__$1 = G__31227;
acc__$1 = G__31228;
continue;
} else {
var G__31229 = subjects;
var G__31230 = acc_STAR_;
G__31215__$1 = G__31229;
acc__$1 = G__31230;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31231_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__31231_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_31322){
var state_val_31323 = (state_31322[(1)]);
if((state_val_31323 === (7))){
var state_31322__$1 = state_31322;
var statearr_31324_31370 = state_31322__$1;
(statearr_31324_31370[(2)] = (100));

(statearr_31324_31370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (20))){
var inst_31271 = (state_31322[(7)]);
var state_31322__$1 = state_31322;
var statearr_31325_31371 = state_31322__$1;
(statearr_31325_31371[(2)] = inst_31271);

(statearr_31325_31371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (1))){
var state_31322__$1 = state_31322;
var statearr_31326_31372 = state_31322__$1;
(statearr_31326_31372[(2)] = null);

(statearr_31326_31372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (24))){
var inst_31308 = (state_31322[(8)]);
var inst_31309 = (state_31322[(9)]);
var inst_31310 = (state_31322[(10)]);
var inst_31243 = (state_31322[(11)]);
var inst_31313 = (function (){var max_depth = inst_31243;
var recur_map__$1 = inst_31309;
var subjects = inst_31308;
var tuples = inst_31310;
return (function (p1__31232_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__31232_SHARP_)],null));
});
})();
var inst_31314 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31313,inst_31310);
var inst_31315 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_31314);
var state_31322__$1 = state_31322;
var statearr_31327_31373 = state_31322__$1;
(statearr_31327_31373[(2)] = inst_31315);

(statearr_31327_31373[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (4))){
var inst_31233 = (state_31322[(2)]);
var state_31322__$1 = state_31322;
var statearr_31328_31374 = state_31322__$1;
(statearr_31328_31374[(2)] = inst_31233);

(statearr_31328_31374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (15))){
var inst_31256 = (state_31322[(12)]);
var inst_31267 = cljs.core.PersistentVector.EMPTY;
var inst_31268 = cljs.core.seq(inst_31256);
var inst_31269 = cljs.core.first(inst_31268);
var inst_31270 = cljs.core.next(inst_31268);
var inst_31271 = inst_31267;
var inst_31272 = inst_31256;
var state_31322__$1 = (function (){var statearr_31329 = state_31322;
(statearr_31329[(13)] = inst_31269);

(statearr_31329[(7)] = inst_31271);

(statearr_31329[(14)] = inst_31270);

(statearr_31329[(15)] = inst_31272);

return statearr_31329;
})();
var statearr_31330_31375 = state_31322__$1;
(statearr_31330_31375[(2)] = null);

(statearr_31330_31375[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (21))){
var inst_31292 = (state_31322[(2)]);
var state_31322__$1 = state_31322;
var statearr_31331_31376 = state_31322__$1;
(statearr_31331_31376[(2)] = inst_31292);

(statearr_31331_31376[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (13))){
var inst_31305 = (state_31322[(2)]);
var state_31322__$1 = state_31322;
var statearr_31332_31377 = state_31322__$1;
(statearr_31332_31377[(2)] = inst_31305);

(statearr_31332_31377[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (22))){
var inst_31279 = (state_31322[(16)]);
var inst_31271 = (state_31322[(7)]);
var inst_31286 = (state_31322[(2)]);
var inst_31287 = fluree.db.util.async.throw_err(inst_31286);
var inst_31288 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_31271,inst_31287);
var inst_31271__$1 = inst_31288;
var inst_31272 = inst_31279;
var state_31322__$1 = (function (){var statearr_31333 = state_31322;
(statearr_31333[(7)] = inst_31271__$1);

(statearr_31333[(15)] = inst_31272);

return statearr_31333;
})();
var statearr_31334_31378 = state_31322__$1;
(statearr_31334_31378[(2)] = null);

(statearr_31334_31378[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (6))){
var inst_31239 = (state_31322[(17)]);
var state_31322__$1 = state_31322;
var statearr_31335_31379 = state_31322__$1;
(statearr_31335_31379[(2)] = inst_31239);

(statearr_31335_31379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (25))){
var inst_31317 = (state_31322[(2)]);
var _ = (function (){var statearr_31336 = state_31322;
(statearr_31336[(4)] = cljs.core.rest((state_31322[(4)])));

return statearr_31336;
})();
var state_31322__$1 = state_31322;
var statearr_31337_31380 = state_31322__$1;
(statearr_31337_31380[(2)] = inst_31317);

(statearr_31337_31380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (17))){
var inst_31278 = (state_31322[(18)]);
var inst_31272 = (state_31322[(15)]);
var inst_31277 = cljs.core.seq(inst_31272);
var inst_31278__$1 = cljs.core.first(inst_31277);
var inst_31279 = cljs.core.next(inst_31277);
var state_31322__$1 = (function (){var statearr_31338 = state_31322;
(statearr_31338[(16)] = inst_31279);

(statearr_31338[(18)] = inst_31278__$1);

return statearr_31338;
})();
if(cljs.core.truth_(inst_31278__$1)){
var statearr_31339_31381 = state_31322__$1;
(statearr_31339_31381[(1)] = (19));

} else {
var statearr_31340_31382 = state_31322__$1;
(statearr_31340_31382[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (3))){
var inst_31320 = (state_31322[(2)]);
var state_31322__$1 = state_31322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31322__$1,inst_31320);
} else {
if((state_val_31323 === (12))){
var inst_31245 = (state_31322[(19)]);
var inst_31256 = (state_31322[(12)]);
var inst_31251 = cljs.core.vals(inst_31245);
var inst_31252 = cljs.core.flatten(inst_31251);
var inst_31253 = cljs.core.set(inst_31252);
var inst_31254 = cljs.core.keys(inst_31245);
var inst_31255 = cljs.core.set(inst_31254);
var inst_31256__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_31253,inst_31255);
var inst_31257 = cljs.core.empty_QMARK_(inst_31256__$1);
var state_31322__$1 = (function (){var statearr_31341 = state_31322;
(statearr_31341[(12)] = inst_31256__$1);

return statearr_31341;
})();
if(inst_31257){
var statearr_31342_31383 = state_31322__$1;
(statearr_31342_31383[(1)] = (14));

} else {
var statearr_31343_31384 = state_31322__$1;
(statearr_31343_31384[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (2))){
var inst_31239 = (state_31322[(17)]);
var _ = (function (){var statearr_31344 = state_31322;
(statearr_31344[(4)] = cljs.core.cons((5),(state_31322[(4)])));

return statearr_31344;
})();
var inst_31239__$1 = depth;
var state_31322__$1 = (function (){var statearr_31345 = state_31322;
(statearr_31345[(17)] = inst_31239__$1);

return statearr_31345;
})();
if(cljs.core.truth_(inst_31239__$1)){
var statearr_31346_31385 = state_31322__$1;
(statearr_31346_31385[(1)] = (6));

} else {
var statearr_31347_31386 = state_31322__$1;
(statearr_31347_31386[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (23))){
var inst_31310 = (state_31322[(10)]);
var state_31322__$1 = state_31322;
var statearr_31348_31387 = state_31322__$1;
(statearr_31348_31387[(2)] = inst_31310);

(statearr_31348_31387[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (19))){
var inst_31278 = (state_31322[(18)]);
var inst_31281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31282 = [inst_31278,predicate];
var inst_31283 = (new cljs.core.PersistentVector(null,2,(5),inst_31281,inst_31282,null));
var inst_31284 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_31283);
var state_31322__$1 = state_31322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31322__$1,(22),inst_31284);
} else {
if((state_val_31323 === (11))){
var inst_31245 = (state_31322[(19)]);
var state_31322__$1 = state_31322;
var statearr_31350_31388 = state_31322__$1;
(statearr_31350_31388[(2)] = inst_31245);

(statearr_31350_31388[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (9))){
var inst_31246 = (state_31322[(20)]);
var inst_31243 = (state_31322[(11)]);
var inst_31248 = (inst_31246 >= inst_31243);
var state_31322__$1 = state_31322;
if(cljs.core.truth_(inst_31248)){
var statearr_31351_31389 = state_31322__$1;
(statearr_31351_31389[(1)] = (11));

} else {
var statearr_31352_31390 = state_31322__$1;
(statearr_31352_31390[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (5))){
var _ = (function (){var statearr_31353 = state_31322;
(statearr_31353[(4)] = cljs.core.rest((state_31322[(4)])));

return statearr_31353;
})();
var state_31322__$1 = state_31322;
var ex31349 = (state_31322__$1[(2)]);
var statearr_31354_31391 = state_31322__$1;
(statearr_31354_31391[(5)] = ex31349);


if((ex31349 instanceof Error)){
var statearr_31355_31392 = state_31322__$1;
(statearr_31355_31392[(1)] = (4));

(statearr_31355_31392[(5)] = null);

} else {
throw ex31349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (14))){
var inst_31245 = (state_31322[(19)]);
var state_31322__$1 = state_31322;
var statearr_31356_31393 = state_31322__$1;
(statearr_31356_31393[(2)] = inst_31245);

(statearr_31356_31393[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (16))){
var inst_31303 = (state_31322[(2)]);
var state_31322__$1 = state_31322;
var statearr_31357_31394 = state_31322__$1;
(statearr_31357_31394[(2)] = inst_31303);

(statearr_31357_31394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (10))){
var inst_31308 = (state_31322[(8)]);
var inst_31309 = (state_31322[(9)]);
var inst_31307 = (state_31322[(2)]);
var inst_31308__$1 = cljs.core.keys(inst_31307);
var inst_31309__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_31308__$1,inst_31307);
var inst_31310 = fluree.db.query.analytical.recur_map__GT_tuples(inst_31308__$1,inst_31309__$1);
var state_31322__$1 = (function (){var statearr_31358 = state_31322;
(statearr_31358[(8)] = inst_31308__$1);

(statearr_31358[(9)] = inst_31309__$1);

(statearr_31358[(10)] = inst_31310);

return statearr_31358;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_31359_31395 = state_31322__$1;
(statearr_31359_31395[(1)] = (23));

} else {
var statearr_31360_31396 = state_31322__$1;
(statearr_31360_31396[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (18))){
var inst_31246 = (state_31322[(20)]);
var inst_31245 = (state_31322[(19)]);
var inst_31294 = (state_31322[(2)]);
var inst_31295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31296 = [(0),(2)];
var inst_31297 = (new cljs.core.PersistentVector(null,2,(5),inst_31295,inst_31296,null));
var inst_31298 = fluree.db.query.analytical.get_ns_arrays(inst_31297,inst_31294);
var inst_31299 = fluree.db.query.analytical.tuples__GT_map(inst_31245,inst_31298);
var inst_31300 = (inst_31246 + (1));
var inst_31245__$1 = inst_31299;
var inst_31246__$1 = inst_31300;
var state_31322__$1 = (function (){var statearr_31361 = state_31322;
(statearr_31361[(20)] = inst_31246__$1);

(statearr_31361[(19)] = inst_31245__$1);

return statearr_31361;
})();
var statearr_31362_31397 = state_31322__$1;
(statearr_31362_31397[(2)] = null);

(statearr_31362_31397[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31323 === (8))){
var inst_31243 = (state_31322[(2)]);
var inst_31244 = recur_map;
var inst_31245 = inst_31244;
var inst_31246 = (1);
var state_31322__$1 = (function (){var statearr_31363 = state_31322;
(statearr_31363[(20)] = inst_31246);

(statearr_31363[(19)] = inst_31245);

(statearr_31363[(11)] = inst_31243);

return statearr_31363;
})();
var statearr_31364_31398 = state_31322__$1;
(statearr_31364_31398[(2)] = null);

(statearr_31364_31398[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____0 = (function (){
var statearr_31365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31365[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__);

(statearr_31365[(1)] = (1));

return statearr_31365;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____1 = (function (state_31322){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_31322);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31366){var ex__11413__auto__ = e31366;
var statearr_31367_31399 = state_31322;
(statearr_31367_31399[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_31322[(4)]))){
var statearr_31368_31400 = state_31322;
(statearr_31368_31400[(1)] = cljs.core.first((state_31322[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31401 = state_31322;
state_31322 = G__31401;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__ = function(state_31322){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____1.call(this,state_31322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31369 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31369[(6)] = c__11484__auto__);

return statearr_31369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__31402,clause,fuel,max_fuel){
var map__31403 = p__31402;
var map__31403__$1 = cljs.core.__destructure_map(map__31403);
var res = map__31403__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31403__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31403__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31403__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_31514){
var state_val_31515 = (state_31514[(1)]);
if((state_val_31515 === (7))){
var inst_31420 = (state_31514[(7)]);
var state_31514__$1 = state_31514;
var statearr_31516_31569 = state_31514__$1;
(statearr_31516_31569[(2)] = inst_31420);

(statearr_31516_31569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (20))){
var inst_31448 = (state_31514[(8)]);
var inst_31479 = typeof inst_31448 === 'number';
var state_31514__$1 = state_31514;
if(cljs.core.truth_(inst_31479)){
var statearr_31517_31570 = state_31514__$1;
(statearr_31517_31570[(1)] = (22));

} else {
var statearr_31518_31571 = state_31514__$1;
(statearr_31518_31571[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (27))){
var inst_31494 = (state_31514[(2)]);
var state_31514__$1 = state_31514;
var statearr_31519_31572 = state_31514__$1;
(statearr_31519_31572[(2)] = inst_31494);

(statearr_31519_31572[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (1))){
var state_31514__$1 = state_31514;
var statearr_31520_31573 = state_31514__$1;
(statearr_31520_31573[(2)] = null);

(statearr_31520_31573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (24))){
var inst_31496 = (state_31514[(2)]);
var state_31514__$1 = state_31514;
var statearr_31521_31574 = state_31514__$1;
(statearr_31521_31574[(2)] = inst_31496);

(statearr_31521_31574[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (4))){
var inst_31404 = (state_31514[(2)]);
var state_31514__$1 = state_31514;
var statearr_31522_31575 = state_31514__$1;
(statearr_31522_31575[(2)] = inst_31404);

(statearr_31522_31575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (15))){
var inst_31462 = (state_31514[(2)]);
var inst_31463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_31464 = fluree.db.query.analytical.variable_QMARK_(inst_31463);
var state_31514__$1 = (function (){var statearr_31523 = state_31514;
(statearr_31523[(9)] = inst_31462);

return statearr_31523;
})();
if(cljs.core.truth_(inst_31464)){
var statearr_31524_31576 = state_31514__$1;
(statearr_31524_31576[(1)] = (16));

} else {
var statearr_31525_31577 = state_31514__$1;
(statearr_31525_31577[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (21))){
var inst_31450 = (state_31514[(10)]);
var inst_31421 = (state_31514[(11)]);
var inst_31451 = (state_31514[(12)]);
var inst_31498 = (state_31514[(2)]);
var inst_31499 = fluree.db.query.analytical.tuples__GT_recur(db,inst_31451,inst_31498,inst_31421,inst_31450);
var state_31514__$1 = state_31514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31514__$1,(28),inst_31499);
} else {
if((state_val_31515 === (13))){
var inst_31430 = (state_31514[(13)]);
var inst_31454 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31430)].join('');
var inst_31455 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31456 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31457 = cljs.core.PersistentHashMap.fromArrays(inst_31455,inst_31456);
var inst_31458 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31454,inst_31457);
var inst_31459 = (function(){throw inst_31458})();
var state_31514__$1 = state_31514;
var statearr_31526_31578 = state_31514__$1;
(statearr_31526_31578[(2)] = inst_31459);

(statearr_31526_31578[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (22))){
var inst_31448 = (state_31514[(8)]);
var inst_31446 = (state_31514[(14)]);
var inst_31481 = cljs.core.PersistentHashMap.EMPTY;
var inst_31482 = cljs.core.flatten(inst_31446);
var inst_31483 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31481,inst_31448,inst_31482);
var state_31514__$1 = state_31514;
var statearr_31527_31579 = state_31514__$1;
(statearr_31527_31579[(2)] = inst_31483);

(statearr_31527_31579[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (6))){
var inst_31432 = (state_31514[(15)]);
var state_31514__$1 = state_31514;
var statearr_31528_31580 = state_31514__$1;
(statearr_31528_31580[(2)] = inst_31432);

(statearr_31528_31580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (28))){
var inst_31501 = (state_31514[(2)]);
var inst_31502 = fluree.db.util.async.throw_err(inst_31501);
var state_31514__$1 = state_31514;
var statearr_31529_31581 = state_31514__$1;
(statearr_31529_31581[(2)] = inst_31502);

(statearr_31529_31581[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (25))){
var inst_31442 = (state_31514[(16)]);
var inst_31446 = (state_31514[(14)]);
var inst_31487 = cljs.core.PersistentHashMap.EMPTY;
var inst_31488 = cljs.core.first(inst_31442);
var inst_31489 = cljs.core.first(inst_31488);
var inst_31490 = cljs.core.flatten(inst_31446);
var inst_31491 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31487,inst_31489,inst_31490);
var state_31514__$1 = state_31514;
var statearr_31530_31582 = state_31514__$1;
(statearr_31530_31582[(2)] = inst_31491);

(statearr_31530_31582[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (17))){
var inst_31430 = (state_31514[(13)]);
var inst_31467 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31430)].join('');
var inst_31468 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31469 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31470 = cljs.core.PersistentHashMap.fromArrays(inst_31468,inst_31469);
var inst_31471 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31467,inst_31470);
var inst_31472 = (function(){throw inst_31471})();
var state_31514__$1 = state_31514;
var statearr_31531_31583 = state_31514__$1;
(statearr_31531_31583[(2)] = inst_31472);

(statearr_31531_31583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (3))){
var inst_31512 = (state_31514[(2)]);
var state_31514__$1 = state_31514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31514__$1,inst_31512);
} else {
if((state_val_31515 === (12))){
var inst_31417 = (state_31514[(17)]);
var inst_31505 = (state_31514[(2)]);
var inst_31506 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_31507 = cljs.core.keys(inst_31417);
var inst_31508 = [inst_31507,vars,inst_31505];
var inst_31509 = cljs.core.PersistentHashMap.fromArrays(inst_31506,inst_31508);
var _ = (function (){var statearr_31532 = state_31514;
(statearr_31532[(4)] = cljs.core.rest((state_31514[(4)])));

return statearr_31532;
})();
var state_31514__$1 = state_31514;
var statearr_31533_31584 = state_31514__$1;
(statearr_31533_31584[(2)] = inst_31509);

(statearr_31533_31584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (2))){
var inst_31417 = (state_31514[(17)]);
var inst_31420 = (state_31514[(7)]);
var inst_31421 = (state_31514[(11)]);
var inst_31432 = (state_31514[(15)]);
var _ = (function (){var statearr_31534 = state_31514;
(statearr_31534[(4)] = cljs.core.cons((5),(state_31514[(4)])));

return statearr_31534;
})();
var inst_31414 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_31415 = cljs.core.__destructure_map(inst_31414);
var inst_31416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31415,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_31417__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31415,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_31418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31415,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_31419 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_31420__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_31418);
var inst_31421__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_31418);
var inst_31423 = (function (){var map__31410 = inst_31415;
var search = inst_31416;
var rel = inst_31417__$1;
var opts = inst_31418;
var common_keys = inst_31419;
var object_fn = inst_31420__$1;
var recur_depth = inst_31421__$1;
return (function (p__31422,common_key){
var vec__31535 = p__31422;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31535,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31535,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__31538 = cljs.core._EQ_;
var expr__31539 = idx_of;
if(cljs.core.truth_((pred__31538.cljs$core$IFn$_invoke$arity$2 ? pred__31538.cljs$core$IFn$_invoke$arity$2((0),expr__31539) : pred__31538.call(null,(0),expr__31539)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__31538.cljs$core$IFn$_invoke$arity$2 ? pred__31538.cljs$core$IFn$_invoke$arity$2((1),expr__31539) : pred__31538.call(null,(1),expr__31539)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__31538.cljs$core$IFn$_invoke$arity$2 ? pred__31538.cljs$core$IFn$_invoke$arity$2((2),expr__31539) : pred__31538.call(null,(2),expr__31539)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31539)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_31424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31425 = cljs.core.PersistentHashMap.EMPTY;
var inst_31426 = [inst_31425,inst_31416];
var inst_31427 = (new cljs.core.PersistentVector(null,2,(5),inst_31424,inst_31426,null));
var inst_31428 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31423,inst_31427,inst_31419);
var inst_31429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31428,(0),null);
var inst_31430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31428,(1),null);
var inst_31431 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_31432__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_31429);
var state_31514__$1 = (function (){var statearr_31541 = state_31514;
(statearr_31541[(17)] = inst_31417__$1);

(statearr_31541[(7)] = inst_31420__$1);

(statearr_31541[(11)] = inst_31421__$1);

(statearr_31541[(18)] = inst_31431);

(statearr_31541[(15)] = inst_31432__$1);

(statearr_31541[(13)] = inst_31430);

return statearr_31541;
})();
if(cljs.core.truth_(inst_31432__$1)){
var statearr_31542_31585 = state_31514__$1;
(statearr_31542_31585[(1)] = (6));

} else {
var statearr_31543_31586 = state_31514__$1;
(statearr_31543_31586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (23))){
var inst_31448 = (state_31514[(8)]);
var inst_31485 = cljs.core.coll_QMARK_(inst_31448);
var state_31514__$1 = state_31514;
if(inst_31485){
var statearr_31544_31587 = state_31514__$1;
(statearr_31544_31587[(1)] = (25));

} else {
var statearr_31545_31588 = state_31514__$1;
(statearr_31545_31588[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (19))){
var inst_31446 = (state_31514[(14)]);
var inst_31476 = cljs.core.PersistentHashMap.EMPTY;
var inst_31477 = fluree.db.query.analytical.tuples__GT_map(inst_31476,inst_31446);
var state_31514__$1 = state_31514;
var statearr_31546_31589 = state_31514__$1;
(statearr_31546_31589[(2)] = inst_31477);

(statearr_31546_31589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (11))){
var inst_31446 = (state_31514[(14)]);
var state_31514__$1 = state_31514;
var statearr_31548_31590 = state_31514__$1;
(statearr_31548_31590[(2)] = inst_31446);

(statearr_31548_31590[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (9))){
var inst_31417 = (state_31514[(17)]);
var inst_31421 = (state_31514[(11)]);
var inst_31442 = (state_31514[(16)]);
var inst_31441 = (state_31514[(2)]);
var inst_31442__$1 = fluree.db.util.async.throw_err(inst_31441);
var inst_31443 = cljs.core.count(inst_31442__$1);
var inst_31444 = fluree.db.query.analytical.add_fuel(inst_31443,fuel,max_fuel);
var inst_31445 = cljs.core.vals(inst_31417);
var inst_31446 = fluree.db.query.analytical.get_ns_arrays(inst_31445,inst_31442__$1);
var state_31514__$1 = (function (){var statearr_31549 = state_31514;
(statearr_31549[(19)] = inst_31444);

(statearr_31549[(16)] = inst_31442__$1);

(statearr_31549[(14)] = inst_31446);

return statearr_31549;
})();
if(cljs.core.truth_(inst_31421)){
var statearr_31550_31591 = state_31514__$1;
(statearr_31550_31591[(1)] = (10));

} else {
var statearr_31551_31592 = state_31514__$1;
(statearr_31551_31592[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (5))){
var _ = (function (){var statearr_31552 = state_31514;
(statearr_31552[(4)] = cljs.core.rest((state_31514[(4)])));

return statearr_31552;
})();
var state_31514__$1 = state_31514;
var ex31547 = (state_31514__$1[(2)]);
var statearr_31553_31593 = state_31514__$1;
(statearr_31553_31593[(5)] = ex31547);


if((ex31547 instanceof Error)){
var statearr_31554_31594 = state_31514__$1;
(statearr_31554_31594[(1)] = (4));

(statearr_31554_31594[(5)] = null);

} else {
throw ex31547;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (14))){
var state_31514__$1 = state_31514;
var statearr_31555_31595 = state_31514__$1;
(statearr_31555_31595[(2)] = null);

(statearr_31555_31595[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (26))){
var state_31514__$1 = state_31514;
var statearr_31556_31596 = state_31514__$1;
(statearr_31556_31596[(2)] = null);

(statearr_31556_31596[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (16))){
var state_31514__$1 = state_31514;
var statearr_31557_31597 = state_31514__$1;
(statearr_31557_31597[(2)] = null);

(statearr_31557_31597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (10))){
var inst_31430 = (state_31514[(13)]);
var inst_31451 = (state_31514[(12)]);
var inst_31448 = cljs.core.first(inst_31430);
var inst_31449 = cljs.core.first(clause);
var inst_31450 = fluree.db.query.analytical.variable_QMARK_(inst_31449);
var inst_31451__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_31430,(1));
var inst_31452 = fluree.db.query.analytical.variable_QMARK_(inst_31451__$1);
var state_31514__$1 = (function (){var statearr_31558 = state_31514;
(statearr_31558[(10)] = inst_31450);

(statearr_31558[(8)] = inst_31448);

(statearr_31558[(12)] = inst_31451__$1);

return statearr_31558;
})();
if(cljs.core.truth_(inst_31452)){
var statearr_31559_31598 = state_31514__$1;
(statearr_31559_31598[(1)] = (13));

} else {
var statearr_31560_31599 = state_31514__$1;
(statearr_31560_31599[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (18))){
var inst_31450 = (state_31514[(10)]);
var inst_31474 = (state_31514[(2)]);
var state_31514__$1 = (function (){var statearr_31561 = state_31514;
(statearr_31561[(20)] = inst_31474);

return statearr_31561;
})();
if(cljs.core.truth_(inst_31450)){
var statearr_31562_31600 = state_31514__$1;
(statearr_31562_31600[(1)] = (19));

} else {
var statearr_31563_31601 = state_31514__$1;
(statearr_31563_31601[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31515 === (8))){
var inst_31431 = (state_31514[(18)]);
var inst_31430 = (state_31514[(13)]);
var inst_31436 = (state_31514[(2)]);
var inst_31437 = [inst_31436];
var inst_31438 = cljs.core.PersistentHashMap.fromArrays(inst_31431,inst_31437);
var inst_31439 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_31430,inst_31438);
var state_31514__$1 = state_31514;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31514__$1,(9),inst_31439);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____0 = (function (){
var statearr_31564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31564[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__);

(statearr_31564[(1)] = (1));

return statearr_31564;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____1 = (function (state_31514){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_31514);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31565){var ex__11413__auto__ = e31565;
var statearr_31566_31602 = state_31514;
(statearr_31566_31602[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_31514[(4)]))){
var statearr_31567_31603 = state_31514;
(statearr_31567_31603[(1)] = cljs.core.first((state_31514[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31604 = state_31514;
state_31514 = G__31604;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__ = function(state_31514){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____1.call(this,state_31514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31568 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31568[(6)] = c__11484__auto__);

return statearr_31568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__31605,res,clause){
var map__31606 = p__31605;
var map__31606__$1 = cljs.core.__destructure_map(map__31606);
var db = map__31606__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31606__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31606__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31606__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_31715){
var state_val_31716 = (state_31715[(1)]);
if((state_val_31716 === (7))){
var inst_31615 = (state_31715[(7)]);
var state_31715__$1 = state_31715;
var statearr_31717_31758 = state_31715__$1;
(statearr_31717_31758[(2)] = inst_31615);

(statearr_31717_31758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (20))){
var state_31715__$1 = state_31715;
var statearr_31718_31759 = state_31715__$1;
(statearr_31718_31759[(2)] = null);

(statearr_31718_31759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (1))){
var state_31715__$1 = state_31715;
var statearr_31719_31760 = state_31715__$1;
(statearr_31719_31760[(2)] = null);

(statearr_31719_31760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (24))){
var inst_31617 = (state_31715[(8)]);
var inst_31688 = (state_31715[(2)]);
var inst_31689 = fluree.db.flake.sid__GT_cid(inst_31688);
var inst_31690 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_31689);
var inst_31691 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31693 = [inst_31617];
var inst_31694 = (new cljs.core.PersistentVector(null,1,(5),inst_31692,inst_31693,null));
var inst_31695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31697 = [inst_31690];
var inst_31698 = (new cljs.core.PersistentVector(null,1,(5),inst_31696,inst_31697,null));
var inst_31699 = [inst_31698];
var inst_31700 = (new cljs.core.PersistentVector(null,1,(5),inst_31695,inst_31699,null));
var inst_31701 = cljs.core.PersistentHashMap.EMPTY;
var inst_31702 = [inst_31694,inst_31700,inst_31701];
var inst_31703 = cljs.core.PersistentHashMap.fromArrays(inst_31691,inst_31702);
var state_31715__$1 = state_31715;
var statearr_31720_31761 = state_31715__$1;
(statearr_31720_31761[(2)] = inst_31703);

(statearr_31720_31761[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (4))){
var inst_31608 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
var statearr_31721_31762 = state_31715__$1;
(statearr_31721_31762[(2)] = inst_31608);

(statearr_31721_31762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (15))){
var inst_31615 = (state_31715[(7)]);
var inst_31617 = (state_31715[(8)]);
var inst_31636 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_31637 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31639 = [inst_31615];
var inst_31640 = (new cljs.core.PersistentVector(null,1,(5),inst_31638,inst_31639,null));
var inst_31641 = (function (){var subject_var = inst_31615;
var object_var = inst_31617;
var min_sid = inst_31636;
var max_sid = (0);
return (function (p1__31607_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__31607_SHARP_);
});
})();
var inst_31642 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_31636,(0));
var inst_31643 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31641,inst_31642);
var inst_31644 = cljs.core.PersistentHashMap.EMPTY;
var inst_31645 = [inst_31640,inst_31643,inst_31644];
var inst_31646 = cljs.core.PersistentHashMap.fromArrays(inst_31637,inst_31645);
var state_31715__$1 = state_31715;
var statearr_31722_31763 = state_31715__$1;
(statearr_31722_31763[(2)] = inst_31646);

(statearr_31722_31763[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (21))){
var inst_31706 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
var statearr_31723_31764 = state_31715__$1;
(statearr_31723_31764[(2)] = inst_31706);

(statearr_31723_31764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (13))){
var inst_31617 = (state_31715[(8)]);
var state_31715__$1 = state_31715;
if(cljs.core.truth_(inst_31617)){
var statearr_31724_31765 = state_31715__$1;
(statearr_31724_31765[(1)] = (19));

} else {
var statearr_31725_31766 = state_31715__$1;
(statearr_31725_31766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (22))){
var inst_31679 = (state_31715[(9)]);
var state_31715__$1 = state_31715;
var statearr_31726_31767 = state_31715__$1;
(statearr_31726_31767[(2)] = inst_31679);

(statearr_31726_31767[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (6))){
var inst_31617 = (state_31715[(8)]);
var state_31715__$1 = state_31715;
var statearr_31727_31768 = state_31715__$1;
(statearr_31727_31768[(2)] = inst_31617);

(statearr_31727_31768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (25))){
var inst_31685 = (state_31715[(2)]);
var inst_31686 = fluree.db.util.async.throw_err(inst_31685);
var state_31715__$1 = state_31715;
var statearr_31728_31769 = state_31715__$1;
(statearr_31728_31769[(2)] = inst_31686);

(statearr_31728_31769[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (17))){
var inst_31676 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
var statearr_31729_31770 = state_31715__$1;
(statearr_31729_31770[(2)] = inst_31676);

(statearr_31729_31770[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (3))){
var inst_31713 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31715__$1,inst_31713);
} else {
if((state_val_31716 === (12))){
var inst_31630 = ["_tx",null,"_block",null];
var inst_31631 = (new cljs.core.PersistentArrayMap(null,2,inst_31630,null));
var inst_31632 = (new cljs.core.PersistentHashSet(null,inst_31631,null));
var inst_31633 = cljs.core.last(clause);
var inst_31634 = (inst_31632.cljs$core$IFn$_invoke$arity$1 ? inst_31632.cljs$core$IFn$_invoke$arity$1(inst_31633) : inst_31632.call(null,inst_31633));
var state_31715__$1 = state_31715;
if(cljs.core.truth_(inst_31634)){
var statearr_31730_31771 = state_31715__$1;
(statearr_31730_31771[(1)] = (15));

} else {
var statearr_31731_31772 = state_31715__$1;
(statearr_31731_31772[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (2))){
var inst_31615 = (state_31715[(7)]);
var _ = (function (){var statearr_31732 = state_31715;
(statearr_31732[(4)] = cljs.core.cons((5),(state_31715[(4)])));

return statearr_31732;
})();
var inst_31614 = cljs.core.first(clause);
var inst_31615__$1 = fluree.db.query.analytical.variable_QMARK_(inst_31614);
var inst_31616 = cljs.core.last(clause);
var inst_31617 = fluree.db.query.analytical.variable_QMARK_(inst_31616);
var state_31715__$1 = (function (){var statearr_31733 = state_31715;
(statearr_31733[(7)] = inst_31615__$1);

(statearr_31733[(8)] = inst_31617);

return statearr_31733;
})();
if(cljs.core.truth_(inst_31615__$1)){
var statearr_31734_31773 = state_31715__$1;
(statearr_31734_31773[(1)] = (6));

} else {
var statearr_31735_31774 = state_31715__$1;
(statearr_31735_31774[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (23))){
var inst_31679 = (state_31715[(9)]);
var inst_31683 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31679);
var state_31715__$1 = state_31715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31715__$1,(25),inst_31683);
} else {
if((state_val_31716 === (19))){
var inst_31679 = (state_31715[(9)]);
var inst_31679__$1 = cljs.core.first(clause);
var inst_31680 = typeof inst_31679__$1 === 'number';
var state_31715__$1 = (function (){var statearr_31736 = state_31715;
(statearr_31736[(9)] = inst_31679__$1);

return statearr_31736;
})();
if(cljs.core.truth_(inst_31680)){
var statearr_31737_31775 = state_31715__$1;
(statearr_31737_31775[(1)] = (22));

} else {
var statearr_31738_31776 = state_31715__$1;
(statearr_31738_31776[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (11))){
var inst_31710 = (state_31715[(2)]);
var _ = (function (){var statearr_31740 = state_31715;
(statearr_31740[(4)] = cljs.core.rest((state_31715[(4)])));

return statearr_31740;
})();
var state_31715__$1 = state_31715;
var statearr_31741_31777 = state_31715__$1;
(statearr_31741_31777[(2)] = inst_31710);

(statearr_31741_31777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (9))){
var inst_31623 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31624 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31625 = cljs.core.PersistentHashMap.fromArrays(inst_31623,inst_31624);
var inst_31626 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_31625);
var inst_31627 = (function(){throw inst_31626})();
var state_31715__$1 = state_31715;
var statearr_31742_31778 = state_31715__$1;
(statearr_31742_31778[(2)] = inst_31627);

(statearr_31742_31778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (5))){
var _ = (function (){var statearr_31743 = state_31715;
(statearr_31743[(4)] = cljs.core.rest((state_31715[(4)])));

return statearr_31743;
})();
var state_31715__$1 = state_31715;
var ex31739 = (state_31715__$1[(2)]);
var statearr_31744_31779 = state_31715__$1;
(statearr_31744_31779[(5)] = ex31739);


if((ex31739 instanceof Error)){
var statearr_31745_31780 = state_31715__$1;
(statearr_31745_31780[(1)] = (4));

(statearr_31745_31780[(5)] = null);

} else {
throw ex31739;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (14))){
var inst_31708 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
var statearr_31746_31781 = state_31715__$1;
(statearr_31746_31781[(2)] = inst_31708);

(statearr_31746_31781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (16))){
var inst_31652 = (state_31715[(10)]);
var inst_31649 = (state_31715[(11)]);
var inst_31651 = (state_31715[(12)]);
var inst_31648 = cljs.core.last(clause);
var inst_31649__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_31648);
var inst_31650 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_31651__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31650,inst_31649__$1);
var inst_31652__$1 = fluree.db.flake.min_subject_id(inst_31649__$1);
var inst_31653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31654 = [inst_31651__$1];
var inst_31655 = (new cljs.core.PersistentVector(null,1,(5),inst_31653,inst_31654,null));
var inst_31656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31657 = [inst_31652__$1];
var inst_31658 = (new cljs.core.PersistentVector(null,1,(5),inst_31656,inst_31657,null));
var inst_31659 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_31655,cljs.core._LT__EQ_,inst_31658);
var state_31715__$1 = (function (){var statearr_31747 = state_31715;
(statearr_31747[(10)] = inst_31652__$1);

(statearr_31747[(11)] = inst_31649__$1);

(statearr_31747[(12)] = inst_31651__$1);

return statearr_31747;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31715__$1,(18),inst_31659);
} else {
if((state_val_31716 === (10))){
var inst_31615 = (state_31715[(7)]);
var state_31715__$1 = state_31715;
if(cljs.core.truth_(inst_31615)){
var statearr_31748_31782 = state_31715__$1;
(statearr_31748_31782[(1)] = (12));

} else {
var statearr_31749_31783 = state_31715__$1;
(statearr_31749_31783[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (18))){
var inst_31652 = (state_31715[(10)]);
var inst_31649 = (state_31715[(11)]);
var inst_31615 = (state_31715[(7)]);
var inst_31617 = (state_31715[(8)]);
var inst_31651 = (state_31715[(12)]);
var inst_31661 = (state_31715[(2)]);
var inst_31662 = fluree.db.util.async.throw_err(inst_31661);
var inst_31663 = (function (){var subject_var = inst_31615;
var object_var = inst_31617;
var partition = inst_31649;
var max_sid = inst_31651;
var min_sid = inst_31652;
var flakes = inst_31662;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_31664 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_31663);
var inst_31665 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_31666 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_31664,inst_31665);
var inst_31667 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31669 = [inst_31615];
var inst_31670 = (new cljs.core.PersistentVector(null,1,(5),inst_31668,inst_31669,null));
var inst_31671 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_31666,inst_31662);
var inst_31672 = cljs.core.PersistentHashMap.EMPTY;
var inst_31673 = [inst_31670,inst_31671,inst_31672];
var inst_31674 = cljs.core.PersistentHashMap.fromArrays(inst_31667,inst_31673);
var state_31715__$1 = state_31715;
var statearr_31750_31784 = state_31715__$1;
(statearr_31750_31784[(2)] = inst_31674);

(statearr_31750_31784[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31716 === (8))){
var inst_31621 = (state_31715[(2)]);
var state_31715__$1 = state_31715;
if(cljs.core.truth_(inst_31621)){
var statearr_31751_31785 = state_31715__$1;
(statearr_31751_31785[(1)] = (9));

} else {
var statearr_31752_31786 = state_31715__$1;
(statearr_31752_31786[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____0 = (function (){
var statearr_31753 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31753[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__);

(statearr_31753[(1)] = (1));

return statearr_31753;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____1 = (function (state_31715){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_31715);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31754){var ex__11413__auto__ = e31754;
var statearr_31755_31787 = state_31715;
(statearr_31755_31787[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_31715[(4)]))){
var statearr_31756_31788 = state_31715;
(statearr_31756_31788[(1)] = cljs.core.first((state_31715[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31789 = state_31715;
state_31715 = G__31789;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__ = function(state_31715){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____1.call(this,state_31715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31757 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31757[(6)] = c__11484__auto__);

return statearr_31757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__31796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__31796 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__31796;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__31797(s__31798){
return (new cljs.core.LazySeq(null,(function (){
var s__31798__$1 = s__31798;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__31798__$1);
if(temp__5753__auto__){
var s__31798__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31798__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__31798__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__31800 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__31799 = (0);
while(true){
if((i__31799 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__31799);
var delta = (x - mean);
cljs.core.chunk_append(b__31800,(delta * delta));

var G__31802 = (i__31799 + (1));
i__31799 = G__31802;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31800),fluree$db$query$analytical$variance_$_iter__31797(cljs.core.chunk_rest(s__31798__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31800),null);
}
} else {
var x = cljs.core.first(s__31798__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__31797(cljs.core.rest(s__31798__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__31801 = variance(coll);
return Math.sqrt(G__31801);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__31803 = null;
var G__31803__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__31803__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31803 = function(n,coll){
switch(arguments.length){
case 1:
return G__31803__1.call(this,n);
case 2:
return G__31803__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31803.cljs$core$IFn$_invoke$arity$1 = G__31803__1;
G__31803.cljs$core$IFn$_invoke$arity$2 = G__31803__2;
return G__31803;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__31804 = null;
var G__31804__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__31804__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31804 = function(n,coll){
switch(arguments.length){
case 1:
return G__31804__1.call(this,n);
case 2:
return G__31804__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31804.cljs$core$IFn$_invoke$arity$1 = G__31804__1;
G__31804.cljs$core$IFn$_invoke$arity$2 = G__31804__2;
return G__31804;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__31805 = null;
var G__31805__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__31805__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__31805 = function(n,coll){
switch(arguments.length){
case 1:
return G__31805__1.call(this,n);
case 2:
return G__31805__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31805.cljs$core$IFn$_invoke$arity$1 = G__31805__1;
G__31805.cljs$core$IFn$_invoke$arity$2 = G__31805__2;
return G__31805;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__31806 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31806,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31806,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31806,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__31809 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__31812 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__31812) : agg_fn.call(null,G__31812));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31809,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31809,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__31813 = agg;
var map__31813__$1 = cljs.core.__destructure_map(map__31813);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31813__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31813__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31813__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__31815 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31815,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31815,(1),null);
var map__31818 = res__$1;
var map__31818__$1 = cljs.core.__destructure_map(map__31818);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31818__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31814_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__31814_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31819_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__31819_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31820_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__31820_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__31821_SHARP_,p2__31822_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31821_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__31822_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31823_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__31823_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__31826,row,b_tuple){
var vec__31827 = p__31826;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31827,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31827,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31824_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__31824_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31825_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__31825_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31830_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__31830_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31831_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31831_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__31836 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__31838 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__31837 = (function (p1__31832_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__31832_SHARP_);
});
return fexpr__31837(G__31838);
})()),cljs.core.set(b_idxs));
var fexpr__31835 = (function (p1__31833_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__31833_SHARP_);
});
return fexpr__31835(G__31836);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31834_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31834_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31839_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__31839_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31840_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31840_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__31845 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__31847 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__31846 = (function (p1__31841_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__31841_SHARP_);
});
return fexpr__31846(G__31847);
})()),cljs.core.set(b_idxs));
var fexpr__31844 = (function (p1__31842_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__31842_SHARP_);
});
return fexpr__31844(G__31845);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31843_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31843_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__31849 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31849,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31849,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__31848_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__31848_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__31854 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31854,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31854,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31852_SHARP_){
return fluree.db.util.core.index_of(headers,p1__31852_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__31853_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__31853_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__31857,filters,optional_QMARK_){
var map__31858 = p__31857;
var map__31858__$1 = cljs.core.__destructure_map(map__31858);
var tuple_map = map__31858__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31858__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31858__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31858__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__31859 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31859,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31859,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__31862 = res;
var map__31862__$1 = cljs.core.__destructure_map(map__31862);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31862__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31862__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_31918){
var state_val_31919 = (state_31918[(1)]);
if((state_val_31919 === (7))){
var inst_31892 = (state_31918[(7)]);
var inst_31890 = (state_31918[(2)]);
var inst_31891 = fluree.db.util.async.throw_err(inst_31890);
var inst_31892__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31891,(0),null);
var inst_31893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31891,(1),null);
var inst_31894 = (inst_31892__$1 == null);
var state_31918__$1 = (function (){var statearr_31920 = state_31918;
(statearr_31920[(8)] = inst_31893);

(statearr_31920[(7)] = inst_31892__$1);

return statearr_31920;
})();
if(cljs.core.truth_(inst_31894)){
var statearr_31921_31950 = state_31918__$1;
(statearr_31921_31950[(1)] = (8));

} else {
var statearr_31922_31951 = state_31918__$1;
(statearr_31922_31951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (1))){
var inst_31870 = optional_clauses;
var inst_31871 = cljs.core.seq(inst_31870);
var inst_31872 = cljs.core.first(inst_31871);
var inst_31873 = cljs.core.next(inst_31871);
var inst_31874 = where_tuples;
var inst_31875 = inst_31870;
var inst_31876 = inst_31874;
var state_31918__$1 = (function (){var statearr_31923 = state_31918;
(statearr_31923[(9)] = inst_31875);

(statearr_31923[(10)] = inst_31873);

(statearr_31923[(11)] = inst_31872);

(statearr_31923[(12)] = inst_31876);

return statearr_31923;
})();
var statearr_31924_31952 = state_31918__$1;
(statearr_31924_31952[(2)] = null);

(statearr_31924_31952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (4))){
var inst_31883 = (state_31918[(13)]);
var inst_31876 = (state_31918[(12)]);
var inst_31882 = (state_31918[(14)]);
var inst_31888 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_31876,inst_31882,inst_31883,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_31876,inst_31882,inst_31883,true,fuel,max_fuel,opts));
var state_31918__$1 = state_31918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31918__$1,(7),inst_31888);
} else {
if((state_val_31919 === (15))){
var state_31918__$1 = state_31918;
var statearr_31925_31953 = state_31918__$1;
(statearr_31925_31953[(2)] = null);

(statearr_31925_31953[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (13))){
var inst_31909 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31926_31954 = state_31918__$1;
(statearr_31926_31954[(2)] = inst_31909);

(statearr_31926_31954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (6))){
var inst_31914 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31927_31955 = state_31918__$1;
(statearr_31927_31955[(2)] = inst_31914);

(statearr_31927_31955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (3))){
var inst_31916 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31918__$1,inst_31916);
} else {
if((state_val_31919 === (12))){
var state_31918__$1 = state_31918;
var statearr_31928_31956 = state_31918__$1;
(statearr_31928_31956[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (2))){
var inst_31875 = (state_31918[(9)]);
var inst_31882 = (state_31918[(14)]);
var inst_31881 = cljs.core.seq(inst_31875);
var inst_31882__$1 = cljs.core.first(inst_31881);
var inst_31883 = cljs.core.next(inst_31881);
var state_31918__$1 = (function (){var statearr_31930 = state_31918;
(statearr_31930[(13)] = inst_31883);

(statearr_31930[(14)] = inst_31882__$1);

return statearr_31930;
})();
if(cljs.core.truth_(inst_31882__$1)){
var statearr_31931_31957 = state_31918__$1;
(statearr_31931_31957[(1)] = (4));

} else {
var statearr_31932_31958 = state_31918__$1;
(statearr_31932_31958[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (11))){
var inst_31893 = (state_31918[(8)]);
var inst_31892 = (state_31918[(7)]);
var inst_31875 = inst_31893;
var inst_31876 = inst_31892;
var state_31918__$1 = (function (){var statearr_31933 = state_31918;
(statearr_31933[(9)] = inst_31875);

(statearr_31933[(12)] = inst_31876);

return statearr_31933;
})();
var statearr_31934_31959 = state_31918__$1;
(statearr_31934_31959[(2)] = null);

(statearr_31934_31959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (9))){
var inst_31882 = (state_31918[(14)]);
var inst_31898 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_31882);
var state_31918__$1 = state_31918;
if(cljs.core.truth_(inst_31898)){
var statearr_31935_31960 = state_31918__$1;
(statearr_31935_31960[(1)] = (11));

} else {
var statearr_31936_31961 = state_31918__$1;
(statearr_31936_31961[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (5))){
var inst_31876 = (state_31918[(12)]);
var state_31918__$1 = state_31918;
var statearr_31937_31962 = state_31918__$1;
(statearr_31937_31962[(2)] = inst_31876);

(statearr_31937_31962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (14))){
var inst_31893 = (state_31918[(8)]);
var inst_31876 = (state_31918[(12)]);
var inst_31892 = (state_31918[(7)]);
var inst_31903 = fluree.db.query.analytical.left_outer_join(inst_31876,inst_31892);
var inst_31875 = inst_31893;
var inst_31876__$1 = inst_31903;
var state_31918__$1 = (function (){var statearr_31938 = state_31918;
(statearr_31938[(9)] = inst_31875);

(statearr_31938[(12)] = inst_31876__$1);

return statearr_31938;
})();
var statearr_31939_31963 = state_31918__$1;
(statearr_31939_31963[(2)] = null);

(statearr_31939_31963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (16))){
var inst_31907 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31941_31964 = state_31918__$1;
(statearr_31941_31964[(2)] = inst_31907);

(statearr_31941_31964[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (10))){
var inst_31911 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31942_31965 = state_31918__$1;
(statearr_31942_31965[(2)] = inst_31911);

(statearr_31942_31965[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31919 === (8))){
var inst_31893 = (state_31918[(8)]);
var inst_31876 = (state_31918[(12)]);
var tmp31940 = inst_31876;
var inst_31875 = inst_31893;
var inst_31876__$1 = tmp31940;
var state_31918__$1 = (function (){var statearr_31943 = state_31918;
(statearr_31943[(9)] = inst_31875);

(statearr_31943[(12)] = inst_31876__$1);

return statearr_31943;
})();
var statearr_31944_31966 = state_31918__$1;
(statearr_31944_31966[(2)] = null);

(statearr_31944_31966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____0 = (function (){
var statearr_31945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31945[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__);

(statearr_31945[(1)] = (1));

return statearr_31945;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____1 = (function (state_31918){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_31918);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e31946){var ex__11413__auto__ = e31946;
var statearr_31947_31967 = state_31918;
(statearr_31947_31967[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_31918[(4)]))){
var statearr_31948_31968 = state_31918;
(statearr_31948_31968[(1)] = cljs.core.first((state_31918[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31969 = state_31918;
state_31918 = G__31969;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__ = function(state_31918){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____1.call(this,state_31918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_31949 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_31949[(6)] = c__11484__auto__);

return statearr_31949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__31971){
var vec__31972 = p__31971;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31972,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31972,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31970_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31970_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__31976,p__31977,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__31978 = p__31976;
var map__31978__$1 = cljs.core.__destructure_map(map__31978);
var q_map = map__31978__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31978__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__31979 = p__31977;
var map__31979__$1 = cljs.core.__destructure_map(map__31979);
var res = map__31979__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31979__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_32216){
var state_val_32217 = (state_32216[(1)]);
if((state_val_32217 === (65))){
var inst_32166 = (state_32216[(7)]);
var inst_32165 = (state_32216[(8)]);
var inst_32177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32178 = fluree.db.query.analytical.full_text__GT_tuples(inst_32165,res,inst_32166);
var inst_32179 = [inst_32178,r];
var inst_32180 = (new cljs.core.PersistentVector(null,2,(5),inst_32177,inst_32179,null));
var state_32216__$1 = state_32216;
var statearr_32218_32331 = state_32216__$1;
(statearr_32218_32331[(2)] = inst_32180);

(statearr_32218_32331[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (70))){
var inst_32192 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32219_32332 = state_32216__$1;
(statearr_32219_32332[(2)] = inst_32192);

(statearr_32219_32332[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (62))){
var inst_32166 = (state_32216[(7)]);
var inst_32174 = cljs.core.second(inst_32166);
var inst_32175 = clojure.string.starts_with_QMARK_(inst_32174,"fullText:");
var state_32216__$1 = state_32216;
if(inst_32175){
var statearr_32220_32333 = state_32216__$1;
(statearr_32220_32333[(1)] = (65));

} else {
var statearr_32221_32334 = state_32216__$1;
(statearr_32221_32334[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (7))){
var inst_32085 = (state_32216[(9)]);
var inst_32084 = cljs.core.count(clause);
var inst_32085__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32084);
var state_32216__$1 = (function (){var statearr_32222 = state_32216;
(statearr_32222[(9)] = inst_32085__$1);

return statearr_32222;
})();
if(inst_32085__$1){
var statearr_32223_32335 = state_32216__$1;
(statearr_32223_32335[(1)] = (31));

} else {
var statearr_32224_32336 = state_32216__$1;
(statearr_32224_32336[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (59))){
var inst_32199 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32225_32337 = state_32216__$1;
(statearr_32225_32337[(2)] = inst_32199);

(statearr_32225_32337[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (20))){
var inst_32048 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32226_32338 = state_32216__$1;
(statearr_32226_32338[(2)] = inst_32048);

(statearr_32226_32338[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (58))){
var state_32216__$1 = state_32216;
var statearr_32227_32339 = state_32216__$1;
(statearr_32227_32339[(2)] = null);

(statearr_32227_32339[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (60))){
var inst_32165 = (state_32216[(8)]);
var inst_32163 = (state_32216[(2)]);
var inst_32164 = fluree.db.util.async.throw_err(inst_32163);
var inst_32165__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32164,(0),null);
var inst_32166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32164,(1),null);
var inst_32167 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_32165__$1);
var state_32216__$1 = (function (){var statearr_32228 = state_32216;
(statearr_32228[(7)] = inst_32166);

(statearr_32228[(8)] = inst_32165__$1);

return statearr_32228;
})();
if(inst_32167){
var statearr_32229_32340 = state_32216__$1;
(statearr_32229_32340[(1)] = (61));

} else {
var statearr_32230_32341 = state_32216__$1;
(statearr_32230_32341[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (27))){
var inst_32078 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32231_32342 = state_32216__$1;
(statearr_32231_32342[(2)] = inst_32078);

(statearr_32231_32342[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (1))){
var state_32216__$1 = state_32216;
var statearr_32232_32343 = state_32216__$1;
(statearr_32232_32343[(2)] = null);

(statearr_32232_32343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (69))){
var state_32216__$1 = state_32216;
var statearr_32233_32344 = state_32216__$1;
(statearr_32233_32344[(2)] = null);

(statearr_32233_32344[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (24))){
var inst_32042 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32234_32345 = state_32216__$1;
(statearr_32234_32345[(2)] = inst_32042);

(statearr_32234_32345[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (55))){
var inst_32148 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_32149 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32150 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32151 = cljs.core.PersistentHashMap.fromArrays(inst_32149,inst_32150);
var inst_32152 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32148,inst_32151);
var inst_32153 = (function(){throw inst_32152})();
var state_32216__$1 = state_32216;
var statearr_32235_32346 = state_32216__$1;
(statearr_32235_32346[(2)] = inst_32153);

(statearr_32235_32346[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (39))){
var inst_32105 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
if(cljs.core.truth_(inst_32105)){
var statearr_32236_32347 = state_32216__$1;
(statearr_32236_32347[(1)] = (40));

} else {
var statearr_32237_32348 = state_32216__$1;
(statearr_32237_32348[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (46))){
var inst_32205 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32238_32349 = state_32216__$1;
(statearr_32238_32349[(2)] = inst_32205);

(statearr_32238_32349[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (4))){
var inst_31980 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32239_32350 = state_32216__$1;
(statearr_32239_32350[(2)] = inst_31980);

(statearr_32239_32350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (54))){
var inst_32141 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_32142 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32143 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32144 = cljs.core.PersistentHashMap.fromArrays(inst_32142,inst_32143);
var inst_32145 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32141,inst_32144);
var inst_32146 = (function(){throw inst_32145})();
var state_32216__$1 = state_32216;
var statearr_32240_32351 = state_32216__$1;
(statearr_32240_32351[(2)] = inst_32146);

(statearr_32240_32351[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (15))){
var inst_32080 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32241_32352 = state_32216__$1;
(statearr_32241_32352[(2)] = inst_32080);

(statearr_32241_32352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (48))){
var inst_32129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32130 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_32131 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_32130);
var inst_32132 = [inst_32131,r];
var inst_32133 = (new cljs.core.PersistentVector(null,2,(5),inst_32129,inst_32132,null));
var state_32216__$1 = state_32216;
var statearr_32242_32353 = state_32216__$1;
(statearr_32242_32353[(2)] = inst_32133);

(statearr_32242_32353[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (50))){
var inst_32203 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32243_32354 = state_32216__$1;
(statearr_32243_32354[(2)] = inst_32203);

(statearr_32243_32354[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (21))){
var inst_32014 = (state_32216[(10)]);
var inst_32018 = (state_32216[(11)]);
var inst_32025 = (state_32216[(12)]);
var inst_32017 = (state_32216[(13)]);
var inst_32026 = (state_32216[(14)]);
var inst_31993 = (state_32216[(15)]);
var inst_32019 = (state_32216[(16)]);
var inst_31989 = (state_32216[(17)]);
var inst_32016 = (state_32216[(18)]);
var inst_32030 = (state_32216[(2)]);
var inst_32031 = fluree.db.util.async.throw_err(inst_32030);
var inst_32032 = (function (){var new_res = inst_32031;
var vec__32011 = inst_32014;
var rest = inst_32026;
var G__32010 = inst_32018;
var seq__32012 = inst_32017;
var tuples = inst_32019;
var vec__32021 = inst_32018;
var first__32023 = inst_32025;
var pred__31990 = inst_31993;
var segment_type = inst_31989;
var expr__31991 = inst_31989;
var seq__32022 = inst_32026;
var first__32013 = inst_32016;
var clause_group = inst_32025;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_32033 = cljs.core.keys(vars);
var inst_32034 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32032,inst_32031,inst_32033);
var inst_32035 = fluree.db.query.analytical.res_absorb_vars(inst_32034);
var state_32216__$1 = (function (){var statearr_32244 = state_32216;
(statearr_32244[(19)] = inst_32035);

return statearr_32244;
})();
if(cljs.core.truth_(inst_32019)){
var statearr_32245_32355 = state_32216__$1;
(statearr_32245_32355[(1)] = (22));

} else {
var statearr_32246_32356 = state_32216__$1;
(statearr_32246_32356[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (31))){
var inst_32087 = cljs.core.second(clause);
var inst_32088 = clojure.string.starts_with_QMARK_(inst_32087,"fullText:");
var state_32216__$1 = state_32216;
var statearr_32247_32357 = state_32216__$1;
(statearr_32247_32357[(2)] = inst_32088);

(statearr_32247_32357[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (32))){
var inst_32085 = (state_32216[(9)]);
var state_32216__$1 = state_32216;
var statearr_32248_32358 = state_32216__$1;
(statearr_32248_32358[(2)] = inst_32085);

(statearr_32248_32358[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (40))){
var inst_32107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32108 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_32216__$1 = (function (){var statearr_32249 = state_32216;
(statearr_32249[(20)] = inst_32107);

return statearr_32249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(43),inst_32108);
} else {
if((state_val_32217 === (56))){
var inst_32155 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32250_32359 = state_32216__$1;
(statearr_32250_32359[(2)] = inst_32155);

(statearr_32250_32359[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (33))){
var inst_32091 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
if(cljs.core.truth_(inst_32091)){
var statearr_32251_32360 = state_32216__$1;
(statearr_32251_32360[(1)] = (34));

} else {
var statearr_32252_32361 = state_32216__$1;
(statearr_32252_32361[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (13))){
var inst_32014 = (state_32216[(10)]);
var inst_32014__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32015 = cljs.core.seq(inst_32014__$1);
var inst_32016 = cljs.core.first(inst_32015);
var inst_32017 = cljs.core.next(inst_32015);
var inst_32018 = inst_32014__$1;
var inst_32019 = null;
var state_32216__$1 = (function (){var statearr_32253 = state_32216;
(statearr_32253[(10)] = inst_32014__$1);

(statearr_32253[(11)] = inst_32018);

(statearr_32253[(13)] = inst_32017);

(statearr_32253[(16)] = inst_32019);

(statearr_32253[(18)] = inst_32016);

return statearr_32253;
})();
var statearr_32254_32362 = state_32216__$1;
(statearr_32254_32362[(2)] = null);

(statearr_32254_32362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (22))){
var inst_32035 = (state_32216[(19)]);
var inst_32026 = (state_32216[(14)]);
var inst_32019 = (state_32216[(16)]);
var inst_32037 = fluree.db.query.union.results(inst_32019,inst_32035);
var inst_32018 = inst_32026;
var inst_32019__$1 = inst_32037;
var state_32216__$1 = (function (){var statearr_32255 = state_32216;
(statearr_32255[(11)] = inst_32018);

(statearr_32255[(16)] = inst_32019__$1);

return statearr_32255;
})();
var statearr_32256_32363 = state_32216__$1;
(statearr_32256_32363[(2)] = null);

(statearr_32256_32363[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (36))){
var inst_32209 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32257_32364 = state_32216__$1;
(statearr_32257_32364[(2)] = inst_32209);

(statearr_32257_32364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (41))){
var inst_32115 = cljs.core.count(clause);
var inst_32116 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32115);
var state_32216__$1 = state_32216;
if(inst_32116){
var statearr_32258_32365 = state_32216__$1;
(statearr_32258_32365[(1)] = (44));

} else {
var statearr_32259_32366 = state_32216__$1;
(statearr_32259_32366[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (43))){
var inst_32107 = (state_32216[(20)]);
var inst_32110 = (state_32216[(2)]);
var inst_32111 = fluree.db.util.async.throw_err(inst_32110);
var inst_32112 = [inst_32111,r];
var inst_32113 = (new cljs.core.PersistentVector(null,2,(5),inst_32107,inst_32112,null));
var state_32216__$1 = state_32216;
var statearr_32260_32367 = state_32216__$1;
(statearr_32260_32367[(2)] = inst_32113);

(statearr_32260_32367[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (61))){
var inst_32166 = (state_32216[(7)]);
var inst_32169 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_32166,r,res,optional_QMARK_,fuel,max_fuel);
var state_32216__$1 = state_32216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(64),inst_32169);
} else {
if((state_val_32217 === (29))){
var inst_31989 = (state_32216[(17)]);
var inst_32072 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31989)].join('');
var inst_32073 = (new Error(inst_32072));
var inst_32074 = (function(){throw inst_32073})();
var state_32216__$1 = state_32216;
var statearr_32261_32368 = state_32216__$1;
(statearr_32261_32368[(2)] = inst_32074);

(statearr_32261_32368[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (44))){
var inst_32118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32119 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_32216__$1 = (function (){var statearr_32262 = state_32216;
(statearr_32262[(21)] = inst_32118);

return statearr_32262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(47),inst_32119);
} else {
if((state_val_32217 === (6))){
var inst_31993 = (state_32216[(15)]);
var inst_31989 = (state_32216[(17)]);
var inst_31988 = cljs.core.keys(clause);
var inst_31989__$1 = cljs.core.first(inst_31988);
var inst_31993__$1 = cljs.core._EQ_;
var inst_31994 = (function (){var G__32263 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__32264 = inst_31989__$1;
return (inst_31993__$1.cljs$core$IFn$_invoke$arity$2 ? inst_31993__$1.cljs$core$IFn$_invoke$arity$2(G__32263,G__32264) : inst_31993__$1.call(null,G__32263,G__32264));
})();
var state_32216__$1 = (function (){var statearr_32265 = state_32216;
(statearr_32265[(15)] = inst_31993__$1);

(statearr_32265[(17)] = inst_31989__$1);

return statearr_32265;
})();
if(cljs.core.truth_(inst_31994)){
var statearr_32266_32369 = state_32216__$1;
(statearr_32266_32369[(1)] = (9));

} else {
var statearr_32267_32370 = state_32216__$1;
(statearr_32267_32370[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (28))){
var inst_32066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32067 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32068 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_32067,optional_QMARK_);
var inst_32069 = [inst_32068,r];
var inst_32070 = (new cljs.core.PersistentVector(null,2,(5),inst_32066,inst_32069,null));
var state_32216__$1 = state_32216;
var statearr_32268_32371 = state_32216__$1;
(statearr_32268_32371[(2)] = inst_32070);

(statearr_32268_32371[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (64))){
var inst_32171 = (state_32216[(2)]);
var inst_32172 = fluree.db.util.async.throw_err(inst_32171);
var state_32216__$1 = state_32216;
var statearr_32269_32372 = state_32216__$1;
(statearr_32269_32372[(2)] = inst_32172);

(statearr_32269_32372[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (51))){
var inst_32138 = cljs.core.first(clause);
var inst_32139 = cljs.core.sequential_QMARK_(inst_32138);
var state_32216__$1 = state_32216;
if(inst_32139){
var statearr_32270_32373 = state_32216__$1;
(statearr_32270_32373[(1)] = (54));

} else {
var statearr_32271_32374 = state_32216__$1;
(statearr_32271_32374[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (25))){
var inst_31993 = (state_32216[(15)]);
var inst_31989 = (state_32216[(17)]);
var inst_32054 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32055 = (function (){var segment_type = inst_31989;
var pred__31990 = inst_31993;
var expr__31991 = inst_31989;
var bindings = inst_32054;
return (function (p1__31975_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__31975_SHARP_);
});
})();
var inst_32056 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32055,inst_32054);
var inst_32057 = cljs.core.PersistentHashMap.EMPTY;
var inst_32058 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32057,inst_32056);
var inst_32059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32060 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_32058);
var inst_32061 = [inst_32060,r];
var inst_32062 = (new cljs.core.PersistentVector(null,2,(5),inst_32059,inst_32061,null));
var state_32216__$1 = state_32216;
var statearr_32272_32375 = state_32216__$1;
(statearr_32272_32375[(2)] = inst_32062);

(statearr_32272_32375[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (34))){
var inst_32093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32094 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_32095 = [inst_32094,r];
var inst_32096 = (new cljs.core.PersistentVector(null,2,(5),inst_32093,inst_32095,null));
var state_32216__$1 = state_32216;
var statearr_32273_32376 = state_32216__$1;
(statearr_32273_32376[(2)] = inst_32096);

(statearr_32273_32376[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (17))){
var inst_32050 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32274_32377 = state_32216__$1;
(statearr_32274_32377[(2)] = inst_32050);

(statearr_32274_32377[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (3))){
var inst_32214 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32216__$1,inst_32214);
} else {
if((state_val_32217 === (12))){
var inst_31996 = (state_32216[(22)]);
var inst_32000 = (state_32216[(2)]);
var inst_32001 = fluree.db.util.async.throw_err(inst_32000);
var inst_32002 = [inst_32001,r];
var inst_32003 = (new cljs.core.PersistentVector(null,2,(5),inst_31996,inst_32002,null));
var state_32216__$1 = state_32216;
var statearr_32275_32378 = state_32216__$1;
(statearr_32275_32378[(2)] = inst_32003);

(statearr_32275_32378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (2))){
var _ = (function (){var statearr_32276 = state_32216;
(statearr_32276[(4)] = cljs.core.cons((5),(state_32216[(4)])));

return statearr_32276;
})();
var inst_31986 = cljs.core.map_QMARK_(clause);
var state_32216__$1 = state_32216;
if(inst_31986){
var statearr_32277_32379 = state_32216__$1;
(statearr_32277_32379[(1)] = (6));

} else {
var statearr_32278_32380 = state_32216__$1;
(statearr_32278_32380[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (66))){
var state_32216__$1 = state_32216;
var statearr_32279_32381 = state_32216__$1;
(statearr_32279_32381[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (23))){
var inst_32035 = (state_32216[(19)]);
var inst_32026 = (state_32216[(14)]);
var inst_32018 = inst_32026;
var inst_32019 = inst_32035;
var state_32216__$1 = (function (){var statearr_32281 = state_32216;
(statearr_32281[(11)] = inst_32018);

(statearr_32281[(16)] = inst_32019);

return statearr_32281;
})();
var statearr_32282_32382 = state_32216__$1;
(statearr_32282_32382[(2)] = null);

(statearr_32282_32382[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (47))){
var inst_32118 = (state_32216[(21)]);
var inst_32121 = (state_32216[(2)]);
var inst_32122 = fluree.db.util.async.throw_err(inst_32121);
var inst_32123 = [inst_32122,r];
var inst_32124 = (new cljs.core.PersistentVector(null,2,(5),inst_32118,inst_32123,null));
var state_32216__$1 = state_32216;
var statearr_32283_32383 = state_32216__$1;
(statearr_32283_32383[(2)] = inst_32124);

(statearr_32283_32383[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (35))){
var inst_32099 = (state_32216[(23)]);
var inst_32098 = cljs.core.count(clause);
var inst_32099__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32098);
var state_32216__$1 = (function (){var statearr_32284 = state_32216;
(statearr_32284[(23)] = inst_32099__$1);

return statearr_32284;
})();
if(inst_32099__$1){
var statearr_32285_32384 = state_32216__$1;
(statearr_32285_32384[(1)] = (37));

} else {
var statearr_32286_32385 = state_32216__$1;
(statearr_32286_32385[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (19))){
var inst_32019 = (state_32216[(16)]);
var inst_32044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32045 = [inst_32019,r];
var inst_32046 = (new cljs.core.PersistentVector(null,2,(5),inst_32044,inst_32045,null));
var state_32216__$1 = state_32216;
var statearr_32287_32386 = state_32216__$1;
(statearr_32287_32386[(2)] = inst_32046);

(statearr_32287_32386[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (57))){
var inst_32161 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_32216__$1 = state_32216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(60),inst_32161);
} else {
if((state_val_32217 === (68))){
var inst_32166 = (state_32216[(7)]);
var inst_32165 = (state_32216[(8)]);
var inst_32183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32184 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_32165,res,inst_32166,fuel,max_fuel);
var state_32216__$1 = (function (){var statearr_32288 = state_32216;
(statearr_32288[(24)] = inst_32183);

return statearr_32288;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(71),inst_32184);
} else {
if((state_val_32217 === (11))){
var inst_32082 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32290_32387 = state_32216__$1;
(statearr_32290_32387[(2)] = inst_32082);

(statearr_32290_32387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (9))){
var inst_31996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31997 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_31998 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_31997,res,fuel,max_fuel,opts);
var state_32216__$1 = (function (){var statearr_32291 = state_32216;
(statearr_32291[(22)] = inst_31996);

return statearr_32291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(12),inst_31998);
} else {
if((state_val_32217 === (5))){
var _ = (function (){var statearr_32292 = state_32216;
(statearr_32292[(4)] = cljs.core.rest((state_32216[(4)])));

return statearr_32292;
})();
var state_32216__$1 = state_32216;
var ex32289 = (state_32216__$1[(2)]);
var statearr_32293_32388 = state_32216__$1;
(statearr_32293_32388[(5)] = ex32289);


if((ex32289 instanceof Error)){
var statearr_32294_32389 = state_32216__$1;
(statearr_32294_32389[(1)] = (4));

(statearr_32294_32389[(5)] = null);

} else {
throw ex32289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (14))){
var inst_31993 = (state_32216[(15)]);
var inst_31989 = (state_32216[(17)]);
var inst_32052 = (function (){var G__32295 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__32296 = inst_31989;
return (inst_31993.cljs$core$IFn$_invoke$arity$2 ? inst_31993.cljs$core$IFn$_invoke$arity$2(G__32295,G__32296) : inst_31993.call(null,G__32295,G__32296));
})();
var state_32216__$1 = state_32216;
if(cljs.core.truth_(inst_32052)){
var statearr_32297_32390 = state_32216__$1;
(statearr_32297_32390[(1)] = (25));

} else {
var statearr_32298_32391 = state_32216__$1;
(statearr_32298_32391[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (45))){
var inst_32126 = cljs.core.count(clause);
var inst_32127 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_32126);
var state_32216__$1 = state_32216;
if(inst_32127){
var statearr_32299_32392 = state_32216__$1;
(statearr_32299_32392[(1)] = (48));

} else {
var statearr_32300_32393 = state_32216__$1;
(statearr_32300_32393[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (53))){
var inst_32201 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32301_32394 = state_32216__$1;
(statearr_32301_32394[(2)] = inst_32201);

(statearr_32301_32394[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (26))){
var inst_31993 = (state_32216[(15)]);
var inst_31989 = (state_32216[(17)]);
var inst_32064 = (function (){var G__32302 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__32303 = inst_31989;
return (inst_31993.cljs$core$IFn$_invoke$arity$2 ? inst_31993.cljs$core$IFn$_invoke$arity$2(G__32302,G__32303) : inst_31993.call(null,G__32302,G__32303));
})();
var state_32216__$1 = state_32216;
if(cljs.core.truth_(inst_32064)){
var statearr_32304_32395 = state_32216__$1;
(statearr_32304_32395[(1)] = (28));

} else {
var statearr_32305_32396 = state_32216__$1;
(statearr_32305_32396[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (16))){
var inst_32018 = (state_32216[(11)]);
var inst_32025 = (state_32216[(12)]);
var inst_32024 = cljs.core.seq(inst_32018);
var inst_32025__$1 = cljs.core.first(inst_32024);
var inst_32026 = cljs.core.next(inst_32024);
var state_32216__$1 = (function (){var statearr_32306 = state_32216;
(statearr_32306[(12)] = inst_32025__$1);

(statearr_32306[(14)] = inst_32026);

return statearr_32306;
})();
if(cljs.core.truth_(inst_32025__$1)){
var statearr_32307_32397 = state_32216__$1;
(statearr_32307_32397[(1)] = (18));

} else {
var statearr_32308_32398 = state_32216__$1;
(statearr_32308_32398[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (38))){
var inst_32099 = (state_32216[(23)]);
var state_32216__$1 = state_32216;
var statearr_32309_32399 = state_32216__$1;
(statearr_32309_32399[(2)] = inst_32099);

(statearr_32309_32399[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (30))){
var inst_32076 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32310_32400 = state_32216__$1;
(statearr_32310_32400[(2)] = inst_32076);

(statearr_32310_32400[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (10))){
var inst_31993 = (state_32216[(15)]);
var inst_31989 = (state_32216[(17)]);
var inst_32005 = (function (){var G__32311 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__32312 = inst_31989;
return (inst_31993.cljs$core$IFn$_invoke$arity$2 ? inst_31993.cljs$core$IFn$_invoke$arity$2(G__32311,G__32312) : inst_31993.call(null,G__32311,G__32312));
})();
var state_32216__$1 = state_32216;
if(cljs.core.truth_(inst_32005)){
var statearr_32313_32401 = state_32216__$1;
(statearr_32313_32401[(1)] = (13));

} else {
var statearr_32314_32402 = state_32216__$1;
(statearr_32314_32402[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (18))){
var inst_32025 = (state_32216[(12)]);
var inst_32028 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_32025,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_32025,q_map,vars,fuel,max_fuel,opts));
var state_32216__$1 = state_32216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32216__$1,(21),inst_32028);
} else {
if((state_val_32217 === (52))){
var state_32216__$1 = state_32216;
var statearr_32315_32403 = state_32216__$1;
(statearr_32315_32403[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (67))){
var inst_32194 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32317_32404 = state_32216__$1;
(statearr_32317_32404[(2)] = inst_32194);

(statearr_32317_32404[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (71))){
var inst_32183 = (state_32216[(24)]);
var inst_32186 = (state_32216[(2)]);
var inst_32187 = fluree.db.util.async.throw_err(inst_32186);
var inst_32188 = [inst_32187,r];
var inst_32189 = (new cljs.core.PersistentVector(null,2,(5),inst_32183,inst_32188,null));
var state_32216__$1 = state_32216;
var statearr_32318_32405 = state_32216__$1;
(statearr_32318_32405[(2)] = inst_32189);

(statearr_32318_32405[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (42))){
var inst_32207 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32319_32406 = state_32216__$1;
(statearr_32319_32406[(2)] = inst_32207);

(statearr_32319_32406[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (37))){
var inst_32101 = cljs.core.second(clause);
var inst_32102 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32101,"rdf:type");
var state_32216__$1 = state_32216;
var statearr_32320_32407 = state_32216__$1;
(statearr_32320_32407[(2)] = inst_32102);

(statearr_32320_32407[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (63))){
var inst_32196 = (state_32216[(2)]);
var state_32216__$1 = state_32216;
var statearr_32321_32408 = state_32216__$1;
(statearr_32321_32408[(2)] = inst_32196);

(statearr_32321_32408[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (8))){
var inst_32211 = (state_32216[(2)]);
var _ = (function (){var statearr_32322 = state_32216;
(statearr_32322[(4)] = cljs.core.rest((state_32216[(4)])));

return statearr_32322;
})();
var state_32216__$1 = state_32216;
var statearr_32323_32409 = state_32216__$1;
(statearr_32323_32409[(2)] = inst_32211);

(statearr_32323_32409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32217 === (49))){
var inst_32135 = cljs.core.count(clause);
var inst_32136 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_32135);
var state_32216__$1 = state_32216;
if(inst_32136){
var statearr_32324_32410 = state_32216__$1;
(statearr_32324_32410[(1)] = (51));

} else {
var statearr_32325_32411 = state_32216__$1;
(statearr_32325_32411[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____0 = (function (){
var statearr_32326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32326[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__);

(statearr_32326[(1)] = (1));

return statearr_32326;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____1 = (function (state_32216){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_32216);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e32327){var ex__11413__auto__ = e32327;
var statearr_32328_32412 = state_32216;
(statearr_32328_32412[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_32216[(4)]))){
var statearr_32329_32413 = state_32216;
(statearr_32329_32413[(1)] = cljs.core.first((state_32216[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32414 = state_32216;
state_32216 = G__32414;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__ = function(state_32216){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____1.call(this,state_32216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_32330 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_32330[(6)] = c__11484__auto__);

return statearr_32330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__32416 = arguments.length;
switch (G__32416) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_32496){
var state_val_32497 = (state_32496[(1)]);
if((state_val_32497 === (7))){
var inst_32491 = (state_32496[(2)]);
var _ = (function (){var statearr_32498 = state_32496;
(statearr_32498[(4)] = cljs.core.rest((state_32496[(4)])));

return statearr_32498;
})();
var state_32496__$1 = state_32496;
var statearr_32499_32547 = state_32496__$1;
(statearr_32499_32547[(2)] = inst_32491);

(statearr_32499_32547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (20))){
var inst_32456 = (state_32496[(7)]);
var inst_32468 = (state_32496[(2)]);
var inst_32438 = inst_32456;
var inst_32439 = inst_32468;
var state_32496__$1 = (function (){var statearr_32500 = state_32496;
(statearr_32500[(8)] = inst_32439);

(statearr_32500[(9)] = inst_32438);

return statearr_32500;
})();
var statearr_32501_32548 = state_32496__$1;
(statearr_32501_32548[(2)] = null);

(statearr_32501_32548[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (1))){
var state_32496__$1 = state_32496;
var statearr_32502_32549 = state_32496__$1;
(statearr_32502_32549[(2)] = null);

(statearr_32502_32549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (24))){
var inst_32439 = (state_32496[(8)]);
var inst_32455 = (state_32496[(10)]);
var inst_32456 = (state_32496[(7)]);
var inst_32476 = fluree.db.query.analytical.inner_join(inst_32439,inst_32455);
var inst_32438 = inst_32456;
var inst_32439__$1 = inst_32476;
var state_32496__$1 = (function (){var statearr_32503 = state_32496;
(statearr_32503[(8)] = inst_32439__$1);

(statearr_32503[(9)] = inst_32438);

return statearr_32503;
})();
var statearr_32504_32550 = state_32496__$1;
(statearr_32504_32550[(2)] = null);

(statearr_32504_32550[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (4))){
var inst_32417 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32506_32551 = state_32496__$1;
(statearr_32506_32551[(2)] = inst_32417);

(statearr_32506_32551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (15))){
var inst_32455 = (state_32496[(10)]);
var state_32496__$1 = state_32496;
if(cljs.core.truth_(inst_32455)){
var statearr_32507_32552 = state_32496__$1;
(statearr_32507_32552[(1)] = (18));

} else {
var statearr_32508_32553 = state_32496__$1;
(statearr_32508_32553[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (21))){
var inst_32439 = (state_32496[(8)]);
var inst_32456 = (state_32496[(7)]);
var tmp32505 = inst_32439;
var inst_32438 = inst_32456;
var inst_32439__$1 = tmp32505;
var state_32496__$1 = (function (){var statearr_32509 = state_32496;
(statearr_32509[(8)] = inst_32439__$1);

(statearr_32509[(9)] = inst_32438);

return statearr_32509;
})();
var statearr_32510_32554 = state_32496__$1;
(statearr_32510_32554[(2)] = null);

(statearr_32510_32554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (13))){
var inst_32439 = (state_32496[(8)]);
var inst_32462 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_32439,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_32463 = cljs.core.empty_QMARK_(inst_32462);
var state_32496__$1 = state_32496;
if(inst_32463){
var statearr_32511_32555 = state_32496__$1;
(statearr_32511_32555[(1)] = (15));

} else {
var statearr_32512_32556 = state_32496__$1;
(statearr_32512_32556[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (22))){
var state_32496__$1 = state_32496;
var statearr_32513_32557 = state_32496__$1;
(statearr_32513_32557[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (6))){
var inst_32445 = (state_32496[(11)]);
var inst_32438 = (state_32496[(9)]);
var inst_32444 = cljs.core.seq(inst_32438);
var inst_32445__$1 = cljs.core.first(inst_32444);
var inst_32446 = cljs.core.next(inst_32444);
var state_32496__$1 = (function (){var statearr_32515 = state_32496;
(statearr_32515[(12)] = inst_32446);

(statearr_32515[(11)] = inst_32445__$1);

return statearr_32515;
})();
if(cljs.core.truth_(inst_32445__$1)){
var statearr_32516_32558 = state_32496__$1;
(statearr_32516_32558[(1)] = (8));

} else {
var statearr_32517_32559 = state_32496__$1;
(statearr_32517_32559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (25))){
var state_32496__$1 = state_32496;
var statearr_32518_32560 = state_32496__$1;
(statearr_32518_32560[(2)] = null);

(statearr_32518_32560[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (17))){
var inst_32484 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32519_32561 = state_32496__$1;
(statearr_32519_32561[(2)] = inst_32484);

(statearr_32519_32561[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (3))){
var inst_32494 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32496__$1,inst_32494);
} else {
if((state_val_32497 === (12))){
var inst_32455 = (state_32496[(10)]);
var inst_32456 = (state_32496[(7)]);
var inst_32438 = inst_32456;
var inst_32439 = inst_32455;
var state_32496__$1 = (function (){var statearr_32520 = state_32496;
(statearr_32520[(8)] = inst_32439);

(statearr_32520[(9)] = inst_32438);

return statearr_32520;
})();
var statearr_32521_32562 = state_32496__$1;
(statearr_32521_32562[(2)] = null);

(statearr_32521_32562[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (2))){
var _ = (function (){var statearr_32522 = state_32496;
(statearr_32522[(4)] = cljs.core.cons((5),(state_32496[(4)])));

return statearr_32522;
})();
var inst_32430 = where;
var inst_32431 = cljs.core.seq(inst_32430);
var inst_32432 = cljs.core.first(inst_32431);
var inst_32433 = cljs.core.next(inst_32431);
var inst_32434 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_32435 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_32436 = [inst_32435];
var inst_32437 = cljs.core.PersistentHashMap.fromArrays(inst_32434,inst_32436);
var inst_32438 = inst_32430;
var inst_32439 = inst_32437;
var state_32496__$1 = (function (){var statearr_32523 = state_32496;
(statearr_32523[(13)] = inst_32433);

(statearr_32523[(14)] = inst_32432);

(statearr_32523[(8)] = inst_32439);

(statearr_32523[(9)] = inst_32438);

return statearr_32523;
})();
var statearr_32524_32563 = state_32496__$1;
(statearr_32524_32563[(2)] = null);

(statearr_32524_32563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (23))){
var inst_32482 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32525_32564 = state_32496__$1;
(statearr_32525_32564[(2)] = inst_32482);

(statearr_32525_32564[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (19))){
var inst_32439 = (state_32496[(8)]);
var state_32496__$1 = state_32496;
var statearr_32526_32565 = state_32496__$1;
(statearr_32526_32565[(2)] = inst_32439);

(statearr_32526_32565[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (11))){
var inst_32445 = (state_32496[(11)]);
var inst_32453 = (state_32496[(2)]);
var inst_32454 = fluree.db.util.async.throw_err(inst_32453);
var inst_32455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32454,(0),null);
var inst_32456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32454,(1),null);
var inst_32457 = cljs.core.count(inst_32445);
var inst_32458 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_32457);
var state_32496__$1 = (function (){var statearr_32528 = state_32496;
(statearr_32528[(10)] = inst_32455);

(statearr_32528[(7)] = inst_32456);

return statearr_32528;
})();
if(inst_32458){
var statearr_32529_32566 = state_32496__$1;
(statearr_32529_32566[(1)] = (12));

} else {
var statearr_32530_32567 = state_32496__$1;
(statearr_32530_32567[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (9))){
var inst_32439 = (state_32496[(8)]);
var state_32496__$1 = state_32496;
var statearr_32531_32568 = state_32496__$1;
(statearr_32531_32568[(2)] = inst_32439);

(statearr_32531_32568[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (5))){
var _ = (function (){var statearr_32532 = state_32496;
(statearr_32532[(4)] = cljs.core.rest((state_32496[(4)])));

return statearr_32532;
})();
var state_32496__$1 = state_32496;
var ex32527 = (state_32496__$1[(2)]);
var statearr_32533_32569 = state_32496__$1;
(statearr_32533_32569[(5)] = ex32527);


if((ex32527 instanceof Error)){
var statearr_32534_32570 = state_32496__$1;
(statearr_32534_32570[(1)] = (4));

(statearr_32534_32570[(5)] = null);

} else {
throw ex32527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (14))){
var inst_32486 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32535_32571 = state_32496__$1;
(statearr_32535_32571[(2)] = inst_32486);

(statearr_32535_32571[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (26))){
var inst_32480 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32536_32572 = state_32496__$1;
(statearr_32536_32572[(2)] = inst_32480);

(statearr_32536_32572[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (16))){
var inst_32455 = (state_32496[(10)]);
var inst_32471 = (inst_32455 == null);
var state_32496__$1 = state_32496;
if(cljs.core.truth_(inst_32471)){
var statearr_32537_32573 = state_32496__$1;
(statearr_32537_32573[(1)] = (21));

} else {
var statearr_32538_32574 = state_32496__$1;
(statearr_32538_32574[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (10))){
var inst_32489 = (state_32496[(2)]);
var state_32496__$1 = state_32496;
var statearr_32539_32575 = state_32496__$1;
(statearr_32539_32575[(2)] = inst_32489);

(statearr_32539_32575[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (18))){
var inst_32455 = (state_32496[(10)]);
var state_32496__$1 = state_32496;
var statearr_32540_32576 = state_32496__$1;
(statearr_32540_32576[(2)] = inst_32455);

(statearr_32540_32576[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32497 === (8))){
var inst_32446 = (state_32496[(12)]);
var inst_32439 = (state_32496[(8)]);
var inst_32445 = (state_32496[(11)]);
var inst_32451 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_32439,inst_32445,inst_32446,false,fuel,max_fuel,opts);
var state_32496__$1 = state_32496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32496__$1,(11),inst_32451);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__11410__auto__ = null;
var fluree$db$query$analytical$state_machine__11410__auto____0 = (function (){
var statearr_32541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32541[(0)] = fluree$db$query$analytical$state_machine__11410__auto__);

(statearr_32541[(1)] = (1));

return statearr_32541;
});
var fluree$db$query$analytical$state_machine__11410__auto____1 = (function (state_32496){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_32496);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e32542){var ex__11413__auto__ = e32542;
var statearr_32543_32577 = state_32496;
(statearr_32543_32577[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_32496[(4)]))){
var statearr_32544_32578 = state_32496;
(statearr_32544_32578[(1)] = cljs.core.first((state_32496[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32579 = state_32496;
state_32496 = G__32579;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__11410__auto__ = function(state_32496){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__11410__auto____1.call(this,state_32496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__11410__auto____0;
fluree$db$query$analytical$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__11410__auto____1;
return fluree$db$query$analytical$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_32545 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_32545[(6)] = c__11484__auto__);

return statearr_32545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_32614){
var state_val_32615 = (state_32614[(1)]);
if((state_val_32615 === (7))){
var inst_32596 = (state_32614[(7)]);
var inst_32591 = (state_32614[(8)]);
var inst_32598 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_32591,inst_32596,fuel,max_fuel,opts);
var state_32614__$1 = state_32614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32614__$1,(10),inst_32598);
} else {
if((state_val_32615 === (1))){
var state_32614__$1 = state_32614;
var statearr_32616_32641 = state_32614__$1;
(statearr_32616_32641[(2)] = null);

(statearr_32616_32641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (4))){
var inst_32580 = (state_32614[(2)]);
var state_32614__$1 = state_32614;
var statearr_32617_32642 = state_32614__$1;
(statearr_32617_32642[(2)] = inst_32580);

(statearr_32617_32642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (13))){
var inst_32609 = (state_32614[(2)]);
var _ = (function (){var statearr_32618 = state_32614;
(statearr_32618[(4)] = cljs.core.rest((state_32614[(4)])));

return statearr_32618;
})();
var state_32614__$1 = state_32614;
var statearr_32619_32643 = state_32614__$1;
(statearr_32619_32643[(2)] = inst_32609);

(statearr_32619_32643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (6))){
var inst_32591 = (state_32614[(8)]);
var inst_32595 = (state_32614[(2)]);
var inst_32596 = fluree.db.util.async.throw_err(inst_32595);
var state_32614__$1 = (function (){var statearr_32620 = state_32614;
(statearr_32620[(7)] = inst_32596);

return statearr_32620;
})();
if(cljs.core.truth_(inst_32591)){
var statearr_32621_32644 = state_32614__$1;
(statearr_32621_32644[(1)] = (7));

} else {
var statearr_32622_32645 = state_32614__$1;
(statearr_32622_32645[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (3))){
var inst_32612 = (state_32614[(2)]);
var state_32614__$1 = state_32614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32614__$1,inst_32612);
} else {
if((state_val_32615 === (12))){
var inst_32604 = (state_32614[(9)]);
var state_32614__$1 = state_32614;
var statearr_32623_32646 = state_32614__$1;
(statearr_32623_32646[(2)] = inst_32604);

(statearr_32623_32646[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (2))){
var _ = (function (){var statearr_32624 = state_32614;
(statearr_32624[(4)] = cljs.core.cons((5),(state_32614[(4)])));

return statearr_32624;
})();
var inst_32587 = q_map;
var inst_32588 = cljs.core.__destructure_map(inst_32587);
var inst_32589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32588,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_32590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32588,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_32591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32588,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_32592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32588,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_32593 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_32590,q_map,inst_32589,fuel,max_fuel,opts);
var state_32614__$1 = (function (){var statearr_32625 = state_32614;
(statearr_32625[(10)] = inst_32592);

(statearr_32625[(8)] = inst_32591);

return statearr_32625;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32614__$1,(6),inst_32593);
} else {
if((state_val_32615 === (11))){
var inst_32604 = (state_32614[(9)]);
var inst_32592 = (state_32614[(10)]);
var inst_32606 = fluree.db.query.analytical.tuples__GT_filtered(inst_32604,inst_32592,null);
var state_32614__$1 = state_32614;
var statearr_32627_32647 = state_32614__$1;
(statearr_32627_32647[(2)] = inst_32606);

(statearr_32627_32647[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (9))){
var inst_32592 = (state_32614[(10)]);
var inst_32604 = (state_32614[(2)]);
var state_32614__$1 = (function (){var statearr_32628 = state_32614;
(statearr_32628[(9)] = inst_32604);

return statearr_32628;
})();
if(cljs.core.truth_(inst_32592)){
var statearr_32629_32648 = state_32614__$1;
(statearr_32629_32648[(1)] = (11));

} else {
var statearr_32630_32649 = state_32614__$1;
(statearr_32630_32649[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (5))){
var _ = (function (){var statearr_32631 = state_32614;
(statearr_32631[(4)] = cljs.core.rest((state_32614[(4)])));

return statearr_32631;
})();
var state_32614__$1 = state_32614;
var ex32626 = (state_32614__$1[(2)]);
var statearr_32632_32650 = state_32614__$1;
(statearr_32632_32650[(5)] = ex32626);


if((ex32626 instanceof Error)){
var statearr_32633_32651 = state_32614__$1;
(statearr_32633_32651[(1)] = (4));

(statearr_32633_32651[(5)] = null);

} else {
throw ex32626;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (10))){
var inst_32600 = (state_32614[(2)]);
var inst_32601 = fluree.db.util.async.throw_err(inst_32600);
var state_32614__$1 = state_32614;
var statearr_32634_32652 = state_32614__$1;
(statearr_32634_32652[(2)] = inst_32601);

(statearr_32634_32652[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32615 === (8))){
var inst_32596 = (state_32614[(7)]);
var state_32614__$1 = state_32614;
var statearr_32635_32653 = state_32614__$1;
(statearr_32635_32653[(2)] = inst_32596);

(statearr_32635_32653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__11410__auto____0 = (function (){
var statearr_32636 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32636[(0)] = fluree$db$query$analytical$q_$_state_machine__11410__auto__);

(statearr_32636[(1)] = (1));

return statearr_32636;
});
var fluree$db$query$analytical$q_$_state_machine__11410__auto____1 = (function (state_32614){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_32614);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e32637){var ex__11413__auto__ = e32637;
var statearr_32638_32654 = state_32614;
(statearr_32638_32654[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_32614[(4)]))){
var statearr_32639_32655 = state_32614;
(statearr_32639_32655[(1)] = cljs.core.first((state_32614[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32656 = state_32614;
state_32614 = G__32656;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__11410__auto__ = function(state_32614){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__11410__auto____1.call(this,state_32614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__11410__auto____0;
fluree$db$query$analytical$q_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__11410__auto____1;
return fluree$db$query$analytical$q_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_32640 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_32640[(6)] = c__11484__auto__);

return statearr_32640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
