// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__24442 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24442,(5),null);
var G__24445 = idx;
var G__24445__$1 = (((G__24445 instanceof cljs.core.Keyword))?G__24445.fqn:null);
switch (G__24445__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24445__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__24447 = idx;
var G__24447__$1 = (((G__24447 instanceof cljs.core.Keyword))?G__24447.fqn:null);
switch (G__24447__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24447__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__24449 = idx;
var G__24449__$1 = (((G__24449 instanceof cljs.core.Keyword))?G__24449.fqn:null);
switch (G__24449__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24449__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__24452 = arguments.length;
switch (G__24452) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__24453 = (function (){var pred__24456 = cljs.core.identical_QMARK_;
var expr__24457 = test;
if(cljs.core.truth_((pred__24456.cljs$core$IFn$_invoke$arity$2 ? pred__24456.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__24457) : pred__24456.call(null,cljs.core._EQ_,expr__24457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__24456.cljs$core$IFn$_invoke$arity$2 ? pred__24456.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__24457) : pred__24456.call(null,cljs.core._LT_,expr__24457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__24456.cljs$core$IFn$_invoke$arity$2 ? pred__24456.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__24457) : pred__24456.call(null,cljs.core._LT__EQ_,expr__24457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__24456.cljs$core$IFn$_invoke$arity$2 ? pred__24456.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__24457) : pred__24456.call(null,cljs.core._GT_,expr__24457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__24456.cljs$core$IFn$_invoke$arity$2 ? pred__24456.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__24457) : pred__24456.call(null,cljs.core._GT__EQ_,expr__24457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__24457)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24453,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24453,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24453,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24453,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_24696){
var state_val_24697 = (state_24696[(1)]);
if((state_val_24697 === (65))){
var inst_24611 = (state_24696[(7)]);
var inst_24667 = (state_24696[(8)]);
var inst_24667__$1 = (state_24696[(2)]);
var inst_24668 = cljs.core.count(inst_24667__$1);
var state_24696__$1 = (function (){var statearr_24698 = state_24696;
(statearr_24698[(8)] = inst_24667__$1);

(statearr_24698[(9)] = inst_24668);

return statearr_24698;
})();
if(cljs.core.truth_(inst_24611)){
var statearr_24699_24836 = state_24696__$1;
(statearr_24699_24836[(1)] = (81));

} else {
var statearr_24700_24837 = state_24696__$1;
(statearr_24700_24837[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (70))){
var inst_24642 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24642)){
var statearr_24701_24838 = state_24696__$1;
(statearr_24701_24838[(1)] = (71));

} else {
var statearr_24702_24839 = state_24696__$1;
(statearr_24702_24839[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (62))){
var inst_24581 = (state_24696[(10)]);
var inst_24595 = (state_24696[(11)]);
var inst_24610 = (state_24696[(2)]);
var inst_24611 = fluree.db.dbproto._rhs(inst_24595);
var state_24696__$1 = (function (){var statearr_24703 = state_24696;
(statearr_24703[(7)] = inst_24611);

(statearr_24703[(12)] = inst_24610);

return statearr_24703;
})();
if(cljs.core.truth_(inst_24581)){
var statearr_24704_24840 = state_24696__$1;
(statearr_24704_24840[(1)] = (63));

} else {
var statearr_24705_24841 = state_24696__$1;
(statearr_24705_24841[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (74))){
var inst_24635 = (state_24696[(13)]);
var inst_24649 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_24635);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(77),inst_24649);
} else {
if((state_val_24697 === (7))){
var inst_24472 = (state_24696[(14)]);
var state_24696__$1 = state_24696;
var statearr_24706_24842 = state_24696__$1;
(statearr_24706_24842[(2)] = inst_24472);

(statearr_24706_24842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (59))){
var inst_24558 = (state_24696[(15)]);
var inst_24557 = (state_24696[(16)]);
var inst_24602 = (state_24696[(17)]);
var inst_24601 = (state_24696[(2)]);
var inst_24602__$1 = fluree.db.util.async.throw_err(inst_24601);
var inst_24603 = fluree.db.flake.subrange(inst_24602__$1,start_test,inst_24557,end_test,inst_24558);
var inst_24604 = fluree.db.query.range.value_with_nil_pred(idx,inst_24557,inst_24558);
var state_24696__$1 = (function (){var statearr_24707 = state_24696;
(statearr_24707[(17)] = inst_24602__$1);

(statearr_24707[(18)] = inst_24603);

return statearr_24707;
})();
if(inst_24604){
var statearr_24708_24843 = state_24696__$1;
(statearr_24708_24843[(1)] = (60));

} else {
var statearr_24709_24844 = state_24696__$1;
(statearr_24709_24844[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (86))){
var inst_24676 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24710_24845 = state_24696__$1;
(statearr_24710_24845[(2)] = inst_24676);

(statearr_24710_24845[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (20))){
var inst_24521 = (state_24696[(19)]);
var inst_24473 = (state_24696[(20)]);
var inst_24520 = (state_24696[(2)]);
var inst_24521__$1 = (inst_24473 == null);
var state_24696__$1 = (function (){var statearr_24711 = state_24696;
(statearr_24711[(21)] = inst_24520);

(statearr_24711[(19)] = inst_24521__$1);

return statearr_24711;
})();
if(cljs.core.truth_(inst_24521__$1)){
var statearr_24712_24846 = state_24696__$1;
(statearr_24712_24846[(1)] = (22));

} else {
var statearr_24713_24847 = state_24696__$1;
(statearr_24713_24847[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (72))){
var inst_24628 = (state_24696[(22)]);
var inst_24646 = (inst_24628 + (1));
var inst_24647 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24696__$1 = (function (){var statearr_24714 = state_24696;
(statearr_24714[(23)] = inst_24646);

return statearr_24714;
})();
if(cljs.core.truth_(inst_24647)){
var statearr_24715_24848 = state_24696__$1;
(statearr_24715_24848[(1)] = (74));

} else {
var statearr_24716_24849 = state_24696__$1;
(statearr_24716_24849[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (58))){
var inst_24691 = (state_24696[(2)]);
var _ = (function (){var statearr_24717 = state_24696;
(statearr_24717[(4)] = cljs.core.rest((state_24696[(4)])));

return statearr_24717;
})();
var state_24696__$1 = state_24696;
var statearr_24718_24850 = state_24696__$1;
(statearr_24718_24850[(2)] = inst_24691);

(statearr_24718_24850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (60))){
var inst_24581 = (state_24696[(10)]);
var inst_24564 = (state_24696[(24)]);
var inst_24590 = (state_24696[(25)]);
var inst_24558 = (state_24696[(15)]);
var inst_24520 = (state_24696[(21)]);
var inst_24511 = (state_24696[(26)]);
var inst_24483 = (state_24696[(27)]);
var inst_24538 = (state_24696[(28)]);
var inst_24557 = (state_24696[(16)]);
var inst_24475 = (state_24696[(29)]);
var inst_24575 = (state_24696[(30)]);
var inst_24596 = (state_24696[(31)]);
var inst_24482 = (state_24696[(32)]);
var inst_24568 = (state_24696[(33)]);
var inst_24547 = (state_24696[(34)]);
var inst_24471 = (state_24696[(35)]);
var inst_24602 = (state_24696[(17)]);
var inst_24585 = (state_24696[(36)]);
var inst_24556 = (state_24696[(37)]);
var inst_24476 = (state_24696[(38)]);
var inst_24478 = (state_24696[(39)]);
var inst_24597 = (state_24696[(40)]);
var inst_24563 = (state_24696[(41)]);
var inst_24603 = (state_24696[(18)]);
var inst_24529 = (state_24696[(42)]);
var inst_24574 = (state_24696[(43)]);
var inst_24502 = (state_24696[(44)]);
var inst_24493 = (state_24696[(45)]);
var inst_24595 = (state_24696[(11)]);
var inst_24606 = (function (){var no_filter_QMARK_ = inst_24581;
var vec__24468 = inst_24478;
var next_node = inst_24595;
var flakes = inst_24602;
var s1 = inst_24493;
var o2 = inst_24520;
var t1 = inst_24475;
var vec__24465 = inst_24471;
var i = inst_24596;
var m1 = inst_24547;
var root_node = inst_24590;
var to_t = inst_24575;
var s2 = inst_24502;
var p2 = inst_24538;
var permissions = inst_24564;
var limit = inst_24563;
var start_flake = inst_24557;
var acc = inst_24597;
var t2 = inst_24482;
var op1 = inst_24476;
var o1 = inst_24511;
var end_flake = inst_24558;
var base_result = inst_24603;
var p1 = inst_24529;
var idx_compare = inst_24568;
var op2 = inst_24483;
var from_t = inst_24574;
var m2 = inst_24556;
var novelty = inst_24585;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_24607 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24606,inst_24603,inst_24603);
var state_24696__$1 = state_24696;
var statearr_24719_24851 = state_24696__$1;
(statearr_24719_24851[(2)] = inst_24607);

(statearr_24719_24851[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (27))){
var inst_24480 = (state_24696[(46)]);
var inst_24530 = (state_24696[(47)]);
var inst_24529 = (state_24696[(2)]);
var inst_24530__$1 = (inst_24480 == null);
var state_24696__$1 = (function (){var statearr_24720 = state_24696;
(statearr_24720[(47)] = inst_24530__$1);

(statearr_24720[(42)] = inst_24529);

return statearr_24720;
})();
if(cljs.core.truth_(inst_24530__$1)){
var statearr_24721_24852 = state_24696__$1;
(statearr_24721_24852[(1)] = (28));

} else {
var statearr_24722_24853 = state_24696__$1;
(statearr_24722_24853[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (1))){
var state_24696__$1 = state_24696;
var statearr_24723_24854 = state_24696__$1;
(statearr_24723_24854[(2)] = null);

(statearr_24723_24854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (69))){
var inst_24628 = (state_24696[(22)]);
var inst_24563 = (state_24696[(41)]);
var inst_24640 = (inst_24628 > inst_24563);
var state_24696__$1 = state_24696;
var statearr_24724_24855 = state_24696__$1;
(statearr_24724_24855[(2)] = inst_24640);

(statearr_24724_24855[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (24))){
var inst_24525 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24525)){
var statearr_24725_24856 = state_24696__$1;
(statearr_24725_24856[(1)] = (25));

} else {
var statearr_24726_24857 = state_24696__$1;
(statearr_24726_24857[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (55))){
var inst_24590 = (state_24696[(25)]);
var inst_24557 = (state_24696[(16)]);
var inst_24589 = (state_24696[(2)]);
var inst_24590__$1 = fluree.db.util.async.throw_err(inst_24589);
var inst_24591 = fluree.db.dbproto._lookup_leaf(inst_24590__$1,inst_24557);
var state_24696__$1 = (function (){var statearr_24727 = state_24696;
(statearr_24727[(25)] = inst_24590__$1);

return statearr_24727;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(56),inst_24591);
} else {
if((state_val_24697 === (85))){
var inst_24671 = (state_24696[(48)]);
var state_24696__$1 = state_24696;
var statearr_24728_24858 = state_24696__$1;
(statearr_24728_24858[(2)] = inst_24671);

(statearr_24728_24858[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (39))){
var inst_24545 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24729_24859 = state_24696__$1;
(statearr_24729_24859[(2)] = inst_24545);

(statearr_24729_24859[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (88))){
var inst_24590 = (state_24696[(25)]);
var inst_24611 = (state_24696[(7)]);
var inst_24683 = fluree.db.dbproto._lookup_leaf(inst_24590,inst_24611);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(90),inst_24683);
} else {
if((state_val_24697 === (46))){
var inst_24559 = (state_24696[(49)]);
var state_24696__$1 = state_24696;
var statearr_24730_24860 = state_24696__$1;
(statearr_24730_24860[(2)] = inst_24559);

(statearr_24730_24860[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (4))){
var inst_24459 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24731_24861 = state_24696__$1;
(statearr_24731_24861[(2)] = inst_24459);

(statearr_24731_24861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (77))){
var inst_24651 = (state_24696[(2)]);
var inst_24652 = fluree.db.util.async.throw_err(inst_24651);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24652)){
var statearr_24732_24862 = state_24696__$1;
(statearr_24732_24862[(1)] = (78));

} else {
var statearr_24733_24863 = state_24696__$1;
(statearr_24733_24863[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (54))){
var inst_24581 = (state_24696[(2)]);
var inst_24582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24583 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_24584 = (new cljs.core.PersistentVector(null,2,(5),inst_24582,inst_24583,null));
var inst_24585 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_24584);
var inst_24586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_24587 = fluree.db.dbproto._resolve(inst_24586);
var state_24696__$1 = (function (){var statearr_24734 = state_24696;
(statearr_24734[(10)] = inst_24581);

(statearr_24734[(36)] = inst_24585);

return statearr_24734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(55),inst_24587);
} else {
if((state_val_24697 === (15))){
var inst_24474 = (state_24696[(50)]);
var state_24696__$1 = state_24696;
var statearr_24735_24864 = state_24696__$1;
(statearr_24735_24864[(2)] = inst_24474);

(statearr_24735_24864[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (48))){
var inst_24569 = (state_24696[(51)]);
var inst_24563 = (state_24696[(2)]);
var inst_24564 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_24565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24566 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_24567 = (new cljs.core.PersistentVector(null,3,(5),inst_24565,inst_24566,null));
var inst_24568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_24567);
var inst_24569__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_24696__$1 = (function (){var statearr_24736 = state_24696;
(statearr_24736[(24)] = inst_24564);

(statearr_24736[(33)] = inst_24568);

(statearr_24736[(51)] = inst_24569__$1);

(statearr_24736[(41)] = inst_24563);

return statearr_24736;
})();
if(cljs.core.truth_(inst_24569__$1)){
var statearr_24737_24865 = state_24696__$1;
(statearr_24737_24865[(1)] = (49));

} else {
var statearr_24738_24866 = state_24696__$1;
(statearr_24738_24866[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (50))){
var inst_24572 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_24696__$1 = state_24696;
var statearr_24739_24867 = state_24696__$1;
(statearr_24739_24867[(2)] = inst_24572);

(statearr_24739_24867[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (75))){
var inst_24629 = (state_24696[(52)]);
var state_24696__$1 = state_24696;
var statearr_24740_24868 = state_24696__$1;
(statearr_24740_24868[(2)] = inst_24629);

(statearr_24740_24868[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (21))){
var inst_24516 = (state_24696[(2)]);
var inst_24517 = fluree.db.util.async.throw_err(inst_24516);
var state_24696__$1 = state_24696;
var statearr_24741_24869 = state_24696__$1;
(statearr_24741_24869[(2)] = inst_24517);

(statearr_24741_24869[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (31))){
var state_24696__$1 = state_24696;
var statearr_24742_24870 = state_24696__$1;
(statearr_24742_24870[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_24742_24870[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (32))){
var inst_24480 = (state_24696[(46)]);
var state_24696__$1 = state_24696;
var statearr_24743_24871 = state_24696__$1;
(statearr_24743_24871[(2)] = inst_24480);

(statearr_24743_24871[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (40))){
var inst_24484 = (state_24696[(53)]);
var state_24696__$1 = state_24696;
var statearr_24744_24872 = state_24696__$1;
(statearr_24744_24872[(2)] = inst_24484);

(statearr_24744_24872[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (56))){
var inst_24593 = (state_24696[(2)]);
var inst_24594 = fluree.db.util.async.throw_err(inst_24593);
var inst_24595 = inst_24594;
var inst_24596 = (0);
var inst_24597 = null;
var state_24696__$1 = (function (){var statearr_24745 = state_24696;
(statearr_24745[(31)] = inst_24596);

(statearr_24745[(40)] = inst_24597);

(statearr_24745[(11)] = inst_24595);

return statearr_24745;
})();
var statearr_24746_24873 = state_24696__$1;
(statearr_24746_24873[(2)] = null);

(statearr_24746_24873[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (33))){
var inst_24477 = (state_24696[(54)]);
var inst_24538 = (state_24696[(2)]);
var state_24696__$1 = (function (){var statearr_24747 = state_24696;
(statearr_24747[(28)] = inst_24538);

return statearr_24747;
})();
if(cljs.core.truth_(inst_24477)){
var statearr_24748_24874 = state_24696__$1;
(statearr_24748_24874[(1)] = (34));

} else {
var statearr_24749_24875 = state_24696__$1;
(statearr_24749_24875[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (13))){
var inst_24498 = (state_24696[(2)]);
var inst_24499 = fluree.db.util.async.throw_err(inst_24498);
var state_24696__$1 = state_24696;
var statearr_24750_24876 = state_24696__$1;
(statearr_24750_24876[(2)] = inst_24499);

(statearr_24750_24876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (22))){
var inst_24511 = (state_24696[(26)]);
var state_24696__$1 = state_24696;
var statearr_24751_24877 = state_24696__$1;
(statearr_24751_24877[(2)] = inst_24511);

(statearr_24751_24877[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (90))){
var inst_24667 = (state_24696[(8)]);
var inst_24668 = (state_24696[(9)]);
var inst_24685 = (state_24696[(2)]);
var inst_24686 = fluree.db.util.async.throw_err(inst_24685);
var inst_24595 = inst_24686;
var inst_24596 = inst_24668;
var inst_24597 = inst_24667;
var state_24696__$1 = (function (){var statearr_24752 = state_24696;
(statearr_24752[(31)] = inst_24596);

(statearr_24752[(40)] = inst_24597);

(statearr_24752[(11)] = inst_24595);

return statearr_24752;
})();
var statearr_24753_24878 = state_24696__$1;
(statearr_24753_24878[(2)] = null);

(statearr_24753_24878[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (36))){
var inst_24484 = (state_24696[(53)]);
var inst_24547 = (state_24696[(2)]);
var state_24696__$1 = (function (){var statearr_24754 = state_24696;
(statearr_24754[(34)] = inst_24547);

return statearr_24754;
})();
if(cljs.core.truth_(inst_24484)){
var statearr_24755_24879 = state_24696__$1;
(statearr_24755_24879[(1)] = (40));

} else {
var statearr_24756_24880 = state_24696__$1;
(statearr_24756_24880[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (41))){
var inst_24550 = (cljs.core._LT__EQ_ === end_test);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24550)){
var statearr_24757_24881 = state_24696__$1;
(statearr_24757_24881[(1)] = (43));

} else {
var statearr_24758_24882 = state_24696__$1;
(statearr_24758_24882[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (89))){
var inst_24689 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24759_24883 = state_24696__$1;
(statearr_24759_24883[(2)] = inst_24689);

(statearr_24759_24883[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (43))){
var state_24696__$1 = state_24696;
var statearr_24760_24884 = state_24696__$1;
(statearr_24760_24884[(2)] = (2147483647));

(statearr_24760_24884[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (61))){
var inst_24603 = (state_24696[(18)]);
var state_24696__$1 = state_24696;
var statearr_24761_24885 = state_24696__$1;
(statearr_24761_24885[(2)] = inst_24603);

(statearr_24761_24885[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (29))){
var inst_24530 = (state_24696[(47)]);
var state_24696__$1 = state_24696;
var statearr_24762_24886 = state_24696__$1;
(statearr_24762_24886[(2)] = inst_24530);

(statearr_24762_24886[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (44))){
var state_24696__$1 = state_24696;
var statearr_24763_24887 = state_24696__$1;
(statearr_24763_24887[(2)] = fluree.db.util.core.min_integer);

(statearr_24763_24887[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (6))){
var inst_24472 = (state_24696[(14)]);
var inst_24487 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_24472);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(9),inst_24487);
} else {
if((state_val_24697 === (28))){
var inst_24520 = (state_24696[(21)]);
var state_24696__$1 = state_24696;
var statearr_24764_24888 = state_24696__$1;
(statearr_24764_24888[(2)] = inst_24520);

(statearr_24764_24888[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (64))){
var inst_24596 = (state_24696[(31)]);
var inst_24610 = (state_24696[(12)]);
var inst_24624 = cljs.core.seq(inst_24610);
var inst_24625 = cljs.core.first(inst_24624);
var inst_24626 = cljs.core.next(inst_24624);
var inst_24627 = inst_24610;
var inst_24628 = inst_24596;
var inst_24629 = inst_24610;
var state_24696__$1 = (function (){var statearr_24765 = state_24696;
(statearr_24765[(22)] = inst_24628);

(statearr_24765[(55)] = inst_24627);

(statearr_24765[(56)] = inst_24626);

(statearr_24765[(52)] = inst_24629);

(statearr_24765[(57)] = inst_24625);

return statearr_24765;
})();
var statearr_24766_24889 = state_24696__$1;
(statearr_24766_24889[(2)] = null);

(statearr_24766_24889[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (51))){
var inst_24574 = (state_24696[(2)]);
var inst_24575 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_24576 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24696__$1 = (function (){var statearr_24767 = state_24696;
(statearr_24767[(30)] = inst_24575);

(statearr_24767[(43)] = inst_24574);

return statearr_24767;
})();
if(cljs.core.truth_(inst_24576)){
var statearr_24768_24890 = state_24696__$1;
(statearr_24768_24890[(1)] = (52));

} else {
var statearr_24769_24891 = state_24696__$1;
(statearr_24769_24891[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (25))){
var state_24696__$1 = state_24696;
var statearr_24770_24892 = state_24696__$1;
(statearr_24770_24892[(2)] = (-1));

(statearr_24770_24892[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (34))){
var inst_24477 = (state_24696[(54)]);
var state_24696__$1 = state_24696;
var statearr_24771_24893 = state_24696__$1;
(statearr_24771_24893[(2)] = inst_24477);

(statearr_24771_24893[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (17))){
var inst_24507 = (state_24696[(2)]);
var inst_24508 = fluree.db.util.async.throw_err(inst_24507);
var state_24696__$1 = state_24696;
var statearr_24772_24894 = state_24696__$1;
(statearr_24772_24894[(2)] = inst_24508);

(statearr_24772_24894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (3))){
var inst_24694 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24696__$1,inst_24694);
} else {
if((state_val_24697 === (12))){
var inst_24474 = (state_24696[(50)]);
var inst_24502 = (state_24696[(2)]);
var inst_24503 = fluree.db.util.core.pred_ident_QMARK_(inst_24474);
var state_24696__$1 = (function (){var statearr_24773 = state_24696;
(statearr_24773[(44)] = inst_24502);

return statearr_24773;
})();
if(inst_24503){
var statearr_24774_24895 = state_24696__$1;
(statearr_24774_24895[(1)] = (14));

} else {
var statearr_24775_24896 = state_24696__$1;
(statearr_24775_24896[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (2))){
var inst_24472 = (state_24696[(14)]);
var inst_24471 = (state_24696[(35)]);
var inst_24478 = (state_24696[(39)]);
var _ = (function (){var statearr_24776 = state_24696;
(statearr_24776[(4)] = cljs.core.cons((5),(state_24696[(4)])));

return statearr_24776;
})();
var inst_24471__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_24472__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(0),null);
var inst_24473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(1),null);
var inst_24474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(2),null);
var inst_24475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(3),null);
var inst_24476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(4),null);
var inst_24477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24471__$1,(5),null);
var inst_24478__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_24479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(0),null);
var inst_24480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(1),null);
var inst_24481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(2),null);
var inst_24482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(3),null);
var inst_24483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(4),null);
var inst_24484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24478__$1,(5),null);
var inst_24485 = fluree.db.util.core.pred_ident_QMARK_(inst_24472__$1);
var state_24696__$1 = (function (){var statearr_24777 = state_24696;
(statearr_24777[(53)] = inst_24484);

(statearr_24777[(14)] = inst_24472__$1);

(statearr_24777[(58)] = inst_24481);

(statearr_24777[(50)] = inst_24474);

(statearr_24777[(27)] = inst_24483);

(statearr_24777[(46)] = inst_24480);

(statearr_24777[(29)] = inst_24475);

(statearr_24777[(32)] = inst_24482);

(statearr_24777[(35)] = inst_24471__$1);

(statearr_24777[(54)] = inst_24477);

(statearr_24777[(38)] = inst_24476);

(statearr_24777[(39)] = inst_24478__$1);

(statearr_24777[(20)] = inst_24473);

(statearr_24777[(59)] = inst_24479);

return statearr_24777;
})();
if(inst_24485){
var statearr_24778_24897 = state_24696__$1;
(statearr_24778_24897[(1)] = (6));

} else {
var statearr_24779_24898 = state_24696__$1;
(statearr_24779_24898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (66))){
var inst_24627 = (state_24696[(55)]);
var inst_24637 = (state_24696[(60)]);
var inst_24635 = (state_24696[(13)]);
var inst_24634 = cljs.core.seq(inst_24627);
var inst_24635__$1 = cljs.core.first(inst_24634);
var inst_24636 = cljs.core.next(inst_24634);
var inst_24637__$1 = (inst_24635__$1 == null);
var state_24696__$1 = (function (){var statearr_24780 = state_24696;
(statearr_24780[(61)] = inst_24636);

(statearr_24780[(60)] = inst_24637__$1);

(statearr_24780[(13)] = inst_24635__$1);

return statearr_24780;
})();
if(cljs.core.truth_(inst_24637__$1)){
var statearr_24781_24899 = state_24696__$1;
(statearr_24781_24899[(1)] = (68));

} else {
var statearr_24782_24900 = state_24696__$1;
(statearr_24782_24900[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (23))){
var inst_24521 = (state_24696[(19)]);
var state_24696__$1 = state_24696;
var statearr_24783_24901 = state_24696__$1;
(statearr_24783_24901[(2)] = inst_24521);

(statearr_24783_24901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (47))){
var state_24696__$1 = state_24696;
var statearr_24784_24902 = state_24696__$1;
(statearr_24784_24902[(2)] = fluree.db.util.core.max_long);

(statearr_24784_24902[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (35))){
var inst_24541 = (cljs.core._GT__EQ_ === start_test);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24541)){
var statearr_24785_24903 = state_24696__$1;
(statearr_24785_24903[(1)] = (37));

} else {
var statearr_24786_24904 = state_24696__$1;
(statearr_24786_24904[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (82))){
var inst_24611 = (state_24696[(7)]);
var state_24696__$1 = state_24696;
var statearr_24787_24905 = state_24696__$1;
(statearr_24787_24905[(2)] = inst_24611);

(statearr_24787_24905[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (76))){
var inst_24636 = (state_24696[(61)]);
var inst_24646 = (state_24696[(23)]);
var inst_24660 = (state_24696[(2)]);
var inst_24627 = inst_24636;
var inst_24628 = inst_24646;
var inst_24629 = inst_24660;
var state_24696__$1 = (function (){var statearr_24788 = state_24696;
(statearr_24788[(22)] = inst_24628);

(statearr_24788[(55)] = inst_24627);

(statearr_24788[(52)] = inst_24629);

return statearr_24788;
})();
var statearr_24789_24906 = state_24696__$1;
(statearr_24789_24906[(2)] = null);

(statearr_24789_24906[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (19))){
var inst_24481 = (state_24696[(58)]);
var state_24696__$1 = state_24696;
var statearr_24790_24907 = state_24696__$1;
(statearr_24790_24907[(2)] = inst_24481);

(statearr_24790_24907[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (57))){
var inst_24575 = (state_24696[(30)]);
var inst_24585 = (state_24696[(36)]);
var inst_24574 = (state_24696[(43)]);
var inst_24595 = (state_24696[(11)]);
var inst_24599 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_24595,inst_24574,inst_24575,inst_24585);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(59),inst_24599);
} else {
if((state_val_24697 === (68))){
var inst_24637 = (state_24696[(60)]);
var state_24696__$1 = state_24696;
var statearr_24791_24908 = state_24696__$1;
(statearr_24791_24908[(2)] = inst_24637);

(statearr_24791_24908[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (11))){
var inst_24479 = (state_24696[(59)]);
var state_24696__$1 = state_24696;
var statearr_24793_24909 = state_24696__$1;
(statearr_24793_24909[(2)] = inst_24479);

(statearr_24793_24909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (9))){
var inst_24489 = (state_24696[(2)]);
var inst_24490 = fluree.db.util.async.throw_err(inst_24489);
var state_24696__$1 = state_24696;
var statearr_24794_24910 = state_24696__$1;
(statearr_24794_24910[(2)] = inst_24490);

(statearr_24794_24910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (5))){
var _ = (function (){var statearr_24795 = state_24696;
(statearr_24795[(4)] = cljs.core.rest((state_24696[(4)])));

return statearr_24795;
})();
var state_24696__$1 = state_24696;
var ex24792 = (state_24696__$1[(2)]);
var statearr_24796_24911 = state_24696__$1;
(statearr_24796_24911[(5)] = ex24792);


if((ex24792 instanceof Error)){
var statearr_24797_24912 = state_24696__$1;
(statearr_24797_24912[(1)] = (4));

(statearr_24797_24912[(5)] = null);

} else {
throw ex24792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (83))){
var inst_24679 = (state_24696[(2)]);
var inst_24680 = cljs.core.not(inst_24679);
var state_24696__$1 = state_24696;
if(inst_24680){
var statearr_24798_24913 = state_24696__$1;
(statearr_24798_24913[(1)] = (87));

} else {
var statearr_24799_24914 = state_24696__$1;
(statearr_24799_24914[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (14))){
var inst_24474 = (state_24696[(50)]);
var inst_24505 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_24474);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(17),inst_24505);
} else {
if((state_val_24697 === (45))){
var inst_24554 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24800_24915 = state_24696__$1;
(statearr_24800_24915[(2)] = inst_24554);

(statearr_24800_24915[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (53))){
var state_24696__$1 = state_24696;
var statearr_24801_24916 = state_24696__$1;
(statearr_24801_24916[(2)] = true);

(statearr_24801_24916[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (78))){
var inst_24629 = (state_24696[(52)]);
var state_24696__$1 = state_24696;
var statearr_24802_24917 = state_24696__$1;
(statearr_24802_24917[(2)] = inst_24629);

(statearr_24802_24917[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (26))){
var inst_24473 = (state_24696[(20)]);
var state_24696__$1 = state_24696;
var statearr_24803_24918 = state_24696__$1;
(statearr_24803_24918[(2)] = inst_24473);

(statearr_24803_24918[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (16))){
var inst_24481 = (state_24696[(58)]);
var inst_24511 = (state_24696[(2)]);
var inst_24512 = fluree.db.util.core.pred_ident_QMARK_(inst_24481);
var state_24696__$1 = (function (){var statearr_24804 = state_24696;
(statearr_24804[(26)] = inst_24511);

return statearr_24804;
})();
if(inst_24512){
var statearr_24805_24919 = state_24696__$1;
(statearr_24805_24919[(1)] = (18));

} else {
var statearr_24806_24920 = state_24696__$1;
(statearr_24806_24920[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (81))){
var inst_24558 = (state_24696[(15)]);
var inst_24671 = (state_24696[(48)]);
var inst_24568 = (state_24696[(33)]);
var inst_24611 = (state_24696[(7)]);
var inst_24670 = (inst_24568.cljs$core$IFn$_invoke$arity$2 ? inst_24568.cljs$core$IFn$_invoke$arity$2(inst_24611,inst_24558) : inst_24568.call(null,inst_24611,inst_24558));
var inst_24671__$1 = (inst_24670 < (0));
var state_24696__$1 = (function (){var statearr_24807 = state_24696;
(statearr_24807[(48)] = inst_24671__$1);

return statearr_24807;
})();
if(cljs.core.truth_(inst_24671__$1)){
var statearr_24808_24921 = state_24696__$1;
(statearr_24808_24921[(1)] = (84));

} else {
var statearr_24809_24922 = state_24696__$1;
(statearr_24809_24922[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (79))){
var inst_24629 = (state_24696[(52)]);
var inst_24635 = (state_24696[(13)]);
var inst_24655 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_24629,inst_24635);
var state_24696__$1 = state_24696;
var statearr_24810_24923 = state_24696__$1;
(statearr_24810_24923[(2)] = inst_24655);

(statearr_24810_24923[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (38))){
var state_24696__$1 = state_24696;
var statearr_24811_24924 = state_24696__$1;
(statearr_24811_24924[(2)] = (2147483647));

(statearr_24811_24924[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (87))){
var inst_24667 = (state_24696[(8)]);
var state_24696__$1 = state_24696;
var statearr_24812_24925 = state_24696__$1;
(statearr_24812_24925[(2)] = inst_24667);

(statearr_24812_24925[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (30))){
var inst_24534 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
if(cljs.core.truth_(inst_24534)){
var statearr_24813_24926 = state_24696__$1;
(statearr_24813_24926[(1)] = (31));

} else {
var statearr_24814_24927 = state_24696__$1;
(statearr_24814_24927[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (73))){
var inst_24663 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24815_24928 = state_24696__$1;
(statearr_24815_24928[(2)] = inst_24663);

(statearr_24815_24928[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (10))){
var inst_24479 = (state_24696[(59)]);
var inst_24496 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_24479);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(13),inst_24496);
} else {
if((state_val_24697 === (18))){
var inst_24481 = (state_24696[(58)]);
var inst_24514 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_24481);
var state_24696__$1 = state_24696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24696__$1,(21),inst_24514);
} else {
if((state_val_24697 === (52))){
var inst_24564 = (state_24696[(24)]);
var inst_24538 = (state_24696[(28)]);
var inst_24529 = (state_24696[(42)]);
var inst_24502 = (state_24696[(44)]);
var inst_24493 = (state_24696[(45)]);
var inst_24578 = fluree.db.permissions_validate.no_filter_QMARK_(inst_24564,inst_24493,inst_24502,inst_24529,inst_24538);
var state_24696__$1 = state_24696;
var statearr_24816_24929 = state_24696__$1;
(statearr_24816_24929[(2)] = inst_24578);

(statearr_24816_24929[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (67))){
var inst_24665 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24817_24930 = state_24696__$1;
(statearr_24817_24930[(2)] = inst_24665);

(statearr_24817_24930[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (71))){
var inst_24597 = (state_24696[(40)]);
var inst_24629 = (state_24696[(52)]);
var inst_24644 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24629,inst_24597);
var state_24696__$1 = state_24696;
var statearr_24818_24931 = state_24696__$1;
(statearr_24818_24931[(2)] = inst_24644);

(statearr_24818_24931[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (42))){
var inst_24520 = (state_24696[(21)]);
var inst_24511 = (state_24696[(26)]);
var inst_24483 = (state_24696[(27)]);
var inst_24538 = (state_24696[(28)]);
var inst_24475 = (state_24696[(29)]);
var inst_24482 = (state_24696[(32)]);
var inst_24547 = (state_24696[(34)]);
var inst_24556 = (state_24696[(37)]);
var inst_24476 = (state_24696[(38)]);
var inst_24559 = (state_24696[(49)]);
var inst_24529 = (state_24696[(42)]);
var inst_24502 = (state_24696[(44)]);
var inst_24493 = (state_24696[(45)]);
var inst_24556__$1 = (state_24696[(2)]);
var inst_24557 = fluree.db.flake.__GT_Flake(inst_24493,inst_24529,inst_24511,inst_24475,inst_24476,inst_24547);
var inst_24558 = fluree.db.flake.__GT_Flake(inst_24502,inst_24538,inst_24520,inst_24482,inst_24483,inst_24556__$1);
var inst_24559__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_24696__$1 = (function (){var statearr_24819 = state_24696;
(statearr_24819[(15)] = inst_24558);

(statearr_24819[(16)] = inst_24557);

(statearr_24819[(37)] = inst_24556__$1);

(statearr_24819[(49)] = inst_24559__$1);

return statearr_24819;
})();
if(cljs.core.truth_(inst_24559__$1)){
var statearr_24820_24932 = state_24696__$1;
(statearr_24820_24932[(1)] = (46));

} else {
var statearr_24821_24933 = state_24696__$1;
(statearr_24821_24933[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (80))){
var inst_24657 = (state_24696[(2)]);
var state_24696__$1 = state_24696;
var statearr_24822_24934 = state_24696__$1;
(statearr_24822_24934[(2)] = inst_24657);

(statearr_24822_24934[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (37))){
var state_24696__$1 = state_24696;
var statearr_24823_24935 = state_24696__$1;
(statearr_24823_24935[(2)] = fluree.db.util.core.min_integer);

(statearr_24823_24935[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (63))){
var inst_24596 = (state_24696[(31)]);
var inst_24597 = (state_24696[(40)]);
var inst_24563 = (state_24696[(41)]);
var inst_24610 = (state_24696[(12)]);
var inst_24613 = (inst_24563 - inst_24596);
var inst_24614 = fluree.db.flake.take(inst_24613,inst_24610);
var inst_24615 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24614,inst_24597);
var state_24696__$1 = state_24696;
var statearr_24824_24936 = state_24696__$1;
(statearr_24824_24936[(2)] = inst_24615);

(statearr_24824_24936[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (8))){
var inst_24479 = (state_24696[(59)]);
var inst_24493 = (state_24696[(2)]);
var inst_24494 = fluree.db.util.core.pred_ident_QMARK_(inst_24479);
var state_24696__$1 = (function (){var statearr_24825 = state_24696;
(statearr_24825[(45)] = inst_24493);

return statearr_24825;
})();
if(inst_24494){
var statearr_24826_24937 = state_24696__$1;
(statearr_24826_24937[(1)] = (10));

} else {
var statearr_24827_24938 = state_24696__$1;
(statearr_24827_24938[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (49))){
var inst_24569 = (state_24696[(51)]);
var state_24696__$1 = state_24696;
var statearr_24828_24939 = state_24696__$1;
(statearr_24828_24939[(2)] = inst_24569);

(statearr_24828_24939[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24697 === (84))){
var inst_24563 = (state_24696[(41)]);
var inst_24668 = (state_24696[(9)]);
var inst_24673 = (inst_24668 < inst_24563);
var state_24696__$1 = state_24696;
var statearr_24829_24940 = state_24696__$1;
(statearr_24829_24940[(2)] = inst_24673);

(statearr_24829_24940[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11410__auto__ = null;
var fluree$db$query$range$state_machine__11410__auto____0 = (function (){
var statearr_24830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24830[(0)] = fluree$db$query$range$state_machine__11410__auto__);

(statearr_24830[(1)] = (1));

return statearr_24830;
});
var fluree$db$query$range$state_machine__11410__auto____1 = (function (state_24696){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_24696);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e24831){var ex__11413__auto__ = e24831;
var statearr_24832_24941 = state_24696;
(statearr_24832_24941[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_24696[(4)]))){
var statearr_24833_24942 = state_24696;
(statearr_24833_24942[(1)] = cljs.core.first((state_24696[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24943 = state_24696;
state_24696 = G__24943;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11410__auto__ = function(state_24696){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11410__auto____1.call(this,state_24696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11410__auto____0;
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11410__auto____1;
return fluree$db$query$range$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_24834 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_24834[(6)] = c__11484__auto__);

return statearr_24834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_25018){
var state_val_25019 = (state_25018[(1)]);
if((state_val_25019 === (7))){
var inst_25013 = (state_25018[(2)]);
var _ = (function (){var statearr_25020 = state_25018;
(statearr_25020[(4)] = cljs.core.rest((state_25018[(4)])));

return statearr_25020;
})();
var state_25018__$1 = state_25018;
var statearr_25021_25061 = state_25018__$1;
(statearr_25021_25061[(2)] = inst_25013);

(statearr_25021_25061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (20))){
var inst_24995 = (state_25018[(2)]);
var inst_24996 = fluree.db.util.async.throw_err(inst_24995);
var state_25018__$1 = state_25018;
var statearr_25022_25062 = state_25018__$1;
(statearr_25022_25062[(2)] = inst_24996);

(statearr_25022_25062[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (1))){
var state_25018__$1 = state_25018;
var statearr_25023_25063 = state_25018__$1;
(statearr_25023_25063[(2)] = null);

(statearr_25023_25063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (4))){
var inst_24944 = (state_25018[(2)]);
var state_25018__$1 = state_25018;
var statearr_25024_25064 = state_25018__$1;
(statearr_25024_25064[(2)] = inst_24944);

(statearr_25024_25064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (15))){
var inst_24991 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25018__$1 = state_25018;
if(cljs.core.truth_(inst_24991)){
var statearr_25025_25065 = state_25018__$1;
(statearr_25025_25065[(1)] = (17));

} else {
var statearr_25026_25066 = state_25018__$1;
(statearr_25026_25066[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (21))){
var state_25018__$1 = state_25018;
var statearr_25027_25067 = state_25018__$1;
(statearr_25027_25067[(2)] = (0));

(statearr_25027_25067[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (13))){
var inst_24983 = (state_25018[(2)]);
var state_25018__$1 = state_25018;
var statearr_25028_25068 = state_25018__$1;
(statearr_25028_25068[(2)] = inst_24983);

(statearr_25028_25068[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (22))){
var state_25018__$1 = state_25018;
var statearr_25029_25069 = state_25018__$1;
(statearr_25029_25069[(2)] = (1));

(statearr_25029_25069[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (6))){
var inst_24975 = (state_25018[(7)]);
var inst_24964 = (state_25018[(8)]);
var inst_24973 = (state_25018[(9)]);
var inst_24972 = cljs.core.seq(inst_24964);
var inst_24973__$1 = cljs.core.first(inst_24972);
var inst_24974 = cljs.core.next(inst_24972);
var inst_24975__$1 = (inst_24973__$1 == null);
var state_25018__$1 = (function (){var statearr_25030 = state_25018;
(statearr_25030[(7)] = inst_24975__$1);

(statearr_25030[(9)] = inst_24973__$1);

(statearr_25030[(10)] = inst_24974);

return statearr_25030;
})();
if(cljs.core.truth_(inst_24975__$1)){
var statearr_25031_25070 = state_25018__$1;
(statearr_25031_25070[(1)] = (8));

} else {
var statearr_25032_25071 = state_25018__$1;
(statearr_25032_25071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (17))){
var inst_24973 = (state_25018[(9)]);
var inst_24993 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_24973);
var state_25018__$1 = state_25018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25018__$1,(20),inst_24993);
} else {
if((state_val_25019 === (3))){
var inst_25016 = (state_25018[(2)]);
var state_25018__$1 = state_25018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25018__$1,inst_25016);
} else {
if((state_val_25019 === (12))){
var inst_24966 = (state_25018[(11)]);
var inst_24981 = (inst_24966 >= subject_limit);
var state_25018__$1 = state_25018;
var statearr_25033_25072 = state_25018__$1;
(statearr_25033_25072[(2)] = inst_24981);

(statearr_25033_25072[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (2))){
var _ = (function (){var statearr_25034 = state_25018;
(statearr_25034[(4)] = cljs.core.cons((5),(state_25018[(4)])));

return statearr_25034;
})();
var inst_24957 = subject_groups;
var inst_24958 = cljs.core.seq(inst_24957);
var inst_24959 = cljs.core.first(inst_24958);
var inst_24960 = cljs.core.next(inst_24958);
var inst_24961 = flake_start;
var inst_24962 = subject_start;
var inst_24963 = cljs.core.PersistentVector.EMPTY;
var inst_24964 = inst_24957;
var inst_24965 = inst_24961;
var inst_24966 = inst_24962;
var inst_24967 = inst_24963;
var state_25018__$1 = (function (){var statearr_25035 = state_25018;
(statearr_25035[(12)] = inst_24967);

(statearr_25035[(13)] = inst_24960);

(statearr_25035[(11)] = inst_24966);

(statearr_25035[(14)] = inst_24959);

(statearr_25035[(15)] = inst_24965);

(statearr_25035[(8)] = inst_24964);

return statearr_25035;
})();
var statearr_25036_25073 = state_25018__$1;
(statearr_25036_25073[(2)] = null);

(statearr_25036_25073[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (23))){
var inst_25000 = (state_25018[(16)]);
var inst_24967 = (state_25018[(12)]);
var inst_24999 = (state_25018[(17)]);
var inst_24966 = (state_25018[(11)]);
var inst_24965 = (state_25018[(15)]);
var inst_24974 = (state_25018[(10)]);
var inst_25005 = (state_25018[(2)]);
var inst_25006 = (inst_24965 + inst_25000);
var inst_25007 = (inst_24966 + inst_25005);
var inst_25008 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24967,inst_24999);
var inst_24964 = inst_24974;
var inst_24965__$1 = inst_25006;
var inst_24966__$1 = inst_25007;
var inst_24967__$1 = inst_25008;
var state_25018__$1 = (function (){var statearr_25037 = state_25018;
(statearr_25037[(12)] = inst_24967__$1);

(statearr_25037[(11)] = inst_24966__$1);

(statearr_25037[(15)] = inst_24965__$1);

(statearr_25037[(8)] = inst_24964);

return statearr_25037;
})();
var statearr_25038_25074 = state_25018__$1;
(statearr_25038_25074[(2)] = null);

(statearr_25038_25074[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (19))){
var inst_25000 = (state_25018[(16)]);
var inst_24999 = (state_25018[(17)]);
var inst_24999__$1 = (state_25018[(2)]);
var inst_25000__$1 = cljs.core.count(inst_24999__$1);
var inst_25001 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_25000__$1);
var state_25018__$1 = (function (){var statearr_25039 = state_25018;
(statearr_25039[(16)] = inst_25000__$1);

(statearr_25039[(17)] = inst_24999__$1);

return statearr_25039;
})();
if(inst_25001){
var statearr_25040_25075 = state_25018__$1;
(statearr_25040_25075[(1)] = (21));

} else {
var statearr_25041_25076 = state_25018__$1;
(statearr_25041_25076[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (11))){
var inst_24978 = (state_25018[(18)]);
var state_25018__$1 = state_25018;
var statearr_25043_25077 = state_25018__$1;
(statearr_25043_25077[(2)] = inst_24978);

(statearr_25043_25077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (9))){
var inst_24965 = (state_25018[(15)]);
var inst_24978 = (state_25018[(18)]);
var inst_24978__$1 = (inst_24965 >= flake_limit);
var state_25018__$1 = (function (){var statearr_25044 = state_25018;
(statearr_25044[(18)] = inst_24978__$1);

return statearr_25044;
})();
if(cljs.core.truth_(inst_24978__$1)){
var statearr_25045_25078 = state_25018__$1;
(statearr_25045_25078[(1)] = (11));

} else {
var statearr_25046_25079 = state_25018__$1;
(statearr_25046_25079[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (5))){
var _ = (function (){var statearr_25047 = state_25018;
(statearr_25047[(4)] = cljs.core.rest((state_25018[(4)])));

return statearr_25047;
})();
var state_25018__$1 = state_25018;
var ex25042 = (state_25018__$1[(2)]);
var statearr_25048_25080 = state_25018__$1;
(statearr_25048_25080[(5)] = ex25042);


if((ex25042 instanceof Error)){
var statearr_25049_25081 = state_25018__$1;
(statearr_25049_25081[(1)] = (4));

(statearr_25049_25081[(5)] = null);

} else {
throw ex25042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (14))){
var inst_24967 = (state_25018[(12)]);
var inst_24966 = (state_25018[(11)]);
var inst_24965 = (state_25018[(15)]);
var inst_24987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24988 = [inst_24965,inst_24966,inst_24967];
var inst_24989 = (new cljs.core.PersistentVector(null,3,(5),inst_24987,inst_24988,null));
var state_25018__$1 = state_25018;
var statearr_25050_25082 = state_25018__$1;
(statearr_25050_25082[(2)] = inst_24989);

(statearr_25050_25082[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (16))){
var inst_25011 = (state_25018[(2)]);
var state_25018__$1 = state_25018;
var statearr_25051_25083 = state_25018__$1;
(statearr_25051_25083[(2)] = inst_25011);

(statearr_25051_25083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (10))){
var inst_24985 = (state_25018[(2)]);
var state_25018__$1 = state_25018;
if(cljs.core.truth_(inst_24985)){
var statearr_25052_25084 = state_25018__$1;
(statearr_25052_25084[(1)] = (14));

} else {
var statearr_25053_25085 = state_25018__$1;
(statearr_25053_25085[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (18))){
var inst_24973 = (state_25018[(9)]);
var state_25018__$1 = state_25018;
var statearr_25054_25086 = state_25018__$1;
(statearr_25054_25086[(2)] = inst_24973);

(statearr_25054_25086[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25019 === (8))){
var inst_24975 = (state_25018[(7)]);
var state_25018__$1 = state_25018;
var statearr_25055_25087 = state_25018__$1;
(statearr_25055_25087[(2)] = inst_24975);

(statearr_25055_25087[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____0 = (function (){
var statearr_25056 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25056[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__);

(statearr_25056[(1)] = (1));

return statearr_25056;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____1 = (function (state_25018){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_25018);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e25057){var ex__11413__auto__ = e25057;
var statearr_25058_25088 = state_25018;
(statearr_25058_25088[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_25018[(4)]))){
var statearr_25059_25089 = state_25018;
(statearr_25059_25089[(1)] = cljs.core.first((state_25018[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25090 = state_25018;
state_25018 = G__25090;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__ = function(state_25018){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____1.call(this,state_25018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_25060 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_25060[(6)] = c__11484__auto__);

return statearr_25060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_25136){
var state_val_25137 = (state_25136[(1)]);
if((state_val_25137 === (7))){
var state_25136__$1 = state_25136;
var statearr_25138_25176 = state_25136__$1;
(statearr_25138_25176[(2)] = null);

(statearr_25138_25176[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (20))){
var inst_25122 = (state_25136[(2)]);
var inst_25123 = fluree.db.util.async.throw_err(inst_25122);
var inst_25101 = inst_25123;
var state_25136__$1 = (function (){var statearr_25139 = state_25136;
(statearr_25139[(7)] = inst_25101);

return statearr_25139;
})();
var statearr_25140_25177 = state_25136__$1;
(statearr_25140_25177[(2)] = null);

(statearr_25140_25177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (1))){
var state_25136__$1 = state_25136;
var statearr_25141_25178 = state_25136__$1;
(statearr_25141_25178[(2)] = null);

(statearr_25141_25178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (4))){
var inst_25091 = (state_25136[(2)]);
var state_25136__$1 = state_25136;
var statearr_25142_25179 = state_25136__$1;
(statearr_25142_25179[(2)] = inst_25091);

(statearr_25142_25179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (15))){
var inst_25101 = (state_25136[(7)]);
var inst_25118 = (state_25136[(8)]);
var inst_25118__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_25101);
var state_25136__$1 = (function (){var statearr_25143 = state_25136;
(statearr_25143[(8)] = inst_25118__$1);

return statearr_25143;
})();
if(cljs.core.truth_(inst_25118__$1)){
var statearr_25144_25180 = state_25136__$1;
(statearr_25144_25180[(1)] = (17));

} else {
var statearr_25145_25181 = state_25136__$1;
(statearr_25145_25181[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (13))){
var inst_25111 = (state_25136[(2)]);
var inst_25112 = fluree.db.util.async.throw_err(inst_25111);
var _ = (function (){var statearr_25146 = state_25136;
(statearr_25146[(4)] = cljs.core.rest((state_25136[(4)])));

return statearr_25146;
})();
var state_25136__$1 = state_25136;
var statearr_25147_25182 = state_25136__$1;
(statearr_25147_25182[(2)] = inst_25112);

(statearr_25147_25182[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (6))){
var inst_25099 = (state_25136[(2)]);
var inst_25100 = fluree.db.util.async.throw_err(inst_25099);
var inst_25101 = inst_25100;
var state_25136__$1 = (function (){var statearr_25148 = state_25136;
(statearr_25148[(7)] = inst_25101);

return statearr_25148;
})();
var statearr_25149_25183 = state_25136__$1;
(statearr_25149_25183[(2)] = null);

(statearr_25149_25183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (17))){
var inst_25118 = (state_25136[(8)]);
var inst_25120 = fluree.db.dbproto._lookup_leaf(root_node,inst_25118);
var state_25136__$1 = state_25136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25136__$1,(20),inst_25120);
} else {
if((state_val_25137 === (3))){
var inst_25134 = (state_25136[(2)]);
var state_25136__$1 = state_25136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25136__$1,inst_25134);
} else {
if((state_val_25137 === (12))){
var _ = (function (){var statearr_25151 = state_25136;
(statearr_25151[(4)] = cljs.core.rest((state_25136[(4)])));

return statearr_25151;
})();
var state_25136__$1 = state_25136;
var ex25150 = (state_25136__$1[(2)]);
var statearr_25152_25184 = state_25136__$1;
(statearr_25152_25184[(5)] = ex25150);


var statearr_25153_25185 = state_25136__$1;
(statearr_25153_25185[(1)] = (11));

(statearr_25153_25185[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (2))){
var _ = (function (){var statearr_25154 = state_25136;
(statearr_25154[(4)] = cljs.core.cons((5),(state_25136[(4)])));

return statearr_25154;
})();
var inst_25097 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_25136__$1 = state_25136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25136__$1,(6),inst_25097);
} else {
if((state_val_25137 === (19))){
var inst_25127 = (state_25136[(2)]);
var state_25136__$1 = state_25136;
var statearr_25155_25186 = state_25136__$1;
(statearr_25155_25186[(2)] = inst_25127);

(statearr_25155_25186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (11))){
var inst_25103 = (state_25136[(2)]);
var state_25136__$1 = (function (){var statearr_25157 = state_25136;
(statearr_25157[(9)] = inst_25103);

return statearr_25157;
})();
var statearr_25158_25187 = state_25136__$1;
(statearr_25158_25187[(2)] = null);

(statearr_25158_25187[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (9))){
var inst_25101 = (state_25136[(7)]);
var _ = (function (){var statearr_25159 = state_25136;
(statearr_25159[(4)] = cljs.core.cons((12),(state_25136[(4)])));

return statearr_25159;
})();
var inst_25109 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_25101,t,novelty,fast_forward_db_QMARK_);
var state_25136__$1 = state_25136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25136__$1,(13),inst_25109);
} else {
if((state_val_25137 === (5))){
var _ = (function (){var statearr_25160 = state_25136;
(statearr_25160[(4)] = cljs.core.rest((state_25136[(4)])));

return statearr_25160;
})();
var state_25136__$1 = state_25136;
var ex25156 = (state_25136__$1[(2)]);
var statearr_25161_25188 = state_25136__$1;
(statearr_25161_25188[(5)] = ex25156);


if((ex25156 instanceof Error)){
var statearr_25162_25189 = state_25136__$1;
(statearr_25162_25189[(1)] = (4));

(statearr_25162_25189[(5)] = null);

} else {
throw ex25156;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (14))){
var inst_25115 = (state_25136[(10)]);
var state_25136__$1 = state_25136;
var statearr_25163_25190 = state_25136__$1;
(statearr_25163_25190[(2)] = inst_25115);

(statearr_25163_25190[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (16))){
var inst_25129 = (state_25136[(2)]);
var state_25136__$1 = state_25136;
var statearr_25164_25191 = state_25136__$1;
(statearr_25164_25191[(2)] = inst_25129);

(statearr_25164_25191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (10))){
var inst_25115 = (state_25136[(10)]);
var inst_25115__$1 = (state_25136[(2)]);
var state_25136__$1 = (function (){var statearr_25165 = state_25136;
(statearr_25165[(10)] = inst_25115__$1);

return statearr_25165;
})();
if(cljs.core.truth_(inst_25115__$1)){
var statearr_25166_25192 = state_25136__$1;
(statearr_25166_25192[(1)] = (14));

} else {
var statearr_25167_25193 = state_25136__$1;
(statearr_25167_25193[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (18))){
var state_25136__$1 = state_25136;
var statearr_25168_25194 = state_25136__$1;
(statearr_25168_25194[(2)] = null);

(statearr_25168_25194[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25137 === (8))){
var inst_25131 = (state_25136[(2)]);
var _ = (function (){var statearr_25169 = state_25136;
(statearr_25169[(4)] = cljs.core.rest((state_25136[(4)])));

return statearr_25169;
})();
var state_25136__$1 = state_25136;
var statearr_25170_25195 = state_25136__$1;
(statearr_25170_25195[(2)] = inst_25131);

(statearr_25170_25195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____0 = (function (){
var statearr_25171 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25171[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__);

(statearr_25171[(1)] = (1));

return statearr_25171;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____1 = (function (state_25136){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_25136);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e25172){var ex__11413__auto__ = e25172;
var statearr_25173_25196 = state_25136;
(statearr_25173_25196[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_25136[(4)]))){
var statearr_25174_25197 = state_25136;
(statearr_25174_25197[(1)] = cljs.core.first((state_25136[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25198 = state_25136;
state_25136 = G__25198;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__ = function(state_25136){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____1.call(this,state_25136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_25175 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_25175[(6)] = c__11484__auto__);

return statearr_25175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__25205 = arguments.length;
switch (G__25205) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__25206 = (function (){var pred__25209 = cljs.core.identical_QMARK_;
var expr__25210 = test;
if(cljs.core.truth_((pred__25209.cljs$core$IFn$_invoke$arity$2 ? pred__25209.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__25210) : pred__25209.call(null,cljs.core._EQ_,expr__25210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25209.cljs$core$IFn$_invoke$arity$2 ? pred__25209.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__25210) : pred__25209.call(null,cljs.core._LT_,expr__25210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__25209.cljs$core$IFn$_invoke$arity$2 ? pred__25209.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__25210) : pred__25209.call(null,cljs.core._LT__EQ_,expr__25210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25209.cljs$core$IFn$_invoke$arity$2 ? pred__25209.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__25210) : pred__25209.call(null,cljs.core._GT_,expr__25210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__25209.cljs$core$IFn$_invoke$arity$2 ? pred__25209.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__25210) : pred__25209.call(null,cljs.core._GT__EQ_,expr__25210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__25210)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25206,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25206,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25206,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25206,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_25582){
var state_val_25583 = (state_25582[(1)]);
if((state_val_25583 === (121))){
var inst_25538 = (state_25582[(7)]);
var state_25582__$1 = state_25582;
var statearr_25584_25780 = state_25582__$1;
(statearr_25584_25780[(2)] = inst_25538);

(statearr_25584_25780[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (65))){
var inst_25390 = (state_25582[(8)]);
var inst_25396 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25585 = state_25582;
(statearr_25585[(9)] = inst_25396);

return statearr_25585;
})();
if(cljs.core.truth_(inst_25390)){
var statearr_25586_25781 = state_25582__$1;
(statearr_25586_25781[(1)] = (66));

} else {
var statearr_25587_25782 = state_25582__$1;
(statearr_25587_25782[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (70))){
var inst_25574 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25588_25783 = state_25582__$1;
(statearr_25588_25783[(2)] = inst_25574);

(statearr_25588_25783[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (62))){
var inst_25389 = (state_25582[(2)]);
var inst_25390 = fluree.db.util.async.throw_err(inst_25389);
var inst_25391 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25582__$1 = (function (){var statearr_25589 = state_25582;
(statearr_25589[(8)] = inst_25390);

return statearr_25589;
})();
if(cljs.core.truth_(inst_25391)){
var statearr_25590_25784 = state_25582__$1;
(statearr_25590_25784[(1)] = (63));

} else {
var statearr_25591_25785 = state_25582__$1;
(statearr_25591_25785[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (74))){
var inst_25375 = (state_25582[(10)]);
var inst_25399 = (state_25582[(11)]);
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25396 = (state_25582[(9)]);
var inst_25362 = (state_25582[(14)]);
var inst_25244 = (state_25582[(15)]);
var inst_25301 = (state_25582[(16)]);
var inst_25371 = (state_25582[(17)]);
var inst_25380 = (state_25582[(18)]);
var inst_25300 = (state_25582[(19)]);
var inst_25236 = (state_25582[(20)]);
var inst_25402 = (state_25582[(21)]);
var inst_25322 = (state_25582[(22)]);
var inst_25370 = (state_25582[(23)]);
var inst_25358 = (state_25582[(24)]);
var inst_25363 = (state_25582[(25)]);
var inst_25400 = (state_25582[(26)]);
var inst_25376 = (state_25582[(27)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25360 = (state_25582[(31)]);
var inst_25417 = (state_25582[(32)]);
var inst_25331 = (state_25582[(33)]);
var inst_25304 = (state_25582[(34)]);
var inst_25232 = (state_25582[(35)]);
var inst_25349 = (state_25582[(36)]);
var inst_25390 = (state_25582[(8)]);
var inst_25248 = (state_25582[(37)]);
var inst_25369 = (state_25582[(38)]);
var inst_25381 = (state_25582[(39)]);
var inst_25409 = (state_25582[(40)]);
var inst_25386 = (state_25582[(41)]);
var inst_25249 = (state_25582[(42)]);
var inst_25313 = (state_25582[(43)]);
var inst_25359 = (state_25582[(44)]);
var inst_25403 = (state_25582[(45)]);
var inst_25340 = (state_25582[(46)]);
var inst_25239 = (state_25582[(47)]);
var inst_25401 = (state_25582[(48)]);
var inst_25419 = (function (){var no_filter_QMARK_ = inst_25396;
var G__25410 = inst_25417;
var t = inst_25376;
var max_limit_QMARK_ = inst_25370;
var next_node = inst_25399;
var fast_forward_db_QMARK_ = inst_25381;
var s1 = inst_25259;
var o2 = inst_25322;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var i = inst_25401;
var m1 = inst_25349;
var root_node = inst_25386;
var s2 = inst_25268;
var p2 = inst_25340;
var map__25224 = inst_25247;
var permissions = inst_25371;
var limit = inst_25369;
var start_flake = inst_25359;
var vec__25218 = inst_25232;
var flake_limit = inst_25363;
var offset = inst_25400;
var acc = inst_25403;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25313;
var end_flake = inst_25360;
var base_result = inst_25409;
var s = inst_25402;
var node_start = inst_25390;
var p1 = inst_25331;
var subject_fn = inst_25248;
var vec__25225 = inst_25300;
var object_fn = inst_25304;
var idx_compare = inst_25375;
var map__25231 = inst_25362;
var vec__25228 = inst_25301;
var op2 = inst_25244;
var m2 = inst_25358;
var novelty = inst_25380;
return (function (p1__25200_SHARP_){
var G__25592 = p1__25200_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__25592) : subject_fn.call(null,G__25592));
});
})();
var inst_25420 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_25419,inst_25417);
var state_25582__$1 = state_25582;
var statearr_25593_25786 = state_25582__$1;
(statearr_25593_25786[(2)] = inst_25420);

(statearr_25593_25786[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (110))){
var inst_25551 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25594_25787 = state_25582__$1;
(statearr_25594_25787[(2)] = inst_25551);

(statearr_25594_25787[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (7))){
var inst_25233 = (state_25582[(49)]);
var state_25582__$1 = state_25582;
var statearr_25595_25788 = state_25582__$1;
(statearr_25595_25788[(2)] = inst_25233);

(statearr_25595_25788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (59))){
var state_25582__$1 = state_25582;
var statearr_25596_25789 = state_25582__$1;
(statearr_25596_25789[(2)] = fluree.db.util.core.max_long);

(statearr_25596_25789[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (86))){
var inst_25396 = (state_25582[(9)]);
var state_25582__$1 = state_25582;
var statearr_25597_25790 = state_25582__$1;
(statearr_25597_25790[(2)] = inst_25396);

(statearr_25597_25790[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (20))){
var state_25582__$1 = state_25582;
var statearr_25598_25791 = state_25582__$1;
(statearr_25598_25791[(2)] = null);

(statearr_25598_25791[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (72))){
var inst_25409 = (state_25582[(40)]);
var state_25582__$1 = state_25582;
var statearr_25599_25792 = state_25582__$1;
(statearr_25599_25792[(2)] = inst_25409);

(statearr_25599_25792[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (58))){
var inst_25364 = (state_25582[(50)]);
var state_25582__$1 = state_25582;
var statearr_25600_25793 = state_25582__$1;
(statearr_25600_25793[(2)] = inst_25364);

(statearr_25600_25793[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (60))){
var inst_25369 = (state_25582[(38)]);
var inst_25369__$1 = (state_25582[(2)]);
var inst_25370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25369__$1,fluree.db.util.core.max_long);
var inst_25371 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_25372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25373 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_25374 = (new cljs.core.PersistentVector(null,3,(5),inst_25372,inst_25373,null));
var inst_25375 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25374);
var inst_25376 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25378 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_25379 = (new cljs.core.PersistentVector(null,2,(5),inst_25377,inst_25378,null));
var inst_25380 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25379);
var inst_25381 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_25382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_25383 = fluree.db.dbproto._resolve(inst_25382);
var state_25582__$1 = (function (){var statearr_25601 = state_25582;
(statearr_25601[(10)] = inst_25375);

(statearr_25601[(17)] = inst_25371);

(statearr_25601[(18)] = inst_25380);

(statearr_25601[(23)] = inst_25370);

(statearr_25601[(27)] = inst_25376);

(statearr_25601[(38)] = inst_25369__$1);

(statearr_25601[(39)] = inst_25381);

return statearr_25601;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(61),inst_25383);
} else {
if((state_val_25583 === (27))){
var inst_25302 = (state_25582[(51)]);
var state_25582__$1 = state_25582;
var statearr_25602_25794 = state_25582__$1;
(statearr_25602_25794[(2)] = inst_25302);

(statearr_25602_25794[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (1))){
var state_25582__$1 = state_25582;
var statearr_25603_25795 = state_25582__$1;
(statearr_25603_25795[(2)] = null);

(statearr_25603_25795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (69))){
var inst_25399 = (state_25582[(11)]);
var inst_25360 = (state_25582[(31)]);
var inst_25359 = (state_25582[(44)]);
var inst_25408 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_25399);
var inst_25409 = fluree.db.flake.subrange(inst_25408,start_test,inst_25359,end_test,inst_25360);
var inst_25411 = fluree.db.query.range.value_with_nil_pred(idx,inst_25359,inst_25360);
var state_25582__$1 = (function (){var statearr_25604 = state_25582;
(statearr_25604[(40)] = inst_25409);

return statearr_25604;
})();
if(inst_25411){
var statearr_25605_25796 = state_25582__$1;
(statearr_25605_25796[(1)] = (71));

} else {
var statearr_25606_25797 = state_25582__$1;
(statearr_25606_25797[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (101))){
var inst_25495 = (state_25582[(52)]);
var inst_25363 = (state_25582[(25)]);
var inst_25497 = (state_25582[(53)]);
var inst_25496 = (state_25582[(54)]);
var inst_25500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25501 = (inst_25497 - inst_25363);
var inst_25502 = (inst_25496 - inst_25501);
var inst_25503 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25502,inst_25495);
var inst_25504 = [inst_25363,inst_25503];
var inst_25505 = (new cljs.core.PersistentVector(null,2,(5),inst_25500,inst_25504,null));
var state_25582__$1 = state_25582;
var statearr_25607_25798 = state_25582__$1;
(statearr_25607_25798[(2)] = inst_25505);

(statearr_25607_25798[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (24))){
var inst_25238 = (state_25582[(55)]);
var inst_25242 = (state_25582[(56)]);
var inst_25259 = (state_25582[(12)]);
var inst_25234 = (state_25582[(57)]);
var inst_25243 = (state_25582[(13)]);
var inst_25244 = (state_25582[(15)]);
var inst_25235 = (state_25582[(58)]);
var inst_25236 = (state_25582[(20)]);
var inst_25250 = (state_25582[(59)]);
var inst_25241 = (state_25582[(60)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25282 = (state_25582[(61)]);
var inst_25245 = (state_25582[(62)]);
var inst_25232 = (state_25582[(35)]);
var inst_25248 = (state_25582[(37)]);
var inst_25249 = (state_25582[(42)]);
var inst_25239 = (state_25582[(47)]);
var inst_25292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25294 = [null,null];
var inst_25295 = (new cljs.core.PersistentVector(null,2,(5),inst_25293,inst_25294,null));
var inst_25296 = (function (){var bool = inst_25282;
var s1 = inst_25259;
var o2 = inst_25242;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var m1 = inst_25238;
var s2 = inst_25268;
var p2 = inst_25241;
var map__25224 = inst_25247;
var vec__25218 = inst_25232;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25235;
var p1 = inst_25234;
var subject_fn = inst_25248;
var object_fn = inst_25250;
var op2 = inst_25244;
var m2 = inst_25245;
var temp__5755__auto__ = inst_25282;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_25297 = [inst_25295,inst_25296];
var inst_25298 = (new cljs.core.PersistentVector(null,2,(5),inst_25292,inst_25297,null));
var state_25582__$1 = state_25582;
var statearr_25608_25799 = state_25582__$1;
(statearr_25608_25799[(2)] = inst_25298);

(statearr_25608_25799[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (102))){
var inst_25495 = (state_25582[(52)]);
var inst_25497 = (state_25582[(53)]);
var inst_25507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25508 = [inst_25497,inst_25495];
var inst_25509 = (new cljs.core.PersistentVector(null,2,(5),inst_25507,inst_25508,null));
var state_25582__$1 = state_25582;
var statearr_25609_25800 = state_25582__$1;
(statearr_25609_25800[(2)] = inst_25509);

(statearr_25609_25800[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (55))){
var state_25582__$1 = state_25582;
var statearr_25610_25801 = state_25582__$1;
(statearr_25610_25801[(2)] = (2147483647));

(statearr_25610_25801[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (85))){
var inst_25445 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
if(cljs.core.truth_(inst_25445)){
var statearr_25611_25802 = state_25582__$1;
(statearr_25611_25802[(1)] = (89));

} else {
var statearr_25612_25803 = state_25582__$1;
(statearr_25612_25803[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (39))){
var inst_25241 = (state_25582[(60)]);
var inst_25332 = (state_25582[(63)]);
var inst_25331 = (state_25582[(2)]);
var inst_25332__$1 = (inst_25241 == null);
var state_25582__$1 = (function (){var statearr_25613 = state_25582;
(statearr_25613[(63)] = inst_25332__$1);

(statearr_25613[(33)] = inst_25331);

return statearr_25613;
})();
if(cljs.core.truth_(inst_25332__$1)){
var statearr_25614_25804 = state_25582__$1;
(statearr_25614_25804[(1)] = (40));

} else {
var statearr_25615_25805 = state_25582__$1;
(statearr_25615_25805[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (88))){
var inst_25442 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25616_25806 = state_25582__$1;
(statearr_25616_25806[(2)] = inst_25442);

(statearr_25616_25806[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (46))){
var inst_25238 = (state_25582[(55)]);
var state_25582__$1 = state_25582;
var statearr_25617_25807 = state_25582__$1;
(statearr_25617_25807[(2)] = inst_25238);

(statearr_25617_25807[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (4))){
var inst_25212 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25618_25808 = state_25582__$1;
(statearr_25618_25808[(2)] = inst_25212);

(statearr_25618_25808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (77))){
var inst_25375 = (state_25582[(10)]);
var inst_25423 = (state_25582[(64)]);
var inst_25399 = (state_25582[(11)]);
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25396 = (state_25582[(9)]);
var inst_25362 = (state_25582[(14)]);
var inst_25244 = (state_25582[(15)]);
var inst_25301 = (state_25582[(16)]);
var inst_25371 = (state_25582[(17)]);
var inst_25380 = (state_25582[(18)]);
var inst_25300 = (state_25582[(19)]);
var inst_25236 = (state_25582[(20)]);
var inst_25402 = (state_25582[(21)]);
var inst_25322 = (state_25582[(22)]);
var inst_25370 = (state_25582[(23)]);
var inst_25358 = (state_25582[(24)]);
var inst_25363 = (state_25582[(25)]);
var inst_25400 = (state_25582[(26)]);
var inst_25376 = (state_25582[(27)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25360 = (state_25582[(31)]);
var inst_25331 = (state_25582[(33)]);
var inst_25304 = (state_25582[(34)]);
var inst_25232 = (state_25582[(35)]);
var inst_25349 = (state_25582[(36)]);
var inst_25390 = (state_25582[(8)]);
var inst_25248 = (state_25582[(37)]);
var inst_25369 = (state_25582[(38)]);
var inst_25381 = (state_25582[(39)]);
var inst_25409 = (state_25582[(40)]);
var inst_25386 = (state_25582[(41)]);
var inst_25249 = (state_25582[(42)]);
var inst_25313 = (state_25582[(43)]);
var inst_25359 = (state_25582[(44)]);
var inst_25403 = (state_25582[(45)]);
var inst_25340 = (state_25582[(46)]);
var inst_25239 = (state_25582[(47)]);
var inst_25401 = (state_25582[(48)]);
var inst_25425 = (function (){var no_filter_QMARK_ = inst_25396;
var G__25410 = inst_25423;
var t = inst_25376;
var max_limit_QMARK_ = inst_25370;
var next_node = inst_25399;
var fast_forward_db_QMARK_ = inst_25381;
var s1 = inst_25259;
var o2 = inst_25322;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var i = inst_25401;
var m1 = inst_25349;
var root_node = inst_25386;
var s2 = inst_25268;
var p2 = inst_25340;
var map__25224 = inst_25247;
var permissions = inst_25371;
var limit = inst_25369;
var start_flake = inst_25359;
var vec__25218 = inst_25232;
var flake_limit = inst_25363;
var offset = inst_25400;
var acc = inst_25403;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25313;
var end_flake = inst_25360;
var base_result = inst_25409;
var s = inst_25402;
var node_start = inst_25390;
var p1 = inst_25331;
var subject_fn = inst_25248;
var vec__25225 = inst_25300;
var object_fn = inst_25304;
var idx_compare = inst_25375;
var map__25231 = inst_25362;
var vec__25228 = inst_25301;
var op2 = inst_25244;
var m2 = inst_25358;
var novelty = inst_25380;
return (function (p1__25201_SHARP_){
var G__25619 = p1__25201_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__25619) : predicate_fn.call(null,G__25619));
});
})();
var inst_25426 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_25425,inst_25423);
var state_25582__$1 = state_25582;
var statearr_25620_25809 = state_25582__$1;
(statearr_25620_25809[(2)] = inst_25426);

(statearr_25620_25809[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (106))){
var inst_25436 = (state_25582[(65)]);
var state_25582__$1 = state_25582;
var statearr_25621_25810 = state_25582__$1;
(statearr_25621_25810[(2)] = inst_25436);

(statearr_25621_25810[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (119))){
var inst_25554 = (state_25582[(66)]);
var state_25582__$1 = state_25582;
var statearr_25622_25811 = state_25582__$1;
(statearr_25622_25811[(2)] = inst_25554);

(statearr_25622_25811[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (95))){
var inst_25478 = (state_25582[(67)]);
var inst_25477 = (state_25582[(68)]);
var inst_25402 = (state_25582[(21)]);
var inst_25479 = (state_25582[(69)]);
var inst_25469 = (state_25582[(70)]);
var inst_25369 = (state_25582[(38)]);
var inst_25477__$1 = cljs.core.count(inst_25469);
var inst_25478__$1 = (inst_25402 + inst_25477__$1);
var inst_25479__$1 = (inst_25478__$1 - inst_25369);
var inst_25480 = cljs.core.pos_int_QMARK_(inst_25479__$1);
var state_25582__$1 = (function (){var statearr_25623 = state_25582;
(statearr_25623[(67)] = inst_25478__$1);

(statearr_25623[(68)] = inst_25477__$1);

(statearr_25623[(69)] = inst_25479__$1);

return statearr_25623;
})();
if(inst_25480){
var statearr_25624_25812 = state_25582__$1;
(statearr_25624_25812[(1)] = (98));

} else {
var statearr_25625_25813 = state_25582__$1;
(statearr_25625_25813[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (54))){
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25364 = (state_25582[(50)]);
var inst_25362 = (state_25582[(14)]);
var inst_25244 = (state_25582[(15)]);
var inst_25236 = (state_25582[(20)]);
var inst_25322 = (state_25582[(22)]);
var inst_25358 = (state_25582[(24)]);
var inst_25237 = (state_25582[(28)]);
var inst_25268 = (state_25582[(30)]);
var inst_25331 = (state_25582[(33)]);
var inst_25349 = (state_25582[(36)]);
var inst_25313 = (state_25582[(43)]);
var inst_25340 = (state_25582[(46)]);
var inst_25358__$1 = (state_25582[(2)]);
var inst_25359 = fluree.db.flake.__GT_Flake(inst_25259,inst_25331,inst_25313,inst_25236,inst_25237,inst_25349);
var inst_25360 = fluree.db.flake.__GT_Flake(inst_25268,inst_25340,inst_25322,inst_25243,inst_25244,inst_25358__$1);
var inst_25361 = opts;
var inst_25362__$1 = cljs.core.__destructure_map(inst_25361);
var inst_25363 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_25362__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_25364__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25362__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25365 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_25362__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_25582__$1 = (function (){var statearr_25626 = state_25582;
(statearr_25626[(50)] = inst_25364__$1);

(statearr_25626[(14)] = inst_25362__$1);

(statearr_25626[(24)] = inst_25358__$1);

(statearr_25626[(25)] = inst_25363);

(statearr_25626[(31)] = inst_25360);

(statearr_25626[(71)] = inst_25365);

(statearr_25626[(44)] = inst_25359);

return statearr_25626;
})();
if(cljs.core.truth_(inst_25364__$1)){
var statearr_25627_25814 = state_25582__$1;
(statearr_25627_25814[(1)] = (58));

} else {
var statearr_25628_25815 = state_25582__$1;
(statearr_25628_25815[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (92))){
var inst_25458 = (state_25582[(72)]);
var inst_25402 = (state_25582[(21)]);
var inst_25400 = (state_25582[(26)]);
var inst_25403 = (state_25582[(45)]);
var inst_25401 = (state_25582[(48)]);
var inst_25461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25462 = (inst_25400 - inst_25458);
var inst_25463 = [inst_25462,inst_25401,inst_25402,inst_25403];
var inst_25464 = (new cljs.core.PersistentVector(null,4,(5),inst_25461,inst_25463,null));
var state_25582__$1 = state_25582;
var statearr_25629_25816 = state_25582__$1;
(statearr_25629_25816[(2)] = inst_25464);

(statearr_25629_25816[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (104))){
var inst_25520 = (state_25582[(2)]);
var inst_25521 = fluree.db.util.async.throw_err(inst_25520);
var state_25582__$1 = state_25582;
var statearr_25630_25817 = state_25582__$1;
(statearr_25630_25817[(2)] = inst_25521);

(statearr_25630_25817[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (15))){
var inst_25242 = (state_25582[(56)]);
var inst_25272 = cljs.core.boolean_QMARK_(inst_25242);
var state_25582__$1 = state_25582;
if(inst_25272){
var statearr_25631_25818 = state_25582__$1;
(statearr_25631_25818[(1)] = (17));

} else {
var statearr_25632_25819 = state_25582__$1;
(statearr_25632_25819[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (48))){
var inst_25245 = (state_25582[(62)]);
var inst_25349 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25633 = state_25582;
(statearr_25633[(36)] = inst_25349);

return statearr_25633;
})();
if(cljs.core.truth_(inst_25245)){
var statearr_25634_25820 = state_25582__$1;
(statearr_25634_25820[(1)] = (52));

} else {
var statearr_25635_25821 = state_25582__$1;
(statearr_25635_25821[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (50))){
var state_25582__$1 = state_25582;
var statearr_25636_25822 = state_25582__$1;
(statearr_25636_25822[(2)] = (2147483647));

(statearr_25636_25822[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (116))){
var inst_25554 = (state_25582[(66)]);
var inst_25562 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25637 = state_25582;
(statearr_25637[(73)] = inst_25562);

return statearr_25637;
})();
if(cljs.core.truth_(inst_25554)){
var statearr_25638_25823 = state_25582__$1;
(statearr_25638_25823[(1)] = (118));

} else {
var statearr_25639_25824 = state_25582__$1;
(statearr_25639_25824[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (75))){
var inst_25417 = (state_25582[(32)]);
var state_25582__$1 = state_25582;
var statearr_25640_25825 = state_25582__$1;
(statearr_25640_25825[(2)] = inst_25417);

(statearr_25640_25825[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (99))){
var inst_25478 = (state_25582[(67)]);
var inst_25487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25488 = [inst_25478,inst_25478];
var inst_25489 = (new cljs.core.PersistentVector(null,2,(5),inst_25487,inst_25488,null));
var state_25582__$1 = state_25582;
var statearr_25641_25826 = state_25582__$1;
(statearr_25641_25826[(2)] = inst_25489);

(statearr_25641_25826[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (21))){
var state_25582__$1 = state_25582;
var statearr_25642_25827 = state_25582__$1;
(statearr_25642_25827[(2)] = null);

(statearr_25642_25827[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (31))){
var inst_25303 = (state_25582[(74)]);
var state_25582__$1 = state_25582;
var statearr_25643_25828 = state_25582__$1;
(statearr_25643_25828[(2)] = inst_25303);

(statearr_25643_25828[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (113))){
var inst_25548 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25644_25829 = state_25582__$1;
(statearr_25644_25829[(2)] = inst_25548);

(statearr_25644_25829[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (32))){
var inst_25234 = (state_25582[(57)]);
var inst_25323 = (state_25582[(75)]);
var inst_25322 = (state_25582[(2)]);
var inst_25323__$1 = (inst_25234 == null);
var state_25582__$1 = (function (){var statearr_25645 = state_25582;
(statearr_25645[(22)] = inst_25322);

(statearr_25645[(75)] = inst_25323__$1);

return statearr_25645;
})();
if(cljs.core.truth_(inst_25323__$1)){
var statearr_25646_25830 = state_25582__$1;
(statearr_25646_25830[(1)] = (34));

} else {
var statearr_25647_25831 = state_25582__$1;
(statearr_25647_25831[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (40))){
var inst_25322 = (state_25582[(22)]);
var state_25582__$1 = state_25582;
var statearr_25648_25832 = state_25582__$1;
(statearr_25648_25832[(2)] = inst_25322);

(statearr_25648_25832[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (91))){
var inst_25436 = (state_25582[(65)]);
var inst_25534 = (state_25582[(2)]);
var inst_25535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25534,(0),null);
var inst_25536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25534,(1),null);
var inst_25537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25534,(2),null);
var inst_25538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25534,(3),null);
var state_25582__$1 = (function (){var statearr_25649 = state_25582;
(statearr_25649[(76)] = inst_25537);

(statearr_25649[(7)] = inst_25538);

(statearr_25649[(77)] = inst_25535);

(statearr_25649[(78)] = inst_25536);

return statearr_25649;
})();
if(cljs.core.truth_(inst_25436)){
var statearr_25650_25833 = state_25582__$1;
(statearr_25650_25833[(1)] = (105));

} else {
var statearr_25651_25834 = state_25582__$1;
(statearr_25651_25834[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (117))){
var inst_25558 = (state_25582[(2)]);
var inst_25559 = fluree.db.util.async.throw_err(inst_25558);
var state_25582__$1 = state_25582;
var statearr_25652_25835 = state_25582__$1;
(statearr_25652_25835[(2)] = inst_25559);

(statearr_25652_25835[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (108))){
var inst_25543 = (state_25582[(79)]);
var inst_25363 = (state_25582[(25)]);
var inst_25536 = (state_25582[(78)]);
var inst_25543__$1 = (inst_25536 < inst_25363);
var state_25582__$1 = (function (){var statearr_25653 = state_25582;
(statearr_25653[(79)] = inst_25543__$1);

return statearr_25653;
})();
if(cljs.core.truth_(inst_25543__$1)){
var statearr_25654_25836 = state_25582__$1;
(statearr_25654_25836[(1)] = (111));

} else {
var statearr_25655_25837 = state_25582__$1;
(statearr_25655_25837[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (56))){
var state_25582__$1 = state_25582;
var statearr_25656_25838 = state_25582__$1;
(statearr_25656_25838[(2)] = fluree.db.util.core.min_integer);

(statearr_25656_25838[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (33))){
var inst_25318 = (state_25582[(2)]);
var inst_25319 = fluree.db.util.async.throw_err(inst_25318);
var state_25582__$1 = state_25582;
var statearr_25657_25839 = state_25582__$1;
(statearr_25657_25839[(2)] = inst_25319);

(statearr_25657_25839[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (13))){
var inst_25264 = (state_25582[(2)]);
var inst_25265 = fluree.db.util.async.throw_err(inst_25264);
var state_25582__$1 = state_25582;
var statearr_25658_25840 = state_25582__$1;
(statearr_25658_25840[(2)] = inst_25265);

(statearr_25658_25840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (22))){
var inst_25278 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25659_25841 = state_25582__$1;
(statearr_25659_25841[(2)] = inst_25278);

(statearr_25659_25841[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (90))){
var inst_25375 = (state_25582[(10)]);
var inst_25458 = (state_25582[(72)]);
var inst_25399 = (state_25582[(11)]);
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25396 = (state_25582[(9)]);
var inst_25362 = (state_25582[(14)]);
var inst_25436 = (state_25582[(65)]);
var inst_25244 = (state_25582[(15)]);
var inst_25301 = (state_25582[(16)]);
var inst_25371 = (state_25582[(17)]);
var inst_25380 = (state_25582[(18)]);
var inst_25300 = (state_25582[(19)]);
var inst_25236 = (state_25582[(20)]);
var inst_25402 = (state_25582[(21)]);
var inst_25322 = (state_25582[(22)]);
var inst_25370 = (state_25582[(23)]);
var inst_25358 = (state_25582[(24)]);
var inst_25363 = (state_25582[(25)]);
var inst_25400 = (state_25582[(26)]);
var inst_25376 = (state_25582[(27)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25360 = (state_25582[(31)]);
var inst_25331 = (state_25582[(33)]);
var inst_25304 = (state_25582[(34)]);
var inst_25232 = (state_25582[(35)]);
var inst_25349 = (state_25582[(36)]);
var inst_25390 = (state_25582[(8)]);
var inst_25248 = (state_25582[(37)]);
var inst_25369 = (state_25582[(38)]);
var inst_25381 = (state_25582[(39)]);
var inst_25409 = (state_25582[(40)]);
var inst_25386 = (state_25582[(41)]);
var inst_25249 = (state_25582[(42)]);
var inst_25313 = (state_25582[(43)]);
var inst_25457 = (state_25582[(80)]);
var inst_25359 = (state_25582[(44)]);
var inst_25403 = (state_25582[(45)]);
var inst_25340 = (state_25582[(46)]);
var inst_25239 = (state_25582[(47)]);
var inst_25435 = (state_25582[(81)]);
var inst_25401 = (state_25582[(48)]);
var inst_25456 = (function (){var no_filter_QMARK_ = inst_25396;
var base_result_SINGLEQUOTE_ = inst_25435;
var t = inst_25376;
var max_limit_QMARK_ = inst_25370;
var next_node = inst_25399;
var fast_forward_db_QMARK_ = inst_25381;
var s1 = inst_25259;
var o2 = inst_25322;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var i = inst_25401;
var rhs = inst_25436;
var m1 = inst_25349;
var root_node = inst_25386;
var s2 = inst_25268;
var p2 = inst_25340;
var map__25224 = inst_25247;
var permissions = inst_25371;
var limit = inst_25369;
var start_flake = inst_25359;
var vec__25218 = inst_25232;
var flake_limit = inst_25363;
var offset = inst_25400;
var acc = inst_25403;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25313;
var end_flake = inst_25360;
var base_result = inst_25409;
var s = inst_25402;
var node_start = inst_25390;
var p1 = inst_25331;
var subject_fn = inst_25248;
var vec__25225 = inst_25300;
var object_fn = inst_25304;
var idx_compare = inst_25375;
var map__25231 = inst_25362;
var vec__25228 = inst_25301;
var op2 = inst_25244;
var m2 = inst_25358;
var novelty = inst_25380;
return (function (p1__25203_SHARP_){
return p1__25203_SHARP_.s;
});
})();
var inst_25457__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_25456,inst_25435);
var inst_25458__$1 = cljs.core.count(inst_25457__$1);
var inst_25459 = (inst_25400 > inst_25458__$1);
var state_25582__$1 = (function (){var statearr_25660 = state_25582;
(statearr_25660[(72)] = inst_25458__$1);

(statearr_25660[(80)] = inst_25457__$1);

return statearr_25660;
})();
if(cljs.core.truth_(inst_25459)){
var statearr_25661_25842 = state_25582__$1;
(statearr_25661_25842[(1)] = (92));

} else {
var statearr_25662_25843 = state_25582__$1;
(statearr_25662_25843[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (109))){
var inst_25541 = (state_25582[(82)]);
var state_25582__$1 = state_25582;
var statearr_25663_25844 = state_25582__$1;
(statearr_25663_25844[(2)] = inst_25541);

(statearr_25663_25844[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (36))){
var inst_25327 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
if(cljs.core.truth_(inst_25327)){
var statearr_25664_25845 = state_25582__$1;
(statearr_25664_25845[(1)] = (37));

} else {
var statearr_25665_25846 = state_25582__$1;
(statearr_25665_25846[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (41))){
var inst_25332 = (state_25582[(63)]);
var state_25582__$1 = state_25582;
var statearr_25666_25847 = state_25582__$1;
(statearr_25666_25847[(2)] = inst_25332);

(statearr_25666_25847[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (118))){
var inst_25562 = (state_25582[(73)]);
var state_25582__$1 = state_25582;
var statearr_25667_25848 = state_25582__$1;
(statearr_25667_25848[(2)] = inst_25562);

(statearr_25667_25848[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (89))){
var inst_25402 = (state_25582[(21)]);
var inst_25363 = (state_25582[(25)]);
var inst_25403 = (state_25582[(45)]);
var inst_25435 = (state_25582[(81)]);
var inst_25401 = (state_25582[(48)]);
var inst_25447 = cljs.core.count(inst_25435);
var inst_25448 = (inst_25363 - inst_25401);
var inst_25449 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25448,inst_25435);
var inst_25450 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25403,inst_25449);
var inst_25451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25452 = (inst_25401 + inst_25447);
var inst_25453 = [(0),inst_25452,inst_25402,inst_25450];
var inst_25454 = (new cljs.core.PersistentVector(null,4,(5),inst_25451,inst_25453,null));
var state_25582__$1 = state_25582;
var statearr_25668_25849 = state_25582__$1;
(statearr_25668_25849[(2)] = inst_25454);

(statearr_25668_25849[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (100))){
var inst_25495 = (state_25582[(52)]);
var inst_25363 = (state_25582[(25)]);
var inst_25469 = (state_25582[(70)]);
var inst_25497 = (state_25582[(53)]);
var inst_25496 = (state_25582[(54)]);
var inst_25401 = (state_25582[(48)]);
var inst_25491 = (state_25582[(2)]);
var inst_25492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25491,(0),null);
var inst_25493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25491,(1),null);
var inst_25494 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25493,inst_25469);
var inst_25495__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_25494);
var inst_25496__$1 = cljs.core.count(inst_25495__$1);
var inst_25497__$1 = (inst_25401 + inst_25496__$1);
var inst_25498 = (inst_25497__$1 > inst_25363);
var state_25582__$1 = (function (){var statearr_25669 = state_25582;
(statearr_25669[(52)] = inst_25495__$1);

(statearr_25669[(83)] = inst_25492);

(statearr_25669[(53)] = inst_25497__$1);

(statearr_25669[(54)] = inst_25496__$1);

return statearr_25669;
})();
if(cljs.core.truth_(inst_25498)){
var statearr_25670_25850 = state_25582__$1;
(statearr_25670_25850[(1)] = (101));

} else {
var statearr_25671_25851 = state_25582__$1;
(statearr_25671_25851[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (122))){
var inst_25537 = (state_25582[(76)]);
var inst_25538 = (state_25582[(7)]);
var inst_25562 = (state_25582[(73)]);
var inst_25535 = (state_25582[(77)]);
var inst_25536 = (state_25582[(78)]);
var inst_25399 = inst_25562;
var inst_25400 = inst_25535;
var inst_25401 = inst_25536;
var inst_25402 = inst_25537;
var inst_25403 = inst_25538;
var state_25582__$1 = (function (){var statearr_25672 = state_25582;
(statearr_25672[(11)] = inst_25399);

(statearr_25672[(21)] = inst_25402);

(statearr_25672[(26)] = inst_25400);

(statearr_25672[(45)] = inst_25403);

(statearr_25672[(48)] = inst_25401);

return statearr_25672;
})();
var statearr_25673_25852 = state_25582__$1;
(statearr_25673_25852[(2)] = null);

(statearr_25673_25852[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (43))){
var state_25582__$1 = state_25582;
var statearr_25674_25853 = state_25582__$1;
(statearr_25674_25853[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25674_25853[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (61))){
var inst_25380 = (state_25582[(18)]);
var inst_25376 = (state_25582[(27)]);
var inst_25381 = (state_25582[(39)]);
var inst_25386 = (state_25582[(41)]);
var inst_25359 = (state_25582[(44)]);
var inst_25385 = (state_25582[(2)]);
var inst_25386__$1 = fluree.db.util.async.throw_err(inst_25385);
var inst_25387 = fluree.db.query.range.find_next_valid_node(inst_25386__$1,inst_25359,inst_25376,inst_25380,inst_25381);
var state_25582__$1 = (function (){var statearr_25675 = state_25582;
(statearr_25675[(41)] = inst_25386__$1);

return statearr_25675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(62),inst_25387);
} else {
if((state_val_25583 === (29))){
var inst_25309 = (state_25582[(2)]);
var inst_25310 = fluree.db.util.async.throw_err(inst_25309);
var state_25582__$1 = state_25582;
var statearr_25676_25854 = state_25582__$1;
(statearr_25676_25854[(2)] = inst_25310);

(statearr_25676_25854[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (44))){
var inst_25241 = (state_25582[(60)]);
var state_25582__$1 = state_25582;
var statearr_25677_25855 = state_25582__$1;
(statearr_25677_25855[(2)] = inst_25241);

(statearr_25677_25855[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (93))){
var inst_25396 = (state_25582[(9)]);
var inst_25400 = (state_25582[(26)]);
var inst_25457 = (state_25582[(80)]);
var inst_25469 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25400,inst_25457);
var state_25582__$1 = (function (){var statearr_25678 = state_25582;
(statearr_25678[(70)] = inst_25469);

return statearr_25678;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25679_25856 = state_25582__$1;
(statearr_25679_25856[(1)] = (95));

} else {
var statearr_25680_25857 = state_25582__$1;
(statearr_25680_25857[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (6))){
var inst_25233 = (state_25582[(49)]);
var inst_25253 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25233);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(9),inst_25253);
} else {
if((state_val_25583 === (111))){
var inst_25537 = (state_25582[(76)]);
var inst_25369 = (state_25582[(38)]);
var inst_25545 = (inst_25537 < inst_25369);
var state_25582__$1 = state_25582;
var statearr_25681_25858 = state_25582__$1;
(statearr_25681_25858[(2)] = inst_25545);

(statearr_25681_25858[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (28))){
var inst_25303 = (state_25582[(74)]);
var inst_25313 = (state_25582[(2)]);
var inst_25314 = fluree.db.util.core.pred_ident_QMARK_(inst_25303);
var state_25582__$1 = (function (){var statearr_25682 = state_25582;
(statearr_25682[(43)] = inst_25313);

return statearr_25682;
})();
if(inst_25314){
var statearr_25683_25859 = state_25582__$1;
(statearr_25683_25859[(1)] = (30));

} else {
var statearr_25684_25860 = state_25582__$1;
(statearr_25684_25860[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (64))){
var state_25582__$1 = state_25582;
var statearr_25685_25861 = state_25582__$1;
(statearr_25685_25861[(2)] = true);

(statearr_25685_25861[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (103))){
var inst_25492 = (state_25582[(83)]);
var inst_25511 = (state_25582[(2)]);
var inst_25512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25511,(0),null);
var inst_25513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25511,(1),null);
var inst_25514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25515 = [inst_25512,inst_25492,inst_25513];
var inst_25516 = (new cljs.core.PersistentVector(null,3,(5),inst_25514,inst_25515,null));
var state_25582__$1 = state_25582;
var statearr_25686_25862 = state_25582__$1;
(statearr_25686_25862[(2)] = inst_25516);

(statearr_25686_25862[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (51))){
var inst_25347 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25687_25863 = state_25582__$1;
(statearr_25687_25863[(2)] = inst_25347);

(statearr_25687_25863[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (25))){
var inst_25301 = (state_25582[(16)]);
var inst_25300 = (state_25582[(19)]);
var inst_25302 = (state_25582[(51)]);
var inst_25300__$1 = (state_25582[(2)]);
var inst_25301__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25300__$1,(0),null);
var inst_25302__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25301__$1,(0),null);
var inst_25303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25301__$1,(1),null);
var inst_25304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25300__$1,(1),null);
var inst_25305 = fluree.db.util.core.pred_ident_QMARK_(inst_25302__$1);
var state_25582__$1 = (function (){var statearr_25688 = state_25582;
(statearr_25688[(16)] = inst_25301__$1);

(statearr_25688[(19)] = inst_25300__$1);

(statearr_25688[(51)] = inst_25302__$1);

(statearr_25688[(34)] = inst_25304);

(statearr_25688[(74)] = inst_25303);

return statearr_25688;
})();
if(inst_25305){
var statearr_25689_25864 = state_25582__$1;
(statearr_25689_25864[(1)] = (26));

} else {
var statearr_25690_25865 = state_25582__$1;
(statearr_25690_25865[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (34))){
var inst_25313 = (state_25582[(43)]);
var state_25582__$1 = state_25582;
var statearr_25691_25866 = state_25582__$1;
(statearr_25691_25866[(2)] = inst_25313);

(statearr_25691_25866[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (17))){
var inst_25242 = (state_25582[(56)]);
var state_25582__$1 = state_25582;
var statearr_25692_25867 = state_25582__$1;
(statearr_25692_25867[(2)] = inst_25242);

(statearr_25692_25867[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (3))){
var inst_25580 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25582__$1,inst_25580);
} else {
if((state_val_25583 === (12))){
var inst_25235 = (state_25582[(58)]);
var inst_25268 = (state_25582[(2)]);
var inst_25269 = cljs.core.boolean_QMARK_(inst_25235);
var state_25582__$1 = (function (){var statearr_25693 = state_25582;
(statearr_25693[(30)] = inst_25268);

return statearr_25693;
})();
if(inst_25269){
var statearr_25694_25868 = state_25582__$1;
(statearr_25694_25868[(1)] = (14));

} else {
var statearr_25695_25869 = state_25582__$1;
(statearr_25695_25869[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (2))){
var inst_25247 = (state_25582[(29)]);
var inst_25232 = (state_25582[(35)]);
var inst_25233 = (state_25582[(49)]);
var inst_25239 = (state_25582[(47)]);
var _ = (function (){var statearr_25696 = state_25582;
(statearr_25696[(4)] = cljs.core.cons((5),(state_25582[(4)])));

return statearr_25696;
})();
var inst_25232__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_25233__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(0),null);
var inst_25234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(1),null);
var inst_25235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(2),null);
var inst_25236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(3),null);
var inst_25237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(4),null);
var inst_25238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25232__$1,(5),null);
var inst_25239__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_25240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(0),null);
var inst_25241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(1),null);
var inst_25242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(2),null);
var inst_25243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(3),null);
var inst_25244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(4),null);
var inst_25245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25239__$1,(5),null);
var inst_25246 = opts;
var inst_25247__$1 = cljs.core.__destructure_map(inst_25246);
var inst_25248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25247__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_25249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25247__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_25250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25247__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_25251 = fluree.db.util.core.pred_ident_QMARK_(inst_25233__$1);
var state_25582__$1 = (function (){var statearr_25697 = state_25582;
(statearr_25697[(55)] = inst_25238);

(statearr_25697[(56)] = inst_25242);

(statearr_25697[(57)] = inst_25234);

(statearr_25697[(13)] = inst_25243);

(statearr_25697[(15)] = inst_25244);

(statearr_25697[(58)] = inst_25235);

(statearr_25697[(20)] = inst_25236);

(statearr_25697[(59)] = inst_25250);

(statearr_25697[(60)] = inst_25241);

(statearr_25697[(28)] = inst_25237);

(statearr_25697[(29)] = inst_25247__$1);

(statearr_25697[(62)] = inst_25245);

(statearr_25697[(35)] = inst_25232__$1);

(statearr_25697[(37)] = inst_25248);

(statearr_25697[(49)] = inst_25233__$1);

(statearr_25697[(84)] = inst_25240);

(statearr_25697[(42)] = inst_25249);

(statearr_25697[(47)] = inst_25239__$1);

return statearr_25697;
})();
if(inst_25251){
var statearr_25698_25870 = state_25582__$1;
(statearr_25698_25870[(1)] = (6));

} else {
var statearr_25699_25871 = state_25582__$1;
(statearr_25699_25871[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (66))){
var inst_25390 = (state_25582[(8)]);
var inst_25365 = (state_25582[(71)]);
var inst_25398 = cljs.core.PersistentVector.EMPTY;
var inst_25399 = inst_25390;
var inst_25400 = inst_25365;
var inst_25401 = (0);
var inst_25402 = (0);
var inst_25403 = inst_25398;
var state_25582__$1 = (function (){var statearr_25700 = state_25582;
(statearr_25700[(11)] = inst_25399);

(statearr_25700[(21)] = inst_25402);

(statearr_25700[(26)] = inst_25400);

(statearr_25700[(45)] = inst_25403);

(statearr_25700[(48)] = inst_25401);

return statearr_25700;
})();
var statearr_25701_25872 = state_25582__$1;
(statearr_25701_25872[(2)] = null);

(statearr_25701_25872[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (107))){
var inst_25554 = (state_25582[(66)]);
var inst_25554__$1 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25702 = state_25582;
(statearr_25702[(66)] = inst_25554__$1);

return statearr_25702;
})();
if(cljs.core.truth_(inst_25554__$1)){
var statearr_25703_25873 = state_25582__$1;
(statearr_25703_25873[(1)] = (114));

} else {
var statearr_25704_25874 = state_25582__$1;
(statearr_25704_25874[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (23))){
var inst_25242 = (state_25582[(56)]);
var inst_25235 = (state_25582[(58)]);
var inst_25250 = (state_25582[(59)]);
var inst_25285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25287 = [inst_25235,inst_25242];
var inst_25288 = (new cljs.core.PersistentVector(null,2,(5),inst_25286,inst_25287,null));
var inst_25289 = [inst_25288,inst_25250];
var inst_25290 = (new cljs.core.PersistentVector(null,2,(5),inst_25285,inst_25289,null));
var state_25582__$1 = state_25582;
var statearr_25705_25875 = state_25582__$1;
(statearr_25705_25875[(2)] = inst_25290);

(statearr_25705_25875[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (47))){
var inst_25343 = (cljs.core._GT__EQ_ === start_test);
var state_25582__$1 = state_25582;
if(cljs.core.truth_(inst_25343)){
var statearr_25706_25876 = state_25582__$1;
(statearr_25706_25876[(1)] = (49));

} else {
var statearr_25707_25877 = state_25582__$1;
(statearr_25707_25877[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (35))){
var inst_25323 = (state_25582[(75)]);
var state_25582__$1 = state_25582;
var statearr_25708_25878 = state_25582__$1;
(statearr_25708_25878[(2)] = inst_25323);

(statearr_25708_25878[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (82))){
var inst_25399 = (state_25582[(11)]);
var inst_25370 = (state_25582[(23)]);
var inst_25435 = (state_25582[(2)]);
var inst_25436 = fluree.db.dbproto._rhs(inst_25399);
var state_25582__$1 = (function (){var statearr_25709 = state_25582;
(statearr_25709[(65)] = inst_25436);

(statearr_25709[(81)] = inst_25435);

return statearr_25709;
})();
if(cljs.core.truth_(inst_25370)){
var statearr_25710_25879 = state_25582__$1;
(statearr_25710_25879[(1)] = (83));

} else {
var statearr_25711_25880 = state_25582__$1;
(statearr_25711_25880[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (76))){
var inst_25249 = (state_25582[(42)]);
var inst_25423 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25712 = state_25582;
(statearr_25712[(64)] = inst_25423);

return statearr_25712;
})();
if(cljs.core.truth_(inst_25249)){
var statearr_25713_25881 = state_25582__$1;
(statearr_25713_25881[(1)] = (77));

} else {
var statearr_25714_25882 = state_25582__$1;
(statearr_25714_25882[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (97))){
var inst_25403 = (state_25582[(45)]);
var inst_25523 = (state_25582[(2)]);
var inst_25524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25523,(0),null);
var inst_25525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25523,(1),null);
var inst_25526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25523,(2),null);
var inst_25527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25528 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25403,inst_25526);
var inst_25529 = [(0),inst_25524,inst_25525,inst_25528];
var inst_25530 = (new cljs.core.PersistentVector(null,4,(5),inst_25527,inst_25529,null));
var state_25582__$1 = state_25582;
var statearr_25715_25883 = state_25582__$1;
(statearr_25715_25883[(2)] = inst_25530);

(statearr_25715_25883[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (19))){
var inst_25280 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25716_25884 = state_25582__$1;
(statearr_25716_25884[(2)] = inst_25280);

(statearr_25716_25884[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (57))){
var inst_25356 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25717_25885 = state_25582__$1;
(statearr_25717_25885[(2)] = inst_25356);

(statearr_25717_25885[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (68))){
var inst_25577 = (state_25582[(2)]);
var _ = (function (){var statearr_25718 = state_25582;
(statearr_25718[(4)] = cljs.core.rest((state_25582[(4)])));

return statearr_25718;
})();
var state_25582__$1 = state_25582;
var statearr_25719_25886 = state_25582__$1;
(statearr_25719_25886[(2)] = inst_25577);

(statearr_25719_25886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (11))){
var inst_25240 = (state_25582[(84)]);
var state_25582__$1 = state_25582;
var statearr_25720_25887 = state_25582__$1;
(statearr_25720_25887[(2)] = inst_25240);

(statearr_25720_25887[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (115))){
var state_25582__$1 = state_25582;
var statearr_25722_25888 = state_25582__$1;
(statearr_25722_25888[(2)] = null);

(statearr_25722_25888[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (9))){
var inst_25255 = (state_25582[(2)]);
var inst_25256 = fluree.db.util.async.throw_err(inst_25255);
var state_25582__$1 = state_25582;
var statearr_25723_25889 = state_25582__$1;
(statearr_25723_25889[(2)] = inst_25256);

(statearr_25723_25889[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (5))){
var _ = (function (){var statearr_25724 = state_25582;
(statearr_25724[(4)] = cljs.core.rest((state_25582[(4)])));

return statearr_25724;
})();
var state_25582__$1 = state_25582;
var ex25721 = (state_25582__$1[(2)]);
var statearr_25725_25890 = state_25582__$1;
(statearr_25725_25890[(5)] = ex25721);


if((ex25721 instanceof Error)){
var statearr_25726_25891 = state_25582__$1;
(statearr_25726_25891[(1)] = (4));

(statearr_25726_25891[(5)] = null);

} else {
throw ex25721;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (112))){
var inst_25543 = (state_25582[(79)]);
var state_25582__$1 = state_25582;
var statearr_25727_25892 = state_25582__$1;
(statearr_25727_25892[(2)] = inst_25543);

(statearr_25727_25892[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (83))){
var inst_25400 = (state_25582[(26)]);
var inst_25438 = (state_25582[(85)]);
var inst_25438__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_25400);
var state_25582__$1 = (function (){var statearr_25728 = state_25582;
(statearr_25728[(85)] = inst_25438__$1);

return statearr_25728;
})();
if(inst_25438__$1){
var statearr_25729_25893 = state_25582__$1;
(statearr_25729_25893[(1)] = (86));

} else {
var statearr_25730_25894 = state_25582__$1;
(statearr_25730_25894[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (14))){
var inst_25235 = (state_25582[(58)]);
var state_25582__$1 = state_25582;
var statearr_25731_25895 = state_25582__$1;
(statearr_25731_25895[(2)] = inst_25235);

(statearr_25731_25895[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (45))){
var inst_25238 = (state_25582[(55)]);
var inst_25340 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25732 = state_25582;
(statearr_25732[(46)] = inst_25340);

return statearr_25732;
})();
if(cljs.core.truth_(inst_25238)){
var statearr_25733_25896 = state_25582__$1;
(statearr_25733_25896[(1)] = (46));

} else {
var statearr_25734_25897 = state_25582__$1;
(statearr_25734_25897[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (53))){
var inst_25352 = (cljs.core._LT__EQ_ === end_test);
var state_25582__$1 = state_25582;
if(cljs.core.truth_(inst_25352)){
var statearr_25735_25898 = state_25582__$1;
(statearr_25735_25898[(1)] = (55));

} else {
var statearr_25736_25899 = state_25582__$1;
(statearr_25736_25899[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (78))){
var inst_25423 = (state_25582[(64)]);
var state_25582__$1 = state_25582;
var statearr_25737_25900 = state_25582__$1;
(statearr_25737_25900[(2)] = inst_25423);

(statearr_25737_25900[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (26))){
var inst_25302 = (state_25582[(51)]);
var inst_25307 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25302);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(29),inst_25307);
} else {
if((state_val_25583 === (123))){
var inst_25572 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25738_25901 = state_25582__$1;
(statearr_25738_25901[(2)] = inst_25572);

(statearr_25738_25901[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (16))){
var inst_25282 = (state_25582[(61)]);
var inst_25282__$1 = (state_25582[(2)]);
var inst_25283 = (inst_25282__$1 == null);
var state_25582__$1 = (function (){var statearr_25739 = state_25582;
(statearr_25739[(61)] = inst_25282__$1);

return statearr_25739;
})();
if(cljs.core.truth_(inst_25283)){
var statearr_25740_25902 = state_25582__$1;
(statearr_25740_25902[(1)] = (23));

} else {
var statearr_25741_25903 = state_25582__$1;
(statearr_25741_25903[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (81))){
var inst_25429 = (state_25582[(86)]);
var state_25582__$1 = state_25582;
var statearr_25742_25904 = state_25582__$1;
(statearr_25742_25904[(2)] = inst_25429);

(statearr_25742_25904[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (120))){
var inst_25566 = (state_25582[(2)]);
var inst_25567 = cljs.core.not(inst_25566);
var state_25582__$1 = state_25582;
if(inst_25567){
var statearr_25743_25905 = state_25582__$1;
(statearr_25743_25905[(1)] = (121));

} else {
var statearr_25744_25906 = state_25582__$1;
(statearr_25744_25906[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (79))){
var inst_25304 = (state_25582[(34)]);
var inst_25429 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25745 = state_25582;
(statearr_25745[(86)] = inst_25429);

return statearr_25745;
})();
if(cljs.core.truth_(inst_25304)){
var statearr_25746_25907 = state_25582__$1;
(statearr_25746_25907[(1)] = (80));

} else {
var statearr_25747_25908 = state_25582__$1;
(statearr_25747_25908[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (38))){
var inst_25234 = (state_25582[(57)]);
var state_25582__$1 = state_25582;
var statearr_25748_25909 = state_25582__$1;
(statearr_25748_25909[(2)] = inst_25234);

(statearr_25748_25909[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (98))){
var inst_25477 = (state_25582[(68)]);
var inst_25479 = (state_25582[(69)]);
var inst_25369 = (state_25582[(38)]);
var inst_25482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25483 = (inst_25477 - inst_25479);
var inst_25484 = [inst_25369,inst_25483];
var inst_25485 = (new cljs.core.PersistentVector(null,2,(5),inst_25482,inst_25484,null));
var state_25582__$1 = state_25582;
var statearr_25749_25910 = state_25582__$1;
(statearr_25749_25910[(2)] = inst_25485);

(statearr_25749_25910[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (87))){
var inst_25438 = (state_25582[(85)]);
var state_25582__$1 = state_25582;
var statearr_25750_25911 = state_25582__$1;
(statearr_25750_25911[(2)] = inst_25438);

(statearr_25750_25911[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (30))){
var inst_25303 = (state_25582[(74)]);
var inst_25316 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25303);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(33),inst_25316);
} else {
if((state_val_25583 === (73))){
var inst_25248 = (state_25582[(37)]);
var inst_25417 = (state_25582[(2)]);
var state_25582__$1 = (function (){var statearr_25751 = state_25582;
(statearr_25751[(32)] = inst_25417);

return statearr_25751;
})();
if(cljs.core.truth_(inst_25248)){
var statearr_25752_25912 = state_25582__$1;
(statearr_25752_25912[(1)] = (74));

} else {
var statearr_25753_25913 = state_25582__$1;
(statearr_25753_25913[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (96))){
var inst_25402 = (state_25582[(21)]);
var inst_25363 = (state_25582[(25)]);
var inst_25469 = (state_25582[(70)]);
var inst_25369 = (state_25582[(38)]);
var inst_25401 = (state_25582[(48)]);
var inst_25518 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_25469,inst_25401,inst_25402,inst_25363,inst_25369);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(104),inst_25518);
} else {
if((state_val_25583 === (10))){
var inst_25240 = (state_25582[(84)]);
var inst_25262 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25240);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(13),inst_25262);
} else {
if((state_val_25583 === (18))){
var state_25582__$1 = state_25582;
var statearr_25754_25914 = state_25582__$1;
(statearr_25754_25914[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (105))){
var inst_25375 = (state_25582[(10)]);
var inst_25436 = (state_25582[(65)]);
var inst_25541 = (state_25582[(82)]);
var inst_25360 = (state_25582[(31)]);
var inst_25540 = (inst_25375.cljs$core$IFn$_invoke$arity$2 ? inst_25375.cljs$core$IFn$_invoke$arity$2(inst_25436,inst_25360) : inst_25375.call(null,inst_25436,inst_25360));
var inst_25541__$1 = (inst_25540 < (0));
var state_25582__$1 = (function (){var statearr_25756 = state_25582;
(statearr_25756[(82)] = inst_25541__$1);

return statearr_25756;
})();
if(cljs.core.truth_(inst_25541__$1)){
var statearr_25757_25915 = state_25582__$1;
(statearr_25757_25915[(1)] = (108));

} else {
var statearr_25758_25916 = state_25582__$1;
(statearr_25758_25916[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (52))){
var inst_25245 = (state_25582[(62)]);
var state_25582__$1 = state_25582;
var statearr_25759_25917 = state_25582__$1;
(statearr_25759_25917[(2)] = inst_25245);

(statearr_25759_25917[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (114))){
var inst_25436 = (state_25582[(65)]);
var inst_25380 = (state_25582[(18)]);
var inst_25376 = (state_25582[(27)]);
var inst_25381 = (state_25582[(39)]);
var inst_25386 = (state_25582[(41)]);
var inst_25556 = fluree.db.query.range.find_next_valid_node(inst_25386,inst_25436,inst_25376,inst_25380,inst_25381);
var state_25582__$1 = state_25582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25582__$1,(117),inst_25556);
} else {
if((state_val_25583 === (67))){
var state_25582__$1 = state_25582;
var statearr_25760_25918 = state_25582__$1;
(statearr_25760_25918[(2)] = null);

(statearr_25760_25918[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (71))){
var inst_25375 = (state_25582[(10)]);
var inst_25399 = (state_25582[(11)]);
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25396 = (state_25582[(9)]);
var inst_25362 = (state_25582[(14)]);
var inst_25244 = (state_25582[(15)]);
var inst_25301 = (state_25582[(16)]);
var inst_25371 = (state_25582[(17)]);
var inst_25380 = (state_25582[(18)]);
var inst_25300 = (state_25582[(19)]);
var inst_25236 = (state_25582[(20)]);
var inst_25402 = (state_25582[(21)]);
var inst_25322 = (state_25582[(22)]);
var inst_25370 = (state_25582[(23)]);
var inst_25358 = (state_25582[(24)]);
var inst_25363 = (state_25582[(25)]);
var inst_25400 = (state_25582[(26)]);
var inst_25376 = (state_25582[(27)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25360 = (state_25582[(31)]);
var inst_25331 = (state_25582[(33)]);
var inst_25304 = (state_25582[(34)]);
var inst_25232 = (state_25582[(35)]);
var inst_25349 = (state_25582[(36)]);
var inst_25390 = (state_25582[(8)]);
var inst_25248 = (state_25582[(37)]);
var inst_25369 = (state_25582[(38)]);
var inst_25381 = (state_25582[(39)]);
var inst_25409 = (state_25582[(40)]);
var inst_25386 = (state_25582[(41)]);
var inst_25249 = (state_25582[(42)]);
var inst_25313 = (state_25582[(43)]);
var inst_25359 = (state_25582[(44)]);
var inst_25403 = (state_25582[(45)]);
var inst_25340 = (state_25582[(46)]);
var inst_25239 = (state_25582[(47)]);
var inst_25401 = (state_25582[(48)]);
var inst_25413 = (function (){var no_filter_QMARK_ = inst_25396;
var G__25410 = inst_25409;
var t = inst_25376;
var max_limit_QMARK_ = inst_25370;
var next_node = inst_25399;
var fast_forward_db_QMARK_ = inst_25381;
var s1 = inst_25259;
var o2 = inst_25322;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var i = inst_25401;
var m1 = inst_25349;
var root_node = inst_25386;
var s2 = inst_25268;
var p2 = inst_25340;
var map__25224 = inst_25247;
var permissions = inst_25371;
var limit = inst_25369;
var start_flake = inst_25359;
var vec__25218 = inst_25232;
var flake_limit = inst_25363;
var offset = inst_25400;
var acc = inst_25403;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25313;
var end_flake = inst_25360;
var base_result = inst_25409;
var s = inst_25402;
var node_start = inst_25390;
var p1 = inst_25331;
var subject_fn = inst_25248;
var vec__25225 = inst_25300;
var object_fn = inst_25304;
var idx_compare = inst_25375;
var map__25231 = inst_25362;
var vec__25228 = inst_25301;
var op2 = inst_25244;
var m2 = inst_25358;
var novelty = inst_25380;
return (function (p1__25199_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__25199_SHARP_.o,start_flake.o);
});
})();
var inst_25414 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_25413,inst_25409);
var state_25582__$1 = state_25582;
var statearr_25761_25919 = state_25582__$1;
(statearr_25761_25919[(2)] = inst_25414);

(statearr_25761_25919[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (42))){
var inst_25336 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
if(cljs.core.truth_(inst_25336)){
var statearr_25762_25920 = state_25582__$1;
(statearr_25762_25920[(1)] = (43));

} else {
var statearr_25763_25921 = state_25582__$1;
(statearr_25763_25921[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (80))){
var inst_25375 = (state_25582[(10)]);
var inst_25399 = (state_25582[(11)]);
var inst_25259 = (state_25582[(12)]);
var inst_25243 = (state_25582[(13)]);
var inst_25396 = (state_25582[(9)]);
var inst_25362 = (state_25582[(14)]);
var inst_25244 = (state_25582[(15)]);
var inst_25301 = (state_25582[(16)]);
var inst_25371 = (state_25582[(17)]);
var inst_25380 = (state_25582[(18)]);
var inst_25300 = (state_25582[(19)]);
var inst_25236 = (state_25582[(20)]);
var inst_25402 = (state_25582[(21)]);
var inst_25322 = (state_25582[(22)]);
var inst_25370 = (state_25582[(23)]);
var inst_25358 = (state_25582[(24)]);
var inst_25363 = (state_25582[(25)]);
var inst_25400 = (state_25582[(26)]);
var inst_25376 = (state_25582[(27)]);
var inst_25237 = (state_25582[(28)]);
var inst_25247 = (state_25582[(29)]);
var inst_25268 = (state_25582[(30)]);
var inst_25360 = (state_25582[(31)]);
var inst_25331 = (state_25582[(33)]);
var inst_25304 = (state_25582[(34)]);
var inst_25232 = (state_25582[(35)]);
var inst_25349 = (state_25582[(36)]);
var inst_25390 = (state_25582[(8)]);
var inst_25248 = (state_25582[(37)]);
var inst_25369 = (state_25582[(38)]);
var inst_25429 = (state_25582[(86)]);
var inst_25381 = (state_25582[(39)]);
var inst_25409 = (state_25582[(40)]);
var inst_25386 = (state_25582[(41)]);
var inst_25249 = (state_25582[(42)]);
var inst_25313 = (state_25582[(43)]);
var inst_25359 = (state_25582[(44)]);
var inst_25403 = (state_25582[(45)]);
var inst_25340 = (state_25582[(46)]);
var inst_25239 = (state_25582[(47)]);
var inst_25401 = (state_25582[(48)]);
var inst_25431 = (function (){var no_filter_QMARK_ = inst_25396;
var G__25410 = inst_25429;
var t = inst_25376;
var max_limit_QMARK_ = inst_25370;
var next_node = inst_25399;
var fast_forward_db_QMARK_ = inst_25381;
var s1 = inst_25259;
var o2 = inst_25322;
var t1 = inst_25236;
var predicate_fn = inst_25249;
var i = inst_25401;
var m1 = inst_25349;
var root_node = inst_25386;
var s2 = inst_25268;
var p2 = inst_25340;
var map__25224 = inst_25247;
var permissions = inst_25371;
var limit = inst_25369;
var start_flake = inst_25359;
var vec__25218 = inst_25232;
var flake_limit = inst_25363;
var offset = inst_25400;
var acc = inst_25403;
var vec__25221 = inst_25239;
var t2 = inst_25243;
var op1 = inst_25237;
var o1 = inst_25313;
var end_flake = inst_25360;
var base_result = inst_25409;
var s = inst_25402;
var node_start = inst_25390;
var p1 = inst_25331;
var subject_fn = inst_25248;
var vec__25225 = inst_25300;
var object_fn = inst_25304;
var idx_compare = inst_25375;
var map__25231 = inst_25362;
var vec__25228 = inst_25301;
var op2 = inst_25244;
var m2 = inst_25358;
var novelty = inst_25380;
return (function (p1__25202_SHARP_){
var G__25764 = p1__25202_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__25764) : object_fn.call(null,G__25764));
});
})();
var inst_25432 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_25431,inst_25429);
var state_25582__$1 = state_25582;
var statearr_25765_25922 = state_25582__$1;
(statearr_25765_25922[(2)] = inst_25432);

(statearr_25765_25922[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (37))){
var state_25582__$1 = state_25582;
var statearr_25766_25923 = state_25582__$1;
(statearr_25766_25923[(2)] = (-1));

(statearr_25766_25923[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (63))){
var inst_25259 = (state_25582[(12)]);
var inst_25371 = (state_25582[(17)]);
var inst_25268 = (state_25582[(30)]);
var inst_25331 = (state_25582[(33)]);
var inst_25340 = (state_25582[(46)]);
var inst_25393 = fluree.db.permissions_validate.no_filter_QMARK_(inst_25371,inst_25259,inst_25268,inst_25331,inst_25340);
var state_25582__$1 = state_25582;
var statearr_25767_25924 = state_25582__$1;
(statearr_25767_25924[(2)] = inst_25393);

(statearr_25767_25924[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (94))){
var inst_25532 = (state_25582[(2)]);
var state_25582__$1 = state_25582;
var statearr_25768_25925 = state_25582__$1;
(statearr_25768_25925[(2)] = inst_25532);

(statearr_25768_25925[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (8))){
var inst_25240 = (state_25582[(84)]);
var inst_25259 = (state_25582[(2)]);
var inst_25260 = fluree.db.util.core.pred_ident_QMARK_(inst_25240);
var state_25582__$1 = (function (){var statearr_25769 = state_25582;
(statearr_25769[(12)] = inst_25259);

return statearr_25769;
})();
if(inst_25260){
var statearr_25770_25926 = state_25582__$1;
(statearr_25770_25926[(1)] = (10));

} else {
var statearr_25771_25927 = state_25582__$1;
(statearr_25771_25927[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (49))){
var state_25582__$1 = state_25582;
var statearr_25772_25928 = state_25582__$1;
(statearr_25772_25928[(2)] = fluree.db.util.core.min_integer);

(statearr_25772_25928[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25583 === (84))){
var inst_25370 = (state_25582[(23)]);
var state_25582__$1 = state_25582;
var statearr_25773_25929 = state_25582__$1;
(statearr_25773_25929[(2)] = inst_25370);

(statearr_25773_25929[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11410__auto__ = null;
var fluree$db$query$range$state_machine__11410__auto____0 = (function (){
var statearr_25774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25774[(0)] = fluree$db$query$range$state_machine__11410__auto__);

(statearr_25774[(1)] = (1));

return statearr_25774;
});
var fluree$db$query$range$state_machine__11410__auto____1 = (function (state_25582){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_25582);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e25775){var ex__11413__auto__ = e25775;
var statearr_25776_25930 = state_25582;
(statearr_25776_25930[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_25582[(4)]))){
var statearr_25777_25931 = state_25582;
(statearr_25777_25931[(1)] = cljs.core.first((state_25582[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25932 = state_25582;
state_25582 = G__25932;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11410__auto__ = function(state_25582){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11410__auto____1.call(this,state_25582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11410__auto____0;
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11410__auto____1;
return fluree$db$query$range$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_25778 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_25778[(6)] = c__11484__auto__);

return statearr_25778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_25988){
var state_val_25989 = (state_25988[(1)]);
if((state_val_25989 === (7))){
var inst_25962 = (state_25988[(7)]);
var inst_25952 = (state_25988[(8)]);
var inst_25960 = fluree.db.flake.Flake__GT_parts(inst_25952);
var inst_25961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(0),null);
var inst_25962__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(1),null);
var inst_25963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(2),null);
var inst_25964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(3),null);
var inst_25965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(4),null);
var inst_25966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25960,(5),null);
var inst_25967 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_25963,inst_25962__$1);
var state_25988__$1 = (function (){var statearr_25990 = state_25988;
(statearr_25990[(9)] = inst_25961);

(statearr_25990[(10)] = inst_25964);

(statearr_25990[(11)] = inst_25966);

(statearr_25990[(7)] = inst_25962__$1);

(statearr_25990[(12)] = inst_25965);

return statearr_25990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25988__$1,(10),inst_25967);
} else {
if((state_val_25989 === (1))){
var inst_25940 = flakes;
var inst_25941 = cljs.core.seq(inst_25940);
var inst_25942 = cljs.core.first(inst_25941);
var inst_25943 = cljs.core.next(inst_25941);
var inst_25944 = cljs.core.PersistentVector.EMPTY;
var inst_25945 = inst_25940;
var inst_25946 = inst_25944;
var state_25988__$1 = (function (){var statearr_25991 = state_25988;
(statearr_25991[(13)] = inst_25946);

(statearr_25991[(14)] = inst_25943);

(statearr_25991[(15)] = inst_25942);

(statearr_25991[(16)] = inst_25945);

return statearr_25991;
})();
var statearr_25992_26010 = state_25988__$1;
(statearr_25992_26010[(2)] = null);

(statearr_25992_26010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (4))){
var inst_25952 = (state_25988[(8)]);
var inst_25955 = fluree.db.query.range.is_tag_flake_QMARK_(inst_25952);
var state_25988__$1 = state_25988;
if(inst_25955){
var statearr_25993_26011 = state_25988__$1;
(statearr_25993_26011[(1)] = (7));

} else {
var statearr_25994_26012 = state_25988__$1;
(statearr_25994_26012[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (6))){
var inst_25984 = (state_25988[(2)]);
var state_25988__$1 = state_25988;
var statearr_25995_26013 = state_25988__$1;
(statearr_25995_26013[(2)] = inst_25984);

(statearr_25995_26013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (3))){
var inst_25986 = (state_25988[(2)]);
var state_25988__$1 = state_25988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25988__$1,inst_25986);
} else {
if((state_val_25989 === (2))){
var inst_25952 = (state_25988[(8)]);
var inst_25945 = (state_25988[(16)]);
var inst_25951 = cljs.core.seq(inst_25945);
var inst_25952__$1 = cljs.core.first(inst_25951);
var inst_25953 = cljs.core.next(inst_25951);
var state_25988__$1 = (function (){var statearr_25996 = state_25988;
(statearr_25996[(8)] = inst_25952__$1);

(statearr_25996[(17)] = inst_25953);

return statearr_25996;
})();
if(cljs.core.truth_(inst_25952__$1)){
var statearr_25997_26014 = state_25988__$1;
(statearr_25997_26014[(1)] = (4));

} else {
var statearr_25998_26015 = state_25988__$1;
(statearr_25998_26015[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (9))){
var inst_25981 = (state_25988[(2)]);
var state_25988__$1 = state_25988;
var statearr_25999_26016 = state_25988__$1;
(statearr_25999_26016[(2)] = inst_25981);

(statearr_25999_26016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (5))){
var inst_25946 = (state_25988[(13)]);
var state_25988__$1 = state_25988;
var statearr_26000_26017 = state_25988__$1;
(statearr_26000_26017[(2)] = inst_25946);

(statearr_26000_26017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (10))){
var inst_25961 = (state_25988[(9)]);
var inst_25964 = (state_25988[(10)]);
var inst_25946 = (state_25988[(13)]);
var inst_25966 = (state_25988[(11)]);
var inst_25962 = (state_25988[(7)]);
var inst_25965 = (state_25988[(12)]);
var inst_25953 = (state_25988[(17)]);
var inst_25969 = (state_25988[(2)]);
var inst_25970 = fluree.db.util.async.throw_err(inst_25969);
var inst_25971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25972 = [inst_25961,inst_25962,inst_25970,inst_25964,inst_25965,inst_25966];
var inst_25973 = (new cljs.core.PersistentVector(null,6,(5),inst_25971,inst_25972,null));
var inst_25974 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_25973);
var inst_25975 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25946,inst_25974);
var inst_25945 = inst_25953;
var inst_25946__$1 = inst_25975;
var state_25988__$1 = (function (){var statearr_26001 = state_25988;
(statearr_26001[(13)] = inst_25946__$1);

(statearr_26001[(16)] = inst_25945);

return statearr_26001;
})();
var statearr_26002_26018 = state_25988__$1;
(statearr_26002_26018[(2)] = null);

(statearr_26002_26018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25989 === (8))){
var inst_25946 = (state_25988[(13)]);
var inst_25952 = (state_25988[(8)]);
var inst_25953 = (state_25988[(17)]);
var inst_25978 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25946,inst_25952);
var inst_25945 = inst_25953;
var inst_25946__$1 = inst_25978;
var state_25988__$1 = (function (){var statearr_26003 = state_25988;
(statearr_26003[(13)] = inst_25946__$1);

(statearr_26003[(16)] = inst_25945);

return statearr_26003;
})();
var statearr_26004_26019 = state_25988__$1;
(statearr_26004_26019[(2)] = null);

(statearr_26004_26019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____0 = (function (){
var statearr_26005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26005[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__);

(statearr_26005[(1)] = (1));

return statearr_26005;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____1 = (function (state_25988){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_25988);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26006){var ex__11413__auto__ = e26006;
var statearr_26007_26020 = state_25988;
(statearr_26007_26020[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_25988[(4)]))){
var statearr_26008_26021 = state_25988;
(statearr_26008_26021[(1)] = cljs.core.first((state_25988[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26022 = state_25988;
state_25988 = G__26022;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__ = function(state_25988){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____1.call(this,state_25988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26009 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26009[(6)] = c__11484__auto__);

return statearr_26009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__26024 = arguments.length;
switch (G__26024) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_26194){
var state_val_26195 = (state_26194[(1)]);
if((state_val_26195 === (65))){
var state_26194__$1 = state_26194;
var statearr_26196_26296 = state_26194__$1;
(statearr_26196_26296[(2)] = null);

(statearr_26196_26296[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (70))){
var inst_26189 = (state_26194[(2)]);
var _ = (function (){var statearr_26197 = state_26194;
(statearr_26197[(4)] = cljs.core.rest((state_26194[(4)])));

return statearr_26197;
})();
var state_26194__$1 = state_26194;
var statearr_26198_26297 = state_26194__$1;
(statearr_26198_26297[(2)] = inst_26189);

(statearr_26198_26297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (62))){
var inst_26175 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26199_26298 = state_26194__$1;
(statearr_26199_26298[(2)] = inst_26175);

(statearr_26199_26298[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (7))){
var state_26194__$1 = state_26194;
var statearr_26200_26299 = state_26194__$1;
(statearr_26200_26299[(2)] = false);

(statearr_26200_26299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (59))){
var inst_26149 = (state_26194[(2)]);
var inst_26150 = fluree.db.util.async.throw_err(inst_26149);
var state_26194__$1 = state_26194;
var statearr_26201_26300 = state_26194__$1;
(statearr_26201_26300[(2)] = inst_26150);

(statearr_26201_26300[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (20))){
var state_26194__$1 = state_26194;
var statearr_26202_26301 = state_26194__$1;
(statearr_26202_26301[(2)] = null);

(statearr_26202_26301[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (58))){
var inst_26139 = (state_26194[(2)]);
var inst_26140 = fluree.db.util.async.throw_err(inst_26139);
var inst_26141 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_26140);
var state_26194__$1 = state_26194;
var statearr_26203_26302 = state_26194__$1;
(statearr_26203_26302[(2)] = inst_26141);

(statearr_26203_26302[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (60))){
var inst_26038 = (state_26194[(7)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26075 = (state_26194[(10)]);
var inst_26155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26156 = [inst_26036,inst_26035,inst_26075,inst_26038];
var inst_26157 = (new cljs.core.PersistentVector(null,4,(5),inst_26155,inst_26156,null));
var inst_26158 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26157,opts);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(63),inst_26158);
} else {
if((state_val_26195 === (27))){
var inst_26086 = (state_26194[(11)]);
var inst_26075 = (state_26194[(10)]);
var inst_26086__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_26075);
var state_26194__$1 = (function (){var statearr_26204 = state_26194;
(statearr_26204[(11)] = inst_26086__$1);

return statearr_26204;
})();
if(inst_26086__$1){
var statearr_26205_26303 = state_26194__$1;
(statearr_26205_26303[(1)] = (30));

} else {
var statearr_26206_26304 = state_26194__$1;
(statearr_26206_26304[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (1))){
var state_26194__$1 = state_26194;
var statearr_26207_26305 = state_26194__$1;
(statearr_26207_26305[(2)] = null);

(statearr_26207_26305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (69))){
var inst_26181 = (state_26194[(12)]);
var state_26194__$1 = state_26194;
var statearr_26208_26306 = state_26194__$1;
(statearr_26208_26306[(2)] = inst_26181);

(statearr_26208_26306[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (24))){
var inst_26036 = (state_26194[(8)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26036)){
var statearr_26209_26307 = state_26194__$1;
(statearr_26209_26307[(1)] = (27));

} else {
var statearr_26210_26308 = state_26194__$1;
(statearr_26210_26308[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (55))){
var inst_26075 = (state_26194[(10)]);
var inst_26133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26134 = [inst_26075];
var inst_26135 = (new cljs.core.PersistentVector(null,1,(5),inst_26133,inst_26134,null));
var inst_26136 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_26137 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26135,inst_26136);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(58),inst_26137);
} else {
if((state_val_26195 === (39))){
var inst_26106 = (state_26194[(2)]);
var inst_26107 = fluree.db.util.async.throw_err(inst_26106);
var state_26194__$1 = state_26194;
var statearr_26211_26309 = state_26194__$1;
(statearr_26211_26309[(2)] = inst_26107);

(statearr_26211_26309[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (46))){
var inst_26119 = (state_26194[(13)]);
var inst_26119__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_26194__$1 = (function (){var statearr_26212 = state_26194;
(statearr_26212[(13)] = inst_26119__$1);

return statearr_26212;
})();
if(cljs.core.truth_(inst_26119__$1)){
var statearr_26213_26310 = state_26194__$1;
(statearr_26213_26310[(1)] = (49));

} else {
var statearr_26214_26311 = state_26194__$1;
(statearr_26214_26311[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (4))){
var inst_26025 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26215_26312 = state_26194__$1;
(statearr_26215_26312[(2)] = inst_26025);

(statearr_26215_26312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (54))){
var inst_26131 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26131)){
var statearr_26216_26313 = state_26194__$1;
(statearr_26216_26313[(1)] = (55));

} else {
var statearr_26217_26314 = state_26194__$1;
(statearr_26217_26314[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (15))){
var inst_26037 = (state_26194[(14)]);
var inst_26056 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_26037);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(18),inst_26056);
} else {
if((state_val_26195 === (48))){
var inst_26177 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26218_26315 = state_26194__$1;
(statearr_26218_26315[(2)] = inst_26177);

(statearr_26218_26315[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (50))){
var inst_26045 = (state_26194[(15)]);
var inst_26038 = (state_26194[(7)]);
var inst_26050 = (state_26194[(16)]);
var inst_26039 = (state_26194[(17)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26119 = (state_26194[(13)]);
var inst_26075 = (state_26194[(10)]);
var inst_26034 = (state_26194[(18)]);
var inst_26123 = (function (){var t = inst_26038;
var p = inst_26036;
var idx_predicate_QMARK_ = inst_26039;
var o = inst_26075;
var tag_predicate_QMARK_ = inst_26045;
var temp__5751__auto__ = inst_26119;
var s = inst_26035;
var o_coerce_QMARK_ = inst_26050;
var vec__26031 = inst_26034;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_26194__$1 = state_26194;
var statearr_26219_26316 = state_26194__$1;
(statearr_26219_26316[(2)] = inst_26123);

(statearr_26219_26316[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (21))){
var inst_26071 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26220_26317 = state_26194__$1;
(statearr_26220_26317[(2)] = inst_26071);

(statearr_26220_26317[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (31))){
var inst_26086 = (state_26194[(11)]);
var state_26194__$1 = state_26194;
var statearr_26221_26318 = state_26194__$1;
(statearr_26221_26318[(2)] = inst_26086);

(statearr_26221_26318[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (32))){
var inst_26096 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26222_26319 = state_26194__$1;
(statearr_26222_26319[(2)] = inst_26096);

(statearr_26222_26319[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (40))){
var inst_26110 = (state_26194[(19)]);
var inst_26039 = (state_26194[(17)]);
var inst_26110__$1 = cljs.core.not(inst_26039);
var state_26194__$1 = (function (){var statearr_26223 = state_26194;
(statearr_26223[(19)] = inst_26110__$1);

return statearr_26223;
})();
if(inst_26110__$1){
var statearr_26224_26320 = state_26194__$1;
(statearr_26224_26320[(1)] = (43));

} else {
var statearr_26225_26321 = state_26194__$1;
(statearr_26225_26321[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (56))){
var inst_26038 = (state_26194[(7)]);
var inst_26036 = (state_26194[(8)]);
var inst_26125 = (state_26194[(20)]);
var inst_26035 = (state_26194[(9)]);
var inst_26143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26144 = [inst_26036,inst_26035,null,inst_26038];
var inst_26145 = (new cljs.core.PersistentVector(null,4,(5),inst_26143,inst_26144,null));
var inst_26146 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_26125);
var inst_26147 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26145,inst_26146);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(59),inst_26147);
} else {
if((state_val_26195 === (33))){
var inst_26075 = (state_26194[(10)]);
var inst_26089 = cljs.core.fn_QMARK_(inst_26075);
var inst_26090 = (!(inst_26089));
var state_26194__$1 = state_26194;
var statearr_26226_26322 = state_26194__$1;
(statearr_26226_26322[(2)] = inst_26090);

(statearr_26226_26322[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (13))){
var inst_26037 = (state_26194[(14)]);
var inst_26054 = fluree.db.query.range.tag_string_QMARK_(inst_26037);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26054)){
var statearr_26227_26323 = state_26194__$1;
(statearr_26227_26323[(1)] = (15));

} else {
var statearr_26228_26324 = state_26194__$1;
(statearr_26228_26324[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (22))){
var inst_26067 = (state_26194[(2)]);
var inst_26068 = fluree.db.util.async.throw_err(inst_26067);
var state_26194__$1 = state_26194;
var statearr_26229_26325 = state_26194__$1;
(statearr_26229_26325[(2)] = inst_26068);

(statearr_26229_26325[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (36))){
var inst_26038 = (state_26194[(7)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26075 = (state_26194[(10)]);
var inst_26101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26102 = [inst_26036,inst_26075,inst_26035,inst_26038];
var inst_26103 = (new cljs.core.PersistentVector(null,4,(5),inst_26101,inst_26102,null));
var inst_26104 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26103,opts);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(39),inst_26104);
} else {
if((state_val_26195 === (41))){
var inst_26036 = (state_26194[(8)]);
var state_26194__$1 = state_26194;
var statearr_26230_26326 = state_26194__$1;
(statearr_26230_26326[(2)] = inst_26036);

(statearr_26230_26326[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (43))){
var inst_26075 = (state_26194[(10)]);
var state_26194__$1 = state_26194;
var statearr_26231_26327 = state_26194__$1;
(statearr_26231_26327[(2)] = inst_26075);

(statearr_26231_26327[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (61))){
var inst_26075 = (state_26194[(10)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26075)){
var statearr_26232_26328 = state_26194__$1;
(statearr_26232_26328[(1)] = (64));

} else {
var statearr_26233_26329 = state_26194__$1;
(statearr_26233_26329[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (29))){
var inst_26099 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26099)){
var statearr_26234_26330 = state_26194__$1;
(statearr_26234_26330[(1)] = (36));

} else {
var statearr_26235_26331 = state_26194__$1;
(statearr_26235_26331[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (44))){
var inst_26110 = (state_26194[(19)]);
var state_26194__$1 = state_26194;
var statearr_26236_26332 = state_26194__$1;
(statearr_26236_26332[(2)] = inst_26110);

(statearr_26236_26332[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (6))){
var inst_26036 = (state_26194[(8)]);
var inst_26041 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_26036);
var inst_26042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_26041);
var state_26194__$1 = state_26194;
var statearr_26237_26333 = state_26194__$1;
(statearr_26237_26333[(2)] = inst_26042);

(statearr_26237_26333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (28))){
var inst_26036 = (state_26194[(8)]);
var state_26194__$1 = state_26194;
var statearr_26238_26334 = state_26194__$1;
(statearr_26238_26334[(2)] = inst_26036);

(statearr_26238_26334[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (64))){
var inst_26038 = (state_26194[(7)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26075 = (state_26194[(10)]);
var inst_26164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26165 = [inst_26075,inst_26036,inst_26035,inst_26038];
var inst_26166 = (new cljs.core.PersistentVector(null,4,(5),inst_26164,inst_26165,null));
var inst_26167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_26166,opts);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(67),inst_26167);
} else {
if((state_val_26195 === (51))){
var inst_26126 = (state_26194[(21)]);
var inst_26036 = (state_26194[(8)]);
var inst_26125 = (state_26194[(2)]);
var inst_26126__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_26036);
var state_26194__$1 = (function (){var statearr_26239 = state_26194;
(statearr_26239[(21)] = inst_26126__$1);

(statearr_26239[(20)] = inst_26125);

return statearr_26239;
})();
if(inst_26126__$1){
var statearr_26240_26335 = state_26194__$1;
(statearr_26240_26335[(1)] = (52));

} else {
var statearr_26241_26336 = state_26194__$1;
(statearr_26241_26336[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (25))){
var inst_26045 = (state_26194[(15)]);
var inst_26181 = (state_26194[(2)]);
var state_26194__$1 = (function (){var statearr_26242 = state_26194;
(statearr_26242[(12)] = inst_26181);

return statearr_26242;
})();
if(cljs.core.truth_(inst_26045)){
var statearr_26243_26337 = state_26194__$1;
(statearr_26243_26337[(1)] = (68));

} else {
var statearr_26244_26338 = state_26194__$1;
(statearr_26244_26338[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (34))){
var inst_26039 = (state_26194[(17)]);
var state_26194__$1 = state_26194;
var statearr_26245_26339 = state_26194__$1;
(statearr_26245_26339[(2)] = inst_26039);

(statearr_26245_26339[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (17))){
var inst_26073 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26246_26340 = state_26194__$1;
(statearr_26246_26340[(2)] = inst_26073);

(statearr_26246_26340[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (3))){
var inst_26192 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26194__$1,inst_26192);
} else {
if((state_val_26195 === (12))){
var inst_26037 = (state_26194[(14)]);
var state_26194__$1 = state_26194;
var statearr_26247_26341 = state_26194__$1;
(statearr_26247_26341[(2)] = inst_26037);

(statearr_26247_26341[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (2))){
var inst_26036 = (state_26194[(8)]);
var inst_26034 = (state_26194[(18)]);
var _ = (function (){var statearr_26248 = state_26194;
(statearr_26248[(4)] = cljs.core.cons((5),(state_26194[(4)])));

return statearr_26248;
})();
var inst_26034__$1 = fparts;
var inst_26035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26034__$1,(0),null);
var inst_26036__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26034__$1,(1),null);
var inst_26037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26034__$1,(2),null);
var inst_26038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26034__$1,(3),null);
var inst_26039 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_26036__$1);
var state_26194__$1 = (function (){var statearr_26249 = state_26194;
(statearr_26249[(7)] = inst_26038);

(statearr_26249[(14)] = inst_26037);

(statearr_26249[(17)] = inst_26039);

(statearr_26249[(8)] = inst_26036__$1);

(statearr_26249[(9)] = inst_26035);

(statearr_26249[(18)] = inst_26034__$1);

return statearr_26249;
})();
if(cljs.core.truth_(inst_26036__$1)){
var statearr_26250_26342 = state_26194__$1;
(statearr_26250_26342[(1)] = (6));

} else {
var statearr_26251_26343 = state_26194__$1;
(statearr_26251_26343[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (66))){
var inst_26173 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26252_26344 = state_26194__$1;
(statearr_26252_26344[(2)] = inst_26173);

(statearr_26252_26344[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (23))){
var inst_26038 = (state_26194[(7)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26075 = (state_26194[(10)]);
var inst_26077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26078 = [inst_26035,inst_26036,inst_26075,inst_26038];
var inst_26079 = (new cljs.core.PersistentVector(null,4,(5),inst_26077,inst_26078,null));
var inst_26080 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26079,opts);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(26),inst_26080);
} else {
if((state_val_26195 === (47))){
var inst_26036 = (state_26194[(8)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26036)){
var statearr_26253_26345 = state_26194__$1;
(statearr_26253_26345[(1)] = (60));

} else {
var statearr_26254_26346 = state_26194__$1;
(statearr_26254_26346[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (35))){
var inst_26093 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26255_26347 = state_26194__$1;
(statearr_26255_26347[(2)] = inst_26093);

(statearr_26255_26347[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (19))){
var inst_26037 = (state_26194[(14)]);
var inst_26036 = (state_26194[(8)]);
var inst_26063 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_26036);
var inst_26064 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26063),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26037)].join('');
var inst_26065 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_26064);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(22),inst_26065);
} else {
if((state_val_26195 === (57))){
var inst_26152 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26256_26348 = state_26194__$1;
(statearr_26256_26348[(2)] = inst_26152);

(statearr_26256_26348[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (68))){
var inst_26181 = (state_26194[(12)]);
var inst_26183 = fluree.db.query.range.coerce_tag_flakes(db,inst_26181);
var state_26194__$1 = state_26194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26194__$1,(71),inst_26183);
} else {
if((state_val_26195 === (11))){
var inst_26050 = (state_26194[(16)]);
var inst_26050__$1 = (state_26194[(2)]);
var inst_26051 = cljs.core.not(inst_26050__$1);
var state_26194__$1 = (function (){var statearr_26258 = state_26194;
(statearr_26258[(16)] = inst_26050__$1);

return statearr_26258;
})();
if(inst_26051){
var statearr_26259_26349 = state_26194__$1;
(statearr_26259_26349[(1)] = (12));

} else {
var statearr_26260_26350 = state_26194__$1;
(statearr_26260_26350[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (9))){
var inst_26037 = (state_26194[(14)]);
var inst_26047 = typeof inst_26037 === 'string';
var state_26194__$1 = state_26194;
var statearr_26261_26351 = state_26194__$1;
(statearr_26261_26351[(2)] = inst_26047);

(statearr_26261_26351[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (5))){
var _ = (function (){var statearr_26262 = state_26194;
(statearr_26262[(4)] = cljs.core.rest((state_26194[(4)])));

return statearr_26262;
})();
var state_26194__$1 = state_26194;
var ex26257 = (state_26194__$1[(2)]);
var statearr_26263_26352 = state_26194__$1;
(statearr_26263_26352[(5)] = ex26257);


if((ex26257 instanceof Error)){
var statearr_26264_26353 = state_26194__$1;
(statearr_26264_26353[(1)] = (4));

(statearr_26264_26353[(5)] = null);

} else {
throw ex26257;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (14))){
var inst_26035 = (state_26194[(9)]);
var inst_26075 = (state_26194[(2)]);
var state_26194__$1 = (function (){var statearr_26265 = state_26194;
(statearr_26265[(10)] = inst_26075);

return statearr_26265;
})();
if(cljs.core.truth_(inst_26035)){
var statearr_26266_26354 = state_26194__$1;
(statearr_26266_26354[(1)] = (23));

} else {
var statearr_26267_26355 = state_26194__$1;
(statearr_26267_26355[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (45))){
var inst_26114 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26268_26356 = state_26194__$1;
(statearr_26268_26356[(2)] = inst_26114);

(statearr_26268_26356[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (53))){
var inst_26126 = (state_26194[(21)]);
var state_26194__$1 = state_26194;
var statearr_26269_26357 = state_26194__$1;
(statearr_26269_26357[(2)] = inst_26126);

(statearr_26269_26357[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (26))){
var inst_26082 = (state_26194[(2)]);
var inst_26083 = fluree.db.util.async.throw_err(inst_26082);
var state_26194__$1 = state_26194;
var statearr_26270_26358 = state_26194__$1;
(statearr_26270_26358[(2)] = inst_26083);

(statearr_26270_26358[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (16))){
var inst_26037 = (state_26194[(14)]);
var inst_26061 = typeof inst_26037 === 'string';
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26061)){
var statearr_26271_26359 = state_26194__$1;
(statearr_26271_26359[(1)] = (19));

} else {
var statearr_26272_26360 = state_26194__$1;
(statearr_26272_26360[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (38))){
var inst_26179 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
var statearr_26273_26361 = state_26194__$1;
(statearr_26273_26361[(2)] = inst_26179);

(statearr_26273_26361[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (30))){
var inst_26039 = (state_26194[(17)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26039)){
var statearr_26274_26362 = state_26194__$1;
(statearr_26274_26362[(1)] = (33));

} else {
var statearr_26275_26363 = state_26194__$1;
(statearr_26275_26363[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (10))){
var inst_26045 = (state_26194[(15)]);
var state_26194__$1 = state_26194;
var statearr_26276_26364 = state_26194__$1;
(statearr_26276_26364[(2)] = inst_26045);

(statearr_26276_26364[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (18))){
var inst_26058 = (state_26194[(2)]);
var inst_26059 = fluree.db.util.async.throw_err(inst_26058);
var state_26194__$1 = state_26194;
var statearr_26277_26365 = state_26194__$1;
(statearr_26277_26365[(2)] = inst_26059);

(statearr_26277_26365[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (52))){
var inst_26075 = (state_26194[(10)]);
var inst_26128 = cljs.core.int_QMARK_(inst_26075);
var state_26194__$1 = state_26194;
var statearr_26278_26366 = state_26194__$1;
(statearr_26278_26366[(2)] = inst_26128);

(statearr_26278_26366[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (67))){
var inst_26169 = (state_26194[(2)]);
var inst_26170 = fluree.db.util.async.throw_err(inst_26169);
var state_26194__$1 = state_26194;
var statearr_26279_26367 = state_26194__$1;
(statearr_26279_26367[(2)] = inst_26170);

(statearr_26279_26367[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (71))){
var inst_26185 = (state_26194[(2)]);
var inst_26186 = fluree.db.util.async.throw_err(inst_26185);
var state_26194__$1 = state_26194;
var statearr_26280_26368 = state_26194__$1;
(statearr_26280_26368[(2)] = inst_26186);

(statearr_26280_26368[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (42))){
var inst_26117 = (state_26194[(2)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26117)){
var statearr_26281_26369 = state_26194__$1;
(statearr_26281_26369[(1)] = (46));

} else {
var statearr_26282_26370 = state_26194__$1;
(statearr_26282_26370[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (37))){
var inst_26036 = (state_26194[(8)]);
var state_26194__$1 = state_26194;
if(cljs.core.truth_(inst_26036)){
var statearr_26283_26371 = state_26194__$1;
(statearr_26283_26371[(1)] = (40));

} else {
var statearr_26284_26372 = state_26194__$1;
(statearr_26284_26372[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (63))){
var inst_26160 = (state_26194[(2)]);
var inst_26161 = fluree.db.util.async.throw_err(inst_26160);
var state_26194__$1 = state_26194;
var statearr_26285_26373 = state_26194__$1;
(statearr_26285_26373[(2)] = inst_26161);

(statearr_26285_26373[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (8))){
var inst_26045 = (state_26194[(15)]);
var inst_26045__$1 = (state_26194[(2)]);
var state_26194__$1 = (function (){var statearr_26286 = state_26194;
(statearr_26286[(15)] = inst_26045__$1);

return statearr_26286;
})();
if(cljs.core.truth_(inst_26045__$1)){
var statearr_26287_26374 = state_26194__$1;
(statearr_26287_26374[(1)] = (9));

} else {
var statearr_26288_26375 = state_26194__$1;
(statearr_26288_26375[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26195 === (49))){
var inst_26045 = (state_26194[(15)]);
var inst_26038 = (state_26194[(7)]);
var inst_26050 = (state_26194[(16)]);
var inst_26039 = (state_26194[(17)]);
var inst_26036 = (state_26194[(8)]);
var inst_26035 = (state_26194[(9)]);
var inst_26119 = (state_26194[(13)]);
var inst_26075 = (state_26194[(10)]);
var inst_26034 = (state_26194[(18)]);
var inst_26121 = (function (){var obj_fn = inst_26119;
var t = inst_26038;
var p = inst_26036;
var idx_predicate_QMARK_ = inst_26039;
var o = inst_26075;
var tag_predicate_QMARK_ = inst_26045;
var temp__5751__auto__ = inst_26119;
var s = inst_26035;
var o_coerce_QMARK_ = inst_26050;
var vec__26031 = inst_26034;
return (function (x){
var and__4251__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_26194__$1 = state_26194;
var statearr_26289_26376 = state_26194__$1;
(statearr_26289_26376[(2)] = inst_26121);

(statearr_26289_26376[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11410__auto__ = null;
var fluree$db$query$range$state_machine__11410__auto____0 = (function (){
var statearr_26290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26290[(0)] = fluree$db$query$range$state_machine__11410__auto__);

(statearr_26290[(1)] = (1));

return statearr_26290;
});
var fluree$db$query$range$state_machine__11410__auto____1 = (function (state_26194){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_26194);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26291){var ex__11413__auto__ = e26291;
var statearr_26292_26377 = state_26194;
(statearr_26292_26377[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_26194[(4)]))){
var statearr_26293_26378 = state_26194;
(statearr_26293_26378[(1)] = cljs.core.first((state_26194[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26379 = state_26194;
state_26194 = G__26379;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11410__auto__ = function(state_26194){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11410__auto____1.call(this,state_26194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11410__auto____0;
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11410__auto____1;
return fluree$db$query$range$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26294 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26294[(6)] = c__11484__auto__);

return statearr_26294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__26381 = arguments.length;
switch (G__26381) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_26416){
var state_val_26417 = (state_26416[(1)]);
if((state_val_26417 === (7))){
var inst_26403 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_26404 = ["Invalid collection name: ",inst_26403].join('');
var inst_26405 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26406 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_26407 = cljs.core.PersistentHashMap.fromArrays(inst_26405,inst_26406);
var inst_26408 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26404,inst_26407);
var inst_26409 = (function(){throw inst_26408})();
var state_26416__$1 = state_26416;
var statearr_26418_26438 = state_26416__$1;
(statearr_26418_26438[(2)] = inst_26409);

(statearr_26418_26438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (1))){
var state_26416__$1 = state_26416;
var statearr_26419_26439 = state_26416__$1;
(statearr_26419_26439[(2)] = null);

(statearr_26419_26439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (4))){
var inst_26382 = (state_26416[(2)]);
var state_26416__$1 = state_26416;
var statearr_26420_26440 = state_26416__$1;
(statearr_26420_26440[(2)] = inst_26382);

(statearr_26420_26440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (6))){
var inst_26388 = (state_26416[(7)]);
var inst_26390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26391 = fluree.db.flake.max_subject_id(inst_26388);
var inst_26392 = [inst_26391];
var inst_26393 = (new cljs.core.PersistentVector(null,1,(5),inst_26390,inst_26392,null));
var inst_26394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26395 = fluree.db.flake.min_subject_id(inst_26388);
var inst_26396 = [inst_26395];
var inst_26397 = (new cljs.core.PersistentVector(null,1,(5),inst_26394,inst_26396,null));
var inst_26398 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_26393,cljs.core._LT__EQ_,inst_26397,opts);
var state_26416__$1 = state_26416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26416__$1,(9),inst_26398);
} else {
if((state_val_26417 === (3))){
var inst_26414 = (state_26416[(2)]);
var state_26416__$1 = state_26416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26416__$1,inst_26414);
} else {
if((state_val_26417 === (2))){
var inst_26388 = (state_26416[(7)]);
var _ = (function (){var statearr_26422 = state_26416;
(statearr_26422[(4)] = cljs.core.cons((5),(state_26416[(4)])));

return statearr_26422;
})();
var inst_26388__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_26416__$1 = (function (){var statearr_26423 = state_26416;
(statearr_26423[(7)] = inst_26388__$1);

return statearr_26423;
})();
if(cljs.core.truth_(inst_26388__$1)){
var statearr_26424_26441 = state_26416__$1;
(statearr_26424_26441[(1)] = (6));

} else {
var statearr_26425_26442 = state_26416__$1;
(statearr_26425_26442[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (9))){
var inst_26400 = (state_26416[(2)]);
var inst_26401 = fluree.db.util.async.throw_err(inst_26400);
var state_26416__$1 = state_26416;
var statearr_26426_26443 = state_26416__$1;
(statearr_26426_26443[(2)] = inst_26401);

(statearr_26426_26443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (5))){
var _ = (function (){var statearr_26427 = state_26416;
(statearr_26427[(4)] = cljs.core.rest((state_26416[(4)])));

return statearr_26427;
})();
var state_26416__$1 = state_26416;
var ex26421 = (state_26416__$1[(2)]);
var statearr_26428_26444 = state_26416__$1;
(statearr_26428_26444[(5)] = ex26421);


var statearr_26429_26445 = state_26416__$1;
(statearr_26429_26445[(1)] = (4));

(statearr_26429_26445[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26417 === (8))){
var inst_26411 = (state_26416[(2)]);
var _ = (function (){var statearr_26430 = state_26416;
(statearr_26430[(4)] = cljs.core.rest((state_26416[(4)])));

return statearr_26430;
})();
var state_26416__$1 = state_26416;
var statearr_26431_26446 = state_26416__$1;
(statearr_26431_26446[(2)] = inst_26411);

(statearr_26431_26446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__11410__auto__ = null;
var fluree$db$query$range$state_machine__11410__auto____0 = (function (){
var statearr_26432 = [null,null,null,null,null,null,null,null];
(statearr_26432[(0)] = fluree$db$query$range$state_machine__11410__auto__);

(statearr_26432[(1)] = (1));

return statearr_26432;
});
var fluree$db$query$range$state_machine__11410__auto____1 = (function (state_26416){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_26416);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26433){var ex__11413__auto__ = e26433;
var statearr_26434_26447 = state_26416;
(statearr_26434_26447[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_26416[(4)]))){
var statearr_26435_26448 = state_26416;
(statearr_26435_26448[(1)] = cljs.core.first((state_26416[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26449 = state_26416;
state_26416 = G__26449;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__11410__auto__ = function(state_26416){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__11410__auto____1.call(this,state_26416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__11410__auto____0;
fluree$db$query$range$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__11410__auto____1;
return fluree$db$query$range$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26436 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26436[(6)] = c__11484__auto__);

return statearr_26436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__26453 = flakes;
var vec__26454 = G__26453;
var seq__26455 = cljs.core.seq(vec__26454);
var first__26456 = cljs.core.first(seq__26455);
var seq__26455__$1 = cljs.core.next(seq__26455);
var flake_SINGLEQUOTE_ = first__26456;
var r = seq__26455__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26453__$1 = G__26453;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26462 = G__26453__$1;
var seq__26463 = cljs.core.seq(vec__26462);
var first__26464 = cljs.core.first(seq__26463);
var seq__26463__$1 = cljs.core.next(seq__26463);
var flake_SINGLEQUOTE___$1 = first__26464;
var r__$1 = seq__26463__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e26466){var e = e26466;
return null;
}})();
var map__26465 = cmd_map;
var map__26465__$1 = cljs.core.__destructure_map(map__26465);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26465__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__26467 = r__$1;
var G__26468 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__26453__$1 = G__26467;
result_STAR___$1 = G__26468;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__26477 = blocks;
var vec__26478 = G__26477;
var seq__26479 = cljs.core.seq(vec__26478);
var first__26480 = cljs.core.first(seq__26479);
var seq__26479__$1 = cljs.core.next(seq__26479);
var block_SINGLEQUOTE_ = first__26480;
var r = seq__26479__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26477__$1 = G__26477;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26485 = G__26477__$1;
var seq__26486 = cljs.core.seq(vec__26485);
var first__26487 = cljs.core.first(seq__26486);
var seq__26486__$1 = cljs.core.next(seq__26486);
var block_SINGLEQUOTE___$1 = first__26487;
var r__$1 = seq__26486__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__26488 = block_SINGLEQUOTE___$1;
var map__26488__$1 = cljs.core.__destructure_map(map__26488);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26488__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26469_SHARP_){
var f = p1__26469_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26470_SHARP_){
var f = p1__26470_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26471_SHARP_){
var f = p1__26471_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,instant,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26472_SHARP_){
var f = p1__26472_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,instant,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26473_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__26473_SHARP_.p,(106));
});})(G__26477__$1,result_STAR___$1,map__26488,map__26488__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26485,seq__26486,first__26487,seq__26486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26477,vec__26478,seq__26479,first__26480,seq__26479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__26489 = r__$1;
var G__26490 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__26477__$1 = G__26489;
result_STAR___$1 = G__26490;
continue;
}
break;
}
});
