// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_26508){
var state_val_26509 = (state_26508[(1)]);
if((state_val_26509 === (1))){
var state_26508__$1 = state_26508;
var statearr_26510_26524 = state_26508__$1;
(statearr_26510_26524[(2)] = null);

(statearr_26510_26524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (2))){
var _ = (function (){var statearr_26511 = state_26508;
(statearr_26511[(4)] = cljs.core.cons((5),(state_26508[(4)])));

return statearr_26511;
})();
var inst_26499 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_26508__$1 = state_26508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26508__$1,(6),inst_26499);
} else {
if((state_val_26509 === (3))){
var inst_26506 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26508__$1,inst_26506);
} else {
if((state_val_26509 === (4))){
var inst_26493 = (state_26508[(2)]);
var state_26508__$1 = state_26508;
var statearr_26513_26525 = state_26508__$1;
(statearr_26513_26525[(2)] = inst_26493);

(statearr_26513_26525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (5))){
var _ = (function (){var statearr_26514 = state_26508;
(statearr_26514[(4)] = cljs.core.rest((state_26508[(4)])));

return statearr_26514;
})();
var state_26508__$1 = state_26508;
var ex26512 = (state_26508__$1[(2)]);
var statearr_26515_26526 = state_26508__$1;
(statearr_26515_26526[(5)] = ex26512);


if((ex26512 instanceof Error)){
var statearr_26516_26527 = state_26508__$1;
(statearr_26516_26527[(1)] = (4));

(statearr_26516_26527[(5)] = null);

} else {
throw ex26512;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26509 === (6))){
var inst_26501 = (state_26508[(2)]);
var inst_26502 = fluree.db.util.async.throw_err(inst_26501);
var inst_26503 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_26502);
var _ = (function (){var statearr_26517 = state_26508;
(statearr_26517[(4)] = cljs.core.rest((state_26508[(4)])));

return statearr_26517;
})();
var state_26508__$1 = state_26508;
var statearr_26518_26528 = state_26508__$1;
(statearr_26518_26528[(2)] = inst_26503);

(statearr_26518_26528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____0 = (function (){
var statearr_26519 = [null,null,null,null,null,null,null];
(statearr_26519[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__);

(statearr_26519[(1)] = (1));

return statearr_26519;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____1 = (function (state_26508){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_26508);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26520){var ex__11413__auto__ = e26520;
var statearr_26521_26529 = state_26508;
(statearr_26521_26529[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_26508[(4)]))){
var statearr_26522_26530 = state_26508;
(statearr_26522_26530[(1)] = cljs.core.first((state_26508[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26531 = state_26508;
state_26508 = G__26531;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__ = function(state_26508){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____1.call(this,state_26508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26523 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26523[(6)] = c__11484__auto__);

return statearr_26523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_26563){
var state_val_26564 = (state_26563[(1)]);
if((state_val_26564 === (7))){
var inst_26547 = (state_26563[(7)]);
var inst_26549 = cljs.core.empty_QMARK_(inst_26547);
var inst_26550 = (!(inst_26549));
var state_26563__$1 = state_26563;
var statearr_26565_26589 = state_26563__$1;
(statearr_26565_26589[(2)] = inst_26550);

(statearr_26565_26589[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (1))){
var state_26563__$1 = state_26563;
var statearr_26566_26590 = state_26563__$1;
(statearr_26566_26590[(2)] = null);

(statearr_26566_26590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (4))){
var inst_26533 = (state_26563[(2)]);
var state_26563__$1 = state_26563;
var statearr_26567_26591 = state_26563__$1;
(statearr_26567_26591[(2)] = inst_26533);

(statearr_26567_26591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (6))){
var inst_26539 = (state_26563[(8)]);
var inst_26547 = (state_26563[(7)]);
var inst_26545 = (state_26563[(2)]);
var inst_26546 = fluree.db.util.async.throw_err(inst_26545);
var inst_26547__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26539,inst_26546);
var state_26563__$1 = (function (){var statearr_26568 = state_26563;
(statearr_26568[(7)] = inst_26547__$1);

return statearr_26568;
})();
if(cljs.core.truth_(inst_26547__$1)){
var statearr_26569_26592 = state_26563__$1;
(statearr_26569_26592[(1)] = (7));

} else {
var statearr_26570_26593 = state_26563__$1;
(statearr_26570_26593[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (3))){
var inst_26561 = (state_26563[(2)]);
var state_26563__$1 = state_26563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26563__$1,inst_26561);
} else {
if((state_val_26564 === (12))){
var inst_26558 = (state_26563[(2)]);
var _ = (function (){var statearr_26571 = state_26563;
(statearr_26571[(4)] = cljs.core.rest((state_26563[(4)])));

return statearr_26571;
})();
var state_26563__$1 = state_26563;
var statearr_26572_26594 = state_26563__$1;
(statearr_26572_26594[(2)] = inst_26558);

(statearr_26572_26594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (2))){
var _ = (function (){var statearr_26573 = state_26563;
(statearr_26573[(4)] = cljs.core.cons((5),(state_26563[(4)])));

return statearr_26573;
})();
var inst_26539 = (function (){return (function (p1__26532_SHARP_){
return p1__26532_SHARP_.o;
});
})();
var inst_26540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26541 = [pred_id];
var inst_26542 = (new cljs.core.PersistentVector(null,1,(5),inst_26540,inst_26541,null));
var inst_26543 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26542);
var state_26563__$1 = (function (){var statearr_26574 = state_26563;
(statearr_26574[(8)] = inst_26539);

return statearr_26574;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26563__$1,(6),inst_26543);
} else {
if((state_val_26564 === (11))){
var state_26563__$1 = state_26563;
var statearr_26576_26595 = state_26563__$1;
(statearr_26576_26595[(2)] = true);

(statearr_26576_26595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (9))){
var inst_26553 = (state_26563[(2)]);
var state_26563__$1 = state_26563;
if(cljs.core.truth_(inst_26553)){
var statearr_26577_26596 = state_26563__$1;
(statearr_26577_26596[(1)] = (10));

} else {
var statearr_26578_26597 = state_26563__$1;
(statearr_26578_26597[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (5))){
var _ = (function (){var statearr_26579 = state_26563;
(statearr_26579[(4)] = cljs.core.rest((state_26563[(4)])));

return statearr_26579;
})();
var state_26563__$1 = state_26563;
var ex26575 = (state_26563__$1[(2)]);
var statearr_26580_26598 = state_26563__$1;
(statearr_26580_26598[(5)] = ex26575);


if((ex26575 instanceof Error)){
var statearr_26581_26599 = state_26563__$1;
(statearr_26581_26599[(1)] = (4));

(statearr_26581_26599[(5)] = null);

} else {
throw ex26575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (10))){
var inst_26547 = (state_26563[(7)]);
var inst_26555 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_26547);
var state_26563__$1 = state_26563;
var statearr_26582_26600 = state_26563__$1;
(statearr_26582_26600[(2)] = inst_26555);

(statearr_26582_26600[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26564 === (8))){
var inst_26547 = (state_26563[(7)]);
var state_26563__$1 = state_26563;
var statearr_26583_26601 = state_26563__$1;
(statearr_26583_26601[(2)] = inst_26547);

(statearr_26583_26601[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_26584 = [null,null,null,null,null,null,null,null,null];
(statearr_26584[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__);

(statearr_26584[(1)] = (1));

return statearr_26584;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____1 = (function (state_26563){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_26563);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26585){var ex__11413__auto__ = e26585;
var statearr_26586_26602 = state_26563;
(statearr_26586_26602[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_26563[(4)]))){
var statearr_26587_26603 = state_26563;
(statearr_26587_26603[(1)] = cljs.core.first((state_26563[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26604 = state_26563;
state_26563 = G__26604;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__ = function(state_26563){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____1.call(this,state_26563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26588 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26588[(6)] = c__11484__auto__);

return statearr_26588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_26685){
var state_val_26686 = (state_26685[(1)]);
if((state_val_26686 === (7))){
var state_26685__$1 = state_26685;
var statearr_26687_26725 = state_26685__$1;
(statearr_26687_26725[(2)] = flakes);

(statearr_26687_26725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (20))){
var inst_26642 = (state_26685[(7)]);
var inst_26675 = (state_26685[(2)]);
var inst_26634 = inst_26642;
var inst_26635 = inst_26675;
var state_26685__$1 = (function (){var statearr_26688 = state_26685;
(statearr_26688[(8)] = inst_26635);

(statearr_26688[(9)] = inst_26634);

return statearr_26688;
})();
var statearr_26689_26726 = state_26685__$1;
(statearr_26689_26726[(2)] = null);

(statearr_26689_26726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (1))){
var state_26685__$1 = state_26685;
var statearr_26690_26727 = state_26685__$1;
(statearr_26690_26727[(2)] = null);

(statearr_26690_26727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (4))){
var inst_26607 = (state_26685[(2)]);
var state_26685__$1 = state_26685;
var statearr_26691_26728 = state_26685__$1;
(statearr_26691_26728[(2)] = inst_26607);

(statearr_26691_26728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (15))){
var inst_26641 = (state_26685[(10)]);
var inst_26659 = inst_26641.o;
var state_26685__$1 = state_26685;
var statearr_26692_26729 = state_26685__$1;
(statearr_26692_26729[(2)] = inst_26659);

(statearr_26692_26729[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (13))){
var inst_26678 = (state_26685[(2)]);
var state_26685__$1 = state_26685;
var statearr_26693_26730 = state_26685__$1;
(statearr_26693_26730[(2)] = inst_26678);

(statearr_26693_26730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (6))){
var inst_26614 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_26685__$1 = state_26685;
var statearr_26694_26731 = state_26685__$1;
(statearr_26694_26731[(2)] = inst_26614);

(statearr_26694_26731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (17))){
var inst_26656 = (state_26685[(2)]);
var inst_26657 = fluree.db.util.async.throw_err(inst_26656);
var state_26685__$1 = state_26685;
var statearr_26695_26732 = state_26685__$1;
(statearr_26695_26732[(2)] = inst_26657);

(statearr_26695_26732[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (3))){
var inst_26683 = (state_26685[(2)]);
var state_26685__$1 = state_26685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26685__$1,inst_26683);
} else {
if((state_val_26686 === (12))){
var inst_26648 = (state_26685[(11)]);
var inst_26641 = (state_26685[(10)]);
var inst_26646 = inst_26641.p;
var inst_26647 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_26646);
var inst_26648__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_26647);
var inst_26649 = inst_26641.op;
var inst_26650 = inst_26649 === false;
var inst_26651 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_26648__$1);
var state_26685__$1 = (function (){var statearr_26696 = state_26685;
(statearr_26696[(11)] = inst_26648__$1);

(statearr_26696[(12)] = inst_26650);

return statearr_26696;
})();
if(inst_26651){
var statearr_26697_26733 = state_26685__$1;
(statearr_26697_26733[(1)] = (14));

} else {
var statearr_26698_26734 = state_26685__$1;
(statearr_26698_26734[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (2))){
var _ = (function (){var statearr_26699 = state_26685;
(statearr_26699[(4)] = cljs.core.cons((5),(state_26685[(4)])));

return statearr_26699;
})();
var state_26685__$1 = state_26685;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_26700_26735 = state_26685__$1;
(statearr_26700_26735[(1)] = (6));

} else {
var statearr_26701_26736 = state_26685__$1;
(statearr_26701_26736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (19))){
var inst_26648 = (state_26685[(11)]);
var inst_26661 = (state_26685[(13)]);
var inst_26641 = (state_26685[(10)]);
var inst_26635 = (state_26685[(8)]);
var inst_26669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26670 = inst_26641.s;
var inst_26671 = [inst_26670,inst_26648,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_26672 = (new cljs.core.PersistentVector(null,3,(5),inst_26669,inst_26671,null));
var inst_26673 = cljs.core.assoc_in(inst_26635,inst_26672,inst_26661);
var state_26685__$1 = state_26685;
var statearr_26702_26737 = state_26685__$1;
(statearr_26702_26737[(2)] = inst_26673);

(statearr_26702_26737[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (11))){
var inst_26635 = (state_26685[(8)]);
var state_26685__$1 = state_26685;
var statearr_26704_26738 = state_26685__$1;
(statearr_26704_26738[(2)] = inst_26635);

(statearr_26704_26738[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (9))){
var inst_26641 = (state_26685[(10)]);
var inst_26634 = (state_26685[(9)]);
var inst_26640 = cljs.core.seq(inst_26634);
var inst_26641__$1 = cljs.core.first(inst_26640);
var inst_26642 = cljs.core.next(inst_26640);
var inst_26643 = cljs.core.not(inst_26641__$1);
var state_26685__$1 = (function (){var statearr_26705 = state_26685;
(statearr_26705[(10)] = inst_26641__$1);

(statearr_26705[(7)] = inst_26642);

return statearr_26705;
})();
if(inst_26643){
var statearr_26706_26739 = state_26685__$1;
(statearr_26706_26739[(1)] = (11));

} else {
var statearr_26707_26740 = state_26685__$1;
(statearr_26707_26740[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (5))){
var _ = (function (){var statearr_26708 = state_26685;
(statearr_26708[(4)] = cljs.core.rest((state_26685[(4)])));

return statearr_26708;
})();
var state_26685__$1 = state_26685;
var ex26703 = (state_26685__$1[(2)]);
var statearr_26709_26741 = state_26685__$1;
(statearr_26709_26741[(5)] = ex26703);


if((ex26703 instanceof Error)){
var statearr_26710_26742 = state_26685__$1;
(statearr_26710_26742[(1)] = (4));

(statearr_26710_26742[(5)] = null);

} else {
throw ex26703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (14))){
var inst_26641 = (state_26685[(10)]);
var inst_26653 = inst_26641.o;
var inst_26654 = fluree.db.query.schema.convert_type_to_kw(inst_26653,db);
var state_26685__$1 = state_26685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26685__$1,(17),inst_26654);
} else {
if((state_val_26686 === (16))){
var inst_26650 = (state_26685[(12)]);
var inst_26661 = (state_26685[(2)]);
var state_26685__$1 = (function (){var statearr_26711 = state_26685;
(statearr_26711[(13)] = inst_26661);

return statearr_26711;
})();
if(cljs.core.truth_(inst_26650)){
var statearr_26712_26743 = state_26685__$1;
(statearr_26712_26743[(1)] = (18));

} else {
var statearr_26713_26744 = state_26685__$1;
(statearr_26713_26744[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (10))){
var inst_26680 = (state_26685[(2)]);
var _ = (function (){var statearr_26714 = state_26685;
(statearr_26714[(4)] = cljs.core.rest((state_26685[(4)])));

return statearr_26714;
})();
var state_26685__$1 = state_26685;
var statearr_26715_26745 = state_26685__$1;
(statearr_26715_26745[(2)] = inst_26680);

(statearr_26715_26745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (18))){
var inst_26648 = (state_26685[(11)]);
var inst_26661 = (state_26685[(13)]);
var inst_26641 = (state_26685[(10)]);
var inst_26635 = (state_26685[(8)]);
var inst_26663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26664 = inst_26641.s;
var inst_26665 = [inst_26664,inst_26648,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_26666 = (new cljs.core.PersistentVector(null,3,(5),inst_26663,inst_26665,null));
var inst_26667 = cljs.core.assoc_in(inst_26635,inst_26666,inst_26661);
var state_26685__$1 = state_26685;
var statearr_26716_26746 = state_26685__$1;
(statearr_26716_26746[(2)] = inst_26667);

(statearr_26716_26746[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26686 === (8))){
var inst_26617 = (state_26685[(2)]);
var inst_26618 = cljs.core.PersistentHashSet.EMPTY;
var inst_26619 = cljs.core.vals(tempids);
var inst_26620 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26618,inst_26619);
var inst_26621 = (function (){var pred_flakes = inst_26617;
var is_new_QMARK_ = inst_26620;
return (function (p1__26606_SHARP_,p2__26605_SHARP_){
var f = p2__26605_SHARP_;
return cljs.core.assoc_in(p1__26606_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__26717 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26717) : is_new_QMARK_.call(null,G__26717));
})()));
});
})();
var inst_26622 = cljs.core.PersistentHashMap.EMPTY;
var inst_26623 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26621,inst_26622,inst_26617);
var inst_26631 = cljs.core.seq(inst_26617);
var inst_26632 = cljs.core.first(inst_26631);
var inst_26633 = cljs.core.next(inst_26631);
var inst_26634 = inst_26617;
var inst_26635 = inst_26623;
var state_26685__$1 = (function (){var statearr_26718 = state_26685;
(statearr_26718[(14)] = inst_26633);

(statearr_26718[(15)] = inst_26632);

(statearr_26718[(8)] = inst_26635);

(statearr_26718[(9)] = inst_26634);

return statearr_26718;
})();
var statearr_26719_26747 = state_26685__$1;
(statearr_26719_26747[(2)] = null);

(statearr_26719_26747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____0 = (function (){
var statearr_26720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26720[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__);

(statearr_26720[(1)] = (1));

return statearr_26720;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____1 = (function (state_26685){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_26685);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e26721){var ex__11413__auto__ = e26721;
var statearr_26722_26748 = state_26685;
(statearr_26722_26748[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_26685[(4)]))){
var statearr_26723_26749 = state_26685;
(statearr_26723_26749[(1)] = cljs.core.first((state_26685[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26750 = state_26685;
state_26685 = G__26750;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__ = function(state_26685){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____1.call(this,state_26685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_26724 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_26724[(6)] = c__11484__auto__);

return statearr_26724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__26752 = arguments.length;
switch (G__26752) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__26755 = arguments.length;
switch (G__26755) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27067){
var state_val_27068 = (state_27067[(1)]);
if((state_val_27068 === (121))){
var inst_27022 = (state_27067[(7)]);
var state_27067__$1 = state_27067;
var statearr_27069_27262 = state_27067__$1;
(statearr_27069_27262[(2)] = inst_27022);

(statearr_27069_27262[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (65))){
var inst_26921 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26921)){
var statearr_27070_27263 = state_27067__$1;
(statearr_27070_27263[(1)] = (66));

} else {
var statearr_27071_27264 = state_27067__$1;
(statearr_27071_27264[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (70))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26931 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_26932 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_26931,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,3,inst_26931,null));
var inst_26933 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26932,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26932,null));
var inst_26934 = (inst_26933.cljs$core$IFn$_invoke$arity$1 ? inst_26933.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26933.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26934)){
var statearr_27072_27265 = state_27067__$1;
(statearr_27072_27265[(1)] = (72));

} else {
var statearr_27073_27266 = state_27067__$1;
(statearr_27073_27266[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (62))){
var inst_26911 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27074_27267 = state_27067__$1;
(statearr_27074_27267[(2)] = inst_26911);

(statearr_27074_27267[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (74))){
var inst_27017 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27075_27268 = state_27067__$1;
(statearr_27075_27268[(2)] = inst_27017);

(statearr_27075_27268[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (110))){
var inst_27044 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_27044)){
var statearr_27076_27269 = state_27067__$1;
(statearr_27076_27269[(1)] = (117));

} else {
var statearr_27077_27270 = state_27067__$1;
(statearr_27077_27270[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (7))){
var inst_27062 = (state_27067[(2)]);
var _ = (function (){var statearr_27078 = state_27067;
(statearr_27078[(4)] = cljs.core.rest((state_27067[(4)])));

return statearr_27078;
})();
var state_27067__$1 = state_27067;
var statearr_27079_27271 = state_27067__$1;
(statearr_27079_27271[(2)] = inst_27062);

(statearr_27079_27271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (59))){
var inst_26795 = (state_27067[(10)]);
var inst_26915 = (state_27067[(11)]);
var inst_26914 = (state_27067[(2)]);
var inst_26915__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27080 = state_27067;
(statearr_27080[(12)] = inst_26914);

(statearr_27080[(11)] = inst_26915__$1);

return statearr_27080;
})();
if(cljs.core.truth_(inst_26915__$1)){
var statearr_27081_27272 = state_27067__$1;
(statearr_27081_27272[(1)] = (63));

} else {
var statearr_27082_27273 = state_27067__$1;
(statearr_27082_27273[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (86))){
var inst_26957 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27083_27274 = state_27067__$1;
(statearr_27083_27274[(2)] = inst_26957);

(statearr_27083_27274[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (20))){
var inst_26795 = (state_27067[(10)]);
var inst_26821 = (state_27067[(13)]);
var inst_26821__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27084 = state_27067;
(statearr_27084[(13)] = inst_26821__$1);

return statearr_27084;
})();
if(cljs.core.truth_(inst_26821__$1)){
var statearr_27085_27275 = state_27067__$1;
(statearr_27085_27275[(1)] = (23));

} else {
var statearr_27086_27276 = state_27067__$1;
(statearr_27086_27276[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (72))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26936 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27087_27277 = state_27067__$1;
(statearr_27087_27277[(2)] = inst_26936);

(statearr_27087_27277[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (58))){
var inst_26876 = (state_27067[(14)]);
var state_27067__$1 = state_27067;
var statearr_27088_27278 = state_27067__$1;
(statearr_27088_27278[(2)] = inst_26876);

(statearr_27088_27278[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (60))){
var inst_26783 = (state_27067[(15)]);
var inst_26794 = (state_27067[(16)]);
var inst_26902 = fluree.db.dbproto._p_prop(inst_26783,new cljs.core.Keyword(null,"name","name",1843675177),inst_26794);
var inst_26903 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26902)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_26904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26905 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_26906 = cljs.core.PersistentHashMap.fromArrays(inst_26904,inst_26905);
var inst_26907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26903,inst_26906);
var inst_26908 = (function(){throw inst_26907})();
var state_27067__$1 = state_27067;
var statearr_27089_27279 = state_27067__$1;
(statearr_27089_27279[(2)] = inst_26908);

(statearr_27089_27279[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (27))){
var inst_26824 = (state_27067[(17)]);
var state_27067__$1 = state_27067;
var statearr_27090_27280 = state_27067__$1;
(statearr_27090_27280[(2)] = inst_26824);

(statearr_27090_27280[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (1))){
var state_27067__$1 = state_27067;
var statearr_27091_27281 = state_27067__$1;
(statearr_27091_27281[(2)] = null);

(statearr_27091_27281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (69))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27092_27282 = state_27067__$1;
(statearr_27092_27282[(2)] = inst_26914);

(statearr_27092_27282[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (101))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26995 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27093_27283 = state_27067__$1;
(statearr_27093_27283[(2)] = inst_26995);

(statearr_27093_27283[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (24))){
var inst_26821 = (state_27067[(13)]);
var state_27067__$1 = state_27067;
var statearr_27094_27284 = state_27067__$1;
(statearr_27094_27284[(2)] = inst_26821);

(statearr_27094_27284[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (102))){
var inst_26997 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27095_27285 = state_27067__$1;
(statearr_27095_27285[(2)] = inst_26997);

(statearr_27095_27285[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (55))){
var inst_26893 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27096_27286 = state_27067__$1;
(statearr_27096_27286[(2)] = inst_26893);

(statearr_27096_27286[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (85))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26955 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27097_27287 = state_27067__$1;
(statearr_27097_27287[(2)] = inst_26955);

(statearr_27097_27287[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (39))){
var inst_26858 = (state_27067[(18)]);
var state_27067__$1 = state_27067;
var statearr_27098_27288 = state_27067__$1;
(statearr_27098_27288[(2)] = inst_26858);

(statearr_27098_27288[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (88))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27099_27289 = state_27067__$1;
(statearr_27099_27289[(2)] = inst_26914);

(statearr_27099_27289[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (46))){
var inst_26795 = (state_27067[(10)]);
var inst_26877 = (state_27067[(19)]);
var inst_26876 = (state_27067[(2)]);
var inst_26877__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27100 = state_27067;
(statearr_27100[(14)] = inst_26876);

(statearr_27100[(19)] = inst_26877__$1);

return statearr_27100;
})();
if(cljs.core.truth_(inst_26877__$1)){
var statearr_27101_27290 = state_27067__$1;
(statearr_27101_27290[(1)] = (47));

} else {
var statearr_27102_27291 = state_27067__$1;
(statearr_27102_27291[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (4))){
var inst_26756 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27103_27292 = state_27067__$1;
(statearr_27103_27292[(2)] = inst_26756);

(statearr_27103_27292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (77))){
var inst_27015 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27104_27293 = state_27067__$1;
(statearr_27104_27293[(2)] = inst_27015);

(statearr_27104_27293[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (106))){
var inst_27007 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27105_27294 = state_27067__$1;
(statearr_27105_27294[(2)] = inst_27007);

(statearr_27105_27294[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (119))){
var inst_26793 = (state_27067[(20)]);
var inst_27057 = (state_27067[(2)]);
var inst_26782 = inst_26793;
var inst_26783 = inst_27057;
var state_27067__$1 = (function (){var statearr_27106 = state_27067;
(statearr_27106[(15)] = inst_26783);

(statearr_27106[(21)] = inst_26782);

return statearr_27106;
})();
var statearr_27107_27295 = state_27067__$1;
(statearr_27107_27295[(2)] = null);

(statearr_27107_27295[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (95))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26979 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26980 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_26979,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,5,inst_26979,null));
var inst_26981 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26980,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26980,null));
var inst_26982 = (inst_26981.cljs$core$IFn$_invoke$arity$1 ? inst_26981.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26981.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26982)){
var statearr_27108_27296 = state_27067__$1;
(statearr_27108_27296[(1)] = (96));

} else {
var statearr_27109_27297 = state_27067__$1;
(statearr_27109_27297[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (54))){
var inst_26884 = (state_27067[(22)]);
var state_27067__$1 = state_27067;
var statearr_27110_27298 = state_27067__$1;
(statearr_27110_27298[(2)] = inst_26884);

(statearr_27110_27298[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (92))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27111_27299 = state_27067__$1;
(statearr_27111_27299[(2)] = inst_26914);

(statearr_27111_27299[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (104))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27112_27300 = state_27067__$1;
(statearr_27112_27300[(2)] = inst_26914);

(statearr_27112_27300[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (15))){
var inst_26803 = (state_27067[(23)]);
var state_27067__$1 = state_27067;
var statearr_27113_27301 = state_27067__$1;
(statearr_27113_27301[(2)] = inst_26803);

(statearr_27113_27301[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (48))){
var inst_26877 = (state_27067[(19)]);
var state_27067__$1 = state_27067;
var statearr_27114_27302 = state_27067__$1;
(statearr_27114_27302[(2)] = inst_26877);

(statearr_27114_27302[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (50))){
var inst_26795 = (state_27067[(10)]);
var inst_26884 = (state_27067[(22)]);
var inst_26882 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26883 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26882);
var inst_26884__$1 = inst_26883 === true;
var state_27067__$1 = (function (){var statearr_27115 = state_27067;
(statearr_27115[(22)] = inst_26884__$1);

return statearr_27115;
})();
if(cljs.core.truth_(inst_26884__$1)){
var statearr_27116_27303 = state_27067__$1;
(statearr_27116_27303[(1)] = (53));

} else {
var statearr_27117_27304 = state_27067__$1;
(statearr_27117_27304[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (116))){
var inst_27038 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27118_27305 = state_27067__$1;
(statearr_27118_27305[(2)] = inst_27038);

(statearr_27118_27305[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (75))){
var inst_26927 = (state_27067[(9)]);
var state_27067__$1 = state_27067;
var G__27119_27306 = inst_26927;
var G__27119_27307__$1 = (((G__27119_27306 instanceof cljs.core.Keyword))?G__27119_27306.fqn:null);
switch (G__27119_27307__$1) {
case "long":
var statearr_27120_27309 = state_27067__$1;
(statearr_27120_27309[(1)] = (79));


break;
case "bigint":
var statearr_27121_27310 = state_27067__$1;
(statearr_27121_27310[(1)] = (83));


break;
case "double":
var statearr_27122_27311 = state_27067__$1;
(statearr_27122_27311[(1)] = (87));


break;
case "float":
var statearr_27123_27312 = state_27067__$1;
(statearr_27123_27312[(1)] = (91));


break;
case "bigdec":
var statearr_27124_27313 = state_27067__$1;
(statearr_27124_27313[(1)] = (95));


break;
case "string":
var statearr_27125_27314 = state_27067__$1;
(statearr_27125_27314[(1)] = (99));


break;
case "instant":
var statearr_27126_27315 = state_27067__$1;
(statearr_27126_27315[(1)] = (103));


break;
default:
var statearr_27127_27316 = state_27067__$1;
(statearr_27127_27316[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (99))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26989 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_26990 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_26989,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,5,inst_26989,null));
var inst_26991 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26990,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26990,null));
var inst_26992 = (inst_26991.cljs$core$IFn$_invoke$arity$1 ? inst_26991.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26991.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26992)){
var statearr_27128_27317 = state_27067__$1;
(statearr_27128_27317[(1)] = (100));

} else {
var statearr_27129_27318 = state_27067__$1;
(statearr_27129_27318[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (21))){
var inst_26819 = (state_27067[(24)]);
var state_27067__$1 = state_27067;
var statearr_27130_27319 = state_27067__$1;
(statearr_27130_27319[(2)] = inst_26819);

(statearr_27130_27319[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (31))){
var inst_26835 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27131_27320 = state_27067__$1;
(statearr_27131_27320[(2)] = inst_26835);

(statearr_27131_27320[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (113))){
var inst_27041 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27132_27321 = state_27067__$1;
(statearr_27132_27321[(2)] = inst_27041);

(statearr_27132_27321[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (32))){
var state_27067__$1 = state_27067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27133_27322 = state_27067__$1;
(statearr_27133_27322[(1)] = (35));

} else {
var statearr_27134_27323 = state_27067__$1;
(statearr_27134_27323[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (40))){
var inst_26871 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26871)){
var statearr_27135_27324 = state_27067__$1;
(statearr_27135_27324[(1)] = (44));

} else {
var statearr_27136_27325 = state_27067__$1;
(statearr_27136_27325[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (91))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26969 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26970 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_26969,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,3,inst_26969,null));
var inst_26971 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26970,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26970,null));
var inst_26972 = (inst_26971.cljs$core$IFn$_invoke$arity$1 ? inst_26971.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26971.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26972)){
var statearr_27137_27326 = state_27067__$1;
(statearr_27137_27326[(1)] = (92));

} else {
var statearr_27138_27327 = state_27067__$1;
(statearr_27138_27327[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (117))){
var state_27067__$1 = state_27067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27139_27328 = state_27067__$1;
(statearr_27139_27328[(1)] = (120));

} else {
var statearr_27140_27329 = state_27067__$1;
(statearr_27140_27329[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (108))){
var inst_26795 = (state_27067[(10)]);
var inst_27026 = (state_27067[(25)]);
var inst_27026__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27141 = state_27067;
(statearr_27141[(25)] = inst_27026__$1);

return statearr_27141;
})();
if(cljs.core.truth_(inst_27026__$1)){
var statearr_27142_27330 = state_27067__$1;
(statearr_27142_27330[(1)] = (111));

} else {
var statearr_27143_27331 = state_27067__$1;
(statearr_27143_27331[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (56))){
var inst_26888 = (state_27067[(2)]);
var inst_26889 = fluree.db.util.async.throw_err(inst_26888);
var inst_26890 = cljs.core.not(inst_26889);
var state_27067__$1 = state_27067;
var statearr_27144_27332 = state_27067__$1;
(statearr_27144_27332[(2)] = inst_26890);

(statearr_27144_27332[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (33))){
var inst_26818 = (state_27067[(26)]);
var state_27067__$1 = state_27067;
var statearr_27145_27333 = state_27067__$1;
(statearr_27145_27333[(2)] = inst_26818);

(statearr_27145_27333[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (13))){
var inst_26813 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26813)){
var statearr_27146_27334 = state_27067__$1;
(statearr_27146_27334[(1)] = (17));

} else {
var statearr_27147_27335 = state_27067__$1;
(statearr_27147_27335[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (22))){
var inst_26844 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26844)){
var statearr_27148_27336 = state_27067__$1;
(statearr_27148_27336[(1)] = (32));

} else {
var statearr_27149_27337 = state_27067__$1;
(statearr_27149_27337[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (90))){
var inst_26967 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27150_27338 = state_27067__$1;
(statearr_27150_27338[(2)] = inst_26967);

(statearr_27150_27338[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (109))){
var inst_27024 = (state_27067[(27)]);
var state_27067__$1 = state_27067;
var statearr_27151_27339 = state_27067__$1;
(statearr_27151_27339[(2)] = inst_27024);

(statearr_27151_27339[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (36))){
var inst_26818 = (state_27067[(26)]);
var state_27067__$1 = state_27067;
var statearr_27152_27340 = state_27067__$1;
(statearr_27152_27340[(2)] = inst_26818);

(statearr_27152_27340[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (41))){
var inst_26795 = (state_27067[(10)]);
var inst_26863 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26864 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26863);
var inst_26865 = inst_26864 === true;
var state_27067__$1 = state_27067;
var statearr_27153_27341 = state_27067__$1;
(statearr_27153_27341[(2)] = inst_26865);

(statearr_27153_27341[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (118))){
var inst_27022 = (state_27067[(7)]);
var state_27067__$1 = state_27067;
var statearr_27154_27342 = state_27067__$1;
(statearr_27154_27342[(2)] = inst_27022);

(statearr_27154_27342[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (89))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26965 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27155_27343 = state_27067__$1;
(statearr_27155_27343[(2)] = inst_26965);

(statearr_27155_27343[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (100))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27156_27344 = state_27067__$1;
(statearr_27156_27344[(2)] = inst_26914);

(statearr_27156_27344[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (122))){
var inst_27054 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27157_27345 = state_27067__$1;
(statearr_27157_27345[(2)] = inst_27054);

(statearr_27157_27345[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (43))){
var inst_26868 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27158_27346 = state_27067__$1;
(statearr_27158_27346[(2)] = inst_26868);

(statearr_27158_27346[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (61))){
var inst_26876 = (state_27067[(14)]);
var state_27067__$1 = state_27067;
var statearr_27159_27347 = state_27067__$1;
(statearr_27159_27347[(2)] = inst_26876);

(statearr_27159_27347[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (29))){
var inst_26795 = (state_27067[(10)]);
var inst_26830 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26831 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26830);
var inst_26832 = inst_26831 === true;
var state_27067__$1 = state_27067;
var statearr_27160_27348 = state_27067__$1;
(statearr_27160_27348[(2)] = inst_26832);

(statearr_27160_27348[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (44))){
var inst_26857 = (state_27067[(28)]);
var inst_26873 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_26857,"a component","a non-component",throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27161_27349 = state_27067__$1;
(statearr_27161_27349[(2)] = inst_26873);

(statearr_27161_27349[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (93))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26975 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27162_27350 = state_27067__$1;
(statearr_27162_27350[(2)] = inst_26975);

(statearr_27162_27350[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (6))){
var inst_26782 = (state_27067[(21)]);
var inst_26794 = (state_27067[(16)]);
var inst_26791 = cljs.core.seq(inst_26782);
var inst_26792 = cljs.core.first(inst_26791);
var inst_26793 = cljs.core.next(inst_26791);
var inst_26794__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26792,(0),null);
var inst_26795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26792,(1),null);
var inst_26796 = cljs.core.not(inst_26794__$1);
var state_27067__$1 = (function (){var statearr_27163 = state_27067;
(statearr_27163[(10)] = inst_26795);

(statearr_27163[(20)] = inst_26793);

(statearr_27163[(16)] = inst_26794__$1);

return statearr_27163;
})();
if(inst_26796){
var statearr_27164_27351 = state_27067__$1;
(statearr_27164_27351[(1)] = (8));

} else {
var statearr_27165_27352 = state_27067__$1;
(statearr_27165_27352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (111))){
var inst_26795 = (state_27067[(10)]);
var inst_27030 = (state_27067[(29)]);
var inst_27028 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_27029 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27028);
var inst_27030__$1 = inst_27029 === true;
var state_27067__$1 = (function (){var statearr_27166 = state_27067;
(statearr_27166[(29)] = inst_27030__$1);

return statearr_27166;
})();
if(cljs.core.truth_(inst_27030__$1)){
var statearr_27167_27353 = state_27067__$1;
(statearr_27167_27353[(1)] = (114));

} else {
var statearr_27168_27354 = state_27067__$1;
(statearr_27168_27354[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (28))){
var inst_26838 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27169_27355 = state_27067__$1;
(statearr_27169_27355[(2)] = inst_26838);

(statearr_27169_27355[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (64))){
var inst_26915 = (state_27067[(11)]);
var state_27067__$1 = state_27067;
var statearr_27170_27356 = state_27067__$1;
(statearr_27170_27356[(2)] = inst_26915);

(statearr_27170_27356[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (103))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26999 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27000 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_26999,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,2,inst_26999,null));
var inst_27001 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_27000,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_27000,null));
var inst_27002 = (inst_27001.cljs$core$IFn$_invoke$arity$1 ? inst_27001.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_27001.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_27002)){
var statearr_27171_27357 = state_27067__$1;
(statearr_27171_27357[(1)] = (104));

} else {
var statearr_27172_27358 = state_27067__$1;
(statearr_27172_27358[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (51))){
var inst_26880 = (state_27067[(30)]);
var state_27067__$1 = state_27067;
var statearr_27173_27359 = state_27067__$1;
(statearr_27173_27359[(2)] = inst_26880);

(statearr_27173_27359[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (25))){
var inst_26841 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27174_27360 = state_27067__$1;
(statearr_27174_27360[(2)] = inst_26841);

(statearr_27174_27360[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (34))){
var inst_26795 = (state_27067[(10)]);
var inst_26858 = (state_27067[(18)]);
var inst_26857 = (state_27067[(2)]);
var inst_26858__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27175 = state_27067;
(statearr_27175[(18)] = inst_26858__$1);

(statearr_27175[(28)] = inst_26857);

return statearr_27175;
})();
if(cljs.core.truth_(inst_26858__$1)){
var statearr_27176_27361 = state_27067__$1;
(statearr_27176_27361[(1)] = (38));

} else {
var statearr_27177_27362 = state_27067__$1;
(statearr_27177_27362[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (17))){
var inst_26783 = (state_27067[(15)]);
var inst_26815 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_26783,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27178_27363 = state_27067__$1;
(statearr_27178_27363[(2)] = inst_26815);

(statearr_27178_27363[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (3))){
var inst_27065 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27067__$1,inst_27065);
} else {
if((state_val_27068 === (12))){
var inst_26799 = (state_27067[(31)]);
var state_27067__$1 = state_27067;
var statearr_27179_27364 = state_27067__$1;
(statearr_27179_27364[(2)] = inst_26799);

(statearr_27179_27364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (2))){
var _ = (function (){var statearr_27180 = state_27067;
(statearr_27180[(4)] = cljs.core.cons((5),(state_27067[(4)])));

return statearr_27180;
})();
var inst_26775 = pred_changes;
var inst_26776 = cljs.core.seq(inst_26775);
var inst_26777 = cljs.core.first(inst_26776);
var inst_26778 = cljs.core.next(inst_26776);
var inst_26779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26777,(0),null);
var inst_26780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26777,(1),null);
var inst_26781 = db;
var inst_26782 = inst_26775;
var inst_26783 = inst_26781;
var state_27067__$1 = (function (){var statearr_27181 = state_27067;
(statearr_27181[(32)] = inst_26780);

(statearr_27181[(15)] = inst_26783);

(statearr_27181[(21)] = inst_26782);

(statearr_27181[(33)] = inst_26778);

(statearr_27181[(34)] = inst_26779);

return statearr_27181;
})();
var statearr_27182_27365 = state_27067__$1;
(statearr_27182_27365[(2)] = null);

(statearr_27182_27365[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (66))){
var inst_26926 = (state_27067[(8)]);
var inst_26795 = (state_27067[(10)]);
var inst_26927 = (state_27067[(9)]);
var inst_26924 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26925 = cljs.core.__destructure_map(inst_26924);
var inst_26926__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26925,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_26927__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26925,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_26928 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26927__$1,inst_26926__$1);
var state_27067__$1 = (function (){var statearr_27183 = state_27067;
(statearr_27183[(8)] = inst_26926__$1);

(statearr_27183[(9)] = inst_26927__$1);

return statearr_27183;
})();
if(inst_26928){
var statearr_27184_27366 = state_27067__$1;
(statearr_27184_27366[(1)] = (69));

} else {
var statearr_27185_27367 = state_27067__$1;
(statearr_27185_27367[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (107))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_27009 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27186_27368 = state_27067__$1;
(statearr_27186_27368[(2)] = inst_27009);

(statearr_27186_27368[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (23))){
var inst_26795 = (state_27067[(10)]);
var inst_26824 = (state_27067[(17)]);
var inst_26823 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26824__$1 = inst_26823 === true;
var state_27067__$1 = (function (){var statearr_27187 = state_27067;
(statearr_27187[(17)] = inst_26824__$1);

return statearr_27187;
})();
if(cljs.core.truth_(inst_26824__$1)){
var statearr_27188_27369 = state_27067__$1;
(statearr_27188_27369[(1)] = (26));

} else {
var statearr_27189_27370 = state_27067__$1;
(statearr_27189_27370[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (47))){
var inst_26795 = (state_27067[(10)]);
var inst_26880 = (state_27067[(30)]);
var inst_26879 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26880__$1 = cljs.core.not(inst_26879);
var state_27067__$1 = (function (){var statearr_27190 = state_27067;
(statearr_27190[(30)] = inst_26880__$1);

return statearr_27190;
})();
if(inst_26880__$1){
var statearr_27191_27371 = state_27067__$1;
(statearr_27191_27371[(1)] = (50));

} else {
var statearr_27192_27372 = state_27067__$1;
(statearr_27192_27372[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (35))){
var inst_26847 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26848 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_26849 = cljs.core.PersistentHashMap.fromArrays(inst_26847,inst_26848);
var inst_26850 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_26849);
var inst_26851 = (function(){throw inst_26850})();
var state_27067__$1 = state_27067;
var statearr_27193_27373 = state_27067__$1;
(statearr_27193_27373[(2)] = inst_26851);

(statearr_27193_27373[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (82))){
var inst_26947 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27194_27374 = state_27067__$1;
(statearr_27194_27374[(2)] = inst_26947);

(statearr_27194_27374[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (76))){
var state_27067__$1 = state_27067;
var statearr_27195_27375 = state_27067__$1;
(statearr_27195_27375[(2)] = null);

(statearr_27195_27375[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (97))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26985 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27196_27376 = state_27067__$1;
(statearr_27196_27376[(2)] = inst_26985);

(statearr_27196_27376[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (19))){
var inst_26795 = (state_27067[(10)]);
var inst_26819 = (state_27067[(24)]);
var inst_26818 = (state_27067[(2)]);
var inst_26819__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27197 = state_27067;
(statearr_27197[(26)] = inst_26818);

(statearr_27197[(24)] = inst_26819__$1);

return statearr_27197;
})();
if(cljs.core.truth_(inst_26819__$1)){
var statearr_27198_27377 = state_27067__$1;
(statearr_27198_27377[(1)] = (20));

} else {
var statearr_27199_27378 = state_27067__$1;
(statearr_27199_27378[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (57))){
var state_27067__$1 = state_27067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27200_27379 = state_27067__$1;
(statearr_27200_27379[(1)] = (60));

} else {
var statearr_27201_27380 = state_27067__$1;
(statearr_27201_27380[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (68))){
var inst_26795 = (state_27067[(10)]);
var inst_27024 = (state_27067[(27)]);
var inst_27022 = (state_27067[(2)]);
var inst_27023 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_27024__$1 = inst_27023 === true;
var state_27067__$1 = (function (){var statearr_27202 = state_27067;
(statearr_27202[(27)] = inst_27024__$1);

(statearr_27202[(7)] = inst_27022);

return statearr_27202;
})();
if(cljs.core.truth_(inst_27024__$1)){
var statearr_27203_27381 = state_27067__$1;
(statearr_27203_27381[(1)] = (108));

} else {
var statearr_27204_27382 = state_27067__$1;
(statearr_27204_27382[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (11))){
var inst_26795 = (state_27067[(10)]);
var inst_26803 = (state_27067[(23)]);
var inst_26801 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26802 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26801);
var inst_26803__$1 = inst_26802 === false;
var state_27067__$1 = (function (){var statearr_27205 = state_27067;
(statearr_27205[(23)] = inst_26803__$1);

return statearr_27205;
})();
if(cljs.core.truth_(inst_26803__$1)){
var statearr_27206_27383 = state_27067__$1;
(statearr_27206_27383[(1)] = (14));

} else {
var statearr_27207_27384 = state_27067__$1;
(statearr_27207_27384[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (115))){
var inst_27030 = (state_27067[(29)]);
var state_27067__$1 = state_27067;
var statearr_27209_27385 = state_27067__$1;
(statearr_27209_27385[(2)] = inst_27030);

(statearr_27209_27385[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (9))){
var inst_26795 = (state_27067[(10)]);
var inst_26799 = (state_27067[(31)]);
var inst_26799__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26795);
var state_27067__$1 = (function (){var statearr_27210 = state_27067;
(statearr_27210[(31)] = inst_26799__$1);

return statearr_27210;
})();
if(cljs.core.truth_(inst_26799__$1)){
var statearr_27211_27386 = state_27067__$1;
(statearr_27211_27386[(1)] = (11));

} else {
var statearr_27212_27387 = state_27067__$1;
(statearr_27212_27387[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (5))){
var _ = (function (){var statearr_27213 = state_27067;
(statearr_27213[(4)] = cljs.core.rest((state_27067[(4)])));

return statearr_27213;
})();
var state_27067__$1 = state_27067;
var ex27208 = (state_27067__$1[(2)]);
var statearr_27214_27388 = state_27067__$1;
(statearr_27214_27388[(5)] = ex27208);


if((ex27208 instanceof Error)){
var statearr_27215_27389 = state_27067__$1;
(statearr_27215_27389[(1)] = (4));

(statearr_27215_27389[(5)] = null);

} else {
throw ex27208;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (112))){
var inst_27026 = (state_27067[(25)]);
var state_27067__$1 = state_27067;
var statearr_27216_27390 = state_27067__$1;
(statearr_27216_27390[(2)] = inst_27026);

(statearr_27216_27390[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (83))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26949 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_26950 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_26949,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,3,inst_26949,null));
var inst_26951 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26950,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26950,null));
var inst_26952 = (inst_26951.cljs$core$IFn$_invoke$arity$1 ? inst_26951.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26951.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26952)){
var statearr_27217_27391 = state_27067__$1;
(statearr_27217_27391[(1)] = (84));

} else {
var statearr_27218_27392 = state_27067__$1;
(statearr_27218_27392[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (14))){
var inst_26795 = (state_27067[(10)]);
var inst_26805 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26806 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_26805);
var inst_26807 = inst_26806 === true;
var state_27067__$1 = state_27067;
var statearr_27219_27393 = state_27067__$1;
(statearr_27219_27393[(2)] = inst_26807);

(statearr_27219_27393[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (45))){
var inst_26857 = (state_27067[(28)]);
var state_27067__$1 = state_27067;
var statearr_27220_27394 = state_27067__$1;
(statearr_27220_27394[(2)] = inst_26857);

(statearr_27220_27394[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (53))){
var inst_26783 = (state_27067[(15)]);
var inst_26794 = (state_27067[(16)]);
var inst_26886 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_26783,inst_26794);
var state_27067__$1 = state_27067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27067__$1,(56),inst_26886);
} else {
if((state_val_27068 === (78))){
var inst_27012 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27221_27395 = state_27067__$1;
(statearr_27221_27395[(2)] = inst_27012);

(statearr_27221_27395[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (26))){
var inst_26795 = (state_27067[(10)]);
var inst_26828 = (state_27067[(35)]);
var inst_26826 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26827 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26826);
var inst_26828__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_26827);
var state_27067__$1 = (function (){var statearr_27222 = state_27067;
(statearr_27222[(35)] = inst_26828__$1);

return statearr_27222;
})();
if(inst_26828__$1){
var statearr_27223_27396 = state_27067__$1;
(statearr_27223_27396[(1)] = (29));

} else {
var statearr_27224_27397 = state_27067__$1;
(statearr_27224_27397[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (16))){
var inst_26810 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27225_27398 = state_27067__$1;
(statearr_27225_27398[(2)] = inst_26810);

(statearr_27225_27398[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (81))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26945 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27226_27399 = state_27067__$1;
(statearr_27226_27399[(2)] = inst_26945);

(statearr_27226_27399[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (120))){
var inst_27047 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27048 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27049 = cljs.core.PersistentHashMap.fromArrays(inst_27047,inst_27048);
var inst_27050 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_27049);
var inst_27051 = (function(){throw inst_27050})();
var state_27067__$1 = state_27067;
var statearr_27227_27400 = state_27067__$1;
(statearr_27227_27400[(2)] = inst_27051);

(statearr_27227_27400[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (79))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26939 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_26940 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_26939,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,2,inst_26939,null));
var inst_26941 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26940,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26940,null));
var inst_26942 = (inst_26941.cljs$core$IFn$_invoke$arity$1 ? inst_26941.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26941.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26942)){
var statearr_27228_27401 = state_27067__$1;
(statearr_27228_27401[(1)] = (80));

} else {
var statearr_27229_27402 = state_27067__$1;
(statearr_27229_27402[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (38))){
var inst_26861 = (state_27067[(36)]);
var inst_26795 = (state_27067[(10)]);
var inst_26860 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26861__$1 = cljs.core.not(inst_26860);
var state_27067__$1 = (function (){var statearr_27230 = state_27067;
(statearr_27230[(36)] = inst_26861__$1);

return statearr_27230;
})();
if(inst_26861__$1){
var statearr_27231_27403 = state_27067__$1;
(statearr_27231_27403[(1)] = (41));

} else {
var statearr_27232_27404 = state_27067__$1;
(statearr_27232_27404[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (98))){
var inst_26987 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27233_27405 = state_27067__$1;
(statearr_27233_27405[(2)] = inst_26987);

(statearr_27233_27405[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (87))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_26959 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26960 = (inst_26927.cljs$core$IFn$_invoke$arity$5 ? inst_26927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_26959,null) : inst_26927.call(null,cljs.core.PersistentArrayMap,null,3,inst_26959,null));
var inst_26961 = (inst_26927.cljs$core$IFn$_invoke$arity$4 ? inst_26927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_26960,null) : inst_26927.call(null,cljs.core.PersistentHashSet,null,inst_26960,null));
var inst_26962 = (inst_26961.cljs$core$IFn$_invoke$arity$1 ? inst_26961.cljs$core$IFn$_invoke$arity$1(inst_26926) : inst_26961.call(null,inst_26926));
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26962)){
var statearr_27234_27406 = state_27067__$1;
(statearr_27234_27406[(1)] = (88));

} else {
var statearr_27235_27407 = state_27067__$1;
(statearr_27235_27407[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (30))){
var inst_26828 = (state_27067[(35)]);
var state_27067__$1 = state_27067;
var statearr_27236_27408 = state_27067__$1;
(statearr_27236_27408[(2)] = inst_26828);

(statearr_27236_27408[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (73))){
var state_27067__$1 = state_27067;
var statearr_27237_27409 = state_27067__$1;
(statearr_27237_27409[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (96))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27239_27410 = state_27067__$1;
(statearr_27239_27410[(2)] = inst_26914);

(statearr_27239_27410[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (10))){
var inst_27060 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27240_27411 = state_27067__$1;
(statearr_27240_27411[(2)] = inst_27060);

(statearr_27240_27411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (18))){
var inst_26783 = (state_27067[(15)]);
var state_27067__$1 = state_27067;
var statearr_27241_27412 = state_27067__$1;
(statearr_27241_27412[(2)] = inst_26783);

(statearr_27241_27412[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (105))){
var inst_26926 = (state_27067[(8)]);
var inst_26927 = (state_27067[(9)]);
var inst_27005 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_26926,inst_26927,throw_QMARK_);
var state_27067__$1 = state_27067;
var statearr_27242_27413 = state_27067__$1;
(statearr_27242_27413[(2)] = inst_27005);

(statearr_27242_27413[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (52))){
var inst_26896 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27243_27414 = state_27067__$1;
(statearr_27243_27414[(2)] = inst_26896);

(statearr_27243_27414[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (114))){
var inst_26795 = (state_27067[(10)]);
var inst_27032 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_27033 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27032);
var inst_27034 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_27033);
var inst_27035 = (!(inst_27034));
var state_27067__$1 = state_27067;
var statearr_27244_27415 = state_27067__$1;
(statearr_27244_27415[(2)] = inst_27035);

(statearr_27244_27415[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (67))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27245_27416 = state_27067__$1;
(statearr_27245_27416[(2)] = inst_26914);

(statearr_27245_27416[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (71))){
var inst_27019 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27246_27417 = state_27067__$1;
(statearr_27246_27417[(2)] = inst_27019);

(statearr_27246_27417[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (42))){
var inst_26861 = (state_27067[(36)]);
var state_27067__$1 = state_27067;
var statearr_27247_27418 = state_27067__$1;
(statearr_27247_27418[(2)] = inst_26861);

(statearr_27247_27418[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (80))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27248_27419 = state_27067__$1;
(statearr_27248_27419[(2)] = inst_26914);

(statearr_27248_27419[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (37))){
var inst_26854 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27249_27420 = state_27067__$1;
(statearr_27249_27420[(2)] = inst_26854);

(statearr_27249_27420[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (63))){
var inst_26795 = (state_27067[(10)]);
var inst_26917 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26795);
var inst_26918 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_26917);
var state_27067__$1 = state_27067;
var statearr_27250_27421 = state_27067__$1;
(statearr_27250_27421[(2)] = inst_26918);

(statearr_27250_27421[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (94))){
var inst_26977 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
var statearr_27251_27422 = state_27067__$1;
(statearr_27251_27422[(2)] = inst_26977);

(statearr_27251_27422[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (8))){
var inst_26783 = (state_27067[(15)]);
var state_27067__$1 = state_27067;
var statearr_27252_27423 = state_27067__$1;
(statearr_27252_27423[(2)] = inst_26783);

(statearr_27252_27423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (49))){
var inst_26899 = (state_27067[(2)]);
var state_27067__$1 = state_27067;
if(cljs.core.truth_(inst_26899)){
var statearr_27253_27424 = state_27067__$1;
(statearr_27253_27424[(1)] = (57));

} else {
var statearr_27254_27425 = state_27067__$1;
(statearr_27254_27425[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27068 === (84))){
var inst_26914 = (state_27067[(12)]);
var state_27067__$1 = state_27067;
var statearr_27255_27426 = state_27067__$1;
(statearr_27255_27426[(2)] = inst_26914);

(statearr_27255_27426[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__11410__auto__ = null;
var fluree$db$query$schema$state_machine__11410__auto____0 = (function (){
var statearr_27256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27256[(0)] = fluree$db$query$schema$state_machine__11410__auto__);

(statearr_27256[(1)] = (1));

return statearr_27256;
});
var fluree$db$query$schema$state_machine__11410__auto____1 = (function (state_27067){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27067);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e27257){var ex__11413__auto__ = e27257;
var statearr_27258_27427 = state_27067;
(statearr_27258_27427[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27067[(4)]))){
var statearr_27259_27428 = state_27067;
(statearr_27259_27428[(1)] = cljs.core.first((state_27067[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27429 = state_27067;
state_27067 = G__27429;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__11410__auto__ = function(state_27067){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__11410__auto____1.call(this,state_27067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__11410__auto____0;
fluree$db$query$schema$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__11410__auto____1;
return fluree$db$query$schema$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_27260 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_27260[(6)] = c__11484__auto__);

return statearr_27260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__27431 = arguments.length;
switch (G__27431) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27455){
var state_val_27456 = (state_27455[(1)]);
if((state_val_27456 === (7))){
var state_27455__$1 = state_27455;
var statearr_27457_27477 = state_27455__$1;
(statearr_27457_27477[(2)] = db);

(statearr_27457_27477[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (1))){
var state_27455__$1 = state_27455;
var statearr_27458_27478 = state_27455__$1;
(statearr_27458_27478[(2)] = null);

(statearr_27458_27478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (4))){
var inst_27432 = (state_27455[(2)]);
var state_27455__$1 = state_27455;
var statearr_27459_27479 = state_27455__$1;
(statearr_27459_27479[(2)] = inst_27432);

(statearr_27459_27479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (6))){
var inst_27441 = (state_27455[(7)]);
var inst_27440 = (state_27455[(2)]);
var inst_27441__$1 = fluree.db.util.async.throw_err(inst_27440);
var inst_27442 = cljs.core.empty_QMARK_(inst_27441__$1);
var state_27455__$1 = (function (){var statearr_27460 = state_27455;
(statearr_27460[(7)] = inst_27441__$1);

return statearr_27460;
})();
if(inst_27442){
var statearr_27461_27480 = state_27455__$1;
(statearr_27461_27480[(1)] = (7));

} else {
var statearr_27462_27481 = state_27455__$1;
(statearr_27462_27481[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (3))){
var inst_27453 = (state_27455[(2)]);
var state_27455__$1 = state_27455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27455__$1,inst_27453);
} else {
if((state_val_27456 === (2))){
var _ = (function (){var statearr_27464 = state_27455;
(statearr_27464[(4)] = cljs.core.cons((5),(state_27455[(4)])));

return statearr_27464;
})();
var inst_27438 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_27455__$1 = state_27455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27455__$1,(6),inst_27438);
} else {
if((state_val_27456 === (9))){
var inst_27450 = (state_27455[(2)]);
var _ = (function (){var statearr_27465 = state_27455;
(statearr_27465[(4)] = cljs.core.rest((state_27455[(4)])));

return statearr_27465;
})();
var state_27455__$1 = state_27455;
var statearr_27466_27482 = state_27455__$1;
(statearr_27466_27482[(2)] = inst_27450);

(statearr_27466_27482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (5))){
var _ = (function (){var statearr_27467 = state_27455;
(statearr_27467[(4)] = cljs.core.rest((state_27455[(4)])));

return statearr_27467;
})();
var state_27455__$1 = state_27455;
var ex27463 = (state_27455__$1[(2)]);
var statearr_27468_27483 = state_27455__$1;
(statearr_27468_27483[(5)] = ex27463);


if((ex27463 instanceof Error)){
var statearr_27469_27484 = state_27455__$1;
(statearr_27469_27484[(1)] = (4));

(statearr_27469_27484[(5)] = null);

} else {
throw ex27463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (10))){
var inst_27447 = (state_27455[(2)]);
var inst_27448 = fluree.db.util.async.throw_err(inst_27447);
var state_27455__$1 = state_27455;
var statearr_27470_27485 = state_27455__$1;
(statearr_27470_27485[(2)] = inst_27448);

(statearr_27470_27485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27456 === (8))){
var inst_27441 = (state_27455[(7)]);
var inst_27445 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_27441,db,true);
var state_27455__$1 = state_27455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27455__$1,(10),inst_27445);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__11410__auto__ = null;
var fluree$db$query$schema$state_machine__11410__auto____0 = (function (){
var statearr_27471 = [null,null,null,null,null,null,null,null];
(statearr_27471[(0)] = fluree$db$query$schema$state_machine__11410__auto__);

(statearr_27471[(1)] = (1));

return statearr_27471;
});
var fluree$db$query$schema$state_machine__11410__auto____1 = (function (state_27455){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27455);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e27472){var ex__11413__auto__ = e27472;
var statearr_27473_27486 = state_27455;
(statearr_27473_27486[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27455[(4)]))){
var statearr_27474_27487 = state_27455;
(statearr_27474_27487[(1)] = cljs.core.first((state_27455[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27488 = state_27455;
state_27455 = G__27488;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__11410__auto__ = function(state_27455){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__11410__auto____1.call(this,state_27455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__11410__auto____0;
fluree$db$query$schema$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__11410__auto____1;
return fluree$db$query$schema$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_27475 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_27475[(6)] = c__11484__auto__);

return statearr_27475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__27490 = arguments.length;
switch (G__27490) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__27492 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27492,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27492,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27492,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__27495_SHARP_,p2__27496_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27495_SHARP_,p2__27496_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__27497_SHARP_){
var f = p1__27497_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27563){
var state_val_27564 = (state_27563[(1)]);
if((state_val_27564 === (1))){
var state_27563__$1 = state_27563;
var statearr_27565_27583 = state_27563__$1;
(statearr_27565_27583[(2)] = null);

(statearr_27565_27583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (2))){
var _ = (function (){var statearr_27566 = state_27563;
(statearr_27566[(4)] = cljs.core.cons((5),(state_27563[(4)])));

return statearr_27566;
})();
var inst_27515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27516 = fluree.db.flake.max_subject_id((1));
var inst_27517 = [inst_27516];
var inst_27518 = (new cljs.core.PersistentVector(null,1,(5),inst_27515,inst_27517,null));
var inst_27519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27520 = [(0)];
var inst_27521 = (new cljs.core.PersistentVector(null,1,(5),inst_27519,inst_27520,null));
var inst_27522 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_27518,cljs.core._LT__EQ_,inst_27521);
var state_27563__$1 = state_27563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27563__$1,(6),inst_27522);
} else {
if((state_val_27564 === (3))){
var inst_27561 = (state_27563[(2)]);
var state_27563__$1 = state_27563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27563__$1,inst_27561);
} else {
if((state_val_27564 === (4))){
var inst_27503 = (state_27563[(2)]);
var state_27563__$1 = state_27563;
var statearr_27568_27584 = state_27563__$1;
(statearr_27568_27584[(2)] = inst_27503);

(statearr_27568_27584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (5))){
var _ = (function (){var statearr_27569 = state_27563;
(statearr_27569[(4)] = cljs.core.rest((state_27563[(4)])));

return statearr_27569;
})();
var state_27563__$1 = state_27563;
var ex27567 = (state_27563__$1[(2)]);
var statearr_27570_27585 = state_27563__$1;
(statearr_27570_27585[(5)] = ex27567);


if((ex27567 instanceof Error)){
var statearr_27571_27586 = state_27563__$1;
(statearr_27571_27586[(1)] = (4));

(statearr_27571_27586[(5)] = null);

} else {
throw ex27567;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27564 === (6))){
var inst_27524 = (state_27563[(2)]);
var inst_27525 = fluree.db.util.async.throw_err(inst_27524);
var inst_27526 = (function (){var schema_flakes = inst_27525;
return (function (p1__27498_SHARP_){
return (p1__27498_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_27527 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_27526,inst_27525);
var inst_27528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27527,(0),null);
var inst_27529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27527,(1),null);
var inst_27530 = (function (){var schema_flakes = inst_27525;
var vec__27509 = inst_27527;
var collection_flakes = inst_27528;
var predicate_flakes = inst_27529;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__27501_SHARP_,p2__27500_SHARP_){
var f = p2__27500_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__27501_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_27531 = [(-1),"_tx"];
var inst_27532 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_27533 = ["_tx",(-1),(-1),(-1),null,null];
var inst_27534 = cljs.core.PersistentHashMap.fromArrays(inst_27532,inst_27533);
var inst_27535 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_27536 = ["_tx",(-1),(-1),(-1),null,null];
var inst_27537 = cljs.core.PersistentHashMap.fromArrays(inst_27535,inst_27536);
var inst_27538 = [inst_27534,inst_27537];
var inst_27539 = cljs.core.PersistentHashMap.fromArrays(inst_27531,inst_27538);
var inst_27540 = (function (){var schema_flakes = inst_27525;
var vec__27509 = inst_27527;
var collection_flakes = inst_27528;
var predicate_flakes = inst_27529;
return (function (p1__27499_SHARP_){
return p1__27499_SHARP_.s;
});
})();
var inst_27541 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_27540,inst_27528);
var inst_27542 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27530,inst_27539,inst_27541);
var inst_27544 = (function (){var schema_flakes = inst_27525;
var vec__27509 = inst_27527;
var collection_flakes = inst_27528;
var predicate_flakes = inst_27529;
var coll = inst_27542;
return (function (p__27543,pred_flakes){
var vec__27572 = p__27543;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27572,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27572,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__27575 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__27575.cljs$core$IFn$_invoke$arity$1 ? fexpr__27575.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__27575.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_27545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27546 = cljs.core.PersistentHashMap.EMPTY;
var inst_27547 = cljs.core.PersistentHashSet.EMPTY;
var inst_27548 = [inst_27546,inst_27547];
var inst_27549 = (new cljs.core.PersistentVector(null,2,(5),inst_27545,inst_27548,null));
var inst_27550 = (function (){var schema_flakes = inst_27525;
var vec__27509 = inst_27527;
var collection_flakes = inst_27528;
var predicate_flakes = inst_27529;
var coll = inst_27542;
return (function (p1__27502_SHARP_){
return p1__27502_SHARP_.s;
});
})();
var inst_27551 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_27550,inst_27529);
var inst_27552 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27544,inst_27549,inst_27551);
var inst_27553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27552,(0),null);
var inst_27554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27552,(1),null);
var inst_27555 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_27556 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27557 = [inst_27556,inst_27542,inst_27553,inst_27554];
var inst_27558 = cljs.core.PersistentHashMap.fromArrays(inst_27555,inst_27557);
var _ = (function (){var statearr_27576 = state_27563;
(statearr_27576[(4)] = cljs.core.rest((state_27563[(4)])));

return statearr_27576;
})();
var state_27563__$1 = state_27563;
var statearr_27577_27587 = state_27563__$1;
(statearr_27577_27587[(2)] = inst_27558);

(statearr_27577_27587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__11410__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__11410__auto____0 = (function (){
var statearr_27578 = [null,null,null,null,null,null,null];
(statearr_27578[(0)] = fluree$db$query$schema$schema_map_$_state_machine__11410__auto__);

(statearr_27578[(1)] = (1));

return statearr_27578;
});
var fluree$db$query$schema$schema_map_$_state_machine__11410__auto____1 = (function (state_27563){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27563);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e27579){var ex__11413__auto__ = e27579;
var statearr_27580_27588 = state_27563;
(statearr_27580_27588[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27563[(4)]))){
var statearr_27581_27589 = state_27563;
(statearr_27581_27589[(1)] = cljs.core.first((state_27563[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27590 = state_27563;
state_27563 = G__27590;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__11410__auto__ = function(state_27563){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__11410__auto____1.call(this,state_27563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__11410__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__11410__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_27582 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_27582[(6)] = c__11484__auto__);

return statearr_27582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27632){
var state_val_27633 = (state_27632[(1)]);
if((state_val_27633 === (7))){
var inst_27615 = (state_27632[(2)]);
var inst_27616 = fluree.db.query.schema.flake__GT_pred_map(inst_27615);
var inst_27617 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_27618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(114));
var inst_27619 = cljs.core.boolean$(inst_27618);
var inst_27620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(110));
var inst_27621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(117));
var inst_27622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_27621);
var inst_27623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(111));
var inst_27624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(115));
var inst_27625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27616,(112));
var inst_27626 = [inst_27619,inst_27620,inst_27622,inst_27623,inst_27624,inst_27625];
var inst_27627 = cljs.core.PersistentHashMap.fromArrays(inst_27617,inst_27626);
var _ = (function (){var statearr_27634 = state_27632;
(statearr_27634[(4)] = cljs.core.rest((state_27632[(4)])));

return statearr_27634;
})();
var state_27632__$1 = state_27632;
var statearr_27635_27658 = state_27632__$1;
(statearr_27635_27658[(2)] = inst_27627);

(statearr_27635_27658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (1))){
var state_27632__$1 = state_27632;
var statearr_27636_27659 = state_27632__$1;
(statearr_27636_27659[(2)] = null);

(statearr_27636_27659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (4))){
var inst_27591 = (state_27632[(2)]);
var state_27632__$1 = state_27632;
var statearr_27637_27660 = state_27632__$1;
(statearr_27637_27660[(2)] = inst_27591);

(statearr_27637_27660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (6))){
var _ = (function (){var statearr_27638 = state_27632;
(statearr_27638[(4)] = cljs.core.cons((9),(state_27632[(4)])));

return statearr_27638;
})();
var inst_27603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27605 = ["_setting/id","root"];
var inst_27606 = (new cljs.core.PersistentVector(null,2,(5),inst_27604,inst_27605,null));
var inst_27607 = [inst_27606];
var inst_27608 = (new cljs.core.PersistentVector(null,1,(5),inst_27603,inst_27607,null));
var inst_27609 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27608);
var state_27632__$1 = state_27632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27632__$1,(10),inst_27609);
} else {
if((state_val_27633 === (3))){
var inst_27630 = (state_27632[(2)]);
var state_27632__$1 = state_27632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27632__$1,inst_27630);
} else {
if((state_val_27633 === (2))){
var _ = (function (){var statearr_27641 = state_27632;
(statearr_27641[(4)] = cljs.core.cons((5),(state_27632[(4)])));

return statearr_27641;
})();
var state_27632__$1 = state_27632;
var statearr_27642_27661 = state_27632__$1;
(statearr_27642_27661[(2)] = null);

(statearr_27642_27661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (9))){
var _ = (function (){var statearr_27643 = state_27632;
(statearr_27643[(4)] = cljs.core.rest((state_27632[(4)])));

return statearr_27643;
})();
var state_27632__$1 = state_27632;
var ex27639 = (state_27632__$1[(2)]);
var statearr_27644_27662 = state_27632__$1;
(statearr_27644_27662[(5)] = ex27639);


var statearr_27645_27663 = state_27632__$1;
(statearr_27645_27663[(1)] = (8));

(statearr_27645_27663[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (5))){
var _ = (function (){var statearr_27646 = state_27632;
(statearr_27646[(4)] = cljs.core.rest((state_27632[(4)])));

return statearr_27646;
})();
var state_27632__$1 = state_27632;
var ex27640 = (state_27632__$1[(2)]);
var statearr_27647_27664 = state_27632__$1;
(statearr_27647_27664[(5)] = ex27640);


if((ex27640 instanceof Error)){
var statearr_27648_27665 = state_27632__$1;
(statearr_27648_27665[(1)] = (4));

(statearr_27648_27665[(5)] = null);

} else {
throw ex27640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (10))){
var inst_27611 = (state_27632[(2)]);
var inst_27612 = fluree.db.util.async.throw_err(inst_27611);
var _ = (function (){var statearr_27649 = state_27632;
(statearr_27649[(4)] = cljs.core.rest((state_27632[(4)])));

return statearr_27649;
})();
var state_27632__$1 = state_27632;
var statearr_27650_27666 = state_27632__$1;
(statearr_27650_27666[(2)] = inst_27612);

(statearr_27650_27666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27633 === (8))){
var inst_27597 = (state_27632[(2)]);
var state_27632__$1 = (function (){var statearr_27651 = state_27632;
(statearr_27651[(7)] = inst_27597);

return statearr_27651;
})();
var statearr_27652_27667 = state_27632__$1;
(statearr_27652_27667[(2)] = null);

(statearr_27652_27667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__11410__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__11410__auto____0 = (function (){
var statearr_27653 = [null,null,null,null,null,null,null,null];
(statearr_27653[(0)] = fluree$db$query$schema$setting_map_$_state_machine__11410__auto__);

(statearr_27653[(1)] = (1));

return statearr_27653;
});
var fluree$db$query$schema$setting_map_$_state_machine__11410__auto____1 = (function (state_27632){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27632);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e27654){var ex__11413__auto__ = e27654;
var statearr_27655_27668 = state_27632;
(statearr_27655_27668[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27632[(4)]))){
var statearr_27656_27669 = state_27632;
(statearr_27656_27669[(1)] = cljs.core.first((state_27632[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27670 = state_27632;
state_27632 = G__27670;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__11410__auto__ = function(state_27632){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__11410__auto____1.call(this,state_27632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__11410__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__11410__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_27657 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_27657[(6)] = c__11484__auto__);

return statearr_27657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
