// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27929){
var state_val_27930 = (state_27929[(1)]);
if((state_val_27930 === (7))){
var inst_27918 = (state_27929[(7)]);
var inst_27920 = fluree.db.storage.core.serde(conn);
var inst_27921 = fluree.db.serde.protocol._deserialize_block(inst_27920,inst_27918);
var state_27929__$1 = state_27929;
var statearr_27931_27950 = state_27929__$1;
(statearr_27931_27950[(2)] = inst_27921);

(statearr_27931_27950[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (1))){
var state_27929__$1 = state_27929;
var statearr_27932_27951 = state_27929__$1;
(statearr_27932_27951[(2)] = null);

(statearr_27932_27951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (4))){
var inst_27908 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
var statearr_27933_27952 = state_27929__$1;
(statearr_27933_27952[(2)] = inst_27908);

(statearr_27933_27952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (6))){
var inst_27918 = (state_27929[(7)]);
var inst_27917 = (state_27929[(2)]);
var inst_27918__$1 = fluree.db.util.async.throw_err(inst_27917);
var state_27929__$1 = (function (){var statearr_27934 = state_27929;
(statearr_27934[(7)] = inst_27918__$1);

return statearr_27934;
})();
if(cljs.core.truth_(inst_27918__$1)){
var statearr_27935_27953 = state_27929__$1;
(statearr_27935_27953[(1)] = (7));

} else {
var statearr_27936_27954 = state_27929__$1;
(statearr_27936_27954[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (3))){
var inst_27927 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27929__$1,inst_27927);
} else {
if((state_val_27930 === (2))){
var _ = (function (){var statearr_27938 = state_27929;
(statearr_27938[(4)] = cljs.core.cons((5),(state_27929[(4)])));

return statearr_27938;
})();
var inst_27914 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_27915 = fluree.db.storage.core.storage_read(conn,inst_27914);
var state_27929__$1 = state_27929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27929__$1,(6),inst_27915);
} else {
if((state_val_27930 === (9))){
var inst_27924 = (state_27929[(2)]);
var _ = (function (){var statearr_27939 = state_27929;
(statearr_27939[(4)] = cljs.core.rest((state_27929[(4)])));

return statearr_27939;
})();
var state_27929__$1 = state_27929;
var statearr_27940_27955 = state_27929__$1;
(statearr_27940_27955[(2)] = inst_27924);

(statearr_27940_27955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (5))){
var _ = (function (){var statearr_27941 = state_27929;
(statearr_27941[(4)] = cljs.core.rest((state_27929[(4)])));

return statearr_27941;
})();
var state_27929__$1 = state_27929;
var ex27937 = (state_27929__$1[(2)]);
var statearr_27942_27956 = state_27929__$1;
(statearr_27942_27956[(5)] = ex27937);


if((ex27937 instanceof Error)){
var statearr_27943_27957 = state_27929__$1;
(statearr_27943_27957[(1)] = (4));

(statearr_27943_27957[(5)] = null);

} else {
throw ex27937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (8))){
var state_27929__$1 = state_27929;
var statearr_27944_27958 = state_27929__$1;
(statearr_27944_27958[(2)] = null);

(statearr_27944_27958[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__11410__auto____0 = (function (){
var statearr_27945 = [null,null,null,null,null,null,null,null];
(statearr_27945[(0)] = fluree$db$storage$core$read_block_$_state_machine__11410__auto__);

(statearr_27945[(1)] = (1));

return statearr_27945;
});
var fluree$db$storage$core$read_block_$_state_machine__11410__auto____1 = (function (state_27929){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27929);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e27946){var ex__11413__auto__ = e27946;
var statearr_27947_27959 = state_27929;
(statearr_27947_27959[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27929[(4)]))){
var statearr_27948_27960 = state_27929;
(statearr_27948_27960[(1)] = cljs.core.first((state_27929[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27961 = state_27929;
state_27929 = G__27961;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__11410__auto__ = function(state_27929){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__11410__auto____1.call(this,state_27929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_27949 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_27949[(6)] = c__11484__auto__);

return statearr_27949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_27984){
var state_val_27985 = (state_27984[(1)]);
if((state_val_27985 === (7))){
var inst_27973 = (state_27984[(7)]);
var inst_27975 = fluree.db.storage.core.serde(conn);
var inst_27976 = fluree.db.serde.protocol._deserialize_block(inst_27975,inst_27973);
var state_27984__$1 = state_27984;
var statearr_27986_28005 = state_27984__$1;
(statearr_27986_28005[(2)] = inst_27976);

(statearr_27986_28005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (1))){
var state_27984__$1 = state_27984;
var statearr_27987_28006 = state_27984__$1;
(statearr_27987_28006[(2)] = null);

(statearr_27987_28006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (4))){
var inst_27962 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
var statearr_27988_28007 = state_27984__$1;
(statearr_27988_28007[(2)] = inst_27962);

(statearr_27988_28007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (6))){
var inst_27973 = (state_27984[(7)]);
var inst_27972 = (state_27984[(2)]);
var inst_27973__$1 = fluree.db.util.async.throw_err(inst_27972);
var state_27984__$1 = (function (){var statearr_27989 = state_27984;
(statearr_27989[(7)] = inst_27973__$1);

return statearr_27989;
})();
if(cljs.core.truth_(inst_27973__$1)){
var statearr_27990_28008 = state_27984__$1;
(statearr_27990_28008[(1)] = (7));

} else {
var statearr_27991_28009 = state_27984__$1;
(statearr_27991_28009[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (3))){
var inst_27982 = (state_27984[(2)]);
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27984__$1,inst_27982);
} else {
if((state_val_27985 === (2))){
var _ = (function (){var statearr_27993 = state_27984;
(statearr_27993[(4)] = cljs.core.cons((5),(state_27984[(4)])));

return statearr_27993;
})();
var inst_27968 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_27969 = [inst_27968,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_27970 = fluree.db.storage.core.storage_read(conn,inst_27969);
var state_27984__$1 = state_27984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27984__$1,(6),inst_27970);
} else {
if((state_val_27985 === (9))){
var inst_27979 = (state_27984[(2)]);
var _ = (function (){var statearr_27994 = state_27984;
(statearr_27994[(4)] = cljs.core.rest((state_27984[(4)])));

return statearr_27994;
})();
var state_27984__$1 = state_27984;
var statearr_27995_28010 = state_27984__$1;
(statearr_27995_28010[(2)] = inst_27979);

(statearr_27995_28010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (5))){
var _ = (function (){var statearr_27996 = state_27984;
(statearr_27996[(4)] = cljs.core.rest((state_27984[(4)])));

return statearr_27996;
})();
var state_27984__$1 = state_27984;
var ex27992 = (state_27984__$1[(2)]);
var statearr_27997_28011 = state_27984__$1;
(statearr_27997_28011[(5)] = ex27992);


if((ex27992 instanceof Error)){
var statearr_27998_28012 = state_27984__$1;
(statearr_27998_28012[(1)] = (4));

(statearr_27998_28012[(5)] = null);

} else {
throw ex27992;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27985 === (8))){
var state_27984__$1 = state_27984;
var statearr_27999_28013 = state_27984__$1;
(statearr_27999_28013[(2)] = null);

(statearr_27999_28013[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____0 = (function (){
var statearr_28000 = [null,null,null,null,null,null,null,null];
(statearr_28000[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__);

(statearr_28000[(1)] = (1));

return statearr_28000;
});
var fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____1 = (function (state_27984){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_27984);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28001){var ex__11413__auto__ = e28001;
var statearr_28002_28014 = state_27984;
(statearr_28002_28014[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_27984[(4)]))){
var statearr_28003_28015 = state_27984;
(statearr_28003_28015[(1)] = cljs.core.first((state_27984[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28016 = state_27984;
state_27984 = G__28016;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__ = function(state_27984){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____1.call(this,state_27984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28004 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28004[(6)] = c__11484__auto__);

return statearr_28004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28040){
var state_val_28041 = (state_28040[(1)]);
if((state_val_28041 === (1))){
var state_28040__$1 = state_28040;
var statearr_28042_28056 = state_28040__$1;
(statearr_28042_28056[(2)] = null);

(statearr_28042_28056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28041 === (2))){
var _ = (function (){var statearr_28043 = state_28040;
(statearr_28043[(4)] = cljs.core.cons((5),(state_28040[(4)])));

return statearr_28043;
})();
var inst_28023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28024 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_28025 = (new cljs.core.PersistentVector(null,3,(5),inst_28023,inst_28024,null));
var inst_28026 = cljs.core.select_keys(block_data,inst_28025);
var inst_28027 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28026);
var inst_28028 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_28027);
var inst_28029 = [inst_28028,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_28030 = fluree.db.storage.core.serde(conn);
var inst_28031 = fluree.db.serde.protocol._serialize_block(inst_28030,inst_28026);
var inst_28032 = fluree.db.storage.core.storage_write(conn,inst_28029,inst_28031);
var state_28040__$1 = state_28040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28040__$1,(6),inst_28032);
} else {
if((state_val_28041 === (3))){
var inst_28038 = (state_28040[(2)]);
var state_28040__$1 = state_28040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28040__$1,inst_28038);
} else {
if((state_val_28041 === (4))){
var inst_28017 = (state_28040[(2)]);
var state_28040__$1 = state_28040;
var statearr_28045_28057 = state_28040__$1;
(statearr_28045_28057[(2)] = inst_28017);

(statearr_28045_28057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28041 === (5))){
var _ = (function (){var statearr_28046 = state_28040;
(statearr_28046[(4)] = cljs.core.rest((state_28040[(4)])));

return statearr_28046;
})();
var state_28040__$1 = state_28040;
var ex28044 = (state_28040__$1[(2)]);
var statearr_28047_28058 = state_28040__$1;
(statearr_28047_28058[(5)] = ex28044);


if((ex28044 instanceof Error)){
var statearr_28048_28059 = state_28040__$1;
(statearr_28048_28059[(1)] = (4));

(statearr_28048_28059[(5)] = null);

} else {
throw ex28044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28041 === (6))){
var inst_28034 = (state_28040[(2)]);
var inst_28035 = fluree.db.util.async.throw_err(inst_28034);
var _ = (function (){var statearr_28049 = state_28040;
(statearr_28049[(4)] = cljs.core.rest((state_28040[(4)])));

return statearr_28049;
})();
var state_28040__$1 = state_28040;
var statearr_28050_28060 = state_28040__$1;
(statearr_28050_28060[(2)] = inst_28035);

(statearr_28050_28060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____0 = (function (){
var statearr_28051 = [null,null,null,null,null,null,null];
(statearr_28051[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__);

(statearr_28051[(1)] = (1));

return statearr_28051;
});
var fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____1 = (function (state_28040){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28040);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28052){var ex__11413__auto__ = e28052;
var statearr_28053_28061 = state_28040;
(statearr_28053_28061[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28040[(4)]))){
var statearr_28054_28062 = state_28040;
(statearr_28054_28062[(1)] = cljs.core.first((state_28040[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28063 = state_28040;
state_28040 = G__28063;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__ = function(state_28040){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____1.call(this,state_28040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28055 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28055[(6)] = c__11484__auto__);

return statearr_28055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28086){
var state_val_28087 = (state_28086[(1)]);
if((state_val_28087 === (1))){
var state_28086__$1 = state_28086;
var statearr_28088_28102 = state_28086__$1;
(statearr_28088_28102[(2)] = null);

(statearr_28088_28102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (2))){
var _ = (function (){var statearr_28089 = state_28086;
(statearr_28089[(4)] = cljs.core.cons((5),(state_28086[(4)])));

return statearr_28089;
})();
var inst_28070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28071 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_28072 = (new cljs.core.PersistentVector(null,3,(5),inst_28070,inst_28071,null));
var inst_28073 = cljs.core.select_keys(block_data,inst_28072);
var inst_28074 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28073);
var inst_28075 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_28074);
var inst_28076 = fluree.db.storage.core.serde(conn);
var inst_28077 = fluree.db.serde.protocol._serialize_block(inst_28076,inst_28073);
var inst_28078 = fluree.db.storage.core.storage_write(conn,inst_28075,inst_28077);
var state_28086__$1 = state_28086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28086__$1,(6),inst_28078);
} else {
if((state_val_28087 === (3))){
var inst_28084 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28086__$1,inst_28084);
} else {
if((state_val_28087 === (4))){
var inst_28064 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
var statearr_28091_28103 = state_28086__$1;
(statearr_28091_28103[(2)] = inst_28064);

(statearr_28091_28103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (5))){
var _ = (function (){var statearr_28092 = state_28086;
(statearr_28092[(4)] = cljs.core.rest((state_28086[(4)])));

return statearr_28092;
})();
var state_28086__$1 = state_28086;
var ex28090 = (state_28086__$1[(2)]);
var statearr_28093_28104 = state_28086__$1;
(statearr_28093_28104[(5)] = ex28090);


if((ex28090 instanceof Error)){
var statearr_28094_28105 = state_28086__$1;
(statearr_28094_28105[(1)] = (4));

(statearr_28094_28105[(5)] = null);

} else {
throw ex28090;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (6))){
var inst_28080 = (state_28086[(2)]);
var inst_28081 = fluree.db.util.async.throw_err(inst_28080);
var _ = (function (){var statearr_28095 = state_28086;
(statearr_28095[(4)] = cljs.core.rest((state_28086[(4)])));

return statearr_28095;
})();
var state_28086__$1 = state_28086;
var statearr_28096_28106 = state_28086__$1;
(statearr_28096_28106[(2)] = inst_28081);

(statearr_28096_28106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__11410__auto____0 = (function (){
var statearr_28097 = [null,null,null,null,null,null,null];
(statearr_28097[(0)] = fluree$db$storage$core$write_block_$_state_machine__11410__auto__);

(statearr_28097[(1)] = (1));

return statearr_28097;
});
var fluree$db$storage$core$write_block_$_state_machine__11410__auto____1 = (function (state_28086){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28086);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28098){var ex__11413__auto__ = e28098;
var statearr_28099_28107 = state_28086;
(statearr_28099_28107[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28086[(4)]))){
var statearr_28100_28108 = state_28086;
(statearr_28100_28108[(1)] = cljs.core.first((state_28086[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28109 = state_28086;
state_28086 = G__28109;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__11410__auto__ = function(state_28086){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__11410__auto____1.call(this,state_28086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28101 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28101[(6)] = c__11484__auto__);

return statearr_28101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28129){
var state_val_28130 = (state_28129[(1)]);
if((state_val_28130 === (1))){
var state_28129__$1 = state_28129;
var statearr_28131_28145 = state_28129__$1;
(statearr_28131_28145[(2)] = null);

(statearr_28131_28145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28130 === (2))){
var _ = (function (){var statearr_28132 = state_28129;
(statearr_28132[(4)] = cljs.core.cons((5),(state_28129[(4)])));

return statearr_28132;
})();
var inst_28116 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_28117 = [history,next_his_key];
var inst_28118 = cljs.core.PersistentHashMap.fromArrays(inst_28116,inst_28117);
var inst_28119 = fluree.db.storage.core.serde(conn);
var inst_28120 = fluree.db.serde.protocol._serialize_leaf(inst_28119,inst_28118);
var inst_28121 = fluree.db.storage.core.storage_write(conn,his_key,inst_28120);
var state_28129__$1 = state_28129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28129__$1,(6),inst_28121);
} else {
if((state_val_28130 === (3))){
var inst_28127 = (state_28129[(2)]);
var state_28129__$1 = state_28129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28129__$1,inst_28127);
} else {
if((state_val_28130 === (4))){
var inst_28110 = (state_28129[(2)]);
var state_28129__$1 = state_28129;
var statearr_28134_28146 = state_28129__$1;
(statearr_28134_28146[(2)] = inst_28110);

(statearr_28134_28146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28130 === (5))){
var _ = (function (){var statearr_28135 = state_28129;
(statearr_28135[(4)] = cljs.core.rest((state_28129[(4)])));

return statearr_28135;
})();
var state_28129__$1 = state_28129;
var ex28133 = (state_28129__$1[(2)]);
var statearr_28136_28147 = state_28129__$1;
(statearr_28136_28147[(5)] = ex28133);


if((ex28133 instanceof Error)){
var statearr_28137_28148 = state_28129__$1;
(statearr_28137_28148[(1)] = (4));

(statearr_28137_28148[(5)] = null);

} else {
throw ex28133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28130 === (6))){
var inst_28123 = (state_28129[(2)]);
var inst_28124 = fluree.db.util.async.throw_err(inst_28123);
var _ = (function (){var statearr_28138 = state_28129;
(statearr_28138[(4)] = cljs.core.rest((state_28129[(4)])));

return statearr_28138;
})();
var state_28129__$1 = state_28129;
var statearr_28139_28149 = state_28129__$1;
(statearr_28139_28149[(2)] = inst_28124);

(statearr_28139_28149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__11410__auto____0 = (function (){
var statearr_28140 = [null,null,null,null,null,null,null];
(statearr_28140[(0)] = fluree$db$storage$core$write_history_$_state_machine__11410__auto__);

(statearr_28140[(1)] = (1));

return statearr_28140;
});
var fluree$db$storage$core$write_history_$_state_machine__11410__auto____1 = (function (state_28129){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28129);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28141){var ex__11413__auto__ = e28141;
var statearr_28142_28150 = state_28129;
(statearr_28142_28150[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28129[(4)]))){
var statearr_28143_28151 = state_28129;
(statearr_28143_28151[(1)] = cljs.core.first((state_28129[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28152 = state_28129;
state_28129 = G__28152;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__11410__auto__ = function(state_28129){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__11410__auto____1.call(this,state_28129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_history_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28144 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28144[(6)] = c__11484__auto__);

return statearr_28144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28178){
var state_val_28179 = (state_28178[(1)]);
if((state_val_28179 === (1))){
var state_28178__$1 = state_28178;
var statearr_28180_28197 = state_28178__$1;
(statearr_28180_28197[(2)] = null);

(statearr_28180_28197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28179 === (2))){
var inst_28159 = (state_28178[(7)]);
var _ = (function (){var statearr_28181 = state_28178;
(statearr_28181[(4)] = cljs.core.cons((5),(state_28178[(4)])));

return statearr_28181;
})();
var inst_28159__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_28160 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28159__$1),"-his"].join('');
var inst_28161 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_28162 = [flakes,inst_28160];
var inst_28163 = cljs.core.PersistentHashMap.fromArrays(inst_28161,inst_28162);
var inst_28164 = fluree.db.storage.core.serde(conn);
var inst_28165 = fluree.db.serde.protocol._serialize_leaf(inst_28164,inst_28163);
var inst_28166 = fluree.db.storage.core.write_history(conn,history,inst_28160,null);
var inst_28167 = fluree.db.storage.core.storage_write(conn,inst_28159__$1,inst_28165);
var state_28178__$1 = (function (){var statearr_28182 = state_28178;
(statearr_28182[(7)] = inst_28159__$1);

(statearr_28182[(8)] = inst_28167);

return statearr_28182;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28178__$1,(6),inst_28166);
} else {
if((state_val_28179 === (3))){
var inst_28176 = (state_28178[(2)]);
var state_28178__$1 = state_28178;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28178__$1,inst_28176);
} else {
if((state_val_28179 === (4))){
var inst_28153 = (state_28178[(2)]);
var state_28178__$1 = state_28178;
var statearr_28184_28198 = state_28178__$1;
(statearr_28184_28198[(2)] = inst_28153);

(statearr_28184_28198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28179 === (5))){
var _ = (function (){var statearr_28185 = state_28178;
(statearr_28185[(4)] = cljs.core.rest((state_28178[(4)])));

return statearr_28185;
})();
var state_28178__$1 = state_28178;
var ex28183 = (state_28178__$1[(2)]);
var statearr_28186_28199 = state_28178__$1;
(statearr_28186_28199[(5)] = ex28183);


if((ex28183 instanceof Error)){
var statearr_28187_28200 = state_28178__$1;
(statearr_28187_28200[(1)] = (4));

(statearr_28187_28200[(5)] = null);

} else {
throw ex28183;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28179 === (6))){
var inst_28167 = (state_28178[(8)]);
var inst_28169 = (state_28178[(2)]);
var inst_28170 = fluree.db.util.async.throw_err(inst_28169);
var state_28178__$1 = (function (){var statearr_28188 = state_28178;
(statearr_28188[(9)] = inst_28170);

return statearr_28188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28178__$1,(7),inst_28167);
} else {
if((state_val_28179 === (7))){
var inst_28159 = (state_28178[(7)]);
var inst_28172 = (state_28178[(2)]);
var inst_28173 = fluree.db.util.async.throw_err(inst_28172);
var _ = (function (){var statearr_28189 = state_28178;
(statearr_28189[(4)] = cljs.core.rest((state_28178[(4)])));

return statearr_28189;
})();
var state_28178__$1 = (function (){var statearr_28190 = state_28178;
(statearr_28190[(10)] = inst_28173);

return statearr_28190;
})();
var statearr_28191_28201 = state_28178__$1;
(statearr_28191_28201[(2)] = inst_28159);

(statearr_28191_28201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____0 = (function (){
var statearr_28192 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28192[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__);

(statearr_28192[(1)] = (1));

return statearr_28192;
});
var fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____1 = (function (state_28178){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28178);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28193){var ex__11413__auto__ = e28193;
var statearr_28194_28202 = state_28178;
(statearr_28194_28202[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28178[(4)]))){
var statearr_28195_28203 = state_28178;
(statearr_28195_28203[(1)] = cljs.core.first((state_28178[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28204 = state_28178;
state_28178 = G__28204;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__ = function(state_28178){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____1.call(this,state_28178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28196 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28196[(6)] = c__11484__auto__);

return statearr_28196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28221){
var state_val_28222 = (state_28221[(1)]);
if((state_val_28222 === (1))){
var state_28221__$1 = state_28221;
var statearr_28223_28238 = state_28221__$1;
(statearr_28223_28238[(2)] = null);

(statearr_28223_28238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28222 === (2))){
var _ = (function (){var statearr_28224 = state_28221;
(statearr_28224[(4)] = cljs.core.cons((5),(state_28221[(4)])));

return statearr_28224;
})();
var inst_28211 = fluree.db.storage.core.serde(conn);
var inst_28212 = fluree.db.serde.protocol._serialize_branch(inst_28211,data);
var inst_28213 = fluree.db.storage.core.storage_write(conn,key,inst_28212);
var state_28221__$1 = state_28221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28221__$1,(6),inst_28213);
} else {
if((state_val_28222 === (3))){
var inst_28219 = (state_28221[(2)]);
var state_28221__$1 = state_28221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28221__$1,inst_28219);
} else {
if((state_val_28222 === (4))){
var inst_28205 = (state_28221[(2)]);
var state_28221__$1 = state_28221;
var statearr_28226_28239 = state_28221__$1;
(statearr_28226_28239[(2)] = inst_28205);

(statearr_28226_28239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28222 === (5))){
var _ = (function (){var statearr_28227 = state_28221;
(statearr_28227[(4)] = cljs.core.rest((state_28221[(4)])));

return statearr_28227;
})();
var state_28221__$1 = state_28221;
var ex28225 = (state_28221__$1[(2)]);
var statearr_28228_28240 = state_28221__$1;
(statearr_28228_28240[(5)] = ex28225);


if((ex28225 instanceof Error)){
var statearr_28229_28241 = state_28221__$1;
(statearr_28229_28241[(1)] = (4));

(statearr_28229_28241[(5)] = null);

} else {
throw ex28225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28222 === (6))){
var inst_28215 = (state_28221[(2)]);
var inst_28216 = fluree.db.util.async.throw_err(inst_28215);
var _ = (function (){var statearr_28230 = state_28221;
(statearr_28230[(4)] = cljs.core.rest((state_28221[(4)])));

return statearr_28230;
})();
var state_28221__$1 = (function (){var statearr_28231 = state_28221;
(statearr_28231[(7)] = inst_28216);

return statearr_28231;
})();
var statearr_28232_28242 = state_28221__$1;
(statearr_28232_28242[(2)] = key);

(statearr_28232_28242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____0 = (function (){
var statearr_28233 = [null,null,null,null,null,null,null,null];
(statearr_28233[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__);

(statearr_28233[(1)] = (1));

return statearr_28233;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____1 = (function (state_28221){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28221);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28234){var ex__11413__auto__ = e28234;
var statearr_28235_28243 = state_28221;
(statearr_28235_28243[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28221[(4)]))){
var statearr_28236_28244 = state_28221;
(statearr_28236_28244[(1)] = cljs.core.first((state_28221[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28245 = state_28221;
state_28221 = G__28245;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__ = function(state_28221){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____1.call(this,state_28221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28237 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28237[(6)] = c__11484__auto__);

return statearr_28237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__28246_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__28246_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__28247){
var map__28248 = p__28247;
var map__28248__$1 = cljs.core.__destructure_map(map__28248);
var progress = map__28248__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28248__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28276){
var state_val_28277 = (state_28276[(1)]);
if((state_val_28277 === (1))){
var state_28276__$1 = state_28276;
var statearr_28278_28294 = state_28276__$1;
(statearr_28278_28294[(2)] = null);

(statearr_28278_28294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (2))){
var inst_28262 = (state_28276[(7)]);
var _ = (function (){var statearr_28279 = state_28276;
(statearr_28279[(4)] = cljs.core.cons((5),(state_28276[(4)])));

return statearr_28279;
})();
var inst_28256 = db;
var inst_28257 = cljs.core.__destructure_map(inst_28256);
var inst_28258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28257,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28257,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28257,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28257,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28262__$1 = fluree.db.storage.core.ledger_garbage_key(inst_28259,inst_28260,inst_28261);
var inst_28263 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_28264 = [inst_28260,inst_28261,garbage];
var inst_28265 = cljs.core.PersistentHashMap.fromArrays(inst_28263,inst_28264);
var inst_28266 = fluree.db.storage.core.serde(inst_28258);
var inst_28267 = fluree.db.serde.protocol._serialize_garbage(inst_28266,inst_28265);
var inst_28268 = fluree.db.storage.core.storage_write(inst_28258,inst_28262__$1,inst_28267);
var state_28276__$1 = (function (){var statearr_28280 = state_28276;
(statearr_28280[(7)] = inst_28262__$1);

return statearr_28280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28276__$1,(6),inst_28268);
} else {
if((state_val_28277 === (3))){
var inst_28274 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28276__$1,inst_28274);
} else {
if((state_val_28277 === (4))){
var inst_28249 = (state_28276[(2)]);
var state_28276__$1 = state_28276;
var statearr_28282_28295 = state_28276__$1;
(statearr_28282_28295[(2)] = inst_28249);

(statearr_28282_28295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (5))){
var _ = (function (){var statearr_28283 = state_28276;
(statearr_28283[(4)] = cljs.core.rest((state_28276[(4)])));

return statearr_28283;
})();
var state_28276__$1 = state_28276;
var ex28281 = (state_28276__$1[(2)]);
var statearr_28284_28296 = state_28276__$1;
(statearr_28284_28296[(5)] = ex28281);


if((ex28281 instanceof Error)){
var statearr_28285_28297 = state_28276__$1;
(statearr_28285_28297[(1)] = (4));

(statearr_28285_28297[(5)] = null);

} else {
throw ex28281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28277 === (6))){
var inst_28262 = (state_28276[(7)]);
var inst_28270 = (state_28276[(2)]);
var inst_28271 = fluree.db.util.async.throw_err(inst_28270);
var _ = (function (){var statearr_28286 = state_28276;
(statearr_28286[(4)] = cljs.core.rest((state_28276[(4)])));

return statearr_28286;
})();
var state_28276__$1 = (function (){var statearr_28287 = state_28276;
(statearr_28287[(8)] = inst_28271);

return statearr_28287;
})();
var statearr_28288_28298 = state_28276__$1;
(statearr_28288_28298[(2)] = inst_28262);

(statearr_28288_28298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____0 = (function (){
var statearr_28289 = [null,null,null,null,null,null,null,null,null];
(statearr_28289[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__);

(statearr_28289[(1)] = (1));

return statearr_28289;
});
var fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____1 = (function (state_28276){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28276);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28290){var ex__11413__auto__ = e28290;
var statearr_28291_28299 = state_28276;
(statearr_28291_28299[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28276[(4)]))){
var statearr_28292_28300 = state_28276;
(statearr_28292_28300[(1)] = cljs.core.first((state_28276[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28301 = state_28276;
state_28276 = G__28301;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__ = function(state_28276){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____1.call(this,state_28276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__11410__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28293 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28293[(6)] = c__11484__auto__);

return statearr_28293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__28303 = arguments.length;
switch (G__28303) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28359){
var state_val_28360 = (state_28359[(1)]);
if((state_val_28360 === (7))){
var state_28359__$1 = state_28359;
var statearr_28361_28387 = state_28359__$1;
(statearr_28361_28387[(2)] = (0));

(statearr_28361_28387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (1))){
var state_28359__$1 = state_28359;
var statearr_28362_28388 = state_28359__$1;
(statearr_28362_28388[(2)] = null);

(statearr_28362_28388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (4))){
var inst_28304 = (state_28359[(2)]);
var state_28359__$1 = state_28359;
var statearr_28363_28389 = state_28359__$1;
(statearr_28363_28389[(2)] = inst_28304);

(statearr_28363_28389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (6))){
var inst_28329 = (state_28359[(7)]);
var state_28359__$1 = state_28359;
var statearr_28364_28390 = state_28359__$1;
(statearr_28364_28390[(2)] = inst_28329);

(statearr_28364_28390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (3))){
var inst_28357 = (state_28359[(2)]);
var state_28359__$1 = state_28359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28359__$1,inst_28357);
} else {
if((state_val_28360 === (12))){
var inst_28326 = (state_28359[(8)]);
var inst_28353 = (state_28359[(2)]);
var inst_28354 = fluree.db.util.async.throw_err(inst_28353);
var _ = (function (){var statearr_28365 = state_28359;
(statearr_28365[(4)] = cljs.core.rest((state_28359[(4)])));

return statearr_28365;
})();
var state_28359__$1 = (function (){var statearr_28366 = state_28359;
(statearr_28366[(9)] = inst_28354);

return statearr_28366;
})();
var statearr_28367_28391 = state_28359__$1;
(statearr_28367_28391[(2)] = inst_28326);

(statearr_28367_28391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (2))){
var inst_28317 = (state_28359[(10)]);
var inst_28329 = (state_28359[(7)]);
var inst_28321 = (state_28359[(11)]);
var inst_28319 = (state_28359[(12)]);
var _ = (function (){var statearr_28368 = state_28359;
(statearr_28368[(4)] = cljs.core.cons((5),(state_28359[(4)])));

return statearr_28368;
})();
var inst_28311 = db;
var inst_28312 = cljs.core.__destructure_map(inst_28311);
var inst_28313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_28316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_28317__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_28318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28319__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_28321__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_28323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_28324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_28325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28312,new cljs.core.Keyword(null,"post","post",269697687));
var inst_28326 = fluree.db.storage.core.ledger_root_key(inst_28313,inst_28321__$1,inst_28319__$1);
var inst_28327 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_28328 = fluree.db.storage.core.child_data(inst_28320);
var inst_28329__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_28317__$1);
var state_28359__$1 = (function (){var statearr_28369 = state_28359;
(statearr_28369[(10)] = inst_28317__$1);

(statearr_28369[(13)] = inst_28327);

(statearr_28369[(7)] = inst_28329__$1);

(statearr_28369[(14)] = inst_28318);

(statearr_28369[(15)] = inst_28323);

(statearr_28369[(11)] = inst_28321__$1);

(statearr_28369[(8)] = inst_28326);

(statearr_28369[(16)] = inst_28315);

(statearr_28369[(17)] = inst_28322);

(statearr_28369[(18)] = inst_28316);

(statearr_28369[(19)] = inst_28314);

(statearr_28369[(20)] = inst_28325);

(statearr_28369[(12)] = inst_28319__$1);

(statearr_28369[(21)] = inst_28324);

(statearr_28369[(22)] = inst_28328);

return statearr_28369;
})();
if(cljs.core.truth_(inst_28329__$1)){
var statearr_28370_28392 = state_28359__$1;
(statearr_28370_28392[(1)] = (6));

} else {
var statearr_28371_28393 = state_28359__$1;
(statearr_28371_28393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (11))){
var inst_28317 = (state_28359[(10)]);
var inst_28327 = (state_28359[(13)]);
var inst_28318 = (state_28359[(14)]);
var inst_28323 = (state_28359[(15)]);
var inst_28321 = (state_28359[(11)]);
var inst_28326 = (state_28359[(8)]);
var inst_28315 = (state_28359[(16)]);
var inst_28316 = (state_28359[(18)]);
var inst_28314 = (state_28359[(19)]);
var inst_28333 = (state_28359[(23)]);
var inst_28325 = (state_28359[(20)]);
var inst_28319 = (state_28359[(12)]);
var inst_28324 = (state_28359[(21)]);
var inst_28328 = (state_28359[(22)]);
var inst_28338 = (state_28359[(2)]);
var inst_28339 = fluree.db.storage.core.child_data(inst_28323);
var inst_28340 = fluree.db.storage.core.child_data(inst_28325);
var inst_28341 = fluree.db.util.core.current_time_millis();
var inst_28342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28343 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_28344 = (new cljs.core.PersistentVector(null,2,(5),inst_28342,inst_28343,null));
var inst_28345 = cljs.core.select_keys(inst_28317,inst_28344);
var inst_28346 = fluree.db.storage.core.child_data(inst_28316);
var inst_28347 = [inst_28319,inst_28328,inst_28321,inst_28333,inst_28338,inst_28339,inst_28340,inst_28314,inst_28341,inst_28315,inst_28324,inst_28345,inst_28346];
var inst_28348 = cljs.core.PersistentHashMap.fromArrays(inst_28327,inst_28347);
var inst_28349 = fluree.db.storage.core.serde(inst_28318);
var inst_28350 = fluree.db.serde.protocol._serialize_db_root(inst_28349,inst_28348);
var inst_28351 = fluree.db.storage.core.storage_write(inst_28318,inst_28326,inst_28350);
var state_28359__$1 = state_28359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28359__$1,(12),inst_28351);
} else {
if((state_val_28360 === (9))){
var inst_28334 = (state_28359[(24)]);
var state_28359__$1 = state_28359;
var statearr_28373_28394 = state_28359__$1;
(statearr_28373_28394[(2)] = inst_28334);

(statearr_28373_28394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (5))){
var _ = (function (){var statearr_28374 = state_28359;
(statearr_28374[(4)] = cljs.core.rest((state_28359[(4)])));

return statearr_28374;
})();
var state_28359__$1 = state_28359;
var ex28372 = (state_28359__$1[(2)]);
var statearr_28375_28395 = state_28359__$1;
(statearr_28375_28395[(5)] = ex28372);


if((ex28372 instanceof Error)){
var statearr_28376_28396 = state_28359__$1;
(statearr_28376_28396[(1)] = (4));

(statearr_28376_28396[(5)] = null);

} else {
throw ex28372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (10))){
var inst_28322 = (state_28359[(17)]);
var state_28359__$1 = state_28359;
var statearr_28377_28397 = state_28359__$1;
(statearr_28377_28397[(2)] = inst_28322);

(statearr_28377_28397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (8))){
var inst_28334 = (state_28359[(24)]);
var inst_28333 = (state_28359[(2)]);
var inst_28334__$1 = custom_ecount;
var state_28359__$1 = (function (){var statearr_28378 = state_28359;
(statearr_28378[(23)] = inst_28333);

(statearr_28378[(24)] = inst_28334__$1);

return statearr_28378;
})();
if(cljs.core.truth_(inst_28334__$1)){
var statearr_28379_28398 = state_28359__$1;
(statearr_28379_28398[(1)] = (9));

} else {
var statearr_28380_28399 = state_28359__$1;
(statearr_28380_28399[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11410__auto__ = null;
var fluree$db$storage$core$state_machine__11410__auto____0 = (function (){
var statearr_28381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28381[(0)] = fluree$db$storage$core$state_machine__11410__auto__);

(statearr_28381[(1)] = (1));

return statearr_28381;
});
var fluree$db$storage$core$state_machine__11410__auto____1 = (function (state_28359){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28359);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28382){var ex__11413__auto__ = e28382;
var statearr_28383_28400 = state_28359;
(statearr_28383_28400[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28359[(4)]))){
var statearr_28384_28401 = state_28359;
(statearr_28384_28401[(1)] = cljs.core.first((state_28359[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28402 = state_28359;
state_28359 = G__28402;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11410__auto__ = function(state_28359){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11410__auto____1.call(this,state_28359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11410__auto____0;
fluree$db$storage$core$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11410__auto____1;
return fluree$db$storage$core$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28385 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28385[(6)] = c__11484__auto__);

return statearr_28385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___28461 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28435){
var state_val_28436 = (state_28435[(1)]);
if((state_val_28436 === (7))){
var inst_28415 = (state_28435[(7)]);
var state_28435__$1 = state_28435;
var statearr_28437_28462 = state_28435__$1;
(statearr_28437_28462[(2)] = inst_28415);

(statearr_28437_28462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (1))){
var state_28435__$1 = state_28435;
var statearr_28438_28463 = state_28435__$1;
(statearr_28438_28463[(2)] = null);

(statearr_28438_28463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (4))){
var inst_28403 = (state_28435[(2)]);
var inst_28404 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_28405 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_28403);
var inst_28406 = cljs.core.async.close_BANG_(return_ch);
var state_28435__$1 = (function (){var statearr_28439 = state_28435;
(statearr_28439[(8)] = inst_28404);

(statearr_28439[(9)] = inst_28405);

return statearr_28439;
})();
var statearr_28440_28464 = state_28435__$1;
(statearr_28440_28464[(2)] = inst_28406);

(statearr_28440_28464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (6))){
var inst_28414 = (state_28435[(10)]);
var inst_28415 = (state_28435[(7)]);
var inst_28414__$1 = (state_28435[(2)]);
var inst_28415__$1 = (inst_28414__$1 == null);
var state_28435__$1 = (function (){var statearr_28441 = state_28435;
(statearr_28441[(10)] = inst_28414__$1);

(statearr_28441[(7)] = inst_28415__$1);

return statearr_28441;
})();
if(cljs.core.truth_(inst_28415__$1)){
var statearr_28442_28465 = state_28435__$1;
(statearr_28442_28465[(1)] = (7));

} else {
var statearr_28443_28466 = state_28435__$1;
(statearr_28443_28466[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (3))){
var inst_28433 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28435__$1,inst_28433);
} else {
if((state_val_28436 === (12))){
var inst_28430 = (state_28435[(2)]);
var _ = (function (){var statearr_28444 = state_28435;
(statearr_28444[(4)] = cljs.core.rest((state_28435[(4)])));

return statearr_28444;
})();
var state_28435__$1 = state_28435;
var statearr_28445_28467 = state_28435__$1;
(statearr_28445_28467[(2)] = inst_28430);

(statearr_28445_28467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (2))){
var _ = (function (){var statearr_28446 = state_28435;
(statearr_28446[(4)] = cljs.core.cons((5),(state_28435[(4)])));

return statearr_28446;
})();
var inst_28412 = fluree.db.storage.core.storage_read(conn,key);
var state_28435__$1 = state_28435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28435__$1,(6),inst_28412);
} else {
if((state_val_28436 === (11))){
var inst_28414 = (state_28435[(10)]);
var inst_28424 = fluree.db.storage.core.serde(conn);
var inst_28425 = fluree.db.serde.protocol._deserialize_leaf(inst_28424,inst_28414);
var inst_28426 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_28425);
var inst_28427 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_28426);
var inst_28428 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_28427);
var state_28435__$1 = state_28435;
var statearr_28448_28468 = state_28435__$1;
(statearr_28448_28468[(2)] = inst_28428);

(statearr_28448_28468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (9))){
var inst_28420 = (state_28435[(2)]);
var state_28435__$1 = state_28435;
if(cljs.core.truth_(inst_28420)){
var statearr_28449_28469 = state_28435__$1;
(statearr_28449_28469[(1)] = (10));

} else {
var statearr_28450_28470 = state_28435__$1;
(statearr_28450_28470[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (5))){
var _ = (function (){var statearr_28451 = state_28435;
(statearr_28451[(4)] = cljs.core.rest((state_28435[(4)])));

return statearr_28451;
})();
var state_28435__$1 = state_28435;
var ex28447 = (state_28435__$1[(2)]);
var statearr_28452_28471 = state_28435__$1;
(statearr_28452_28471[(5)] = ex28447);


var statearr_28453_28472 = state_28435__$1;
(statearr_28453_28472[(1)] = (4));

(statearr_28453_28472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (10))){
var inst_28422 = cljs.core.async.close_BANG_(return_ch);
var state_28435__$1 = state_28435;
var statearr_28454_28473 = state_28435__$1;
(statearr_28454_28473[(2)] = inst_28422);

(statearr_28454_28473[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28436 === (8))){
var inst_28414 = (state_28435[(10)]);
var inst_28418 = (inst_28414 instanceof Error);
var state_28435__$1 = state_28435;
var statearr_28455_28474 = state_28435__$1;
(statearr_28455_28474[(2)] = inst_28418);

(statearr_28455_28474[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__11410__auto____0 = (function (){
var statearr_28456 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28456[(0)] = fluree$db$storage$core$reify_history_$_state_machine__11410__auto__);

(statearr_28456[(1)] = (1));

return statearr_28456;
});
var fluree$db$storage$core$reify_history_$_state_machine__11410__auto____1 = (function (state_28435){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28435);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28457){var ex__11413__auto__ = e28457;
var statearr_28458_28475 = state_28435;
(statearr_28458_28475[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28435[(4)]))){
var statearr_28459_28476 = state_28435;
(statearr_28459_28476[(1)] = cljs.core.first((state_28435[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28477 = state_28435;
state_28435 = G__28477;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__11410__auto__ = function(state_28435){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__11410__auto____1.call(this,state_28435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__11410__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__11410__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28460 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28460[(6)] = c__11484__auto___28461);

return statearr_28460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__28479 = arguments.length;
switch (G__28479) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___28591 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28542){
var state_val_28543 = (state_28542[(1)]);
if((state_val_28543 === (7))){
var state_28542__$1 = state_28542;
var statearr_28544_28592 = state_28542__$1;
(statearr_28544_28592[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_28544_28592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (20))){
var inst_28521 = cljs.core.PersistentVector.EMPTY;
var state_28542__$1 = state_28542;
var statearr_28545_28593 = state_28542__$1;
(statearr_28545_28593[(2)] = inst_28521);

(statearr_28545_28593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (1))){
var state_28542__$1 = state_28542;
var statearr_28546_28594 = state_28542__$1;
(statearr_28546_28594[(2)] = null);

(statearr_28546_28594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (24))){
var state_28542__$1 = state_28542;
var statearr_28547_28595 = state_28542__$1;
(statearr_28547_28595[(2)] = null);

(statearr_28547_28595[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (4))){
var inst_28482 = (state_28542[(2)]);
var inst_28483 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_28484 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_28482);
var inst_28485 = cljs.core.async.close_BANG_(result_ch);
var state_28542__$1 = (function (){var statearr_28548 = state_28542;
(statearr_28548[(7)] = inst_28484);

(statearr_28548[(8)] = inst_28483);

return statearr_28548;
})();
var statearr_28549_28596 = state_28542__$1;
(statearr_28549_28596[(2)] = inst_28485);

(statearr_28549_28596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (15))){
var inst_28507 = (state_28542[(2)]);
var state_28542__$1 = state_28542;
var statearr_28550_28597 = state_28542__$1;
(statearr_28550_28597[(2)] = inst_28507);

(statearr_28550_28597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (21))){
var inst_28494 = (state_28542[(9)]);
var inst_28524 = (state_28542[(10)]);
var inst_28495 = (state_28542[(11)]);
var inst_28511 = (state_28542[(12)]);
var inst_28496 = (state_28542[(13)]);
var inst_28531 = (state_28542[(2)]);
var inst_28532 = (function (){var base_node = inst_28494;
var first_flake = inst_28495;
var node_t = inst_28496;
var source = inst_28511;
var coll = inst_28524;
var conj_QMARK_ = inst_28531;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__28552 = f.p;
var fexpr__28551 = (function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__28551.cljs$core$IFn$_invoke$arity$1 ? fexpr__28551.cljs$core$IFn$_invoke$arity$1(G__28552) : fexpr__28551.call(null,G__28552));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_28533 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_28494);
var inst_28534 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28532,inst_28533,inst_28524);
var inst_28535 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_28534);
var inst_28536 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28494,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_28535);
var inst_28537 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_28536);
var _ = (function (){var statearr_28553 = state_28542;
(statearr_28553[(4)] = cljs.core.rest((state_28542[(4)])));

return statearr_28553;
})();
var state_28542__$1 = state_28542;
var statearr_28554_28598 = state_28542__$1;
(statearr_28554_28598[(2)] = inst_28537);

(statearr_28554_28598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (13))){
var state_28542__$1 = state_28542;
var statearr_28555_28599 = state_28542__$1;
(statearr_28555_28599[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_28555_28599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (22))){
var inst_28494 = (state_28542[(9)]);
var inst_28524 = (state_28542[(10)]);
var inst_28495 = (state_28542[(11)]);
var inst_28511 = (state_28542[(12)]);
var inst_28496 = (state_28542[(13)]);
var inst_28525 = (function (){var base_node = inst_28494;
var first_flake = inst_28495;
var node_t = inst_28496;
var source = inst_28511;
var coll = inst_28524;
return (function (f){
return f.op === true;
});
})();
var state_28542__$1 = state_28542;
var statearr_28556_28600 = state_28542__$1;
(statearr_28556_28600[(2)] = inst_28525);

(statearr_28556_28600[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (6))){
var inst_28494 = (state_28542[(9)]);
var inst_28496 = (state_28542[(13)]);
var inst_28493 = (state_28542[(2)]);
var inst_28494__$1 = fluree.db.util.async.throw_err(inst_28493);
var inst_28495 = fluree.db.dbproto._first_flake(inst_28494__$1);
var inst_28496__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28494__$1);
var inst_28497 = (inst_28496__$1 > t);
var state_28542__$1 = (function (){var statearr_28557 = state_28542;
(statearr_28557[(9)] = inst_28494__$1);

(statearr_28557[(11)] = inst_28495);

(statearr_28557[(13)] = inst_28496__$1);

return statearr_28557;
})();
if(cljs.core.truth_(inst_28497)){
var statearr_28558_28601 = state_28542__$1;
(statearr_28558_28601[(1)] = (7));

} else {
var statearr_28559_28602 = state_28542__$1;
(statearr_28559_28602[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (17))){
var inst_28495 = (state_28542[(11)]);
var inst_28512 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_28495,rhs,leftmost_QMARK_,t);
var state_28542__$1 = state_28542;
var statearr_28560_28603 = state_28542__$1;
(statearr_28560_28603[(2)] = inst_28512);

(statearr_28560_28603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (3))){
var inst_28540 = (state_28542[(2)]);
var state_28542__$1 = state_28542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28542__$1,inst_28540);
} else {
if((state_val_28543 === (12))){
var inst_28509 = (state_28542[(2)]);
var state_28542__$1 = state_28542;
var statearr_28561_28604 = state_28542__$1;
(statearr_28561_28604[(2)] = inst_28509);

(statearr_28561_28604[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (2))){
var _ = (function (){var statearr_28562 = state_28542;
(statearr_28562[(4)] = cljs.core.cons((5),(state_28542[(4)])));

return statearr_28562;
})();
var inst_28491 = fluree.db.dbproto._resolve(node);
var state_28542__$1 = state_28542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28542__$1,(6),inst_28491);
} else {
if((state_val_28543 === (23))){
var inst_28494 = (state_28542[(9)]);
var inst_28524 = (state_28542[(10)]);
var inst_28495 = (state_28542[(11)]);
var inst_28511 = (state_28542[(12)]);
var inst_28496 = (state_28542[(13)]);
var inst_28527 = (function (){var base_node = inst_28494;
var first_flake = inst_28495;
var node_t = inst_28496;
var source = inst_28511;
var coll = inst_28524;
return (function (f){
return f.op === false;
});
})();
var state_28542__$1 = state_28542;
var statearr_28563_28605 = state_28542__$1;
(statearr_28563_28605[(2)] = inst_28527);

(statearr_28563_28605[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (19))){
var inst_28514 = (state_28542[(14)]);
var inst_28517 = (state_28542[(2)]);
var inst_28518 = fluree.db.util.async.throw_err(inst_28517);
var inst_28519 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_28514,inst_28518);
var state_28542__$1 = state_28542;
var statearr_28564_28606 = state_28542__$1;
(statearr_28564_28606[(2)] = inst_28519);

(statearr_28564_28606[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (11))){
var inst_28496 = (state_28542[(13)]);
var inst_28503 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28496,t);
var state_28542__$1 = state_28542;
if(inst_28503){
var statearr_28566_28607 = state_28542__$1;
(statearr_28566_28607[(1)] = (13));

} else {
var statearr_28567_28608 = state_28542__$1;
(statearr_28567_28608[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (9))){
var inst_28511 = (state_28542[(12)]);
var inst_28511__$1 = (state_28542[(2)]);
var state_28542__$1 = (function (){var statearr_28568 = state_28542;
(statearr_28568[(12)] = inst_28511__$1);

return statearr_28568;
})();
var G__28569_28609 = inst_28511__$1;
var G__28569_28610__$1 = (((G__28569_28609 instanceof cljs.core.Keyword))?G__28569_28609.fqn:null);
switch (G__28569_28610__$1) {
case "novelty":
var statearr_28570_28612 = state_28542__$1;
(statearr_28570_28612[(1)] = (17));


break;
case "history":
var statearr_28571_28613 = state_28542__$1;
(statearr_28571_28613[(1)] = (18));


break;
case "none":
var statearr_28572_28614 = state_28542__$1;
(statearr_28572_28614[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28569_28610__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (5))){
var _ = (function (){var statearr_28573 = state_28542;
(statearr_28573[(4)] = cljs.core.rest((state_28542[(4)])));

return statearr_28573;
})();
var state_28542__$1 = state_28542;
var ex28565 = (state_28542__$1[(2)]);
var statearr_28574_28615 = state_28542__$1;
(statearr_28574_28615[(5)] = ex28565);


var statearr_28575_28616 = state_28542__$1;
(statearr_28575_28616[(1)] = (4));

(statearr_28575_28616[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (14))){
var state_28542__$1 = state_28542;
var statearr_28576_28617 = state_28542__$1;
(statearr_28576_28617[(2)] = null);

(statearr_28576_28617[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (16))){
var inst_28511 = (state_28542[(12)]);
var inst_28524 = (state_28542[(2)]);
var state_28542__$1 = (function (){var statearr_28577 = state_28542;
(statearr_28577[(10)] = inst_28524);

return statearr_28577;
})();
var G__28578_28618 = inst_28511;
var G__28578_28619__$1 = (((G__28578_28618 instanceof cljs.core.Keyword))?G__28578_28618.fqn:null);
switch (G__28578_28619__$1) {
case "novelty":
var statearr_28579_28621 = state_28542__$1;
(statearr_28579_28621[(1)] = (22));


break;
case "history":
var statearr_28580_28622 = state_28542__$1;
(statearr_28580_28622[(1)] = (23));


break;
case "none":
var statearr_28581_28623 = state_28542__$1;
(statearr_28581_28623[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28578_28619__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (10))){
var state_28542__$1 = state_28542;
var statearr_28582_28624 = state_28542__$1;
(statearr_28582_28624[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_28582_28624[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28543 === (18))){
var inst_28494 = (state_28542[(9)]);
var inst_28495 = (state_28542[(11)]);
var inst_28511 = (state_28542[(12)]);
var inst_28496 = (state_28542[(13)]);
var inst_28514 = (function (){var base_node = inst_28494;
var first_flake = inst_28495;
var node_t = inst_28496;
var source = inst_28511;
return (function (p1__28481_SHARP_){
return (p1__28481_SHARP_.t <= t);
});
})();
var inst_28515 = fluree.db.dbproto._resolve_history(node);
var state_28542__$1 = (function (){var statearr_28583 = state_28542;
(statearr_28583[(14)] = inst_28514);

return statearr_28583;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28542__$1,(19),inst_28515);
} else {
if((state_val_28543 === (8))){
var inst_28496 = (state_28542[(13)]);
var inst_28500 = (inst_28496 < t);
var state_28542__$1 = state_28542;
if(cljs.core.truth_(inst_28500)){
var statearr_28584_28625 = state_28542__$1;
(statearr_28584_28625[(1)] = (10));

} else {
var statearr_28585_28626 = state_28542__$1;
(statearr_28585_28626[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____0 = (function (){
var statearr_28586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28586[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__);

(statearr_28586[(1)] = (1));

return statearr_28586;
});
var fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____1 = (function (state_28542){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28542);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28587){var ex__11413__auto__ = e28587;
var statearr_28588_28627 = state_28542;
(statearr_28588_28627[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28542[(4)]))){
var statearr_28589_28628 = state_28542;
(statearr_28589_28628[(1)] = cljs.core.first((state_28542[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28629 = state_28542;
state_28542 = G__28629;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__ = function(state_28542){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____1.call(this,state_28542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__11410__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28590 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28590[(6)] = c__11484__auto___28591);

return statearr_28590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28689){
var state_val_28690 = (state_28689[(1)]);
if((state_val_28690 === (7))){
var inst_28640 = (state_28689[(7)]);
var inst_28644 = (inst_28640 <= from_t);
var state_28689__$1 = state_28689;
var statearr_28691_28731 = state_28689__$1;
(statearr_28691_28731[(2)] = inst_28644);

(statearr_28691_28731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (20))){
var inst_28674 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_28675 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28674)].join('');
var inst_28676 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28677 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28678 = cljs.core.PersistentHashMap.fromArrays(inst_28676,inst_28677);
var inst_28679 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28675,inst_28678);
var inst_28680 = (function(){throw inst_28679})();
var state_28689__$1 = state_28689;
var statearr_28692_28732 = state_28689__$1;
(statearr_28692_28732[(2)] = inst_28680);

(statearr_28692_28732[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (1))){
var state_28689__$1 = state_28689;
var statearr_28693_28733 = state_28689__$1;
(statearr_28693_28733[(2)] = null);

(statearr_28693_28733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (4))){
var inst_28632 = (state_28689[(2)]);
var inst_28633 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28632], 0));
var inst_28634 = (function(){throw inst_28632})();
var state_28689__$1 = (function (){var statearr_28694 = state_28689;
(statearr_28694[(8)] = inst_28633);

return statearr_28694;
})();
var statearr_28695_28734 = state_28689__$1;
(statearr_28695_28734[(2)] = inst_28634);

(statearr_28695_28734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (15))){
var inst_28659 = (state_28689[(2)]);
var state_28689__$1 = (function (){var statearr_28696 = state_28689;
(statearr_28696[(9)] = inst_28659);

return statearr_28696;
})();
if(cljs.core.truth_(from_t)){
var statearr_28697_28735 = state_28689__$1;
(statearr_28697_28735[(1)] = (16));

} else {
var statearr_28698_28736 = state_28689__$1;
(statearr_28698_28736[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (21))){
var inst_28668 = (state_28689[(10)]);
var inst_28670 = (state_28689[(11)]);
var inst_28669 = (state_28689[(12)]);
var inst_28682 = (state_28689[(2)]);
var inst_28683 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_28669,inst_28670,leftmost_QMARK_,to_t);
var inst_28684 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28683,inst_28668);
var _ = (function (){var statearr_28699 = state_28689;
(statearr_28699[(4)] = cljs.core.rest((state_28689[(4)])));

return statearr_28699;
})();
var state_28689__$1 = (function (){var statearr_28700 = state_28689;
(statearr_28700[(13)] = inst_28682);

return statearr_28700;
})();
var statearr_28701_28737 = state_28689__$1;
(statearr_28701_28737[(2)] = inst_28684);

(statearr_28701_28737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (13))){
var inst_28640 = (state_28689[(7)]);
var inst_28652 = (state_28689[(14)]);
var inst_28655 = (function (){var node_t = inst_28640;
var G__28648 = inst_28652;
return (function (p1__28630_SHARP_){
return (p1__28630_SHARP_.t < to_t);
});
})();
var inst_28656 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_28655,inst_28652);
var state_28689__$1 = state_28689;
var statearr_28702_28738 = state_28689__$1;
(statearr_28702_28738[(2)] = inst_28656);

(statearr_28702_28738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (6))){
var inst_28641 = (state_28689[(15)]);
var state_28689__$1 = state_28689;
var statearr_28703_28739 = state_28689__$1;
(statearr_28703_28739[(2)] = inst_28641);

(statearr_28703_28739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (17))){
var inst_28659 = (state_28689[(9)]);
var state_28689__$1 = state_28689;
var statearr_28704_28740 = state_28689__$1;
(statearr_28704_28740[(2)] = inst_28659);

(statearr_28704_28740[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (3))){
var inst_28687 = (state_28689[(2)]);
var state_28689__$1 = state_28689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28689__$1,inst_28687);
} else {
if((state_val_28690 === (12))){
var inst_28640 = (state_28689[(7)]);
var inst_28651 = (state_28689[(2)]);
var inst_28652 = fluree.db.util.async.throw_err(inst_28651);
var inst_28653 = (to_t > inst_28640);
var state_28689__$1 = (function (){var statearr_28705 = state_28689;
(statearr_28705[(14)] = inst_28652);

return statearr_28705;
})();
if(cljs.core.truth_(inst_28653)){
var statearr_28706_28741 = state_28689__$1;
(statearr_28706_28741[(1)] = (13));

} else {
var statearr_28707_28742 = state_28689__$1;
(statearr_28707_28742[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (2))){
var inst_28641 = (state_28689[(15)]);
var _ = (function (){var statearr_28708 = state_28689;
(statearr_28708[(4)] = cljs.core.cons((5),(state_28689[(4)])));

return statearr_28708;
})();
var inst_28640 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_28641__$1 = (from_t == null);
var state_28689__$1 = (function (){var statearr_28709 = state_28689;
(statearr_28709[(7)] = inst_28640);

(statearr_28709[(15)] = inst_28641__$1);

return statearr_28709;
})();
if(cljs.core.truth_(inst_28641__$1)){
var statearr_28710_28743 = state_28689__$1;
(statearr_28710_28743[(1)] = (6));

} else {
var statearr_28711_28744 = state_28689__$1;
(statearr_28711_28744[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (19))){
var state_28689__$1 = state_28689;
var statearr_28712_28745 = state_28689__$1;
(statearr_28712_28745[(2)] = null);

(statearr_28712_28745[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (11))){
var inst_28668 = (state_28689[(2)]);
var inst_28669 = fluree.db.dbproto._first_flake(node);
var inst_28670 = fluree.db.dbproto._rhs(node);
var inst_28671 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_28689__$1 = (function (){var statearr_28714 = state_28689;
(statearr_28714[(10)] = inst_28668);

(statearr_28714[(11)] = inst_28670);

(statearr_28714[(12)] = inst_28669);

return statearr_28714;
})();
if(cljs.core.truth_(inst_28671)){
var statearr_28715_28746 = state_28689__$1;
(statearr_28715_28746[(1)] = (19));

} else {
var statearr_28716_28747 = state_28689__$1;
(statearr_28716_28747[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (9))){
var inst_28649 = fluree.db.dbproto._resolve_history(node);
var state_28689__$1 = state_28689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28689__$1,(12),inst_28649);
} else {
if((state_val_28690 === (5))){
var _ = (function (){var statearr_28717 = state_28689;
(statearr_28717[(4)] = cljs.core.rest((state_28689[(4)])));

return statearr_28717;
})();
var state_28689__$1 = state_28689;
var ex28713 = (state_28689__$1[(2)]);
var statearr_28718_28748 = state_28689__$1;
(statearr_28718_28748[(5)] = ex28713);


var statearr_28719_28749 = state_28689__$1;
(statearr_28719_28749[(1)] = (4));

(statearr_28719_28749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (14))){
var inst_28652 = (state_28689[(14)]);
var state_28689__$1 = state_28689;
var statearr_28720_28750 = state_28689__$1;
(statearr_28720_28750[(2)] = inst_28652);

(statearr_28720_28750[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (16))){
var inst_28659 = (state_28689[(9)]);
var inst_28640 = (state_28689[(7)]);
var inst_28661 = (function (){var node_t = inst_28640;
var G__28648 = inst_28659;
return (function (p1__28631_SHARP_){
return (p1__28631_SHARP_.t <= from_t);
});
})();
var inst_28662 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_28661,inst_28659);
var state_28689__$1 = state_28689;
var statearr_28721_28751 = state_28689__$1;
(statearr_28721_28751[(2)] = inst_28662);

(statearr_28721_28751[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (10))){
var state_28689__$1 = state_28689;
var statearr_28722_28752 = state_28689__$1;
(statearr_28722_28752[(2)] = null);

(statearr_28722_28752[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (18))){
var inst_28665 = (state_28689[(2)]);
var state_28689__$1 = state_28689;
var statearr_28723_28753 = state_28689__$1;
(statearr_28723_28753[(2)] = inst_28665);

(statearr_28723_28753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28690 === (8))){
var inst_28646 = (state_28689[(2)]);
var state_28689__$1 = state_28689;
if(cljs.core.truth_(inst_28646)){
var statearr_28724_28754 = state_28689__$1;
(statearr_28724_28754[(1)] = (9));

} else {
var statearr_28725_28755 = state_28689__$1;
(statearr_28725_28755[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____0 = (function (){
var statearr_28726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28726[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__);

(statearr_28726[(1)] = (1));

return statearr_28726;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____1 = (function (state_28689){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28689);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28727){var ex__11413__auto__ = e28727;
var statearr_28728_28756 = state_28689;
(statearr_28728_28756[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28689[(4)]))){
var statearr_28729_28757 = state_28689;
(statearr_28729_28757[(1)] = cljs.core.first((state_28689[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28758 = state_28689;
state_28689 = G__28758;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__ = function(state_28689){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____1.call(this,state_28689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28730 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28730[(6)] = c__11484__auto__);

return statearr_28730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__28759_28769 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__28760_28770 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__28759_28769,G__28760_28770) : object_cache.call(null,G__28759_28769,G__28760_28770));

var G__28761 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__28762 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__28763 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__28764 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__28763,G__28764) : object_cache.call(null,G__28763,G__28764));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__28761,G__28762) : object_cache.call(null,G__28761,G__28762));
} else {
var G__28765 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__28766 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__28767 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__28768 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__28767,G__28768) : object_cache.call(null,G__28767,G__28768));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__28765,G__28766) : object_cache.call(null,G__28765,G__28766));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28791){
var state_val_28792 = (state_28791[(1)]);
if((state_val_28792 === (7))){
var inst_28780 = (state_28791[(7)]);
var inst_28782 = fluree.db.storage.core.serde(conn);
var inst_28783 = fluree.db.serde.protocol._deserialize_branch(inst_28782,inst_28780);
var state_28791__$1 = state_28791;
var statearr_28793_28812 = state_28791__$1;
(statearr_28793_28812[(2)] = inst_28783);

(statearr_28793_28812[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (1))){
var state_28791__$1 = state_28791;
var statearr_28794_28813 = state_28791__$1;
(statearr_28794_28813[(2)] = null);

(statearr_28794_28813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (4))){
var inst_28771 = (state_28791[(2)]);
var state_28791__$1 = state_28791;
var statearr_28795_28814 = state_28791__$1;
(statearr_28795_28814[(2)] = inst_28771);

(statearr_28795_28814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (6))){
var inst_28780 = (state_28791[(7)]);
var inst_28779 = (state_28791[(2)]);
var inst_28780__$1 = fluree.db.util.async.throw_err(inst_28779);
var state_28791__$1 = (function (){var statearr_28796 = state_28791;
(statearr_28796[(7)] = inst_28780__$1);

return statearr_28796;
})();
if(cljs.core.truth_(inst_28780__$1)){
var statearr_28797_28815 = state_28791__$1;
(statearr_28797_28815[(1)] = (7));

} else {
var statearr_28798_28816 = state_28791__$1;
(statearr_28798_28816[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (3))){
var inst_28789 = (state_28791[(2)]);
var state_28791__$1 = state_28791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28791__$1,inst_28789);
} else {
if((state_val_28792 === (2))){
var _ = (function (){var statearr_28800 = state_28791;
(statearr_28800[(4)] = cljs.core.cons((5),(state_28791[(4)])));

return statearr_28800;
})();
var inst_28777 = fluree.db.storage.core.storage_read(conn,key);
var state_28791__$1 = state_28791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28791__$1,(6),inst_28777);
} else {
if((state_val_28792 === (9))){
var inst_28786 = (state_28791[(2)]);
var _ = (function (){var statearr_28801 = state_28791;
(statearr_28801[(4)] = cljs.core.rest((state_28791[(4)])));

return statearr_28801;
})();
var state_28791__$1 = state_28791;
var statearr_28802_28817 = state_28791__$1;
(statearr_28802_28817[(2)] = inst_28786);

(statearr_28802_28817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (5))){
var _ = (function (){var statearr_28803 = state_28791;
(statearr_28803[(4)] = cljs.core.rest((state_28791[(4)])));

return statearr_28803;
})();
var state_28791__$1 = state_28791;
var ex28799 = (state_28791__$1[(2)]);
var statearr_28804_28818 = state_28791__$1;
(statearr_28804_28818[(5)] = ex28799);


if((ex28799 instanceof Error)){
var statearr_28805_28819 = state_28791__$1;
(statearr_28805_28819[(1)] = (4));

(statearr_28805_28819[(5)] = null);

} else {
throw ex28799;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (8))){
var state_28791__$1 = state_28791;
var statearr_28806_28820 = state_28791__$1;
(statearr_28806_28820[(2)] = null);

(statearr_28806_28820[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__11410__auto____0 = (function (){
var statearr_28807 = [null,null,null,null,null,null,null,null];
(statearr_28807[(0)] = fluree$db$storage$core$read_branch_$_state_machine__11410__auto__);

(statearr_28807[(1)] = (1));

return statearr_28807;
});
var fluree$db$storage$core$read_branch_$_state_machine__11410__auto____1 = (function (state_28791){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28791);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28808){var ex__11413__auto__ = e28808;
var statearr_28809_28821 = state_28791;
(statearr_28809_28821[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28791[(4)]))){
var statearr_28810_28822 = state_28791;
(statearr_28810_28822[(1)] = cljs.core.first((state_28791[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28823 = state_28791;
state_28791 = G__28823;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__11410__auto__ = function(state_28791){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__11410__auto____1.call(this,state_28791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28811 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28811[(6)] = c__11484__auto__);

return statearr_28811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___28902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28874){
var state_val_28875 = (state_28874[(1)]);
if((state_val_28875 === (7))){
var inst_28841 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_28842 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28843 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_28844 = cljs.core.PersistentHashMap.fromArrays(inst_28842,inst_28843);
var inst_28845 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28841,inst_28844);
var inst_28846 = (function(){throw inst_28845})();
var state_28874__$1 = state_28874;
var statearr_28876_28903 = state_28874__$1;
(statearr_28876_28903[(2)] = inst_28846);

(statearr_28876_28903[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (1))){
var state_28874__$1 = state_28874;
var statearr_28877_28904 = state_28874__$1;
(statearr_28877_28904[(2)] = null);

(statearr_28877_28904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (4))){
var inst_28824 = (state_28874[(2)]);
var inst_28825 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_28826 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_28824);
var inst_28827 = cljs.core.async.close_BANG_(return_ch);
var state_28874__$1 = (function (){var statearr_28878 = state_28874;
(statearr_28878[(7)] = inst_28826);

(statearr_28878[(8)] = inst_28825);

return statearr_28878;
})();
var statearr_28879_28905 = state_28874__$1;
(statearr_28879_28905[(2)] = inst_28827);

(statearr_28879_28905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (6))){
var inst_28838 = (state_28874[(9)]);
var inst_28837 = (state_28874[(2)]);
var inst_28838__$1 = fluree.db.util.async.throw_err(inst_28837);
var inst_28839 = (inst_28838__$1 == null);
var state_28874__$1 = (function (){var statearr_28880 = state_28874;
(statearr_28880[(9)] = inst_28838__$1);

return statearr_28880;
})();
if(cljs.core.truth_(inst_28839)){
var statearr_28881_28906 = state_28874__$1;
(statearr_28881_28906[(1)] = (7));

} else {
var statearr_28882_28907 = state_28874__$1;
(statearr_28882_28907[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (3))){
var inst_28872 = (state_28874[(2)]);
var state_28874__$1 = state_28874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28874__$1,inst_28872);
} else {
if((state_val_28875 === (12))){
var inst_28838 = (state_28874[(9)]);
var inst_28855 = (state_28874[(2)]);
var inst_28856 = cljs.core.__destructure_map(inst_28838);
var inst_28857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28856,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_28858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28856,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_28859 = config;
var inst_28860 = cljs.core.__destructure_map(inst_28859);
var inst_28861 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28860,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_28863 = (function (){var data = inst_28838;
var _ = inst_28855;
var map__28833 = inst_28856;
var children = inst_28857;
var rhs = inst_28858;
var map__28834 = inst_28860;
var comparator = inst_28861;
return (function (idx,p__28862){
var map__28883 = p__28862;
var map__28883__$1 = cljs.core.__destructure_map(map__28883);
var child = map__28883__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28883__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28883__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28883__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28883__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28883__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_28864 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_28863,inst_28857);
var inst_28865 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_28864);
var inst_28866 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_28865,inst_28864);
var inst_28867 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_28861,inst_28866);
var inst_28868 = fluree.db.index.__GT_IndexNode(block,t,inst_28858,inst_28867,config,leftmost_QMARK_);
var inst_28869 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_28868);
var _ = (function (){var statearr_28884 = state_28874;
(statearr_28884[(4)] = cljs.core.rest((state_28874[(4)])));

return statearr_28884;
})();
var state_28874__$1 = state_28874;
var statearr_28885_28908 = state_28874__$1;
(statearr_28885_28908[(2)] = inst_28869);

(statearr_28885_28908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (2))){
var _ = (function (){var statearr_28886 = state_28874;
(statearr_28886[(4)] = cljs.core.cons((5),(state_28874[(4)])));

return statearr_28886;
})();
var inst_28835 = fluree.db.storage.core.read_branch(conn,key);
var state_28874__$1 = state_28874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28874__$1,(6),inst_28835);
} else {
if((state_val_28875 === (11))){
var state_28874__$1 = state_28874;
var statearr_28888_28909 = state_28874__$1;
(statearr_28888_28909[(2)] = null);

(statearr_28888_28909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (9))){
var inst_28838 = (state_28874[(9)]);
var inst_28849 = (state_28874[(2)]);
var inst_28850 = fluree.db.util.core.exception_QMARK_(inst_28838);
var state_28874__$1 = (function (){var statearr_28889 = state_28874;
(statearr_28889[(10)] = inst_28849);

return statearr_28889;
})();
if(inst_28850){
var statearr_28890_28910 = state_28874__$1;
(statearr_28890_28910[(1)] = (10));

} else {
var statearr_28891_28911 = state_28874__$1;
(statearr_28891_28911[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (5))){
var _ = (function (){var statearr_28892 = state_28874;
(statearr_28892[(4)] = cljs.core.rest((state_28874[(4)])));

return statearr_28892;
})();
var state_28874__$1 = state_28874;
var ex28887 = (state_28874__$1[(2)]);
var statearr_28893_28912 = state_28874__$1;
(statearr_28893_28912[(5)] = ex28887);


var statearr_28894_28913 = state_28874__$1;
(statearr_28894_28913[(1)] = (4));

(statearr_28894_28913[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (10))){
var inst_28838 = (state_28874[(9)]);
var inst_28852 = (function(){throw inst_28838})();
var state_28874__$1 = state_28874;
var statearr_28895_28914 = state_28874__$1;
(statearr_28895_28914[(2)] = inst_28852);

(statearr_28895_28914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28875 === (8))){
var state_28874__$1 = state_28874;
var statearr_28896_28915 = state_28874__$1;
(statearr_28896_28915[(2)] = null);

(statearr_28896_28915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____0 = (function (){
var statearr_28897 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28897[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__);

(statearr_28897[(1)] = (1));

return statearr_28897;
});
var fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____1 = (function (state_28874){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28874);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28898){var ex__11413__auto__ = e28898;
var statearr_28899_28916 = state_28874;
(statearr_28899_28916[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28874[(4)]))){
var statearr_28900_28917 = state_28874;
(statearr_28900_28917[(1)] = cljs.core.first((state_28874[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28918 = state_28874;
state_28874 = G__28918;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__ = function(state_28874){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____1.call(this,state_28874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__11410__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28901 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28901[(6)] = c__11484__auto___28902);

return statearr_28901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_28939){
var state_val_28940 = (state_28939[(1)]);
if((state_val_28940 === (7))){
var state_28939__$1 = state_28939;
var statearr_28941_28961 = state_28939__$1;
(statearr_28941_28961[(2)] = null);

(statearr_28941_28961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (1))){
var state_28939__$1 = state_28939;
var statearr_28942_28962 = state_28939__$1;
(statearr_28942_28962[(2)] = null);

(statearr_28942_28962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (4))){
var inst_28919 = (state_28939[(2)]);
var state_28939__$1 = state_28939;
var statearr_28943_28963 = state_28939__$1;
(statearr_28943_28963[(2)] = inst_28919);

(statearr_28943_28963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (6))){
var inst_28925 = (state_28939[(7)]);
var inst_28927 = fluree.db.storage.core.serde(conn);
var state_28939__$1 = (function (){var statearr_28944 = state_28939;
(statearr_28944[(8)] = inst_28927);

return statearr_28944;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28939__$1,(9),inst_28925);
} else {
if((state_val_28940 === (3))){
var inst_28937 = (state_28939[(2)]);
var state_28939__$1 = state_28939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28939__$1,inst_28937);
} else {
if((state_val_28940 === (2))){
var inst_28925 = (state_28939[(7)]);
var _ = (function (){var statearr_28946 = state_28939;
(statearr_28946[(4)] = cljs.core.cons((5),(state_28939[(4)])));

return statearr_28946;
})();
var inst_28925__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_28939__$1 = (function (){var statearr_28947 = state_28939;
(statearr_28947[(7)] = inst_28925__$1);

return statearr_28947;
})();
if(cljs.core.truth_(inst_28925__$1)){
var statearr_28948_28964 = state_28939__$1;
(statearr_28948_28964[(1)] = (6));

} else {
var statearr_28949_28965 = state_28939__$1;
(statearr_28949_28965[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (9))){
var inst_28927 = (state_28939[(8)]);
var inst_28929 = (state_28939[(2)]);
var inst_28930 = fluree.db.util.async.throw_err(inst_28929);
var inst_28931 = fluree.db.serde.protocol._deserialize_leaf(inst_28927,inst_28930);
var state_28939__$1 = state_28939;
var statearr_28950_28966 = state_28939__$1;
(statearr_28950_28966[(2)] = inst_28931);

(statearr_28950_28966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (5))){
var _ = (function (){var statearr_28951 = state_28939;
(statearr_28951[(4)] = cljs.core.rest((state_28939[(4)])));

return statearr_28951;
})();
var state_28939__$1 = state_28939;
var ex28945 = (state_28939__$1[(2)]);
var statearr_28952_28967 = state_28939__$1;
(statearr_28952_28967[(5)] = ex28945);


if((ex28945 instanceof Error)){
var statearr_28953_28968 = state_28939__$1;
(statearr_28953_28968[(1)] = (4));

(statearr_28953_28968[(5)] = null);

} else {
throw ex28945;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28940 === (8))){
var inst_28934 = (state_28939[(2)]);
var _ = (function (){var statearr_28954 = state_28939;
(statearr_28954[(4)] = cljs.core.rest((state_28939[(4)])));

return statearr_28954;
})();
var state_28939__$1 = state_28939;
var statearr_28955_28969 = state_28939__$1;
(statearr_28955_28969[(2)] = inst_28934);

(statearr_28955_28969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____0 = (function (){
var statearr_28956 = [null,null,null,null,null,null,null,null,null];
(statearr_28956[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__);

(statearr_28956[(1)] = (1));

return statearr_28956;
});
var fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____1 = (function (state_28939){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_28939);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e28957){var ex__11413__auto__ = e28957;
var statearr_28958_28970 = state_28939;
(statearr_28958_28970[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_28939[(4)]))){
var statearr_28959_28971 = state_28939;
(statearr_28959_28971[(1)] = cljs.core.first((state_28939[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28972 = state_28939;
state_28939 = G__28972;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__ = function(state_28939){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____1.call(this,state_28939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_28960 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_28960[(6)] = c__11484__auto__);

return statearr_28960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___29045 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29017){
var state_val_29018 = (state_29017[(1)]);
if((state_val_29018 === (7))){
var inst_28989 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_28990 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28991 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_28992 = cljs.core.PersistentHashMap.fromArrays(inst_28990,inst_28991);
var inst_28993 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28989,inst_28992);
var inst_28994 = (function(){throw inst_28993})();
var state_29017__$1 = state_29017;
var statearr_29019_29046 = state_29017__$1;
(statearr_29019_29046[(2)] = inst_28994);

(statearr_29019_29046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (1))){
var state_29017__$1 = state_29017;
var statearr_29020_29047 = state_29017__$1;
(statearr_29020_29047[(2)] = null);

(statearr_29020_29047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (4))){
var inst_28973 = (state_29017[(2)]);
var inst_28974 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_28975 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_28973);
var inst_28976 = cljs.core.async.close_BANG_(return_ch);
var state_29017__$1 = (function (){var statearr_29021 = state_29017;
(statearr_29021[(7)] = inst_28975);

(statearr_29021[(8)] = inst_28974);

return statearr_29021;
})();
var statearr_29022_29048 = state_29017__$1;
(statearr_29022_29048[(2)] = inst_28976);

(statearr_29022_29048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (6))){
var inst_28986 = (state_29017[(9)]);
var inst_28986__$1 = (state_29017[(2)]);
var inst_28987 = (inst_28986__$1 == null);
var state_29017__$1 = (function (){var statearr_29023 = state_29017;
(statearr_29023[(9)] = inst_28986__$1);

return statearr_29023;
})();
if(cljs.core.truth_(inst_28987)){
var statearr_29024_29049 = state_29017__$1;
(statearr_29024_29049[(1)] = (7));

} else {
var statearr_29025_29050 = state_29017__$1;
(statearr_29025_29050[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (3))){
var inst_29015 = (state_29017[(2)]);
var state_29017__$1 = state_29017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29017__$1,inst_29015);
} else {
if((state_val_29018 === (12))){
var inst_28986 = (state_29017[(9)]);
var inst_29003 = (state_29017[(2)]);
var inst_29004 = cljs.core.__destructure_map(inst_28986);
var inst_29005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29004,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_29006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29004,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_29007 = config;
var inst_29008 = cljs.core.__destructure_map(inst_29007);
var inst_29009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29008,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_29010 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_29009,inst_29005);
var inst_29011 = fluree.db.index.data_node(block,t,inst_29010,rhs,config);
var inst_29012 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29011);
var _ = (function (){var statearr_29026 = state_29017;
(statearr_29026[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29026;
})();
var state_29017__$1 = (function (){var statearr_29027 = state_29017;
(statearr_29027[(10)] = inst_29003);

(statearr_29027[(11)] = inst_29006);

return statearr_29027;
})();
var statearr_29028_29051 = state_29017__$1;
(statearr_29028_29051[(2)] = inst_29012);

(statearr_29028_29051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (2))){
var _ = (function (){var statearr_29029 = state_29017;
(statearr_29029[(4)] = cljs.core.cons((5),(state_29017[(4)])));

return statearr_29029;
})();
var inst_28984 = fluree.db.storage.core.read_leaf(conn,key);
var state_29017__$1 = state_29017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29017__$1,(6),inst_28984);
} else {
if((state_val_29018 === (11))){
var state_29017__$1 = state_29017;
var statearr_29031_29052 = state_29017__$1;
(statearr_29031_29052[(2)] = null);

(statearr_29031_29052[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (9))){
var inst_28986 = (state_29017[(9)]);
var inst_28997 = (state_29017[(2)]);
var inst_28998 = fluree.db.util.core.exception_QMARK_(inst_28986);
var state_29017__$1 = (function (){var statearr_29032 = state_29017;
(statearr_29032[(12)] = inst_28997);

return statearr_29032;
})();
if(inst_28998){
var statearr_29033_29053 = state_29017__$1;
(statearr_29033_29053[(1)] = (10));

} else {
var statearr_29034_29054 = state_29017__$1;
(statearr_29034_29054[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (5))){
var _ = (function (){var statearr_29035 = state_29017;
(statearr_29035[(4)] = cljs.core.rest((state_29017[(4)])));

return statearr_29035;
})();
var state_29017__$1 = state_29017;
var ex29030 = (state_29017__$1[(2)]);
var statearr_29036_29055 = state_29017__$1;
(statearr_29036_29055[(5)] = ex29030);


var statearr_29037_29056 = state_29017__$1;
(statearr_29037_29056[(1)] = (4));

(statearr_29037_29056[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (10))){
var inst_28986 = (state_29017[(9)]);
var inst_29000 = (function(){throw inst_28986})();
var state_29017__$1 = state_29017;
var statearr_29038_29057 = state_29017__$1;
(statearr_29038_29057[(2)] = inst_29000);

(statearr_29038_29057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29018 === (8))){
var state_29017__$1 = state_29017;
var statearr_29039_29058 = state_29017__$1;
(statearr_29039_29058[(2)] = null);

(statearr_29039_29058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____0 = (function (){
var statearr_29040 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29040[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__);

(statearr_29040[(1)] = (1));

return statearr_29040;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____1 = (function (state_29017){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29017);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29041){var ex__11413__auto__ = e29041;
var statearr_29042_29059 = state_29017;
(statearr_29042_29059[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29017[(4)]))){
var statearr_29043_29060 = state_29017;
(statearr_29043_29060[(1)] = cljs.core.first((state_29017[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29061 = state_29017;
state_29017 = G__29061;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__ = function(state_29017){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____1.call(this,state_29017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29044 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29044[(6)] = c__11484__auto___29045);

return statearr_29044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k29063,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__29067 = k29063;
var G__29067__$1 = (((G__29067 instanceof cljs.core.Keyword))?G__29067.fqn:null);
switch (G__29067__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k29063,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__29068){
var vec__29069 = p__29068;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29069,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29069,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29062){
var self__ = this;
var G__29062__$1 = this;
return (new cljs.core.RecordIter((0),G__29062__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__29072 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__29073 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__29074 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__29075 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29074,G__29075) : object_cache.call(null,G__29074,G__29075));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__29076 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__29077 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29076,G__29077) : object_cache.call(null,G__29076,G__29077));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29072,G__29073) : object_cache.call(null,G__29072,G__29073));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__29078 = history_id;
var G__29079 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29078,G__29079) : object_cache.call(null,G__29078,G__29079));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__29080 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__29080(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this29064,other29065){
var self__ = this;
var this29064__$1 = this;
return (((!((other29065 == null)))) && ((((this29064__$1.constructor === other29065.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.conn,other29065.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.config,other29065.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.network,other29065.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.dbid,other29065.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.id,other29065.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.leaf,other29065.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.first,other29065.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.rhs,other29065.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.size,other29065.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.block,other29065.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.t,other29065.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.tt_id,other29065.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.leftmost_QMARK_,other29065.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.tempid,other29065.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29064__$1.__extmap,other29065.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k29063){
var self__ = this;
var this__4509__auto____$1 = this;
var G__29081 = k29063;
var G__29081__$1 = (((G__29081 instanceof cljs.core.Keyword))?G__29081.fqn:null);
switch (G__29081__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k29063);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__29062){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__29082 = cljs.core.keyword_identical_QMARK_;
var expr__29083 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__29085 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__29086 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29085,G__29086) : pred__29082.call(null,G__29085,G__29086));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__29062,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29087 = new cljs.core.Keyword(null,"config","config",994861415);
var G__29088 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29087,G__29088) : pred__29082.call(null,G__29087,G__29088));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__29062,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29089 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__29090 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29089,G__29090) : pred__29082.call(null,G__29089,G__29090));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__29062,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29091 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__29092 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29091,G__29092) : pred__29082.call(null,G__29091,G__29092));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__29062,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29093 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__29094 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29093,G__29094) : pred__29082.call(null,G__29093,G__29094));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__29062,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29095 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__29096 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29095,G__29096) : pred__29082.call(null,G__29095,G__29096));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__29062,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29097 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__29098 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29097,G__29098) : pred__29082.call(null,G__29097,G__29098));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__29062,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29099 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__29100 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29099,G__29100) : pred__29082.call(null,G__29099,G__29100));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__29062,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29101 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__29102 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29101,G__29102) : pred__29082.call(null,G__29101,G__29102));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__29062,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29103 = new cljs.core.Keyword(null,"block","block",664686210);
var G__29104 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29103,G__29104) : pred__29082.call(null,G__29103,G__29104));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__29062,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29105 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__29106 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29105,G__29106) : pred__29082.call(null,G__29105,G__29106));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__29062,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29107 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__29108 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29107,G__29108) : pred__29082.call(null,G__29107,G__29108));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__29062,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29109 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__29110 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29109,G__29110) : pred__29082.call(null,G__29109,G__29110));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__29062,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29111 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__29112 = expr__29083;
return (pred__29082.cljs$core$IFn$_invoke$arity$2 ? pred__29082.cljs$core$IFn$_invoke$arity$2(G__29111,G__29112) : pred__29082.call(null,G__29111,G__29112));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__29062,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__29062),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__29062){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__29062,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__29066){
var extmap__4542__auto__ = (function (){var G__29113 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__29066,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__29066)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__29113);
} else {
return G__29113;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__29066),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__29066),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__29116 = blank_db;
var map__29116__$1 = cljs.core.__destructure_map(map__29116);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29116__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29116__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29116__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__29117 = root_data;
var map__29117__$1 = cljs.core.__destructure_map(map__29117);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29117__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29117__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29117__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29117__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29139){
var state_val_29140 = (state_29139[(1)]);
if((state_val_29140 === (7))){
var state_29139__$1 = state_29139;
var statearr_29141_29161 = state_29139__$1;
(statearr_29141_29161[(2)] = null);

(statearr_29141_29161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (1))){
var state_29139__$1 = state_29139;
var statearr_29142_29162 = state_29139__$1;
(statearr_29142_29162[(2)] = null);

(statearr_29142_29162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (4))){
var inst_29118 = (state_29139[(2)]);
var state_29139__$1 = state_29139;
var statearr_29143_29163 = state_29139__$1;
(statearr_29143_29163[(2)] = inst_29118);

(statearr_29143_29163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (6))){
var inst_29125 = (state_29139[(7)]);
var inst_29127 = fluree.db.storage.core.serde(conn);
var state_29139__$1 = (function (){var statearr_29144 = state_29139;
(statearr_29144[(8)] = inst_29127);

return statearr_29144;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29139__$1,(9),inst_29125);
} else {
if((state_val_29140 === (3))){
var inst_29137 = (state_29139[(2)]);
var state_29139__$1 = state_29139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29139__$1,inst_29137);
} else {
if((state_val_29140 === (2))){
var inst_29125 = (state_29139[(7)]);
var _ = (function (){var statearr_29146 = state_29139;
(statearr_29146[(4)] = cljs.core.cons((5),(state_29139[(4)])));

return statearr_29146;
})();
var inst_29124 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_29125__$1 = fluree.db.storage.core.storage_read(conn,inst_29124);
var state_29139__$1 = (function (){var statearr_29147 = state_29139;
(statearr_29147[(7)] = inst_29125__$1);

return statearr_29147;
})();
if(cljs.core.truth_(inst_29125__$1)){
var statearr_29148_29164 = state_29139__$1;
(statearr_29148_29164[(1)] = (6));

} else {
var statearr_29149_29165 = state_29139__$1;
(statearr_29149_29165[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (9))){
var inst_29127 = (state_29139[(8)]);
var inst_29129 = (state_29139[(2)]);
var inst_29130 = fluree.db.util.async.throw_err(inst_29129);
var inst_29131 = fluree.db.serde.protocol._deserialize_garbage(inst_29127,inst_29130);
var state_29139__$1 = state_29139;
var statearr_29150_29166 = state_29139__$1;
(statearr_29150_29166[(2)] = inst_29131);

(statearr_29150_29166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (5))){
var _ = (function (){var statearr_29151 = state_29139;
(statearr_29151[(4)] = cljs.core.rest((state_29139[(4)])));

return statearr_29151;
})();
var state_29139__$1 = state_29139;
var ex29145 = (state_29139__$1[(2)]);
var statearr_29152_29167 = state_29139__$1;
(statearr_29152_29167[(5)] = ex29145);


if((ex29145 instanceof Error)){
var statearr_29153_29168 = state_29139__$1;
(statearr_29153_29168[(1)] = (4));

(statearr_29153_29168[(5)] = null);

} else {
throw ex29145;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29140 === (8))){
var inst_29134 = (state_29139[(2)]);
var _ = (function (){var statearr_29154 = state_29139;
(statearr_29154[(4)] = cljs.core.rest((state_29139[(4)])));

return statearr_29154;
})();
var state_29139__$1 = state_29139;
var statearr_29155_29169 = state_29139__$1;
(statearr_29155_29169[(2)] = inst_29134);

(statearr_29155_29169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____0 = (function (){
var statearr_29156 = [null,null,null,null,null,null,null,null,null];
(statearr_29156[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__);

(statearr_29156[(1)] = (1));

return statearr_29156;
});
var fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____1 = (function (state_29139){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29139);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29157){var ex__11413__auto__ = e29157;
var statearr_29158_29170 = state_29139;
(statearr_29158_29170[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29139[(4)]))){
var statearr_29159_29171 = state_29139;
(statearr_29159_29171[(1)] = cljs.core.first((state_29139[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29172 = state_29139;
state_29139 = G__29172;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__ = function(state_29139){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____1.call(this,state_29139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29160 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29160[(6)] = c__11484__auto__);

return statearr_29160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29194){
var state_val_29195 = (state_29194[(1)]);
if((state_val_29195 === (7))){
var inst_29183 = (state_29194[(7)]);
var inst_29185 = fluree.db.storage.core.serde(conn);
var inst_29186 = fluree.db.serde.protocol._deserialize_db_root(inst_29185,inst_29183);
var state_29194__$1 = state_29194;
var statearr_29196_29215 = state_29194__$1;
(statearr_29196_29215[(2)] = inst_29186);

(statearr_29196_29215[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (1))){
var state_29194__$1 = state_29194;
var statearr_29197_29216 = state_29194__$1;
(statearr_29197_29216[(2)] = null);

(statearr_29197_29216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (4))){
var inst_29173 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
var statearr_29198_29217 = state_29194__$1;
(statearr_29198_29217[(2)] = inst_29173);

(statearr_29198_29217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (6))){
var inst_29183 = (state_29194[(7)]);
var inst_29182 = (state_29194[(2)]);
var inst_29183__$1 = fluree.db.util.async.throw_err(inst_29182);
var state_29194__$1 = (function (){var statearr_29199 = state_29194;
(statearr_29199[(7)] = inst_29183__$1);

return statearr_29199;
})();
if(cljs.core.truth_(inst_29183__$1)){
var statearr_29200_29218 = state_29194__$1;
(statearr_29200_29218[(1)] = (7));

} else {
var statearr_29201_29219 = state_29194__$1;
(statearr_29201_29219[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (3))){
var inst_29192 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29194__$1,inst_29192);
} else {
if((state_val_29195 === (2))){
var _ = (function (){var statearr_29203 = state_29194;
(statearr_29203[(4)] = cljs.core.cons((5),(state_29194[(4)])));

return statearr_29203;
})();
var inst_29179 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_29180 = fluree.db.storage.core.storage_read(conn,inst_29179);
var state_29194__$1 = state_29194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29194__$1,(6),inst_29180);
} else {
if((state_val_29195 === (9))){
var inst_29189 = (state_29194[(2)]);
var _ = (function (){var statearr_29204 = state_29194;
(statearr_29204[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29204;
})();
var state_29194__$1 = state_29194;
var statearr_29205_29220 = state_29194__$1;
(statearr_29205_29220[(2)] = inst_29189);

(statearr_29205_29220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (5))){
var _ = (function (){var statearr_29206 = state_29194;
(statearr_29206[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29206;
})();
var state_29194__$1 = state_29194;
var ex29202 = (state_29194__$1[(2)]);
var statearr_29207_29221 = state_29194__$1;
(statearr_29207_29221[(5)] = ex29202);


if((ex29202 instanceof Error)){
var statearr_29208_29222 = state_29194__$1;
(statearr_29208_29222[(1)] = (4));

(statearr_29208_29222[(5)] = null);

} else {
throw ex29202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (8))){
var state_29194__$1 = state_29194;
var statearr_29209_29223 = state_29194__$1;
(statearr_29209_29223[(2)] = null);

(statearr_29209_29223[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____0 = (function (){
var statearr_29210 = [null,null,null,null,null,null,null,null];
(statearr_29210[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__);

(statearr_29210[(1)] = (1));

return statearr_29210;
});
var fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____1 = (function (state_29194){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29194);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29211){var ex__11413__auto__ = e29211;
var statearr_29212_29224 = state_29194;
(statearr_29212_29224[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29194[(4)]))){
var statearr_29213_29225 = state_29194;
(statearr_29213_29225[(1)] = cljs.core.first((state_29194[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29226 = state_29194;
state_29194 = G__29226;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__ = function(state_29194){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____1.call(this,state_29194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__11410__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29214 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29214[(6)] = c__11484__auto__);

return statearr_29214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29262){
var state_val_29263 = (state_29262[(1)]);
if((state_val_29263 === (7))){
var inst_29236 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_29237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29238 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_29239 = cljs.core.PersistentHashMap.fromArrays(inst_29237,inst_29238);
var inst_29240 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29236,inst_29239);
var inst_29241 = (function(){throw inst_29240})();
var state_29262__$1 = state_29262;
var statearr_29264_29286 = state_29262__$1;
(statearr_29264_29286[(2)] = inst_29241);

(statearr_29264_29286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (1))){
var state_29262__$1 = state_29262;
var statearr_29265_29287 = state_29262__$1;
(statearr_29265_29287[(2)] = null);

(statearr_29265_29287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (4))){
var inst_29227 = (state_29262[(2)]);
var state_29262__$1 = state_29262;
var statearr_29266_29288 = state_29262__$1;
(statearr_29266_29288[(2)] = inst_29227);

(statearr_29266_29288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (6))){
var state_29262__$1 = state_29262;
var statearr_29267_29289 = state_29262__$1;
(statearr_29267_29289[(2)] = null);

(statearr_29267_29289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (3))){
var inst_29260 = (state_29262[(2)]);
var state_29262__$1 = state_29262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29262__$1,inst_29260);
} else {
if((state_val_29263 === (2))){
var inst_29233 = (state_29262[(7)]);
var _ = (function (){var statearr_29268 = state_29262;
(statearr_29268[(4)] = cljs.core.cons((5),(state_29262[(4)])));

return statearr_29268;
})();
var inst_29233__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_29262__$1 = (function (){var statearr_29269 = state_29262;
(statearr_29269[(7)] = inst_29233__$1);

return statearr_29269;
})();
if(cljs.core.truth_(inst_29233__$1)){
var statearr_29270_29290 = state_29262__$1;
(statearr_29270_29290[(1)] = (6));

} else {
var statearr_29271_29291 = state_29262__$1;
(statearr_29271_29291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (11))){
var inst_29252 = (state_29262[(8)]);
var inst_29255 = (state_29262[(2)]);
var inst_29256 = fluree.db.util.async.throw_err(inst_29255);
var inst_29257 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29252,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_29256);
var _ = (function (){var statearr_29273 = state_29262;
(statearr_29273[(4)] = cljs.core.rest((state_29262[(4)])));

return statearr_29273;
})();
var state_29262__$1 = state_29262;
var statearr_29274_29292 = state_29262__$1;
(statearr_29274_29292[(2)] = inst_29257);

(statearr_29274_29292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (9))){
var inst_29247 = (state_29262[(9)]);
var inst_29245 = (state_29262[(2)]);
var inst_29246 = fluree.db.util.async.throw_err(inst_29245);
var inst_29247__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_29246);
var inst_29248 = fluree.db.query.schema.schema_map(inst_29247__$1);
var state_29262__$1 = (function (){var statearr_29275 = state_29262;
(statearr_29275[(9)] = inst_29247__$1);

return statearr_29275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29262__$1,(10),inst_29248);
} else {
if((state_val_29263 === (5))){
var _ = (function (){var statearr_29276 = state_29262;
(statearr_29276[(4)] = cljs.core.rest((state_29262[(4)])));

return statearr_29276;
})();
var state_29262__$1 = state_29262;
var ex29272 = (state_29262__$1[(2)]);
var statearr_29277_29293 = state_29262__$1;
(statearr_29277_29293[(5)] = ex29272);


if((ex29272 instanceof Error)){
var statearr_29278_29294 = state_29262__$1;
(statearr_29278_29294[(1)] = (4));

(statearr_29278_29294[(5)] = null);

} else {
throw ex29272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29263 === (10))){
var inst_29247 = (state_29262[(9)]);
var inst_29252 = (state_29262[(8)]);
var inst_29250 = (state_29262[(2)]);
var inst_29251 = fluree.db.util.async.throw_err(inst_29250);
var inst_29252__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29247,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_29251);
var inst_29253 = fluree.db.query.schema.setting_map(inst_29252__$1);
var state_29262__$1 = (function (){var statearr_29279 = state_29262;
(statearr_29279[(8)] = inst_29252__$1);

return statearr_29279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29262__$1,(11),inst_29253);
} else {
if((state_val_29263 === (8))){
var inst_29233 = (state_29262[(7)]);
var inst_29243 = (state_29262[(2)]);
var state_29262__$1 = (function (){var statearr_29280 = state_29262;
(statearr_29280[(10)] = inst_29243);

return statearr_29280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29262__$1,(9),inst_29233);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__11410__auto____0 = (function (){
var statearr_29281 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29281[(0)] = fluree$db$storage$core$reify_db_$_state_machine__11410__auto__);

(statearr_29281[(1)] = (1));

return statearr_29281;
});
var fluree$db$storage$core$reify_db_$_state_machine__11410__auto____1 = (function (state_29262){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29262);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29282){var ex__11413__auto__ = e29282;
var statearr_29283_29295 = state_29262;
(statearr_29283_29295[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29262[(4)]))){
var statearr_29284_29296 = state_29262;
(statearr_29284_29296[(1)] = cljs.core.first((state_29262[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29297 = state_29262;
state_29262 = G__29297;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__11410__auto__ = function(state_29262){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__11410__auto____1.call(this,state_29262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__11410__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__11410__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29285 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29285[(6)] = c__11484__auto__);

return statearr_29285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__29299 = arguments.length;
switch (G__29299) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29352){
var state_val_29353 = (state_29352[(1)]);
if((state_val_29353 === (7))){
var inst_29309 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_29310 = (new Error(inst_29309));
var inst_29311 = (function(){throw inst_29310})();
var state_29352__$1 = state_29352;
var statearr_29354_29394 = state_29352__$1;
(statearr_29354_29394[(2)] = inst_29311);

(statearr_29354_29394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (20))){
var inst_29343 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
var statearr_29355_29395 = state_29352__$1;
(statearr_29355_29395[(2)] = inst_29343);

(statearr_29355_29395[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (1))){
var state_29352__$1 = state_29352;
var statearr_29356_29396 = state_29352__$1;
(statearr_29356_29396[(2)] = null);

(statearr_29356_29396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (4))){
var inst_29300 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
var statearr_29357_29397 = state_29352__$1;
(statearr_29357_29397[(2)] = inst_29300);

(statearr_29357_29397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (15))){
var inst_29318 = (state_29352[(7)]);
var state_29352__$1 = state_29352;
var statearr_29358_29398 = state_29352__$1;
(statearr_29358_29398[(2)] = inst_29318);

(statearr_29358_29398[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (21))){
var inst_29318 = (state_29352[(7)]);
var inst_29317 = (state_29352[(8)]);
var inst_29322 = (state_29352[(9)]);
var inst_29336 = (inst_29317 + (1));
var inst_29337 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29318,inst_29322);
var inst_29317__$1 = inst_29336;
var inst_29318__$1 = inst_29337;
var state_29352__$1 = (function (){var statearr_29359 = state_29352;
(statearr_29359[(7)] = inst_29318__$1);

(statearr_29359[(8)] = inst_29317__$1);

return statearr_29359;
})();
var statearr_29360_29399 = state_29352__$1;
(statearr_29360_29399[(2)] = null);

(statearr_29360_29399[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (13))){
var inst_29322 = (state_29352[(9)]);
var inst_29326 = (inst_29322 instanceof Error);
var state_29352__$1 = state_29352;
var statearr_29361_29400 = state_29352__$1;
(statearr_29361_29400[(2)] = inst_29326);

(statearr_29361_29400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (22))){
var state_29352__$1 = state_29352;
var statearr_29362_29401 = state_29352__$1;
(statearr_29362_29401[(2)] = null);

(statearr_29362_29401[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (6))){
var state_29352__$1 = state_29352;
var statearr_29363_29402 = state_29352__$1;
(statearr_29363_29402[(2)] = null);

(statearr_29363_29402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (17))){
var inst_29345 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
var statearr_29364_29403 = state_29352__$1;
(statearr_29364_29403[(2)] = inst_29345);

(statearr_29364_29403[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (3))){
var inst_29350 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29352__$1,inst_29350);
} else {
if((state_val_29353 === (12))){
var inst_29323 = (state_29352[(10)]);
var state_29352__$1 = state_29352;
var statearr_29365_29404 = state_29352__$1;
(statearr_29365_29404[(2)] = inst_29323);

(statearr_29365_29404[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (2))){
var _ = (function (){var statearr_29366 = state_29352;
(statearr_29366[(4)] = cljs.core.cons((5),(state_29352[(4)])));

return statearr_29366;
})();
var inst_29306 = (end >= start);
var state_29352__$1 = state_29352;
if(cljs.core.truth_(inst_29306)){
var statearr_29367_29405 = state_29352__$1;
(statearr_29367_29405[(1)] = (6));

} else {
var statearr_29368_29406 = state_29352__$1;
(statearr_29368_29406[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (23))){
var inst_29341 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
var statearr_29369_29407 = state_29352__$1;
(statearr_29369_29407[(2)] = inst_29341);

(statearr_29369_29407[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (19))){
var state_29352__$1 = state_29352;
var statearr_29370_29408 = state_29352__$1;
(statearr_29370_29408[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (11))){
var inst_29323 = (state_29352[(10)]);
var inst_29322 = (state_29352[(9)]);
var inst_29322__$1 = (state_29352[(2)]);
var inst_29323__$1 = (inst_29322__$1 == null);
var state_29352__$1 = (function (){var statearr_29373 = state_29352;
(statearr_29373[(10)] = inst_29323__$1);

(statearr_29373[(9)] = inst_29322__$1);

return statearr_29373;
})();
if(cljs.core.truth_(inst_29323__$1)){
var statearr_29374_29409 = state_29352__$1;
(statearr_29374_29409[(1)] = (12));

} else {
var statearr_29375_29410 = state_29352__$1;
(statearr_29375_29410[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (9))){
var inst_29317 = (state_29352[(8)]);
var inst_29320 = fluree.db.storage.core.read_block(conn,network,dbid,inst_29317);
var state_29352__$1 = state_29352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29352__$1,(11),inst_29320);
} else {
if((state_val_29353 === (5))){
var _ = (function (){var statearr_29376 = state_29352;
(statearr_29376[(4)] = cljs.core.rest((state_29352[(4)])));

return statearr_29376;
})();
var state_29352__$1 = state_29352;
var ex29372 = (state_29352__$1[(2)]);
var statearr_29377_29411 = state_29352__$1;
(statearr_29377_29411[(5)] = ex29372);


if((ex29372 instanceof Error)){
var statearr_29378_29412 = state_29352__$1;
(statearr_29378_29412[(1)] = (4));

(statearr_29378_29412[(5)] = null);

} else {
throw ex29372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (14))){
var inst_29328 = (state_29352[(2)]);
var state_29352__$1 = state_29352;
if(cljs.core.truth_(inst_29328)){
var statearr_29379_29413 = state_29352__$1;
(statearr_29379_29413[(1)] = (15));

} else {
var statearr_29380_29414 = state_29352__$1;
(statearr_29380_29414[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (16))){
var inst_29317 = (state_29352[(8)]);
var inst_29331 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29317,end);
var state_29352__$1 = state_29352;
if(inst_29331){
var statearr_29381_29415 = state_29352__$1;
(statearr_29381_29415[(1)] = (18));

} else {
var statearr_29382_29416 = state_29352__$1;
(statearr_29382_29416[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (10))){
var inst_29347 = (state_29352[(2)]);
var _ = (function (){var statearr_29383 = state_29352;
(statearr_29383[(4)] = cljs.core.rest((state_29352[(4)])));

return statearr_29383;
})();
var state_29352__$1 = state_29352;
var statearr_29384_29417 = state_29352__$1;
(statearr_29384_29417[(2)] = inst_29347);

(statearr_29384_29417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (18))){
var inst_29318 = (state_29352[(7)]);
var inst_29322 = (state_29352[(9)]);
var inst_29333 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29318,inst_29322);
var state_29352__$1 = state_29352;
var statearr_29385_29418 = state_29352__$1;
(statearr_29385_29418[(2)] = inst_29333);

(statearr_29385_29418[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29353 === (8))){
var inst_29313 = (state_29352[(2)]);
var inst_29314 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29315 = start;
var inst_29316 = cljs.core.PersistentVector.EMPTY;
var inst_29317 = inst_29315;
var inst_29318 = inst_29316;
var state_29352__$1 = (function (){var statearr_29386 = state_29352;
(statearr_29386[(11)] = inst_29314);

(statearr_29386[(12)] = inst_29313);

(statearr_29386[(7)] = inst_29318);

(statearr_29386[(8)] = inst_29317);

return statearr_29386;
})();
var statearr_29387_29419 = state_29352__$1;
(statearr_29387_29419[(2)] = null);

(statearr_29387_29419[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__11410__auto__ = null;
var fluree$db$storage$core$state_machine__11410__auto____0 = (function (){
var statearr_29388 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29388[(0)] = fluree$db$storage$core$state_machine__11410__auto__);

(statearr_29388[(1)] = (1));

return statearr_29388;
});
var fluree$db$storage$core$state_machine__11410__auto____1 = (function (state_29352){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29352);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29389){var ex__11413__auto__ = e29389;
var statearr_29390_29420 = state_29352;
(statearr_29390_29420[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29352[(4)]))){
var statearr_29391_29421 = state_29352;
(statearr_29391_29421[(1)] = cljs.core.first((state_29352[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29422 = state_29352;
state_29352 = G__29422;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__11410__auto__ = function(state_29352){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__11410__auto____1.call(this,state_29352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__11410__auto____0;
fluree$db$storage$core$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__11410__auto____1;
return fluree$db$storage$core$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29392 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29392[(6)] = c__11484__auto__);

return statearr_29392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_29438){
var state_val_29439 = (state_29438[(1)]);
if((state_val_29439 === (1))){
var state_29438__$1 = state_29438;
var statearr_29440_29454 = state_29438__$1;
(statearr_29440_29454[(2)] = null);

(statearr_29440_29454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (2))){
var _ = (function (){var statearr_29441 = state_29438;
(statearr_29441[(4)] = cljs.core.cons((5),(state_29438[(4)])));

return statearr_29441;
})();
var inst_29429 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29438__$1,(6),inst_29429);
} else {
if((state_val_29439 === (3))){
var inst_29436 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29438__$1,inst_29436);
} else {
if((state_val_29439 === (4))){
var inst_29423 = (state_29438[(2)]);
var state_29438__$1 = state_29438;
var statearr_29443_29455 = state_29438__$1;
(statearr_29443_29455[(2)] = inst_29423);

(statearr_29443_29455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (5))){
var _ = (function (){var statearr_29444 = state_29438;
(statearr_29444[(4)] = cljs.core.rest((state_29438[(4)])));

return statearr_29444;
})();
var state_29438__$1 = state_29438;
var ex29442 = (state_29438__$1[(2)]);
var statearr_29445_29456 = state_29438__$1;
(statearr_29445_29456[(5)] = ex29442);


if((ex29442 instanceof Error)){
var statearr_29446_29457 = state_29438__$1;
(statearr_29446_29457[(1)] = (4));

(statearr_29446_29457[(5)] = null);

} else {
throw ex29442;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29439 === (6))){
var inst_29431 = (state_29438[(2)]);
var inst_29432 = fluree.db.util.async.throw_err(inst_29431);
var inst_29433 = cljs.core.first(inst_29432);
var _ = (function (){var statearr_29447 = state_29438;
(statearr_29447[(4)] = cljs.core.rest((state_29438[(4)])));

return statearr_29447;
})();
var state_29438__$1 = state_29438;
var statearr_29448_29458 = state_29438__$1;
(statearr_29448_29458[(2)] = inst_29433);

(statearr_29448_29458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__11410__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__11410__auto____0 = (function (){
var statearr_29449 = [null,null,null,null,null,null,null];
(statearr_29449[(0)] = fluree$db$storage$core$block_$_state_machine__11410__auto__);

(statearr_29449[(1)] = (1));

return statearr_29449;
});
var fluree$db$storage$core$block_$_state_machine__11410__auto____1 = (function (state_29438){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_29438);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e29450){var ex__11413__auto__ = e29450;
var statearr_29451_29459 = state_29438;
(statearr_29451_29459[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_29438[(4)]))){
var statearr_29452_29460 = state_29438;
(statearr_29452_29460[(1)] = cljs.core.first((state_29438[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29461 = state_29438;
state_29438 = G__29461;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__11410__auto__ = function(state_29438){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__11410__auto____1.call(this,state_29438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__11410__auto____0;
fluree$db$storage$core$block_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__11410__auto____1;
return fluree$db$storage$core$block_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_29453 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_29453[(6)] = c__11484__auto__);

return statearr_29453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
