// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_23599){
var state_val_23600 = (state_23599[(1)]);
if((state_val_23600 === (7))){
var inst_23594 = (state_23599[(2)]);
var _ = (function (){var statearr_23601 = state_23599;
(statearr_23601[(4)] = cljs.core.rest((state_23599[(4)])));

return statearr_23601;
})();
var state_23599__$1 = state_23599;
var statearr_23602_23624 = state_23599__$1;
(statearr_23602_23624[(2)] = inst_23594);

(statearr_23602_23624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (1))){
var state_23599__$1 = state_23599;
var statearr_23603_23625 = state_23599__$1;
(statearr_23603_23625[(2)] = null);

(statearr_23603_23625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (4))){
var inst_23556 = (state_23599[(2)]);
var state_23599__$1 = state_23599;
var statearr_23604_23626 = state_23599__$1;
(statearr_23604_23626[(2)] = inst_23556);

(statearr_23604_23626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (6))){
var inst_23581 = (state_23599[(7)]);
var inst_23574 = (state_23599[(8)]);
var inst_23580 = cljs.core.seq(inst_23574);
var inst_23581__$1 = cljs.core.first(inst_23580);
var inst_23582 = cljs.core.next(inst_23580);
var inst_23583 = cljs.core.not(inst_23581__$1);
var state_23599__$1 = (function (){var statearr_23605 = state_23599;
(statearr_23605[(7)] = inst_23581__$1);

(statearr_23605[(9)] = inst_23582);

return statearr_23605;
})();
if(inst_23583){
var statearr_23606_23627 = state_23599__$1;
(statearr_23606_23627[(1)] = (8));

} else {
var statearr_23607_23628 = state_23599__$1;
(statearr_23607_23628[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (3))){
var inst_23597 = (state_23599[(2)]);
var state_23599__$1 = state_23599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23599__$1,inst_23597);
} else {
if((state_val_23600 === (2))){
var _ = (function (){var statearr_23608 = state_23599;
(statearr_23608[(4)] = cljs.core.cons((5),(state_23599[(4)])));

return statearr_23608;
})();
var inst_23569 = chs;
var inst_23570 = cljs.core.seq(inst_23569);
var inst_23571 = cljs.core.first(inst_23570);
var inst_23572 = cljs.core.next(inst_23570);
var inst_23573 = coll;
var inst_23574 = inst_23569;
var inst_23575 = inst_23573;
var state_23599__$1 = (function (){var statearr_23609 = state_23599;
(statearr_23609[(10)] = inst_23571);

(statearr_23609[(8)] = inst_23574);

(statearr_23609[(11)] = inst_23575);

(statearr_23609[(12)] = inst_23572);

return statearr_23609;
})();
var statearr_23610_23629 = state_23599__$1;
(statearr_23610_23629[(2)] = null);

(statearr_23610_23629[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (11))){
var inst_23582 = (state_23599[(9)]);
var inst_23575 = (state_23599[(11)]);
var inst_23587 = (state_23599[(2)]);
var inst_23588 = fluree.db.util.async.throw_err(inst_23587);
var inst_23589 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23575,inst_23588);
var inst_23574 = inst_23582;
var inst_23575__$1 = inst_23589;
var state_23599__$1 = (function (){var statearr_23612 = state_23599;
(statearr_23612[(8)] = inst_23574);

(statearr_23612[(11)] = inst_23575__$1);

return statearr_23612;
})();
var statearr_23613_23630 = state_23599__$1;
(statearr_23613_23630[(2)] = null);

(statearr_23613_23630[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (9))){
var inst_23581 = (state_23599[(7)]);
var state_23599__$1 = state_23599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23599__$1,(11),inst_23581);
} else {
if((state_val_23600 === (5))){
var _ = (function (){var statearr_23614 = state_23599;
(statearr_23614[(4)] = cljs.core.rest((state_23599[(4)])));

return statearr_23614;
})();
var state_23599__$1 = state_23599;
var ex23611 = (state_23599__$1[(2)]);
var statearr_23615_23631 = state_23599__$1;
(statearr_23615_23631[(5)] = ex23611);


var statearr_23616_23632 = state_23599__$1;
(statearr_23616_23632[(1)] = (4));

(statearr_23616_23632[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (10))){
var inst_23592 = (state_23599[(2)]);
var state_23599__$1 = state_23599;
var statearr_23617_23633 = state_23599__$1;
(statearr_23617_23633[(2)] = inst_23592);

(statearr_23617_23633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23600 === (8))){
var inst_23575 = (state_23599[(11)]);
var state_23599__$1 = state_23599;
var statearr_23618_23634 = state_23599__$1;
(statearr_23618_23634[(2)] = inst_23575);

(statearr_23618_23634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_23619 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23619[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__);

(statearr_23619[(1)] = (1));

return statearr_23619;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____1 = (function (state_23599){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_23599);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e23620){var ex__11413__auto__ = e23620;
var statearr_23621_23635 = state_23599;
(statearr_23621_23635[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_23599[(4)]))){
var statearr_23622_23636 = state_23599;
(statearr_23622_23636[(1)] = cljs.core.first((state_23599[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23637 = state_23599;
state_23599 = G__23637;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__ = function(state_23599){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____1.call(this,state_23599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_23623 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_23623[(6)] = c__11484__auto__);

return statearr_23623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_23663){
var state_val_23664 = (state_23663[(1)]);
if((state_val_23664 === (7))){
var inst_23658 = (state_23663[(2)]);
var _ = (function (){var statearr_23665 = state_23663;
(statearr_23665[(4)] = cljs.core.rest((state_23663[(4)])));

return statearr_23665;
})();
var state_23663__$1 = state_23663;
var statearr_23666_23688 = state_23663__$1;
(statearr_23666_23688[(2)] = inst_23658);

(statearr_23666_23688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (1))){
var state_23663__$1 = state_23663;
var statearr_23667_23689 = state_23663__$1;
(statearr_23667_23689[(2)] = null);

(statearr_23667_23689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (4))){
var inst_23638 = (state_23663[(2)]);
var state_23663__$1 = state_23663;
var statearr_23668_23690 = state_23663__$1;
(statearr_23668_23690[(2)] = inst_23638);

(statearr_23668_23690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (6))){
var state_23663__$1 = state_23663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23663__$1,(8),chan);
} else {
if((state_val_23664 === (3))){
var inst_23661 = (state_23663[(2)]);
var state_23663__$1 = state_23663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23663__$1,inst_23661);
} else {
if((state_val_23664 === (2))){
var _ = (function (){var statearr_23669 = state_23663;
(statearr_23669[(4)] = cljs.core.cons((5),(state_23663[(4)])));

return statearr_23669;
})();
var inst_23644 = coll;
var inst_23645 = inst_23644;
var state_23663__$1 = (function (){var statearr_23670 = state_23663;
(statearr_23670[(7)] = inst_23645);

return statearr_23670;
})();
var statearr_23671_23691 = state_23663__$1;
(statearr_23671_23691[(2)] = null);

(statearr_23671_23691[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (11))){
var inst_23656 = (state_23663[(2)]);
var state_23663__$1 = state_23663;
var statearr_23673_23692 = state_23663__$1;
(statearr_23673_23692[(2)] = inst_23656);

(statearr_23673_23692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (9))){
var inst_23645 = (state_23663[(7)]);
var state_23663__$1 = state_23663;
var statearr_23674_23693 = state_23663__$1;
(statearr_23674_23693[(2)] = inst_23645);

(statearr_23674_23693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (5))){
var _ = (function (){var statearr_23675 = state_23663;
(statearr_23675[(4)] = cljs.core.rest((state_23663[(4)])));

return statearr_23675;
})();
var state_23663__$1 = state_23663;
var ex23672 = (state_23663__$1[(2)]);
var statearr_23676_23694 = state_23663__$1;
(statearr_23676_23694[(5)] = ex23672);


var statearr_23677_23695 = state_23663__$1;
(statearr_23677_23695[(1)] = (4));

(statearr_23677_23695[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (10))){
var inst_23645 = (state_23663[(7)]);
var inst_23649 = (state_23663[(8)]);
var inst_23653 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23645,inst_23649);
var inst_23645__$1 = inst_23653;
var state_23663__$1 = (function (){var statearr_23678 = state_23663;
(statearr_23678[(7)] = inst_23645__$1);

return statearr_23678;
})();
var statearr_23679_23696 = state_23663__$1;
(statearr_23679_23696[(2)] = null);

(statearr_23679_23696[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23664 === (8))){
var inst_23649 = (state_23663[(8)]);
var inst_23648 = (state_23663[(2)]);
var inst_23649__$1 = fluree.db.util.async.throw_err(inst_23648);
var inst_23650 = (inst_23649__$1 == null);
var state_23663__$1 = (function (){var statearr_23680 = state_23663;
(statearr_23680[(8)] = inst_23649__$1);

return statearr_23680;
})();
if(cljs.core.truth_(inst_23650)){
var statearr_23681_23697 = state_23663__$1;
(statearr_23681_23697[(1)] = (9));

} else {
var statearr_23682_23698 = state_23663__$1;
(statearr_23682_23698[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_23683 = [null,null,null,null,null,null,null,null,null];
(statearr_23683[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__);

(statearr_23683[(1)] = (1));

return statearr_23683;
});
var fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____1 = (function (state_23663){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_23663);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e23684){var ex__11413__auto__ = e23684;
var statearr_23685_23699 = state_23663;
(statearr_23685_23699[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_23663[(4)]))){
var statearr_23686_23700 = state_23663;
(statearr_23686_23700[(1)] = cljs.core.first((state_23663[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23701 = state_23663;
state_23663 = G__23701;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__ = function(state_23663){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____1.call(this,state_23663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__11410__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_23687 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_23687[(6)] = c__11484__auto__);

return statearr_23687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
