// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__30544 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30544,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__30544;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__30545 = opts;
var map__30545__$1 = cljs.core.__destructure_map(map__30545);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30545__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30545__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30545__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__30546 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__30546__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__30546,headers], 0)):G__30546);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30546__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30546__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__30547 = opts;
var map__30547__$1 = cljs.core.__destructure_map(map__30547);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30547__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30547__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30547__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30547__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30547__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__30548 = cljs.core.PersistentArrayMap.EMPTY;
var G__30548__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__30548,headers], 0)):G__30548);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30548__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30548__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__30549 = output_format;
var G__30549__$1 = (((G__30549 instanceof cljs.core.Keyword))?G__30549.fqn:null);
switch (G__30549__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__30551 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30551,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__30551;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30583){
var state_val_30584 = (state_30583[(1)]);
if((state_val_30584 === (7))){
var inst_30579 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
var statearr_30585_30610 = state_30583__$1;
(statearr_30585_30610[(2)] = inst_30579);

(statearr_30585_30610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (1))){
var state_30583__$1 = state_30583;
var statearr_30586_30611 = state_30583__$1;
(statearr_30586_30611[(2)] = null);

(statearr_30586_30611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (4))){
var inst_30554 = (state_30583[(7)]);
var inst_30554__$1 = (state_30583[(2)]);
var inst_30555 = (inst_30554__$1 == null);
var state_30583__$1 = (function (){var statearr_30587 = state_30583;
(statearr_30587[(7)] = inst_30554__$1);

return statearr_30587;
})();
if(cljs.core.truth_(inst_30555)){
var statearr_30588_30612 = state_30583__$1;
(statearr_30588_30612[(1)] = (5));

} else {
var statearr_30589_30613 = state_30583__$1;
(statearr_30589_30613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (6))){
var inst_30554 = (state_30583[(7)]);
var inst_30562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30554,(0),null);
var inst_30563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30554,(1),null);
var state_30583__$1 = (function (){var statearr_30590 = state_30583;
(statearr_30590[(8)] = inst_30563);

(statearr_30590[(9)] = inst_30562);

return statearr_30590;
})();
var statearr_30591_30614 = state_30583__$1;
(statearr_30591_30614[(2)] = null);

(statearr_30591_30614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (3))){
var inst_30581 = (state_30583[(2)]);
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30583__$1,inst_30581);
} else {
if((state_val_30584 === (2))){
var state_30583__$1 = state_30583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30583__$1,(4),pub_chan);
} else {
if((state_val_30584 === (11))){
var _ = (function (){var statearr_30593 = state_30583;
(statearr_30593[(4)] = cljs.core.rest((state_30583[(4)])));

return statearr_30593;
})();
var state_30583__$1 = state_30583;
var ex30592 = (state_30583__$1[(2)]);
var statearr_30594_30615 = state_30583__$1;
(statearr_30594_30615[(5)] = ex30592);


var statearr_30595_30616 = state_30583__$1;
(statearr_30595_30616[(1)] = (10));

(statearr_30595_30616[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (9))){
var inst_30576 = (state_30583[(2)]);
var state_30583__$1 = (function (){var statearr_30596 = state_30583;
(statearr_30596[(10)] = inst_30576);

return statearr_30596;
})();
var statearr_30597_30617 = state_30583__$1;
(statearr_30597_30617[(2)] = null);

(statearr_30597_30617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (5))){
var inst_30557 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_30583__$1 = state_30583;
var statearr_30598_30618 = state_30583__$1;
(statearr_30598_30618[(2)] = inst_30557);

(statearr_30598_30618[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (10))){
var inst_30563 = (state_30583[(8)]);
var inst_30562 = (state_30583[(9)]);
var inst_30564 = (state_30583[(2)]);
var inst_30565 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_30564,"Error sending websocket message:",inst_30562], 0));
var inst_30566 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30563,false);
var state_30583__$1 = (function (){var statearr_30599 = state_30583;
(statearr_30599[(11)] = inst_30565);

return statearr_30599;
})();
var statearr_30600_30619 = state_30583__$1;
(statearr_30600_30619[(2)] = inst_30566);

(statearr_30600_30619[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30584 === (8))){
var inst_30563 = (state_30583[(8)]);
var inst_30562 = (state_30583[(9)]);
var _ = (function (){var statearr_30601 = state_30583;
(statearr_30601[(4)] = cljs.core.cons((11),(state_30583[(4)])));

return statearr_30601;
})();
var inst_30572 = ws.send(inst_30562);
var inst_30573 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30563,true);
var ___$1 = (function (){var statearr_30602 = state_30583;
(statearr_30602[(4)] = cljs.core.rest((state_30583[(4)])));

return statearr_30602;
})();
var state_30583__$1 = (function (){var statearr_30603 = state_30583;
(statearr_30603[(12)] = inst_30572);

return statearr_30603;
})();
var statearr_30604_30620 = state_30583__$1;
(statearr_30604_30620[(2)] = inst_30573);

(statearr_30604_30620[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____0 = (function (){
var statearr_30605 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30605[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__);

(statearr_30605[(1)] = (1));

return statearr_30605;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____1 = (function (state_30583){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30583);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e30606){var ex__11413__auto__ = e30606;
var statearr_30607_30621 = state_30583;
(statearr_30607_30621[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30583[(4)]))){
var statearr_30608_30622 = state_30583;
(statearr_30608_30622[(1)] = cljs.core.first((state_30583[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30623 = state_30583;
state_30583 = G__30623;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__ = function(state_30583){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____1.call(this,state_30583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_30609 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_30609[(6)] = c__11484__auto__);

return statearr_30609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__11484__auto___30661 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30648){
var state_val_30649 = (state_30648[(1)]);
if((state_val_30649 === (1))){
var inst_30627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30628 = [open_QMARK_,timeout_chan];
var inst_30629 = (new cljs.core.PersistentVector(null,2,(5),inst_30627,inst_30628,null));
var state_30648__$1 = state_30648;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_30648__$1,(2),inst_30629,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_30649 === (2))){
var inst_30631 = (state_30648[(2)]);
var inst_30632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30631,(0),null);
var inst_30633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30631,(1),null);
var inst_30634 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30633,timeout_chan);
var state_30648__$1 = (function (){var statearr_30650 = state_30648;
(statearr_30650[(7)] = inst_30632);

return statearr_30650;
})();
if(inst_30634){
var statearr_30651_30662 = state_30648__$1;
(statearr_30651_30662[(1)] = (3));

} else {
var statearr_30652_30663 = state_30648__$1;
(statearr_30652_30663[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (3))){
var inst_30636 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_30637 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30638 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_30639 = cljs.core.PersistentHashMap.fromArrays(inst_30637,inst_30638);
var inst_30640 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30636,inst_30639);
var inst_30641 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_30640);
var inst_30642 = fluree.db.util.xhttp.close_websocket(ws);
var state_30648__$1 = (function (){var statearr_30653 = state_30648;
(statearr_30653[(8)] = inst_30641);

return statearr_30653;
})();
var statearr_30654_30664 = state_30648__$1;
(statearr_30654_30664[(2)] = inst_30642);

(statearr_30654_30664[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (4))){
var inst_30644 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_30648__$1 = state_30648;
var statearr_30655_30665 = state_30648__$1;
(statearr_30655_30665[(2)] = inst_30644);

(statearr_30655_30665[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (5))){
var inst_30646 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30648__$1,inst_30646);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____0 = (function (){
var statearr_30656 = [null,null,null,null,null,null,null,null,null];
(statearr_30656[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__);

(statearr_30656[(1)] = (1));

return statearr_30656;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____1 = (function (state_30648){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30648);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e30657){var ex__11413__auto__ = e30657;
var statearr_30658_30666 = state_30648;
(statearr_30658_30666[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30648[(4)]))){
var statearr_30659_30667 = state_30648;
(statearr_30659_30667[(1)] = cljs.core.first((state_30648[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30668 = state_30648;
state_30648 = G__30668;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__ = function(state_30648){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____1.call(this,state_30648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_30660 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_30660[(6)] = c__11484__auto___30661);

return statearr_30660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
