// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__78185 = opts_SINGLEQUOTE_;
var map__78185__$1 = cljs.core.__destructure_map(map__78185);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78185__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__78187 = arguments.length;
switch (G__78187) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__78190 = arguments.length;
switch (G__78190) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__78193 = arguments.length;
switch (G__78193) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__78196 = arguments.length;
switch (G__78196) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__78199 = arguments.length;
switch (G__78199) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__78202 = arguments.length;
switch (G__78202) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___78211 = arguments.length;
var i__4865__auto___78212 = (0);
while(true){
if((i__4865__auto___78212 < len__4864__auto___78211)){
args__4870__auto__.push((arguments[i__4865__auto___78212]));

var G__78213 = (i__4865__auto___78212 + (1));
i__4865__auto___78212 = G__78213;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__78207){
var vec__78208 = p__78207;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78208,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq78204){
var G__78205 = cljs.core.first(seq78204);
var seq78204__$1 = cljs.core.next(seq78204);
var G__78206 = cljs.core.first(seq78204__$1);
var seq78204__$2 = cljs.core.next(seq78204__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__78205,G__78206,seq78204__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78232){
var state_val_78233 = (state_78232[(1)]);
if((state_val_78233 === (1))){
var state_78232__$1 = state_78232;
var statearr_78234_78249 = state_78232__$1;
(statearr_78234_78249[(2)] = null);

(statearr_78234_78249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78233 === (2))){
var _ = (function (){var statearr_78235 = state_78232;
(statearr_78235[(4)] = cljs.core.cons((5),(state_78232[(4)])));

return statearr_78235;
})();
var state_78232__$1 = state_78232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78232__$1,(6),db);
} else {
if((state_val_78233 === (3))){
var inst_78230 = (state_78232[(2)]);
var state_78232__$1 = state_78232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78232__$1,inst_78230);
} else {
if((state_val_78233 === (4))){
var inst_78214 = (state_78232[(2)]);
var inst_78215 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78214], 0));
var inst_78216 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78214) : reject.call(null,inst_78214));
var state_78232__$1 = (function (){var statearr_78237 = state_78232;
(statearr_78237[(7)] = inst_78215);

return statearr_78237;
})();
var statearr_78238_78250 = state_78232__$1;
(statearr_78238_78250[(2)] = inst_78216);

(statearr_78238_78250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78233 === (5))){
var _ = (function (){var statearr_78239 = state_78232;
(statearr_78239[(4)] = cljs.core.rest((state_78232[(4)])));

return statearr_78239;
})();
var state_78232__$1 = state_78232;
var ex78236 = (state_78232__$1[(2)]);
var statearr_78240_78251 = state_78232__$1;
(statearr_78240_78251[(5)] = ex78236);


var statearr_78241_78252 = state_78232__$1;
(statearr_78241_78252[(1)] = (4));

(statearr_78241_78252[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78233 === (6))){
var inst_78223 = (state_78232[(2)]);
var inst_78224 = fluree.db.util.async.throw_err(inst_78223);
var inst_78225 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_78224);
var inst_78226 = cljs.core.clj__GT_js(inst_78225);
var inst_78227 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78226) : resolve.call(null,inst_78226));
var _ = (function (){var statearr_78242 = state_78232;
(statearr_78242[(4)] = cljs.core.rest((state_78232[(4)])));

return statearr_78242;
})();
var state_78232__$1 = state_78232;
var statearr_78243_78253 = state_78232__$1;
(statearr_78243_78253[(2)] = inst_78227);

(statearr_78243_78253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__11410__auto__ = null;
var flureedb$db_schema_$_state_machine__11410__auto____0 = (function (){
var statearr_78244 = [null,null,null,null,null,null,null,null];
(statearr_78244[(0)] = flureedb$db_schema_$_state_machine__11410__auto__);

(statearr_78244[(1)] = (1));

return statearr_78244;
});
var flureedb$db_schema_$_state_machine__11410__auto____1 = (function (state_78232){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78232);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78245){var ex__11413__auto__ = e78245;
var statearr_78246_78254 = state_78232;
(statearr_78246_78254[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78232[(4)]))){
var statearr_78247_78255 = state_78232;
(statearr_78247_78255[(1)] = cljs.core.first((state_78232[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78256 = state_78232;
state_78232 = G__78256;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__11410__auto__ = function(state_78232){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__11410__auto____1.call(this,state_78232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__11410__auto____0;
flureedb$db_schema_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__11410__auto____1;
return flureedb$db_schema_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78248 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78248[(6)] = c__11484__auto__);

return statearr_78248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__78258 = arguments.length;
switch (G__78258) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78328){
var state_val_78329 = (state_78328[(1)]);
if((state_val_78329 === (7))){
var inst_78271 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78328__$1 = state_78328;
var statearr_78330_78375 = state_78328__$1;
(statearr_78330_78375[(2)] = inst_78271);

(statearr_78330_78375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (20))){
var inst_78279 = (state_78328[(7)]);
var inst_78303 = (state_78328[(2)]);
var state_78328__$1 = (function (){var statearr_78331 = state_78328;
(statearr_78331[(8)] = inst_78303);

return statearr_78331;
})();
if(cljs.core.truth_(inst_78279)){
var statearr_78332_78376 = state_78328__$1;
(statearr_78332_78376[(1)] = (21));

} else {
var statearr_78333_78377 = state_78328__$1;
(statearr_78333_78377[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (1))){
var state_78328__$1 = state_78328;
var statearr_78334_78378 = state_78328__$1;
(statearr_78334_78378[(2)] = null);

(statearr_78334_78378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (24))){
var inst_78310 = (state_78328[(2)]);
var inst_78311 = fluree.db.util.async.throw_err(inst_78310);
var state_78328__$1 = state_78328;
var statearr_78335_78379 = state_78328__$1;
(statearr_78335_78379[(2)] = inst_78311);

(statearr_78335_78379[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (4))){
var inst_78259 = (state_78328[(2)]);
var inst_78260 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78259], 0));
var inst_78261 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78259) : reject.call(null,inst_78259));
var state_78328__$1 = (function (){var statearr_78336 = state_78328;
(statearr_78336[(9)] = inst_78260);

return statearr_78336;
})();
var statearr_78337_78380 = state_78328__$1;
(statearr_78337_78380[(2)] = inst_78261);

(statearr_78337_78380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (15))){
var inst_78292 = (state_78328[(10)]);
var inst_78294 = fluree.db.util.core.without_nils(inst_78292);
var inst_78295 = fluree.db.util.json.stringify(inst_78294);
var state_78328__$1 = state_78328;
var statearr_78338_78381 = state_78328__$1;
(statearr_78338_78381[(2)] = inst_78295);

(statearr_78338_78381[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (21))){
var inst_78298 = (state_78328[(11)]);
var inst_78303 = (state_78328[(8)]);
var inst_78305 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_78306 = [inst_78298,inst_78303];
var inst_78307 = cljs.core.PersistentHashMap.fromArrays(inst_78305,inst_78306);
var inst_78308 = fluree.db.operations.command_async(conn,inst_78307);
var state_78328__$1 = state_78328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78328__$1,(24),inst_78308);
} else {
if((state_val_78329 === (13))){
var inst_78280 = (state_78328[(12)]);
var inst_78287 = (inst_78280 + (30000));
var state_78328__$1 = state_78328;
var statearr_78339_78382 = state_78328__$1;
(statearr_78339_78382[(2)] = inst_78287);

(statearr_78339_78382[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (22))){
var inst_78292 = (state_78328[(10)]);
var inst_78313 = fluree.db.operations.unsigned_command_async(conn,inst_78292);
var state_78328__$1 = state_78328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78328__$1,(25),inst_78313);
} else {
if((state_val_78329 === (6))){
var state_78328__$1 = state_78328;
var statearr_78340_78383 = state_78328__$1;
(statearr_78340_78383[(2)] = null);

(statearr_78340_78383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (25))){
var inst_78315 = (state_78328[(2)]);
var inst_78316 = fluree.db.util.async.throw_err(inst_78315);
var state_78328__$1 = state_78328;
var statearr_78341_78384 = state_78328__$1;
(statearr_78341_78384[(2)] = inst_78316);

(statearr_78341_78384[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (17))){
var inst_78279 = (state_78328[(7)]);
var inst_78298 = (state_78328[(2)]);
var state_78328__$1 = (function (){var statearr_78342 = state_78328;
(statearr_78342[(11)] = inst_78298);

return statearr_78342;
})();
if(cljs.core.truth_(inst_78279)){
var statearr_78343_78385 = state_78328__$1;
(statearr_78343_78385[(1)] = (18));

} else {
var statearr_78344_78386 = state_78328__$1;
(statearr_78344_78386[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (3))){
var inst_78326 = (state_78328[(2)]);
var state_78328__$1 = state_78328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78328__$1,inst_78326);
} else {
if((state_val_78329 === (12))){
var inst_78277 = (state_78328[(13)]);
var state_78328__$1 = state_78328;
var statearr_78345_78387 = state_78328__$1;
(statearr_78345_78387[(2)] = inst_78277);

(statearr_78345_78387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (2))){
var _ = (function (){var statearr_78346 = state_78328;
(statearr_78346[(4)] = cljs.core.cons((5),(state_78328[(4)])));

return statearr_78346;
})();
var inst_78268 = (opts == null);
var state_78328__$1 = state_78328;
if(cljs.core.truth_(inst_78268)){
var statearr_78347_78388 = state_78328__$1;
(statearr_78347_78388[(1)] = (6));

} else {
var statearr_78348_78389 = state_78328__$1;
(statearr_78348_78389[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (23))){
var inst_78318 = (state_78328[(2)]);
var inst_78319 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_78320 = [(200),inst_78318];
var inst_78321 = cljs.core.PersistentHashMap.fromArrays(inst_78319,inst_78320);
var inst_78322 = cljs.core.clj__GT_js(inst_78321);
var inst_78323 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78322) : resolve.call(null,inst_78322));
var _ = (function (){var statearr_78349 = state_78328;
(statearr_78349[(4)] = cljs.core.rest((state_78328[(4)])));

return statearr_78349;
})();
var state_78328__$1 = state_78328;
var statearr_78350_78390 = state_78328__$1;
(statearr_78350_78390[(2)] = inst_78323);

(statearr_78350_78390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (19))){
var state_78328__$1 = state_78328;
var statearr_78351_78391 = state_78328__$1;
(statearr_78351_78391[(2)] = null);

(statearr_78351_78391[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (11))){
var inst_78277 = (state_78328[(13)]);
var inst_78284 = (state_78328[(2)]);
var state_78328__$1 = (function (){var statearr_78353 = state_78328;
(statearr_78353[(14)] = inst_78284);

return statearr_78353;
})();
if(cljs.core.truth_(inst_78277)){
var statearr_78354_78392 = state_78328__$1;
(statearr_78354_78392[(1)] = (12));

} else {
var statearr_78355_78393 = state_78328__$1;
(statearr_78355_78393[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (9))){
var inst_78276 = (state_78328[(15)]);
var state_78328__$1 = state_78328;
var statearr_78356_78394 = state_78328__$1;
(statearr_78356_78394[(2)] = inst_78276);

(statearr_78356_78394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (5))){
var _ = (function (){var statearr_78357 = state_78328;
(statearr_78357[(4)] = cljs.core.rest((state_78328[(4)])));

return statearr_78357;
})();
var state_78328__$1 = state_78328;
var ex78352 = (state_78328__$1[(2)]);
var statearr_78358_78395 = state_78328__$1;
(statearr_78358_78395[(5)] = ex78352);


var statearr_78359_78396 = state_78328__$1;
(statearr_78359_78396[(1)] = (4));

(statearr_78359_78396[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (14))){
var inst_78284 = (state_78328[(14)]);
var inst_78279 = (state_78328[(7)]);
var inst_78289 = (state_78328[(2)]);
var inst_78290 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_78291 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_78284,inst_78289];
var inst_78292 = cljs.core.PersistentHashMap.fromArrays(inst_78290,inst_78291);
var state_78328__$1 = (function (){var statearr_78360 = state_78328;
(statearr_78360[(10)] = inst_78292);

return statearr_78360;
})();
if(cljs.core.truth_(inst_78279)){
var statearr_78361_78397 = state_78328__$1;
(statearr_78361_78397[(1)] = (15));

} else {
var statearr_78362_78398 = state_78328__$1;
(statearr_78362_78398[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (16))){
var state_78328__$1 = state_78328;
var statearr_78363_78399 = state_78328__$1;
(statearr_78363_78399[(2)] = null);

(statearr_78363_78399[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (10))){
var inst_78280 = (state_78328[(12)]);
var state_78328__$1 = state_78328;
var statearr_78364_78400 = state_78328__$1;
(statearr_78364_78400[(2)] = inst_78280);

(statearr_78364_78400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (18))){
var inst_78298 = (state_78328[(11)]);
var inst_78279 = (state_78328[(7)]);
var inst_78300 = fluree.crypto.sign_message(inst_78298,inst_78279);
var state_78328__$1 = state_78328;
var statearr_78365_78401 = state_78328__$1;
(statearr_78365_78401[(2)] = inst_78300);

(statearr_78365_78401[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78329 === (8))){
var inst_78276 = (state_78328[(15)]);
var inst_78273 = (state_78328[(2)]);
var inst_78274 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78273);
var inst_78275 = cljs.core.__destructure_map(inst_78273);
var inst_78276__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78275,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_78277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78275,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_78278 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_78275,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_78279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78275,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_78280 = fluree.db.util.core.current_time_millis();
var state_78328__$1 = (function (){var statearr_78366 = state_78328;
(statearr_78366[(16)] = inst_78278);

(statearr_78366[(13)] = inst_78277);

(statearr_78366[(12)] = inst_78280);

(statearr_78366[(7)] = inst_78279);

(statearr_78366[(17)] = inst_78274);

(statearr_78366[(15)] = inst_78276__$1);

return statearr_78366;
})();
if(cljs.core.truth_(inst_78276__$1)){
var statearr_78367_78402 = state_78328__$1;
(statearr_78367_78402[(1)] = (9));

} else {
var statearr_78368_78403 = state_78328__$1;
(statearr_78368_78403[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_78369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78369[(0)] = flureedb$state_machine__11410__auto__);

(statearr_78369[(1)] = (1));

return statearr_78369;
});
var flureedb$state_machine__11410__auto____1 = (function (state_78328){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78328);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78370){var ex__11413__auto__ = e78370;
var statearr_78371_78404 = state_78328;
(statearr_78371_78404[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78328[(4)]))){
var statearr_78372_78405 = state_78328;
(statearr_78372_78405[(1)] = cljs.core.first((state_78328[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78406 = state_78328;
state_78328 = G__78406;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_78328){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_78328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78373 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78373[(6)] = c__11484__auto__);

return statearr_78373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78425){
var state_val_78426 = (state_78425[(1)]);
if((state_val_78426 === (1))){
var state_78425__$1 = state_78425;
var statearr_78427_78442 = state_78425__$1;
(statearr_78427_78442[(2)] = null);

(statearr_78427_78442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78426 === (2))){
var _ = (function (){var statearr_78428 = state_78425;
(statearr_78428[(4)] = cljs.core.cons((5),(state_78425[(4)])));

return statearr_78428;
})();
var inst_78415 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_78425__$1 = state_78425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78425__$1,(6),inst_78415);
} else {
if((state_val_78426 === (3))){
var inst_78423 = (state_78425[(2)]);
var state_78425__$1 = state_78425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78425__$1,inst_78423);
} else {
if((state_val_78426 === (4))){
var inst_78407 = (state_78425[(2)]);
var inst_78408 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78407], 0));
var inst_78409 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78407) : reject.call(null,inst_78407));
var state_78425__$1 = (function (){var statearr_78430 = state_78425;
(statearr_78430[(7)] = inst_78408);

return statearr_78430;
})();
var statearr_78431_78443 = state_78425__$1;
(statearr_78431_78443[(2)] = inst_78409);

(statearr_78431_78443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78426 === (5))){
var _ = (function (){var statearr_78432 = state_78425;
(statearr_78432[(4)] = cljs.core.rest((state_78425[(4)])));

return statearr_78432;
})();
var state_78425__$1 = state_78425;
var ex78429 = (state_78425__$1[(2)]);
var statearr_78433_78444 = state_78425__$1;
(statearr_78433_78444[(5)] = ex78429);


var statearr_78434_78445 = state_78425__$1;
(statearr_78434_78445[(1)] = (4));

(statearr_78434_78445[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78426 === (6))){
var inst_78417 = (state_78425[(2)]);
var inst_78418 = fluree.db.util.async.throw_err(inst_78417);
var inst_78419 = cljs.core.clj__GT_js(inst_78418);
var inst_78420 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78419) : resolve.call(null,inst_78419));
var _ = (function (){var statearr_78435 = state_78425;
(statearr_78435[(4)] = cljs.core.rest((state_78425[(4)])));

return statearr_78435;
})();
var state_78425__$1 = state_78425;
var statearr_78436_78446 = state_78425__$1;
(statearr_78436_78446[(2)] = inst_78420);

(statearr_78436_78446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__11410__auto__ = null;
var flureedb$ledger_stats_$_state_machine__11410__auto____0 = (function (){
var statearr_78437 = [null,null,null,null,null,null,null,null];
(statearr_78437[(0)] = flureedb$ledger_stats_$_state_machine__11410__auto__);

(statearr_78437[(1)] = (1));

return statearr_78437;
});
var flureedb$ledger_stats_$_state_machine__11410__auto____1 = (function (state_78425){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78425);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78438){var ex__11413__auto__ = e78438;
var statearr_78439_78447 = state_78425;
(statearr_78439_78447[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78425[(4)]))){
var statearr_78440_78448 = state_78425;
(statearr_78440_78448[(1)] = cljs.core.first((state_78425[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78449 = state_78425;
state_78425 = G__78449;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__11410__auto__ = function(state_78425){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__11410__auto____1.call(this,state_78425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__11410__auto____0;
flureedb$ledger_stats_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__11410__auto____1;
return flureedb$ledger_stats_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78441 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78441[(6)] = c__11484__auto__);

return statearr_78441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__78451 = arguments.length;
switch (G__78451) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78575){
var state_val_78576 = (state_78575[(1)]);
if((state_val_78576 === (7))){
var inst_78474 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78575__$1 = state_78575;
var statearr_78577_78647 = state_78575__$1;
(statearr_78577_78647[(2)] = inst_78474);

(statearr_78577_78647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (20))){
var inst_78481 = (state_78575[(7)]);
var inst_78520 = (state_78575[(2)]);
var inst_78521 = fluree.db.util.core.current_time_millis();
var state_78575__$1 = (function (){var statearr_78578 = state_78575;
(statearr_78578[(8)] = inst_78520);

(statearr_78578[(9)] = inst_78521);

return statearr_78578;
})();
if(cljs.core.truth_(inst_78481)){
var statearr_78579_78648 = state_78575__$1;
(statearr_78579_78648[(1)] = (21));

} else {
var statearr_78580_78649 = state_78575__$1;
(statearr_78580_78649[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (27))){
var inst_78489 = (state_78575[(10)]);
var inst_78534 = (state_78575[(11)]);
var inst_78536 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78534,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_78489);
var state_78575__$1 = state_78575;
var statearr_78581_78650 = state_78575__$1;
(statearr_78581_78650[(2)] = inst_78536);

(statearr_78581_78650[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (1))){
var state_78575__$1 = state_78575;
var statearr_78582_78651 = state_78575__$1;
(statearr_78582_78651[(2)] = null);

(statearr_78582_78651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (24))){
var inst_78487 = (state_78575[(12)]);
var state_78575__$1 = state_78575;
var statearr_78583_78652 = state_78575__$1;
(statearr_78583_78652[(2)] = inst_78487);

(statearr_78583_78652[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (39))){
var inst_78557 = (state_78575[(2)]);
var inst_78558 = fluree.db.util.async.throw_err(inst_78557);
var state_78575__$1 = state_78575;
var statearr_78584_78653 = state_78575__$1;
(statearr_78584_78653[(2)] = inst_78558);

(statearr_78584_78653[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (4))){
var inst_78452 = (state_78575[(2)]);
var inst_78453 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78452], 0));
var inst_78454 = cljs.core.ex_data(inst_78452);
var inst_78455 = cljs.core.ex_message(inst_78452);
var inst_78456 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78454,new cljs.core.Keyword(null,"message","message",-406056002),inst_78455);
var inst_78457 = cljs.core.clj__GT_js(inst_78456);
var inst_78458 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78457) : reject.call(null,inst_78457));
var state_78575__$1 = (function (){var statearr_78585 = state_78575;
(statearr_78585[(13)] = inst_78453);

return statearr_78585;
})();
var statearr_78586_78654 = state_78575__$1;
(statearr_78586_78654[(2)] = inst_78458);

(statearr_78586_78654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (15))){
var inst_78510 = (state_78575[(14)]);
var inst_78512 = fluree.db.graphdb.validate_ledger_name(inst_78510,"alias");
var state_78575__$1 = state_78575;
var statearr_78587_78655 = state_78575__$1;
(statearr_78587_78655[(2)] = inst_78512);

(statearr_78587_78655[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (21))){
var inst_78481 = (state_78575[(7)]);
var state_78575__$1 = state_78575;
var statearr_78588_78656 = state_78575__$1;
(statearr_78588_78656[(2)] = inst_78481);

(statearr_78588_78656[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (31))){
var state_78575__$1 = state_78575;
var statearr_78589_78657 = state_78575__$1;
(statearr_78589_78657[(2)] = null);

(statearr_78589_78657[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (32))){
var inst_78483 = (state_78575[(15)]);
var inst_78545 = (state_78575[(2)]);
var state_78575__$1 = (function (){var statearr_78590 = state_78575;
(statearr_78590[(16)] = inst_78545);

return statearr_78590;
})();
if(cljs.core.truth_(inst_78483)){
var statearr_78591_78658 = state_78575__$1;
(statearr_78591_78658[(1)] = (33));

} else {
var statearr_78592_78659 = state_78575__$1;
(statearr_78592_78659[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (40))){
var inst_78562 = (state_78575[(2)]);
var inst_78563 = fluree.db.util.async.throw_err(inst_78562);
var state_78575__$1 = state_78575;
var statearr_78593_78660 = state_78575__$1;
(statearr_78593_78660[(2)] = inst_78563);

(statearr_78593_78660[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (33))){
var inst_78545 = (state_78575[(16)]);
var inst_78483 = (state_78575[(15)]);
var inst_78547 = fluree.crypto.sign_message(inst_78545,inst_78483);
var state_78575__$1 = state_78575;
var statearr_78594_78661 = state_78575__$1;
(statearr_78594_78661[(2)] = inst_78547);

(statearr_78594_78661[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (13))){
var state_78575__$1 = state_78575;
var statearr_78595_78662 = state_78575__$1;
(statearr_78595_78662[(2)] = null);

(statearr_78595_78662[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (22))){
var inst_78521 = (state_78575[(9)]);
var state_78575__$1 = state_78575;
var statearr_78596_78663 = state_78575__$1;
(statearr_78596_78663[(2)] = inst_78521);

(statearr_78596_78663[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (36))){
var inst_78545 = (state_78575[(16)]);
var inst_78550 = (state_78575[(17)]);
var inst_78552 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_78553 = [inst_78545,inst_78550];
var inst_78554 = cljs.core.PersistentHashMap.fromArrays(inst_78552,inst_78553);
var inst_78555 = fluree.db.operations.command_async(conn,inst_78554);
var state_78575__$1 = state_78575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78575__$1,(39),inst_78555);
} else {
if((state_val_78576 === (29))){
var inst_78483 = (state_78575[(15)]);
var inst_78539 = (state_78575[(2)]);
var state_78575__$1 = (function (){var statearr_78597 = state_78575;
(statearr_78597[(18)] = inst_78539);

return statearr_78597;
})();
if(cljs.core.truth_(inst_78483)){
var statearr_78598_78664 = state_78575__$1;
(statearr_78598_78664[(1)] = (30));

} else {
var statearr_78599_78665 = state_78575__$1;
(statearr_78599_78665[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (6))){
var state_78575__$1 = state_78575;
var statearr_78600_78666 = state_78575__$1;
(statearr_78600_78666[(2)] = null);

(statearr_78600_78666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (28))){
var inst_78534 = (state_78575[(11)]);
var state_78575__$1 = state_78575;
var statearr_78601_78667 = state_78575__$1;
(statearr_78601_78667[(2)] = inst_78534);

(statearr_78601_78667[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (25))){
var inst_78521 = (state_78575[(9)]);
var inst_78528 = (inst_78521 + (30000));
var state_78575__$1 = state_78575;
var statearr_78602_78668 = state_78575__$1;
(statearr_78602_78668[(2)] = inst_78528);

(statearr_78602_78668[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (34))){
var state_78575__$1 = state_78575;
var statearr_78603_78669 = state_78575__$1;
(statearr_78603_78669[(2)] = null);

(statearr_78603_78669[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (17))){
var inst_78491 = (state_78575[(19)]);
var inst_78515 = (state_78575[(2)]);
var state_78575__$1 = (function (){var statearr_78604 = state_78575;
(statearr_78604[(20)] = inst_78515);

return statearr_78604;
})();
if(cljs.core.truth_(inst_78491)){
var statearr_78605_78670 = state_78575__$1;
(statearr_78605_78670[(1)] = (18));

} else {
var statearr_78606_78671 = state_78575__$1;
(statearr_78606_78671[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (3))){
var inst_78573 = (state_78575[(2)]);
var state_78575__$1 = state_78575;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78575__$1,inst_78573);
} else {
if((state_val_78576 === (12))){
var inst_78505 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_78575__$1 = state_78575;
var statearr_78607_78672 = state_78575__$1;
(statearr_78607_78672[(2)] = inst_78505);

(statearr_78607_78672[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (2))){
var _ = (function (){var statearr_78608 = state_78575;
(statearr_78608[(4)] = cljs.core.cons((5),(state_78575[(4)])));

return statearr_78608;
})();
var inst_78471 = (opts == null);
var state_78575__$1 = state_78575;
if(cljs.core.truth_(inst_78471)){
var statearr_78609_78673 = state_78575__$1;
(statearr_78609_78673[(1)] = (6));

} else {
var statearr_78610_78674 = state_78575__$1;
(statearr_78610_78674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (23))){
var inst_78487 = (state_78575[(12)]);
var inst_78525 = (state_78575[(2)]);
var state_78575__$1 = (function (){var statearr_78611 = state_78575;
(statearr_78611[(21)] = inst_78525);

return statearr_78611;
})();
if(cljs.core.truth_(inst_78487)){
var statearr_78612_78675 = state_78575__$1;
(statearr_78612_78675[(1)] = (24));

} else {
var statearr_78613_78676 = state_78575__$1;
(statearr_78613_78676[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (35))){
var inst_78483 = (state_78575[(15)]);
var inst_78550 = (state_78575[(2)]);
var state_78575__$1 = (function (){var statearr_78614 = state_78575;
(statearr_78614[(17)] = inst_78550);

return statearr_78614;
})();
if(cljs.core.truth_(inst_78483)){
var statearr_78615_78677 = state_78575__$1;
(statearr_78615_78677[(1)] = (36));

} else {
var statearr_78616_78678 = state_78575__$1;
(statearr_78616_78678[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (19))){
var state_78575__$1 = state_78575;
var statearr_78617_78679 = state_78575__$1;
(statearr_78617_78679[(2)] = null);

(statearr_78617_78679[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (11))){
var inst_78494 = (state_78575[(22)]);
var inst_78501 = (state_78575[(23)]);
var inst_78491 = (state_78575[(19)]);
var inst_78501__$1 = (state_78575[(2)]);
var inst_78502 = fluree.db.graphdb.validate_ledger_name(inst_78501__$1,"ledger");
var inst_78503 = fluree.db.graphdb.validate_ledger_name(inst_78494,"network");
var state_78575__$1 = (function (){var statearr_78619 = state_78575;
(statearr_78619[(24)] = inst_78502);

(statearr_78619[(25)] = inst_78503);

(statearr_78619[(23)] = inst_78501__$1);

return statearr_78619;
})();
if(cljs.core.truth_(inst_78491)){
var statearr_78620_78680 = state_78575__$1;
(statearr_78620_78680[(1)] = (12));

} else {
var statearr_78621_78681 = state_78575__$1;
(statearr_78621_78681[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (9))){
var inst_78495 = (state_78575[(26)]);
var inst_78498 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_78495,(1));
var state_78575__$1 = state_78575;
var statearr_78622_78682 = state_78575__$1;
(statearr_78622_78682[(2)] = inst_78498);

(statearr_78622_78682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (5))){
var _ = (function (){var statearr_78623 = state_78575;
(statearr_78623[(4)] = cljs.core.rest((state_78575[(4)])));

return statearr_78623;
})();
var state_78575__$1 = state_78575;
var ex78618 = (state_78575__$1[(2)]);
var statearr_78624_78683 = state_78575__$1;
(statearr_78624_78683[(5)] = ex78618);


var statearr_78625_78684 = state_78575__$1;
(statearr_78625_78684[(1)] = (4));

(statearr_78625_78684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (14))){
var inst_78491 = (state_78575[(19)]);
var inst_78508 = (state_78575[(2)]);
var inst_78509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78508,(0),null);
var inst_78510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78508,(1),null);
var state_78575__$1 = (function (){var statearr_78626 = state_78575;
(statearr_78626[(14)] = inst_78510);

(statearr_78626[(27)] = inst_78509);

return statearr_78626;
})();
if(cljs.core.truth_(inst_78491)){
var statearr_78627_78685 = state_78575__$1;
(statearr_78627_78685[(1)] = (15));

} else {
var statearr_78628_78686 = state_78575__$1;
(statearr_78628_78686[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (26))){
var inst_78490 = (state_78575[(28)]);
var inst_78494 = (state_78575[(22)]);
var inst_78489 = (state_78575[(10)]);
var inst_78486 = (state_78575[(29)]);
var inst_78482 = (state_78575[(30)]);
var inst_78484 = (state_78575[(31)]);
var inst_78488 = (state_78575[(32)]);
var inst_78492 = (state_78575[(33)]);
var inst_78520 = (state_78575[(8)]);
var inst_78501 = (state_78575[(23)]);
var inst_78485 = (state_78575[(34)]);
var inst_78525 = (state_78575[(21)]);
var inst_78480 = (state_78575[(35)]);
var inst_78530 = (state_78575[(2)]);
var inst_78531 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_78532 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78494),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78501)].join('');
var inst_78533 = [inst_78485,inst_78486,inst_78532,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_78530,inst_78488,inst_78520,inst_78492,inst_78490,inst_78480,inst_78525,inst_78482,inst_78484];
var inst_78534 = cljs.core.PersistentHashMap.fromArrays(inst_78531,inst_78533);
var state_78575__$1 = (function (){var statearr_78629 = state_78575;
(statearr_78629[(11)] = inst_78534);

return statearr_78629;
})();
if(cljs.core.truth_(inst_78489)){
var statearr_78630_78687 = state_78575__$1;
(statearr_78630_78687[(1)] = (27));

} else {
var statearr_78631_78688 = state_78575__$1;
(statearr_78631_78688[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (16))){
var state_78575__$1 = state_78575;
var statearr_78632_78689 = state_78575__$1;
(statearr_78632_78689[(2)] = null);

(statearr_78632_78689[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (38))){
var inst_78565 = (state_78575[(2)]);
var inst_78566 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_78567 = [(200),inst_78565];
var inst_78568 = cljs.core.PersistentHashMap.fromArrays(inst_78566,inst_78567);
var inst_78569 = cljs.core.clj__GT_js(inst_78568);
var inst_78570 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78569) : resolve.call(null,inst_78569));
var _ = (function (){var statearr_78633 = state_78575;
(statearr_78633[(4)] = cljs.core.rest((state_78575[(4)])));

return statearr_78633;
})();
var state_78575__$1 = state_78575;
var statearr_78634_78690 = state_78575__$1;
(statearr_78634_78690[(2)] = inst_78570);

(statearr_78634_78690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (30))){
var inst_78539 = (state_78575[(18)]);
var inst_78541 = fluree.db.util.core.without_nils(inst_78539);
var inst_78542 = fluree.db.util.json.stringify(inst_78541);
var state_78575__$1 = state_78575;
var statearr_78635_78691 = state_78575__$1;
(statearr_78635_78691[(2)] = inst_78542);

(statearr_78635_78691[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (10))){
var inst_78495 = (state_78575[(26)]);
var state_78575__$1 = state_78575;
var statearr_78636_78692 = state_78575__$1;
(statearr_78636_78692[(2)] = inst_78495);

(statearr_78636_78692[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (18))){
var inst_78510 = (state_78575[(14)]);
var inst_78509 = (state_78575[(27)]);
var inst_78517 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78509),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78510)].join('');
var state_78575__$1 = state_78575;
var statearr_78637_78693 = state_78575__$1;
(statearr_78637_78693[(2)] = inst_78517);

(statearr_78637_78693[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78576 === (37))){
var inst_78539 = (state_78575[(18)]);
var inst_78560 = fluree.db.operations.unsigned_command_async(conn,inst_78539);
var state_78575__$1 = state_78575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78575__$1,(40),inst_78560);
} else {
if((state_val_78576 === (8))){
var inst_78495 = (state_78575[(26)]);
var inst_78476 = (state_78575[(2)]);
var inst_78477 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78476);
var inst_78478 = cljs.core.__destructure_map(inst_78476);
var inst_78479 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_78478,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_78480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_78481 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_78482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_78483 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_78484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_78485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_78486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_78487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_78488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_78490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_78491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_78492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78478,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_78493 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_78494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78493,(0),null);
var inst_78495__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78493,(1),null);
var inst_78496 = clojure.string.starts_with_QMARK_(inst_78495__$1,"$");
var state_78575__$1 = (function (){var statearr_78638 = state_78575;
(statearr_78638[(28)] = inst_78490);

(statearr_78638[(22)] = inst_78494);

(statearr_78638[(10)] = inst_78489);

(statearr_78638[(29)] = inst_78486);

(statearr_78638[(30)] = inst_78482);

(statearr_78638[(12)] = inst_78487);

(statearr_78638[(31)] = inst_78484);

(statearr_78638[(32)] = inst_78488);

(statearr_78638[(36)] = inst_78477);

(statearr_78638[(37)] = inst_78479);

(statearr_78638[(7)] = inst_78481);

(statearr_78638[(33)] = inst_78492);

(statearr_78638[(26)] = inst_78495__$1);

(statearr_78638[(34)] = inst_78485);

(statearr_78638[(15)] = inst_78483);

(statearr_78638[(19)] = inst_78491);

(statearr_78638[(35)] = inst_78480);

return statearr_78638;
})();
if(inst_78496){
var statearr_78639_78694 = state_78575__$1;
(statearr_78639_78694[(1)] = (9));

} else {
var statearr_78640_78695 = state_78575__$1;
(statearr_78640_78695[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_78641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78641[(0)] = flureedb$state_machine__11410__auto__);

(statearr_78641[(1)] = (1));

return statearr_78641;
});
var flureedb$state_machine__11410__auto____1 = (function (state_78575){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78575);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78642){var ex__11413__auto__ = e78642;
var statearr_78643_78696 = state_78575;
(statearr_78643_78696[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78575[(4)]))){
var statearr_78644_78697 = state_78575;
(statearr_78644_78697[(1)] = cljs.core.first((state_78575[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78698 = state_78575;
state_78575 = G__78698;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_78575){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_78575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78645 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78645[(6)] = c__11484__auto__);

return statearr_78645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78718){
var state_val_78719 = (state_78718[(1)]);
if((state_val_78719 === (1))){
var state_78718__$1 = state_78718;
var statearr_78720_78736 = state_78718__$1;
(statearr_78720_78736[(2)] = null);

(statearr_78720_78736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78719 === (2))){
var _ = (function (){var statearr_78721 = state_78718;
(statearr_78721[(4)] = cljs.core.cons((5),(state_78718[(4)])));

return statearr_78721;
})();
var inst_78708 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_78709 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_78718__$1 = (function (){var statearr_78722 = state_78718;
(statearr_78722[(7)] = inst_78708);

return statearr_78722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78718__$1,(6),inst_78709);
} else {
if((state_val_78719 === (3))){
var inst_78716 = (state_78718[(2)]);
var state_78718__$1 = state_78718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78718__$1,inst_78716);
} else {
if((state_val_78719 === (4))){
var inst_78699 = (state_78718[(2)]);
var inst_78700 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78699], 0));
var inst_78701 = cljs.core.clj__GT_js(inst_78699);
var inst_78702 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78701) : reject.call(null,inst_78701));
var state_78718__$1 = (function (){var statearr_78724 = state_78718;
(statearr_78724[(8)] = inst_78700);

return statearr_78724;
})();
var statearr_78725_78737 = state_78718__$1;
(statearr_78725_78737[(2)] = inst_78702);

(statearr_78725_78737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78719 === (5))){
var _ = (function (){var statearr_78726 = state_78718;
(statearr_78726[(4)] = cljs.core.rest((state_78718[(4)])));

return statearr_78726;
})();
var state_78718__$1 = state_78718;
var ex78723 = (state_78718__$1[(2)]);
var statearr_78727_78738 = state_78718__$1;
(statearr_78727_78738[(5)] = ex78723);


var statearr_78728_78739 = state_78718__$1;
(statearr_78728_78739[(1)] = (4));

(statearr_78728_78739[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78719 === (6))){
var inst_78711 = (state_78718[(2)]);
var inst_78712 = cljs.core.clj__GT_js(inst_78711);
var inst_78713 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78712) : resolve.call(null,inst_78712));
var _ = (function (){var statearr_78729 = state_78718;
(statearr_78729[(4)] = cljs.core.rest((state_78718[(4)])));

return statearr_78729;
})();
var state_78718__$1 = state_78718;
var statearr_78730_78740 = state_78718__$1;
(statearr_78730_78740[(2)] = inst_78713);

(statearr_78730_78740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__11410__auto__ = null;
var flureedb$monitor_tx_$_state_machine__11410__auto____0 = (function (){
var statearr_78731 = [null,null,null,null,null,null,null,null,null];
(statearr_78731[(0)] = flureedb$monitor_tx_$_state_machine__11410__auto__);

(statearr_78731[(1)] = (1));

return statearr_78731;
});
var flureedb$monitor_tx_$_state_machine__11410__auto____1 = (function (state_78718){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78718);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78732){var ex__11413__auto__ = e78732;
var statearr_78733_78741 = state_78718;
(statearr_78733_78741[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78718[(4)]))){
var statearr_78734_78742 = state_78718;
(statearr_78734_78742[(1)] = cljs.core.first((state_78718[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78743 = state_78718;
state_78718 = G__78743;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__11410__auto__ = function(state_78718){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__11410__auto____1.call(this,state_78718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__11410__auto____0;
flureedb$monitor_tx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__11410__auto____1;
return flureedb$monitor_tx_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78735 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78735[(6)] = c__11484__auto__);

return statearr_78735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__78745 = arguments.length;
switch (G__78745) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78771){
var state_val_78772 = (state_78771[(1)]);
if((state_val_78772 === (7))){
var inst_78757 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78771__$1 = state_78771;
var statearr_78773_78794 = state_78771__$1;
(statearr_78773_78794[(2)] = inst_78757);

(statearr_78773_78794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (1))){
var state_78771__$1 = state_78771;
var statearr_78774_78795 = state_78771__$1;
(statearr_78774_78795[(2)] = null);

(statearr_78774_78795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (4))){
var inst_78746 = (state_78771[(2)]);
var inst_78747 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78746], 0));
var inst_78748 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78746) : reject.call(null,inst_78746));
var state_78771__$1 = (function (){var statearr_78775 = state_78771;
(statearr_78775[(7)] = inst_78747);

return statearr_78775;
})();
var statearr_78776_78796 = state_78771__$1;
(statearr_78776_78796[(2)] = inst_78748);

(statearr_78776_78796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (6))){
var state_78771__$1 = state_78771;
var statearr_78777_78797 = state_78771__$1;
(statearr_78777_78797[(2)] = null);

(statearr_78777_78797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (3))){
var inst_78769 = (state_78771[(2)]);
var state_78771__$1 = state_78771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78771__$1,inst_78769);
} else {
if((state_val_78772 === (2))){
var _ = (function (){var statearr_78779 = state_78771;
(statearr_78779[(4)] = cljs.core.cons((5),(state_78771[(4)])));

return statearr_78779;
})();
var inst_78754 = (opts == null);
var state_78771__$1 = state_78771;
if(cljs.core.truth_(inst_78754)){
var statearr_78780_78798 = state_78771__$1;
(statearr_78780_78798[(1)] = (6));

} else {
var statearr_78781_78799 = state_78771__$1;
(statearr_78781_78799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (9))){
var inst_78764 = (state_78771[(2)]);
var inst_78765 = cljs.core.clj__GT_js(inst_78764);
var inst_78766 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78765) : resolve.call(null,inst_78765));
var _ = (function (){var statearr_78782 = state_78771;
(statearr_78782[(4)] = cljs.core.rest((state_78771[(4)])));

return statearr_78782;
})();
var state_78771__$1 = state_78771;
var statearr_78783_78800 = state_78771__$1;
(statearr_78783_78800[(2)] = inst_78766);

(statearr_78783_78800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (5))){
var _ = (function (){var statearr_78784 = state_78771;
(statearr_78784[(4)] = cljs.core.rest((state_78771[(4)])));

return statearr_78784;
})();
var state_78771__$1 = state_78771;
var ex78778 = (state_78771__$1[(2)]);
var statearr_78785_78801 = state_78771__$1;
(statearr_78785_78801[(5)] = ex78778);


var statearr_78786_78802 = state_78771__$1;
(statearr_78786_78802[(1)] = (4));

(statearr_78786_78802[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78772 === (8))){
var inst_78759 = (state_78771[(2)]);
var inst_78760 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78759);
var inst_78761 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78762 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_78761,inst_78759);
var state_78771__$1 = (function (){var statearr_78787 = state_78771;
(statearr_78787[(8)] = inst_78760);

return statearr_78787;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78771__$1,(9),inst_78762);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_78788 = [null,null,null,null,null,null,null,null,null];
(statearr_78788[(0)] = flureedb$state_machine__11410__auto__);

(statearr_78788[(1)] = (1));

return statearr_78788;
});
var flureedb$state_machine__11410__auto____1 = (function (state_78771){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78771);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78789){var ex__11413__auto__ = e78789;
var statearr_78790_78803 = state_78771;
(statearr_78790_78803[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78771[(4)]))){
var statearr_78791_78804 = state_78771;
(statearr_78791_78804[(1)] = cljs.core.first((state_78771[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78805 = state_78771;
state_78771 = G__78805;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_78771){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_78771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78792 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78792[(6)] = c__11484__auto__);

return statearr_78792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__78807 = arguments.length;
switch (G__78807) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78836){
var state_val_78837 = (state_78836[(1)]);
if((state_val_78837 === (7))){
var inst_78819 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78836__$1 = state_78836;
var statearr_78838_78859 = state_78836__$1;
(statearr_78838_78859[(2)] = inst_78819);

(statearr_78838_78859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (1))){
var state_78836__$1 = state_78836;
var statearr_78839_78860 = state_78836__$1;
(statearr_78839_78860[(2)] = null);

(statearr_78839_78860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (4))){
var inst_78808 = (state_78836[(2)]);
var inst_78809 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78808], 0));
var inst_78810 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78808) : reject.call(null,inst_78808));
var state_78836__$1 = (function (){var statearr_78840 = state_78836;
(statearr_78840[(7)] = inst_78809);

return statearr_78840;
})();
var statearr_78841_78861 = state_78836__$1;
(statearr_78841_78861[(2)] = inst_78810);

(statearr_78841_78861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (6))){
var state_78836__$1 = state_78836;
var statearr_78842_78862 = state_78836__$1;
(statearr_78842_78862[(2)] = null);

(statearr_78842_78862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (3))){
var inst_78834 = (state_78836[(2)]);
var state_78836__$1 = state_78836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78836__$1,inst_78834);
} else {
if((state_val_78837 === (2))){
var _ = (function (){var statearr_78844 = state_78836;
(statearr_78844[(4)] = cljs.core.cons((5),(state_78836[(4)])));

return statearr_78844;
})();
var inst_78816 = (opts == null);
var state_78836__$1 = state_78836;
if(cljs.core.truth_(inst_78816)){
var statearr_78845_78863 = state_78836__$1;
(statearr_78845_78863[(1)] = (6));

} else {
var statearr_78846_78864 = state_78836__$1;
(statearr_78846_78864[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (9))){
var inst_78821 = (state_78836[(8)]);
var inst_78824 = (state_78836[(2)]);
var inst_78825 = fluree.db.util.async.throw_err(inst_78824);
var inst_78826 = fluree.db.query.block.block_range(inst_78825,start,end,inst_78821);
var state_78836__$1 = state_78836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78836__$1,(10),inst_78826);
} else {
if((state_val_78837 === (5))){
var _ = (function (){var statearr_78847 = state_78836;
(statearr_78847[(4)] = cljs.core.rest((state_78836[(4)])));

return statearr_78847;
})();
var state_78836__$1 = state_78836;
var ex78843 = (state_78836__$1[(2)]);
var statearr_78848_78865 = state_78836__$1;
(statearr_78848_78865[(5)] = ex78843);


var statearr_78849_78866 = state_78836__$1;
(statearr_78849_78866[(1)] = (4));

(statearr_78849_78866[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (10))){
var inst_78828 = (state_78836[(2)]);
var inst_78829 = fluree.db.util.async.throw_err(inst_78828);
var inst_78830 = cljs.core.clj__GT_js(inst_78829);
var inst_78831 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78830) : resolve.call(null,inst_78830));
var _ = (function (){var statearr_78850 = state_78836;
(statearr_78850[(4)] = cljs.core.rest((state_78836[(4)])));

return statearr_78850;
})();
var state_78836__$1 = state_78836;
var statearr_78851_78867 = state_78836__$1;
(statearr_78851_78867[(2)] = inst_78831);

(statearr_78851_78867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78837 === (8))){
var inst_78821 = (state_78836[(8)]);
var inst_78821__$1 = (state_78836[(2)]);
var inst_78822 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78821__$1], 0));
var state_78836__$1 = (function (){var statearr_78852 = state_78836;
(statearr_78852[(8)] = inst_78821__$1);

return statearr_78852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78836__$1,(9),inst_78822);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_78853 = [null,null,null,null,null,null,null,null,null];
(statearr_78853[(0)] = flureedb$state_machine__11410__auto__);

(statearr_78853[(1)] = (1));

return statearr_78853;
});
var flureedb$state_machine__11410__auto____1 = (function (state_78836){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78836);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78854){var ex__11413__auto__ = e78854;
var statearr_78855_78868 = state_78836;
(statearr_78855_78868[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78836[(4)]))){
var statearr_78856_78869 = state_78836;
(statearr_78856_78869[(1)] = cljs.core.first((state_78836[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78870 = state_78836;
state_78836 = G__78870;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_78836){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_78836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78857 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78857[(6)] = c__11484__auto__);

return statearr_78857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__78872 = arguments.length;
switch (G__78872) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78907){
var state_val_78908 = (state_78907[(1)]);
if((state_val_78908 === (7))){
var inst_78885 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78907__$1 = state_78907;
var statearr_78909_78930 = state_78907__$1;
(statearr_78909_78930[(2)] = inst_78885);

(statearr_78909_78930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (1))){
var state_78907__$1 = state_78907;
var statearr_78910_78931 = state_78907__$1;
(statearr_78910_78931[(2)] = null);

(statearr_78910_78931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (4))){
var inst_78873 = (state_78907[(2)]);
var inst_78874 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78873], 0));
var inst_78875 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78873) : reject.call(null,inst_78873));
var state_78907__$1 = (function (){var statearr_78911 = state_78907;
(statearr_78911[(7)] = inst_78874);

return statearr_78911;
})();
var statearr_78912_78932 = state_78907__$1;
(statearr_78912_78932[(2)] = inst_78875);

(statearr_78912_78932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (6))){
var state_78907__$1 = state_78907;
var statearr_78913_78933 = state_78907__$1;
(statearr_78913_78933[(2)] = null);

(statearr_78913_78933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (3))){
var inst_78905 = (state_78907[(2)]);
var state_78907__$1 = state_78907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78907__$1,inst_78905);
} else {
if((state_val_78908 === (2))){
var _ = (function (){var statearr_78915 = state_78907;
(statearr_78915[(4)] = cljs.core.cons((5),(state_78907[(4)])));

return statearr_78915;
})();
var inst_78882 = (opts == null);
var state_78907__$1 = state_78907;
if(cljs.core.truth_(inst_78882)){
var statearr_78916_78934 = state_78907__$1;
(statearr_78916_78934[(1)] = (6));

} else {
var statearr_78917_78935 = state_78907__$1;
(statearr_78917_78935[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (9))){
var inst_78887 = (state_78907[(8)]);
var inst_78891 = (state_78907[(9)]);
var inst_78890 = (state_78907[(10)]);
var inst_78894 = (state_78907[(2)]);
var inst_78895 = fluree.db.util.async.throw_err(inst_78894);
var inst_78896 = fluree.db.query.block.block_range(inst_78895,inst_78890,inst_78891,inst_78887);
var state_78907__$1 = state_78907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78907__$1,(10),inst_78896);
} else {
if((state_val_78908 === (5))){
var _ = (function (){var statearr_78918 = state_78907;
(statearr_78918[(4)] = cljs.core.rest((state_78907[(4)])));

return statearr_78918;
})();
var state_78907__$1 = state_78907;
var ex78914 = (state_78907__$1[(2)]);
var statearr_78919_78936 = state_78907__$1;
(statearr_78919_78936[(5)] = ex78914);


var statearr_78920_78937 = state_78907__$1;
(statearr_78920_78937[(1)] = (4));

(statearr_78920_78937[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (10))){
var inst_78898 = (state_78907[(2)]);
var inst_78899 = fluree.db.util.async.throw_err(inst_78898);
var inst_78900 = fluree.db.query.range.block_with_tx_data(inst_78899);
var inst_78901 = cljs.core.clj__GT_js(inst_78900);
var inst_78902 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78901) : resolve.call(null,inst_78901));
var _ = (function (){var statearr_78921 = state_78907;
(statearr_78921[(4)] = cljs.core.rest((state_78907[(4)])));

return statearr_78921;
})();
var state_78907__$1 = state_78907;
var statearr_78922_78938 = state_78907__$1;
(statearr_78922_78938[(2)] = inst_78902);

(statearr_78922_78938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78908 === (8))){
var inst_78887 = (state_78907[(8)]);
var inst_78887__$1 = (state_78907[(2)]);
var inst_78888 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78889 = cljs.core.__destructure_map(inst_78888);
var inst_78890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78889,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_78891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78889,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_78892 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78887__$1], 0));
var state_78907__$1 = (function (){var statearr_78923 = state_78907;
(statearr_78923[(8)] = inst_78887__$1);

(statearr_78923[(9)] = inst_78891);

(statearr_78923[(10)] = inst_78890);

return statearr_78923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78907__$1,(9),inst_78892);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_78924 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78924[(0)] = flureedb$state_machine__11410__auto__);

(statearr_78924[(1)] = (1));

return statearr_78924;
});
var flureedb$state_machine__11410__auto____1 = (function (state_78907){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78907);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78925){var ex__11413__auto__ = e78925;
var statearr_78926_78939 = state_78907;
(statearr_78926_78939[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78907[(4)]))){
var statearr_78927_78940 = state_78907;
(statearr_78927_78940[(1)] = cljs.core.first((state_78907[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78941 = state_78907;
state_78907 = G__78941;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_78907){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_78907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78928 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78928[(6)] = c__11484__auto__);

return statearr_78928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__78943 = arguments.length;
switch (G__78943) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_79010){
var state_val_79011 = (state_79010[(1)]);
if((state_val_79011 === (7))){
var inst_78956 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79010__$1 = state_79010;
var statearr_79012_79053 = state_79010__$1;
(statearr_79012_79053[(2)] = inst_78956);

(statearr_79012_79053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (20))){
var inst_78952 = (state_79010[(7)]);
var inst_78958 = (state_79010[(8)]);
var inst_78994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78995 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_78996 = (new cljs.core.PersistentVector(null,1,(5),inst_78994,inst_78995,null));
var inst_78997 = cljs.core.assoc_in(inst_78958,inst_78996,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78998 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_78952,inst_78997);
var state_79010__$1 = state_79010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79010__$1,(23),inst_78998);
} else {
if((state_val_79011 === (1))){
var state_79010__$1 = state_79010;
var statearr_79013_79054 = state_79010__$1;
(statearr_79013_79054[(2)] = null);

(statearr_79013_79054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (4))){
var inst_78944 = (state_79010[(2)]);
var inst_78945 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78944], 0));
var inst_78946 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78944) : reject.call(null,inst_78944));
var state_79010__$1 = (function (){var statearr_79014 = state_79010;
(statearr_79014[(9)] = inst_78945);

return statearr_79014;
})();
var statearr_79015_79055 = state_79010__$1;
(statearr_79015_79055[(2)] = inst_78946);

(statearr_79015_79055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (15))){
var inst_78982 = (state_79010[(2)]);
var inst_78983 = fluree.db.util.async.throw_err(inst_78982);
var state_79010__$1 = state_79010;
var statearr_79016_79056 = state_79010__$1;
(statearr_79016_79056[(2)] = inst_78983);

(statearr_79016_79056[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (21))){
var inst_79003 = (state_79010[(2)]);
var inst_79004 = cljs.core.clj__GT_js(inst_79003);
var inst_79005 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79004) : resolve.call(null,inst_79004));
var _ = (function (){var statearr_79017 = state_79010;
(statearr_79017[(4)] = cljs.core.rest((state_79010[(4)])));

return statearr_79017;
})();
var state_79010__$1 = state_79010;
var statearr_79018_79057 = state_79010__$1;
(statearr_79018_79057[(2)] = inst_79005);

(statearr_79018_79057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (13))){
var state_79010__$1 = state_79010;
var statearr_79019_79058 = state_79010__$1;
(statearr_79019_79058[(2)] = null);

(statearr_79019_79058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (22))){
var inst_78991 = (state_79010[(2)]);
var inst_78992 = fluree.db.util.async.throw_err(inst_78991);
var state_79010__$1 = state_79010;
var statearr_79020_79059 = state_79010__$1;
(statearr_79020_79059[(2)] = inst_78992);

(statearr_79020_79059[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (6))){
var state_79010__$1 = state_79010;
var statearr_79021_79060 = state_79010__$1;
(statearr_79021_79060[(2)] = null);

(statearr_79021_79060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (17))){
var state_79010__$1 = state_79010;
var statearr_79022_79061 = state_79010__$1;
(statearr_79022_79061[(2)] = null);

(statearr_79022_79061[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (3))){
var inst_79008 = (state_79010[(2)]);
var state_79010__$1 = state_79010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79010__$1,inst_79008);
} else {
if((state_val_79011 === (12))){
var inst_78966 = (state_79010[(10)]);
var inst_78970 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_79010__$1 = (function (){var statearr_79023 = state_79010;
(statearr_79023[(11)] = inst_78970);

return statearr_79023;
})();
if(cljs.core.truth_(inst_78966)){
var statearr_79024_79062 = state_79010__$1;
(statearr_79024_79062[(1)] = (16));

} else {
var statearr_79025_79063 = state_79010__$1;
(statearr_79025_79063[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (2))){
var _ = (function (){var statearr_79026 = state_79010;
(statearr_79026[(4)] = cljs.core.cons((5),(state_79010[(4)])));

return statearr_79026;
})();
var inst_78952 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78953 = (opts == null);
var state_79010__$1 = (function (){var statearr_79027 = state_79010;
(statearr_79027[(7)] = inst_78952);

return statearr_79027;
})();
if(cljs.core.truth_(inst_78953)){
var statearr_79028_79064 = state_79010__$1;
(statearr_79028_79064[(1)] = (6));

} else {
var statearr_79029_79065 = state_79010__$1;
(statearr_79029_79065[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (23))){
var inst_79000 = (state_79010[(2)]);
var inst_79001 = fluree.db.util.async.throw_err(inst_79000);
var state_79010__$1 = state_79010;
var statearr_79030_79066 = state_79010__$1;
(statearr_79030_79066[(2)] = inst_79001);

(statearr_79030_79066[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (19))){
var inst_78952 = (state_79010[(7)]);
var inst_78986 = (state_79010[(12)]);
var inst_78958 = (state_79010[(8)]);
var inst_78989 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_78986,inst_78952,inst_78958);
var state_79010__$1 = state_79010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79010__$1,(22),inst_78989);
} else {
if((state_val_79011 === (11))){
var inst_78960 = (state_79010[(13)]);
var inst_78958 = (state_79010[(8)]);
var inst_78966 = (state_79010[(2)]);
var inst_78967 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_78958);
var inst_78968 = (inst_78960 == null);
var state_79010__$1 = (function (){var statearr_79032 = state_79010;
(statearr_79032[(14)] = inst_78967);

(statearr_79032[(10)] = inst_78966);

return statearr_79032;
})();
if(cljs.core.truth_(inst_78968)){
var statearr_79033_79067 = state_79010__$1;
(statearr_79033_79067[(1)] = (12));

} else {
var statearr_79034_79068 = state_79010__$1;
(statearr_79034_79068[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (9))){
var inst_78961 = (state_79010[(15)]);
var state_79010__$1 = state_79010;
var statearr_79035_79069 = state_79010__$1;
(statearr_79035_79069[(2)] = inst_78961);

(statearr_79035_79069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (5))){
var _ = (function (){var statearr_79036 = state_79010;
(statearr_79036[(4)] = cljs.core.rest((state_79010[(4)])));

return statearr_79036;
})();
var state_79010__$1 = state_79010;
var ex79031 = (state_79010__$1[(2)]);
var statearr_79037_79070 = state_79010__$1;
(statearr_79037_79070[(5)] = ex79031);


var statearr_79038_79071 = state_79010__$1;
(statearr_79038_79071[(1)] = (4));

(statearr_79038_79071[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (14))){
var inst_78960 = (state_79010[(13)]);
var inst_78986 = (state_79010[(2)]);
var inst_78987 = (inst_78960 == null);
var state_79010__$1 = (function (){var statearr_79039 = state_79010;
(statearr_79039[(12)] = inst_78986);

return statearr_79039;
})();
if(cljs.core.truth_(inst_78987)){
var statearr_79040_79072 = state_79010__$1;
(statearr_79040_79072[(1)] = (19));

} else {
var statearr_79041_79073 = state_79010__$1;
(statearr_79041_79073[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (16))){
var inst_78966 = (state_79010[(10)]);
var inst_78972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78973 = ["_auth/id",inst_78966];
var inst_78974 = (new cljs.core.PersistentVector(null,2,(5),inst_78972,inst_78973,null));
var state_79010__$1 = state_79010;
var statearr_79042_79074 = state_79010__$1;
(statearr_79042_79074[(2)] = inst_78974);

(statearr_79042_79074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (10))){
var inst_78958 = (state_79010[(8)]);
var inst_78964 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_78958);
var state_79010__$1 = state_79010;
var statearr_79043_79075 = state_79010__$1;
(statearr_79043_79075[(2)] = inst_78964);

(statearr_79043_79075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79011 === (18))){
var inst_78970 = (state_79010[(11)]);
var inst_78967 = (state_79010[(14)]);
var inst_78977 = (state_79010[(2)]);
var inst_78978 = [inst_78977,inst_78967];
var inst_78979 = cljs.core.PersistentHashMap.fromArrays(inst_78970,inst_78978);
var inst_78980 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78979], 0));
var state_79010__$1 = state_79010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79010__$1,(15),inst_78980);
} else {
if((state_val_79011 === (8))){
var inst_78961 = (state_79010[(15)]);
var inst_78958 = (state_79010[(8)]);
var inst_78958__$1 = (state_79010[(2)]);
var inst_78959 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78958__$1);
var inst_78960 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_78958__$1);
var inst_78961__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78958__$1);
var state_79010__$1 = (function (){var statearr_79044 = state_79010;
(statearr_79044[(15)] = inst_78961__$1);

(statearr_79044[(13)] = inst_78960);

(statearr_79044[(16)] = inst_78959);

(statearr_79044[(8)] = inst_78958__$1);

return statearr_79044;
})();
if(cljs.core.truth_(inst_78961__$1)){
var statearr_79045_79076 = state_79010__$1;
(statearr_79045_79076[(1)] = (9));

} else {
var statearr_79046_79077 = state_79010__$1;
(statearr_79046_79077[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_79047 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79047[(0)] = flureedb$state_machine__11410__auto__);

(statearr_79047[(1)] = (1));

return statearr_79047;
});
var flureedb$state_machine__11410__auto____1 = (function (state_79010){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_79010);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e79048){var ex__11413__auto__ = e79048;
var statearr_79049_79078 = state_79010;
(statearr_79049_79078[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_79010[(4)]))){
var statearr_79050_79079 = state_79010;
(statearr_79050_79079[(1)] = cljs.core.first((state_79010[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79080 = state_79010;
state_79010 = G__79080;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_79010){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_79010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_79051 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_79051[(6)] = c__11484__auto__);

return statearr_79051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_79100){
var state_val_79101 = (state_79100[(1)]);
if((state_val_79101 === (1))){
var state_79100__$1 = state_79100;
var statearr_79102_79117 = state_79100__$1;
(statearr_79102_79117[(2)] = null);

(statearr_79102_79117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79101 === (2))){
var _ = (function (){var statearr_79103 = state_79100;
(statearr_79103[(4)] = cljs.core.cons((5),(state_79100[(4)])));

return statearr_79103;
})();
var inst_79089 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79090 = fluree.db.api.query.history_query_async(sources,inst_79089);
var state_79100__$1 = state_79100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79100__$1,(6),inst_79090);
} else {
if((state_val_79101 === (3))){
var inst_79098 = (state_79100[(2)]);
var state_79100__$1 = state_79100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79100__$1,inst_79098);
} else {
if((state_val_79101 === (4))){
var inst_79081 = (state_79100[(2)]);
var inst_79082 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79081], 0));
var inst_79083 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79081) : reject.call(null,inst_79081));
var state_79100__$1 = (function (){var statearr_79105 = state_79100;
(statearr_79105[(7)] = inst_79082);

return statearr_79105;
})();
var statearr_79106_79118 = state_79100__$1;
(statearr_79106_79118[(2)] = inst_79083);

(statearr_79106_79118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79101 === (5))){
var _ = (function (){var statearr_79107 = state_79100;
(statearr_79107[(4)] = cljs.core.rest((state_79100[(4)])));

return statearr_79107;
})();
var state_79100__$1 = state_79100;
var ex79104 = (state_79100__$1[(2)]);
var statearr_79108_79119 = state_79100__$1;
(statearr_79108_79119[(5)] = ex79104);


var statearr_79109_79120 = state_79100__$1;
(statearr_79109_79120[(1)] = (4));

(statearr_79109_79120[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79101 === (6))){
var inst_79092 = (state_79100[(2)]);
var inst_79093 = fluree.db.util.async.throw_err(inst_79092);
var inst_79094 = cljs.core.clj__GT_js(inst_79093);
var inst_79095 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79094) : resolve.call(null,inst_79094));
var _ = (function (){var statearr_79110 = state_79100;
(statearr_79110[(4)] = cljs.core.rest((state_79100[(4)])));

return statearr_79110;
})();
var state_79100__$1 = state_79100;
var statearr_79111_79121 = state_79100__$1;
(statearr_79111_79121[(2)] = inst_79095);

(statearr_79111_79121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__11410__auto__ = null;
var flureedb$history_query_$_state_machine__11410__auto____0 = (function (){
var statearr_79112 = [null,null,null,null,null,null,null,null];
(statearr_79112[(0)] = flureedb$history_query_$_state_machine__11410__auto__);

(statearr_79112[(1)] = (1));

return statearr_79112;
});
var flureedb$history_query_$_state_machine__11410__auto____1 = (function (state_79100){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_79100);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e79113){var ex__11413__auto__ = e79113;
var statearr_79114_79122 = state_79100;
(statearr_79114_79122[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_79100[(4)]))){
var statearr_79115_79123 = state_79100;
(statearr_79115_79123[(1)] = cljs.core.first((state_79100[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79124 = state_79100;
state_79100 = G__79124;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__11410__auto__ = function(state_79100){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__11410__auto____1.call(this,state_79100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__11410__auto____0;
flureedb$history_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__11410__auto____1;
return flureedb$history_query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_79116 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_79116[(6)] = c__11484__auto__);

return statearr_79116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_79144){
var state_val_79145 = (state_79144[(1)]);
if((state_val_79145 === (1))){
var state_79144__$1 = state_79144;
var statearr_79146_79161 = state_79144__$1;
(statearr_79146_79161[(2)] = null);

(statearr_79146_79161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79145 === (2))){
var _ = (function (){var statearr_79147 = state_79144;
(statearr_79147[(4)] = cljs.core.cons((5),(state_79144[(4)])));

return statearr_79147;
})();
var inst_79133 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79134 = fluree.db.api.query.multi_query_async(sources,inst_79133);
var state_79144__$1 = state_79144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79144__$1,(6),inst_79134);
} else {
if((state_val_79145 === (3))){
var inst_79142 = (state_79144[(2)]);
var state_79144__$1 = state_79144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79144__$1,inst_79142);
} else {
if((state_val_79145 === (4))){
var inst_79125 = (state_79144[(2)]);
var inst_79126 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79125], 0));
var inst_79127 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79125) : reject.call(null,inst_79125));
var state_79144__$1 = (function (){var statearr_79149 = state_79144;
(statearr_79149[(7)] = inst_79126);

return statearr_79149;
})();
var statearr_79150_79162 = state_79144__$1;
(statearr_79150_79162[(2)] = inst_79127);

(statearr_79150_79162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79145 === (5))){
var _ = (function (){var statearr_79151 = state_79144;
(statearr_79151[(4)] = cljs.core.rest((state_79144[(4)])));

return statearr_79151;
})();
var state_79144__$1 = state_79144;
var ex79148 = (state_79144__$1[(2)]);
var statearr_79152_79163 = state_79144__$1;
(statearr_79152_79163[(5)] = ex79148);


var statearr_79153_79164 = state_79144__$1;
(statearr_79153_79164[(1)] = (4));

(statearr_79153_79164[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79145 === (6))){
var inst_79136 = (state_79144[(2)]);
var inst_79137 = fluree.db.util.async.throw_err(inst_79136);
var inst_79138 = cljs.core.clj__GT_js(inst_79137);
var inst_79139 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79138) : resolve.call(null,inst_79138));
var _ = (function (){var statearr_79154 = state_79144;
(statearr_79154[(4)] = cljs.core.rest((state_79144[(4)])));

return statearr_79154;
})();
var state_79144__$1 = state_79144;
var statearr_79155_79165 = state_79144__$1;
(statearr_79155_79165[(2)] = inst_79139);

(statearr_79155_79165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__11410__auto__ = null;
var flureedb$multi_query_$_state_machine__11410__auto____0 = (function (){
var statearr_79156 = [null,null,null,null,null,null,null,null];
(statearr_79156[(0)] = flureedb$multi_query_$_state_machine__11410__auto__);

(statearr_79156[(1)] = (1));

return statearr_79156;
});
var flureedb$multi_query_$_state_machine__11410__auto____1 = (function (state_79144){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_79144);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e79157){var ex__11413__auto__ = e79157;
var statearr_79158_79166 = state_79144;
(statearr_79158_79166[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_79144[(4)]))){
var statearr_79159_79167 = state_79144;
(statearr_79159_79167[(1)] = cljs.core.first((state_79144[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79168 = state_79144;
state_79144 = G__79168;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__11410__auto__ = function(state_79144){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__11410__auto____1.call(this,state_79144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__11410__auto____0;
flureedb$multi_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__11410__auto____1;
return flureedb$multi_query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_79160 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_79160[(6)] = c__11484__auto__);

return statearr_79160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_79188){
var state_val_79189 = (state_79188[(1)]);
if((state_val_79189 === (1))){
var state_79188__$1 = state_79188;
var statearr_79190_79205 = state_79188__$1;
(statearr_79190_79205[(2)] = null);

(statearr_79190_79205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79189 === (2))){
var _ = (function (){var statearr_79191 = state_79188;
(statearr_79191[(4)] = cljs.core.cons((5),(state_79188[(4)])));

return statearr_79191;
})();
var inst_79178 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79179 = fluree.db.api.query.query_async(sources,inst_79178);
var state_79188__$1 = state_79188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79188__$1,(6),inst_79179);
} else {
if((state_val_79189 === (3))){
var inst_79186 = (state_79188[(2)]);
var state_79188__$1 = state_79188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79188__$1,inst_79186);
} else {
if((state_val_79189 === (4))){
var inst_79169 = (state_79188[(2)]);
var inst_79170 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79169], 0));
var inst_79171 = cljs.core.clj__GT_js(inst_79169);
var inst_79172 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79171) : reject.call(null,inst_79171));
var state_79188__$1 = (function (){var statearr_79193 = state_79188;
(statearr_79193[(7)] = inst_79170);

return statearr_79193;
})();
var statearr_79194_79206 = state_79188__$1;
(statearr_79194_79206[(2)] = inst_79172);

(statearr_79194_79206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79189 === (5))){
var _ = (function (){var statearr_79195 = state_79188;
(statearr_79195[(4)] = cljs.core.rest((state_79188[(4)])));

return statearr_79195;
})();
var state_79188__$1 = state_79188;
var ex79192 = (state_79188__$1[(2)]);
var statearr_79196_79207 = state_79188__$1;
(statearr_79196_79207[(5)] = ex79192);


var statearr_79197_79208 = state_79188__$1;
(statearr_79197_79208[(1)] = (4));

(statearr_79197_79208[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79189 === (6))){
var inst_79181 = (state_79188[(2)]);
var inst_79182 = cljs.core.clj__GT_js(inst_79181);
var inst_79183 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79182) : resolve.call(null,inst_79182));
var _ = (function (){var statearr_79198 = state_79188;
(statearr_79198[(4)] = cljs.core.rest((state_79188[(4)])));

return statearr_79198;
})();
var state_79188__$1 = state_79188;
var statearr_79199_79209 = state_79188__$1;
(statearr_79199_79209[(2)] = inst_79183);

(statearr_79199_79209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__11410__auto__ = null;
var flureedb$query_$_state_machine__11410__auto____0 = (function (){
var statearr_79200 = [null,null,null,null,null,null,null,null];
(statearr_79200[(0)] = flureedb$query_$_state_machine__11410__auto__);

(statearr_79200[(1)] = (1));

return statearr_79200;
});
var flureedb$query_$_state_machine__11410__auto____1 = (function (state_79188){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_79188);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e79201){var ex__11413__auto__ = e79201;
var statearr_79202_79210 = state_79188;
(statearr_79202_79210[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_79188[(4)]))){
var statearr_79203_79211 = state_79188;
(statearr_79203_79211[(1)] = cljs.core.first((state_79188[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79212 = state_79188;
state_79188 = G__79212;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$query_$_state_machine__11410__auto__ = function(state_79188){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__11410__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__11410__auto____1.call(this,state_79188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__11410__auto____0;
flureedb$query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__11410__auto____1;
return flureedb$query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_79204 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_79204[(6)] = c__11484__auto__);

return statearr_79204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__79214 = arguments.length;
switch (G__79214) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_79241){
var state_val_79242 = (state_79241[(1)]);
if((state_val_79242 === (7))){
var inst_79228 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_79241__$1 = state_79241;
var statearr_79243_79264 = state_79241__$1;
(statearr_79243_79264[(2)] = inst_79228);

(statearr_79243_79264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (1))){
var state_79241__$1 = state_79241;
var statearr_79244_79265 = state_79241__$1;
(statearr_79244_79265[(2)] = null);

(statearr_79244_79265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (4))){
var inst_79215 = (state_79241[(2)]);
var inst_79216 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79215], 0));
var inst_79217 = cljs.core.clj__GT_js(inst_79215);
var inst_79218 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_79217) : reject.call(null,inst_79217));
var state_79241__$1 = (function (){var statearr_79245 = state_79241;
(statearr_79245[(7)] = inst_79216);

return statearr_79245;
})();
var statearr_79246_79266 = state_79241__$1;
(statearr_79246_79266[(2)] = inst_79218);

(statearr_79246_79266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (6))){
var state_79241__$1 = state_79241;
var statearr_79247_79267 = state_79241__$1;
(statearr_79247_79267[(2)] = null);

(statearr_79247_79267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (3))){
var inst_79239 = (state_79241[(2)]);
var state_79241__$1 = state_79241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79241__$1,inst_79239);
} else {
if((state_val_79242 === (2))){
var _ = (function (){var statearr_79249 = state_79241;
(statearr_79249[(4)] = cljs.core.cons((5),(state_79241[(4)])));

return statearr_79249;
})();
var inst_79224 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_79225 = (opts == null);
var state_79241__$1 = (function (){var statearr_79250 = state_79241;
(statearr_79250[(8)] = inst_79224);

return statearr_79250;
})();
if(cljs.core.truth_(inst_79225)){
var statearr_79251_79268 = state_79241__$1;
(statearr_79251_79268[(1)] = (6));

} else {
var statearr_79252_79269 = state_79241__$1;
(statearr_79252_79269[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (9))){
var inst_79233 = (state_79241[(2)]);
var inst_79234 = fluree.db.util.async.throw_err(inst_79233);
var inst_79235 = cljs.core.clj__GT_js(inst_79234);
var inst_79236 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_79235) : resolve.call(null,inst_79235));
var _ = (function (){var statearr_79253 = state_79241;
(statearr_79253[(4)] = cljs.core.rest((state_79241[(4)])));

return statearr_79253;
})();
var state_79241__$1 = state_79241;
var statearr_79254_79270 = state_79241__$1;
(statearr_79254_79270[(2)] = inst_79236);

(statearr_79254_79270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (5))){
var _ = (function (){var statearr_79255 = state_79241;
(statearr_79255[(4)] = cljs.core.rest((state_79241[(4)])));

return statearr_79255;
})();
var state_79241__$1 = state_79241;
var ex79248 = (state_79241__$1[(2)]);
var statearr_79256_79271 = state_79241__$1;
(statearr_79256_79271[(5)] = ex79248);


var statearr_79257_79272 = state_79241__$1;
(statearr_79257_79272[(1)] = (4));

(statearr_79257_79272[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79242 === (8))){
var inst_79224 = (state_79241[(8)]);
var inst_79230 = (state_79241[(2)]);
var inst_79231 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_79224,inst_79230);
var state_79241__$1 = state_79241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79241__$1,(9),inst_79231);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__11410__auto__ = null;
var flureedb$state_machine__11410__auto____0 = (function (){
var statearr_79258 = [null,null,null,null,null,null,null,null,null];
(statearr_79258[(0)] = flureedb$state_machine__11410__auto__);

(statearr_79258[(1)] = (1));

return statearr_79258;
});
var flureedb$state_machine__11410__auto____1 = (function (state_79241){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_79241);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e79259){var ex__11413__auto__ = e79259;
var statearr_79260_79273 = state_79241;
(statearr_79260_79273[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_79241[(4)]))){
var statearr_79261_79274 = state_79241;
(statearr_79261_79274[(1)] = cljs.core.first((state_79241[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79275 = state_79241;
state_79241 = G__79275;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
flureedb$state_machine__11410__auto__ = function(state_79241){
switch(arguments.length){
case 0:
return flureedb$state_machine__11410__auto____0.call(this);
case 1:
return flureedb$state_machine__11410__auto____1.call(this,state_79241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__11410__auto____0;
flureedb$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__11410__auto____1;
return flureedb$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_79262 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_79262[(6)] = c__11484__auto__);

return statearr_79262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
