// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73241 = arguments.length;
var i__4865__auto___73242 = (0);
while(true){
if((i__4865__auto___73242 < len__4864__auto___73241)){
args__4870__auto__.push((arguments[i__4865__auto___73242]));

var G__73243 = (i__4865__auto___73242 + (1));
i__4865__auto___73242 = G__73243;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__73173){
var vec__73174 = p__73173;
var opts = cljs.core.nth.call(null,vec__73174,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___73244 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73218){
var state_val_73219 = (state_73218[(1)]);
if((state_val_73219 === (7))){
var inst_73204 = (state_73218[(7)]);
var inst_73195 = (state_73218[(8)]);
var inst_73206 = fluree.db.time_travel.as_of_block.call(null,inst_73204,inst_73195);
var state_73218__$1 = state_73218;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73218__$1,(10),inst_73206);
} else {
if((state_val_73219 === (1))){
var state_73218__$1 = state_73218;
var statearr_73220_73245 = state_73218__$1;
(statearr_73220_73245[(2)] = null);

(statearr_73220_73245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (4))){
var inst_73177 = (state_73218[(2)]);
var inst_73178 = fluree.db.util.log.error.call(null,inst_73177);
var inst_73179 = cljs.core.async.put_BANG_.call(null,pc,inst_73177);
var inst_73180 = cljs.core.async.close_BANG_.call(null,pc);
var state_73218__$1 = (function (){var statearr_73221 = state_73218;
(statearr_73221[(9)] = inst_73178);

(statearr_73221[(10)] = inst_73179);

return statearr_73221;
})();
var statearr_73222_73246 = state_73218__$1;
(statearr_73222_73246[(2)] = inst_73180);

(statearr_73222_73246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (6))){
var inst_73198 = (state_73218[(11)]);
var inst_73199 = (state_73218[(12)]);
var inst_73195 = (state_73218[(8)]);
var inst_73202 = (state_73218[(2)]);
var inst_73203 = fluree.db.util.async.throw_err.call(null,inst_73202);
var inst_73204 = cljs.core.assoc.call(null,inst_73203,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_73198,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_73199);
var state_73218__$1 = (function (){var statearr_73223 = state_73218;
(statearr_73223[(7)] = inst_73204);

return statearr_73223;
})();
if(cljs.core.truth_(inst_73195)){
var statearr_73224_73247 = state_73218__$1;
(statearr_73224_73247[(1)] = (7));

} else {
var statearr_73225_73248 = state_73218__$1;
(statearr_73225_73248[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (3))){
var inst_73216 = (state_73218[(2)]);
var state_73218__$1 = state_73218;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73218__$1,inst_73216);
} else {
if((state_val_73219 === (2))){
var _ = (function (){var statearr_73227 = state_73218;
(statearr_73227[(4)] = cljs.core.cons.call(null,(5),(state_73218[(4)])));

return statearr_73227;
})();
var inst_73190 = opts;
var inst_73191 = cljs.core.__destructure_map.call(null,inst_73190);
var inst_73192 = cljs.core.get.call(null,inst_73191,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_73193 = cljs.core.get.call(null,inst_73191,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_73194 = cljs.core.get.call(null,inst_73191,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73195 = cljs.core.get.call(null,inst_73191,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73196 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_73197 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_73198 = cljs.core.nth.call(null,inst_73197,(0),null);
var inst_73199 = cljs.core.nth.call(null,inst_73197,(1),null);
var inst_73200 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_73218__$1 = (function (){var statearr_73228 = state_73218;
(statearr_73228[(11)] = inst_73198);

(statearr_73228[(13)] = inst_73192);

(statearr_73228[(12)] = inst_73199);

(statearr_73228[(14)] = inst_73193);

(statearr_73228[(8)] = inst_73195);

(statearr_73228[(15)] = inst_73194);

(statearr_73228[(16)] = inst_73196);

return statearr_73228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73218__$1,(6),inst_73200);
} else {
if((state_val_73219 === (9))){
var inst_73212 = (state_73218[(2)]);
var inst_73213 = cljs.core.async.put_BANG_.call(null,pc,inst_73212);
var _ = (function (){var statearr_73229 = state_73218;
(statearr_73229[(4)] = cljs.core.rest.call(null,(state_73218[(4)])));

return statearr_73229;
})();
var state_73218__$1 = state_73218;
var statearr_73230_73249 = state_73218__$1;
(statearr_73230_73249[(2)] = inst_73213);

(statearr_73230_73249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (5))){
var _ = (function (){var statearr_73231 = state_73218;
(statearr_73231[(4)] = cljs.core.rest.call(null,(state_73218[(4)])));

return statearr_73231;
})();
var state_73218__$1 = state_73218;
var ex73226 = (state_73218__$1[(2)]);
var statearr_73232_73250 = state_73218__$1;
(statearr_73232_73250[(5)] = ex73226);


var statearr_73233_73251 = state_73218__$1;
(statearr_73233_73251[(1)] = (4));

(statearr_73233_73251[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (10))){
var inst_73208 = (state_73218[(2)]);
var inst_73209 = fluree.db.util.async.throw_err.call(null,inst_73208);
var state_73218__$1 = state_73218;
var statearr_73234_73252 = state_73218__$1;
(statearr_73234_73252[(2)] = inst_73209);

(statearr_73234_73252[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73219 === (8))){
var inst_73204 = (state_73218[(7)]);
var state_73218__$1 = state_73218;
var statearr_73235_73253 = state_73218__$1;
(statearr_73235_73253[(2)] = inst_73204);

(statearr_73235_73253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_73236 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73236[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_73236[(1)] = (1));

return statearr_73236;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_73218){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73218);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73237){var ex__10906__auto__ = e73237;
var statearr_73238_73254 = state_73218;
(statearr_73238_73254[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73218[(4)]))){
var statearr_73239_73255 = state_73218;
(statearr_73239_73255[(1)] = cljs.core.first.call(null,(state_73218[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73256 = state_73218;
state_73218 = G__73256;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_73218){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_73218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73240 = f__10977__auto__.call(null);
(statearr_73240[(6)] = c__10976__auto___73244);

return statearr_73240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq73170){
var G__73171 = cljs.core.first.call(null,seq73170);
var seq73170__$1 = cljs.core.next.call(null,seq73170);
var G__73172 = cljs.core.first.call(null,seq73170__$1);
var seq73170__$2 = cljs.core.next.call(null,seq73170__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73171,G__73172,seq73170__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__73258 = arguments.length;
switch (G__73258) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73384){
var state_val_73385 = (state_73384[(1)]);
if((state_val_73385 === (7))){
var inst_73284 = (state_73384[(7)]);
var inst_73274 = (state_73384[(8)]);
var inst_73286 = fluree.db.time_travel.as_of_block.call(null,inst_73284,inst_73274);
var state_73384__$1 = state_73384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73384__$1,(10),inst_73286);
} else {
if((state_val_73385 === (20))){
var inst_73278 = (state_73384[(9)]);
var state_73384__$1 = state_73384;
var statearr_73386_73466 = state_73384__$1;
(statearr_73386_73466[(2)] = inst_73278);

(statearr_73386_73466[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (27))){
var inst_73272 = (state_73384[(10)]);
var state_73384__$1 = state_73384;
var statearr_73387_73467 = state_73384__$1;
(statearr_73387_73467[(2)] = inst_73272);

(statearr_73387_73467[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (1))){
var state_73384__$1 = state_73384;
var statearr_73388_73468 = state_73384__$1;
(statearr_73388_73468[(2)] = null);

(statearr_73388_73468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (24))){
var inst_73281 = (state_73384[(11)]);
var state_73384__$1 = state_73384;
if(cljs.core.truth_(inst_73281)){
var statearr_73389_73469 = state_73384__$1;
(statearr_73389_73469[(1)] = (26));

} else {
var statearr_73390_73470 = state_73384__$1;
(statearr_73390_73470[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (39))){
var inst_73346 = (state_73384[(12)]);
var inst_73349 = cljs.core.ex_data.call(null,inst_73346);
var inst_73350 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73351 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73349);
var inst_73352 = cljs.core.ex_message.call(null,inst_73346);
var inst_73353 = [inst_73351,inst_73352,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73354 = cljs.core.PersistentHashMap.fromArrays(inst_73350,inst_73353);
var state_73384__$1 = state_73384;
var statearr_73391_73471 = state_73384__$1;
(statearr_73391_73471[(2)] = inst_73354);

(statearr_73391_73471[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (46))){
var inst_73346 = (state_73384[(12)]);
var state_73384__$1 = state_73384;
var statearr_73392_73472 = state_73384__$1;
(statearr_73392_73472[(2)] = inst_73346);

(statearr_73392_73472[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (4))){
var inst_73259 = (state_73384[(2)]);
var inst_73260 = fluree.db.util.log.error.call(null,inst_73259);
var inst_73261 = cljs.core.ex_data.call(null,inst_73259);
var inst_73262 = cljs.core.ex_message.call(null,inst_73259);
var inst_73263 = cljs.core.assoc.call(null,inst_73261,new cljs.core.Keyword(null,"message","message",-406056002),inst_73262);
var state_73384__$1 = (function (){var statearr_73393 = state_73384;
(statearr_73393[(13)] = inst_73260);

return statearr_73393;
})();
var statearr_73394_73473 = state_73384__$1;
(statearr_73394_73473[(2)] = inst_73263);

(statearr_73394_73473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (15))){
var state_73384__$1 = state_73384;
var statearr_73395_73474 = state_73384__$1;
(statearr_73395_73474[(2)] = (1000000));

(statearr_73395_73474[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (48))){
var inst_73346 = (state_73384[(12)]);
var state_73384__$1 = state_73384;
var statearr_73396_73475 = state_73384__$1;
(statearr_73396_73475[(2)] = inst_73346);

(statearr_73396_73475[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (50))){
var inst_73373 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73397_73476 = state_73384__$1;
(statearr_73397_73476[(2)] = inst_73373);

(statearr_73397_73476[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (21))){
var inst_73277 = (state_73384[(14)]);
var state_73384__$1 = state_73384;
if(cljs.core.truth_(inst_73277)){
var statearr_73398_73477 = state_73384__$1;
(statearr_73398_73477[(1)] = (23));

} else {
var statearr_73399_73478 = state_73384__$1;
(statearr_73399_73478[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (31))){
var inst_73335 = (state_73384[(2)]);
var inst_73336 = cljs.core.not.call(null,inst_73335);
var state_73384__$1 = state_73384;
if(inst_73336){
var statearr_73400_73479 = state_73384__$1;
(statearr_73400_73479[(1)] = (35));

} else {
var statearr_73401_73480 = state_73384__$1;
(statearr_73401_73480[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (32))){
var inst_73279 = (state_73384[(15)]);
var state_73384__$1 = state_73384;
var statearr_73402_73481 = state_73384__$1;
(statearr_73402_73481[(2)] = inst_73279);

(statearr_73402_73481[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (40))){
var inst_73309 = (state_73384[(16)]);
var state_73384__$1 = state_73384;
if(cljs.core.truth_(inst_73309)){
var statearr_73403_73482 = state_73384__$1;
(statearr_73403_73482[(1)] = (42));

} else {
var statearr_73404_73483 = state_73384__$1;
(statearr_73404_73483[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (33))){
var inst_73275 = (state_73384[(17)]);
var state_73384__$1 = state_73384;
var statearr_73405_73484 = state_73384__$1;
(statearr_73405_73484[(2)] = inst_73275);

(statearr_73405_73484[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (13))){
var inst_73280 = (state_73384[(18)]);
var inst_73304 = (state_73384[(19)]);
var inst_73302 = (state_73384[(2)]);
var inst_73303 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73304__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_73280);
var state_73384__$1 = (function (){var statearr_73406 = state_73384;
(statearr_73406[(20)] = inst_73302);

(statearr_73406[(19)] = inst_73304__$1);

(statearr_73406[(21)] = inst_73303);

return statearr_73406;
})();
if(cljs.core.truth_(inst_73304__$1)){
var statearr_73407_73485 = state_73384__$1;
(statearr_73407_73485[(1)] = (14));

} else {
var statearr_73408_73486 = state_73384__$1;
(statearr_73408_73486[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (22))){
var inst_73325 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73409_73487 = state_73384__$1;
(statearr_73409_73487[(2)] = inst_73325);

(statearr_73409_73487[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (36))){
var inst_73292 = (state_73384[(22)]);
var inst_73311 = (state_73384[(23)]);
var inst_73342 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_73311);
var inst_73343 = fluree.db.query.fql.query.call(null,inst_73292,inst_73342);
var state_73384__$1 = state_73384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73384__$1,(38),inst_73343);
} else {
if((state_val_73385 === (41))){
var inst_73377 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73410_73488 = state_73384__$1;
(statearr_73410_73488[(2)] = inst_73377);

(statearr_73410_73488[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (43))){
var state_73384__$1 = state_73384;
var statearr_73411_73489 = state_73384__$1;
(statearr_73411_73489[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (29))){
var inst_73279 = (state_73384[(15)]);
var state_73384__$1 = state_73384;
if(cljs.core.truth_(inst_73279)){
var statearr_73413_73490 = state_73384__$1;
(statearr_73413_73490[(1)] = (32));

} else {
var statearr_73414_73491 = state_73384__$1;
(statearr_73414_73491[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (44))){
var inst_73375 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73415_73492 = state_73384__$1;
(statearr_73415_73492[(2)] = inst_73375);

(statearr_73415_73492[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (6))){
var inst_73274 = (state_73384[(8)]);
var inst_73283 = (state_73384[(2)]);
var inst_73284 = fluree.db.util.async.throw_err.call(null,inst_73283);
var state_73384__$1 = (function (){var statearr_73416 = state_73384;
(statearr_73416[(7)] = inst_73284);

return statearr_73416;
})();
if(cljs.core.truth_(inst_73274)){
var statearr_73417_73493 = state_73384__$1;
(statearr_73417_73493[(1)] = (7));

} else {
var statearr_73418_73494 = state_73384__$1;
(statearr_73418_73494[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (28))){
var inst_73321 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73419_73495 = state_73384__$1;
(statearr_73419_73495[(2)] = inst_73321);

(statearr_73419_73495[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (25))){
var inst_73323 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73420_73496 = state_73384__$1;
(statearr_73420_73496[(2)] = inst_73323);

(statearr_73420_73496[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (34))){
var inst_73332 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
var statearr_73421_73497 = state_73384__$1;
(statearr_73421_73497[(2)] = inst_73332);

(statearr_73421_73497[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (17))){
var inst_73273 = (state_73384[(24)]);
var state_73384__$1 = state_73384;
var statearr_73422_73498 = state_73384__$1;
(statearr_73422_73498[(2)] = inst_73273);

(statearr_73422_73498[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (3))){
var inst_73382 = (state_73384[(2)]);
var state_73384__$1 = state_73384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73384__$1,inst_73382);
} else {
if((state_val_73385 === (12))){
var inst_73300 = cljs.core.PersistentHashMap.EMPTY;
var state_73384__$1 = state_73384;
var statearr_73423_73499 = state_73384__$1;
(statearr_73423_73499[(2)] = inst_73300);

(statearr_73423_73499[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (2))){
var _ = (function (){var statearr_73424 = state_73384;
(statearr_73424[(4)] = cljs.core.cons.call(null,(5),(state_73384[(4)])));

return statearr_73424;
})();
var inst_73270 = query_map;
var inst_73271 = cljs.core.__destructure_map.call(null,inst_73270);
var inst_73272 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_73273 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_73274 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73275 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_73276 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_73277 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_73278 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_73279 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_73280 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_73281 = cljs.core.get.call(null,inst_73271,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_73384__$1 = (function (){var statearr_73425 = state_73384;
(statearr_73425[(11)] = inst_73281);

(statearr_73425[(18)] = inst_73280);

(statearr_73425[(24)] = inst_73273);

(statearr_73425[(17)] = inst_73275);

(statearr_73425[(14)] = inst_73277);

(statearr_73425[(25)] = inst_73276);

(statearr_73425[(15)] = inst_73279);

(statearr_73425[(8)] = inst_73274);

(statearr_73425[(9)] = inst_73278);

(statearr_73425[(10)] = inst_73272);

return statearr_73425;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73384__$1,(6),sources);
} else {
if((state_val_73385 === (23))){
var inst_73277 = (state_73384[(14)]);
var state_73384__$1 = state_73384;
var statearr_73426_73500 = state_73384__$1;
(statearr_73426_73500[(2)] = inst_73277);

(statearr_73426_73500[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (47))){
var inst_73357 = (state_73384[(26)]);
var inst_73310 = (state_73384[(27)]);
var inst_73303 = (state_73384[(21)]);
var inst_73292 = (state_73384[(22)]);
var inst_73363 = (state_73384[(2)]);
var inst_73364 = cljs.core.deref.call(null,inst_73303);
var inst_73365 = fluree.db.util.core.response_time_formatted.call(null,inst_73310);
var inst_73366 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73292);
var inst_73367 = [(200),inst_73363,inst_73364,inst_73365,inst_73366];
var inst_73368 = cljs.core.PersistentHashMap.fromArrays(inst_73357,inst_73367);
var state_73384__$1 = state_73384;
var statearr_73427_73501 = state_73384__$1;
(statearr_73427_73501[(2)] = inst_73368);

(statearr_73427_73501[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (35))){
var inst_73338 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73339 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73340 = cljs.core.PersistentHashMap.fromArrays(inst_73338,inst_73339);
var state_73384__$1 = state_73384;
var statearr_73428_73502 = state_73384__$1;
(statearr_73428_73502[(2)] = inst_73340);

(statearr_73428_73502[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (19))){
var inst_73327 = (state_73384[(28)]);
var inst_73327__$1 = (state_73384[(2)]);
var state_73384__$1 = (function (){var statearr_73429 = state_73384;
(statearr_73429[(28)] = inst_73327__$1);

return statearr_73429;
})();
if(cljs.core.truth_(inst_73327__$1)){
var statearr_73430_73503 = state_73384__$1;
(statearr_73430_73503[(1)] = (29));

} else {
var statearr_73431_73504 = state_73384__$1;
(statearr_73431_73504[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (11))){
var inst_73276 = (state_73384[(25)]);
var inst_73293 = (state_73384[(29)]);
var inst_73292 = (state_73384[(22)]);
var inst_73295 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_73292);
var inst_73296 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_73293);
var inst_73297 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_73292);
var inst_73298 = fluree.db.api_js.get_sources.call(null,inst_73293,inst_73295,inst_73296,inst_73297,inst_73276,db_fn);
var state_73384__$1 = state_73384;
var statearr_73433_73505 = state_73384__$1;
(statearr_73433_73505[(2)] = inst_73298);

(statearr_73433_73505[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (9))){
var inst_73276 = (state_73384[(25)]);
var inst_73292 = (state_73384[(22)]);
var inst_73292__$1 = (state_73384[(2)]);
var inst_73293 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_73292__$1);
var state_73384__$1 = (function (){var statearr_73434 = state_73384;
(statearr_73434[(29)] = inst_73293);

(statearr_73434[(22)] = inst_73292__$1);

return statearr_73434;
})();
if(cljs.core.truth_(inst_73276)){
var statearr_73435_73506 = state_73384__$1;
(statearr_73435_73506[(1)] = (11));

} else {
var statearr_73436_73507 = state_73384__$1;
(statearr_73436_73507[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (5))){
var _ = (function (){var statearr_73437 = state_73384;
(statearr_73437[(4)] = cljs.core.rest.call(null,(state_73384[(4)])));

return statearr_73437;
})();
var state_73384__$1 = state_73384;
var ex73432 = (state_73384__$1[(2)]);
var statearr_73438_73508 = state_73384__$1;
(statearr_73438_73508[(5)] = ex73432);


var statearr_73439_73509 = state_73384__$1;
(statearr_73439_73509[(1)] = (4));

(statearr_73439_73509[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (14))){
var inst_73304 = (state_73384[(19)]);
var state_73384__$1 = state_73384;
var statearr_73440_73510 = state_73384__$1;
(statearr_73440_73510[(2)] = inst_73304);

(statearr_73440_73510[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (45))){
var inst_73346 = (state_73384[(12)]);
var inst_73360 = cljs.core.doall.call(null,inst_73346);
var state_73384__$1 = state_73384;
var statearr_73441_73511 = state_73384__$1;
(statearr_73441_73511[(2)] = inst_73360);

(statearr_73441_73511[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (26))){
var inst_73281 = (state_73384[(11)]);
var state_73384__$1 = state_73384;
var statearr_73442_73512 = state_73384__$1;
(statearr_73442_73512[(2)] = inst_73281);

(statearr_73442_73512[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (16))){
var inst_73302 = (state_73384[(20)]);
var inst_73280 = (state_73384[(18)]);
var inst_73273 = (state_73384[(24)]);
var inst_73303 = (state_73384[(21)]);
var inst_73308 = (state_73384[(2)]);
var inst_73309 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_73280);
var inst_73310 = fluree.db.util.core.current_time_millis.call(null);
var inst_73311 = cljs.core.assoc.call(null,inst_73280,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_73302,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_73308,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_73303);
var state_73384__$1 = (function (){var statearr_73443 = state_73384;
(statearr_73443[(16)] = inst_73309);

(statearr_73443[(27)] = inst_73310);

(statearr_73443[(23)] = inst_73311);

return statearr_73443;
})();
if(cljs.core.truth_(inst_73273)){
var statearr_73444_73513 = state_73384__$1;
(statearr_73444_73513[(1)] = (17));

} else {
var statearr_73445_73514 = state_73384__$1;
(statearr_73445_73514[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (38))){
var inst_73346 = (state_73384[(12)]);
var inst_73345 = (state_73384[(2)]);
var inst_73346__$1 = fluree.db.util.async.throw_err.call(null,inst_73345);
var inst_73347 = (inst_73346__$1 instanceof cljs.core.ExceptionInfo);
var state_73384__$1 = (function (){var statearr_73446 = state_73384;
(statearr_73446[(12)] = inst_73346__$1);

return statearr_73446;
})();
if(cljs.core.truth_(inst_73347)){
var statearr_73447_73515 = state_73384__$1;
(statearr_73447_73515[(1)] = (39));

} else {
var statearr_73448_73516 = state_73384__$1;
(statearr_73448_73516[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (30))){
var inst_73327 = (state_73384[(28)]);
var state_73384__$1 = state_73384;
var statearr_73449_73517 = state_73384__$1;
(statearr_73449_73517[(2)] = inst_73327);

(statearr_73449_73517[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (10))){
var inst_73288 = (state_73384[(2)]);
var inst_73289 = fluree.db.util.async.throw_err.call(null,inst_73288);
var state_73384__$1 = state_73384;
var statearr_73450_73518 = state_73384__$1;
(statearr_73450_73518[(2)] = inst_73289);

(statearr_73450_73518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (18))){
var inst_73278 = (state_73384[(9)]);
var state_73384__$1 = state_73384;
if(cljs.core.truth_(inst_73278)){
var statearr_73451_73519 = state_73384__$1;
(statearr_73451_73519[(1)] = (20));

} else {
var statearr_73452_73520 = state_73384__$1;
(statearr_73452_73520[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (42))){
var inst_73346 = (state_73384[(12)]);
var inst_73357 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73358 = cljs.core.sequential_QMARK_.call(null,inst_73346);
var state_73384__$1 = (function (){var statearr_73453 = state_73384;
(statearr_73453[(26)] = inst_73357);

return statearr_73453;
})();
if(inst_73358){
var statearr_73454_73521 = state_73384__$1;
(statearr_73454_73521[(1)] = (45));

} else {
var statearr_73455_73522 = state_73384__$1;
(statearr_73455_73522[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (37))){
var inst_73379 = (state_73384[(2)]);
var _ = (function (){var statearr_73456 = state_73384;
(statearr_73456[(4)] = cljs.core.rest.call(null,(state_73384[(4)])));

return statearr_73456;
})();
var state_73384__$1 = state_73384;
var statearr_73457_73523 = state_73384__$1;
(statearr_73457_73523[(2)] = inst_73379);

(statearr_73457_73523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (8))){
var inst_73284 = (state_73384[(7)]);
var state_73384__$1 = state_73384;
var statearr_73458_73524 = state_73384__$1;
(statearr_73458_73524[(2)] = inst_73284);

(statearr_73458_73524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73385 === (49))){
var state_73384__$1 = state_73384;
var statearr_73459_73525 = state_73384__$1;
(statearr_73459_73525[(2)] = null);

(statearr_73459_73525[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_73460 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73460[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_73460[(1)] = (1));

return statearr_73460;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_73384){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73461){var ex__10906__auto__ = e73461;
var statearr_73462_73526 = state_73384;
(statearr_73462_73526[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73384[(4)]))){
var statearr_73463_73527 = state_73384;
(statearr_73463_73527[(1)] = cljs.core.first.call(null,(state_73384[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73528 = state_73384;
state_73384 = G__73528;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_73384){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_73384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73464 = f__10977__auto__.call(null);
(statearr_73464[(6)] = c__10976__auto__);

return statearr_73464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__73529_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__73529_SHARP_);
}));

var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73551){
var state_val_73552 = (state_73551[(1)]);
if((state_val_73552 === (1))){
var inst_73533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73534 = [resp_chan,timeout_chan];
var inst_73535 = (new cljs.core.PersistentVector(null,2,(5),inst_73533,inst_73534,null));
var state_73551__$1 = state_73551;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73551__$1,(2),inst_73535);
} else {
if((state_val_73552 === (2))){
var inst_73537 = (state_73551[(2)]);
var inst_73538 = cljs.core.nth.call(null,inst_73537,(0),null);
var inst_73539 = cljs.core.nth.call(null,inst_73537,(1),null);
var inst_73540 = cljs.core._EQ_.call(null,timeout_chan,inst_73539);
var state_73551__$1 = (function (){var statearr_73553 = state_73551;
(statearr_73553[(7)] = inst_73538);

return statearr_73553;
})();
if(inst_73540){
var statearr_73554_73564 = state_73551__$1;
(statearr_73554_73564[(1)] = (3));

} else {
var statearr_73555_73565 = state_73551__$1;
(statearr_73555_73565[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73552 === (3))){
var inst_73542 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_73543 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_73544 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_73545 = [tid,(408),inst_73544];
var inst_73546 = cljs.core.PersistentHashMap.fromArrays(inst_73543,inst_73545);
var state_73551__$1 = (function (){var statearr_73556 = state_73551;
(statearr_73556[(8)] = inst_73542);

return statearr_73556;
})();
var statearr_73557_73566 = state_73551__$1;
(statearr_73557_73566[(2)] = inst_73546);

(statearr_73557_73566[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73552 === (4))){
var inst_73538 = (state_73551[(7)]);
var state_73551__$1 = state_73551;
var statearr_73558_73567 = state_73551__$1;
(statearr_73558_73567[(2)] = inst_73538);

(statearr_73558_73567[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73552 === (5))){
var inst_73549 = (state_73551[(2)]);
var state_73551__$1 = state_73551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73551__$1,inst_73549);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____0 = (function (){
var statearr_73559 = [null,null,null,null,null,null,null,null,null];
(statearr_73559[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__);

(statearr_73559[(1)] = (1));

return statearr_73559;
});
var fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____1 = (function (state_73551){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73560){var ex__10906__auto__ = e73560;
var statearr_73561_73568 = state_73551;
(statearr_73561_73568[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73551[(4)]))){
var statearr_73562_73569 = state_73551;
(statearr_73562_73569[(1)] = cljs.core.first.call(null,(state_73551[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73570 = state_73551;
state_73551 = G__73570;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__ = function(state_73551){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____1.call(this,state_73551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__10903__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73563 = f__10977__auto__.call(null);
(statearr_73563[(6)] = c__10976__auto__);

return statearr_73563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__73572 = arguments.length;
switch (G__73572) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__73573 = opts;
var map__73573__$1 = cljs.core.__destructure_map.call(null,map__73573);
var auth = cljs.core.get.call(null,map__73573__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__73573__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__73573__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__73573__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__73574 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__73574,(0),null);
var authority = cljs.core.nth.call(null,vec__73574,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e73577){var e = e73577;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__73580 = arguments.length;
switch (G__73580) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73646){
var state_val_73647 = (state_73646[(1)]);
if((state_val_73647 === (7))){
var inst_73597 = (state_73646[(7)]);
var inst_73601 = (state_73646[(8)]);
var inst_73602 = (state_73646[(9)]);
var inst_73600 = (state_73646[(10)]);
var inst_73599 = (state_73646[(11)]);
var inst_73615 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73616 = [ledger,txn,inst_73597,inst_73599,inst_73600,inst_73601,inst_73602];
var inst_73617 = cljs.core.PersistentHashMap.fromArrays(inst_73615,inst_73616);
var inst_73618 = fluree.db.util.core.without_nils.call(null,inst_73617);
var inst_73619 = fluree.db.operations.transact_async.call(null,conn,inst_73618);
var state_73646__$1 = state_73646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73646__$1,(13),inst_73619);
} else {
if((state_val_73647 === (20))){
var inst_73637 = (state_73646[(2)]);
var state_73646__$1 = state_73646;
var statearr_73648_73684 = state_73646__$1;
(statearr_73648_73684[(2)] = inst_73637);

(statearr_73648_73684[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (1))){
var state_73646__$1 = state_73646;
var statearr_73649_73685 = state_73646__$1;
(statearr_73649_73685[(2)] = null);

(statearr_73649_73685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (4))){
var inst_73581 = (state_73646[(2)]);
var inst_73582 = fluree.db.util.log.error.call(null,inst_73581);
var inst_73583 = cljs.core.ex_data.call(null,inst_73581);
var inst_73584 = cljs.core.ex_message.call(null,inst_73581);
var inst_73585 = cljs.core.assoc.call(null,inst_73583,new cljs.core.Keyword(null,"message","message",-406056002),inst_73584);
var state_73646__$1 = (function (){var statearr_73650 = state_73646;
(statearr_73650[(12)] = inst_73582);

return statearr_73650;
})();
var statearr_73651_73686 = state_73646__$1;
(statearr_73651_73686[(2)] = inst_73585);

(statearr_73651_73686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (15))){
var inst_73596 = (state_73646[(13)]);
var inst_73621 = (state_73646[(14)]);
var inst_73624 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_73621,inst_73596);
var state_73646__$1 = state_73646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73646__$1,(17),inst_73624);
} else {
if((state_val_73647 === (13))){
var inst_73595 = (state_73646[(15)]);
var inst_73621 = (state_73646[(2)]);
var state_73646__$1 = (function (){var statearr_73652 = state_73646;
(statearr_73652[(14)] = inst_73621);

return statearr_73652;
})();
if(cljs.core.truth_(inst_73595)){
var statearr_73653_73687 = state_73646__$1;
(statearr_73653_73687[(1)] = (14));

} else {
var statearr_73654_73688 = state_73646__$1;
(statearr_73654_73688[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (6))){
var inst_73595 = (state_73646[(15)]);
var inst_73594 = (state_73646[(16)]);
var inst_73604 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_73594,opts);
var inst_73605 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_73604);
var inst_73606 = fluree.db.operations.command_async.call(null,conn,inst_73604);
var state_73646__$1 = (function (){var statearr_73655 = state_73646;
(statearr_73655[(17)] = inst_73605);

(statearr_73655[(18)] = inst_73606);

return statearr_73655;
})();
if(cljs.core.truth_(inst_73595)){
var statearr_73656_73689 = state_73646__$1;
(statearr_73656_73689[(1)] = (9));

} else {
var statearr_73657_73690 = state_73646__$1;
(statearr_73657_73690[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (17))){
var inst_73626 = (state_73646[(19)]);
var inst_73626__$1 = (state_73646[(2)]);
var inst_73627 = (inst_73626__$1 instanceof cljs.core.ExceptionInfo);
var state_73646__$1 = (function (){var statearr_73658 = state_73646;
(statearr_73658[(19)] = inst_73626__$1);

return statearr_73658;
})();
if(cljs.core.truth_(inst_73627)){
var statearr_73659_73691 = state_73646__$1;
(statearr_73659_73691[(1)] = (18));

} else {
var statearr_73660_73692 = state_73646__$1;
(statearr_73660_73692[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (3))){
var inst_73644 = (state_73646[(2)]);
var state_73646__$1 = state_73646;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73646__$1,inst_73644);
} else {
if((state_val_73647 === (12))){
var inst_73611 = (state_73646[(2)]);
var state_73646__$1 = state_73646;
var statearr_73661_73693 = state_73646__$1;
(statearr_73661_73693[(2)] = inst_73611);

(statearr_73661_73693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (2))){
var inst_73594 = (state_73646[(16)]);
var _ = (function (){var statearr_73662 = state_73646;
(statearr_73662[(4)] = cljs.core.cons.call(null,(5),(state_73646[(4)])));

return statearr_73662;
})();
var inst_73592 = opts;
var inst_73593 = cljs.core.__destructure_map.call(null,inst_73592);
var inst_73594__$1 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73595 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_73596 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73597 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73598 = fluree.db.util.core.current_time_millis.call(null);
var inst_73599 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_73598);
var inst_73600 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_73601 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73602 = cljs.core.get.call(null,inst_73593,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73646__$1 = (function (){var statearr_73663 = state_73646;
(statearr_73663[(15)] = inst_73595);

(statearr_73663[(7)] = inst_73597);

(statearr_73663[(16)] = inst_73594__$1);

(statearr_73663[(8)] = inst_73601);

(statearr_73663[(13)] = inst_73596);

(statearr_73663[(9)] = inst_73602);

(statearr_73663[(10)] = inst_73600);

(statearr_73663[(11)] = inst_73599);

return statearr_73663;
})();
if(cljs.core.truth_(inst_73594__$1)){
var statearr_73664_73694 = state_73646__$1;
(statearr_73664_73694[(1)] = (6));

} else {
var statearr_73665_73695 = state_73646__$1;
(statearr_73665_73695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (19))){
var inst_73626 = (state_73646[(19)]);
var state_73646__$1 = state_73646;
var statearr_73666_73696 = state_73646__$1;
(statearr_73666_73696[(2)] = inst_73626);

(statearr_73666_73696[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (11))){
var inst_73613 = (state_73646[(2)]);
var state_73646__$1 = state_73646;
var statearr_73668_73697 = state_73646__$1;
(statearr_73668_73697[(2)] = inst_73613);

(statearr_73668_73697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (9))){
var inst_73606 = (state_73646[(18)]);
var state_73646__$1 = state_73646;
var statearr_73669_73698 = state_73646__$1;
(statearr_73669_73698[(2)] = inst_73606);

(statearr_73669_73698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (5))){
var _ = (function (){var statearr_73670 = state_73646;
(statearr_73670[(4)] = cljs.core.rest.call(null,(state_73646[(4)])));

return statearr_73670;
})();
var state_73646__$1 = state_73646;
var ex73667 = (state_73646__$1[(2)]);
var statearr_73671_73699 = state_73646__$1;
(statearr_73671_73699[(5)] = ex73667);


var statearr_73672_73700 = state_73646__$1;
(statearr_73672_73700[(1)] = (4));

(statearr_73672_73700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (14))){
var inst_73621 = (state_73646[(14)]);
var state_73646__$1 = state_73646;
var statearr_73673_73701 = state_73646__$1;
(statearr_73673_73701[(2)] = inst_73621);

(statearr_73673_73701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (16))){
var inst_73639 = (state_73646[(2)]);
var state_73646__$1 = state_73646;
var statearr_73674_73702 = state_73646__$1;
(statearr_73674_73702[(2)] = inst_73639);

(statearr_73674_73702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (10))){
var inst_73605 = (state_73646[(17)]);
var inst_73596 = (state_73646[(13)]);
var inst_73609 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_73605,inst_73596);
var state_73646__$1 = state_73646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73646__$1,(12),inst_73609);
} else {
if((state_val_73647 === (18))){
var inst_73626 = (state_73646[(19)]);
var inst_73629 = cljs.core.ex_data.call(null,inst_73626);
var inst_73630 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73631 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73629);
var inst_73632 = cljs.core.ex_message.call(null,inst_73626);
var inst_73633 = [inst_73631,inst_73632,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73634 = cljs.core.PersistentHashMap.fromArrays(inst_73630,inst_73633);
var state_73646__$1 = state_73646;
var statearr_73675_73703 = state_73646__$1;
(statearr_73675_73703[(2)] = inst_73634);

(statearr_73675_73703[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73647 === (8))){
var inst_73641 = (state_73646[(2)]);
var _ = (function (){var statearr_73676 = state_73646;
(statearr_73676[(4)] = cljs.core.rest.call(null,(state_73646[(4)])));

return statearr_73676;
})();
var state_73646__$1 = state_73646;
var statearr_73677_73704 = state_73646__$1;
(statearr_73677_73704[(2)] = inst_73641);

(statearr_73677_73704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_73678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73678[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_73678[(1)] = (1));

return statearr_73678;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_73646){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73646);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73679){var ex__10906__auto__ = e73679;
var statearr_73680_73705 = state_73646;
(statearr_73680_73705[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73646[(4)]))){
var statearr_73681_73706 = state_73646;
(statearr_73681_73706[(1)] = cljs.core.first.call(null,(state_73646[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73707 = state_73646;
state_73646 = G__73707;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_73646){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_73646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73682 = f__10977__auto__.call(null);
(statearr_73682[(6)] = c__10976__auto__);

return statearr_73682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73709 = arguments.length;
var i__4865__auto___73710 = (0);
while(true){
if((i__4865__auto___73710 < len__4864__auto___73709)){
args__4870__auto__.push((arguments[i__4865__auto___73710]));

var G__73711 = (i__4865__auto___73710 + (1));
i__4865__auto___73710 = G__73711;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq73708){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73708));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73742){
var state_val_73743 = (state_73742[(1)]);
if((state_val_73743 === (1))){
var inst_73712 = cljs.core.first.call(null,flakes);
var inst_73713 = cljs.core.rest.call(null,flakes);
var inst_73714 = cljs.core.PersistentVector.EMPTY;
var inst_73715 = inst_73712;
var inst_73716 = inst_73713;
var inst_73717 = inst_73714;
var state_73742__$1 = (function (){var statearr_73744 = state_73742;
(statearr_73744[(7)] = inst_73717);

(statearr_73744[(8)] = inst_73715);

(statearr_73744[(9)] = inst_73716);

return statearr_73744;
})();
var statearr_73745_73758 = state_73742__$1;
(statearr_73745_73758[(2)] = null);

(statearr_73745_73758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73743 === (2))){
var inst_73715 = (state_73742[(8)]);
var inst_73719 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73720 = cljs.core.PersistentHashMap.EMPTY;
var inst_73721 = [true,inst_73720];
var inst_73722 = cljs.core.PersistentHashMap.fromArrays(inst_73719,inst_73721);
var inst_73723 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_73722,inst_73715);
var state_73742__$1 = state_73742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73742__$1,(4),inst_73723);
} else {
if((state_val_73743 === (3))){
var inst_73740 = (state_73742[(2)]);
var state_73742__$1 = state_73742;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73742__$1,inst_73740);
} else {
if((state_val_73743 === (4))){
var inst_73717 = (state_73742[(7)]);
var inst_73716 = (state_73742[(9)]);
var inst_73725 = (state_73742[(2)]);
var inst_73726 = fluree.db.util.async.throw_err.call(null,inst_73725);
var inst_73727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73728 = [inst_73726];
var inst_73729 = (new cljs.core.PersistentVector(null,1,(5),inst_73727,inst_73728,null));
var inst_73730 = cljs.core.concat.call(null,inst_73717,inst_73729);
var inst_73731 = cljs.core.first.call(null,inst_73716);
var state_73742__$1 = (function (){var statearr_73746 = state_73742;
(statearr_73746[(10)] = inst_73730);

return statearr_73746;
})();
if(cljs.core.truth_(inst_73731)){
var statearr_73747_73759 = state_73742__$1;
(statearr_73747_73759[(1)] = (5));

} else {
var statearr_73748_73760 = state_73742__$1;
(statearr_73748_73760[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73743 === (5))){
var inst_73730 = (state_73742[(10)]);
var inst_73716 = (state_73742[(9)]);
var inst_73733 = cljs.core.first.call(null,inst_73716);
var inst_73734 = cljs.core.rest.call(null,inst_73716);
var inst_73715 = inst_73733;
var inst_73716__$1 = inst_73734;
var inst_73717 = inst_73730;
var state_73742__$1 = (function (){var statearr_73749 = state_73742;
(statearr_73749[(7)] = inst_73717);

(statearr_73749[(8)] = inst_73715);

(statearr_73749[(9)] = inst_73716__$1);

return statearr_73749;
})();
var statearr_73750_73761 = state_73742__$1;
(statearr_73750_73761[(2)] = null);

(statearr_73750_73761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73743 === (6))){
var inst_73730 = (state_73742[(10)]);
var state_73742__$1 = state_73742;
var statearr_73751_73762 = state_73742__$1;
(statearr_73751_73762[(2)] = inst_73730);

(statearr_73751_73762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73743 === (7))){
var inst_73738 = (state_73742[(2)]);
var state_73742__$1 = state_73742;
var statearr_73752_73763 = state_73742__$1;
(statearr_73752_73763[(2)] = inst_73738);

(statearr_73752_73763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____0 = (function (){
var statearr_73753 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73753[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__);

(statearr_73753[(1)] = (1));

return statearr_73753;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____1 = (function (state_73742){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73742);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73754){var ex__10906__auto__ = e73754;
var statearr_73755_73764 = state_73742;
(statearr_73755_73764[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73742[(4)]))){
var statearr_73756_73765 = state_73742;
(statearr_73756_73765[(1)] = cljs.core.first.call(null,(state_73742[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73766 = state_73742;
state_73742 = G__73766;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__ = function(state_73742){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____1.call(this,state_73742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73757 = f__10977__auto__.call(null);
(statearr_73757[(6)] = c__10976__auto__);

return statearr_73757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73834){
var state_val_73835 = (state_73834[(1)]);
if((state_val_73835 === (7))){
var inst_73794 = (state_73834[(2)]);
var inst_73795 = fluree.db.util.async.throw_err.call(null,inst_73794);
var state_73834__$1 = state_73834;
var statearr_73836_73862 = state_73834__$1;
(statearr_73836_73862[(2)] = inst_73795);

(statearr_73836_73862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (1))){
var inst_73771 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73772 = cljs.core.PersistentHashMap.EMPTY;
var inst_73773 = cljs.core.volatile_BANG_.call(null,inst_73772);
var inst_73774 = cljs.core.first.call(null,resp);
var inst_73775 = cljs.core.rest.call(null,resp);
var inst_73776 = cljs.core.PersistentVector.EMPTY;
var inst_73777 = inst_73771;
var inst_73778 = inst_73773;
var inst_73779 = inst_73774;
var inst_73780 = inst_73775;
var inst_73781 = inst_73776;
var state_73834__$1 = (function (){var statearr_73837 = state_73834;
(statearr_73837[(7)] = inst_73778);

(statearr_73837[(8)] = inst_73781);

(statearr_73837[(9)] = inst_73777);

(statearr_73837[(10)] = inst_73779);

(statearr_73837[(11)] = inst_73780);

return statearr_73837;
})();
var statearr_73838_73863 = state_73834__$1;
(statearr_73838_73863[(2)] = null);

(statearr_73838_73863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (4))){
var inst_73778 = (state_73834[(7)]);
var inst_73781 = (state_73834[(8)]);
var inst_73777 = (state_73834[(9)]);
var inst_73779 = (state_73834[(10)]);
var inst_73783 = (state_73834[(12)]);
var inst_73780 = (state_73834[(11)]);
var inst_73785 = (state_73834[(13)]);
var inst_73789 = (function (){var fuel = inst_73777;
var cache = inst_73778;
var curr_block = inst_73779;
var rest_blocks = inst_73780;
var acc = inst_73781;
var flakes = inst_73783;
var asserted = inst_73785;
return (function (p1__73768_SHARP_){
return p1__73768_SHARP_.s;
});
})();
var inst_73790 = cljs.core.group_by.call(null,inst_73789,inst_73785);
var inst_73791 = cljs.core.vals.call(null,inst_73790);
var inst_73792 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73778,inst_73777,inst_73791);
var state_73834__$1 = state_73834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73834__$1,(7),inst_73792);
} else {
if((state_val_73835 === (13))){
var inst_73822 = (state_73834[(14)]);
var state_73834__$1 = state_73834;
var statearr_73839_73864 = state_73834__$1;
(statearr_73839_73864[(2)] = inst_73822);

(statearr_73839_73864[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (6))){
var inst_73800 = (state_73834[(15)]);
var inst_73778 = (state_73834[(7)]);
var inst_73798 = (state_73834[(16)]);
var inst_73781 = (state_73834[(8)]);
var inst_73777 = (state_73834[(9)]);
var inst_73779 = (state_73834[(10)]);
var inst_73783 = (state_73834[(12)]);
var inst_73780 = (state_73834[(11)]);
var inst_73785 = (state_73834[(13)]);
var inst_73798__$1 = (state_73834[(2)]);
var inst_73799 = (function (){var fuel = inst_73777;
var cache = inst_73778;
var curr_block = inst_73779;
var rest_blocks = inst_73780;
var acc = inst_73781;
var flakes = inst_73783;
var asserted = inst_73785;
var asserted_SINGLEQUOTE_ = inst_73798__$1;
return (function (p1__73769_SHARP_){
return p1__73769_SHARP_.op === false;
});
})();
var inst_73800__$1 = cljs.core.filter.call(null,inst_73799,inst_73783);
var inst_73801 = cljs.core.empty_QMARK_.call(null,inst_73800__$1);
var inst_73802 = (!(inst_73801));
var state_73834__$1 = (function (){var statearr_73842 = state_73834;
(statearr_73842[(15)] = inst_73800__$1);

(statearr_73842[(16)] = inst_73798__$1);

return statearr_73842;
})();
if(inst_73802){
var statearr_73843_73865 = state_73834__$1;
(statearr_73843_73865[(1)] = (8));

} else {
var statearr_73844_73866 = state_73834__$1;
(statearr_73844_73866[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (3))){
var inst_73832 = (state_73834[(2)]);
var state_73834__$1 = state_73834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73834__$1,inst_73832);
} else {
if((state_val_73835 === (12))){
var inst_73822 = (state_73834[(14)]);
var inst_73778 = (state_73834[(7)]);
var inst_73777 = (state_73834[(9)]);
var inst_73780 = (state_73834[(11)]);
var inst_73825 = cljs.core.first.call(null,inst_73780);
var inst_73826 = cljs.core.rest.call(null,inst_73780);
var tmp73840 = inst_73778;
var tmp73841 = inst_73777;
var inst_73777__$1 = tmp73841;
var inst_73778__$1 = tmp73840;
var inst_73779 = inst_73825;
var inst_73780__$1 = inst_73826;
var inst_73781 = inst_73822;
var state_73834__$1 = (function (){var statearr_73845 = state_73834;
(statearr_73845[(7)] = inst_73778__$1);

(statearr_73845[(8)] = inst_73781);

(statearr_73845[(9)] = inst_73777__$1);

(statearr_73845[(10)] = inst_73779);

(statearr_73845[(11)] = inst_73780__$1);

return statearr_73845;
})();
var statearr_73846_73867 = state_73834__$1;
(statearr_73846_73867[(2)] = null);

(statearr_73846_73867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (2))){
var inst_73778 = (state_73834[(7)]);
var inst_73781 = (state_73834[(8)]);
var inst_73777 = (state_73834[(9)]);
var inst_73779 = (state_73834[(10)]);
var inst_73783 = (state_73834[(12)]);
var inst_73780 = (state_73834[(11)]);
var inst_73785 = (state_73834[(13)]);
var inst_73783__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73779);
var inst_73784 = (function (){var fuel = inst_73777;
var cache = inst_73778;
var curr_block = inst_73779;
var rest_blocks = inst_73780;
var acc = inst_73781;
var flakes = inst_73783__$1;
return (function (p1__73767_SHARP_){
return p1__73767_SHARP_.op;
});
})();
var inst_73785__$1 = cljs.core.filter.call(null,inst_73784,inst_73783__$1);
var inst_73786 = cljs.core.empty_QMARK_.call(null,inst_73785__$1);
var inst_73787 = (!(inst_73786));
var state_73834__$1 = (function (){var statearr_73847 = state_73834;
(statearr_73847[(12)] = inst_73783__$1);

(statearr_73847[(13)] = inst_73785__$1);

return statearr_73847;
})();
if(inst_73787){
var statearr_73848_73868 = state_73834__$1;
(statearr_73848_73868[(1)] = (4));

} else {
var statearr_73849_73869 = state_73834__$1;
(statearr_73849_73869[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (11))){
var inst_73810 = (state_73834[(2)]);
var inst_73811 = fluree.db.util.async.throw_err.call(null,inst_73810);
var state_73834__$1 = state_73834;
var statearr_73850_73870 = state_73834__$1;
(statearr_73850_73870[(2)] = inst_73811);

(statearr_73850_73870[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (9))){
var state_73834__$1 = state_73834;
var statearr_73851_73871 = state_73834__$1;
(statearr_73851_73871[(2)] = null);

(statearr_73851_73871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (5))){
var state_73834__$1 = state_73834;
var statearr_73852_73872 = state_73834__$1;
(statearr_73852_73872[(2)] = null);

(statearr_73852_73872[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (14))){
var inst_73830 = (state_73834[(2)]);
var state_73834__$1 = state_73834;
var statearr_73853_73873 = state_73834__$1;
(statearr_73853_73873[(2)] = inst_73830);

(statearr_73853_73873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (10))){
var inst_73798 = (state_73834[(16)]);
var inst_73781 = (state_73834[(8)]);
var inst_73779 = (state_73834[(10)]);
var inst_73780 = (state_73834[(11)]);
var inst_73814 = (state_73834[(2)]);
var inst_73815 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73816 = [inst_73798,inst_73814];
var inst_73817 = cljs.core.PersistentHashMap.fromArrays(inst_73815,inst_73816);
var inst_73818 = cljs.core.assoc.call(null,inst_73779,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73817);
var inst_73819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73820 = [inst_73818];
var inst_73821 = (new cljs.core.PersistentVector(null,1,(5),inst_73819,inst_73820,null));
var inst_73822 = cljs.core.concat.call(null,inst_73781,inst_73821);
var inst_73823 = cljs.core.first.call(null,inst_73780);
var state_73834__$1 = (function (){var statearr_73854 = state_73834;
(statearr_73854[(14)] = inst_73822);

return statearr_73854;
})();
if(cljs.core.truth_(inst_73823)){
var statearr_73855_73874 = state_73834__$1;
(statearr_73855_73874[(1)] = (12));

} else {
var statearr_73856_73875 = state_73834__$1;
(statearr_73856_73875[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73835 === (8))){
var inst_73800 = (state_73834[(15)]);
var inst_73778 = (state_73834[(7)]);
var inst_73798 = (state_73834[(16)]);
var inst_73781 = (state_73834[(8)]);
var inst_73777 = (state_73834[(9)]);
var inst_73779 = (state_73834[(10)]);
var inst_73783 = (state_73834[(12)]);
var inst_73780 = (state_73834[(11)]);
var inst_73785 = (state_73834[(13)]);
var inst_73804 = (function (){var flakes = inst_73783;
var rest_blocks = inst_73780;
var curr_block = inst_73779;
var asserted_SINGLEQUOTE_ = inst_73798;
var acc = inst_73781;
var fuel = inst_73777;
var cache = inst_73778;
var retracted = inst_73800;
var asserted = inst_73785;
return (function (p1__73770_SHARP_){
return p1__73770_SHARP_.s;
});
})();
var inst_73805 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_73800);
var inst_73806 = cljs.core.group_by.call(null,inst_73804,inst_73805);
var inst_73807 = cljs.core.vals.call(null,inst_73806);
var inst_73808 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73778,inst_73777,inst_73807);
var state_73834__$1 = state_73834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73834__$1,(11),inst_73808);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____0 = (function (){
var statearr_73857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73857[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__);

(statearr_73857[(1)] = (1));

return statearr_73857;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____1 = (function (state_73834){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73858){var ex__10906__auto__ = e73858;
var statearr_73859_73876 = state_73834;
(statearr_73859_73876[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73834[(4)]))){
var statearr_73860_73877 = state_73834;
(statearr_73860_73877[(1)] = cljs.core.first.call(null,(state_73834[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73878 = state_73834;
state_73834 = G__73878;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__ = function(state_73834){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____1.call(this,state_73834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73861 = f__10977__auto__.call(null);
(statearr_73861[(6)] = c__10976__auto__);

return statearr_73861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73978){
var state_val_73979 = (state_73978[(1)]);
if((state_val_73979 === (7))){
var inst_73950 = (state_73978[(7)]);
var inst_73943 = (state_73978[(8)]);
var inst_73949 = cljs.core.seq.call(null,inst_73943);
var inst_73950__$1 = cljs.core.first.call(null,inst_73949);
var inst_73951 = cljs.core.next.call(null,inst_73949);
var state_73978__$1 = (function (){var statearr_73980 = state_73978;
(statearr_73980[(7)] = inst_73950__$1);

(statearr_73980[(9)] = inst_73951);

return statearr_73980;
})();
if(cljs.core.truth_(inst_73950__$1)){
var statearr_73981_74018 = state_73978__$1;
(statearr_73981_74018[(1)] = (9));

} else {
var statearr_73982_74019 = state_73978__$1;
(statearr_73982_74019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (1))){
var state_73978__$1 = state_73978;
var statearr_73983_74020 = state_73978__$1;
(statearr_73983_74020[(2)] = null);

(statearr_73983_74020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (4))){
var inst_73880 = (state_73978[(2)]);
var state_73978__$1 = state_73978;
var statearr_73984_74021 = state_73978__$1;
(statearr_73984_74021[(2)] = inst_73880);

(statearr_73984_74021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (6))){
var inst_73929 = (state_73978[(2)]);
var inst_73930 = fluree.db.util.async.throw_err.call(null,inst_73929);
var inst_73938 = resp;
var inst_73939 = cljs.core.seq.call(null,inst_73938);
var inst_73940 = cljs.core.first.call(null,inst_73939);
var inst_73941 = cljs.core.next.call(null,inst_73939);
var inst_73942 = cljs.core.PersistentHashMap.EMPTY;
var inst_73943 = inst_73938;
var inst_73944 = inst_73942;
var state_73978__$1 = (function (){var statearr_73985 = state_73978;
(statearr_73985[(8)] = inst_73943);

(statearr_73985[(10)] = inst_73944);

(statearr_73985[(11)] = inst_73930);

(statearr_73985[(12)] = inst_73940);

(statearr_73985[(13)] = inst_73941);

return statearr_73985;
})();
var statearr_73986_74022 = state_73978__$1;
(statearr_73986_74022[(2)] = null);

(statearr_73986_74022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (3))){
var inst_73976 = (state_73978[(2)]);
var state_73978__$1 = state_73978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73978__$1,inst_73976);
} else {
if((state_val_73979 === (2))){
var _ = (function (){var statearr_73987 = state_73978;
(statearr_73987[(4)] = cljs.core.cons.call(null,(5),(state_73978[(4)])));

return statearr_73987;
})();
var inst_73886 = (function (){return (function (p1__73879_SHARP_){
return p1__73879_SHARP_.t;
});
})();
var inst_73887 = cljs.core.map.call(null,inst_73886,resp);
var inst_73888 = cljs.core.set.call(null,inst_73887);
var inst_73925 = cljs.core.async.chan.call(null,(1));
var inst_73926 = (function (){var ts = inst_73888;
var c__10976__auto____$1 = inst_73925;
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73923){
var state_val_73924 = (state_73923[(1)]);
if((state_val_73924 === (1))){
var inst_73896 = ts;
var inst_73897 = cljs.core.seq.call(null,inst_73896);
var inst_73898 = cljs.core.first.call(null,inst_73897);
var inst_73899 = cljs.core.next.call(null,inst_73897);
var inst_73900 = cljs.core.PersistentHashMap.EMPTY;
var inst_73901 = inst_73896;
var inst_73902 = inst_73900;
var state_73923__$1 = (function (){var statearr_73988 = state_73923;
(statearr_73988[(7)] = inst_73899);

(statearr_73988[(8)] = inst_73901);

(statearr_73988[(9)] = inst_73898);

(statearr_73988[(10)] = inst_73902);

return statearr_73988;
})();
var statearr_73989_74023 = state_73923__$1;
(statearr_73989_74023[(2)] = null);

(statearr_73989_74023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73924 === (2))){
var inst_73901 = (state_73923[(8)]);
var inst_73908 = (state_73923[(11)]);
var inst_73907 = cljs.core.seq.call(null,inst_73901);
var inst_73908__$1 = cljs.core.first.call(null,inst_73907);
var inst_73909 = cljs.core.next.call(null,inst_73907);
var state_73923__$1 = (function (){var statearr_73990 = state_73923;
(statearr_73990[(11)] = inst_73908__$1);

(statearr_73990[(12)] = inst_73909);

return statearr_73990;
})();
if(cljs.core.truth_(inst_73908__$1)){
var statearr_73991_74024 = state_73923__$1;
(statearr_73991_74024[(1)] = (4));

} else {
var statearr_73992_74025 = state_73923__$1;
(statearr_73992_74025[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73924 === (3))){
var inst_73921 = (state_73923[(2)]);
var state_73923__$1 = state_73923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73923__$1,inst_73921);
} else {
if((state_val_73924 === (4))){
var inst_73908 = (state_73923[(11)]);
var inst_73911 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_73908);
var state_73923__$1 = state_73923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73923__$1,(7),inst_73911);
} else {
if((state_val_73924 === (5))){
var inst_73902 = (state_73923[(10)]);
var state_73923__$1 = state_73923;
var statearr_73993_74026 = state_73923__$1;
(statearr_73993_74026[(2)] = inst_73902);

(statearr_73993_74026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73924 === (6))){
var inst_73919 = (state_73923[(2)]);
var state_73923__$1 = state_73923;
var statearr_73994_74027 = state_73923__$1;
(statearr_73994_74027[(2)] = inst_73919);

(statearr_73994_74027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73924 === (7))){
var inst_73902 = (state_73923[(10)]);
var inst_73908 = (state_73923[(11)]);
var inst_73909 = (state_73923[(12)]);
var inst_73913 = (state_73923[(2)]);
var inst_73914 = fluree.db.util.async.throw_err.call(null,inst_73913);
var inst_73915 = cljs.core.assoc.call(null,inst_73902,inst_73908,inst_73914);
var inst_73901 = inst_73909;
var inst_73902__$1 = inst_73915;
var state_73923__$1 = (function (){var statearr_73995 = state_73923;
(statearr_73995[(8)] = inst_73901);

(statearr_73995[(10)] = inst_73902__$1);

return statearr_73995;
})();
var statearr_73996_74028 = state_73923__$1;
(statearr_73996_74028[(2)] = null);

(statearr_73996_74028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0 = (function (){
var statearr_73997 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73997[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__);

(statearr_73997[(1)] = (1));

return statearr_73997;
});
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1 = (function (state_73923){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73998){var ex__10906__auto__ = e73998;
var statearr_73999_74029 = state_73923;
(statearr_73999_74029[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73923[(4)]))){
var statearr_74000_74030 = state_73923;
(statearr_74000_74030[(1)] = cljs.core.first.call(null,(state_73923[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74031 = state_73923;
state_73923 = G__74031;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__ = function(state_73923){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1.call(this,state_73923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74001 = f__10977__auto__.call(null);
(statearr_74001[(6)] = c__10976__auto____$1);

return statearr_74001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});
})();
var inst_73927 = cljs.core.async.impl.dispatch.run.call(null,inst_73926);
var state_73978__$1 = (function (){var statearr_74002 = state_73978;
(statearr_74002[(14)] = inst_73927);

return statearr_74002;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73978__$1,(6),inst_73925);
} else {
if((state_val_73979 === (11))){
var inst_73970 = (state_73978[(2)]);
var state_73978__$1 = state_73978;
var statearr_74004_74032 = state_73978__$1;
(statearr_74004_74032[(2)] = inst_73970);

(statearr_74004_74032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (9))){
var inst_73950 = (state_73978[(7)]);
var inst_73951 = (state_73978[(9)]);
var inst_73944 = (state_73978[(10)]);
var inst_73930 = (state_73978[(11)]);
var inst_73953 = inst_73950.t;
var inst_73954 = cljs.core.get.call(null,inst_73930,inst_73953);
var inst_73955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73956 = [inst_73954,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73957 = (new cljs.core.PersistentVector(null,2,(5),inst_73955,inst_73956,null));
var inst_73958 = cljs.core.assoc_in.call(null,inst_73944,inst_73957,inst_73954);
var inst_73959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73960 = [inst_73954,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73961 = (new cljs.core.PersistentVector(null,2,(5),inst_73959,inst_73960,null));
var inst_73962 = cljs.core.update_in.call(null,inst_73958,inst_73961,cljs.core.conj,inst_73950);
var inst_73963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73964 = [inst_73954,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73965 = (new cljs.core.PersistentVector(null,2,(5),inst_73963,inst_73964,null));
var inst_73966 = cljs.core.update_in.call(null,inst_73962,inst_73965,fluree.db.api_js.min_safe,inst_73953);
var inst_73943 = inst_73951;
var inst_73944__$1 = inst_73966;
var state_73978__$1 = (function (){var statearr_74005 = state_73978;
(statearr_74005[(8)] = inst_73943);

(statearr_74005[(10)] = inst_73944__$1);

return statearr_74005;
})();
var statearr_74006_74033 = state_73978__$1;
(statearr_74006_74033[(2)] = null);

(statearr_74006_74033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (5))){
var _ = (function (){var statearr_74007 = state_73978;
(statearr_74007[(4)] = cljs.core.rest.call(null,(state_73978[(4)])));

return statearr_74007;
})();
var state_73978__$1 = state_73978;
var ex74003 = (state_73978__$1[(2)]);
var statearr_74008_74034 = state_73978__$1;
(statearr_74008_74034[(5)] = ex74003);


if((ex74003 instanceof Error)){
var statearr_74009_74035 = state_73978__$1;
(statearr_74009_74035[(1)] = (4));

(statearr_74009_74035[(5)] = null);

} else {
throw ex74003;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (10))){
var inst_73944 = (state_73978[(10)]);
var state_73978__$1 = state_73978;
var statearr_74010_74036 = state_73978__$1;
(statearr_74010_74036[(2)] = inst_73944);

(statearr_74010_74036[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73979 === (8))){
var inst_73972 = (state_73978[(2)]);
var inst_73973 = cljs.core.vals.call(null,inst_73972);
var _ = (function (){var statearr_74011 = state_73978;
(statearr_74011[(4)] = cljs.core.rest.call(null,(state_73978[(4)])));

return statearr_74011;
})();
var state_73978__$1 = state_73978;
var statearr_74012_74037 = state_73978__$1;
(statearr_74012_74037[(2)] = inst_73973);

(statearr_74012_74037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0 = (function (){
var statearr_74013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74013[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__);

(statearr_74013[(1)] = (1));

return statearr_74013;
});
var fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1 = (function (state_73978){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74014){var ex__10906__auto__ = e74014;
var statearr_74015_74038 = state_73978;
(statearr_74015_74038[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73978[(4)]))){
var statearr_74016_74039 = state_73978;
(statearr_74016_74039[(1)] = cljs.core.first.call(null,(state_73978[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74040 = state_73978;
state_73978 = G__74040;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__ = function(state_73978){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1.call(this,state_73978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__10903__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74017 = f__10977__auto__.call(null);
(statearr_74017[(6)] = c__10976__auto__);

return statearr_74017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_74185){
var state_val_74186 = (state_74185[(1)]);
if((state_val_74186 === (7))){
var inst_74065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74066 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74067 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74068 = [inst_74066,inst_74067];
var inst_74069 = (new cljs.core.PersistentVector(null,2,(5),inst_74065,inst_74068,null));
var state_74185__$1 = state_74185;
var statearr_74187_74258 = state_74185__$1;
(statearr_74187_74258[(2)] = inst_74069);

(statearr_74187_74258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (20))){
var inst_74095 = (state_74185[(7)]);
var state_74185__$1 = state_74185;
var statearr_74188_74259 = state_74185__$1;
(statearr_74188_74259[(2)] = inst_74095);

(statearr_74188_74259[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (27))){
var state_74185__$1 = state_74185;
var statearr_74189_74260 = state_74185__$1;
(statearr_74189_74260[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (1))){
var state_74185__$1 = state_74185;
var statearr_74191_74261 = state_74185__$1;
(statearr_74191_74261[(2)] = null);

(statearr_74191_74261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (24))){
var inst_74094 = (state_74185[(8)]);
var state_74185__$1 = state_74185;
if(cljs.core.truth_(inst_74094)){
var statearr_74192_74262 = state_74185__$1;
(statearr_74192_74262[(1)] = (26));

} else {
var statearr_74193_74263 = state_74185__$1;
(statearr_74193_74263[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (39))){
var inst_74141 = (state_74185[(9)]);
var inst_74140 = (state_74185[(10)]);
var inst_74166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74167 = [inst_74140,inst_74141];
var inst_74168 = (new cljs.core.PersistentVector(null,2,(5),inst_74166,inst_74167,null));
var state_74185__$1 = state_74185;
var statearr_74194_74264 = state_74185__$1;
(statearr_74194_74264[(2)] = inst_74168);

(statearr_74194_74264[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (4))){
var inst_74041 = (state_74185[(2)]);
var inst_74042 = fluree.db.util.log.error.call(null,inst_74041);
var inst_74043 = cljs.core.ex_data.call(null,inst_74041);
var inst_74044 = cljs.core.ex_message.call(null,inst_74041);
var inst_74045 = cljs.core.assoc.call(null,inst_74043,new cljs.core.Keyword(null,"message","message",-406056002),inst_74044);
var state_74185__$1 = (function (){var statearr_74195 = state_74185;
(statearr_74195[(11)] = inst_74042);

return statearr_74195;
})();
var statearr_74196_74265 = state_74185__$1;
(statearr_74196_74265[(2)] = inst_74045);

(statearr_74196_74265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (15))){
var inst_74079 = (state_74185[(12)]);
var inst_74074 = (state_74185[(13)]);
var inst_74088 = (state_74185[(2)]);
var inst_74089 = [inst_74079,inst_74088];
var inst_74090 = (new cljs.core.PersistentVector(null,2,(5),inst_74074,inst_74089,null));
var state_74185__$1 = state_74185;
var statearr_74197_74266 = state_74185__$1;
(statearr_74197_74266[(2)] = inst_74090);

(statearr_74197_74266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (21))){
var inst_74094 = (state_74185[(8)]);
var state_74185__$1 = state_74185;
var statearr_74198_74267 = state_74185__$1;
(statearr_74198_74267[(2)] = inst_74094);

(statearr_74198_74267[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (31))){
var inst_74135 = (state_74185[(2)]);
var state_74185__$1 = state_74185;
var statearr_74199_74268 = state_74185__$1;
(statearr_74199_74268[(2)] = inst_74135);

(statearr_74199_74268[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (32))){
var inst_74141 = (state_74185[(9)]);
var inst_74144 = cljs.core.pos_int_QMARK_.call(null,inst_74141);
var state_74185__$1 = state_74185;
var statearr_74200_74269 = state_74185__$1;
(statearr_74200_74269[(2)] = inst_74144);

(statearr_74200_74269[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (40))){
var inst_74096 = (state_74185[(14)]);
var inst_74172 = (state_74185[(15)]);
var inst_74170 = (state_74185[(2)]);
var inst_74171 = cljs.core.nth.call(null,inst_74170,(0),null);
var inst_74172__$1 = cljs.core.nth.call(null,inst_74170,(1),null);
var inst_74173 = (inst_74172__$1 > inst_74096);
var state_74185__$1 = (function (){var statearr_74201 = state_74185;
(statearr_74201[(16)] = inst_74171);

(statearr_74201[(15)] = inst_74172__$1);

return statearr_74201;
})();
if(cljs.core.truth_(inst_74173)){
var statearr_74202_74270 = state_74185__$1;
(statearr_74202_74270[(1)] = (41));

} else {
var statearr_74203_74271 = state_74185__$1;
(statearr_74203_74271[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (33))){
var inst_74142 = (state_74185[(17)]);
var state_74185__$1 = state_74185;
var statearr_74204_74272 = state_74185__$1;
(statearr_74204_74272[(2)] = inst_74142);

(statearr_74204_74272[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (13))){
var inst_74080 = (state_74185[(18)]);
var inst_74082 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_74080);
var state_74185__$1 = state_74185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74185__$1,(16),inst_74082);
} else {
if((state_val_74186 === (22))){
var inst_74113 = (state_74185[(2)]);
var state_74185__$1 = state_74185;
if(cljs.core.truth_(inst_74113)){
var statearr_74205_74273 = state_74185__$1;
(statearr_74205_74273[(1)] = (23));

} else {
var statearr_74206_74274 = state_74185__$1;
(statearr_74206_74274[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (36))){
var state_74185__$1 = state_74185;
var statearr_74207_74275 = state_74185__$1;
(statearr_74207_74275[(2)] = null);

(statearr_74207_74275[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (41))){
var inst_74096 = (state_74185[(14)]);
var state_74185__$1 = state_74185;
var statearr_74208_74276 = state_74185__$1;
(statearr_74208_74276[(2)] = inst_74096);

(statearr_74208_74276[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (43))){
var inst_74171 = (state_74185[(16)]);
var inst_74177 = (state_74185[(2)]);
var inst_74178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74179 = [inst_74171,inst_74177];
var inst_74180 = (new cljs.core.PersistentVector(null,2,(5),inst_74178,inst_74179,null));
var _ = (function (){var statearr_74209 = state_74185;
(statearr_74209[(4)] = cljs.core.rest.call(null,(state_74185[(4)])));

return statearr_74209;
})();
var state_74185__$1 = state_74185;
var statearr_74210_74277 = state_74185__$1;
(statearr_74210_74277[(2)] = inst_74180);

(statearr_74210_74277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (29))){
var inst_74071 = (state_74185[(19)]);
var inst_74126 = cljs.core.pr_str.call(null,inst_74071);
var inst_74127 = ["Invalid block range provided: ",inst_74126].join('');
var inst_74128 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74129 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74130 = cljs.core.PersistentHashMap.fromArrays(inst_74128,inst_74129);
var inst_74131 = cljs.core.ex_info.call(null,inst_74127,inst_74130);
var inst_74132 = (function(){throw inst_74131})();
var state_74185__$1 = state_74185;
var statearr_74211_74278 = state_74185__$1;
(statearr_74211_74278[(2)] = inst_74132);

(statearr_74211_74278[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (6))){
var inst_74063 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74185__$1 = state_74185;
var statearr_74212_74279 = state_74185__$1;
(statearr_74212_74279[(2)] = inst_74063);

(statearr_74212_74279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (28))){
var inst_74137 = (state_74185[(2)]);
var state_74185__$1 = state_74185;
var statearr_74213_74280 = state_74185__$1;
(statearr_74213_74280[(2)] = inst_74137);

(statearr_74213_74280[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (25))){
var inst_74142 = (state_74185[(17)]);
var inst_74140 = (state_74185[(10)]);
var inst_74139 = (state_74185[(2)]);
var inst_74140__$1 = cljs.core.nth.call(null,inst_74139,(0),null);
var inst_74141 = cljs.core.nth.call(null,inst_74139,(1),null);
var inst_74142__$1 = cljs.core.pos_int_QMARK_.call(null,inst_74140__$1);
var state_74185__$1 = (function (){var statearr_74214 = state_74185;
(statearr_74214[(17)] = inst_74142__$1);

(statearr_74214[(9)] = inst_74141);

(statearr_74214[(10)] = inst_74140__$1);

return statearr_74214;
})();
if(inst_74142__$1){
var statearr_74215_74281 = state_74185__$1;
(statearr_74215_74281[(1)] = (32));

} else {
var statearr_74216_74282 = state_74185__$1;
(statearr_74216_74282[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (34))){
var inst_74147 = (state_74185[(2)]);
var inst_74148 = cljs.core.not.call(null,inst_74147);
var state_74185__$1 = state_74185;
if(inst_74148){
var statearr_74217_74283 = state_74185__$1;
(statearr_74217_74283[(1)] = (35));

} else {
var statearr_74218_74284 = state_74185__$1;
(statearr_74218_74284[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (17))){
var inst_74094 = (state_74185[(8)]);
var inst_74096 = (state_74185[(14)]);
var inst_74099 = cljs.core.pr_str.call(null,inst_74094);
var inst_74100 = cljs.core.pr_str.call(null,inst_74096);
var inst_74101 = ["Start block is out of range for this ledger. Start block provided: ",inst_74099,". Database block: ",inst_74100].join('');
var inst_74102 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74103 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74104 = cljs.core.PersistentHashMap.fromArrays(inst_74102,inst_74103);
var inst_74105 = cljs.core.ex_info.call(null,inst_74101,inst_74104);
var inst_74106 = (function(){throw inst_74105})();
var state_74185__$1 = state_74185;
var statearr_74219_74285 = state_74185__$1;
(statearr_74219_74285[(2)] = inst_74106);

(statearr_74219_74285[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (3))){
var inst_74183 = (state_74185[(2)]);
var state_74185__$1 = state_74185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74185__$1,inst_74183);
} else {
if((state_val_74186 === (12))){
var inst_74080 = (state_74185[(18)]);
var inst_74071 = (state_74185[(19)]);
var inst_74078 = (state_74185[(2)]);
var inst_74079 = fluree.db.util.async.throw_err.call(null,inst_74078);
var inst_74080__$1 = cljs.core.second.call(null,inst_74071);
var state_74185__$1 = (function (){var statearr_74220 = state_74185;
(statearr_74220[(18)] = inst_74080__$1);

(statearr_74220[(12)] = inst_74079);

return statearr_74220;
})();
if(cljs.core.truth_(inst_74080__$1)){
var statearr_74221_74286 = state_74185__$1;
(statearr_74221_74286[(1)] = (13));

} else {
var statearr_74222_74287 = state_74185__$1;
(statearr_74222_74287[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (2))){
var _ = (function (){var statearr_74223 = state_74185;
(statearr_74223[(4)] = cljs.core.cons.call(null,(5),(state_74185[(4)])));

return statearr_74223;
})();
var inst_74060 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_74061 = cljs.core.sequential_QMARK_.call(null,inst_74060);
var state_74185__$1 = state_74185;
if(inst_74061){
var statearr_74224_74288 = state_74185__$1;
(statearr_74224_74288[(1)] = (6));

} else {
var statearr_74225_74289 = state_74185__$1;
(statearr_74225_74289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (23))){
var inst_74094 = (state_74185[(8)]);
var inst_74095 = (state_74185[(7)]);
var inst_74115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74116 = [inst_74094,inst_74095];
var inst_74117 = (new cljs.core.PersistentVector(null,2,(5),inst_74115,inst_74116,null));
var state_74185__$1 = state_74185;
var statearr_74226_74290 = state_74185__$1;
(statearr_74226_74290[(2)] = inst_74117);

(statearr_74226_74290[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (35))){
var inst_74071 = (state_74185[(19)]);
var inst_74150 = cljs.core.pr_str.call(null,inst_74071);
var inst_74151 = ["Invalid block range provided: ",inst_74150].join('');
var inst_74152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74153 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74154 = cljs.core.PersistentHashMap.fromArrays(inst_74152,inst_74153);
var inst_74155 = cljs.core.ex_info.call(null,inst_74151,inst_74154);
var inst_74156 = (function(){throw inst_74155})();
var state_74185__$1 = state_74185;
var statearr_74227_74291 = state_74185__$1;
(statearr_74227_74291[(2)] = inst_74156);

(statearr_74227_74291[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (19))){
var inst_74094 = (state_74185[(8)]);
var inst_74109 = (state_74185[(2)]);
var state_74185__$1 = (function (){var statearr_74228 = state_74185;
(statearr_74228[(20)] = inst_74109);

return statearr_74228;
})();
if(cljs.core.truth_(inst_74094)){
var statearr_74229_74292 = state_74185__$1;
(statearr_74229_74292[(1)] = (20));

} else {
var statearr_74230_74293 = state_74185__$1;
(statearr_74230_74293[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (11))){
var inst_74094 = (state_74185[(8)]);
var inst_74096 = (state_74185[(14)]);
var inst_74093 = (state_74185[(2)]);
var inst_74094__$1 = cljs.core.nth.call(null,inst_74093,(0),null);
var inst_74095 = cljs.core.nth.call(null,inst_74093,(1),null);
var inst_74096__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74097 = (inst_74094__$1 > inst_74096__$1);
var state_74185__$1 = (function (){var statearr_74232 = state_74185;
(statearr_74232[(8)] = inst_74094__$1);

(statearr_74232[(14)] = inst_74096__$1);

(statearr_74232[(7)] = inst_74095);

return statearr_74232;
})();
if(cljs.core.truth_(inst_74097)){
var statearr_74233_74294 = state_74185__$1;
(statearr_74233_74294[(1)] = (17));

} else {
var statearr_74234_74295 = state_74185__$1;
(statearr_74234_74295[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (9))){
var inst_74071 = (state_74185[(19)]);
var inst_74074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74075 = cljs.core.first.call(null,inst_74071);
var inst_74076 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_74075);
var state_74185__$1 = (function (){var statearr_74235 = state_74185;
(statearr_74235[(13)] = inst_74074);

return statearr_74235;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74185__$1,(12),inst_74076);
} else {
if((state_val_74186 === (5))){
var _ = (function (){var statearr_74236 = state_74185;
(statearr_74236[(4)] = cljs.core.rest.call(null,(state_74185[(4)])));

return statearr_74236;
})();
var state_74185__$1 = state_74185;
var ex74231 = (state_74185__$1[(2)]);
var statearr_74237_74296 = state_74185__$1;
(statearr_74237_74296[(5)] = ex74231);


var statearr_74238_74297 = state_74185__$1;
(statearr_74238_74297[(1)] = (4));

(statearr_74238_74297[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (14))){
var state_74185__$1 = state_74185;
var statearr_74239_74298 = state_74185__$1;
(statearr_74239_74298[(2)] = null);

(statearr_74239_74298[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (26))){
var inst_74094 = (state_74185[(8)]);
var inst_74120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74121 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_74122 = [inst_74094,inst_74121];
var inst_74123 = (new cljs.core.PersistentVector(null,2,(5),inst_74120,inst_74122,null));
var state_74185__$1 = state_74185;
var statearr_74240_74299 = state_74185__$1;
(statearr_74240_74299[(2)] = inst_74123);

(statearr_74240_74299[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (16))){
var inst_74084 = (state_74185[(2)]);
var inst_74085 = fluree.db.util.async.throw_err.call(null,inst_74084);
var state_74185__$1 = state_74185;
var statearr_74241_74300 = state_74185__$1;
(statearr_74241_74300[(2)] = inst_74085);

(statearr_74241_74300[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (38))){
var inst_74141 = (state_74185[(9)]);
var inst_74140 = (state_74185[(10)]);
var inst_74162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74163 = [inst_74141,inst_74140];
var inst_74164 = (new cljs.core.PersistentVector(null,2,(5),inst_74162,inst_74163,null));
var state_74185__$1 = state_74185;
var statearr_74242_74301 = state_74185__$1;
(statearr_74242_74301[(2)] = inst_74164);

(statearr_74242_74301[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (30))){
var state_74185__$1 = state_74185;
var statearr_74243_74302 = state_74185__$1;
(statearr_74243_74302[(2)] = null);

(statearr_74243_74302[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (10))){
var inst_74071 = (state_74185[(19)]);
var state_74185__$1 = state_74185;
var statearr_74244_74303 = state_74185__$1;
(statearr_74244_74303[(2)] = inst_74071);

(statearr_74244_74303[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (18))){
var state_74185__$1 = state_74185;
var statearr_74245_74304 = state_74185__$1;
(statearr_74245_74304[(2)] = null);

(statearr_74245_74304[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (42))){
var inst_74172 = (state_74185[(15)]);
var state_74185__$1 = state_74185;
var statearr_74246_74305 = state_74185__$1;
(statearr_74246_74305[(2)] = inst_74172);

(statearr_74246_74305[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (37))){
var inst_74141 = (state_74185[(9)]);
var inst_74140 = (state_74185[(10)]);
var inst_74159 = (state_74185[(2)]);
var inst_74160 = (inst_74141 < inst_74140);
var state_74185__$1 = (function (){var statearr_74247 = state_74185;
(statearr_74247[(21)] = inst_74159);

return statearr_74247;
})();
if(cljs.core.truth_(inst_74160)){
var statearr_74248_74306 = state_74185__$1;
(statearr_74248_74306[(1)] = (38));

} else {
var statearr_74249_74307 = state_74185__$1;
(statearr_74249_74307[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74186 === (8))){
var inst_74071 = (state_74185[(19)]);
var inst_74071__$1 = (state_74185[(2)]);
var inst_74072 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_74071__$1);
var state_74185__$1 = (function (){var statearr_74250 = state_74185;
(statearr_74250[(19)] = inst_74071__$1);

return statearr_74250;
})();
if(cljs.core.truth_(inst_74072)){
var statearr_74251_74308 = state_74185__$1;
(statearr_74251_74308[(1)] = (9));

} else {
var statearr_74252_74309 = state_74185__$1;
(statearr_74252_74309[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____0 = (function (){
var statearr_74253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74253[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__);

(statearr_74253[(1)] = (1));

return statearr_74253;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____1 = (function (state_74185){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_74185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74254){var ex__10906__auto__ = e74254;
var statearr_74255_74310 = state_74185;
(statearr_74255_74310[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_74185[(4)]))){
var statearr_74256_74311 = state_74185;
(statearr_74256_74311[(1)] = cljs.core.first.call(null,(state_74185[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74312 = state_74185;
state_74185 = G__74312;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__ = function(state_74185){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____1.call(this,state_74185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74257 = f__10977__auto__.call(null);
(statearr_74257[(6)] = c__10976__auto__);

return statearr_74257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__74314 = arguments.length;
switch (G__74314) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_74405){
var state_val_74406 = (state_74405[(1)]);
if((state_val_74406 === (7))){
var inst_74337 = (state_74405[(7)]);
var inst_74340 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_74337);
var state_74405__$1 = state_74405;
var statearr_74407_74458 = state_74405__$1;
(statearr_74407_74458[(2)] = inst_74340);

(statearr_74407_74458[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (20))){
var inst_74376 = (state_74405[(8)]);
var inst_74379 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_74376);
var state_74405__$1 = state_74405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74405__$1,(23),inst_74379);
} else {
if((state_val_74406 === (27))){
var inst_74385 = (state_74405[(9)]);
var inst_74391 = cljs.core.doall.call(null,inst_74385);
var state_74405__$1 = state_74405;
var statearr_74408_74459 = state_74405__$1;
(statearr_74408_74459[(2)] = inst_74391);

(statearr_74408_74459[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (1))){
var state_74405__$1 = state_74405;
var statearr_74409_74460 = state_74405__$1;
(statearr_74409_74460[(2)] = null);

(statearr_74409_74460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (24))){
var inst_74385 = (state_74405[(9)]);
var inst_74388 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_74389 = cljs.core.sequential_QMARK_.call(null,inst_74385);
var state_74405__$1 = (function (){var statearr_74410 = state_74405;
(statearr_74410[(10)] = inst_74388);

return statearr_74410;
})();
if(inst_74389){
var statearr_74411_74461 = state_74405__$1;
(statearr_74411_74461[(1)] = (27));

} else {
var statearr_74412_74462 = state_74405__$1;
(statearr_74412_74462[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (4))){
var inst_74315 = (state_74405[(2)]);
var inst_74316 = fluree.db.util.log.error.call(null,inst_74315);
var inst_74317 = cljs.core.ex_data.call(null,inst_74315);
var inst_74318 = cljs.core.ex_message.call(null,inst_74315);
var inst_74319 = cljs.core.assoc.call(null,inst_74317,new cljs.core.Keyword(null,"message","message",-406056002),inst_74318);
var state_74405__$1 = (function (){var statearr_74413 = state_74405;
(statearr_74413[(11)] = inst_74316);

return statearr_74413;
})();
var statearr_74414_74463 = state_74405__$1;
(statearr_74414_74463[(2)] = inst_74319);

(statearr_74414_74463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (15))){
var inst_74337 = (state_74405[(7)]);
var inst_74350 = (state_74405[(2)]);
var inst_74351 = cljs.core.ex_info.call(null,inst_74350,inst_74337);
var inst_74352 = (function(){throw inst_74351})();
var state_74405__$1 = state_74405;
var statearr_74415_74464 = state_74405__$1;
(statearr_74415_74464[(2)] = inst_74352);

(statearr_74415_74464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (21))){
var inst_74376 = (state_74405[(8)]);
var state_74405__$1 = state_74405;
var statearr_74416_74465 = state_74405__$1;
(statearr_74416_74465[(2)] = inst_74376);

(statearr_74416_74465[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (13))){
var inst_74345 = (state_74405[(12)]);
var state_74405__$1 = state_74405;
var statearr_74417_74466 = state_74405__$1;
(statearr_74417_74466[(2)] = inst_74345);

(statearr_74417_74466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (22))){
var inst_74385 = (state_74405[(2)]);
var inst_74386 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74405__$1 = (function (){var statearr_74418 = state_74405;
(statearr_74418[(9)] = inst_74385);

return statearr_74418;
})();
if(cljs.core.truth_(inst_74386)){
var statearr_74419_74467 = state_74405__$1;
(statearr_74419_74467[(1)] = (24));

} else {
var statearr_74420_74468 = state_74405__$1;
(statearr_74420_74468[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (29))){
var inst_74388 = (state_74405[(10)]);
var inst_74329 = (state_74405[(13)]);
var inst_74394 = (state_74405[(2)]);
var inst_74395 = fluree.db.util.core.response_time_formatted.call(null,inst_74329);
var inst_74396 = [(200),inst_74394,(100),inst_74395];
var inst_74397 = cljs.core.PersistentHashMap.fromArrays(inst_74388,inst_74396);
var state_74405__$1 = state_74405;
var statearr_74421_74469 = state_74405__$1;
(statearr_74421_74469[(2)] = inst_74397);

(statearr_74421_74469[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (6))){
var inst_74337 = (state_74405[(7)]);
var inst_74338 = (state_74405[(14)]);
var inst_74336 = (state_74405[(2)]);
var inst_74337__$1 = fluree.db.util.async.throw_err.call(null,inst_74336);
var inst_74338__$1 = cljs.core.map_QMARK_.call(null,inst_74337__$1);
var state_74405__$1 = (function (){var statearr_74422 = state_74405;
(statearr_74422[(7)] = inst_74337__$1);

(statearr_74422[(14)] = inst_74338__$1);

return statearr_74422;
})();
if(inst_74338__$1){
var statearr_74423_74470 = state_74405__$1;
(statearr_74423_74470[(1)] = (7));

} else {
var statearr_74424_74471 = state_74405__$1;
(statearr_74424_74471[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (28))){
var inst_74385 = (state_74405[(9)]);
var state_74405__$1 = state_74405;
var statearr_74425_74472 = state_74405__$1;
(statearr_74425_74472[(2)] = inst_74385);

(statearr_74425_74472[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (25))){
var inst_74385 = (state_74405[(9)]);
var state_74405__$1 = state_74405;
var statearr_74426_74473 = state_74405__$1;
(statearr_74426_74473[(2)] = inst_74385);

(statearr_74426_74473[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (17))){
var inst_74368 = cljs.core.pr_str.call(null,query_map);
var inst_74369 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_74368].join('');
var inst_74370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74371 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74372 = cljs.core.PersistentHashMap.fromArrays(inst_74370,inst_74371);
var inst_74373 = cljs.core.ex_info.call(null,inst_74369,inst_74372);
var inst_74374 = (function(){throw inst_74373})();
var state_74405__$1 = state_74405;
var statearr_74427_74474 = state_74405__$1;
(statearr_74427_74474[(2)] = inst_74374);

(statearr_74427_74474[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (3))){
var inst_74403 = (state_74405[(2)]);
var state_74405__$1 = state_74405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74405__$1,inst_74403);
} else {
if((state_val_74406 === (12))){
var inst_74337 = (state_74405[(7)]);
var inst_74355 = (state_74405[(2)]);
var inst_74356 = cljs.core.nth.call(null,inst_74337,(0),null);
var inst_74357 = cljs.core.nth.call(null,inst_74337,(1),null);
var inst_74358 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_74359 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_74360 = cljs.core.keys.call(null,inst_74359);
var inst_74361 = cljs.core._EQ_.call(null,inst_74358,inst_74360);
var state_74405__$1 = (function (){var statearr_74428 = state_74405;
(statearr_74428[(15)] = inst_74355);

(statearr_74428[(16)] = inst_74356);

(statearr_74428[(17)] = inst_74357);

return statearr_74428;
})();
if(inst_74361){
var statearr_74429_74475 = state_74405__$1;
(statearr_74429_74475[(1)] = (16));

} else {
var statearr_74430_74476 = state_74405__$1;
(statearr_74430_74476[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (2))){
var _ = (function (){var statearr_74431 = state_74405;
(statearr_74431[(4)] = cljs.core.cons.call(null,(5),(state_74405[(4)])));

return statearr_74431;
})();
var inst_74329 = fluree.db.util.core.current_time_millis.call(null);
var inst_74330 = db;
var inst_74331 = cljs.core.__destructure_map.call(null,inst_74330);
var inst_74332 = cljs.core.get.call(null,inst_74331,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_74333 = cljs.core.get.call(null,inst_74331,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_74334 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_74405__$1 = (function (){var statearr_74432 = state_74405;
(statearr_74432[(18)] = inst_74332);

(statearr_74432[(19)] = inst_74333);

(statearr_74432[(13)] = inst_74329);

return statearr_74432;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74405__$1,(6),inst_74334);
} else {
if((state_val_74406 === (23))){
var inst_74381 = (state_74405[(2)]);
var inst_74382 = fluree.db.util.async.throw_err.call(null,inst_74381);
var state_74405__$1 = state_74405;
var statearr_74433_74477 = state_74405__$1;
(statearr_74433_74477[(2)] = inst_74382);

(statearr_74433_74477[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (19))){
var inst_74365 = (state_74405[(2)]);
var inst_74366 = fluree.db.util.async.throw_err.call(null,inst_74365);
var state_74405__$1 = state_74405;
var statearr_74434_74478 = state_74405__$1;
(statearr_74434_74478[(2)] = inst_74366);

(statearr_74434_74478[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (11))){
var state_74405__$1 = state_74405;
var statearr_74436_74479 = state_74405__$1;
(statearr_74436_74479[(2)] = null);

(statearr_74436_74479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (9))){
var inst_74343 = (state_74405[(2)]);
var state_74405__$1 = state_74405;
if(cljs.core.truth_(inst_74343)){
var statearr_74437_74480 = state_74405__$1;
(statearr_74437_74480[(1)] = (10));

} else {
var statearr_74438_74481 = state_74405__$1;
(statearr_74438_74481[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (5))){
var _ = (function (){var statearr_74439 = state_74405;
(statearr_74439[(4)] = cljs.core.rest.call(null,(state_74405[(4)])));

return statearr_74439;
})();
var state_74405__$1 = state_74405;
var ex74435 = (state_74405__$1[(2)]);
var statearr_74440_74482 = state_74405__$1;
(statearr_74440_74482[(5)] = ex74435);


var statearr_74441_74483 = state_74405__$1;
(statearr_74441_74483[(1)] = (4));

(statearr_74441_74483[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (14))){
var inst_74332 = (state_74405[(18)]);
var inst_74333 = (state_74405[(19)]);
var inst_74348 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74332),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74333)].join('');
var state_74405__$1 = state_74405;
var statearr_74442_74484 = state_74405__$1;
(statearr_74442_74484[(2)] = inst_74348);

(statearr_74442_74484[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (26))){
var inst_74400 = (state_74405[(2)]);
var _ = (function (){var statearr_74443 = state_74405;
(statearr_74443[(4)] = cljs.core.rest.call(null,(state_74405[(4)])));

return statearr_74443;
})();
var state_74405__$1 = state_74405;
var statearr_74444_74485 = state_74405__$1;
(statearr_74444_74485[(2)] = inst_74400);

(statearr_74444_74485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (16))){
var inst_74356 = (state_74405[(16)]);
var inst_74357 = (state_74405[(17)]);
var inst_74363 = fluree.db.query.block.block_range.call(null,db,inst_74356,inst_74357,opts);
var state_74405__$1 = state_74405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74405__$1,(19),inst_74363);
} else {
if((state_val_74406 === (10))){
var inst_74345 = (state_74405[(12)]);
var inst_74337 = (state_74405[(7)]);
var inst_74345__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_74337);
var state_74405__$1 = (function (){var statearr_74445 = state_74405;
(statearr_74445[(12)] = inst_74345__$1);

return statearr_74445;
})();
if(cljs.core.truth_(inst_74345__$1)){
var statearr_74446_74486 = state_74405__$1;
(statearr_74446_74486[(1)] = (13));

} else {
var statearr_74447_74487 = state_74405__$1;
(statearr_74447_74487[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (18))){
var inst_74376 = (state_74405[(2)]);
var inst_74377 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_74405__$1 = (function (){var statearr_74448 = state_74405;
(statearr_74448[(8)] = inst_74376);

return statearr_74448;
})();
if(cljs.core.truth_(inst_74377)){
var statearr_74449_74488 = state_74405__$1;
(statearr_74449_74488[(1)] = (20));

} else {
var statearr_74450_74489 = state_74405__$1;
(statearr_74450_74489[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74406 === (8))){
var inst_74338 = (state_74405[(14)]);
var state_74405__$1 = state_74405;
var statearr_74451_74490 = state_74405__$1;
(statearr_74451_74490[(2)] = inst_74338);

(statearr_74451_74490[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_74452 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74452[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_74452[(1)] = (1));

return statearr_74452;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_74405){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_74405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74453){var ex__10906__auto__ = e74453;
var statearr_74454_74491 = state_74405;
(statearr_74454_74491[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_74405[(4)]))){
var statearr_74455_74492 = state_74405;
(statearr_74455_74492[(1)] = cljs.core.first.call(null,(state_74405[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74493 = state_74405;
state_74405 = G__74493;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_74405){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_74405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74456 = f__10977__auto__.call(null);
(statearr_74456[(6)] = c__10976__auto__);

return statearr_74456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__74495 = arguments.length;
switch (G__74495) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_74690){
var state_val_74691 = (state_74690[(1)]);
if((state_val_74691 === (62))){
var inst_74688 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74690__$1,inst_74688);
} else {
if((state_val_74691 === (7))){
var inst_74516 = (state_74690[(7)]);
var inst_74526 = cljs.core.not_EQ_.call(null,(1),inst_74516);
var state_74690__$1 = state_74690;
var statearr_74692_74783 = state_74690__$1;
(statearr_74692_74783[(2)] = inst_74526);

(statearr_74692_74783[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (59))){
var inst_74676 = (state_74690[(2)]);
var inst_74677 = fluree.db.util.async.throw_err.call(null,inst_74676);
var state_74690__$1 = state_74690;
var statearr_74693_74784 = state_74690__$1;
(statearr_74693_74784[(2)] = inst_74677);

(statearr_74693_74784[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (20))){
var inst_74584 = (state_74690[(8)]);
var inst_74592 = (state_74690[(9)]);
var inst_74584__$1 = (state_74690[(2)]);
var inst_74585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74586 = cljs.core.get.call(null,inst_74584__$1,(0));
var inst_74587 = cljs.core.get.call(null,inst_74584__$1,(1));
var inst_74588 = cljs.core.get.call(null,inst_74584__$1,(2));
var inst_74589 = cljs.core.get.call(null,inst_74584__$1,(3));
var inst_74590 = [inst_74586,inst_74587,inst_74588,inst_74589];
var inst_74591 = (new cljs.core.PersistentVector(null,4,(5),inst_74585,inst_74590,null));
var inst_74592__$1 = cljs.core.nth.call(null,inst_74591,(0),null);
var inst_74593 = cljs.core.nth.call(null,inst_74591,(1),null);
var inst_74594 = cljs.core.nth.call(null,inst_74591,(2),null);
var inst_74595 = cljs.core.nth.call(null,inst_74591,(3),null);
var inst_74596 = (inst_74592__$1 == null);
var inst_74597 = cljs.core.not.call(null,inst_74596);
var state_74690__$1 = (function (){var statearr_74694 = state_74690;
(statearr_74694[(10)] = inst_74593);

(statearr_74694[(11)] = inst_74595);

(statearr_74694[(8)] = inst_74584__$1);

(statearr_74694[(12)] = inst_74594);

(statearr_74694[(9)] = inst_74592__$1);

return statearr_74694;
})();
if(inst_74597){
var statearr_74695_74785 = state_74690__$1;
(statearr_74695_74785[(1)] = (30));

} else {
var statearr_74696_74786 = state_74690__$1;
(statearr_74696_74786[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (58))){
var inst_74524 = (state_74690[(13)]);
var inst_74680 = (state_74690[(2)]);
var state_74690__$1 = (function (){var statearr_74697 = state_74690;
(statearr_74697[(14)] = inst_74680);

return statearr_74697;
})();
if(cljs.core.truth_(inst_74524)){
var statearr_74698_74787 = state_74690__$1;
(statearr_74698_74787[(1)] = (60));

} else {
var statearr_74699_74788 = state_74690__$1;
(statearr_74699_74788[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (60))){
var inst_74668 = (state_74690[(15)]);
var inst_74680 = (state_74690[(14)]);
var inst_74682 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74683 = cljs.core.count.call(null,inst_74668);
var inst_74684 = [inst_74680,inst_74683,(200)];
var inst_74685 = cljs.core.PersistentHashMap.fromArrays(inst_74682,inst_74684);
var state_74690__$1 = state_74690;
var statearr_74700_74789 = state_74690__$1;
(statearr_74700_74789[(2)] = inst_74685);

(statearr_74700_74789[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (27))){
var inst_74503 = (state_74690[(16)]);
var inst_74572 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74503)].join('');
var inst_74573 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74574 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74575 = cljs.core.PersistentHashMap.fromArrays(inst_74573,inst_74574);
var inst_74576 = cljs.core.ex_info.call(null,inst_74572,inst_74575);
var inst_74577 = (function(){throw inst_74576})();
var state_74690__$1 = state_74690;
var statearr_74701_74790 = state_74690__$1;
(statearr_74701_74790[(2)] = inst_74577);

(statearr_74701_74790[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (1))){
var inst_74500 = query_map;
var inst_74501 = cljs.core.__destructure_map.call(null,inst_74500);
var inst_74502 = cljs.core.get.call(null,inst_74501,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74503 = cljs.core.get.call(null,inst_74501,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_74504 = cljs.core.get.call(null,inst_74501,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_74690__$1 = (function (){var statearr_74702 = state_74690;
(statearr_74702[(17)] = inst_74504);

(statearr_74702[(18)] = inst_74502);

(statearr_74702[(16)] = inst_74503);

return statearr_74702;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(2),sources);
} else {
if((state_val_74691 === (24))){
var inst_74503 = (state_74690[(16)]);
var inst_74561 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74503)].join('');
var inst_74562 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74563 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74564 = cljs.core.PersistentHashMap.fromArrays(inst_74562,inst_74563);
var inst_74565 = cljs.core.ex_info.call(null,inst_74561,inst_74564);
var inst_74566 = (function(){throw inst_74565})();
var state_74690__$1 = state_74690;
var statearr_74703_74791 = state_74690__$1;
(statearr_74703_74791[(2)] = inst_74566);

(statearr_74703_74791[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (55))){
var inst_74504 = (state_74690[(17)]);
var inst_74671 = (state_74690[(2)]);
var inst_74672 = fluree.db.util.async.throw_err.call(null,inst_74671);
var state_74690__$1 = (function (){var statearr_74704 = state_74690;
(statearr_74704[(19)] = inst_74672);

return statearr_74704;
})();
if(cljs.core.truth_(inst_74504)){
var statearr_74705_74792 = state_74690__$1;
(statearr_74705_74792[(1)] = (56));

} else {
var statearr_74706_74793 = state_74690__$1;
(statearr_74706_74793[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (39))){
var inst_74593 = (state_74690[(10)]);
var inst_74595 = (state_74690[(11)]);
var inst_74594 = (state_74690[(12)]);
var inst_74592 = (state_74690[(9)]);
var inst_74616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74618 = [inst_74593,inst_74592,inst_74594,inst_74595];
var inst_74619 = (new cljs.core.PersistentVector(null,4,(5),inst_74617,inst_74618,null));
var inst_74620 = [inst_74619,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74621 = (new cljs.core.PersistentVector(null,2,(5),inst_74616,inst_74620,null));
var state_74690__$1 = state_74690;
var statearr_74707_74794 = state_74690__$1;
(statearr_74707_74794[(2)] = inst_74621);

(statearr_74707_74794[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (46))){
var inst_74626 = (state_74690[(20)]);
var state_74690__$1 = state_74690;
var statearr_74708_74795 = state_74690__$1;
(statearr_74708_74795[(2)] = inst_74626);

(statearr_74708_74795[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (4))){
var state_74690__$1 = state_74690;
var statearr_74709_74796 = state_74690__$1;
(statearr_74709_74796[(2)] = null);

(statearr_74709_74796[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (54))){
var inst_74668 = (state_74690[(15)]);
var inst_74507 = (state_74690[(21)]);
var inst_74667 = (state_74690[(2)]);
var inst_74668__$1 = fluree.db.util.async.throw_err.call(null,inst_74667);
var inst_74669 = fluree.db.api_js.format_history_resp.call(null,inst_74507,inst_74668__$1);
var state_74690__$1 = (function (){var statearr_74710 = state_74690;
(statearr_74710[(15)] = inst_74668__$1);

return statearr_74710;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(55),inst_74669);
} else {
if((state_val_74691 === (15))){
var inst_74507 = (state_74690[(21)]);
var inst_74548 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74507);
var state_74690__$1 = state_74690;
var statearr_74711_74797 = state_74690__$1;
(statearr_74711_74797[(2)] = inst_74548);

(statearr_74711_74797[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (48))){
var inst_74593 = (state_74690[(10)]);
var inst_74595 = (state_74690[(11)]);
var inst_74594 = (state_74690[(12)]);
var inst_74592 = (state_74690[(9)]);
var inst_74637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74639 = [inst_74593,inst_74594,inst_74592,inst_74595];
var inst_74640 = (new cljs.core.PersistentVector(null,4,(5),inst_74638,inst_74639,null));
var inst_74641 = [inst_74640,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74642 = (new cljs.core.PersistentVector(null,2,(5),inst_74637,inst_74641,null));
var state_74690__$1 = state_74690;
var statearr_74712_74798 = state_74690__$1;
(statearr_74712_74798[(2)] = inst_74642);

(statearr_74712_74798[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (50))){
var inst_74655 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74713_74799 = state_74690__$1;
(statearr_74713_74799[(2)] = inst_74655);

(statearr_74713_74799[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (21))){
var inst_74503 = (state_74690[(16)]);
var inst_74559 = cljs.core.empty_QMARK_.call(null,inst_74503);
var state_74690__$1 = state_74690;
if(inst_74559){
var statearr_74714_74800 = state_74690__$1;
(statearr_74714_74800[(1)] = (24));

} else {
var statearr_74715_74801 = state_74690__$1;
(statearr_74715_74801[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (31))){
var inst_74603 = (state_74690[(22)]);
var inst_74592 = (state_74690[(9)]);
var inst_74603__$1 = (inst_74592 == null);
var state_74690__$1 = (function (){var statearr_74716 = state_74690;
(statearr_74716[(22)] = inst_74603__$1);

return statearr_74716;
})();
if(cljs.core.truth_(inst_74603__$1)){
var statearr_74717_74802 = state_74690__$1;
(statearr_74717_74802[(1)] = (33));

} else {
var statearr_74718_74803 = state_74690__$1;
(statearr_74718_74803[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (32))){
var inst_74507 = (state_74690[(21)]);
var inst_74540 = (state_74690[(23)]);
var inst_74550 = (state_74690[(24)]);
var inst_74659 = (state_74690[(2)]);
var inst_74660 = cljs.core.nth.call(null,inst_74659,(0),null);
var inst_74661 = cljs.core.nth.call(null,inst_74659,(1),null);
var inst_74662 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74663 = [inst_74540,inst_74550];
var inst_74664 = cljs.core.PersistentHashMap.fromArrays(inst_74662,inst_74663);
var inst_74665 = fluree.db.query.range.time_range.call(null,inst_74507,inst_74661,cljs.core._EQ_,inst_74660,inst_74664);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(54),inst_74665);
} else {
if((state_val_74691 === (40))){
var inst_74623 = (state_74690[(25)]);
var inst_74592 = (state_74690[(9)]);
var inst_74623__$1 = (inst_74592 == null);
var state_74690__$1 = (function (){var statearr_74719 = state_74690;
(statearr_74719[(25)] = inst_74623__$1);

return statearr_74719;
})();
if(cljs.core.truth_(inst_74623__$1)){
var statearr_74720_74804 = state_74690__$1;
(statearr_74720_74804[(1)] = (42));

} else {
var statearr_74721_74805 = state_74690__$1;
(statearr_74721_74805[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (56))){
var inst_74507 = (state_74690[(21)]);
var inst_74672 = (state_74690[(19)]);
var inst_74674 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_74507,inst_74672);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(59),inst_74674);
} else {
if((state_val_74691 === (33))){
var inst_74606 = (state_74690[(26)]);
var inst_74593 = (state_74690[(10)]);
var inst_74605 = (inst_74593 == null);
var inst_74606__$1 = cljs.core.not.call(null,inst_74605);
var state_74690__$1 = (function (){var statearr_74722 = state_74690;
(statearr_74722[(26)] = inst_74606__$1);

return statearr_74722;
})();
if(inst_74606__$1){
var statearr_74723_74806 = state_74690__$1;
(statearr_74723_74806[(1)] = (36));

} else {
var statearr_74724_74807 = state_74690__$1;
(statearr_74724_74807[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (13))){
var inst_74534 = (state_74690[(2)]);
var inst_74535 = fluree.db.util.async.throw_err.call(null,inst_74534);
var inst_74536 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74535);
var inst_74537 = (inst_74536 - (1));
var state_74690__$1 = state_74690;
var statearr_74725_74808 = state_74690__$1;
(statearr_74725_74808[(2)] = inst_74537);

(statearr_74725_74808[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (22))){
var state_74690__$1 = state_74690;
var statearr_74726_74809 = state_74690__$1;
(statearr_74726_74809[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (36))){
var inst_74594 = (state_74690[(12)]);
var inst_74608 = (inst_74594 == null);
var state_74690__$1 = state_74690;
var statearr_74728_74810 = state_74690__$1;
(statearr_74728_74810[(2)] = inst_74608);

(statearr_74728_74810[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (41))){
var inst_74657 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74729_74811 = state_74690__$1;
(statearr_74729_74811[(2)] = inst_74657);

(statearr_74729_74811[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (43))){
var inst_74623 = (state_74690[(25)]);
var state_74690__$1 = state_74690;
var statearr_74730_74812 = state_74690__$1;
(statearr_74730_74812[(2)] = inst_74623);

(statearr_74730_74812[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (61))){
var inst_74680 = (state_74690[(14)]);
var state_74690__$1 = state_74690;
var statearr_74731_74813 = state_74690__$1;
(statearr_74731_74813[(2)] = inst_74680);

(statearr_74731_74813[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (29))){
var inst_74580 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74732_74814 = state_74690__$1;
(statearr_74732_74814[(2)] = inst_74580);

(statearr_74732_74814[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (44))){
var inst_74635 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
if(cljs.core.truth_(inst_74635)){
var statearr_74733_74815 = state_74690__$1;
(statearr_74733_74815[(1)] = (48));

} else {
var statearr_74734_74816 = state_74690__$1;
(statearr_74734_74816[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (6))){
var inst_74511 = (state_74690[(2)]);
var inst_74512 = fluree.db.util.async.throw_err.call(null,inst_74511);
var state_74690__$1 = state_74690;
var statearr_74735_74817 = state_74690__$1;
(statearr_74735_74817[(2)] = inst_74512);

(statearr_74735_74817[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (28))){
var state_74690__$1 = state_74690;
var statearr_74736_74818 = state_74690__$1;
(statearr_74736_74818[(2)] = null);

(statearr_74736_74818[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (51))){
var inst_74503 = (state_74690[(16)]);
var inst_74645 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74503)].join('');
var inst_74646 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74647 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74648 = cljs.core.PersistentHashMap.fromArrays(inst_74646,inst_74647);
var inst_74649 = cljs.core.ex_info.call(null,inst_74645,inst_74648);
var inst_74650 = (function(){throw inst_74649})();
var state_74690__$1 = state_74690;
var statearr_74737_74819 = state_74690__$1;
(statearr_74737_74819[(2)] = inst_74650);

(statearr_74737_74819[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (25))){
var inst_74503 = (state_74690[(16)]);
var state_74690__$1 = state_74690;
var statearr_74738_74820 = state_74690__$1;
(statearr_74738_74820[(2)] = inst_74503);

(statearr_74738_74820[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (34))){
var inst_74603 = (state_74690[(22)]);
var state_74690__$1 = state_74690;
var statearr_74739_74821 = state_74690__$1;
(statearr_74739_74821[(2)] = inst_74603);

(statearr_74739_74821[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (17))){
var inst_74544 = (state_74690[(2)]);
var inst_74545 = fluree.db.util.async.throw_err.call(null,inst_74544);
var inst_74546 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_74545);
var state_74690__$1 = state_74690;
var statearr_74740_74822 = state_74690__$1;
(statearr_74740_74822[(2)] = inst_74546);

(statearr_74740_74822[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (3))){
var inst_74507 = (state_74690[(21)]);
var inst_74509 = fluree.db.api_js.resolve_block_range.call(null,inst_74507,query_map);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(6),inst_74509);
} else {
if((state_val_74691 === (12))){
var inst_74517 = (state_74690[(27)]);
var inst_74540 = (state_74690[(2)]);
var state_74690__$1 = (function (){var statearr_74741 = state_74690;
(statearr_74741[(23)] = inst_74540);

return statearr_74741;
})();
if(cljs.core.truth_(inst_74517)){
var statearr_74742_74823 = state_74690__$1;
(statearr_74742_74823[(1)] = (14));

} else {
var statearr_74743_74824 = state_74690__$1;
(statearr_74743_74824[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (2))){
var inst_74502 = (state_74690[(18)]);
var inst_74506 = (state_74690[(2)]);
var inst_74507 = fluree.db.util.async.throw_err.call(null,inst_74506);
var state_74690__$1 = (function (){var statearr_74744 = state_74690;
(statearr_74744[(21)] = inst_74507);

return statearr_74744;
})();
if(cljs.core.truth_(inst_74502)){
var statearr_74745_74825 = state_74690__$1;
(statearr_74745_74825[(1)] = (3));

} else {
var statearr_74746_74826 = state_74690__$1;
(statearr_74746_74826[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (23))){
var inst_74582 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74747_74827 = state_74690__$1;
(statearr_74747_74827[(2)] = inst_74582);

(statearr_74747_74827[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (47))){
var inst_74632 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74748_74828 = state_74690__$1;
(statearr_74748_74828[(2)] = inst_74632);

(statearr_74748_74828[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (35))){
var inst_74614 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
if(cljs.core.truth_(inst_74614)){
var statearr_74749_74829 = state_74690__$1;
(statearr_74749_74829[(1)] = (39));

} else {
var statearr_74750_74830 = state_74690__$1;
(statearr_74750_74830[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (19))){
var inst_74503 = (state_74690[(16)]);
var inst_74557 = cljs.core.sequential_QMARK_.call(null,inst_74503);
var state_74690__$1 = state_74690;
if(inst_74557){
var statearr_74751_74831 = state_74690__$1;
(statearr_74751_74831[(1)] = (21));

} else {
var statearr_74752_74832 = state_74690__$1;
(statearr_74752_74832[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (57))){
var inst_74672 = (state_74690[(19)]);
var state_74690__$1 = state_74690;
var statearr_74753_74833 = state_74690__$1;
(statearr_74753_74833[(2)] = inst_74672);

(statearr_74753_74833[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (11))){
var state_74690__$1 = state_74690;
var statearr_74754_74834 = state_74690__$1;
(statearr_74754_74834[(2)] = (-1));

(statearr_74754_74834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (9))){
var inst_74529 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
if(cljs.core.truth_(inst_74529)){
var statearr_74755_74835 = state_74690__$1;
(statearr_74755_74835[(1)] = (10));

} else {
var statearr_74756_74836 = state_74690__$1;
(statearr_74756_74836[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (5))){
var inst_74516 = (state_74690[(7)]);
var inst_74515 = (state_74690[(2)]);
var inst_74516__$1 = cljs.core.nth.call(null,inst_74515,(0),null);
var inst_74517 = cljs.core.nth.call(null,inst_74515,(1),null);
var inst_74524 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74690__$1 = (function (){var statearr_74757 = state_74690;
(statearr_74757[(13)] = inst_74524);

(statearr_74757[(7)] = inst_74516__$1);

(statearr_74757[(27)] = inst_74517);

return statearr_74757;
})();
if(cljs.core.truth_(inst_74516__$1)){
var statearr_74758_74837 = state_74690__$1;
(statearr_74758_74837[(1)] = (7));

} else {
var statearr_74759_74838 = state_74690__$1;
(statearr_74759_74838[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (14))){
var inst_74507 = (state_74690[(21)]);
var inst_74517 = (state_74690[(27)]);
var inst_74542 = fluree.db.time_travel.as_of_block.call(null,inst_74507,inst_74517);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(17),inst_74542);
} else {
if((state_val_74691 === (45))){
var inst_74594 = (state_74690[(12)]);
var inst_74628 = (inst_74594 == null);
var inst_74629 = cljs.core.not.call(null,inst_74628);
var state_74690__$1 = state_74690;
var statearr_74760_74839 = state_74690__$1;
(statearr_74760_74839[(2)] = inst_74629);

(statearr_74760_74839[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (53))){
var inst_74653 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74761_74840 = state_74690__$1;
(statearr_74761_74840[(2)] = inst_74653);

(statearr_74761_74840[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (26))){
var inst_74569 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74762_74841 = state_74690__$1;
(statearr_74762_74841[(2)] = inst_74569);

(statearr_74762_74841[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (16))){
var inst_74503 = (state_74690[(16)]);
var inst_74550 = (state_74690[(2)]);
var inst_74551 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_74503);
var state_74690__$1 = (function (){var statearr_74763 = state_74690;
(statearr_74763[(24)] = inst_74550);

return statearr_74763;
})();
if(inst_74551){
var statearr_74764_74842 = state_74690__$1;
(statearr_74764_74842[(1)] = (18));

} else {
var statearr_74765_74843 = state_74690__$1;
(statearr_74765_74843[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (38))){
var inst_74611 = (state_74690[(2)]);
var state_74690__$1 = state_74690;
var statearr_74766_74844 = state_74690__$1;
(statearr_74766_74844[(2)] = inst_74611);

(statearr_74766_74844[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (30))){
var inst_74584 = (state_74690[(8)]);
var inst_74599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74600 = [inst_74584,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_74601 = (new cljs.core.PersistentVector(null,2,(5),inst_74599,inst_74600,null));
var state_74690__$1 = state_74690;
var statearr_74767_74845 = state_74690__$1;
(statearr_74767_74845[(2)] = inst_74601);

(statearr_74767_74845[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (10))){
var inst_74516 = (state_74690[(7)]);
var inst_74507 = (state_74690[(21)]);
var inst_74531 = (inst_74516 - (1));
var inst_74532 = fluree.db.time_travel.as_of_block.call(null,inst_74507,inst_74531);
var state_74690__$1 = state_74690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74690__$1,(13),inst_74532);
} else {
if((state_val_74691 === (18))){
var inst_74503 = (state_74690[(16)]);
var inst_74553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74554 = [inst_74503];
var inst_74555 = (new cljs.core.PersistentVector(null,1,(5),inst_74553,inst_74554,null));
var state_74690__$1 = state_74690;
var statearr_74768_74846 = state_74690__$1;
(statearr_74768_74846[(2)] = inst_74555);

(statearr_74768_74846[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (52))){
var state_74690__$1 = state_74690;
var statearr_74769_74847 = state_74690__$1;
(statearr_74769_74847[(2)] = null);

(statearr_74769_74847[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (42))){
var inst_74593 = (state_74690[(10)]);
var inst_74626 = (state_74690[(20)]);
var inst_74625 = (inst_74593 == null);
var inst_74626__$1 = cljs.core.not.call(null,inst_74625);
var state_74690__$1 = (function (){var statearr_74770 = state_74690;
(statearr_74770[(20)] = inst_74626__$1);

return statearr_74770;
})();
if(inst_74626__$1){
var statearr_74771_74848 = state_74690__$1;
(statearr_74771_74848[(1)] = (45));

} else {
var statearr_74772_74849 = state_74690__$1;
(statearr_74772_74849[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (37))){
var inst_74606 = (state_74690[(26)]);
var state_74690__$1 = state_74690;
var statearr_74773_74850 = state_74690__$1;
(statearr_74773_74850[(2)] = inst_74606);

(statearr_74773_74850[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (8))){
var inst_74516 = (state_74690[(7)]);
var state_74690__$1 = state_74690;
var statearr_74774_74851 = state_74690__$1;
(statearr_74774_74851[(2)] = inst_74516);

(statearr_74774_74851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74691 === (49))){
var state_74690__$1 = state_74690;
var statearr_74775_74852 = state_74690__$1;
(statearr_74775_74852[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_74777 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74777[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_74777[(1)] = (1));

return statearr_74777;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_74690){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_74690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74778){var ex__10906__auto__ = e74778;
var statearr_74779_74853 = state_74690;
(statearr_74779_74853[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_74690[(4)]))){
var statearr_74780_74854 = state_74690;
(statearr_74780_74854[(1)] = cljs.core.first.call(null,(state_74690[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74855 = state_74690;
state_74690 = G__74855;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_74690){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_74690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74781 = f__10977__auto__.call(null);
(statearr_74781[(6)] = c__10976__auto__);

return statearr_74781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74863 = arguments.length;
switch (G__74863) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__74856_SHARP_){
return cljs.core.dissoc.call(null,p1__74856_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_74952){
var state_val_74953 = (state_74952[(1)]);
if((state_val_74953 === (7))){
var inst_74913 = (state_74952[(7)]);
var inst_74906 = (state_74952[(8)]);
var inst_74909 = (state_74952[(9)]);
var inst_74903 = (state_74952[(10)]);
var inst_74919 = (function (){var responses = inst_74903;
var responses_STAR_ = inst_74906;
var statuses = inst_74909;
var fuel = inst_74913;
return (function (p1__74859_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__74859_SHARP_);
});
})();
var inst_74920 = cljs.core.some.call(null,inst_74919,inst_74909);
var state_74952__$1 = state_74952;
if(cljs.core.truth_(inst_74920)){
var statearr_74954_75002 = state_74952__$1;
(statearr_74954_75002[(1)] = (9));

} else {
var statearr_74955_75003 = state_74952__$1;
(statearr_74955_75003[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (20))){
var inst_74947 = (state_74952[(2)]);
var state_74952__$1 = state_74952;
var statearr_74956_75004 = state_74952__$1;
(statearr_74956_75004[(2)] = inst_74947);

(statearr_74956_75004[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (1))){
var inst_74898 = cljs.core.async.chan.call(null,(1));
var inst_74899 = (function (){var c__10976__auto____$1 = inst_74898;
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_74896){
var state_val_74897 = (state_74896[(1)]);
if((state_val_74897 === (1))){
var inst_74864 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_74865 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_74866 = cljs.core.assoc.call(null,inst_74865,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74867 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_74868 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_74869 = cljs.core.PersistentHashMap.EMPTY;
var inst_74870 = inst_74864;
var inst_74871 = inst_74866;
var inst_74872 = inst_74867;
var inst_74873 = inst_74868;
var inst_74874 = inst_74869;
var state_74896__$1 = (function (){var statearr_74957 = state_74896;
(statearr_74957[(7)] = inst_74874);

(statearr_74957[(8)] = inst_74873);

(statearr_74957[(9)] = inst_74872);

(statearr_74957[(10)] = inst_74871);

(statearr_74957[(11)] = inst_74870);

return statearr_74957;
})();
var statearr_74958_75005 = state_74896__$1;
(statearr_74958_75005[(2)] = null);

(statearr_74958_75005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74897 === (2))){
var inst_74871 = (state_74896[(10)]);
var inst_74876 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74871);
var inst_74877 = cljs.core.merge.call(null,opts,inst_74876);
var inst_74878 = cljs.core.assoc.call(null,inst_74871,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74877);
var inst_74879 = fluree.db.api_js.query_async.call(null,db,inst_74878,db_fn);
var state_74896__$1 = state_74896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74896__$1,(4),inst_74879);
} else {
if((state_val_74897 === (3))){
var inst_74894 = (state_74896[(2)]);
var state_74896__$1 = state_74896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74896__$1,inst_74894);
} else {
if((state_val_74897 === (4))){
var inst_74874 = (state_74896[(7)]);
var inst_74872 = (state_74896[(9)]);
var inst_74870 = (state_74896[(11)]);
var inst_74881 = (state_74896[(2)]);
var inst_74882 = cljs.core.assoc.call(null,inst_74874,inst_74870,inst_74881);
var inst_74883 = cljs.core.first.call(null,inst_74872);
var state_74896__$1 = (function (){var statearr_74959 = state_74896;
(statearr_74959[(12)] = inst_74882);

return statearr_74959;
})();
if(cljs.core.truth_(inst_74883)){
var statearr_74960_75006 = state_74896__$1;
(statearr_74960_75006[(1)] = (5));

} else {
var statearr_74961_75007 = state_74896__$1;
(statearr_74961_75007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74897 === (5))){
var inst_74882 = (state_74896[(12)]);
var inst_74873 = (state_74896[(8)]);
var inst_74872 = (state_74896[(9)]);
var inst_74885 = cljs.core.first.call(null,inst_74872);
var inst_74886 = cljs.core.first.call(null,inst_74873);
var inst_74887 = cljs.core.rest.call(null,inst_74872);
var inst_74888 = cljs.core.rest.call(null,inst_74873);
var inst_74870 = inst_74885;
var inst_74871 = inst_74886;
var inst_74872__$1 = inst_74887;
var inst_74873__$1 = inst_74888;
var inst_74874 = inst_74882;
var state_74896__$1 = (function (){var statearr_74962 = state_74896;
(statearr_74962[(7)] = inst_74874);

(statearr_74962[(8)] = inst_74873__$1);

(statearr_74962[(9)] = inst_74872__$1);

(statearr_74962[(10)] = inst_74871);

(statearr_74962[(11)] = inst_74870);

return statearr_74962;
})();
var statearr_74963_75008 = state_74896__$1;
(statearr_74963_75008[(2)] = null);

(statearr_74963_75008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74897 === (6))){
var inst_74882 = (state_74896[(12)]);
var state_74896__$1 = state_74896;
var statearr_74964_75009 = state_74896__$1;
(statearr_74964_75009[(2)] = inst_74882);

(statearr_74964_75009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74897 === (7))){
var inst_74892 = (state_74896[(2)]);
var state_74896__$1 = state_74896;
var statearr_74965_75010 = state_74896__$1;
(statearr_74965_75010[(2)] = inst_74892);

(statearr_74965_75010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_74966 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74966[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_74966[(1)] = (1));

return statearr_74966;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_74896){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_74896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74967){var ex__10906__auto__ = e74967;
var statearr_74968_75011 = state_74896;
(statearr_74968_75011[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_74896[(4)]))){
var statearr_74969_75012 = state_74896;
(statearr_74969_75012[(1)] = cljs.core.first.call(null,(state_74896[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75013 = state_74896;
state_74896 = G__75013;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_74896){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_74896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_74970 = f__10977__auto__.call(null);
(statearr_74970[(6)] = c__10976__auto____$1);

return statearr_74970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});
})();
var inst_74900 = cljs.core.async.impl.dispatch.run.call(null,inst_74899);
var state_74952__$1 = (function (){var statearr_74971 = state_74952;
(statearr_74971[(11)] = inst_74900);

return statearr_74971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74952__$1,(2),inst_74898);
} else {
if((state_val_74953 === (4))){
var inst_74903 = (state_74952[(10)]);
var state_74952__$1 = state_74952;
var statearr_74972_75014 = state_74952__$1;
(statearr_74972_75014[(2)] = inst_74903);

(statearr_74972_75014[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (15))){
var state_74952__$1 = state_74952;
var statearr_74973_75015 = state_74952__$1;
(statearr_74973_75015[(2)] = (400));

(statearr_74973_75015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (13))){
var state_74952__$1 = state_74952;
var statearr_74974_75016 = state_74952__$1;
(statearr_74974_75016[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (6))){
var inst_74909 = (state_74952[(9)]);
var inst_74917 = cljs.core.first.call(null,inst_74909);
var state_74952__$1 = state_74952;
var statearr_74976_75017 = state_74952__$1;
(statearr_74976_75017[(2)] = inst_74917);

(statearr_74976_75017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (17))){
var inst_74930 = (state_74952[(2)]);
var state_74952__$1 = state_74952;
var statearr_74977_75018 = state_74952__$1;
(statearr_74977_75018[(2)] = inst_74930);

(statearr_74977_75018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (3))){
var inst_74913 = (state_74952[(7)]);
var inst_74906 = (state_74952[(8)]);
var inst_74909 = (state_74952[(9)]);
var inst_74903 = (state_74952[(10)]);
var inst_74908 = cljs.core.vals.call(null,inst_74903);
var inst_74909__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74908);
var inst_74910 = (function (){var responses = inst_74903;
var responses_STAR_ = inst_74906;
var statuses = inst_74909__$1;
return (function (p1__74857_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74857_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_74911 = cljs.core.vals.call(null,inst_74903);
var inst_74912 = cljs.core.map.call(null,inst_74910,inst_74911);
var inst_74913__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_74912);
var inst_74914 = (function (){var responses = inst_74903;
var responses_STAR_ = inst_74906;
var statuses = inst_74909__$1;
var fuel = inst_74913__$1;
return (function (p1__74858_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__74858_SHARP_);
});
})();
var inst_74915 = cljs.core.every_QMARK_.call(null,inst_74914,inst_74909__$1);
var state_74952__$1 = (function (){var statearr_74978 = state_74952;
(statearr_74978[(7)] = inst_74913__$1);

(statearr_74978[(9)] = inst_74909__$1);

return statearr_74978;
})();
if(inst_74915){
var statearr_74979_75019 = state_74952__$1;
(statearr_74979_75019[(1)] = (6));

} else {
var statearr_74980_75020 = state_74952__$1;
(statearr_74980_75020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (12))){
var state_74952__$1 = state_74952;
var statearr_74981_75021 = state_74952__$1;
(statearr_74981_75021[(2)] = (500));

(statearr_74981_75021[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (2))){
var inst_74903 = (state_74952[(10)]);
var inst_74902 = (state_74952[(2)]);
var inst_74903__$1 = fluree.db.util.async.throw_err.call(null,inst_74902);
var inst_74904 = (function (){var responses = inst_74903__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_74905 = cljs.core.PersistentHashMap.EMPTY;
var inst_74906 = cljs.core.reduce_kv.call(null,inst_74904,inst_74905,inst_74903__$1);
var state_74952__$1 = (function (){var statearr_74982 = state_74952;
(statearr_74982[(8)] = inst_74906);

(statearr_74982[(10)] = inst_74903__$1);

return statearr_74982;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74983_75022 = state_74952__$1;
(statearr_74983_75022[(1)] = (3));

} else {
var statearr_74984_75023 = state_74952__$1;
(statearr_74984_75023[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (19))){
var inst_74913 = (state_74952[(7)]);
var inst_74906 = (state_74952[(8)]);
var inst_74936 = (state_74952[(12)]);
var inst_74945 = cljs.core.assoc.call(null,inst_74906,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74936,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74913);
var state_74952__$1 = state_74952;
var statearr_74985_75024 = state_74952__$1;
(statearr_74985_75024[(2)] = inst_74945);

(statearr_74985_75024[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (11))){
var inst_74934 = (state_74952[(2)]);
var state_74952__$1 = state_74952;
var statearr_74986_75025 = state_74952__$1;
(statearr_74986_75025[(2)] = inst_74934);

(statearr_74986_75025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (9))){
var state_74952__$1 = state_74952;
var statearr_74987_75026 = state_74952__$1;
(statearr_74987_75026[(2)] = (207));

(statearr_74987_75026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (5))){
var inst_74950 = (state_74952[(2)]);
var state_74952__$1 = state_74952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74952__$1,inst_74950);
} else {
if((state_val_74953 === (14))){
var inst_74932 = (state_74952[(2)]);
var state_74952__$1 = state_74952;
var statearr_74988_75027 = state_74952__$1;
(statearr_74988_75027[(2)] = inst_74932);

(statearr_74988_75027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (16))){
var state_74952__$1 = state_74952;
var statearr_74989_75028 = state_74952__$1;
(statearr_74989_75028[(2)] = null);

(statearr_74989_75028[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (10))){
var inst_74913 = (state_74952[(7)]);
var inst_74906 = (state_74952[(8)]);
var inst_74909 = (state_74952[(9)]);
var inst_74903 = (state_74952[(10)]);
var inst_74923 = (function (){var responses = inst_74903;
var responses_STAR_ = inst_74906;
var statuses = inst_74909;
var fuel = inst_74913;
return (function (p1__74860_SHARP_){
return ((499) < p1__74860_SHARP_);
});
})();
var inst_74924 = cljs.core.some.call(null,inst_74923,inst_74909);
var state_74952__$1 = state_74952;
if(cljs.core.truth_(inst_74924)){
var statearr_74990_75029 = state_74952__$1;
(statearr_74990_75029[(1)] = (12));

} else {
var statearr_74991_75030 = state_74952__$1;
(statearr_74991_75030[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (18))){
var inst_74913 = (state_74952[(7)]);
var inst_74941 = (state_74952[(13)]);
var inst_74906 = (state_74952[(8)]);
var inst_74936 = (state_74952[(12)]);
var inst_74943 = cljs.core.assoc.call(null,inst_74906,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74936,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74913,new cljs.core.Keyword(null,"block","block",664686210),inst_74941);
var state_74952__$1 = state_74952;
var statearr_74992_75031 = state_74952__$1;
(statearr_74992_75031[(2)] = inst_74943);

(statearr_74992_75031[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74953 === (8))){
var inst_74913 = (state_74952[(7)]);
var inst_74941 = (state_74952[(13)]);
var inst_74906 = (state_74952[(8)]);
var inst_74909 = (state_74952[(9)]);
var inst_74903 = (state_74952[(10)]);
var inst_74936 = (state_74952[(12)]);
var inst_74936__$1 = (state_74952[(2)]);
var inst_74937 = (function (){var responses = inst_74903;
var responses_STAR_ = inst_74906;
var statuses = inst_74909;
var fuel = inst_74913;
var status = inst_74936__$1;
return (function (p1__74861_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74861_SHARP_));
});
})();
var inst_74938 = cljs.core.vals.call(null,inst_74903);
var inst_74939 = cljs.core.filter.call(null,inst_74937,inst_74938);
var inst_74940 = cljs.core.first.call(null,inst_74939);
var inst_74941__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74940);
var state_74952__$1 = (function (){var statearr_74993 = state_74952;
(statearr_74993[(13)] = inst_74941__$1);

(statearr_74993[(12)] = inst_74936__$1);

return statearr_74993;
})();
if(cljs.core.truth_(inst_74941__$1)){
var statearr_74994_75032 = state_74952__$1;
(statearr_74994_75032[(1)] = (18));

} else {
var statearr_74995_75033 = state_74952__$1;
(statearr_74995_75033[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_74996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74996[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_74996[(1)] = (1));

return statearr_74996;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_74952){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_74952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e74997){var ex__10906__auto__ = e74997;
var statearr_74998_75034 = state_74952;
(statearr_74998_75034[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_74952[(4)]))){
var statearr_74999_75035 = state_74952;
(statearr_74999_75035[(1)] = cljs.core.first.call(null,(state_74952[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75036 = state_74952;
state_74952 = G__75036;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_74952){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_74952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_75000 = f__10977__auto__.call(null);
(statearr_75000[(6)] = c__10976__auto__);

return statearr_75000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__75038 = arguments.length;
switch (G__75038) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__75039 = opts;
var map__75039__$1 = cljs.core.__destructure_map.call(null,map__75039);
var auth = cljs.core.get.call(null,map__75039__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__75039__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__75039__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__75039__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__75040 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__75040,(0),null);
var authority = cljs.core.nth.call(null,vec__75040,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e75043){var e = e75043;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__75046 = arguments.length;
switch (G__75046) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_75077){
var state_val_75078 = (state_75077[(1)]);
if((state_val_75078 === (7))){
var state_75077__$1 = state_75077;
var statearr_75079_75100 = state_75077__$1;
(statearr_75079_75100[(2)] = opts);

(statearr_75079_75100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (1))){
var state_75077__$1 = state_75077;
var statearr_75080_75101 = state_75077__$1;
(statearr_75080_75101[(2)] = null);

(statearr_75080_75101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (4))){
var inst_75047 = (state_75077[(2)]);
var inst_75048 = fluree.db.util.log.error.call(null,inst_75047);
var inst_75049 = cljs.core.ex_data.call(null,inst_75047);
var inst_75050 = cljs.core.ex_message.call(null,inst_75047);
var inst_75051 = cljs.core.assoc.call(null,inst_75049,new cljs.core.Keyword(null,"message","message",-406056002),inst_75050);
var state_75077__$1 = (function (){var statearr_75081 = state_75077;
(statearr_75081[(7)] = inst_75048);

return statearr_75081;
})();
var statearr_75082_75102 = state_75077__$1;
(statearr_75082_75102[(2)] = inst_75051);

(statearr_75082_75102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (6))){
var inst_75061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75062 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_75063 = (new cljs.core.PersistentVector(null,1,(5),inst_75061,inst_75062,null));
var inst_75064 = cljs.core.assoc_in.call(null,opts,inst_75063,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_75077__$1 = state_75077;
var statearr_75083_75103 = state_75077__$1;
(statearr_75083_75103[(2)] = inst_75064);

(statearr_75083_75103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (3))){
var inst_75075 = (state_75077[(2)]);
var state_75077__$1 = state_75077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75077__$1,inst_75075);
} else {
if((state_val_75078 === (2))){
var _ = (function (){var statearr_75085 = state_75077;
(statearr_75085[(4)] = cljs.core.cons.call(null,(5),(state_75077[(4)])));

return statearr_75085;
})();
var inst_75057 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_75058 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_75059 = (inst_75058 == null);
var state_75077__$1 = (function (){var statearr_75086 = state_75077;
(statearr_75086[(8)] = inst_75057);

return statearr_75086;
})();
if(cljs.core.truth_(inst_75059)){
var statearr_75087_75104 = state_75077__$1;
(statearr_75087_75104[(1)] = (6));

} else {
var statearr_75088_75105 = state_75077__$1;
(statearr_75088_75105[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (9))){
var inst_75071 = (state_75077[(2)]);
var inst_75072 = fluree.db.util.async.throw_err.call(null,inst_75071);
var _ = (function (){var statearr_75089 = state_75077;
(statearr_75089[(4)] = cljs.core.rest.call(null,(state_75077[(4)])));

return statearr_75089;
})();
var state_75077__$1 = state_75077;
var statearr_75090_75106 = state_75077__$1;
(statearr_75090_75106[(2)] = inst_75072);

(statearr_75090_75106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (5))){
var _ = (function (){var statearr_75091 = state_75077;
(statearr_75091[(4)] = cljs.core.rest.call(null,(state_75077[(4)])));

return statearr_75091;
})();
var state_75077__$1 = state_75077;
var ex75084 = (state_75077__$1[(2)]);
var statearr_75092_75107 = state_75077__$1;
(statearr_75092_75107[(5)] = ex75084);


var statearr_75093_75108 = state_75077__$1;
(statearr_75093_75108[(1)] = (4));

(statearr_75093_75108[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75078 === (8))){
var inst_75057 = (state_75077[(8)]);
var inst_75067 = (state_75077[(2)]);
var inst_75068 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_75057,inst_75067);
var inst_75069 = fluree.db.operations.command_async.call(null,conn,inst_75068);
var state_75077__$1 = state_75077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75077__$1,(9),inst_75069);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__10903__auto__ = null;
var fluree$db$api_js$state_machine__10903__auto____0 = (function (){
var statearr_75094 = [null,null,null,null,null,null,null,null,null];
(statearr_75094[(0)] = fluree$db$api_js$state_machine__10903__auto__);

(statearr_75094[(1)] = (1));

return statearr_75094;
});
var fluree$db$api_js$state_machine__10903__auto____1 = (function (state_75077){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_75077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e75095){var ex__10906__auto__ = e75095;
var statearr_75096_75109 = state_75077;
(statearr_75096_75109[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_75077[(4)]))){
var statearr_75097_75110 = state_75077;
(statearr_75097_75110[(1)] = cljs.core.first.call(null,(state_75077[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75111 = state_75077;
state_75077 = G__75111;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__10903__auto__ = function(state_75077){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__10903__auto____1.call(this,state_75077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__10903__auto____0;
fluree$db$api_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__10903__auto____1;
return fluree$db$api_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_75098 = f__10977__auto__.call(null);
(statearr_75098[(6)] = c__10976__auto__);

return statearr_75098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

