// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38811 = arguments.length;
var i__4865__auto___38812 = (0);
while(true){
if((i__4865__auto___38812 < len__4864__auto___38811)){
args__4870__auto__.push((arguments[i__4865__auto___38812]));

var G__38813 = (i__4865__auto___38812 + (1));
i__4865__auto___38812 = G__38813;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq38808){
var G__38809 = cljs.core.first.call(null,seq38808);
var seq38808__$1 = cljs.core.next.call(null,seq38808);
var G__38810 = cljs.core.first.call(null,seq38808__$1);
var seq38808__$2 = cljs.core.next.call(null,seq38808__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38809,G__38810,seq38808__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e38814){var e = e38814;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e38815){var e = e38815;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e38816){var e = e38816;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e38817){var e = e38817;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e38818){var e = e38818;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38821 = arguments.length;
var i__4865__auto___38822 = (0);
while(true){
if((i__4865__auto___38822 < len__4864__auto___38821)){
args__4870__auto__.push((arguments[i__4865__auto___38822]));

var G__38823 = (i__4865__auto___38822 + (1));
i__4865__auto___38822 = G__38823;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38820){var e = e38820;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq38819){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38819));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38826 = arguments.length;
var i__4865__auto___38827 = (0);
while(true){
if((i__4865__auto___38827 < len__4864__auto___38826)){
args__4870__auto__.push((arguments[i__4865__auto___38827]));

var G__38828 = (i__4865__auto___38827 + (1));
i__4865__auto___38827 = G__38828;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38825){var e = e38825;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq38824){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38824));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e38829){var e = e38829;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38832 = arguments.length;
var i__4865__auto___38833 = (0);
while(true){
if((i__4865__auto___38833 < len__4864__auto___38832)){
args__4870__auto__.push((arguments[i__4865__auto___38833]));

var G__38834 = (i__4865__auto___38833 + (1));
i__4865__auto___38833 = G__38834;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e38831){var e = e38831;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq38830){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38830));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38837 = arguments.length;
var i__4865__auto___38838 = (0);
while(true){
if((i__4865__auto___38838 < len__4864__auto___38837)){
args__4870__auto__.push((arguments[i__4865__auto___38838]));

var G__38839 = (i__4865__auto___38838 + (1));
i__4865__auto___38838 = G__38839;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e38836){var e = e38836;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq38835){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38835));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e38840){var e = e38840;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e38841){var e = e38841;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38844 = arguments.length;
var i__4865__auto___38845 = (0);
while(true){
if((i__4865__auto___38845 < len__4864__auto___38844)){
args__4870__auto__.push((arguments[i__4865__auto___38845]));

var G__38846 = (i__4865__auto___38845 + (1));
i__4865__auto___38845 = G__38846;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38843){var e = e38843;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq38842){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38842));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38849 = arguments.length;
var i__4865__auto___38850 = (0);
while(true){
if((i__4865__auto___38850 < len__4864__auto___38849)){
args__4870__auto__.push((arguments[i__4865__auto___38850]));

var G__38851 = (i__4865__auto___38850 + (1));
i__4865__auto___38850 = G__38851;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38848){var e = e38848;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq38847){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38847));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38854 = arguments.length;
var i__4865__auto___38855 = (0);
while(true){
if((i__4865__auto___38855 < len__4864__auto___38854)){
args__4870__auto__.push((arguments[i__4865__auto___38855]));

var G__38856 = (i__4865__auto___38855 + (1));
i__4865__auto___38855 = G__38856;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e38853){var e = e38853;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq38852){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38852));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38859 = arguments.length;
var i__4865__auto___38860 = (0);
while(true){
if((i__4865__auto___38860 < len__4864__auto___38859)){
args__4870__auto__.push((arguments[i__4865__auto___38860]));

var G__38861 = (i__4865__auto___38860 + (1));
i__4865__auto___38860 = G__38861;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e38858){var e = e38858;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq38857){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38857));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38864 = arguments.length;
var i__4865__auto___38865 = (0);
while(true){
if((i__4865__auto___38865 < len__4864__auto___38864)){
args__4870__auto__.push((arguments[i__4865__auto___38865]));

var G__38866 = (i__4865__auto___38865 + (1));
i__4865__auto___38865 = G__38866;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e38863){var e = e38863;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq38862){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38862));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38869 = arguments.length;
var i__4865__auto___38870 = (0);
while(true){
if((i__4865__auto___38870 < len__4864__auto___38869)){
args__4870__auto__.push((arguments[i__4865__auto___38870]));

var G__38871 = (i__4865__auto___38870 + (1));
i__4865__auto___38870 = G__38871;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e38868){var e = e38868;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq38867){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38867));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___38874 = arguments.length;
var i__4865__auto___38875 = (0);
while(true){
if((i__4865__auto___38875 < len__4864__auto___38874)){
args__4870__auto__.push((arguments[i__4865__auto___38875]));

var G__38876 = (i__4865__auto___38875 + (1));
i__4865__auto___38875 = G__38876;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e38873){var e = e38873;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq38872){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38872));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__38878 = arguments.length;
switch (G__38878) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38906){
var state_val_38907 = (state_38906[(1)]);
if((state_val_38907 === (7))){
var inst_38891 = (state_38906[(7)]);
var inst_38894 = fluree.db.dbfunctions.internal.function_error.call(null,inst_38891,"query",query_map);
var state_38906__$1 = state_38906;
var statearr_38908_38994 = state_38906__$1;
(statearr_38908_38994[(2)] = inst_38894);

(statearr_38908_38994[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (1))){
var state_38906__$1 = state_38906;
var statearr_38909_38995 = state_38906__$1;
(statearr_38909_38995[(2)] = null);

(statearr_38909_38995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (4))){
var inst_38879 = (state_38906[(2)]);
var state_38906__$1 = state_38906;
var statearr_38910_38996 = state_38906__$1;
(statearr_38910_38996[(2)] = inst_38879);

(statearr_38910_38996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (6))){
var inst_38891 = (state_38906[(7)]);
var inst_38891__$1 = (state_38906[(2)]);
var inst_38892 = fluree.db.util.core.exception_QMARK_.call(null,inst_38891__$1);
var state_38906__$1 = (function (){var statearr_38911 = state_38906;
(statearr_38911[(7)] = inst_38891__$1);

return statearr_38911;
})();
if(inst_38892){
var statearr_38912_38997 = state_38906__$1;
(statearr_38912_38997[(1)] = (7));

} else {
var statearr_38913_38998 = state_38906__$1;
(statearr_38913_38998[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (3))){
var inst_38904 = (state_38906[(2)]);
var state_38906__$1 = state_38906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38906__$1,inst_38904);
} else {
if((state_val_38907 === (2))){
var inst_38885 = (state_38906[(8)]);
var _ = (function (){var statearr_38915 = state_38906;
(statearr_38915[(4)] = cljs.core.cons.call(null,(5),(state_38906[(4)])));

return statearr_38915;
})();
var inst_38885__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_38886 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_38887 = cljs.core.assoc.call(null,inst_38886,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_38885__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_38888 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_38887);
var inst_38889 = fluree.db.query.fql.query.call(null,db,inst_38888);
var state_38906__$1 = (function (){var statearr_38916 = state_38906;
(statearr_38916[(8)] = inst_38885__$1);

return statearr_38916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38906__$1,(6),inst_38889);
} else {
if((state_val_38907 === (9))){
var inst_38901 = (state_38906[(2)]);
var _ = (function (){var statearr_38917 = state_38906;
(statearr_38917[(4)] = cljs.core.rest.call(null,(state_38906[(4)])));

return statearr_38917;
})();
var state_38906__$1 = state_38906;
var statearr_38918_38999 = state_38906__$1;
(statearr_38918_38999[(2)] = inst_38901);

(statearr_38918_38999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (5))){
var _ = (function (){var statearr_38919 = state_38906;
(statearr_38919[(4)] = cljs.core.rest.call(null,(state_38906[(4)])));

return statearr_38919;
})();
var state_38906__$1 = state_38906;
var ex38914 = (state_38906__$1[(2)]);
var statearr_38920_39000 = state_38906__$1;
(statearr_38920_39000[(5)] = ex38914);


if((ex38914 instanceof Error)){
var statearr_38921_39001 = state_38906__$1;
(statearr_38921_39001[(1)] = (4));

(statearr_38921_39001[(5)] = null);

} else {
throw ex38914;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38907 === (8))){
var inst_38885 = (state_38906[(8)]);
var inst_38891 = (state_38906[(7)]);
var inst_38896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38897 = cljs.core.deref.call(null,inst_38885);
var inst_38898 = [inst_38891,inst_38897];
var inst_38899 = (new cljs.core.PersistentVector(null,2,(5),inst_38896,inst_38898,null));
var state_38906__$1 = state_38906;
var statearr_38922_39002 = state_38906__$1;
(statearr_38922_39002[(2)] = inst_38899);

(statearr_38922_39002[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10903__auto____0 = (function (){
var statearr_38923 = [null,null,null,null,null,null,null,null,null];
(statearr_38923[(0)] = fluree$db$dbfunctions$internal$state_machine__10903__auto__);

(statearr_38923[(1)] = (1));

return statearr_38923;
});
var fluree$db$dbfunctions$internal$state_machine__10903__auto____1 = (function (state_38906){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38924){var ex__10906__auto__ = e38924;
var statearr_38925_39003 = state_38906;
(statearr_38925_39003[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38906[(4)]))){
var statearr_38926_39004 = state_38906;
(statearr_38926_39004[(1)] = cljs.core.first.call(null,(state_38906[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39005 = state_38906;
state_38906 = G__39005;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10903__auto__ = function(state_38906){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____1.call(this,state_38906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38927 = f__10977__auto__.call(null);
(statearr_38927[(6)] = c__10976__auto__);

return statearr_38927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38972){
var state_val_38973 = (state_38972[(1)]);
if((state_val_38973 === (7))){
var inst_38958 = (state_38972[(2)]);
var inst_38959 = fluree.db.query.fql.query.call(null,db,inst_38958);
var state_38972__$1 = state_38972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38972__$1,(8),inst_38959);
} else {
if((state_val_38973 === (1))){
var inst_38928 = typeof select === 'string';
var state_38972__$1 = state_38972;
if(cljs.core.truth_(inst_38928)){
var statearr_38974_39006 = state_38972__$1;
(statearr_38974_39006[(1)] = (2));

} else {
var statearr_38975_39007 = state_38972__$1;
(statearr_38975_39007[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (4))){
var inst_38941 = (state_38972[(7)]);
var inst_38934 = (state_38972[(8)]);
var inst_38933 = (state_38972[(2)]);
var inst_38934__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_38935 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_38936 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_38937 = [inst_38934__$1,(100000)];
var inst_38938 = cljs.core.PersistentHashMap.fromArrays(inst_38936,inst_38937);
var inst_38939 = [inst_38933,from,where,block,limit,inst_38938];
var inst_38940 = cljs.core.PersistentHashMap.fromArrays(inst_38935,inst_38939);
var inst_38941__$1 = fluree.db.util.core.without_nils.call(null,inst_38940);
var inst_38942 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38941__$1);
var inst_38943 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38941__$1);
var inst_38944 = cljs.core.first.call(null,inst_38943);
var inst_38945 = fluree.db.dbfunctions.internal.str.call(null,inst_38944);
var inst_38946 = cljs.core._EQ_.call(null,"[",inst_38945);
var inst_38947 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38941__$1);
var inst_38948 = cljs.core.last.call(null,inst_38947);
var inst_38949 = fluree.db.dbfunctions.internal.str.call(null,inst_38948);
var inst_38950 = cljs.core._EQ_.call(null,"]",inst_38949);
var inst_38951 = fluree.db.dbfunctions.internal.and.call(null,inst_38942,inst_38946,inst_38950);
var state_38972__$1 = (function (){var statearr_38976 = state_38972;
(statearr_38976[(7)] = inst_38941__$1);

(statearr_38976[(8)] = inst_38934__$1);

return statearr_38976;
})();
if(cljs.core.truth_(inst_38951)){
var statearr_38977_39008 = state_38972__$1;
(statearr_38977_39008[(1)] = (5));

} else {
var statearr_38978_39009 = state_38972__$1;
(statearr_38978_39009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (6))){
var inst_38941 = (state_38972[(7)]);
var state_38972__$1 = state_38972;
var statearr_38979_39010 = state_38972__$1;
(statearr_38979_39010[(2)] = inst_38941);

(statearr_38979_39010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (3))){
var state_38972__$1 = state_38972;
var statearr_38980_39011 = state_38972__$1;
(statearr_38980_39011[(2)] = select);

(statearr_38980_39011[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (2))){
var inst_38930 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_38972__$1 = state_38972;
var statearr_38981_39012 = state_38972__$1;
(statearr_38981_39012[(2)] = inst_38930);

(statearr_38981_39012[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (11))){
var inst_38970 = (state_38972[(2)]);
var state_38972__$1 = state_38972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38972__$1,inst_38970);
} else {
if((state_val_38973 === (9))){
var inst_38961 = (state_38972[(9)]);
var state_38972__$1 = state_38972;
var statearr_38982_39013 = state_38972__$1;
(statearr_38982_39013[(2)] = inst_38961);

(statearr_38982_39013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (5))){
var inst_38941 = (state_38972[(7)]);
var inst_38953 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_38941);
var inst_38954 = cljs.reader.read_string.call(null,inst_38953);
var inst_38955 = cljs.core.assoc.call(null,inst_38941,new cljs.core.Keyword(null,"where","where",-2044795965),inst_38954);
var state_38972__$1 = state_38972;
var statearr_38983_39014 = state_38972__$1;
(statearr_38983_39014[(2)] = inst_38955);

(statearr_38983_39014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (10))){
var inst_38934 = (state_38972[(8)]);
var inst_38961 = (state_38972[(9)]);
var inst_38965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38966 = cljs.core.deref.call(null,inst_38934);
var inst_38967 = [inst_38961,inst_38966];
var inst_38968 = (new cljs.core.PersistentVector(null,2,(5),inst_38965,inst_38967,null));
var state_38972__$1 = state_38972;
var statearr_38984_39015 = state_38972__$1;
(statearr_38984_39015[(2)] = inst_38968);

(statearr_38984_39015[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38973 === (8))){
var inst_38961 = (state_38972[(9)]);
var inst_38961__$1 = (state_38972[(2)]);
var inst_38962 = fluree.db.util.core.exception_QMARK_.call(null,inst_38961__$1);
var state_38972__$1 = (function (){var statearr_38985 = state_38972;
(statearr_38985[(9)] = inst_38961__$1);

return statearr_38985;
})();
if(inst_38962){
var statearr_38986_39016 = state_38972__$1;
(statearr_38986_39016[(1)] = (9));

} else {
var statearr_38987_39017 = state_38972__$1;
(statearr_38987_39017[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10903__auto____0 = (function (){
var statearr_38988 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38988[(0)] = fluree$db$dbfunctions$internal$state_machine__10903__auto__);

(statearr_38988[(1)] = (1));

return statearr_38988;
});
var fluree$db$dbfunctions$internal$state_machine__10903__auto____1 = (function (state_38972){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38989){var ex__10906__auto__ = e38989;
var statearr_38990_39018 = state_38972;
(statearr_38990_39018[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38972[(4)]))){
var statearr_38991_39019 = state_38972;
(statearr_38991_39019[(1)] = cljs.core.first.call(null,(state_38972[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39020 = state_38972;
state_38972 = G__39020;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10903__auto__ = function(state_38972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____1.call(this,state_38972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38992 = f__10977__auto__.call(null);
(statearr_38992[(6)] = c__10976__auto__);

return statearr_38992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__39024 = path;
var vec__39025 = G__39024;
var seq__39026 = cljs.core.seq.call(null,vec__39025);
var first__39027 = cljs.core.first.call(null,seq__39026);
var seq__39026__$1 = cljs.core.next.call(null,seq__39026);
var var$ = first__39027;
var r = seq__39026__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__39024__$1 = G__39024;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__39031 = G__39024__$1;
var seq__39032 = cljs.core.seq.call(null,vec__39031);
var first__39033 = cljs.core.first.call(null,seq__39032);
var seq__39032__$1 = cljs.core.next.call(null,seq__39032);
var var$__$1 = first__39033;
var r__$1 = seq__39032__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__39034 = r__$1;
var G__39035 = n__$2;
var G__39036 = next_clauses;
G__39024__$1 = G__39034;
n__$1 = G__39035;
where_clauses__$1 = G__39036;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__39037 = r__$1;
var G__39038 = next_n;
var G__39039 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__39024__$1 = G__39037;
n__$1 = G__39038;
where_clauses__$1 = G__39039;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39076){
var state_val_39077 = (state_39076[(1)]);
if((state_val_39077 === (7))){
var inst_39049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39050 = [path];
var inst_39051 = (new cljs.core.PersistentVector(null,1,(5),inst_39049,inst_39050,null));
var state_39076__$1 = state_39076;
var statearr_39078_39106 = state_39076__$1;
(statearr_39078_39106[(2)] = inst_39051);

(statearr_39078_39106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (1))){
var state_39076__$1 = state_39076;
var statearr_39079_39107 = state_39076__$1;
(statearr_39079_39107[(2)] = null);

(statearr_39079_39107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (4))){
var inst_39040 = (state_39076[(2)]);
var state_39076__$1 = state_39076;
var statearr_39080_39108 = state_39076__$1;
(statearr_39080_39108[(2)] = inst_39040);

(statearr_39080_39108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (13))){
var inst_39067 = (state_39076[(2)]);
var inst_39068 = fluree.db.util.async.throw_err.call(null,inst_39067);
var _ = (function (){var statearr_39081 = state_39076;
(statearr_39081[(4)] = cljs.core.rest.call(null,(state_39076[(4)])));

return statearr_39081;
})();
var state_39076__$1 = state_39076;
var statearr_39082_39109 = state_39076__$1;
(statearr_39082_39109[(2)] = inst_39068);

(statearr_39082_39109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (6))){
var state_39076__$1 = state_39076;
var statearr_39084_39110 = state_39076__$1;
(statearr_39084_39110[(2)] = path);

(statearr_39084_39110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (3))){
var inst_39074 = (state_39076[(2)]);
var state_39076__$1 = state_39076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39076__$1,inst_39074);
} else {
if((state_val_39077 === (12))){
var _ = (function (){var statearr_39085 = state_39076;
(statearr_39085[(4)] = cljs.core.rest.call(null,(state_39076[(4)])));

return statearr_39085;
})();
var state_39076__$1 = state_39076;
var ex39083 = (state_39076__$1[(2)]);
var statearr_39086_39111 = state_39076__$1;
(statearr_39086_39111[(5)] = ex39083);


var statearr_39087_39112 = state_39076__$1;
(statearr_39087_39112[(1)] = (11));

(statearr_39087_39112[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (2))){
var _ = (function (){var statearr_39088 = state_39076;
(statearr_39088[(4)] = cljs.core.cons.call(null,(5),(state_39076[(4)])));

return statearr_39088;
})();
var inst_39046 = cljs.core.vector_QMARK_.call(null,path);
var state_39076__$1 = state_39076;
if(inst_39046){
var statearr_39089_39113 = state_39076__$1;
(statearr_39089_39113[(1)] = (6));

} else {
var statearr_39090_39114 = state_39076__$1;
(statearr_39090_39114[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (11))){
var inst_39053 = (state_39076[(7)]);
var inst_39058 = (state_39076[(2)]);
var inst_39059 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39058,"relationship?",startSubject,inst_39053,endSubject);
var state_39076__$1 = state_39076;
var statearr_39092_39115 = state_39076__$1;
(statearr_39092_39115[(2)] = inst_39059);

(statearr_39092_39115[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (9))){
var inst_39057 = (state_39076[(8)]);
var _ = (function (){var statearr_39093 = state_39076;
(statearr_39093[(4)] = cljs.core.cons.call(null,(12),(state_39076[(4)])));

return statearr_39093;
})();
var inst_39065 = fluree.db.dbfunctions.internal.query.call(null,db,inst_39057);
var state_39076__$1 = state_39076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39076__$1,(13),inst_39065);
} else {
if((state_val_39077 === (5))){
var _ = (function (){var statearr_39094 = state_39076;
(statearr_39094[(4)] = cljs.core.rest.call(null,(state_39076[(4)])));

return statearr_39094;
})();
var state_39076__$1 = state_39076;
var ex39091 = (state_39076__$1[(2)]);
var statearr_39095_39116 = state_39076__$1;
(statearr_39095_39116[(5)] = ex39091);


if((ex39091 instanceof Error)){
var statearr_39096_39117 = state_39076__$1;
(statearr_39096_39117[(1)] = (4));

(statearr_39096_39117[(5)] = null);

} else {
throw ex39091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (10))){
var inst_39071 = (state_39076[(2)]);
var _ = (function (){var statearr_39097 = state_39076;
(statearr_39097[(4)] = cljs.core.rest.call(null,(state_39076[(4)])));

return statearr_39097;
})();
var state_39076__$1 = state_39076;
var statearr_39098_39118 = state_39076__$1;
(statearr_39098_39118[(2)] = inst_39071);

(statearr_39098_39118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39077 === (8))){
var inst_39053 = (state_39076[(7)]);
var inst_39053__$1 = (state_39076[(2)]);
var inst_39054 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_39053__$1,endSubject);
var inst_39055 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_39056 = ["?var1",inst_39054];
var inst_39057 = cljs.core.PersistentHashMap.fromArrays(inst_39055,inst_39056);
var state_39076__$1 = (function (){var statearr_39099 = state_39076;
(statearr_39099[(8)] = inst_39057);

(statearr_39099[(7)] = inst_39053__$1);

return statearr_39099;
})();
var statearr_39100_39119 = state_39076__$1;
(statearr_39100_39119[(2)] = null);

(statearr_39100_39119[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_39101 = [null,null,null,null,null,null,null,null,null];
(statearr_39101[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__);

(statearr_39101[(1)] = (1));

return statearr_39101;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____1 = (function (state_39076){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39102){var ex__10906__auto__ = e39102;
var statearr_39103_39120 = state_39076;
(statearr_39103_39120[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39076[(4)]))){
var statearr_39104_39121 = state_39076;
(statearr_39104_39121[(1)] = cljs.core.first.call(null,(state_39076[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39122 = state_39076;
state_39076 = G__39122;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__ = function(state_39076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____1.call(this,state_39076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39105 = f__10977__auto__.call(null);
(statearr_39105[(6)] = c__10976__auto__);

return statearr_39105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e39123){var e = e39123;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e39124){var e = e39124;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e39125){var e = e39125;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e39126){var e = e39126;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39129 = arguments.length;
var i__4865__auto___39130 = (0);
while(true){
if((i__4865__auto___39130 < len__4864__auto___39129)){
args__4870__auto__.push((arguments[i__4865__auto___39130]));

var G__39131 = (i__4865__auto___39130 + (1));
i__4865__auto___39130 = G__39131;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e39128){var e = e39128;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq39127){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39127));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39134 = arguments.length;
var i__4865__auto___39135 = (0);
while(true){
if((i__4865__auto___39135 < len__4864__auto___39134)){
args__4870__auto__.push((arguments[i__4865__auto___39135]));

var G__39136 = (i__4865__auto___39135 + (1));
i__4865__auto___39135 = G__39136;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e39133){var e = e39133;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq39132){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39132));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39139 = arguments.length;
var i__4865__auto___39140 = (0);
while(true){
if((i__4865__auto___39140 < len__4864__auto___39139)){
args__4870__auto__.push((arguments[i__4865__auto___39140]));

var G__39141 = (i__4865__auto___39140 + (1));
i__4865__auto___39140 = G__39141;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e39138){var e = e39138;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq39137){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39137));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39144 = arguments.length;
var i__4865__auto___39145 = (0);
while(true){
if((i__4865__auto___39145 < len__4864__auto___39144)){
args__4870__auto__.push((arguments[i__4865__auto___39145]));

var G__39146 = (i__4865__auto___39145 + (1));
i__4865__auto___39145 = G__39146;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e39143){var e = e39143;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq39142){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39142));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e39147){var e = e39147;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e39148){var e = e39148;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e39149){var e = e39149;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e39150){var e = e39150;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e39151){var e = e39151;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__39157 = path;
var vec__39158 = G__39157;
var seq__39159 = cljs.core.seq.call(null,vec__39158);
var first__39160 = cljs.core.first.call(null,seq__39159);
var seq__39159__$1 = cljs.core.next.call(null,seq__39159);
var pred = first__39160;
var r = seq__39159__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__39157__$1 = G__39157;
var subjects__$1 = subjects;
while(true){
var vec__39164 = G__39157__$1;
var seq__39165 = cljs.core.seq.call(null,vec__39164);
var first__39166 = cljs.core.first.call(null,seq__39165);
var seq__39165__$1 = cljs.core.next.call(null,seq__39165);
var pred__$1 = first__39166;
var r__$1 = seq__39165__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__39157__$1,subjects__$1,vec__39164,seq__39165,first__39166,seq__39165__$1,pred__$1,r__$1,subjects__$2,G__39157,vec__39158,seq__39159,first__39160,seq__39159__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__39157__$1,subjects__$1,vec__39164,seq__39165,first__39166,seq__39165__$1,pred__$1,r__$1,subjects__$2,G__39157,vec__39158,seq__39159,first__39160,seq__39159__$1,pred,r,subjects){
return (function (p1__39152_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__39152_SHARP_,pred__$1);
});})(G__39157__$1,subjects__$1,vec__39164,seq__39165,first__39166,seq__39165__$1,pred__$1,r__$1,subjects__$2,G__39157,vec__39158,seq__39159,first__39160,seq__39159__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__39157__$1,subjects__$1,vec__39164,seq__39165,first__39166,seq__39165__$1,pred__$1,r__$1,subjects__$2,G__39157,vec__39158,seq__39159,first__39160,seq__39159__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__39167 = r__$1;
var G__39168 = next_subjects;
G__39157__$1 = G__39167;
subjects__$1 = G__39168;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e39153){var e = e39153;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e39169){var e = e39169;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e39170){var e = e39170;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39173 = arguments.length;
var i__4865__auto___39174 = (0);
while(true){
if((i__4865__auto___39174 < len__4864__auto___39173)){
args__4870__auto__.push((arguments[i__4865__auto___39174]));

var G__39175 = (i__4865__auto___39174 + (1));
i__4865__auto___39174 = G__39175;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e39172){var e = e39172;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq39171){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39171));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e39176){var e = e39176;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39179 = arguments.length;
var i__4865__auto___39180 = (0);
while(true){
if((i__4865__auto___39180 < len__4864__auto___39179)){
args__4870__auto__.push((arguments[i__4865__auto___39180]));

var G__39181 = (i__4865__auto___39180 + (1));
i__4865__auto___39180 = G__39181;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e39178){var e = e39178;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq39177){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39177));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e39182){var e = e39182;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39239){
var state_val_39240 = (state_39239[(1)]);
if((state_val_39240 === (7))){
var inst_39185 = (state_39239[(2)]);
var state_39239__$1 = state_39239;
var statearr_39241_39275 = state_39239__$1;
(statearr_39241_39275[(2)] = inst_39185);

(statearr_39241_39275[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (1))){
var state_39239__$1 = state_39239;
var statearr_39242_39276 = state_39239__$1;
(statearr_39242_39276[(2)] = null);

(statearr_39242_39276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (4))){
var inst_39184 = (state_39239[(2)]);
var state_39239__$1 = (function (){var statearr_39243 = state_39239;
(statearr_39243[(7)] = inst_39184);

return statearr_39243;
})();
var statearr_39244_39277 = state_39239__$1;
(statearr_39244_39277[(2)] = null);

(statearr_39244_39277[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (15))){
var inst_39220 = (state_39239[(8)]);
var inst_39219 = (state_39239[(9)]);
var inst_39222 = (state_39239[(10)]);
var inst_39209 = (state_39239[(11)]);
var inst_39207 = (state_39239[(12)]);
var inst_39210 = (state_39239[(13)]);
var inst_39226 = (function (){var db = inst_39207;
var prevT = inst_39209;
var db_SINGLEQUOTE_ = inst_39210;
var prev_vals = inst_39219;
var fuel = inst_39220;
var G__39221 = inst_39222;
return (function (p1__39183_SHARP_){
var f = p1__39183_SHARP_;
return f.o;
});
})();
var inst_39227 = inst_39226.call(null,inst_39222);
var state_39239__$1 = state_39239;
var statearr_39245_39278 = state_39239__$1;
(statearr_39245_39278[(2)] = inst_39227);

(statearr_39245_39278[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (13))){
var inst_39219 = (state_39239[(9)]);
var inst_39222 = (state_39239[(10)]);
var inst_39218 = (state_39239[(2)]);
var inst_39219__$1 = fluree.db.util.async.throw_err.call(null,inst_39218);
var inst_39220 = fluree.db.dbfunctions.internal.count.call(null,inst_39219__$1);
var inst_39222__$1 = cljs.core.first.call(null,inst_39219__$1);
var inst_39223 = (inst_39222__$1 == null);
var state_39239__$1 = (function (){var statearr_39246 = state_39239;
(statearr_39246[(8)] = inst_39220);

(statearr_39246[(9)] = inst_39219__$1);

(statearr_39246[(10)] = inst_39222__$1);

return statearr_39246;
})();
if(cljs.core.truth_(inst_39223)){
var statearr_39247_39279 = state_39239__$1;
(statearr_39247_39279[(1)] = (14));

} else {
var statearr_39248_39280 = state_39239__$1;
(statearr_39248_39280[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (6))){
var inst_39194 = (state_39239[(2)]);
var state_39239__$1 = state_39239;
var statearr_39249_39281 = state_39239__$1;
(statearr_39249_39281[(2)] = inst_39194);

(statearr_39249_39281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (3))){
var inst_39237 = (state_39239[(2)]);
var state_39239__$1 = state_39239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39239__$1,inst_39237);
} else {
if((state_val_39240 === (12))){
var inst_39234 = (state_39239[(2)]);
var _ = (function (){var statearr_39250 = state_39239;
(statearr_39250[(4)] = cljs.core.rest.call(null,(state_39239[(4)])));

return statearr_39250;
})();
var state_39239__$1 = state_39239;
var statearr_39251_39282 = state_39239__$1;
(statearr_39251_39282[(2)] = inst_39234);

(statearr_39251_39282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (2))){
var _ = (function (){var statearr_39253 = state_39239;
(statearr_39253[(4)] = cljs.core.cons.call(null,(9),(state_39239[(4)])));

return statearr_39253;
})();
var inst_39200 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39201 = typeof inst_39200 === 'string';
var state_39239__$1 = state_39239;
if(cljs.core.truth_(inst_39201)){
var statearr_39254_39283 = state_39239__$1;
(statearr_39254_39283[(1)] = (10));

} else {
var statearr_39255_39284 = state_39239__$1;
(statearr_39255_39284[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (11))){
var inst_39209 = (state_39239[(11)]);
var inst_39207 = (state_39239[(12)]);
var inst_39210 = (state_39239[(13)]);
var inst_39207__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39208 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_39207__$1);
var inst_39209__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_39208);
var inst_39210__$1 = cljs.core.assoc.call(null,inst_39207__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_39209__$1);
var inst_39211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39212 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39213 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39214 = [inst_39212,inst_39213];
var inst_39215 = (new cljs.core.PersistentVector(null,2,(5),inst_39211,inst_39214,null));
var inst_39216 = fluree.db.dbproto._search.call(null,inst_39210__$1,inst_39215);
var state_39239__$1 = (function (){var statearr_39256 = state_39239;
(statearr_39256[(11)] = inst_39209__$1);

(statearr_39256[(12)] = inst_39207__$1);

(statearr_39256[(13)] = inst_39210__$1);

return statearr_39256;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39239__$1,(13),inst_39216);
} else {
if((state_val_39240 === (9))){
var _ = (function (){var statearr_39257 = state_39239;
(statearr_39257[(4)] = cljs.core.rest.call(null,(state_39239[(4)])));

return statearr_39257;
})();
var state_39239__$1 = state_39239;
var ex39252 = (state_39239__$1[(2)]);
var statearr_39258_39285 = state_39239__$1;
(statearr_39258_39285[(5)] = ex39252);


var statearr_39259_39286 = state_39239__$1;
(statearr_39259_39286[(1)] = (4));

(statearr_39259_39286[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (5))){
var inst_39184 = (state_39239[(7)]);
var _ = (function (){var statearr_39260 = state_39239;
(statearr_39260[(4)] = cljs.core.cons.call(null,(8),(state_39239[(4)])));

return statearr_39260;
})();
var inst_39191 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39184,"?pO","Context Object");
var ___$1 = (function (){var statearr_39261 = state_39239;
(statearr_39261[(4)] = cljs.core.rest.call(null,(state_39239[(4)])));

return statearr_39261;
})();
var state_39239__$1 = state_39239;
var statearr_39262_39287 = state_39239__$1;
(statearr_39262_39287[(2)] = inst_39191);

(statearr_39262_39287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (14))){
var state_39239__$1 = state_39239;
var statearr_39263_39288 = state_39239__$1;
(statearr_39263_39288[(2)] = null);

(statearr_39263_39288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (16))){
var inst_39220 = (state_39239[(8)]);
var inst_39229 = (state_39239[(2)]);
var inst_39230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39231 = [inst_39229,inst_39220];
var inst_39232 = (new cljs.core.PersistentVector(null,2,(5),inst_39230,inst_39231,null));
var state_39239__$1 = state_39239;
var statearr_39265_39289 = state_39239__$1;
(statearr_39265_39289[(2)] = inst_39232);

(statearr_39265_39289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (10))){
var inst_39203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39204 = [null,(0)];
var inst_39205 = (new cljs.core.PersistentVector(null,2,(5),inst_39203,inst_39204,null));
var state_39239__$1 = state_39239;
var statearr_39266_39290 = state_39239__$1;
(statearr_39266_39290[(2)] = inst_39205);

(statearr_39266_39290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39240 === (8))){
var _ = (function (){var statearr_39267 = state_39239;
(statearr_39267[(4)] = cljs.core.rest.call(null,(state_39239[(4)])));

return statearr_39267;
})();
var state_39239__$1 = state_39239;
var ex39264 = (state_39239__$1[(2)]);
var statearr_39268_39291 = state_39239__$1;
(statearr_39268_39291[(5)] = ex39264);


var statearr_39269_39292 = state_39239__$1;
(statearr_39269_39292[(1)] = (7));

(statearr_39269_39292[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____0 = (function (){
var statearr_39270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39270[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__);

(statearr_39270[(1)] = (1));

return statearr_39270;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____1 = (function (state_39239){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39271){var ex__10906__auto__ = e39271;
var statearr_39272_39293 = state_39239;
(statearr_39272_39293[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39239[(4)]))){
var statearr_39273_39294 = state_39239;
(statearr_39273_39294[(1)] = cljs.core.first.call(null,(state_39239[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39295 = state_39239;
state_39239 = G__39295;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__ = function(state_39239){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____1.call(this,state_39239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39274 = f__10977__auto__.call(null);
(statearr_39274[(6)] = c__10976__auto__);

return statearr_39274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39347){
var state_val_39348 = (state_39347[(1)]);
if((state_val_39348 === (7))){
var inst_39297 = (state_39347[(2)]);
var state_39347__$1 = state_39347;
var statearr_39349_39378 = state_39347__$1;
(statearr_39349_39378[(2)] = inst_39297);

(statearr_39349_39378[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (1))){
var state_39347__$1 = state_39347;
var statearr_39350_39379 = state_39347__$1;
(statearr_39350_39379[(2)] = null);

(statearr_39350_39379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (4))){
var inst_39296 = (state_39347[(2)]);
var state_39347__$1 = (function (){var statearr_39351 = state_39347;
(statearr_39351[(7)] = inst_39296);

return statearr_39351;
})();
var statearr_39352_39380 = state_39347__$1;
(statearr_39352_39380[(2)] = null);

(statearr_39352_39380[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (13))){
var inst_39342 = (state_39347[(2)]);
var _ = (function (){var statearr_39353 = state_39347;
(statearr_39353[(4)] = cljs.core.rest.call(null,(state_39347[(4)])));

return statearr_39353;
})();
var state_39347__$1 = state_39347;
var statearr_39354_39381 = state_39347__$1;
(statearr_39354_39381[(2)] = inst_39342);

(statearr_39354_39381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (6))){
var inst_39306 = (state_39347[(2)]);
var state_39347__$1 = state_39347;
var statearr_39355_39382 = state_39347__$1;
(statearr_39355_39382[(2)] = inst_39306);

(statearr_39355_39382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (3))){
var inst_39345 = (state_39347[(2)]);
var state_39347__$1 = state_39347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39347__$1,inst_39345);
} else {
if((state_val_39348 === (12))){
var inst_39329 = (state_39347[(8)]);
var inst_39338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39339 = [null,inst_39329];
var inst_39340 = (new cljs.core.PersistentVector(null,2,(5),inst_39338,inst_39339,null));
var state_39347__$1 = state_39347;
var statearr_39356_39383 = state_39347__$1;
(statearr_39356_39383[(2)] = inst_39340);

(statearr_39356_39383[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (2))){
var _ = (function (){var statearr_39358 = state_39347;
(statearr_39358[(4)] = cljs.core.cons.call(null,(9),(state_39347[(4)])));

return statearr_39358;
})();
var inst_39315 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39318 = [null,pred_name,"?o"];
var inst_39319 = (new cljs.core.PersistentVector(null,3,(5),inst_39317,inst_39318,null));
var inst_39320 = [inst_39319];
var inst_39321 = (new cljs.core.PersistentVector(null,1,(5),inst_39316,inst_39320,null));
var inst_39322 = ["?o",inst_39321,opts];
var inst_39323 = cljs.core.PersistentHashMap.fromArrays(inst_39315,inst_39322);
var inst_39324 = fluree.db.dbfunctions.internal.query.call(null,db,inst_39323);
var state_39347__$1 = state_39347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39347__$1,(10),inst_39324);
} else {
if((state_val_39348 === (11))){
var inst_39329 = (state_39347[(8)]);
var inst_39328 = (state_39347[(9)]);
var inst_39333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39334 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_39328);
var inst_39335 = [inst_39334,inst_39329];
var inst_39336 = (new cljs.core.PersistentVector(null,2,(5),inst_39333,inst_39335,null));
var state_39347__$1 = state_39347;
var statearr_39359_39384 = state_39347__$1;
(statearr_39359_39384[(2)] = inst_39336);

(statearr_39359_39384[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (9))){
var _ = (function (){var statearr_39360 = state_39347;
(statearr_39360[(4)] = cljs.core.rest.call(null,(state_39347[(4)])));

return statearr_39360;
})();
var state_39347__$1 = state_39347;
var ex39357 = (state_39347__$1[(2)]);
var statearr_39361_39385 = state_39347__$1;
(statearr_39361_39385[(5)] = ex39357);


var statearr_39362_39386 = state_39347__$1;
(statearr_39362_39386[(1)] = (4));

(statearr_39362_39386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (5))){
var inst_39296 = (state_39347[(7)]);
var _ = (function (){var statearr_39364 = state_39347;
(statearr_39364[(4)] = cljs.core.cons.call(null,(8),(state_39347[(4)])));

return statearr_39364;
})();
var inst_39303 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39296,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_39365 = state_39347;
(statearr_39365[(4)] = cljs.core.rest.call(null,(state_39347[(4)])));

return statearr_39365;
})();
var state_39347__$1 = state_39347;
var statearr_39366_39387 = state_39347__$1;
(statearr_39366_39387[(2)] = inst_39303);

(statearr_39366_39387[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (10))){
var inst_39328 = (state_39347[(9)]);
var inst_39326 = (state_39347[(2)]);
var inst_39327 = fluree.db.util.async.throw_err.call(null,inst_39326);
var inst_39328__$1 = cljs.core.nth.call(null,inst_39327,(0),null);
var inst_39329 = cljs.core.nth.call(null,inst_39327,(1),null);
var inst_39330 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_39328__$1);
var inst_39331 = cljs.core.not.call(null,inst_39330);
var state_39347__$1 = (function (){var statearr_39367 = state_39347;
(statearr_39367[(8)] = inst_39329);

(statearr_39367[(9)] = inst_39328__$1);

return statearr_39367;
})();
if(inst_39331){
var statearr_39368_39388 = state_39347__$1;
(statearr_39368_39388[(1)] = (11));

} else {
var statearr_39369_39389 = state_39347__$1;
(statearr_39369_39389[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39348 === (8))){
var _ = (function (){var statearr_39370 = state_39347;
(statearr_39370[(4)] = cljs.core.rest.call(null,(state_39347[(4)])));

return statearr_39370;
})();
var state_39347__$1 = state_39347;
var ex39363 = (state_39347__$1[(2)]);
var statearr_39371_39390 = state_39347__$1;
(statearr_39371_39390[(5)] = ex39363);


var statearr_39372_39391 = state_39347__$1;
(statearr_39372_39391[(1)] = (7));

(statearr_39372_39391[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____0 = (function (){
var statearr_39373 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39373[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__);

(statearr_39373[(1)] = (1));

return statearr_39373;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____1 = (function (state_39347){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39374){var ex__10906__auto__ = e39374;
var statearr_39375_39392 = state_39347;
(statearr_39375_39392[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39347[(4)]))){
var statearr_39376_39393 = state_39347;
(statearr_39376_39393[(1)] = cljs.core.first.call(null,(state_39347[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39394 = state_39347;
state_39347 = G__39394;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__ = function(state_39347){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____1.call(this,state_39347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39377 = f__10977__auto__.call(null);
(statearr_39377[(6)] = c__10976__auto__);

return statearr_39377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e39395){var e = e39395;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__39397 = arguments.length;
switch (G__39397) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39467){
var state_val_39468 = (state_39467[(1)]);
if((state_val_39468 === (7))){
var inst_39399 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
var statearr_39469_39513 = state_39467__$1;
(statearr_39469_39513[(2)] = inst_39399);

(statearr_39469_39513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (20))){
var inst_39443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39444 = ["*"];
var inst_39445 = (new cljs.core.PersistentVector(null,1,(5),inst_39443,inst_39444,null));
var state_39467__$1 = state_39467;
var statearr_39470_39514 = state_39467__$1;
(statearr_39470_39514[(2)] = inst_39445);

(statearr_39470_39514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (1))){
var state_39467__$1 = state_39467;
var statearr_39471_39515 = state_39467__$1;
(statearr_39471_39515[(2)] = null);

(statearr_39471_39515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (4))){
var inst_39398 = (state_39467[(2)]);
var state_39467__$1 = (function (){var statearr_39472 = state_39467;
(statearr_39472[(7)] = inst_39398);

return statearr_39472;
})();
var statearr_39473_39516 = state_39467__$1;
(statearr_39473_39516[(2)] = null);

(statearr_39473_39516[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (15))){
var inst_39462 = (state_39467[(2)]);
var _ = (function (){var statearr_39474 = state_39467;
(statearr_39474[(4)] = cljs.core.rest.call(null,(state_39467[(4)])));

return statearr_39474;
})();
var state_39467__$1 = state_39467;
var statearr_39475_39517 = state_39467__$1;
(statearr_39475_39517[(2)] = inst_39462);

(statearr_39475_39517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (21))){
var inst_39426 = (state_39467[(8)]);
var inst_39433 = (state_39467[(9)]);
var inst_39447 = (state_39467[(2)]);
var inst_39448 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39449 = cljs.core.PersistentHashMap.EMPTY;
var inst_39450 = [inst_39447,inst_39433,inst_39449];
var inst_39451 = cljs.core.PersistentHashMap.fromArrays(inst_39448,inst_39450);
var inst_39452 = fluree.db.dbfunctions.internal.query.call(null,inst_39426,inst_39451);
var state_39467__$1 = state_39467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39467__$1,(22),inst_39452);
} else {
if((state_val_39468 === (13))){
var inst_39421 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39467__$1 = state_39467;
var statearr_39476_39518 = state_39467__$1;
(statearr_39476_39518[(2)] = inst_39421);

(statearr_39476_39518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (22))){
var inst_39454 = (state_39467[(2)]);
var inst_39455 = fluree.db.util.async.throw_err.call(null,inst_39454);
var inst_39456 = cljs.core.nth.call(null,inst_39455,(0),null);
var inst_39457 = cljs.core.nth.call(null,inst_39455,(1),null);
var inst_39458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39459 = [inst_39456,inst_39457];
var inst_39460 = (new cljs.core.PersistentVector(null,2,(5),inst_39458,inst_39459,null));
var state_39467__$1 = state_39467;
var statearr_39477_39519 = state_39467__$1;
(statearr_39477_39519[(2)] = inst_39460);

(statearr_39477_39519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (6))){
var inst_39408 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
var statearr_39478_39520 = state_39467__$1;
(statearr_39478_39520[(2)] = inst_39408);

(statearr_39478_39520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (17))){
var inst_39430 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39431 = fluree.db.dbfunctions.internal.get.call(null,inst_39430,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_39467__$1 = state_39467;
var statearr_39479_39521 = state_39467__$1;
(statearr_39479_39521[(2)] = inst_39431);

(statearr_39479_39521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (3))){
var inst_39465 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39467__$1,inst_39465);
} else {
if((state_val_39468 === (12))){
var inst_39419 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
if(cljs.core.truth_(inst_39419)){
var statearr_39480_39522 = state_39467__$1;
(statearr_39480_39522[(1)] = (13));

} else {
var statearr_39481_39523 = state_39467__$1;
(statearr_39481_39523[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (2))){
var inst_39414 = (state_39467[(10)]);
var _ = (function (){var statearr_39482 = state_39467;
(statearr_39482[(4)] = cljs.core.cons.call(null,(9),(state_39467[(4)])));

return statearr_39482;
})();
var inst_39414__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39467__$1 = (function (){var statearr_39483 = state_39467;
(statearr_39483[(10)] = inst_39414__$1);

return statearr_39483;
})();
if(cljs.core.truth_(inst_39414__$1)){
var statearr_39484_39524 = state_39467__$1;
(statearr_39484_39524[(1)] = (10));

} else {
var statearr_39485_39525 = state_39467__$1;
(statearr_39485_39525[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (19))){
var inst_39435 = cljs.core.PersistentVector.EMPTY;
var inst_39436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39437 = ["*"];
var inst_39438 = (new cljs.core.PersistentVector(null,1,(5),inst_39436,inst_39437,null));
var inst_39439 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_39440 = cljs.core.concat.call(null,inst_39438,inst_39439);
var inst_39441 = cljs.core.into.call(null,inst_39435,inst_39440);
var state_39467__$1 = state_39467;
var statearr_39487_39526 = state_39467__$1;
(statearr_39487_39526[(2)] = inst_39441);

(statearr_39487_39526[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (11))){
var inst_39414 = (state_39467[(10)]);
var state_39467__$1 = state_39467;
var statearr_39488_39527 = state_39467__$1;
(statearr_39488_39527[(2)] = inst_39414);

(statearr_39488_39527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (9))){
var _ = (function (){var statearr_39489 = state_39467;
(statearr_39489[(4)] = cljs.core.rest.call(null,(state_39467[(4)])));

return statearr_39489;
})();
var state_39467__$1 = state_39467;
var ex39486 = (state_39467__$1[(2)]);
var statearr_39490_39528 = state_39467__$1;
(statearr_39490_39528[(5)] = ex39486);


var statearr_39491_39529 = state_39467__$1;
(statearr_39491_39529[(1)] = (4));

(statearr_39491_39529[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (5))){
var inst_39398 = (state_39467[(7)]);
var _ = (function (){var statearr_39492 = state_39467;
(statearr_39492[(4)] = cljs.core.cons.call(null,(8),(state_39467[(4)])));

return statearr_39492;
})();
var inst_39405 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39398,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_39493 = state_39467;
(statearr_39493[(4)] = cljs.core.rest.call(null,(state_39467[(4)])));

return statearr_39493;
})();
var state_39467__$1 = state_39467;
var statearr_39494_39530 = state_39467__$1;
(statearr_39494_39530[(2)] = inst_39405);

(statearr_39494_39530[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (14))){
var inst_39427 = (state_39467[(11)]);
var inst_39426 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39427__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39467__$1 = (function (){var statearr_39495 = state_39467;
(statearr_39495[(8)] = inst_39426);

(statearr_39495[(11)] = inst_39427__$1);

return statearr_39495;
})();
if(cljs.core.truth_(inst_39427__$1)){
var statearr_39496_39531 = state_39467__$1;
(statearr_39496_39531[(1)] = (16));

} else {
var statearr_39497_39532 = state_39467__$1;
(statearr_39497_39532[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (16))){
var inst_39427 = (state_39467[(11)]);
var state_39467__$1 = state_39467;
var statearr_39498_39533 = state_39467__$1;
(statearr_39498_39533[(2)] = inst_39427);

(statearr_39498_39533[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (10))){
var inst_39416 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_39467__$1 = state_39467;
var statearr_39500_39534 = state_39467__$1;
(statearr_39500_39534[(2)] = inst_39416);

(statearr_39500_39534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (18))){
var inst_39433 = (state_39467[(2)]);
var state_39467__$1 = (function (){var statearr_39501 = state_39467;
(statearr_39501[(9)] = inst_39433);

return statearr_39501;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39502_39535 = state_39467__$1;
(statearr_39502_39535[(1)] = (19));

} else {
var statearr_39503_39536 = state_39467__$1;
(statearr_39503_39536[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39468 === (8))){
var _ = (function (){var statearr_39504 = state_39467;
(statearr_39504[(4)] = cljs.core.rest.call(null,(state_39467[(4)])));

return statearr_39504;
})();
var state_39467__$1 = state_39467;
var ex39499 = (state_39467__$1[(2)]);
var statearr_39505_39537 = state_39467__$1;
(statearr_39505_39537[(5)] = ex39499);


var statearr_39506_39538 = state_39467__$1;
(statearr_39506_39538[(1)] = (7));

(statearr_39506_39538[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10903__auto____0 = (function (){
var statearr_39507 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39507[(0)] = fluree$db$dbfunctions$internal$state_machine__10903__auto__);

(statearr_39507[(1)] = (1));

return statearr_39507;
});
var fluree$db$dbfunctions$internal$state_machine__10903__auto____1 = (function (state_39467){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39508){var ex__10906__auto__ = e39508;
var statearr_39509_39539 = state_39467;
(statearr_39509_39539[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39467[(4)]))){
var statearr_39510_39540 = state_39467;
(statearr_39510_39540[(1)] = cljs.core.first.call(null,(state_39467[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39541 = state_39467;
state_39467 = G__39541;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10903__auto__ = function(state_39467){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____1.call(this,state_39467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39511 = f__10977__auto__.call(null);
(statearr_39511[(6)] = c__10976__auto__);

return statearr_39511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__39543 = arguments.length;
switch (G__39543) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39587){
var state_val_39588 = (state_39587[(1)]);
if((state_val_39588 === (7))){
var inst_39565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39566 = ["*"];
var inst_39567 = (new cljs.core.PersistentVector(null,1,(5),inst_39565,inst_39566,null));
var state_39587__$1 = state_39587;
var statearr_39589_39609 = state_39587__$1;
(statearr_39589_39609[(2)] = inst_39567);

(statearr_39589_39609[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (1))){
var state_39587__$1 = state_39587;
var statearr_39590_39610 = state_39587__$1;
(statearr_39590_39610[(2)] = null);

(statearr_39590_39610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (4))){
var inst_39544 = (state_39587[(2)]);
var inst_39545 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39544,"?p","Context Object",additional_params);
var state_39587__$1 = state_39587;
var statearr_39591_39611 = state_39587__$1;
(statearr_39591_39611[(2)] = inst_39545);

(statearr_39591_39611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (6))){
var inst_39557 = cljs.core.PersistentVector.EMPTY;
var inst_39558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39559 = ["*"];
var inst_39560 = (new cljs.core.PersistentVector(null,1,(5),inst_39558,inst_39559,null));
var inst_39561 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_39562 = cljs.core.concat.call(null,inst_39560,inst_39561);
var inst_39563 = cljs.core.into.call(null,inst_39557,inst_39562);
var state_39587__$1 = state_39587;
var statearr_39592_39612 = state_39587__$1;
(statearr_39592_39612[(2)] = inst_39563);

(statearr_39592_39612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (3))){
var inst_39585 = (state_39587[(2)]);
var state_39587__$1 = state_39587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39587__$1,inst_39585);
} else {
if((state_val_39588 === (2))){
var _ = (function (){var statearr_39594 = state_39587;
(statearr_39594[(4)] = cljs.core.cons.call(null,(5),(state_39587[(4)])));

return statearr_39594;
})();
var inst_39554 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39555 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39587__$1 = (function (){var statearr_39595 = state_39587;
(statearr_39595[(7)] = inst_39555);

(statearr_39595[(8)] = inst_39554);

return statearr_39595;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39596_39613 = state_39587__$1;
(statearr_39596_39613[(1)] = (6));

} else {
var statearr_39597_39614 = state_39587__$1;
(statearr_39597_39614[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (9))){
var inst_39576 = (state_39587[(2)]);
var inst_39577 = fluree.db.util.async.throw_err.call(null,inst_39576);
var inst_39578 = cljs.core.nth.call(null,inst_39577,(0),null);
var inst_39579 = cljs.core.nth.call(null,inst_39577,(1),null);
var inst_39580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39581 = [inst_39578,inst_39579];
var inst_39582 = (new cljs.core.PersistentVector(null,2,(5),inst_39580,inst_39581,null));
var _ = (function (){var statearr_39598 = state_39587;
(statearr_39598[(4)] = cljs.core.rest.call(null,(state_39587[(4)])));

return statearr_39598;
})();
var state_39587__$1 = state_39587;
var statearr_39599_39615 = state_39587__$1;
(statearr_39599_39615[(2)] = inst_39582);

(statearr_39599_39615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (5))){
var _ = (function (){var statearr_39600 = state_39587;
(statearr_39600[(4)] = cljs.core.rest.call(null,(state_39587[(4)])));

return statearr_39600;
})();
var state_39587__$1 = state_39587;
var ex39593 = (state_39587__$1[(2)]);
var statearr_39601_39616 = state_39587__$1;
(statearr_39601_39616[(5)] = ex39593);


var statearr_39602_39617 = state_39587__$1;
(statearr_39602_39617[(1)] = (4));

(statearr_39602_39617[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39588 === (8))){
var inst_39555 = (state_39587[(7)]);
var inst_39554 = (state_39587[(8)]);
var inst_39569 = (state_39587[(2)]);
var inst_39570 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39571 = cljs.core.PersistentHashMap.EMPTY;
var inst_39572 = [inst_39569,inst_39555,inst_39571];
var inst_39573 = cljs.core.PersistentHashMap.fromArrays(inst_39570,inst_39572);
var inst_39574 = fluree.db.dbfunctions.internal.query.call(null,inst_39554,inst_39573);
var state_39587__$1 = state_39587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39587__$1,(9),inst_39574);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10903__auto____0 = (function (){
var statearr_39603 = [null,null,null,null,null,null,null,null,null];
(statearr_39603[(0)] = fluree$db$dbfunctions$internal$state_machine__10903__auto__);

(statearr_39603[(1)] = (1));

return statearr_39603;
});
var fluree$db$dbfunctions$internal$state_machine__10903__auto____1 = (function (state_39587){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39604){var ex__10906__auto__ = e39604;
var statearr_39605_39618 = state_39587;
(statearr_39605_39618[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39587[(4)]))){
var statearr_39606_39619 = state_39587;
(statearr_39606_39619[(1)] = cljs.core.first.call(null,(state_39587[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39620 = state_39587;
state_39587 = G__39620;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10903__auto__ = function(state_39587){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10903__auto____1.call(this,state_39587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39607 = f__10977__auto__.call(null);
(statearr_39607[(6)] = c__10976__auto__);

return statearr_39607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39664){
var state_val_39665 = (state_39664[(1)]);
if((state_val_39665 === (1))){
var state_39664__$1 = state_39664;
var statearr_39666_39680 = state_39664__$1;
(statearr_39666_39680[(2)] = null);

(statearr_39666_39680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39665 === (2))){
var _ = (function (){var statearr_39667 = state_39664;
(statearr_39667[(4)] = cljs.core.cons.call(null,(5),(state_39664[(4)])));

return statearr_39667;
})();
var inst_39631 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39633 = ["_user/_auth"];
var inst_39634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39635 = ["*"];
var inst_39636 = (new cljs.core.PersistentVector(null,1,(5),inst_39634,inst_39635,null));
var inst_39637 = [inst_39636];
var inst_39638 = cljs.core.PersistentHashMap.fromArrays(inst_39633,inst_39637);
var inst_39639 = [inst_39638];
var inst_39640 = (new cljs.core.PersistentVector(null,1,(5),inst_39632,inst_39639,null));
var inst_39641 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39642 = cljs.core.PersistentHashMap.EMPTY;
var inst_39643 = [inst_39640,inst_39641,inst_39642];
var inst_39644 = cljs.core.PersistentHashMap.fromArrays(inst_39631,inst_39643);
var inst_39645 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39646 = fluree.db.dbfunctions.internal.query.call(null,inst_39645,inst_39644);
var state_39664__$1 = state_39664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39664__$1,(6),inst_39646);
} else {
if((state_val_39665 === (3))){
var inst_39662 = (state_39664[(2)]);
var state_39664__$1 = state_39664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39664__$1,inst_39662);
} else {
if((state_val_39665 === (4))){
var inst_39621 = (state_39664[(2)]);
var inst_39622 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39621,"?user_id-from-auth","Context Object");
var state_39664__$1 = state_39664;
var statearr_39669_39681 = state_39664__$1;
(statearr_39669_39681[(2)] = inst_39622);

(statearr_39669_39681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39665 === (5))){
var _ = (function (){var statearr_39670 = state_39664;
(statearr_39670[(4)] = cljs.core.rest.call(null,(state_39664[(4)])));

return statearr_39670;
})();
var state_39664__$1 = state_39664;
var ex39668 = (state_39664__$1[(2)]);
var statearr_39671_39682 = state_39664__$1;
(statearr_39671_39682[(5)] = ex39668);


var statearr_39672_39683 = state_39664__$1;
(statearr_39672_39683[(1)] = (4));

(statearr_39672_39683[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39665 === (6))){
var inst_39648 = (state_39664[(2)]);
var inst_39649 = fluree.db.util.async.throw_err.call(null,inst_39648);
var inst_39650 = cljs.core.nth.call(null,inst_39649,(0),null);
var inst_39651 = cljs.core.nth.call(null,inst_39649,(1),null);
var inst_39652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39653 = ["_user/_auth","_id"];
var inst_39654 = (new cljs.core.PersistentVector(null,2,(5),inst_39652,inst_39653,null));
var inst_39655 = fluree.db.dbfunctions.internal.get_in.call(null,inst_39650,inst_39654);
var inst_39656 = cljs.core.first.call(null,inst_39655);
var inst_39657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39658 = [inst_39656,inst_39651];
var inst_39659 = (new cljs.core.PersistentVector(null,2,(5),inst_39657,inst_39658,null));
var _ = (function (){var statearr_39673 = state_39664;
(statearr_39673[(4)] = cljs.core.rest.call(null,(state_39664[(4)])));

return statearr_39673;
})();
var state_39664__$1 = state_39664;
var statearr_39674_39684 = state_39664__$1;
(statearr_39674_39684[(2)] = inst_39659);

(statearr_39674_39684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____0 = (function (){
var statearr_39675 = [null,null,null,null,null,null,null];
(statearr_39675[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__);

(statearr_39675[(1)] = (1));

return statearr_39675;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____1 = (function (state_39664){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39676){var ex__10906__auto__ = e39676;
var statearr_39677_39685 = state_39664;
(statearr_39677_39685[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39664[(4)]))){
var statearr_39678_39686 = state_39664;
(statearr_39678_39686[(1)] = cljs.core.first.call(null,(state_39664[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39687 = state_39664;
state_39664 = G__39687;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__ = function(state_39664){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____1.call(this,state_39664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39679 = f__10977__auto__.call(null);
(statearr_39679[(6)] = c__10976__auto__);

return statearr_39679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39704){
var state_val_39705 = (state_39704[(1)]);
if((state_val_39705 === (1))){
var state_39704__$1 = state_39704;
var statearr_39706_39720 = state_39704__$1;
(statearr_39706_39720[(2)] = null);

(statearr_39706_39720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39705 === (2))){
var _ = (function (){var statearr_39707 = state_39704;
(statearr_39707[(4)] = cljs.core.cons.call(null,(5),(state_39704[(4)])));

return statearr_39707;
})();
var inst_39694 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39695 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39696 = fluree.db.dbproto._subid.call(null,inst_39695,inst_39694);
var state_39704__$1 = state_39704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39704__$1,(6),inst_39696);
} else {
if((state_val_39705 === (3))){
var inst_39702 = (state_39704[(2)]);
var state_39704__$1 = state_39704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39704__$1,inst_39702);
} else {
if((state_val_39705 === (4))){
var inst_39688 = (state_39704[(2)]);
var state_39704__$1 = state_39704;
var statearr_39709_39721 = state_39704__$1;
(statearr_39709_39721[(2)] = inst_39688);

(statearr_39709_39721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39705 === (5))){
var _ = (function (){var statearr_39710 = state_39704;
(statearr_39710[(4)] = cljs.core.rest.call(null,(state_39704[(4)])));

return statearr_39710;
})();
var state_39704__$1 = state_39704;
var ex39708 = (state_39704__$1[(2)]);
var statearr_39711_39722 = state_39704__$1;
(statearr_39711_39722[(5)] = ex39708);


if((ex39708 instanceof Error)){
var statearr_39712_39723 = state_39704__$1;
(statearr_39712_39723[(1)] = (4));

(statearr_39712_39723[(5)] = null);

} else {
throw ex39708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39705 === (6))){
var inst_39698 = (state_39704[(2)]);
var inst_39699 = fluree.db.util.async.throw_err.call(null,inst_39698);
var _ = (function (){var statearr_39713 = state_39704;
(statearr_39713[(4)] = cljs.core.rest.call(null,(state_39704[(4)])));

return statearr_39713;
})();
var state_39704__$1 = state_39704;
var statearr_39714_39724 = state_39704__$1;
(statearr_39714_39724[(2)] = inst_39699);

(statearr_39714_39724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____0 = (function (){
var statearr_39715 = [null,null,null,null,null,null,null];
(statearr_39715[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__);

(statearr_39715[(1)] = (1));

return statearr_39715;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____1 = (function (state_39704){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39716){var ex__10906__auto__ = e39716;
var statearr_39717_39725 = state_39704;
(statearr_39717_39725[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39704[(4)]))){
var statearr_39718_39726 = state_39704;
(statearr_39718_39726[(1)] = cljs.core.first.call(null,(state_39704[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39727 = state_39704;
state_39704 = G__39727;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__ = function(state_39704){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____1.call(this,state_39704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39719 = f__10977__auto__.call(null);
(statearr_39719[(6)] = c__10976__auto__);

return statearr_39719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__39728_SHARP_){
return p1__39728_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__39729_SHARP_){
return p1__39729_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e39730){var e = e39730;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__39731_SHARP_){
return p1__39731_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__39732_SHARP_){
return p1__39732_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e39733){var e = e39733;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e39734){var e = e39734;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_39814){
var state_val_39815 = (state_39814[(1)]);
if((state_val_39815 === (7))){
var inst_39753 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_39754 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39755 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39756 = cljs.core.PersistentHashMap.fromArrays(inst_39754,inst_39755);
var inst_39757 = cljs.core.ex_info.call(null,inst_39753,inst_39756);
var inst_39758 = (function(){throw inst_39757})();
var state_39814__$1 = state_39814;
var statearr_39816_39851 = state_39814__$1;
(statearr_39816_39851[(2)] = inst_39758);

(statearr_39816_39851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (1))){
var state_39814__$1 = state_39814;
var statearr_39817_39852 = state_39814__$1;
(statearr_39817_39852[(2)] = null);

(statearr_39817_39852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (4))){
var inst_39735 = (state_39814[(2)]);
var state_39814__$1 = state_39814;
var statearr_39818_39853 = state_39814__$1;
(statearr_39818_39853[(2)] = inst_39735);

(statearr_39818_39853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (15))){
var inst_39798 = (state_39814[(7)]);
var inst_39794 = (state_39814[(2)]);
var inst_39795 = fluree.db.util.async.throw_err.call(null,inst_39794);
var inst_39796 = cljs.core.nth.call(null,inst_39795,(0),null);
var inst_39797 = cljs.core.nth.call(null,inst_39795,(1),null);
var inst_39798__$1 = cljs.core.first.call(null,inst_39796);
var inst_39799 = cljs.core._EQ_.call(null,inst_39798__$1,compare_val);
var state_39814__$1 = (function (){var statearr_39819 = state_39814;
(statearr_39819[(7)] = inst_39798__$1);

(statearr_39819[(8)] = inst_39797);

return statearr_39819;
})();
if(inst_39799){
var statearr_39820_39854 = state_39814__$1;
(statearr_39820_39854[(1)] = (16));

} else {
var statearr_39821_39855 = state_39814__$1;
(statearr_39821_39855[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (13))){
var state_39814__$1 = state_39814;
var statearr_39822_39856 = state_39814__$1;
(statearr_39822_39856[(2)] = null);

(statearr_39822_39856[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (6))){
var state_39814__$1 = state_39814;
var statearr_39823_39857 = state_39814__$1;
(statearr_39823_39857[(2)] = null);

(statearr_39823_39857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (17))){
var inst_39798 = (state_39814[(7)]);
var inst_39802 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39798)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_39803 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39804 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39805 = cljs.core.PersistentHashMap.fromArrays(inst_39803,inst_39804);
var inst_39806 = cljs.core.ex_info.call(null,inst_39802,inst_39805);
var inst_39807 = (function(){throw inst_39806})();
var state_39814__$1 = state_39814;
var statearr_39824_39858 = state_39814__$1;
(statearr_39824_39858[(2)] = inst_39807);

(statearr_39824_39858[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (3))){
var inst_39812 = (state_39814[(2)]);
var state_39814__$1 = state_39814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39814__$1,inst_39812);
} else {
if((state_val_39815 === (12))){
var inst_39750 = (state_39814[(9)]);
var inst_39773 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_39750);
var inst_39774 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39775 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39776 = cljs.core.PersistentHashMap.fromArrays(inst_39774,inst_39775);
var inst_39777 = cljs.core.ex_info.call(null,inst_39773,inst_39776);
var inst_39778 = (function(){throw inst_39777})();
var state_39814__$1 = state_39814;
var statearr_39825_39859 = state_39814__$1;
(statearr_39825_39859[(2)] = inst_39778);

(statearr_39825_39859[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (2))){
var inst_39747 = (state_39814[(10)]);
var inst_39749 = (state_39814[(11)]);
var inst_39748 = (state_39814[(12)]);
var _ = (function (){var statearr_39826 = state_39814;
(statearr_39826[(4)] = cljs.core.cons.call(null,(5),(state_39814[(4)])));

return statearr_39826;
})();
var inst_39745 = _QMARK_ctx;
var inst_39746 = cljs.core.__destructure_map.call(null,inst_39745);
var inst_39747__$1 = cljs.core.get.call(null,inst_39746,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_39748__$1 = cljs.core.get.call(null,inst_39746,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_39749__$1 = cljs.core.get.call(null,inst_39746,new cljs.core.Keyword(null,"db","db",993250759));
var inst_39750 = fluree.db.dbproto._p_prop.call(null,inst_39749__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_39748__$1);
var state_39814__$1 = (function (){var statearr_39827 = state_39814;
(statearr_39827[(10)] = inst_39747__$1);

(statearr_39827[(11)] = inst_39749__$1);

(statearr_39827[(12)] = inst_39748__$1);

(statearr_39827[(9)] = inst_39750);

return statearr_39827;
})();
if(cljs.core.truth_(inst_39747__$1)){
var statearr_39828_39860 = state_39814__$1;
(statearr_39828_39860[(1)] = (6));

} else {
var statearr_39829_39861 = state_39814__$1;
(statearr_39829_39861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (11))){
var inst_39749 = (state_39814[(11)]);
var inst_39748 = (state_39814[(12)]);
var inst_39770 = (state_39814[(2)]);
var inst_39771 = fluree.db.dbproto._p_prop.call(null,inst_39749,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_39748);
var state_39814__$1 = (function (){var statearr_39831 = state_39814;
(statearr_39831[(13)] = inst_39770);

return statearr_39831;
})();
if(cljs.core.truth_(inst_39771)){
var statearr_39832_39862 = state_39814__$1;
(statearr_39832_39862[(1)] = (12));

} else {
var statearr_39833_39863 = state_39814__$1;
(statearr_39833_39863[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (9))){
var state_39814__$1 = state_39814;
var statearr_39834_39864 = state_39814__$1;
(statearr_39834_39864[(2)] = null);

(statearr_39834_39864[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (5))){
var _ = (function (){var statearr_39835 = state_39814;
(statearr_39835[(4)] = cljs.core.rest.call(null,(state_39814[(4)])));

return statearr_39835;
})();
var state_39814__$1 = state_39814;
var ex39830 = (state_39814__$1[(2)]);
var statearr_39836_39865 = state_39814__$1;
(statearr_39836_39865[(5)] = ex39830);


if((ex39830 instanceof Error)){
var statearr_39837_39866 = state_39814__$1;
(statearr_39837_39866[(1)] = (4));

(statearr_39837_39866[(5)] = null);

} else {
throw ex39830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (14))){
var inst_39747 = (state_39814[(10)]);
var inst_39749 = (state_39814[(11)]);
var inst_39750 = (state_39814[(9)]);
var inst_39781 = (state_39814[(2)]);
var inst_39782 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39785 = [inst_39747,inst_39750,"?current-val"];
var inst_39786 = (new cljs.core.PersistentVector(null,3,(5),inst_39784,inst_39785,null));
var inst_39787 = [inst_39786];
var inst_39788 = (new cljs.core.PersistentVector(null,1,(5),inst_39783,inst_39787,null));
var inst_39789 = cljs.core.PersistentHashMap.EMPTY;
var inst_39790 = ["?current-val",inst_39788,inst_39789];
var inst_39791 = cljs.core.PersistentHashMap.fromArrays(inst_39782,inst_39790);
var inst_39792 = fluree.db.dbfunctions.internal.query.call(null,inst_39749,inst_39791);
var state_39814__$1 = (function (){var statearr_39838 = state_39814;
(statearr_39838[(14)] = inst_39781);

return statearr_39838;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39814__$1,(15),inst_39792);
} else {
if((state_val_39815 === (16))){
var state_39814__$1 = state_39814;
var statearr_39839_39867 = state_39814__$1;
(statearr_39839_39867[(2)] = new_val);

(statearr_39839_39867[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (10))){
var inst_39763 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_39764 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39765 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39766 = cljs.core.PersistentHashMap.fromArrays(inst_39764,inst_39765);
var inst_39767 = cljs.core.ex_info.call(null,inst_39763,inst_39766);
var inst_39768 = (function(){throw inst_39767})();
var state_39814__$1 = state_39814;
var statearr_39840_39868 = state_39814__$1;
(statearr_39840_39868[(2)] = inst_39768);

(statearr_39840_39868[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (18))){
var inst_39809 = (state_39814[(2)]);
var _ = (function (){var statearr_39841 = state_39814;
(statearr_39841[(4)] = cljs.core.rest.call(null,(state_39814[(4)])));

return statearr_39841;
})();
var state_39814__$1 = state_39814;
var statearr_39842_39869 = state_39814__$1;
(statearr_39842_39869[(2)] = inst_39809);

(statearr_39842_39869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39815 === (8))){
var inst_39750 = (state_39814[(9)]);
var inst_39760 = (state_39814[(2)]);
var state_39814__$1 = (function (){var statearr_39843 = state_39814;
(statearr_39843[(15)] = inst_39760);

return statearr_39843;
})();
if(cljs.core.truth_(inst_39750)){
var statearr_39844_39870 = state_39814__$1;
(statearr_39844_39870[(1)] = (9));

} else {
var statearr_39845_39871 = state_39814__$1;
(statearr_39845_39871[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____0 = (function (){
var statearr_39846 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39846[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__);

(statearr_39846[(1)] = (1));

return statearr_39846;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____1 = (function (state_39814){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_39814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e39847){var ex__10906__auto__ = e39847;
var statearr_39848_39872 = state_39814;
(statearr_39848_39872[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_39814[(4)]))){
var statearr_39849_39873 = state_39814;
(statearr_39849_39873[(1)] = cljs.core.first.call(null,(state_39814[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39874 = state_39814;
state_39814 = G__39874;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__ = function(state_39814){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____1.call(this,state_39814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_39850 = f__10977__auto__.call(null);
(statearr_39850[(6)] = c__10976__auto__);

return statearr_39850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
