// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e30167){var e = e30167;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__30168_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__30168_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__30168_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__30168_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30169_SHARP_){
return cljs.core.conj.call(null,p1__30169_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30170_SHARP_){
return cljs.core.conj.call(null,p1__30170_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__30175 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__30175,(0),null);
var _ = cljs.core.nth.call(null,vec__30175,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30171_SHARP_){
return cljs.core.conj.call(null,p1__30171_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4251__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__30178 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__30178,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__30178,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30172_SHARP_){
return cljs.core.conj.call(null,p1__30172_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30173_SHARP_){
return cljs.core.conj.call(null,p1__30173_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__30174_SHARP_){
return cljs.core.conj.call(null,p1__30174_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__30181_SHARP_){
return cljs.core.nth.call(null,array,p1__30181_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5751__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__30184,optional_QMARK_,fuel,max_fuel){
var map__30185 = p__30184;
var map__30185__$1 = cljs.core.__destructure_map.call(null,map__30185);
var res = map__30185__$1;
var vars = cljs.core.get.call(null,map__30185__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30251){
var state_val_30252 = (state_30251[(1)]);
if((state_val_30252 === (7))){
var inst_30240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30241 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_30242 = cljs.core.conj.call(null,inst_30241,clause);
var inst_30243 = [null,inst_30242];
var inst_30244 = (new cljs.core.PersistentVector(null,2,(5),inst_30240,inst_30243,null));
var state_30251__$1 = state_30251;
var statearr_30253_30281 = state_30251__$1;
(statearr_30253_30281[(2)] = inst_30244);

(statearr_30253_30281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (1))){
var state_30251__$1 = state_30251;
var statearr_30254_30282 = state_30251__$1;
(statearr_30254_30282[(2)] = null);

(statearr_30254_30282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (4))){
var inst_30186 = (state_30251[(2)]);
var state_30251__$1 = state_30251;
var statearr_30255_30283 = state_30251__$1;
(statearr_30255_30283[(2)] = inst_30186);

(statearr_30255_30283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (15))){
var inst_30229 = (state_30251[(2)]);
var inst_30230 = fluree.db.util.async.throw_err.call(null,inst_30229);
var inst_30231 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_30230);
var inst_30232 = cljs.core.count.call(null,inst_30231);
var inst_30233 = fluree.db.query.analytical.add_fuel.call(null,inst_30232,fuel,max_fuel);
var inst_30234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30235 = [inst_30230,r];
var inst_30236 = (new cljs.core.PersistentVector(null,2,(5),inst_30234,inst_30235,null));
var state_30251__$1 = (function (){var statearr_30256 = state_30251;
(statearr_30256[(7)] = inst_30233);

return statearr_30256;
})();
var statearr_30257_30284 = state_30251__$1;
(statearr_30257_30284[(2)] = inst_30236);

(statearr_30257_30284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (13))){
var inst_30195 = (state_30251[(8)]);
var inst_30208 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30209 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_30208);
var inst_30210 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_30195);
var inst_30211 = cljs.core.apply.call(null,cljs.core.concat,inst_30210);
var inst_30212 = cljs.core.set.call(null,inst_30211);
var inst_30213 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_30209);
var inst_30214 = cljs.core.apply.call(null,cljs.core.concat,inst_30213);
var inst_30215 = cljs.core.into.call(null,inst_30212,inst_30214);
var inst_30216 = (function (){var all_wd = inst_30195;
var optional = inst_30209;
var all_wd_vars = inst_30212;
var all_vars = inst_30215;
return (function (p1__30182_SHARP_){
return all_vars.call(null,p1__30182_SHARP_);
});
})();
var inst_30217 = cljs.core.keys.call(null,vars);
var inst_30218 = cljs.core.map.call(null,inst_30216,inst_30217);
var inst_30219 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_30218);
var inst_30220 = cljs.core.set.call(null,inst_30219);
var inst_30221 = (function (){var all_wd = inst_30195;
var optional = inst_30209;
var all_wd_vars = inst_30212;
var all_vars = inst_30215;
var intersecting_vars = inst_30220;
return (function (p1__30183_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__30183_SHARP_);
});
})();
var inst_30222 = cljs.core.map.call(null,inst_30221,inst_30195);
var inst_30223 = cljs.core.apply.call(null,cljs.core.concat,inst_30222);
var inst_30224 = fluree.db.query.analytical.select_from_tuples.call(null,inst_30223,res);
var inst_30225 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_30195,inst_30220,vars);
var inst_30226 = cljs.core.remove.call(null,inst_30220,inst_30215);
var inst_30227 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_30225,inst_30223,inst_30224,inst_30226,inst_30209);
var state_30251__$1 = state_30251;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30251__$1,(15),inst_30227);
} else {
if((state_val_30252 === (6))){
var inst_30196 = (state_30251[(9)]);
var inst_30194 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_30195 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_30194);
var inst_30196__$1 = optional_QMARK_;
var state_30251__$1 = (function (){var statearr_30258 = state_30251;
(statearr_30258[(9)] = inst_30196__$1);

(statearr_30258[(8)] = inst_30195);

return statearr_30258;
})();
if(cljs.core.truth_(inst_30196__$1)){
var statearr_30259_30285 = state_30251__$1;
(statearr_30259_30285[(1)] = (9));

} else {
var statearr_30260_30286 = state_30251__$1;
(statearr_30260_30286[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (3))){
var inst_30249 = (state_30251[(2)]);
var state_30251__$1 = state_30251;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30251__$1,inst_30249);
} else {
if((state_val_30252 === (12))){
var inst_30204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30205 = [null,r];
var inst_30206 = (new cljs.core.PersistentVector(null,2,(5),inst_30204,inst_30205,null));
var state_30251__$1 = state_30251;
var statearr_30261_30287 = state_30251__$1;
(statearr_30261_30287[(2)] = inst_30206);

(statearr_30261_30287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (2))){
var _ = (function (){var statearr_30262 = state_30251;
(statearr_30262[(4)] = cljs.core.cons.call(null,(5),(state_30251[(4)])));

return statearr_30262;
})();
var inst_30192 = (r == null);
var state_30251__$1 = state_30251;
if(cljs.core.truth_(inst_30192)){
var statearr_30263_30288 = state_30251__$1;
(statearr_30263_30288[(1)] = (6));

} else {
var statearr_30264_30289 = state_30251__$1;
(statearr_30264_30289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (11))){
var inst_30202 = (state_30251[(2)]);
var state_30251__$1 = state_30251;
if(cljs.core.truth_(inst_30202)){
var statearr_30266_30290 = state_30251__$1;
(statearr_30266_30290[(1)] = (12));

} else {
var statearr_30267_30291 = state_30251__$1;
(statearr_30267_30291[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (9))){
var inst_30195 = (state_30251[(8)]);
var inst_30198 = cljs.core.empty_QMARK_.call(null,inst_30195);
var inst_30199 = (!(inst_30198));
var state_30251__$1 = state_30251;
var statearr_30268_30292 = state_30251__$1;
(statearr_30268_30292[(2)] = inst_30199);

(statearr_30268_30292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (5))){
var _ = (function (){var statearr_30269 = state_30251;
(statearr_30269[(4)] = cljs.core.rest.call(null,(state_30251[(4)])));

return statearr_30269;
})();
var state_30251__$1 = state_30251;
var ex30265 = (state_30251__$1[(2)]);
var statearr_30270_30293 = state_30251__$1;
(statearr_30270_30293[(5)] = ex30265);


if((ex30265 instanceof Error)){
var statearr_30271_30294 = state_30251__$1;
(statearr_30271_30294[(1)] = (4));

(statearr_30271_30294[(5)] = null);

} else {
throw ex30265;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (14))){
var inst_30238 = (state_30251[(2)]);
var state_30251__$1 = state_30251;
var statearr_30272_30295 = state_30251__$1;
(statearr_30272_30295[(2)] = inst_30238);

(statearr_30272_30295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (10))){
var inst_30196 = (state_30251[(9)]);
var state_30251__$1 = state_30251;
var statearr_30273_30296 = state_30251__$1;
(statearr_30273_30296[(2)] = inst_30196);

(statearr_30273_30296[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30252 === (8))){
var inst_30246 = (state_30251[(2)]);
var _ = (function (){var statearr_30274 = state_30251;
(statearr_30274[(4)] = cljs.core.rest.call(null,(state_30251[(4)])));

return statearr_30274;
})();
var state_30251__$1 = state_30251;
var statearr_30275_30297 = state_30251__$1;
(statearr_30275_30297[(2)] = inst_30246);

(statearr_30275_30297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____0 = (function (){
var statearr_30276 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30276[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__);

(statearr_30276[(1)] = (1));

return statearr_30276;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____1 = (function (state_30251){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30277){var ex__10906__auto__ = e30277;
var statearr_30278_30298 = state_30251;
(statearr_30278_30298[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30251[(4)]))){
var statearr_30279_30299 = state_30251;
(statearr_30279_30299[(1)] = cljs.core.first.call(null,(state_30251[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30300 = state_30251;
state_30251 = G__30300;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__ = function(state_30251){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____1.call(this,state_30251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30280 = f__10977__auto__.call(null);
(statearr_30280[(6)] = c__10976__auto__);

return statearr_30280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__30302 = arguments.length;
switch (G__30302) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30396){
var state_val_30397 = (state_30396[(1)]);
if((state_val_30397 === (7))){
var inst_30309 = (state_30396[(7)]);
var inst_30319 = clojure.string.starts_with_QMARK_.call(null,inst_30309,"$fdb");
var state_30396__$1 = state_30396;
if(inst_30319){
var statearr_30398_30447 = state_30396__$1;
(statearr_30398_30447[(1)] = (9));

} else {
var statearr_30399_30448 = state_30396__$1;
(statearr_30399_30448[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (20))){
var state_30396__$1 = state_30396;
var statearr_30400_30449 = state_30396__$1;
(statearr_30400_30449[(2)] = null);

(statearr_30400_30449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (27))){
var inst_30359 = (state_30396[(8)]);
var state_30396__$1 = state_30396;
var statearr_30401_30450 = state_30396__$1;
(statearr_30401_30450[(2)] = inst_30359);

(statearr_30401_30450[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (1))){
var state_30396__$1 = state_30396;
var statearr_30402_30451 = state_30396__$1;
(statearr_30402_30451[(2)] = null);

(statearr_30402_30451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (24))){
var inst_30382 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
var statearr_30403_30452 = state_30396__$1;
(statearr_30403_30452[(2)] = inst_30382);

(statearr_30403_30452[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (4))){
var inst_30303 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
var statearr_30404_30453 = state_30396__$1;
(statearr_30404_30453[(2)] = inst_30303);

(statearr_30404_30453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (15))){
var inst_30326 = (state_30396[(9)]);
var inst_30332 = (state_30396[(2)]);
var inst_30333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30334 = cljs.core.PersistentVector.EMPTY;
var inst_30335 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_30336 = cljs.core.into.call(null,inst_30334,inst_30335);
var inst_30337 = [inst_30326,inst_30336];
var inst_30338 = (new cljs.core.PersistentVector(null,2,(5),inst_30333,inst_30337,null));
var state_30396__$1 = (function (){var statearr_30405 = state_30396;
(statearr_30405[(10)] = inst_30332);

return statearr_30405;
})();
var statearr_30406_30454 = state_30396__$1;
(statearr_30406_30454[(2)] = inst_30338);

(statearr_30406_30454[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (21))){
var inst_30385 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
var statearr_30407_30455 = state_30396__$1;
(statearr_30407_30455[(2)] = inst_30385);

(statearr_30407_30455[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (13))){
var inst_30326 = (state_30396[(9)]);
var inst_30329 = (function(){throw inst_30326})();
var state_30396__$1 = state_30396;
var statearr_30408_30456 = state_30396__$1;
(statearr_30408_30456[(2)] = inst_30329);

(statearr_30408_30456[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (22))){
var inst_30348 = (state_30396[(11)]);
var inst_30350 = (state_30396[(12)]);
var inst_30352 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_30348);
var inst_30353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30354 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_30350];
var inst_30355 = (new cljs.core.PersistentVector(null,2,(5),inst_30353,inst_30354,null));
var inst_30356 = cljs.core.get_in.call(null,opts,inst_30355);
var state_30396__$1 = (function (){var statearr_30409 = state_30396;
(statearr_30409[(13)] = inst_30352);

return statearr_30409;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30396__$1,(25),inst_30356);
} else {
if((state_val_30397 === (29))){
var inst_30363 = (state_30396[(2)]);
var inst_30364 = fluree.db.util.async.throw_err.call(null,inst_30363);
var state_30396__$1 = state_30396;
var statearr_30410_30457 = state_30396__$1;
(statearr_30410_30457[(2)] = inst_30364);

(statearr_30410_30457[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (6))){
var inst_30312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30313 = cljs.core.PersistentVector.EMPTY;
var inst_30314 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_30315 = cljs.core.into.call(null,inst_30313,inst_30314);
var inst_30316 = [db,inst_30315];
var inst_30317 = (new cljs.core.PersistentVector(null,2,(5),inst_30312,inst_30316,null));
var state_30396__$1 = state_30396;
var statearr_30411_30458 = state_30396__$1;
(statearr_30411_30458[(2)] = inst_30317);

(statearr_30411_30458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (28))){
var inst_30367 = (state_30396[(2)]);
var inst_30368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30369 = cljs.core.PersistentVector.EMPTY;
var inst_30370 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_30371 = cljs.core.into.call(null,inst_30369,inst_30370);
var inst_30372 = [inst_30367,inst_30371];
var inst_30373 = (new cljs.core.PersistentVector(null,2,(5),inst_30368,inst_30372,null));
var state_30396__$1 = state_30396;
var statearr_30412_30459 = state_30396__$1;
(statearr_30412_30459[(2)] = inst_30373);

(statearr_30412_30459[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (25))){
var inst_30352 = (state_30396[(13)]);
var inst_30358 = (state_30396[(2)]);
var inst_30359 = fluree.db.util.async.throw_err.call(null,inst_30358);
var state_30396__$1 = (function (){var statearr_30413 = state_30396;
(statearr_30413[(8)] = inst_30359);

return statearr_30413;
})();
if(cljs.core.truth_(inst_30352)){
var statearr_30414_30460 = state_30396__$1;
(statearr_30414_30460[(1)] = (26));

} else {
var statearr_30415_30461 = state_30396__$1;
(statearr_30415_30461[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (17))){
var state_30396__$1 = state_30396;
var statearr_30416_30462 = state_30396__$1;
(statearr_30416_30462[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (3))){
var inst_30394 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30396__$1,inst_30394);
} else {
if((state_val_30397 === (12))){
var inst_30326 = (state_30396[(9)]);
var inst_30325 = (state_30396[(2)]);
var inst_30326__$1 = fluree.db.util.async.throw_err.call(null,inst_30325);
var inst_30327 = fluree.db.util.core.exception_QMARK_.call(null,inst_30326__$1);
var state_30396__$1 = (function (){var statearr_30418 = state_30396;
(statearr_30418[(9)] = inst_30326__$1);

return statearr_30418;
})();
if(inst_30327){
var statearr_30419_30463 = state_30396__$1;
(statearr_30419_30463[(1)] = (13));

} else {
var statearr_30420_30464 = state_30396__$1;
(statearr_30420_30464[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (2))){
var inst_30309 = (state_30396[(7)]);
var _ = (function (){var statearr_30421 = state_30396;
(statearr_30421[(4)] = cljs.core.cons.call(null,(5),(state_30396[(4)])));

return statearr_30421;
})();
var inst_30309__$1 = cljs.core.first.call(null,clause);
var inst_30310 = cljs.core._EQ_.call(null,"$fdb",inst_30309__$1);
var state_30396__$1 = (function (){var statearr_30422 = state_30396;
(statearr_30422[(7)] = inst_30309__$1);

return statearr_30422;
})();
if(inst_30310){
var statearr_30423_30465 = state_30396__$1;
(statearr_30423_30465[(1)] = (6));

} else {
var statearr_30424_30466 = state_30396__$1;
(statearr_30424_30466[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (23))){
var inst_30309 = (state_30396[(7)]);
var inst_30375 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30309)," is not supported in Fluree"].join('');
var inst_30376 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30377 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30378 = cljs.core.PersistentHashMap.fromArrays(inst_30376,inst_30377);
var inst_30379 = cljs.core.ex_info.call(null,inst_30375,inst_30378);
var inst_30380 = (function(){throw inst_30379})();
var state_30396__$1 = state_30396;
var statearr_30425_30467 = state_30396__$1;
(statearr_30425_30467[(2)] = inst_30380);

(statearr_30425_30467[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (19))){
var inst_30309 = (state_30396[(7)]);
var inst_30350 = (state_30396[(12)]);
var inst_30347 = fluree.db.query.analytical.isolate_source_name.call(null,inst_30309);
var inst_30348 = fluree.db.query.analytical.isolate_source_block.call(null,inst_30309);
var inst_30349 = cljs.core.keyword.call(null,inst_30347);
var inst_30350__$1 = cljs.core.get.call(null,prefixes,inst_30349);
var state_30396__$1 = (function (){var statearr_30426 = state_30396;
(statearr_30426[(11)] = inst_30348);

(statearr_30426[(12)] = inst_30350__$1);

return statearr_30426;
})();
if(cljs.core.truth_(inst_30350__$1)){
var statearr_30427_30468 = state_30396__$1;
(statearr_30427_30468[(1)] = (22));

} else {
var statearr_30428_30469 = state_30396__$1;
(statearr_30428_30469[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (11))){
var inst_30389 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
var statearr_30430_30470 = state_30396__$1;
(statearr_30430_30470[(2)] = inst_30389);

(statearr_30430_30470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (9))){
var inst_30309 = (state_30396[(7)]);
var inst_30321 = cljs.core.subs.call(null,inst_30309,(4));
var inst_30322 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_30321);
var inst_30323 = fluree.db.time_travel.as_of_block.call(null,db,inst_30322);
var state_30396__$1 = state_30396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30396__$1,(12),inst_30323);
} else {
if((state_val_30397 === (5))){
var _ = (function (){var statearr_30431 = state_30396;
(statearr_30431[(4)] = cljs.core.rest.call(null,(state_30396[(4)])));

return statearr_30431;
})();
var state_30396__$1 = state_30396;
var ex30429 = (state_30396__$1[(2)]);
var statearr_30432_30471 = state_30396__$1;
(statearr_30432_30471[(5)] = ex30429);


if((ex30429 instanceof Error)){
var statearr_30433_30472 = state_30396__$1;
(statearr_30433_30472[(1)] = (4));

(statearr_30433_30472[(5)] = null);

} else {
throw ex30429;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (14))){
var state_30396__$1 = state_30396;
var statearr_30434_30473 = state_30396__$1;
(statearr_30434_30473[(2)] = null);

(statearr_30434_30473[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (26))){
var inst_30359 = (state_30396[(8)]);
var inst_30352 = (state_30396[(13)]);
var inst_30361 = fluree.db.time_travel.as_of_block.call(null,inst_30359,inst_30352);
var state_30396__$1 = state_30396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30396__$1,(29),inst_30361);
} else {
if((state_val_30397 === (16))){
var inst_30342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30343 = ["$wd",clause];
var inst_30344 = (new cljs.core.PersistentVector(null,2,(5),inst_30342,inst_30343,null));
var state_30396__$1 = state_30396;
var statearr_30435_30474 = state_30396__$1;
(statearr_30435_30474[(2)] = inst_30344);

(statearr_30435_30474[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (10))){
var inst_30309 = (state_30396[(7)]);
var inst_30340 = cljs.core._EQ_.call(null,"$wd",inst_30309);
var state_30396__$1 = state_30396;
if(inst_30340){
var statearr_30436_30475 = state_30396__$1;
(statearr_30436_30475[(1)] = (16));

} else {
var statearr_30437_30476 = state_30396__$1;
(statearr_30437_30476[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (18))){
var inst_30387 = (state_30396[(2)]);
var state_30396__$1 = state_30396;
var statearr_30438_30477 = state_30396__$1;
(statearr_30438_30477[(2)] = inst_30387);

(statearr_30438_30477[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30397 === (8))){
var inst_30391 = (state_30396[(2)]);
var _ = (function (){var statearr_30439 = state_30396;
(statearr_30439[(4)] = cljs.core.rest.call(null,(state_30396[(4)])));

return statearr_30439;
})();
var state_30396__$1 = state_30396;
var statearr_30440_30478 = state_30396__$1;
(statearr_30440_30478[(2)] = inst_30391);

(statearr_30440_30478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10903__auto__ = null;
var fluree$db$query$analytical$state_machine__10903__auto____0 = (function (){
var statearr_30441 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30441[(0)] = fluree$db$query$analytical$state_machine__10903__auto__);

(statearr_30441[(1)] = (1));

return statearr_30441;
});
var fluree$db$query$analytical$state_machine__10903__auto____1 = (function (state_30396){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30442){var ex__10906__auto__ = e30442;
var statearr_30443_30479 = state_30396;
(statearr_30443_30479[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30396[(4)]))){
var statearr_30444_30480 = state_30396;
(statearr_30444_30480[(1)] = cljs.core.first.call(null,(state_30396[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30481 = state_30396;
state_30396 = G__30481;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10903__auto__ = function(state_30396){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10903__auto____1.call(this,state_30396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10903__auto____0;
fluree$db$query$analytical$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10903__auto____1;
return fluree$db$query$analytical$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30445 = f__10977__auto__.call(null);
(statearr_30445[(6)] = c__10976__auto__);

return statearr_30445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__30482){
var vec__30483 = p__30482;
var sub = cljs.core.nth.call(null,vec__30483,(0),null);
var obj = cljs.core.nth.call(null,vec__30483,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__30486_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__30486_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__30490 = subjects;
var vec__30491 = G__30490;
var seq__30492 = cljs.core.seq.call(null,vec__30491);
var first__30493 = cljs.core.first.call(null,seq__30492);
var seq__30492__$1 = cljs.core.next.call(null,seq__30492);
var subject = first__30493;
var r = seq__30492__$1;
var acc = expanded_map;
var G__30490__$1 = G__30490;
var acc__$1 = acc;
while(true){
var vec__30497 = G__30490__$1;
var seq__30498 = cljs.core.seq.call(null,vec__30497);
var first__30499 = cljs.core.first.call(null,seq__30498);
var seq__30498__$1 = cljs.core.next.call(null,seq__30498);
var subject__$1 = first__30499;
var r__$1 = seq__30498__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__30500 = r__$1;
var G__30501 = acc__$2;
G__30490__$1 = G__30500;
acc__$1 = G__30501;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__30490__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__30490__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__30490__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__30490__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__30490__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__30490__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__30497,seq__30498,first__30499,seq__30498__$1,subject__$1,r__$1,acc__$2,G__30490,vec__30491,seq__30492,first__30493,seq__30492__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__30502 = r__$1;
var G__30503 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__30490__$1 = G__30502;
acc__$1 = G__30503;
continue;
} else {
var G__30504 = subjects;
var G__30505 = acc_STAR_;
G__30490__$1 = G__30504;
acc__$1 = G__30505;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__30506_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__30506_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30597){
var state_val_30598 = (state_30597[(1)]);
if((state_val_30598 === (7))){
var state_30597__$1 = state_30597;
var statearr_30599_30645 = state_30597__$1;
(statearr_30599_30645[(2)] = (100));

(statearr_30599_30645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (20))){
var inst_30546 = (state_30597[(7)]);
var state_30597__$1 = state_30597;
var statearr_30600_30646 = state_30597__$1;
(statearr_30600_30646[(2)] = inst_30546);

(statearr_30600_30646[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (1))){
var state_30597__$1 = state_30597;
var statearr_30601_30647 = state_30597__$1;
(statearr_30601_30647[(2)] = null);

(statearr_30601_30647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (24))){
var inst_30518 = (state_30597[(8)]);
var inst_30583 = (state_30597[(9)]);
var inst_30584 = (state_30597[(10)]);
var inst_30585 = (state_30597[(11)]);
var inst_30588 = (function (){var max_depth = inst_30518;
var recur_map__$1 = inst_30584;
var subjects = inst_30583;
var tuples = inst_30585;
return (function (p1__30507_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__30507_SHARP_)],null));
});
})();
var inst_30589 = cljs.core.map.call(null,inst_30588,inst_30585);
var inst_30590 = cljs.core.distinct.call(null,inst_30589);
var state_30597__$1 = state_30597;
var statearr_30602_30648 = state_30597__$1;
(statearr_30602_30648[(2)] = inst_30590);

(statearr_30602_30648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (4))){
var inst_30508 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
var statearr_30603_30649 = state_30597__$1;
(statearr_30603_30649[(2)] = inst_30508);

(statearr_30603_30649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (15))){
var inst_30531 = (state_30597[(12)]);
var inst_30542 = cljs.core.PersistentVector.EMPTY;
var inst_30543 = cljs.core.seq.call(null,inst_30531);
var inst_30544 = cljs.core.first.call(null,inst_30543);
var inst_30545 = cljs.core.next.call(null,inst_30543);
var inst_30546 = inst_30542;
var inst_30547 = inst_30531;
var state_30597__$1 = (function (){var statearr_30604 = state_30597;
(statearr_30604[(13)] = inst_30547);

(statearr_30604[(14)] = inst_30544);

(statearr_30604[(15)] = inst_30545);

(statearr_30604[(7)] = inst_30546);

return statearr_30604;
})();
var statearr_30605_30650 = state_30597__$1;
(statearr_30605_30650[(2)] = null);

(statearr_30605_30650[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (21))){
var inst_30567 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
var statearr_30606_30651 = state_30597__$1;
(statearr_30606_30651[(2)] = inst_30567);

(statearr_30606_30651[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (13))){
var inst_30580 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
var statearr_30607_30652 = state_30597__$1;
(statearr_30607_30652[(2)] = inst_30580);

(statearr_30607_30652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (22))){
var inst_30546 = (state_30597[(7)]);
var inst_30554 = (state_30597[(16)]);
var inst_30561 = (state_30597[(2)]);
var inst_30562 = fluree.db.util.async.throw_err.call(null,inst_30561);
var inst_30563 = cljs.core.concat.call(null,inst_30546,inst_30562);
var inst_30546__$1 = inst_30563;
var inst_30547 = inst_30554;
var state_30597__$1 = (function (){var statearr_30608 = state_30597;
(statearr_30608[(13)] = inst_30547);

(statearr_30608[(7)] = inst_30546__$1);

return statearr_30608;
})();
var statearr_30609_30653 = state_30597__$1;
(statearr_30609_30653[(2)] = null);

(statearr_30609_30653[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (6))){
var inst_30514 = (state_30597[(17)]);
var state_30597__$1 = state_30597;
var statearr_30610_30654 = state_30597__$1;
(statearr_30610_30654[(2)] = inst_30514);

(statearr_30610_30654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (25))){
var inst_30592 = (state_30597[(2)]);
var _ = (function (){var statearr_30611 = state_30597;
(statearr_30611[(4)] = cljs.core.rest.call(null,(state_30597[(4)])));

return statearr_30611;
})();
var state_30597__$1 = state_30597;
var statearr_30612_30655 = state_30597__$1;
(statearr_30612_30655[(2)] = inst_30592);

(statearr_30612_30655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (17))){
var inst_30547 = (state_30597[(13)]);
var inst_30553 = (state_30597[(18)]);
var inst_30552 = cljs.core.seq.call(null,inst_30547);
var inst_30553__$1 = cljs.core.first.call(null,inst_30552);
var inst_30554 = cljs.core.next.call(null,inst_30552);
var state_30597__$1 = (function (){var statearr_30613 = state_30597;
(statearr_30613[(16)] = inst_30554);

(statearr_30613[(18)] = inst_30553__$1);

return statearr_30613;
})();
if(cljs.core.truth_(inst_30553__$1)){
var statearr_30614_30656 = state_30597__$1;
(statearr_30614_30656[(1)] = (19));

} else {
var statearr_30615_30657 = state_30597__$1;
(statearr_30615_30657[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (3))){
var inst_30595 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30597__$1,inst_30595);
} else {
if((state_val_30598 === (12))){
var inst_30520 = (state_30597[(19)]);
var inst_30531 = (state_30597[(12)]);
var inst_30526 = cljs.core.vals.call(null,inst_30520);
var inst_30527 = cljs.core.flatten.call(null,inst_30526);
var inst_30528 = cljs.core.set.call(null,inst_30527);
var inst_30529 = cljs.core.keys.call(null,inst_30520);
var inst_30530 = cljs.core.set.call(null,inst_30529);
var inst_30531__$1 = clojure.set.difference.call(null,inst_30528,inst_30530);
var inst_30532 = cljs.core.empty_QMARK_.call(null,inst_30531__$1);
var state_30597__$1 = (function (){var statearr_30616 = state_30597;
(statearr_30616[(12)] = inst_30531__$1);

return statearr_30616;
})();
if(inst_30532){
var statearr_30617_30658 = state_30597__$1;
(statearr_30617_30658[(1)] = (14));

} else {
var statearr_30618_30659 = state_30597__$1;
(statearr_30618_30659[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (2))){
var inst_30514 = (state_30597[(17)]);
var _ = (function (){var statearr_30619 = state_30597;
(statearr_30619[(4)] = cljs.core.cons.call(null,(5),(state_30597[(4)])));

return statearr_30619;
})();
var inst_30514__$1 = depth;
var state_30597__$1 = (function (){var statearr_30620 = state_30597;
(statearr_30620[(17)] = inst_30514__$1);

return statearr_30620;
})();
if(cljs.core.truth_(inst_30514__$1)){
var statearr_30621_30660 = state_30597__$1;
(statearr_30621_30660[(1)] = (6));

} else {
var statearr_30622_30661 = state_30597__$1;
(statearr_30622_30661[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (23))){
var inst_30585 = (state_30597[(11)]);
var state_30597__$1 = state_30597;
var statearr_30623_30662 = state_30597__$1;
(statearr_30623_30662[(2)] = inst_30585);

(statearr_30623_30662[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (19))){
var inst_30553 = (state_30597[(18)]);
var inst_30556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30557 = [inst_30553,predicate];
var inst_30558 = (new cljs.core.PersistentVector(null,2,(5),inst_30556,inst_30557,null));
var inst_30559 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_30558);
var state_30597__$1 = state_30597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30597__$1,(22),inst_30559);
} else {
if((state_val_30598 === (11))){
var inst_30520 = (state_30597[(19)]);
var state_30597__$1 = state_30597;
var statearr_30625_30663 = state_30597__$1;
(statearr_30625_30663[(2)] = inst_30520);

(statearr_30625_30663[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (9))){
var inst_30518 = (state_30597[(8)]);
var inst_30521 = (state_30597[(20)]);
var inst_30523 = (inst_30521 >= inst_30518);
var state_30597__$1 = state_30597;
if(cljs.core.truth_(inst_30523)){
var statearr_30626_30664 = state_30597__$1;
(statearr_30626_30664[(1)] = (11));

} else {
var statearr_30627_30665 = state_30597__$1;
(statearr_30627_30665[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (5))){
var _ = (function (){var statearr_30628 = state_30597;
(statearr_30628[(4)] = cljs.core.rest.call(null,(state_30597[(4)])));

return statearr_30628;
})();
var state_30597__$1 = state_30597;
var ex30624 = (state_30597__$1[(2)]);
var statearr_30629_30666 = state_30597__$1;
(statearr_30629_30666[(5)] = ex30624);


if((ex30624 instanceof Error)){
var statearr_30630_30667 = state_30597__$1;
(statearr_30630_30667[(1)] = (4));

(statearr_30630_30667[(5)] = null);

} else {
throw ex30624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (14))){
var inst_30520 = (state_30597[(19)]);
var state_30597__$1 = state_30597;
var statearr_30631_30668 = state_30597__$1;
(statearr_30631_30668[(2)] = inst_30520);

(statearr_30631_30668[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (16))){
var inst_30578 = (state_30597[(2)]);
var state_30597__$1 = state_30597;
var statearr_30632_30669 = state_30597__$1;
(statearr_30632_30669[(2)] = inst_30578);

(statearr_30632_30669[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (10))){
var inst_30583 = (state_30597[(9)]);
var inst_30584 = (state_30597[(10)]);
var inst_30582 = (state_30597[(2)]);
var inst_30583__$1 = cljs.core.keys.call(null,inst_30582);
var inst_30584__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_30583__$1,inst_30582);
var inst_30585 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_30583__$1,inst_30584__$1);
var state_30597__$1 = (function (){var statearr_30633 = state_30597;
(statearr_30633[(9)] = inst_30583__$1);

(statearr_30633[(10)] = inst_30584__$1);

(statearr_30633[(11)] = inst_30585);

return statearr_30633;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_30634_30670 = state_30597__$1;
(statearr_30634_30670[(1)] = (23));

} else {
var statearr_30635_30671 = state_30597__$1;
(statearr_30635_30671[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (18))){
var inst_30520 = (state_30597[(19)]);
var inst_30521 = (state_30597[(20)]);
var inst_30569 = (state_30597[(2)]);
var inst_30570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30571 = [(0),(2)];
var inst_30572 = (new cljs.core.PersistentVector(null,2,(5),inst_30570,inst_30571,null));
var inst_30573 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_30572,inst_30569);
var inst_30574 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_30520,inst_30573);
var inst_30575 = (inst_30521 + (1));
var inst_30520__$1 = inst_30574;
var inst_30521__$1 = inst_30575;
var state_30597__$1 = (function (){var statearr_30636 = state_30597;
(statearr_30636[(19)] = inst_30520__$1);

(statearr_30636[(20)] = inst_30521__$1);

return statearr_30636;
})();
var statearr_30637_30672 = state_30597__$1;
(statearr_30637_30672[(2)] = null);

(statearr_30637_30672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30598 === (8))){
var inst_30518 = (state_30597[(2)]);
var inst_30519 = recur_map;
var inst_30520 = inst_30519;
var inst_30521 = (1);
var state_30597__$1 = (function (){var statearr_30638 = state_30597;
(statearr_30638[(8)] = inst_30518);

(statearr_30638[(19)] = inst_30520);

(statearr_30638[(20)] = inst_30521);

return statearr_30638;
})();
var statearr_30639_30673 = state_30597__$1;
(statearr_30639_30673[(2)] = null);

(statearr_30639_30673[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____0 = (function (){
var statearr_30640 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30640[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__);

(statearr_30640[(1)] = (1));

return statearr_30640;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____1 = (function (state_30597){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30641){var ex__10906__auto__ = e30641;
var statearr_30642_30674 = state_30597;
(statearr_30642_30674[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30597[(4)]))){
var statearr_30643_30675 = state_30597;
(statearr_30643_30675[(1)] = cljs.core.first.call(null,(state_30597[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30676 = state_30597;
state_30597 = G__30676;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__ = function(state_30597){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____1.call(this,state_30597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30644 = f__10977__auto__.call(null);
(statearr_30644[(6)] = c__10976__auto__);

return statearr_30644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__30677,clause,fuel,max_fuel){
var map__30678 = p__30677;
var map__30678__$1 = cljs.core.__destructure_map.call(null,map__30678);
var res = map__30678__$1;
var headers = cljs.core.get.call(null,map__30678__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__30678__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__30678__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30789){
var state_val_30790 = (state_30789[(1)]);
if((state_val_30790 === (7))){
var inst_30695 = (state_30789[(7)]);
var state_30789__$1 = state_30789;
var statearr_30791_30844 = state_30789__$1;
(statearr_30791_30844[(2)] = inst_30695);

(statearr_30791_30844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (20))){
var inst_30723 = (state_30789[(8)]);
var inst_30754 = typeof inst_30723 === 'number';
var state_30789__$1 = state_30789;
if(cljs.core.truth_(inst_30754)){
var statearr_30792_30845 = state_30789__$1;
(statearr_30792_30845[(1)] = (22));

} else {
var statearr_30793_30846 = state_30789__$1;
(statearr_30793_30846[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (27))){
var inst_30769 = (state_30789[(2)]);
var state_30789__$1 = state_30789;
var statearr_30794_30847 = state_30789__$1;
(statearr_30794_30847[(2)] = inst_30769);

(statearr_30794_30847[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (1))){
var state_30789__$1 = state_30789;
var statearr_30795_30848 = state_30789__$1;
(statearr_30795_30848[(2)] = null);

(statearr_30795_30848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (24))){
var inst_30771 = (state_30789[(2)]);
var state_30789__$1 = state_30789;
var statearr_30796_30849 = state_30789__$1;
(statearr_30796_30849[(2)] = inst_30771);

(statearr_30796_30849[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (4))){
var inst_30679 = (state_30789[(2)]);
var state_30789__$1 = state_30789;
var statearr_30797_30850 = state_30789__$1;
(statearr_30797_30850[(2)] = inst_30679);

(statearr_30797_30850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (15))){
var inst_30737 = (state_30789[(2)]);
var inst_30738 = cljs.core.nth.call(null,clause,(2));
var inst_30739 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_30738);
var state_30789__$1 = (function (){var statearr_30798 = state_30789;
(statearr_30798[(9)] = inst_30737);

return statearr_30798;
})();
if(cljs.core.truth_(inst_30739)){
var statearr_30799_30851 = state_30789__$1;
(statearr_30799_30851[(1)] = (16));

} else {
var statearr_30800_30852 = state_30789__$1;
(statearr_30800_30852[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (21))){
var inst_30726 = (state_30789[(10)]);
var inst_30725 = (state_30789[(11)]);
var inst_30696 = (state_30789[(12)]);
var inst_30773 = (state_30789[(2)]);
var inst_30774 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_30726,inst_30773,inst_30696,inst_30725);
var state_30789__$1 = state_30789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30789__$1,(28),inst_30774);
} else {
if((state_val_30790 === (13))){
var inst_30705 = (state_30789[(13)]);
var inst_30729 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30705)].join('');
var inst_30730 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30731 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30732 = cljs.core.PersistentHashMap.fromArrays(inst_30730,inst_30731);
var inst_30733 = cljs.core.ex_info.call(null,inst_30729,inst_30732);
var inst_30734 = (function(){throw inst_30733})();
var state_30789__$1 = state_30789;
var statearr_30801_30853 = state_30789__$1;
(statearr_30801_30853[(2)] = inst_30734);

(statearr_30801_30853[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (22))){
var inst_30721 = (state_30789[(14)]);
var inst_30723 = (state_30789[(8)]);
var inst_30756 = cljs.core.PersistentHashMap.EMPTY;
var inst_30757 = cljs.core.flatten.call(null,inst_30721);
var inst_30758 = cljs.core.assoc.call(null,inst_30756,inst_30723,inst_30757);
var state_30789__$1 = state_30789;
var statearr_30802_30854 = state_30789__$1;
(statearr_30802_30854[(2)] = inst_30758);

(statearr_30802_30854[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (6))){
var inst_30707 = (state_30789[(15)]);
var state_30789__$1 = state_30789;
var statearr_30803_30855 = state_30789__$1;
(statearr_30803_30855[(2)] = inst_30707);

(statearr_30803_30855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (28))){
var inst_30776 = (state_30789[(2)]);
var inst_30777 = fluree.db.util.async.throw_err.call(null,inst_30776);
var state_30789__$1 = state_30789;
var statearr_30804_30856 = state_30789__$1;
(statearr_30804_30856[(2)] = inst_30777);

(statearr_30804_30856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (25))){
var inst_30717 = (state_30789[(16)]);
var inst_30721 = (state_30789[(14)]);
var inst_30762 = cljs.core.PersistentHashMap.EMPTY;
var inst_30763 = cljs.core.first.call(null,inst_30717);
var inst_30764 = cljs.core.first.call(null,inst_30763);
var inst_30765 = cljs.core.flatten.call(null,inst_30721);
var inst_30766 = cljs.core.assoc.call(null,inst_30762,inst_30764,inst_30765);
var state_30789__$1 = state_30789;
var statearr_30805_30857 = state_30789__$1;
(statearr_30805_30857[(2)] = inst_30766);

(statearr_30805_30857[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (17))){
var inst_30705 = (state_30789[(13)]);
var inst_30742 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30705)].join('');
var inst_30743 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30744 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30745 = cljs.core.PersistentHashMap.fromArrays(inst_30743,inst_30744);
var inst_30746 = cljs.core.ex_info.call(null,inst_30742,inst_30745);
var inst_30747 = (function(){throw inst_30746})();
var state_30789__$1 = state_30789;
var statearr_30806_30858 = state_30789__$1;
(statearr_30806_30858[(2)] = inst_30747);

(statearr_30806_30858[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (3))){
var inst_30787 = (state_30789[(2)]);
var state_30789__$1 = state_30789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30789__$1,inst_30787);
} else {
if((state_val_30790 === (12))){
var inst_30692 = (state_30789[(17)]);
var inst_30780 = (state_30789[(2)]);
var inst_30781 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_30782 = cljs.core.keys.call(null,inst_30692);
var inst_30783 = [inst_30782,vars,inst_30780];
var inst_30784 = cljs.core.PersistentHashMap.fromArrays(inst_30781,inst_30783);
var _ = (function (){var statearr_30807 = state_30789;
(statearr_30807[(4)] = cljs.core.rest.call(null,(state_30789[(4)])));

return statearr_30807;
})();
var state_30789__$1 = state_30789;
var statearr_30808_30859 = state_30789__$1;
(statearr_30808_30859[(2)] = inst_30784);

(statearr_30808_30859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (2))){
var inst_30707 = (state_30789[(15)]);
var inst_30692 = (state_30789[(17)]);
var inst_30696 = (state_30789[(12)]);
var inst_30695 = (state_30789[(7)]);
var _ = (function (){var statearr_30809 = state_30789;
(statearr_30809[(4)] = cljs.core.cons.call(null,(5),(state_30789[(4)])));

return statearr_30809;
})();
var inst_30689 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_30690 = cljs.core.__destructure_map.call(null,inst_30689);
var inst_30691 = cljs.core.get.call(null,inst_30690,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_30692__$1 = cljs.core.get.call(null,inst_30690,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_30693 = cljs.core.get.call(null,inst_30690,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_30694 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_30695__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_30693);
var inst_30696__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_30693);
var inst_30698 = (function (){var map__30685 = inst_30690;
var search = inst_30691;
var rel = inst_30692__$1;
var opts = inst_30693;
var common_keys = inst_30694;
var object_fn = inst_30695__$1;
var recur_depth = inst_30696__$1;
return (function (p__30697,common_key){
var vec__30810 = p__30697;
var acc = cljs.core.nth.call(null,vec__30810,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__30810,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__30813 = cljs.core._EQ_;
var expr__30814 = idx_of;
if(cljs.core.truth_(pred__30813.call(null,(0),expr__30814))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__30813.call(null,(1),expr__30814))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__30813.call(null,(2),expr__30814))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30814)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_30699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30700 = cljs.core.PersistentHashMap.EMPTY;
var inst_30701 = [inst_30700,inst_30691];
var inst_30702 = (new cljs.core.PersistentVector(null,2,(5),inst_30699,inst_30701,null));
var inst_30703 = cljs.core.reduce.call(null,inst_30698,inst_30702,inst_30694);
var inst_30704 = cljs.core.nth.call(null,inst_30703,(0),null);
var inst_30705 = cljs.core.nth.call(null,inst_30703,(1),null);
var inst_30706 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_30707__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_30704);
var state_30789__$1 = (function (){var statearr_30816 = state_30789;
(statearr_30816[(15)] = inst_30707__$1);

(statearr_30816[(17)] = inst_30692__$1);

(statearr_30816[(18)] = inst_30706);

(statearr_30816[(12)] = inst_30696__$1);

(statearr_30816[(13)] = inst_30705);

(statearr_30816[(7)] = inst_30695__$1);

return statearr_30816;
})();
if(cljs.core.truth_(inst_30707__$1)){
var statearr_30817_30860 = state_30789__$1;
(statearr_30817_30860[(1)] = (6));

} else {
var statearr_30818_30861 = state_30789__$1;
(statearr_30818_30861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (23))){
var inst_30723 = (state_30789[(8)]);
var inst_30760 = cljs.core.coll_QMARK_.call(null,inst_30723);
var state_30789__$1 = state_30789;
if(inst_30760){
var statearr_30819_30862 = state_30789__$1;
(statearr_30819_30862[(1)] = (25));

} else {
var statearr_30820_30863 = state_30789__$1;
(statearr_30820_30863[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (19))){
var inst_30721 = (state_30789[(14)]);
var inst_30751 = cljs.core.PersistentHashMap.EMPTY;
var inst_30752 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_30751,inst_30721);
var state_30789__$1 = state_30789;
var statearr_30821_30864 = state_30789__$1;
(statearr_30821_30864[(2)] = inst_30752);

(statearr_30821_30864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (11))){
var inst_30721 = (state_30789[(14)]);
var state_30789__$1 = state_30789;
var statearr_30823_30865 = state_30789__$1;
(statearr_30823_30865[(2)] = inst_30721);

(statearr_30823_30865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (9))){
var inst_30692 = (state_30789[(17)]);
var inst_30717 = (state_30789[(16)]);
var inst_30696 = (state_30789[(12)]);
var inst_30716 = (state_30789[(2)]);
var inst_30717__$1 = fluree.db.util.async.throw_err.call(null,inst_30716);
var inst_30718 = cljs.core.count.call(null,inst_30717__$1);
var inst_30719 = fluree.db.query.analytical.add_fuel.call(null,inst_30718,fuel,max_fuel);
var inst_30720 = cljs.core.vals.call(null,inst_30692);
var inst_30721 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_30720,inst_30717__$1);
var state_30789__$1 = (function (){var statearr_30824 = state_30789;
(statearr_30824[(19)] = inst_30719);

(statearr_30824[(16)] = inst_30717__$1);

(statearr_30824[(14)] = inst_30721);

return statearr_30824;
})();
if(cljs.core.truth_(inst_30696)){
var statearr_30825_30866 = state_30789__$1;
(statearr_30825_30866[(1)] = (10));

} else {
var statearr_30826_30867 = state_30789__$1;
(statearr_30826_30867[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (5))){
var _ = (function (){var statearr_30827 = state_30789;
(statearr_30827[(4)] = cljs.core.rest.call(null,(state_30789[(4)])));

return statearr_30827;
})();
var state_30789__$1 = state_30789;
var ex30822 = (state_30789__$1[(2)]);
var statearr_30828_30868 = state_30789__$1;
(statearr_30828_30868[(5)] = ex30822);


if((ex30822 instanceof Error)){
var statearr_30829_30869 = state_30789__$1;
(statearr_30829_30869[(1)] = (4));

(statearr_30829_30869[(5)] = null);

} else {
throw ex30822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (14))){
var state_30789__$1 = state_30789;
var statearr_30830_30870 = state_30789__$1;
(statearr_30830_30870[(2)] = null);

(statearr_30830_30870[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (26))){
var state_30789__$1 = state_30789;
var statearr_30831_30871 = state_30789__$1;
(statearr_30831_30871[(2)] = null);

(statearr_30831_30871[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (16))){
var state_30789__$1 = state_30789;
var statearr_30832_30872 = state_30789__$1;
(statearr_30832_30872[(2)] = null);

(statearr_30832_30872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (10))){
var inst_30726 = (state_30789[(10)]);
var inst_30705 = (state_30789[(13)]);
var inst_30723 = cljs.core.first.call(null,inst_30705);
var inst_30724 = cljs.core.first.call(null,clause);
var inst_30725 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_30724);
var inst_30726__$1 = cljs.core.nth.call(null,inst_30705,(1));
var inst_30727 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_30726__$1);
var state_30789__$1 = (function (){var statearr_30833 = state_30789;
(statearr_30833[(10)] = inst_30726__$1);

(statearr_30833[(11)] = inst_30725);

(statearr_30833[(8)] = inst_30723);

return statearr_30833;
})();
if(cljs.core.truth_(inst_30727)){
var statearr_30834_30873 = state_30789__$1;
(statearr_30834_30873[(1)] = (13));

} else {
var statearr_30835_30874 = state_30789__$1;
(statearr_30835_30874[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (18))){
var inst_30725 = (state_30789[(11)]);
var inst_30749 = (state_30789[(2)]);
var state_30789__$1 = (function (){var statearr_30836 = state_30789;
(statearr_30836[(20)] = inst_30749);

return statearr_30836;
})();
if(cljs.core.truth_(inst_30725)){
var statearr_30837_30875 = state_30789__$1;
(statearr_30837_30875[(1)] = (19));

} else {
var statearr_30838_30876 = state_30789__$1;
(statearr_30838_30876[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30790 === (8))){
var inst_30706 = (state_30789[(18)]);
var inst_30705 = (state_30789[(13)]);
var inst_30711 = (state_30789[(2)]);
var inst_30712 = [inst_30711];
var inst_30713 = cljs.core.PersistentHashMap.fromArrays(inst_30706,inst_30712);
var inst_30714 = fluree.db.query.range.search.call(null,db,inst_30705,inst_30713);
var state_30789__$1 = state_30789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30789__$1,(9),inst_30714);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____0 = (function (){
var statearr_30839 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30839[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__);

(statearr_30839[(1)] = (1));

return statearr_30839;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____1 = (function (state_30789){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30840){var ex__10906__auto__ = e30840;
var statearr_30841_30877 = state_30789;
(statearr_30841_30877[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30789[(4)]))){
var statearr_30842_30878 = state_30789;
(statearr_30842_30878[(1)] = cljs.core.first.call(null,(state_30789[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30879 = state_30789;
state_30789 = G__30879;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__ = function(state_30789){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____1.call(this,state_30789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30843 = f__10977__auto__.call(null);
(statearr_30843[(6)] = c__10976__auto__);

return statearr_30843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__30880,res,clause){
var map__30881 = p__30880;
var map__30881__$1 = cljs.core.__destructure_map.call(null,map__30881);
var db = map__30881__$1;
var conn = cljs.core.get.call(null,map__30881__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__30881__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__30881__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30990){
var state_val_30991 = (state_30990[(1)]);
if((state_val_30991 === (7))){
var inst_30890 = (state_30990[(7)]);
var state_30990__$1 = state_30990;
var statearr_30992_31033 = state_30990__$1;
(statearr_30992_31033[(2)] = inst_30890);

(statearr_30992_31033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (20))){
var state_30990__$1 = state_30990;
var statearr_30993_31034 = state_30990__$1;
(statearr_30993_31034[(2)] = null);

(statearr_30993_31034[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (1))){
var state_30990__$1 = state_30990;
var statearr_30994_31035 = state_30990__$1;
(statearr_30994_31035[(2)] = null);

(statearr_30994_31035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (24))){
var inst_30892 = (state_30990[(8)]);
var inst_30963 = (state_30990[(2)]);
var inst_30964 = fluree.db.flake.sid__GT_cid.call(null,inst_30963);
var inst_30965 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_30964);
var inst_30966 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_30967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30968 = [inst_30892];
var inst_30969 = (new cljs.core.PersistentVector(null,1,(5),inst_30967,inst_30968,null));
var inst_30970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30972 = [inst_30965];
var inst_30973 = (new cljs.core.PersistentVector(null,1,(5),inst_30971,inst_30972,null));
var inst_30974 = [inst_30973];
var inst_30975 = (new cljs.core.PersistentVector(null,1,(5),inst_30970,inst_30974,null));
var inst_30976 = cljs.core.PersistentHashMap.EMPTY;
var inst_30977 = [inst_30969,inst_30975,inst_30976];
var inst_30978 = cljs.core.PersistentHashMap.fromArrays(inst_30966,inst_30977);
var state_30990__$1 = state_30990;
var statearr_30995_31036 = state_30990__$1;
(statearr_30995_31036[(2)] = inst_30978);

(statearr_30995_31036[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (4))){
var inst_30883 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
var statearr_30996_31037 = state_30990__$1;
(statearr_30996_31037[(2)] = inst_30883);

(statearr_30996_31037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (15))){
var inst_30890 = (state_30990[(7)]);
var inst_30892 = (state_30990[(8)]);
var inst_30911 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_30912 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_30913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30914 = [inst_30890];
var inst_30915 = (new cljs.core.PersistentVector(null,1,(5),inst_30913,inst_30914,null));
var inst_30916 = (function (){var subject_var = inst_30890;
var object_var = inst_30892;
var min_sid = inst_30911;
var max_sid = (0);
return (function (p1__30882_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__30882_SHARP_);
});
})();
var inst_30917 = cljs.core.range.call(null,inst_30911,(0));
var inst_30918 = cljs.core.map.call(null,inst_30916,inst_30917);
var inst_30919 = cljs.core.PersistentHashMap.EMPTY;
var inst_30920 = [inst_30915,inst_30918,inst_30919];
var inst_30921 = cljs.core.PersistentHashMap.fromArrays(inst_30912,inst_30920);
var state_30990__$1 = state_30990;
var statearr_30997_31038 = state_30990__$1;
(statearr_30997_31038[(2)] = inst_30921);

(statearr_30997_31038[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (21))){
var inst_30981 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
var statearr_30998_31039 = state_30990__$1;
(statearr_30998_31039[(2)] = inst_30981);

(statearr_30998_31039[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (13))){
var inst_30892 = (state_30990[(8)]);
var state_30990__$1 = state_30990;
if(cljs.core.truth_(inst_30892)){
var statearr_30999_31040 = state_30990__$1;
(statearr_30999_31040[(1)] = (19));

} else {
var statearr_31000_31041 = state_30990__$1;
(statearr_31000_31041[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (22))){
var inst_30954 = (state_30990[(9)]);
var state_30990__$1 = state_30990;
var statearr_31001_31042 = state_30990__$1;
(statearr_31001_31042[(2)] = inst_30954);

(statearr_31001_31042[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (6))){
var inst_30892 = (state_30990[(8)]);
var state_30990__$1 = state_30990;
var statearr_31002_31043 = state_30990__$1;
(statearr_31002_31043[(2)] = inst_30892);

(statearr_31002_31043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (25))){
var inst_30960 = (state_30990[(2)]);
var inst_30961 = fluree.db.util.async.throw_err.call(null,inst_30960);
var state_30990__$1 = state_30990;
var statearr_31003_31044 = state_30990__$1;
(statearr_31003_31044[(2)] = inst_30961);

(statearr_31003_31044[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (17))){
var inst_30951 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
var statearr_31004_31045 = state_30990__$1;
(statearr_31004_31045[(2)] = inst_30951);

(statearr_31004_31045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (3))){
var inst_30988 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30990__$1,inst_30988);
} else {
if((state_val_30991 === (12))){
var inst_30905 = ["_tx",null,"_block",null];
var inst_30906 = (new cljs.core.PersistentArrayMap(null,2,inst_30905,null));
var inst_30907 = (new cljs.core.PersistentHashSet(null,inst_30906,null));
var inst_30908 = cljs.core.last.call(null,clause);
var inst_30909 = inst_30907.call(null,inst_30908);
var state_30990__$1 = state_30990;
if(cljs.core.truth_(inst_30909)){
var statearr_31005_31046 = state_30990__$1;
(statearr_31005_31046[(1)] = (15));

} else {
var statearr_31006_31047 = state_30990__$1;
(statearr_31006_31047[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (2))){
var inst_30890 = (state_30990[(7)]);
var _ = (function (){var statearr_31007 = state_30990;
(statearr_31007[(4)] = cljs.core.cons.call(null,(5),(state_30990[(4)])));

return statearr_31007;
})();
var inst_30889 = cljs.core.first.call(null,clause);
var inst_30890__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_30889);
var inst_30891 = cljs.core.last.call(null,clause);
var inst_30892 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_30891);
var state_30990__$1 = (function (){var statearr_31008 = state_30990;
(statearr_31008[(7)] = inst_30890__$1);

(statearr_31008[(8)] = inst_30892);

return statearr_31008;
})();
if(cljs.core.truth_(inst_30890__$1)){
var statearr_31009_31048 = state_30990__$1;
(statearr_31009_31048[(1)] = (6));

} else {
var statearr_31010_31049 = state_30990__$1;
(statearr_31010_31049[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (23))){
var inst_30954 = (state_30990[(9)]);
var inst_30958 = fluree.db.dbproto._subid.call(null,db,inst_30954);
var state_30990__$1 = state_30990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30990__$1,(25),inst_30958);
} else {
if((state_val_30991 === (19))){
var inst_30954 = (state_30990[(9)]);
var inst_30954__$1 = cljs.core.first.call(null,clause);
var inst_30955 = typeof inst_30954__$1 === 'number';
var state_30990__$1 = (function (){var statearr_31011 = state_30990;
(statearr_31011[(9)] = inst_30954__$1);

return statearr_31011;
})();
if(cljs.core.truth_(inst_30955)){
var statearr_31012_31050 = state_30990__$1;
(statearr_31012_31050[(1)] = (22));

} else {
var statearr_31013_31051 = state_30990__$1;
(statearr_31013_31051[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (11))){
var inst_30985 = (state_30990[(2)]);
var _ = (function (){var statearr_31015 = state_30990;
(statearr_31015[(4)] = cljs.core.rest.call(null,(state_30990[(4)])));

return statearr_31015;
})();
var state_30990__$1 = state_30990;
var statearr_31016_31052 = state_30990__$1;
(statearr_31016_31052[(2)] = inst_30985);

(statearr_31016_31052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (9))){
var inst_30898 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30899 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30900 = cljs.core.PersistentHashMap.fromArrays(inst_30898,inst_30899);
var inst_30901 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_30900);
var inst_30902 = (function(){throw inst_30901})();
var state_30990__$1 = state_30990;
var statearr_31017_31053 = state_30990__$1;
(statearr_31017_31053[(2)] = inst_30902);

(statearr_31017_31053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (5))){
var _ = (function (){var statearr_31018 = state_30990;
(statearr_31018[(4)] = cljs.core.rest.call(null,(state_30990[(4)])));

return statearr_31018;
})();
var state_30990__$1 = state_30990;
var ex31014 = (state_30990__$1[(2)]);
var statearr_31019_31054 = state_30990__$1;
(statearr_31019_31054[(5)] = ex31014);


if((ex31014 instanceof Error)){
var statearr_31020_31055 = state_30990__$1;
(statearr_31020_31055[(1)] = (4));

(statearr_31020_31055[(5)] = null);

} else {
throw ex31014;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (14))){
var inst_30983 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
var statearr_31021_31056 = state_30990__$1;
(statearr_31021_31056[(2)] = inst_30983);

(statearr_31021_31056[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (16))){
var inst_30927 = (state_30990[(10)]);
var inst_30924 = (state_30990[(11)]);
var inst_30926 = (state_30990[(12)]);
var inst_30923 = cljs.core.last.call(null,clause);
var inst_30924__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_30923);
var inst_30925 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_30926__$1 = cljs.core.get.call(null,inst_30925,inst_30924__$1);
var inst_30927__$1 = fluree.db.flake.min_subject_id.call(null,inst_30924__$1);
var inst_30928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30929 = [inst_30926__$1];
var inst_30930 = (new cljs.core.PersistentVector(null,1,(5),inst_30928,inst_30929,null));
var inst_30931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30932 = [inst_30927__$1];
var inst_30933 = (new cljs.core.PersistentVector(null,1,(5),inst_30931,inst_30932,null));
var inst_30934 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_30930,cljs.core._LT__EQ_,inst_30933);
var state_30990__$1 = (function (){var statearr_31022 = state_30990;
(statearr_31022[(10)] = inst_30927__$1);

(statearr_31022[(11)] = inst_30924__$1);

(statearr_31022[(12)] = inst_30926__$1);

return statearr_31022;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30990__$1,(18),inst_30934);
} else {
if((state_val_30991 === (10))){
var inst_30890 = (state_30990[(7)]);
var state_30990__$1 = state_30990;
if(cljs.core.truth_(inst_30890)){
var statearr_31023_31057 = state_30990__$1;
(statearr_31023_31057[(1)] = (12));

} else {
var statearr_31024_31058 = state_30990__$1;
(statearr_31024_31058[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (18))){
var inst_30927 = (state_30990[(10)]);
var inst_30924 = (state_30990[(11)]);
var inst_30890 = (state_30990[(7)]);
var inst_30892 = (state_30990[(8)]);
var inst_30926 = (state_30990[(12)]);
var inst_30936 = (state_30990[(2)]);
var inst_30937 = fluree.db.util.async.throw_err.call(null,inst_30936);
var inst_30938 = (function (){var subject_var = inst_30890;
var object_var = inst_30892;
var partition = inst_30924;
var max_sid = inst_30926;
var min_sid = inst_30927;
var flakes = inst_30937;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_30939 = cljs.core.map.call(null,inst_30938);
var inst_30940 = cljs.core.distinct.call(null);
var inst_30941 = cljs.core.comp.call(null,inst_30939,inst_30940);
var inst_30942 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_30943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30944 = [inst_30890];
var inst_30945 = (new cljs.core.PersistentVector(null,1,(5),inst_30943,inst_30944,null));
var inst_30946 = cljs.core.sequence.call(null,inst_30941,inst_30937);
var inst_30947 = cljs.core.PersistentHashMap.EMPTY;
var inst_30948 = [inst_30945,inst_30946,inst_30947];
var inst_30949 = cljs.core.PersistentHashMap.fromArrays(inst_30942,inst_30948);
var state_30990__$1 = state_30990;
var statearr_31025_31059 = state_30990__$1;
(statearr_31025_31059[(2)] = inst_30949);

(statearr_31025_31059[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30991 === (8))){
var inst_30896 = (state_30990[(2)]);
var state_30990__$1 = state_30990;
if(cljs.core.truth_(inst_30896)){
var statearr_31026_31060 = state_30990__$1;
(statearr_31026_31060[(1)] = (9));

} else {
var statearr_31027_31061 = state_30990__$1;
(statearr_31027_31061[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____0 = (function (){
var statearr_31028 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31028[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__);

(statearr_31028[(1)] = (1));

return statearr_31028;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____1 = (function (state_30990){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e31029){var ex__10906__auto__ = e31029;
var statearr_31030_31062 = state_30990;
(statearr_31030_31062[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30990[(4)]))){
var statearr_31031_31063 = state_30990;
(statearr_31031_31063[(1)] = cljs.core.first.call(null,(state_30990[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31064 = state_30990;
state_30990 = G__31064;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__ = function(state_30990){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____1.call(this,state_30990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_31032 = f__10977__auto__.call(null);
(statearr_31032[(6)] = c__10976__auto__);

return statearr_31032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__31070 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__31070 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__31070;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__31071(s__31072){
return (new cljs.core.LazySeq(null,(function (){
var s__31072__$1 = s__31072;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__31072__$1);
if(temp__5753__auto__){
var s__31072__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__31072__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__31072__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__31074 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__31073 = (0);
while(true){
if((i__31073 < size__4651__auto__)){
var x = cljs.core._nth.call(null,c__4650__auto__,i__31073);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__31074,(delta * delta));

var G__31075 = (i__31073 + (1));
i__31073 = G__31075;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__31074),fluree$db$query$analytical$variance_$_iter__31071.call(null,cljs.core.chunk_rest.call(null,s__31072__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__31074),null);
}
} else {
var x = cljs.core.first.call(null,s__31072__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__31071.call(null,cljs.core.rest.call(null,s__31072__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__31076 = null;
var G__31076__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__31076__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31076 = function(n,coll){
switch(arguments.length){
case 1:
return G__31076__1.call(this,n);
case 2:
return G__31076__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31076.cljs$core$IFn$_invoke$arity$1 = G__31076__1;
G__31076.cljs$core$IFn$_invoke$arity$2 = G__31076__2;
return G__31076;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__31077 = null;
var G__31077__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__31077__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31077 = function(n,coll){
switch(arguments.length){
case 1:
return G__31077__1.call(this,n);
case 2:
return G__31077__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31077.cljs$core$IFn$_invoke$arity$1 = G__31077__1;
G__31077.cljs$core$IFn$_invoke$arity$2 = G__31077__2;
return G__31077;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__31078 = null;
var G__31078__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__31078__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__31078 = function(n,coll){
switch(arguments.length){
case 1:
return G__31078__1.call(this,n);
case 2:
return G__31078__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31078.cljs$core$IFn$_invoke$arity$1 = G__31078__1;
G__31078.cljs$core$IFn$_invoke$arity$2 = G__31078__2;
return G__31078;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__31079 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__31079,(0),null);
var arg = cljs.core.nth.call(null,vec__31079,(1),null);
var var$ = cljs.core.nth.call(null,vec__31079,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__31082 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__31082,(0),null);
var variable = cljs.core.nth.call(null,vec__31082,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__31085 = agg;
var map__31085__$1 = cljs.core.__destructure_map.call(null,map__31085);
var variable = cljs.core.get.call(null,map__31085__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__31085__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__31085__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__31087 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__31087,(0),null);
var agg_result = cljs.core.nth.call(null,vec__31087,(1),null);
var map__31090 = res__$1;
var map__31090__$1 = cljs.core.__destructure_map.call(null,map__31090);
var headers = cljs.core.get.call(null,map__31090__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__31090__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__31086_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__31086_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__31091_SHARP_){
return cljs.core.nth.call(null,tuple,p1__31091_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__31092_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__31092_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.call(null,(function (p1__31093_SHARP_,p2__31094_SHARP_){
return cljs.core.conj.call(null,p1__31093_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__31094_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__31095_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__31095_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__31098,row,b_tuple){
var vec__31099 = p__31098;
var acc = cljs.core.nth.call(null,vec__31099,(0),null);
var b_rows = cljs.core.nth.call(null,vec__31099,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__31096_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__31096_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__31097_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__31097_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__31102_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__31102_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__31103_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31103_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__31105_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__31105_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__31104_SHARP_){
return cljs.core.range.call(null,(0),p1__31104_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__31106_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31106_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__31107_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__31107_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__31108_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31108_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__31110_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__31110_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__31109_SHARP_){
return cljs.core.range.call(null,(0),p1__31109_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__31111_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31111_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__31113 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__31113,(0),null);
var _ = cljs.core.nth.call(null,vec__31113,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__31112_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__31112_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__31118 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__31118,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__31118,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__31116_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__31116_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__31117_SHARP_){
return cljs.core.nth.call(null,clause,p1__31117_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__31121,filters,optional_QMARK_){
var map__31122 = p__31121;
var map__31122__$1 = cljs.core.__destructure_map.call(null,map__31122);
var tuple_map = map__31122__$1;
var headers = cljs.core.get.call(null,map__31122__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__31122__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__31122__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__31123 = clause;
var k = cljs.core.nth.call(null,vec__31123,(0),null);
var v = cljs.core.nth.call(null,vec__31123,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__31126 = res;
var map__31126__$1 = cljs.core.__destructure_map.call(null,map__31126);
var headers = cljs.core.get.call(null,map__31126__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__31126__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5751__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_31182){
var state_val_31183 = (state_31182[(1)]);
if((state_val_31183 === (7))){
var inst_31156 = (state_31182[(7)]);
var inst_31154 = (state_31182[(2)]);
var inst_31155 = fluree.db.util.async.throw_err.call(null,inst_31154);
var inst_31156__$1 = cljs.core.nth.call(null,inst_31155,(0),null);
var inst_31157 = cljs.core.nth.call(null,inst_31155,(1),null);
var inst_31158 = (inst_31156__$1 == null);
var state_31182__$1 = (function (){var statearr_31184 = state_31182;
(statearr_31184[(8)] = inst_31157);

(statearr_31184[(7)] = inst_31156__$1);

return statearr_31184;
})();
if(cljs.core.truth_(inst_31158)){
var statearr_31185_31214 = state_31182__$1;
(statearr_31185_31214[(1)] = (8));

} else {
var statearr_31186_31215 = state_31182__$1;
(statearr_31186_31215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (1))){
var inst_31134 = optional_clauses;
var inst_31135 = cljs.core.seq.call(null,inst_31134);
var inst_31136 = cljs.core.first.call(null,inst_31135);
var inst_31137 = cljs.core.next.call(null,inst_31135);
var inst_31138 = where_tuples;
var inst_31139 = inst_31134;
var inst_31140 = inst_31138;
var state_31182__$1 = (function (){var statearr_31187 = state_31182;
(statearr_31187[(9)] = inst_31140);

(statearr_31187[(10)] = inst_31139);

(statearr_31187[(11)] = inst_31137);

(statearr_31187[(12)] = inst_31136);

return statearr_31187;
})();
var statearr_31188_31216 = state_31182__$1;
(statearr_31188_31216[(2)] = null);

(statearr_31188_31216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (4))){
var inst_31140 = (state_31182[(9)]);
var inst_31147 = (state_31182[(13)]);
var inst_31146 = (state_31182[(14)]);
var inst_31152 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_31140,inst_31146,inst_31147,true,fuel,max_fuel,opts);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31182__$1,(7),inst_31152);
} else {
if((state_val_31183 === (15))){
var state_31182__$1 = state_31182;
var statearr_31189_31217 = state_31182__$1;
(statearr_31189_31217[(2)] = null);

(statearr_31189_31217[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (13))){
var inst_31173 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
var statearr_31190_31218 = state_31182__$1;
(statearr_31190_31218[(2)] = inst_31173);

(statearr_31190_31218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (6))){
var inst_31178 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
var statearr_31191_31219 = state_31182__$1;
(statearr_31191_31219[(2)] = inst_31178);

(statearr_31191_31219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (3))){
var inst_31180 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31182__$1,inst_31180);
} else {
if((state_val_31183 === (12))){
var state_31182__$1 = state_31182;
var statearr_31192_31220 = state_31182__$1;
(statearr_31192_31220[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (2))){
var inst_31139 = (state_31182[(10)]);
var inst_31146 = (state_31182[(14)]);
var inst_31145 = cljs.core.seq.call(null,inst_31139);
var inst_31146__$1 = cljs.core.first.call(null,inst_31145);
var inst_31147 = cljs.core.next.call(null,inst_31145);
var state_31182__$1 = (function (){var statearr_31194 = state_31182;
(statearr_31194[(13)] = inst_31147);

(statearr_31194[(14)] = inst_31146__$1);

return statearr_31194;
})();
if(cljs.core.truth_(inst_31146__$1)){
var statearr_31195_31221 = state_31182__$1;
(statearr_31195_31221[(1)] = (4));

} else {
var statearr_31196_31222 = state_31182__$1;
(statearr_31196_31222[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (11))){
var inst_31157 = (state_31182[(8)]);
var inst_31156 = (state_31182[(7)]);
var inst_31139 = inst_31157;
var inst_31140 = inst_31156;
var state_31182__$1 = (function (){var statearr_31197 = state_31182;
(statearr_31197[(9)] = inst_31140);

(statearr_31197[(10)] = inst_31139);

return statearr_31197;
})();
var statearr_31198_31223 = state_31182__$1;
(statearr_31198_31223[(2)] = null);

(statearr_31198_31223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (9))){
var inst_31146 = (state_31182[(14)]);
var inst_31162 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_31146);
var state_31182__$1 = state_31182;
if(cljs.core.truth_(inst_31162)){
var statearr_31199_31224 = state_31182__$1;
(statearr_31199_31224[(1)] = (11));

} else {
var statearr_31200_31225 = state_31182__$1;
(statearr_31200_31225[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (5))){
var inst_31140 = (state_31182[(9)]);
var state_31182__$1 = state_31182;
var statearr_31201_31226 = state_31182__$1;
(statearr_31201_31226[(2)] = inst_31140);

(statearr_31201_31226[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (14))){
var inst_31140 = (state_31182[(9)]);
var inst_31157 = (state_31182[(8)]);
var inst_31156 = (state_31182[(7)]);
var inst_31167 = fluree.db.query.analytical.left_outer_join.call(null,inst_31140,inst_31156);
var inst_31139 = inst_31157;
var inst_31140__$1 = inst_31167;
var state_31182__$1 = (function (){var statearr_31202 = state_31182;
(statearr_31202[(9)] = inst_31140__$1);

(statearr_31202[(10)] = inst_31139);

return statearr_31202;
})();
var statearr_31203_31227 = state_31182__$1;
(statearr_31203_31227[(2)] = null);

(statearr_31203_31227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (16))){
var inst_31171 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
var statearr_31205_31228 = state_31182__$1;
(statearr_31205_31228[(2)] = inst_31171);

(statearr_31205_31228[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (10))){
var inst_31175 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
var statearr_31206_31229 = state_31182__$1;
(statearr_31206_31229[(2)] = inst_31175);

(statearr_31206_31229[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31183 === (8))){
var inst_31140 = (state_31182[(9)]);
var inst_31157 = (state_31182[(8)]);
var tmp31204 = inst_31140;
var inst_31139 = inst_31157;
var inst_31140__$1 = tmp31204;
var state_31182__$1 = (function (){var statearr_31207 = state_31182;
(statearr_31207[(9)] = inst_31140__$1);

(statearr_31207[(10)] = inst_31139);

return statearr_31207;
})();
var statearr_31208_31230 = state_31182__$1;
(statearr_31208_31230[(2)] = null);

(statearr_31208_31230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____0 = (function (){
var statearr_31209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31209[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__);

(statearr_31209[(1)] = (1));

return statearr_31209;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____1 = (function (state_31182){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_31182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e31210){var ex__10906__auto__ = e31210;
var statearr_31211_31231 = state_31182;
(statearr_31211_31231[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_31182[(4)]))){
var statearr_31212_31232 = state_31182;
(statearr_31212_31232[(1)] = cljs.core.first.call(null,(state_31182[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31233 = state_31182;
state_31182 = G__31233;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__ = function(state_31182){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____1.call(this,state_31182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_31213 = f__10977__auto__.call(null);
(statearr_31213[(6)] = c__10976__auto__);

return statearr_31213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__31235){
var vec__31236 = p__31235;
var var_name = cljs.core.nth.call(null,vec__31236,(0),null);
var var_val = cljs.core.nth.call(null,vec__31236,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__31234_SHARP_){
return cljs.core.conj.call(null,p1__31234_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__31240,p__31241,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__31242 = p__31240;
var map__31242__$1 = cljs.core.__destructure_map.call(null,map__31242);
var q_map = map__31242__$1;
var prefixes = cljs.core.get.call(null,map__31242__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__31243 = p__31241;
var map__31243__$1 = cljs.core.__destructure_map.call(null,map__31243);
var res = map__31243__$1;
var vars = cljs.core.get.call(null,map__31243__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_31480){
var state_val_31481 = (state_31480[(1)]);
if((state_val_31481 === (65))){
var inst_31429 = (state_31480[(7)]);
var inst_31430 = (state_31480[(8)]);
var inst_31441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31442 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_31429,res,inst_31430);
var inst_31443 = [inst_31442,r];
var inst_31444 = (new cljs.core.PersistentVector(null,2,(5),inst_31441,inst_31443,null));
var state_31480__$1 = state_31480;
var statearr_31482_31587 = state_31480__$1;
(statearr_31482_31587[(2)] = inst_31444);

(statearr_31482_31587[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (70))){
var inst_31456 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31483_31588 = state_31480__$1;
(statearr_31483_31588[(2)] = inst_31456);

(statearr_31483_31588[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (62))){
var inst_31430 = (state_31480[(8)]);
var inst_31438 = cljs.core.second.call(null,inst_31430);
var inst_31439 = clojure.string.starts_with_QMARK_.call(null,inst_31438,"fullText:");
var state_31480__$1 = state_31480;
if(inst_31439){
var statearr_31484_31589 = state_31480__$1;
(statearr_31484_31589[(1)] = (65));

} else {
var statearr_31485_31590 = state_31480__$1;
(statearr_31485_31590[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (7))){
var inst_31349 = (state_31480[(9)]);
var inst_31348 = cljs.core.count.call(null,clause);
var inst_31349__$1 = cljs.core._EQ_.call(null,(3),inst_31348);
var state_31480__$1 = (function (){var statearr_31486 = state_31480;
(statearr_31486[(9)] = inst_31349__$1);

return statearr_31486;
})();
if(inst_31349__$1){
var statearr_31487_31591 = state_31480__$1;
(statearr_31487_31591[(1)] = (31));

} else {
var statearr_31488_31592 = state_31480__$1;
(statearr_31488_31592[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (59))){
var inst_31463 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31489_31593 = state_31480__$1;
(statearr_31489_31593[(2)] = inst_31463);

(statearr_31489_31593[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (20))){
var inst_31312 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31490_31594 = state_31480__$1;
(statearr_31490_31594[(2)] = inst_31312);

(statearr_31490_31594[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (58))){
var state_31480__$1 = state_31480;
var statearr_31491_31595 = state_31480__$1;
(statearr_31491_31595[(2)] = null);

(statearr_31491_31595[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (60))){
var inst_31429 = (state_31480[(7)]);
var inst_31427 = (state_31480[(2)]);
var inst_31428 = fluree.db.util.async.throw_err.call(null,inst_31427);
var inst_31429__$1 = cljs.core.nth.call(null,inst_31428,(0),null);
var inst_31430 = cljs.core.nth.call(null,inst_31428,(1),null);
var inst_31431 = cljs.core._EQ_.call(null,"$wd",inst_31429__$1);
var state_31480__$1 = (function (){var statearr_31492 = state_31480;
(statearr_31492[(7)] = inst_31429__$1);

(statearr_31492[(8)] = inst_31430);

return statearr_31492;
})();
if(inst_31431){
var statearr_31493_31596 = state_31480__$1;
(statearr_31493_31596[(1)] = (61));

} else {
var statearr_31494_31597 = state_31480__$1;
(statearr_31494_31597[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (27))){
var inst_31342 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31495_31598 = state_31480__$1;
(statearr_31495_31598[(2)] = inst_31342);

(statearr_31495_31598[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (1))){
var state_31480__$1 = state_31480;
var statearr_31496_31599 = state_31480__$1;
(statearr_31496_31599[(2)] = null);

(statearr_31496_31599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (69))){
var state_31480__$1 = state_31480;
var statearr_31497_31600 = state_31480__$1;
(statearr_31497_31600[(2)] = null);

(statearr_31497_31600[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (24))){
var inst_31306 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31498_31601 = state_31480__$1;
(statearr_31498_31601[(2)] = inst_31306);

(statearr_31498_31601[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (55))){
var inst_31412 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_31413 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31414 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31415 = cljs.core.PersistentHashMap.fromArrays(inst_31413,inst_31414);
var inst_31416 = cljs.core.ex_info.call(null,inst_31412,inst_31415);
var inst_31417 = (function(){throw inst_31416})();
var state_31480__$1 = state_31480;
var statearr_31499_31602 = state_31480__$1;
(statearr_31499_31602[(2)] = inst_31417);

(statearr_31499_31602[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (39))){
var inst_31369 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31369)){
var statearr_31500_31603 = state_31480__$1;
(statearr_31500_31603[(1)] = (40));

} else {
var statearr_31501_31604 = state_31480__$1;
(statearr_31501_31604[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (46))){
var inst_31469 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31502_31605 = state_31480__$1;
(statearr_31502_31605[(2)] = inst_31469);

(statearr_31502_31605[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (4))){
var inst_31244 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31503_31606 = state_31480__$1;
(statearr_31503_31606[(2)] = inst_31244);

(statearr_31503_31606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (54))){
var inst_31405 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_31406 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31407 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31408 = cljs.core.PersistentHashMap.fromArrays(inst_31406,inst_31407);
var inst_31409 = cljs.core.ex_info.call(null,inst_31405,inst_31408);
var inst_31410 = (function(){throw inst_31409})();
var state_31480__$1 = state_31480;
var statearr_31504_31607 = state_31480__$1;
(statearr_31504_31607[(2)] = inst_31410);

(statearr_31504_31607[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (15))){
var inst_31344 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31505_31608 = state_31480__$1;
(statearr_31505_31608[(2)] = inst_31344);

(statearr_31505_31608[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (48))){
var inst_31393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31394 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_31395 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_31394);
var inst_31396 = [inst_31395,r];
var inst_31397 = (new cljs.core.PersistentVector(null,2,(5),inst_31393,inst_31396,null));
var state_31480__$1 = state_31480;
var statearr_31506_31609 = state_31480__$1;
(statearr_31506_31609[(2)] = inst_31397);

(statearr_31506_31609[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (50))){
var inst_31467 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31507_31610 = state_31480__$1;
(statearr_31507_31610[(2)] = inst_31467);

(statearr_31507_31610[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (21))){
var inst_31281 = (state_31480[(10)]);
var inst_31278 = (state_31480[(11)]);
var inst_31280 = (state_31480[(12)]);
var inst_31289 = (state_31480[(13)]);
var inst_31253 = (state_31480[(14)]);
var inst_31282 = (state_31480[(15)]);
var inst_31257 = (state_31480[(16)]);
var inst_31290 = (state_31480[(17)]);
var inst_31283 = (state_31480[(18)]);
var inst_31294 = (state_31480[(2)]);
var inst_31295 = fluree.db.util.async.throw_err.call(null,inst_31294);
var inst_31296 = (function (){var new_res = inst_31295;
var rest = inst_31290;
var vec__31275 = inst_31278;
var first__31287 = inst_31289;
var tuples = inst_31283;
var vec__31285 = inst_31282;
var expr__31255 = inst_31253;
var seq__31276 = inst_31281;
var G__31274 = inst_31282;
var pred__31254 = inst_31257;
var first__31277 = inst_31280;
var segment_type = inst_31253;
var seq__31286 = inst_31290;
var clause_group = inst_31289;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_31297 = cljs.core.keys.call(null,vars);
var inst_31298 = cljs.core.reduce.call(null,inst_31296,inst_31295,inst_31297);
var inst_31299 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_31298);
var state_31480__$1 = (function (){var statearr_31508 = state_31480;
(statearr_31508[(19)] = inst_31299);

return statearr_31508;
})();
if(cljs.core.truth_(inst_31283)){
var statearr_31509_31611 = state_31480__$1;
(statearr_31509_31611[(1)] = (22));

} else {
var statearr_31510_31612 = state_31480__$1;
(statearr_31510_31612[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (31))){
var inst_31351 = cljs.core.second.call(null,clause);
var inst_31352 = clojure.string.starts_with_QMARK_.call(null,inst_31351,"fullText:");
var state_31480__$1 = state_31480;
var statearr_31511_31613 = state_31480__$1;
(statearr_31511_31613[(2)] = inst_31352);

(statearr_31511_31613[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (32))){
var inst_31349 = (state_31480[(9)]);
var state_31480__$1 = state_31480;
var statearr_31512_31614 = state_31480__$1;
(statearr_31512_31614[(2)] = inst_31349);

(statearr_31512_31614[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (40))){
var inst_31371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31372 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_31480__$1 = (function (){var statearr_31513 = state_31480;
(statearr_31513[(20)] = inst_31371);

return statearr_31513;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(43),inst_31372);
} else {
if((state_val_31481 === (56))){
var inst_31419 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31514_31615 = state_31480__$1;
(statearr_31514_31615[(2)] = inst_31419);

(statearr_31514_31615[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (33))){
var inst_31355 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31355)){
var statearr_31515_31616 = state_31480__$1;
(statearr_31515_31616[(1)] = (34));

} else {
var statearr_31516_31617 = state_31480__$1;
(statearr_31516_31617[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (13))){
var inst_31278 = (state_31480[(11)]);
var inst_31278__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_31279 = cljs.core.seq.call(null,inst_31278__$1);
var inst_31280 = cljs.core.first.call(null,inst_31279);
var inst_31281 = cljs.core.next.call(null,inst_31279);
var inst_31282 = inst_31278__$1;
var inst_31283 = null;
var state_31480__$1 = (function (){var statearr_31517 = state_31480;
(statearr_31517[(10)] = inst_31281);

(statearr_31517[(11)] = inst_31278__$1);

(statearr_31517[(12)] = inst_31280);

(statearr_31517[(15)] = inst_31282);

(statearr_31517[(18)] = inst_31283);

return statearr_31517;
})();
var statearr_31518_31618 = state_31480__$1;
(statearr_31518_31618[(2)] = null);

(statearr_31518_31618[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (22))){
var inst_31299 = (state_31480[(19)]);
var inst_31290 = (state_31480[(17)]);
var inst_31283 = (state_31480[(18)]);
var inst_31301 = fluree.db.query.union.results.call(null,inst_31283,inst_31299);
var inst_31282 = inst_31290;
var inst_31283__$1 = inst_31301;
var state_31480__$1 = (function (){var statearr_31519 = state_31480;
(statearr_31519[(15)] = inst_31282);

(statearr_31519[(18)] = inst_31283__$1);

return statearr_31519;
})();
var statearr_31520_31619 = state_31480__$1;
(statearr_31520_31619[(2)] = null);

(statearr_31520_31619[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (36))){
var inst_31473 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31521_31620 = state_31480__$1;
(statearr_31521_31620[(2)] = inst_31473);

(statearr_31521_31620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (41))){
var inst_31379 = cljs.core.count.call(null,clause);
var inst_31380 = cljs.core._EQ_.call(null,(3),inst_31379);
var state_31480__$1 = state_31480;
if(inst_31380){
var statearr_31522_31621 = state_31480__$1;
(statearr_31522_31621[(1)] = (44));

} else {
var statearr_31523_31622 = state_31480__$1;
(statearr_31523_31622[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (43))){
var inst_31371 = (state_31480[(20)]);
var inst_31374 = (state_31480[(2)]);
var inst_31375 = fluree.db.util.async.throw_err.call(null,inst_31374);
var inst_31376 = [inst_31375,r];
var inst_31377 = (new cljs.core.PersistentVector(null,2,(5),inst_31371,inst_31376,null));
var state_31480__$1 = state_31480;
var statearr_31524_31623 = state_31480__$1;
(statearr_31524_31623[(2)] = inst_31377);

(statearr_31524_31623[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (61))){
var inst_31430 = (state_31480[(8)]);
var inst_31433 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_31430,r,res,optional_QMARK_,fuel,max_fuel);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(64),inst_31433);
} else {
if((state_val_31481 === (29))){
var inst_31253 = (state_31480[(14)]);
var inst_31336 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31253)].join('');
var inst_31337 = (new Error(inst_31336));
var inst_31338 = (function(){throw inst_31337})();
var state_31480__$1 = state_31480;
var statearr_31525_31624 = state_31480__$1;
(statearr_31525_31624[(2)] = inst_31338);

(statearr_31525_31624[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (44))){
var inst_31382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31383 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_31480__$1 = (function (){var statearr_31526 = state_31480;
(statearr_31526[(21)] = inst_31382);

return statearr_31526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(47),inst_31383);
} else {
if((state_val_31481 === (6))){
var inst_31253 = (state_31480[(14)]);
var inst_31257 = (state_31480[(16)]);
var inst_31252 = cljs.core.keys.call(null,clause);
var inst_31253__$1 = cljs.core.first.call(null,inst_31252);
var inst_31257__$1 = cljs.core._EQ_;
var inst_31258 = inst_31257__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_31253__$1);
var state_31480__$1 = (function (){var statearr_31527 = state_31480;
(statearr_31527[(14)] = inst_31253__$1);

(statearr_31527[(16)] = inst_31257__$1);

return statearr_31527;
})();
if(cljs.core.truth_(inst_31258)){
var statearr_31528_31625 = state_31480__$1;
(statearr_31528_31625[(1)] = (9));

} else {
var statearr_31529_31626 = state_31480__$1;
(statearr_31529_31626[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (28))){
var inst_31330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31331 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_31332 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_31331,optional_QMARK_);
var inst_31333 = [inst_31332,r];
var inst_31334 = (new cljs.core.PersistentVector(null,2,(5),inst_31330,inst_31333,null));
var state_31480__$1 = state_31480;
var statearr_31530_31627 = state_31480__$1;
(statearr_31530_31627[(2)] = inst_31334);

(statearr_31530_31627[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (64))){
var inst_31435 = (state_31480[(2)]);
var inst_31436 = fluree.db.util.async.throw_err.call(null,inst_31435);
var state_31480__$1 = state_31480;
var statearr_31531_31628 = state_31480__$1;
(statearr_31531_31628[(2)] = inst_31436);

(statearr_31531_31628[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (51))){
var inst_31402 = cljs.core.first.call(null,clause);
var inst_31403 = cljs.core.sequential_QMARK_.call(null,inst_31402);
var state_31480__$1 = state_31480;
if(inst_31403){
var statearr_31532_31629 = state_31480__$1;
(statearr_31532_31629[(1)] = (54));

} else {
var statearr_31533_31630 = state_31480__$1;
(statearr_31533_31630[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (25))){
var inst_31253 = (state_31480[(14)]);
var inst_31257 = (state_31480[(16)]);
var inst_31318 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_31319 = (function (){var segment_type = inst_31253;
var pred__31254 = inst_31257;
var expr__31255 = inst_31253;
var bindings = inst_31318;
return (function (p1__31239_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__31239_SHARP_);
});
})();
var inst_31320 = cljs.core.map.call(null,inst_31319,inst_31318);
var inst_31321 = cljs.core.PersistentHashMap.EMPTY;
var inst_31322 = cljs.core.into.call(null,inst_31321,inst_31320);
var inst_31323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31324 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_31322);
var inst_31325 = [inst_31324,r];
var inst_31326 = (new cljs.core.PersistentVector(null,2,(5),inst_31323,inst_31325,null));
var state_31480__$1 = state_31480;
var statearr_31534_31631 = state_31480__$1;
(statearr_31534_31631[(2)] = inst_31326);

(statearr_31534_31631[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (34))){
var inst_31357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31358 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_31359 = [inst_31358,r];
var inst_31360 = (new cljs.core.PersistentVector(null,2,(5),inst_31357,inst_31359,null));
var state_31480__$1 = state_31480;
var statearr_31535_31632 = state_31480__$1;
(statearr_31535_31632[(2)] = inst_31360);

(statearr_31535_31632[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (17))){
var inst_31314 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31536_31633 = state_31480__$1;
(statearr_31536_31633[(2)] = inst_31314);

(statearr_31536_31633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (3))){
var inst_31478 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31480__$1,inst_31478);
} else {
if((state_val_31481 === (12))){
var inst_31260 = (state_31480[(22)]);
var inst_31264 = (state_31480[(2)]);
var inst_31265 = fluree.db.util.async.throw_err.call(null,inst_31264);
var inst_31266 = [inst_31265,r];
var inst_31267 = (new cljs.core.PersistentVector(null,2,(5),inst_31260,inst_31266,null));
var state_31480__$1 = state_31480;
var statearr_31537_31634 = state_31480__$1;
(statearr_31537_31634[(2)] = inst_31267);

(statearr_31537_31634[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (2))){
var _ = (function (){var statearr_31538 = state_31480;
(statearr_31538[(4)] = cljs.core.cons.call(null,(5),(state_31480[(4)])));

return statearr_31538;
})();
var inst_31250 = cljs.core.map_QMARK_.call(null,clause);
var state_31480__$1 = state_31480;
if(inst_31250){
var statearr_31539_31635 = state_31480__$1;
(statearr_31539_31635[(1)] = (6));

} else {
var statearr_31540_31636 = state_31480__$1;
(statearr_31540_31636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (66))){
var state_31480__$1 = state_31480;
var statearr_31541_31637 = state_31480__$1;
(statearr_31541_31637[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (23))){
var inst_31299 = (state_31480[(19)]);
var inst_31290 = (state_31480[(17)]);
var inst_31282 = inst_31290;
var inst_31283 = inst_31299;
var state_31480__$1 = (function (){var statearr_31543 = state_31480;
(statearr_31543[(15)] = inst_31282);

(statearr_31543[(18)] = inst_31283);

return statearr_31543;
})();
var statearr_31544_31638 = state_31480__$1;
(statearr_31544_31638[(2)] = null);

(statearr_31544_31638[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (47))){
var inst_31382 = (state_31480[(21)]);
var inst_31385 = (state_31480[(2)]);
var inst_31386 = fluree.db.util.async.throw_err.call(null,inst_31385);
var inst_31387 = [inst_31386,r];
var inst_31388 = (new cljs.core.PersistentVector(null,2,(5),inst_31382,inst_31387,null));
var state_31480__$1 = state_31480;
var statearr_31545_31639 = state_31480__$1;
(statearr_31545_31639[(2)] = inst_31388);

(statearr_31545_31639[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (35))){
var inst_31363 = (state_31480[(23)]);
var inst_31362 = cljs.core.count.call(null,clause);
var inst_31363__$1 = cljs.core._EQ_.call(null,(3),inst_31362);
var state_31480__$1 = (function (){var statearr_31546 = state_31480;
(statearr_31546[(23)] = inst_31363__$1);

return statearr_31546;
})();
if(inst_31363__$1){
var statearr_31547_31640 = state_31480__$1;
(statearr_31547_31640[(1)] = (37));

} else {
var statearr_31548_31641 = state_31480__$1;
(statearr_31548_31641[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (19))){
var inst_31283 = (state_31480[(18)]);
var inst_31308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31309 = [inst_31283,r];
var inst_31310 = (new cljs.core.PersistentVector(null,2,(5),inst_31308,inst_31309,null));
var state_31480__$1 = state_31480;
var statearr_31549_31642 = state_31480__$1;
(statearr_31549_31642[(2)] = inst_31310);

(statearr_31549_31642[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (57))){
var inst_31425 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(60),inst_31425);
} else {
if((state_val_31481 === (68))){
var inst_31429 = (state_31480[(7)]);
var inst_31430 = (state_31480[(8)]);
var inst_31447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31448 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_31429,res,inst_31430,fuel,max_fuel);
var state_31480__$1 = (function (){var statearr_31550 = state_31480;
(statearr_31550[(24)] = inst_31447);

return statearr_31550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(71),inst_31448);
} else {
if((state_val_31481 === (11))){
var inst_31346 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31552_31643 = state_31480__$1;
(statearr_31552_31643[(2)] = inst_31346);

(statearr_31552_31643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (9))){
var inst_31260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31261 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_31262 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_31261,res,fuel,max_fuel,opts);
var state_31480__$1 = (function (){var statearr_31553 = state_31480;
(statearr_31553[(22)] = inst_31260);

return statearr_31553;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(12),inst_31262);
} else {
if((state_val_31481 === (5))){
var _ = (function (){var statearr_31554 = state_31480;
(statearr_31554[(4)] = cljs.core.rest.call(null,(state_31480[(4)])));

return statearr_31554;
})();
var state_31480__$1 = state_31480;
var ex31551 = (state_31480__$1[(2)]);
var statearr_31555_31644 = state_31480__$1;
(statearr_31555_31644[(5)] = ex31551);


if((ex31551 instanceof Error)){
var statearr_31556_31645 = state_31480__$1;
(statearr_31556_31645[(1)] = (4));

(statearr_31556_31645[(5)] = null);

} else {
throw ex31551;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (14))){
var inst_31253 = (state_31480[(14)]);
var inst_31257 = (state_31480[(16)]);
var inst_31316 = inst_31257.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_31253);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31316)){
var statearr_31557_31646 = state_31480__$1;
(statearr_31557_31646[(1)] = (25));

} else {
var statearr_31558_31647 = state_31480__$1;
(statearr_31558_31647[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (45))){
var inst_31390 = cljs.core.count.call(null,clause);
var inst_31391 = cljs.core._EQ_.call(null,(2),inst_31390);
var state_31480__$1 = state_31480;
if(inst_31391){
var statearr_31559_31648 = state_31480__$1;
(statearr_31559_31648[(1)] = (48));

} else {
var statearr_31560_31649 = state_31480__$1;
(statearr_31560_31649[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (53))){
var inst_31465 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31561_31650 = state_31480__$1;
(statearr_31561_31650[(2)] = inst_31465);

(statearr_31561_31650[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (26))){
var inst_31253 = (state_31480[(14)]);
var inst_31257 = (state_31480[(16)]);
var inst_31328 = inst_31257.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_31253);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31328)){
var statearr_31562_31651 = state_31480__$1;
(statearr_31562_31651[(1)] = (28));

} else {
var statearr_31563_31652 = state_31480__$1;
(statearr_31563_31652[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (16))){
var inst_31289 = (state_31480[(13)]);
var inst_31282 = (state_31480[(15)]);
var inst_31288 = cljs.core.seq.call(null,inst_31282);
var inst_31289__$1 = cljs.core.first.call(null,inst_31288);
var inst_31290 = cljs.core.next.call(null,inst_31288);
var state_31480__$1 = (function (){var statearr_31564 = state_31480;
(statearr_31564[(13)] = inst_31289__$1);

(statearr_31564[(17)] = inst_31290);

return statearr_31564;
})();
if(cljs.core.truth_(inst_31289__$1)){
var statearr_31565_31653 = state_31480__$1;
(statearr_31565_31653[(1)] = (18));

} else {
var statearr_31566_31654 = state_31480__$1;
(statearr_31566_31654[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (38))){
var inst_31363 = (state_31480[(23)]);
var state_31480__$1 = state_31480;
var statearr_31567_31655 = state_31480__$1;
(statearr_31567_31655[(2)] = inst_31363);

(statearr_31567_31655[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (30))){
var inst_31340 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31568_31656 = state_31480__$1;
(statearr_31568_31656[(2)] = inst_31340);

(statearr_31568_31656[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (10))){
var inst_31253 = (state_31480[(14)]);
var inst_31257 = (state_31480[(16)]);
var inst_31269 = inst_31257.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_31253);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31269)){
var statearr_31569_31657 = state_31480__$1;
(statearr_31569_31657[(1)] = (13));

} else {
var statearr_31570_31658 = state_31480__$1;
(statearr_31570_31658[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (18))){
var inst_31289 = (state_31480[(13)]);
var inst_31292 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_31289,q_map,vars,fuel,max_fuel,opts);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(21),inst_31292);
} else {
if((state_val_31481 === (52))){
var state_31480__$1 = state_31480;
var statearr_31571_31659 = state_31480__$1;
(statearr_31571_31659[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (67))){
var inst_31458 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31573_31660 = state_31480__$1;
(statearr_31573_31660[(2)] = inst_31458);

(statearr_31573_31660[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (71))){
var inst_31447 = (state_31480[(24)]);
var inst_31450 = (state_31480[(2)]);
var inst_31451 = fluree.db.util.async.throw_err.call(null,inst_31450);
var inst_31452 = [inst_31451,r];
var inst_31453 = (new cljs.core.PersistentVector(null,2,(5),inst_31447,inst_31452,null));
var state_31480__$1 = state_31480;
var statearr_31574_31661 = state_31480__$1;
(statearr_31574_31661[(2)] = inst_31453);

(statearr_31574_31661[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (42))){
var inst_31471 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31575_31662 = state_31480__$1;
(statearr_31575_31662[(2)] = inst_31471);

(statearr_31575_31662[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (37))){
var inst_31365 = cljs.core.second.call(null,clause);
var inst_31366 = cljs.core._EQ_.call(null,inst_31365,"rdf:type");
var state_31480__$1 = state_31480;
var statearr_31576_31663 = state_31480__$1;
(statearr_31576_31663[(2)] = inst_31366);

(statearr_31576_31663[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (63))){
var inst_31460 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31577_31664 = state_31480__$1;
(statearr_31577_31664[(2)] = inst_31460);

(statearr_31577_31664[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (8))){
var inst_31475 = (state_31480[(2)]);
var _ = (function (){var statearr_31578 = state_31480;
(statearr_31578[(4)] = cljs.core.rest.call(null,(state_31480[(4)])));

return statearr_31578;
})();
var state_31480__$1 = state_31480;
var statearr_31579_31665 = state_31480__$1;
(statearr_31579_31665[(2)] = inst_31475);

(statearr_31579_31665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (49))){
var inst_31399 = cljs.core.count.call(null,clause);
var inst_31400 = cljs.core._EQ_.call(null,(1),inst_31399);
var state_31480__$1 = state_31480;
if(inst_31400){
var statearr_31580_31666 = state_31480__$1;
(statearr_31580_31666[(1)] = (51));

} else {
var statearr_31581_31667 = state_31480__$1;
(statearr_31581_31667[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____0 = (function (){
var statearr_31582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31582[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__);

(statearr_31582[(1)] = (1));

return statearr_31582;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____1 = (function (state_31480){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_31480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e31583){var ex__10906__auto__ = e31583;
var statearr_31584_31668 = state_31480;
(statearr_31584_31668[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_31480[(4)]))){
var statearr_31585_31669 = state_31480;
(statearr_31585_31669[(1)] = cljs.core.first.call(null,(state_31480[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31670 = state_31480;
state_31480 = G__31670;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__ = function(state_31480){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____1.call(this,state_31480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_31586 = f__10977__auto__.call(null);
(statearr_31586[(6)] = c__10976__auto__);

return statearr_31586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__31672 = arguments.length;
switch (G__31672) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_31752){
var state_val_31753 = (state_31752[(1)]);
if((state_val_31753 === (7))){
var inst_31747 = (state_31752[(2)]);
var _ = (function (){var statearr_31754 = state_31752;
(statearr_31754[(4)] = cljs.core.rest.call(null,(state_31752[(4)])));

return statearr_31754;
})();
var state_31752__$1 = state_31752;
var statearr_31755_31803 = state_31752__$1;
(statearr_31755_31803[(2)] = inst_31747);

(statearr_31755_31803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (20))){
var inst_31712 = (state_31752[(7)]);
var inst_31724 = (state_31752[(2)]);
var inst_31694 = inst_31712;
var inst_31695 = inst_31724;
var state_31752__$1 = (function (){var statearr_31756 = state_31752;
(statearr_31756[(8)] = inst_31694);

(statearr_31756[(9)] = inst_31695);

return statearr_31756;
})();
var statearr_31757_31804 = state_31752__$1;
(statearr_31757_31804[(2)] = null);

(statearr_31757_31804[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (1))){
var state_31752__$1 = state_31752;
var statearr_31758_31805 = state_31752__$1;
(statearr_31758_31805[(2)] = null);

(statearr_31758_31805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (24))){
var inst_31712 = (state_31752[(7)]);
var inst_31695 = (state_31752[(9)]);
var inst_31711 = (state_31752[(10)]);
var inst_31732 = fluree.db.query.analytical.inner_join.call(null,inst_31695,inst_31711);
var inst_31694 = inst_31712;
var inst_31695__$1 = inst_31732;
var state_31752__$1 = (function (){var statearr_31759 = state_31752;
(statearr_31759[(8)] = inst_31694);

(statearr_31759[(9)] = inst_31695__$1);

return statearr_31759;
})();
var statearr_31760_31806 = state_31752__$1;
(statearr_31760_31806[(2)] = null);

(statearr_31760_31806[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (4))){
var inst_31673 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31762_31807 = state_31752__$1;
(statearr_31762_31807[(2)] = inst_31673);

(statearr_31762_31807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (15))){
var inst_31711 = (state_31752[(10)]);
var state_31752__$1 = state_31752;
if(cljs.core.truth_(inst_31711)){
var statearr_31763_31808 = state_31752__$1;
(statearr_31763_31808[(1)] = (18));

} else {
var statearr_31764_31809 = state_31752__$1;
(statearr_31764_31809[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (21))){
var inst_31712 = (state_31752[(7)]);
var inst_31695 = (state_31752[(9)]);
var tmp31761 = inst_31695;
var inst_31694 = inst_31712;
var inst_31695__$1 = tmp31761;
var state_31752__$1 = (function (){var statearr_31765 = state_31752;
(statearr_31765[(8)] = inst_31694);

(statearr_31765[(9)] = inst_31695__$1);

return statearr_31765;
})();
var statearr_31766_31810 = state_31752__$1;
(statearr_31766_31810[(2)] = null);

(statearr_31766_31810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (13))){
var inst_31695 = (state_31752[(9)]);
var inst_31718 = cljs.core.dissoc.call(null,inst_31695,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_31719 = cljs.core.empty_QMARK_.call(null,inst_31718);
var state_31752__$1 = state_31752;
if(inst_31719){
var statearr_31767_31811 = state_31752__$1;
(statearr_31767_31811[(1)] = (15));

} else {
var statearr_31768_31812 = state_31752__$1;
(statearr_31768_31812[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (22))){
var state_31752__$1 = state_31752;
var statearr_31769_31813 = state_31752__$1;
(statearr_31769_31813[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (6))){
var inst_31694 = (state_31752[(8)]);
var inst_31701 = (state_31752[(11)]);
var inst_31700 = cljs.core.seq.call(null,inst_31694);
var inst_31701__$1 = cljs.core.first.call(null,inst_31700);
var inst_31702 = cljs.core.next.call(null,inst_31700);
var state_31752__$1 = (function (){var statearr_31771 = state_31752;
(statearr_31771[(12)] = inst_31702);

(statearr_31771[(11)] = inst_31701__$1);

return statearr_31771;
})();
if(cljs.core.truth_(inst_31701__$1)){
var statearr_31772_31814 = state_31752__$1;
(statearr_31772_31814[(1)] = (8));

} else {
var statearr_31773_31815 = state_31752__$1;
(statearr_31773_31815[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (25))){
var state_31752__$1 = state_31752;
var statearr_31774_31816 = state_31752__$1;
(statearr_31774_31816[(2)] = null);

(statearr_31774_31816[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (17))){
var inst_31740 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31775_31817 = state_31752__$1;
(statearr_31775_31817[(2)] = inst_31740);

(statearr_31775_31817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (3))){
var inst_31750 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31752__$1,inst_31750);
} else {
if((state_val_31753 === (12))){
var inst_31712 = (state_31752[(7)]);
var inst_31711 = (state_31752[(10)]);
var inst_31694 = inst_31712;
var inst_31695 = inst_31711;
var state_31752__$1 = (function (){var statearr_31776 = state_31752;
(statearr_31776[(8)] = inst_31694);

(statearr_31776[(9)] = inst_31695);

return statearr_31776;
})();
var statearr_31777_31818 = state_31752__$1;
(statearr_31777_31818[(2)] = null);

(statearr_31777_31818[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (2))){
var _ = (function (){var statearr_31778 = state_31752;
(statearr_31778[(4)] = cljs.core.cons.call(null,(5),(state_31752[(4)])));

return statearr_31778;
})();
var inst_31686 = where;
var inst_31687 = cljs.core.seq.call(null,inst_31686);
var inst_31688 = cljs.core.first.call(null,inst_31687);
var inst_31689 = cljs.core.next.call(null,inst_31687);
var inst_31690 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31691 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_31692 = [inst_31691];
var inst_31693 = cljs.core.PersistentHashMap.fromArrays(inst_31690,inst_31692);
var inst_31694 = inst_31686;
var inst_31695 = inst_31693;
var state_31752__$1 = (function (){var statearr_31779 = state_31752;
(statearr_31779[(13)] = inst_31689);

(statearr_31779[(14)] = inst_31688);

(statearr_31779[(8)] = inst_31694);

(statearr_31779[(9)] = inst_31695);

return statearr_31779;
})();
var statearr_31780_31819 = state_31752__$1;
(statearr_31780_31819[(2)] = null);

(statearr_31780_31819[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (23))){
var inst_31738 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31781_31820 = state_31752__$1;
(statearr_31781_31820[(2)] = inst_31738);

(statearr_31781_31820[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (19))){
var inst_31695 = (state_31752[(9)]);
var state_31752__$1 = state_31752;
var statearr_31782_31821 = state_31752__$1;
(statearr_31782_31821[(2)] = inst_31695);

(statearr_31782_31821[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (11))){
var inst_31701 = (state_31752[(11)]);
var inst_31709 = (state_31752[(2)]);
var inst_31710 = fluree.db.util.async.throw_err.call(null,inst_31709);
var inst_31711 = cljs.core.nth.call(null,inst_31710,(0),null);
var inst_31712 = cljs.core.nth.call(null,inst_31710,(1),null);
var inst_31713 = cljs.core.count.call(null,inst_31701);
var inst_31714 = cljs.core._EQ_.call(null,(2),inst_31713);
var state_31752__$1 = (function (){var statearr_31784 = state_31752;
(statearr_31784[(7)] = inst_31712);

(statearr_31784[(10)] = inst_31711);

return statearr_31784;
})();
if(inst_31714){
var statearr_31785_31822 = state_31752__$1;
(statearr_31785_31822[(1)] = (12));

} else {
var statearr_31786_31823 = state_31752__$1;
(statearr_31786_31823[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (9))){
var inst_31695 = (state_31752[(9)]);
var state_31752__$1 = state_31752;
var statearr_31787_31824 = state_31752__$1;
(statearr_31787_31824[(2)] = inst_31695);

(statearr_31787_31824[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (5))){
var _ = (function (){var statearr_31788 = state_31752;
(statearr_31788[(4)] = cljs.core.rest.call(null,(state_31752[(4)])));

return statearr_31788;
})();
var state_31752__$1 = state_31752;
var ex31783 = (state_31752__$1[(2)]);
var statearr_31789_31825 = state_31752__$1;
(statearr_31789_31825[(5)] = ex31783);


if((ex31783 instanceof Error)){
var statearr_31790_31826 = state_31752__$1;
(statearr_31790_31826[(1)] = (4));

(statearr_31790_31826[(5)] = null);

} else {
throw ex31783;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (14))){
var inst_31742 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31791_31827 = state_31752__$1;
(statearr_31791_31827[(2)] = inst_31742);

(statearr_31791_31827[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (26))){
var inst_31736 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31792_31828 = state_31752__$1;
(statearr_31792_31828[(2)] = inst_31736);

(statearr_31792_31828[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (16))){
var inst_31711 = (state_31752[(10)]);
var inst_31727 = (inst_31711 == null);
var state_31752__$1 = state_31752;
if(cljs.core.truth_(inst_31727)){
var statearr_31793_31829 = state_31752__$1;
(statearr_31793_31829[(1)] = (21));

} else {
var statearr_31794_31830 = state_31752__$1;
(statearr_31794_31830[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (10))){
var inst_31745 = (state_31752[(2)]);
var state_31752__$1 = state_31752;
var statearr_31795_31831 = state_31752__$1;
(statearr_31795_31831[(2)] = inst_31745);

(statearr_31795_31831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (18))){
var inst_31711 = (state_31752[(10)]);
var state_31752__$1 = state_31752;
var statearr_31796_31832 = state_31752__$1;
(statearr_31796_31832[(2)] = inst_31711);

(statearr_31796_31832[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31753 === (8))){
var inst_31702 = (state_31752[(12)]);
var inst_31695 = (state_31752[(9)]);
var inst_31701 = (state_31752[(11)]);
var inst_31707 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_31695,inst_31701,inst_31702,false,fuel,max_fuel,opts);
var state_31752__$1 = state_31752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31752__$1,(11),inst_31707);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10903__auto__ = null;
var fluree$db$query$analytical$state_machine__10903__auto____0 = (function (){
var statearr_31797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31797[(0)] = fluree$db$query$analytical$state_machine__10903__auto__);

(statearr_31797[(1)] = (1));

return statearr_31797;
});
var fluree$db$query$analytical$state_machine__10903__auto____1 = (function (state_31752){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_31752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e31798){var ex__10906__auto__ = e31798;
var statearr_31799_31833 = state_31752;
(statearr_31799_31833[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_31752[(4)]))){
var statearr_31800_31834 = state_31752;
(statearr_31800_31834[(1)] = cljs.core.first.call(null,(state_31752[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31835 = state_31752;
state_31752 = G__31835;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10903__auto__ = function(state_31752){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10903__auto____1.call(this,state_31752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10903__auto____0;
fluree$db$query$analytical$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10903__auto____1;
return fluree$db$query$analytical$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_31801 = f__10977__auto__.call(null);
(statearr_31801[(6)] = c__10976__auto__);

return statearr_31801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_31870){
var state_val_31871 = (state_31870[(1)]);
if((state_val_31871 === (7))){
var inst_31852 = (state_31870[(7)]);
var inst_31847 = (state_31870[(8)]);
var inst_31854 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_31847,inst_31852,fuel,max_fuel,opts);
var state_31870__$1 = state_31870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31870__$1,(10),inst_31854);
} else {
if((state_val_31871 === (1))){
var state_31870__$1 = state_31870;
var statearr_31872_31897 = state_31870__$1;
(statearr_31872_31897[(2)] = null);

(statearr_31872_31897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (4))){
var inst_31836 = (state_31870[(2)]);
var state_31870__$1 = state_31870;
var statearr_31873_31898 = state_31870__$1;
(statearr_31873_31898[(2)] = inst_31836);

(statearr_31873_31898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (13))){
var inst_31865 = (state_31870[(2)]);
var _ = (function (){var statearr_31874 = state_31870;
(statearr_31874[(4)] = cljs.core.rest.call(null,(state_31870[(4)])));

return statearr_31874;
})();
var state_31870__$1 = state_31870;
var statearr_31875_31899 = state_31870__$1;
(statearr_31875_31899[(2)] = inst_31865);

(statearr_31875_31899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (6))){
var inst_31847 = (state_31870[(8)]);
var inst_31851 = (state_31870[(2)]);
var inst_31852 = fluree.db.util.async.throw_err.call(null,inst_31851);
var state_31870__$1 = (function (){var statearr_31876 = state_31870;
(statearr_31876[(7)] = inst_31852);

return statearr_31876;
})();
if(cljs.core.truth_(inst_31847)){
var statearr_31877_31900 = state_31870__$1;
(statearr_31877_31900[(1)] = (7));

} else {
var statearr_31878_31901 = state_31870__$1;
(statearr_31878_31901[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (3))){
var inst_31868 = (state_31870[(2)]);
var state_31870__$1 = state_31870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31870__$1,inst_31868);
} else {
if((state_val_31871 === (12))){
var inst_31860 = (state_31870[(9)]);
var state_31870__$1 = state_31870;
var statearr_31879_31902 = state_31870__$1;
(statearr_31879_31902[(2)] = inst_31860);

(statearr_31879_31902[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (2))){
var _ = (function (){var statearr_31880 = state_31870;
(statearr_31880[(4)] = cljs.core.cons.call(null,(5),(state_31870[(4)])));

return statearr_31880;
})();
var inst_31843 = q_map;
var inst_31844 = cljs.core.__destructure_map.call(null,inst_31843);
var inst_31845 = cljs.core.get.call(null,inst_31844,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_31846 = cljs.core.get.call(null,inst_31844,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_31847 = cljs.core.get.call(null,inst_31844,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_31848 = cljs.core.get.call(null,inst_31844,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_31849 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_31846,q_map,inst_31845,fuel,max_fuel,opts);
var state_31870__$1 = (function (){var statearr_31881 = state_31870;
(statearr_31881[(8)] = inst_31847);

(statearr_31881[(10)] = inst_31848);

return statearr_31881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31870__$1,(6),inst_31849);
} else {
if((state_val_31871 === (11))){
var inst_31860 = (state_31870[(9)]);
var inst_31848 = (state_31870[(10)]);
var inst_31862 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_31860,inst_31848,null);
var state_31870__$1 = state_31870;
var statearr_31883_31903 = state_31870__$1;
(statearr_31883_31903[(2)] = inst_31862);

(statearr_31883_31903[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (9))){
var inst_31848 = (state_31870[(10)]);
var inst_31860 = (state_31870[(2)]);
var state_31870__$1 = (function (){var statearr_31884 = state_31870;
(statearr_31884[(9)] = inst_31860);

return statearr_31884;
})();
if(cljs.core.truth_(inst_31848)){
var statearr_31885_31904 = state_31870__$1;
(statearr_31885_31904[(1)] = (11));

} else {
var statearr_31886_31905 = state_31870__$1;
(statearr_31886_31905[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (5))){
var _ = (function (){var statearr_31887 = state_31870;
(statearr_31887[(4)] = cljs.core.rest.call(null,(state_31870[(4)])));

return statearr_31887;
})();
var state_31870__$1 = state_31870;
var ex31882 = (state_31870__$1[(2)]);
var statearr_31888_31906 = state_31870__$1;
(statearr_31888_31906[(5)] = ex31882);


if((ex31882 instanceof Error)){
var statearr_31889_31907 = state_31870__$1;
(statearr_31889_31907[(1)] = (4));

(statearr_31889_31907[(5)] = null);

} else {
throw ex31882;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (10))){
var inst_31856 = (state_31870[(2)]);
var inst_31857 = fluree.db.util.async.throw_err.call(null,inst_31856);
var state_31870__$1 = state_31870;
var statearr_31890_31908 = state_31870__$1;
(statearr_31890_31908[(2)] = inst_31857);

(statearr_31890_31908[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31871 === (8))){
var inst_31852 = (state_31870[(7)]);
var state_31870__$1 = state_31870;
var statearr_31891_31909 = state_31870__$1;
(statearr_31891_31909[(2)] = inst_31852);

(statearr_31891_31909[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__10903__auto____0 = (function (){
var statearr_31892 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31892[(0)] = fluree$db$query$analytical$q_$_state_machine__10903__auto__);

(statearr_31892[(1)] = (1));

return statearr_31892;
});
var fluree$db$query$analytical$q_$_state_machine__10903__auto____1 = (function (state_31870){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_31870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e31893){var ex__10906__auto__ = e31893;
var statearr_31894_31910 = state_31870;
(statearr_31894_31910[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_31870[(4)]))){
var statearr_31895_31911 = state_31870;
(statearr_31895_31911[(1)] = cljs.core.first.call(null,(state_31870[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31912 = state_31870;
state_31870 = G__31912;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__10903__auto__ = function(state_31870){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__10903__auto____1.call(this,state_31870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__10903__auto____0;
fluree$db$query$analytical$q_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__10903__auto____1;
return fluree$db$query$analytical$q_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_31896 = f__10977__auto__.call(null);
(statearr_31896[(6)] = c__10976__auto__);

return statearr_31896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
