// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__23791 = match;
var p1 = cljs.core.nth.call(null,vec__23791,(0),null);
var p2 = cljs.core.nth.call(null,vec__23791,(1),null);
var p3 = cljs.core.nth.call(null,vec__23791,(2),null);
var t = cljs.core.nth.call(null,vec__23791,(3),null);
var op = cljs.core.nth.call(null,vec__23791,(4),null);
var m = cljs.core.nth.call(null,vec__23791,(5),null);
var G__23794 = idx;
var G__23794__$1 = (((G__23794 instanceof cljs.core.Keyword))?G__23794.fqn:null);
switch (G__23794__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23794__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__23796 = idx;
var G__23796__$1 = (((G__23796 instanceof cljs.core.Keyword))?G__23796.fqn:null);
switch (G__23796__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23796__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__23798 = idx;
var G__23798__$1 = (((G__23798 instanceof cljs.core.Keyword))?G__23798.fqn:null);
switch (G__23798__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23798__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__23801 = arguments.length;
switch (G__23801) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__23802 = (function (){var pred__23805 = cljs.core.identical_QMARK_;
var expr__23806 = test;
if(cljs.core.truth_(pred__23805.call(null,cljs.core._EQ_,expr__23806))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__23805.call(null,cljs.core._LT_,expr__23806))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__23805.call(null,cljs.core._LT__EQ_,expr__23806))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__23805.call(null,cljs.core._GT_,expr__23806))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__23805.call(null,cljs.core._GT__EQ_,expr__23806))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__23806)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__23802,(0),null);
var start_match = cljs.core.nth.call(null,vec__23802,(1),null);
var end_test = cljs.core.nth.call(null,vec__23802,(2),null);
var end_match = cljs.core.nth.call(null,vec__23802,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_24045){
var state_val_24046 = (state_24045[(1)]);
if((state_val_24046 === (65))){
var inst_23960 = (state_24045[(7)]);
var inst_24016 = (state_24045[(8)]);
var inst_24016__$1 = (state_24045[(2)]);
var inst_24017 = cljs.core.count.call(null,inst_24016__$1);
var state_24045__$1 = (function (){var statearr_24047 = state_24045;
(statearr_24047[(9)] = inst_24017);

(statearr_24047[(8)] = inst_24016__$1);

return statearr_24047;
})();
if(cljs.core.truth_(inst_23960)){
var statearr_24048_24185 = state_24045__$1;
(statearr_24048_24185[(1)] = (81));

} else {
var statearr_24049_24186 = state_24045__$1;
(statearr_24049_24186[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (70))){
var inst_23991 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_23991)){
var statearr_24050_24187 = state_24045__$1;
(statearr_24050_24187[(1)] = (71));

} else {
var statearr_24051_24188 = state_24045__$1;
(statearr_24051_24188[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (62))){
var inst_23930 = (state_24045[(10)]);
var inst_23944 = (state_24045[(11)]);
var inst_23959 = (state_24045[(2)]);
var inst_23960 = fluree.db.dbproto._rhs.call(null,inst_23944);
var state_24045__$1 = (function (){var statearr_24052 = state_24045;
(statearr_24052[(12)] = inst_23959);

(statearr_24052[(7)] = inst_23960);

return statearr_24052;
})();
if(cljs.core.truth_(inst_23930)){
var statearr_24053_24189 = state_24045__$1;
(statearr_24053_24189[(1)] = (63));

} else {
var statearr_24054_24190 = state_24045__$1;
(statearr_24054_24190[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (74))){
var inst_23984 = (state_24045[(13)]);
var inst_23998 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_23984);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(77),inst_23998);
} else {
if((state_val_24046 === (7))){
var inst_23821 = (state_24045[(14)]);
var state_24045__$1 = state_24045;
var statearr_24055_24191 = state_24045__$1;
(statearr_24055_24191[(2)] = inst_23821);

(statearr_24055_24191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (59))){
var inst_23907 = (state_24045[(15)]);
var inst_23906 = (state_24045[(16)]);
var inst_23951 = (state_24045[(17)]);
var inst_23950 = (state_24045[(2)]);
var inst_23951__$1 = fluree.db.util.async.throw_err.call(null,inst_23950);
var inst_23952 = fluree.db.flake.subrange.call(null,inst_23951__$1,start_test,inst_23906,end_test,inst_23907);
var inst_23953 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_23906,inst_23907);
var state_24045__$1 = (function (){var statearr_24056 = state_24045;
(statearr_24056[(18)] = inst_23952);

(statearr_24056[(17)] = inst_23951__$1);

return statearr_24056;
})();
if(inst_23953){
var statearr_24057_24192 = state_24045__$1;
(statearr_24057_24192[(1)] = (60));

} else {
var statearr_24058_24193 = state_24045__$1;
(statearr_24058_24193[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (86))){
var inst_24025 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24059_24194 = state_24045__$1;
(statearr_24059_24194[(2)] = inst_24025);

(statearr_24059_24194[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (20))){
var inst_23822 = (state_24045[(19)]);
var inst_23870 = (state_24045[(20)]);
var inst_23869 = (state_24045[(2)]);
var inst_23870__$1 = (inst_23822 == null);
var state_24045__$1 = (function (){var statearr_24060 = state_24045;
(statearr_24060[(21)] = inst_23869);

(statearr_24060[(20)] = inst_23870__$1);

return statearr_24060;
})();
if(cljs.core.truth_(inst_23870__$1)){
var statearr_24061_24195 = state_24045__$1;
(statearr_24061_24195[(1)] = (22));

} else {
var statearr_24062_24196 = state_24045__$1;
(statearr_24062_24196[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (72))){
var inst_23977 = (state_24045[(22)]);
var inst_23995 = (inst_23977 + (1));
var inst_23996 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24045__$1 = (function (){var statearr_24063 = state_24045;
(statearr_24063[(23)] = inst_23995);

return statearr_24063;
})();
if(cljs.core.truth_(inst_23996)){
var statearr_24064_24197 = state_24045__$1;
(statearr_24064_24197[(1)] = (74));

} else {
var statearr_24065_24198 = state_24045__$1;
(statearr_24065_24198[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (58))){
var inst_24040 = (state_24045[(2)]);
var _ = (function (){var statearr_24066 = state_24045;
(statearr_24066[(4)] = cljs.core.rest.call(null,(state_24045[(4)])));

return statearr_24066;
})();
var state_24045__$1 = state_24045;
var statearr_24067_24199 = state_24045__$1;
(statearr_24067_24199[(2)] = inst_24040);

(statearr_24067_24199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (60))){
var inst_23917 = (state_24045[(24)]);
var inst_23887 = (state_24045[(25)]);
var inst_23851 = (state_24045[(26)]);
var inst_23827 = (state_24045[(27)]);
var inst_23905 = (state_24045[(28)]);
var inst_23832 = (state_24045[(29)]);
var inst_23820 = (state_24045[(30)]);
var inst_23907 = (state_24045[(15)]);
var inst_23913 = (state_24045[(31)]);
var inst_23824 = (state_24045[(32)]);
var inst_23946 = (state_24045[(33)]);
var inst_23923 = (state_24045[(34)]);
var inst_23912 = (state_24045[(35)]);
var inst_23906 = (state_24045[(16)]);
var inst_23924 = (state_24045[(36)]);
var inst_23869 = (state_24045[(21)]);
var inst_23930 = (state_24045[(10)]);
var inst_23934 = (state_24045[(37)]);
var inst_23878 = (state_24045[(38)]);
var inst_23945 = (state_24045[(39)]);
var inst_23825 = (state_24045[(40)]);
var inst_23939 = (state_24045[(41)]);
var inst_23896 = (state_24045[(42)]);
var inst_23860 = (state_24045[(43)]);
var inst_23952 = (state_24045[(18)]);
var inst_23842 = (state_24045[(44)]);
var inst_23831 = (state_24045[(45)]);
var inst_23951 = (state_24045[(17)]);
var inst_23944 = (state_24045[(11)]);
var inst_23955 = (function (){var no_filter_QMARK_ = inst_23930;
var next_node = inst_23944;
var flakes = inst_23951;
var s1 = inst_23842;
var o2 = inst_23869;
var t1 = inst_23824;
var i = inst_23945;
var vec__23814 = inst_23820;
var m1 = inst_23896;
var root_node = inst_23939;
var to_t = inst_23924;
var s2 = inst_23851;
var vec__23817 = inst_23827;
var p2 = inst_23887;
var permissions = inst_23913;
var limit = inst_23912;
var start_flake = inst_23906;
var acc = inst_23946;
var t2 = inst_23831;
var op1 = inst_23825;
var o1 = inst_23860;
var end_flake = inst_23907;
var base_result = inst_23952;
var p1 = inst_23878;
var idx_compare = inst_23917;
var op2 = inst_23832;
var from_t = inst_23923;
var m2 = inst_23905;
var novelty = inst_23934;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_23956 = cljs.core.reduce.call(null,inst_23955,inst_23952,inst_23952);
var state_24045__$1 = state_24045;
var statearr_24068_24200 = state_24045__$1;
(statearr_24068_24200[(2)] = inst_23956);

(statearr_24068_24200[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (27))){
var inst_23829 = (state_24045[(46)]);
var inst_23879 = (state_24045[(47)]);
var inst_23878 = (state_24045[(2)]);
var inst_23879__$1 = (inst_23829 == null);
var state_24045__$1 = (function (){var statearr_24069 = state_24045;
(statearr_24069[(47)] = inst_23879__$1);

(statearr_24069[(38)] = inst_23878);

return statearr_24069;
})();
if(cljs.core.truth_(inst_23879__$1)){
var statearr_24070_24201 = state_24045__$1;
(statearr_24070_24201[(1)] = (28));

} else {
var statearr_24071_24202 = state_24045__$1;
(statearr_24071_24202[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (1))){
var state_24045__$1 = state_24045;
var statearr_24072_24203 = state_24045__$1;
(statearr_24072_24203[(2)] = null);

(statearr_24072_24203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (69))){
var inst_23912 = (state_24045[(35)]);
var inst_23977 = (state_24045[(22)]);
var inst_23989 = (inst_23977 > inst_23912);
var state_24045__$1 = state_24045;
var statearr_24073_24204 = state_24045__$1;
(statearr_24073_24204[(2)] = inst_23989);

(statearr_24073_24204[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (24))){
var inst_23874 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_23874)){
var statearr_24074_24205 = state_24045__$1;
(statearr_24074_24205[(1)] = (25));

} else {
var statearr_24075_24206 = state_24045__$1;
(statearr_24075_24206[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (55))){
var inst_23906 = (state_24045[(16)]);
var inst_23939 = (state_24045[(41)]);
var inst_23938 = (state_24045[(2)]);
var inst_23939__$1 = fluree.db.util.async.throw_err.call(null,inst_23938);
var inst_23940 = fluree.db.dbproto._lookup_leaf.call(null,inst_23939__$1,inst_23906);
var state_24045__$1 = (function (){var statearr_24076 = state_24045;
(statearr_24076[(41)] = inst_23939__$1);

return statearr_24076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(56),inst_23940);
} else {
if((state_val_24046 === (85))){
var inst_24020 = (state_24045[(48)]);
var state_24045__$1 = state_24045;
var statearr_24077_24207 = state_24045__$1;
(statearr_24077_24207[(2)] = inst_24020);

(statearr_24077_24207[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (39))){
var inst_23894 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24078_24208 = state_24045__$1;
(statearr_24078_24208[(2)] = inst_23894);

(statearr_24078_24208[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (88))){
var inst_23960 = (state_24045[(7)]);
var inst_23939 = (state_24045[(41)]);
var inst_24032 = fluree.db.dbproto._lookup_leaf.call(null,inst_23939,inst_23960);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(90),inst_24032);
} else {
if((state_val_24046 === (46))){
var inst_23908 = (state_24045[(49)]);
var state_24045__$1 = state_24045;
var statearr_24079_24209 = state_24045__$1;
(statearr_24079_24209[(2)] = inst_23908);

(statearr_24079_24209[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (4))){
var inst_23808 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24080_24210 = state_24045__$1;
(statearr_24080_24210[(2)] = inst_23808);

(statearr_24080_24210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (77))){
var inst_24000 = (state_24045[(2)]);
var inst_24001 = fluree.db.util.async.throw_err.call(null,inst_24000);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_24001)){
var statearr_24081_24211 = state_24045__$1;
(statearr_24081_24211[(1)] = (78));

} else {
var statearr_24082_24212 = state_24045__$1;
(statearr_24082_24212[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (54))){
var inst_23930 = (state_24045[(2)]);
var inst_23931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23932 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_23933 = (new cljs.core.PersistentVector(null,2,(5),inst_23931,inst_23932,null));
var inst_23934 = cljs.core.get_in.call(null,db,inst_23933);
var inst_23935 = cljs.core.get.call(null,db,idx);
var inst_23936 = fluree.db.dbproto._resolve.call(null,inst_23935);
var state_24045__$1 = (function (){var statearr_24083 = state_24045;
(statearr_24083[(10)] = inst_23930);

(statearr_24083[(37)] = inst_23934);

return statearr_24083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(55),inst_23936);
} else {
if((state_val_24046 === (15))){
var inst_23823 = (state_24045[(50)]);
var state_24045__$1 = state_24045;
var statearr_24084_24213 = state_24045__$1;
(statearr_24084_24213[(2)] = inst_23823);

(statearr_24084_24213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (48))){
var inst_23918 = (state_24045[(51)]);
var inst_23912 = (state_24045[(2)]);
var inst_23913 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_23914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23915 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_23916 = (new cljs.core.PersistentVector(null,3,(5),inst_23914,inst_23915,null));
var inst_23917 = cljs.core.get_in.call(null,db,inst_23916);
var inst_23918__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_24045__$1 = (function (){var statearr_24085 = state_24045;
(statearr_24085[(24)] = inst_23917);

(statearr_24085[(31)] = inst_23913);

(statearr_24085[(35)] = inst_23912);

(statearr_24085[(51)] = inst_23918__$1);

return statearr_24085;
})();
if(cljs.core.truth_(inst_23918__$1)){
var statearr_24086_24214 = state_24045__$1;
(statearr_24086_24214[(1)] = (49));

} else {
var statearr_24087_24215 = state_24045__$1;
(statearr_24087_24215[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (50))){
var inst_23921 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_24045__$1 = state_24045;
var statearr_24088_24216 = state_24045__$1;
(statearr_24088_24216[(2)] = inst_23921);

(statearr_24088_24216[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (75))){
var inst_23978 = (state_24045[(52)]);
var state_24045__$1 = state_24045;
var statearr_24089_24217 = state_24045__$1;
(statearr_24089_24217[(2)] = inst_23978);

(statearr_24089_24217[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (21))){
var inst_23865 = (state_24045[(2)]);
var inst_23866 = fluree.db.util.async.throw_err.call(null,inst_23865);
var state_24045__$1 = state_24045;
var statearr_24090_24218 = state_24045__$1;
(statearr_24090_24218[(2)] = inst_23866);

(statearr_24090_24218[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (31))){
var state_24045__$1 = state_24045;
var statearr_24091_24219 = state_24045__$1;
(statearr_24091_24219[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_24091_24219[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (32))){
var inst_23829 = (state_24045[(46)]);
var state_24045__$1 = state_24045;
var statearr_24092_24220 = state_24045__$1;
(statearr_24092_24220[(2)] = inst_23829);

(statearr_24092_24220[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (40))){
var inst_23833 = (state_24045[(53)]);
var state_24045__$1 = state_24045;
var statearr_24093_24221 = state_24045__$1;
(statearr_24093_24221[(2)] = inst_23833);

(statearr_24093_24221[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (56))){
var inst_23942 = (state_24045[(2)]);
var inst_23943 = fluree.db.util.async.throw_err.call(null,inst_23942);
var inst_23944 = inst_23943;
var inst_23945 = (0);
var inst_23946 = null;
var state_24045__$1 = (function (){var statearr_24094 = state_24045;
(statearr_24094[(33)] = inst_23946);

(statearr_24094[(39)] = inst_23945);

(statearr_24094[(11)] = inst_23944);

return statearr_24094;
})();
var statearr_24095_24222 = state_24045__$1;
(statearr_24095_24222[(2)] = null);

(statearr_24095_24222[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (33))){
var inst_23826 = (state_24045[(54)]);
var inst_23887 = (state_24045[(2)]);
var state_24045__$1 = (function (){var statearr_24096 = state_24045;
(statearr_24096[(25)] = inst_23887);

return statearr_24096;
})();
if(cljs.core.truth_(inst_23826)){
var statearr_24097_24223 = state_24045__$1;
(statearr_24097_24223[(1)] = (34));

} else {
var statearr_24098_24224 = state_24045__$1;
(statearr_24098_24224[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (13))){
var inst_23847 = (state_24045[(2)]);
var inst_23848 = fluree.db.util.async.throw_err.call(null,inst_23847);
var state_24045__$1 = state_24045;
var statearr_24099_24225 = state_24045__$1;
(statearr_24099_24225[(2)] = inst_23848);

(statearr_24099_24225[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (22))){
var inst_23860 = (state_24045[(43)]);
var state_24045__$1 = state_24045;
var statearr_24100_24226 = state_24045__$1;
(statearr_24100_24226[(2)] = inst_23860);

(statearr_24100_24226[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (90))){
var inst_24017 = (state_24045[(9)]);
var inst_24016 = (state_24045[(8)]);
var inst_24034 = (state_24045[(2)]);
var inst_24035 = fluree.db.util.async.throw_err.call(null,inst_24034);
var inst_23944 = inst_24035;
var inst_23945 = inst_24017;
var inst_23946 = inst_24016;
var state_24045__$1 = (function (){var statearr_24101 = state_24045;
(statearr_24101[(33)] = inst_23946);

(statearr_24101[(39)] = inst_23945);

(statearr_24101[(11)] = inst_23944);

return statearr_24101;
})();
var statearr_24102_24227 = state_24045__$1;
(statearr_24102_24227[(2)] = null);

(statearr_24102_24227[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (36))){
var inst_23833 = (state_24045[(53)]);
var inst_23896 = (state_24045[(2)]);
var state_24045__$1 = (function (){var statearr_24103 = state_24045;
(statearr_24103[(42)] = inst_23896);

return statearr_24103;
})();
if(cljs.core.truth_(inst_23833)){
var statearr_24104_24228 = state_24045__$1;
(statearr_24104_24228[(1)] = (40));

} else {
var statearr_24105_24229 = state_24045__$1;
(statearr_24105_24229[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (41))){
var inst_23899 = (cljs.core._LT__EQ_ === end_test);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_23899)){
var statearr_24106_24230 = state_24045__$1;
(statearr_24106_24230[(1)] = (43));

} else {
var statearr_24107_24231 = state_24045__$1;
(statearr_24107_24231[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (89))){
var inst_24038 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24108_24232 = state_24045__$1;
(statearr_24108_24232[(2)] = inst_24038);

(statearr_24108_24232[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (43))){
var state_24045__$1 = state_24045;
var statearr_24109_24233 = state_24045__$1;
(statearr_24109_24233[(2)] = (2147483647));

(statearr_24109_24233[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (61))){
var inst_23952 = (state_24045[(18)]);
var state_24045__$1 = state_24045;
var statearr_24110_24234 = state_24045__$1;
(statearr_24110_24234[(2)] = inst_23952);

(statearr_24110_24234[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (29))){
var inst_23879 = (state_24045[(47)]);
var state_24045__$1 = state_24045;
var statearr_24111_24235 = state_24045__$1;
(statearr_24111_24235[(2)] = inst_23879);

(statearr_24111_24235[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (44))){
var state_24045__$1 = state_24045;
var statearr_24112_24236 = state_24045__$1;
(statearr_24112_24236[(2)] = fluree.db.util.core.min_integer);

(statearr_24112_24236[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (6))){
var inst_23821 = (state_24045[(14)]);
var inst_23836 = fluree.db.dbproto._subid.call(null,db,inst_23821);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(9),inst_23836);
} else {
if((state_val_24046 === (28))){
var inst_23869 = (state_24045[(21)]);
var state_24045__$1 = state_24045;
var statearr_24113_24237 = state_24045__$1;
(statearr_24113_24237[(2)] = inst_23869);

(statearr_24113_24237[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (64))){
var inst_23959 = (state_24045[(12)]);
var inst_23945 = (state_24045[(39)]);
var inst_23973 = cljs.core.seq.call(null,inst_23959);
var inst_23974 = cljs.core.first.call(null,inst_23973);
var inst_23975 = cljs.core.next.call(null,inst_23973);
var inst_23976 = inst_23959;
var inst_23977 = inst_23945;
var inst_23978 = inst_23959;
var state_24045__$1 = (function (){var statearr_24114 = state_24045;
(statearr_24114[(55)] = inst_23975);

(statearr_24114[(56)] = inst_23974);

(statearr_24114[(22)] = inst_23977);

(statearr_24114[(57)] = inst_23976);

(statearr_24114[(52)] = inst_23978);

return statearr_24114;
})();
var statearr_24115_24238 = state_24045__$1;
(statearr_24115_24238[(2)] = null);

(statearr_24115_24238[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (51))){
var inst_23923 = (state_24045[(2)]);
var inst_23924 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_23925 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24045__$1 = (function (){var statearr_24116 = state_24045;
(statearr_24116[(34)] = inst_23923);

(statearr_24116[(36)] = inst_23924);

return statearr_24116;
})();
if(cljs.core.truth_(inst_23925)){
var statearr_24117_24239 = state_24045__$1;
(statearr_24117_24239[(1)] = (52));

} else {
var statearr_24118_24240 = state_24045__$1;
(statearr_24118_24240[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (25))){
var state_24045__$1 = state_24045;
var statearr_24119_24241 = state_24045__$1;
(statearr_24119_24241[(2)] = (-1));

(statearr_24119_24241[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (34))){
var inst_23826 = (state_24045[(54)]);
var state_24045__$1 = state_24045;
var statearr_24120_24242 = state_24045__$1;
(statearr_24120_24242[(2)] = inst_23826);

(statearr_24120_24242[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (17))){
var inst_23856 = (state_24045[(2)]);
var inst_23857 = fluree.db.util.async.throw_err.call(null,inst_23856);
var state_24045__$1 = state_24045;
var statearr_24121_24243 = state_24045__$1;
(statearr_24121_24243[(2)] = inst_23857);

(statearr_24121_24243[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (3))){
var inst_24043 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24045__$1,inst_24043);
} else {
if((state_val_24046 === (12))){
var inst_23823 = (state_24045[(50)]);
var inst_23851 = (state_24045[(2)]);
var inst_23852 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23823);
var state_24045__$1 = (function (){var statearr_24122 = state_24045;
(statearr_24122[(26)] = inst_23851);

return statearr_24122;
})();
if(inst_23852){
var statearr_24123_24244 = state_24045__$1;
(statearr_24123_24244[(1)] = (14));

} else {
var statearr_24124_24245 = state_24045__$1;
(statearr_24124_24245[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (2))){
var inst_23827 = (state_24045[(27)]);
var inst_23820 = (state_24045[(30)]);
var inst_23821 = (state_24045[(14)]);
var _ = (function (){var statearr_24125 = state_24045;
(statearr_24125[(4)] = cljs.core.cons.call(null,(5),(state_24045[(4)])));

return statearr_24125;
})();
var inst_23820__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_23821__$1 = cljs.core.nth.call(null,inst_23820__$1,(0),null);
var inst_23822 = cljs.core.nth.call(null,inst_23820__$1,(1),null);
var inst_23823 = cljs.core.nth.call(null,inst_23820__$1,(2),null);
var inst_23824 = cljs.core.nth.call(null,inst_23820__$1,(3),null);
var inst_23825 = cljs.core.nth.call(null,inst_23820__$1,(4),null);
var inst_23826 = cljs.core.nth.call(null,inst_23820__$1,(5),null);
var inst_23827__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_23828 = cljs.core.nth.call(null,inst_23827__$1,(0),null);
var inst_23829 = cljs.core.nth.call(null,inst_23827__$1,(1),null);
var inst_23830 = cljs.core.nth.call(null,inst_23827__$1,(2),null);
var inst_23831 = cljs.core.nth.call(null,inst_23827__$1,(3),null);
var inst_23832 = cljs.core.nth.call(null,inst_23827__$1,(4),null);
var inst_23833 = cljs.core.nth.call(null,inst_23827__$1,(5),null);
var inst_23834 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23821__$1);
var state_24045__$1 = (function (){var statearr_24126 = state_24045;
(statearr_24126[(27)] = inst_23827__$1);

(statearr_24126[(29)] = inst_23832);

(statearr_24126[(30)] = inst_23820__$1);

(statearr_24126[(32)] = inst_23824);

(statearr_24126[(19)] = inst_23822);

(statearr_24126[(53)] = inst_23833);

(statearr_24126[(46)] = inst_23829);

(statearr_24126[(40)] = inst_23825);

(statearr_24126[(54)] = inst_23826);

(statearr_24126[(58)] = inst_23830);

(statearr_24126[(59)] = inst_23828);

(statearr_24126[(14)] = inst_23821__$1);

(statearr_24126[(45)] = inst_23831);

(statearr_24126[(50)] = inst_23823);

return statearr_24126;
})();
if(inst_23834){
var statearr_24127_24246 = state_24045__$1;
(statearr_24127_24246[(1)] = (6));

} else {
var statearr_24128_24247 = state_24045__$1;
(statearr_24128_24247[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (66))){
var inst_23986 = (state_24045[(60)]);
var inst_23984 = (state_24045[(13)]);
var inst_23976 = (state_24045[(57)]);
var inst_23983 = cljs.core.seq.call(null,inst_23976);
var inst_23984__$1 = cljs.core.first.call(null,inst_23983);
var inst_23985 = cljs.core.next.call(null,inst_23983);
var inst_23986__$1 = (inst_23984__$1 == null);
var state_24045__$1 = (function (){var statearr_24129 = state_24045;
(statearr_24129[(60)] = inst_23986__$1);

(statearr_24129[(13)] = inst_23984__$1);

(statearr_24129[(61)] = inst_23985);

return statearr_24129;
})();
if(cljs.core.truth_(inst_23986__$1)){
var statearr_24130_24248 = state_24045__$1;
(statearr_24130_24248[(1)] = (68));

} else {
var statearr_24131_24249 = state_24045__$1;
(statearr_24131_24249[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (23))){
var inst_23870 = (state_24045[(20)]);
var state_24045__$1 = state_24045;
var statearr_24132_24250 = state_24045__$1;
(statearr_24132_24250[(2)] = inst_23870);

(statearr_24132_24250[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (47))){
var state_24045__$1 = state_24045;
var statearr_24133_24251 = state_24045__$1;
(statearr_24133_24251[(2)] = fluree.db.util.core.max_long);

(statearr_24133_24251[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (35))){
var inst_23890 = (cljs.core._GT__EQ_ === start_test);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_23890)){
var statearr_24134_24252 = state_24045__$1;
(statearr_24134_24252[(1)] = (37));

} else {
var statearr_24135_24253 = state_24045__$1;
(statearr_24135_24253[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (82))){
var inst_23960 = (state_24045[(7)]);
var state_24045__$1 = state_24045;
var statearr_24136_24254 = state_24045__$1;
(statearr_24136_24254[(2)] = inst_23960);

(statearr_24136_24254[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (76))){
var inst_23985 = (state_24045[(61)]);
var inst_23995 = (state_24045[(23)]);
var inst_24009 = (state_24045[(2)]);
var inst_23976 = inst_23985;
var inst_23977 = inst_23995;
var inst_23978 = inst_24009;
var state_24045__$1 = (function (){var statearr_24137 = state_24045;
(statearr_24137[(22)] = inst_23977);

(statearr_24137[(57)] = inst_23976);

(statearr_24137[(52)] = inst_23978);

return statearr_24137;
})();
var statearr_24138_24255 = state_24045__$1;
(statearr_24138_24255[(2)] = null);

(statearr_24138_24255[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (19))){
var inst_23830 = (state_24045[(58)]);
var state_24045__$1 = state_24045;
var statearr_24139_24256 = state_24045__$1;
(statearr_24139_24256[(2)] = inst_23830);

(statearr_24139_24256[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (57))){
var inst_23923 = (state_24045[(34)]);
var inst_23924 = (state_24045[(36)]);
var inst_23934 = (state_24045[(37)]);
var inst_23944 = (state_24045[(11)]);
var inst_23948 = fluree.db.dbproto._resolve_history_range.call(null,inst_23944,inst_23923,inst_23924,inst_23934);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(59),inst_23948);
} else {
if((state_val_24046 === (68))){
var inst_23986 = (state_24045[(60)]);
var state_24045__$1 = state_24045;
var statearr_24140_24257 = state_24045__$1;
(statearr_24140_24257[(2)] = inst_23986);

(statearr_24140_24257[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (11))){
var inst_23828 = (state_24045[(59)]);
var state_24045__$1 = state_24045;
var statearr_24142_24258 = state_24045__$1;
(statearr_24142_24258[(2)] = inst_23828);

(statearr_24142_24258[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (9))){
var inst_23838 = (state_24045[(2)]);
var inst_23839 = fluree.db.util.async.throw_err.call(null,inst_23838);
var state_24045__$1 = state_24045;
var statearr_24143_24259 = state_24045__$1;
(statearr_24143_24259[(2)] = inst_23839);

(statearr_24143_24259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (5))){
var _ = (function (){var statearr_24144 = state_24045;
(statearr_24144[(4)] = cljs.core.rest.call(null,(state_24045[(4)])));

return statearr_24144;
})();
var state_24045__$1 = state_24045;
var ex24141 = (state_24045__$1[(2)]);
var statearr_24145_24260 = state_24045__$1;
(statearr_24145_24260[(5)] = ex24141);


if((ex24141 instanceof Error)){
var statearr_24146_24261 = state_24045__$1;
(statearr_24146_24261[(1)] = (4));

(statearr_24146_24261[(5)] = null);

} else {
throw ex24141;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (83))){
var inst_24028 = (state_24045[(2)]);
var inst_24029 = cljs.core.not.call(null,inst_24028);
var state_24045__$1 = state_24045;
if(inst_24029){
var statearr_24147_24262 = state_24045__$1;
(statearr_24147_24262[(1)] = (87));

} else {
var statearr_24148_24263 = state_24045__$1;
(statearr_24148_24263[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (14))){
var inst_23823 = (state_24045[(50)]);
var inst_23854 = fluree.db.dbproto._subid.call(null,db,inst_23823);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(17),inst_23854);
} else {
if((state_val_24046 === (45))){
var inst_23903 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24149_24264 = state_24045__$1;
(statearr_24149_24264[(2)] = inst_23903);

(statearr_24149_24264[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (53))){
var state_24045__$1 = state_24045;
var statearr_24150_24265 = state_24045__$1;
(statearr_24150_24265[(2)] = true);

(statearr_24150_24265[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (78))){
var inst_23978 = (state_24045[(52)]);
var state_24045__$1 = state_24045;
var statearr_24151_24266 = state_24045__$1;
(statearr_24151_24266[(2)] = inst_23978);

(statearr_24151_24266[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (26))){
var inst_23822 = (state_24045[(19)]);
var state_24045__$1 = state_24045;
var statearr_24152_24267 = state_24045__$1;
(statearr_24152_24267[(2)] = inst_23822);

(statearr_24152_24267[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (16))){
var inst_23830 = (state_24045[(58)]);
var inst_23860 = (state_24045[(2)]);
var inst_23861 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23830);
var state_24045__$1 = (function (){var statearr_24153 = state_24045;
(statearr_24153[(43)] = inst_23860);

return statearr_24153;
})();
if(inst_23861){
var statearr_24154_24268 = state_24045__$1;
(statearr_24154_24268[(1)] = (18));

} else {
var statearr_24155_24269 = state_24045__$1;
(statearr_24155_24269[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (81))){
var inst_23917 = (state_24045[(24)]);
var inst_23907 = (state_24045[(15)]);
var inst_23960 = (state_24045[(7)]);
var inst_24020 = (state_24045[(48)]);
var inst_24019 = inst_23917.call(null,inst_23960,inst_23907);
var inst_24020__$1 = (inst_24019 < (0));
var state_24045__$1 = (function (){var statearr_24156 = state_24045;
(statearr_24156[(48)] = inst_24020__$1);

return statearr_24156;
})();
if(cljs.core.truth_(inst_24020__$1)){
var statearr_24157_24270 = state_24045__$1;
(statearr_24157_24270[(1)] = (84));

} else {
var statearr_24158_24271 = state_24045__$1;
(statearr_24158_24271[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (79))){
var inst_23984 = (state_24045[(13)]);
var inst_23978 = (state_24045[(52)]);
var inst_24004 = cljs.core.disj.call(null,inst_23978,inst_23984);
var state_24045__$1 = state_24045;
var statearr_24159_24272 = state_24045__$1;
(statearr_24159_24272[(2)] = inst_24004);

(statearr_24159_24272[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (38))){
var state_24045__$1 = state_24045;
var statearr_24160_24273 = state_24045__$1;
(statearr_24160_24273[(2)] = (2147483647));

(statearr_24160_24273[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (87))){
var inst_24016 = (state_24045[(8)]);
var state_24045__$1 = state_24045;
var statearr_24161_24274 = state_24045__$1;
(statearr_24161_24274[(2)] = inst_24016);

(statearr_24161_24274[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (30))){
var inst_23883 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
if(cljs.core.truth_(inst_23883)){
var statearr_24162_24275 = state_24045__$1;
(statearr_24162_24275[(1)] = (31));

} else {
var statearr_24163_24276 = state_24045__$1;
(statearr_24163_24276[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (73))){
var inst_24012 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24164_24277 = state_24045__$1;
(statearr_24164_24277[(2)] = inst_24012);

(statearr_24164_24277[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (10))){
var inst_23828 = (state_24045[(59)]);
var inst_23845 = fluree.db.dbproto._subid.call(null,db,inst_23828);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(13),inst_23845);
} else {
if((state_val_24046 === (18))){
var inst_23830 = (state_24045[(58)]);
var inst_23863 = fluree.db.dbproto._subid.call(null,db,inst_23830);
var state_24045__$1 = state_24045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24045__$1,(21),inst_23863);
} else {
if((state_val_24046 === (52))){
var inst_23887 = (state_24045[(25)]);
var inst_23851 = (state_24045[(26)]);
var inst_23913 = (state_24045[(31)]);
var inst_23878 = (state_24045[(38)]);
var inst_23842 = (state_24045[(44)]);
var inst_23927 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_23913,inst_23842,inst_23851,inst_23878,inst_23887);
var state_24045__$1 = state_24045;
var statearr_24165_24278 = state_24045__$1;
(statearr_24165_24278[(2)] = inst_23927);

(statearr_24165_24278[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (67))){
var inst_24014 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24166_24279 = state_24045__$1;
(statearr_24166_24279[(2)] = inst_24014);

(statearr_24166_24279[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (71))){
var inst_23946 = (state_24045[(33)]);
var inst_23978 = (state_24045[(52)]);
var inst_23993 = cljs.core.into.call(null,inst_23978,inst_23946);
var state_24045__$1 = state_24045;
var statearr_24167_24280 = state_24045__$1;
(statearr_24167_24280[(2)] = inst_23993);

(statearr_24167_24280[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (42))){
var inst_23887 = (state_24045[(25)]);
var inst_23851 = (state_24045[(26)]);
var inst_23905 = (state_24045[(28)]);
var inst_23832 = (state_24045[(29)]);
var inst_23824 = (state_24045[(32)]);
var inst_23869 = (state_24045[(21)]);
var inst_23878 = (state_24045[(38)]);
var inst_23825 = (state_24045[(40)]);
var inst_23896 = (state_24045[(42)]);
var inst_23860 = (state_24045[(43)]);
var inst_23908 = (state_24045[(49)]);
var inst_23842 = (state_24045[(44)]);
var inst_23831 = (state_24045[(45)]);
var inst_23905__$1 = (state_24045[(2)]);
var inst_23906 = fluree.db.flake.__GT_Flake.call(null,inst_23842,inst_23878,inst_23860,inst_23824,inst_23825,inst_23896);
var inst_23907 = fluree.db.flake.__GT_Flake.call(null,inst_23851,inst_23887,inst_23869,inst_23831,inst_23832,inst_23905__$1);
var inst_23908__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_24045__$1 = (function (){var statearr_24168 = state_24045;
(statearr_24168[(28)] = inst_23905__$1);

(statearr_24168[(15)] = inst_23907);

(statearr_24168[(16)] = inst_23906);

(statearr_24168[(49)] = inst_23908__$1);

return statearr_24168;
})();
if(cljs.core.truth_(inst_23908__$1)){
var statearr_24169_24281 = state_24045__$1;
(statearr_24169_24281[(1)] = (46));

} else {
var statearr_24170_24282 = state_24045__$1;
(statearr_24170_24282[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (80))){
var inst_24006 = (state_24045[(2)]);
var state_24045__$1 = state_24045;
var statearr_24171_24283 = state_24045__$1;
(statearr_24171_24283[(2)] = inst_24006);

(statearr_24171_24283[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (37))){
var state_24045__$1 = state_24045;
var statearr_24172_24284 = state_24045__$1;
(statearr_24172_24284[(2)] = fluree.db.util.core.min_integer);

(statearr_24172_24284[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (63))){
var inst_23959 = (state_24045[(12)]);
var inst_23946 = (state_24045[(33)]);
var inst_23912 = (state_24045[(35)]);
var inst_23945 = (state_24045[(39)]);
var inst_23962 = (inst_23912 - inst_23945);
var inst_23963 = fluree.db.flake.take.call(null,inst_23962,inst_23959);
var inst_23964 = cljs.core.into.call(null,inst_23963,inst_23946);
var state_24045__$1 = state_24045;
var statearr_24173_24285 = state_24045__$1;
(statearr_24173_24285[(2)] = inst_23964);

(statearr_24173_24285[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (8))){
var inst_23828 = (state_24045[(59)]);
var inst_23842 = (state_24045[(2)]);
var inst_23843 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23828);
var state_24045__$1 = (function (){var statearr_24174 = state_24045;
(statearr_24174[(44)] = inst_23842);

return statearr_24174;
})();
if(inst_23843){
var statearr_24175_24286 = state_24045__$1;
(statearr_24175_24286[(1)] = (10));

} else {
var statearr_24176_24287 = state_24045__$1;
(statearr_24176_24287[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (49))){
var inst_23918 = (state_24045[(51)]);
var state_24045__$1 = state_24045;
var statearr_24177_24288 = state_24045__$1;
(statearr_24177_24288[(2)] = inst_23918);

(statearr_24177_24288[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24046 === (84))){
var inst_24017 = (state_24045[(9)]);
var inst_23912 = (state_24045[(35)]);
var inst_24022 = (inst_24017 < inst_23912);
var state_24045__$1 = state_24045;
var statearr_24178_24289 = state_24045__$1;
(statearr_24178_24289[(2)] = inst_24022);

(statearr_24178_24289[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10903__auto__ = null;
var fluree$db$query$range$state_machine__10903__auto____0 = (function (){
var statearr_24179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24179[(0)] = fluree$db$query$range$state_machine__10903__auto__);

(statearr_24179[(1)] = (1));

return statearr_24179;
});
var fluree$db$query$range$state_machine__10903__auto____1 = (function (state_24045){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_24045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e24180){var ex__10906__auto__ = e24180;
var statearr_24181_24290 = state_24045;
(statearr_24181_24290[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_24045[(4)]))){
var statearr_24182_24291 = state_24045;
(statearr_24182_24291[(1)] = cljs.core.first.call(null,(state_24045[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24292 = state_24045;
state_24045 = G__24292;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10903__auto__ = function(state_24045){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10903__auto____1.call(this,state_24045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10903__auto____0;
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10903__auto____1;
return fluree$db$query$range$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_24183 = f__10977__auto__.call(null);
(statearr_24183[(6)] = c__10976__auto__);

return statearr_24183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_24367){
var state_val_24368 = (state_24367[(1)]);
if((state_val_24368 === (7))){
var inst_24362 = (state_24367[(2)]);
var _ = (function (){var statearr_24369 = state_24367;
(statearr_24369[(4)] = cljs.core.rest.call(null,(state_24367[(4)])));

return statearr_24369;
})();
var state_24367__$1 = state_24367;
var statearr_24370_24410 = state_24367__$1;
(statearr_24370_24410[(2)] = inst_24362);

(statearr_24370_24410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (20))){
var inst_24344 = (state_24367[(2)]);
var inst_24345 = fluree.db.util.async.throw_err.call(null,inst_24344);
var state_24367__$1 = state_24367;
var statearr_24371_24411 = state_24367__$1;
(statearr_24371_24411[(2)] = inst_24345);

(statearr_24371_24411[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (1))){
var state_24367__$1 = state_24367;
var statearr_24372_24412 = state_24367__$1;
(statearr_24372_24412[(2)] = null);

(statearr_24372_24412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (4))){
var inst_24293 = (state_24367[(2)]);
var state_24367__$1 = state_24367;
var statearr_24373_24413 = state_24367__$1;
(statearr_24373_24413[(2)] = inst_24293);

(statearr_24373_24413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (15))){
var inst_24340 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24367__$1 = state_24367;
if(cljs.core.truth_(inst_24340)){
var statearr_24374_24414 = state_24367__$1;
(statearr_24374_24414[(1)] = (17));

} else {
var statearr_24375_24415 = state_24367__$1;
(statearr_24375_24415[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (21))){
var state_24367__$1 = state_24367;
var statearr_24376_24416 = state_24367__$1;
(statearr_24376_24416[(2)] = (0));

(statearr_24376_24416[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (13))){
var inst_24332 = (state_24367[(2)]);
var state_24367__$1 = state_24367;
var statearr_24377_24417 = state_24367__$1;
(statearr_24377_24417[(2)] = inst_24332);

(statearr_24377_24417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (22))){
var state_24367__$1 = state_24367;
var statearr_24378_24418 = state_24367__$1;
(statearr_24378_24418[(2)] = (1));

(statearr_24378_24418[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (6))){
var inst_24324 = (state_24367[(7)]);
var inst_24313 = (state_24367[(8)]);
var inst_24322 = (state_24367[(9)]);
var inst_24321 = cljs.core.seq.call(null,inst_24313);
var inst_24322__$1 = cljs.core.first.call(null,inst_24321);
var inst_24323 = cljs.core.next.call(null,inst_24321);
var inst_24324__$1 = (inst_24322__$1 == null);
var state_24367__$1 = (function (){var statearr_24379 = state_24367;
(statearr_24379[(7)] = inst_24324__$1);

(statearr_24379[(9)] = inst_24322__$1);

(statearr_24379[(10)] = inst_24323);

return statearr_24379;
})();
if(cljs.core.truth_(inst_24324__$1)){
var statearr_24380_24419 = state_24367__$1;
(statearr_24380_24419[(1)] = (8));

} else {
var statearr_24381_24420 = state_24367__$1;
(statearr_24381_24420[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (17))){
var inst_24322 = (state_24367[(9)]);
var inst_24342 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_24322);
var state_24367__$1 = state_24367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24367__$1,(20),inst_24342);
} else {
if((state_val_24368 === (3))){
var inst_24365 = (state_24367[(2)]);
var state_24367__$1 = state_24367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24367__$1,inst_24365);
} else {
if((state_val_24368 === (12))){
var inst_24315 = (state_24367[(11)]);
var inst_24330 = (inst_24315 >= subject_limit);
var state_24367__$1 = state_24367;
var statearr_24382_24421 = state_24367__$1;
(statearr_24382_24421[(2)] = inst_24330);

(statearr_24382_24421[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (2))){
var _ = (function (){var statearr_24383 = state_24367;
(statearr_24383[(4)] = cljs.core.cons.call(null,(5),(state_24367[(4)])));

return statearr_24383;
})();
var inst_24306 = subject_groups;
var inst_24307 = cljs.core.seq.call(null,inst_24306);
var inst_24308 = cljs.core.first.call(null,inst_24307);
var inst_24309 = cljs.core.next.call(null,inst_24307);
var inst_24310 = flake_start;
var inst_24311 = subject_start;
var inst_24312 = cljs.core.PersistentVector.EMPTY;
var inst_24313 = inst_24306;
var inst_24314 = inst_24310;
var inst_24315 = inst_24311;
var inst_24316 = inst_24312;
var state_24367__$1 = (function (){var statearr_24384 = state_24367;
(statearr_24384[(12)] = inst_24314);

(statearr_24384[(8)] = inst_24313);

(statearr_24384[(13)] = inst_24308);

(statearr_24384[(14)] = inst_24316);

(statearr_24384[(11)] = inst_24315);

(statearr_24384[(15)] = inst_24309);

return statearr_24384;
})();
var statearr_24385_24422 = state_24367__$1;
(statearr_24385_24422[(2)] = null);

(statearr_24385_24422[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (23))){
var inst_24314 = (state_24367[(12)]);
var inst_24349 = (state_24367[(16)]);
var inst_24323 = (state_24367[(10)]);
var inst_24316 = (state_24367[(14)]);
var inst_24315 = (state_24367[(11)]);
var inst_24348 = (state_24367[(17)]);
var inst_24354 = (state_24367[(2)]);
var inst_24355 = (inst_24314 + inst_24349);
var inst_24356 = (inst_24315 + inst_24354);
var inst_24357 = cljs.core.into.call(null,inst_24316,inst_24348);
var inst_24313 = inst_24323;
var inst_24314__$1 = inst_24355;
var inst_24315__$1 = inst_24356;
var inst_24316__$1 = inst_24357;
var state_24367__$1 = (function (){var statearr_24386 = state_24367;
(statearr_24386[(12)] = inst_24314__$1);

(statearr_24386[(8)] = inst_24313);

(statearr_24386[(14)] = inst_24316__$1);

(statearr_24386[(11)] = inst_24315__$1);

return statearr_24386;
})();
var statearr_24387_24423 = state_24367__$1;
(statearr_24387_24423[(2)] = null);

(statearr_24387_24423[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (19))){
var inst_24349 = (state_24367[(16)]);
var inst_24348 = (state_24367[(17)]);
var inst_24348__$1 = (state_24367[(2)]);
var inst_24349__$1 = cljs.core.count.call(null,inst_24348__$1);
var inst_24350 = cljs.core._EQ_.call(null,(0),inst_24349__$1);
var state_24367__$1 = (function (){var statearr_24388 = state_24367;
(statearr_24388[(16)] = inst_24349__$1);

(statearr_24388[(17)] = inst_24348__$1);

return statearr_24388;
})();
if(inst_24350){
var statearr_24389_24424 = state_24367__$1;
(statearr_24389_24424[(1)] = (21));

} else {
var statearr_24390_24425 = state_24367__$1;
(statearr_24390_24425[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (11))){
var inst_24327 = (state_24367[(18)]);
var state_24367__$1 = state_24367;
var statearr_24392_24426 = state_24367__$1;
(statearr_24392_24426[(2)] = inst_24327);

(statearr_24392_24426[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (9))){
var inst_24327 = (state_24367[(18)]);
var inst_24314 = (state_24367[(12)]);
var inst_24327__$1 = (inst_24314 >= flake_limit);
var state_24367__$1 = (function (){var statearr_24393 = state_24367;
(statearr_24393[(18)] = inst_24327__$1);

return statearr_24393;
})();
if(cljs.core.truth_(inst_24327__$1)){
var statearr_24394_24427 = state_24367__$1;
(statearr_24394_24427[(1)] = (11));

} else {
var statearr_24395_24428 = state_24367__$1;
(statearr_24395_24428[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (5))){
var _ = (function (){var statearr_24396 = state_24367;
(statearr_24396[(4)] = cljs.core.rest.call(null,(state_24367[(4)])));

return statearr_24396;
})();
var state_24367__$1 = state_24367;
var ex24391 = (state_24367__$1[(2)]);
var statearr_24397_24429 = state_24367__$1;
(statearr_24397_24429[(5)] = ex24391);


if((ex24391 instanceof Error)){
var statearr_24398_24430 = state_24367__$1;
(statearr_24398_24430[(1)] = (4));

(statearr_24398_24430[(5)] = null);

} else {
throw ex24391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (14))){
var inst_24314 = (state_24367[(12)]);
var inst_24316 = (state_24367[(14)]);
var inst_24315 = (state_24367[(11)]);
var inst_24336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24337 = [inst_24314,inst_24315,inst_24316];
var inst_24338 = (new cljs.core.PersistentVector(null,3,(5),inst_24336,inst_24337,null));
var state_24367__$1 = state_24367;
var statearr_24399_24431 = state_24367__$1;
(statearr_24399_24431[(2)] = inst_24338);

(statearr_24399_24431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (16))){
var inst_24360 = (state_24367[(2)]);
var state_24367__$1 = state_24367;
var statearr_24400_24432 = state_24367__$1;
(statearr_24400_24432[(2)] = inst_24360);

(statearr_24400_24432[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (10))){
var inst_24334 = (state_24367[(2)]);
var state_24367__$1 = state_24367;
if(cljs.core.truth_(inst_24334)){
var statearr_24401_24433 = state_24367__$1;
(statearr_24401_24433[(1)] = (14));

} else {
var statearr_24402_24434 = state_24367__$1;
(statearr_24402_24434[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (18))){
var inst_24322 = (state_24367[(9)]);
var state_24367__$1 = state_24367;
var statearr_24403_24435 = state_24367__$1;
(statearr_24403_24435[(2)] = inst_24322);

(statearr_24403_24435[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24368 === (8))){
var inst_24324 = (state_24367[(7)]);
var state_24367__$1 = state_24367;
var statearr_24404_24436 = state_24367__$1;
(statearr_24404_24436[(2)] = inst_24324);

(statearr_24404_24436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____0 = (function (){
var statearr_24405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24405[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__);

(statearr_24405[(1)] = (1));

return statearr_24405;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____1 = (function (state_24367){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_24367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e24406){var ex__10906__auto__ = e24406;
var statearr_24407_24437 = state_24367;
(statearr_24407_24437[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_24367[(4)]))){
var statearr_24408_24438 = state_24367;
(statearr_24408_24438[(1)] = cljs.core.first.call(null,(state_24367[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24439 = state_24367;
state_24367 = G__24439;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__ = function(state_24367){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____1.call(this,state_24367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_24409 = f__10977__auto__.call(null);
(statearr_24409[(6)] = c__10976__auto__);

return statearr_24409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_24485){
var state_val_24486 = (state_24485[(1)]);
if((state_val_24486 === (7))){
var state_24485__$1 = state_24485;
var statearr_24487_24525 = state_24485__$1;
(statearr_24487_24525[(2)] = null);

(statearr_24487_24525[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (20))){
var inst_24471 = (state_24485[(2)]);
var inst_24472 = fluree.db.util.async.throw_err.call(null,inst_24471);
var inst_24450 = inst_24472;
var state_24485__$1 = (function (){var statearr_24488 = state_24485;
(statearr_24488[(7)] = inst_24450);

return statearr_24488;
})();
var statearr_24489_24526 = state_24485__$1;
(statearr_24489_24526[(2)] = null);

(statearr_24489_24526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (1))){
var state_24485__$1 = state_24485;
var statearr_24490_24527 = state_24485__$1;
(statearr_24490_24527[(2)] = null);

(statearr_24490_24527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (4))){
var inst_24440 = (state_24485[(2)]);
var state_24485__$1 = state_24485;
var statearr_24491_24528 = state_24485__$1;
(statearr_24491_24528[(2)] = inst_24440);

(statearr_24491_24528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (15))){
var inst_24467 = (state_24485[(8)]);
var inst_24450 = (state_24485[(7)]);
var inst_24467__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_24450);
var state_24485__$1 = (function (){var statearr_24492 = state_24485;
(statearr_24492[(8)] = inst_24467__$1);

return statearr_24492;
})();
if(cljs.core.truth_(inst_24467__$1)){
var statearr_24493_24529 = state_24485__$1;
(statearr_24493_24529[(1)] = (17));

} else {
var statearr_24494_24530 = state_24485__$1;
(statearr_24494_24530[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (13))){
var inst_24460 = (state_24485[(2)]);
var inst_24461 = fluree.db.util.async.throw_err.call(null,inst_24460);
var _ = (function (){var statearr_24495 = state_24485;
(statearr_24495[(4)] = cljs.core.rest.call(null,(state_24485[(4)])));

return statearr_24495;
})();
var state_24485__$1 = state_24485;
var statearr_24496_24531 = state_24485__$1;
(statearr_24496_24531[(2)] = inst_24461);

(statearr_24496_24531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (6))){
var inst_24448 = (state_24485[(2)]);
var inst_24449 = fluree.db.util.async.throw_err.call(null,inst_24448);
var inst_24450 = inst_24449;
var state_24485__$1 = (function (){var statearr_24497 = state_24485;
(statearr_24497[(7)] = inst_24450);

return statearr_24497;
})();
var statearr_24498_24532 = state_24485__$1;
(statearr_24498_24532[(2)] = null);

(statearr_24498_24532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (17))){
var inst_24467 = (state_24485[(8)]);
var inst_24469 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_24467);
var state_24485__$1 = state_24485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24485__$1,(20),inst_24469);
} else {
if((state_val_24486 === (3))){
var inst_24483 = (state_24485[(2)]);
var state_24485__$1 = state_24485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24485__$1,inst_24483);
} else {
if((state_val_24486 === (12))){
var _ = (function (){var statearr_24500 = state_24485;
(statearr_24500[(4)] = cljs.core.rest.call(null,(state_24485[(4)])));

return statearr_24500;
})();
var state_24485__$1 = state_24485;
var ex24499 = (state_24485__$1[(2)]);
var statearr_24501_24533 = state_24485__$1;
(statearr_24501_24533[(5)] = ex24499);


var statearr_24502_24534 = state_24485__$1;
(statearr_24502_24534[(1)] = (11));

(statearr_24502_24534[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (2))){
var _ = (function (){var statearr_24503 = state_24485;
(statearr_24503[(4)] = cljs.core.cons.call(null,(5),(state_24485[(4)])));

return statearr_24503;
})();
var inst_24446 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_24485__$1 = state_24485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24485__$1,(6),inst_24446);
} else {
if((state_val_24486 === (19))){
var inst_24476 = (state_24485[(2)]);
var state_24485__$1 = state_24485;
var statearr_24504_24535 = state_24485__$1;
(statearr_24504_24535[(2)] = inst_24476);

(statearr_24504_24535[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (11))){
var inst_24452 = (state_24485[(2)]);
var state_24485__$1 = (function (){var statearr_24506 = state_24485;
(statearr_24506[(9)] = inst_24452);

return statearr_24506;
})();
var statearr_24507_24536 = state_24485__$1;
(statearr_24507_24536[(2)] = null);

(statearr_24507_24536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (9))){
var inst_24450 = (state_24485[(7)]);
var _ = (function (){var statearr_24508 = state_24485;
(statearr_24508[(4)] = cljs.core.cons.call(null,(12),(state_24485[(4)])));

return statearr_24508;
})();
var inst_24458 = fluree.db.dbproto._resolve_to_t.call(null,inst_24450,t,novelty,fast_forward_db_QMARK_);
var state_24485__$1 = state_24485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24485__$1,(13),inst_24458);
} else {
if((state_val_24486 === (5))){
var _ = (function (){var statearr_24509 = state_24485;
(statearr_24509[(4)] = cljs.core.rest.call(null,(state_24485[(4)])));

return statearr_24509;
})();
var state_24485__$1 = state_24485;
var ex24505 = (state_24485__$1[(2)]);
var statearr_24510_24537 = state_24485__$1;
(statearr_24510_24537[(5)] = ex24505);


if((ex24505 instanceof Error)){
var statearr_24511_24538 = state_24485__$1;
(statearr_24511_24538[(1)] = (4));

(statearr_24511_24538[(5)] = null);

} else {
throw ex24505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (14))){
var inst_24464 = (state_24485[(10)]);
var state_24485__$1 = state_24485;
var statearr_24512_24539 = state_24485__$1;
(statearr_24512_24539[(2)] = inst_24464);

(statearr_24512_24539[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (16))){
var inst_24478 = (state_24485[(2)]);
var state_24485__$1 = state_24485;
var statearr_24513_24540 = state_24485__$1;
(statearr_24513_24540[(2)] = inst_24478);

(statearr_24513_24540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (10))){
var inst_24464 = (state_24485[(10)]);
var inst_24464__$1 = (state_24485[(2)]);
var state_24485__$1 = (function (){var statearr_24514 = state_24485;
(statearr_24514[(10)] = inst_24464__$1);

return statearr_24514;
})();
if(cljs.core.truth_(inst_24464__$1)){
var statearr_24515_24541 = state_24485__$1;
(statearr_24515_24541[(1)] = (14));

} else {
var statearr_24516_24542 = state_24485__$1;
(statearr_24516_24542[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (18))){
var state_24485__$1 = state_24485;
var statearr_24517_24543 = state_24485__$1;
(statearr_24517_24543[(2)] = null);

(statearr_24517_24543[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24486 === (8))){
var inst_24480 = (state_24485[(2)]);
var _ = (function (){var statearr_24518 = state_24485;
(statearr_24518[(4)] = cljs.core.rest.call(null,(state_24485[(4)])));

return statearr_24518;
})();
var state_24485__$1 = state_24485;
var statearr_24519_24544 = state_24485__$1;
(statearr_24519_24544[(2)] = inst_24480);

(statearr_24519_24544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____0 = (function (){
var statearr_24520 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24520[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__);

(statearr_24520[(1)] = (1));

return statearr_24520;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____1 = (function (state_24485){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_24485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e24521){var ex__10906__auto__ = e24521;
var statearr_24522_24545 = state_24485;
(statearr_24522_24545[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_24485[(4)]))){
var statearr_24523_24546 = state_24485;
(statearr_24523_24546[(1)] = cljs.core.first.call(null,(state_24485[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24547 = state_24485;
state_24485 = G__24547;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__ = function(state_24485){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____1.call(this,state_24485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_24524 = f__10977__auto__.call(null);
(statearr_24524[(6)] = c__10976__auto__);

return statearr_24524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__24554 = arguments.length;
switch (G__24554) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__24555 = (function (){var pred__24558 = cljs.core.identical_QMARK_;
var expr__24559 = test;
if(cljs.core.truth_(pred__24558.call(null,cljs.core._EQ_,expr__24559))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24558.call(null,cljs.core._LT_,expr__24559))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__24558.call(null,cljs.core._LT__EQ_,expr__24559))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24558.call(null,cljs.core._GT_,expr__24559))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__24558.call(null,cljs.core._GT__EQ_,expr__24559))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__24559)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__24555,(0),null);
var start_match = cljs.core.nth.call(null,vec__24555,(1),null);
var end_test = cljs.core.nth.call(null,vec__24555,(2),null);
var end_match = cljs.core.nth.call(null,vec__24555,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_24931){
var state_val_24932 = (state_24931[(1)]);
if((state_val_24932 === (121))){
var inst_24887 = (state_24931[(7)]);
var state_24931__$1 = state_24931;
var statearr_24933_25126 = state_24931__$1;
(statearr_24933_25126[(2)] = inst_24887);

(statearr_24933_25126[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (65))){
var inst_24739 = (state_24931[(8)]);
var inst_24745 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_24934 = state_24931;
(statearr_24934[(9)] = inst_24745);

return statearr_24934;
})();
if(cljs.core.truth_(inst_24739)){
var statearr_24935_25127 = state_24931__$1;
(statearr_24935_25127[(1)] = (66));

} else {
var statearr_24936_25128 = state_24931__$1;
(statearr_24936_25128[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (70))){
var inst_24923 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_24937_25129 = state_24931__$1;
(statearr_24937_25129[(2)] = inst_24923);

(statearr_24937_25129[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (62))){
var inst_24738 = (state_24931[(2)]);
var inst_24739 = fluree.db.util.async.throw_err.call(null,inst_24738);
var inst_24740 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24931__$1 = (function (){var statearr_24938 = state_24931;
(statearr_24938[(8)] = inst_24739);

return statearr_24938;
})();
if(cljs.core.truth_(inst_24740)){
var statearr_24939_25130 = state_24931__$1;
(statearr_24939_25130[(1)] = (63));

} else {
var statearr_24940_25131 = state_24931__$1;
(statearr_24940_25131[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (74))){
var inst_24581 = (state_24931[(10)]);
var inst_24745 = (state_24931[(9)]);
var inst_24708 = (state_24931[(11)]);
var inst_24724 = (state_24931[(12)]);
var inst_24689 = (state_24931[(13)]);
var inst_24650 = (state_24931[(14)]);
var inst_24758 = (state_24931[(15)]);
var inst_24720 = (state_24931[(16)]);
var inst_24711 = (state_24931[(17)]);
var inst_24653 = (state_24931[(18)]);
var inst_24750 = (state_24931[(19)]);
var inst_24698 = (state_24931[(20)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24748 = (state_24931[(24)]);
var inst_24735 = (state_24931[(25)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24649 = (state_24931[(30)]);
var inst_24593 = (state_24931[(31)]);
var inst_24751 = (state_24931[(32)]);
var inst_24766 = (state_24931[(33)]);
var inst_24752 = (state_24931[(34)]);
var inst_24585 = (state_24931[(35)]);
var inst_24712 = (state_24931[(36)]);
var inst_24707 = (state_24931[(37)]);
var inst_24749 = (state_24931[(38)]);
var inst_24718 = (state_24931[(39)]);
var inst_24662 = (state_24931[(40)]);
var inst_24597 = (state_24931[(41)]);
var inst_24739 = (state_24931[(8)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24719 = (state_24931[(47)]);
var inst_24709 = (state_24931[(48)]);
var inst_24768 = (function (){var no_filter_QMARK_ = inst_24745;
var t = inst_24725;
var max_limit_QMARK_ = inst_24719;
var next_node = inst_24748;
var fast_forward_db_QMARK_ = inst_24730;
var s1 = inst_24608;
var map__24580 = inst_24711;
var o2 = inst_24671;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var i = inst_24750;
var m1 = inst_24698;
var root_node = inst_24735;
var s2 = inst_24617;
var G__24759 = inst_24766;
var p2 = inst_24689;
var permissions = inst_24720;
var map__24573 = inst_24596;
var limit = inst_24718;
var start_flake = inst_24708;
var vec__24577 = inst_24650;
var vec__24574 = inst_24649;
var flake_limit = inst_24712;
var offset = inst_24749;
var acc = inst_24752;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24662;
var end_flake = inst_24709;
var base_result = inst_24758;
var s = inst_24751;
var node_start = inst_24739;
var p1 = inst_24680;
var subject_fn = inst_24597;
var object_fn = inst_24653;
var idx_compare = inst_24724;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24707;
var novelty = inst_24729;
return (function (p1__24549_SHARP_){
return subject_fn.call(null,p1__24549_SHARP_.s);
});
})();
var inst_24769 = cljs.core.filter.call(null,inst_24768,inst_24766);
var state_24931__$1 = state_24931;
var statearr_24941_25132 = state_24931__$1;
(statearr_24941_25132[(2)] = inst_24769);

(statearr_24941_25132[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (110))){
var inst_24900 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_24942_25133 = state_24931__$1;
(statearr_24942_25133[(2)] = inst_24900);

(statearr_24942_25133[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (7))){
var inst_24582 = (state_24931[(49)]);
var state_24931__$1 = state_24931;
var statearr_24943_25134 = state_24931__$1;
(statearr_24943_25134[(2)] = inst_24582);

(statearr_24943_25134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (59))){
var state_24931__$1 = state_24931;
var statearr_24944_25135 = state_24931__$1;
(statearr_24944_25135[(2)] = fluree.db.util.core.max_long);

(statearr_24944_25135[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (86))){
var inst_24745 = (state_24931[(9)]);
var state_24931__$1 = state_24931;
var statearr_24945_25136 = state_24931__$1;
(statearr_24945_25136[(2)] = inst_24745);

(statearr_24945_25136[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (20))){
var state_24931__$1 = state_24931;
var statearr_24946_25137 = state_24931__$1;
(statearr_24946_25137[(2)] = null);

(statearr_24946_25137[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (72))){
var inst_24758 = (state_24931[(15)]);
var state_24931__$1 = state_24931;
var statearr_24947_25138 = state_24931__$1;
(statearr_24947_25138[(2)] = inst_24758);

(statearr_24947_25138[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (58))){
var inst_24713 = (state_24931[(50)]);
var state_24931__$1 = state_24931;
var statearr_24948_25139 = state_24931__$1;
(statearr_24948_25139[(2)] = inst_24713);

(statearr_24948_25139[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (60))){
var inst_24718 = (state_24931[(39)]);
var inst_24718__$1 = (state_24931[(2)]);
var inst_24719 = cljs.core._EQ_.call(null,inst_24718__$1,fluree.db.util.core.max_long);
var inst_24720 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_24721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24722 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_24723 = (new cljs.core.PersistentVector(null,3,(5),inst_24721,inst_24722,null));
var inst_24724 = cljs.core.get_in.call(null,db,inst_24723);
var inst_24725 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_24726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24727 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_24728 = (new cljs.core.PersistentVector(null,2,(5),inst_24726,inst_24727,null));
var inst_24729 = cljs.core.get_in.call(null,db,inst_24728);
var inst_24730 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_24731 = cljs.core.get.call(null,db,idx);
var inst_24732 = fluree.db.dbproto._resolve.call(null,inst_24731);
var state_24931__$1 = (function (){var statearr_24949 = state_24931;
(statearr_24949[(12)] = inst_24724);

(statearr_24949[(16)] = inst_24720);

(statearr_24949[(39)] = inst_24718__$1);

(statearr_24949[(42)] = inst_24725);

(statearr_24949[(43)] = inst_24730);

(statearr_24949[(44)] = inst_24729);

(statearr_24949[(47)] = inst_24719);

return statearr_24949;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(61),inst_24732);
} else {
if((state_val_24932 === (27))){
var inst_24651 = (state_24931[(51)]);
var state_24931__$1 = state_24931;
var statearr_24950_25140 = state_24931__$1;
(statearr_24950_25140[(2)] = inst_24651);

(statearr_24950_25140[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (1))){
var state_24931__$1 = state_24931;
var statearr_24951_25141 = state_24931__$1;
(statearr_24951_25141[(2)] = null);

(statearr_24951_25141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (69))){
var inst_24708 = (state_24931[(11)]);
var inst_24748 = (state_24931[(24)]);
var inst_24709 = (state_24931[(48)]);
var inst_24757 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_24748);
var inst_24758 = fluree.db.flake.subrange.call(null,inst_24757,start_test,inst_24708,end_test,inst_24709);
var inst_24760 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_24708,inst_24709);
var state_24931__$1 = (function (){var statearr_24952 = state_24931;
(statearr_24952[(15)] = inst_24758);

return statearr_24952;
})();
if(inst_24760){
var statearr_24953_25142 = state_24931__$1;
(statearr_24953_25142[(1)] = (71));

} else {
var statearr_24954_25143 = state_24931__$1;
(statearr_24954_25143[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (101))){
var inst_24844 = (state_24931[(52)]);
var inst_24712 = (state_24931[(36)]);
var inst_24845 = (state_24931[(53)]);
var inst_24846 = (state_24931[(54)]);
var inst_24849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24850 = (inst_24846 - inst_24712);
var inst_24851 = (inst_24845 - inst_24850);
var inst_24852 = cljs.core.take.call(null,inst_24851,inst_24844);
var inst_24853 = [inst_24712,inst_24852];
var inst_24854 = (new cljs.core.PersistentVector(null,2,(5),inst_24849,inst_24853,null));
var state_24931__$1 = state_24931;
var statearr_24955_25144 = state_24931__$1;
(statearr_24955_25144[(2)] = inst_24854);

(statearr_24955_25144[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (24))){
var inst_24581 = (state_24931[(10)]);
var inst_24590 = (state_24931[(55)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24591 = (state_24931[(56)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24594 = (state_24931[(57)]);
var inst_24593 = (state_24931[(31)]);
var inst_24599 = (state_24931[(58)]);
var inst_24585 = (state_24931[(35)]);
var inst_24583 = (state_24931[(59)]);
var inst_24597 = (state_24931[(41)]);
var inst_24631 = (state_24931[(60)]);
var inst_24608 = (state_24931[(46)]);
var inst_24587 = (state_24931[(61)]);
var inst_24584 = (state_24931[(62)]);
var inst_24641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24643 = [null,null];
var inst_24644 = (new cljs.core.PersistentVector(null,2,(5),inst_24642,inst_24643,null));
var inst_24645 = (function (){var bool = inst_24631;
var s1 = inst_24608;
var o2 = inst_24591;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var m1 = inst_24587;
var s2 = inst_24617;
var p2 = inst_24590;
var map__24573 = inst_24596;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24584;
var p1 = inst_24583;
var subject_fn = inst_24597;
var object_fn = inst_24599;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24594;
var temp__5755__auto__ = inst_24631;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_24646 = [inst_24644,inst_24645];
var inst_24647 = (new cljs.core.PersistentVector(null,2,(5),inst_24641,inst_24646,null));
var state_24931__$1 = state_24931;
var statearr_24956_25145 = state_24931__$1;
(statearr_24956_25145[(2)] = inst_24647);

(statearr_24956_25145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (102))){
var inst_24844 = (state_24931[(52)]);
var inst_24846 = (state_24931[(54)]);
var inst_24856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24857 = [inst_24846,inst_24844];
var inst_24858 = (new cljs.core.PersistentVector(null,2,(5),inst_24856,inst_24857,null));
var state_24931__$1 = state_24931;
var statearr_24957_25146 = state_24931__$1;
(statearr_24957_25146[(2)] = inst_24858);

(statearr_24957_25146[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (55))){
var state_24931__$1 = state_24931;
var statearr_24958_25147 = state_24931__$1;
(statearr_24958_25147[(2)] = (2147483647));

(statearr_24958_25147[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (85))){
var inst_24794 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
if(cljs.core.truth_(inst_24794)){
var statearr_24959_25148 = state_24931__$1;
(statearr_24959_25148[(1)] = (89));

} else {
var statearr_24960_25149 = state_24931__$1;
(statearr_24960_25149[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (39))){
var inst_24681 = (state_24931[(63)]);
var inst_24590 = (state_24931[(55)]);
var inst_24680 = (state_24931[(2)]);
var inst_24681__$1 = (inst_24590 == null);
var state_24931__$1 = (function (){var statearr_24961 = state_24931;
(statearr_24961[(63)] = inst_24681__$1);

(statearr_24961[(45)] = inst_24680);

return statearr_24961;
})();
if(cljs.core.truth_(inst_24681__$1)){
var statearr_24962_25150 = state_24931__$1;
(statearr_24962_25150[(1)] = (40));

} else {
var statearr_24963_25151 = state_24931__$1;
(statearr_24963_25151[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (88))){
var inst_24791 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_24964_25152 = state_24931__$1;
(statearr_24964_25152[(2)] = inst_24791);

(statearr_24964_25152[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (46))){
var inst_24587 = (state_24931[(61)]);
var state_24931__$1 = state_24931;
var statearr_24965_25153 = state_24931__$1;
(statearr_24965_25153[(2)] = inst_24587);

(statearr_24965_25153[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (4))){
var inst_24561 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_24966_25154 = state_24931__$1;
(statearr_24966_25154[(2)] = inst_24561);

(statearr_24966_25154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (77))){
var inst_24581 = (state_24931[(10)]);
var inst_24745 = (state_24931[(9)]);
var inst_24708 = (state_24931[(11)]);
var inst_24724 = (state_24931[(12)]);
var inst_24689 = (state_24931[(13)]);
var inst_24650 = (state_24931[(14)]);
var inst_24758 = (state_24931[(15)]);
var inst_24720 = (state_24931[(16)]);
var inst_24711 = (state_24931[(17)]);
var inst_24653 = (state_24931[(18)]);
var inst_24750 = (state_24931[(19)]);
var inst_24698 = (state_24931[(20)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24748 = (state_24931[(24)]);
var inst_24735 = (state_24931[(25)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24649 = (state_24931[(30)]);
var inst_24593 = (state_24931[(31)]);
var inst_24751 = (state_24931[(32)]);
var inst_24752 = (state_24931[(34)]);
var inst_24585 = (state_24931[(35)]);
var inst_24712 = (state_24931[(36)]);
var inst_24707 = (state_24931[(37)]);
var inst_24749 = (state_24931[(38)]);
var inst_24718 = (state_24931[(39)]);
var inst_24662 = (state_24931[(40)]);
var inst_24597 = (state_24931[(41)]);
var inst_24739 = (state_24931[(8)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24719 = (state_24931[(47)]);
var inst_24772 = (state_24931[(64)]);
var inst_24709 = (state_24931[(48)]);
var inst_24774 = (function (){var no_filter_QMARK_ = inst_24745;
var t = inst_24725;
var max_limit_QMARK_ = inst_24719;
var next_node = inst_24748;
var fast_forward_db_QMARK_ = inst_24730;
var s1 = inst_24608;
var map__24580 = inst_24711;
var o2 = inst_24671;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var i = inst_24750;
var m1 = inst_24698;
var root_node = inst_24735;
var s2 = inst_24617;
var G__24759 = inst_24772;
var p2 = inst_24689;
var permissions = inst_24720;
var map__24573 = inst_24596;
var limit = inst_24718;
var start_flake = inst_24708;
var vec__24577 = inst_24650;
var vec__24574 = inst_24649;
var flake_limit = inst_24712;
var offset = inst_24749;
var acc = inst_24752;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24662;
var end_flake = inst_24709;
var base_result = inst_24758;
var s = inst_24751;
var node_start = inst_24739;
var p1 = inst_24680;
var subject_fn = inst_24597;
var object_fn = inst_24653;
var idx_compare = inst_24724;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24707;
var novelty = inst_24729;
return (function (p1__24550_SHARP_){
return predicate_fn.call(null,p1__24550_SHARP_.p);
});
})();
var inst_24775 = cljs.core.filter.call(null,inst_24774,inst_24772);
var state_24931__$1 = state_24931;
var statearr_24967_25155 = state_24931__$1;
(statearr_24967_25155[(2)] = inst_24775);

(statearr_24967_25155[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (106))){
var inst_24785 = (state_24931[(65)]);
var state_24931__$1 = state_24931;
var statearr_24968_25156 = state_24931__$1;
(statearr_24968_25156[(2)] = inst_24785);

(statearr_24968_25156[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (119))){
var inst_24903 = (state_24931[(66)]);
var state_24931__$1 = state_24931;
var statearr_24969_25157 = state_24931__$1;
(statearr_24969_25157[(2)] = inst_24903);

(statearr_24969_25157[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (95))){
var inst_24827 = (state_24931[(67)]);
var inst_24818 = (state_24931[(68)]);
var inst_24826 = (state_24931[(69)]);
var inst_24751 = (state_24931[(32)]);
var inst_24718 = (state_24931[(39)]);
var inst_24828 = (state_24931[(70)]);
var inst_24826__$1 = cljs.core.count.call(null,inst_24818);
var inst_24827__$1 = (inst_24751 + inst_24826__$1);
var inst_24828__$1 = (inst_24827__$1 - inst_24718);
var inst_24829 = cljs.core.pos_int_QMARK_.call(null,inst_24828__$1);
var state_24931__$1 = (function (){var statearr_24970 = state_24931;
(statearr_24970[(67)] = inst_24827__$1);

(statearr_24970[(69)] = inst_24826__$1);

(statearr_24970[(70)] = inst_24828__$1);

return statearr_24970;
})();
if(inst_24829){
var statearr_24971_25158 = state_24931__$1;
(statearr_24971_25158[(1)] = (98));

} else {
var statearr_24972_25159 = state_24931__$1;
(statearr_24972_25159[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (54))){
var inst_24689 = (state_24931[(13)]);
var inst_24711 = (state_24931[(17)]);
var inst_24698 = (state_24931[(20)]);
var inst_24713 = (state_24931[(50)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24593 = (state_24931[(31)]);
var inst_24585 = (state_24931[(35)]);
var inst_24707 = (state_24931[(37)]);
var inst_24662 = (state_24931[(40)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24707__$1 = (state_24931[(2)]);
var inst_24708 = fluree.db.flake.__GT_Flake.call(null,inst_24608,inst_24680,inst_24662,inst_24585,inst_24586,inst_24698);
var inst_24709 = fluree.db.flake.__GT_Flake.call(null,inst_24617,inst_24689,inst_24671,inst_24592,inst_24593,inst_24707__$1);
var inst_24710 = opts;
var inst_24711__$1 = cljs.core.__destructure_map.call(null,inst_24710);
var inst_24712 = cljs.core.get.call(null,inst_24711__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_24713__$1 = cljs.core.get.call(null,inst_24711__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24714 = cljs.core.get.call(null,inst_24711__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_24931__$1 = (function (){var statearr_24973 = state_24931;
(statearr_24973[(11)] = inst_24708);

(statearr_24973[(17)] = inst_24711__$1);

(statearr_24973[(50)] = inst_24713__$1);

(statearr_24973[(36)] = inst_24712);

(statearr_24973[(37)] = inst_24707__$1);

(statearr_24973[(71)] = inst_24714);

(statearr_24973[(48)] = inst_24709);

return statearr_24973;
})();
if(cljs.core.truth_(inst_24713__$1)){
var statearr_24974_25160 = state_24931__$1;
(statearr_24974_25160[(1)] = (58));

} else {
var statearr_24975_25161 = state_24931__$1;
(statearr_24975_25161[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (92))){
var inst_24750 = (state_24931[(19)]);
var inst_24751 = (state_24931[(32)]);
var inst_24752 = (state_24931[(34)]);
var inst_24749 = (state_24931[(38)]);
var inst_24807 = (state_24931[(72)]);
var inst_24810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24811 = (inst_24749 - inst_24807);
var inst_24812 = [inst_24811,inst_24750,inst_24751,inst_24752];
var inst_24813 = (new cljs.core.PersistentVector(null,4,(5),inst_24810,inst_24812,null));
var state_24931__$1 = state_24931;
var statearr_24976_25162 = state_24931__$1;
(statearr_24976_25162[(2)] = inst_24813);

(statearr_24976_25162[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (104))){
var inst_24869 = (state_24931[(2)]);
var inst_24870 = fluree.db.util.async.throw_err.call(null,inst_24869);
var state_24931__$1 = state_24931;
var statearr_24977_25163 = state_24931__$1;
(statearr_24977_25163[(2)] = inst_24870);

(statearr_24977_25163[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (15))){
var inst_24591 = (state_24931[(56)]);
var inst_24621 = cljs.core.boolean_QMARK_.call(null,inst_24591);
var state_24931__$1 = state_24931;
if(inst_24621){
var statearr_24978_25164 = state_24931__$1;
(statearr_24978_25164[(1)] = (17));

} else {
var statearr_24979_25165 = state_24931__$1;
(statearr_24979_25165[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (48))){
var inst_24594 = (state_24931[(57)]);
var inst_24698 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_24980 = state_24931;
(statearr_24980[(20)] = inst_24698);

return statearr_24980;
})();
if(cljs.core.truth_(inst_24594)){
var statearr_24981_25166 = state_24931__$1;
(statearr_24981_25166[(1)] = (52));

} else {
var statearr_24982_25167 = state_24931__$1;
(statearr_24982_25167[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (50))){
var state_24931__$1 = state_24931;
var statearr_24983_25168 = state_24931__$1;
(statearr_24983_25168[(2)] = (2147483647));

(statearr_24983_25168[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (116))){
var inst_24903 = (state_24931[(66)]);
var inst_24911 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_24984 = state_24931;
(statearr_24984[(73)] = inst_24911);

return statearr_24984;
})();
if(cljs.core.truth_(inst_24903)){
var statearr_24985_25169 = state_24931__$1;
(statearr_24985_25169[(1)] = (118));

} else {
var statearr_24986_25170 = state_24931__$1;
(statearr_24986_25170[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (75))){
var inst_24766 = (state_24931[(33)]);
var state_24931__$1 = state_24931;
var statearr_24987_25171 = state_24931__$1;
(statearr_24987_25171[(2)] = inst_24766);

(statearr_24987_25171[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (99))){
var inst_24827 = (state_24931[(67)]);
var inst_24836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24837 = [inst_24827,inst_24827];
var inst_24838 = (new cljs.core.PersistentVector(null,2,(5),inst_24836,inst_24837,null));
var state_24931__$1 = state_24931;
var statearr_24988_25172 = state_24931__$1;
(statearr_24988_25172[(2)] = inst_24838);

(statearr_24988_25172[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (21))){
var state_24931__$1 = state_24931;
var statearr_24989_25173 = state_24931__$1;
(statearr_24989_25173[(2)] = null);

(statearr_24989_25173[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (31))){
var inst_24652 = (state_24931[(74)]);
var state_24931__$1 = state_24931;
var statearr_24990_25174 = state_24931__$1;
(statearr_24990_25174[(2)] = inst_24652);

(statearr_24990_25174[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (113))){
var inst_24897 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_24991_25175 = state_24931__$1;
(statearr_24991_25175[(2)] = inst_24897);

(statearr_24991_25175[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (32))){
var inst_24672 = (state_24931[(75)]);
var inst_24583 = (state_24931[(59)]);
var inst_24671 = (state_24931[(2)]);
var inst_24672__$1 = (inst_24583 == null);
var state_24931__$1 = (function (){var statearr_24992 = state_24931;
(statearr_24992[(75)] = inst_24672__$1);

(statearr_24992[(23)] = inst_24671);

return statearr_24992;
})();
if(cljs.core.truth_(inst_24672__$1)){
var statearr_24993_25176 = state_24931__$1;
(statearr_24993_25176[(1)] = (34));

} else {
var statearr_24994_25177 = state_24931__$1;
(statearr_24994_25177[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (40))){
var inst_24671 = (state_24931[(23)]);
var state_24931__$1 = state_24931;
var statearr_24995_25178 = state_24931__$1;
(statearr_24995_25178[(2)] = inst_24671);

(statearr_24995_25178[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (91))){
var inst_24785 = (state_24931[(65)]);
var inst_24883 = (state_24931[(2)]);
var inst_24884 = cljs.core.nth.call(null,inst_24883,(0),null);
var inst_24885 = cljs.core.nth.call(null,inst_24883,(1),null);
var inst_24886 = cljs.core.nth.call(null,inst_24883,(2),null);
var inst_24887 = cljs.core.nth.call(null,inst_24883,(3),null);
var state_24931__$1 = (function (){var statearr_24996 = state_24931;
(statearr_24996[(7)] = inst_24887);

(statearr_24996[(76)] = inst_24885);

(statearr_24996[(77)] = inst_24884);

(statearr_24996[(78)] = inst_24886);

return statearr_24996;
})();
if(cljs.core.truth_(inst_24785)){
var statearr_24997_25179 = state_24931__$1;
(statearr_24997_25179[(1)] = (105));

} else {
var statearr_24998_25180 = state_24931__$1;
(statearr_24998_25180[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (117))){
var inst_24907 = (state_24931[(2)]);
var inst_24908 = fluree.db.util.async.throw_err.call(null,inst_24907);
var state_24931__$1 = state_24931;
var statearr_24999_25181 = state_24931__$1;
(statearr_24999_25181[(2)] = inst_24908);

(statearr_24999_25181[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (108))){
var inst_24885 = (state_24931[(76)]);
var inst_24892 = (state_24931[(79)]);
var inst_24712 = (state_24931[(36)]);
var inst_24892__$1 = (inst_24885 < inst_24712);
var state_24931__$1 = (function (){var statearr_25000 = state_24931;
(statearr_25000[(79)] = inst_24892__$1);

return statearr_25000;
})();
if(cljs.core.truth_(inst_24892__$1)){
var statearr_25001_25182 = state_24931__$1;
(statearr_25001_25182[(1)] = (111));

} else {
var statearr_25002_25183 = state_24931__$1;
(statearr_25002_25183[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (56))){
var state_24931__$1 = state_24931;
var statearr_25003_25184 = state_24931__$1;
(statearr_25003_25184[(2)] = fluree.db.util.core.min_integer);

(statearr_25003_25184[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (33))){
var inst_24667 = (state_24931[(2)]);
var inst_24668 = fluree.db.util.async.throw_err.call(null,inst_24667);
var state_24931__$1 = state_24931;
var statearr_25004_25185 = state_24931__$1;
(statearr_25004_25185[(2)] = inst_24668);

(statearr_25004_25185[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (13))){
var inst_24613 = (state_24931[(2)]);
var inst_24614 = fluree.db.util.async.throw_err.call(null,inst_24613);
var state_24931__$1 = state_24931;
var statearr_25005_25186 = state_24931__$1;
(statearr_25005_25186[(2)] = inst_24614);

(statearr_25005_25186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (22))){
var inst_24627 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25006_25187 = state_24931__$1;
(statearr_25006_25187[(2)] = inst_24627);

(statearr_25006_25187[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (90))){
var inst_24581 = (state_24931[(10)]);
var inst_24745 = (state_24931[(9)]);
var inst_24708 = (state_24931[(11)]);
var inst_24724 = (state_24931[(12)]);
var inst_24689 = (state_24931[(13)]);
var inst_24650 = (state_24931[(14)]);
var inst_24758 = (state_24931[(15)]);
var inst_24720 = (state_24931[(16)]);
var inst_24711 = (state_24931[(17)]);
var inst_24653 = (state_24931[(18)]);
var inst_24750 = (state_24931[(19)]);
var inst_24784 = (state_24931[(80)]);
var inst_24698 = (state_24931[(20)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24748 = (state_24931[(24)]);
var inst_24735 = (state_24931[(25)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24649 = (state_24931[(30)]);
var inst_24785 = (state_24931[(65)]);
var inst_24593 = (state_24931[(31)]);
var inst_24751 = (state_24931[(32)]);
var inst_24806 = (state_24931[(81)]);
var inst_24752 = (state_24931[(34)]);
var inst_24585 = (state_24931[(35)]);
var inst_24712 = (state_24931[(36)]);
var inst_24707 = (state_24931[(37)]);
var inst_24749 = (state_24931[(38)]);
var inst_24718 = (state_24931[(39)]);
var inst_24662 = (state_24931[(40)]);
var inst_24597 = (state_24931[(41)]);
var inst_24739 = (state_24931[(8)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24807 = (state_24931[(72)]);
var inst_24729 = (state_24931[(44)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24719 = (state_24931[(47)]);
var inst_24709 = (state_24931[(48)]);
var inst_24805 = (function (){var no_filter_QMARK_ = inst_24745;
var base_result_SINGLEQUOTE_ = inst_24784;
var t = inst_24725;
var max_limit_QMARK_ = inst_24719;
var next_node = inst_24748;
var fast_forward_db_QMARK_ = inst_24730;
var s1 = inst_24608;
var map__24580 = inst_24711;
var o2 = inst_24671;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var i = inst_24750;
var rhs = inst_24785;
var m1 = inst_24698;
var root_node = inst_24735;
var s2 = inst_24617;
var p2 = inst_24689;
var permissions = inst_24720;
var map__24573 = inst_24596;
var limit = inst_24718;
var start_flake = inst_24708;
var vec__24577 = inst_24650;
var vec__24574 = inst_24649;
var flake_limit = inst_24712;
var offset = inst_24749;
var acc = inst_24752;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24662;
var end_flake = inst_24709;
var base_result = inst_24758;
var s = inst_24751;
var node_start = inst_24739;
var p1 = inst_24680;
var subject_fn = inst_24597;
var object_fn = inst_24653;
var idx_compare = inst_24724;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24707;
var novelty = inst_24729;
return (function (p1__24552_SHARP_){
return p1__24552_SHARP_.s;
});
})();
var inst_24806__$1 = cljs.core.partition_by.call(null,inst_24805,inst_24784);
var inst_24807__$1 = cljs.core.count.call(null,inst_24806__$1);
var inst_24808 = (inst_24749 > inst_24807__$1);
var state_24931__$1 = (function (){var statearr_25007 = state_24931;
(statearr_25007[(81)] = inst_24806__$1);

(statearr_25007[(72)] = inst_24807__$1);

return statearr_25007;
})();
if(cljs.core.truth_(inst_24808)){
var statearr_25008_25188 = state_24931__$1;
(statearr_25008_25188[(1)] = (92));

} else {
var statearr_25009_25189 = state_24931__$1;
(statearr_25009_25189[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (109))){
var inst_24890 = (state_24931[(82)]);
var state_24931__$1 = state_24931;
var statearr_25010_25190 = state_24931__$1;
(statearr_25010_25190[(2)] = inst_24890);

(statearr_25010_25190[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (36))){
var inst_24676 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
if(cljs.core.truth_(inst_24676)){
var statearr_25011_25191 = state_24931__$1;
(statearr_25011_25191[(1)] = (37));

} else {
var statearr_25012_25192 = state_24931__$1;
(statearr_25012_25192[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (41))){
var inst_24681 = (state_24931[(63)]);
var state_24931__$1 = state_24931;
var statearr_25013_25193 = state_24931__$1;
(statearr_25013_25193[(2)] = inst_24681);

(statearr_25013_25193[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (118))){
var inst_24911 = (state_24931[(73)]);
var state_24931__$1 = state_24931;
var statearr_25014_25194 = state_24931__$1;
(statearr_25014_25194[(2)] = inst_24911);

(statearr_25014_25194[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (89))){
var inst_24750 = (state_24931[(19)]);
var inst_24784 = (state_24931[(80)]);
var inst_24751 = (state_24931[(32)]);
var inst_24752 = (state_24931[(34)]);
var inst_24712 = (state_24931[(36)]);
var inst_24796 = cljs.core.count.call(null,inst_24784);
var inst_24797 = (inst_24712 - inst_24750);
var inst_24798 = cljs.core.take.call(null,inst_24797,inst_24784);
var inst_24799 = cljs.core.into.call(null,inst_24752,inst_24798);
var inst_24800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24801 = (inst_24750 + inst_24796);
var inst_24802 = [(0),inst_24801,inst_24751,inst_24799];
var inst_24803 = (new cljs.core.PersistentVector(null,4,(5),inst_24800,inst_24802,null));
var state_24931__$1 = state_24931;
var statearr_25015_25195 = state_24931__$1;
(statearr_25015_25195[(2)] = inst_24803);

(statearr_25015_25195[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (100))){
var inst_24750 = (state_24931[(19)]);
var inst_24818 = (state_24931[(68)]);
var inst_24844 = (state_24931[(52)]);
var inst_24712 = (state_24931[(36)]);
var inst_24845 = (state_24931[(53)]);
var inst_24846 = (state_24931[(54)]);
var inst_24840 = (state_24931[(2)]);
var inst_24841 = cljs.core.nth.call(null,inst_24840,(0),null);
var inst_24842 = cljs.core.nth.call(null,inst_24840,(1),null);
var inst_24843 = cljs.core.take.call(null,inst_24842,inst_24818);
var inst_24844__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_24843);
var inst_24845__$1 = cljs.core.count.call(null,inst_24844__$1);
var inst_24846__$1 = (inst_24750 + inst_24845__$1);
var inst_24847 = (inst_24846__$1 > inst_24712);
var state_24931__$1 = (function (){var statearr_25016 = state_24931;
(statearr_25016[(52)] = inst_24844__$1);

(statearr_25016[(53)] = inst_24845__$1);

(statearr_25016[(54)] = inst_24846__$1);

(statearr_25016[(83)] = inst_24841);

return statearr_25016;
})();
if(cljs.core.truth_(inst_24847)){
var statearr_25017_25196 = state_24931__$1;
(statearr_25017_25196[(1)] = (101));

} else {
var statearr_25018_25197 = state_24931__$1;
(statearr_25018_25197[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (122))){
var inst_24887 = (state_24931[(7)]);
var inst_24885 = (state_24931[(76)]);
var inst_24884 = (state_24931[(77)]);
var inst_24886 = (state_24931[(78)]);
var inst_24911 = (state_24931[(73)]);
var inst_24748 = inst_24911;
var inst_24749 = inst_24884;
var inst_24750 = inst_24885;
var inst_24751 = inst_24886;
var inst_24752 = inst_24887;
var state_24931__$1 = (function (){var statearr_25019 = state_24931;
(statearr_25019[(19)] = inst_24750);

(statearr_25019[(24)] = inst_24748);

(statearr_25019[(32)] = inst_24751);

(statearr_25019[(34)] = inst_24752);

(statearr_25019[(38)] = inst_24749);

return statearr_25019;
})();
var statearr_25020_25198 = state_24931__$1;
(statearr_25020_25198[(2)] = null);

(statearr_25020_25198[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (43))){
var state_24931__$1 = state_24931;
var statearr_25021_25199 = state_24931__$1;
(statearr_25021_25199[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25021_25199[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (61))){
var inst_24708 = (state_24931[(11)]);
var inst_24735 = (state_24931[(25)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24734 = (state_24931[(2)]);
var inst_24735__$1 = fluree.db.util.async.throw_err.call(null,inst_24734);
var inst_24736 = fluree.db.query.range.find_next_valid_node.call(null,inst_24735__$1,inst_24708,inst_24725,inst_24729,inst_24730);
var state_24931__$1 = (function (){var statearr_25022 = state_24931;
(statearr_25022[(25)] = inst_24735__$1);

return statearr_25022;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(62),inst_24736);
} else {
if((state_val_24932 === (29))){
var inst_24658 = (state_24931[(2)]);
var inst_24659 = fluree.db.util.async.throw_err.call(null,inst_24658);
var state_24931__$1 = state_24931;
var statearr_25023_25200 = state_24931__$1;
(statearr_25023_25200[(2)] = inst_24659);

(statearr_25023_25200[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (44))){
var inst_24590 = (state_24931[(55)]);
var state_24931__$1 = state_24931;
var statearr_25024_25201 = state_24931__$1;
(statearr_25024_25201[(2)] = inst_24590);

(statearr_25024_25201[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (93))){
var inst_24745 = (state_24931[(9)]);
var inst_24806 = (state_24931[(81)]);
var inst_24749 = (state_24931[(38)]);
var inst_24818 = cljs.core.drop.call(null,inst_24749,inst_24806);
var state_24931__$1 = (function (){var statearr_25025 = state_24931;
(statearr_25025[(68)] = inst_24818);

return statearr_25025;
})();
if(cljs.core.truth_(inst_24745)){
var statearr_25026_25202 = state_24931__$1;
(statearr_25026_25202[(1)] = (95));

} else {
var statearr_25027_25203 = state_24931__$1;
(statearr_25027_25203[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (6))){
var inst_24582 = (state_24931[(49)]);
var inst_24602 = fluree.db.dbproto._subid.call(null,db,inst_24582);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(9),inst_24602);
} else {
if((state_val_24932 === (111))){
var inst_24718 = (state_24931[(39)]);
var inst_24886 = (state_24931[(78)]);
var inst_24894 = (inst_24886 < inst_24718);
var state_24931__$1 = state_24931;
var statearr_25028_25204 = state_24931__$1;
(statearr_25028_25204[(2)] = inst_24894);

(statearr_25028_25204[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (28))){
var inst_24652 = (state_24931[(74)]);
var inst_24662 = (state_24931[(2)]);
var inst_24663 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24652);
var state_24931__$1 = (function (){var statearr_25029 = state_24931;
(statearr_25029[(40)] = inst_24662);

return statearr_25029;
})();
if(inst_24663){
var statearr_25030_25205 = state_24931__$1;
(statearr_25030_25205[(1)] = (30));

} else {
var statearr_25031_25206 = state_24931__$1;
(statearr_25031_25206[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (64))){
var state_24931__$1 = state_24931;
var statearr_25032_25207 = state_24931__$1;
(statearr_25032_25207[(2)] = true);

(statearr_25032_25207[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (103))){
var inst_24841 = (state_24931[(83)]);
var inst_24860 = (state_24931[(2)]);
var inst_24861 = cljs.core.nth.call(null,inst_24860,(0),null);
var inst_24862 = cljs.core.nth.call(null,inst_24860,(1),null);
var inst_24863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24864 = [inst_24861,inst_24841,inst_24862];
var inst_24865 = (new cljs.core.PersistentVector(null,3,(5),inst_24863,inst_24864,null));
var state_24931__$1 = state_24931;
var statearr_25033_25208 = state_24931__$1;
(statearr_25033_25208[(2)] = inst_24865);

(statearr_25033_25208[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (51))){
var inst_24696 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25034_25209 = state_24931__$1;
(statearr_25034_25209[(2)] = inst_24696);

(statearr_25034_25209[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (25))){
var inst_24650 = (state_24931[(14)]);
var inst_24649 = (state_24931[(30)]);
var inst_24651 = (state_24931[(51)]);
var inst_24649__$1 = (state_24931[(2)]);
var inst_24650__$1 = cljs.core.nth.call(null,inst_24649__$1,(0),null);
var inst_24651__$1 = cljs.core.nth.call(null,inst_24650__$1,(0),null);
var inst_24652 = cljs.core.nth.call(null,inst_24650__$1,(1),null);
var inst_24653 = cljs.core.nth.call(null,inst_24649__$1,(1),null);
var inst_24654 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24651__$1);
var state_24931__$1 = (function (){var statearr_25035 = state_24931;
(statearr_25035[(14)] = inst_24650__$1);

(statearr_25035[(18)] = inst_24653);

(statearr_25035[(30)] = inst_24649__$1);

(statearr_25035[(51)] = inst_24651__$1);

(statearr_25035[(74)] = inst_24652);

return statearr_25035;
})();
if(inst_24654){
var statearr_25036_25210 = state_24931__$1;
(statearr_25036_25210[(1)] = (26));

} else {
var statearr_25037_25211 = state_24931__$1;
(statearr_25037_25211[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (34))){
var inst_24662 = (state_24931[(40)]);
var state_24931__$1 = state_24931;
var statearr_25038_25212 = state_24931__$1;
(statearr_25038_25212[(2)] = inst_24662);

(statearr_25038_25212[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (17))){
var inst_24591 = (state_24931[(56)]);
var state_24931__$1 = state_24931;
var statearr_25039_25213 = state_24931__$1;
(statearr_25039_25213[(2)] = inst_24591);

(statearr_25039_25213[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (3))){
var inst_24929 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24931__$1,inst_24929);
} else {
if((state_val_24932 === (12))){
var inst_24584 = (state_24931[(62)]);
var inst_24617 = (state_24931[(2)]);
var inst_24618 = cljs.core.boolean_QMARK_.call(null,inst_24584);
var state_24931__$1 = (function (){var statearr_25040 = state_24931;
(statearr_25040[(27)] = inst_24617);

return statearr_25040;
})();
if(inst_24618){
var statearr_25041_25214 = state_24931__$1;
(statearr_25041_25214[(1)] = (14));

} else {
var statearr_25042_25215 = state_24931__$1;
(statearr_25042_25215[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (2))){
var inst_24581 = (state_24931[(10)]);
var inst_24596 = (state_24931[(26)]);
var inst_24588 = (state_24931[(29)]);
var inst_24582 = (state_24931[(49)]);
var _ = (function (){var statearr_25043 = state_24931;
(statearr_25043[(4)] = cljs.core.cons.call(null,(5),(state_24931[(4)])));

return statearr_25043;
})();
var inst_24581__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_24582__$1 = cljs.core.nth.call(null,inst_24581__$1,(0),null);
var inst_24583 = cljs.core.nth.call(null,inst_24581__$1,(1),null);
var inst_24584 = cljs.core.nth.call(null,inst_24581__$1,(2),null);
var inst_24585 = cljs.core.nth.call(null,inst_24581__$1,(3),null);
var inst_24586 = cljs.core.nth.call(null,inst_24581__$1,(4),null);
var inst_24587 = cljs.core.nth.call(null,inst_24581__$1,(5),null);
var inst_24588__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_24589 = cljs.core.nth.call(null,inst_24588__$1,(0),null);
var inst_24590 = cljs.core.nth.call(null,inst_24588__$1,(1),null);
var inst_24591 = cljs.core.nth.call(null,inst_24588__$1,(2),null);
var inst_24592 = cljs.core.nth.call(null,inst_24588__$1,(3),null);
var inst_24593 = cljs.core.nth.call(null,inst_24588__$1,(4),null);
var inst_24594 = cljs.core.nth.call(null,inst_24588__$1,(5),null);
var inst_24595 = opts;
var inst_24596__$1 = cljs.core.__destructure_map.call(null,inst_24595);
var inst_24597 = cljs.core.get.call(null,inst_24596__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_24598 = cljs.core.get.call(null,inst_24596__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_24599 = cljs.core.get.call(null,inst_24596__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_24600 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24582__$1);
var state_24931__$1 = (function (){var statearr_25044 = state_24931;
(statearr_25044[(10)] = inst_24581__$1);

(statearr_25044[(84)] = inst_24589);

(statearr_25044[(55)] = inst_24590);

(statearr_25044[(21)] = inst_24598);

(statearr_25044[(22)] = inst_24586);

(statearr_25044[(56)] = inst_24591);

(statearr_25044[(26)] = inst_24596__$1);

(statearr_25044[(28)] = inst_24592);

(statearr_25044[(29)] = inst_24588__$1);

(statearr_25044[(57)] = inst_24594);

(statearr_25044[(31)] = inst_24593);

(statearr_25044[(58)] = inst_24599);

(statearr_25044[(35)] = inst_24585);

(statearr_25044[(59)] = inst_24583);

(statearr_25044[(41)] = inst_24597);

(statearr_25044[(49)] = inst_24582__$1);

(statearr_25044[(61)] = inst_24587);

(statearr_25044[(62)] = inst_24584);

return statearr_25044;
})();
if(inst_24600){
var statearr_25045_25216 = state_24931__$1;
(statearr_25045_25216[(1)] = (6));

} else {
var statearr_25046_25217 = state_24931__$1;
(statearr_25046_25217[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (66))){
var inst_24739 = (state_24931[(8)]);
var inst_24714 = (state_24931[(71)]);
var inst_24747 = cljs.core.PersistentVector.EMPTY;
var inst_24748 = inst_24739;
var inst_24749 = inst_24714;
var inst_24750 = (0);
var inst_24751 = (0);
var inst_24752 = inst_24747;
var state_24931__$1 = (function (){var statearr_25047 = state_24931;
(statearr_25047[(19)] = inst_24750);

(statearr_25047[(24)] = inst_24748);

(statearr_25047[(32)] = inst_24751);

(statearr_25047[(34)] = inst_24752);

(statearr_25047[(38)] = inst_24749);

return statearr_25047;
})();
var statearr_25048_25218 = state_24931__$1;
(statearr_25048_25218[(2)] = null);

(statearr_25048_25218[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (107))){
var inst_24903 = (state_24931[(66)]);
var inst_24903__$1 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_25049 = state_24931;
(statearr_25049[(66)] = inst_24903__$1);

return statearr_25049;
})();
if(cljs.core.truth_(inst_24903__$1)){
var statearr_25050_25219 = state_24931__$1;
(statearr_25050_25219[(1)] = (114));

} else {
var statearr_25051_25220 = state_24931__$1;
(statearr_25051_25220[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (23))){
var inst_24591 = (state_24931[(56)]);
var inst_24599 = (state_24931[(58)]);
var inst_24584 = (state_24931[(62)]);
var inst_24634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24636 = [inst_24584,inst_24591];
var inst_24637 = (new cljs.core.PersistentVector(null,2,(5),inst_24635,inst_24636,null));
var inst_24638 = [inst_24637,inst_24599];
var inst_24639 = (new cljs.core.PersistentVector(null,2,(5),inst_24634,inst_24638,null));
var state_24931__$1 = state_24931;
var statearr_25052_25221 = state_24931__$1;
(statearr_25052_25221[(2)] = inst_24639);

(statearr_25052_25221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (47))){
var inst_24692 = (cljs.core._GT__EQ_ === start_test);
var state_24931__$1 = state_24931;
if(cljs.core.truth_(inst_24692)){
var statearr_25053_25222 = state_24931__$1;
(statearr_25053_25222[(1)] = (49));

} else {
var statearr_25054_25223 = state_24931__$1;
(statearr_25054_25223[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (35))){
var inst_24672 = (state_24931[(75)]);
var state_24931__$1 = state_24931;
var statearr_25055_25224 = state_24931__$1;
(statearr_25055_25224[(2)] = inst_24672);

(statearr_25055_25224[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (82))){
var inst_24748 = (state_24931[(24)]);
var inst_24719 = (state_24931[(47)]);
var inst_24784 = (state_24931[(2)]);
var inst_24785 = fluree.db.dbproto._rhs.call(null,inst_24748);
var state_24931__$1 = (function (){var statearr_25056 = state_24931;
(statearr_25056[(80)] = inst_24784);

(statearr_25056[(65)] = inst_24785);

return statearr_25056;
})();
if(cljs.core.truth_(inst_24719)){
var statearr_25057_25225 = state_24931__$1;
(statearr_25057_25225[(1)] = (83));

} else {
var statearr_25058_25226 = state_24931__$1;
(statearr_25058_25226[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (76))){
var inst_24598 = (state_24931[(21)]);
var inst_24772 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_25059 = state_24931;
(statearr_25059[(64)] = inst_24772);

return statearr_25059;
})();
if(cljs.core.truth_(inst_24598)){
var statearr_25060_25227 = state_24931__$1;
(statearr_25060_25227[(1)] = (77));

} else {
var statearr_25061_25228 = state_24931__$1;
(statearr_25061_25228[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (97))){
var inst_24752 = (state_24931[(34)]);
var inst_24872 = (state_24931[(2)]);
var inst_24873 = cljs.core.nth.call(null,inst_24872,(0),null);
var inst_24874 = cljs.core.nth.call(null,inst_24872,(1),null);
var inst_24875 = cljs.core.nth.call(null,inst_24872,(2),null);
var inst_24876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24877 = cljs.core.into.call(null,inst_24752,inst_24875);
var inst_24878 = [(0),inst_24873,inst_24874,inst_24877];
var inst_24879 = (new cljs.core.PersistentVector(null,4,(5),inst_24876,inst_24878,null));
var state_24931__$1 = state_24931;
var statearr_25062_25229 = state_24931__$1;
(statearr_25062_25229[(2)] = inst_24879);

(statearr_25062_25229[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (19))){
var inst_24629 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25063_25230 = state_24931__$1;
(statearr_25063_25230[(2)] = inst_24629);

(statearr_25063_25230[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (57))){
var inst_24705 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25064_25231 = state_24931__$1;
(statearr_25064_25231[(2)] = inst_24705);

(statearr_25064_25231[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (68))){
var inst_24926 = (state_24931[(2)]);
var _ = (function (){var statearr_25065 = state_24931;
(statearr_25065[(4)] = cljs.core.rest.call(null,(state_24931[(4)])));

return statearr_25065;
})();
var state_24931__$1 = state_24931;
var statearr_25066_25232 = state_24931__$1;
(statearr_25066_25232[(2)] = inst_24926);

(statearr_25066_25232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (11))){
var inst_24589 = (state_24931[(84)]);
var state_24931__$1 = state_24931;
var statearr_25067_25233 = state_24931__$1;
(statearr_25067_25233[(2)] = inst_24589);

(statearr_25067_25233[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (115))){
var state_24931__$1 = state_24931;
var statearr_25069_25234 = state_24931__$1;
(statearr_25069_25234[(2)] = null);

(statearr_25069_25234[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (9))){
var inst_24604 = (state_24931[(2)]);
var inst_24605 = fluree.db.util.async.throw_err.call(null,inst_24604);
var state_24931__$1 = state_24931;
var statearr_25070_25235 = state_24931__$1;
(statearr_25070_25235[(2)] = inst_24605);

(statearr_25070_25235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (5))){
var _ = (function (){var statearr_25071 = state_24931;
(statearr_25071[(4)] = cljs.core.rest.call(null,(state_24931[(4)])));

return statearr_25071;
})();
var state_24931__$1 = state_24931;
var ex25068 = (state_24931__$1[(2)]);
var statearr_25072_25236 = state_24931__$1;
(statearr_25072_25236[(5)] = ex25068);


if((ex25068 instanceof Error)){
var statearr_25073_25237 = state_24931__$1;
(statearr_25073_25237[(1)] = (4));

(statearr_25073_25237[(5)] = null);

} else {
throw ex25068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (112))){
var inst_24892 = (state_24931[(79)]);
var state_24931__$1 = state_24931;
var statearr_25074_25238 = state_24931__$1;
(statearr_25074_25238[(2)] = inst_24892);

(statearr_25074_25238[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (83))){
var inst_24749 = (state_24931[(38)]);
var inst_24787 = (state_24931[(85)]);
var inst_24787__$1 = cljs.core._EQ_.call(null,(0),inst_24749);
var state_24931__$1 = (function (){var statearr_25075 = state_24931;
(statearr_25075[(85)] = inst_24787__$1);

return statearr_25075;
})();
if(inst_24787__$1){
var statearr_25076_25239 = state_24931__$1;
(statearr_25076_25239[(1)] = (86));

} else {
var statearr_25077_25240 = state_24931__$1;
(statearr_25077_25240[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (14))){
var inst_24584 = (state_24931[(62)]);
var state_24931__$1 = state_24931;
var statearr_25078_25241 = state_24931__$1;
(statearr_25078_25241[(2)] = inst_24584);

(statearr_25078_25241[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (45))){
var inst_24587 = (state_24931[(61)]);
var inst_24689 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_25079 = state_24931;
(statearr_25079[(13)] = inst_24689);

return statearr_25079;
})();
if(cljs.core.truth_(inst_24587)){
var statearr_25080_25242 = state_24931__$1;
(statearr_25080_25242[(1)] = (46));

} else {
var statearr_25081_25243 = state_24931__$1;
(statearr_25081_25243[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (53))){
var inst_24701 = (cljs.core._LT__EQ_ === end_test);
var state_24931__$1 = state_24931;
if(cljs.core.truth_(inst_24701)){
var statearr_25082_25244 = state_24931__$1;
(statearr_25082_25244[(1)] = (55));

} else {
var statearr_25083_25245 = state_24931__$1;
(statearr_25083_25245[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (78))){
var inst_24772 = (state_24931[(64)]);
var state_24931__$1 = state_24931;
var statearr_25084_25246 = state_24931__$1;
(statearr_25084_25246[(2)] = inst_24772);

(statearr_25084_25246[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (26))){
var inst_24651 = (state_24931[(51)]);
var inst_24656 = fluree.db.dbproto._subid.call(null,db,inst_24651);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(29),inst_24656);
} else {
if((state_val_24932 === (123))){
var inst_24921 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25085_25247 = state_24931__$1;
(statearr_25085_25247[(2)] = inst_24921);

(statearr_25085_25247[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (16))){
var inst_24631 = (state_24931[(60)]);
var inst_24631__$1 = (state_24931[(2)]);
var inst_24632 = (inst_24631__$1 == null);
var state_24931__$1 = (function (){var statearr_25086 = state_24931;
(statearr_25086[(60)] = inst_24631__$1);

return statearr_25086;
})();
if(cljs.core.truth_(inst_24632)){
var statearr_25087_25248 = state_24931__$1;
(statearr_25087_25248[(1)] = (23));

} else {
var statearr_25088_25249 = state_24931__$1;
(statearr_25088_25249[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (81))){
var inst_24778 = (state_24931[(86)]);
var state_24931__$1 = state_24931;
var statearr_25089_25250 = state_24931__$1;
(statearr_25089_25250[(2)] = inst_24778);

(statearr_25089_25250[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (120))){
var inst_24915 = (state_24931[(2)]);
var inst_24916 = cljs.core.not.call(null,inst_24915);
var state_24931__$1 = state_24931;
if(inst_24916){
var statearr_25090_25251 = state_24931__$1;
(statearr_25090_25251[(1)] = (121));

} else {
var statearr_25091_25252 = state_24931__$1;
(statearr_25091_25252[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (79))){
var inst_24653 = (state_24931[(18)]);
var inst_24778 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_25092 = state_24931;
(statearr_25092[(86)] = inst_24778);

return statearr_25092;
})();
if(cljs.core.truth_(inst_24653)){
var statearr_25093_25253 = state_24931__$1;
(statearr_25093_25253[(1)] = (80));

} else {
var statearr_25094_25254 = state_24931__$1;
(statearr_25094_25254[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (38))){
var inst_24583 = (state_24931[(59)]);
var state_24931__$1 = state_24931;
var statearr_25095_25255 = state_24931__$1;
(statearr_25095_25255[(2)] = inst_24583);

(statearr_25095_25255[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (98))){
var inst_24826 = (state_24931[(69)]);
var inst_24718 = (state_24931[(39)]);
var inst_24828 = (state_24931[(70)]);
var inst_24831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24832 = (inst_24826 - inst_24828);
var inst_24833 = [inst_24718,inst_24832];
var inst_24834 = (new cljs.core.PersistentVector(null,2,(5),inst_24831,inst_24833,null));
var state_24931__$1 = state_24931;
var statearr_25096_25256 = state_24931__$1;
(statearr_25096_25256[(2)] = inst_24834);

(statearr_25096_25256[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (87))){
var inst_24787 = (state_24931[(85)]);
var state_24931__$1 = state_24931;
var statearr_25097_25257 = state_24931__$1;
(statearr_25097_25257[(2)] = inst_24787);

(statearr_25097_25257[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (30))){
var inst_24652 = (state_24931[(74)]);
var inst_24665 = fluree.db.dbproto._subid.call(null,db,inst_24652);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(33),inst_24665);
} else {
if((state_val_24932 === (73))){
var inst_24597 = (state_24931[(41)]);
var inst_24766 = (state_24931[(2)]);
var state_24931__$1 = (function (){var statearr_25098 = state_24931;
(statearr_25098[(33)] = inst_24766);

return statearr_25098;
})();
if(cljs.core.truth_(inst_24597)){
var statearr_25099_25258 = state_24931__$1;
(statearr_25099_25258[(1)] = (74));

} else {
var statearr_25100_25259 = state_24931__$1;
(statearr_25100_25259[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (96))){
var inst_24750 = (state_24931[(19)]);
var inst_24818 = (state_24931[(68)]);
var inst_24751 = (state_24931[(32)]);
var inst_24712 = (state_24931[(36)]);
var inst_24718 = (state_24931[(39)]);
var inst_24867 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_24818,inst_24750,inst_24751,inst_24712,inst_24718);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(104),inst_24867);
} else {
if((state_val_24932 === (10))){
var inst_24589 = (state_24931[(84)]);
var inst_24611 = fluree.db.dbproto._subid.call(null,db,inst_24589);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(13),inst_24611);
} else {
if((state_val_24932 === (18))){
var state_24931__$1 = state_24931;
var statearr_25101_25260 = state_24931__$1;
(statearr_25101_25260[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (105))){
var inst_24724 = (state_24931[(12)]);
var inst_24890 = (state_24931[(82)]);
var inst_24785 = (state_24931[(65)]);
var inst_24709 = (state_24931[(48)]);
var inst_24889 = inst_24724.call(null,inst_24785,inst_24709);
var inst_24890__$1 = (inst_24889 < (0));
var state_24931__$1 = (function (){var statearr_25103 = state_24931;
(statearr_25103[(82)] = inst_24890__$1);

return statearr_25103;
})();
if(cljs.core.truth_(inst_24890__$1)){
var statearr_25104_25261 = state_24931__$1;
(statearr_25104_25261[(1)] = (108));

} else {
var statearr_25105_25262 = state_24931__$1;
(statearr_25105_25262[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (52))){
var inst_24594 = (state_24931[(57)]);
var state_24931__$1 = state_24931;
var statearr_25106_25263 = state_24931__$1;
(statearr_25106_25263[(2)] = inst_24594);

(statearr_25106_25263[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (114))){
var inst_24735 = (state_24931[(25)]);
var inst_24785 = (state_24931[(65)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24905 = fluree.db.query.range.find_next_valid_node.call(null,inst_24735,inst_24785,inst_24725,inst_24729,inst_24730);
var state_24931__$1 = state_24931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24931__$1,(117),inst_24905);
} else {
if((state_val_24932 === (67))){
var state_24931__$1 = state_24931;
var statearr_25107_25264 = state_24931__$1;
(statearr_25107_25264[(2)] = null);

(statearr_25107_25264[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (71))){
var inst_24581 = (state_24931[(10)]);
var inst_24745 = (state_24931[(9)]);
var inst_24708 = (state_24931[(11)]);
var inst_24724 = (state_24931[(12)]);
var inst_24689 = (state_24931[(13)]);
var inst_24650 = (state_24931[(14)]);
var inst_24758 = (state_24931[(15)]);
var inst_24720 = (state_24931[(16)]);
var inst_24711 = (state_24931[(17)]);
var inst_24653 = (state_24931[(18)]);
var inst_24750 = (state_24931[(19)]);
var inst_24698 = (state_24931[(20)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24748 = (state_24931[(24)]);
var inst_24735 = (state_24931[(25)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24649 = (state_24931[(30)]);
var inst_24593 = (state_24931[(31)]);
var inst_24751 = (state_24931[(32)]);
var inst_24752 = (state_24931[(34)]);
var inst_24585 = (state_24931[(35)]);
var inst_24712 = (state_24931[(36)]);
var inst_24707 = (state_24931[(37)]);
var inst_24749 = (state_24931[(38)]);
var inst_24718 = (state_24931[(39)]);
var inst_24662 = (state_24931[(40)]);
var inst_24597 = (state_24931[(41)]);
var inst_24739 = (state_24931[(8)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24719 = (state_24931[(47)]);
var inst_24709 = (state_24931[(48)]);
var inst_24762 = (function (){var no_filter_QMARK_ = inst_24745;
var t = inst_24725;
var max_limit_QMARK_ = inst_24719;
var next_node = inst_24748;
var fast_forward_db_QMARK_ = inst_24730;
var s1 = inst_24608;
var map__24580 = inst_24711;
var o2 = inst_24671;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var i = inst_24750;
var m1 = inst_24698;
var root_node = inst_24735;
var s2 = inst_24617;
var G__24759 = inst_24758;
var p2 = inst_24689;
var permissions = inst_24720;
var map__24573 = inst_24596;
var limit = inst_24718;
var start_flake = inst_24708;
var vec__24577 = inst_24650;
var vec__24574 = inst_24649;
var flake_limit = inst_24712;
var offset = inst_24749;
var acc = inst_24752;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24662;
var end_flake = inst_24709;
var base_result = inst_24758;
var s = inst_24751;
var node_start = inst_24739;
var p1 = inst_24680;
var subject_fn = inst_24597;
var object_fn = inst_24653;
var idx_compare = inst_24724;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24707;
var novelty = inst_24729;
return (function (p1__24548_SHARP_){
return cljs.core._EQ_.call(null,p1__24548_SHARP_.o,start_flake.o);
});
})();
var inst_24763 = cljs.core.filter.call(null,inst_24762,inst_24758);
var state_24931__$1 = state_24931;
var statearr_25108_25265 = state_24931__$1;
(statearr_25108_25265[(2)] = inst_24763);

(statearr_25108_25265[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (42))){
var inst_24685 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
if(cljs.core.truth_(inst_24685)){
var statearr_25109_25266 = state_24931__$1;
(statearr_25109_25266[(1)] = (43));

} else {
var statearr_25110_25267 = state_24931__$1;
(statearr_25110_25267[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (80))){
var inst_24581 = (state_24931[(10)]);
var inst_24745 = (state_24931[(9)]);
var inst_24708 = (state_24931[(11)]);
var inst_24724 = (state_24931[(12)]);
var inst_24689 = (state_24931[(13)]);
var inst_24650 = (state_24931[(14)]);
var inst_24758 = (state_24931[(15)]);
var inst_24720 = (state_24931[(16)]);
var inst_24778 = (state_24931[(86)]);
var inst_24711 = (state_24931[(17)]);
var inst_24653 = (state_24931[(18)]);
var inst_24750 = (state_24931[(19)]);
var inst_24698 = (state_24931[(20)]);
var inst_24598 = (state_24931[(21)]);
var inst_24586 = (state_24931[(22)]);
var inst_24671 = (state_24931[(23)]);
var inst_24748 = (state_24931[(24)]);
var inst_24735 = (state_24931[(25)]);
var inst_24596 = (state_24931[(26)]);
var inst_24617 = (state_24931[(27)]);
var inst_24592 = (state_24931[(28)]);
var inst_24588 = (state_24931[(29)]);
var inst_24649 = (state_24931[(30)]);
var inst_24593 = (state_24931[(31)]);
var inst_24751 = (state_24931[(32)]);
var inst_24752 = (state_24931[(34)]);
var inst_24585 = (state_24931[(35)]);
var inst_24712 = (state_24931[(36)]);
var inst_24707 = (state_24931[(37)]);
var inst_24749 = (state_24931[(38)]);
var inst_24718 = (state_24931[(39)]);
var inst_24662 = (state_24931[(40)]);
var inst_24597 = (state_24931[(41)]);
var inst_24739 = (state_24931[(8)]);
var inst_24725 = (state_24931[(42)]);
var inst_24730 = (state_24931[(43)]);
var inst_24729 = (state_24931[(44)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24719 = (state_24931[(47)]);
var inst_24709 = (state_24931[(48)]);
var inst_24780 = (function (){var no_filter_QMARK_ = inst_24745;
var t = inst_24725;
var max_limit_QMARK_ = inst_24719;
var next_node = inst_24748;
var fast_forward_db_QMARK_ = inst_24730;
var s1 = inst_24608;
var map__24580 = inst_24711;
var o2 = inst_24671;
var t1 = inst_24585;
var vec__24570 = inst_24588;
var predicate_fn = inst_24598;
var i = inst_24750;
var m1 = inst_24698;
var root_node = inst_24735;
var s2 = inst_24617;
var G__24759 = inst_24778;
var p2 = inst_24689;
var permissions = inst_24720;
var map__24573 = inst_24596;
var limit = inst_24718;
var start_flake = inst_24708;
var vec__24577 = inst_24650;
var vec__24574 = inst_24649;
var flake_limit = inst_24712;
var offset = inst_24749;
var acc = inst_24752;
var t2 = inst_24592;
var op1 = inst_24586;
var o1 = inst_24662;
var end_flake = inst_24709;
var base_result = inst_24758;
var s = inst_24751;
var node_start = inst_24739;
var p1 = inst_24680;
var subject_fn = inst_24597;
var object_fn = inst_24653;
var idx_compare = inst_24724;
var vec__24567 = inst_24581;
var op2 = inst_24593;
var m2 = inst_24707;
var novelty = inst_24729;
return (function (p1__24551_SHARP_){
return object_fn.call(null,p1__24551_SHARP_.o);
});
})();
var inst_24781 = cljs.core.filter.call(null,inst_24780,inst_24778);
var state_24931__$1 = state_24931;
var statearr_25111_25268 = state_24931__$1;
(statearr_25111_25268[(2)] = inst_24781);

(statearr_25111_25268[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (37))){
var state_24931__$1 = state_24931;
var statearr_25112_25269 = state_24931__$1;
(statearr_25112_25269[(2)] = (-1));

(statearr_25112_25269[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (63))){
var inst_24689 = (state_24931[(13)]);
var inst_24720 = (state_24931[(16)]);
var inst_24617 = (state_24931[(27)]);
var inst_24680 = (state_24931[(45)]);
var inst_24608 = (state_24931[(46)]);
var inst_24742 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_24720,inst_24608,inst_24617,inst_24680,inst_24689);
var state_24931__$1 = state_24931;
var statearr_25113_25270 = state_24931__$1;
(statearr_25113_25270[(2)] = inst_24742);

(statearr_25113_25270[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (94))){
var inst_24881 = (state_24931[(2)]);
var state_24931__$1 = state_24931;
var statearr_25114_25271 = state_24931__$1;
(statearr_25114_25271[(2)] = inst_24881);

(statearr_25114_25271[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (8))){
var inst_24589 = (state_24931[(84)]);
var inst_24608 = (state_24931[(2)]);
var inst_24609 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24589);
var state_24931__$1 = (function (){var statearr_25115 = state_24931;
(statearr_25115[(46)] = inst_24608);

return statearr_25115;
})();
if(inst_24609){
var statearr_25116_25272 = state_24931__$1;
(statearr_25116_25272[(1)] = (10));

} else {
var statearr_25117_25273 = state_24931__$1;
(statearr_25117_25273[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (49))){
var state_24931__$1 = state_24931;
var statearr_25118_25274 = state_24931__$1;
(statearr_25118_25274[(2)] = fluree.db.util.core.min_integer);

(statearr_25118_25274[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24932 === (84))){
var inst_24719 = (state_24931[(47)]);
var state_24931__$1 = state_24931;
var statearr_25119_25275 = state_24931__$1;
(statearr_25119_25275[(2)] = inst_24719);

(statearr_25119_25275[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10903__auto__ = null;
var fluree$db$query$range$state_machine__10903__auto____0 = (function (){
var statearr_25120 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25120[(0)] = fluree$db$query$range$state_machine__10903__auto__);

(statearr_25120[(1)] = (1));

return statearr_25120;
});
var fluree$db$query$range$state_machine__10903__auto____1 = (function (state_24931){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_24931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25121){var ex__10906__auto__ = e25121;
var statearr_25122_25276 = state_24931;
(statearr_25122_25276[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_24931[(4)]))){
var statearr_25123_25277 = state_24931;
(statearr_25123_25277[(1)] = cljs.core.first.call(null,(state_24931[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25278 = state_24931;
state_24931 = G__25278;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10903__auto__ = function(state_24931){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10903__auto____1.call(this,state_24931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10903__auto____0;
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10903__auto____1;
return fluree$db$query$range$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25124 = f__10977__auto__.call(null);
(statearr_25124[(6)] = c__10976__auto__);

return statearr_25124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_25334){
var state_val_25335 = (state_25334[(1)]);
if((state_val_25335 === (7))){
var inst_25308 = (state_25334[(7)]);
var inst_25298 = (state_25334[(8)]);
var inst_25306 = fluree.db.flake.Flake__GT_parts.call(null,inst_25298);
var inst_25307 = cljs.core.nth.call(null,inst_25306,(0),null);
var inst_25308__$1 = cljs.core.nth.call(null,inst_25306,(1),null);
var inst_25309 = cljs.core.nth.call(null,inst_25306,(2),null);
var inst_25310 = cljs.core.nth.call(null,inst_25306,(3),null);
var inst_25311 = cljs.core.nth.call(null,inst_25306,(4),null);
var inst_25312 = cljs.core.nth.call(null,inst_25306,(5),null);
var inst_25313 = fluree.db.dbproto._tag.call(null,db,inst_25309,inst_25308__$1);
var state_25334__$1 = (function (){var statearr_25336 = state_25334;
(statearr_25336[(9)] = inst_25307);

(statearr_25336[(7)] = inst_25308__$1);

(statearr_25336[(10)] = inst_25310);

(statearr_25336[(11)] = inst_25311);

(statearr_25336[(12)] = inst_25312);

return statearr_25336;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25334__$1,(10),inst_25313);
} else {
if((state_val_25335 === (1))){
var inst_25286 = flakes;
var inst_25287 = cljs.core.seq.call(null,inst_25286);
var inst_25288 = cljs.core.first.call(null,inst_25287);
var inst_25289 = cljs.core.next.call(null,inst_25287);
var inst_25290 = cljs.core.PersistentVector.EMPTY;
var inst_25291 = inst_25286;
var inst_25292 = inst_25290;
var state_25334__$1 = (function (){var statearr_25337 = state_25334;
(statearr_25337[(13)] = inst_25292);

(statearr_25337[(14)] = inst_25291);

(statearr_25337[(15)] = inst_25288);

(statearr_25337[(16)] = inst_25289);

return statearr_25337;
})();
var statearr_25338_25356 = state_25334__$1;
(statearr_25338_25356[(2)] = null);

(statearr_25338_25356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (4))){
var inst_25298 = (state_25334[(8)]);
var inst_25301 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_25298);
var state_25334__$1 = state_25334;
if(inst_25301){
var statearr_25339_25357 = state_25334__$1;
(statearr_25339_25357[(1)] = (7));

} else {
var statearr_25340_25358 = state_25334__$1;
(statearr_25340_25358[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (6))){
var inst_25330 = (state_25334[(2)]);
var state_25334__$1 = state_25334;
var statearr_25341_25359 = state_25334__$1;
(statearr_25341_25359[(2)] = inst_25330);

(statearr_25341_25359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (3))){
var inst_25332 = (state_25334[(2)]);
var state_25334__$1 = state_25334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25334__$1,inst_25332);
} else {
if((state_val_25335 === (2))){
var inst_25298 = (state_25334[(8)]);
var inst_25291 = (state_25334[(14)]);
var inst_25297 = cljs.core.seq.call(null,inst_25291);
var inst_25298__$1 = cljs.core.first.call(null,inst_25297);
var inst_25299 = cljs.core.next.call(null,inst_25297);
var state_25334__$1 = (function (){var statearr_25342 = state_25334;
(statearr_25342[(8)] = inst_25298__$1);

(statearr_25342[(17)] = inst_25299);

return statearr_25342;
})();
if(cljs.core.truth_(inst_25298__$1)){
var statearr_25343_25360 = state_25334__$1;
(statearr_25343_25360[(1)] = (4));

} else {
var statearr_25344_25361 = state_25334__$1;
(statearr_25344_25361[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (9))){
var inst_25327 = (state_25334[(2)]);
var state_25334__$1 = state_25334;
var statearr_25345_25362 = state_25334__$1;
(statearr_25345_25362[(2)] = inst_25327);

(statearr_25345_25362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (5))){
var inst_25292 = (state_25334[(13)]);
var state_25334__$1 = state_25334;
var statearr_25346_25363 = state_25334__$1;
(statearr_25346_25363[(2)] = inst_25292);

(statearr_25346_25363[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (10))){
var inst_25307 = (state_25334[(9)]);
var inst_25292 = (state_25334[(13)]);
var inst_25308 = (state_25334[(7)]);
var inst_25310 = (state_25334[(10)]);
var inst_25311 = (state_25334[(11)]);
var inst_25312 = (state_25334[(12)]);
var inst_25299 = (state_25334[(17)]);
var inst_25315 = (state_25334[(2)]);
var inst_25316 = fluree.db.util.async.throw_err.call(null,inst_25315);
var inst_25317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25318 = [inst_25307,inst_25308,inst_25316,inst_25310,inst_25311,inst_25312];
var inst_25319 = (new cljs.core.PersistentVector(null,6,(5),inst_25317,inst_25318,null));
var inst_25320 = fluree.db.flake.parts__GT_Flake.call(null,inst_25319);
var inst_25321 = cljs.core.conj.call(null,inst_25292,inst_25320);
var inst_25291 = inst_25299;
var inst_25292__$1 = inst_25321;
var state_25334__$1 = (function (){var statearr_25347 = state_25334;
(statearr_25347[(13)] = inst_25292__$1);

(statearr_25347[(14)] = inst_25291);

return statearr_25347;
})();
var statearr_25348_25364 = state_25334__$1;
(statearr_25348_25364[(2)] = null);

(statearr_25348_25364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25335 === (8))){
var inst_25292 = (state_25334[(13)]);
var inst_25298 = (state_25334[(8)]);
var inst_25299 = (state_25334[(17)]);
var inst_25324 = cljs.core.conj.call(null,inst_25292,inst_25298);
var inst_25291 = inst_25299;
var inst_25292__$1 = inst_25324;
var state_25334__$1 = (function (){var statearr_25349 = state_25334;
(statearr_25349[(13)] = inst_25292__$1);

(statearr_25349[(14)] = inst_25291);

return statearr_25349;
})();
var statearr_25350_25365 = state_25334__$1;
(statearr_25350_25365[(2)] = null);

(statearr_25350_25365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____0 = (function (){
var statearr_25351 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25351[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__);

(statearr_25351[(1)] = (1));

return statearr_25351;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____1 = (function (state_25334){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_25334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25352){var ex__10906__auto__ = e25352;
var statearr_25353_25366 = state_25334;
(statearr_25353_25366[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_25334[(4)]))){
var statearr_25354_25367 = state_25334;
(statearr_25354_25367[(1)] = cljs.core.first.call(null,(state_25334[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25368 = state_25334;
state_25334 = G__25368;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__ = function(state_25334){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____1.call(this,state_25334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25355 = f__10977__auto__.call(null);
(statearr_25355[(6)] = c__10976__auto__);

return statearr_25355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__25370 = arguments.length;
switch (G__25370) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_25540){
var state_val_25541 = (state_25540[(1)]);
if((state_val_25541 === (65))){
var state_25540__$1 = state_25540;
var statearr_25542_25642 = state_25540__$1;
(statearr_25542_25642[(2)] = null);

(statearr_25542_25642[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (70))){
var inst_25535 = (state_25540[(2)]);
var _ = (function (){var statearr_25543 = state_25540;
(statearr_25543[(4)] = cljs.core.rest.call(null,(state_25540[(4)])));

return statearr_25543;
})();
var state_25540__$1 = state_25540;
var statearr_25544_25643 = state_25540__$1;
(statearr_25544_25643[(2)] = inst_25535);

(statearr_25544_25643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (62))){
var inst_25521 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25545_25644 = state_25540__$1;
(statearr_25545_25644[(2)] = inst_25521);

(statearr_25545_25644[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (7))){
var state_25540__$1 = state_25540;
var statearr_25546_25645 = state_25540__$1;
(statearr_25546_25645[(2)] = false);

(statearr_25546_25645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (59))){
var inst_25495 = (state_25540[(2)]);
var inst_25496 = fluree.db.util.async.throw_err.call(null,inst_25495);
var state_25540__$1 = state_25540;
var statearr_25547_25646 = state_25540__$1;
(statearr_25547_25646[(2)] = inst_25496);

(statearr_25547_25646[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (20))){
var state_25540__$1 = state_25540;
var statearr_25548_25647 = state_25540__$1;
(statearr_25548_25647[(2)] = null);

(statearr_25548_25647[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (58))){
var inst_25485 = (state_25540[(2)]);
var inst_25486 = fluree.db.util.async.throw_err.call(null,inst_25485);
var inst_25487 = cljs.core.take.call(null,(1),inst_25486);
var state_25540__$1 = state_25540;
var statearr_25549_25648 = state_25540__$1;
(statearr_25549_25648[(2)] = inst_25487);

(statearr_25549_25648[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (60))){
var inst_25384 = (state_25540[(7)]);
var inst_25421 = (state_25540[(8)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25502 = [inst_25382,inst_25381,inst_25421,inst_25384];
var inst_25503 = (new cljs.core.PersistentVector(null,4,(5),inst_25501,inst_25502,null));
var inst_25504 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25503,opts);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(63),inst_25504);
} else {
if((state_val_25541 === (27))){
var inst_25432 = (state_25540[(11)]);
var inst_25421 = (state_25540[(8)]);
var inst_25432__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_25421);
var state_25540__$1 = (function (){var statearr_25550 = state_25540;
(statearr_25550[(11)] = inst_25432__$1);

return statearr_25550;
})();
if(inst_25432__$1){
var statearr_25551_25649 = state_25540__$1;
(statearr_25551_25649[(1)] = (30));

} else {
var statearr_25552_25650 = state_25540__$1;
(statearr_25552_25650[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (1))){
var state_25540__$1 = state_25540;
var statearr_25553_25651 = state_25540__$1;
(statearr_25553_25651[(2)] = null);

(statearr_25553_25651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (69))){
var inst_25527 = (state_25540[(12)]);
var state_25540__$1 = state_25540;
var statearr_25554_25652 = state_25540__$1;
(statearr_25554_25652[(2)] = inst_25527);

(statearr_25554_25652[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (24))){
var inst_25382 = (state_25540[(9)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25382)){
var statearr_25555_25653 = state_25540__$1;
(statearr_25555_25653[(1)] = (27));

} else {
var statearr_25556_25654 = state_25540__$1;
(statearr_25556_25654[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (55))){
var inst_25421 = (state_25540[(8)]);
var inst_25479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25480 = [inst_25421];
var inst_25481 = (new cljs.core.PersistentVector(null,1,(5),inst_25479,inst_25480,null));
var inst_25482 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_25483 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25481,inst_25482);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(58),inst_25483);
} else {
if((state_val_25541 === (39))){
var inst_25452 = (state_25540[(2)]);
var inst_25453 = fluree.db.util.async.throw_err.call(null,inst_25452);
var state_25540__$1 = state_25540;
var statearr_25557_25655 = state_25540__$1;
(statearr_25557_25655[(2)] = inst_25453);

(statearr_25557_25655[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (46))){
var inst_25465 = (state_25540[(13)]);
var inst_25465__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_25540__$1 = (function (){var statearr_25558 = state_25540;
(statearr_25558[(13)] = inst_25465__$1);

return statearr_25558;
})();
if(cljs.core.truth_(inst_25465__$1)){
var statearr_25559_25656 = state_25540__$1;
(statearr_25559_25656[(1)] = (49));

} else {
var statearr_25560_25657 = state_25540__$1;
(statearr_25560_25657[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (4))){
var inst_25371 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25561_25658 = state_25540__$1;
(statearr_25561_25658[(2)] = inst_25371);

(statearr_25561_25658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (54))){
var inst_25477 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25477)){
var statearr_25562_25659 = state_25540__$1;
(statearr_25562_25659[(1)] = (55));

} else {
var statearr_25563_25660 = state_25540__$1;
(statearr_25563_25660[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (15))){
var inst_25383 = (state_25540[(14)]);
var inst_25402 = fluree.db.dbproto._tag_id.call(null,db,inst_25383);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(18),inst_25402);
} else {
if((state_val_25541 === (48))){
var inst_25523 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25564_25661 = state_25540__$1;
(statearr_25564_25661[(2)] = inst_25523);

(statearr_25564_25661[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (50))){
var inst_25384 = (state_25540[(7)]);
var inst_25385 = (state_25540[(15)]);
var inst_25421 = (state_25540[(8)]);
var inst_25396 = (state_25540[(16)]);
var inst_25380 = (state_25540[(17)]);
var inst_25465 = (state_25540[(13)]);
var inst_25391 = (state_25540[(18)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25469 = (function (){var t = inst_25384;
var p = inst_25382;
var idx_predicate_QMARK_ = inst_25385;
var o = inst_25421;
var tag_predicate_QMARK_ = inst_25391;
var temp__5751__auto__ = inst_25465;
var s = inst_25381;
var o_coerce_QMARK_ = inst_25396;
var vec__25377 = inst_25380;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_25540__$1 = state_25540;
var statearr_25565_25662 = state_25540__$1;
(statearr_25565_25662[(2)] = inst_25469);

(statearr_25565_25662[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (21))){
var inst_25417 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25566_25663 = state_25540__$1;
(statearr_25566_25663[(2)] = inst_25417);

(statearr_25566_25663[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (31))){
var inst_25432 = (state_25540[(11)]);
var state_25540__$1 = state_25540;
var statearr_25567_25664 = state_25540__$1;
(statearr_25567_25664[(2)] = inst_25432);

(statearr_25567_25664[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (32))){
var inst_25442 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25568_25665 = state_25540__$1;
(statearr_25568_25665[(2)] = inst_25442);

(statearr_25568_25665[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (40))){
var inst_25385 = (state_25540[(15)]);
var inst_25456 = (state_25540[(19)]);
var inst_25456__$1 = cljs.core.not.call(null,inst_25385);
var state_25540__$1 = (function (){var statearr_25569 = state_25540;
(statearr_25569[(19)] = inst_25456__$1);

return statearr_25569;
})();
if(inst_25456__$1){
var statearr_25570_25666 = state_25540__$1;
(statearr_25570_25666[(1)] = (43));

} else {
var statearr_25571_25667 = state_25540__$1;
(statearr_25571_25667[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (56))){
var inst_25384 = (state_25540[(7)]);
var inst_25471 = (state_25540[(20)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25490 = [inst_25382,inst_25381,null,inst_25384];
var inst_25491 = (new cljs.core.PersistentVector(null,4,(5),inst_25489,inst_25490,null));
var inst_25492 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_25471);
var inst_25493 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25491,inst_25492);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(59),inst_25493);
} else {
if((state_val_25541 === (33))){
var inst_25421 = (state_25540[(8)]);
var inst_25435 = cljs.core.fn_QMARK_.call(null,inst_25421);
var inst_25436 = (!(inst_25435));
var state_25540__$1 = state_25540;
var statearr_25572_25668 = state_25540__$1;
(statearr_25572_25668[(2)] = inst_25436);

(statearr_25572_25668[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (13))){
var inst_25383 = (state_25540[(14)]);
var inst_25400 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_25383);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25400)){
var statearr_25573_25669 = state_25540__$1;
(statearr_25573_25669[(1)] = (15));

} else {
var statearr_25574_25670 = state_25540__$1;
(statearr_25574_25670[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (22))){
var inst_25413 = (state_25540[(2)]);
var inst_25414 = fluree.db.util.async.throw_err.call(null,inst_25413);
var state_25540__$1 = state_25540;
var statearr_25575_25671 = state_25540__$1;
(statearr_25575_25671[(2)] = inst_25414);

(statearr_25575_25671[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (36))){
var inst_25384 = (state_25540[(7)]);
var inst_25421 = (state_25540[(8)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25448 = [inst_25382,inst_25421,inst_25381,inst_25384];
var inst_25449 = (new cljs.core.PersistentVector(null,4,(5),inst_25447,inst_25448,null));
var inst_25450 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_25449,opts);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(39),inst_25450);
} else {
if((state_val_25541 === (41))){
var inst_25382 = (state_25540[(9)]);
var state_25540__$1 = state_25540;
var statearr_25576_25672 = state_25540__$1;
(statearr_25576_25672[(2)] = inst_25382);

(statearr_25576_25672[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (43))){
var inst_25421 = (state_25540[(8)]);
var state_25540__$1 = state_25540;
var statearr_25577_25673 = state_25540__$1;
(statearr_25577_25673[(2)] = inst_25421);

(statearr_25577_25673[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (61))){
var inst_25421 = (state_25540[(8)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25421)){
var statearr_25578_25674 = state_25540__$1;
(statearr_25578_25674[(1)] = (64));

} else {
var statearr_25579_25675 = state_25540__$1;
(statearr_25579_25675[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (29))){
var inst_25445 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25445)){
var statearr_25580_25676 = state_25540__$1;
(statearr_25580_25676[(1)] = (36));

} else {
var statearr_25581_25677 = state_25540__$1;
(statearr_25581_25677[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (44))){
var inst_25456 = (state_25540[(19)]);
var state_25540__$1 = state_25540;
var statearr_25582_25678 = state_25540__$1;
(statearr_25582_25678[(2)] = inst_25456);

(statearr_25582_25678[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (6))){
var inst_25382 = (state_25540[(9)]);
var inst_25387 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_25382);
var inst_25388 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_25387);
var state_25540__$1 = state_25540;
var statearr_25583_25679 = state_25540__$1;
(statearr_25583_25679[(2)] = inst_25388);

(statearr_25583_25679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (28))){
var inst_25382 = (state_25540[(9)]);
var state_25540__$1 = state_25540;
var statearr_25584_25680 = state_25540__$1;
(statearr_25584_25680[(2)] = inst_25382);

(statearr_25584_25680[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (64))){
var inst_25384 = (state_25540[(7)]);
var inst_25421 = (state_25540[(8)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25511 = [inst_25421,inst_25382,inst_25381,inst_25384];
var inst_25512 = (new cljs.core.PersistentVector(null,4,(5),inst_25510,inst_25511,null));
var inst_25513 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_25512,opts);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(67),inst_25513);
} else {
if((state_val_25541 === (51))){
var inst_25382 = (state_25540[(9)]);
var inst_25472 = (state_25540[(21)]);
var inst_25471 = (state_25540[(2)]);
var inst_25472__$1 = cljs.core._EQ_.call(null,"_id",inst_25382);
var state_25540__$1 = (function (){var statearr_25585 = state_25540;
(statearr_25585[(20)] = inst_25471);

(statearr_25585[(21)] = inst_25472__$1);

return statearr_25585;
})();
if(inst_25472__$1){
var statearr_25586_25681 = state_25540__$1;
(statearr_25586_25681[(1)] = (52));

} else {
var statearr_25587_25682 = state_25540__$1;
(statearr_25587_25682[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (25))){
var inst_25391 = (state_25540[(18)]);
var inst_25527 = (state_25540[(2)]);
var state_25540__$1 = (function (){var statearr_25588 = state_25540;
(statearr_25588[(12)] = inst_25527);

return statearr_25588;
})();
if(cljs.core.truth_(inst_25391)){
var statearr_25589_25683 = state_25540__$1;
(statearr_25589_25683[(1)] = (68));

} else {
var statearr_25590_25684 = state_25540__$1;
(statearr_25590_25684[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (34))){
var inst_25385 = (state_25540[(15)]);
var state_25540__$1 = state_25540;
var statearr_25591_25685 = state_25540__$1;
(statearr_25591_25685[(2)] = inst_25385);

(statearr_25591_25685[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (17))){
var inst_25419 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25592_25686 = state_25540__$1;
(statearr_25592_25686[(2)] = inst_25419);

(statearr_25592_25686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (3))){
var inst_25538 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25540__$1,inst_25538);
} else {
if((state_val_25541 === (12))){
var inst_25383 = (state_25540[(14)]);
var state_25540__$1 = state_25540;
var statearr_25593_25687 = state_25540__$1;
(statearr_25593_25687[(2)] = inst_25383);

(statearr_25593_25687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (2))){
var inst_25380 = (state_25540[(17)]);
var inst_25382 = (state_25540[(9)]);
var _ = (function (){var statearr_25594 = state_25540;
(statearr_25594[(4)] = cljs.core.cons.call(null,(5),(state_25540[(4)])));

return statearr_25594;
})();
var inst_25380__$1 = fparts;
var inst_25381 = cljs.core.nth.call(null,inst_25380__$1,(0),null);
var inst_25382__$1 = cljs.core.nth.call(null,inst_25380__$1,(1),null);
var inst_25383 = cljs.core.nth.call(null,inst_25380__$1,(2),null);
var inst_25384 = cljs.core.nth.call(null,inst_25380__$1,(3),null);
var inst_25385 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_25382__$1);
var state_25540__$1 = (function (){var statearr_25595 = state_25540;
(statearr_25595[(7)] = inst_25384);

(statearr_25595[(14)] = inst_25383);

(statearr_25595[(15)] = inst_25385);

(statearr_25595[(17)] = inst_25380__$1);

(statearr_25595[(9)] = inst_25382__$1);

(statearr_25595[(10)] = inst_25381);

return statearr_25595;
})();
if(cljs.core.truth_(inst_25382__$1)){
var statearr_25596_25688 = state_25540__$1;
(statearr_25596_25688[(1)] = (6));

} else {
var statearr_25597_25689 = state_25540__$1;
(statearr_25597_25689[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (66))){
var inst_25519 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25598_25690 = state_25540__$1;
(statearr_25598_25690[(2)] = inst_25519);

(statearr_25598_25690[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (23))){
var inst_25384 = (state_25540[(7)]);
var inst_25421 = (state_25540[(8)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25424 = [inst_25381,inst_25382,inst_25421,inst_25384];
var inst_25425 = (new cljs.core.PersistentVector(null,4,(5),inst_25423,inst_25424,null));
var inst_25426 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_25425,opts);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(26),inst_25426);
} else {
if((state_val_25541 === (47))){
var inst_25382 = (state_25540[(9)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25382)){
var statearr_25599_25691 = state_25540__$1;
(statearr_25599_25691[(1)] = (60));

} else {
var statearr_25600_25692 = state_25540__$1;
(statearr_25600_25692[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (35))){
var inst_25439 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25601_25693 = state_25540__$1;
(statearr_25601_25693[(2)] = inst_25439);

(statearr_25601_25693[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (19))){
var inst_25383 = (state_25540[(14)]);
var inst_25382 = (state_25540[(9)]);
var inst_25409 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_25382);
var inst_25410 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25409),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25383)].join('');
var inst_25411 = fluree.db.dbproto._tag_id.call(null,db,inst_25410);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(22),inst_25411);
} else {
if((state_val_25541 === (57))){
var inst_25498 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25602_25694 = state_25540__$1;
(statearr_25602_25694[(2)] = inst_25498);

(statearr_25602_25694[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (68))){
var inst_25527 = (state_25540[(12)]);
var inst_25529 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_25527);
var state_25540__$1 = state_25540;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25540__$1,(71),inst_25529);
} else {
if((state_val_25541 === (11))){
var inst_25396 = (state_25540[(16)]);
var inst_25396__$1 = (state_25540[(2)]);
var inst_25397 = cljs.core.not.call(null,inst_25396__$1);
var state_25540__$1 = (function (){var statearr_25604 = state_25540;
(statearr_25604[(16)] = inst_25396__$1);

return statearr_25604;
})();
if(inst_25397){
var statearr_25605_25695 = state_25540__$1;
(statearr_25605_25695[(1)] = (12));

} else {
var statearr_25606_25696 = state_25540__$1;
(statearr_25606_25696[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (9))){
var inst_25383 = (state_25540[(14)]);
var inst_25393 = typeof inst_25383 === 'string';
var state_25540__$1 = state_25540;
var statearr_25607_25697 = state_25540__$1;
(statearr_25607_25697[(2)] = inst_25393);

(statearr_25607_25697[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (5))){
var _ = (function (){var statearr_25608 = state_25540;
(statearr_25608[(4)] = cljs.core.rest.call(null,(state_25540[(4)])));

return statearr_25608;
})();
var state_25540__$1 = state_25540;
var ex25603 = (state_25540__$1[(2)]);
var statearr_25609_25698 = state_25540__$1;
(statearr_25609_25698[(5)] = ex25603);


if((ex25603 instanceof Error)){
var statearr_25610_25699 = state_25540__$1;
(statearr_25610_25699[(1)] = (4));

(statearr_25610_25699[(5)] = null);

} else {
throw ex25603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (14))){
var inst_25381 = (state_25540[(10)]);
var inst_25421 = (state_25540[(2)]);
var state_25540__$1 = (function (){var statearr_25611 = state_25540;
(statearr_25611[(8)] = inst_25421);

return statearr_25611;
})();
if(cljs.core.truth_(inst_25381)){
var statearr_25612_25700 = state_25540__$1;
(statearr_25612_25700[(1)] = (23));

} else {
var statearr_25613_25701 = state_25540__$1;
(statearr_25613_25701[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (45))){
var inst_25460 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25614_25702 = state_25540__$1;
(statearr_25614_25702[(2)] = inst_25460);

(statearr_25614_25702[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (53))){
var inst_25472 = (state_25540[(21)]);
var state_25540__$1 = state_25540;
var statearr_25615_25703 = state_25540__$1;
(statearr_25615_25703[(2)] = inst_25472);

(statearr_25615_25703[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (26))){
var inst_25428 = (state_25540[(2)]);
var inst_25429 = fluree.db.util.async.throw_err.call(null,inst_25428);
var state_25540__$1 = state_25540;
var statearr_25616_25704 = state_25540__$1;
(statearr_25616_25704[(2)] = inst_25429);

(statearr_25616_25704[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (16))){
var inst_25383 = (state_25540[(14)]);
var inst_25407 = typeof inst_25383 === 'string';
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25407)){
var statearr_25617_25705 = state_25540__$1;
(statearr_25617_25705[(1)] = (19));

} else {
var statearr_25618_25706 = state_25540__$1;
(statearr_25618_25706[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (38))){
var inst_25525 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
var statearr_25619_25707 = state_25540__$1;
(statearr_25619_25707[(2)] = inst_25525);

(statearr_25619_25707[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (30))){
var inst_25385 = (state_25540[(15)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25385)){
var statearr_25620_25708 = state_25540__$1;
(statearr_25620_25708[(1)] = (33));

} else {
var statearr_25621_25709 = state_25540__$1;
(statearr_25621_25709[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (10))){
var inst_25391 = (state_25540[(18)]);
var state_25540__$1 = state_25540;
var statearr_25622_25710 = state_25540__$1;
(statearr_25622_25710[(2)] = inst_25391);

(statearr_25622_25710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (18))){
var inst_25404 = (state_25540[(2)]);
var inst_25405 = fluree.db.util.async.throw_err.call(null,inst_25404);
var state_25540__$1 = state_25540;
var statearr_25623_25711 = state_25540__$1;
(statearr_25623_25711[(2)] = inst_25405);

(statearr_25623_25711[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (52))){
var inst_25421 = (state_25540[(8)]);
var inst_25474 = cljs.core.int_QMARK_.call(null,inst_25421);
var state_25540__$1 = state_25540;
var statearr_25624_25712 = state_25540__$1;
(statearr_25624_25712[(2)] = inst_25474);

(statearr_25624_25712[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (67))){
var inst_25515 = (state_25540[(2)]);
var inst_25516 = fluree.db.util.async.throw_err.call(null,inst_25515);
var state_25540__$1 = state_25540;
var statearr_25625_25713 = state_25540__$1;
(statearr_25625_25713[(2)] = inst_25516);

(statearr_25625_25713[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (71))){
var inst_25531 = (state_25540[(2)]);
var inst_25532 = fluree.db.util.async.throw_err.call(null,inst_25531);
var state_25540__$1 = state_25540;
var statearr_25626_25714 = state_25540__$1;
(statearr_25626_25714[(2)] = inst_25532);

(statearr_25626_25714[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (42))){
var inst_25463 = (state_25540[(2)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25463)){
var statearr_25627_25715 = state_25540__$1;
(statearr_25627_25715[(1)] = (46));

} else {
var statearr_25628_25716 = state_25540__$1;
(statearr_25628_25716[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (37))){
var inst_25382 = (state_25540[(9)]);
var state_25540__$1 = state_25540;
if(cljs.core.truth_(inst_25382)){
var statearr_25629_25717 = state_25540__$1;
(statearr_25629_25717[(1)] = (40));

} else {
var statearr_25630_25718 = state_25540__$1;
(statearr_25630_25718[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (63))){
var inst_25506 = (state_25540[(2)]);
var inst_25507 = fluree.db.util.async.throw_err.call(null,inst_25506);
var state_25540__$1 = state_25540;
var statearr_25631_25719 = state_25540__$1;
(statearr_25631_25719[(2)] = inst_25507);

(statearr_25631_25719[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (8))){
var inst_25391 = (state_25540[(18)]);
var inst_25391__$1 = (state_25540[(2)]);
var state_25540__$1 = (function (){var statearr_25632 = state_25540;
(statearr_25632[(18)] = inst_25391__$1);

return statearr_25632;
})();
if(cljs.core.truth_(inst_25391__$1)){
var statearr_25633_25720 = state_25540__$1;
(statearr_25633_25720[(1)] = (9));

} else {
var statearr_25634_25721 = state_25540__$1;
(statearr_25634_25721[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25541 === (49))){
var inst_25384 = (state_25540[(7)]);
var inst_25385 = (state_25540[(15)]);
var inst_25421 = (state_25540[(8)]);
var inst_25396 = (state_25540[(16)]);
var inst_25380 = (state_25540[(17)]);
var inst_25465 = (state_25540[(13)]);
var inst_25391 = (state_25540[(18)]);
var inst_25382 = (state_25540[(9)]);
var inst_25381 = (state_25540[(10)]);
var inst_25467 = (function (){var obj_fn = inst_25465;
var t = inst_25384;
var p = inst_25382;
var idx_predicate_QMARK_ = inst_25385;
var o = inst_25421;
var tag_predicate_QMARK_ = inst_25391;
var temp__5751__auto__ = inst_25465;
var s = inst_25381;
var o_coerce_QMARK_ = inst_25396;
var vec__25377 = inst_25380;
return (function (x){
var and__4251__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_25540__$1 = state_25540;
var statearr_25635_25722 = state_25540__$1;
(statearr_25635_25722[(2)] = inst_25467);

(statearr_25635_25722[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10903__auto__ = null;
var fluree$db$query$range$state_machine__10903__auto____0 = (function (){
var statearr_25636 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25636[(0)] = fluree$db$query$range$state_machine__10903__auto__);

(statearr_25636[(1)] = (1));

return statearr_25636;
});
var fluree$db$query$range$state_machine__10903__auto____1 = (function (state_25540){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_25540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25637){var ex__10906__auto__ = e25637;
var statearr_25638_25723 = state_25540;
(statearr_25638_25723[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_25540[(4)]))){
var statearr_25639_25724 = state_25540;
(statearr_25639_25724[(1)] = cljs.core.first.call(null,(state_25540[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25725 = state_25540;
state_25540 = G__25725;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10903__auto__ = function(state_25540){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10903__auto____1.call(this,state_25540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10903__auto____0;
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10903__auto____1;
return fluree$db$query$range$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25640 = f__10977__auto__.call(null);
(statearr_25640[(6)] = c__10976__auto__);

return statearr_25640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__25727 = arguments.length;
switch (G__25727) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_25762){
var state_val_25763 = (state_25762[(1)]);
if((state_val_25763 === (7))){
var inst_25749 = cljs.core.pr_str.call(null,name);
var inst_25750 = ["Invalid collection name: ",inst_25749].join('');
var inst_25751 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25752 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_25753 = cljs.core.PersistentHashMap.fromArrays(inst_25751,inst_25752);
var inst_25754 = cljs.core.ex_info.call(null,inst_25750,inst_25753);
var inst_25755 = (function(){throw inst_25754})();
var state_25762__$1 = state_25762;
var statearr_25764_25784 = state_25762__$1;
(statearr_25764_25784[(2)] = inst_25755);

(statearr_25764_25784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (1))){
var state_25762__$1 = state_25762;
var statearr_25765_25785 = state_25762__$1;
(statearr_25765_25785[(2)] = null);

(statearr_25765_25785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (4))){
var inst_25728 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25766_25786 = state_25762__$1;
(statearr_25766_25786[(2)] = inst_25728);

(statearr_25766_25786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (6))){
var inst_25734 = (state_25762[(7)]);
var inst_25736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25737 = fluree.db.flake.max_subject_id.call(null,inst_25734);
var inst_25738 = [inst_25737];
var inst_25739 = (new cljs.core.PersistentVector(null,1,(5),inst_25736,inst_25738,null));
var inst_25740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25741 = fluree.db.flake.min_subject_id.call(null,inst_25734);
var inst_25742 = [inst_25741];
var inst_25743 = (new cljs.core.PersistentVector(null,1,(5),inst_25740,inst_25742,null));
var inst_25744 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_25739,cljs.core._LT__EQ_,inst_25743,opts);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25762__$1,(9),inst_25744);
} else {
if((state_val_25763 === (3))){
var inst_25760 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25762__$1,inst_25760);
} else {
if((state_val_25763 === (2))){
var inst_25734 = (state_25762[(7)]);
var _ = (function (){var statearr_25768 = state_25762;
(statearr_25768[(4)] = cljs.core.cons.call(null,(5),(state_25762[(4)])));

return statearr_25768;
})();
var inst_25734__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_25762__$1 = (function (){var statearr_25769 = state_25762;
(statearr_25769[(7)] = inst_25734__$1);

return statearr_25769;
})();
if(cljs.core.truth_(inst_25734__$1)){
var statearr_25770_25787 = state_25762__$1;
(statearr_25770_25787[(1)] = (6));

} else {
var statearr_25771_25788 = state_25762__$1;
(statearr_25771_25788[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (9))){
var inst_25746 = (state_25762[(2)]);
var inst_25747 = fluree.db.util.async.throw_err.call(null,inst_25746);
var state_25762__$1 = state_25762;
var statearr_25772_25789 = state_25762__$1;
(statearr_25772_25789[(2)] = inst_25747);

(statearr_25772_25789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (5))){
var _ = (function (){var statearr_25773 = state_25762;
(statearr_25773[(4)] = cljs.core.rest.call(null,(state_25762[(4)])));

return statearr_25773;
})();
var state_25762__$1 = state_25762;
var ex25767 = (state_25762__$1[(2)]);
var statearr_25774_25790 = state_25762__$1;
(statearr_25774_25790[(5)] = ex25767);


var statearr_25775_25791 = state_25762__$1;
(statearr_25775_25791[(1)] = (4));

(statearr_25775_25791[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25763 === (8))){
var inst_25757 = (state_25762[(2)]);
var _ = (function (){var statearr_25776 = state_25762;
(statearr_25776[(4)] = cljs.core.rest.call(null,(state_25762[(4)])));

return statearr_25776;
})();
var state_25762__$1 = state_25762;
var statearr_25777_25792 = state_25762__$1;
(statearr_25777_25792[(2)] = inst_25757);

(statearr_25777_25792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10903__auto__ = null;
var fluree$db$query$range$state_machine__10903__auto____0 = (function (){
var statearr_25778 = [null,null,null,null,null,null,null,null];
(statearr_25778[(0)] = fluree$db$query$range$state_machine__10903__auto__);

(statearr_25778[(1)] = (1));

return statearr_25778;
});
var fluree$db$query$range$state_machine__10903__auto____1 = (function (state_25762){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_25762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25779){var ex__10906__auto__ = e25779;
var statearr_25780_25793 = state_25762;
(statearr_25780_25793[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_25762[(4)]))){
var statearr_25781_25794 = state_25762;
(statearr_25781_25794[(1)] = cljs.core.first.call(null,(state_25762[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25795 = state_25762;
state_25762 = G__25795;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10903__auto__ = function(state_25762){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10903__auto____1.call(this,state_25762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10903__auto____0;
fluree$db$query$range$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10903__auto____1;
return fluree$db$query$range$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25782 = f__10977__auto__.call(null);
(statearr_25782[(6)] = c__10976__auto__);

return statearr_25782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__25799 = flakes;
var vec__25800 = G__25799;
var seq__25801 = cljs.core.seq.call(null,vec__25800);
var first__25802 = cljs.core.first.call(null,seq__25801);
var seq__25801__$1 = cljs.core.next.call(null,seq__25801);
var flake_SINGLEQUOTE_ = first__25802;
var r = seq__25801__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__25799__$1 = G__25799;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__25808 = G__25799__$1;
var seq__25809 = cljs.core.seq.call(null,vec__25808);
var first__25810 = cljs.core.first.call(null,seq__25809);
var seq__25809__$1 = cljs.core.next.call(null,seq__25809);
var flake_SINGLEQUOTE___$1 = first__25810;
var r__$1 = seq__25809__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e25812){var e = e25812;
return null;
}})();
var map__25811 = cmd_map;
var map__25811__$1 = cljs.core.__destructure_map.call(null,map__25811);
var type = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__25811__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__25813 = r__$1;
var G__25814 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__25799__$1 = G__25813;
result_STAR___$1 = G__25814;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__25823 = blocks;
var vec__25824 = G__25823;
var seq__25825 = cljs.core.seq.call(null,vec__25824);
var first__25826 = cljs.core.first.call(null,seq__25825);
var seq__25825__$1 = cljs.core.next.call(null,seq__25825);
var block_SINGLEQUOTE_ = first__25826;
var r = seq__25825__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__25823__$1 = G__25823;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__25831 = G__25823__$1;
var seq__25832 = cljs.core.seq.call(null,vec__25831);
var first__25833 = cljs.core.first.call(null,seq__25832);
var seq__25832__$1 = cljs.core.next.call(null,seq__25832);
var block_SINGLEQUOTE___$1 = first__25833;
var r__$1 = seq__25832__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__25834 = block_SINGLEQUOTE___$1;
var map__25834__$1 = cljs.core.__destructure_map.call(null,map__25834);
var block = cljs.core.get.call(null,map__25834__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__25834__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__25834__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25815_SHARP_){
var f = p1__25815_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25816_SHARP_){
var f = p1__25816_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25817_SHARP_){
var f = p1__25817_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,instant,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25818_SHARP_){
var f = p1__25818_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,instant,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__25819_SHARP_){
return cljs.core._EQ_.call(null,p1__25819_SHARP_.p,(106));
});})(G__25823__$1,result_STAR___$1,map__25834,map__25834__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__25831,seq__25832,first__25833,seq__25832__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__25823,vec__25824,seq__25825,first__25826,seq__25825__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__25835 = r__$1;
var G__25836 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__25823__$1 = G__25835;
result_STAR___$1 = G__25836;
continue;
}
break;
}
});
