// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.union');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
fluree.db.query.union.intersecting_keys_tuples = (function fluree$db$query$union$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.union.find_match_PLUS_row_nums = (function fluree$db$query$union$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__28904_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__28904_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__28907,row,b_tuple){
var vec__28908 = p__28907;
var acc = cljs.core.nth.call(null,vec__28908,(0),null);
var b_rows = cljs.core.nth.call(null,vec__28908,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__28905_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28905_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__28906_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__28906_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
/**
 * Pads n columns with nil values on either left or right hand side of tuples
 */
fluree.db.query.union.nil_pad_tuples = (function fluree$db$query$union$nil_pad_tuples(tuples,pad_n,side){
var pad_seq = cljs.core.repeat.call(null,cljs.core.take.call(null,pad_n,cljs.core.repeat.call(null,null)));
return cljs.core.doall.call(null,(function (){var G__28911 = side;
var G__28911__$1 = (((G__28911 instanceof cljs.core.Keyword))?G__28911.fqn:null);
switch (G__28911__$1) {
case "right":
return cljs.core.map.call(null,cljs.core.concat,tuples,pad_seq);

break;
case "left":
return cljs.core.map.call(null,cljs.core.concat,pad_seq,tuples);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28911__$1)].join('')));

}
})());
});
/**
 * Non-intersecting means there are no common variable bindings between the two tuples.
 *   The result of this operation can be quite fast as it is just a concatenation of all results with
 *   null values all columns that are not in each result set respectively.
 */
fluree.db.query.union.non_intersecting = (function fluree$db$query$union$non_intersecting(a_tuples,b_tuples){
var a_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples);
var b_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
var c_tuples = cljs.core.concat.call(null,fluree.db.query.union.nil_pad_tuples.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.count.call(null,b_headers),new cljs.core.Keyword(null,"right","right",-452581833)),fluree.db.query.union.nil_pad_tuples.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),cljs.core.count.call(null,a_headers),new cljs.core.Keyword(null,"left","left",-399115937)));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.concat.call(null,a_headers,b_headers),new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * Returns a list containing the tuple-index for each provided subset header based on tuple headers.
 *   i.e. if the tuple headers are (?x ?y ?z ?c) and the subset headers given is (?c ?y), it will
 *   return (3 1) as the respective index points for those tuples.
 */
fluree.db.query.union.tuple_positions = (function fluree$db$query$union$tuple_positions(all_headers,subset_headers){
return cljs.core.map.call(null,(function (p1__28913_SHARP_){
return fluree.db.util.core.index_of.call(null,all_headers,p1__28913_SHARP_);
}),subset_headers);
});
/**
 * Case where every variable is intersecting in union of two tuple sets.
 */
fluree.db.query.union.all_intersecting = (function fluree$db$query$union$all_intersecting(a_tuples,b_tuples){
var a_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples);
var b_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
var a_data = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples);
var b_data = ((cljs.core._EQ_.call(null,a_headers,b_headers))?new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples):(function (){var positions = fluree.db.query.union.tuple_positions.call(null,b_headers,a_headers);
return cljs.core.map.call(null,(function (p1__28914_SHARP_){
return cljs.core.map.call(null,(function (i){
return cljs.core.get.call(null,p1__28914_SHARP_,i);
}),positions);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples));
})());
var b_pos_map = cljs.core.apply.call(null,cljs.core.hash_map,cljs.core.interleave.call(null,b_data,cljs.core.range.call(null)));
var c_data = (function (){var a_items = a_data;
var b_pos_map_STAR_ = b_pos_map;
while(true){
if(cljs.core.empty_QMARK_.call(null,a_items)){
return cljs.core.concat.call(null,a_data,cljs.core.keys.call(null,cljs.core.sort_by.call(null,cljs.core.val,b_pos_map_STAR_)));
} else {
var G__28915 = cljs.core.rest.call(null,a_items);
var G__28916 = cljs.core.dissoc.call(null,b_pos_map_STAR_,cljs.core.first.call(null,a_items));
a_items = G__28915;
b_pos_map_STAR_ = G__28916;
continue;
}
break;
}
})();
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),a_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_data], null);
});
/**
 * For situation where just some variables in a union intersect between the a-tuples and b-tuples,
 *   creates a map of b-tuples where key is intersecting variables for fast lookup, and value is a
 *   *list* of map(s) of original tuple along with :idx which is the original order (row number) of b-tuples
 *   to ensure consistent ordering.
 * 
 *   There can be multiple matches in b-tuples for a key, as the other non-matching variables differ.
 * 
 *   Matches between a-tuples and b-tuples will remove entries from this map and merge results, entries
 *   remaining in this map will be items in b-tuples that did not match a-tuples.
 */
fluree.db.query.union.b_data_map = (function fluree$db$query$union$b_data_map(b_common_idx,b_data){
var b_data_STAR_ = b_data;
var i = (0);
var acc = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(cljs.core.empty_QMARK_.call(null,b_data_STAR_)){
return acc;
} else {
var tuple = cljs.core.vec.call(null,cljs.core.first.call(null,b_data_STAR_));
var common = cljs.core.map.call(null,((function (b_data_STAR_,i,acc,tuple){
return (function (p1__28917_SHARP_){
return cljs.core.get.call(null,tuple,p1__28917_SHARP_);
});})(b_data_STAR_,i,acc,tuple))
,b_common_idx);
var G__28918 = cljs.core.rest.call(null,b_data_STAR_);
var G__28919 = (i + (1));
var G__28920 = cljs.core.update.call(null,acc,common,cljs.core.conj,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"idx","idx",1053688473),i,new cljs.core.Keyword(null,"tuple","tuple",-472667284),tuple], null));
b_data_STAR_ = G__28918;
i = G__28919;
acc = G__28920;
continue;
}
break;
}
});
/**
 * Takes a b-data map as per above and re-flattens it into a list of tuples in the original order.
 * 
 *   This is used after removing matching entries in b-data-map, so this will often end up being a subset
 *   of the original b-data-map.
 */
fluree.db.query.union.flatten_b_data_map = (function fluree$db$query$union$flatten_b_data_map(b_data_map){
return cljs.core.map.call(null,new cljs.core.Keyword(null,"tuple","tuple",-472667284),cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"idx","idx",1053688473),cljs.core.apply.call(null,cljs.core.concat,cljs.core.vals.call(null,b_data_map))));
});
/**
 * With common-headers already calculated, takes a list of headers and returns a
 * 3-tuple of:
 *  - common indexes, i.e (3, 1)
 *  - not common indexes, i.e. (0, 2)
 *  - not common headers, i.e. (?x, ?y)
 */
fluree.db.query.union.intersecting = (function fluree$db$query$union$intersecting(common_headers,headers){
var common_key_QMARK_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,common_headers);
var not_common = cljs.core.filter.call(null,(function (p1__28921_SHARP_){
return cljs.core.not.call(null,common_key_QMARK_.call(null,p1__28921_SHARP_));
}),headers);
var common_idx = fluree.db.query.union.tuple_positions.call(null,headers,common_headers);
var not_common_idx = fluree.db.query.union.tuple_positions.call(null,headers,not_common);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [common_idx,not_common_idx,not_common], null);
});
/**
 * B-tuples that do not match and get merged with an a-tuple must be concatenated to the
 *   list in the order of the combined tuple headers. This will take a list of b-tuples and
 *   put nil values into all columns that are unique to a.
 * 
 *   If a-headers were [?x ?y ?z] and b-headers were [?y ?a ?b] the combined headers will be:
 *   [?x ?y ?z ?a ?b]
 * 
 *   Because these are b-only values, ?x and ?z will always be nil.
 *   If we have a b-tuple of [42 36 49] we'd want a final result of [nil 42 nil 36 49]
 */
fluree.db.query.union.pad_b_tuples = (function fluree$db$query$union$pad_b_tuples(b_tuples,a_headers,a_common_idx,b_common_idx,b_only_idx){
var a_nil_pad = cljs.core.vec.call(null,cljs.core.repeat.call(null,cljs.core.count.call(null,a_headers),null));
var a__GT_b_positions = cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,a_common_idx,b_common_idx));
return cljs.core.map.call(null,(function (b_tuple){
var a_headers_merged = cljs.core.reduce.call(null,(function (acc,p__28923){
var vec__28924 = p__28923;
var a_idx = cljs.core.nth.call(null,vec__28924,(0),null);
var b_idx = cljs.core.nth.call(null,vec__28924,(1),null);
return cljs.core.assoc.call(null,acc,a_idx,cljs.core.get.call(null,b_tuple,b_idx));
}),a_nil_pad,a__GT_b_positions);
return cljs.core.concat.call(null,a_headers_merged,cljs.core.map.call(null,(function (p1__28922_SHARP_){
return cljs.core.get.call(null,b_tuple,p1__28922_SHARP_);
}),b_only_idx));
}),b_tuples);
});
/**
 * Some headers from a and/or b tuples intersect. Need to build out all columns.
 *   Where common values exist for intersecting headers, merge into more complete rows.
 *   Otherwise pad superset of headers as results with nil values for both a and b as
 *   applicable.
 */
fluree.db.query.union.some_intersecting = (function fluree$db$query$union$some_intersecting(common_headers,a_tuples,b_tuples){
var a_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples);
var b_headers = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
var a_data = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples);
var b_data = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples);
var a_common_idx = cljs.core.map.call(null,(function (p1__28927_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__28927_SHARP_);
}),common_headers);
var vec__28930 = fluree.db.query.union.intersecting.call(null,common_headers,b_headers);
var b_common_idx = cljs.core.nth.call(null,vec__28930,(0),null);
var b_only_idx = cljs.core.nth.call(null,vec__28930,(1),null);
var b_only_headers = cljs.core.nth.call(null,vec__28930,(2),null);
var b_pos_map = fluree.db.query.union.b_data_map.call(null,b_common_idx,b_data);
var b_nil_pad = cljs.core.repeat.call(null,cljs.core.count.call(null,b_only_headers),null);
var c_data = (function (){var a_data_STAR_ = a_data;
var b_pos_map_STAR_ = b_pos_map;
var acc = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.empty_QMARK_.call(null,a_data_STAR_)){
return cljs.core.concat.call(null,acc,fluree.db.query.union.pad_b_tuples.call(null,fluree.db.query.union.flatten_b_data_map.call(null,b_pos_map_STAR_),a_headers,a_common_idx,b_common_idx,b_only_idx));
} else {
var a_item = cljs.core.vec.call(null,cljs.core.first.call(null,a_data_STAR_));
var match_key = cljs.core.map.call(null,((function (a_data_STAR_,b_pos_map_STAR_,acc,a_item,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad){
return (function (p1__28928_SHARP_){
return cljs.core.get.call(null,a_item,p1__28928_SHARP_);
});})(a_data_STAR_,b_pos_map_STAR_,acc,a_item,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad))
,a_common_idx);
var temp__5751__auto__ = cljs.core.get.call(null,b_pos_map_STAR_,match_key);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matches = temp__5751__auto__;
var G__28933 = cljs.core.rest.call(null,a_data_STAR_);
var G__28934 = cljs.core.dissoc.call(null,b_pos_map_STAR_,match_key);
var G__28935 = cljs.core.reduce.call(null,((function (a_data_STAR_,b_pos_map_STAR_,acc,b_matches,temp__5751__auto__,a_item,match_key,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad){
return (function (acc_STAR_,b_match){
return cljs.core.conj.call(null,acc_STAR_,cljs.core.concat.call(null,a_item,cljs.core.map.call(null,((function (a_data_STAR_,b_pos_map_STAR_,acc,b_matches,temp__5751__auto__,a_item,match_key,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad){
return (function (p1__28929_SHARP_){
return cljs.core.get.call(null,new cljs.core.Keyword(null,"tuple","tuple",-472667284).cljs$core$IFn$_invoke$arity$1(b_match),p1__28929_SHARP_);
});})(a_data_STAR_,b_pos_map_STAR_,acc,b_matches,temp__5751__auto__,a_item,match_key,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad))
,b_only_idx)));
});})(a_data_STAR_,b_pos_map_STAR_,acc,b_matches,temp__5751__auto__,a_item,match_key,a_headers,b_headers,a_data,b_data,a_common_idx,vec__28930,b_common_idx,b_only_idx,b_only_headers,b_pos_map,b_nil_pad))
,acc,b_matches);
a_data_STAR_ = G__28933;
b_pos_map_STAR_ = G__28934;
acc = G__28935;
continue;
} else {
var G__28936 = cljs.core.rest.call(null,a_data_STAR_);
var G__28937 = b_pos_map_STAR_;
var G__28938 = cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_item,b_nil_pad));
a_data_STAR_ = G__28936;
b_pos_map_STAR_ = G__28937;
acc = G__28938;
continue;
}
}
break;
}
})();
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.concat.call(null,a_headers,b_only_headers),new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_data], null);
});
/**
 * Returns union (outer join) results of two statements.
 */
fluree.db.query.union.results = (function fluree$db$query$union$results(a_tuples,b_tuples){
var common_keys = fluree.db.query.union.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var intersections = (((cljs.core.count.call(null,common_keys) === (0)))?new cljs.core.Keyword(null,"none","none",1333468478):((cljs.core._EQ_.call(null,cljs.core.count.call(null,common_keys),cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples)),cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples))))?new cljs.core.Keyword(null,"all","all",892129742):new cljs.core.Keyword(null,"some","some",-1951079573)
));
var G__28939 = intersections;
var G__28939__$1 = (((G__28939 instanceof cljs.core.Keyword))?G__28939.fqn:null);
switch (G__28939__$1) {
case "none":
return fluree.db.query.union.non_intersecting.call(null,a_tuples,b_tuples);

break;
case "all":
return fluree.db.query.union.all_intersecting.call(null,a_tuples,b_tuples);

break;
case "some":
return fluree.db.query.union.some_intersecting.call(null,common_keys,a_tuples,b_tuples);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28939__$1)].join('')));

}
});
