// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27242){
var state_val_27243 = (state_27242[(1)]);
if((state_val_27243 === (7))){
var inst_27231 = (state_27242[(7)]);
var inst_27233 = fluree.db.storage.core.serde.call(null,conn);
var inst_27234 = fluree.db.serde.protocol._deserialize_block.call(null,inst_27233,inst_27231);
var state_27242__$1 = state_27242;
var statearr_27244_27263 = state_27242__$1;
(statearr_27244_27263[(2)] = inst_27234);

(statearr_27244_27263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (1))){
var state_27242__$1 = state_27242;
var statearr_27245_27264 = state_27242__$1;
(statearr_27245_27264[(2)] = null);

(statearr_27245_27264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (4))){
var inst_27221 = (state_27242[(2)]);
var state_27242__$1 = state_27242;
var statearr_27246_27265 = state_27242__$1;
(statearr_27246_27265[(2)] = inst_27221);

(statearr_27246_27265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (6))){
var inst_27231 = (state_27242[(7)]);
var inst_27230 = (state_27242[(2)]);
var inst_27231__$1 = fluree.db.util.async.throw_err.call(null,inst_27230);
var state_27242__$1 = (function (){var statearr_27247 = state_27242;
(statearr_27247[(7)] = inst_27231__$1);

return statearr_27247;
})();
if(cljs.core.truth_(inst_27231__$1)){
var statearr_27248_27266 = state_27242__$1;
(statearr_27248_27266[(1)] = (7));

} else {
var statearr_27249_27267 = state_27242__$1;
(statearr_27249_27267[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (3))){
var inst_27240 = (state_27242[(2)]);
var state_27242__$1 = state_27242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27242__$1,inst_27240);
} else {
if((state_val_27243 === (2))){
var _ = (function (){var statearr_27251 = state_27242;
(statearr_27251[(4)] = cljs.core.cons.call(null,(5),(state_27242[(4)])));

return statearr_27251;
})();
var inst_27227 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_27228 = fluree.db.storage.core.storage_read.call(null,conn,inst_27227);
var state_27242__$1 = state_27242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27242__$1,(6),inst_27228);
} else {
if((state_val_27243 === (9))){
var inst_27237 = (state_27242[(2)]);
var _ = (function (){var statearr_27252 = state_27242;
(statearr_27252[(4)] = cljs.core.rest.call(null,(state_27242[(4)])));

return statearr_27252;
})();
var state_27242__$1 = state_27242;
var statearr_27253_27268 = state_27242__$1;
(statearr_27253_27268[(2)] = inst_27237);

(statearr_27253_27268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (5))){
var _ = (function (){var statearr_27254 = state_27242;
(statearr_27254[(4)] = cljs.core.rest.call(null,(state_27242[(4)])));

return statearr_27254;
})();
var state_27242__$1 = state_27242;
var ex27250 = (state_27242__$1[(2)]);
var statearr_27255_27269 = state_27242__$1;
(statearr_27255_27269[(5)] = ex27250);


if((ex27250 instanceof Error)){
var statearr_27256_27270 = state_27242__$1;
(statearr_27256_27270[(1)] = (4));

(statearr_27256_27270[(5)] = null);

} else {
throw ex27250;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27243 === (8))){
var state_27242__$1 = state_27242;
var statearr_27257_27271 = state_27242__$1;
(statearr_27257_27271[(2)] = null);

(statearr_27257_27271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__10903__auto____0 = (function (){
var statearr_27258 = [null,null,null,null,null,null,null,null];
(statearr_27258[(0)] = fluree$db$storage$core$read_block_$_state_machine__10903__auto__);

(statearr_27258[(1)] = (1));

return statearr_27258;
});
var fluree$db$storage$core$read_block_$_state_machine__10903__auto____1 = (function (state_27242){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27259){var ex__10906__auto__ = e27259;
var statearr_27260_27272 = state_27242;
(statearr_27260_27272[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27242[(4)]))){
var statearr_27261_27273 = state_27242;
(statearr_27261_27273[(1)] = cljs.core.first.call(null,(state_27242[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27274 = state_27242;
state_27242 = G__27274;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__10903__auto__ = function(state_27242){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__10903__auto____1.call(this,state_27242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27262 = f__10977__auto__.call(null);
(statearr_27262[(6)] = c__10976__auto__);

return statearr_27262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27297){
var state_val_27298 = (state_27297[(1)]);
if((state_val_27298 === (7))){
var inst_27286 = (state_27297[(7)]);
var inst_27288 = fluree.db.storage.core.serde.call(null,conn);
var inst_27289 = fluree.db.serde.protocol._deserialize_block.call(null,inst_27288,inst_27286);
var state_27297__$1 = state_27297;
var statearr_27299_27318 = state_27297__$1;
(statearr_27299_27318[(2)] = inst_27289);

(statearr_27299_27318[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (1))){
var state_27297__$1 = state_27297;
var statearr_27300_27319 = state_27297__$1;
(statearr_27300_27319[(2)] = null);

(statearr_27300_27319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (4))){
var inst_27275 = (state_27297[(2)]);
var state_27297__$1 = state_27297;
var statearr_27301_27320 = state_27297__$1;
(statearr_27301_27320[(2)] = inst_27275);

(statearr_27301_27320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (6))){
var inst_27286 = (state_27297[(7)]);
var inst_27285 = (state_27297[(2)]);
var inst_27286__$1 = fluree.db.util.async.throw_err.call(null,inst_27285);
var state_27297__$1 = (function (){var statearr_27302 = state_27297;
(statearr_27302[(7)] = inst_27286__$1);

return statearr_27302;
})();
if(cljs.core.truth_(inst_27286__$1)){
var statearr_27303_27321 = state_27297__$1;
(statearr_27303_27321[(1)] = (7));

} else {
var statearr_27304_27322 = state_27297__$1;
(statearr_27304_27322[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (3))){
var inst_27295 = (state_27297[(2)]);
var state_27297__$1 = state_27297;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27297__$1,inst_27295);
} else {
if((state_val_27298 === (2))){
var _ = (function (){var statearr_27306 = state_27297;
(statearr_27306[(4)] = cljs.core.cons.call(null,(5),(state_27297[(4)])));

return statearr_27306;
})();
var inst_27281 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_27282 = [inst_27281,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_27283 = fluree.db.storage.core.storage_read.call(null,conn,inst_27282);
var state_27297__$1 = state_27297;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27297__$1,(6),inst_27283);
} else {
if((state_val_27298 === (9))){
var inst_27292 = (state_27297[(2)]);
var _ = (function (){var statearr_27307 = state_27297;
(statearr_27307[(4)] = cljs.core.rest.call(null,(state_27297[(4)])));

return statearr_27307;
})();
var state_27297__$1 = state_27297;
var statearr_27308_27323 = state_27297__$1;
(statearr_27308_27323[(2)] = inst_27292);

(statearr_27308_27323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (5))){
var _ = (function (){var statearr_27309 = state_27297;
(statearr_27309[(4)] = cljs.core.rest.call(null,(state_27297[(4)])));

return statearr_27309;
})();
var state_27297__$1 = state_27297;
var ex27305 = (state_27297__$1[(2)]);
var statearr_27310_27324 = state_27297__$1;
(statearr_27310_27324[(5)] = ex27305);


if((ex27305 instanceof Error)){
var statearr_27311_27325 = state_27297__$1;
(statearr_27311_27325[(1)] = (4));

(statearr_27311_27325[(5)] = null);

} else {
throw ex27305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27298 === (8))){
var state_27297__$1 = state_27297;
var statearr_27312_27326 = state_27297__$1;
(statearr_27312_27326[(2)] = null);

(statearr_27312_27326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____0 = (function (){
var statearr_27313 = [null,null,null,null,null,null,null,null];
(statearr_27313[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__);

(statearr_27313[(1)] = (1));

return statearr_27313;
});
var fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____1 = (function (state_27297){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27297);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27314){var ex__10906__auto__ = e27314;
var statearr_27315_27327 = state_27297;
(statearr_27315_27327[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27297[(4)]))){
var statearr_27316_27328 = state_27297;
(statearr_27316_27328[(1)] = cljs.core.first.call(null,(state_27297[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27329 = state_27297;
state_27297 = G__27329;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__ = function(state_27297){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____1.call(this,state_27297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27317 = f__10977__auto__.call(null);
(statearr_27317[(6)] = c__10976__auto__);

return statearr_27317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27353){
var state_val_27354 = (state_27353[(1)]);
if((state_val_27354 === (1))){
var state_27353__$1 = state_27353;
var statearr_27355_27369 = state_27353__$1;
(statearr_27355_27369[(2)] = null);

(statearr_27355_27369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27354 === (2))){
var _ = (function (){var statearr_27356 = state_27353;
(statearr_27356[(4)] = cljs.core.cons.call(null,(5),(state_27353[(4)])));

return statearr_27356;
})();
var inst_27336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27337 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27338 = (new cljs.core.PersistentVector(null,3,(5),inst_27336,inst_27337,null));
var inst_27339 = cljs.core.select_keys.call(null,block_data,inst_27338);
var inst_27340 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27339);
var inst_27341 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_27340);
var inst_27342 = [inst_27341,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_27343 = fluree.db.storage.core.serde.call(null,conn);
var inst_27344 = fluree.db.serde.protocol._serialize_block.call(null,inst_27343,inst_27339);
var inst_27345 = fluree.db.storage.core.storage_write.call(null,conn,inst_27342,inst_27344);
var state_27353__$1 = state_27353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27353__$1,(6),inst_27345);
} else {
if((state_val_27354 === (3))){
var inst_27351 = (state_27353[(2)]);
var state_27353__$1 = state_27353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27353__$1,inst_27351);
} else {
if((state_val_27354 === (4))){
var inst_27330 = (state_27353[(2)]);
var state_27353__$1 = state_27353;
var statearr_27358_27370 = state_27353__$1;
(statearr_27358_27370[(2)] = inst_27330);

(statearr_27358_27370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27354 === (5))){
var _ = (function (){var statearr_27359 = state_27353;
(statearr_27359[(4)] = cljs.core.rest.call(null,(state_27353[(4)])));

return statearr_27359;
})();
var state_27353__$1 = state_27353;
var ex27357 = (state_27353__$1[(2)]);
var statearr_27360_27371 = state_27353__$1;
(statearr_27360_27371[(5)] = ex27357);


if((ex27357 instanceof Error)){
var statearr_27361_27372 = state_27353__$1;
(statearr_27361_27372[(1)] = (4));

(statearr_27361_27372[(5)] = null);

} else {
throw ex27357;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27354 === (6))){
var inst_27347 = (state_27353[(2)]);
var inst_27348 = fluree.db.util.async.throw_err.call(null,inst_27347);
var _ = (function (){var statearr_27362 = state_27353;
(statearr_27362[(4)] = cljs.core.rest.call(null,(state_27353[(4)])));

return statearr_27362;
})();
var state_27353__$1 = state_27353;
var statearr_27363_27373 = state_27353__$1;
(statearr_27363_27373[(2)] = inst_27348);

(statearr_27363_27373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____0 = (function (){
var statearr_27364 = [null,null,null,null,null,null,null];
(statearr_27364[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__);

(statearr_27364[(1)] = (1));

return statearr_27364;
});
var fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____1 = (function (state_27353){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27365){var ex__10906__auto__ = e27365;
var statearr_27366_27374 = state_27353;
(statearr_27366_27374[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27353[(4)]))){
var statearr_27367_27375 = state_27353;
(statearr_27367_27375[(1)] = cljs.core.first.call(null,(state_27353[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27376 = state_27353;
state_27353 = G__27376;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__ = function(state_27353){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____1.call(this,state_27353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27368 = f__10977__auto__.call(null);
(statearr_27368[(6)] = c__10976__auto__);

return statearr_27368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27399){
var state_val_27400 = (state_27399[(1)]);
if((state_val_27400 === (1))){
var state_27399__$1 = state_27399;
var statearr_27401_27415 = state_27399__$1;
(statearr_27401_27415[(2)] = null);

(statearr_27401_27415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27400 === (2))){
var _ = (function (){var statearr_27402 = state_27399;
(statearr_27402[(4)] = cljs.core.cons.call(null,(5),(state_27399[(4)])));

return statearr_27402;
})();
var inst_27383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27384 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27385 = (new cljs.core.PersistentVector(null,3,(5),inst_27383,inst_27384,null));
var inst_27386 = cljs.core.select_keys.call(null,block_data,inst_27385);
var inst_27387 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27386);
var inst_27388 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_27387);
var inst_27389 = fluree.db.storage.core.serde.call(null,conn);
var inst_27390 = fluree.db.serde.protocol._serialize_block.call(null,inst_27389,inst_27386);
var inst_27391 = fluree.db.storage.core.storage_write.call(null,conn,inst_27388,inst_27390);
var state_27399__$1 = state_27399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27399__$1,(6),inst_27391);
} else {
if((state_val_27400 === (3))){
var inst_27397 = (state_27399[(2)]);
var state_27399__$1 = state_27399;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27399__$1,inst_27397);
} else {
if((state_val_27400 === (4))){
var inst_27377 = (state_27399[(2)]);
var state_27399__$1 = state_27399;
var statearr_27404_27416 = state_27399__$1;
(statearr_27404_27416[(2)] = inst_27377);

(statearr_27404_27416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27400 === (5))){
var _ = (function (){var statearr_27405 = state_27399;
(statearr_27405[(4)] = cljs.core.rest.call(null,(state_27399[(4)])));

return statearr_27405;
})();
var state_27399__$1 = state_27399;
var ex27403 = (state_27399__$1[(2)]);
var statearr_27406_27417 = state_27399__$1;
(statearr_27406_27417[(5)] = ex27403);


if((ex27403 instanceof Error)){
var statearr_27407_27418 = state_27399__$1;
(statearr_27407_27418[(1)] = (4));

(statearr_27407_27418[(5)] = null);

} else {
throw ex27403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27400 === (6))){
var inst_27393 = (state_27399[(2)]);
var inst_27394 = fluree.db.util.async.throw_err.call(null,inst_27393);
var _ = (function (){var statearr_27408 = state_27399;
(statearr_27408[(4)] = cljs.core.rest.call(null,(state_27399[(4)])));

return statearr_27408;
})();
var state_27399__$1 = state_27399;
var statearr_27409_27419 = state_27399__$1;
(statearr_27409_27419[(2)] = inst_27394);

(statearr_27409_27419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__10903__auto____0 = (function (){
var statearr_27410 = [null,null,null,null,null,null,null];
(statearr_27410[(0)] = fluree$db$storage$core$write_block_$_state_machine__10903__auto__);

(statearr_27410[(1)] = (1));

return statearr_27410;
});
var fluree$db$storage$core$write_block_$_state_machine__10903__auto____1 = (function (state_27399){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27399);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27411){var ex__10906__auto__ = e27411;
var statearr_27412_27420 = state_27399;
(statearr_27412_27420[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27399[(4)]))){
var statearr_27413_27421 = state_27399;
(statearr_27413_27421[(1)] = cljs.core.first.call(null,(state_27399[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27422 = state_27399;
state_27399 = G__27422;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__10903__auto__ = function(state_27399){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__10903__auto____1.call(this,state_27399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27414 = f__10977__auto__.call(null);
(statearr_27414[(6)] = c__10976__auto__);

return statearr_27414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27442){
var state_val_27443 = (state_27442[(1)]);
if((state_val_27443 === (1))){
var state_27442__$1 = state_27442;
var statearr_27444_27458 = state_27442__$1;
(statearr_27444_27458[(2)] = null);

(statearr_27444_27458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27443 === (2))){
var _ = (function (){var statearr_27445 = state_27442;
(statearr_27445[(4)] = cljs.core.cons.call(null,(5),(state_27442[(4)])));

return statearr_27445;
})();
var inst_27429 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_27430 = [history,next_his_key];
var inst_27431 = cljs.core.PersistentHashMap.fromArrays(inst_27429,inst_27430);
var inst_27432 = fluree.db.storage.core.serde.call(null,conn);
var inst_27433 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_27432,inst_27431);
var inst_27434 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_27433);
var state_27442__$1 = state_27442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27442__$1,(6),inst_27434);
} else {
if((state_val_27443 === (3))){
var inst_27440 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27442__$1,inst_27440);
} else {
if((state_val_27443 === (4))){
var inst_27423 = (state_27442[(2)]);
var state_27442__$1 = state_27442;
var statearr_27447_27459 = state_27442__$1;
(statearr_27447_27459[(2)] = inst_27423);

(statearr_27447_27459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27443 === (5))){
var _ = (function (){var statearr_27448 = state_27442;
(statearr_27448[(4)] = cljs.core.rest.call(null,(state_27442[(4)])));

return statearr_27448;
})();
var state_27442__$1 = state_27442;
var ex27446 = (state_27442__$1[(2)]);
var statearr_27449_27460 = state_27442__$1;
(statearr_27449_27460[(5)] = ex27446);


if((ex27446 instanceof Error)){
var statearr_27450_27461 = state_27442__$1;
(statearr_27450_27461[(1)] = (4));

(statearr_27450_27461[(5)] = null);

} else {
throw ex27446;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27443 === (6))){
var inst_27436 = (state_27442[(2)]);
var inst_27437 = fluree.db.util.async.throw_err.call(null,inst_27436);
var _ = (function (){var statearr_27451 = state_27442;
(statearr_27451[(4)] = cljs.core.rest.call(null,(state_27442[(4)])));

return statearr_27451;
})();
var state_27442__$1 = state_27442;
var statearr_27452_27462 = state_27442__$1;
(statearr_27452_27462[(2)] = inst_27437);

(statearr_27452_27462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__10903__auto____0 = (function (){
var statearr_27453 = [null,null,null,null,null,null,null];
(statearr_27453[(0)] = fluree$db$storage$core$write_history_$_state_machine__10903__auto__);

(statearr_27453[(1)] = (1));

return statearr_27453;
});
var fluree$db$storage$core$write_history_$_state_machine__10903__auto____1 = (function (state_27442){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27454){var ex__10906__auto__ = e27454;
var statearr_27455_27463 = state_27442;
(statearr_27455_27463[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27442[(4)]))){
var statearr_27456_27464 = state_27442;
(statearr_27456_27464[(1)] = cljs.core.first.call(null,(state_27442[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27465 = state_27442;
state_27442 = G__27465;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__10903__auto__ = function(state_27442){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__10903__auto____1.call(this,state_27442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_history_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27457 = f__10977__auto__.call(null);
(statearr_27457[(6)] = c__10976__auto__);

return statearr_27457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27491){
var state_val_27492 = (state_27491[(1)]);
if((state_val_27492 === (1))){
var state_27491__$1 = state_27491;
var statearr_27493_27510 = state_27491__$1;
(statearr_27493_27510[(2)] = null);

(statearr_27493_27510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27492 === (2))){
var inst_27472 = (state_27491[(7)]);
var _ = (function (){var statearr_27494 = state_27491;
(statearr_27494[(4)] = cljs.core.cons.call(null,(5),(state_27491[(4)])));

return statearr_27494;
})();
var inst_27472__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_27473 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27472__$1),"-his"].join('');
var inst_27474 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_27475 = [flakes,inst_27473];
var inst_27476 = cljs.core.PersistentHashMap.fromArrays(inst_27474,inst_27475);
var inst_27477 = fluree.db.storage.core.serde.call(null,conn);
var inst_27478 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_27477,inst_27476);
var inst_27479 = fluree.db.storage.core.write_history.call(null,conn,history,inst_27473,null);
var inst_27480 = fluree.db.storage.core.storage_write.call(null,conn,inst_27472__$1,inst_27478);
var state_27491__$1 = (function (){var statearr_27495 = state_27491;
(statearr_27495[(8)] = inst_27480);

(statearr_27495[(7)] = inst_27472__$1);

return statearr_27495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27491__$1,(6),inst_27479);
} else {
if((state_val_27492 === (3))){
var inst_27489 = (state_27491[(2)]);
var state_27491__$1 = state_27491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27491__$1,inst_27489);
} else {
if((state_val_27492 === (4))){
var inst_27466 = (state_27491[(2)]);
var state_27491__$1 = state_27491;
var statearr_27497_27511 = state_27491__$1;
(statearr_27497_27511[(2)] = inst_27466);

(statearr_27497_27511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27492 === (5))){
var _ = (function (){var statearr_27498 = state_27491;
(statearr_27498[(4)] = cljs.core.rest.call(null,(state_27491[(4)])));

return statearr_27498;
})();
var state_27491__$1 = state_27491;
var ex27496 = (state_27491__$1[(2)]);
var statearr_27499_27512 = state_27491__$1;
(statearr_27499_27512[(5)] = ex27496);


if((ex27496 instanceof Error)){
var statearr_27500_27513 = state_27491__$1;
(statearr_27500_27513[(1)] = (4));

(statearr_27500_27513[(5)] = null);

} else {
throw ex27496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27492 === (6))){
var inst_27480 = (state_27491[(8)]);
var inst_27482 = (state_27491[(2)]);
var inst_27483 = fluree.db.util.async.throw_err.call(null,inst_27482);
var state_27491__$1 = (function (){var statearr_27501 = state_27491;
(statearr_27501[(9)] = inst_27483);

return statearr_27501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27491__$1,(7),inst_27480);
} else {
if((state_val_27492 === (7))){
var inst_27472 = (state_27491[(7)]);
var inst_27485 = (state_27491[(2)]);
var inst_27486 = fluree.db.util.async.throw_err.call(null,inst_27485);
var _ = (function (){var statearr_27502 = state_27491;
(statearr_27502[(4)] = cljs.core.rest.call(null,(state_27491[(4)])));

return statearr_27502;
})();
var state_27491__$1 = (function (){var statearr_27503 = state_27491;
(statearr_27503[(10)] = inst_27486);

return statearr_27503;
})();
var statearr_27504_27514 = state_27491__$1;
(statearr_27504_27514[(2)] = inst_27472);

(statearr_27504_27514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____0 = (function (){
var statearr_27505 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27505[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__);

(statearr_27505[(1)] = (1));

return statearr_27505;
});
var fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____1 = (function (state_27491){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27506){var ex__10906__auto__ = e27506;
var statearr_27507_27515 = state_27491;
(statearr_27507_27515[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27491[(4)]))){
var statearr_27508_27516 = state_27491;
(statearr_27508_27516[(1)] = cljs.core.first.call(null,(state_27491[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27517 = state_27491;
state_27491 = G__27517;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__ = function(state_27491){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____1.call(this,state_27491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27509 = f__10977__auto__.call(null);
(statearr_27509[(6)] = c__10976__auto__);

return statearr_27509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27534){
var state_val_27535 = (state_27534[(1)]);
if((state_val_27535 === (1))){
var state_27534__$1 = state_27534;
var statearr_27536_27551 = state_27534__$1;
(statearr_27536_27551[(2)] = null);

(statearr_27536_27551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (2))){
var _ = (function (){var statearr_27537 = state_27534;
(statearr_27537[(4)] = cljs.core.cons.call(null,(5),(state_27534[(4)])));

return statearr_27537;
})();
var inst_27524 = fluree.db.storage.core.serde.call(null,conn);
var inst_27525 = fluree.db.serde.protocol._serialize_branch.call(null,inst_27524,data);
var inst_27526 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_27525);
var state_27534__$1 = state_27534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27534__$1,(6),inst_27526);
} else {
if((state_val_27535 === (3))){
var inst_27532 = (state_27534[(2)]);
var state_27534__$1 = state_27534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27534__$1,inst_27532);
} else {
if((state_val_27535 === (4))){
var inst_27518 = (state_27534[(2)]);
var state_27534__$1 = state_27534;
var statearr_27539_27552 = state_27534__$1;
(statearr_27539_27552[(2)] = inst_27518);

(statearr_27539_27552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (5))){
var _ = (function (){var statearr_27540 = state_27534;
(statearr_27540[(4)] = cljs.core.rest.call(null,(state_27534[(4)])));

return statearr_27540;
})();
var state_27534__$1 = state_27534;
var ex27538 = (state_27534__$1[(2)]);
var statearr_27541_27553 = state_27534__$1;
(statearr_27541_27553[(5)] = ex27538);


if((ex27538 instanceof Error)){
var statearr_27542_27554 = state_27534__$1;
(statearr_27542_27554[(1)] = (4));

(statearr_27542_27554[(5)] = null);

} else {
throw ex27538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (6))){
var inst_27528 = (state_27534[(2)]);
var inst_27529 = fluree.db.util.async.throw_err.call(null,inst_27528);
var _ = (function (){var statearr_27543 = state_27534;
(statearr_27543[(4)] = cljs.core.rest.call(null,(state_27534[(4)])));

return statearr_27543;
})();
var state_27534__$1 = (function (){var statearr_27544 = state_27534;
(statearr_27544[(7)] = inst_27529);

return statearr_27544;
})();
var statearr_27545_27555 = state_27534__$1;
(statearr_27545_27555[(2)] = key);

(statearr_27545_27555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____0 = (function (){
var statearr_27546 = [null,null,null,null,null,null,null,null];
(statearr_27546[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__);

(statearr_27546[(1)] = (1));

return statearr_27546;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____1 = (function (state_27534){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27547){var ex__10906__auto__ = e27547;
var statearr_27548_27556 = state_27534;
(statearr_27548_27556[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27534[(4)]))){
var statearr_27549_27557 = state_27534;
(statearr_27549_27557[(1)] = cljs.core.first.call(null,(state_27534[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27558 = state_27534;
state_27534 = G__27558;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__ = function(state_27534){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____1.call(this,state_27534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27550 = f__10977__auto__.call(null);
(statearr_27550[(6)] = c__10976__auto__);

return statearr_27550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__27559_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__27559_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__27560){
var map__27561 = p__27560;
var map__27561__$1 = cljs.core.__destructure_map.call(null,map__27561);
var progress = map__27561__$1;
var garbage = cljs.core.get.call(null,map__27561__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27589){
var state_val_27590 = (state_27589[(1)]);
if((state_val_27590 === (1))){
var state_27589__$1 = state_27589;
var statearr_27591_27607 = state_27589__$1;
(statearr_27591_27607[(2)] = null);

(statearr_27591_27607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (2))){
var inst_27575 = (state_27589[(7)]);
var _ = (function (){var statearr_27592 = state_27589;
(statearr_27592[(4)] = cljs.core.cons.call(null,(5),(state_27589[(4)])));

return statearr_27592;
})();
var inst_27569 = db;
var inst_27570 = cljs.core.__destructure_map.call(null,inst_27569);
var inst_27571 = cljs.core.get.call(null,inst_27570,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27572 = cljs.core.get.call(null,inst_27570,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27573 = cljs.core.get.call(null,inst_27570,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27574 = cljs.core.get.call(null,inst_27570,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27575__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_27572,inst_27573,inst_27574);
var inst_27576 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_27577 = [inst_27573,inst_27574,garbage];
var inst_27578 = cljs.core.PersistentHashMap.fromArrays(inst_27576,inst_27577);
var inst_27579 = fluree.db.storage.core.serde.call(null,inst_27571);
var inst_27580 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_27579,inst_27578);
var inst_27581 = fluree.db.storage.core.storage_write.call(null,inst_27571,inst_27575__$1,inst_27580);
var state_27589__$1 = (function (){var statearr_27593 = state_27589;
(statearr_27593[(7)] = inst_27575__$1);

return statearr_27593;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27589__$1,(6),inst_27581);
} else {
if((state_val_27590 === (3))){
var inst_27587 = (state_27589[(2)]);
var state_27589__$1 = state_27589;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27589__$1,inst_27587);
} else {
if((state_val_27590 === (4))){
var inst_27562 = (state_27589[(2)]);
var state_27589__$1 = state_27589;
var statearr_27595_27608 = state_27589__$1;
(statearr_27595_27608[(2)] = inst_27562);

(statearr_27595_27608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (5))){
var _ = (function (){var statearr_27596 = state_27589;
(statearr_27596[(4)] = cljs.core.rest.call(null,(state_27589[(4)])));

return statearr_27596;
})();
var state_27589__$1 = state_27589;
var ex27594 = (state_27589__$1[(2)]);
var statearr_27597_27609 = state_27589__$1;
(statearr_27597_27609[(5)] = ex27594);


if((ex27594 instanceof Error)){
var statearr_27598_27610 = state_27589__$1;
(statearr_27598_27610[(1)] = (4));

(statearr_27598_27610[(5)] = null);

} else {
throw ex27594;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (6))){
var inst_27575 = (state_27589[(7)]);
var inst_27583 = (state_27589[(2)]);
var inst_27584 = fluree.db.util.async.throw_err.call(null,inst_27583);
var _ = (function (){var statearr_27599 = state_27589;
(statearr_27599[(4)] = cljs.core.rest.call(null,(state_27589[(4)])));

return statearr_27599;
})();
var state_27589__$1 = (function (){var statearr_27600 = state_27589;
(statearr_27600[(8)] = inst_27584);

return statearr_27600;
})();
var statearr_27601_27611 = state_27589__$1;
(statearr_27601_27611[(2)] = inst_27575);

(statearr_27601_27611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____0 = (function (){
var statearr_27602 = [null,null,null,null,null,null,null,null,null];
(statearr_27602[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__);

(statearr_27602[(1)] = (1));

return statearr_27602;
});
var fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____1 = (function (state_27589){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27589);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27603){var ex__10906__auto__ = e27603;
var statearr_27604_27612 = state_27589;
(statearr_27604_27612[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27589[(4)]))){
var statearr_27605_27613 = state_27589;
(statearr_27605_27613[(1)] = cljs.core.first.call(null,(state_27589[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27614 = state_27589;
state_27589 = G__27614;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__ = function(state_27589){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____1.call(this,state_27589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__10903__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27606 = f__10977__auto__.call(null);
(statearr_27606[(6)] = c__10976__auto__);

return statearr_27606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__27616 = arguments.length;
switch (G__27616) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27672){
var state_val_27673 = (state_27672[(1)]);
if((state_val_27673 === (7))){
var state_27672__$1 = state_27672;
var statearr_27674_27700 = state_27672__$1;
(statearr_27674_27700[(2)] = (0));

(statearr_27674_27700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (1))){
var state_27672__$1 = state_27672;
var statearr_27675_27701 = state_27672__$1;
(statearr_27675_27701[(2)] = null);

(statearr_27675_27701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (4))){
var inst_27617 = (state_27672[(2)]);
var state_27672__$1 = state_27672;
var statearr_27676_27702 = state_27672__$1;
(statearr_27676_27702[(2)] = inst_27617);

(statearr_27676_27702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (6))){
var inst_27642 = (state_27672[(7)]);
var state_27672__$1 = state_27672;
var statearr_27677_27703 = state_27672__$1;
(statearr_27677_27703[(2)] = inst_27642);

(statearr_27677_27703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (3))){
var inst_27670 = (state_27672[(2)]);
var state_27672__$1 = state_27672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27672__$1,inst_27670);
} else {
if((state_val_27673 === (12))){
var inst_27639 = (state_27672[(8)]);
var inst_27666 = (state_27672[(2)]);
var inst_27667 = fluree.db.util.async.throw_err.call(null,inst_27666);
var _ = (function (){var statearr_27678 = state_27672;
(statearr_27678[(4)] = cljs.core.rest.call(null,(state_27672[(4)])));

return statearr_27678;
})();
var state_27672__$1 = (function (){var statearr_27679 = state_27672;
(statearr_27679[(9)] = inst_27667);

return statearr_27679;
})();
var statearr_27680_27704 = state_27672__$1;
(statearr_27680_27704[(2)] = inst_27639);

(statearr_27680_27704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (2))){
var inst_27642 = (state_27672[(7)]);
var inst_27632 = (state_27672[(10)]);
var inst_27634 = (state_27672[(11)]);
var inst_27630 = (state_27672[(12)]);
var _ = (function (){var statearr_27681 = state_27672;
(statearr_27681[(4)] = cljs.core.cons.call(null,(5),(state_27672[(4)])));

return statearr_27681;
})();
var inst_27624 = db;
var inst_27625 = cljs.core.__destructure_map.call(null,inst_27624);
var inst_27626 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27627 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27628 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_27629 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_27630__$1 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_27631 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27632__$1 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27633 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_27634__$1 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27635 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_27636 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_27637 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_27638 = cljs.core.get.call(null,inst_27625,new cljs.core.Keyword(null,"post","post",269697687));
var inst_27639 = fluree.db.storage.core.ledger_root_key.call(null,inst_27626,inst_27634__$1,inst_27632__$1);
var inst_27640 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_27641 = fluree.db.storage.core.child_data.call(null,inst_27633);
var inst_27642__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_27630__$1);
var state_27672__$1 = (function (){var statearr_27682 = state_27672;
(statearr_27682[(13)] = inst_27635);

(statearr_27682[(7)] = inst_27642__$1);

(statearr_27682[(14)] = inst_27628);

(statearr_27682[(10)] = inst_27632__$1);

(statearr_27682[(8)] = inst_27639);

(statearr_27682[(15)] = inst_27640);

(statearr_27682[(16)] = inst_27631);

(statearr_27682[(17)] = inst_27636);

(statearr_27682[(11)] = inst_27634__$1);

(statearr_27682[(18)] = inst_27641);

(statearr_27682[(12)] = inst_27630__$1);

(statearr_27682[(19)] = inst_27638);

(statearr_27682[(20)] = inst_27627);

(statearr_27682[(21)] = inst_27637);

(statearr_27682[(22)] = inst_27629);

return statearr_27682;
})();
if(cljs.core.truth_(inst_27642__$1)){
var statearr_27683_27705 = state_27672__$1;
(statearr_27683_27705[(1)] = (6));

} else {
var statearr_27684_27706 = state_27672__$1;
(statearr_27684_27706[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (11))){
var inst_27646 = (state_27672[(23)]);
var inst_27628 = (state_27672[(14)]);
var inst_27632 = (state_27672[(10)]);
var inst_27639 = (state_27672[(8)]);
var inst_27640 = (state_27672[(15)]);
var inst_27631 = (state_27672[(16)]);
var inst_27636 = (state_27672[(17)]);
var inst_27634 = (state_27672[(11)]);
var inst_27641 = (state_27672[(18)]);
var inst_27630 = (state_27672[(12)]);
var inst_27638 = (state_27672[(19)]);
var inst_27627 = (state_27672[(20)]);
var inst_27637 = (state_27672[(21)]);
var inst_27629 = (state_27672[(22)]);
var inst_27651 = (state_27672[(2)]);
var inst_27652 = fluree.db.storage.core.child_data.call(null,inst_27636);
var inst_27653 = fluree.db.storage.core.child_data.call(null,inst_27638);
var inst_27654 = fluree.db.util.core.current_time_millis.call(null);
var inst_27655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27656 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27657 = (new cljs.core.PersistentVector(null,2,(5),inst_27655,inst_27656,null));
var inst_27658 = cljs.core.select_keys.call(null,inst_27630,inst_27657);
var inst_27659 = fluree.db.storage.core.child_data.call(null,inst_27629);
var inst_27660 = [inst_27632,inst_27641,inst_27634,inst_27646,inst_27651,inst_27652,inst_27653,inst_27627,inst_27654,inst_27628,inst_27637,inst_27658,inst_27659];
var inst_27661 = cljs.core.PersistentHashMap.fromArrays(inst_27640,inst_27660);
var inst_27662 = fluree.db.storage.core.serde.call(null,inst_27631);
var inst_27663 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_27662,inst_27661);
var inst_27664 = fluree.db.storage.core.storage_write.call(null,inst_27631,inst_27639,inst_27663);
var state_27672__$1 = state_27672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27672__$1,(12),inst_27664);
} else {
if((state_val_27673 === (9))){
var inst_27647 = (state_27672[(24)]);
var state_27672__$1 = state_27672;
var statearr_27686_27707 = state_27672__$1;
(statearr_27686_27707[(2)] = inst_27647);

(statearr_27686_27707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (5))){
var _ = (function (){var statearr_27687 = state_27672;
(statearr_27687[(4)] = cljs.core.rest.call(null,(state_27672[(4)])));

return statearr_27687;
})();
var state_27672__$1 = state_27672;
var ex27685 = (state_27672__$1[(2)]);
var statearr_27688_27708 = state_27672__$1;
(statearr_27688_27708[(5)] = ex27685);


if((ex27685 instanceof Error)){
var statearr_27689_27709 = state_27672__$1;
(statearr_27689_27709[(1)] = (4));

(statearr_27689_27709[(5)] = null);

} else {
throw ex27685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (10))){
var inst_27635 = (state_27672[(13)]);
var state_27672__$1 = state_27672;
var statearr_27690_27710 = state_27672__$1;
(statearr_27690_27710[(2)] = inst_27635);

(statearr_27690_27710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27673 === (8))){
var inst_27647 = (state_27672[(24)]);
var inst_27646 = (state_27672[(2)]);
var inst_27647__$1 = custom_ecount;
var state_27672__$1 = (function (){var statearr_27691 = state_27672;
(statearr_27691[(23)] = inst_27646);

(statearr_27691[(24)] = inst_27647__$1);

return statearr_27691;
})();
if(cljs.core.truth_(inst_27647__$1)){
var statearr_27692_27711 = state_27672__$1;
(statearr_27692_27711[(1)] = (9));

} else {
var statearr_27693_27712 = state_27672__$1;
(statearr_27693_27712[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10903__auto__ = null;
var fluree$db$storage$core$state_machine__10903__auto____0 = (function (){
var statearr_27694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27694[(0)] = fluree$db$storage$core$state_machine__10903__auto__);

(statearr_27694[(1)] = (1));

return statearr_27694;
});
var fluree$db$storage$core$state_machine__10903__auto____1 = (function (state_27672){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27695){var ex__10906__auto__ = e27695;
var statearr_27696_27713 = state_27672;
(statearr_27696_27713[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27672[(4)]))){
var statearr_27697_27714 = state_27672;
(statearr_27697_27714[(1)] = cljs.core.first.call(null,(state_27672[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27715 = state_27672;
state_27672 = G__27715;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10903__auto__ = function(state_27672){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10903__auto____1.call(this,state_27672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10903__auto____0;
fluree$db$storage$core$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10903__auto____1;
return fluree$db$storage$core$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27698 = f__10977__auto__.call(null);
(statearr_27698[(6)] = c__10976__auto__);

return statearr_27698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__10976__auto___27774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27748){
var state_val_27749 = (state_27748[(1)]);
if((state_val_27749 === (7))){
var inst_27728 = (state_27748[(7)]);
var state_27748__$1 = state_27748;
var statearr_27750_27775 = state_27748__$1;
(statearr_27750_27775[(2)] = inst_27728);

(statearr_27750_27775[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (1))){
var state_27748__$1 = state_27748;
var statearr_27751_27776 = state_27748__$1;
(statearr_27751_27776[(2)] = null);

(statearr_27751_27776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (4))){
var inst_27716 = (state_27748[(2)]);
var inst_27717 = error_fn.call(null);
var inst_27718 = cljs.core.async.put_BANG_.call(null,return_ch,inst_27716);
var inst_27719 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_27748__$1 = (function (){var statearr_27752 = state_27748;
(statearr_27752[(8)] = inst_27718);

(statearr_27752[(9)] = inst_27717);

return statearr_27752;
})();
var statearr_27753_27777 = state_27748__$1;
(statearr_27753_27777[(2)] = inst_27719);

(statearr_27753_27777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (6))){
var inst_27727 = (state_27748[(10)]);
var inst_27728 = (state_27748[(7)]);
var inst_27727__$1 = (state_27748[(2)]);
var inst_27728__$1 = (inst_27727__$1 == null);
var state_27748__$1 = (function (){var statearr_27754 = state_27748;
(statearr_27754[(10)] = inst_27727__$1);

(statearr_27754[(7)] = inst_27728__$1);

return statearr_27754;
})();
if(cljs.core.truth_(inst_27728__$1)){
var statearr_27755_27778 = state_27748__$1;
(statearr_27755_27778[(1)] = (7));

} else {
var statearr_27756_27779 = state_27748__$1;
(statearr_27756_27779[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (3))){
var inst_27746 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27748__$1,inst_27746);
} else {
if((state_val_27749 === (12))){
var inst_27743 = (state_27748[(2)]);
var _ = (function (){var statearr_27757 = state_27748;
(statearr_27757[(4)] = cljs.core.rest.call(null,(state_27748[(4)])));

return statearr_27757;
})();
var state_27748__$1 = state_27748;
var statearr_27758_27780 = state_27748__$1;
(statearr_27758_27780[(2)] = inst_27743);

(statearr_27758_27780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (2))){
var _ = (function (){var statearr_27759 = state_27748;
(statearr_27759[(4)] = cljs.core.cons.call(null,(5),(state_27748[(4)])));

return statearr_27759;
})();
var inst_27725 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27748__$1,(6),inst_27725);
} else {
if((state_val_27749 === (11))){
var inst_27727 = (state_27748[(10)]);
var inst_27737 = fluree.db.storage.core.serde.call(null,conn);
var inst_27738 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_27737,inst_27727);
var inst_27739 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_27738);
var inst_27740 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_27739);
var inst_27741 = cljs.core.async.put_BANG_.call(null,return_ch,inst_27740);
var state_27748__$1 = state_27748;
var statearr_27761_27781 = state_27748__$1;
(statearr_27761_27781[(2)] = inst_27741);

(statearr_27761_27781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (9))){
var inst_27733 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
if(cljs.core.truth_(inst_27733)){
var statearr_27762_27782 = state_27748__$1;
(statearr_27762_27782[(1)] = (10));

} else {
var statearr_27763_27783 = state_27748__$1;
(statearr_27763_27783[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (5))){
var _ = (function (){var statearr_27764 = state_27748;
(statearr_27764[(4)] = cljs.core.rest.call(null,(state_27748[(4)])));

return statearr_27764;
})();
var state_27748__$1 = state_27748;
var ex27760 = (state_27748__$1[(2)]);
var statearr_27765_27784 = state_27748__$1;
(statearr_27765_27784[(5)] = ex27760);


var statearr_27766_27785 = state_27748__$1;
(statearr_27766_27785[(1)] = (4));

(statearr_27766_27785[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (10))){
var inst_27735 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_27748__$1 = state_27748;
var statearr_27767_27786 = state_27748__$1;
(statearr_27767_27786[(2)] = inst_27735);

(statearr_27767_27786[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (8))){
var inst_27727 = (state_27748[(10)]);
var inst_27731 = (inst_27727 instanceof Error);
var state_27748__$1 = state_27748;
var statearr_27768_27787 = state_27748__$1;
(statearr_27768_27787[(2)] = inst_27731);

(statearr_27768_27787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__10903__auto____0 = (function (){
var statearr_27769 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27769[(0)] = fluree$db$storage$core$reify_history_$_state_machine__10903__auto__);

(statearr_27769[(1)] = (1));

return statearr_27769;
});
var fluree$db$storage$core$reify_history_$_state_machine__10903__auto____1 = (function (state_27748){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27770){var ex__10906__auto__ = e27770;
var statearr_27771_27788 = state_27748;
(statearr_27771_27788[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27748[(4)]))){
var statearr_27772_27789 = state_27748;
(statearr_27772_27789[(1)] = cljs.core.first.call(null,(state_27748[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27790 = state_27748;
state_27748 = G__27790;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__10903__auto__ = function(state_27748){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__10903__auto____1.call(this,state_27748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__10903__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__10903__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27773 = f__10977__auto__.call(null);
(statearr_27773[(6)] = c__10976__auto___27774);

return statearr_27773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__27792 = arguments.length;
switch (G__27792) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__10976__auto___27902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_27855){
var state_val_27856 = (state_27855[(1)]);
if((state_val_27856 === (7))){
var state_27855__$1 = state_27855;
var statearr_27857_27903 = state_27855__$1;
(statearr_27857_27903[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_27857_27903[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (20))){
var inst_27834 = cljs.core.PersistentVector.EMPTY;
var state_27855__$1 = state_27855;
var statearr_27858_27904 = state_27855__$1;
(statearr_27858_27904[(2)] = inst_27834);

(statearr_27858_27904[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (1))){
var state_27855__$1 = state_27855;
var statearr_27859_27905 = state_27855__$1;
(statearr_27859_27905[(2)] = null);

(statearr_27859_27905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (24))){
var state_27855__$1 = state_27855;
var statearr_27860_27906 = state_27855__$1;
(statearr_27860_27906[(2)] = null);

(statearr_27860_27906[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (4))){
var inst_27795 = (state_27855[(2)]);
var inst_27796 = error_fn.call(null);
var inst_27797 = cljs.core.async.put_BANG_.call(null,result_ch,inst_27795);
var inst_27798 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_27855__$1 = (function (){var statearr_27861 = state_27855;
(statearr_27861[(7)] = inst_27797);

(statearr_27861[(8)] = inst_27796);

return statearr_27861;
})();
var statearr_27862_27907 = state_27855__$1;
(statearr_27862_27907[(2)] = inst_27798);

(statearr_27862_27907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (15))){
var inst_27820 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27863_27908 = state_27855__$1;
(statearr_27863_27908[(2)] = inst_27820);

(statearr_27863_27908[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (21))){
var inst_27837 = (state_27855[(9)]);
var inst_27824 = (state_27855[(10)]);
var inst_27807 = (state_27855[(11)]);
var inst_27809 = (state_27855[(12)]);
var inst_27808 = (state_27855[(13)]);
var inst_27844 = (state_27855[(2)]);
var inst_27845 = (function (){var base_node = inst_27807;
var first_flake = inst_27808;
var node_t = inst_27809;
var source = inst_27824;
var coll = inst_27837;
var conj_QMARK_ = inst_27844;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_27846 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_27807);
var inst_27847 = cljs.core.reduce.call(null,inst_27845,inst_27846,inst_27837);
var inst_27848 = cljs.core.doall.call(null,inst_27847);
var inst_27849 = cljs.core.assoc.call(null,inst_27807,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_27848);
var inst_27850 = cljs.core.async.put_BANG_.call(null,result_ch,inst_27849);
var _ = (function (){var statearr_27864 = state_27855;
(statearr_27864[(4)] = cljs.core.rest.call(null,(state_27855[(4)])));

return statearr_27864;
})();
var state_27855__$1 = state_27855;
var statearr_27865_27909 = state_27855__$1;
(statearr_27865_27909[(2)] = inst_27850);

(statearr_27865_27909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (13))){
var state_27855__$1 = state_27855;
var statearr_27866_27910 = state_27855__$1;
(statearr_27866_27910[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_27866_27910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (22))){
var inst_27837 = (state_27855[(9)]);
var inst_27824 = (state_27855[(10)]);
var inst_27807 = (state_27855[(11)]);
var inst_27809 = (state_27855[(12)]);
var inst_27808 = (state_27855[(13)]);
var inst_27838 = (function (){var base_node = inst_27807;
var first_flake = inst_27808;
var node_t = inst_27809;
var source = inst_27824;
var coll = inst_27837;
return (function (f){
return f.op === true;
});
})();
var state_27855__$1 = state_27855;
var statearr_27867_27911 = state_27855__$1;
(statearr_27867_27911[(2)] = inst_27838);

(statearr_27867_27911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (6))){
var inst_27807 = (state_27855[(11)]);
var inst_27809 = (state_27855[(12)]);
var inst_27806 = (state_27855[(2)]);
var inst_27807__$1 = fluree.db.util.async.throw_err.call(null,inst_27806);
var inst_27808 = fluree.db.dbproto._first_flake.call(null,inst_27807__$1);
var inst_27809__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_27807__$1);
var inst_27810 = (inst_27809__$1 > t);
var state_27855__$1 = (function (){var statearr_27868 = state_27855;
(statearr_27868[(11)] = inst_27807__$1);

(statearr_27868[(12)] = inst_27809__$1);

(statearr_27868[(13)] = inst_27808);

return statearr_27868;
})();
if(cljs.core.truth_(inst_27810)){
var statearr_27869_27912 = state_27855__$1;
(statearr_27869_27912[(1)] = (7));

} else {
var statearr_27870_27913 = state_27855__$1;
(statearr_27870_27913[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (17))){
var inst_27808 = (state_27855[(13)]);
var inst_27825 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_27808,rhs,leftmost_QMARK_,t);
var state_27855__$1 = state_27855;
var statearr_27871_27914 = state_27855__$1;
(statearr_27871_27914[(2)] = inst_27825);

(statearr_27871_27914[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (3))){
var inst_27853 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27855__$1,inst_27853);
} else {
if((state_val_27856 === (12))){
var inst_27822 = (state_27855[(2)]);
var state_27855__$1 = state_27855;
var statearr_27872_27915 = state_27855__$1;
(statearr_27872_27915[(2)] = inst_27822);

(statearr_27872_27915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (2))){
var _ = (function (){var statearr_27873 = state_27855;
(statearr_27873[(4)] = cljs.core.cons.call(null,(5),(state_27855[(4)])));

return statearr_27873;
})();
var inst_27804 = fluree.db.dbproto._resolve.call(null,node);
var state_27855__$1 = state_27855;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27855__$1,(6),inst_27804);
} else {
if((state_val_27856 === (23))){
var inst_27837 = (state_27855[(9)]);
var inst_27824 = (state_27855[(10)]);
var inst_27807 = (state_27855[(11)]);
var inst_27809 = (state_27855[(12)]);
var inst_27808 = (state_27855[(13)]);
var inst_27840 = (function (){var base_node = inst_27807;
var first_flake = inst_27808;
var node_t = inst_27809;
var source = inst_27824;
var coll = inst_27837;
return (function (f){
return f.op === false;
});
})();
var state_27855__$1 = state_27855;
var statearr_27874_27916 = state_27855__$1;
(statearr_27874_27916[(2)] = inst_27840);

(statearr_27874_27916[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (19))){
var inst_27827 = (state_27855[(14)]);
var inst_27830 = (state_27855[(2)]);
var inst_27831 = fluree.db.util.async.throw_err.call(null,inst_27830);
var inst_27832 = cljs.core.take_while.call(null,inst_27827,inst_27831);
var state_27855__$1 = state_27855;
var statearr_27875_27917 = state_27855__$1;
(statearr_27875_27917[(2)] = inst_27832);

(statearr_27875_27917[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (11))){
var inst_27809 = (state_27855[(12)]);
var inst_27816 = cljs.core._EQ_.call(null,inst_27809,t);
var state_27855__$1 = state_27855;
if(inst_27816){
var statearr_27877_27918 = state_27855__$1;
(statearr_27877_27918[(1)] = (13));

} else {
var statearr_27878_27919 = state_27855__$1;
(statearr_27878_27919[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (9))){
var inst_27824 = (state_27855[(10)]);
var inst_27824__$1 = (state_27855[(2)]);
var state_27855__$1 = (function (){var statearr_27879 = state_27855;
(statearr_27879[(10)] = inst_27824__$1);

return statearr_27879;
})();
var G__27880_27920 = inst_27824__$1;
var G__27880_27921__$1 = (((G__27880_27920 instanceof cljs.core.Keyword))?G__27880_27920.fqn:null);
switch (G__27880_27921__$1) {
case "novelty":
var statearr_27881_27923 = state_27855__$1;
(statearr_27881_27923[(1)] = (17));


break;
case "history":
var statearr_27882_27924 = state_27855__$1;
(statearr_27882_27924[(1)] = (18));


break;
case "none":
var statearr_27883_27925 = state_27855__$1;
(statearr_27883_27925[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27880_27921__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (5))){
var _ = (function (){var statearr_27884 = state_27855;
(statearr_27884[(4)] = cljs.core.rest.call(null,(state_27855[(4)])));

return statearr_27884;
})();
var state_27855__$1 = state_27855;
var ex27876 = (state_27855__$1[(2)]);
var statearr_27885_27926 = state_27855__$1;
(statearr_27885_27926[(5)] = ex27876);


var statearr_27886_27927 = state_27855__$1;
(statearr_27886_27927[(1)] = (4));

(statearr_27886_27927[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (14))){
var state_27855__$1 = state_27855;
var statearr_27887_27928 = state_27855__$1;
(statearr_27887_27928[(2)] = null);

(statearr_27887_27928[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (16))){
var inst_27824 = (state_27855[(10)]);
var inst_27837 = (state_27855[(2)]);
var state_27855__$1 = (function (){var statearr_27888 = state_27855;
(statearr_27888[(9)] = inst_27837);

return statearr_27888;
})();
var G__27889_27929 = inst_27824;
var G__27889_27930__$1 = (((G__27889_27929 instanceof cljs.core.Keyword))?G__27889_27929.fqn:null);
switch (G__27889_27930__$1) {
case "novelty":
var statearr_27890_27932 = state_27855__$1;
(statearr_27890_27932[(1)] = (22));


break;
case "history":
var statearr_27891_27933 = state_27855__$1;
(statearr_27891_27933[(1)] = (23));


break;
case "none":
var statearr_27892_27934 = state_27855__$1;
(statearr_27892_27934[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27889_27930__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (10))){
var state_27855__$1 = state_27855;
var statearr_27893_27935 = state_27855__$1;
(statearr_27893_27935[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_27893_27935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27856 === (18))){
var inst_27824 = (state_27855[(10)]);
var inst_27807 = (state_27855[(11)]);
var inst_27809 = (state_27855[(12)]);
var inst_27808 = (state_27855[(13)]);
var inst_27827 = (function (){var base_node = inst_27807;
var first_flake = inst_27808;
var node_t = inst_27809;
var source = inst_27824;
return (function (p1__27794_SHARP_){
return (p1__27794_SHARP_.t <= t);
});
})();
var inst_27828 = fluree.db.dbproto._resolve_history.call(null,node);
var state_27855__$1 = (function (){var statearr_27894 = state_27855;
(statearr_27894[(14)] = inst_27827);

return statearr_27894;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27855__$1,(19),inst_27828);
} else {
if((state_val_27856 === (8))){
var inst_27809 = (state_27855[(12)]);
var inst_27813 = (inst_27809 < t);
var state_27855__$1 = state_27855;
if(cljs.core.truth_(inst_27813)){
var statearr_27895_27936 = state_27855__$1;
(statearr_27895_27936[(1)] = (10));

} else {
var statearr_27896_27937 = state_27855__$1;
(statearr_27896_27937[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____0 = (function (){
var statearr_27897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27897[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__);

(statearr_27897[(1)] = (1));

return statearr_27897;
});
var fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____1 = (function (state_27855){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_27855);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e27898){var ex__10906__auto__ = e27898;
var statearr_27899_27938 = state_27855;
(statearr_27899_27938[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_27855[(4)]))){
var statearr_27900_27939 = state_27855;
(statearr_27900_27939[(1)] = cljs.core.first.call(null,(state_27855[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27940 = state_27855;
state_27855 = G__27940;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__ = function(state_27855){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____1.call(this,state_27855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__10903__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27901 = f__10977__auto__.call(null);
(statearr_27901[(6)] = c__10976__auto___27902);

return statearr_27901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28000){
var state_val_28001 = (state_28000[(1)]);
if((state_val_28001 === (7))){
var inst_27951 = (state_28000[(7)]);
var inst_27955 = (inst_27951 <= from_t);
var state_28000__$1 = state_28000;
var statearr_28002_28042 = state_28000__$1;
(statearr_28002_28042[(2)] = inst_27955);

(statearr_28002_28042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (20))){
var inst_27985 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_27986 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27985)].join('');
var inst_27987 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27988 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27989 = cljs.core.PersistentHashMap.fromArrays(inst_27987,inst_27988);
var inst_27990 = cljs.core.ex_info.call(null,inst_27986,inst_27989);
var inst_27991 = (function(){throw inst_27990})();
var state_28000__$1 = state_28000;
var statearr_28003_28043 = state_28000__$1;
(statearr_28003_28043[(2)] = inst_27991);

(statearr_28003_28043[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (1))){
var state_28000__$1 = state_28000;
var statearr_28004_28044 = state_28000__$1;
(statearr_28004_28044[(2)] = null);

(statearr_28004_28044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (4))){
var inst_27943 = (state_28000[(2)]);
var inst_27944 = fluree.db.util.log.error.call(null,inst_27943);
var inst_27945 = (function(){throw inst_27943})();
var state_28000__$1 = (function (){var statearr_28005 = state_28000;
(statearr_28005[(8)] = inst_27944);

return statearr_28005;
})();
var statearr_28006_28045 = state_28000__$1;
(statearr_28006_28045[(2)] = inst_27945);

(statearr_28006_28045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (15))){
var inst_27970 = (state_28000[(2)]);
var state_28000__$1 = (function (){var statearr_28007 = state_28000;
(statearr_28007[(9)] = inst_27970);

return statearr_28007;
})();
if(cljs.core.truth_(from_t)){
var statearr_28008_28046 = state_28000__$1;
(statearr_28008_28046[(1)] = (16));

} else {
var statearr_28009_28047 = state_28000__$1;
(statearr_28009_28047[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (21))){
var inst_27979 = (state_28000[(10)]);
var inst_27980 = (state_28000[(11)]);
var inst_27981 = (state_28000[(12)]);
var inst_27993 = (state_28000[(2)]);
var inst_27994 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_27980,inst_27981,leftmost_QMARK_,to_t);
var inst_27995 = cljs.core.into.call(null,inst_27994,inst_27979);
var _ = (function (){var statearr_28010 = state_28000;
(statearr_28010[(4)] = cljs.core.rest.call(null,(state_28000[(4)])));

return statearr_28010;
})();
var state_28000__$1 = (function (){var statearr_28011 = state_28000;
(statearr_28011[(13)] = inst_27993);

return statearr_28011;
})();
var statearr_28012_28048 = state_28000__$1;
(statearr_28012_28048[(2)] = inst_27995);

(statearr_28012_28048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (13))){
var inst_27951 = (state_28000[(7)]);
var inst_27963 = (state_28000[(14)]);
var inst_27966 = (function (){var node_t = inst_27951;
var G__27959 = inst_27963;
return (function (p1__27941_SHARP_){
return (p1__27941_SHARP_.t < to_t);
});
})();
var inst_27967 = cljs.core.drop_while.call(null,inst_27966,inst_27963);
var state_28000__$1 = state_28000;
var statearr_28013_28049 = state_28000__$1;
(statearr_28013_28049[(2)] = inst_27967);

(statearr_28013_28049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (6))){
var inst_27952 = (state_28000[(15)]);
var state_28000__$1 = state_28000;
var statearr_28014_28050 = state_28000__$1;
(statearr_28014_28050[(2)] = inst_27952);

(statearr_28014_28050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (17))){
var inst_27970 = (state_28000[(9)]);
var state_28000__$1 = state_28000;
var statearr_28015_28051 = state_28000__$1;
(statearr_28015_28051[(2)] = inst_27970);

(statearr_28015_28051[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (3))){
var inst_27998 = (state_28000[(2)]);
var state_28000__$1 = state_28000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28000__$1,inst_27998);
} else {
if((state_val_28001 === (12))){
var inst_27951 = (state_28000[(7)]);
var inst_27962 = (state_28000[(2)]);
var inst_27963 = fluree.db.util.async.throw_err.call(null,inst_27962);
var inst_27964 = (to_t > inst_27951);
var state_28000__$1 = (function (){var statearr_28016 = state_28000;
(statearr_28016[(14)] = inst_27963);

return statearr_28016;
})();
if(cljs.core.truth_(inst_27964)){
var statearr_28017_28052 = state_28000__$1;
(statearr_28017_28052[(1)] = (13));

} else {
var statearr_28018_28053 = state_28000__$1;
(statearr_28018_28053[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (2))){
var inst_27952 = (state_28000[(15)]);
var _ = (function (){var statearr_28019 = state_28000;
(statearr_28019[(4)] = cljs.core.cons.call(null,(5),(state_28000[(4)])));

return statearr_28019;
})();
var inst_27951 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_27952__$1 = (from_t == null);
var state_28000__$1 = (function (){var statearr_28020 = state_28000;
(statearr_28020[(15)] = inst_27952__$1);

(statearr_28020[(7)] = inst_27951);

return statearr_28020;
})();
if(cljs.core.truth_(inst_27952__$1)){
var statearr_28021_28054 = state_28000__$1;
(statearr_28021_28054[(1)] = (6));

} else {
var statearr_28022_28055 = state_28000__$1;
(statearr_28022_28055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (19))){
var state_28000__$1 = state_28000;
var statearr_28023_28056 = state_28000__$1;
(statearr_28023_28056[(2)] = null);

(statearr_28023_28056[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (11))){
var inst_27979 = (state_28000[(2)]);
var inst_27980 = fluree.db.dbproto._first_flake.call(null,node);
var inst_27981 = fluree.db.dbproto._rhs.call(null,node);
var inst_27982 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_28000__$1 = (function (){var statearr_28025 = state_28000;
(statearr_28025[(10)] = inst_27979);

(statearr_28025[(11)] = inst_27980);

(statearr_28025[(12)] = inst_27981);

return statearr_28025;
})();
if(cljs.core.truth_(inst_27982)){
var statearr_28026_28057 = state_28000__$1;
(statearr_28026_28057[(1)] = (19));

} else {
var statearr_28027_28058 = state_28000__$1;
(statearr_28027_28058[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (9))){
var inst_27960 = fluree.db.dbproto._resolve_history.call(null,node);
var state_28000__$1 = state_28000;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28000__$1,(12),inst_27960);
} else {
if((state_val_28001 === (5))){
var _ = (function (){var statearr_28028 = state_28000;
(statearr_28028[(4)] = cljs.core.rest.call(null,(state_28000[(4)])));

return statearr_28028;
})();
var state_28000__$1 = state_28000;
var ex28024 = (state_28000__$1[(2)]);
var statearr_28029_28059 = state_28000__$1;
(statearr_28029_28059[(5)] = ex28024);


var statearr_28030_28060 = state_28000__$1;
(statearr_28030_28060[(1)] = (4));

(statearr_28030_28060[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (14))){
var inst_27963 = (state_28000[(14)]);
var state_28000__$1 = state_28000;
var statearr_28031_28061 = state_28000__$1;
(statearr_28031_28061[(2)] = inst_27963);

(statearr_28031_28061[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (16))){
var inst_27951 = (state_28000[(7)]);
var inst_27970 = (state_28000[(9)]);
var inst_27972 = (function (){var node_t = inst_27951;
var G__27959 = inst_27970;
return (function (p1__27942_SHARP_){
return (p1__27942_SHARP_.t <= from_t);
});
})();
var inst_27973 = cljs.core.take_while.call(null,inst_27972,inst_27970);
var state_28000__$1 = state_28000;
var statearr_28032_28062 = state_28000__$1;
(statearr_28032_28062[(2)] = inst_27973);

(statearr_28032_28062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (10))){
var state_28000__$1 = state_28000;
var statearr_28033_28063 = state_28000__$1;
(statearr_28033_28063[(2)] = null);

(statearr_28033_28063[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (18))){
var inst_27976 = (state_28000[(2)]);
var state_28000__$1 = state_28000;
var statearr_28034_28064 = state_28000__$1;
(statearr_28034_28064[(2)] = inst_27976);

(statearr_28034_28064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28001 === (8))){
var inst_27957 = (state_28000[(2)]);
var state_28000__$1 = state_28000;
if(cljs.core.truth_(inst_27957)){
var statearr_28035_28065 = state_28000__$1;
(statearr_28035_28065[(1)] = (9));

} else {
var statearr_28036_28066 = state_28000__$1;
(statearr_28036_28066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____0 = (function (){
var statearr_28037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28037[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__);

(statearr_28037[(1)] = (1));

return statearr_28037;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____1 = (function (state_28000){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28038){var ex__10906__auto__ = e28038;
var statearr_28039_28067 = state_28000;
(statearr_28039_28067[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28000[(4)]))){
var statearr_28040_28068 = state_28000;
(statearr_28040_28068[(1)] = cljs.core.first.call(null,(state_28000[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28069 = state_28000;
state_28000 = G__28069;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__ = function(state_28000){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____1.call(this,state_28000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28041 = f__10977__auto__.call(null);
(statearr_28041[(6)] = c__10976__auto__);

return statearr_28041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28090){
var state_val_28091 = (state_28090[(1)]);
if((state_val_28091 === (7))){
var inst_28079 = (state_28090[(7)]);
var inst_28081 = fluree.db.storage.core.serde.call(null,conn);
var inst_28082 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_28081,inst_28079);
var state_28090__$1 = state_28090;
var statearr_28092_28111 = state_28090__$1;
(statearr_28092_28111[(2)] = inst_28082);

(statearr_28092_28111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (1))){
var state_28090__$1 = state_28090;
var statearr_28093_28112 = state_28090__$1;
(statearr_28093_28112[(2)] = null);

(statearr_28093_28112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (4))){
var inst_28070 = (state_28090[(2)]);
var state_28090__$1 = state_28090;
var statearr_28094_28113 = state_28090__$1;
(statearr_28094_28113[(2)] = inst_28070);

(statearr_28094_28113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (6))){
var inst_28079 = (state_28090[(7)]);
var inst_28078 = (state_28090[(2)]);
var inst_28079__$1 = fluree.db.util.async.throw_err.call(null,inst_28078);
var state_28090__$1 = (function (){var statearr_28095 = state_28090;
(statearr_28095[(7)] = inst_28079__$1);

return statearr_28095;
})();
if(cljs.core.truth_(inst_28079__$1)){
var statearr_28096_28114 = state_28090__$1;
(statearr_28096_28114[(1)] = (7));

} else {
var statearr_28097_28115 = state_28090__$1;
(statearr_28097_28115[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (3))){
var inst_28088 = (state_28090[(2)]);
var state_28090__$1 = state_28090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28090__$1,inst_28088);
} else {
if((state_val_28091 === (2))){
var _ = (function (){var statearr_28099 = state_28090;
(statearr_28099[(4)] = cljs.core.cons.call(null,(5),(state_28090[(4)])));

return statearr_28099;
})();
var inst_28076 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_28090__$1 = state_28090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28090__$1,(6),inst_28076);
} else {
if((state_val_28091 === (9))){
var inst_28085 = (state_28090[(2)]);
var _ = (function (){var statearr_28100 = state_28090;
(statearr_28100[(4)] = cljs.core.rest.call(null,(state_28090[(4)])));

return statearr_28100;
})();
var state_28090__$1 = state_28090;
var statearr_28101_28116 = state_28090__$1;
(statearr_28101_28116[(2)] = inst_28085);

(statearr_28101_28116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (5))){
var _ = (function (){var statearr_28102 = state_28090;
(statearr_28102[(4)] = cljs.core.rest.call(null,(state_28090[(4)])));

return statearr_28102;
})();
var state_28090__$1 = state_28090;
var ex28098 = (state_28090__$1[(2)]);
var statearr_28103_28117 = state_28090__$1;
(statearr_28103_28117[(5)] = ex28098);


if((ex28098 instanceof Error)){
var statearr_28104_28118 = state_28090__$1;
(statearr_28104_28118[(1)] = (4));

(statearr_28104_28118[(5)] = null);

} else {
throw ex28098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28091 === (8))){
var state_28090__$1 = state_28090;
var statearr_28105_28119 = state_28090__$1;
(statearr_28105_28119[(2)] = null);

(statearr_28105_28119[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__10903__auto____0 = (function (){
var statearr_28106 = [null,null,null,null,null,null,null,null];
(statearr_28106[(0)] = fluree$db$storage$core$read_branch_$_state_machine__10903__auto__);

(statearr_28106[(1)] = (1));

return statearr_28106;
});
var fluree$db$storage$core$read_branch_$_state_machine__10903__auto____1 = (function (state_28090){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28107){var ex__10906__auto__ = e28107;
var statearr_28108_28120 = state_28090;
(statearr_28108_28120[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28090[(4)]))){
var statearr_28109_28121 = state_28090;
(statearr_28109_28121[(1)] = cljs.core.first.call(null,(state_28090[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28122 = state_28090;
state_28090 = G__28122;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__10903__auto__ = function(state_28090){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__10903__auto____1.call(this,state_28090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28110 = f__10977__auto__.call(null);
(statearr_28110[(6)] = c__10976__auto__);

return statearr_28110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__10976__auto___28201 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28173){
var state_val_28174 = (state_28173[(1)]);
if((state_val_28174 === (7))){
var inst_28140 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_28141 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28142 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_28143 = cljs.core.PersistentHashMap.fromArrays(inst_28141,inst_28142);
var inst_28144 = cljs.core.ex_info.call(null,inst_28140,inst_28143);
var inst_28145 = (function(){throw inst_28144})();
var state_28173__$1 = state_28173;
var statearr_28175_28202 = state_28173__$1;
(statearr_28175_28202[(2)] = inst_28145);

(statearr_28175_28202[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (1))){
var state_28173__$1 = state_28173;
var statearr_28176_28203 = state_28173__$1;
(statearr_28176_28203[(2)] = null);

(statearr_28176_28203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (4))){
var inst_28123 = (state_28173[(2)]);
var inst_28124 = error_fn.call(null);
var inst_28125 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28123);
var inst_28126 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_28173__$1 = (function (){var statearr_28177 = state_28173;
(statearr_28177[(7)] = inst_28124);

(statearr_28177[(8)] = inst_28125);

return statearr_28177;
})();
var statearr_28178_28204 = state_28173__$1;
(statearr_28178_28204[(2)] = inst_28126);

(statearr_28178_28204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (6))){
var inst_28137 = (state_28173[(9)]);
var inst_28136 = (state_28173[(2)]);
var inst_28137__$1 = fluree.db.util.async.throw_err.call(null,inst_28136);
var inst_28138 = (inst_28137__$1 == null);
var state_28173__$1 = (function (){var statearr_28179 = state_28173;
(statearr_28179[(9)] = inst_28137__$1);

return statearr_28179;
})();
if(cljs.core.truth_(inst_28138)){
var statearr_28180_28205 = state_28173__$1;
(statearr_28180_28205[(1)] = (7));

} else {
var statearr_28181_28206 = state_28173__$1;
(statearr_28181_28206[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (3))){
var inst_28171 = (state_28173[(2)]);
var state_28173__$1 = state_28173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28173__$1,inst_28171);
} else {
if((state_val_28174 === (12))){
var inst_28137 = (state_28173[(9)]);
var inst_28154 = (state_28173[(2)]);
var inst_28155 = cljs.core.__destructure_map.call(null,inst_28137);
var inst_28156 = cljs.core.get.call(null,inst_28155,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_28157 = cljs.core.get.call(null,inst_28155,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_28158 = config;
var inst_28159 = cljs.core.__destructure_map.call(null,inst_28158);
var inst_28160 = cljs.core.get.call(null,inst_28159,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_28162 = (function (){var data = inst_28137;
var _ = inst_28154;
var map__28132 = inst_28155;
var children = inst_28156;
var rhs = inst_28157;
var map__28133 = inst_28159;
var comparator = inst_28160;
return (function (idx,p__28161){
var map__28182 = p__28161;
var map__28182__$1 = cljs.core.__destructure_map.call(null,map__28182);
var child = map__28182__$1;
var id = cljs.core.get.call(null,map__28182__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__28182__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__28182__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__28182__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__28182__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_28163 = cljs.core.map_indexed.call(null,inst_28162,inst_28156);
var inst_28164 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_28163);
var inst_28165 = cljs.core.interleave.call(null,inst_28164,inst_28163);
var inst_28166 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_28160,inst_28165);
var inst_28167 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_28157,inst_28166,config,leftmost_QMARK_);
var inst_28168 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28167);
var _ = (function (){var statearr_28183 = state_28173;
(statearr_28183[(4)] = cljs.core.rest.call(null,(state_28173[(4)])));

return statearr_28183;
})();
var state_28173__$1 = state_28173;
var statearr_28184_28207 = state_28173__$1;
(statearr_28184_28207[(2)] = inst_28168);

(statearr_28184_28207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (2))){
var _ = (function (){var statearr_28185 = state_28173;
(statearr_28185[(4)] = cljs.core.cons.call(null,(5),(state_28173[(4)])));

return statearr_28185;
})();
var inst_28134 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_28173__$1 = state_28173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28173__$1,(6),inst_28134);
} else {
if((state_val_28174 === (11))){
var state_28173__$1 = state_28173;
var statearr_28187_28208 = state_28173__$1;
(statearr_28187_28208[(2)] = null);

(statearr_28187_28208[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (9))){
var inst_28137 = (state_28173[(9)]);
var inst_28148 = (state_28173[(2)]);
var inst_28149 = fluree.db.util.core.exception_QMARK_.call(null,inst_28137);
var state_28173__$1 = (function (){var statearr_28188 = state_28173;
(statearr_28188[(10)] = inst_28148);

return statearr_28188;
})();
if(inst_28149){
var statearr_28189_28209 = state_28173__$1;
(statearr_28189_28209[(1)] = (10));

} else {
var statearr_28190_28210 = state_28173__$1;
(statearr_28190_28210[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (5))){
var _ = (function (){var statearr_28191 = state_28173;
(statearr_28191[(4)] = cljs.core.rest.call(null,(state_28173[(4)])));

return statearr_28191;
})();
var state_28173__$1 = state_28173;
var ex28186 = (state_28173__$1[(2)]);
var statearr_28192_28211 = state_28173__$1;
(statearr_28192_28211[(5)] = ex28186);


var statearr_28193_28212 = state_28173__$1;
(statearr_28193_28212[(1)] = (4));

(statearr_28193_28212[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (10))){
var inst_28137 = (state_28173[(9)]);
var inst_28151 = (function(){throw inst_28137})();
var state_28173__$1 = state_28173;
var statearr_28194_28213 = state_28173__$1;
(statearr_28194_28213[(2)] = inst_28151);

(statearr_28194_28213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28174 === (8))){
var state_28173__$1 = state_28173;
var statearr_28195_28214 = state_28173__$1;
(statearr_28195_28214[(2)] = null);

(statearr_28195_28214[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____0 = (function (){
var statearr_28196 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28196[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__);

(statearr_28196[(1)] = (1));

return statearr_28196;
});
var fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____1 = (function (state_28173){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28197){var ex__10906__auto__ = e28197;
var statearr_28198_28215 = state_28173;
(statearr_28198_28215[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28173[(4)]))){
var statearr_28199_28216 = state_28173;
(statearr_28199_28216[(1)] = cljs.core.first.call(null,(state_28173[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28217 = state_28173;
state_28173 = G__28217;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__ = function(state_28173){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____1.call(this,state_28173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__10903__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28200 = f__10977__auto__.call(null);
(statearr_28200[(6)] = c__10976__auto___28201);

return statearr_28200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28238){
var state_val_28239 = (state_28238[(1)]);
if((state_val_28239 === (7))){
var state_28238__$1 = state_28238;
var statearr_28240_28260 = state_28238__$1;
(statearr_28240_28260[(2)] = null);

(statearr_28240_28260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (1))){
var state_28238__$1 = state_28238;
var statearr_28241_28261 = state_28238__$1;
(statearr_28241_28261[(2)] = null);

(statearr_28241_28261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (4))){
var inst_28218 = (state_28238[(2)]);
var state_28238__$1 = state_28238;
var statearr_28242_28262 = state_28238__$1;
(statearr_28242_28262[(2)] = inst_28218);

(statearr_28242_28262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (6))){
var inst_28224 = (state_28238[(7)]);
var inst_28226 = fluree.db.storage.core.serde.call(null,conn);
var state_28238__$1 = (function (){var statearr_28243 = state_28238;
(statearr_28243[(8)] = inst_28226);

return statearr_28243;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28238__$1,(9),inst_28224);
} else {
if((state_val_28239 === (3))){
var inst_28236 = (state_28238[(2)]);
var state_28238__$1 = state_28238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28238__$1,inst_28236);
} else {
if((state_val_28239 === (2))){
var inst_28224 = (state_28238[(7)]);
var _ = (function (){var statearr_28245 = state_28238;
(statearr_28245[(4)] = cljs.core.cons.call(null,(5),(state_28238[(4)])));

return statearr_28245;
})();
var inst_28224__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_28238__$1 = (function (){var statearr_28246 = state_28238;
(statearr_28246[(7)] = inst_28224__$1);

return statearr_28246;
})();
if(cljs.core.truth_(inst_28224__$1)){
var statearr_28247_28263 = state_28238__$1;
(statearr_28247_28263[(1)] = (6));

} else {
var statearr_28248_28264 = state_28238__$1;
(statearr_28248_28264[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (9))){
var inst_28226 = (state_28238[(8)]);
var inst_28228 = (state_28238[(2)]);
var inst_28229 = fluree.db.util.async.throw_err.call(null,inst_28228);
var inst_28230 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_28226,inst_28229);
var state_28238__$1 = state_28238;
var statearr_28249_28265 = state_28238__$1;
(statearr_28249_28265[(2)] = inst_28230);

(statearr_28249_28265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (5))){
var _ = (function (){var statearr_28250 = state_28238;
(statearr_28250[(4)] = cljs.core.rest.call(null,(state_28238[(4)])));

return statearr_28250;
})();
var state_28238__$1 = state_28238;
var ex28244 = (state_28238__$1[(2)]);
var statearr_28251_28266 = state_28238__$1;
(statearr_28251_28266[(5)] = ex28244);


if((ex28244 instanceof Error)){
var statearr_28252_28267 = state_28238__$1;
(statearr_28252_28267[(1)] = (4));

(statearr_28252_28267[(5)] = null);

} else {
throw ex28244;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28239 === (8))){
var inst_28233 = (state_28238[(2)]);
var _ = (function (){var statearr_28253 = state_28238;
(statearr_28253[(4)] = cljs.core.rest.call(null,(state_28238[(4)])));

return statearr_28253;
})();
var state_28238__$1 = state_28238;
var statearr_28254_28268 = state_28238__$1;
(statearr_28254_28268[(2)] = inst_28233);

(statearr_28254_28268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____0 = (function (){
var statearr_28255 = [null,null,null,null,null,null,null,null,null];
(statearr_28255[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__);

(statearr_28255[(1)] = (1));

return statearr_28255;
});
var fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____1 = (function (state_28238){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28256){var ex__10906__auto__ = e28256;
var statearr_28257_28269 = state_28238;
(statearr_28257_28269[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28238[(4)]))){
var statearr_28258_28270 = state_28238;
(statearr_28258_28270[(1)] = cljs.core.first.call(null,(state_28238[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28271 = state_28238;
state_28238 = G__28271;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__ = function(state_28238){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____1.call(this,state_28238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28259 = f__10977__auto__.call(null);
(statearr_28259[(6)] = c__10976__auto__);

return statearr_28259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__10976__auto___28344 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28316){
var state_val_28317 = (state_28316[(1)]);
if((state_val_28317 === (7))){
var inst_28288 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_28289 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28290 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_28291 = cljs.core.PersistentHashMap.fromArrays(inst_28289,inst_28290);
var inst_28292 = cljs.core.ex_info.call(null,inst_28288,inst_28291);
var inst_28293 = (function(){throw inst_28292})();
var state_28316__$1 = state_28316;
var statearr_28318_28345 = state_28316__$1;
(statearr_28318_28345[(2)] = inst_28293);

(statearr_28318_28345[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (1))){
var state_28316__$1 = state_28316;
var statearr_28319_28346 = state_28316__$1;
(statearr_28319_28346[(2)] = null);

(statearr_28319_28346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (4))){
var inst_28272 = (state_28316[(2)]);
var inst_28273 = error_fn.call(null);
var inst_28274 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28272);
var inst_28275 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_28316__$1 = (function (){var statearr_28320 = state_28316;
(statearr_28320[(7)] = inst_28273);

(statearr_28320[(8)] = inst_28274);

return statearr_28320;
})();
var statearr_28321_28347 = state_28316__$1;
(statearr_28321_28347[(2)] = inst_28275);

(statearr_28321_28347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (6))){
var inst_28285 = (state_28316[(9)]);
var inst_28285__$1 = (state_28316[(2)]);
var inst_28286 = (inst_28285__$1 == null);
var state_28316__$1 = (function (){var statearr_28322 = state_28316;
(statearr_28322[(9)] = inst_28285__$1);

return statearr_28322;
})();
if(cljs.core.truth_(inst_28286)){
var statearr_28323_28348 = state_28316__$1;
(statearr_28323_28348[(1)] = (7));

} else {
var statearr_28324_28349 = state_28316__$1;
(statearr_28324_28349[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (3))){
var inst_28314 = (state_28316[(2)]);
var state_28316__$1 = state_28316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28316__$1,inst_28314);
} else {
if((state_val_28317 === (12))){
var inst_28285 = (state_28316[(9)]);
var inst_28302 = (state_28316[(2)]);
var inst_28303 = cljs.core.__destructure_map.call(null,inst_28285);
var inst_28304 = cljs.core.get.call(null,inst_28303,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28305 = cljs.core.get.call(null,inst_28303,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_28306 = config;
var inst_28307 = cljs.core.__destructure_map.call(null,inst_28306);
var inst_28308 = cljs.core.get.call(null,inst_28307,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_28309 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_28308,inst_28304);
var inst_28310 = fluree.db.index.data_node.call(null,block,t,inst_28309,rhs,config);
var inst_28311 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28310);
var _ = (function (){var statearr_28325 = state_28316;
(statearr_28325[(4)] = cljs.core.rest.call(null,(state_28316[(4)])));

return statearr_28325;
})();
var state_28316__$1 = (function (){var statearr_28326 = state_28316;
(statearr_28326[(10)] = inst_28302);

(statearr_28326[(11)] = inst_28305);

return statearr_28326;
})();
var statearr_28327_28350 = state_28316__$1;
(statearr_28327_28350[(2)] = inst_28311);

(statearr_28327_28350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (2))){
var _ = (function (){var statearr_28328 = state_28316;
(statearr_28328[(4)] = cljs.core.cons.call(null,(5),(state_28316[(4)])));

return statearr_28328;
})();
var inst_28283 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_28316__$1 = state_28316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28316__$1,(6),inst_28283);
} else {
if((state_val_28317 === (11))){
var state_28316__$1 = state_28316;
var statearr_28330_28351 = state_28316__$1;
(statearr_28330_28351[(2)] = null);

(statearr_28330_28351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (9))){
var inst_28285 = (state_28316[(9)]);
var inst_28296 = (state_28316[(2)]);
var inst_28297 = fluree.db.util.core.exception_QMARK_.call(null,inst_28285);
var state_28316__$1 = (function (){var statearr_28331 = state_28316;
(statearr_28331[(12)] = inst_28296);

return statearr_28331;
})();
if(inst_28297){
var statearr_28332_28352 = state_28316__$1;
(statearr_28332_28352[(1)] = (10));

} else {
var statearr_28333_28353 = state_28316__$1;
(statearr_28333_28353[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (5))){
var _ = (function (){var statearr_28334 = state_28316;
(statearr_28334[(4)] = cljs.core.rest.call(null,(state_28316[(4)])));

return statearr_28334;
})();
var state_28316__$1 = state_28316;
var ex28329 = (state_28316__$1[(2)]);
var statearr_28335_28354 = state_28316__$1;
(statearr_28335_28354[(5)] = ex28329);


var statearr_28336_28355 = state_28316__$1;
(statearr_28336_28355[(1)] = (4));

(statearr_28336_28355[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (10))){
var inst_28285 = (state_28316[(9)]);
var inst_28299 = (function(){throw inst_28285})();
var state_28316__$1 = state_28316;
var statearr_28337_28356 = state_28316__$1;
(statearr_28337_28356[(2)] = inst_28299);

(statearr_28337_28356[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28317 === (8))){
var state_28316__$1 = state_28316;
var statearr_28338_28357 = state_28316__$1;
(statearr_28338_28357[(2)] = null);

(statearr_28338_28357[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____0 = (function (){
var statearr_28339 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28339[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__);

(statearr_28339[(1)] = (1));

return statearr_28339;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____1 = (function (state_28316){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28340){var ex__10906__auto__ = e28340;
var statearr_28341_28358 = state_28316;
(statearr_28341_28358[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28316[(4)]))){
var statearr_28342_28359 = state_28316;
(statearr_28342_28359[(1)] = cljs.core.first.call(null,(state_28316[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28360 = state_28316;
state_28316 = G__28360;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__ = function(state_28316){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____1.call(this,state_28316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28343 = f__10977__auto__.call(null);
(statearr_28343[(6)] = c__10976__auto___28344);

return statearr_28343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k28362,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__28366 = k28362;
var G__28366__$1 = (((G__28366 instanceof cljs.core.Keyword))?G__28366.fqn:null);
switch (G__28366__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k28362,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__28367){
var vec__28368 = p__28367;
var k__4526__auto__ = cljs.core.nth.call(null,vec__28368,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__28368,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28361){
var self__ = this;
var G__28361__$1 = this;
return (new cljs.core.RecordIter((0),G__28361__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28363,other28364){
var self__ = this;
var this28363__$1 = this;
return (((!((other28364 == null)))) && ((((this28363__$1.constructor === other28364.constructor)) && (((cljs.core._EQ_.call(null,this28363__$1.conn,other28364.conn)) && (((cljs.core._EQ_.call(null,this28363__$1.config,other28364.config)) && (((cljs.core._EQ_.call(null,this28363__$1.network,other28364.network)) && (((cljs.core._EQ_.call(null,this28363__$1.dbid,other28364.dbid)) && (((cljs.core._EQ_.call(null,this28363__$1.id,other28364.id)) && (((cljs.core._EQ_.call(null,this28363__$1.leaf,other28364.leaf)) && (((cljs.core._EQ_.call(null,this28363__$1.first,other28364.first)) && (((cljs.core._EQ_.call(null,this28363__$1.rhs,other28364.rhs)) && (((cljs.core._EQ_.call(null,this28363__$1.size,other28364.size)) && (((cljs.core._EQ_.call(null,this28363__$1.block,other28364.block)) && (((cljs.core._EQ_.call(null,this28363__$1.t,other28364.t)) && (((cljs.core._EQ_.call(null,this28363__$1.tt_id,other28364.tt_id)) && (((cljs.core._EQ_.call(null,this28363__$1.leftmost_QMARK_,other28364.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this28363__$1.tempid,other28364.tempid)) && (cljs.core._EQ_.call(null,this28363__$1.__extmap,other28364.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k28362){
var self__ = this;
var this__4509__auto____$1 = this;
var G__28371 = k28362;
var G__28371__$1 = (((G__28371 instanceof cljs.core.Keyword))?G__28371.fqn:null);
switch (G__28371__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k28362);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__28361){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__28372 = cljs.core.keyword_identical_QMARK_;
var expr__28373 = k__4511__auto__;
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(G__28361,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__28361,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__28361,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__28361,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__28361,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__28361,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__28361,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__28361,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__28361,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__28361,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__28361,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__28361,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__28361,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__28372.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__28373))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__28361,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__28361),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__28361){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__28361,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__28365){
var extmap__4542__auto__ = (function (){var G__28375 = cljs.core.dissoc.call(null,G__28365,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__28365)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__28375);
} else {
return G__28375;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__28365),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__28365),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__28378 = blank_db;
var map__28378__$1 = cljs.core.__destructure_map.call(null,map__28378);
var network = cljs.core.get.call(null,map__28378__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28378__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__28378__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__28379 = root_data;
var map__28379__$1 = cljs.core.__destructure_map.call(null,map__28379);
var block = cljs.core.get.call(null,map__28379__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__28379__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__28379__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__28379__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28401){
var state_val_28402 = (state_28401[(1)]);
if((state_val_28402 === (7))){
var state_28401__$1 = state_28401;
var statearr_28403_28423 = state_28401__$1;
(statearr_28403_28423[(2)] = null);

(statearr_28403_28423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (1))){
var state_28401__$1 = state_28401;
var statearr_28404_28424 = state_28401__$1;
(statearr_28404_28424[(2)] = null);

(statearr_28404_28424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (4))){
var inst_28380 = (state_28401[(2)]);
var state_28401__$1 = state_28401;
var statearr_28405_28425 = state_28401__$1;
(statearr_28405_28425[(2)] = inst_28380);

(statearr_28405_28425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (6))){
var inst_28387 = (state_28401[(7)]);
var inst_28389 = fluree.db.storage.core.serde.call(null,conn);
var state_28401__$1 = (function (){var statearr_28406 = state_28401;
(statearr_28406[(8)] = inst_28389);

return statearr_28406;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28401__$1,(9),inst_28387);
} else {
if((state_val_28402 === (3))){
var inst_28399 = (state_28401[(2)]);
var state_28401__$1 = state_28401;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28401__$1,inst_28399);
} else {
if((state_val_28402 === (2))){
var inst_28387 = (state_28401[(7)]);
var _ = (function (){var statearr_28408 = state_28401;
(statearr_28408[(4)] = cljs.core.cons.call(null,(5),(state_28401[(4)])));

return statearr_28408;
})();
var inst_28386 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_28387__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_28386);
var state_28401__$1 = (function (){var statearr_28409 = state_28401;
(statearr_28409[(7)] = inst_28387__$1);

return statearr_28409;
})();
if(cljs.core.truth_(inst_28387__$1)){
var statearr_28410_28426 = state_28401__$1;
(statearr_28410_28426[(1)] = (6));

} else {
var statearr_28411_28427 = state_28401__$1;
(statearr_28411_28427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (9))){
var inst_28389 = (state_28401[(8)]);
var inst_28391 = (state_28401[(2)]);
var inst_28392 = fluree.db.util.async.throw_err.call(null,inst_28391);
var inst_28393 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_28389,inst_28392);
var state_28401__$1 = state_28401;
var statearr_28412_28428 = state_28401__$1;
(statearr_28412_28428[(2)] = inst_28393);

(statearr_28412_28428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (5))){
var _ = (function (){var statearr_28413 = state_28401;
(statearr_28413[(4)] = cljs.core.rest.call(null,(state_28401[(4)])));

return statearr_28413;
})();
var state_28401__$1 = state_28401;
var ex28407 = (state_28401__$1[(2)]);
var statearr_28414_28429 = state_28401__$1;
(statearr_28414_28429[(5)] = ex28407);


if((ex28407 instanceof Error)){
var statearr_28415_28430 = state_28401__$1;
(statearr_28415_28430[(1)] = (4));

(statearr_28415_28430[(5)] = null);

} else {
throw ex28407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28402 === (8))){
var inst_28396 = (state_28401[(2)]);
var _ = (function (){var statearr_28416 = state_28401;
(statearr_28416[(4)] = cljs.core.rest.call(null,(state_28401[(4)])));

return statearr_28416;
})();
var state_28401__$1 = state_28401;
var statearr_28417_28431 = state_28401__$1;
(statearr_28417_28431[(2)] = inst_28396);

(statearr_28417_28431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____0 = (function (){
var statearr_28418 = [null,null,null,null,null,null,null,null,null];
(statearr_28418[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__);

(statearr_28418[(1)] = (1));

return statearr_28418;
});
var fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____1 = (function (state_28401){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28401);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28419){var ex__10906__auto__ = e28419;
var statearr_28420_28432 = state_28401;
(statearr_28420_28432[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28401[(4)]))){
var statearr_28421_28433 = state_28401;
(statearr_28421_28433[(1)] = cljs.core.first.call(null,(state_28401[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28434 = state_28401;
state_28401 = G__28434;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__ = function(state_28401){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____1.call(this,state_28401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28422 = f__10977__auto__.call(null);
(statearr_28422[(6)] = c__10976__auto__);

return statearr_28422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28456){
var state_val_28457 = (state_28456[(1)]);
if((state_val_28457 === (7))){
var inst_28445 = (state_28456[(7)]);
var inst_28447 = fluree.db.storage.core.serde.call(null,conn);
var inst_28448 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_28447,inst_28445);
var state_28456__$1 = state_28456;
var statearr_28458_28477 = state_28456__$1;
(statearr_28458_28477[(2)] = inst_28448);

(statearr_28458_28477[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (1))){
var state_28456__$1 = state_28456;
var statearr_28459_28478 = state_28456__$1;
(statearr_28459_28478[(2)] = null);

(statearr_28459_28478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (4))){
var inst_28435 = (state_28456[(2)]);
var state_28456__$1 = state_28456;
var statearr_28460_28479 = state_28456__$1;
(statearr_28460_28479[(2)] = inst_28435);

(statearr_28460_28479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (6))){
var inst_28445 = (state_28456[(7)]);
var inst_28444 = (state_28456[(2)]);
var inst_28445__$1 = fluree.db.util.async.throw_err.call(null,inst_28444);
var state_28456__$1 = (function (){var statearr_28461 = state_28456;
(statearr_28461[(7)] = inst_28445__$1);

return statearr_28461;
})();
if(cljs.core.truth_(inst_28445__$1)){
var statearr_28462_28480 = state_28456__$1;
(statearr_28462_28480[(1)] = (7));

} else {
var statearr_28463_28481 = state_28456__$1;
(statearr_28463_28481[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (3))){
var inst_28454 = (state_28456[(2)]);
var state_28456__$1 = state_28456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28456__$1,inst_28454);
} else {
if((state_val_28457 === (2))){
var _ = (function (){var statearr_28465 = state_28456;
(statearr_28465[(4)] = cljs.core.cons.call(null,(5),(state_28456[(4)])));

return statearr_28465;
})();
var inst_28441 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_28442 = fluree.db.storage.core.storage_read.call(null,conn,inst_28441);
var state_28456__$1 = state_28456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28456__$1,(6),inst_28442);
} else {
if((state_val_28457 === (9))){
var inst_28451 = (state_28456[(2)]);
var _ = (function (){var statearr_28466 = state_28456;
(statearr_28466[(4)] = cljs.core.rest.call(null,(state_28456[(4)])));

return statearr_28466;
})();
var state_28456__$1 = state_28456;
var statearr_28467_28482 = state_28456__$1;
(statearr_28467_28482[(2)] = inst_28451);

(statearr_28467_28482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (5))){
var _ = (function (){var statearr_28468 = state_28456;
(statearr_28468[(4)] = cljs.core.rest.call(null,(state_28456[(4)])));

return statearr_28468;
})();
var state_28456__$1 = state_28456;
var ex28464 = (state_28456__$1[(2)]);
var statearr_28469_28483 = state_28456__$1;
(statearr_28469_28483[(5)] = ex28464);


if((ex28464 instanceof Error)){
var statearr_28470_28484 = state_28456__$1;
(statearr_28470_28484[(1)] = (4));

(statearr_28470_28484[(5)] = null);

} else {
throw ex28464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28457 === (8))){
var state_28456__$1 = state_28456;
var statearr_28471_28485 = state_28456__$1;
(statearr_28471_28485[(2)] = null);

(statearr_28471_28485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____0 = (function (){
var statearr_28472 = [null,null,null,null,null,null,null,null];
(statearr_28472[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__);

(statearr_28472[(1)] = (1));

return statearr_28472;
});
var fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____1 = (function (state_28456){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28473){var ex__10906__auto__ = e28473;
var statearr_28474_28486 = state_28456;
(statearr_28474_28486[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28456[(4)]))){
var statearr_28475_28487 = state_28456;
(statearr_28475_28487[(1)] = cljs.core.first.call(null,(state_28456[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28488 = state_28456;
state_28456 = G__28488;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__ = function(state_28456){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____1.call(this,state_28456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__10903__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28476 = f__10977__auto__.call(null);
(statearr_28476[(6)] = c__10976__auto__);

return statearr_28476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28524){
var state_val_28525 = (state_28524[(1)]);
if((state_val_28525 === (7))){
var inst_28498 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_28499 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28500 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28501 = cljs.core.PersistentHashMap.fromArrays(inst_28499,inst_28500);
var inst_28502 = cljs.core.ex_info.call(null,inst_28498,inst_28501);
var inst_28503 = (function(){throw inst_28502})();
var state_28524__$1 = state_28524;
var statearr_28526_28548 = state_28524__$1;
(statearr_28526_28548[(2)] = inst_28503);

(statearr_28526_28548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (1))){
var state_28524__$1 = state_28524;
var statearr_28527_28549 = state_28524__$1;
(statearr_28527_28549[(2)] = null);

(statearr_28527_28549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (4))){
var inst_28489 = (state_28524[(2)]);
var state_28524__$1 = state_28524;
var statearr_28528_28550 = state_28524__$1;
(statearr_28528_28550[(2)] = inst_28489);

(statearr_28528_28550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (6))){
var state_28524__$1 = state_28524;
var statearr_28529_28551 = state_28524__$1;
(statearr_28529_28551[(2)] = null);

(statearr_28529_28551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (3))){
var inst_28522 = (state_28524[(2)]);
var state_28524__$1 = state_28524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28524__$1,inst_28522);
} else {
if((state_val_28525 === (2))){
var inst_28495 = (state_28524[(7)]);
var _ = (function (){var statearr_28530 = state_28524;
(statearr_28530[(4)] = cljs.core.cons.call(null,(5),(state_28524[(4)])));

return statearr_28530;
})();
var inst_28495__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_28524__$1 = (function (){var statearr_28531 = state_28524;
(statearr_28531[(7)] = inst_28495__$1);

return statearr_28531;
})();
if(cljs.core.truth_(inst_28495__$1)){
var statearr_28532_28552 = state_28524__$1;
(statearr_28532_28552[(1)] = (6));

} else {
var statearr_28533_28553 = state_28524__$1;
(statearr_28533_28553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (11))){
var inst_28514 = (state_28524[(8)]);
var inst_28517 = (state_28524[(2)]);
var inst_28518 = fluree.db.util.async.throw_err.call(null,inst_28517);
var inst_28519 = cljs.core.assoc.call(null,inst_28514,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28518);
var _ = (function (){var statearr_28535 = state_28524;
(statearr_28535[(4)] = cljs.core.rest.call(null,(state_28524[(4)])));

return statearr_28535;
})();
var state_28524__$1 = state_28524;
var statearr_28536_28554 = state_28524__$1;
(statearr_28536_28554[(2)] = inst_28519);

(statearr_28536_28554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (9))){
var inst_28509 = (state_28524[(9)]);
var inst_28507 = (state_28524[(2)]);
var inst_28508 = fluree.db.util.async.throw_err.call(null,inst_28507);
var inst_28509__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_28508);
var inst_28510 = fluree.db.query.schema.schema_map.call(null,inst_28509__$1);
var state_28524__$1 = (function (){var statearr_28537 = state_28524;
(statearr_28537[(9)] = inst_28509__$1);

return statearr_28537;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28524__$1,(10),inst_28510);
} else {
if((state_val_28525 === (5))){
var _ = (function (){var statearr_28538 = state_28524;
(statearr_28538[(4)] = cljs.core.rest.call(null,(state_28524[(4)])));

return statearr_28538;
})();
var state_28524__$1 = state_28524;
var ex28534 = (state_28524__$1[(2)]);
var statearr_28539_28555 = state_28524__$1;
(statearr_28539_28555[(5)] = ex28534);


if((ex28534 instanceof Error)){
var statearr_28540_28556 = state_28524__$1;
(statearr_28540_28556[(1)] = (4));

(statearr_28540_28556[(5)] = null);

} else {
throw ex28534;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (10))){
var inst_28514 = (state_28524[(8)]);
var inst_28509 = (state_28524[(9)]);
var inst_28512 = (state_28524[(2)]);
var inst_28513 = fluree.db.util.async.throw_err.call(null,inst_28512);
var inst_28514__$1 = cljs.core.assoc.call(null,inst_28509,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28513);
var inst_28515 = fluree.db.query.schema.setting_map.call(null,inst_28514__$1);
var state_28524__$1 = (function (){var statearr_28541 = state_28524;
(statearr_28541[(8)] = inst_28514__$1);

return statearr_28541;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28524__$1,(11),inst_28515);
} else {
if((state_val_28525 === (8))){
var inst_28495 = (state_28524[(7)]);
var inst_28505 = (state_28524[(2)]);
var state_28524__$1 = (function (){var statearr_28542 = state_28524;
(statearr_28542[(10)] = inst_28505);

return statearr_28542;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28524__$1,(9),inst_28495);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__10903__auto____0 = (function (){
var statearr_28543 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28543[(0)] = fluree$db$storage$core$reify_db_$_state_machine__10903__auto__);

(statearr_28543[(1)] = (1));

return statearr_28543;
});
var fluree$db$storage$core$reify_db_$_state_machine__10903__auto____1 = (function (state_28524){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28544){var ex__10906__auto__ = e28544;
var statearr_28545_28557 = state_28524;
(statearr_28545_28557[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28524[(4)]))){
var statearr_28546_28558 = state_28524;
(statearr_28546_28558[(1)] = cljs.core.first.call(null,(state_28524[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28559 = state_28524;
state_28524 = G__28559;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__10903__auto__ = function(state_28524){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__10903__auto____1.call(this,state_28524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__10903__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__10903__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28547 = f__10977__auto__.call(null);
(statearr_28547[(6)] = c__10976__auto__);

return statearr_28547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__28561 = arguments.length;
switch (G__28561) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28614){
var state_val_28615 = (state_28614[(1)]);
if((state_val_28615 === (7))){
var inst_28571 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_28572 = (new Error(inst_28571));
var inst_28573 = (function(){throw inst_28572})();
var state_28614__$1 = state_28614;
var statearr_28616_28656 = state_28614__$1;
(statearr_28616_28656[(2)] = inst_28573);

(statearr_28616_28656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (20))){
var inst_28605 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
var statearr_28617_28657 = state_28614__$1;
(statearr_28617_28657[(2)] = inst_28605);

(statearr_28617_28657[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (1))){
var state_28614__$1 = state_28614;
var statearr_28618_28658 = state_28614__$1;
(statearr_28618_28658[(2)] = null);

(statearr_28618_28658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (4))){
var inst_28562 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
var statearr_28619_28659 = state_28614__$1;
(statearr_28619_28659[(2)] = inst_28562);

(statearr_28619_28659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (15))){
var inst_28580 = (state_28614[(7)]);
var state_28614__$1 = state_28614;
var statearr_28620_28660 = state_28614__$1;
(statearr_28620_28660[(2)] = inst_28580);

(statearr_28620_28660[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (21))){
var inst_28579 = (state_28614[(8)]);
var inst_28584 = (state_28614[(9)]);
var inst_28580 = (state_28614[(7)]);
var inst_28598 = (inst_28579 + (1));
var inst_28599 = cljs.core.conj.call(null,inst_28580,inst_28584);
var inst_28579__$1 = inst_28598;
var inst_28580__$1 = inst_28599;
var state_28614__$1 = (function (){var statearr_28621 = state_28614;
(statearr_28621[(8)] = inst_28579__$1);

(statearr_28621[(7)] = inst_28580__$1);

return statearr_28621;
})();
var statearr_28622_28661 = state_28614__$1;
(statearr_28622_28661[(2)] = null);

(statearr_28622_28661[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (13))){
var inst_28584 = (state_28614[(9)]);
var inst_28588 = (inst_28584 instanceof Error);
var state_28614__$1 = state_28614;
var statearr_28623_28662 = state_28614__$1;
(statearr_28623_28662[(2)] = inst_28588);

(statearr_28623_28662[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (22))){
var state_28614__$1 = state_28614;
var statearr_28624_28663 = state_28614__$1;
(statearr_28624_28663[(2)] = null);

(statearr_28624_28663[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (6))){
var state_28614__$1 = state_28614;
var statearr_28625_28664 = state_28614__$1;
(statearr_28625_28664[(2)] = null);

(statearr_28625_28664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (17))){
var inst_28607 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
var statearr_28626_28665 = state_28614__$1;
(statearr_28626_28665[(2)] = inst_28607);

(statearr_28626_28665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (3))){
var inst_28612 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28614__$1,inst_28612);
} else {
if((state_val_28615 === (12))){
var inst_28585 = (state_28614[(10)]);
var state_28614__$1 = state_28614;
var statearr_28627_28666 = state_28614__$1;
(statearr_28627_28666[(2)] = inst_28585);

(statearr_28627_28666[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (2))){
var _ = (function (){var statearr_28628 = state_28614;
(statearr_28628[(4)] = cljs.core.cons.call(null,(5),(state_28614[(4)])));

return statearr_28628;
})();
var inst_28568 = (end >= start);
var state_28614__$1 = state_28614;
if(cljs.core.truth_(inst_28568)){
var statearr_28629_28667 = state_28614__$1;
(statearr_28629_28667[(1)] = (6));

} else {
var statearr_28630_28668 = state_28614__$1;
(statearr_28630_28668[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (23))){
var inst_28603 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
var statearr_28631_28669 = state_28614__$1;
(statearr_28631_28669[(2)] = inst_28603);

(statearr_28631_28669[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (19))){
var state_28614__$1 = state_28614;
var statearr_28632_28670 = state_28614__$1;
(statearr_28632_28670[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (11))){
var inst_28585 = (state_28614[(10)]);
var inst_28584 = (state_28614[(9)]);
var inst_28584__$1 = (state_28614[(2)]);
var inst_28585__$1 = (inst_28584__$1 == null);
var state_28614__$1 = (function (){var statearr_28635 = state_28614;
(statearr_28635[(10)] = inst_28585__$1);

(statearr_28635[(9)] = inst_28584__$1);

return statearr_28635;
})();
if(cljs.core.truth_(inst_28585__$1)){
var statearr_28636_28671 = state_28614__$1;
(statearr_28636_28671[(1)] = (12));

} else {
var statearr_28637_28672 = state_28614__$1;
(statearr_28637_28672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (9))){
var inst_28579 = (state_28614[(8)]);
var inst_28582 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_28579);
var state_28614__$1 = state_28614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28614__$1,(11),inst_28582);
} else {
if((state_val_28615 === (5))){
var _ = (function (){var statearr_28638 = state_28614;
(statearr_28638[(4)] = cljs.core.rest.call(null,(state_28614[(4)])));

return statearr_28638;
})();
var state_28614__$1 = state_28614;
var ex28634 = (state_28614__$1[(2)]);
var statearr_28639_28673 = state_28614__$1;
(statearr_28639_28673[(5)] = ex28634);


if((ex28634 instanceof Error)){
var statearr_28640_28674 = state_28614__$1;
(statearr_28640_28674[(1)] = (4));

(statearr_28640_28674[(5)] = null);

} else {
throw ex28634;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (14))){
var inst_28590 = (state_28614[(2)]);
var state_28614__$1 = state_28614;
if(cljs.core.truth_(inst_28590)){
var statearr_28641_28675 = state_28614__$1;
(statearr_28641_28675[(1)] = (15));

} else {
var statearr_28642_28676 = state_28614__$1;
(statearr_28642_28676[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (16))){
var inst_28579 = (state_28614[(8)]);
var inst_28593 = cljs.core._EQ_.call(null,inst_28579,end);
var state_28614__$1 = state_28614;
if(inst_28593){
var statearr_28643_28677 = state_28614__$1;
(statearr_28643_28677[(1)] = (18));

} else {
var statearr_28644_28678 = state_28614__$1;
(statearr_28644_28678[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (10))){
var inst_28609 = (state_28614[(2)]);
var _ = (function (){var statearr_28645 = state_28614;
(statearr_28645[(4)] = cljs.core.rest.call(null,(state_28614[(4)])));

return statearr_28645;
})();
var state_28614__$1 = state_28614;
var statearr_28646_28679 = state_28614__$1;
(statearr_28646_28679[(2)] = inst_28609);

(statearr_28646_28679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (18))){
var inst_28584 = (state_28614[(9)]);
var inst_28580 = (state_28614[(7)]);
var inst_28595 = cljs.core.conj.call(null,inst_28580,inst_28584);
var state_28614__$1 = state_28614;
var statearr_28647_28680 = state_28614__$1;
(statearr_28647_28680[(2)] = inst_28595);

(statearr_28647_28680[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28615 === (8))){
var inst_28575 = (state_28614[(2)]);
var inst_28576 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28577 = start;
var inst_28578 = cljs.core.PersistentVector.EMPTY;
var inst_28579 = inst_28577;
var inst_28580 = inst_28578;
var state_28614__$1 = (function (){var statearr_28648 = state_28614;
(statearr_28648[(11)] = inst_28576);

(statearr_28648[(8)] = inst_28579);

(statearr_28648[(12)] = inst_28575);

(statearr_28648[(7)] = inst_28580);

return statearr_28648;
})();
var statearr_28649_28681 = state_28614__$1;
(statearr_28649_28681[(2)] = null);

(statearr_28649_28681[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10903__auto__ = null;
var fluree$db$storage$core$state_machine__10903__auto____0 = (function (){
var statearr_28650 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28650[(0)] = fluree$db$storage$core$state_machine__10903__auto__);

(statearr_28650[(1)] = (1));

return statearr_28650;
});
var fluree$db$storage$core$state_machine__10903__auto____1 = (function (state_28614){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28651){var ex__10906__auto__ = e28651;
var statearr_28652_28682 = state_28614;
(statearr_28652_28682[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28614[(4)]))){
var statearr_28653_28683 = state_28614;
(statearr_28653_28683[(1)] = cljs.core.first.call(null,(state_28614[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28684 = state_28614;
state_28614 = G__28684;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10903__auto__ = function(state_28614){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10903__auto____1.call(this,state_28614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10903__auto____0;
fluree$db$storage$core$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10903__auto____1;
return fluree$db$storage$core$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28654 = f__10977__auto__.call(null);
(statearr_28654[(6)] = c__10976__auto__);

return statearr_28654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28700){
var state_val_28701 = (state_28700[(1)]);
if((state_val_28701 === (1))){
var state_28700__$1 = state_28700;
var statearr_28702_28716 = state_28700__$1;
(statearr_28702_28716[(2)] = null);

(statearr_28702_28716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (2))){
var _ = (function (){var statearr_28703 = state_28700;
(statearr_28703[(4)] = cljs.core.cons.call(null,(5),(state_28700[(4)])));

return statearr_28703;
})();
var inst_28691 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_28700__$1 = state_28700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28700__$1,(6),inst_28691);
} else {
if((state_val_28701 === (3))){
var inst_28698 = (state_28700[(2)]);
var state_28700__$1 = state_28700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28700__$1,inst_28698);
} else {
if((state_val_28701 === (4))){
var inst_28685 = (state_28700[(2)]);
var state_28700__$1 = state_28700;
var statearr_28705_28717 = state_28700__$1;
(statearr_28705_28717[(2)] = inst_28685);

(statearr_28705_28717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (5))){
var _ = (function (){var statearr_28706 = state_28700;
(statearr_28706[(4)] = cljs.core.rest.call(null,(state_28700[(4)])));

return statearr_28706;
})();
var state_28700__$1 = state_28700;
var ex28704 = (state_28700__$1[(2)]);
var statearr_28707_28718 = state_28700__$1;
(statearr_28707_28718[(5)] = ex28704);


if((ex28704 instanceof Error)){
var statearr_28708_28719 = state_28700__$1;
(statearr_28708_28719[(1)] = (4));

(statearr_28708_28719[(5)] = null);

} else {
throw ex28704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (6))){
var inst_28693 = (state_28700[(2)]);
var inst_28694 = fluree.db.util.async.throw_err.call(null,inst_28693);
var inst_28695 = cljs.core.first.call(null,inst_28694);
var _ = (function (){var statearr_28709 = state_28700;
(statearr_28709[(4)] = cljs.core.rest.call(null,(state_28700[(4)])));

return statearr_28709;
})();
var state_28700__$1 = state_28700;
var statearr_28710_28720 = state_28700__$1;
(statearr_28710_28720[(2)] = inst_28695);

(statearr_28710_28720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__10903__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__10903__auto____0 = (function (){
var statearr_28711 = [null,null,null,null,null,null,null];
(statearr_28711[(0)] = fluree$db$storage$core$block_$_state_machine__10903__auto__);

(statearr_28711[(1)] = (1));

return statearr_28711;
});
var fluree$db$storage$core$block_$_state_machine__10903__auto____1 = (function (state_28700){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28712){var ex__10906__auto__ = e28712;
var statearr_28713_28721 = state_28700;
(statearr_28713_28721[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28700[(4)]))){
var statearr_28714_28722 = state_28700;
(statearr_28714_28722[(1)] = cljs.core.first.call(null,(state_28700[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28723 = state_28700;
state_28700 = G__28723;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__10903__auto__ = function(state_28700){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__10903__auto____1.call(this,state_28700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__10903__auto____0;
fluree$db$storage$core$block_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__10903__auto____1;
return fluree$db$storage$core$block_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28715 = f__10977__auto__.call(null);
(statearr_28715[(6)] = c__10976__auto__);

return statearr_28715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
