// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_22982){
var state_val_22983 = (state_22982[(1)]);
if((state_val_22983 === (7))){
var inst_22977 = (state_22982[(2)]);
var _ = (function (){var statearr_22984 = state_22982;
(statearr_22984[(4)] = cljs.core.rest.call(null,(state_22982[(4)])));

return statearr_22984;
})();
var state_22982__$1 = state_22982;
var statearr_22985_23007 = state_22982__$1;
(statearr_22985_23007[(2)] = inst_22977);

(statearr_22985_23007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (1))){
var state_22982__$1 = state_22982;
var statearr_22986_23008 = state_22982__$1;
(statearr_22986_23008[(2)] = null);

(statearr_22986_23008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (4))){
var inst_22939 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
var statearr_22987_23009 = state_22982__$1;
(statearr_22987_23009[(2)] = inst_22939);

(statearr_22987_23009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (6))){
var inst_22957 = (state_22982[(7)]);
var inst_22964 = (state_22982[(8)]);
var inst_22963 = cljs.core.seq.call(null,inst_22957);
var inst_22964__$1 = cljs.core.first.call(null,inst_22963);
var inst_22965 = cljs.core.next.call(null,inst_22963);
var inst_22966 = cljs.core.not.call(null,inst_22964__$1);
var state_22982__$1 = (function (){var statearr_22988 = state_22982;
(statearr_22988[(9)] = inst_22965);

(statearr_22988[(8)] = inst_22964__$1);

return statearr_22988;
})();
if(inst_22966){
var statearr_22989_23010 = state_22982__$1;
(statearr_22989_23010[(1)] = (8));

} else {
var statearr_22990_23011 = state_22982__$1;
(statearr_22990_23011[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (3))){
var inst_22980 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22982__$1,inst_22980);
} else {
if((state_val_22983 === (2))){
var _ = (function (){var statearr_22991 = state_22982;
(statearr_22991[(4)] = cljs.core.cons.call(null,(5),(state_22982[(4)])));

return statearr_22991;
})();
var inst_22952 = chs;
var inst_22953 = cljs.core.seq.call(null,inst_22952);
var inst_22954 = cljs.core.first.call(null,inst_22953);
var inst_22955 = cljs.core.next.call(null,inst_22953);
var inst_22956 = coll;
var inst_22957 = inst_22952;
var inst_22958 = inst_22956;
var state_22982__$1 = (function (){var statearr_22992 = state_22982;
(statearr_22992[(10)] = inst_22954);

(statearr_22992[(11)] = inst_22955);

(statearr_22992[(7)] = inst_22957);

(statearr_22992[(12)] = inst_22958);

return statearr_22992;
})();
var statearr_22993_23012 = state_22982__$1;
(statearr_22993_23012[(2)] = null);

(statearr_22993_23012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (11))){
var inst_22965 = (state_22982[(9)]);
var inst_22958 = (state_22982[(12)]);
var inst_22970 = (state_22982[(2)]);
var inst_22971 = fluree.db.util.async.throw_err.call(null,inst_22970);
var inst_22972 = cljs.core.conj.call(null,inst_22958,inst_22971);
var inst_22957 = inst_22965;
var inst_22958__$1 = inst_22972;
var state_22982__$1 = (function (){var statearr_22995 = state_22982;
(statearr_22995[(7)] = inst_22957);

(statearr_22995[(12)] = inst_22958__$1);

return statearr_22995;
})();
var statearr_22996_23013 = state_22982__$1;
(statearr_22996_23013[(2)] = null);

(statearr_22996_23013[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (9))){
var inst_22964 = (state_22982[(8)]);
var state_22982__$1 = state_22982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22982__$1,(11),inst_22964);
} else {
if((state_val_22983 === (5))){
var _ = (function (){var statearr_22997 = state_22982;
(statearr_22997[(4)] = cljs.core.rest.call(null,(state_22982[(4)])));

return statearr_22997;
})();
var state_22982__$1 = state_22982;
var ex22994 = (state_22982__$1[(2)]);
var statearr_22998_23014 = state_22982__$1;
(statearr_22998_23014[(5)] = ex22994);


var statearr_22999_23015 = state_22982__$1;
(statearr_22999_23015[(1)] = (4));

(statearr_22999_23015[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (10))){
var inst_22975 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
var statearr_23000_23016 = state_22982__$1;
(statearr_23000_23016[(2)] = inst_22975);

(statearr_23000_23016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22983 === (8))){
var inst_22958 = (state_22982[(12)]);
var state_22982__$1 = state_22982;
var statearr_23001_23017 = state_22982__$1;
(statearr_23001_23017[(2)] = inst_22958);

(statearr_23001_23017[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_23002 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23002[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__);

(statearr_23002[(1)] = (1));

return statearr_23002;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____1 = (function (state_22982){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_22982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e23003){var ex__10906__auto__ = e23003;
var statearr_23004_23018 = state_22982;
(statearr_23004_23018[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_22982[(4)]))){
var statearr_23005_23019 = state_22982;
(statearr_23005_23019[(1)] = cljs.core.first.call(null,(state_22982[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23020 = state_22982;
state_22982 = G__23020;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__ = function(state_22982){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____1.call(this,state_22982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_23006 = f__10977__auto__.call(null);
(statearr_23006[(6)] = c__10976__auto__);

return statearr_23006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_23046){
var state_val_23047 = (state_23046[(1)]);
if((state_val_23047 === (7))){
var inst_23041 = (state_23046[(2)]);
var _ = (function (){var statearr_23048 = state_23046;
(statearr_23048[(4)] = cljs.core.rest.call(null,(state_23046[(4)])));

return statearr_23048;
})();
var state_23046__$1 = state_23046;
var statearr_23049_23071 = state_23046__$1;
(statearr_23049_23071[(2)] = inst_23041);

(statearr_23049_23071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (1))){
var state_23046__$1 = state_23046;
var statearr_23050_23072 = state_23046__$1;
(statearr_23050_23072[(2)] = null);

(statearr_23050_23072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (4))){
var inst_23021 = (state_23046[(2)]);
var state_23046__$1 = state_23046;
var statearr_23051_23073 = state_23046__$1;
(statearr_23051_23073[(2)] = inst_23021);

(statearr_23051_23073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (6))){
var state_23046__$1 = state_23046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23046__$1,(8),chan);
} else {
if((state_val_23047 === (3))){
var inst_23044 = (state_23046[(2)]);
var state_23046__$1 = state_23046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23046__$1,inst_23044);
} else {
if((state_val_23047 === (2))){
var _ = (function (){var statearr_23052 = state_23046;
(statearr_23052[(4)] = cljs.core.cons.call(null,(5),(state_23046[(4)])));

return statearr_23052;
})();
var inst_23027 = coll;
var inst_23028 = inst_23027;
var state_23046__$1 = (function (){var statearr_23053 = state_23046;
(statearr_23053[(7)] = inst_23028);

return statearr_23053;
})();
var statearr_23054_23074 = state_23046__$1;
(statearr_23054_23074[(2)] = null);

(statearr_23054_23074[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (11))){
var inst_23039 = (state_23046[(2)]);
var state_23046__$1 = state_23046;
var statearr_23056_23075 = state_23046__$1;
(statearr_23056_23075[(2)] = inst_23039);

(statearr_23056_23075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (9))){
var inst_23028 = (state_23046[(7)]);
var state_23046__$1 = state_23046;
var statearr_23057_23076 = state_23046__$1;
(statearr_23057_23076[(2)] = inst_23028);

(statearr_23057_23076[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (5))){
var _ = (function (){var statearr_23058 = state_23046;
(statearr_23058[(4)] = cljs.core.rest.call(null,(state_23046[(4)])));

return statearr_23058;
})();
var state_23046__$1 = state_23046;
var ex23055 = (state_23046__$1[(2)]);
var statearr_23059_23077 = state_23046__$1;
(statearr_23059_23077[(5)] = ex23055);


var statearr_23060_23078 = state_23046__$1;
(statearr_23060_23078[(1)] = (4));

(statearr_23060_23078[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (10))){
var inst_23032 = (state_23046[(8)]);
var inst_23028 = (state_23046[(7)]);
var inst_23036 = cljs.core.conj.call(null,inst_23028,inst_23032);
var inst_23028__$1 = inst_23036;
var state_23046__$1 = (function (){var statearr_23061 = state_23046;
(statearr_23061[(7)] = inst_23028__$1);

return statearr_23061;
})();
var statearr_23062_23079 = state_23046__$1;
(statearr_23062_23079[(2)] = null);

(statearr_23062_23079[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23047 === (8))){
var inst_23032 = (state_23046[(8)]);
var inst_23031 = (state_23046[(2)]);
var inst_23032__$1 = fluree.db.util.async.throw_err.call(null,inst_23031);
var inst_23033 = (inst_23032__$1 == null);
var state_23046__$1 = (function (){var statearr_23063 = state_23046;
(statearr_23063[(8)] = inst_23032__$1);

return statearr_23063;
})();
if(cljs.core.truth_(inst_23033)){
var statearr_23064_23080 = state_23046__$1;
(statearr_23064_23080[(1)] = (9));

} else {
var statearr_23065_23081 = state_23046__$1;
(statearr_23065_23081[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_23066 = [null,null,null,null,null,null,null,null,null];
(statearr_23066[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__);

(statearr_23066[(1)] = (1));

return statearr_23066;
});
var fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____1 = (function (state_23046){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_23046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e23067){var ex__10906__auto__ = e23067;
var statearr_23068_23082 = state_23046;
(statearr_23068_23082[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_23046[(4)]))){
var statearr_23069_23083 = state_23046;
(statearr_23069_23083[(1)] = cljs.core.first.call(null,(state_23046[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23084 = state_23046;
state_23046 = G__23084;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__ = function(state_23046){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____1.call(this,state_23046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__10903__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_23070 = f__10977__auto__.call(null);
(statearr_23070[(6)] = c__10976__auto__);

return statearr_23070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
